/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dynmap.snakeyaml.DumperOptions;
import org.dynmap.snakeyaml.LoaderOptions;
import org.dynmap.snakeyaml.TypeDescription;
import org.dynmap.snakeyaml.Yaml;
import org.dynmap.snakeyaml.constructor.Constructor;
import org.dynmap.snakeyaml.introspector.BeanAccess;
import org.dynmap.snakeyaml.reader.UnicodeReader;
import org.dynmap.snakeyaml.representer.Representer;
import org.dynmap.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanLoader<T> {
    private Yaml loader;

    public JavaBeanLoader(TypeDescription typeDescription) {
        this(typeDescription, BeanAccess.DEFAULT);
    }

    public JavaBeanLoader(TypeDescription typeDescription, BeanAccess beanAccess) {
        this(new LoaderOptions(typeDescription), beanAccess);
    }

    public JavaBeanLoader(LoaderOptions options, BeanAccess beanAccess) {
        if (options == null) {
            throw new NullPointerException("LoaderOptions must be provided.");
        }
        if (options.getRootTypeDescription() == null) {
            throw new NullPointerException("TypeDescription must be provided.");
        }
        Constructor constructor = new Constructor(options.getRootTypeDescription());
        this.loader = new Yaml(constructor, options, new Representer(), new DumperOptions(), new Resolver());
        this.loader.setBeanAccess(beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz, BeanAccess beanAccess) {
        this(new TypeDescription(clazz), beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz) {
        this(clazz, BeanAccess.DEFAULT);
    }

    public T load(String yaml) {
        return (T)this.loader.load(new StringReader(yaml));
    }

    public T load(InputStream io) {
        return (T)this.loader.load(new UnicodeReader(io));
    }

    public T load(Reader io) {
        return (T)this.loader.load(io);
    }
}

