/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.Arrays;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.TransparencyMode;

public class CopyBlockTextureRecordImpl
implements CopyBlockTextureRecord {
    private int[] ids = new int[0];
    private String[] names = new String[0];
    private int metaMask = -1;
    private final int srcid;
    private final String srcname;
    private final int srcmeta;
    private TransparencyMode mode = null;

    private int isNumber(String v) {
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return -1;
        }
        return Integer.parseInt(v);
    }

    public CopyBlockTextureRecordImpl(int blkid, int srcid, int srcmeta) {
        this.addBlockID(blkid);
        this.srcid = srcid;
        this.srcname = null;
        this.srcmeta = srcmeta;
    }

    public CopyBlockTextureRecordImpl(String blkname, String srcname, int srcmeta) {
        this.addBlockName(blkname);
        int id = this.isNumber(srcname);
        if (id < 0) {
            this.srcname = srcname;
            this.srcid = 0;
        } else {
            this.srcname = null;
            this.srcid = id;
        }
        this.srcmeta = srcmeta;
    }

    @Override
    public void addBlockID(int blockID) {
        if (blockID > 0 && blockID < 4096) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    @Override
    public void addBlockName(String blockname) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(blockname)) continue;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = blockname;
    }

    @Override
    public int[] getBlockIDs() {
        return this.ids;
    }

    @Override
    public String[] getBlockNames() {
        return this.names;
    }

    @Override
    public void setMetaValue(int data) {
        if (data < 0) {
            this.metaMask = -1;
        } else if (data < 16) {
            if (this.metaMask == -1) {
                this.metaMask = 0;
            }
            this.metaMask |= 1 << data;
        }
    }

    @Override
    public int getMetaValueMask() {
        return this.metaMask;
    }

    public String getLine() {
        int i;
        if (this.ids.length == 0 && this.names.length == 0) {
            return null;
        }
        String s = "copyblock:";
        int idcnt = 0;
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
            ++idcnt;
        }
        for (i = 0; i < this.names.length; ++i) {
            if (idcnt > 0) {
                s = s + ",";
            }
            s = s + "id=%" + this.names[i];
            ++idcnt;
        }
        if (this.metaMask == -1) {
            s = s + ",data=*";
        } else {
            for (i = 0; i < 16; ++i) {
                if ((this.metaMask & 1 << i) == 0) continue;
                s = s + ",data=" + i;
            }
        }
        s = this.srcname != null ? s + ",srcid=%" + this.srcname + ",srcmeta=" + this.srcmeta : s + ",srcid=" + this.srcid + ",srcmeta=" + this.srcmeta;
        switch (this.mode) {
            case TRANSPARENT: {
                s = s + ",transparency=TRANSPARENT";
                break;
            }
            case SEMITRANSPARENT: {
                s = s + ",transparency=SEMITRANSPARENT";
                break;
            }
        }
        return s;
    }

    @Override
    public int getSourceBlockID() {
        return this.srcid;
    }

    @Override
    public int getSourceMeta() {
        return this.srcmeta;
    }

    @Override
    public void setTransparencyMode(TransparencyMode mode) {
        this.mode = mode;
    }

    @Override
    public TransparencyMode getTransparencyMode() {
        return this.mode;
    }
}

