/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class TFCSupportRenderer
extends CustomRenderer {
    private boolean isVert;
    private static BitSet vertid = new BitSet();
    private static BitSet horizid = new BitSet();
    private static final int SIDE_XP = 1;
    private static final int SIDE_XN = 2;
    private static final int SIDE_X = 3;
    private static final int SIDE_ZP = 4;
    private static final int SIDE_ZN = 8;
    private static final int SIDE_Z = 12;
    private static final int SIDE_YN = 16;
    private RenderPatch[][] meshes = new RenderPatch[32][];
    private static final int[] patchlist = new int[]{0, 0, 0, 0, 0, 0};
    private static int[][] sides = new int[][]{{1, 0, 0, 1}, {-1, 0, 0, 2}, {0, 0, 1, 4}, {0, 0, -1, 8}};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        String vert = custparm.get("vert");
        if (vert != null && vert.equals("true")) {
            this.isVert = true;
            vertid.set(blkid, true);
        } else {
            horizid.set(blkid, true);
        }
        this.buildMeshes(rpf);
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 1;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        TFCSupportRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private void buildMeshes(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 32; ++dat) {
            switch (dat & 3) {
                case 1: {
                    this.addBox(rpf, list, 0.75, 1.0, 0.5, 1.0, 0.25, 0.75);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.25, 0.5, 1.0, 0.25, 0.75);
                    break;
                }
                case 3: {
                    this.addBox(rpf, list, 0.0, 1.0, 0.5, 1.0, 0.25, 0.75);
                }
            }
            switch (dat & 0xC) {
                case 4: {
                    this.addBox(rpf, list, 0.25, 0.75, 0.5, 1.0, 0.75, 1.0);
                    break;
                }
                case 8: {
                    this.addBox(rpf, list, 0.25, 0.75, 0.5, 1.0, 0.0, 0.25);
                    break;
                }
                case 12: {
                    this.addBox(rpf, list, 0.25, 0.75, 0.5, 1.0, 0.0, 1.0);
                }
            }
            if (this.isVert || (dat & 0x10) != 0) {
                this.addBox(rpf, list, 0.25, 0.75, 0.0, 1.0, 0.25, 0.75);
            } else {
                this.addBox(rpf, list, 0.25, 0.75, 0.5, 1.0, 0.25, 0.75);
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int id;
        int connect = 0;
        for (int i = 0; i < sides.length; ++i) {
            int id2 = ctx.getBlockTypeIDAt(sides[i][0], sides[i][1], sides[i][2]);
            if (id2 == 0 || !vertid.get(id2) && !horizid.get(id2)) continue;
            connect |= sides[i][3];
        }
        if (!this.isVert && (id = ctx.getBlockTypeIDAt(0, -1, 0)) > 0 && vertid.get(id)) {
            connect |= 0x10;
        }
        return this.meshes[connect];
    }
}

