/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class CTMVertTextureRenderer
extends CustomRenderer {
    private static final int TEXTURE_BOTTOM = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_SIDE_NO_NEIGHBOR = 2;
    private static final int TEXTURE_SIDE_ABOVE = 3;
    private static final int TEXTURE_SIDE_BELOW = 4;
    private static final int TEXTURE_SIDE_BOTH = 5;
    private int blkid;
    private RenderPatch[] mesh_no_neighbor;
    private RenderPatch[] mesh_above_neighbor;
    private RenderPatch[] mesh_below_neighbor;
    private RenderPatch[] mesh_both_neighbor;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.blkid = blkid;
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        CTMVertTextureRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, new int[]{0, 1, 2, 2, 2, 2});
        this.mesh_no_neighbor = list.toArray(new RenderPatch[6]);
        list.clear();
        CTMVertTextureRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, new int[]{0, 1, 3, 3, 3, 3});
        this.mesh_above_neighbor = list.toArray(new RenderPatch[6]);
        list.clear();
        CTMVertTextureRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, new int[]{0, 1, 4, 4, 4, 4});
        this.mesh_below_neighbor = list.toArray(new RenderPatch[6]);
        list.clear();
        CTMVertTextureRenderer.addBox(rpf, list, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, new int[]{0, 1, 5, 5, 5, 5});
        this.mesh_both_neighbor = list.toArray(new RenderPatch[6]);
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 6;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext mapDataCtx) {
        int id_meta;
        int id_meta2;
        int meta = mapDataCtx.getBlockData();
        boolean above = false;
        int id_above = mapDataCtx.getBlockTypeIDAt(0, 1, 0);
        if (id_above == this.blkid && meta == (id_meta2 = mapDataCtx.getBlockDataAt(0, 1, 0))) {
            above = true;
        }
        boolean below = false;
        int id_below = mapDataCtx.getBlockTypeIDAt(0, -1, 0);
        if (id_below == this.blkid && meta == (id_meta = mapDataCtx.getBlockDataAt(0, -1, 0))) {
            below = true;
        }
        RenderPatch[] mesh = above ? (below ? this.mesh_both_neighbor : this.mesh_above_neighbor) : (below ? this.mesh_below_neighbor : this.mesh_no_neighbor);
        return mesh;
    }
}

