/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.io.IOException;
import org.dynmap.Color;
import org.dynmap.ColorScheme;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.JSONUtils;
import org.dynmap.MapManager;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDLighting;
import org.dynmap.hdmap.HDMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShader;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynLongHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;

public class DefaultHDShader
implements HDShader {
    private String name;
    protected ColorScheme colorScheme;
    protected boolean transparency;
    protected BiomeColorOption biomecolored = BiomeColorOption.NONE;
    private static final String[] nulllist = new String[0];

    public DefaultHDShader(DynmapCore core, ConfigurationNode configuration) {
        this.name = (String)configuration.get("name");
        this.colorScheme = ColorScheme.getScheme(core, configuration.getString("colorscheme", "default"));
        this.transparency = configuration.getBoolean("transparency", true);
        String biomeopt = configuration.getString("biomecolored", "none");
        this.biomecolored = biomeopt.equals("biome") ? BiomeColorOption.BIOME : (biomeopt.equals("temperature") ? BiomeColorOption.TEMPERATURE : (biomeopt.equals("rainfall") ? BiomeColorOption.RAINFALL : BiomeColorOption.NONE));
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return this.biomecolored == BiomeColorOption.BIOME;
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return this.biomecolored == BiomeColorOption.RAINFALL || this.biomecolored == BiomeColorOption.TEMPERATURE;
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return false;
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return true;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return false;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HDShaderState getStateInstance(HDMap map, MapChunkCache cache, MapIterator mapiter, int scale) {
        switch (this.biomecolored) {
            case NONE: {
                return new OurShaderState(mapiter, map, cache);
            }
            case BIOME: {
                return new OurBiomeShaderState(mapiter, map, cache);
            }
            case RAINFALL: {
                return new OurBiomeRainfallShaderState(mapiter, map, cache);
            }
            case TEMPERATURE: {
                return new OurBiomeTempShaderState(mapiter, map, cache);
            }
        }
        return null;
    }

    @Override
    public void addClientConfiguration(JSONObject mapObject) {
        JSONUtils.s(mapObject, "shader", this.name);
    }

    @Override
    public void exportAsMaterialLibrary(DynmapCommandSender sender, OBJExport out) throws IOException {
        throw new IOException("Export unsupported");
    }

    @Override
    public String[] getCurrentBlockMaterials(int blkid, int blkdata, int renderdata, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        return nulllist;
    }

    private class OurBiomeTempShaderState
    extends OurShaderState {
        private OurBiomeTempShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            super(mapiter, map, cache);
        }

        @Override
        protected Color[] getBlockColors(int blocktype, int blockdata) {
            return DefaultHDShader.this.colorScheme.getTempColor(this.mapiter.getBiome().getTemperature());
        }
    }

    private class OurBiomeRainfallShaderState
    extends OurShaderState {
        private OurBiomeRainfallShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            super(mapiter, map, cache);
        }

        @Override
        protected Color[] getBlockColors(int blocktype, int blockdata) {
            return DefaultHDShader.this.colorScheme.getRainColor(this.mapiter.getBiome().getRainfall());
        }
    }

    private class OurBiomeShaderState
    extends OurShaderState {
        private OurBiomeShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            super(mapiter, map, cache);
        }

        @Override
        protected Color[] getBlockColors(int blocktype, int blockdata) {
            BiomeMap bio = this.mapiter.getBiome();
            if (bio != null) {
                return DefaultHDShader.this.colorScheme.biomecolors[bio.ordinal()];
            }
            return null;
        }
    }

    private class OurShaderState
    implements HDShaderState {
        private Color[] color;
        protected MapIterator mapiter;
        protected HDMap map;
        private Color[] tmpcolor;
        private int pixelodd;
        private HDLighting lighting;
        final int[] lightingTable;

        private OurShaderState(MapIterator mapiter, HDMap map, MapChunkCache cache) {
            this.mapiter = mapiter;
            this.map = map;
            this.lighting = map.getLighting();
            if (this.lighting.isNightAndDayEnabled()) {
                this.color = new Color[]{new Color(), new Color()};
                this.tmpcolor = new Color[]{new Color(), new Color()};
            } else {
                this.color = new Color[]{new Color()};
                this.tmpcolor = new Color[]{new Color()};
            }
            this.lightingTable = (int[])(MapManager.mapman.useBrightnessTable() ? cache.getWorld().getBrightnessTable() : null);
        }

        @Override
        public HDShader getShader() {
            return DefaultHDShader.this;
        }

        @Override
        public HDMap getMap() {
            return this.map;
        }

        @Override
        public HDLighting getLighting() {
            return this.lighting;
        }

        @Override
        public void reset(HDPerspectiveState ps) {
            for (int i = 0; i < this.color.length; ++i) {
                this.color[i].setTransparent();
            }
            this.pixelodd = (ps.getPixelX() & 3) + (ps.getPixelY() << 1);
        }

        protected Color[] getBlockColors(int blocktype, int blockdata) {
            if (blockdata != 0 && DefaultHDShader.this.colorScheme.datacolors[blocktype] != null) {
                return DefaultHDShader.this.colorScheme.datacolors[blocktype][blockdata];
            }
            return DefaultHDShader.this.colorScheme.colors[blocktype];
        }

        @Override
        public boolean processBlock(HDPerspectiveState ps) {
            int blocktype = ps.getBlockTypeID();
            if (blocktype == 0) {
                return false;
            }
            Color[] colors = this.getBlockColors(blocktype, ps.getBlockData());
            if (colors != null) {
                int seq;
                int subalpha = ps.getSubmodelAlpha();
                switch (ps.getLastBlockStep()) {
                    case X_PLUS: 
                    case X_MINUS: {
                        seq = 2;
                        break;
                    }
                    case Z_PLUS: 
                    case Z_MINUS: {
                        seq = 0;
                        break;
                    }
                    default: {
                        seq = (this.pixelodd + this.mapiter.getY() & 3) == 0 ? 3 : 1;
                    }
                }
                Color c = colors[seq];
                if (c.getAlpha() > 0) {
                    this.lighting.applyLighting(ps, this, c, this.tmpcolor);
                    if (subalpha >= 0) {
                        for (int j = 0; j < this.tmpcolor.length; ++j) {
                            this.tmpcolor[j].setAlpha(Math.max(subalpha, this.tmpcolor[j].getAlpha()));
                        }
                    }
                    if (!DefaultHDShader.this.transparency) {
                        for (int i = 0; i < this.color.length; ++i) {
                            this.color[i].setARGB(this.tmpcolor[i].getARGB() | 0xFF000000);
                        }
                        return true;
                    }
                    if (this.color[0].isTransparent()) {
                        for (int i = 0; i < this.color.length; ++i) {
                            this.color[i].setColor(this.tmpcolor[i]);
                        }
                        return this.color[0].getAlpha() == 255;
                    }
                    int alpha = this.color[0].getAlpha();
                    int alpha2 = this.tmpcolor[0].getAlpha() * (255 - alpha) / 255;
                    int talpha = alpha + alpha2;
                    for (int i = 0; i < this.color.length; ++i) {
                        this.color[i].setRGBA((this.tmpcolor[i].getRed() * alpha2 + this.color[i].getRed() * alpha) / talpha, (this.tmpcolor[i].getGreen() * alpha2 + this.color[i].getGreen() * alpha) / talpha, (this.tmpcolor[i].getBlue() * alpha2 + this.color[i].getBlue() * alpha) / talpha, talpha);
                    }
                    return talpha >= 254;
                }
            }
            return false;
        }

        @Override
        public void rayFinished(HDPerspectiveState ps) {
        }

        @Override
        public void getRayColor(Color c, int index) {
            c.setColor(this.color[index]);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public DynLongHashMap getCTMTextureCache() {
            return null;
        }

        @Override
        public int[] getLightingTable() {
            return this.lightingTable;
        }
    }

    public static enum BiomeColorOption {
        NONE,
        BIOME,
        TEMPERATURE,
        RAINFALL;

    }
}

