/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.dynmap.AsynchronousQueue;
import org.dynmap.Client;
import org.dynmap.ColorScheme;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Handler;
import org.dynmap.Log;
import org.dynmap.MapTile;
import org.dynmap.MapType;
import org.dynmap.MapTypeState;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.debug.Debug;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.HDMapManager;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.TileFlags;

public class MapManager {
    public AsynchronousQueue<MapTile> tileQueue;
    private static final int DEFAULT_CHUNKS_PER_TICK = 200;
    private static final int DEFAULT_ZOOMOUT_PERIOD = 60;
    public List<DynmapWorld> worlds = new CopyOnWriteArrayList<DynmapWorld>();
    private List<String> disabled_worlds = new ArrayList<String>();
    public Map<String, DynmapWorld> worldsLookup = new HashMap<String, DynmapWorld>();
    private DynmapCore core;
    private long timeslice_int = 0L;
    private int max_chunk_loads_per_tick = 200;
    private int parallelrendercnt = 0;
    private int progressinterval = 100;
    private int tileupdatedelay = 30;
    private int savependingperiod = 900;
    private boolean saverestorepending = true;
    private boolean pauseupdaterenders = false;
    private boolean hideores = false;
    private boolean useBrightnessTable = false;
    private boolean usenormalpriority = false;
    private short[] blockidalias;
    private boolean pausefullrenders = false;
    private double tpslimit_updaterenders = 18.0;
    private double tpslimit_fullrenders = 18.0;
    private double tpslimit_zoomout = 18.0;
    private boolean tpspauseupdaterenders = false;
    private boolean tpspausefullrenders = false;
    private boolean tpspausezoomout = false;
    private boolean did_start = false;
    private int zoomout_period = 60;
    private HashMap<String, FullWorldRenderState> active_renders = new HashMap();
    AtomicInteger chunk_caches_created = new AtomicInteger(0);
    AtomicInteger[] chunks_read;
    AtomicLong[] chunks_read_times;
    public static final Object lock = new Object();
    public static MapManager mapman;
    public HDMapManager hdmapman;
    private DynmapScheduledThreadPoolExecutor render_pool;
    private static final int POOL_SIZE = 3;
    private ConcurrentHashMap<TouchEvent, Object> touch_events = new ConcurrentHashMap();
    private LinkedList<TouchVolumeEvent> touch_volume_events = new LinkedList();
    private Object touch_lock = new Object();
    private HashMap<String, MapStats> mapstats = new HashMap();
    private HashMap<String, TriggerStats> trigstats = new HashMap();
    private static final String RENDERTYPE_FULLRENDER = "Full render";
    private static final String RENDERTYPE_RADIUSRENDER = "Radius render";
    private static final String RENDERTYPE_UPDATERENDER = "Update render";

    public DynmapWorld getWorld(String name) {
        DynmapWorld world = this.worldsLookup.get(name);
        if (world == null) {
            world = this.worldsLookup.get(DynmapWorld.normalizeWorldName(name));
        }
        return world;
    }

    public Collection<DynmapWorld> getWorlds() {
        return this.worlds;
    }

    public Collection<String> getDisabledWorlds() {
        return this.disabled_worlds;
    }

    public int getDefTileUpdateDelay() {
        return this.tileupdatedelay;
    }

    private void addNextTilesToUpdate(int cnt) {
        ArrayList<MapTile> tiles = new ArrayList<MapTile>();
        TileFlags.TileCoord coord = new TileFlags.TileCoord();
        while (cnt > 0) {
            tiles.clear();
            for (DynmapWorld w : this.worlds) {
                for (MapTypeState mts : w.mapstate) {
                    if (!mts.getNextInvalidTileCoord(coord)) continue;
                    mts.type.addMapTiles(tiles, w, coord.x, coord.y);
                    mts.validateTile(coord.x, coord.y);
                }
            }
            if (tiles.size() == 0) {
                return;
            }
            for (MapTile mt : tiles) {
                this.tileQueue.push(mt);
                --cnt;
            }
        }
    }

    public MapManager(DynmapCore core, ConfigurationNode configuration) {
        ConfigurationNode blockalias;
        int i;
        this.core = core;
        mapman = this;
        this.chunks_read = new AtomicInteger[MapChunkCache.ChunkStats.values().length];
        this.chunks_read_times = new AtomicLong[MapChunkCache.ChunkStats.values().length];
        for (i = 0; i < MapChunkCache.ChunkStats.values().length; ++i) {
            this.chunks_read[i] = new AtomicInteger(0);
            this.chunks_read_times[i] = new AtomicLong(0L);
        }
        this.hideores = configuration.getBoolean("hideores", false);
        this.useBrightnessTable = configuration.getBoolean("use-brightness-table", false);
        this.blockidalias = new short[4096];
        for (i = 0; i < this.blockidalias.length; ++i) {
            this.blockidalias[i] = (short)i;
        }
        if (this.hideores) {
            this.setBlockIDAlias(14, 1);
            this.setBlockIDAlias(15, 1);
            this.setBlockIDAlias(16, 1);
            this.setBlockIDAlias(21, 1);
            this.setBlockIDAlias(56, 1);
            this.setBlockIDAlias(73, 1);
            this.setBlockIDAlias(74, 1);
            this.setBlockIDAlias(129, 1);
            this.setBlockIDAlias(153, 87);
        }
        if ((blockalias = configuration.getNode("block-id-alias")) != null) {
            for (String id : blockalias.keySet()) {
                int newid;
                int srcid = Integer.parseInt(id.trim());
                if (srcid == (newid = blockalias.getInteger(id, srcid))) continue;
                this.setBlockIDAlias(srcid, newid);
            }
        }
        this.usenormalpriority = configuration.getBoolean("usenormalthreadpriority", false);
        ColorScheme.reset();
        this.hdmapman = new HDMapManager();
        this.hdmapman.loadHDShaders(core);
        this.hdmapman.loadHDPerspectives(core);
        this.hdmapman.loadHDLightings(core);
        this.parallelrendercnt = configuration.getInteger("parallelrendercnt", 0);
        this.progressinterval = configuration.getInteger("progressloginterval", 100);
        if (this.progressinterval < 100) {
            this.progressinterval = 100;
        }
        this.saverestorepending = configuration.getBoolean("saverestorepending", true);
        this.tileupdatedelay = configuration.getInteger("tileupdatedelay", 30);
        this.tpslimit_updaterenders = configuration.getDouble("update-min-tps", 18.0);
        if (this.tpslimit_updaterenders > 19.5) {
            this.tpslimit_updaterenders = 19.5;
        }
        this.tpslimit_fullrenders = configuration.getDouble("fullrender-min-tps", 18.0);
        if (this.tpslimit_fullrenders > 19.5) {
            this.tpslimit_fullrenders = 19.5;
        }
        this.tpslimit_zoomout = configuration.getDouble("zoomout-min-tps", 18.0);
        if (this.tpslimit_zoomout > 19.5) {
            this.tpslimit_zoomout = 19.5;
        }
        this.savependingperiod = configuration.getInteger("save-pending-period", 900);
        if (this.savependingperiod > 0 && this.savependingperiod < 60) {
            this.savependingperiod = 60;
        }
        this.tileQueue = new AsynchronousQueue<MapTile>(new Handler<MapTile>(){

            @Override
            public void handle(MapTile t) {
                FullWorldRenderState job = new FullWorldRenderState(t);
                if (!MapManager.scheduleDelayedJob(job, 0L)) {
                    job.cleanup();
                }
            }
        }, (int)(configuration.getDouble("renderinterval", 0.5) * 1000.0), configuration.getInteger("renderacceleratethreshold", 30), (int)(configuration.getDouble("renderaccelerateinterval", 0.2) * 1000.0), configuration.getInteger("tiles-rendered-at-once", (Runtime.getRuntime().availableProcessors() + 1) / 2), this.usenormalpriority);
        this.timeslice_int = (long)(configuration.getDouble("timesliceinterval", 0.0) * 1000.0);
        this.max_chunk_loads_per_tick = configuration.getInteger("maxchunkspertick", 200);
        if (this.max_chunk_loads_per_tick < 5) {
            this.max_chunk_loads_per_tick = 5;
        }
        this.zoomout_period = configuration.getInteger("zoomoutperiod", 60);
        if (this.zoomout_period < 5) {
            this.zoomout_period = 5;
        }
        this.tileQueue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderFullWorld(DynmapLocation l, DynmapCommandSender sender, String mapname, boolean update) {
        FullWorldRenderState rndr;
        DynmapWorld world = this.getWorld(l.world);
        if (world == null) {
            sender.sendMessage("Could not render: world '" + l.world + "' not defined in configuration.");
            return;
        }
        String wname = l.world;
        Object object = lock;
        synchronized (object) {
            rndr = this.active_renders.get(wname);
            if (rndr != null) {
                sender.sendMessage(rndr.rendertype + " of world '" + wname + "' already active.");
                return;
            }
            rndr = new FullWorldRenderState(world, l, sender, mapname, update);
            this.active_renders.put(wname, rndr);
        }
        MapManager.scheduleDelayedJob(rndr, 0L);
        if (update) {
            sender.sendMessage("Update render starting on world '" + wname + "'...");
        } else {
            sender.sendMessage("Full render starting on world '" + wname + "'...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderWorldRadius(DynmapLocation l, DynmapCommandSender sender, String mapname, int radius) {
        FullWorldRenderState rndr;
        DynmapWorld world = this.getWorld(l.world);
        if (world == null) {
            sender.sendMessage("Could not render: world '" + l.world + "' not defined in configuration.");
            return;
        }
        String wname = l.world;
        Object object = lock;
        synchronized (object) {
            rndr = this.active_renders.get(wname);
            if (rndr != null) {
                sender.sendMessage(rndr.rendertype + " of world '" + wname + "' already active.");
                return;
            }
            rndr = new FullWorldRenderState(world, l, sender, mapname, radius);
            this.active_renders.put(wname, rndr);
        }
        MapManager.scheduleDelayedJob(rndr, 0L);
        sender.sendMessage("Render of " + radius + " block radius starting on world '" + wname + "'...");
    }

    public void startOBJExport(OBJExport exp, DynmapCommandSender sender) {
        ProcessOBJExport e = new ProcessOBJExport();
        e.exp = exp;
        e.sender = sender;
        MapManager.scheduleDelayedJob(e, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRender(String w, DynmapCommandSender sender) {
        block5: {
            Object object = lock;
            synchronized (object) {
                String[] wids;
                block4: {
                    if (w == null) break block4;
                    FullWorldRenderState rndr = this.active_renders.remove(w);
                    if (rndr == null) break block5;
                    rndr.cancelRender();
                    if (sender == null) break block5;
                    sender.sendMessage("Cancelled render for '" + w + "'");
                    break block5;
                }
                for (String wid : wids = this.active_renders.keySet().toArray(new String[0])) {
                    FullWorldRenderState rnd = this.active_renders.remove(wid);
                    rnd.cancelRender();
                    if (sender == null) continue;
                    sender.sendMessage("Cancelled render for '" + wid + "'");
                }
            }
        }
    }

    void purgeQueue(DynmapCommandSender sender, String worldname) {
        DynmapWorld world = null;
        if (worldname != null && (world = this.getWorld(worldname)) == null) {
            sender.sendMessage("World '" + worldname + "' not found.");
            return;
        }
        if (this.tileQueue != null) {
            int cnt = 0;
            List<MapTile> popped = this.tileQueue.popAll();
            if (popped != null) {
                cnt = popped.size();
                if (worldname != null) {
                    for (MapTile mt : popped) {
                        if (mt.world == world) continue;
                        this.tileQueue.push(mt);
                    }
                }
                popped.clear();
            }
            for (DynmapWorld dw : this.worlds) {
                if (worldname != null && dw != world) continue;
                for (MapTypeState mts : dw.mapstate) {
                    cnt += mts.getInvCount();
                    mts.clear();
                }
            }
            sender.sendMessage("Purged " + cnt + " tiles from queue");
        }
    }

    void purgeMap(final DynmapCommandSender sender, final String worldname, final String mapname) {
        final DynmapWorld world = this.getWorld(worldname);
        if (world == null) {
            sender.sendMessage("Could not purge map: world '" + worldname + "' not defined in configuration.");
            return;
        }
        MapType mt = null;
        for (MapType mtp : world.maps) {
            if (!mtp.getName().equals(mapname)) continue;
            mt = mtp;
            break;
        }
        if (mt == null) {
            sender.sendMessage("Could not purge map: map '" + mapname + "' not defined in configuration.");
            return;
        }
        final MapType mtf = mt;
        Runnable purgejob = new Runnable(){

            @Override
            public void run() {
                world.purgeMap(mtf);
                sender.sendMessage("Purge of tiles for map '" + mapname + "' for world '" + worldname + "' completed");
            }
        };
        MapManager.scheduleDelayedJob(purgejob, 0L);
        sender.sendMessage("Map tile purge starting on map '" + mapname + "' for world '" + worldname + "'...");
    }

    void purgeWorld(final DynmapCommandSender sender, final String worldname) {
        final DynmapWorld world = this.getWorld(worldname);
        if (world == null) {
            sender.sendMessage("Could not purge world: world '" + worldname + "' not defined in configuration.");
            return;
        }
        this.cancelRender(worldname, sender);
        this.purgeQueue(sender, worldname);
        Runnable purgejob = new Runnable(){

            @Override
            public void run() {
                world.purgeTree();
                sender.sendMessage("Purge of files for world '" + worldname + "' completed");
            }
        };
        MapManager.scheduleDelayedJob(purgejob, 0L);
        sender.sendMessage("World purge starting on world '" + worldname + "'...");
    }

    public boolean activateWorld(DynmapWorld dynmapWorld) {
        String worldname = dynmapWorld.getName();
        ConfigurationNode worldconfig = this.core.getWorldConfiguration(dynmapWorld);
        if (!dynmapWorld.loadConfiguration(this.core, worldconfig)) {
            Log.info("World '" + worldname + "' disabled");
            this.disabled_worlds.add(worldname);
            DynmapWorld oldw = this.worldsLookup.remove(worldname);
            if (oldw != null) {
                this.worlds.remove(oldw);
            }
            return false;
        }
        this.disabled_worlds.remove(worldname);
        HashMap<String, Integer> indexLookup = new HashMap<String, Integer>();
        List<Map<String, Object>> nodes = this.core.world_config.getMapList("worlds");
        for (int i = 0; i < nodes.size(); ++i) {
            Map<String, Object> node = nodes.get(i);
            indexLookup.put((String)node.get("name"), i);
        }
        Integer worldIndex = (Integer)indexLookup.get(worldname);
        if (worldIndex == null) {
            this.worlds.add(dynmapWorld);
        } else {
            Integer nextWorldIndex;
            int insertIndex;
            for (insertIndex = 0; insertIndex < this.worlds.size() && (nextWorldIndex = (Integer)indexLookup.get(this.worlds.get(insertIndex).getName())) != null && worldIndex >= nextWorldIndex; ++insertIndex) {
            }
            this.worlds.add(insertIndex, dynmapWorld);
        }
        this.worldsLookup.put(worldname, dynmapWorld);
        this.core.events.trigger("worldactivated", dynmapWorld);
        if (dynmapWorld.isLoaded()) {
            this.loadWorld(dynmapWorld);
        }
        dynmapWorld.activateZoomOutFreshen();
        return true;
    }

    public void deactivateWorld(String wname) {
        DynmapWorld w = this.worldsLookup.get(wname);
        if (w != null) {
            if (this.saverestorepending) {
                this.savePending(w, false);
            } else {
                this.cancelRender(wname, null);
            }
        }
        if ((w = this.worldsLookup.remove(wname)) != null) {
            this.worlds.remove(w);
        }
        this.disabled_worlds.remove(wname);
    }

    public void loadWorld(DynmapWorld dynmapWorld) {
        if (this.saverestorepending) {
            this.loadPending(dynmapWorld);
        }
    }

    public void unloadWorld(DynmapWorld dynmapWorld) {
        if (this.saverestorepending) {
            this.savePending(dynmapWorld, false);
        }
    }

    private void loadPending(DynmapWorld w) {
        String wname = w.getName();
        File f = new File(this.core.getDataFolder(), wname + ".pending");
        if (f.exists()) {
            ConfigurationNode job;
            List<String> v;
            ConfigurationNode invmap;
            ConfigurationNode cn = new ConfigurationNode(f);
            cn.load();
            int cnt = 0;
            List<ConfigurationNode> tiles = cn.getNodes("tiles");
            if (tiles != null) {
                for (ConfigurationNode tile : tiles) {
                    MapTile mt = MapTile.restoreTile(w, tile);
                    if (mt == null || !this.tileQueue.push(mt)) continue;
                    ++cnt;
                }
            }
            if ((invmap = cn.getNode("invalid")) != null) {
                for (MapTypeState mts : w.mapstate) {
                    v = invmap.getStrings(mts.type.getPrefix(), null);
                    if (v == null) continue;
                    mts.restore(v);
                    cnt += mts.getInvCount();
                }
            }
            if (cnt > 0) {
                Log.info("Loaded " + cnt + " pending tile renders for world '" + wname + "'");
            }
            if ((invmap = cn.getNode("invZoomOut")) != null) {
                for (MapTypeState mts : w.mapstate) {
                    v = invmap.getList(mts.type.getPrefix());
                    if (v == null) continue;
                    mts.restoreZoomOut(v);
                }
            }
            if ((job = cn.getNode("job")) != null && this.active_renders.get(wname) == null) {
                try {
                    FullWorldRenderState j = new FullWorldRenderState(job);
                    this.active_renders.put(wname, j);
                    if (this.did_start) {
                        MapManager.scheduleDelayedJob(j, 5000L);
                    }
                    Log.info(j.rendertype + " for world '" + wname + "' restored");
                }
                catch (Exception x) {
                    Log.info("Unable to restore render job for world '" + wname + "' - map configuration changed");
                }
            }
        }
    }

    public boolean isRenderJobActive(String wname) {
        return this.active_renders.containsKey(wname);
    }

    private void savePending(DynmapWorld w, boolean keepQueue) {
        FullWorldRenderState job;
        List<MapTile> mt = this.tileQueue.popAll();
        File f = new File(this.core.getDataFolder(), w.getName() + ".pending");
        ConfigurationNode saved = new ConfigurationNode();
        ArrayList<ConfigurationNode> savedtiles = new ArrayList<ConfigurationNode>();
        for (MapTile tile : mt) {
            if (tile.getDynmapWorld() != w) {
                this.tileQueue.push(tile);
                continue;
            }
            ConfigurationNode tilenode = tile.saveTile();
            if (tilenode != null) {
                savedtiles.add(tilenode);
            }
            if (!keepQueue) continue;
            this.tileQueue.push(tile);
        }
        int cnt = savedtiles.size();
        if (cnt > 0) {
            saved.put("tiles", (Object)savedtiles);
        }
        HashMap<String, List<String>> invalid = new HashMap<String, List<String>>();
        for (MapTypeState mts : w.mapstate) {
            invalid.put(mts.type.getPrefix(), mts.save());
            cnt += mts.getInvCount();
        }
        if (cnt > 0) {
            saved.put("invalid", (Object)invalid);
            if (!keepQueue) {
                Log.info("Saved " + cnt + " pending tile renders in world '" + w.getName() + "'");
            }
        }
        HashMap<String, List<List<String>>> invzooms = new HashMap<String, List<List<String>>>();
        for (MapTypeState mts : w.mapstate) {
            List<List<String>> szo = mts.saveZoomOut();
            if (szo == null) continue;
            invzooms.put(mts.type.getPrefix(), szo);
        }
        if (!invzooms.isEmpty()) {
            saved.put("invZoomOut", (Object)invzooms);
        }
        if ((job = this.active_renders.get(w.getName())) != null) {
            saved.put("job", (Object)job.saveState());
            if (!keepQueue) {
                this.active_renders.remove(w.getName());
                job.shutdownRender();
                Log.info(job.rendertype + " job saved for world '" + w.getName() + "'");
            }
        }
        if (saved.isEmpty()) {
            f.delete();
        } else {
            saved.save(f);
        }
    }

    public void touch(String wname, int x, int y, int z, String reason) {
        TouchEvent evt = new TouchEvent();
        evt.world = wname;
        evt.x = x;
        evt.y = y;
        evt.z = z;
        evt.reason = reason;
        this.touch_events.putIfAbsent(evt, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchVolume(String wname, int minx, int miny, int minz, int maxx, int maxy, int maxz, String reason) {
        TouchVolumeEvent evt = new TouchVolumeEvent();
        evt.world = wname;
        evt.xmin = minx;
        evt.xmax = maxx;
        evt.ymin = miny;
        evt.ymax = maxy;
        evt.zmin = minz;
        evt.zmax = maxz;
        evt.reason = reason;
        Object object = this.touch_lock;
        synchronized (object) {
            this.touch_volume_events.add(evt);
        }
    }

    public static boolean scheduleDelayedJob(Runnable job, long delay_in_msec) {
        if (mapman != null && MapManager.mapman.render_pool != null) {
            if (delay_in_msec > 0L) {
                MapManager.mapman.render_pool.schedule(job, delay_in_msec, TimeUnit.MILLISECONDS);
            } else {
                MapManager.mapman.render_pool.execute(job);
            }
            return true;
        }
        return false;
    }

    public void startRendering() {
        this.render_pool = new DynmapScheduledThreadPoolExecutor();
        this.tileQueue.start();
        MapManager.scheduleDelayedJob(new DoZoomOutProcessing(), 60000L);
        MapManager.scheduleDelayedJob(new CheckWorldTimes(), 5000L);
        MapManager.scheduleDelayedJob(new DoTouchProcessing(), 1000L);
        for (FullWorldRenderState job : this.active_renders.values()) {
            MapManager.scheduleDelayedJob(job, 5000L);
            Log.info("Resumed render starting on world '" + job.world.getName() + "'...");
        }
        this.did_start = true;
    }

    public void stopRendering() {
        this.tileQueue.stop();
        for (DynmapWorld w : this.worlds) {
            w.cancelZoomOutFreshen();
        }
        for (DynmapWorld w : this.worlds) {
            if (!w.isLoaded()) continue;
            w.setWorldUnloaded();
            if (!this.saverestorepending) continue;
            this.savePending(w, false);
        }
        this.render_pool.shutdown();
        try {
            this.render_pool.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        mapman = null;
        this.hdmapman = null;
        this.did_start = false;
    }

    public void pushUpdate(Client.Update update) {
        int sz = this.worlds.size();
        for (int i = 0; i < sz; ++i) {
            this.worlds.get((int)i).updates.pushUpdate(update);
        }
    }

    public void pushUpdate(DynmapWorld world, Client.Update update) {
        this.pushUpdate(world.getName(), update);
    }

    public void pushUpdate(String worldName, Client.Update update) {
        DynmapWorld world = this.getWorld(worldName);
        if (world != null) {
            world.updates.pushUpdate(update);
        }
    }

    public Client.Update[] getWorldUpdates(String worldName, long since) {
        DynmapWorld world = this.getWorld(worldName);
        if (world == null) {
            return new Client.Update[0];
        }
        return world.updates.getUpdatedObjects(since);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatistics(MapTile tile, String prefix, boolean rendered, boolean updated, boolean transparent) {
        Object object = lock;
        synchronized (object) {
            String k = tile.getDynmapWorld().getName() + "." + prefix;
            MapStats ms = this.mapstats.get(k);
            if (ms == null) {
                ms = new MapStats();
                this.mapstats.put(k, ms);
            }
            ++ms.loggedcnt;
            if (rendered) {
                ++ms.renderedcnt;
            }
            if (updated) {
                ++ms.updatedcnt;
            }
            if (transparent) {
                ++ms.transparentcnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStats(DynmapCommandSender sender, String prefix) {
        sender.sendMessage("Tile Render Statistics:");
        MapStats tot = new MapStats();
        int invcnt = 0;
        for (DynmapWorld dw : this.worlds) {
            for (MapTypeState mts : dw.mapstate) {
                invcnt += mts.getInvCount();
            }
        }
        Object i$ = lock;
        synchronized (i$) {
            for (String k : new TreeSet<String>(this.mapstats.keySet())) {
                if (prefix != null && !k.startsWith(prefix)) continue;
                MapStats ms = this.mapstats.get(k);
                sender.sendMessage(String.format("  %s: processed=%d, rendered=%d, updated=%d, transparent=%d", k, ms.loggedcnt, ms.renderedcnt, ms.updatedcnt, ms.transparentcnt));
                tot.loggedcnt += ms.loggedcnt;
                tot.renderedcnt += ms.renderedcnt;
                tot.updatedcnt += ms.updatedcnt;
                tot.transparentcnt += ms.transparentcnt;
            }
        }
        sender.sendMessage(String.format("  TOTALS: processed=%d, rendered=%d, updated=%d, transparent=%d", tot.loggedcnt, tot.renderedcnt, tot.updatedcnt, tot.transparentcnt));
        sender.sendMessage(String.format("  Triggered update queue size: %d + %d", this.tileQueue.size(), invcnt));
        String act = "";
        for (String wn : this.active_renders.keySet()) {
            act = act + wn + " ";
        }
        sender.sendMessage(String.format("  Active render jobs: %s", act));
        sender.sendMessage("Chunk Loading Statistics:");
        sender.sendMessage(String.format("  Cache hit rate: %.2f%%", this.core.getServer().getCacheHitRate()));
        for (MapChunkCache.ChunkStats cs : MapChunkCache.ChunkStats.values()) {
            int cnt = this.chunks_read[cs.ordinal()].get();
            if (cnt == 0) {
                cnt = 1;
            }
            long ts = this.chunks_read_times[cs.ordinal()].get();
            sender.sendMessage(String.format("  Chunks processed: %s: count=%d, %.2f msec/chunk", cs.getLabel(), cnt, 1.0E-6 * (double)(ts / (long)cnt)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTriggerStats(DynmapCommandSender sender) {
        sender.sendMessage("Render Trigger Statistics:");
        Object object = lock;
        synchronized (object) {
            for (String k : new TreeSet<String>(this.trigstats.keySet())) {
                TriggerStats ts = this.trigstats.get(k);
                sender.sendMessage("  " + k + ": calls=" + ts.callsmade + ", calls-adding-tiles=" + ts.callswithtiles + ", tiles-added=" + ts.tilesqueued);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats(DynmapCommandSender sender, String prefix) {
        Object object = lock;
        synchronized (object) {
            for (String k : this.mapstats.keySet()) {
                if (prefix != null && !k.startsWith(prefix)) continue;
                MapStats ms = this.mapstats.get(k);
                ms.loggedcnt = 0;
                ms.renderedcnt = 0;
                ms.updatedcnt = 0;
                ms.transparentcnt = 0;
            }
            for (String k : this.trigstats.keySet()) {
                TriggerStats ts = this.trigstats.get(k);
                ts.callsmade = 0L;
                ts.callswithtiles = 0L;
                ts.tilesqueued = 0L;
            }
            this.chunk_caches_created.set(0);
            for (int i = 0; i < this.chunks_read.length; ++i) {
                this.chunks_read[i].set(0);
                this.chunks_read_times[i].set(0L);
            }
        }
        this.core.getServer().resetCacheStats();
        sender.sendMessage("Tile Render Statistics reset");
    }

    public boolean getSmoothLighting() {
        return this.core.smoothlighting;
    }

    public boolean getBetterGrass() {
        return this.core.bettergrass;
    }

    public DynmapCore.CompassMode getCompassMode() {
        return this.core.compassmode;
    }

    public boolean getHideOres() {
        return this.hideores;
    }

    public int getBlockIDAlias(int id) {
        return this.blockidalias[id];
    }

    public void setBlockIDAlias(int id, int newid) {
        if (id > 0 && id < 4096 && newid >= 0 && newid < 4096) {
            this.blockidalias[id] = (short)newid;
        }
    }

    void setPauseFullRadiusRenders(boolean dopause) {
        if (dopause != this.pausefullrenders) {
            this.pausefullrenders = dopause;
            Log.info("Full/radius render pause set to " + dopause);
        }
    }

    boolean getPauseFullRadiusRenders() {
        return this.pausefullrenders;
    }

    void setPauseUpdateRenders(boolean dopause) {
        if (dopause != this.pauseupdaterenders) {
            this.pauseupdaterenders = dopause;
            Log.info("Update render pause set to " + dopause);
        }
    }

    boolean getPauseUpdateRenders() {
        return this.pauseupdaterenders;
    }

    void connectTasksToPlayer(DynmapPlayer p) {
        String pn = p.getName();
        for (FullWorldRenderState job : this.active_renders.values()) {
            if (!pn.equals(job.player)) continue;
            job.sender = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTouchEvents() {
        TriggerStats ts;
        List<TileFlags.TileCoord> tiles;
        int invalidates;
        ArrayList te = null;
        ArrayList<TouchVolumeEvent> tve = null;
        if (!this.touch_events.isEmpty()) {
            te = new ArrayList(this.touch_events.keySet());
            for (int i = 0; i < te.size(); ++i) {
                this.touch_events.remove(te.get(i));
            }
        }
        Object i = this.touch_lock;
        synchronized (i) {
            if (!this.touch_volume_events.isEmpty()) {
                tve = new ArrayList<TouchVolumeEvent>(this.touch_volume_events);
                this.touch_volume_events.clear();
            }
        }
        DynmapWorld world = null;
        String wname = "";
        if (te != null) {
            for (TouchEvent touchEvent : te) {
                invalidates = 0;
                if (!touchEvent.world.equals(wname)) {
                    wname = touchEvent.world;
                    world = this.getWorld(wname);
                }
                if (world == null) continue;
                for (MapTypeState mts : world.mapstate) {
                    tiles = mts.type.getTileCoords(world, touchEvent.x, touchEvent.y, touchEvent.z);
                    invalidates += mts.invalidateTiles(tiles);
                }
                if (touchEvent.reason == null) continue;
                Object i$ = lock;
                synchronized (i$) {
                    ts = this.trigstats.get(touchEvent.reason);
                    if (ts == null) {
                        ts = new TriggerStats();
                        this.trigstats.put(touchEvent.reason, ts);
                    }
                    ++ts.callsmade;
                    if (invalidates > 0) {
                        ++ts.callswithtiles;
                        ts.tilesqueued += (long)invalidates;
                    }
                }
            }
            te.clear();
        }
        if (tve != null) {
            for (TouchVolumeEvent touchVolumeEvent : tve) {
                if (!touchVolumeEvent.world.equals(wname)) {
                    wname = touchVolumeEvent.world;
                    world = this.getWorld(wname);
                }
                if (world == null) continue;
                invalidates = 0;
                for (MapTypeState mts : world.mapstate) {
                    tiles = mts.type.getTileCoords(world, touchVolumeEvent.xmin, touchVolumeEvent.ymin, touchVolumeEvent.zmin, touchVolumeEvent.xmax, touchVolumeEvent.ymax, touchVolumeEvent.zmax);
                    invalidates += mts.invalidateTiles(tiles);
                }
                if (touchVolumeEvent.reason == null) continue;
                Object object = lock;
                synchronized (object) {
                    ts = this.trigstats.get(touchVolumeEvent.reason);
                    if (ts == null) {
                        ts = new TriggerStats();
                        this.trigstats.put(touchVolumeEvent.reason, ts);
                    }
                    ++ts.callsmade;
                    if (invalidates > 0) {
                        ++ts.callswithtiles;
                        ts.tilesqueued += (long)invalidates;
                    }
                }
            }
            tve.clear();
        }
    }

    public int getMaxChunkLoadsPerTick() {
        return this.max_chunk_loads_per_tick;
    }

    public void updateTPS(double tps) {
        this.tpspauseupdaterenders = tps < this.tpslimit_updaterenders;
        this.tpspausefullrenders = tps < this.tpslimit_fullrenders;
        this.tpspausezoomout = tps < this.tpslimit_zoomout;
    }

    public boolean getTPSFullRenderPause() {
        return this.tpspausefullrenders;
    }

    public boolean getTPSUpdateRenderPause() {
        return this.tpspauseupdaterenders;
    }

    public boolean getTPSZoomOutPause() {
        return this.tpspausezoomout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobsQuiet(DynmapCommandSender sender) {
        DynmapPlayer player = null;
        if (sender instanceof DynmapPlayer) {
            player = (DynmapPlayer)sender;
        }
        Object object = lock;
        synchronized (object) {
            for (FullWorldRenderState job : this.active_renders.values()) {
                if (job.sender instanceof DynmapPlayer) {
                    DynmapPlayer js = (DynmapPlayer)job.sender;
                    if (player == null || !player.getName().equals(js.getName())) continue;
                    job.quiet = true;
                    continue;
                }
                if (player != null) continue;
                job.quiet = true;
            }
        }
    }

    public boolean useBrightnessTable() {
        return this.useBrightnessTable;
    }

    private class DoTouchProcessing
    implements Runnable {
        private DoTouchProcessing() {
        }

        @Override
        public void run() {
            MapManager.this.processTouchEvents();
            int cnt = 2 * MapManager.this.tileQueue.accelDequeueThresh;
            if (cnt < 100) {
                cnt = 100;
            }
            if ((cnt -= MapManager.this.tileQueue.size()) > 0) {
                MapManager.this.addNextTilesToUpdate(cnt);
            }
            MapManager.scheduleDelayedJob(this, 1000L);
        }
    }

    private class DoZoomOutProcessing
    implements Runnable {
        private DoZoomOutProcessing() {
        }

        @Override
        public void run() {
            if (!MapManager.this.tpspausezoomout) {
                Debug.debug("DoZoomOutProcessing started");
                ArrayList<DynmapWorld> wl = new ArrayList<DynmapWorld>(MapManager.this.worlds);
                for (DynmapWorld w : wl) {
                    w.freshenZoomOutFiles();
                }
                Debug.debug("DoZoomOutProcessing finished");
                MapManager.scheduleDelayedJob(this, MapManager.this.zoomout_period * 1000);
            } else {
                MapManager.scheduleDelayedJob(this, 5000L);
            }
        }
    }

    private class CheckWorldTimes
    implements Runnable {
        private CheckWorldTimes() {
        }

        @Override
        public void run() {
            Future<Integer> f = MapManager.this.core.getServer().callSyncMethod(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    long now_nsec = System.nanoTime();
                    for (DynmapWorld w : MapManager.this.worlds) {
                        if (w.isLoaded()) {
                            int new_servertime = (int)(w.getTime() % 24000L);
                            boolean wasday = w.servertime >= 0 && w.servertime < 13700;
                            boolean isday = new_servertime >= 0 && new_servertime < 13700;
                            w.servertime = new_servertime;
                            if (wasday != isday) {
                                MapManager.this.pushUpdate(w, (Client.Update)new Client.DayNight(isday));
                            }
                        }
                        for (MapTypeState mts : w.mapstate) {
                            mts.tickMapTypeState(now_nsec);
                        }
                    }
                    return 0;
                }
            });
            if (f == null) {
                return;
            }
            try {
                f.get();
            }
            catch (CancellationException cx) {
                return;
            }
            catch (ExecutionException ex) {
                Log.severe("Error while checking world times: ", ex.getCause());
            }
            catch (Exception ix) {
                Log.severe(ix);
            }
            MapManager.scheduleDelayedJob(this, 5000L);
        }
    }

    private class ProcessOBJExport
    implements Runnable {
        private OBJExport exp;
        private DynmapCommandSender sender;

        private ProcessOBJExport() {
        }

        @Override
        public void run() {
            this.exp.processExport(this.sender);
        }
    }

    private class FullWorldRenderState
    implements Runnable {
        DynmapWorld world;
        DynmapLocation loc;
        int map_index = -1;
        MapType map;
        TileFlags found = null;
        TileFlags rendered = null;
        LinkedList<MapTile> renderQueue = null;
        MapTile tile0 = null;
        int rendercnt = 0;
        DynmapCommandSender sender;
        String player;
        long timeaccum;
        HashSet<MapType> renderedmaps = new HashSet();
        String activemaps;
        int activemapcnt;
        int cxmin;
        int cxmax;
        int czmin;
        int czmax;
        String rendertype;
        boolean cancelled;
        boolean shutdown = false;
        boolean pausedforworld = false;
        boolean updaterender = false;
        boolean quiet = false;
        String mapname;
        AtomicLong total_render_ns = new AtomicLong(0L);
        AtomicInteger rendercalls = new AtomicInteger(0);
        long lastPendingSaveTS = 0L;

        FullWorldRenderState(DynmapWorld dworld, DynmapLocation l, DynmapCommandSender sender, String mapname, boolean updaterender) {
            this(dworld, l, sender, mapname, -1);
            if (updaterender) {
                this.rendertype = MapManager.RENDERTYPE_UPDATERENDER;
                this.updaterender = true;
            } else {
                this.rendertype = MapManager.RENDERTYPE_FULLRENDER;
            }
        }

        FullWorldRenderState(DynmapWorld dworld, DynmapLocation l, DynmapCommandSender sender, String mapname, int radius) {
            this.world = dworld;
            this.loc = l;
            this.found = new TileFlags();
            this.rendered = new TileFlags();
            this.renderQueue = new LinkedList();
            this.sender = sender;
            this.player = sender instanceof DynmapPlayer ? ((DynmapPlayer)sender).getName() : "";
            if (radius < 0) {
                this.czmin = Integer.MIN_VALUE;
                this.cxmin = Integer.MIN_VALUE;
                this.czmax = Integer.MAX_VALUE;
                this.cxmax = Integer.MAX_VALUE;
                this.rendertype = MapManager.RENDERTYPE_FULLRENDER;
            } else {
                this.cxmin = (int)l.x - radius >> 4;
                this.czmin = (int)l.z - radius >> 4;
                this.cxmax = (int)l.x + radius + 1 >> 4;
                this.czmax = (int)l.z + radius + 1 >> 4;
                this.rendertype = MapManager.RENDERTYPE_RADIUSRENDER;
            }
            this.mapname = mapname;
        }

        FullWorldRenderState(MapTile t) {
            this.world = MapManager.this.getWorld(t.getDynmapWorld().getName());
            this.tile0 = t;
            this.czmin = Integer.MIN_VALUE;
            this.cxmin = Integer.MIN_VALUE;
            this.czmax = Integer.MAX_VALUE;
            this.cxmax = Integer.MAX_VALUE;
        }

        FullWorldRenderState(ConfigurationNode n) throws Exception {
            String w = n.getString("world", "");
            this.world = MapManager.this.getWorld(w);
            if (this.world == null) {
                throw new Exception();
            }
            this.loc = new DynmapLocation();
            this.loc.world = this.world.getName();
            this.loc.x = (int)n.getDouble("locX", 0.0);
            this.loc.y = (int)n.getDouble("locY", 0.0);
            this.loc.z = (int)n.getDouble("locZ", 0.0);
            this.map_index = n.getInteger("mapindex", -1);
            if (this.map_index >= 0) {
                String m = n.getString("map", "");
                this.map = this.world.maps.get(this.map_index);
                if (this.map == null || !this.map.getName().equals(m)) {
                    throw new Exception();
                }
            } else {
                this.map_index = -1;
                this.map = null;
            }
            this.found = new TileFlags();
            List<String> sl = n.getStrings("found", null);
            if (sl != null) {
                this.found.load(sl);
            }
            this.rendered = new TileFlags();
            sl = n.getStrings("rendered", null);
            if (sl != null) {
                this.rendered.load(sl);
            }
            this.renderQueue = new LinkedList();
            List<ConfigurationNode> tl = n.getNodes("queue");
            if (tl != null) {
                for (ConfigurationNode cn : tl) {
                    MapTile mt = MapTile.restoreTile(this.world, cn);
                    if (mt == null) continue;
                    this.renderQueue.add(mt);
                }
            }
            this.rendercnt = n.getInteger("count", 0);
            this.timeaccum = n.getInteger("timeaccum", 0);
            this.renderedmaps = new HashSet();
            sl = n.getStrings("renderedmaps", null);
            if (sl != null) {
                block1: for (String s : sl) {
                    for (int i = 0; i < this.world.maps.size(); ++i) {
                        MapType mt = this.world.maps.get(i);
                        if (!mt.getName().equals(s)) continue;
                        this.renderedmaps.add(mt);
                        continue block1;
                    }
                }
                if (sl.size() > this.renderedmaps.size()) {
                    throw new Exception();
                }
            }
            this.activemaps = n.getString("activemaps", "");
            this.activemapcnt = n.getInteger("activemapcnt", 0);
            this.cxmin = n.getInteger("cxmin", 0);
            this.cxmax = n.getInteger("cxmax", 0);
            this.czmin = n.getInteger("czmin", 0);
            this.czmax = n.getInteger("czmax", 0);
            this.rendertype = n.getString("rendertype", "");
            this.mapname = n.getString("mapname", null);
            this.player = n.getString("player", "");
            this.updaterender = this.rendertype.equals(MapManager.RENDERTYPE_UPDATERENDER);
            this.sender = null;
            if (this.player.length() > 0) {
                this.sender = MapManager.this.core.getServer().getPlayer(this.player);
            }
        }

        public HashMap<String, Object> saveState() {
            HashMap<String, Object> v = new HashMap<String, Object>();
            v.put("world", this.world.getName());
            v.put("locX", this.loc.x);
            v.put("locY", this.loc.y);
            v.put("locZ", this.loc.z);
            if (this.map != null) {
                v.put("mapindex", this.map_index);
                v.put("map", this.map.getName());
            } else {
                v.put("mapindex", -1);
                v.put("map", "");
            }
            v.put("found", this.found.save());
            v.put("rendered", this.rendered.save());
            LinkedList<ConfigurationNode> queue = new LinkedList<ConfigurationNode>();
            for (MapTile tq : this.renderQueue) {
                ConfigurationNode n = tq.saveTile();
                if (n == null) continue;
                queue.add(n);
            }
            v.put("queue", queue);
            v.put("count", this.rendercnt);
            v.put("timeaccum", this.timeaccum);
            LinkedList<String> rmaps = new LinkedList<String>();
            for (MapType mt : this.renderedmaps) {
                rmaps.add(mt.getName());
            }
            v.put("renderedmaps", rmaps);
            v.put("activemaps", this.activemaps);
            v.put("activemapcnt", this.activemapcnt);
            v.put("cxmin", this.cxmin);
            v.put("cxmax", this.cxmax);
            v.put("czmin", this.czmin);
            v.put("czmax", this.czmax);
            v.put("rendertype", this.rendertype);
            if (this.mapname != null) {
                v.put("mapname", this.mapname);
            }
            v.put("player", this.player);
            return v;
        }

        public String toString() {
            return "world=" + this.world.getName() + ", map=" + this.map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            if (this.tile0 == null) {
                Object object = lock;
                synchronized (object) {
                    String wn = this.world.getName();
                    FullWorldRenderState rs = (FullWorldRenderState)MapManager.this.active_renders.get(wn);
                    if (rs == this) {
                        MapManager.this.active_renders.remove(wn);
                    }
                }
            } else {
                MapManager.this.tileQueue.done(this.tile0);
            }
        }

        public void saveRefresh() {
            if (MapManager.this.saverestorepending && this.world.isLoaded() && MapManager.this.savependingperiod > 0) {
                MapManager.this.savePending(this.world, true);
            }
        }

        @Override
        public void run() {
            long tstart = System.currentTimeMillis();
            MapTile tile = null;
            ArrayList<MapTile> tileset = null;
            if (this.cancelled) {
                this.cleanup();
                if (!this.shutdown) {
                    this.saveRefresh();
                }
                return;
            }
            if (this.tile0 == null) {
                if (MapManager.this.saverestorepending && this.world.isLoaded() && MapManager.this.savependingperiod > 0 && this.lastPendingSaveTS + (long)(1000 * MapManager.this.savependingperiod) < System.currentTimeMillis()) {
                    MapManager.this.savePending(this.world, true);
                    this.lastPendingSaveTS = System.currentTimeMillis();
                }
                if (MapManager.this.pausefullrenders || MapManager.this.tpspausefullrenders) {
                    MapManager.scheduleDelayedJob(this, 100L);
                    return;
                }
                if (!this.world.isLoaded()) {
                    if (!this.pausedforworld) {
                        this.pausedforworld = true;
                        Log.info("Paused " + this.rendertype + " for world '" + this.world.getName() + "' - world unloaded");
                    }
                    MapManager.scheduleDelayedJob(this, 100L);
                    return;
                }
                if (this.pausedforworld) {
                    this.pausedforworld = false;
                    Log.info("Unpaused " + this.rendertype + " for world '" + this.world.getName() + "' - world reloaded");
                }
                if (this.renderQueue.isEmpty()) {
                    if (this.map_index >= 0) {
                        double msecpertile = (double)this.timeaccum / (double)(this.rendercnt > 0 ? this.rendercnt : 1) / (double)this.activemapcnt;
                        int rndcalls = this.rendercalls.get();
                        if (rndcalls == 0) {
                            rndcalls = 1;
                        }
                        double rendtime = this.total_render_ns.doubleValue() * 1.0E-6 / (double)rndcalls;
                        if (this.activemapcnt > 1) {
                            this.sendMessage(String.format("%s of maps [%s] of '%s' completed - %d tiles rendered each (%.2f msec/map-tile, %.2f msec per render)", this.rendertype, this.activemaps, this.world.getName(), this.rendercnt, msecpertile, rendtime));
                        } else {
                            this.sendMessage(String.format("%s of map '%s' of '%s' completed - %d tiles rendered (%.2f msec/map-tile, %.2f msec per render)", this.rendertype, this.activemaps, this.world.getName(), this.rendercnt, msecpertile, rendtime));
                        }
                        if (this.rendertype.equals(MapManager.RENDERTYPE_FULLRENDER)) {
                            if (this.activemapcnt == 1) {
                                this.map.purgeOldTiles(this.world, this.rendered);
                            } else {
                                for (MapType mapType : this.map.getMapsSharingRender(this.world)) {
                                    mapType.purgeOldTiles(this.world, this.rendered);
                                }
                            }
                        }
                    }
                    this.found.clear();
                    this.rendered.clear();
                    this.rendercnt = 0;
                    this.timeaccum = 0L;
                    this.total_render_ns.set(0L);
                    this.rendercalls.set(0);
                    while (this.map_index < this.world.maps.size()) {
                        ++this.map_index;
                        if (this.map_index < this.world.maps.size() && !(this.mapname != null ? this.world.maps.get(this.map_index).getName().equals(this.mapname) : !this.renderedmaps.contains(this.world.maps.get(this.map_index)))) continue;
                    }
                    if (this.map_index >= this.world.maps.size()) {
                        this.sendMessage(this.rendertype + " of '" + this.world.getName() + "' finished.");
                        this.cleanup();
                        this.saveRefresh();
                        return;
                    }
                    this.map = this.world.maps.get(this.map_index);
                    List<String> activemaplist = this.map.getMapNamesSharingRender(this.world);
                    this.activemaps = "";
                    if (this.mapname != null) {
                        this.activemaps = this.mapname;
                        this.activemapcnt = 1;
                    } else {
                        this.activemapcnt = 0;
                        for (String n : activemaplist) {
                            if (this.activemaps.length() > 0) {
                                this.activemaps = this.activemaps + ",";
                            }
                            this.activemaps = this.activemaps + n;
                            ++this.activemapcnt;
                        }
                    }
                    this.renderedmaps.addAll(this.map.getMapsSharingRender(this.world));
                    for (MapTile mt : this.map.getTiles(this.world, (int)this.loc.x, (int)this.loc.y, (int)this.loc.z)) {
                        if (this.found.getFlag(mt.tileOrdinalX(), mt.tileOrdinalY())) continue;
                        this.found.setFlag(mt.tileOrdinalX(), mt.tileOrdinalY(), true);
                        this.renderQueue.add(mt);
                    }
                    if (!this.updaterender) {
                        DynmapLocation sloc = this.world.getSpawnLocation();
                        for (MapTile mt : this.map.getTiles(this.world, (int)sloc.x, (int)sloc.y, (int)sloc.z)) {
                            if (this.found.getFlag(mt.tileOrdinalX(), mt.tileOrdinalY())) continue;
                            this.found.setFlag(mt.tileOrdinalX(), mt.tileOrdinalY(), true);
                            this.renderQueue.add(mt);
                        }
                        if (this.world.seedloc != null) {
                            for (DynmapLocation seed : this.world.seedloc) {
                                for (MapTile mt : this.map.getTiles(this.world, (int)seed.x, (int)seed.y, (int)seed.z)) {
                                    if (this.found.getFlag(mt.tileOrdinalX(), mt.tileOrdinalY())) continue;
                                    this.found.setFlag(mt.tileOrdinalX(), mt.tileOrdinalY(), true);
                                    this.renderQueue.add(mt);
                                }
                            }
                        }
                    }
                }
                if (MapManager.this.parallelrendercnt > 1) {
                    tileset = new ArrayList<MapTile>();
                    for (int i = 0; i < MapManager.this.parallelrendercnt; ++i) {
                        tile = this.renderQueue.pollFirst();
                        if (tile == null) continue;
                        tileset.add(tile);
                    }
                } else {
                    tile = this.renderQueue.pollFirst();
                }
            } else {
                if (MapManager.this.pauseupdaterenders || MapManager.this.tpspauseupdaterenders) {
                    MapManager.scheduleDelayedJob(this, 100L);
                    return;
                }
                tile = this.tile0;
            }
            boolean notdone = true;
            if (tileset != null) {
                int i;
                long save_timeaccum = this.timeaccum;
                ArrayList<Future<Boolean>> rslt = new ArrayList<Future<Boolean>>();
                final int cnt = tileset.size();
                for (i = 1; i < cnt; ++i) {
                    final MapTile mapTile = (MapTile)tileset.get(i);
                    if (mapman == null || mapman.render_pool == null) continue;
                    final long ts = tstart;
                    Future<Boolean> future = mapman.render_pool.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return FullWorldRenderState.this.processTile(mapTile, ts, cnt);
                        }
                    });
                    rslt.add(future);
                }
                tile = (MapTile)tileset.get(0);
                notdone = this.processTile(tile, tstart, cnt);
                if (!notdone && this.tile0 == null) {
                    this.renderQueue.push(tile);
                }
                for (i = 0; i < rslt.size(); ++i) {
                    boolean bl = false;
                    try {
                        bl = (Boolean)((Future)rslt.get(i)).get();
                    }
                    catch (CancellationException cx) {
                        bl = false;
                    }
                    catch (ExecutionException xx) {
                        Log.severe("Execution exception while processing tile: ", xx.getCause());
                        bl = false;
                    }
                    catch (InterruptedException ix) {
                        bl = false;
                    }
                    boolean bl2 = notdone = notdone && bl;
                    if (bl || this.tile0 != null) continue;
                    tile = (MapTile)tileset.get(i + 1);
                    this.renderQueue.push(tile);
                }
                this.timeaccum = save_timeaccum + System.currentTimeMillis() - tstart;
            } else {
                notdone = this.processTile(tile, tstart, 1);
                if (!notdone && this.tile0 == null) {
                    this.renderQueue.push(tile);
                }
            }
            if (notdone) {
                if (this.tile0 == null) {
                    long tend = System.currentTimeMillis();
                    if (MapManager.this.timeslice_int > tend - tstart) {
                        MapManager.scheduleDelayedJob(this, MapManager.this.timeslice_int - (tend - tstart));
                    } else {
                        MapManager.scheduleDelayedJob(this, 0L);
                    }
                } else {
                    this.cleanup();
                }
            } else {
                this.shutdownRender();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processTile(MapTile tile, long tstart, int parallelcnt) {
            MapChunkCache cache;
            List<DynmapChunk> requiredChunks = tile.getRequiredChunks();
            if (this.cxmin != Integer.MIN_VALUE) {
                boolean good = false;
                for (DynmapChunk c : requiredChunks) {
                    if (c.x < this.cxmin || c.x > this.cxmax || c.z < this.czmin || c.z > this.czmax) continue;
                    good = true;
                    break;
                }
                if (!good) {
                    requiredChunks = Collections.emptyList();
                }
            }
            if ((cache = MapManager.this.core.getServer().createMapChunkCache(this.world, requiredChunks, tile.isBlockTypeDataNeeded(), tile.isHightestBlockYDataNeeded(), tile.isBiomeDataNeeded(), tile.isRawBiomeDataNeeded())) == null) {
                return !this.world.isLoaded();
            }
            MapManager.this.chunk_caches_created.incrementAndGet();
            for (MapChunkCache.ChunkStats cs : MapChunkCache.ChunkStats.values()) {
                MapManager.this.chunks_read[cs.ordinal()].addAndGet(cache.getChunksLoaded(cs));
                MapManager.this.chunks_read_times[cs.ordinal()].addAndGet(cache.getTotalRuntimeNanos(cs));
            }
            if (this.tile0 != null) {
                if (!cache.isEmpty()) {
                    tile.render(cache, null);
                }
            } else {
                MapManager.this.tileQueue.remove(tile);
                if (!cache.isEmpty()) {
                    long rt0 = System.nanoTime();
                    boolean upd = tile.render(cache, this.mapname);
                    this.total_render_ns.addAndGet(System.nanoTime() - rt0);
                    this.rendercalls.incrementAndGet();
                    Object object = lock;
                    synchronized (object) {
                        this.rendered.setFlag(tile.tileOrdinalX(), tile.tileOrdinalY(), true);
                        if (upd || !this.updaterender) {
                            for (MapTile adjTile : this.map.getAdjecentTiles(tile)) {
                                if (this.found.getFlag(adjTile.tileOrdinalX(), adjTile.tileOrdinalY())) continue;
                                this.found.setFlag(adjTile.tileOrdinalX(), adjTile.tileOrdinalY(), true);
                                this.renderQueue.add(adjTile);
                            }
                        }
                    }
                }
                Object object = lock;
                synchronized (object) {
                    if (!cache.isEmpty()) {
                        ++this.rendercnt;
                        this.timeaccum += System.currentTimeMillis() - tstart;
                        if (this.rendercnt % MapManager.this.progressinterval == 0 && !this.quiet) {
                            int rndcalls = this.rendercalls.get();
                            if (rndcalls == 0) {
                                rndcalls = 1;
                            }
                            double rendtime = this.total_render_ns.doubleValue() * 1.0E-6 / (double)rndcalls;
                            double msecpertile = (double)this.timeaccum / (double)this.rendercnt / (double)this.activemapcnt;
                            if (this.activemapcnt > 1) {
                                this.sendMessage(String.format("%s of maps [%s] of '%s' in progress - %d tiles rendered each (%.2f msec/map-tile, %.2f msec per render)", this.rendertype, this.activemaps, this.world.getName(), this.rendercnt, msecpertile, rendtime));
                            } else {
                                this.sendMessage(String.format("%s of map '%s' of '%s' in progress - %d tiles rendered (%.2f msec/tile, %.2f msec per render)", this.rendertype, this.activemaps, this.world.getName(), this.rendercnt, msecpertile, rendtime));
                            }
                        }
                    }
                }
            }
            cache.unloadChunks();
            return true;
        }

        public void cancelRender() {
            this.cancelled = true;
        }

        public void shutdownRender() {
            this.shutdown = true;
            this.cancelRender();
        }

        public void sendMessage(String msg) {
            if (this.sender != null) {
                this.sender.sendMessage(msg);
            } else {
                Log.info(msg);
            }
        }
    }

    private class DynmapScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        DynmapScheduledThreadPoolExecutor() {
            super(3 + MapManager.this.parallelrendercnt);
            this.setThreadFactory(new OurThreadFactory());
            this.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable x) {
            if (r instanceof FullWorldRenderState) {
                ((FullWorldRenderState)r).cleanup();
            }
            if (x != null) {
                Log.severe("Exception during render job: " + r);
                x.printStackTrace();
            }
        }

        @Override
        public void execute(final Runnable r) {
            try {
                super.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            r.run();
                        }
                        catch (Exception x) {
                            Log.severe("Exception during render job: " + r);
                            x.printStackTrace();
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        @Override
        public ScheduledFuture<?> schedule(final Runnable command, long delay, TimeUnit unit) {
            try {
                return super.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            command.run();
                        }
                        catch (Exception x) {
                            Log.severe("Exception during render job: " + command);
                            x.printStackTrace();
                        }
                    }
                }, delay, unit);
            }
            catch (RejectedExecutionException rxe) {
                return null;
            }
        }
    }

    private static class OurThreadFactory
    implements ThreadFactory {
        private OurThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            if (!mapman.usenormalpriority) {
                t.setPriority(1);
            }
            t.setName("Dynmap Render Thread");
            return t;
        }
    }

    private static class TriggerStats {
        long callsmade;
        long callswithtiles;
        long tilesqueued;

        private TriggerStats() {
        }
    }

    private static class MapStats {
        int loggedcnt;
        int renderedcnt;
        int updatedcnt;
        int transparentcnt;

        private MapStats() {
        }
    }

    private static class TouchVolumeEvent {
        int xmin;
        int ymin;
        int zmin;
        int xmax;
        int ymax;
        int zmax;
        String world;
        String reason;

        private TouchVolumeEvent() {
        }
    }

    private static class TouchEvent {
        int x;
        int y;
        int z;
        String world;
        String reason;

        private TouchEvent() {
        }

        public int hashCode() {
            return this.x << 16 ^ this.y << 24 ^ this.z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            TouchEvent te = (TouchEvent)o;
            return this.x == te.x && this.y == te.y && this.z == te.z && this.world.equals(te.world);
        }
    }
}

