/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.packets;

import com.codingforcookies.betterrecords.src.items.TileEntityFrequencyTuner;
import com.codingforcookies.betterrecords.src.items.TileEntityRecordEtcher;
import com.codingforcookies.betterrecords.src.packets.IPacket;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class PacketURLWriter
implements IPacket {
    int x;
    int y;
    int z;
    int size;
    int color = -999;
    String name;
    String url;
    String localName;
    String author;

    public PacketURLWriter() {
    }

    public PacketURLWriter(int x, int y, int z, String name, String url, String localName, int size) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.url = url;
        this.localName = localName;
        this.size = size;
    }

    public PacketURLWriter(int x, int y, int z, String name, String url, String localName, int size, int color, String author) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.url = url;
        this.localName = localName;
        this.size = size;
        this.color = color;
        this.author = author;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        String recieved = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        String[] str = recieved.split("\u00a77");
        this.x = Integer.parseInt(str[0]);
        this.y = Integer.parseInt(str[1]);
        this.z = Integer.parseInt(str[2]);
        this.name = str[3];
        this.url = str[4];
        this.localName = str[5];
        this.size = Integer.parseInt(str[6]);
        if (str.length > 7) {
            this.color = Integer.parseInt(str[7]);
            this.author = str[8];
        }
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)(this.x + "\u00a77" + this.y + "\u00a77" + this.z + "\u00a77" + this.name + "\u00a77" + this.url + "\u00a77" + this.localName + "\u00a77" + this.size + (this.color != -999 ? "\u00a77" + this.color + "\u00a77" + this.author : "")));
    }

    @Override
    public void executeClient(EntityPlayer player) {
    }

    @Override
    public void executeServer(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (te == null || !(te instanceof TileEntityRecordEtcher) && !(te instanceof TileEntityFrequencyTuner)) {
            return;
        }
        if (te instanceof TileEntityRecordEtcher) {
            TileEntityRecordEtcher tileEntityRecordEtcher = (TileEntityRecordEtcher)te;
            ItemStack itemStack = tileEntityRecordEtcher.record;
            if (itemStack != null) {
                if (itemStack.field_77990_d == null) {
                    itemStack.field_77990_d = new NBTTagCompound();
                }
                itemStack.field_77990_d.func_74778_a("name", this.name);
                itemStack.field_77990_d.func_74778_a("url", this.url);
                itemStack.field_77990_d.func_74778_a("local", this.localName);
                itemStack.field_77990_d.func_74768_a("size", this.size);
                if (this.color != -999) {
                    itemStack.field_77990_d.func_74768_a("color", this.color);
                    itemStack.field_77990_d.func_74778_a("author", this.author);
                }
                player.field_70170_p.func_147471_g(this.x, this.y, this.z);
            }
        } else if (te instanceof TileEntityFrequencyTuner) {
            TileEntityFrequencyTuner tileEntityFrequencyTuner = (TileEntityFrequencyTuner)te;
            ItemStack itemStack = tileEntityFrequencyTuner.crystal;
            if (itemStack != null) {
                if (itemStack.field_77990_d == null) {
                    itemStack.field_77990_d = new NBTTagCompound();
                }
                itemStack.field_77990_d.func_74778_a("url", this.url);
                itemStack.field_77990_d.func_74778_a("local", this.localName);
                if (this.color != -999) {
                    itemStack.field_77990_d.func_74768_a("color", this.color);
                }
                player.field_70170_p.func_147471_g(this.x, this.y, this.z);
            }
        }
    }
}

