/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.packets;

import com.codingforcookies.betterrecords.src.client.sound.Sound;
import com.codingforcookies.betterrecords.src.client.sound.SoundHandler;
import com.codingforcookies.betterrecords.src.packets.IPacket;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketRecordPlayerPlay
implements IPacket {
    int x;
    int y;
    int z;
    int dimension;
    float playRadius;
    boolean repeat;
    boolean shuffle;
    List<Sound> sounds = null;

    public PacketRecordPlayerPlay() {
    }

    public PacketRecordPlayerPlay(int x, int y, int z, float playRadius, int dimension, String name, String url, String local, boolean repeat, boolean shuffle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.playRadius = playRadius;
        this.dimension = dimension;
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.sounds = new ArrayList<Sound>();
        this.sounds.add(new Sound().setInfo(name, url, local));
    }

    public PacketRecordPlayerPlay(int x, int y, int z, float playRadius, int dimension, NBTTagCompound nbt, boolean repeat, boolean shuffle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.playRadius = playRadius;
        this.dimension = dimension;
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.sounds = new ArrayList<Sound>();
        NBTTagList songList = nbt.func_150295_c("songs", 10);
        for (int i = 0; i < songList.func_74745_c(); ++i) {
            this.sounds.add(new Sound().setInfo(songList.func_150305_b(i).func_74779_i("name"), songList.func_150305_b(i).func_74779_i("url"), songList.func_150305_b(i).func_74779_i("local")));
        }
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        String recieved = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        String[] str = recieved.split("\u00a77");
        this.x = Integer.parseInt(str[0]);
        this.y = Integer.parseInt(str[1]);
        this.z = Integer.parseInt(str[2]);
        this.playRadius = Float.parseFloat(str[3]);
        this.dimension = Integer.parseInt(str[4]);
        this.repeat = Boolean.parseBoolean(str[5]);
        this.shuffle = Boolean.parseBoolean(str[6]);
        this.sounds = new ArrayList<Sound>();
        for (String strr : str[7].split("\u00a78")) {
            Sound snd = Sound.fromString(strr);
            snd.x = this.x;
            snd.y = this.y;
            snd.z = this.z;
            snd.dimension = this.dimension;
            snd.playRadius = this.playRadius;
            this.sounds.add(snd);
        }
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        String sndStr = "";
        if (this.sounds != null) {
            for (Sound snd : this.sounds) {
                sndStr = sndStr + snd.toString() + "\u00a78";
            }
        }
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)(this.x + "\u00a77" + this.y + "\u00a77" + this.z + "\u00a77" + this.playRadius + "\u00a77" + this.dimension + "\u00a77" + this.repeat + "\u00a77" + this.shuffle + "\u00a77" + sndStr.substring(0, sndStr.length() - 2)));
    }

    @Override
    public void executeClient(EntityPlayer player) {
        if (this.playRadius > 100000.0f || (float)Math.abs(Math.sqrt(Math.pow(player.field_70165_t - (double)this.x, 2.0) + Math.pow(player.field_70163_u - (double)this.y, 2.0) + Math.pow(player.field_70161_v - (double)this.z, 2.0))) < this.playRadius) {
            SoundHandler.playSound(this.x, this.y, this.z, this.dimension, this.playRadius, this.sounds, this.repeat, this.shuffle);
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
    }
}

