/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.client.sound;

import com.codingforcookies.betterrecords.src.client.sound.Sound;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SoundManager {
    public boolean repeat = false;
    public boolean shuffle = false;
    public int current = -1;
    public List<Sound> songs = new ArrayList<Sound>();
    public List<Integer> completedSongs = new ArrayList<Integer>();
    private final Random rand;

    public SoundManager(boolean repeat, boolean shuffle) {
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.rand = new Random();
    }

    public SoundManager(Sound sound, boolean repeat, boolean shuffle) {
        this.songs.add(sound);
        this.repeat = repeat;
        this.shuffle = shuffle;
        this.rand = new Random();
    }

    public Sound getCurrentSong() {
        return this.current == -1 ? null : (this.current < this.songs.size() ? this.songs.get(this.current) : null);
    }

    public void addSong(Sound sound) {
        this.songs.add(sound);
    }

    public Sound nextSong() {
        if (this.shuffle && this.current != -1) {
            this.completedSongs.add(this.current);
        }
        if (this.shuffle && this.completedSongs.size() > 0 && this.completedSongs.size() < this.songs.size()) {
            while (this.completedSongs.contains(this.current)) {
                this.current = this.rand.nextInt(this.songs.size());
            }
        } else {
            ++this.current;
        }
        if (this.current >= this.songs.size() && this.repeat) {
            this.completedSongs.clear();
            for (Sound s : this.songs) {
                s.volume = null;
            }
            this.current = this.shuffle ? this.rand.nextInt(this.songs.size()) : 0;
        }
        return this.getCurrentSong();
    }
}

