/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.client.sound;

import com.codingforcookies.betterrecords.src.BetterUtils;
import com.codingforcookies.betterrecords.src.ClasspathInjector;
import com.codingforcookies.betterrecords.src.betterenums.IRecordAmplitude;
import com.codingforcookies.betterrecords.src.betterenums.IRecordWireHome;
import com.codingforcookies.betterrecords.src.betterenums.RecordConnection;
import com.codingforcookies.betterrecords.src.client.ClientProxy;
import com.codingforcookies.betterrecords.src.client.sound.FileDownloader;
import com.codingforcookies.betterrecords.src.client.sound.IcyURLConnection;
import com.codingforcookies.betterrecords.src.client.sound.Sound;
import com.codingforcookies.betterrecords.src.client.sound.SoundManager;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class SoundHandler {
    public static File soundLocation;
    public static HashMap<String, File> soundList;
    public static HashMap<String, SoundManager> soundPlaying;
    public static boolean downloadSongs;
    public static int streamBuffer;
    public static boolean streamRadio;
    public static String nowPlaying;
    public static long nowPlayingEnd;
    public static int nowPlayingInt;

    public static void initalize() {
        File libs = new File(Minecraft.func_71410_x().field_71412_D, "betterrecords/libs");
        libs.mkdirs();
        if (!new File(libs, "vorbisspi-1.0.3-1.jar").exists()) {
            FileDownloader.downloadFile("vorbisspi-1.0.3-1.jar", "https://raw.githubusercontent.com/stumblinbear/Versions/master/betterrecords/libs/vorbisspi-1.0.3-1.jar", "vorbisspi-1.0.3-1", libs);
        }
        if (!new File(libs, "tritonus-share-0.3.7-2.jar").exists()) {
            FileDownloader.downloadFile("tritonus-share-0.3.7-2.jar", "https://raw.githubusercontent.com/stumblinbear/Versions/master/betterrecords/libs/tritonus-share-0.3.7-2.jar", "tritonus-share-0.3.7-2.", libs);
        }
        if (!new File(libs, "mp3spi1.9.5.jar").exists()) {
            FileDownloader.downloadFile("mp3spi1.9.5.jar", "https://raw.githubusercontent.com/stumblinbear/Versions/master/betterrecords/libs/mp3spi1.9.5.jar", "mp3spi1.9.5", libs);
        }
        if (!new File(libs, "mp3plugin.jar").exists()) {
            FileDownloader.downloadFile("mp3plugin.jar", "https://raw.githubusercontent.com/stumblinbear/Versions/master/betterrecords/libs/mp3plugin.jar", "mp3plugin", libs);
        }
        SoundHandler.loadLibrary(new File(libs, "vorbisspi-1.0.3-1.jar"));
        SoundHandler.loadLibrary(new File(libs, "tritonus-share-0.3.7-2.jar"));
        SoundHandler.loadLibrary(new File(libs, "mp3spi1.9.5.jar"));
        SoundHandler.loadLibrary(new File(libs, "mp3plugin.jar"));
        soundLocation = new File(Minecraft.func_71410_x().field_71412_D, "betterrecords/cache");
        soundList = new HashMap();
        soundPlaying = new HashMap();
        if (!soundLocation.mkdirs()) {
            for (File sound : soundLocation.listFiles()) {
                System.out.println("Loaded " + sound.getName());
                soundList.put(sound.getName(), sound);
            }
        }
        System.out.println("Loaded sound cache of " + soundList.size() + " sounds.");
    }

    private static void loadLibrary(File file) {
        System.out.println("Injecting library " + file.getName() + ".");
        try {
            ((ModClassLoader)Loader.instance().getModClassLoader()).addFile(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to load library, trying another method: " + file.getName());
            try {
                ClasspathInjector.addFile(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void playSound(int x, int y, int z, int dimension, float playRadius, List<Sound> sounds, boolean repeat, boolean shuffle) {
        SoundHandler.playSound(x, y, z, dimension, playRadius, sounds, repeat, shuffle, 0);
    }

    private static void obtainSound(final SoundManager manager, final int songIndex) {
        soundList.put(manager.songs.get((int)songIndex).name, new File(soundLocation, manager.songs.get((int)songIndex).name));
        new Thread(){

            @Override
            public void run() {
                if (!FileDownloader.downloadFile(soundLocation, manager, songIndex)) {
                    soundList.remove(manager.songs.get((int)songIndex).name);
                } else {
                    SoundHandler.playSound(manager, songIndex);
                }
            }
        }.start();
    }

    protected static void playSound(SoundManager manager, int songIndex) {
        if (songIndex == -1) {
            SoundHandler.playSound(manager.songs.get((int)0).x, manager.songs.get((int)0).y, manager.songs.get((int)0).z, manager.songs.get((int)0).dimension, manager.songs.get((int)0).playRadius, manager.songs, manager.repeat, manager.shuffle, -1);
        } else {
            SoundHandler.playSound(manager.songs.get((int)songIndex).x, manager.songs.get((int)songIndex).y, manager.songs.get((int)songIndex).z, manager.songs.get((int)songIndex).dimension, manager.songs.get((int)songIndex).playRadius, manager.songs, manager.repeat, manager.shuffle, songIndex);
        }
    }

    private static void playSound(int x, int y, int z, int dimension, float playRadius, List<Sound> sounds, boolean repeat, boolean shuffle, int songIndex) {
        if (songIndex >= 0) {
            SoundManager sndMgr = null;
            if (soundPlaying.get(x + "," + y + "," + z + "," + dimension) == null) {
                sndMgr = new SoundManager(repeat, shuffle);
                sndMgr.songs = sounds;
                soundPlaying.put(x + "," + y + "," + z + "," + dimension, sndMgr);
            } else {
                sndMgr = soundPlaying.get(x + "," + y + "," + z + "," + dimension);
            }
            for (int i = songIndex; i < sounds.size(); ++i) {
                if (!soundList.containsKey(sounds.get((int)i).name)) {
                    if (downloadSongs) {
                        if (FileDownloader.isDownloading) {
                            System.err.println("Song downloading... Please wait...");
                            nowPlaying = BetterUtils.getTranslatedString("overlay.nowplaying.error1");
                            nowPlayingEnd = System.currentTimeMillis() + 5000L;
                            return;
                        }
                        SoundHandler.obtainSound(sndMgr, i);
                    }
                    return;
                }
                if (!soundList.get(sounds.get((int)i).name).exists()) {
                    System.err.println("Sound exists in hashmap, but not in file. Reloading cache...");
                    soundList.clear();
                    if (!soundLocation.mkdirs()) {
                        for (File soundFile : soundLocation.listFiles()) {
                            System.out.println("Loaded " + soundFile.getName());
                            soundList.put(soundFile.getName(), soundFile);
                        }
                    }
                    --i;
                    continue;
                }
                if (i != 0) continue;
                SoundHandler.tryToStart(x, y, z, dimension);
                if (sounds.size() != 1) continue;
                return;
            }
        }
        SoundHandler.tryToStart(x, y, z, dimension);
    }

    private static void tryToStart(final int x, final int y, final int z, final int dimension) {
        if (soundPlaying.get(x + "," + y + "," + z + "," + dimension) != null && SoundHandler.soundPlaying.get((Object)new StringBuilder().append((int)x).append((String)",").append((int)y).append((String)",").append((int)z).append((String)",").append((int)dimension).toString()).current == -1) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Sound snd = null;
                    if (SoundHandler.soundPlaying.get((Object)new StringBuilder().append((int)x).append((String)",").append((int)y).append((String)",").append((int)z).append((String)",").append((int)dimension).toString()).current != -1) {
                        return;
                    }
                    while (soundPlaying.get(x + "," + y + "," + z + "," + dimension) != null && (snd = soundPlaying.get(x + "," + y + "," + z + "," + dimension).nextSong()) != null) {
                        nowPlaying = snd.local;
                        nowPlayingEnd = System.currentTimeMillis() + 5000L;
                        SoundHandler.playSourceDataLine(snd, x, y, z, dimension, BetterSoundType.SONG, new File(soundLocation, snd.name));
                    }
                    soundPlaying.remove(x + "," + y + "," + z + "," + dimension);
                }
            }).start();
        }
    }

    public static void playSoundFromStream(final int x, final int y, final int z, final int dimension, float playRadius, final String localName, final String url) {
        if (!streamRadio) {
            return;
        }
        soundPlaying.put(x + "," + y + "," + z + "," + dimension, new SoundManager(new Sound(x, y, z, dimension, playRadius).setInfo("", url, localName), false, false));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("Connection to stream " + localName + "...");
                    Sound snd = soundPlaying.get(x + "," + y + "," + z + "," + dimension).nextSong();
                    IcyURLConnection urlConn = new IcyURLConnection(new URL(url.startsWith("http") ? url : "http://" + url));
                    urlConn.setInstanceFollowRedirects(true);
                    urlConn.connect();
                    SoundHandler.playSourceDataLine(snd, x, y, z, dimension, BetterSoundType.RADIO, new BufferedInputStream(urlConn.getInputStream()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Failed to stream: " + url);
                    nowPlaying = BetterUtils.getTranslatedString("overlay.nowplaying.error2");
                    nowPlayingEnd = System.currentTimeMillis() + 5000L;
                }
                soundPlaying.remove(x + "," + y + "," + z + "," + dimension);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void playSourceDataLine(Sound snd, int x, int y, int z, int dimension, BetterSoundType type, Object object) {
        try {
            AudioInputStream in = object instanceof File ? SoundHandler.convertToPCM(AudioSystem.getAudioInputStream((File)object)) : (object instanceof BufferedInputStream ? SoundHandler.convertToPCM(AudioSystem.getAudioInputStream((BufferedInputStream)object)) : SoundHandler.convertToPCM((AudioInputStream)object));
            AudioFormat outFormat = SoundHandler.getOutFormat(in.getFormat());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, outFormat);
            System.out.println("Playing " + snd.name + ": " + new File(soundLocation, snd.name).getAbsolutePath());
            try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
                if (line != null) {
                    line.open(outFormat);
                    if (snd.volume == null) {
                        snd.volume = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                        snd.volume.setValue(-20.0f);
                    }
                    line.start();
                    SoundHandler.stream(AudioSystem.getAudioInputStream(outFormat, in), line, x, y, z, dimension, type);
                    line.drain();
                    line.stop();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            switch (type) {
                case SONG: {
                    nowPlaying = BetterUtils.getTranslatedString("overlay.nowplaying.error3");
                    System.err.println("Could not read file: Local: " + snd.local + " File: " + snd.name);
                    break;
                }
                case RADIO: {
                    nowPlaying = BetterUtils.getTranslatedString("overlay.nowplaying.error2");
                    System.err.println("Failed to stream: URL: " + snd.url);
                    break;
                }
            }
            nowPlayingEnd = System.currentTimeMillis() + 5000L;
        }
    }

    private static AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private static void stream(AudioInputStream in, SourceDataLine line, int x, int y, int z, int dimension, BetterSoundType soundType) throws IOException {
        byte[] buffer = new byte[streamBuffer];
        int n = 0;
        while (n != -1) {
            while (Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r.func_73868_f()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (soundPlaying.get(x + "," + y + "," + z + "," + dimension) == null || soundType == BetterSoundType.RADIO && !streamRadio) {
                return;
            }
            SoundHandler.updateAmplitude(buffer, x, y, z, dimension);
            line.write(buffer, 0, n);
            n = in.read(buffer, 0, buffer.length);
        }
        SoundHandler.updateAmplitude(null, x, y, z, dimension);
    }

    private static void updateAmplitude(byte[] buffer, int x, int y, int z, int dimension) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != dimension) {
            return;
        }
        float unscaledTreble = -1.0f;
        float unscaledBass = -1.0f;
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof IRecordWireHome) {
            ((IRecordWireHome)tileEntity).addTreble(SoundHandler.getUnscaledWaveform(buffer, true, false));
            ((IRecordWireHome)tileEntity).addBass(SoundHandler.getUnscaledWaveform(buffer, false, false));
            for (RecordConnection con : ((IRecordWireHome)tileEntity).getConnections()) {
                if (buffer == null) {
                    return;
                }
                TileEntity tileEntityCon = Minecraft.func_71410_x().field_71441_e.func_147438_o(con.x2, con.y2, con.z2);
                if (tileEntityCon == null || !(tileEntityCon instanceof IRecordAmplitude)) continue;
                if (unscaledTreble == -1.0f || unscaledBass == 11.0f) {
                    unscaledTreble = SoundHandler.getUnscaledWaveform(buffer, true, true);
                    unscaledBass = SoundHandler.getUnscaledWaveform(buffer, false, true);
                }
                ((IRecordAmplitude)tileEntityCon).setTreble(unscaledTreble);
                ((IRecordAmplitude)tileEntityCon).setBass(unscaledBass);
            }
        }
    }

    public static float getUnscaledWaveform(byte[] eightBitByteArray, boolean high, boolean control) {
        if (eightBitByteArray != null) {
            int audioByte;
            int[] toReturn = new int[eightBitByteArray.length / 2];
            float avg = 0.0f;
            int index = 0;
            int n = audioByte = high ? 1 : 0;
            while (audioByte < eightBitByteArray.length) {
                toReturn[index] = eightBitByteArray[audioByte];
                avg += (float)toReturn[index];
                ++index;
                audioByte += 2;
            }
            avg /= (float)toReturn.length;
            if (control) {
                if (avg < 0.0f) {
                    avg = Math.abs(avg);
                }
                if (avg > 20.0f) {
                    return ClientProxy.flashyMode < 3 ? 10.0f : 20.0f;
                }
                return (int)(avg * (ClientProxy.flashyMode < 3 ? 1.0f : 2.0f));
            }
            return avg;
        }
        return 0.0f;
    }

    private static int getSixteenBitSample(int high, int low) {
        return (high << 8) + (low & 0xFF);
    }

    private static AudioInputStream convertToPCM(AudioInputStream audioInputStream) {
        AudioFormat format = audioInputStream.getFormat();
        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED && format.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), format.isBigEndian());
            audioInputStream = AudioSystem.getAudioInputStream(targetFormat, audioInputStream);
        }
        return audioInputStream;
    }

    static {
        downloadSongs = true;
        streamBuffer = 256;
        streamRadio = true;
        nowPlaying = "";
        nowPlayingEnd = 0L;
        nowPlayingInt = 0;
    }

    private static enum BetterSoundType {
        SONG,
        RADIO;

    }
}

