/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.client.sound;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IcyURLConnection
extends HttpURLConnection {
    protected Socket socket;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected HashMap<String, List<String>> requestProps;
    protected HashMap<String, List<String>> headers;
    protected String responseLine;

    public IcyURLConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.socket = this.createSocket();
        this.socket.connect(new InetSocketAddress(this.url.getHost(), this.url.getPort() != -1 ? this.url.getPort() : this.url.getDefaultPort()), this.getConnectTimeout());
        Map<String, List<String>> requestProps = this.getRequestProperties();
        this.connected = true;
        this.headers = new HashMap();
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
        this.writeLine("GET " + ("".equals(this.url.getPath()) ? "/" : this.url.getPath()) + " HTTP/1.1");
        this.writeLine("Host: " + this.url.getHost());
        if (requestProps != null) {
            for (Map.Entry<String, List<String>> entry : requestProps.entrySet()) {
                for (String val : entry.getValue()) {
                    this.writeLine(entry.getKey() + ": " + val);
                }
            }
        }
        this.writeLine("");
        this.responseLine = this.readResponseLine();
        String line = this.readLine();
        while (line != null && line.length() != 0) {
            this.parseHeaderLine(line);
            line = this.readLine();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public String getHeaderField(String name) {
        List<String> list;
        HashMap<String, List<String>> lmap = this.headers;
        if (lmap != null && (list = lmap.get(name)) != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public String getHeaderField(int n) {
        return n == 0 ? this.responseLine : null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public synchronized void setRequestProperty(String key, String value) {
        if (this.requestProps == null) {
            this.requestProps = new HashMap();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.requestProps.put(key, list);
    }

    @Override
    public synchronized void addRequestProperty(String key, String value) {
        List<String> list;
        if (this.requestProps == null) {
            this.requestProps = new HashMap();
        }
        if ((list = this.requestProps.get(key)) == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        this.requestProps.put(key, list);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.requestProps;
    }

    @Override
    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.inputStream = null;
        this.outputStream = null;
        this.headers = null;
        this.responseLine = null;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    protected Socket createSocket() {
        return new Socket();
    }

    protected void parseHeaderLine(String line) throws IOException {
        int len = 2;
        int n = line.indexOf(": ");
        if (n == -1) {
            len = 1;
            n = line.indexOf(58);
            if (n == -1) {
                return;
            }
        }
        String key = line.substring(0, n);
        String val = line.substring(n + len);
        List<String> list = this.headers.get(key);
        if (list != null) {
            list.add(val);
        } else {
            list = new ArrayList<String>();
            list.add(val);
            this.headers.put(key, list);
        }
    }

    protected String readResponseLine() throws IOException {
        int n;
        String line = this.readLine();
        if (line != null && (n = line.indexOf(32)) != -1) {
            line = "HTTP/1.0" + line.substring(n);
        }
        return line;
    }

    protected String readLine() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.inputStream.read()) != -1) {
            if (c == 13) continue;
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected void writeLine(String line) throws IOException {
        line = line + '\r';
        line = line + '\n';
        this.outputStream.write(line.getBytes("UTF-8"));
    }
}

