/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.client.sound;

import com.codingforcookies.betterrecords.src.client.ClientProxy;
import com.codingforcookies.betterrecords.src.client.sound.Sound;
import com.codingforcookies.betterrecords.src.client.sound.SoundHandler;
import com.codingforcookies.betterrecords.src.client.sound.SoundManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public class FileDownloader {
    public static String nowDownloading = "";
    public static float downloadPercent = 0.0f;
    public static boolean isDownloading = false;

    public static boolean downloadFile(File saveLoc, final SoundManager manager, final int songIndex) {
        if (isDownloading) {
            return false;
        }
        Sound sound = manager.songs.get(songIndex);
        return FileDownloader.downloadFile(sound.name, sound.url, sound.local, saveLoc, new DownloadInfo(){
            private boolean started = false;

            @Override
            public void onDownloading(String local, float percent) {
                if (songIndex == 0 && ClientProxy.playWhileDownload && !this.started && downloadPercent > 0.05f) {
                    this.started = true;
                    SoundHandler.playSound(manager, -1);
                }
            }

            @Override
            public void onFileTooLarge(String local) {
                SoundHandler.nowPlaying = "Error: " + local + " is over download limit!";
                SoundHandler.nowPlayingEnd = System.currentTimeMillis() + 5000L;
            }

            @Override
            public void onGeneralFailure(String local) {
                SoundHandler.nowPlaying = "Error: General download error for " + local;
                SoundHandler.nowPlayingEnd = System.currentTimeMillis() + 5000L;
            }
        });
    }

    public static boolean downloadFile(String name, String urlLocation, String localName, File saveLoc) {
        return FileDownloader.downloadFile(name, urlLocation, localName, saveLoc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean downloadFile(String name, String urlLocation, String localName, File saveLoc, DownloadInfo dwnloadNfo) {
        urlLocation = urlLocation.replace(" ", "%20");
        System.err.println("Downloading " + name + " from " + urlLocation + "...");
        isDownloading = true;
        nowDownloading = localName;
        downloadPercent = 0.0f;
        BufferedInputStream in = null;
        FileOutputStream out = null;
        URL url = null;
        try {
            int count;
            url = new URL(urlLocation);
            URLConnection conn = url.openConnection();
            int size = conn.getContentLength();
            if (size / 1024 / 1024 > (ClientProxy.downloadMax != 100 ? ClientProxy.downloadMax : 102400)) {
                System.err.println("File larger than configured max size!");
                if (dwnloadNfo != null) {
                    dwnloadNfo.onFileTooLarge(localName);
                }
                boolean bl = false;
                return bl;
            }
            in = new BufferedInputStream(url.openStream());
            out = new FileOutputStream(new File(saveLoc, name));
            byte[] data = new byte[1024];
            float sumCount = 0.0f;
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
                sumCount += (float)count;
                isDownloading = true;
                nowDownloading = localName;
                if (size > 0) {
                    downloadPercent = sumCount / (float)size;
                }
                if (dwnloadNfo == null) continue;
                dwnloadNfo.onDownloading(localName, downloadPercent);
            }
            isDownloading = false;
            nowDownloading = "";
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (dwnloadNfo != null) {
                dwnloadNfo.onGeneralFailure(localName);
            }
            System.err.println("Failed to download: " + localName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Failed to close inputstream while downloading: " + localName + "\u00a7" + urlLocation);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Failed to close outputstream while downloading: " + localName + "\u00a7" + urlLocation);
                }
            }
        }
        isDownloading = false;
        nowDownloading = "";
        return false;
    }

    private static abstract class DownloadInfo {
        private DownloadInfo() {
        }

        public abstract void onDownloading(String var1, float var2);

        public abstract void onFileTooLarge(String var1);

        public abstract void onGeneralFailure(String var1);
    }
}

