/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src.betterenums;

import com.codingforcookies.betterrecords.src.BetterRecords;
import com.codingforcookies.betterrecords.src.betterenums.IRecordWire;
import com.codingforcookies.betterrecords.src.betterenums.IRecordWireHome;
import com.codingforcookies.betterrecords.src.betterenums.RecordConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ConnectionHelper {
    public static String serializeConnections(ArrayList<RecordConnection> rec) {
        if (rec.size() == 0) {
            return "";
        }
        String ret = "";
        for (RecordConnection recc : rec) {
            ret = ret + recc.toString() + "]";
        }
        return ret.substring(0, ret.length() - 1);
    }

    public static ArrayList<RecordConnection> unserializeConnections(String rec) {
        if (rec.trim().equals("")) {
            return new ArrayList<RecordConnection>();
        }
        String[] recc = rec.split("]");
        ArrayList<RecordConnection> ret = new ArrayList<RecordConnection>();
        for (String str : recc) {
            ret.add(new RecordConnection(str));
        }
        return ret;
    }

    public static String serializeWireSystemInfo(HashMap<String, Integer> wireSystemInfo) {
        if (wireSystemInfo.size() == 0) {
            return "";
        }
        String ret = "";
        for (Map.Entry<String, Integer> entry : wireSystemInfo.entrySet()) {
            ret = ret + entry.getKey() + "," + entry.getValue() + "]";
        }
        return ret.substring(0, ret.length() - 1);
    }

    public static HashMap<String, Integer> unserializeWireSystemInfo(String wireSystemInfo) {
        if (wireSystemInfo.trim().equals("")) {
            return new HashMap<String, Integer>();
        }
        String[] wsi = wireSystemInfo.split("]");
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String str : wsi) {
            String[] split = str.split(",");
            ret.put(split[0], Integer.parseInt(split[1]));
        }
        return ret;
    }

    public static void addConnection(World world, IRecordWire iRecordWire, RecordConnection rec) {
        for (int i = 0; i < iRecordWire.getConnections().size(); ++i) {
            if (!iRecordWire.getConnections().get(i).same(rec)) continue;
            return;
        }
        iRecordWire.getConnections().add(rec);
        world.func_147471_g(((TileEntity)iRecordWire).field_145851_c, ((TileEntity)iRecordWire).field_145848_d, ((TileEntity)iRecordWire).field_145849_e);
        TileEntity te = world.func_147438_o(rec.x1, rec.y1, rec.z1);
        if (te != null && te instanceof IRecordWireHome && te != iRecordWire) {
            ((IRecordWireHome)te).increaseAmount(iRecordWire);
            world.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    public static void removeConnection(World world, IRecordWire iRecordWire, RecordConnection rec) {
        for (int i = 0; i < iRecordWire.getConnections().size(); ++i) {
            if (!iRecordWire.getConnections().get(i).same(rec)) continue;
            TileEntity te = world.func_147438_o(iRecordWire.getConnections().get((int)i).x1, iRecordWire.getConnections().get((int)i).y1, iRecordWire.getConnections().get((int)i).z1);
            if (te != null && te instanceof IRecordWireHome && te != iRecordWire) {
                ((IRecordWireHome)te).decreaseAmount(iRecordWire);
                world.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
                Random rand = new Random();
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(world, (double)((float)te.field_145851_c + rx), (double)((float)te.field_145848_d + ry), (double)((float)te.field_145849_e + rz), new ItemStack((Item)BetterRecords.itemRecordWire));
                entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
                entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
                entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
                world.func_72838_d((Entity)entityItem);
                ConnectionHelper.removeConnection(world, (IRecordWire)te, rec);
            }
            iRecordWire.getConnections().remove(i);
            break;
        }
    }

    public static void clearConnections(World world, IRecordWire iRecordWire) {
        while (iRecordWire.getConnections().size() != 0) {
            RecordConnection rec = iRecordWire.getConnections().get(0);
            TileEntity te = world.func_147438_o(rec.x1, rec.y1, rec.z1);
            if (te != null && te instanceof IRecordWire) {
                ConnectionHelper.removeConnection(world, iRecordWire, rec);
                continue;
            }
            System.err.println("Warning on clearing connections: Attached block is not a member of IRecordWire! This may cause ghost connections until a relog!");
            iRecordWire.getConnections().remove(0);
        }
        world.func_147471_g(((TileEntity)iRecordWire).field_145851_c, ((TileEntity)iRecordWire).field_145848_d, ((TileEntity)iRecordWire).field_145849_e);
    }
}

