/*
 * Decompiled with CFR 0.152.
 */
package com.codingforcookies.betterrecords.src;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;

public class CurseModInfo {
    private String title;
    private String game;
    private String category;
    private String url;
    private String thumbnail;
    private String[] authors;
    private int favorites;
    private int likes;
    private String updated_at;
    private String created_at;
    private String project_url;
    private String release_type;
    private String license;
    private VersionInfo download;
    private Map<String, VersionInfo[]> versions;
    private static Gson gson = new Gson();

    public static CurseModInfo fromURL(URL url) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        return (CurseModInfo)gson.fromJson((Reader)reader, CurseModInfo.class);
    }

    public VersionInfo[] getVersions(String mcVersion) {
        return this.versions.get(mcVersion);
    }

    public VersionInfo getNewestVersion(String mcVersion) {
        VersionInfo newest = null;
        for (VersionInfo versionInfo : this.getVersions(mcVersion)) {
            if (newest != null && versionInfo.getId() <= newest.getId()) continue;
            newest = versionInfo;
        }
        return newest;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGame() {
        return this.game;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUrl() {
        return this.url;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public int getFavorites() {
        return this.favorites;
    }

    public int getLikes() {
        return this.likes;
    }

    public String getUpdated_at() {
        return this.updated_at;
    }

    public String getCreated_at() {
        return this.created_at;
    }

    public String getProject_url() {
        return this.project_url;
    }

    public String getRelease_type() {
        return this.release_type;
    }

    public String getLicense() {
        return this.license;
    }

    public VersionInfo getDownload() {
        return this.download;
    }

    public class VersionInfo {
        private int id;
        private String url;
        private String name;
        private String type;
        private String version;
        private int downloads;
        private String created_at;

        public String getModVersion() {
            return this.name.toLowerCase().replaceAll("betterrecords-|.jar", "");
        }

        public int getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getMinecraftVersion() {
            return this.version;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getCreated_at() {
            return this.created_at;
        }
    }
}

