--[[
    Prop Hunt Mod
    Made by: Mr. Bushido aka One Piece lover aka

    This mod is a prop hunt mod. The player tursn into a prop and hides from the hunter.
    The hunter(s) must find all the props before the time limit to win.
    When a prop is caught, they turn into a hunter

    [ PROP INNERWORKINGS ]
    - When a prop is picked, it will spawn that prop in the same location as the player.
    - The player will be invisible and invincible, but they will be able to move around.
    - The prop actor will be warped to the players position every frame.

    [ TODO ]
    - You name it
]]

local function bprint(type, message)
    if type == "Error" then
        print("\27[31m" .. "[Error]: " .. message .. "\27[0m")
    elseif type == "Debug" then
        print("\27[90m" .. "[Debug]: " .. message .. "\27[0m")
    elseif type == "Success" then
        print("\27[32m" .. "[Prop Hunt]: " .. message .. "\27[0m")
    elseif type == "Server" then
        print("\27[34m" .. "[Server]: " .. message .. "\27[0m")
    elseif type == "Info" then
        print("\27[37m" .. "[Info]: " .. message .. "\27[0m")
    end
end


--[[
#
    SETUP
#
]]
local
hook_on_sync_table_change, network_is_server,
hook_event, djui_popup_create, network_get_player_text_color_string, play_sound,
djui_chat_message_create, djui_hud_set_resolution, djui_hud_set_font,
djui_hud_set_color, djui_hud_render_rect, djui_hud_print_text, djui_hud_get_screen_width, djui_hud_get_screen_height,
djui_hud_measure_text, tostring, warp_to_level, warp_to_start_level, stop_cap_music, dist_between_objects,
math_floor, math_ceil, table_insert, set_camera_mode, table_unpack, table_remove
=
hook_on_sync_table_change, network_is_server,
hook_event, djui_popup_create, network_get_player_text_color_string, play_sound,
djui_chat_message_create, djui_hud_set_resolution, djui_hud_set_font,
djui_hud_set_color, djui_hud_render_rect, djui_hud_print_text, djui_hud_get_screen_width, djui_hud_get_screen_height,
djui_hud_measure_text, tostring, warp_to_level, warp_to_start_level, stop_cap_music, dist_between_objects,
math.floor, math.ceil, table.insert, set_camera_mode, table.unpack, table.remove

-- States
local GAME_STATES = { WAITING = 0, HEAD_START = 1, HEAD_START_PROP = 2, PLAYING = 3, PROP_HUNT_WIN = 4, HUNTERS_WIN = 5 }

-- Globals
gGlobalSyncTable.roundState = GAME_STATES.WAITING
gGlobalSyncTable.displayTimer = 0
gGlobalSyncTable.count_down_began = false
gGlobalSyncTable.markStartMatch = false
gGlobalSyncTable.selected_prop_id = 0
gGlobalSyncTable.selected_level = 12
gGlobalSyncTable.prop_mode = 0  -- 0 = Smart, 1 = Frantic
gGlobalSyncTable.ohGodIHopeThisWorks = 0
gGlobalSyncTable.open_world = false
gGlobalSyncTable.force_stop = false

-- Settings
gServerSettings.bubbleDeath = 0

-- Game Variables
local network_player = gNetworkPlayers[0] -- Index 0 is always local player
local server_timer = 0
local grace_period = 60 * 30  -- 60 seconds
local sRoundEndTimeout   = 3 * 60 * 30  -- 3 minutes
local resetTimeout = 5 * 30  -- 5 seconds
local flash_index = 0
local flag_start_match = false
local prop = {}
local selected_prop = nil
local offset = 0
local mark_prop_for_respawn = false
local proppers = {}

local levels = {
    {level_id= 4, level_name= "Big Boo's Haunt"},
    {level_id= 5, level_name= "Cool, Cool Mountain"},
    {level_id= 7, level_name= "Hazy Maze Cave"},
    {level_id= 8, level_name= "Shifting Sand Land"},
    {level_id= 9, level_name= "Bob-omb Battlefield"},
    {level_id= 10, level_name= "Snowman's Land"},
    {level_id= 11, level_name= "Wet-Dry World"},
    {level_id= 12, level_name= "Jolly Roger Bay"},
    {level_id= 13, level_name= "Tiny-Huge Island"},
    {level_id= 14, level_name= "Tick Tock Clock"},
    {level_id= 15, level_name= "Rainbow Road"},
    {level_id= 16, level_name= "Castle Grounds - Only"},
    --{level_id= 16, level_name= "Castle Grounds - Open World"},
    {level_id= 17, level_name= "Bowser in the Dark World"},
    {level_id= 19, level_name= "Bowser in the Fire Sea"},
    {level_id= 21, level_name= "Bowser in the Sky"},
    {level_id= 22, level_name= "Lethal Lava Land"},
    {level_id= 23, level_name= "Dire, Dire Docks"},
    {level_id= 36, level_name= "Tall, Tall Mountain"}
}

-- All spawnable objects for prop hunt. 
-- Edit to add more spawnable objects to the pool!
local spawnable_objects = {
    {behavior_id = id_bhvOneCoin, model_id = E_MODEL_YELLOW_COIN, name = "Coin"},
    {behavior_id = id_bhvRedCoin, model_id = E_MODEL_RED_COIN, name = "Red Coin"},
    {behavior_id = id_bhvOneCoin, model_id = E_MODEL_YELLOW_COIN, name = "Coin"},
    {behavior_id = id_bhvRedCoin, model_id = E_MODEL_RED_COIN, name = "Red Coin"},
    {behavior_id = id_bhvTree, model_id = E_MODEL_BUBBLY_TREE, name = "Tree"},
    {behavior_id = id_bhvSeaweed, model_id = E_MODEL_SEAWEED, name = "Seaweed"},
    {behavior_id = id_bhvRecoveryHeart, model_id = E_MODEL_HEART, name = "Recovery Heart"},
    {behavior_id = id_bhvSeaweed, model_id = E_MODEL_WOODEN_SIGNPOST, name = "Signboard"},
    {behavior_id = id_bhvOneCoin, model_id = E_MODEL_BULLET_BILL, name = "Bullet Bill"},
    {behavior_id = id_bhvSeaweed, model_id = E_MODEL_BREAKABLE_BOX_SMALL, name = "Small Breakable Box"},
    {behavior_id = id_bhvSeaweed, model_id = E_MODEL_WOODEN_POST, name = "Wooden Post"},
    {behavior_id = id_bhvTree, model_id = E_MODEL_SNOW_TREE, name = "Snow Tree"},
    {behavior_id = id_bhvTree, model_id = E_MODEL_PALM_TREE, name = "Palm Tree"},
    {behavior_id = id_bhvOneCoin, model_id = E_MODEL_RR_TRICKY_TRIANGLES, name = "Tricky Triangles"},
    {behavior_id = id_bhvTree, model_id = E_MODEL_DDD_POLE, name = "Pole"},
    {behavior_id = id_bhvExclamationBox, model_id = E_MODEL_EXCLAMATION_BOX, name = "Exclamation Box"},
    {behavior_id = id_bhvSeaweed, model_id = E_MODEL_METAL_BOX, name = "Metal Box"},
    {behavior_id = id_bhvRecoveryHeart, model_id = E_MODEL_KOOPA_SHELL, name = "Koopa Shell"},
    {behavior_id = id_bhvOneCoin, model_id = E_MODEL_YOSHI_EGG, name = "Yoshi Egg"},
    {behavior_id = id_bhvTree, model_id = E_MODEL_SSL_PYRAMID_TOP, name = "Pyramid Top"},
    {behavior_id = id_bhvRecoveryHeart, model_id = E_MODEL_STAR, name = "Power Star"},
}

local function reset_game()
    gGlobalSyncTable.count_down_began = false
    gGlobalSyncTable.markStartMatch = false
    
    for i = 0, (MAX_PLAYERS - 1) do
        gPlayerSyncTable[i].level_check_cleared = false
        gPlayerSyncTable[i].selected_prop_id = nil
    end

    gGlobalSyncTable.displayTimer = 0
    server_timer = 0
    flag_start_match = false
    selected_prop = nil
    gGlobalSyncTable.selected_level = 12
    gGlobalSyncTable.open_world = false
end

local function update_server()
    local amount_connected = 0

    -- One time print
    if (server_timer == 0) then 
        bprint("Server", "Update Server called. Awaiting players..")

        if(network_is_server()) then
            djui_chat_message_create("L/R DPAD: Select Level")
            -- djui_chat_message_create("UP DPAD: Change Prop Selection Mode")
            djui_chat_message_create("L Trigger + R Trigger + A: Start Match")
        end

        server_timer = server_timer + 1
    end

    local participants = {}
    for i = 0, (MAX_PLAYERS - 1) do
        if (gNetworkPlayers[i].connected) then
            amount_connected = amount_connected + 1
            table_insert(participants, gPlayerSyncTable[i])
        end
    end

    -- Enough people have joined to be able to start the match
    if (amount_connected >= 2) and (gGlobalSyncTable.roundState == GAME_STATES.WAITING) then
        -- Player has called for the start of the match..
        if(gGlobalSyncTable.markStartMatch) then
            -- .. so start!
            gGlobalSyncTable.roundState = GAME_STATES.HEAD_START
            gGlobalSyncTable.markStartMatch = false

            gGlobalSyncTable.displayTimer = 0
            server_timer = 1

            bprint("Server", "Switching to playing state..")
        end
    -- Insufficient party amount
    elseif (amount_connected < 2) then
        gGlobalSyncTable.roundState = GAME_STATES.WAITING
    end 

    -- Head Start State. This state assigns proppers with their props, as well as their hunters.
    if (gGlobalSyncTable.roundState == GAME_STATES.HEAD_START) then
        -- Timer has not yet began
        if not gGlobalSyncTable.count_down_began then
            bprint("Server", "Selecting proppers and hunters..")
            -- Randomly shuffle the participants
            local shuffle = participants
            for i = #shuffle, 2, -1 do
                local j = math.random(#shuffle)
                shuffle[i], shuffle[j] = shuffle[j], shuffle[i]
            end

            for i = 1, #shuffle do
                shuffle[i].hunter = false
            end

            -- Make half of the shuffled players hunters
            local hlen = math_floor(#shuffle / 4)
            if hlen <= 1 then hlen = 1 end

            for i = 1, hlen do
                shuffle[i].hunter = true
            end

            -- Assign the remaining players as proppers
            --proppers = {table_unpack(shuffle, hlen + 1)}  -- Remaining players are proppers

            bprint("Success", "Proppers and Hunters set!")
            bprint("Server", "Beginning countdown..")
            gGlobalSyncTable.count_down_began = true  -- We can begin the countdown now
        
            -- Initialize non-hunters as hunters = false
            for i = 1, #participants do
                if participants[i].hunter == nil then participants[i].hunter = false end
                bprint("Server", "... " .. tostring(participants[i].hunter))
            end
        -- Timer has began for the proppers to hide
        else
            server_timer = server_timer + 1
            gGlobalSyncTable.displayTimer = math_floor(server_timer / 30)

            --if(grace_period/30 - gGlobalSyncTable.displayTimer <= 3) then
            --    gGlobalSyncTable.force_stop = true
            --end

            if gGlobalSyncTable.displayTimer >= 5 then
                gGlobalSyncTable.roundState = GAME_STATES.HEAD_START_PROP
            end
        end
    end

    -- Head Start Prop State
    if (gGlobalSyncTable.roundState == GAME_STATES.HEAD_START_PROP) then
        server_timer = server_timer + 1
        gGlobalSyncTable.displayTimer = math_floor(server_timer / 30)

        if (flag_start_match) then
            bprint("Server", "Timer has reached zero, switching to playing state")
            server_timer = 0
            gGlobalSyncTable.displayTimer = 0
            gGlobalSyncTable.count_down_began = false
            gGlobalSyncTable.roundState = GAME_STATES.PLAYING
        end
    end 

    -- Playing state
    if (gGlobalSyncTable.roundState == GAME_STATES.PLAYING) then
        server_timer = server_timer + 1
        gGlobalSyncTable.displayTimer = math_floor(server_timer / 30)

        gGlobalSyncTable.force_stop = false

        if(server_timer % 30 == 0) then
            for i = 0, #participants do
                if(gPlayerSyncTable[i].hunter == false and gNetworkPlayers[i].currLevelNum == 6 and 
                (
                    spawnable_objects[gPlayerSyncTable[i].selected_prop_id].behavior_id == "id_bhvOneCoin" or
                    spawnable_objects[gPlayerSyncTable[i].selected_prop_id].behavior_id == "id_bhvRedCoin" or
                    spawnable_objects[gPlayerSyncTable[i].selected_prop_id].behavior_id == "id_bhvExclamationBox")
                )
                or
                    levels[gGlobalSyncTable.selected_level].level_id == 7
                then
                    gPlayerSyncTable[i].reset_prop = true
                end
            end
        end

        -- Check to see if all proppers are caught
        local all_proppers_caught = true
        for i = 1, #participants do
            if participants[i].hunter == false then
                all_proppers_caught = false
            end
        end

        -- If so, mark hunters as winners
        if all_proppers_caught then
            bprint("Server", "All proppers caught, switching to hunters win state")
            server_timer = 0
            gGlobalSyncTable.displayTimer = 0
            gGlobalSyncTable.roundState = GAME_STATES.HUNTERS_WIN
        end

        -- If not, you know the drill
        if gGlobalSyncTable.displayTimer >= sRoundEndTimeout / 30 then
            bprint("Server", "Time limit reached, switching to props win state")
            server_timer = 0
            gGlobalSyncTable.displayTimer = 0
            gGlobalSyncTable.roundState = GAME_STATES.PROP_HUNT_WIN
        end
    end

    -- Hunters / Prop win state
    if (gGlobalSyncTable.roundState == GAME_STATES.HUNTERS_WIN) or (gGlobalSyncTable.roundState == GAME_STATES.PROP_HUNT_WIN) then
        server_timer = server_timer + 1
        gGlobalSyncTable.displayTimer = math_floor(server_timer / 30)

        for i = 1, #participants do
            gPlayerSyncTable[i].selected_prop_id = nil
        end
    end
end

local function update()
    if (network_is_server()) then update_server() end
end

--[[
#
    SPAWNABLES
#
]]
-- Creating a prop and setting it to the player
local function spawn_object(m, behavior_id, model_id)
    local new_prop = spawn_sync_object(
        behavior_id,
        model_id,
        0, 0, 0,
    nil)
    
    prop[m.playerIndex] = new_prop
end

local function spawn_coin(m)
    local new_prop = spawn_sync_object(
        id_bhvOneCoin,
        E_MODEL_YELLOW_COIN,
        m.pos.x, m.pos.y, m.pos.z,
    nil)
    prop[m.playerIndex] = new_prop
end

local function randomly_select_object(m)
    bprint("Info", "Random prop selector called")

    local i = math.random(1, #spawnable_objects)
    gPlayerSyncTable[m.playerIndex].selected_prop_id = i  -- This is the only thing that matters
    return spawnable_objects[i]  -- This shouldn't exist or return anything
end

--[[
#
    HUD
#
]]
local function generate_random_transition_message(type)
    local r = math.random(1, 8)

    --if(type == 1) then  -- Was Tagged
        if r == 1 then
            return "was caught and is now a hunter!"
        elseif r == 2 then
            return "had their plot foiled."
        elseif r == 3 then
            return "has fallen to the dark side."
        elseif r == 4 then
            return "was caught red-handed."
    --  end
    --elseif(type == 2)  -- Transition Due to Death
    --then
        elseif r == 5 then
            return "couldn't quite get their act together."
        elseif r == 6 then
            return "sucumbed to the pressure."
        elseif r == 7 then
            return "took a mistep."
        elseif r == 8 then
            return "was caught off guard."
    --  end
    end
end

local function on_hunter_status_changed(tag, oldVal, newVal)
    local m = gMarioStates[tag]
    local npT = gNetworkPlayers[tag]

    if gGlobalSyncTable.roundState ~= GAME_STATES.PLAYING then return end

    -- play sound and create popup if became a seeker
    if newVal and not oldVal then
        play_sound(SOUND_OBJ_BOWSER_LAUGH, m.marioObj.header.gfx.cameraToObject)
        playerColor = network_get_player_text_color_string(m.playerIndex)

        if gPlayerSyncTable[m.playerIndex].mark_as_dead == true then
            djui_popup_create(playerColor .. npT.name .. "\\#ffa0a0\\ " .. generate_random_transition_message(2), 2)
            gPlayerSyncTable[m.playerIndex].mark_as_dead = false
        else
            djui_popup_create(playerColor .. npT.name .. "\\#ffa0a0\\ " .. generate_random_transition_message(1), 2)
        end
    end
end

-- These three methods (hud top render) and (hud center render) and (on hud render) are from/heavily based off of the hide and seek mod.
local function hud_top_render()
    local seconds = 0
    local text = ""

    if gGlobalSyncTable.roundState == GAME_STATES.WAITING then
        seconds = 30
        text = "Waiting for More Players."
    elseif (gGlobalSyncTable.roundState == GAME_STATES.HEAD_START or gGlobalSyncTable.roundState == GAME_STATES.HEAD_START_PROP) and gGlobalSyncTable.count_down_began then
        seconds = math_floor(grace_period / 30 - gGlobalSyncTable.displayTimer)

        if seconds < 0 then 
            flag_start_match = true -- This shouldn't be handled here but ok..
        end
        
        text = "Proppers have " .. seconds .. " Seconds to Hide!"
    elseif (gGlobalSyncTable.roundState == GAME_STATES.PLAYING) then
        seconds = math_floor(sRoundEndTimeout / 30 - gGlobalSyncTable.displayTimer)

        if seconds < 0 then 
            flag_start_match = true
        end
        
        text = seconds .. " Seconds Remain"
    elseif (gGlobalSyncTable.roundState == GAME_STATES.HUNTERS_WIN) then
        seconds = math_floor(resetTimeout / 30 - gGlobalSyncTable.displayTimer)
        if seconds < 0 then 
            reset_game()
            gGlobalSyncTable.roundState = GAME_STATES.WAITING
        end

        text = "Round Over!"
    elseif (gGlobalSyncTable.roundState == GAME_STATES.PROP_HUNT_WIN) then
        seconds = math_floor(resetTimeout / 30 - gGlobalSyncTable.displayTimer)
        if seconds < 0 then 
            reset_game()
            gGlobalSyncTable.roundState = GAME_STATES.WAITING
        end

        text = "Times Up!"
    end


    local scale = 0.5
    local screenWidth = djui_hud_get_screen_width()
    local width = djui_hud_measure_text(text) * scale

    local x = (screenWidth - width) * 0.5
    local y = 0

    local background = 0.0
    if seconds <= 15 and gGlobalSyncTable.roundState == GAME_STATES.HEAD_START then
        background = (math.sin(flash_index * 0.1) * 0.5 + 0.5) * 1
        background = background * background
        background = background * background
    elseif seconds <= 60 and gGlobalSyncTable.roundState == GAME_STATES.PLAYING then
        background = (math.sin(flash_index * 0.1) * 0.5 + 0.5) * 1
        background = background * background
        background = background * background
    end

    -- render top
    djui_hud_set_color(255 * background, 0, 0, 128)
    djui_hud_render_rect(x - 6, y, width + 12, 16)

    djui_hud_set_color(255, 255, 255, 255)
    djui_hud_print_text(text, x, y, scale)
end

local function hud_center_render()
    -- set text
    local text = ""
    if gGlobalSyncTable.roundState == GAME_STATES.HUNTERS_WIN then
        text = "Hunters Win!"
    elseif gGlobalSyncTable.roundState == GAME_STATES.PROP_HUNT_WIN then
        text = "Props Win!"
    else
        return
    end

    local scale = 1
    local screenWidth = djui_hud_get_screen_width()
    local screenHeight = djui_hud_get_screen_height()
    local width = djui_hud_measure_text(text) * scale
    local height = 32 * scale

    local x = (screenWidth - width) * 0.5
    local y = (screenHeight - height) * 0.5

    -- render
    djui_hud_set_color(0, 0, 0, 128)
    djui_hud_render_rect(x - 6 * scale, y, width + 12 * scale, height)

    djui_hud_set_color(255, 255, 255, 255)
    djui_hud_print_text(text, x, y, scale)
end


local function on_hud_render()
    djui_hud_set_resolution(RESOLUTION_N64)
    djui_hud_set_font(FONT_NORMAL)
    hud_top_render()
    hud_center_render()

    flash_index = flash_index + 1
end

--[[
#
    FIXES / REWRITES
#
]]
local function handle_death_and_warp(trans)
    local s = gPlayerSyncTable[0]

    -- Check if the player has died and turn them into a hunter if so
    for i=1,(MAX_PLAYERS-1) do
        if gNetworkPlayers[i].connected and gNetworkPlayers[i].currLevelNum == network_player.currLevelNum and
            gNetworkPlayers[i].currActNum == network_player.currActNum and gNetworkPlayers[i].currAreaIndex == network_player.currAreaIndex 
            and gGlobalSyncTable.roundState == GAME_STATES.PLAYING then

            local m = gMarioStates[0]
            local a = gMarioStates[i]

            if trans == WARP_TRANSITION_FADE_INTO_BOWSER or (m.floor.type == SURFACE_DEATH_PLANE and m.pos.y <= m.floorHeight + 2048) then
                bprint("Info", "Propper died, transforming to hunter.")
                s.hunter = true
            end
            
            if trans == WARP_TRANSITION_FADE_INTO_CIRCLE then
                bprint("Info", "Propper initiating transfer.")
                if not gPlayerSyncTable[m.playerIndex].hunter then
                    mark_prop_for_respawn = true
                end
            end
        end
    end
end

local function handle_warp()
    print("hi")

    if not gGlobalSyncTable.roundState == GAME_STATES.PLAYING then return end

    for i = 0, (MAX_PLAYERS - 1) do
        if(gPlayerSyncTable[i].hunter == false) then
            gPlayerSyncTable[i].reset_prop = true
        end
    end
end

-- Stop the goomba from chasing their own player
local function bhv_custom_goomba_force_stop_chase(o)
    local player = nearest_player_to_object(o)
    local distanceToPlayer = player and dist_between_objects(o, player) or 10000

    if (distanceToPlayer > 5) then return end

    o.oAction = 0
    o.oForwardVel = 0
    o.oVelX = 0
    o.oVelZ = 0
end



--[[
#
    PROP HUNT
#
]]
-- On prop catch
local function on_interact(m, obj, itype)
    local type_state_and_interaction_check = (itype == INTERACT_PLAYER) and (m ~= gMarioStates[0]) and (gGlobalSyncTable.roundState == GAME_STATES.PLAYING)

    if not type_state_and_interaction_check then return end

    for i = 0,(MAX_PLAYERS - 1) do
        if gNetworkPlayers[i].connected and gNetworkPlayers[i].currAreaSyncValid then
            if gPlayerSyncTable[m.playerIndex].hunter and not gPlayerSyncTable[i].hunter and obj == gMarioStates[i].marioObj then
                bprint("Success", "Propper caught, transforming to hunter.")
                gPlayerSyncTable[i].hunter = true -- Transform to hunter
            end
        end
    end
end

local debug_index = 0
local function propper_update(m)
    -- Player went through a door/other form of warp. We need to de and then re spawn the prop.
    if gPlayerSyncTable[m.playerIndex].reset_prop then
        bprint("Info", "Player prop reset")
        --if prop[m.playerIndex] ~= nil then
            obj_mark_for_deletion(prop[m.playerIndex])
        --end

        spawn_object(m, spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].behavior_id, spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].model_id)
        gPlayerSyncTable[m.playerIndex].reset_prop = false
        
        if (not gGlobalSyncTable.open_world) and (gGlobalSyncTable.roundState == GAME_STATES.PLAYING) and (gNetworkPlayers[m.playerIndex].currLevelNum ~= levels[gGlobalSyncTable.selected_level].level_id) then
            bprint("Info", "Propper went out of bounds")
            gPlayerSyncTable[m.playerIndex].hunter = true
            gPlayerSyncTable[m.playerIndex].mark_as_dead = true
            warp_to_level(levels[gGlobalSyncTable.selected_level].level_id, 1, 1)
        end
    end

    -- Summon a prop as soon as possible
    if (prop[m.playerIndex] == nil) then
        -- Invis flags
        m.invincTimer = 10
        m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE

        -- Spawn prop
        -- [TODO]: could look way nicer..
        spawn_object(m, spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].behavior_id, spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].model_id)
        
        bprint("Success", "Spawned " .. spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].name .. " and Assigned as Prop.")
    end
    

    if(prop[m.playerIndex] == nil) then return end

    -- Check if the proppers prop was killed or deleted in some way
    if (prop[m.playerIndex].activeFlags == prop[m.playerIndex].activeFlags & ACTIVE_FLAG_DEACTIVATED) then
        prop[m.playerIndex] = nil
        gPlayerSyncTable[m.playerIndex].hunter = true

        bprint("Success", "Prop Deactivated. Turning assigned propper into hunter")
    end

    -- Update prop position
    local current_prop = prop[m.playerIndex]
    local y_offset = 0
    
    -- Offsets for certain props
    if(spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].name == "Recovery Heart") then
        y_offset = 75
    elseif(spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].name == "Exclamation Box") then
        y_offset = 300
    elseif(spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].name == "Pyramid Top") then
        y_offset = 110
    elseif(spawnable_objects[gPlayerSyncTable[m.playerIndex].selected_prop_id].name == "Power Star") then
        y_offset = 200
    end

    current_prop.oPosX, current_prop.oPosY, current_prop.oPosZ = m.pos.x, m.pos.y + y_offset, m.pos.z + offset

    -- Update prop interactability
    current_prop.oInteractStatus = 0
    current_prop.oIntangibleTimer = 10

    -- Invis flags (again?? hello??)
    m.invincTimer = 10
    m.marioObj.header.gfx.node.flags = m.marioObj.header.gfx.node.flags | GRAPH_RENDER_INVISIBLE
end

local function mario_update_prop(m)
    -- Basically, the player doesn't have an assigned prop yet and we're in the headstart phase.. so..
    if (gPlayerSyncTable[m.playerIndex].selected_prop_id == nil) then
        -- .. we get to picking the prop..
        selected_prop = randomly_select_object(m)
        bprint("Success", "Randomly Selected Prop: " .. selected_prop.name)
    end

    -- We're out folks!
    --if gGlobalSyncTable.roundState == GAME_STATES.PLAYING then
    local np = gNetworkPlayers[0]
    if (np.currLevelNum == levels[gGlobalSyncTable.selected_level].level_id and gGlobalSyncTable.open_world == false) or (gGlobalSyncTable.open_world == true) then
        if (gGlobalSyncTable.roundState == GAME_STATES.HEAD_START_PROP or gGlobalSyncTable.roundState == GAME_STATES.PLAYING) then
            propper_update(m)
        end
    elseif(gGlobalSyncTable.force_stop) then
        if prop[m.playerIndex] ~= nil then
            obj_mark_for_deletion(prop[m.playerIndex])
        end

        prop[m.playerIndex] = nil
    end
    --end
end

-- A disaster
local function mario_update(m)
    local head_start_or_playing = (gGlobalSyncTable.roundState == GAME_STATES.HEAD_START) or gGlobalSyncTable.roundState == GAME_STATES.HEAD_START_PROP or (gGlobalSyncTable.roundState == GAME_STATES.PLAYING)
    local np = gNetworkPlayers[0]

    -- Update propper logic
    local s = gPlayerSyncTable[m.playerIndex]
    if (s.hunter == false) then
        if (head_start_or_playing) then
            mario_update_prop(m)
        end
    end

    --[[if m.playerIndex == 0 then
        if(s.hunter == true) then
            print("ST " .. server_timer)
            if(gGlobalSyncTable.roundState == GAME_STATES.HEAD_START and server_timer == 1) then
                gPlayerSyncTable[m.playerIndex].level_check_cleared = true
                play_transition(3, 10, 0, 0, 0)
            end
        end
    end]]

    if m.playerIndex == 0 then
        if (head_start_or_playing and not gGlobalSyncTable.open_world --[[and not (s.hunter == true and grace_period/30 - gGlobalSyncTable.displayTimer >= 1)]]) then
            if(np.currLevelNum ~= levels[gGlobalSyncTable.selected_level].level_id and gPlayerSyncTable[0].level_check_cleared ~= true) then
                warp_to_level(levels[gGlobalSyncTable.selected_level].level_id, 1, 1)
            --    if head_start_or_playing then
            --        gPlayerSyncTable[0].level_check_cleared = true
            --    end
            end
        end
    end

    -- Set hunters to sleep when the countdown begins
    if (s.hunter == true) then
        if (gGlobalSyncTable.count_down_began) then
            m.action = ACT_SLEEPING
        end
    end

    -- Invincibility
    m.health = 0x880

    if(gGlobalSyncTable.roundState == GAME_STATES.WAITING) then
        if(np.currLevelNum ~= 16) then
            warp_to_level(16, 1, 1)
        end
    end

    if(network_is_server() and m.playerIndex == 0 and gGlobalSyncTable.roundState == GAME_STATES.WAITING) then
        if (m.controller.buttonDown & R_TRIG ~= 0) and (m.controller.buttonDown & L_TRIG ~= 0) and (m.controller.buttonDown & A_BUTTON ~= 0) then
            -- Start
            if(gGlobalSyncTable.roundState == GAME_STATES.WAITING) then
                gGlobalSyncTable.markStartMatch = true
                
                --if(gGlobalSyncTable.selected_level == 13) then
                --    gGlobalSyncTable.open_world = true
                --else
                --    gGlobalSyncTable.open_world = false
                --end

                bprint("Success", "Marked to start match..")
                bprint("Info", "Current match settings: " .. (gGlobalSyncTable.prop_mode == 0 and "Smart" or "Frantic") .. " mode, " .. levels[gGlobalSyncTable.selected_level].level_name)
    
            -- Reset
            elseif((gGlobalSyncTable.roundState == GAME_STATES.PROP_HUNT_WIN) or (gGlobalSyncTable.roundState == GAME_STATES.HUNTERS_WIN)) then
                bprint("Success", "Resetting game settings")
                reset_game()
            end
        elseif (m.controller.buttonDown & R_JPAD ~= 0) then
            gGlobalSyncTable.selected_level = gGlobalSyncTable.selected_level + 1
            if(gGlobalSyncTable.selected_level > #levels) then
                gGlobalSyncTable.selected_level = #levels
            else
                djui_popup_create(gGlobalSyncTable.selected_level .. ". Selecting Level: " .. levels[gGlobalSyncTable.selected_level].level_name, 2)
            end
        elseif (m.controller.buttonDown & L_JPAD ~= 0) then
            gGlobalSyncTable.selected_level = gGlobalSyncTable.selected_level - 1
            if(gGlobalSyncTable.selected_level < 1) then
                gGlobalSyncTable.selected_level = 1
            else
                djui_popup_create(gGlobalSyncTable.selected_level .. ". Selecting Level: " .. levels[gGlobalSyncTable.selected_level].level_name, 2)
            end
        elseif (m.controller.buttonDown & U_JPAD ~= 0) then
            gGlobalSyncTable.prop_mode = gGlobalSyncTable.prop_mode + 1
            if(gGlobalSyncTable.prop_mode > 1) then
                gGlobalSyncTable.prop_mode = 0
            end

            djui_popup_create("Prop Selection Mode: " .. (gGlobalSyncTable.prop_mode == 0 and "Smart" or "Frantic"), 2)
        end
    end
end

hook_event(HOOK_UPDATE, update)
hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_INTERACT, on_interact)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_event(HOOK_ON_SCREEN_TRANSITION, handle_death_and_warp)
hook_event(HOOK_ON_WARP, handle_warp)

id_bhvCustomGoomba = hook_behavior(id_bhvGoomba, OBJ_LIST_PUSHABLE, false, nil, bhv_custom_goomba_force_stop_chase)

--for i = 0, (MAX_PLAYERS - 1) do
--    hook_on_sync_table_change(gPlayerSyncTable[i], "selected_prop_id", i, on_prop_selection_change)
--end

--hook_on_sync_table_change(gGlobalSyncTable, "roundState", 0, on_prop_creation)

for i = 0, (MAX_PLAYERS - 1) do
    hook_on_sync_table_change(gPlayerSyncTable[i], "hunter", i, on_hunter_status_changed)
end