---------------------
-- Animation fixes --
---------------------

local groundPoundValues = {
    0x0000, 0x0036, 0x0033, 0x0036, 0x004B, 0x005D, 0x0054, 0x0046, 0x0042, 
    0x003C, 0x0003, 0xFFAD, 0x0000, 0xFFE1, 0xFFBC, 0xFFC4, 0xFFDE, 0x0005, 
    0x0024, 0x0029, 0x0025, 0x001E, 0x0019, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x4A68, 0x4E5F, 0x5970, 0x6A58, 0x7FD8, 0x98B0, 0xB39E, 
    0xCF60, 0xEAB8, 0x0465, 0x1B25, 0xFFFF, 0xFFBD, 0xFF41, 0xFEF8, 0xFEF7, 
    0xFF05, 0xFF1E, 0xFF3E, 0xFF60, 0xFF81, 0xFF9D, 0xFCBD, 0xFCC8, 0xFCDC, 
    0xFCE8, 0xFCE8, 0xFCE6, 0xFCE1, 0xFCDC, 0xFCD7, 0xFCD2, 0xFCCD, 0x13EC, 
    0x1734, 0x1D64, 0x2100, 0x210D, 0x205C, 0x1F20, 0x1D8E, 0x1BD9, 0x1A35, 
    0x18D7, 0xFEE9, 0xFF31, 0xFFC3, 0x0031, 0x0064, 0x008C, 0x00AD, 0x00C9, 
    0x00E4, 0x00FF, 0x011E, 0x0312, 0x031E, 0x0334, 0x0340, 0x033E, 0x0339, 
    0x0332, 0x0329, 0x0320, 0x0317, 0x030F, 0x0A30, 0x0DCD, 0x150B, 0x1A89, 
    0x1D0E, 0x1F12, 0x20B8, 0x2222, 0x2376, 0x24D4, 0x2662, 0x0001, 0xFFFE, 
    0xC170, 0x9BD7, 0xF82E, 0xB6BD, 0x15C5, 0x1F53, 0x3240, 0xCBFC, 0xE9FC, 
    0x09B4, 0xA88D, 0xC3FF, 0xC4EC, 0xB613, 0xAC7C, 0xD99C, 0xDAAD, 0xDABD, 
    0xA5ED, 0xA70F, 0xA85F, 0xD666, 0xD58B, 0x194D, 0xC01A, 0x081B, 0xAEA6, 
    0xA88E, 0x98CF, 0x020B, 0xE6DF, 0xC9F6, 0x2DEF, 0x1569, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xD609, 0xD17B, 0xC894, 0xC27A, 0xC0A2, 0xBF98, 0xBF25, 
    0xBF0F, 0xBF20, 0xBF1D, 0xBECF, 0xFF89, 0xF97F, 0xF06E, 0x0001, 0xFFFE, 
    0xC170, 0x492C, 0x4FF6, 0xDC9D, 0xE391, 0xE2D8, 0xE079, 0xDCE7, 0xD896, 
    0x53FA, 0x4F83, 0x4BA5, 0x2EC5, 0x3DFB, 0x260F, 0x17D8, 0x1BAF, 0x237D, 
    0x2E2E, 0x3AAD, 0x381B, 0x2B40, 0x1FD6, 0xF656, 0xFDC7, 0x8CC4, 0x9853, 
    0x9DE9, 0xA281, 0xA660, 0xA9CB, 0x2D09, 0x305E, 0x340F, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xDBBD, 0xDABD, 0xD879, 0xD609, 0xD3D8, 0xD19B, 0xCF55, 
    0xCD09, 0xCABB, 0xC86D, 0xC625, 0x0000, 0xFFFC, 0xFFF8, 0xFFFF, 0x0013, 
    0x002A, 0x0043, 0x005D, 0x0079, 0x0094, 0x00AD, 0xFFFF, 0x0012, 0x0024, 
    0xFFFF, 0xFFA5, 0xFF3A, 0xFEC4, 0xFE47, 0xFDC7, 0xFD48, 0xFCCF, 0xED8B, 
    0xEDBB, 0xEDEC, 0xED8B, 0xEC96, 0xEB77, 0xEA39, 0xE8E8, 0xE790, 0xE63B, 
    0xE4F5, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x002A, 0x0012, 0xFFE5, 0xFFC7, 0xFFC0, 
    0xFFBE, 0xFFBE, 0xFFC1, 0xFFC5, 0xFFC8, 0xFFCA, 0x0063, 0x00A9, 0x00ED, 
    0x005C, 0xFEF5, 0xFD50, 0xFB7F, 0xF991, 0xF798, 0xF5A5, 0xF3C9, 0xB182, 
    0xA8A5, 0x975B, 0x8B9E, 0x8840, 0x867B, 0x85E1, 0x8601, 0x866B, 0x86B0, 
    0x8660, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x4A26, 0x4F49, 0x5868, 0x5C13, 0x58F2, 
    0x543E, 0x4E65, 0x47D6, 0x40FD, 0x3A48, 0x3426, 0x0095, 0x00AF, 0x00E1, 
    0x00FB, 0x00F7, 0x00ED, 0x00DE, 0x00CB, 0x00B8, 0x00A5, 0x0095, 0xFF08, 
    0xFF23, 0xFF55, 0xFF70, 0xFF6C, 0xFF62, 0xFF52, 0xFF40, 0xFF2C, 0xFF19, 
    0xFF08, 0xCC41, 0xC6DE, 0xBCDD, 0xB77A, 0xB844, 0xBA62, 0xBD79, 0xC12B, 
    0xC51B, 0xC8EC, 0xCC41, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x007E, 0x00AF, 0x00DF, 
    0x007E, 0xFF8A, 0xFE6B, 0xFD2E, 0xFBDE, 0xFA86, 0xF932, 0xF7EE, 0xFEC3, 
    0xFE90, 0xFE5C, 0xFEC3, 0xFFC6, 0x00F5, 0x0245, 0x03A9, 0x0515, 0x067E, 
    0x07D6, 0x854C, 0x8588, 0x85C3, 0x854C, 0x8421, 0x82C2, 0x813D, 0x7F9F, 
    0x7DFA, 0x7C59, 0x7ACB, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x5341, 0x562D, 0x5B16, 0x5C37, 
    0x58E2, 0x5474, 0x4F3C, 0x4984, 0x4399, 0x3DC8, 0x385D, 0x001B, 0xFFEA, 
    0xFF8D, 0xFF5C, 0xFF63, 0xFF76, 0xFF93, 0xFFB5, 0xFFD9, 0xFFFD, 0x001B, 
    0x025B, 0x0256, 0x024B, 0x0245, 0x0246, 0x0249, 0x024C, 0x0250, 0x0254, 
    0x0258, 0x025B, 0xCB24, 0xC7C2, 0xC178, 0xBE15, 0xBE94, 0xBFE9, 0xC1DA, 
    0xC42D, 0xC6A6, 0xC90C, 0xCB24, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0xFFFF, 0x01A8, 0x0648, 
    0x0D6E, 0x1685, 0x20B3, 0x2AE1, 0x33F9, 0x3B1E, 0x3FBF, 0x4166, 
}

local groundPoundIndices = {
    0x0001, 0x0000, 0x000B, 0x0001, 0x000B, 0x000C, 0x0001, 0x0017, 0x0001, 
    0x0018, 0x0001, 0x0019, 0x000B, 0x001A, 0x000A, 0x0025, 0x000B, 0x002F, 
    0x000B, 0x003A, 0x000B, 0x0045, 0x000B, 0x0050, 0x000B, 0x005B, 0x000B, 
    0x0066, 0x000B, 0x0071, 0x0001, 0x007C, 0x0001, 0x007D, 0x0001, 0x007E, 
    0x000B, 0x007F, 0x000B, 0x008A, 0x000B, 0x0095, 0x000B, 0x00A0, 0x000B, 
    0x00AB, 0x000B, 0x00B6, 0x0001, 0x00C1, 0x0001, 0x00C2, 0x0001, 0x00C3, 
    0x0001, 0x00C4, 0x0001, 0x00C5, 0x0001, 0x00C6, 0x000B, 0x00C7, 0x000B, 
    0x00D2, 0x000B, 0x00DD, 0x000B, 0x00E8, 0x000B, 0x00F3, 0x000B, 0x00FE, 
    0x000B, 0x0109, 0x000B, 0x0114, 0x000B, 0x011F, 0x0009, 0x012A, 0x000B, 
    0x0133, 0x0001, 0x013E, 0x000B, 0x013F, 0x000B, 0x014A, 0x000B, 0x0155, 
    0x000B, 0x0160, 0x000A, 0x016B, 0x000B, 0x0175, 0x000B, 0x0180, 0x000B, 
    0x018B, 0x000B, 0x0196, 0x0009, 0x01A1, 0x000B, 0x01AA, 0x0001, 0x01B5, 
    0x000B, 0x01B6, 0x000B, 0x01C1, 0x000B, 0x01CC, 0x000B, 0x01D7, 0x0009, 
    0x01E2, 0x000B, 0x01EB, 0x000B, 0x01F6, 0x000B, 0x0201, 0x000B, 0x020C, 
    0x0008, 0x0217, 0x0007, 0x021F, 0x000B, 0x0226, 0x0005, 0x0231, 0x0007, 
    0x0236, 0x000B, 0x023D, 
}

smlua_anim_util_register_animation("MILNE_ANIM_START_GROUND_POUND",
    1,
    0,
    0,
    0,
    11,
    groundPoundValues,
    groundPoundIndices)

smlua_anim_util_register_animation("MILNE_ANIM_GROUND_POUND",
    1,
    0,
    0,
    11,
    11,
    groundPoundValues,
    groundPoundIndices)

smlua_anim_util_register_animation("MILNE_ANIM_GROUND_POUND_LANDING",
    1,
    0,
    0,
    0,
    5,
    {
    0x0000, 0xFFAD, 0xFFAC, 0xFFAC, 0xFFAC, 0xFFAB, 0xFFFE, 0xFFFE, 0xFFFF, 
    0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x1B25, 0x1B7C, 0x1C4B, 0x1D42, 0x1E11, 
    0x1E68, 0xFFF8, 0xFFF9, 0xFFFB, 0xFFFD, 0xFFFF, 0x0000, 0xFCBB, 0xFCBB, 
    0xFCBC, 0xFCBC, 0xFCBD, 0x144D, 0x1443, 0x142B, 0x140E, 0x13F6, 0x13EC, 
    0x011E, 0x0100, 0x00B9, 0x0064, 0x001D, 0xFFFF, 0x030F, 0x0315, 0x0321, 
    0x0330, 0x033D, 0x0342, 0x2662, 0x24E6, 0x215A, 0x1D1E, 0x1992, 0x1815, 
    0x0001, 0xFFFE, 0xC170, 0xC3FF, 0xC063, 0xB7C9, 0xAD84, 0x24EB, 0x2150, 
    0xD58B, 0xD49C, 0xD263, 0xCFBC, 0xB27B, 0xB36A, 0x1569, 0x1B00, 0x2853, 
    0x383B, 0xC58E, 0xCB25, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xBECF, 0xC13A, 0xC6FC, 0xCDDC, 
    0xD39E, 0xD609, 0xFF89, 0xF97F, 0xF06E, 0x0001, 0xFFFE, 0xC170, 0x4BA5, 
    0x48E4, 0x4252, 0x3A7A, 0x33E9, 0x3127, 0x1FD6, 0x21AF, 0x2617, 0x2B59, 
    0x2FC1, 0x319A, 0x340F, 0x3134, 0x2A67, 0x2249, 0x1B7B, 0x18A1, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xC625, 0xC864, 0xCDBF, 0xD423, 0xD97E, 0xDBBD, 0x00AD, 0x009B, 
    0x0070, 0x003D, 0x0012, 0x0000, 0xFCCF, 0xFD24, 0xFDEF, 0xFEE0, 0xFFAB, 
    0xFFFF, 0xE4F5, 0xE5DA, 0xE7FB, 0xEA85, 0xECA6, 0xED8B, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFFCA, 0xFFD0, 
    0xFFDD, 0xFFED, 0xFFFA, 0xFFFF, 0xF3C9, 0xF519, 0xF83B, 0xFBF9, 0xFF1B, 
    0x006C, 0x8660, 0x892B, 0x8FD2, 0x97C4, 0x9E6B, 0xA136, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x3426, 0x2FBE, 
    0x253C, 0x18B1, 0x0E2F, 0x09C7, 0x0095, 0xFF08, 0xCC41, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xF7EE, 0xF8BE, 
    0xFAB0, 0xFD02, 0xFEF4, 0xFFC4, 0x07D6, 0x06E2, 0x049D, 0x01E8, 0xFFA4, 
    0xFEB0, 0x7ACB, 0x7E42, 0x8688, 0x9065, 0x98A9, 0x9C20, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x385D, 0x3327, 0x26B9, 0x17E4, 0x0B76, 0x0640, 0x001B, 0x025B, 
    0xCB24, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x3957, 
    },
    {
    0x0001, 0x0000, 0x0005, 0x0001, 0x0004, 0x0006, 0x0001, 0x000A, 0x0001, 
    0x000B, 0x0001, 0x000C, 0x0006, 0x000D, 0x0003, 0x0013, 0x0006, 0x0016, 
    0x0006, 0x001C, 0x0005, 0x0022, 0x0006, 0x0027, 0x0006, 0x002D, 0x0006, 
    0x0033, 0x0006, 0x0039, 0x0001, 0x003F, 0x0001, 0x0040, 0x0001, 0x0041, 
    0x0006, 0x0042, 0x0006, 0x0048, 0x0006, 0x004E, 0x0005, 0x0054, 0x0006, 
    0x0059, 0x0006, 0x005F, 0x0001, 0x0065, 0x0001, 0x0066, 0x0001, 0x0067, 
    0x0001, 0x0068, 0x0001, 0x0069, 0x0001, 0x006A, 0x0006, 0x006B, 0x0006, 
    0x0071, 0x0006, 0x0077, 0x0005, 0x007D, 0x0006, 0x0082, 0x0006, 0x0088, 
    0x0006, 0x008E, 0x0006, 0x0094, 0x0006, 0x009A, 0x0004, 0x00A0, 0x0004, 
    0x00A4, 0x0001, 0x00A8, 0x0006, 0x00A9, 0x0006, 0x00AF, 0x0006, 0x00B5, 
    0x0003, 0x00BB, 0x0006, 0x00BE, 0x0006, 0x00C4, 0x0001, 0x00CA, 0x0001, 
    0x00CB, 0x0001, 0x00CC, 0x0004, 0x00CD, 0x0004, 0x00D1, 0x0001, 0x00D5, 
    0x0006, 0x00D6, 0x0006, 0x00DC, 0x0006, 0x00E2, 0x0006, 0x00E8, 0x0006, 
    0x00EE, 0x0006, 0x00F4, 0x0001, 0x00FA, 0x0001, 0x00FB, 0x0001, 0x00FC, 
    0x0003, 0x00FD, 0x0006, 0x0100, 0x0001, 0x0106, 0x0001, 0x0107, 0x0001, 
    0x0108, 0x0001, 0x0109, 
})

smlua_anim_util_register_animation("MILNE_ANIM_STOP_SLIDE",
    1,
    0,
    0,
    0,
    19,
    {
    0x0000, 0xFFAD, 0xFFAD, 0xFFAD, 0xFFBF, 0xFFE9, 0x0019, 0x003F, 0x004F, 
    0x005B, 0x006B, 0x0081, 0x0096, 0x00A3, 0x00A5, 0x00A7, 0x00A9, 0x00AA, 
    0x00AB, 0x00AB, 0x00AC, 0x0000, 0xFFFF, 0xFFFD, 0xFFF9, 0xFFF4, 0xFFEF, 
    0xFFEA, 0xFFE7, 0xFFE9, 0xFFEE, 0xFFF5, 0xFFFB, 0xFFFF, 0x0000, 0x0000, 
    0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x1E68, 0x1E7C, 0x1EEB, 0x2004, 0x2212, 
    0x2654, 0x2E3C, 0x3FE6, 0x4862, 0x4755, 0x448C, 0x4295, 0x41F5, 0x417C, 
    0x4123, 0x40E7, 0x40C0, 0x40AB, 0x40A3, 0x40A1, 0x0000, 0xFFE7, 0xFFAD, 
    0xFF6B, 0xFF39, 0xFF21, 0xFF17, 0xFF15, 0xFF1F, 0xFF33, 0xFF48, 0xFF61, 
    0xFF7C, 0xFF97, 0xFFB1, 0xFFCA, 0xFFE0, 0xFFF0, 0xFFFC, 0x0000, 0xFCBD, 
    0xFCB4, 0xFCA6, 0xFCAA, 0xFCD5, 0xFD4E, 0xFDFF, 0xFEA6, 0xFF36, 0xFF8F, 
    0xFFAA, 0xFFC0, 0xFFD2, 0xFFE0, 0xFFEB, 0xFFF4, 0xFFF9, 0xFFFD, 0x0000, 
    0xFFFF, 0x13EC, 0x151D, 0x17EB, 0x1B2D, 0x1DBB, 0x1EE6, 0x1F81, 0x20A4, 
    0x2489, 0x268C, 0x2414, 0x20DA, 0x1D1B, 0x1915, 0x1505, 0x1128, 0x0DBC, 
    0x0AFF, 0x092D, 0x0884, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFE3, 
    0xFFAE, 0xFF91, 0xFF93, 0xFF99, 0xFFA2, 0xFFAE, 0xFFBA, 0xFFC8, 0xFFD6, 
    0xFFE3, 0xFFEE, 0xFFF7, 0xFFFD, 0x0000, 0x0342, 0x0342, 0x0342, 0x0342, 
    0x0342, 0x0314, 0x02B3, 0x0260, 0x0225, 0x01E5, 0x01A3, 0x015F, 0x011C, 
    0x00DC, 0x00A1, 0x006C, 0x003F, 0x001D, 0x0007, 0x0000, 0x1815, 0x1815, 
    0x1815, 0x1815, 0x1815, 0x14BA, 0x0E24, 0x098E, 0x07BE, 0x0603, 0x0461, 
    0x02DB, 0x0175, 0x0032, 0xFF17, 0xFE27, 0xFD66, 0xFCD7, 0xFC7F, 0xFC61, 
    0x0001, 0xFFFE, 0xC170, 0x2150, 0x1E76, 0x1775, 0x0E9C, 0x063B, 0xFCC8, 
    0xF50B, 0xF211, 0xF63E, 0x01DF, 0x0FA4, 0x1EE0, 0xAEE2, 0xBEFD, 0xCE7F, 
    0xDCBA, 0xE8FD, 0xF299, 0xF8DE, 0xFB1C, 0xB36A, 0xB9F7, 0xC978, 0xDBBB, 
    0xEA88, 0xF24A, 0xF572, 0xF570, 0xF1BF, 0xEB8D, 0xE452, 0xDC65, 0xABE0, 
    0xB429, 0xBC1D, 0xC363, 0xC9A4, 0xCE88, 0xD1B8, 0xD2DB, 0xCB25, 0xCC82, 
    0xCF70, 0xD232, 0xD308, 0xCEFA, 0xC6E9, 0xBB89, 0xB021, 0xA6BD, 0x9C66, 
    0x917F, 0x066C, 0xFB90, 0xF14F, 0xE80B, 0xE02A, 0xDA0D, 0xD61A, 0xD4B3, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xD609, 0xD4B9, 0xD289, 0xD219, 0xD609, 0xEA24, 0x0000, 
    0x0000, 0x0000, 0xFB56, 0xF5CA, 0xEFA4, 0xE92C, 0xE2A9, 0xDC62, 0xD69E, 
    0xD1A7, 0xCDC2, 0xCB37, 0xCA4E, 0xFF89, 0x022A, 0x0856, 0x0F7B, 0x1506, 
    0x1772, 0x16D6, 0x1176, 0x0C4C, 0x0A8F, 0x08E0, 0x0744, 0x05C2, 0x045F, 
    0x0322, 0x0212, 0x0133, 0x008C, 0x0024, 0x0000, 0xF97F, 0xF7BB, 0xF3C7, 
    0xEFA8, 0xED61, 0xF0E6, 0xF564, 0xF425, 0xF26C, 0xF2D9, 0xF376, 0xF436, 
    0xF50E, 0xF5F0, 0xF6D2, 0xF7A6, 0xF861, 0xF8F5, 0xF957, 0xF97B, 0xF06E, 
    0xF017, 0xEF08, 0xED37, 0xEA97, 0xE38C, 0xDE25, 0xE49C, 0xEB8C, 0xEC92, 
    0xED4E, 0xEDCA, 0xEE10, 0xEE2B, 0xEE26, 0xEE0A, 0xEDE2, 0xEDB8, 0xED98, 
    0xED8B, 0x0001, 0xFFFE, 0xC170, 0x3127, 0x292C, 0x16DC, 0x02AA, 0xF50B, 
    0xF9EE, 0x0409, 0x04B8, 0x00BD, 0xF0D8, 0xEEEA, 0xEE2A, 0xEE6D, 0xEF86, 
    0xF14A, 0xF4AE, 0xF9CE, 0xFF3C, 0x038B, 0x054B, 0x319A, 0x2EA7, 0x278A, 
    0x1EDB, 0x1734, 0x1025, 0x0BF6, 0x0ED4, 0x1510, 0x1E96, 0x24F4, 0x2B8E, 
    0x319D, 0x365A, 0x38FC, 0x3877, 0x3550, 0x311A, 0x2D6B, 0x2BD6, 0x18A1, 
    0x0F37, 0xF907, 0xDF20, 0xCA95, 0xC2BF, 0xBF98, 0xBB6E, 0xB4AB, 0x9F90, 
    0x9FAA, 0xA1C0, 0xA53E, 0xA993, 0xAE2C, 0xB447, 0xBC47, 0xC44D, 0xCA7B, 
    0xCCF5, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xDBBD, 0xDA9B, 0xD8B7, 0xD856, 0xDBBD, 0xEDE0, 
    0xFFFF, 0xFC79, 0xF3C9, 0xEF31, 0xEA2D, 0xE4EA, 0xDF97, 0xDA63, 0xD57C, 
    0xD110, 0xCD50, 0xCA68, 0xC887, 0xC7DC, 0x0000, 0xFED9, 0xFBE9, 0xF7F6, 
    0xF3C6, 0xEBC4, 0xF533, 0xF7EC, 0xF8DF, 0xF9BA, 0xFA9B, 0xFB7E, 0xFC5C, 
    0xFD30, 0xFDF3, 0xFEA0, 0xFF31, 0xFFA0, 0xFFE7, 0xFFFF, 0xFFFF, 0x003E, 
    0x00A5, 0x00BA, 0x0000, 0xF989, 0xFFFF, 0x0089, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xED8B, 0xEE44, 0xEF79, 0xEFB6, 0xED8B, 0xDA3E, 0xEF57, 0xF23F, 0xF181, 
    0xF1F8, 0xF272, 0xF2EB, 0xF361, 0xF3D1, 0xF438, 0xF492, 0xF4DD, 0xF517, 
    0xF53B, 0xF548, 0x0000, 0xFFFD, 0xFFF8, 0xFFF7, 0x0000, 0x0024, 0x0058, 
    0x0089, 0x00B4, 0x00C7, 0x0091, 0x0058, 0x0045, 0x0034, 0x0024, 0x0018, 
    0x000D, 0x0006, 0x0001, 0x0000, 0x0000, 0xFFB6, 0xFF3B, 0xFF22, 0x0000, 
    0x03CD, 0x093A, 0x0E57, 0x12E0, 0x14D5, 0x0F3A, 0x0938, 0x073A, 0x056F, 
    0x03DC, 0x0286, 0x0173, 0x00A8, 0x002B, 0x0000, 0xBF5E, 0xBF5C, 0xBF59, 
    0xBF59, 0xBF5E, 0xBF75, 0xBF97, 0xBFB6, 0xBFD2, 0xBFDE, 0xBFBC, 0xBF97, 
    0xBF8B, 0xBF7F, 0xBF76, 0xBF6E, 0xBF67, 0xBF62, 0xBF5F, 0xBF5E, 0xFFFF, 
    0xFFF2, 0xFFD4, 0xFFB8, 0xFFB2, 0xFFF7, 0x003C, 0xFFD6, 0xFBDF, 0xFFE2, 
    0xF31B, 0xE79F, 0xE3B1, 0xE03C, 0xDD43, 0xDACB, 0xD8D9, 0xD76F, 0xD693, 
    0xD649, 0x006C, 0x0069, 0x0062, 0x0058, 0x004B, 0x002C, 0x0017, 0x0058, 
    0x0228, 0x005E, 0xF9E0, 0xF4A2, 0xF2BB, 0xF10F, 0xEF9F, 0xEE6E, 0xED7D, 
    0xECCE, 0xEC64, 0xEC40, 0xA136, 0x9CB4, 0x9283, 0x879F, 0x8106, 0x86CB, 
    0x907B, 0x902A, 0x8953, 0x94BD, 0xA047, 0xA84C, 0xAB63, 0xAE14, 0xB05D, 
    0xB23E, 0xB3B6, 0xB4C4, 0xB567, 0xB59D, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x09C7, 0x0F7C, 0x1D58, 0x2E75, 0x3DED, 
    0x4C93, 0x57E1, 0x50E8, 0x4ADD, 0x4421, 0x395C, 0x3108, 0x2E28, 0x2BB5, 
    0x29AB, 0x2808, 0x26C7, 0x25E7, 0x2562, 0x2537, 0x0095, 0x0069, 0x0020, 
    0x0012, 0x0095, 0x0361, 0x060D, 0x0290, 0x01F5, 0xFEAA, 0x01A0, 0x0444, 
    0x042F, 0x03BF, 0x0312, 0x0244, 0x0171, 0x00B7, 0x0032, 0x0000, 0xFF08, 
    0xFEF8, 0xFEDD, 0xFED8, 0xFF08, 0xFFD9, 0x010C, 0x0257, 0x015B, 0x0236, 
    0x0244, 0x0217, 0x01D5, 0x0184, 0x012B, 0x00D3, 0x0081, 0x003E, 0x0010, 
    0xFFFF, 0xCC41, 0xCCDF, 0xCDE5, 0xCE1A, 0xCC41, 0xC41D, 0xB890, 0xADF1, 
    0xB1DC, 0xAE98, 0xB206, 0xB5A8, 0xB758, 0xB907, 0xBAA4, 0xBC1E, 0xBD62, 
    0xBE60, 0xBF04, 0xBF3F, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFFC4, 0xFF97, 0xFF5F, 0xFF93, 0x00AA, 
    0x0497, 0x09E6, 0x0E04, 0x0EBA, 0x12E8, 0x160E, 0x180E, 0x18CE, 0x196F, 
    0x19F3, 0x1A5B, 0x1AAA, 0x1AE0, 0x1AFF, 0x1B09, 0xFEB0, 0xFE94, 0xFE6A, 
    0xFE6D, 0xFED9, 0x004B, 0x02EF, 0x0821, 0x0F6B, 0x0E01, 0x0F33, 0x1065, 
    0x10AF, 0x10E6, 0x110E, 0x1128, 0x1139, 0x1141, 0x1144, 0x9C20, 0x97FE, 
    0x8EBA, 0x8507, 0x7F95, 0x8693, 0x91B6, 0x9350, 0x8C01, 0x9AC2, 0xA1DF, 
    0xA597, 0xA737, 0xA89A, 0xA9C0, 0xAAAD, 0xAB62, 0xABE0, 0xAC2B, 0xAC43, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0640, 0x0C90, 0x1BD6, 
    0x2E94, 0x3F4A, 0x4E7B, 0x5970, 0x4F7A, 0x4DCA, 0x4735, 0x395B, 0x2EA6, 
    0x2AD0, 0x277D, 0x24AD, 0x2260, 0x2096, 0x1F4F, 0x1E8B, 0x1E4A, 0x001B, 
    0x0051, 0x00A9, 0x00BB, 0x001B, 0xFD54, 0xF975, 0xF638, 0xF733, 0xF842, 
    0xFBCE, 0xFE85, 0xFF2D, 0xFF9F, 0xFFE5, 0x0008, 0x0013, 0x000F, 0x0005, 
    0x0000, 0x025B, 0x025C, 0x025E, 0x025E, 0x025B, 0x0271, 0x023F, 0x00A2, 
    0xF75A, 0xF570, 0xF885, 0xFB6A, 0xFC52, 0xFD19, 0xFDC0, 0xFE46, 0xFEAD, 
    0xFEF6, 0xFF21, 0xFF2F, 0xCB24, 0xCBCD, 0xCCE6, 0xCD1F, 0xCB24, 0xC24F, 
    0xB60A, 0xABF2, 0xB02D, 0xA942, 0xB312, 0xBC77, 0xBF88, 0xC238, 0xC484, 
    0xC669, 0xC7E6, 0xC8F9, 0xC99F, 0xC9D7, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFF, 0x4166, 0x3F0B, 0x3815, 0x2C3B, 0x1B86, 0x07CF, 
    0xF50E, 0xE6D4, 0xDE7D, 0xDC3D, 0xDDFD, 0xE128, 0xE55C, 0xEA3C, 0xEF64, 
    0xF470, 0xF8FB, 0xFCA6, 0xFF1A, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x0014, 0x0001, 0x000E, 0x0015, 0x0001, 0x0023, 0x0001, 
    0x0024, 0x0001, 0x0025, 0x0013, 0x0026, 0x0013, 0x0039, 0x0014, 0x004C, 
    0x0014, 0x0060, 0x0014, 0x0074, 0x0014, 0x0088, 0x0014, 0x009C, 0x0014, 
    0x00B0, 0x0014, 0x00C4, 0x0001, 0x00D8, 0x0001, 0x00D9, 0x0001, 0x00DA, 
    0x0014, 0x00DB, 0x0014, 0x00EF, 0x0014, 0x0103, 0x0014, 0x0117, 0x0012, 
    0x012B, 0x0014, 0x013D, 0x0014, 0x0151, 0x0014, 0x0165, 0x0014, 0x0179, 
    0x0001, 0x018D, 0x0001, 0x018E, 0x0001, 0x018F, 0x0014, 0x0190, 0x0014, 
    0x01A4, 0x0014, 0x01B8, 0x0014, 0x01CC, 0x0012, 0x01E0, 0x0014, 0x01F2, 
    0x0014, 0x0206, 0x0014, 0x021A, 0x0014, 0x022E, 0x0014, 0x0242, 0x0014, 
    0x0256, 0x0014, 0x026A, 0x0014, 0x027E, 0x0014, 0x0292, 0x0014, 0x02A6, 
    0x0013, 0x02BA, 0x0010, 0x02CD, 0x0014, 0x02DD, 0x0014, 0x02F1, 0x0014, 
    0x0305, 0x0014, 0x0319, 0x0011, 0x032D, 0x0013, 0x033E, 0x0001, 0x0351, 
    0x0014, 0x0352, 0x0013, 0x0366, 0x0014, 0x0379, 0x0013, 0x038D, 0x000E, 
    0x03A0, 0x0014, 0x03AE, 0x0014, 0x03C2, 0x0014, 0x03D6, 0x0014, 0x03EA, 
    0x0014, 0x03FE, 0x0011, 0x0412, 0x0014, 0x0423, 0x0010, 0x0437, 0x000F, 
    0x0447, 0x0014, 0x0456, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLIDE",
    0,
    0,
    0,
    0,
    7,
    {
    0x0000, 0xFFB3, 0xFFB2, 0xFFAF, 0xFFAD, 0xFFAE, 0xFFB0, 0xFFB2, 0xFFB3, 
    0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0x1E68, 0x0000, 0xFCBD, 
    0x13EC, 0xFFFF, 0x001C, 0x0053, 0x007A, 0x0070, 0x0048, 0x001C, 0x0001, 
    0x0342, 0x033E, 0x0338, 0x0333, 0x0334, 0x0338, 0x033E, 0x0342, 0x1815, 
    0x18E8, 0x1A85, 0x1BA8, 0x1B61, 0x1A3C, 0x18EC, 0x1820, 0x0001, 0xFFFE, 
    0xC170, 0x2150, 0x255B, 0xACDB, 0xB0E6, 0xAEB7, 0x29CB, 0x2490, 0x2177, 
    0xB36A, 0xB038, 0xD5B5, 0xD8E7, 0xD72D, 0xACB6, 0xB0D8, 0xB34B, 0xCB25, 
    0xC6B2, 0x3E70, 0x39FD, 0x3C65, 0xC1CF, 0xC790, 0xCAF9, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xD609, 0xD199, 0xC95C, 0xC4EC, 0xC751, 0xCCB9, 
    0xD277, 0xD5DD, 0xFF89, 0xF97F, 0xF06E, 0x0001, 0xFFFE, 0xC170, 0x3127, 
    0x3220, 0x33EE, 0x34E7, 0x3460, 0x3331, 0x31F0, 0x3131, 0x319A, 0x2DEE, 
    0x271C, 0x2370, 0x256C, 0x29E5, 0x2EA6, 0x3176, 0x18A1, 0x1AB3, 0x1E8A, 
    0x209C, 0x1F7E, 0x1CF8, 0x1A4B, 0x18B5, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xDBBD, 0xD6C6, 0xCD8E, 0xC897, 0xCB45, 0xD152, 
    0xD7BE, 0xDB8C, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xED8B, 0xECB2, 
    0xEB20, 0xEA48, 0xEABD, 0xEBC5, 0xECDC, 0xED82, 0x0000, 0x0000, 0xBF5E, 
    0xFFFF, 0x006C, 0xA136, 0x0000, 0x0000, 0x09C7, 0x0095, 0xFF08, 0xCC41, 
    0x0000, 0x0000, 0xBF5E, 0xFFC4, 0xFEB0, 0x9C20, 0x0000, 0x0000, 0x0640, 
    0x001B, 0x025B, 0xCB24, 0xFFFF, 0x0000, 0x0000, 0xFFFE, 0x0001, 0x4166, 
    0x4297, 0x44CC, 0x45FC, 0x4545, 0x43B1, 0x421E, 0x4166, 
    },
    {
    0x0001, 0x0000, 0x0008, 0x0001, 0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 
    0x000B, 0x0001, 0x000C, 0x0001, 0x000D, 0x0001, 0x000E, 0x0001, 0x000F, 
    0x0001, 0x0010, 0x0001, 0x0011, 0x0001, 0x0012, 0x0008, 0x0013, 0x0008, 
    0x001B, 0x0008, 0x0023, 0x0001, 0x002B, 0x0001, 0x002C, 0x0001, 0x002D, 
    0x0008, 0x002E, 0x0008, 0x0036, 0x0008, 0x003E, 0x0008, 0x0046, 0x0006, 
    0x004E, 0x0008, 0x0054, 0x0001, 0x005C, 0x0001, 0x005D, 0x0001, 0x005E, 
    0x0001, 0x005F, 0x0001, 0x0060, 0x0001, 0x0061, 0x0008, 0x0062, 0x0008, 
    0x006A, 0x0008, 0x0072, 0x0008, 0x007A, 0x0008, 0x0082, 0x0008, 0x008A, 
    0x0008, 0x0092, 0x0006, 0x009A, 0x0008, 0x00A0, 0x0001, 0x00A8, 0x0001, 
    0x00A9, 0x0001, 0x00AA, 0x0001, 0x00AB, 0x0001, 0x00AC, 0x0001, 0x00AD, 
    0x0001, 0x00AE, 0x0001, 0x00AF, 0x0001, 0x00B0, 0x0001, 0x00B1, 0x0001, 
    0x00B2, 0x0001, 0x00B3, 0x0001, 0x00B4, 0x0001, 0x00B5, 0x0001, 0x00B6, 
    0x0001, 0x00B7, 0x0001, 0x00B8, 0x0001, 0x00B9, 0x0001, 0x00BA, 0x0001, 
    0x00BB, 0x0001, 0x00BC, 0x0001, 0x00BD, 0x0001, 0x00BE, 0x0001, 0x00BF, 
    0x0001, 0x00C0, 0x0001, 0x00C1, 0x0001, 0x00C2, 0x0001, 0x00C3, 0x0001, 
    0x00C4, 0x0008, 0x00C5, 
})

local diveValues = {
    0x0000, 0x0109, 0x0101, 0x00EC, 0x00CC, 0x00A4, 0x0078, 0x004B, 0x001F, 
    0xFFF7, 0xFFD7, 0xFFC0, 0xFFB1, 0xFFA8, 0xFFA3, 0xFFA1, 0xFFA1, 0xFFA2, 
    0xFFA4, 0xFF9E, 0xFF97, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x52E9, 0x5839, 0x61ED, 0x6C23, 0x7609, 0x7D26, 0x8293, 0x875C, 
    0x8B7C, 0x8DFB, 0x8E26, 0x8CAF, 0x8AB9, 0x885D, 0x8563, 0x8273, 0x8035, 
    0x7F52, 0x7F58, 0x7F62, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x1995, 0x17DB, 
    0x135F, 0x0D31, 0x065F, 0xFFF6, 0xFB07, 0xF869, 0xF775, 0xF6F4, 0xF676, 
    0xF66C, 0xF6F4, 0xF7CF, 0xF8AA, 0xF986, 0xFA64, 0xFB45, 0xFC2A, 0xFD14, 
    0x01EE, 0x01ED, 0x01EC, 0x01E9, 0x01E7, 0x01E3, 0x01E0, 0x01DB, 0x01D6, 
    0x01D0, 0x01CA, 0x01C3, 0x01B6, 0x019C, 0x018C, 0x0197, 0x01AB, 0x01B6, 
    0x01B5, 0x01B4, 0x010C, 0x010D, 0x0110, 0x0114, 0x0119, 0x011E, 0x0124, 
    0x012B, 0x0133, 0x013C, 0x0145, 0x014E, 0x015E, 0x017B, 0x018E, 0x0182, 
    0x016C, 0x0160, 0x0161, 0x0165, 0xE07B, 0xE066, 0xE02E, 0xDFDA, 0xDF6F, 
    0xDEF4, 0xDE71, 0xDDDE, 0xDD32, 0xDC71, 0xDBA1, 0xDAC7, 0xD945, 0xD677, 
    0xD4AB, 0xD5D2, 0xD7FB, 0xD926, 0xD90D, 0xD8CA, 0xFFFE, 0x0001, 0xC170, 
    0x0268, 0x032E, 0x053F, 0x0837, 0x0BB2, 0x0F4D, 0x12A6, 0x1617, 0x1A0A, 
    0x1E2B, 0x22E7, 0x27D2, 0x2B51, 0x2D7E, 0x2F79, 0x3137, 0x32A9, 0x33C1, 
    0x3474, 0x34B2, 0xD800, 0xD92D, 0xDC1F, 0xDFF0, 0xE3BF, 0xE6A7, 0xE7C6, 
    0xE335, 0xDB0B, 0xD75E, 0xDDA8, 0xE870, 0xEF61, 0xF0F0, 0xF15A, 0xF0F3, 
    0xF010, 0xEF06, 0xEE27, 0xEDCB, 0x7B6C, 0x7A25, 0x76C3, 0x71F0, 0x6C58, 
    0x66A5, 0x6184, 0x5C68, 0x56E4, 0x51CF, 0x4CCA, 0x4834, 0x4603, 0x461B, 
    0x46EC, 0x483F, 0x49DE, 0x4B95, 0x4D2E, 0x4E72, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xE875, 0xE85A, 0xE820, 0xE7E5, 
    0xE7CB, 0xE7F0, 0xE875, 0xE995, 0xEB45, 0xED34, 0xEF15, 0xF096, 0xF16B, 
    0xF1CF, 0xF230, 0xF28D, 0xF2E4, 0xF332, 0xF377, 0xF3AE, 0xFA8B, 0xFAE5, 
    0xFBAD, 0xFC74, 0xFCCF, 0xFC50, 0xFA8B, 0xF6B1, 0xF0F1, 0xEA57, 0xE3F1, 
    0xDECD, 0xDBF7, 0xDACA, 0xD9E5, 0xD943, 0xD8DB, 0xD8A8, 0xD8A0, 0xD8BF, 
    0x0985, 0x09AE, 0x0A08, 0x0A62, 0x0A8A, 0x0A51, 0x0985, 0x07C8, 0x052F, 
    0x0234, 0xFF51, 0xFCFE, 0xFBB7, 0xFB2F, 0xFAC7, 0xFA7E, 0xFA4F, 0xFA38, 
    0xFA35, 0xFA43, 0xF482, 0xF481, 0xF47E, 0xF47B, 0xF47A, 0xF47C, 0xF482, 
    0xF48F, 0xF4A3, 0xF4BA, 0xF4D0, 0xF4E1, 0xF4EB, 0xF4EF, 0xF4F2, 0xF4F4, 
    0xF4F6, 0xFFFE, 0x0001, 0xC170, 0x69A2, 0x67CA, 0xE2F9, 0xDC46, 0xD4C6, 
    0xCD8E, 0xC7B5, 0xC370, 0xC04D, 0xBE5E, 0xBDBA, 0xBDFC, 0xBE7B, 0xBE90, 
    0xBE0E, 0xBD51, 0xBC7C, 0xBBB7, 0xBB25, 0xBAED, 0x556A, 0x5646, 0x2784, 
    0x2481, 0x213D, 0x1E46, 0x1C27, 0x1BE7, 0x1CD8, 0x1CFB, 0x1B85, 0x1967, 
    0x173E, 0x15A7, 0x149E, 0x13B9, 0x12FD, 0x1271, 0x1218, 0x11FA, 0x009C, 
    0xFE2A, 0x77C8, 0x6EDF, 0x64DB, 0x5B26, 0x532A, 0x4CED, 0x47EC, 0x44C6, 
    0x438D, 0x438B, 0x443D, 0x451D, 0x4617, 0x4759, 0x48C4, 0x4A36, 0x4B92, 
    0x4CB6, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xE80C, 0xE89F, 0xEA0A, 0xEBDE, 
    0xEDA9, 0xEEFB, 0xEF62, 0xEE93, 0xECDB, 0xEAA9, 0xE86D, 0xE698, 0xE59A, 
    0xE53F, 0xE504, 0xE4E4, 0xE4DD, 0xE4E9, 0xE504, 0xE52C, 0x1904, 0x189A, 
    0x17B1, 0x16C8, 0x165E, 0x16F2, 0x1904, 0x1D85, 0x2440, 0x2BF9, 0x3375, 
    0x3979, 0x3CCA, 0x3E2B, 0x3F36, 0x3FF4, 0x406E, 0x40AA, 0x40B2, 0x408F, 
    0x0E48, 0x0E3E, 0x0E27, 0x0E10, 0x0E05, 0x0E14, 0x0E48, 0x0EBA, 0x0F63, 
    0x1026, 0x10E2, 0x117A, 0x11CD, 0x11F0, 0x120A, 0x121D, 0x1229, 0x122F, 
    0x1230, 0x122C, 0xE983, 0xE911, 0xE815, 0xE719, 0xE6A6, 0xE747, 0xE983, 
    0xEE61, 0xF5A6, 0xFDFE, 0x0614, 0x0C94, 0x1029, 0x11A6, 0x12C6, 0x1394, 
    0x1417, 0x1458, 0x1461, 0x143B, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xC5E3, 0xF549, 0xF5ED, 
    0xF75F, 0xF9FB, 0xFBBE, 0xF9B8, 0xF70E, 0xF5F3, 0xF549, 0xF4F2, 0xF54E, 
    0xF5FE, 0xF66A, 0xF6D0, 0xF734, 0xF798, 0xF7FF, 0xF86C, 0xF8E4, 0xF96A, 
    0xFC69, 0xFAF5, 0xF8AD, 0xF6A0, 0xF5C2, 0xF863, 0xFB77, 0xFCCB, 0xFD8F, 
    0xFDB4, 0xFC3F, 0xFA81, 0xF9E3, 0xF97B, 0xF92A, 0xF8D3, 0xF857, 0xF796, 
    0xF699, 0xF580, 0xBD44, 0xB7BE, 0xADDE, 0xA15D, 0x9A7A, 0xA7EB, 0xB80A, 
    0xBE37, 0xC156, 0xC1FE, 0xBCCB, 0xB62D, 0xB337, 0xB0A9, 0xAE68, 0xAC59, 
    0xAA61, 0xA864, 0xA64D, 0xA41F, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x1553, 0x109D, 0x0BA8, 
    0x0E43, 0x135C, 0x17DE, 0x1D97, 0x2611, 0x2F58, 0x35EB, 0x3750, 0x3601, 
    0x35EB, 0x3877, 0x3BF1, 0x3F9D, 0x42BD, 0x4496, 0x454F, 0x45A0, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xE453, 0xE873, 0xED3E, 0xEC59, 0xE9AB, 0xE756, 0xE449, 
    0xDFC3, 0xDACD, 0xD749, 0xD653, 0xD6CE, 0xD749, 0xD749, 0xD749, 0xD749, 
    0xD749, 0xD749, 0xD737, 0xD708, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x03D0, 
    0x036C, 0x02BE, 0x01E6, 0x0181, 0x02A9, 0x0401, 0x048F, 0x04DF, 0x04F5, 
    0x0473, 0x03EB, 0x03EF, 0x0415, 0x0447, 0x0472, 0x0481, 0x0460, 0x0413, 
    0x03AC, 0x03AB, 0x0401, 0x047C, 0x04DC, 0x04D2, 0x0393, 0x024E, 0x01DE, 
    0x01B9, 0x01D9, 0x02BD, 0x0392, 0x037B, 0x0316, 0x029C, 0x0248, 0x0253, 
    0x02F9, 0x041F, 0x057F, 0xBE37, 0xBA47, 0xB3CE, 0xAC52, 0xA9F5, 0xB8B6, 
    0xC88F, 0xCDE2, 0xCFAF, 0xCEDC, 0xC6F1, 0xBF57, 0xBF37, 0xC0B1, 0xC2E6, 
    0xC4F4, 0xC5FD, 0xC521, 0xC2A9, 0xBF8A, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x1927, 0x12C2, 0x0B42, 0x0C70, 0x1054, 0x13B5, 0x1826, 0x1EBC, 0x25F5, 
    0x2B14, 0x2C55, 0x2B7C, 0x2B14, 0x2BCB, 0x2CA3, 0x2DA8, 0x2EE3, 0x3060, 
    0x31FA, 0x3388, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xDF07, 0xE25F, 0xE5C2, 
    0xE37F, 0xDF5B, 0xDBAE, 0xD70A, 0xD02A, 0xC8A6, 0xC352, 0xC1DC, 0xC297, 
    0xC352, 0xC329, 0xC2D7, 0xC299, 0xC2AD, 0xC352, 0xC464, 0xC595, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x0000, 0xF901, 0xE8CE, 0xD881, 0xD166, 
    0xDA97, 0xECC6, 0xF6B1, 0xF6A7, 0xF61B, 0xF522, 0xF3D0, 0xF23A, 0xF07E, 
    0xEEB6, 0xED00, 0xEB79, 0xEA3D, 0xE96A, 0xE91E, 
}

local diveIndices = {
    0x0001, 0x0000, 0x0014, 0x0001, 0x0001, 0x0015, 0x0001, 0x0016, 0x0001, 
    0x0017, 0x0001, 0x0018, 0x0013, 0x0019, 0x0014, 0x002C, 0x0014, 0x0040, 
    0x0014, 0x0054, 0x0014, 0x0068, 0x0014, 0x007C, 0x0014, 0x0090, 0x0014, 
    0x00A4, 0x0014, 0x00B8, 0x0001, 0x00CC, 0x0001, 0x00CD, 0x0001, 0x00CE, 
    0x0014, 0x00CF, 0x0014, 0x00E3, 0x0014, 0x00F7, 0x0012, 0x010B, 0x0011, 
    0x011D, 0x0014, 0x012E, 0x0014, 0x0142, 0x0014, 0x0156, 0x0011, 0x016A, 
    0x0001, 0x017B, 0x0001, 0x017C, 0x0001, 0x017D, 0x0014, 0x017E, 0x0014, 
    0x0192, 0x0014, 0x01A6, 0x0014, 0x01BA, 0x0014, 0x01CE, 0x0014, 0x01E2, 
    0x0014, 0x01F6, 0x0014, 0x020A, 0x0014, 0x021E, 0x0013, 0x0232, 0x0013, 
    0x0245, 0x0001, 0x0258, 0x0014, 0x0259, 0x0014, 0x026D, 0x0014, 0x0281, 
    0x0012, 0x0295, 0x0014, 0x02A7, 0x0014, 0x02BB, 0x0013, 0x02CF, 0x0014, 
    0x02E2, 0x0014, 0x02F6, 0x0014, 0x030A, 0x0013, 0x031E, 0x0001, 0x0331, 
    0x0014, 0x0332, 0x0014, 0x0346, 0x0014, 0x035A, 0x0014, 0x036E, 0x0014, 
    0x0382, 0x0014, 0x0396, 0x0014, 0x03AA, 0x0014, 0x03BE, 0x0014, 0x03D2, 
    0x0014, 0x03E6, 0x0013, 0x03FA, 0x0014, 0x040D, 0x000A, 0x0421, 0x0011, 
    0x042B, 0x0014, 0x043C, 
}

smlua_anim_util_register_animation("MILNE_ANIM_DIVE",
    1,
    0,
    0,
    0,
    19,
    diveValues,
    diveIndices)

smlua_anim_util_register_animation("MILNE_ANIM_SLIDE_DIVE",
    1,
    0,
    0,
    19,
    19,
    diveValues,
    diveIndices)

smlua_anim_util_register_animation("MILNE_ANIM_SLOW_LAND_FROM_DIVE",
    1,
    0,
    0,
    0,
    37,
    {
    0x0000, 0xFF97, 0xFF97, 0xFF97, 0xFF97, 0xFF97, 0xFF98, 0xFF9C, 0xFFA2, 
    0xFFAA, 0xFFB3, 0xFFBE, 0xFFC8, 0xFFD3, 0xFFDE, 0xFFE8, 0xFFF2, 0xFFFF, 
    0x000F, 0x0020, 0x002F, 0x0039, 0x003F, 0x0042, 0x0044, 0x0047, 0x004B, 
    0x0052, 0x005D, 0x006B, 0x007A, 0x0087, 0x0092, 0x009B, 0x00A1, 0x00A5, 
    0x00A8, 0x00AA, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFD, 
    0xFFFC, 0xFFFB, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFF6, 
    0xFFF6, 0xFFF7, 0xFFFA, 0xFFFC, 0xFFFD, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x3FFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 
    0xFFFE, 0x0000, 0xFFF1, 0x0015, 0x00E8, 0x0444, 0x0755, 0x04AA, 0x015E, 
    0x008D, 0x0022, 0xFFFD, 0xFFFC, 0xFFFF, 0xFFFB, 0xFFF8, 0xFFF7, 0xFFF7, 
    0xFFF8, 0xFFFA, 0xFFFC, 0xFFFE, 0x0000, 0xFFFF, 0x7F62, 0x7DBD, 0x7DD6, 
    0x7DE5, 0x7DD4, 0x7D8D, 0x7CF9, 0x7C03, 0x7A94, 0x7896, 0x75F3, 0x7119, 
    0x6980, 0x609E, 0x57EB, 0x50DF, 0x4C93, 0x4A25, 0x4813, 0x462A, 0x44EB, 
    0x43EF, 0x43D6, 0x44F7, 0x469B, 0x484B, 0x4990, 0x49F2, 0x4983, 0x48B4, 
    0x479F, 0x465C, 0x4505, 0x43B4, 0x4282, 0x4188, 0x40DF, 0x40A1, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x004F, 0x00EF, 0x0166, 0x013E, 0x0000, 0xFCE6, 0xF839, 0xF30D, 
    0xEE7B, 0xEC6E, 0xEBFD, 0xECE1, 0xEF52, 0xF23C, 0xF562, 0xF887, 0xFB6F, 
    0xFDDC, 0xFF92, 0x0091, 0x0112, 0x0133, 0x010F, 0x00C2, 0x0069, 0x001E, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x001B, 
    0x0048, 0x0051, 0xFFFF, 0xFD2F, 0x00A4, 0x03BE, 0x0414, 0x0410, 0x03CB, 
    0x035D, 0x02DE, 0x0266, 0x020F, 0x01C7, 0x0174, 0x011D, 0x00C7, 0x0079, 
    0x003A, 0x000F, 0xFFFF, 0xFD14, 0xFEA9, 0xFEE4, 0xFF4B, 0xFFE2, 0x00AB, 
    0x01AB, 0x02E4, 0x045C, 0x0614, 0x0811, 0x0B4F, 0x1025, 0x1599, 0x1AB2, 
    0x1E79, 0x2037, 0x208D, 0x2087, 0x212F, 0x2534, 0x2661, 0x25EC, 0x2408, 
    0x21D4, 0x1F6B, 0x1CEB, 0x1A6E, 0x1813, 0x15F5, 0x13E1, 0x11A7, 0x0F68, 
    0x0D46, 0x0B64, 0x09E1, 0x08E1, 0x0884, 0x01B4, 0x01B7, 0x01B6, 0x01B5, 
    0x01B3, 0x01B1, 0x01B0, 0x01AF, 0x01B0, 0x01B2, 0x01B6, 0x0175, 0x00F2, 
    0x0097, 0x00CC, 0x01FD, 0x0503, 0x0992, 0x0E5D, 0x1215, 0x1450, 0x1567, 
    0x153A, 0x13D7, 0x11A0, 0x0EEB, 0x0C10, 0x087E, 0x0474, 0x017E, 0x0008, 
    0xFF45, 0xFEF0, 0xFEC3, 0xFEDA, 0xFF49, 0xFFC5, 0x0000, 0x0165, 0x0165, 
    0x0167, 0x0169, 0x016B, 0x016C, 0x016D, 0x016D, 0x016B, 0x0167, 0x0160, 
    0x0153, 0x013E, 0x0124, 0x0108, 0x00EE, 0x00B5, 0x0065, 0x003F, 0x0086, 
    0x01E4, 0x03DC, 0x04F2, 0x04B9, 0x03ED, 0x02CC, 0x0197, 0xFFE3, 0xFDE5, 
    0xFCCD, 0xFD12, 0xFE05, 0xFF21, 0xFFE2, 0x0020, 0x0024, 0x000E, 0x0000, 
    0xD8CA, 0xD8D4, 0xD8B1, 0xD884, 0xD855, 0xD82D, 0xD817, 0xD81B, 0xD844, 
    0xD899, 0xD926, 0xDA4B, 0xDC2A, 0xDE71, 0xE0CD, 0xE2EC, 0xE4F8, 0xE718, 
    0xE8F3, 0xEA31, 0xEA46, 0xE978, 0xE8A6, 0xE7E2, 0xE6F7, 0xE653, 0xE663, 
    0xE7BB, 0xEA13, 0xEC93, 0xEF0C, 0xF1B2, 0xF443, 0xF67E, 0xF886, 0xFA6C, 
    0xFBD4, 0xFC61, 0xFFFE, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0001, 0x0001, 0x0001, 0x004C, 0x00E2, 0x0153, 0x012D, 0x0001, 
    0xF839, 0xF32C, 0xF842, 0xFF94, 0x0817, 0x10B1, 0x1857, 0x1DF7, 0x2081, 
    0x2080, 0x1F59, 0x1D3F, 0x1A65, 0x16FE, 0x133D, 0x0F57, 0x0B7D, 0x07E3, 
    0x04BD, 0x023E, 0x0099, 0x0001, 0x0001, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x0038, 0x00A5, 0x00F7, 
    0x00DB, 0xFFFE, 0xFBAD, 0xF6AD, 0xF3CF, 0xF0C5, 0xEDCE, 0xEB2B, 0xE91C, 
    0xE7E0, 0xE7B8, 0xE886, 0xE9EF, 0xEBD4, 0xEE17, 0xF09C, 0xF344, 0xF5F2, 
    0xF888, 0xFAE8, 0xFCF5, 0xFE91, 0xFF9D, 0xFFFE, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC148, 
    0xC0F7, 0xC0BB, 0xC0CF, 0xC170, 0xC591, 0xC84A, 0xC5AF, 0xC1EA, 0xBD88, 
    0xB917, 0xB522, 0xB238, 0xB0E5, 0xB0E2, 0xB176, 0xB286, 0xB3F9, 0xB5B5, 
    0xB79E, 0xB99C, 0xBB93, 0xBD69, 0xBF05, 0xC04B, 0xC122, 0xC170, 0x34B2, 
    0x3484, 0x33F3, 0x3309, 0x31CA, 0x303C, 0x2E63, 0x2C46, 0x29E8, 0x2750, 
    0x2483, 0x2185, 0x1E5C, 0x1A6C, 0x1520, 0x0E87, 0x06B2, 0xFDAD, 0xF2E5, 
    0xE64A, 0xD8C3, 0xCB39, 0xBE91, 0xB3B2, 0xAB86, 0xA525, 0x9F17, 0x9963, 
    0x1414, 0x0F30, 0x0ABF, 0x06CB, 0x035C, 0x007A, 0xFE2D, 0xFC7F, 0xFB76, 
    0xFB1C, 0xEDCB, 0xEDFF, 0xEE8D, 0xEF61, 0xF066, 0xF189, 0xF2B5, 0xF3D6, 
    0xF4D7, 0xF5A3, 0xF628, 0xF650, 0xF607, 0xF454, 0xF0E0, 0xEC8B, 0xE835, 
    0xE4BE, 0xE234, 0xDFFC, 0xDDF4, 0xDBFC, 0xD9F2, 0xD7B4, 0xD522, 0xD217, 
    0xCE9A, 0xCACA, 0xB938, 0xBD53, 0xC164, 0xC54F, 0xC8F3, 0xCC32, 0xCEEE, 
    0xD108, 0xD261, 0xD2DB, 0x4E72, 0x4EB6, 0x4F87, 0x50DE, 0x52B7, 0x550C, 
    0x57DA, 0x5B1C, 0x5ECE, 0x62EB, 0x676E, 0x6C55, 0x7199, 0x7911, 0x83C3, 
    0x9079, 0x9DF3, 0xAAF8, 0xB814, 0xC637, 0xD4C0, 0xE30B, 0xF077, 0xFC61, 
    0x062A, 0x0EB8, 0x1752, 0x1FD8, 0xA829, 0xB025, 0xB7AB, 0xBE9B, 0xC4D3, 
    0xCA32, 0xCE99, 0xD1E7, 0xD3FA, 0xD4B3, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF3AE, 0xF1A4, 
    0xF1F5, 0xF261, 0xF2D4, 0xF338, 0xF378, 0xF37F, 0xF339, 0xF28E, 0xF16B, 
    0xE21F, 0xE2C2, 0xE5CF, 0xE950, 0xEB4F, 0xE95F, 0xE5A8, 0xE277, 0xDEFC, 
    0xDB6D, 0xD7FE, 0xD4E4, 0xD255, 0xD085, 0xCF40, 0xCE2A, 0xCD40, 0xCC7F, 
    0xCBE1, 0xCB64, 0xCB04, 0xCABD, 0xCA8B, 0xCA6B, 0xCA58, 0xCA50, 0xCA4E, 
    0xD8BF, 0xDD1F, 0xE076, 0xE57D, 0xEBC4, 0xF2DB, 0xFA53, 0x01BB, 0x08A2, 
    0x0E99, 0x1330, 0x15F7, 0x1740, 0x17BC, 0x1783, 0x16B1, 0x1560, 0x13AA, 
    0x11A9, 0x0F77, 0x0D30, 0x0AED, 0x08C8, 0x06DC, 0x0543, 0x03B5, 0x01EB, 
    0xFFFE, 0xFE08, 0xFC21, 0xFA63, 0xF8E8, 0xF7C8, 0xF71E, 0xF847, 0xFB5B, 
    0xFE89, 0x0000, 0xFA43, 0xFBAC, 0xFB8F, 0xFB66, 0xFB33, 0xFAFE, 0xFACA, 
    0xFA9D, 0xFA7B, 0xFA69, 0xFA6D, 0xFA8B, 0xFACD, 0xFB31, 0xFBB2, 0xFC46, 
    0xFCE6, 0xFD8A, 0xFE2B, 0xFEC0, 0xFF42, 0xFFA9, 0xFFED, 0x0007, 0xFFEE, 
    0xFF79, 0xFE99, 0xFD68, 0xFC05, 0xFA8B, 0xF918, 0xF7C6, 0xF6B4, 0xF5FE, 
    0xF642, 0xF77D, 0xF8D7, 0xF97B, 0xF4F6, 0xF502, 0xF488, 0xF3CE, 0xF2E2, 
    0xF1D3, 0xF0AE, 0xEF81, 0xEE5C, 0xED4B, 0xEC5E, 0xEBA1, 0xEAF7, 0xEA3D, 
    0xE979, 0xE8B4, 0xE7F4, 0xE742, 0xE6A4, 0xE623, 0xE5C5, 0xE591, 0xE591, 
    0xE5CA, 0xE645, 0xE759, 0xE936, 0xEBA0, 0xEE5F, 0xF138, 0xF3F4, 0xF657, 
    0xF82A, 0xF932, 0xF7B0, 0xF3A6, 0xEF78, 0xED8B, 0xFFFE, 0x0001, 0xC170, 
    0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC15E, 0xC13A, 0xC11F, 0xC128, 0xC170, 0xC1F9, 0xC2AB, 0xC378, 
    0xC452, 0xC52E, 0xC5FD, 0xC6B2, 0xC73F, 0xC799, 0xC79F, 0xC74E, 0xC6C3, 
    0xC61A, 0xC56F, 0xC4DF, 0xC455, 0xC3B5, 0xC30E, 0xC271, 0xC1EC, 0xC192, 
    0xC170, 0xBAED, 0xBAE4, 0xBAD1, 0xBAC1, 0xBAC0, 0xBAD9, 0xBB19, 0xBB8C, 
    0xBC3F, 0xBD3C, 0xBE90, 0xC170, 0x4622, 0x4B4C, 0xCF97, 0xD1AC, 0xD18F, 
    0xD064, 0xCE7E, 0xCC30, 0x49CD, 0x47A8, 0x4615, 0x4566, 0x45F0, 0x4865, 
    0xCCCF, 0xD281, 0xD8CE, 0xDF08, 0xE481, 0xE9E7, 0xEFFB, 0xF62F, 0xFBF8, 
    0x00C9, 0x0413, 0x054B, 0x11FA, 0x1202, 0x1219, 0x1243, 0x127E, 0x12CE, 
    0x1332, 0x13AC, 0x143C, 0x14E5, 0x15A7, 0x16D5, 0x6773, 0x6578, 0x1C7A, 
    0x1E1B, 0x1F89, 0x210C, 0x2294, 0x2412, 0x5A8A, 0x594D, 0x5848, 0x5789, 
    0x571F, 0x578B, 0x2711, 0x2531, 0x2351, 0x21ED, 0x2182, 0x223F, 0x23CA, 
    0x25CC, 0x27F0, 0x29E2, 0x2B4B, 0x2BD6, 0x4CB6, 0x4C7A, 0x4BF1, 0x4B4D, 
    0x4AC1, 0x4A83, 0x4AC7, 0x4BC1, 0x4DA5, 0x50A8, 0x54FE, 0x5E90, 0xEE52, 
    0x0017, 0x8F9E, 0x98B8, 0x9BF1, 0x9CFD, 0x9C63, 0x9AAB, 0x185D, 0x15FE, 
    0x1417, 0x132E, 0x13CC, 0x165C, 0x9A8C, 0x9FC9, 0xA581, 0xAB1D, 0xB00B, 
    0xB4E0, 0xBA43, 0xBFBB, 0xC4CF, 0xC905, 0xCBE5, 0xCCF5, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xE52C, 
    0xE588, 0xE57C, 0xE56C, 0xE55B, 0xE54D, 0xE544, 0xE544, 0xE551, 0xE56C, 
    0xE59A, 0xE6A3, 0xE892, 0xEA50, 0xEAC6, 0xE8DD, 0xE351, 0xDADB, 0xD163, 
    0xC8CD, 0xC2FF, 0xC136, 0xC257, 0xC4C1, 0xC6D7, 0xC884, 0xCA99, 0xCCC5, 
    0xCEB9, 0xD027, 0xD0C0, 0xD051, 0xCF12, 0xCD54, 0xCB6B, 0xC9A8, 0xC85D, 
    0xC7DC, 0x408F, 0x3BCC, 0x389A, 0x33C3, 0x2DAD, 0x26BD, 0x1F5A, 0x17E7, 
    0x10CD, 0x0A6F, 0x0534, 0x0182, 0xFFBE, 0x0D54, 0x26BD, 0x32EA, 0x2B1C, 
    0x1BE8, 0x0943, 0xF71E, 0xE96D, 0xE0DF, 0xDB45, 0xD84A, 0xD794, 0xD8EC, 
    0xDBEC, 0xDFFC, 0xE482, 0xE8E8, 0xEC94, 0xEFF0, 0xF399, 0xF744, 0xFAA3, 
    0xFD6B, 0xFF4E, 0xFFFF, 0x122C, 0x11C3, 0x1212, 0x128B, 0x1327, 0x13E0, 
    0x14AD, 0x1587, 0x1667, 0x1744, 0x1818, 0x18DB, 0x1986, 0x1A1E, 0x1A96, 
    0x1AC9, 0x1AAC, 0x1A62, 0x1A09, 0x19BF, 0x199F, 0x1A2F, 0x1B37, 0x1BBD, 
    0x1ACA, 0x1818, 0x1463, 0x1029, 0x0BEE, 0x0832, 0x0577, 0x03A6, 0x0247, 
    0x014C, 0x00A3, 0x003E, 0x000C, 0xFFFF, 0x143B, 0x0FD0, 0x0E23, 0x0B95, 
    0x0859, 0x04A2, 0x00A2, 0xFC8B, 0xF890, 0xF4E3, 0xF1B7, 0xEF3F, 0xEDAC, 
    0xF2CC, 0xFCD2, 0x0086, 0xFAEE, 0xF1CF, 0xE70A, 0xDC81, 0xD417, 0xCD8C, 
    0xC806, 0xC482, 0xC3F8, 0xC679, 0xCAEB, 0xD08B, 0xD696, 0xDC4A, 0xE0E3, 
    0xE4CE, 0xE8CD, 0xECA1, 0xF00B, 0xF2CA, 0xF49E, 0xF548, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
    0xC5E3, 0xC5E3, 0xC5E1, 0xC5DD, 0xC5DA, 0xC5DB, 0xC5E3, 0xC5F7, 0xC615, 
    0xC636, 0xC650, 0xC647, 0xC62B, 0xC61A, 0xC5E3, 0xC56D, 0xC4E6, 0xC454, 
    0xC3BA, 0xC31B, 0xC27D, 0xC1E2, 0xC14F, 0xC0C8, 0xC050, 0xBFEC, 0xBFA0, 
    0xBF6F, 0xBF5E, 0xF96A, 0xF98A, 0xF9E0, 0xFA60, 0xFAFA, 0xFBA3, 0xFC4C, 
    0xFCE7, 0xFD68, 0xFDC0, 0xFDE2, 0xFD22, 0xFB75, 0xF9B9, 0xF8CC, 0xF990, 
    0xFD94, 0x0428, 0x0AC9, 0x0EF4, 0x040A, 0xFCB2, 0x01A8, 0x0538, 0x0277, 
    0xFF18, 0xFB3B, 0xF704, 0xF293, 0xEE0B, 0xE98D, 0xE53B, 0xE137, 0xDDA2, 
    0xDA9D, 0xD84C, 0xD6D0, 0xD649, 0xF580, 0xF53D, 0xF486, 0xF372, 0xF21B, 
    0xF098, 0xEF03, 0xED74, 0xEC04, 0xEACB, 0xE9E1, 0xE986, 0xE9B5, 0xEA26, 
    0xEA8F, 0xEAA7, 0xEA46, 0xE99F, 0xE8ED, 0xE86D, 0xE903, 0xEAE1, 0xEAB5, 
    0xEA5A, 0xEA74, 0xEA95, 0xEABC, 0xEAE7, 0xEB15, 0xEB44, 0xEB73, 0xEBA1, 
    0xEBCB, 0xEBF1, 0xEC11, 0xEC2A, 0xEC3A, 0xEC40, 0xA41F, 0xA3AA, 0xA269, 
    0xA08C, 0x9E41, 0x9BB6, 0x991A, 0x969C, 0x9469, 0x92B1, 0x91A2, 0x9225, 
    0x944E, 0x970F, 0x9958, 0x9A1C, 0x982F, 0x945C, 0x9080, 0x8E79, 0x97A3, 
    0x9638, 0x8AA2, 0x8366, 0x85D3, 0x8911, 0x8CF7, 0x915C, 0x9618, 0x9B02, 
    0x9FF1, 0xA4BC, 0xA93A, 0xAD43, 0xB0AD, 0xB350, 0xB503, 0xB59D, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x45A0, 
    0x457F, 0x452B, 0x44BC, 0x4448, 0x43E7, 0x43AF, 0x43B7, 0x4416, 0x44E4, 
    0x4637, 0x491F, 0x4DF1, 0x53AC, 0x594F, 0x5DD8, 0x6167, 0x6473, 0x6682, 
    0x6717, 0x5C47, 0x65A9, 0x62E4, 0x5DD8, 0x598C, 0x54CA, 0x4FB3, 0x4A66, 
    0x4503, 0x3FAA, 0x3A7B, 0x3596, 0x311A, 0x2D27, 0x29DE, 0x275D, 0x25C6, 
    0x2537, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x000C, 0x0024, 0x0036, 0x0030, 0xFFFF, 0x0012, 
    0xFDEB, 0xF35E, 0xED0D, 0xFD5B, 0x0CDF, 0x0365, 0xF5AC, 0xF9E3, 0xF9EF, 
    0xF93C, 0xF909, 0xF99C, 0xFA5C, 0xFB3B, 0xFC29, 0xFD1A, 0xFDFF, 0xFECA, 
    0xFF6D, 0xFFD8, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFDA, 0xFF8E, 0xFF55, 0xFF68, 
    0xFFFF, 0x04BB, 0x0676, 0xF922, 0xEBAA, 0xEB5E, 0xF0FA, 0xFAE9, 0x0570, 
    0x07DD, 0x06CE, 0x051E, 0x03E8, 0x034F, 0x02BA, 0x022D, 0x01A9, 0x0132, 
    0x00CB, 0x0076, 0x0036, 0x000E, 0xFFFF, 0xD708, 0xD6F2, 0xD6B9, 0xD66D, 
    0xD61D, 0xD5D9, 0xD5B0, 0xD5B0, 0xD5EB, 0xD66E, 0xD749, 0xD96F, 0xDD18, 
    0xE13B, 0xE4CC, 0xE6C4, 0xE395, 0xDD0B, 0xD8A6, 0xCF3D, 0xB500, 0x9D6B, 
    0x9DCB, 0xA4DA, 0xA5B7, 0xA6FA, 0xA856, 0xAA0A, 0xAC3A, 0xAEC3, 0xB182, 
    0xB455, 0xB719, 0xB9AB, 0xBBE7, 0xBDAC, 0xBED5, 0xBF3F, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xBF5E, 0x03AC, 0x03A2, 0x0386, 0x0356, 0x0311, 0x02B5, 
    0x0242, 0x01B7, 0x0112, 0x0052, 0xFF77, 0xFE13, 0xFC02, 0xF9B0, 0xF78A, 
    0xF5FA, 0xF4D0, 0xF3A6, 0xF29A, 0xF1CB, 0xF157, 0xF15C, 0xF1FA, 0xF3AE, 
    0xF690, 0xFA23, 0xFDE9, 0x0167, 0x04DD, 0x086F, 0x0B79, 0x0E38, 0x112D, 
    0x141C, 0x16CB, 0x18FF, 0x1A7C, 0x1B09, 0x057F, 0x05C5, 0x068C, 0x07C0, 
    0x094F, 0x0B25, 0x0D31, 0x0F5F, 0x119C, 0x13D5, 0x15F9, 0x18E0, 0x1CC7, 
    0x20B0, 0x239B, 0x248A, 0x2363, 0x20FF, 0x1DCA, 0x1A30, 0x169E, 0x1382, 
    0x1146, 0x102D, 0x0FEF, 0x1031, 0x1093, 0x10B8, 0x109C, 0x1083, 0x1081, 
    0x1096, 0x10B6, 0x10DC, 0x1102, 0x1123, 0x113B, 0x1144, 0xBF8A, 0xBEC4, 
    0xBC9D, 0xB95A, 0xB53E, 0xB08D, 0xAB89, 0xA676, 0xA199, 0x9D33, 0x9989, 
    0x96CE, 0x94C9, 0x931F, 0x9173, 0x8F68, 0x8CB1, 0x8976, 0x860E, 0x82CE, 
    0x800E, 0x7E1F, 0x7D5E, 0x7E8A, 0x81A6, 0x85E7, 0x8A82, 0x8EAF, 0x92DA, 
    0x9747, 0x9AF3, 0x9E15, 0xA166, 0xA4A9, 0xA79F, 0xAA09, 0xABAA, 0xAC43, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x3388, 0x33CF, 0x349A, 0x35DB, 0x3783, 0x3984, 0x3BD0, 0x3E58, 
    0x410D, 0x43E3, 0x46C9, 0x4B06, 0x50FB, 0x5744, 0x5C7B, 0x5F3B, 0x5FA1, 
    0x5EE7, 0x5D4E, 0x5B19, 0x588A, 0x55E4, 0x536A, 0x50E7, 0x4E03, 0x4ACB, 
    0x474A, 0x438C, 0x3ECF, 0x3953, 0x34AA, 0x30B0, 0x2C6D, 0x2835, 0x245B, 
    0x2134, 0x1F12, 0x1E4A, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFAA, 0xFF00, 0xFE80, 0xFEAB, 
    0xFFFF, 0x03B3, 0x0958, 0x0EFF, 0x12B9, 0x0A91, 0x0BC4, 0x0D8E, 0x0CB5, 
    0x0B60, 0x09CD, 0x0835, 0x06D4, 0x05B8, 0x04C7, 0x0402, 0x0348, 0x0284, 
    0x01C2, 0x0113, 0x0084, 0x0023, 0x0000, 0x0000, 0xFFEC, 0xFFBB, 0xFF78, 
    0xFF31, 0xFEF2, 0xFEC9, 0xFEC3, 0xFEEC, 0xFF51, 0xFFFF, 0x01E4, 0x052B, 
    0x08C3, 0x0B9B, 0x0CA1, 0x0ABB, 0x0692, 0x01BD, 0xFDCF, 0xFDE1, 0xFD1D, 
    0xFCA4, 0xFCF7, 0xFD80, 0xFE20, 0xFEB8, 0xFF2A, 0xFF59, 0xFF56, 0xFF4C, 
    0xFF4B, 0xFF47, 0xFF41, 0xFF3B, 0xFF35, 0xFF31, 0xFF2F, 0xC595, 0xC60C, 
    0xC74E, 0xC924, 0xCB58, 0xCDB4, 0xD002, 0xD20C, 0xD39A, 0xD478, 0xD46F, 
    0xD258, 0xCDE9, 0xC832, 0xC246, 0xBD36, 0xB8F7, 0xB4E5, 0xB12A, 0xADF4, 
    0xAEB8, 0xB5E3, 0xBB4B, 0xBB3B, 0xB9C1, 0xB7B3, 0xB5E7, 0xB534, 0xB6A4, 
    0xB992, 0xBC4D, 0xBE91, 0xC117, 0xC3A7, 0xC607, 0xC800, 0xC958, 0xC9D7, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 
    0xFFFB, 0xFFF8, 0xFFF5, 0xFFF1, 0xFFED, 0xFFE9, 0xFFE5, 0xFFE0, 0xFFDC, 
    0xFFD8, 0xFFD4, 0xFFD1, 0xFFCE, 0xFFCB, 0xFFC9, 0xFFC7, 0xFFC6, 0xFFC6, 
    0xFFC6, 0xFFC6, 0xFFC6, 0xFFC7, 0xFFC9, 0xFFCB, 0xFFCE, 0xFFD3, 0xFFD8, 
    0xFFDE, 0xFFE4, 0xFFEB, 0xFFF1, 0xFFF7, 0xFFFB, 0xFFFE, 0xFFFF, 0xFFFE, 
    0xFFFD, 0xFFFA, 0xFFF5, 0xFFEE, 0xFFE6, 0xFFDC, 0xFFD2, 0xFFC7, 0xFFBB, 
    0xFFAF, 0xFFA3, 0xFF97, 0xFF8C, 0xFF81, 0xFF77, 0xFF6F, 0xFF68, 0xFF63, 
    0xFF5F, 0xFF5E, 0xFF60, 0xFF65, 0xFF6C, 0xFF76, 0xFF82, 0xFF8F, 0xFF9D, 
    0xFFAC, 0xFFBA, 0xFFC8, 0xFFD6, 0xFFE1, 0xFFEB, 0xFFF4, 0xFFFA, 0xFFFE, 
    0xFFFF, 0xE91E, 0xE917, 0xE904, 0xE8E5, 0xE8BC, 0xE88C, 0xE854, 0xE816, 
    0xE7D4, 0xE790, 0xE74A, 0xE704, 0xE6BF, 0xE67E, 0xE640, 0xE608, 0xE5D7, 
    0xE5AF, 0xE590, 0xE57D, 0xE576, 0xE5B9, 0xE676, 0xE79F, 0xE923, 0xEAF4, 
    0xED01, 0xEF3A, 0xF18D, 0xF3E9, 0xF63C, 0xF874, 0xFA81, 0xFC52, 0xFDD7, 
    0xFEFF, 0xFFBC, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x0025, 0x0001, 0x0018, 0x0026, 0x0001, 0x003E, 0x0001, 
    0x003F, 0x0001, 0x0040, 0x0026, 0x0041, 0x0026, 0x0067, 0x0026, 0x008D, 
    0x0026, 0x00B3, 0x0026, 0x00D9, 0x0026, 0x00FF, 0x0026, 0x0125, 0x0026, 
    0x014B, 0x0026, 0x0171, 0x0026, 0x0197, 0x0026, 0x01BD, 0x0026, 0x01E3, 
    0x0026, 0x0209, 0x0026, 0x022F, 0x0026, 0x0255, 0x0025, 0x027B, 0x0025, 
    0x02A0, 0x0026, 0x02C5, 0x0026, 0x02EB, 0x0026, 0x0311, 0x0026, 0x0337, 
    0x0001, 0x035D, 0x0001, 0x035E, 0x0026, 0x035F, 0x0026, 0x0385, 0x0026, 
    0x03AB, 0x0026, 0x03D1, 0x0025, 0x03F7, 0x0024, 0x041C, 0x0026, 0x0440, 
    0x0026, 0x0466, 0x0026, 0x048C, 0x0026, 0x04B2, 0x0024, 0x04D8, 0x0026, 
    0x04FC, 0x0026, 0x0522, 0x0026, 0x0548, 0x0026, 0x056E, 0x0026, 0x0594, 
    0x0025, 0x05BA, 0x0023, 0x05DF, 0x0026, 0x0602, 0x0026, 0x0628, 0x0026, 
    0x064E, 0x0026, 0x0674, 0x0026, 0x069A, 0x0026, 0x06C0, 0x0001, 0x06E6, 
    0x0026, 0x06E7, 0x0026, 0x070D, 0x0026, 0x0733, 0x0026, 0x0759, 0x0023, 
    0x077F, 0x0026, 0x07A2, 0x0026, 0x07C8, 0x0026, 0x07EE, 0x0026, 0x0814, 
    0x0026, 0x083A, 0x0026, 0x0860, 0x0026, 0x0886, 0x0026, 0x08AC, 0x0026, 
    0x08D2, 0x0026, 0x08F8, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLOW_LEDGE_GRAB",
    1,
    0,
    0,
    0,
    33,
    {
    0x0007, 0x0006, 0x0005, 0x0002, 0xFFFE, 0xFFFA, 0xFFF5, 0xFFF0, 0xFFEA, 
    0xFFE4, 0xFFDF, 0xFFD9, 0xFFD3, 0xFFCE, 0xFFC9, 0xFFC5, 0xFFC1, 0xFFBE, 
    0xFFBD, 0xFFBC, 0xFFC6, 0xFFDA, 0xFFED, 0xFFF5, 0xFFF7, 0xFFF3, 0xFFEB, 
    0xFFE7, 0xFFE8, 0xFFF5, 0x0000, 0x0002, 0x0001, 0x0000, 0xFE3E, 0xFE3E, 
    0xFE3F, 0xFE41, 0xFE44, 0xFE49, 0xFE4F, 0xFE56, 0xFE60, 0xFE6C, 0xFE7A, 
    0xFE8A, 0xFE9E, 0xFEB4, 0xFECE, 0xFEED, 0xFF11, 0xFF3D, 0xFF71, 0xFFB0, 
    0xFFF7, 0x003B, 0x006D, 0x0084, 0x0090, 0x00A0, 0x00B0, 0x00B8, 0x00B7, 
    0x00B0, 0x00AA, 0x00A9, 0x00A9, 0x00AA, 0xFFA4, 0xFFA4, 0xFFA5, 0xFFA5, 
    0xFFA6, 0xFFA7, 0xFFA9, 0xFFAA, 0xFFAB, 0xFFAD, 0xFFAE, 0xFFAF, 0xFFB0, 
    0xFFB0, 0xFFB1, 0xFFB2, 0xFFB4, 0xFFB8, 0xFFBF, 0xFFCA, 0xFFDE, 0xFFFA, 
    0x0013, 0x0020, 0x0025, 0x0027, 0x0029, 0x002F, 0x0036, 0x0000, 0x3FFF, 
    0x0000, 0xFF93, 0xFF8D, 0xFF8B, 0xFFA8, 0xFFFF, 0xFF35, 0xFD33, 0xFBFB, 
    0xFD90, 0x03F6, 0x101E, 0x2072, 0x3325, 0x466A, 0x5874, 0xE775, 0xF1A3, 
    0xEDFD, 0x5D1C, 0x4B98, 0x3CAA, 0x2CA3, 0x1DBC, 0x122E, 0x0B13, 0x0711, 
    0x04B0, 0x027D, 0x00B0, 0x0011, 0x0000, 0x0580, 0x05D5, 0x05ED, 0x046E, 
    0x0000, 0xF75E, 0xEBA9, 0xDF1A, 0xD3EA, 0xCC54, 0xC82D, 0xC595, 0xC42F, 
    0xC3A0, 0xC38D, 0xBC64, 0xBC93, 0xBD3A, 0xC370, 0xC823, 0xD283, 0xE03E, 
    0xEE0F, 0xF8B3, 0xFF58, 0x03BA, 0x0660, 0x07D6, 0x0644, 0x0243, 0xFFFF, 
    0x3F76, 0x3F10, 0x3E17, 0x3CE2, 0x3BC4, 0x3C2D, 0x3DF1, 0x3F04, 0x3D57, 
    0x36DB, 0x2A93, 0x1A19, 0x0741, 0xF3E2, 0xE1D1, 0x52E4, 0x48F0, 0x4C7D, 
    0xDDCD, 0xF24C, 0x0898, 0x2296, 0x3A90, 0x4AD4, 0x5055, 0x4EA1, 0x49E9, 
    0x4660, 0x4409, 0x414E, 0x3FFF, 0xFFDA, 0xFFD8, 0xFFD7, 0xFFE1, 0x0000, 
    0x0035, 0x007B, 0x00C9, 0x0117, 0x015E, 0x0175, 0x0153, 0x0122, 0x010C, 
    0x013B, 0x01D8, 0x030D, 0x07D9, 0x0EB3, 0x10F6, 0x096D, 0xFD4E, 0xF590, 
    0xF47C, 0xF5AF, 0xF81C, 0xFAB7, 0xFC73, 0xFD5F, 0xFE36, 0xFEEF, 0xFF80, 
    0xFFDE, 0x0000, 0xFC2F, 0xFBF4, 0xFBE4, 0xFCED, 0xFFFF, 0x0618, 0x0E70, 
    0x1751, 0x1F03, 0x23D1, 0x25CD, 0x266A, 0x2605, 0x24F8, 0x239E, 0x2253, 
    0x2171, 0x20B6, 0x1FA5, 0x1E3B, 0x1C5B, 0x1A23, 0x17EB, 0x15D4, 0x13BF, 
    0x11A9, 0x0F8E, 0x0D67, 0x0AE7, 0x07FF, 0x0512, 0x0282, 0x00B0, 0xFFFF, 
    0xFC1B, 0xFC48, 0xFCBB, 0xFD52, 0xFDED, 0xFE79, 0xFF02, 0xFF9B, 0x0056, 
    0x0144, 0x023B, 0x031B, 0x0404, 0x0517, 0x0675, 0x083F, 0x0A94, 0x0F36, 
    0x15E6, 0x1BC3, 0x2028, 0x23BB, 0x258A, 0x25D9, 0x2588, 0x2493, 0x22F5, 
    0x20AA, 0x1D0B, 0x180F, 0x129C, 0x0D9A, 0x09F0, 0x0884, 0x01E1, 0x01FE, 
    0x0206, 0x0184, 0x0000, 0xFCF7, 0xF8CC, 0xF461, 0xF099, 0xEE55, 0xED52, 
    0xECBC, 0xEC9C, 0xECFC, 0xEDE4, 0xEF5F, 0xF175, 0xF499, 0xF8EA, 0xFDF0, 
    0x0337, 0x0849, 0x0CAF, 0x0FF3, 0x0D40, 0x0865, 0x08B9, 0x08E2, 0x0449, 
    0x0000, 0xFF2A, 0xFF42, 0xFFB8, 0xFFFF, 0xFEFE, 0xFEEE, 0xFEEA, 0xFF30, 
    0x0000, 0x0193, 0x03B5, 0x05FF, 0x080B, 0x0972, 0x0A46, 0x0AE2, 0x0B4B, 
    0x0B85, 0x0B96, 0x0B83, 0x0B4F, 0x0AD3, 0x09FE, 0x08F7, 0x07E2, 0x06E5, 
    0x0627, 0x05CD, 0x08B7, 0x0A5A, 0x02B9, 0xFB23, 0xFCB8, 0x0000, 0x0074, 
    0x0067, 0x0026, 0xFFFF, 0xEC5A, 0xEC20, 0xEB81, 0xEA92, 0xE969, 0xE7B4, 
    0xE575, 0xE33B, 0xE198, 0xE11A, 0xE1B7, 0xE2EA, 0xE48E, 0xE67E, 0xE896, 
    0xEAB1, 0xECAA, 0xEEF5, 0xF1D9, 0xF4F0, 0xF7D0, 0xFA12, 0xFB50, 0xFB21, 
    0xF06B, 0xE360, 0xE1CB, 0xE459, 0xE8AC, 0xEDB6, 0xF241, 0xF70C, 0xFAD6, 
    0xFC61, 0xFFFE, 0x0001, 0xC170, 0x2AD0, 0x2E13, 0x3184, 0x3499, 0x36C3, 
    0x37E5, 0x3868, 0x3888, 0x387E, 0x3886, 0x3843, 0x376E, 0x366D, 0x35A5, 
    0x3579, 0x364D, 0x3886, 0x3486, 0x3545, 0xD709, 0xD299, 0xE30F, 0x07A9, 
    0x0B33, 0x08C3, 0x056F, 0x01CF, 0xFE7C, 0xFC0D, 0xFB1C, 0xEA94, 0xE9E7, 
    0xE8F4, 0xE88E, 0xE98B, 0xEC7B, 0xF0C3, 0xF56F, 0xF98D, 0xFC2B, 0xFDE6, 
    0xFFB7, 0x013B, 0x0207, 0x01B8, 0xFFE5, 0xFC2B, 0xF0C9, 0xDDEA, 0xB3F7, 
    0xBFEB, 0xCCB4, 0xE2CB, 0xE06C, 0xDDD6, 0xDAE2, 0xD7EE, 0xD55C, 0xD38B, 
    0xD2DB, 0x60E1, 0x600A, 0x5F42, 0x5E5B, 0x5D24, 0x5B65, 0x5941, 0x5712, 
    0x5532, 0x53FC, 0x53C6, 0x545E, 0x5553, 0x5635, 0x5693, 0x55FB, 0x53FC, 
    0x578F, 0x56B6, 0xB790, 0xC5A7, 0xC162, 0xA4A2, 0xA4A5, 0xACF9, 0xB735, 
    0xC1D2, 0xCB4B, 0xD217, 0xD4B3, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF502, 0xF46D, 0xF3CE, 
    0xF343, 0xF2E6, 0xF2BF, 0xF2BA, 0xF2C9, 0xF2DC, 0xF2E6, 0xF381, 0xF4EA, 
    0xF688, 0xF7BE, 0xF7F2, 0xF688, 0xF2E6, 0xE5FF, 0xD166, 0xC171, 0xBB8D, 
    0xC342, 0xF66F, 0xF25F, 0xEB06, 0xE261, 0xD99C, 0xD1E4, 0xCC66, 0xCA4E, 
    0x17FE, 0x155E, 0x1294, 0x101F, 0x0E7D, 0x0DD0, 0x0DBA, 0x0DFB, 0x0E52, 
    0x0E7D, 0x0E8C, 0x0EAF, 0x0ED7, 0x0EF5, 0x0EFA, 0x0ED7, 0x0E7D, 0x0CBA, 
    0x0A38, 0x09AE, 0x0E45, 0x153A, 0x1BEC, 0x1D13, 0x17F4, 0x120D, 0x0C81, 
    0x069A, 0x01E9, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFF32, 0xFED0, 0xFE67, 
    0xFE0B, 0xFDCD, 0xFDB4, 0xFDB1, 0xFDBA, 0xFDC7, 0xFDCD, 0xFDD2, 0xFDDC, 
    0xFDE8, 0xFDF1, 0xFDF3, 0xFDE8, 0xFDCD, 0xFCF7, 0xFBE7, 0xFC5E, 0x01DA, 
    0x06DC, 0xFEF6, 0xEBF7, 0xF0AA, 0xF7B4, 0xF93F, 0xF9B8, 0xF9A0, 0xF97B, 
    0xF1E4, 0xF26D, 0xF2FE, 0xF37F, 0xF3D4, 0xF3F7, 0xF3FB, 0xF3EE, 0xF3DD, 
    0xF3D4, 0xF3DA, 0xF3EA, 0xF3FB, 0xF408, 0xF40A, 0xF3FB, 0xF3D4, 0xF322, 
    0xF21E, 0xF1BE, 0xF6C4, 0xF52B, 0xCACF, 0xD2B5, 0xDC57, 0xE403, 0xE804, 
    0xEB03, 0xECE4, 0xED8B, 0xFFFE, 0x0001, 0xC170, 0xC362, 0xC215, 0xC0B7, 
    0xBF7C, 0xBE99, 0xBD9D, 0xBC60, 0xBB87, 0x3BB9, 0x3D99, 0x41B5, 0x479B, 
    0x4E6D, 0x5551, 0x5B68, 0xDFD5, 0xE1BE, 0xDEF9, 0xD751, 0xCCD5, 0xC193, 
    0x32A9, 0x2126, 0x1511, 0x0F3F, 0x0B06, 0x0828, 0x0668, 0x0588, 0x054B, 
    0x10BB, 0x10DE, 0x10BA, 0x1124, 0x12F2, 0x1703, 0x1CB7, 0x22AB, 0x5886, 
    0x5642, 0x5657, 0x5783, 0x5992, 0x5C51, 0x5F8E, 0x1CEC, 0x1950, 0x1366, 
    0x0B36, 0x0450, 0x0244, 0x7640, 0x6840, 0x5BBE, 0x51E0, 0x473C, 0x3CF7, 
    0x3436, 0x2E1F, 0x2BD6, 0x5C92, 0x5BDD, 0x5B21, 0x5A73, 0x59E7, 0x58DF, 
    0x574B, 0x5617, 0xD62D, 0xD879, 0xDD48, 0xE3D5, 0xEB6E, 0xF361, 0xFAFC, 
    0x818C, 0x8660, 0x88C6, 0x88A3, 0x8626, 0x8180, 0xF745, 0xE916, 0xDEBC, 
    0xD95D, 0xD4EF, 0xD177, 0xCEF8, 0xCD76, 0xCCF5, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xF8AA, 0xF877, 0xF8C3, 0xF813, 0xF4EF, 0xEE20, 0xE4BE, 
    0xDAC4, 0xD22C, 0xCCF2, 0xCAE7, 0xCA51, 0xCAE2, 0xCC49, 0xCE35, 0xD056, 
    0xD25C, 0xD4C0, 0xD7FA, 0xDBB8, 0xDFA5, 0xE371, 0xE6C6, 0xE954, 0xEAC6, 
    0xEACA, 0xE4E0, 0xD8EC, 0xCD2B, 0xC7DC, 0xF32B, 0xF5A3, 0xF7E2, 0xFA92, 
    0xFE58, 0x03DF, 0x0AAB, 0x11AB, 0x17CE, 0x1C05, 0x1E9B, 0x2090, 0x21E6, 
    0x229E, 0x22BA, 0x223A, 0x2120, 0x1F60, 0x1D02, 0x1A29, 0x16F6, 0x138A, 
    0x1008, 0x0C91, 0x0946, 0x0648, 0x03BB, 0x01BF, 0x0075, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x066E, 0x06BB, 0x06FA, 0x0755, 0x07F4, 0x0910, 
    0x0A8A, 0x0C0A, 0x0D39, 0x0DBE, 0x0D9B, 0x0D1F, 0x0C62, 0x0B7D, 0x0A89, 
    0x099E, 0x08D5, 0x0819, 0x0749, 0x066B, 0x0585, 0x049D, 0x03BA, 0x02E2, 
    0x0219, 0x0168, 0x00D3, 0x0062, 0x0019, 0xFFFF, 0x0000, 0xFFFF, 0xF3C6, 
    0xF44A, 0xF4C2, 0xF553, 0xF627, 0xF772, 0xF915, 0xFABF, 0xFC1B, 0xFCD6, 
    0xFCF1, 0xFCB6, 0xFC3C, 0xFB9D, 0xFAF1, 0xFA52, 0xF9D6, 0xF970, 0xF902, 
    0xF88D, 0xF816, 0xF79F, 0xF72A, 0xF6BC, 0xF657, 0xF5FD, 0xF5B2, 0xF579, 
    0xF555, 0xF548, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xBF5E, 0xE71D, 0xE850, 0xEAFC, 0xEDC0, 0xEF3C, 0xEF0C, 0xEE09, 0xECA5, 
    0xEB53, 0xEA86, 0xEA4B, 0xEA51, 0xEA7D, 0xEAB4, 0xEADA, 0xEAD4, 0xEA86, 
    0xEA0C, 0xE990, 0xE90B, 0xE878, 0xE7CE, 0xE70A, 0xE623, 0xE514, 0xE3D7, 
    0xE265, 0xDF3C, 0xDA6D, 0xD649, 0xE79B, 0xE9F7, 0xEF20, 0xF42E, 0xF63D, 
    0xF453, 0xF03F, 0xEB4C, 0xE6C6, 0xE3F7, 0xE2E6, 0xE298, 0xE2CD, 0xE348, 
    0xE3CC, 0xE41B, 0xE3F7, 0xE355, 0xE265, 0xE143, 0xE008, 0xDECE, 0xDDB0, 
    0xDCC8, 0xDC31, 0xDC04, 0xDC5C, 0xDFE1, 0xE681, 0xEC40, 0x9BA3, 0x9FCB, 
    0xA966, 0xB430, 0xBBE1, 0xBFD3, 0xC277, 0xC427, 0xC53F, 0xC61A, 0xC6F5, 
    0xC7BF, 0xC854, 0xC896, 0xC863, 0xC799, 0xC61A, 0xC3C6, 0xC0B8, 0xBD23, 
    0xB939, 0xB52C, 0xB130, 0xAD76, 0xAA32, 0xA795, 0xA5D3, 0xA87A, 0xAF7C, 
    0xB59D, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x4A2F, 0x4409, 
    0x3602, 0x26B8, 0x1CCA, 0x1945, 0x1848, 0x190D, 0x1ACF, 0x1CCA, 0x1F08, 
    0x21F0, 0x254B, 0x28E0, 0x2C77, 0x2FD8, 0x32CB, 0x35B1, 0x38F2, 0x3C5F, 
    0x3FCB, 0x4306, 0x45E3, 0x4832, 0x49C6, 0x4A6F, 0x4A00, 0x420B, 0x329B, 
    0x2537, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBA4C, 
    0xBD25, 0xC3A4, 0xCAB8, 0xCF52, 0xD0D0, 0xD100, 0xD071, 0xCFB1, 0xCF52, 
    0xCF6E, 0xCFAF, 0xCFF9, 0xD031, 0xD03A, 0xCFF9, 0xCF52, 0xCE3F, 0xCCDB, 
    0xCB3B, 0xC974, 0xC79B, 0xC5C6, 0xC409, 0xC279, 0xC12B, 0xC034, 0xC141, 
    0xC3F5, 0xC55C, 0xBF3F, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xBF5E, 0x2333, 0x23DA, 0x24E2, 0x24E3, 0x2279, 0x1C94, 0x1441, 
    0x0B45, 0x0361, 0xFE5A, 0xFB53, 0xF88E, 0xF67F, 0xF599, 0xF64F, 0xF913, 
    0xFE5A, 0x0F77, 0x2AF8, 0xC125, 0x484F, 0x45C4, 0x31C5, 0x198C, 0x1ADA, 
    0x1B13, 0x1B10, 0x1B13, 0x1B0D, 0x1B09, 0x170B, 0x157C, 0x1235, 0x0F50, 
    0x0EE5, 0x11DB, 0x16D2, 0x1C7E, 0x2193, 0x24C6, 0x262D, 0x26D7, 0x26EF, 
    0x269C, 0x2609, 0x255F, 0x24C6, 0x23FE, 0x226A, 0x6053, 0x195D, 0x1386, 
    0x182A, 0x2263, 0x1EC7, 0x1838, 0x12E4, 0x115C, 0x1144, 0xAA09, 0xAD3B, 
    0xB3D5, 0xB95F, 0xB961, 0xB1CC, 0xA598, 0x97D1, 0x8B87, 0x83C6, 0x8039, 
    0x7E50, 0x7DC4, 0x7E51, 0x7FAF, 0x8198, 0x83C6, 0x8892, 0x90D4, 0x1A04, 
    0xA5AA, 0xAFC7, 0xAB2D, 0x96E5, 0x9DBB, 0xA14A, 0xA41A, 0xA70E, 0xA9E3, 
    0xAC43, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x2741, 0x275A, 0x27F8, 0x2992, 0x2CA2, 0x32AE, 0x3B3E, 0x43CC, 0x49D2, 
    0x4AC8, 0x45EB, 0x3D37, 0x3242, 0x26A4, 0x1BF3, 0x13C6, 0x0FB4, 0x18B6, 
    0x2C8A, 0x3BED, 0x3C06, 0x3824, 0x3C4A, 0x38E9, 0x3465, 0x26F1, 0x1C15, 
    0x1A91, 0x1C7D, 0x1E4A, 0xFFE9, 0xFFEC, 0xFFF3, 0xFFFB, 0xFFFF, 0x0001, 
    0x0001, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFC, 
    0xFFFD, 0xFFFF, 0x0052, 0x00A9, 0x0022, 0xFCB1, 0xF9B1, 0xFEFE, 0x012A, 
    0x050D, 0xFFF0, 0xFA59, 0xFB62, 0xFD71, 0x000B, 0x0000, 0xFF2F, 0xFF2F, 
    0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 
    0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF71, 0xFFB3, 0xFF32, 
    0xFC47, 0xF982, 0xFCB2, 0xF7AE, 0xF8CD, 0xF8E6, 0xF9C5, 0xFF88, 0x018F, 
    0xFF2F, 0xCE0A, 0xCD6D, 0xCC07, 0xCA80, 0xC983, 0xC930, 0xC926, 0xC945, 
    0xC96E, 0xC983, 0xC998, 0xC9CA, 0xCA03, 0xCA2D, 0xCA35, 0xCA03, 0xC983, 
    0xC750, 0xC40E, 0xC2B5, 0xC855, 0xCC7D, 0xBBB7, 0xC17E, 0xB978, 0xC03E, 
    0xC85C, 0xC86D, 0xC6CB, 0xC765, 0xC9D7, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFBB4, 0xFC8F, 
    0xFEED, 0x0285, 0x0707, 0x0C1C, 0x1164, 0x167A, 0x1AFC, 0x1E94, 0x20F2, 
    0x21CD, 0x1D41, 0x11D8, 0x03B7, 0xF820, 0xF389, 0xF3BE, 0xF428, 0xF4C0, 
    0xF582, 0xF668, 0xF76C, 0xF884, 0xF9A7, 0xFAC9, 0xFBE1, 0xFCE4, 0xFDCB, 
    0xFE8F, 0xFF2B, 0xFF9F, 0xFFE6, 0xFFFF, 0x0018, 0x0028, 0x0051, 0x0087, 
    0x00BA, 0x00DD, 0x00E8, 0x00D9, 0x00B7, 0x008F, 0x006E, 0x0061, 0x0110, 
    0x025F, 0x0317, 0x02E7, 0x02A8, 0x02B8, 0x02D3, 0x02F5, 0x0315, 0x032D, 
    0x0335, 0x0327, 0x0300, 0x02C0, 0x0267, 0x01FC, 0x0187, 0x0112, 0x00A7, 
    0x004F, 0x0015, 0xFFFF, 0xDAD8, 0xDAF5, 0xDB47, 0xDBC7, 0xDC6F, 0xDD31, 
    0xDDFD, 0xDEC2, 0xDF6E, 0xDFF3, 0xE049, 0xE068, 0xDFA9, 0xDD88, 0xDA97, 
    0xD833, 0xD776, 0xD820, 0xD96E, 0xDB4C, 0xDDA7, 0xE06D, 0xE38A, 0xE6E7, 
    0xEA6B, 0xEDFC, 0xF17D, 0xF4D3, 0xF7E4, 0xFA97, 0xFCD5, 0xFE89, 0xFF9E, 
    0x0000, 
    },
    {
    0x0022, 0x0000, 0x0022, 0x0022, 0x001D, 0x0044, 0x0001, 0x0061, 0x0001, 
    0x0062, 0x0001, 0x0063, 0x001F, 0x0064, 0x001F, 0x0083, 0x001F, 0x00A2, 
    0x0022, 0x00C1, 0x0022, 0x00E3, 0x0022, 0x0105, 0x0022, 0x0127, 0x0022, 
    0x0149, 0x0022, 0x016B, 0x0001, 0x018D, 0x0001, 0x018E, 0x0001, 0x018F, 
    0x001E, 0x0190, 0x001E, 0x01AE, 0x001E, 0x01CC, 0x0022, 0x01EA, 0x001F, 
    0x020C, 0x001E, 0x022B, 0x0021, 0x0249, 0x001E, 0x026A, 0x001E, 0x0288, 
    0x0001, 0x02A6, 0x0001, 0x02A7, 0x0001, 0x02A8, 0x001E, 0x02A9, 0x001E, 
    0x02C7, 0x001E, 0x02E5, 0x0022, 0x0303, 0x0022, 0x0325, 0x001E, 0x0347, 
    0x0022, 0x0365, 0x0020, 0x0387, 0x001E, 0x03A7, 0x001F, 0x03C5, 0x001E, 
    0x03E4, 0x0001, 0x0402, 0x001E, 0x0403, 0x001E, 0x0421, 0x001E, 0x043F, 
    0x001F, 0x045D, 0x001D, 0x047C, 0x001E, 0x0499, 0x001E, 0x04B7, 0x001F, 
    0x04D5, 0x001F, 0x04F4, 0x001F, 0x0513, 0x001E, 0x0532, 0x0001, 0x0550, 
    0x001E, 0x0551, 0x001D, 0x056F, 0x001E, 0x058C, 0x001F, 0x05AA, 0x001F, 
    0x05C9, 0x001E, 0x05E8, 0x001F, 0x0606, 0x001E, 0x0625, 0x001F, 0x0643, 
    0x001F, 0x0662, 0x001E, 0x0681, 0x001F, 0x069F, 0x0022, 0x06BE, 0x0022, 
    0x06E0, 0x0022, 0x0702, 
})

smlua_anim_util_register_animation("MILNE_ANIM_CLIMB_DOWN_LEDGE",
    1,
    0,
    0,
    0,
    9,
    {
    0x0000, 0x0000, 0x0001, 0x0002, 0x0004, 0x0005, 0x0006, 0x0006, 0x0007, 
    0x008F, 0x001D, 0xFF6B, 0xFEFB, 0xFEAC, 0xFE76, 0xFE56, 0xFE45, 0xFE3F, 
    0xFE3E, 0xFFF9, 0xFFEE, 0xFFD7, 0xFFC4, 0xFFB7, 0xFFAE, 0xFFA8, 0xFFA5, 
    0xFFA4, 0x0000, 0x3FFF, 0x0000, 0x5589, 0x487B, 0x3835, 0x1969, 0x011F, 
    0xFBC9, 0xFAC1, 0xFC3D, 0xFE71, 0xFF93, 0xDE18, 0xD19C, 0xCAAB, 0xD55E, 
    0xE396, 0xEC7E, 0xF593, 0xFD99, 0x0352, 0x0580, 0x3DF7, 0x33C6, 0x2DBF, 
    0x35BC, 0x3EE0, 0x408E, 0x40E7, 0x4078, 0x3FCE, 0x3F76, 0xCFA9, 0xCEFE, 
    0xD2FB, 0xE869, 0xFB8F, 0x001C, 0x01B0, 0x016B, 0x006E, 0xFFDA, 0x0EC2, 
    0x100A, 0x1158, 0x13D4, 0x1422, 0x0FB5, 0x0986, 0x0329, 0xFE31, 0xFC2F, 
    0xF8D8, 0xF1E1, 0xEE00, 0xF49F, 0xFBDF, 0xFD30, 0xFD68, 0xFCFD, 0xFC67, 
    0xFC1B, 0x3A19, 0x3B0D, 0x3DBE, 0x45E6, 0x4809, 0x3B44, 0x292F, 0x1678, 
    0x07CF, 0x01E1, 0xF0EE, 0xFA6D, 0x0547, 0x016E, 0xFBC7, 0xFB89, 0xFC43, 
    0xFD6E, 0xFE84, 0xFEFE, 0xF4BE, 0xF443, 0xF404, 0xF5B1, 0xF696, 0xF4D3, 
    0xF232, 0xEF6E, 0xED3E, 0xEC5A, 0xFFFE, 0x0001, 0xC170, 0x2709, 0xDD37, 
    0x909A, 0xFCD0, 0xF17F, 0xA62E, 0x2560, 0x274C, 0x29A9, 0x2AD0, 0xE3DC, 
    0xDA25, 0xDE09, 0xAD6B, 0xA98C, 0xADA5, 0xDB70, 0xE20E, 0xE800, 0xEA94, 
    0xA065, 0xD096, 0x1FBD, 0xBA98, 0xC593, 0xF1B6, 0x661A, 0x62E0, 0x614C, 
    0x60E1, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xE59A, 0xBE8A, 0xB4FF, 0xB578, 0xC35E, 0xD1A3, 
    0xE643, 0xEE04, 0xF327, 0xF502, 0x0000, 0x1A7D, 0xE5DA, 0xE7B5, 0xEB91, 
    0xFFAF, 0xFFCE, 0x08C7, 0x1312, 0x17FE, 0xF97B, 0xFC7E, 0xFB04, 0xFB8A, 
    0xF074, 0xFFF4, 0xFD61, 0xFDC4, 0xFEAF, 0xFF32, 0xED8B, 0xE780, 0xEEB6, 
    0xF029, 0xF45A, 0xEA85, 0xEE5C, 0xF018, 0xF163, 0xF1E4, 0xFFFE, 0x0001, 
    0xC170, 0x054B, 0xDEF3, 0x41FE, 0x348E, 0x49C0, 0xC075, 0xC786, 0xC7CB, 
    0xC521, 0xC362, 0x2BD6, 0x1E05, 0x6BCB, 0x7221, 0x6363, 0x1305, 0x0E23, 
    0x0DDA, 0x0F94, 0x10BB, 0xCCF5, 0x9EF3, 0xFC18, 0xEFFD, 0x046E, 0x658D, 
    0x6799, 0x6421, 0x5F20, 0x5C92, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xC7DC, 0xD03B, 0xD4FA, 
    0xCB41, 0xC518, 0xEAD3, 0xF14F, 0xF596, 0xF7F1, 0xF8AA, 0x0000, 0xFD14, 
    0xFC8D, 0x057C, 0x0C40, 0xF616, 0xF3FD, 0xF32B, 0xF314, 0xF32B, 0xFFFF, 
    0x00DA, 0x01BA, 0xFF07, 0x03A9, 0x1E80, 0x17FB, 0x1004, 0x0946, 0x066E, 
    0xF548, 0xF515, 0xF4E0, 0xF5A4, 0xF46C, 0xED2F, 0xEEF9, 0xF127, 0xF2FF, 
    0xF3C6, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xBF5E, 0xED51, 0xF036, 0xEF4B, 0xDFAF, 0xD2CE, 0xD42B, 
    0xD91D, 0xDF67, 0xE4D0, 0xE71D, 0xFF66, 0xF511, 0xEC7B, 0xE8B7, 0xE794, 
    0xE722, 0xE716, 0xE742, 0xE77D, 0xE79B, 0xAB33, 0xA233, 0x9EC9, 0xB04B, 
    0xBF17, 0xBB1E, 0xB24A, 0xA7E7, 0x9F41, 0x9BA3, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x2124, 0x1E8B, 
    0x1C3B, 0x18C7, 0x198E, 0x22D0, 0x2F66, 0x3C38, 0x462D, 0x4A2F, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xD195, 0xCE99, 0xCD63, 0xD36C, 0xD75E, 0xD29A, 0xCB2C, 0xC339, 0xBCE2, 
    0xBA4C, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xBF5E, 0x056C, 0x028B, 0xFAA6, 0x05A9, 0x1123, 0x16B9, 
    0x1BAA, 0x1F9F, 0x223F, 0x2333, 0x1EFC, 0x3240, 0x21A7, 0x293A, 0x305D, 
    0x2CC2, 0x265C, 0x1F3B, 0x196F, 0x170B, 0x87CF, 0x5D05, 0x8177, 0x9168, 
    0x9A12, 0x9F70, 0xA3DD, 0xA732, 0xA94D, 0xAA09, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x4FFE, 0x51AF, 0x4AA3, 
    0x23F3, 0x0728, 0x0742, 0x0ED1, 0x1987, 0x231B, 0x2741, 0x00D4, 0x06BC, 
    0x0084, 0xFFE7, 0x0051, 0x0038, 0x001C, 0x0003, 0xFFF0, 0xFFE9, 0xEDC0, 
    0xF6F0, 0xFF73, 0x001E, 0xFF5D, 0xFF52, 0xFF46, 0xFF3A, 0xFF32, 0xFF2F, 
    0x9A39, 0xBBDE, 0xABAF, 0xAF8D, 0xB6BB, 0xBC4C, 0xC278, 0xC830, 0xCC66, 
    0xCE0A, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFDD, 0xFF7F, 0xFEEF, 0xFE3C, 0xFD7C, 0xFCC8, 
    0xFC37, 0xFBD7, 0xFBB4, 0xFFFF, 0x0011, 0x0039, 0x0067, 0x0086, 0x008A, 
    0x0072, 0x004B, 0x0027, 0x0018, 0x0000, 0xFEC3, 0xFB6B, 0xF67D, 0xF08F, 
    0xEA48, 0xE45A, 0xDF6C, 0xDC13, 0xDAD8, 
    },
    {
    0x0009, 0x0000, 0x000A, 0x0009, 0x0009, 0x0013, 0x0001, 0x001C, 0x0001, 
    0x001D, 0x0001, 0x001E, 0x000A, 0x001F, 0x000A, 0x0029, 0x000A, 0x0033, 
    0x000A, 0x003D, 0x000A, 0x0047, 0x000A, 0x0051, 0x000A, 0x005B, 0x000A, 
    0x0065, 0x000A, 0x006F, 0x0001, 0x0079, 0x0001, 0x007A, 0x0001, 0x007B, 
    0x000A, 0x007C, 0x000A, 0x0086, 0x000A, 0x0090, 0x000A, 0x009A, 0x000A, 
    0x00A4, 0x000A, 0x00AE, 0x000A, 0x00B8, 0x000A, 0x00C2, 0x000A, 0x00CC, 
    0x0001, 0x00D6, 0x0001, 0x00D7, 0x0001, 0x00D8, 0x000A, 0x00D9, 0x000A, 
    0x00E3, 0x000A, 0x00ED, 0x000A, 0x00F7, 0x000A, 0x0101, 0x000A, 0x010B, 
    0x000A, 0x0115, 0x000A, 0x011F, 0x000A, 0x0129, 0x0009, 0x0133, 0x000A, 
    0x013C, 0x0001, 0x0146, 0x000A, 0x0147, 0x000A, 0x0151, 0x000A, 0x015B, 
    0x000A, 0x0165, 0x0009, 0x016F, 0x000A, 0x0178, 0x0009, 0x0182, 0x000A, 
    0x018B, 0x000A, 0x0195, 0x0009, 0x019F, 0x000A, 0x01A8, 0x0001, 0x01B2, 
    0x000A, 0x01B3, 0x000A, 0x01BD, 0x000A, 0x01C7, 0x0008, 0x01D1, 0x000A, 
    0x01D9, 0x000A, 0x01E3, 0x000A, 0x01ED, 0x000A, 0x01F7, 0x000A, 0x0201, 
    0x0008, 0x020B, 0x000A, 0x0213, 0x000A, 0x021D, 0x000A, 0x0227, 0x000A, 
    0x0231, 0x000A, 0x023B, 
})

smlua_anim_util_register_animation("MILNE_ANIM_IDLE_ON_LEDGE",
    0,
    0,
    0,
    0,
    49,
    {
    0x0007, 0x0008, 0x0008, 0x0009, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 
    0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x000F, 0x000F, 0x000E, 
    0x000E, 0x000D, 0x000D, 0x000C, 0x000C, 0x000B, 0x000B, 0x000A, 0x0009, 
    0x0009, 0x0008, 0x0008, 0x0007, 0x0007, 0x0007, 0x0006, 0x0006, 0x0006, 
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0007, 
    0xFE3E, 0xFFA4, 0x0000, 0x3FFF, 0x0000, 0xFF93, 0xFF93, 0xFF93, 0xFF92, 
    0xFF92, 0xFF91, 0xFF90, 0xFF8F, 0xFF8F, 0xFF8E, 0xFF8E, 0xFF8E, 0xFF8E, 
    0xFF8E, 0xFF8F, 0xFF8F, 0xFF8F, 0xFF8F, 0xFF90, 0xFF90, 0xFF90, 0xFF91, 
    0xFF91, 0xFF91, 0xFF92, 0xFF92, 0xFF92, 0xFF93, 0xFF93, 0xFF93, 0xFF94, 
    0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF95, 0xFF95, 0xFF95, 0xFF94, 
    0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 0xFF94, 
    0xFF93, 0x0580, 0x05BF, 0x0667, 0x075D, 0x0887, 0x09C8, 0x0B05, 0x0C21, 
    0x0D03, 0x0D8E, 0x0DA6, 0x0D70, 0x0D23, 0x0CC0, 0x0C4B, 0x0BC5, 0x0B30, 
    0x0A8E, 0x09E1, 0x092C, 0x0870, 0x07AF, 0x06EC, 0x0628, 0x0566, 0x04A8, 
    0x03EF, 0x033E, 0x0297, 0x01FC, 0x016E, 0x00F1, 0x0085, 0x002E, 0xFFED, 
    0xFFD0, 0xFFE2, 0x001A, 0x0074, 0x00E8, 0x0170, 0x0205, 0x02A1, 0x033D, 
    0x03D3, 0x045C, 0x04D2, 0x052F, 0x056B, 0x0580, 0x3F76, 0x3F75, 0x3F73, 
    0x3F70, 0x3F6D, 0x3F6A, 0x3F66, 0x3F63, 0x3F61, 0x3F5F, 0x3F5F, 0x3F5F, 
    0x3F60, 0x3F61, 0x3F63, 0x3F64, 0x3F66, 0x3F67, 0x3F69, 0x3F6B, 0x3F6D, 
    0x3F6F, 0x3F71, 0x3F73, 0x3F75, 0x3F77, 0x3F79, 0x3F7B, 0x3F7D, 0x3F7F, 
    0x3F80, 0x3F82, 0x3F83, 0x3F84, 0x3F84, 0x3F85, 0x3F85, 0x3F84, 0x3F83, 
    0x3F82, 0x3F80, 0x3F7F, 0x3F7D, 0x3F7C, 0x3F7A, 0x3F79, 0x3F77, 0x3F77, 
    0x3F76, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFD9, 0xFFD9, 0xFFD9, 
    0xFFD9, 0xFFD8, 0xFFD8, 0xFFD8, 0xFFD8, 0xFFD8, 0xFFD8, 0xFFD8, 0xFFD9, 
    0xFFD9, 0xFFD9, 0xFFD9, 0xFFD9, 0xFFD9, 0xFFD9, 0xFFD9, 0xFFDA, 0xFFDA, 
    0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDA, 0xFC2F, 0xFBF0, 
    0xFB42, 0xFA40, 0xF902, 0xF7A1, 0xF636, 0xF4DB, 0xF3A8, 0xF2B8, 0xF222, 
    0xF1FF, 0xF230, 0xF27F, 0xF2E9, 0xF36C, 0xF406, 0xF4B2, 0xF56E, 0xF637, 
    0xF70B, 0xF7E6, 0xF8C5, 0xF9A7, 0xFA87, 0xFB63, 0xFC38, 0xFD03, 0xFDC1, 
    0xFE70, 0xFF0C, 0xFF93, 0x0001, 0x0054, 0x0084, 0x0090, 0x007A, 0x0049, 
    0xFFFF, 0xFFA5, 0xFF3C, 0xFECB, 0xFE55, 0xFDDF, 0xFD6F, 0xFD08, 0xFCB0, 
    0xFC6C, 0xFC3F, 0xFC2F, 0xFC1B, 0xFC1B, 0xFC1B, 0xFC1C, 0xFC1E, 0xFC1F, 
    0xFC20, 0xFC22, 0xFC23, 0xFC24, 0xFC24, 0xFC24, 0xFC24, 0xFC24, 0xFC23, 
    0xFC23, 0xFC22, 0xFC22, 0xFC21, 0xFC20, 0xFC20, 0xFC1F, 0xFC1E, 0xFC1D, 
    0xFC1C, 0xFC1B, 0xFC1B, 0xFC1A, 0xFC19, 0xFC19, 0xFC18, 0xFC17, 0xFC17, 
    0xFC17, 0xFC17, 0xFC17, 0xFC17, 0xFC17, 0xFC17, 0xFC17, 0xFC18, 0xFC18, 
    0xFC19, 0xFC19, 0xFC19, 0xFC1A, 0xFC1A, 0xFC1A, 0xFC1A, 0xFC1B, 0x01E1, 
    0x0219, 0x02AF, 0x038D, 0x049B, 0x05C1, 0x06E6, 0x07F4, 0x08D3, 0x096A, 
    0x09A3, 0x0992, 0x095D, 0x0909, 0x089A, 0x0814, 0x077C, 0x06D5, 0x0623, 
    0x056B, 0x04B0, 0x03F8, 0x0345, 0x029C, 0x0201, 0x0163, 0x00B0, 0xFFF0, 
    0xFF26, 0xFE5A, 0xFD90, 0xFCCF, 0xFC1B, 0xFB7B, 0xFAF5, 0xFA8E, 0xFA4B, 
    0xFA33, 0xFA58, 0xFAC2, 0xFB64, 0xFC2E, 0xFD14, 0xFE08, 0xFEFC, 0xFFE2, 
    0x00AD, 0x014F, 0x01BA, 0x01E1, 0xFEFE, 0xFF14, 0xFF51, 0xFFAC, 0x001C, 
    0x0099, 0x0119, 0x0194, 0x0201, 0x0258, 0x028F, 0x02AD, 0x02C0, 0x02C9, 
    0x02CA, 0x02C5, 0x02BA, 0x02AC, 0x029C, 0x028B, 0x027B, 0x026F, 0x0266, 
    0x0263, 0x0267, 0x0275, 0x028D, 0x02AC, 0x02D1, 0x02F8, 0x031F, 0x0344, 
    0x0365, 0x037F, 0x038F, 0x0394, 0x038B, 0x0371, 0x033D, 0x02EC, 0x0284, 
    0x020B, 0x0189, 0x0103, 0x0080, 0x0006, 0xFF9C, 0xFF49, 0xFF12, 0xFEFE, 
    0xEC5A, 0xEC60, 0xEC70, 0xEC88, 0xECA5, 0xECC5, 0xECE5, 0xED02, 0xED1B, 
    0xED2D, 0xED36, 0xED36, 0xED31, 0xED28, 0xED1B, 0xED0C, 0xECFC, 0xECEA, 
    0xECD9, 0xECC8, 0xECB8, 0xECAB, 0xECA1, 0xEC9B, 0xEC9A, 0xEC9E, 0xECA8, 
    0xECB7, 0xECC9, 0xECDE, 0xECF4, 0xED0A, 0xED20, 0xED33, 0xED43, 0xED50, 
    0xED57, 0xED58, 0xED51, 0xED42, 0xED2C, 0xED12, 0xECF4, 0xECD5, 0xECB6, 
    0xEC9A, 0xEC80, 0xEC6C, 0xEC5F, 0xEC5A, 0xFFFE, 0x0001, 0xC170, 0x2AD0, 
    0x2AD1, 0x2AD5, 0x2ADB, 0x2AE3, 0x2AED, 0x2AF8, 0x2B04, 0x2B11, 0x2B1F, 
    0x2B2E, 0x2B3D, 0x2B4C, 0x2B5A, 0x2B68, 0x2B75, 0x2B82, 0x2B8D, 0x2B97, 
    0x2B9F, 0x2BA4, 0x2BA8, 0x2BAA, 0x2BA9, 0x2BA6, 0x2BA2, 0x2B9D, 0x2B96, 
    0x2B8E, 0x2B85, 0x2B7C, 0x2B71, 0x2B66, 0x2B5B, 0x2B4F, 0x2B43, 0x2B37, 
    0x2B2B, 0x2B1F, 0x2B13, 0x2B08, 0x2AFE, 0x2AF4, 0x2AEB, 0x2AE4, 0x2ADD, 
    0x2AD7, 0x2AD3, 0x2AD1, 0x2AD0, 0xEA94, 0xEA98, 0xEAA5, 0xEAB9, 0xEAD3, 
    0xEAF4, 0xEB19, 0xEB42, 0xEB6F, 0xEB9E, 0xEBCF, 0xEC00, 0xEC32, 0xEC62, 
    0xEC91, 0xECBE, 0xECE7, 0xED0D, 0xED2D, 0xED47, 0xED5B, 0xED68, 0xED6C, 
    0xED69, 0xED61, 0xED53, 0xED41, 0xED2B, 0xED10, 0xECF3, 0xECD2, 0xECB0, 
    0xEC8B, 0xEC64, 0xEC3D, 0xEC14, 0xEBEC, 0xEBC4, 0xEB9C, 0xEB76, 0xEB51, 
    0xEB2E, 0xEB0D, 0xEAF0, 0xEAD6, 0xEABF, 0xEAAD, 0xEA9F, 0xEA97, 0xEA94, 
    0x60E1, 0x60DE, 0x60D6, 0x60C9, 0x60B9, 0x60A4, 0x608D, 0x6072, 0x6056, 
    0x6038, 0x6019, 0x5FFA, 0x5FDB, 0x5FBC, 0x5F9E, 0x5F82, 0x5F68, 0x5F50, 
    0x5F3B, 0x5F2B, 0x5F1E, 0x5F16, 0x5F13, 0x5F15, 0x5F1A, 0x5F23, 0x5F2F, 
    0x5F3D, 0x5F4D, 0x5F60, 0x5F75, 0x5F8B, 0x5FA2, 0x5FBB, 0x5FD4, 0x5FED, 
    0x6007, 0x6020, 0x6039, 0x6052, 0x6069, 0x607F, 0x6094, 0x60A7, 0x60B7, 
    0x60C5, 0x60D1, 0x60DA, 0x60DF, 0x60E1, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xF502, 0x17FE, 0x17FD, 0x17FA, 0x17F6, 0x17F0, 
    0x17E8, 0x17DF, 0x17D5, 0x17C9, 0x17BD, 0x17B0, 0x17A1, 0x1792, 0x1783, 
    0x1773, 0x1762, 0x1752, 0x1741, 0x1730, 0x171F, 0x170F, 0x16FE, 0x16EE, 
    0x16DF, 0x16D0, 0x16C1, 0x16B4, 0x16A8, 0x169C, 0x1692, 0x1689, 0x1682, 
    0x167B, 0x1677, 0x1674, 0x1673, 0x1679, 0x1689, 0x16A2, 0x16C1, 0x16E6, 
    0x170F, 0x1739, 0x1762, 0x178B, 0x17B0, 0x17CF, 0x17E8, 0x17F8, 0x17FE, 
    0xFF32, 0xFF35, 0xFF3E, 0xFF4C, 0xFF60, 0xFF78, 0xFF95, 0xFFB5, 0xFFD9, 
    0x0001, 0x002C, 0x0059, 0x0089, 0x00BA, 0x00ED, 0x0122, 0x0157, 0x018D, 
    0x01C3, 0x01F9, 0x022E, 0x0262, 0x0295, 0x02C7, 0x02F6, 0x0324, 0x034E, 
    0x0376, 0x039A, 0x03BB, 0x03D8, 0x03F0, 0x0403, 0x0412, 0x041A, 0x041D, 
    0x040B, 0x03D8, 0x0389, 0x0324, 0x02AE, 0x022E, 0x01A8, 0x0122, 0x00A1, 
    0x002C, 0xFFC7, 0xFF78, 0xFF45, 0xFF32, 0xF1E4, 0xF1E2, 0xF1DA, 0xF1CE, 
    0xF1BE, 0xF1AA, 0xF193, 0xF178, 0xF15A, 0xF139, 0xF115, 0xF0F0, 0xF0C9, 
    0xF0A0, 0xF075, 0xF04A, 0xF01E, 0xEFF1, 0xEFC5, 0xEF98, 0xEF6C, 0xEF41, 
    0xEF16, 0xEEED, 0xEEC6, 0xEEA0, 0xEE7D, 0xEE5C, 0xEE3E, 0xEE23, 0xEE0C, 
    0xEDF8, 0xEDE8, 0xEDDC, 0xEDD4, 0xEDD2, 0xEDE1, 0xEE0C, 0xEE4D, 0xEEA0, 
    0xEF02, 0xEF6C, 0xEFDB, 0xF04A, 0xF0B4, 0xF115, 0xF169, 0xF1AA, 0xF1D5, 
    0xF1E4, 0xFFFE, 0x0001, 0xC170, 0xC362, 0xC362, 0xC361, 0xC361, 0xC360, 
    0xC360, 0xC35F, 0xC35E, 0xC35D, 0xC35C, 0xC35B, 0xC35A, 0xC358, 0xC357, 
    0xC356, 0xC355, 0xC354, 0xC353, 0xC352, 0xC352, 0xC351, 0xC351, 0xC350, 
    0xC350, 0xC350, 0xC351, 0xC351, 0xC351, 0xC352, 0xC353, 0xC353, 0xC354, 
    0xC355, 0xC356, 0xC357, 0xC358, 0xC359, 0xC35A, 0xC35B, 0xC35C, 0xC35D, 
    0xC35E, 0xC35F, 0xC35F, 0xC360, 0xC361, 0xC361, 0xC361, 0xC362, 0x10BB, 
    0x10BF, 0x10CB, 0x10DD, 0x10F6, 0x1114, 0x1137, 0x115E, 0x1188, 0x11B5, 
    0x11E4, 0x1213, 0x1243, 0x1273, 0x12A1, 0x12CE, 0x12F8, 0x131F, 0x1342, 
    0x1360, 0x1379, 0x138C, 0x1397, 0x139B, 0x1398, 0x138F, 0x1380, 0x136C, 
    0x1354, 0x1338, 0x1318, 0x12F5, 0x12D0, 0x12A8, 0x1280, 0x1256, 0x122B, 
    0x1201, 0x11D7, 0x11AE, 0x1187, 0x1161, 0x113F, 0x111F, 0x1102, 0x10EA, 
    0x10D6, 0x10C8, 0x10BE, 0x10BB, 0x5C92, 0x5C92, 0x5C91, 0x5C90, 0x5C8E, 
    0x5C8C, 0x5C8A, 0x5C87, 0x5C85, 0x5C82, 0x5C7E, 0x5C7B, 0x5C78, 0x5C75, 
    0x5C72, 0x5C6F, 0x5C6C, 0x5C6A, 0x5C67, 0x5C65, 0x5C64, 0x5C63, 0x5C62, 
    0x5C61, 0x5C62, 0x5C62, 0x5C63, 0x5C65, 0x5C66, 0x5C68, 0x5C6A, 0x5C6C, 
    0x5C6F, 0x5C72, 0x5C74, 0x5C77, 0x5C7A, 0x5C7D, 0x5C7F, 0x5C82, 0x5C85, 
    0x5C87, 0x5C89, 0x5C8B, 0x5C8D, 0x5C8F, 0x5C90, 0x5C91, 0x5C92, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xF8AA, 0xF32B, 0x066E, 0xF3C6, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xBF5E, 0xE71D, 0xE71C, 0xE719, 0xE715, 0xE70F, 0xE707, 
    0xE6FE, 0xE6F4, 0xE6E9, 0xE6DC, 0xE6CF, 0xE6C0, 0xE6B1, 0xE6A1, 0xE691, 
    0xE680, 0xE66F, 0xE65D, 0xE64C, 0xE63A, 0xE628, 0xE617, 0xE605, 0xE5F5, 
    0xE5E4, 0xE5D4, 0xE5C5, 0xE5B7, 0xE5A9, 0xE59D, 0xE591, 0xE587, 0xE57E, 
    0xE577, 0xE570, 0xE56C, 0xE569, 0xE568, 0xE571, 0xE589, 0xE5AD, 0xE5DA, 
    0xE60D, 0xE643, 0xE679, 0xE6AC, 0xE6D9, 0xE6FD, 0xE714, 0xE71D, 0xE79B, 
    0xE79C, 0xE79F, 0xE7A4, 0xE7AB, 0xE7B3, 0xE7BD, 0xE7C9, 0xE7D6, 0xE7E4, 
    0xE7F3, 0xE803, 0xE814, 0xE826, 0xE839, 0xE84C, 0xE85F, 0xE873, 0xE887, 
    0xE89B, 0xE8AF, 0xE8C3, 0xE8D6, 0xE8E9, 0xE8FC, 0xE90E, 0xE91F, 0xE92F, 
    0xE93E, 0xE94C, 0xE959, 0xE965, 0xE96F, 0xE977, 0xE97E, 0xE983, 0xE986, 
    0xE988, 0xE97E, 0xE963, 0xE93A, 0xE908, 0xE8CE, 0xE891, 0xE854, 0xE81A, 
    0xE7E8, 0xE7BF, 0xE7A4, 0xE79B, 0x9BA3, 0x9BA5, 0x9BAA, 0x9BB2, 0x9BBD, 
    0x9BCB, 0x9BDC, 0x9BEF, 0x9C04, 0x9C1B, 0x9C34, 0x9C4E, 0x9C6A, 0x9C87, 
    0x9CA5, 0x9CC4, 0x9CE4, 0x9D04, 0x9D24, 0x9D45, 0x9D65, 0x9D85, 0x9DA5, 
    0x9DC4, 0x9DE2, 0x9DFF, 0x9E1B, 0x9E36, 0x9E4E, 0x9E65, 0x9E7B, 0x9E8D, 
    0x9E9E, 0x9EAC, 0x9EB7, 0x9EBF, 0x9EC4, 0x9EC6, 0x9EB6, 0x9E8A, 0x9E48, 
    0x9DF6, 0x9D98, 0x9D35, 0x9CD1, 0x9C73, 0x9C21, 0x9BDF, 0x9BB3, 0x9BA3, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x4A2F, 0x4A17, 0x49D5, 0x4972, 0x48F4, 0x4866, 0x47CE, 0x4734, 
    0x46A2, 0x461F, 0x45B4, 0x4553, 0x44EC, 0x4480, 0x440F, 0x439A, 0x4322, 
    0x42A8, 0x422D, 0x41B2, 0x4137, 0x40BE, 0x4047, 0x3FD4, 0x3F64, 0x3EF9, 
    0x3E95, 0x3E37, 0x3DE0, 0x3D92, 0x3D4E, 0x3D13, 0x3CE4, 0x3CC1, 0x3CAB, 
    0x3CA2, 0x3CA8, 0x3CBD, 0x3D1A, 0x3DE5, 0x3F09, 0x406E, 0x41FE, 0x43A2, 
    0x4544, 0x46CD, 0x4826, 0x4938, 0x49EE, 0x4A2F, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBA4C, 0xBA4C, 0xBA4D, 
    0xBA50, 0xBA54, 0xBA5B, 0xBA64, 0xBA71, 0xBA81, 0xBA95, 0xBAAE, 0xBACC, 
    0xBAF0, 0xBB19, 0xBB48, 0xBB7F, 0xBBBD, 0xBC02, 0xBC50, 0xBCA6, 0xBD05, 
    0xBD6E, 0xBDE1, 0xBE5F, 0xBF0A, 0xBFFB, 0xC126, 0xC27C, 0xC3EF, 0xC571, 
    0xC6F6, 0xC86E, 0xC9CB, 0xCB01, 0xCC02, 0xCCBE, 0xCD2A, 0xCD36, 0xCCB5, 
    0xCB98, 0xC9FE, 0xC807, 0xC5D4, 0xC385, 0xC139, 0xBF10, 0xBD2A, 0xBBA7, 
    0xBAA8, 0xBA4C, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xBF5E, 0x2333, 0x170B, 0xAA09, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x2741, 0x274B, 0x276A, 0x279B, 0x27DC, 0x282A, 0x2885, 0x28EA, 0x2957, 
    0x29CA, 0x2A41, 0x2ABA, 0x2B34, 0x2BAB, 0x2C1F, 0x2C8D, 0x2D36, 0x2E32, 
    0x2F3B, 0x300C, 0x3061, 0x2FF6, 0x2EDD, 0x2D63, 0x2BA0, 0x29A7, 0x2790, 
    0x256F, 0x235B, 0x2169, 0x1FAE, 0x1E40, 0x1D34, 0x1CA1, 0x1C7A, 0x1C9C, 
    0x1CFF, 0x1D97, 0x1E5C, 0x1F43, 0x2043, 0x2152, 0x2265, 0x2374, 0x2474, 
    0x255C, 0x2621, 0x26BA, 0x271E, 0x2741, 0xFFE9, 0xFFE8, 0xFFE6, 0xFFE3, 
    0xFFE0, 0xFFDC, 0xFFD8, 0xFFD4, 0xFFD1, 0xFFCE, 0xFFCC, 0xFFCB, 0xFFC9, 
    0xFFC8, 0xFFC7, 0xFFC6, 0xFFC5, 0xFFC4, 0xFFC3, 0xFFC2, 0xFFC1, 0xFFC0, 
    0xFFC0, 0xFFBF, 0xFFBF, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 
    0xFFBF, 0xFFBF, 0xFFC0, 0xFFC1, 0xFFC3, 0xFFC5, 0xFFC8, 0xFFCB, 0xFFCE, 
    0xFFD2, 0xFFD6, 0xFFD9, 0xFFDD, 0xFFE0, 0xFFE3, 0xFFE5, 0xFFE7, 0xFFE8, 
    0xFFE9, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF30, 0xFF31, 0xFF31, 0xFF32, 0xFF33, 
    0xFF33, 0xFF34, 0xFF34, 0xFF34, 0xFF35, 0xFF35, 0xFF35, 0xFF36, 0xFF36, 
    0xFF36, 0xFF36, 0xFF37, 0xFF37, 0xFF37, 0xFF37, 0xFF38, 0xFF38, 0xFF38, 
    0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 
    0xFF38, 0xFF37, 0xFF36, 0xFF36, 0xFF35, 0xFF34, 0xFF33, 0xFF33, 0xFF32, 
    0xFF31, 0xFF30, 0xFF30, 0xFF2F, 0xCE0A, 0xCE2D, 0xCE8D, 0xCF1D, 0xCFCF, 
    0xD094, 0xD160, 0xD225, 0xD2D5, 0xD362, 0xD3BE, 0xD3FD, 0xD43C, 0xD479, 
    0xD4B5, 0xD4EE, 0xD526, 0xD55B, 0xD58D, 0xD5BC, 0xD5E7, 0xD60F, 0xD632, 
    0xD650, 0xD66A, 0xD67F, 0xD68E, 0xD697, 0xD699, 0xD696, 0xD68B, 0xD679, 
    0xD660, 0xD63E, 0xD606, 0xD5AB, 0xD532, 0xD4A2, 0xD3FE, 0xD34E, 0xD295, 
    0xD1D9, 0xD11F, 0xD06E, 0xCFC9, 0xCF36, 0xCEBA, 0xCE5C, 0xCE1F, 0xCE0A, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFBB4, 0xFB4E, 0xFA3C, 
    0xF8AF, 0xF6D8, 0xF4E7, 0xF310, 0xF183, 0xF071, 0xF00B, 0xF01D, 0xF052, 
    0xF0A6, 0xF117, 0xF1A3, 0xF245, 0xF2FC, 0xF3C5, 0xF49C, 0xF580, 0xF66C, 
    0xF75E, 0xF853, 0xF948, 0xFA3A, 0xFB26, 0xFC09, 0xFCE0, 0xFDA9, 0xFE60, 
    0xFF03, 0xFF8E, 0x0000, 0x0055, 0x0089, 0x009C, 0x0089, 0x0056, 0x0008, 
    0xFFA2, 0xFF2D, 0xFEAD, 0xFE28, 0xFDA2, 0xFD22, 0xFCAD, 0xFC48, 0xFBFA, 
    0xFBC7, 0xFBB4, 0x0018, 0x001A, 0x001F, 0x0027, 0x0031, 0x003A, 0x0043, 
    0x004B, 0x0050, 0x0051, 0x0051, 0x0050, 0x004E, 0x004C, 0x0049, 0x0046, 
    0x0042, 0x003E, 0x0039, 0x0034, 0x002E, 0x0029, 0x0023, 0x001D, 0x0017, 
    0x0011, 0x000C, 0x0006, 0x0001, 0xFFFB, 0xFFF7, 0xFFF3, 0xFFF1, 0xFFEE, 
    0xFFED, 0xFFEC, 0xFFED, 0xFFEF, 0xFFF2, 0xFFF5, 0xFFF9, 0xFFFD, 0x0003, 
    0x0007, 0x000C, 0x000F, 0x0013, 0x0015, 0x0017, 0x0018, 0xDAD8, 0xDAD7, 
    0xDAD4, 0xDAD1, 0xDACC, 0xDAC6, 0xDAC1, 0xDABC, 0xDAB8, 0xDAB7, 0xDAB7, 
    0xDAB8, 0xDABA, 0xDABC, 0xDABF, 0xDAC3, 0xDAC6, 0xDACA, 0xDACE, 0xDAD2, 
    0xDAD6, 0xDADA, 0xDADE, 0xDAE2, 0xDAE5, 0xDAE8, 0xDAEB, 0xDAEE, 0xDAF0, 
    0xDAF1, 0xDAF2, 0xDAF3, 0xDAF3, 0xDAF3, 0xDAF2, 0xDAF0, 0xDAEF, 0xDAED, 
    0xDAEB, 0xDAE8, 0xDAE6, 0xDAE4, 0xDAE2, 0xDADF, 0xDADD, 0xDADB, 0xDADA, 
    0xDAD9, 0xDAD8, 
    },
    {
    0x002D, 0x0000, 0x0001, 0x002D, 0x0001, 0x002E, 0x0001, 0x002F, 0x0001, 
    0x0030, 0x0001, 0x0031, 0x0032, 0x0032, 0x0032, 0x0064, 0x0031, 0x0096, 
    0x002A, 0x00C7, 0x0032, 0x00F1, 0x0032, 0x0123, 0x0032, 0x0155, 0x0032, 
    0x0187, 0x0032, 0x01B9, 0x0001, 0x01EB, 0x0001, 0x01EC, 0x0001, 0x01ED, 
    0x0032, 0x01EE, 0x0032, 0x0220, 0x0032, 0x0252, 0x002F, 0x0284, 0x0032, 
    0x02B3, 0x0001, 0x02E5, 0x0032, 0x02E6, 0x0032, 0x0318, 0x0032, 0x034A, 
    0x0001, 0x037C, 0x0001, 0x037D, 0x0001, 0x037E, 0x0031, 0x037F, 0x0032, 
    0x03B0, 0x0031, 0x03E2, 0x0032, 0x0413, 0x0032, 0x0445, 0x0001, 0x0477, 
    0x0001, 0x0478, 0x0001, 0x0479, 0x0001, 0x047A, 0x002F, 0x047B, 0x0032, 
    0x04AA, 0x0001, 0x04DC, 0x0032, 0x04DD, 0x0032, 0x050F, 0x0032, 0x0541, 
    0x0032, 0x0573, 0x0032, 0x05A5, 0x0032, 0x05D7, 0x0031, 0x0609, 0x0032, 
    0x063A, 0x0032, 0x066C, 0x002F, 0x069E, 0x0032, 0x06CD, 0x0001, 0x06FF, 
    0x0001, 0x0700, 0x0001, 0x0701, 0x0001, 0x0702, 0x0032, 0x0703, 0x002D, 
    0x0735, 0x0032, 0x0762, 0x0032, 0x0794, 0x0030, 0x07C6, 0x0032, 0x07F6, 
    0x0032, 0x0828, 0x0032, 0x085A, 0x0032, 0x088C, 0x0032, 0x08BE, 0x0032, 
    0x08F0, 0x0031, 0x0922, 
})

smlua_anim_util_register_animation("MILNE_ANIM_FAST_LEDGE_GRAB",
    1,
    0,
    0,
    0,
    15,
    {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0006, 0x0004, 0x0002, 0x0001, 
    0x0000, 0xFE3E, 0xFE7C, 0xFF12, 0xFFCC, 0x0078, 0x00F5, 0x0125, 0x0104, 
    0x00C1, 0x0090, 0x0088, 0x0096, 0x009E, 0x00A4, 0x00AA, 0xFFA4, 0xFF9C, 
    0xFF8E, 0xFF86, 0xFF99, 0xFFC6, 0xFFF9, 0x0021, 0x003A, 0x0042, 0x003F, 
    0x003F, 0x003E, 0x003E, 0x003E, 0x003A, 0x0000, 0x3FFF, 0x0000, 0xFF93, 
    0xFF76, 0xFFC6, 0x0255, 0x024C, 0x022E, 0x01FE, 0x01C1, 0x017B, 0x0130, 
    0x00E5, 0x009E, 0x005F, 0x002D, 0x000C, 0xFFFF, 0x0580, 0x058F, 0x0589, 
    0x0501, 0x048F, 0x040F, 0x0386, 0x02F9, 0x026B, 0x01E1, 0x0161, 0x00EE, 
    0x008C, 0x0041, 0x0011, 0xFFFF, 0x3F76, 0x3EAD, 0x412A, 0x5469, 0x53FD, 
    0x52E4, 0x5141, 0x4F36, 0x4CE7, 0x4A76, 0x4805, 0x45B9, 0x43B3, 0x4215, 
    0x4104, 0x40A1, 0xFFDA, 0xFF4C, 0xFE1E, 0xFD08, 0xFC80, 0xFD40, 0xFE32, 
    0xFF2B, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFC2F, 0xFC72, 0xFD05, 0xFD97, 0xFE27, 0xFEA4, 0xFF21, 0xFF98, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFC1B, 0x02D1, 
    0x113F, 0x1ED1, 0x274D, 0x22E4, 0x1C89, 0x15CD, 0x1041, 0x1128, 0x1097, 
    0x0F03, 0x0CEB, 0x0ACD, 0x092B, 0x0884, 0x01E1, 0x01CA, 0x0192, 0x0153, 
    0x0112, 0x00CB, 0x0083, 0x003D, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFEFE, 0xFECB, 0xFE71, 0xFE53, 0xFE89, 0xFEDF, 
    0xFF45, 0xFFAA, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xEC5A, 0xF017, 0xF78B, 0xFD0D, 0xFEF9, 0xFFD1, 0x0027, 0x008D, 0x0197, 
    0x065B, 0x051A, 0x031B, 0x00CF, 0xFEA2, 0xFD03, 0xFC61, 0xFFFE, 0x0001, 
    0xC170, 0x2AD0, 0x1474, 0x0F7F, 0x1200, 0x27EB, 0x1019, 0xB494, 0xE751, 
    0x9A4E, 0xC9E4, 0xE756, 0xF523, 0xFB82, 0xFCF5, 0xFBFD, 0xFB1C, 0xEA94, 
    0xE00F, 0xE041, 0xF4E0, 0xF20A, 0xDCE4, 0xA768, 0xAB43, 0xD2C7, 0xDAD3, 
    0xE00D, 0xDFF3, 0xDCD6, 0xD874, 0xD48C, 0xD2DB, 0x60E1, 0x8B1D, 0x9718, 
    0x8EDD, 0x79A6, 0x9C81, 0x00FD, 0xD7AE, 0x2BEB, 0xF798, 0xE84C, 0xDB54, 
    0xD51A, 0xD366, 0xD401, 0xD4B3, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF502, 
    0xD1C2, 0xD262, 0xEA02, 0xF2F1, 0xD285, 0xC8CD, 0xC1C8, 0xBD5D, 0xBB76, 
    0xCF24, 0xD038, 0xCF38, 0xCD32, 0xCB34, 0xCA4E, 0x17FE, 0x0206, 0x0C2C, 
    0x1C2F, 0x0343, 0xF068, 0xF4D6, 0xFA64, 0xFF81, 0x029B, 0x0381, 0x0354, 
    0x027C, 0x0160, 0x0069, 0x0000, 0xFF32, 0xFE3C, 0xFD04, 0xEA86, 0x0173, 
    0x06EC, 0x02CA, 0xFE4B, 0xFA56, 0xF7D4, 0xF6EC, 0xF6F1, 0xF78B, 0xF865, 
    0xF927, 0xF97B, 0xF1E4, 0xE9BC, 0xE45D, 0xDA84, 0xF20E, 0xF505, 0xF275, 
    0xEFB2, 0xED4B, 0xEBCF, 0xEB59, 0xEB82, 0xEC0A, 0xECB7, 0xED4C, 0xED8B, 
    0xFFFE, 0x0001, 0xC170, 0xC362, 0x420C, 0x3A54, 0x407B, 0x38AC, 0x3F16, 
    0x4869, 0x5023, 0x51C0, 0x29F0, 0x1FA4, 0x16BB, 0x0F6D, 0x09F1, 0x067E, 
    0x054B, 0x10BB, 0x56FD, 0x5771, 0x65A2, 0x6A93, 0x5CD2, 0x4C51, 0x3B10, 
    0x2B0C, 0x20EF, 0x21D1, 0x23DC, 0x2678, 0x290F, 0x2B0B, 0x2BD6, 0x5C92, 
    0xF040, 0xF402, 0xFEFC, 0xF598, 0xFDF9, 0x09B8, 0x142F, 0x18B6, 0xF5A5, 
    0xEB1E, 0xE17A, 0xD92F, 0xD2B2, 0xCE78, 0xCCF5, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF8AA, 0xCC1F, 
    0xCF52, 0xEDAA, 0xE6DD, 0xDC31, 0xCF81, 0xC2A7, 0xB77F, 0xAFE4, 0xC925, 
    0xCB91, 0xCB92, 0xCA3B, 0xC8A2, 0xC7DC, 0xF32B, 0xFEA4, 0x0633, 0x140A, 
    0x0EA9, 0x0B9D, 0x08A4, 0x05EA, 0x039D, 0x01EB, 0x00D9, 0x003C, 0xFFF5, 
    0xFFE7, 0xFFF5, 0xFFFF, 0x066E, 0x17A0, 0x22F5, 0x37B4, 0x0D26, 0x070E, 
    0x04B4, 0x0492, 0x0521, 0x04DC, 0x03AB, 0x0289, 0x0188, 0x00BA, 0x0031, 
    0xFFFF, 0xF3C6, 0xF5FB, 0xF76F, 0xFA1A, 0xEEFD, 0xEF21, 0xF08F, 0xF298, 
    0xF48B, 0xF5BA, 0xF617, 0xF61F, 0xF5EF, 0xF5A7, 0xF565, 0xF548, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xE71D, 0xE953, 0xEA46, 0xDF0B, 
    0xE192, 0xE676, 0xE86B, 0xE16D, 0xD8AC, 0xDA03, 0xDC73, 0xD980, 0xD84E, 
    0xD747, 0xD68F, 0xD649, 0xE79B, 0xF0F1, 0xFCD3, 0xF7E4, 0xF287, 0xECD6, 
    0xE8C1, 0xE926, 0xEAB0, 0xE7B5, 0xE2CE, 0xE6BE, 0xE8AA, 0xEA71, 0xEBBE, 
    0xEC40, 0x9BA3, 0x98E6, 0x9949, 0xAFA9, 0xB088, 0xADC3, 0xAC10, 0xAEBE, 
    0xB1BD, 0xAF38, 0xAB2C, 0xAFEB, 0xB1FB, 0xB3CF, 0xB51E, 0xB59D, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x4A2F, 0x3AFB, 0x24F6, 0x1E97, 0x29BE, 0x3848, 0x40DA, 0x36AA, 0x2AEA, 
    0x3EE1, 0x41F7, 0x3A9A, 0x3407, 0x2D08, 0x277A, 0x2537, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFDD, 0xFFB4, 0xFF9E, 0xFFB8, 0xFFEA, 0xFB70, 0xFAB6, 
    0xFA4C, 0xFD1E, 0x0000, 0xFFF1, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x002C, 0x0065, 0x00A3, 0x00F4, 0x0138, 0x0062, 0xFFC2, 0x0021, 0x0015, 
    0xFFF6, 0xFFEC, 0xFFFF, 0xBA4C, 0xBFCC, 0xCB69, 0xE169, 0xD814, 0xC8D8, 
    0xBD19, 0xBCFC, 0xBF11, 0xA94A, 0xAC42, 0xAF55, 0xB4C7, 0xBA52, 0xBE04, 
    0xBF3F, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x2333, 0x14EB, 
    0x06FE, 0x2575, 0x255B, 0x1FEB, 0x1B46, 0x1ADC, 0x1A65, 0x1458, 0x12F6, 
    0x1623, 0x17CF, 0x1965, 0x1A92, 0x1B09, 0x170B, 0x100E, 0x0845, 0x11F7, 
    0x165C, 0x19F4, 0x1B78, 0x1710, 0x1234, 0x18E4, 0x19D2, 0x16D5, 0x1500, 
    0x1331, 0x11D1, 0x1144, 0xAA09, 0xA48F, 0x9FCF, 0xAEB5, 0xAC1C, 0xA66B, 
    0xA2D6, 0xA6EC, 0xAABE, 0x9EDA, 0x9C8B, 0xA277, 0xA5C3, 0xA8EF, 0xAB52, 
    0xAC43, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x2741, 
    0x27B2, 0x2619, 0x1A37, 0x2708, 0x3883, 0x42BF, 0x3614, 0x2769, 0x3EA2, 
    0x449D, 0x37E1, 0x2F92, 0x2740, 0x20D9, 0x1E4A, 0xFFE9, 0xFFED, 0xFFDE, 
    0xFF73, 0xFF7D, 0xFFA7, 0x004A, 0x0296, 0x0464, 0x048F, 0x02C7, 0x02CF, 
    0x020F, 0x0120, 0x0055, 0x0000, 0xFF2F, 0xFF2A, 0xFF2D, 0xFF64, 0xFF69, 
    0xFF65, 0xFF5F, 0xFF58, 0xFF4C, 0xFF8F, 0xFFC2, 0xFF4E, 0xFF39, 0xFF30, 
    0xFF2E, 0xFF2F, 0xCE0A, 0xCD14, 0xD021, 0xE7B5, 0xDAFC, 0xC752, 0xB80F, 
    0xB61B, 0xB94D, 0xAF20, 0xAD11, 0xB5F7, 0xBC4E, 0xC2C7, 0xC7D0, 0xC9D7, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFBB4, 0xFBA6, 0xFB80, 0xFB47, 0xFB01, 0xFAB8, 0xFA86, 
    0xFC1C, 0xFED1, 0xFFA2, 0xFFB0, 0xFFCA, 0xFFE6, 0xFFF8, 0xFFFE, 0xFFFF, 
    0x0018, 0x0012, 0x0008, 0x0006, 0x001B, 0x005B, 0x00E1, 0x01AA, 0x00A4, 
    0xFF96, 0xFF97, 0xFFA1, 0xFFBA, 0xFFDA, 0xFFF5, 0xFFFF, 0xDAD8, 0xDAEE, 
    0xDB89, 0xDD34, 0xE091, 0xE670, 0xEFEA, 0x0841, 0x2791, 0x348B, 0x30DD, 
    0x2744, 0x1A45, 0x0D47, 0x03AE, 0x0000, 
    },
    {
    0x000A, 0x0000, 0x000F, 0x000A, 0x0010, 0x0019, 0x0001, 0x0029, 0x0001, 
    0x002A, 0x0001, 0x002B, 0x0010, 0x002C, 0x0010, 0x003C, 0x0010, 0x004C, 
    0x0010, 0x005C, 0x0010, 0x006C, 0x0010, 0x007C, 0x0010, 0x008C, 0x000F, 
    0x009C, 0x0010, 0x00AB, 0x0001, 0x00BB, 0x0001, 0x00BC, 0x0001, 0x00BD, 
    0x0010, 0x00BE, 0x0010, 0x00CE, 0x0010, 0x00DE, 0x0010, 0x00EE, 0x000F, 
    0x00FE, 0x0010, 0x010D, 0x0010, 0x011D, 0x0010, 0x012D, 0x0010, 0x013D, 
    0x0001, 0x014D, 0x0001, 0x014E, 0x0001, 0x014F, 0x0010, 0x0150, 0x0010, 
    0x0160, 0x0010, 0x0170, 0x000F, 0x0180, 0x000D, 0x018F, 0x0010, 0x019C, 
    0x0010, 0x01AC, 0x0010, 0x01BC, 0x0010, 0x01CC, 0x0010, 0x01DC, 0x0010, 
    0x01EC, 0x0001, 0x01FC, 0x0010, 0x01FD, 0x0010, 0x020D, 0x0010, 0x021D, 
    0x0010, 0x022D, 0x000C, 0x023D, 0x0010, 0x0249, 0x0010, 0x0259, 0x0010, 
    0x0269, 0x0010, 0x0279, 0x0010, 0x0289, 0x0010, 0x0299, 0x0001, 0x02A9, 
    0x0010, 0x02AA, 0x0010, 0x02BA, 0x0010, 0x02CA, 0x000E, 0x02DA, 0x000B, 
    0x02E8, 0x0010, 0x02F3, 0x0010, 0x0303, 0x0010, 0x0313, 0x0010, 0x0323, 
    0x000F, 0x0333, 0x0010, 0x0342, 0x0010, 0x0352, 0x0010, 0x0362, 0x0010, 
    0x0372, 0x0010, 0x0382, 
})

smlua_anim_util_register_animation("MILNE_ANIM_FALL_OVER_BACKWARDS",
    1,
    0,
    0,
    0,
    79,
    {
    0x0000, 0x00A0, 0x008E, 0x0062, 0x0028, 0xFFEF, 0xFFC2, 0xFFB1, 0xFFB1, 
    0xFFB1, 0xFFC6, 0xFFF5, 0x0029, 0x004E, 0x0064, 0x006A, 0x0060, 0x0045, 
    0x0021, 0xFFFA, 0xFFD5, 0xFFBB, 0xFFB1, 0xFFB1, 0xFFBA, 0xFFD0, 0xFFEB, 
    0x0001, 0x000B, 0xFFF7, 0xFFD3, 0xFFBF, 0xFFC2, 0xFFC7, 0xFFC9, 0xFFC5, 
    0xFFBD, 0xFFB4, 0xFFB1, 0xFFB4, 0xFFB7, 0xFFB7, 0xFFB6, 0xFFB5, 0xFFB5, 
    0xFFB9, 0xFFB5, 0xFFB5, 0xFFB5, 0xFFB6, 0xFFB7, 0xFFB8, 0xFFB8, 0xFFB7, 
    0xFFB5, 0xFFB2, 0xFFAF, 0xFFAC, 0xFFAA, 0xFFA9, 0xFFB1, 0xFFC5, 0xFFE1, 
    0xFFFF, 0x001A, 0x002E, 0x003D, 0x0047, 0x004E, 0x0055, 0x005D, 0x0068, 
    0x0075, 0x0082, 0x008F, 0x009B, 0x00A3, 0x00A8, 0x00A9, 0x00AA, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 
    0xFFDF, 0xFFEA, 0xFFF7, 0x0004, 0x000F, 0x0013, 0x0013, 0x0012, 0x0012, 
    0x0010, 0x000F, 0x000C, 0x0009, 0x0005, 0x0001, 0x0000, 0x0000, 0x3FFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFE, 0xFFFA, 0xFFF6, 0xFFF3, 
    0xFFF3, 0xFFF6, 0xFFFF, 0x0014, 0x0036, 0x005E, 0x0089, 0x00D0, 0x00FB, 
    0x00E8, 0x00CC, 0x00A9, 0x0083, 0x005C, 0x0038, 0x001B, 0x0007, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFE, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFDE, 0xFFD2, 0xFFC6, 0xFFB9, 
    0xFFAD, 0xFFA3, 0xFF99, 0xFF92, 0xFF8D, 0xFF8C, 0xFF8D, 0xFF93, 0xFF9E, 
    0xFFAD, 0xFFC3, 0xFFDE, 0x0000, 0x0057, 0x00FB, 0x01CB, 0x02A3, 0x0364, 
    0x03E9, 0x0413, 0x0330, 0x0161, 0xFFB9, 0xFF4B, 0x036D, 0x0751, 0x071E, 
    0x0678, 0x0581, 0x0458, 0x031D, 0x01F0, 0x00F2, 0x0041, 0xFFFF, 0x3400, 
    0x31EB, 0x2CC1, 0x2625, 0x1D43, 0x12EE, 0x0B42, 0x068A, 0x0254, 0xFE9B, 
    0xFB5D, 0xF899, 0xF64B, 0xF471, 0xF32F, 0xF293, 0xF27B, 0xF2C2, 0xF345, 
    0xF3E1, 0xF471, 0xF51C, 0xF60F, 0xF734, 0xF872, 0xF9B3, 0xFADF, 0xFC0F, 
    0xFD53, 0xFE81, 0xFF71, 0xFFA2, 0xFF71, 0xFF4B, 0xFF0B, 0xFEFE, 0xFF71, 
    0x0034, 0x00E5, 0x018A, 0x0224, 0x02B7, 0x0347, 0x03D7, 0x046C, 0x0507, 
    0x05AD, 0x0661, 0x0726, 0x0801, 0x08F4, 0x0A03, 0x0B31, 0x0C82, 0x0DF9, 
    0x0F9A, 0x1169, 0x1368, 0x1687, 0x1B59, 0x2154, 0x27EF, 0x2E9F, 0x34DC, 
    0x3A1C, 0x3DF2, 0x40BC, 0x431F, 0x45C0, 0x49B5, 0x4BF2, 0x4B30, 0x49F4, 
    0x4864, 0x46A7, 0x44E3, 0x4341, 0x41E5, 0x40F9, 0x40A1, 0x011C, 0x0233, 
    0x0435, 0x0542, 0x0417, 0x01F6, 0x00CA, 0x00F9, 0x0186, 0x024C, 0x0327, 
    0x03F1, 0x0485, 0x04BF, 0x048C, 0x0408, 0x0350, 0x0283, 0x01BF, 0x0122, 
    0x00CA, 0x00C2, 0x00F2, 0x014A, 0x01B7, 0x0228, 0x028B, 0x02F0, 0x0365, 
    0x03D4, 0x042D, 0x043E, 0x042D, 0x042C, 0x042C, 0x042C, 0x042D, 0x0432, 
    0x043D, 0x044C, 0x045E, 0x0471, 0x0482, 0x0491, 0x049A, 0x049E, 0x0499, 
    0x048B, 0x0471, 0x0449, 0x03F8, 0x0370, 0x02C6, 0x020F, 0x0160, 0x00CF, 
    0x006F, 0x0057, 0x0080, 0x00D8, 0x015E, 0x0215, 0x02FB, 0x0413, 0x055C, 
    0x0954, 0x0CC9, 0x0A7C, 0x06CD, 0x0487, 0x0326, 0x028E, 0x0206, 0x018C, 
    0x0122, 0x00C7, 0x007C, 0x0042, 0x0018, 0x0000, 0xF993, 0xF9B0, 0xF9D8, 
    0xF9C5, 0xF92B, 0xF857, 0xF7E6, 0xF7F3, 0xF826, 0xF870, 0xF8C3, 0xF910, 
    0xF949, 0xF95F, 0xF953, 0xF933, 0xF901, 0xF8C3, 0xF87D, 0xF831, 0xF7E6, 
    0xF793, 0xF735, 0xF6CE, 0xF663, 0xF5F9, 0xF593, 0xF52C, 0xF4C1, 0xF45F, 
    0xF411, 0xF401, 0xF411, 0xF402, 0xF3E9, 0xF3E4, 0xF411, 0xF469, 0xF4CF, 
    0xF53F, 0xF5B6, 0xF633, 0xF6B1, 0xF72E, 0xF7A8, 0xF81B, 0xF884, 0xF8E2, 
    0xF92F, 0xF96B, 0xF98C, 0xF98D, 0xF974, 0xF946, 0xF909, 0xF8C1, 0xF875, 
    0xF82A, 0xF7DD, 0xF788, 0xF72A, 0xF6BF, 0xF645, 0xF5B9, 0xF51A, 0xF393, 
    0xF22D, 0xF261, 0xF37F, 0xF5C0, 0xF7DD, 0xF90C, 0xFA4B, 0xFB8B, 0xFCBE, 
    0xFDD5, 0xFEC2, 0xFF77, 0xFFE6, 0xFFFF, 0x10FB, 0x0B03, 0xFFFD, 0xFA3E, 
    0x00BE, 0x0C85, 0x1303, 0x1210, 0x0F16, 0x0AE0, 0x0638, 0x01EA, 0xFEC0, 
    0xFD85, 0xFE98, 0x0165, 0x0549, 0x09A1, 0x0DCA, 0x1121, 0x1303, 0x133B, 
    0x1240, 0x1070, 0x0E2D, 0x0BD4, 0x09C5, 0x07AE, 0x0545, 0x02F2, 0x011F, 
    0x00C2, 0x011F, 0x011F, 0x0121, 0x0121, 0x011F, 0x0107, 0x00D0, 0x0082, 
    0x0027, 0xFFC9, 0xFF70, 0xFF28, 0xFEF9, 0xFEED, 0xFF0E, 0xFF64, 0xFFFB, 
    0x00DB, 0x0298, 0x0576, 0x090A, 0x0CE7, 0x10A1, 0x13CC, 0x15FB, 0x16C3, 
    0x15D4, 0x136C, 0x0FF8, 0x0BDF, 0x078E, 0x036E, 0xFFE9, 0xFC6E, 0xFB15, 
    0xFEF4, 0x04B4, 0x0AFA, 0x0EF0, 0x0EFB, 0x0E81, 0x0DA8, 0x0C92, 0x0B64, 
    0x0A41, 0x094E, 0x08AD, 0x0884, 0xFF65, 0x0E89, 0x071E, 0xFE98, 0xFE5E, 
    0x0095, 0x021F, 0x01D0, 0x00F0, 0x0010, 0xFFC2, 0x00B4, 0x0253, 0x034B, 
    0x034F, 0x030A, 0x029A, 0x0222, 0x01C2, 0x019A, 0x01CB, 0x0270, 0x0376, 
    0x04BA, 0x0618, 0x076E, 0x0896, 0x0993, 0x0A7D, 0x0B4E, 0x0C04, 0x0C6F, 
    0x0C7D, 0x0C77, 0x0C6A, 0x0C30, 0x0BA5, 0x0AD1, 0x09DD, 0x08D2, 0x07B9, 
    0x069C, 0x0584, 0x0478, 0x0383, 0x02AE, 0x01F5, 0x014D, 0x00B4, 0x0029, 
    0xFFAA, 0xFF33, 0xFEC5, 0xFE5B, 0xFDF6, 0xFDCB, 0xFDE3, 0xFDF6, 0xFDE8, 
    0xFDD4, 0xFDBD, 0xFDA8, 0xFD9A, 0xFD97, 0xFDA3, 0xFE04, 0xFEAA, 0xFF1D, 
    0xFEE6, 0xFBF3, 0xF967, 0xF9B6, 0xFA5B, 0xFB3F, 0xFC47, 0xFD59, 0xFE5B, 
    0xFF33, 0xFFC8, 0x0000, 0xF0B6, 0xF827, 0xF4D3, 0xF0C2, 0xEFE7, 0xF00B, 
    0xF0D7, 0xF22E, 0xF3FB, 0xF5F8, 0xF7E2, 0xF9FC, 0xFC1A, 0xFD4D, 0xFD92, 
    0xFD91, 0xFD5F, 0xFD0F, 0xFCB2, 0xFC5E, 0xFC23, 0xFC06, 0xFBF5, 0xFBE5, 
    0xFBCD, 0xFBA1, 0xFB58, 0xFAC6, 0xF9F1, 0xF920, 0xF894, 0xF8F2, 0xF96C, 
    0xF92B, 0xF8B7, 0xF843, 0xF7FF, 0xF7E9, 0xF7DE, 0xF7DB, 0xF7DF, 0xF7E6, 
    0xF7EF, 0xF7F8, 0xF7FE, 0xF7FF, 0xF7FB, 0xF7F7, 0xF7F1, 0xF7EC, 0xF7E5, 
    0xF7DF, 0xF7D9, 0xF7D4, 0xF7CF, 0xF79D, 0xF76E, 0xF7CF, 0xF895, 0xF94B, 
    0xFA10, 0xFB06, 0xFC4C, 0xFE04, 0x004E, 0x04DE, 0x0B8B, 0x11AC, 0x1495, 
    0x0C3F, 0x02C4, 0x0132, 0x0027, 0xFF8E, 0xFF4D, 0xFF4E, 0xFF78, 0xFFB3, 
    0xFFE8, 0x0000, 0x17B1, 0xEB77, 0xE93B, 0xE953, 0xEB3F, 0xEE7F, 0xF292, 
    0xF6F8, 0xFB33, 0x05F1, 0x0F3A, 0x0BCF, 0x046A, 0x0087, 0x01C6, 0x0468, 
    0x07DE, 0x0B9B, 0x0F0F, 0x11AB, 0x12E3, 0x11F4, 0x0F26, 0x0B73, 0x07D8, 
    0x0551, 0x04D8, 0x0965, 0x11FA, 0x199F, 0x1A96, 0x15DF, 0x149F, 0x13F1, 
    0x1387, 0x1353, 0x1346, 0x134E, 0x1365, 0x138A, 0x13BF, 0x1404, 0x145C, 
    0x14C6, 0x1545, 0x15D9, 0x168F, 0x176A, 0x1861, 0x196A, 0x1A79, 0x1B85, 
    0x1C85, 0x1D6C, 0x1E33, 0x1EF8, 0x1F46, 0x1E33, 0x1BAC, 0x1876, 0x14E3, 
    0x1146, 0x0DF2, 0x0B3B, 0x0973, 0x0A8B, 0x0E32, 0x1159, 0x10F2, 0x0345, 
    0xF643, 0xF4FF, 0xF4C6, 0xF55B, 0xF681, 0xF7FB, 0xF98C, 0xFAF6, 0xFBFC, 
    0xFC61, 0x0001, 0xFFFE, 0xC170, 0xCA37, 0xCC80, 0xCEC8, 0xCA37, 0xB677, 
    0x9BDD, 0x0C8F, 0x0B3E, 0x0DB2, 0x92A3, 0x98D0, 0x9EF3, 0xA3C7, 0xA607, 
    0xA580, 0xA340, 0x9FE8, 0x9C18, 0x9871, 0x9594, 0x9420, 0x94BB, 0x9705, 
    0x9A19, 0x9D10, 0x9F06, 0x9F15, 0x9B1A, 0x93C0, 0x8C5A, 0x083A, 0x8F45, 
    0x96C8, 0x9389, 0x8D22, 0x0740, 0x058D, 0x075C, 0x0988, 0x0C0A, 0x8EDC, 
    0x91F8, 0x9559, 0x98F6, 0x9CCA, 0xA0CF, 0xA4FE, 0xA951, 0xADC2, 0xB249, 
    0xB782, 0xBDCD, 0xC4CC, 0xCC20, 0xD36C, 0xDA52, 0xE073, 0xE573, 0xE912, 
    0xEB8B, 0xED39, 0xEE73, 0xEF95, 0xF0F6, 0xF2F1, 0xF696, 0xFB04, 0xFFE8, 
    0x02D1, 0x02A7, 0x022F, 0x017B, 0x009B, 0xFF9F, 0xFE98, 0xFD98, 0xFCAE, 
    0xFBEA, 0xFB5F, 0xFB1C, 0xC606, 0xC60A, 0xC60E, 0xC606, 0xC559, 0xC4A1, 
    0xBA5D, 0xB750, 0xB359, 0xD113, 0xD586, 0xD98A, 0xDCAC, 0xDE79, 0xDEA7, 
    0xDD83, 0xDB7D, 0xD908, 0xD694, 0xD493, 0xD377, 0xD373, 0xD434, 0xD55D, 
    0xD694, 0xD77C, 0xD7BA, 0xD6B9, 0xD4B9, 0xD2A2, 0xAEA3, 0xD2AF, 0xD448, 
    0xD3C8, 0xD2B7, 0xAE57, 0xAED8, 0xAEE2, 0xAEEC, 0xAEF3, 0xD108, 0xD10E, 
    0xD11F, 0xD13E, 0xD16D, 0xD1B0, 0xD209, 0xD27B, 0xD309, 0xD3B5, 0xD49A, 
    0xD5C9, 0xD738, 0xD8DB, 0xDAA8, 0xDC94, 0xDE96, 0xE0A1, 0xE300, 0xE5D7, 
    0xE8E9, 0xEBF4, 0xEEBA, 0xF0FA, 0xF277, 0xEE95, 0xE9CC, 0xECCF, 0xEF54, 
    0xED2E, 0xEA63, 0xE722, 0xE39C, 0xDFFF, 0xDC7A, 0xD93F, 0xD67B, 0xD45F, 
    0xD31A, 0xD2DB, 0xE104, 0xDEAB, 0xDC52, 0xE104, 0xF592, 0x112B, 0xA061, 
    0xA04E, 0x9BF6, 0x14DB, 0x0C77, 0x044A, 0xFDD3, 0xFA8F, 0xFAD0, 0xFD5B, 
    0x0162, 0x0614, 0x0AA3, 0x0E3E, 0x1016, 0x0F74, 0x0CDD, 0x0959, 0x05F0, 
    0x03A9, 0x038E, 0x0805, 0x104A, 0x18A0, 0x9D49, 0x1575, 0x0D14, 0x1048, 
    0x16B9, 0x9D20, 0xA038, 0xA069, 0xA04E, 0x9FF0, 0x1F54, 0x1E7F, 0x1D78, 
    0x1C46, 0x1AEF, 0x197A, 0x17EC, 0x164C, 0x14A1, 0x12F0, 0x1103, 0x0EAD, 
    0x0C03, 0x091A, 0x0608, 0x02E2, 0xFFBC, 0xFCAB, 0xF9BC, 0xF6DB, 0xF3F0, 
    0xF0E4, 0xED9E, 0xEA09, 0xE60A, 0xDF37, 0xD69E, 0xCCE1, 0xC6F5, 0xC728, 
    0xC7F5, 0xC93B, 0xCAD9, 0xCCAC, 0xCE94, 0xD06E, 0xD21A, 0xD375, 0xD45D, 
    0xD4B3, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xCA4E, 0xC9CF, 0xC94F, 
    0xCA4E, 0xCE20, 0xD371, 0xD7C0, 0xDAB2, 0xDD8B, 0xE039, 0xE2AE, 0xE4D8, 
    0xE6A7, 0xE80C, 0xE8E7, 0xE93C, 0xE930, 0xE8E7, 0xE886, 0xE831, 0xE80C, 
    0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
    0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
    0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
    0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
    0xE80C, 0xE7C8, 0xE729, 0xE673, 0xE5EA, 0xE5D3, 0xE673, 0xE80C, 0xED63, 
    0xF61A, 0xFDC8, 0xFFFF, 0xFD1C, 0xF8AA, 0xF30D, 0xECA6, 0xE5DA, 0xDF0B, 
    0xD89B, 0xD2EE, 0xCE65, 0xCB64, 0xCA4E, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0003, 0x0009, 0x000A, 0xFFFF, 0xFFE8, 0xFFC7, 0xFF9F, 
    0xFF71, 0xFF3F, 0xFF09, 0xFED1, 0xFE9A, 0xFE63, 0xFE2F, 0xFDFE, 0xFDD3, 
    0xFDAF, 0xFD92, 0xFD80, 0xFD78, 0xFD7D, 0xFD8F, 0xFDB0, 0xFDE3, 0xFE27, 
    0xFF07, 0x00C9, 0x0303, 0x054E, 0x0740, 0x0872, 0x087C, 0x044D, 0xFCC5, 
    0xF75B, 0xFE5F, 0xFF01, 0xFF7A, 0xFFD0, 0x0007, 0x0025, 0x0030, 0x002D, 
    0x0021, 0x0012, 0x0005, 0x0000, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
    0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
    0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
    0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
    0xF97B, 0xF99B, 0xF9D0, 0xF9DB, 0xF97B, 0xF8CE, 0xF81F, 0xF76D, 0xF6B8, 
    0xF600, 0xF546, 0xF488, 0xF3C7, 0xF303, 0xF23C, 0xF171, 0xF0A3, 0xEFD2, 
    0xEEFD, 0xEE25, 0xED48, 0xEC68, 0xEB84, 0xEA9D, 0xE9B1, 0xE8C1, 0xE77C, 
    0xE5BD, 0xE3C6, 0xE1DD, 0xE042, 0xDF3B, 0xDF0A, 0xE1DC, 0xE755, 0xEBE6, 
    0xEAC2, 0xEC09, 0xED8F, 0xEF3E, 0xF104, 0xF2CD, 0xF486, 0xF61A, 0xF777, 
    0xF888, 0xF93B, 0xF97B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
    0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
    0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
    0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
    0xEDAA, 0xEDDD, 0xEDE8, 0xED8B, 0xECE1, 0xEC31, 0xEB79, 0xEABC, 0xE9FA, 
    0xE934, 0xE869, 0xE79C, 0xE6CC, 0xE5FB, 0xE529, 0xE457, 0xE385, 0xE2B5, 
    0xE1E7, 0xE11B, 0xE053, 0xDF8F, 0xDECF, 0xDE16, 0xDD62, 0xDC80, 0xDB62, 
    0xDA43, 0xD95C, 0xD8E9, 0xD924, 0xDA49, 0xDFE5, 0xE8CB, 0xEE20, 0xDF52, 
    0xDF9C, 0xE07E, 0xE1D7, 0xE384, 0xE564, 0xE756, 0xE939, 0xEAEA, 0xEC4A, 
    0xED35, 0xED8B, 0x0001, 0xFFFE, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
    0xC170, 0xC15E, 0xC142, 0xC13C, 0xC170, 0xC1D3, 0xC244, 0xC2BF, 0xC342, 
    0xC3CA, 0xC455, 0xC4E0, 0xC568, 0xC5EB, 0xC665, 0xC6D6, 0xC739, 0xC78C, 
    0xC7C5, 0xC7E0, 0xC7E3, 0xC7D7, 0xC7C1, 0xC7A8, 0xC794, 0xC78C, 0xC78F, 
    0xC796, 0xC79E, 0xC7A3, 0xC7A4, 0xC79E, 0xC78C, 0xC75B, 0xC705, 0xC69F, 
    0xC62D, 0xC5AB, 0xC51F, 0xC48D, 0xC3FA, 0xC36B, 0xC2E4, 0xC26B, 0xC204, 
    0xC1B5, 0xC182, 0xC170, 0xFF42, 0xFF32, 0xFF23, 0xFF42, 0xFD7F, 0xFBEA, 
    0x00E0, 0x0CEC, 0x1B9F, 0x2BE3, 0x3CA1, 0x4CC0, 0x5B29, 0x66C6, 0x6FC1, 
    0x7724, 0x7D1D, 0x81E1, 0x859B, 0x887D, 0x8ABA, 0x8B80, 0x8A59, 0x87F7, 
    0x850D, 0x824D, 0x806B, 0x7EC0, 0x7D0B, 0x7C8C, 0x7E87, 0x8A77, 0x963B, 
    0x976B, 0x95C6, 0x9363, 0x925C, 0x928A, 0x9272, 0x922E, 0x91D7, 0x9188, 
    0x915B, 0x9167, 0x91C9, 0x9298, 0x93EF, 0x95E7, 0x989B, 0x9C23, 0xA19D, 
    0xA99A, 0xB361, 0xBE3A, 0xC96E, 0xD444, 0xDE05, 0xE5F7, 0xEBCD, 0xF015, 
    0xF361, 0xF644, 0xF952, 0xFD1D, 0x0239, 0x10BB, 0x223A, 0x2186, 0x0DE8, 
    0xF591, 0x59B6, 0x3B84, 0x1C2F, 0xFCE5, 0x5EE0, 0x434C, 0x2B5A, 0x183E, 
    0x0B29, 0x054B, 0x2D41, 0x2D42, 0x2D43, 0x2D41, 0x2D51, 0x2D5D, 0x2D1D, 
    0x2C69, 0x2B66, 0x2A45, 0x2937, 0x286B, 0x2813, 0x285E, 0x29B9, 0x2C1B, 
    0x2F0B, 0x320A, 0x349F, 0x364C, 0x3695, 0x34C9, 0x311B, 0x2C6A, 0x2796, 
    0x237E, 0x2101, 0x2120, 0x235A, 0x2651, 0x28A7, 0x29D4, 0x2A5E, 0x2A88, 
    0x2A84, 0x2A6D, 0x2A60, 0x2A6A, 0x2A84, 0x2AAA, 0x2AD6, 0x2B04, 0x2B2E, 
    0x2B51, 0x2B66, 0x2B69, 0x2B55, 0x2B26, 0x2AD6, 0x2A60, 0x297C, 0x2809, 
    0x263A, 0x2445, 0x225D, 0x20B9, 0x1F8B, 0x1F09, 0x1F91, 0x2115, 0x232A, 
    0x2566, 0x275E, 0x28A6, 0x28D5, 0x26EB, 0x2437, 0x23BF, 0x2691, 0x2B01, 
    0x5005, 0x4B95, 0x493B, 0x4830, 0x3888, 0x37F2, 0x3530, 0x3125, 0x2D79, 
    0x2BD6, 0x932B, 0x9356, 0x9382, 0x932B, 0x8FBD, 0x8BCD, 0x8E9B, 0x98CA, 
    0xA584, 0xB3CE, 0xC2AF, 0xD12A, 0xDE47, 0xE90A, 0xF1D7, 0xF9AD, 0x007C, 
    0x0636, 0x0ACA, 0x0E28, 0x1042, 0x0FE8, 0x0CC1, 0x07FC, 0x02C8, 0xFE54, 
    0xFBCE, 0xFBF7, 0xFE20, 0x0155, 0x04A2, 0x0962, 0x0DFA, 0x1082, 0x1298, 
    0x141A, 0x14E8, 0x1517, 0x14E4, 0x1468, 0x13BB, 0x12F5, 0x1230, 0x1184, 
    0x110A, 0x10D9, 0x110C, 0x11B9, 0x12FA, 0x14E8, 0x1792, 0x1B07, 0x1F5D, 
    0x24A8, 0x2B00, 0x3279, 0x3B28, 0x4524, 0x516D, 0x6061, 0x7122, 0x82D5, 
    0x9497, 0xA58D, 0xB4DA, 0xC664, 0xD529, 0xD2F1, 0xC0E1, 0xAA5F, 0x108C, 
    0xF482, 0xD76D, 0xBA69, 0x1E99, 0x051A, 0xEF10, 0xDD9B, 0xD1DC, 0xCCF5, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xC7DC, 0xC7DC, 
    0xC7DC, 0xC7DC, 0xC758, 0xC6D4, 0xC7DC, 0xCAA7, 0xCE28, 0xD20F, 0xD606, 
    0xD9BC, 0xDCDD, 0xDF16, 0xE057, 0xE0E8, 0xE0F0, 0xE09C, 0xE015, 0xDF84, 
    0xDF16, 0xDEA7, 0xDE07, 0xDD47, 0xDC7B, 0xDBB5, 0xDB06, 0xDA4C, 0xD986, 
    0xD8FD, 0xD8F9, 0xDAED, 0xDD0C, 0xDD6E, 0xDD63, 0xDD2D, 0xDD0C, 0xDD13, 
    0xDD26, 0xDD41, 0xDD61, 0xDD82, 0xDDA0, 0xDDB9, 0xDDC8, 0xDDCB, 0xDDBC, 
    0xDD9A, 0xDD61, 0xDD0C, 0xDC90, 0xDBE6, 0xDB11, 0xDA14, 0xD8F4, 0xD7B5, 
    0xD65A, 0xD4E6, 0xD2DA, 0xD004, 0xCCDD, 0xC9DF, 0xC786, 0xC649, 0xC6A4, 
    0xCE00, 0xDA91, 0xE1F9, 0xE281, 0xE195, 0xDF97, 0xDCE7, 0xD9E5, 0xD6F2, 
    0xD46D, 0xD1BA, 0xCE70, 0xCB3D, 0xC8D2, 0xC7DC, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFE4, 0xFF9B, 
    0xFF32, 0xFEB7, 0xFE37, 0xFDC0, 0xFD60, 0xFD25, 0xFD1C, 0xFD52, 0xFDD7, 
    0xFEB7, 0xFFFF, 0x0248, 0x05D9, 0x0A4C, 0x0F3A, 0x143A, 0x18E7, 0x1CD9, 
    0x1FA9, 0x2160, 0x225E, 0x22B9, 0x228A, 0x21E8, 0x20EA, 0x1FA9, 0x1C01, 
    0x163D, 0x1215, 0x0FF4, 0x0DD0, 0x0BB2, 0x09A4, 0x07B0, 0x05E0, 0x043C, 
    0x02CF, 0x01A3, 0x00C0, 0x0031, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFF8, 0xFFE4, 0xFFC6, 
    0xFFA4, 0xFF81, 0xFF60, 0xFF45, 0xFF35, 0xFF32, 0xFF41, 0xFF66, 0xFFA4, 
    0xFFFF, 0x00A2, 0x01A0, 0x02DC, 0x043A, 0x059E, 0x06EA, 0x0803, 0x08CB, 
    0x093D, 0x0972, 0x0977, 0x095A, 0x092B, 0x08F6, 0x08CB, 0x0884, 0x0808, 
    0x0775, 0x06D1, 0x0617, 0x054D, 0x047B, 0x03A7, 0x02D9, 0x0217, 0x0169, 
    0x00D5, 0x0063, 0x001A, 0xFFFF, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
    0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
    0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
    0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
    0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF551, 0xF569, 0xF58C, 0xF5B5, 
    0xF5DF, 0xF606, 0xF626, 0xF639, 0xF63C, 0xF62A, 0xF5FE, 0xF5B5, 0xF548, 
    0xF488, 0xF35B, 0xF1E3, 0xF044, 0xEE9D, 0xED13, 0xEBC6, 0xEAD9, 0xEA51, 
    0xEA13, 0xEA0D, 0xEA2E, 0xEA67, 0xEAA5, 0xEAD9, 0xEB2D, 0xEBBF, 0xEC6F, 
    0xED31, 0xEE0E, 0xEEFD, 0xEFF7, 0xF0F2, 0xF1E7, 0xF2CD, 0xF39B, 0xF44A, 
    0xF4D2, 0xF529, 0xF548, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xEA48, 
    0xEA71, 0xEAD5, 0xEB54, 0xEBB2, 0xEC2B, 0xED56, 0xEF4F, 0xF1AA, 0xF437, 
    0xF6C3, 0xF91D, 0xFB12, 0xFC71, 0xFD49, 0xFDCE, 0xFDFE, 0xFDDB, 0xFD65, 
    0xFC9B, 0xFB7F, 0xF9C5, 0xF751, 0xF46D, 0xF15F, 0xEE73, 0xEBF0, 0xE9ED, 
    0xE83E, 0xE6C5, 0xE562, 0xE42D, 0xE3A8, 0xE3DB, 0xE456, 0xE4E8, 0xE562, 
    0xE5BF, 0xE61B, 0xE675, 0xE6CD, 0xE724, 0xE779, 0xE7CD, 0xE81E, 0xE86F, 
    0xE899, 0xE8A5, 0xE8D4, 0xE968, 0xEA3E, 0xEB10, 0xEBEC, 0xECE1, 0xEDFC, 
    0xEF4C, 0xF0DF, 0xF2C3, 0xF550, 0xF89B, 0xFC4E, 0x0013, 0x0393, 0x0678, 
    0x086D, 0x0755, 0x0390, 0x0084, 0x0230, 0xFB50, 0xF750, 0xF289, 0xEDB1, 
    0xE8B1, 0xE372, 0xDEDA, 0xDBCE, 0xD90D, 0xD70E, 0xD649, 0xF262, 0xF21D, 
    0xF17C, 0xF0C3, 0xEF6B, 0xEDFA, 0xEE4D, 0xF0A6, 0xF3CD, 0xF765, 0xFB13, 
    0xFE7C, 0x0142, 0x030B, 0x03AF, 0x0370, 0x0296, 0x0169, 0x002F, 0xFF31, 
    0xFEB4, 0xFF01, 0xFFE6, 0x00FC, 0x01D9, 0x0213, 0x0143, 0xFE27, 0xF901, 
    0xF3AA, 0xEFFB, 0xF154, 0xF3CD, 0xF354, 0xF238, 0xF0F3, 0xEFFB, 0xEF56, 
    0xEEBB, 0xEE27, 0xED9B, 0xED16, 0xEC96, 0xEC1D, 0xEBA9, 0xEB39, 0xEAF7, 
    0xEAE5, 0xEAC9, 0xEA67, 0xE993, 0xE867, 0xE710, 0xE5BB, 0xE497, 0xE3D0, 
    0xE394, 0xE410, 0xE594, 0xE817, 0xEB45, 0xEEC7, 0xF249, 0xF574, 0xF7F4, 
    0xF8F5, 0xF8BB, 0xF890, 0xF91B, 0xFA4C, 0xFBCA, 0xFA31, 0xF82D, 0xF5EF, 
    0xF3A6, 0xF12F, 0xEF70, 0xEDDA, 0xECB2, 0xEC40, 0x8A9D, 0x8A22, 0x88FB, 
    0x8799, 0x83D7, 0x7FD9, 0x827F, 0x8CFC, 0x9AE0, 0xAA88, 0xBA50, 0xC895, 
    0xD3B3, 0xDA06, 0xDA6F, 0xD601, 0xCE69, 0xC555, 0xBC6F, 0xB566, 0xB1E5, 
    0xB2DD, 0xB71F, 0xBD26, 0xC36F, 0xC875, 0xCAB4, 0xC88F, 0xC2ED, 0xBC0F, 
    0xB634, 0xB2D7, 0xB1BD, 0xB2F7, 0xB578, 0xB7F4, 0xB91D, 0xB903, 0xB89E, 
    0xB7FC, 0xB72E, 0xB643, 0xB54A, 0xB453, 0xB36C, 0xB2A6, 0xB229, 0xB1D2, 
    0xB145, 0xB021, 0xAEB0, 0xAD63, 0xAC12, 0xAA97, 0xA8C9, 0xA683, 0xA39D, 
    0x9FF0, 0x9AA7, 0x9392, 0x8B87, 0x835B, 0x7BE3, 0x75F6, 0x7269, 0x75EE, 
    0x8052, 0x8B0F, 0x955E, 0x9BC3, 0xA0BE, 0xA3F3, 0xA6E1, 0xA9C8, 0xACE6, 
    0xAFE7, 0xB1EE, 0xB3C5, 0xB51A, 0xB59D, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x2537, 0x2584, 0x25D1, 0x2537, 0x22AE, 0x1F3D, 0x1D11, 0x1CA3, 0x1CCE, 
    0x1D4B, 0x1DD6, 0x1E28, 0x1DFE, 0x1D11, 0x1B05, 0x17FA, 0x1462, 0x10B0, 
    0x0D59, 0x0ACD, 0x0982, 0x09DA, 0x0B96, 0x0E35, 0x1134, 0x1413, 0x1650, 
    0x17E3, 0x1927, 0x1A2D, 0x1B07, 0x1B3A, 0x1B07, 0x1B18, 0x1B35, 0x1B3B, 
    0x1B07, 0x1AA4, 0x1A33, 0x19B8, 0x1935, 0x18AD, 0x1822, 0x1797, 0x170F, 
    0x168C, 0x1611, 0x15A1, 0x153E, 0x14EB, 0x142F, 0x12D7, 0x114C, 0x0FF7, 
    0x0F40, 0x0F90, 0x1151, 0x14EB, 0x1B55, 0x2497, 0x2FB4, 0x3BAD, 0x4785, 
    0x523E, 0x5ADB, 0x5B2C, 0x55F2, 0x50DE, 0x4B62, 0x43B0, 0x3C1B, 0x3671, 
    0x3163, 0x2C34, 0x2896, 0x271F, 0x2626, 0x2591, 0x2549, 0x2537, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x000F, 0x0036, 0x0066, 0x0092, 0x00AB, 
    0x00A4, 0x006F, 0xFFFF, 0xFF2E, 0xFDF9, 0xFC87, 0xFB00, 0xF98A, 0xF84E, 
    0xF771, 0xF86A, 0xFA69, 0xFBB7, 0xF903, 0xF924, 0xF69C, 0xF72F, 0xF863, 
    0xF97E, 0xFAA3, 0xFBE4, 0xFD4F, 0xFEA2, 0xFF9D, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0x0000, 0x0009, 0x001F, 0x0037, 0x004B, 0x0051, 0x0042, 0x0015, 
    0xFF2B, 0xFDCD, 0xFCA0, 0xFB70, 0xFB64, 0xFBE8, 0xFCA8, 0xFD71, 0xFE49, 
    0xFEEF, 0xFF47, 0xFF92, 0xFFCC, 0xFFF2, 0xFFFF, 0xBF3F, 0xBF3F, 0xBF3F, 
    0xBF3F, 0xBEA2, 0xBE04, 0xBF3F, 0xC2CC, 0xC77F, 0xCCBD, 0xD1EA, 0xD66A, 
    0xD9A1, 0xDAF4, 0xD9AE, 0xD61F, 0xD12E, 0xCBC3, 0xC6C5, 0xC31D, 0xC1B1, 
    0xC336, 0xC71E, 0xCC6D, 0xD228, 0xD754, 0xDAF4, 0xDC5F, 0xDC37, 0xDB6D, 
    0xDAF4, 0xDAF4, 0xDAF4, 0xDAF0, 0xDAEB, 0xDAE9, 0xDAF4, 0xDB08, 0xDB1E, 
    0xDB37, 0xDB51, 0xDB6C, 0xDB88, 0xDBA4, 0xDBBF, 0xDBD9, 0xDBF2, 0xDC08, 
    0xDC1C, 0xDC2D, 0xDC5C, 0xDCB8, 0xDD24, 0xDD83, 0xDDB6, 0xDDA2, 0xDD29, 
    0xDC2D, 0xDAA8, 0xD8AF, 0xD648, 0xD37C, 0xD052, 0xCCD2, 0xC904, 0xC1D9, 
    0xB8A7, 0xB107, 0xA99A, 0xA758, 0xAA1B, 0xADEB, 0xB216, 0xB743, 0xBB3C, 
    0xBCDB, 0xBE00, 0xBEBD, 0xBF21, 0xBF3F, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xBF5E, 0xC017, 0xC0D1, 0xBF5E, 0xB8D9, 0xB028, 0xABD0, 0xACDA, 0xAF8C, 
    0xB340, 0xB754, 0xBB22, 0xBE07, 0xBF5E, 0xBED0, 0xBCD1, 0xB9F0, 0xB6BB, 
    0xB3C0, 0xB18E, 0xB0B3, 0xB195, 0xB3DA, 0xB6EF, 0xBA43, 0xBD43, 0xBF5E, 
    0xC031, 0xC01A, 0xBFA4, 0xBF5E, 0x160A, 0x1561, 0x140E, 0x1310, 0x12F2, 
    0x1328, 0x1310, 0x129B, 0x1220, 0x1198, 0x10FE, 0x104C, 0x0F7C, 0x0E89, 
    0x0D42, 0x0BA0, 0x09D0, 0x0806, 0x0670, 0x0540, 0x04A6, 0x0507, 0x0654, 
    0x0815, 0x09D2, 0x0B13, 0x0B5E, 0x09C7, 0x069F, 0x034E, 0x013A, 0x030E, 
    0x056C, 0x04F5, 0x03C9, 0x0285, 0x01C2, 0x018D, 0x0181, 0x0190, 0x01AF, 
    0x01D1, 0x01E9, 0x01EC, 0x01CD, 0x017F, 0x00F8, 0x003F, 0xFF61, 0xFE6A, 
    0xFD66, 0xFC63, 0xFB6E, 0xFA91, 0xF9DB, 0xF958, 0xF915, 0xF91D, 0xF9D3, 
    0xFB5C, 0xFD6E, 0xFFC0, 0x0206, 0x03F7, 0x0548, 0x057D, 0x04BF, 0x03BB, 
    0x031D, 0x0B95, 0x1095, 0x0FB3, 0x0EF7, 0x140E, 0x1ACB, 0x1F19, 0x1F6F, 
    0x1DEE, 0x1BFE, 0x1B09, 0x1789, 0x1810, 0x191D, 0x19E7, 0x1A3B, 0x1A4C, 
    0x19E7, 0x190A, 0x17EA, 0x16A8, 0x1568, 0x144B, 0x1373, 0x1303, 0x1314, 
    0x1393, 0x1458, 0x153E, 0x161D, 0x16D0, 0x1730, 0x1725, 0x16CA, 0x1643, 
    0x15B7, 0x154B, 0x1525, 0x157D, 0x1638, 0x1706, 0x1792, 0x1763, 0x170A, 
    0x171B, 0x1744, 0x1771, 0x178B, 0x1794, 0x179B, 0x17A0, 0x17A3, 0x17A4, 
    0x17A3, 0x179F, 0x1798, 0x178F, 0x1787, 0x1783, 0x1782, 0x1781, 0x177F, 
    0x1779, 0x176F, 0x175D, 0x1743, 0x171F, 0x16EE, 0x16AF, 0x163C, 0x1586, 
    0x14AB, 0x13CC, 0x1309, 0x1281, 0x1254, 0x12C6, 0x13E0, 0x156B, 0x1732, 
    0x18E8, 0x17B9, 0x16FF, 0x16CB, 0x17CD, 0x192B, 0x196C, 0x17B4, 0x14F3, 
    0x1265, 0x1144, 0xA1EE, 0xA0C6, 0x9E75, 0x9CB8, 0x9B6E, 0x9AB7, 0x9CB8, 
    0xA1CB, 0xA85B, 0xAFAA, 0xB6FA, 0xBD8D, 0xC2A5, 0xC584, 0xC59A, 0xC361, 
    0xBFA7, 0xBB3B, 0xB6EC, 0xB388, 0xB1DE, 0xB299, 0xB533, 0xB8AE, 0xBC11, 
    0xBE5E, 0xBE9B, 0xB84C, 0xAD9A, 0xA749, 0xA64D, 0xA75E, 0xA875, 0xA8D8, 
    0xA956, 0xA9CA, 0xAA1D, 0xAA85, 0xAAFF, 0xAB80, 0xABF8, 0xAC5C, 0xAC9E, 
    0xACB0, 0xAC85, 0xAC10, 0xAB6E, 0xAAC1, 0xAA04, 0xA930, 0xA83F, 0xA72D, 
    0xA5F1, 0xA488, 0xA2EA, 0xA112, 0x9EFA, 0x9C9C, 0x9962, 0x9504, 0x8FE8, 
    0x8A7A, 0x8520, 0x8046, 0x7C51, 0x79AB, 0x783A, 0x77A9, 0x77A4, 0x8A65, 
    0x946B, 0x986A, 0x9AB4, 0x9F8C, 0xA4CA, 0xA89D, 0xAA98, 0xABB1, 0xAC29, 
    0xAC43, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x1E4A, 0x1E4A, 0x1E4A, 0x1E4A, 0x1DF8, 
    0x1DA7, 0x1E4A, 0x202B, 0x22B6, 0x258E, 0x2853, 0x2AA9, 0x2C30, 0x2C8C, 
    0x2B3E, 0x2870, 0x24BF, 0x20C9, 0x1D29, 0x1A7F, 0x1966, 0x1A5B, 0x1D00, 
    0x20AA, 0x24B0, 0x2868, 0x2B26, 0x2C9F, 0x2D42, 0x2D7F, 0x2DC5, 0x2DE1, 
    0x2DC5, 0x2DFD, 0x2E59, 0x2E6C, 0x2DC5, 0x2C68, 0x2AB6, 0x28CB, 0x26C3, 
    0x24B9, 0x22C9, 0x2111, 0x1FAA, 0x1EB2, 0x1E25, 0x1DE3, 0x1DDF, 0x1E07, 
    0x1E4F, 0x1EA6, 0x1EFD, 0x1F47, 0x1F73, 0x1F73, 0x1F37, 0x1EB2, 0x1D43, 
    0x1ABA, 0x17A9, 0x14A4, 0x1240, 0x1110, 0x11A8, 0x1513, 0x1BB6, 0x2532, 
    0x3126, 0x4AF7, 0x491E, 0x44C9, 0x3E78, 0x381B, 0x3185, 0x2BFA, 0x2741, 
    0x22D5, 0x1F90, 0x1E4A, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0002, 0x0005, 
    0xFFFF, 0xFFF1, 0xFFDD, 0xFFC7, 0xFFB1, 0xFF9E, 0xFF91, 0xFF8C, 0xFF92, 
    0xFFA2, 0xFFB7, 0xFFCF, 0xFFE5, 0xFFF6, 0xFFFC, 0xFFF3, 0xFFDE, 0xFFC2, 
    0xFFA7, 0xFF93, 0xFF8C, 0xFF9E, 0xFFC5, 0xFFF2, 0x0013, 0x0019, 0x0013, 
    0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
    0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
    0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0017, 0x0021, 
    0x002B, 0x0033, 0x0035, 0x002B, 0x0013, 0xFFE1, 0xFF91, 0xFF28, 0xFEAC, 
    0xFB7C, 0xFA5E, 0xFD74, 0x00D3, 0x007F, 0xFF70, 0x003F, 0x0045, 0x002D, 
    0x000F, 0x0000, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2E, 0xFF2D, 0xFF2F, 
    0xFF33, 0xFF39, 0xFF40, 0xFF47, 0xFF4D, 0xFF51, 0xFF52, 0xFF50, 0xFF4B, 
    0xFF43, 0xFF3C, 0xFF35, 0xFF30, 0xFF2F, 0xFF33, 0xFF3D, 0xFF48, 0xFF54, 
    0xFF5D, 0xFF60, 0xFF5A, 0xFF4C, 0xFF3C, 0xFF30, 0xFF2E, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF32, 0xFF36, 0xFF3A, 
    0xFF3E, 0xFF3E, 0xFF3A, 0xFF30, 0xFF1F, 0xFF03, 0xFED7, 0xFE95, 0xFCD5, 
    0xFC2D, 0xFC5F, 0xFCD8, 0xFD14, 0xFD53, 0xFDD0, 0xFE3C, 0xFEAF, 0xFF0A, 
    0xFF2F, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC94E, 0xC8C6, 0xC9D7, 0xCCEF, 
    0xD10C, 0xD5A3, 0xDA28, 0xDE11, 0xE0D3, 0xE1E2, 0xE094, 0xDD2C, 0xD883, 
    0xD371, 0xCECF, 0xCB76, 0xCA3F, 0xCC47, 0xD120, 0xD756, 0xDD76, 0xE20A, 
    0xE39E, 0xDFB5, 0xD725, 0xCD75, 0xC62C, 0xC4F2, 0xC62C, 0xC62C, 0xC62C, 
    0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
    0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
    0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC635, 0xC648, 0xC65F, 0xC670, 
    0xC672, 0xC65F, 0xC62C, 0xC62A, 0xC62C, 0xC571, 0xC337, 0xADE1, 0xA7EB, 
    0xA95C, 0xAE2E, 0xB2B9, 0xB7D9, 0xBD9C, 0xC18B, 0xC586, 0xC89B, 0xC9D7, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFD39, 0xF54C, 0xE96C, 0xDCDE, 0xD247, 0xC90B, 
    0xBF94, 0xB7BA, 0xB370, 0xB323, 0xB5CA, 0xB9CB, 0xBD87, 0xBF90, 0xC019, 
    0xC047, 0xC035, 0xBFFC, 0xBFBA, 0xBF8D, 0xBF92, 0xBFAD, 0xBFB5, 0xBFAF, 
    0xBFA3, 0xBF97, 0xBF92, 0xBF8C, 0xBF81, 0xBF76, 0xBF73, 0xBF7B, 0xBF92, 
    0xBFB4, 0xBFD6, 0xBFED, 0xBFF5, 0xBFEC, 0xBFD2, 0xBFA2, 0xBF2E, 0xBE46, 
    0xBCE0, 0xBAE8, 0xB846, 0xB4DC, 0xB088, 0xAB2D, 0x24C3, 0x1D61, 0x151C, 
    0x0CD5, 0x05A7, 0xFFE7, 0xFB68, 0xF7CF, 0xF4BC, 0xF1C1, 0xE2AB, 0x0171, 
    0xFD25, 0xFD2C, 0xFE39, 0xFF6C, 0xFFFF, 0xFFFD, 0xFFF6, 0xFFEB, 0xFFDD, 
    0xFFCD, 0xFFBD, 0xFFAE, 0xFFA3, 0xFF9E, 0xFF9E, 0xFFAC, 0xFFCD, 0xFFEF, 
    0xFFFF, 0x0001, 0xFFC6, 0xFDEC, 0xF7B5, 0xEC08, 0xDEB2, 0xD458, 0xCED9, 
    0xCD20, 0xCCF8, 0xCD81, 0xCE28, 0xCE9E, 0xCED5, 0xCED9, 0xCECE, 0xCECE, 
    0xCED2, 0xCED7, 0xCED9, 0xCED9, 0xCED9, 0xCEDA, 0xCEDA, 0xCEDA, 0xCED9, 
    0xCED9, 0xCED9, 0xCED4, 0xCEC9, 0xCEBD, 0xCEB8, 0xCEBF, 0xCED9, 0xCF0A, 
    0xCF45, 0xCF7B, 0xCF9B, 0xCF95, 0xCF5A, 0xCED8, 0xCE1A, 0xCD3B, 0xCC42, 
    0xCB3A, 0xCA2C, 0xC921, 0xC825, 0xC741, 0xB980, 0xBA1D, 0xBA73, 0xBA72, 
    0xBA38, 0xB9E9, 0xB9A7, 0xB98C, 0xB9AD, 0xBA1D, 0xBD8B, 0xC731, 0xD4BA, 
    0xE480, 0xF2D5, 0xFC8B, 0xFFFF, 0xFFFE, 0xFFFB, 0xFFF9, 0xFFF8, 0xFFF7, 
    0xFFF3, 0xFFE7, 0xFFD6, 0xFFC6, 0xFFBF, 0xFFCA, 0xFFE1, 0xFFF6, 0xFFFF, 
    0x307B, 0x2DC7, 0x2627, 0x1B1F, 0x1090, 0x0A7C, 0x0AFF, 0x131D, 0x1F27, 
    0x2AAD, 0x3453, 0x3BE5, 0x4157, 0x447A, 0x4512, 0x431E, 0x3F46, 0x3A49, 
    0x34F7, 0x3024, 0x2CA2, 0x2B34, 0x2B6F, 0x2C3B, 0x2D52, 0x2E70, 0x2F4E, 
    0x2FA7, 0x2F61, 0x2E9C, 0x2D6B, 0x2BE2, 0x2A17, 0x2821, 0x261C, 0x2421, 
    0x2248, 0x20A3, 0x1F42, 0x1E34, 0x1D89, 0x1D62, 0x1DCD, 0x1ECA, 0x2063, 
    0x22A5, 0x25A3, 0x2976, 0x2E2E, 0xB3C9, 0xBA24, 0xC118, 0xC7CA, 0xCD3B, 
    0xD132, 0xD3F8, 0xD602, 0xD7C9, 0xD9D2, 0xE8CE, 0xCB13, 0xD178, 0xD482, 
    0xD732, 0xD9B2, 0xDBA5, 0xDFFE, 0xE8BC, 0xF40A, 0xFF77, 0x0834, 0x0BA4, 
    0x08E8, 0x02DE, 0xFCD2, 0xFA17, 0xFB05, 0xFD0C, 0xFF13, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x004F, 0x0001, 0x0050, 0x0050, 0x0001, 0x00A0, 0x0001, 
    0x00A1, 0x0001, 0x00A2, 0x0050, 0x00A3, 0x0050, 0x00F3, 0x0050, 0x0143, 
    0x0050, 0x0193, 0x0050, 0x01E3, 0x0050, 0x0233, 0x0050, 0x0283, 0x0050, 
    0x02D3, 0x0050, 0x0323, 0x0001, 0x0373, 0x0001, 0x0374, 0x0001, 0x0375, 
    0x0050, 0x0376, 0x0050, 0x03C6, 0x0050, 0x0416, 0x004E, 0x0466, 0x0050, 
    0x04B4, 0x0050, 0x0504, 0x0050, 0x0554, 0x0050, 0x05A4, 0x0050, 0x05F4, 
    0x0001, 0x0644, 0x0001, 0x0645, 0x0050, 0x0646, 0x0050, 0x0696, 0x0050, 
    0x06E6, 0x0050, 0x0736, 0x0050, 0x0786, 0x0050, 0x07D6, 0x0050, 0x0826, 
    0x0050, 0x0876, 0x0050, 0x08C6, 0x0050, 0x0916, 0x004D, 0x0966, 0x0050, 
    0x09B3, 0x0001, 0x0A03, 0x0050, 0x0A04, 0x0050, 0x0A54, 0x0050, 0x0AA4, 
    0x0050, 0x0AF4, 0x004D, 0x0B44, 0x0050, 0x0B91, 0x0050, 0x0BE1, 0x0050, 
    0x0C31, 0x0050, 0x0C81, 0x004D, 0x0CD1, 0x0050, 0x0D1E, 0x001F, 0x0D6E, 
    0x0050, 0x0D8D, 0x0050, 0x0DDD, 0x0050, 0x0E2D, 0x004E, 0x0E7D, 0x004E, 
    0x0ECB, 0x0050, 0x0F19, 0x0050, 0x0F69, 0x0050, 0x0FB9, 0x0050, 0x1009, 
    0x0050, 0x1059, 0x0050, 0x10A9, 0x004C, 0x10F9, 0x0050, 0x1145, 0x0050, 
    0x1195, 0x0050, 0x11E5, 
})

smlua_anim_util_register_animation("MILNE_ANIM_BACKWARD_KB",
    1,
    0,
    0,
    0,
    29,
    {
    0x0000, 0x0059, 0x000D, 0xFFC0, 0xFFC6, 0xFFD1, 0xFFD7, 0xFFCE, 0xFFC4, 
    0xFFC4, 0xFFC4, 0xFFCA, 0xFFCA, 0xFFC8, 0xFFC7, 0xFFC7, 0xFFC6, 0xFFCC, 
    0xFFDA, 0xFFEF, 0x0008, 0x0024, 0x0041, 0x005B, 0x0073, 0x0087, 0x0095, 
    0x009D, 0x00A3, 0x00A8, 0x00AA, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFF84, 
    0xFF68, 0xFF4B, 0xFF48, 0xFF46, 0xFF43, 0xFF40, 0xFF3D, 0xFF3A, 0xFF37, 
    0xFF36, 0xFF35, 0xFF35, 0xFF36, 0xFF38, 0xFF3D, 0xFF43, 0xFF4B, 0xFF68, 
    0xFF9D, 0xFFD4, 0xFFF5, 0x0001, 0x0008, 0x000A, 0x0009, 0x0007, 0x0004, 
    0x0001, 0xFFFF, 0x02CF, 0x02CA, 0x02C3, 0x02C4, 0x02C8, 0x02CF, 0x02D7, 
    0x02E0, 0x02E9, 0x02F1, 0x02F8, 0x02FC, 0x02FE, 0x02FC, 0x02F6, 0x02EB, 
    0x02DA, 0x02C3, 0x026F, 0x01D4, 0x0130, 0x00C4, 0x008E, 0x0063, 0x0041, 
    0x0027, 0x0014, 0x0008, 0x0002, 0xFFFF, 0x28FB, 0x2762, 0x25B7, 0x2588, 
    0x2538, 0x24D0, 0x2458, 0x23DB, 0x2362, 0x22F5, 0x229E, 0x2267, 0x2259, 
    0x227C, 0x22DB, 0x237E, 0x246F, 0x25B7, 0x2A77, 0x333B, 0x3C31, 0x4186, 
    0x4334, 0x43E8, 0x43DF, 0x4352, 0x427D, 0x419C, 0x40EA, 0x40A1, 0xF868, 
    0xFC58, 0x04A0, 0x051B, 0x0575, 0x05B2, 0x05D4, 0x05E0, 0x05D9, 0x05C2, 
    0x05A0, 0x0575, 0x0546, 0x0516, 0x04E8, 0x04C0, 0x04A2, 0x0483, 0x0451, 
    0x0400, 0x0385, 0x02D5, 0x015B, 0xFF62, 0xFE34, 0xFE2A, 0xFE94, 0xFF32, 
    0xFFC1, 0x0000, 0x0083, 0x0045, 0xFFB3, 0xFFA2, 0xFF78, 0xFF3D, 0xFEF8, 
    0xFEB0, 0xFE6C, 0xFE32, 0xFE0A, 0xFDFB, 0xFE0D, 0xFE45, 0xFEAB, 0xFF46, 
    0x001D, 0x0292, 0x070B, 0x0C16, 0x103F, 0x1215, 0x0E68, 0x06F3, 0x01A4, 
    0x0006, 0xFF6F, 0xFF7E, 0xFFCF, 0xFFFF, 0x0435, 0x0465, 0x044A, 0x03EF, 
    0x0369, 0x02C1, 0x0206, 0x0142, 0x0081, 0xFFD1, 0xFF3C, 0xFECE, 0xFE95, 
    0xFE9B, 0xFEED, 0xFF97, 0x00A5, 0x0402, 0x0A52, 0x11B8, 0x1857, 0x1C51, 
    0x1ACF, 0x1568, 0x10E5, 0x0E70, 0x0C2A, 0x0A47, 0x08FD, 0x0884, 0x0321, 
    0xFF00, 0xF6AC, 0xF55C, 0xF564, 0xF5DF, 0xF727, 0xF8B2, 0xF926, 0xF98C, 
    0xFA75, 0xFB82, 0xFC91, 0xFD81, 0xFE6A, 0xFF2F, 0xFF61, 0xFEE5, 0xFE11, 
    0xFD1A, 0xFC35, 0xFB98, 0xFB6F, 0xFBAA, 0xFC24, 0xFCE4, 0xFDE5, 0xFEE7, 
    0xFFAF, 0x0000, 0xFA27, 0xF99B, 0xF8C5, 0xFA4B, 0xFC39, 0xFD94, 0xFD17, 
    0xFC79, 0xFDED, 0xFF8A, 0x003F, 0x00C3, 0x0121, 0x0167, 0x0192, 0x018B, 
    0x013E, 0x009D, 0xFFC6, 0xFEE4, 0xFE25, 0xFDB6, 0xFE02, 0xFED8, 0xFF7A, 
    0xFFB7, 0xFFDE, 0xFFF4, 0xFFFD, 0x0000, 0x0F2A, 0x17C3, 0x28F4, 0x3016, 
    0x3522, 0x3700, 0x2FEF, 0x287E, 0x2DB6, 0x33A2, 0x336D, 0x31DD, 0x2F40, 
    0x2BE0, 0x26AB, 0x1FEE, 0x1A09, 0x152E, 0x104F, 0x0BE6, 0x0870, 0x0667, 
    0x08D9, 0x0E5F, 0x10C2, 0x0DD6, 0x08AE, 0x02F3, 0xFE4C, 0xFC61, 0x0001, 
    0xFFFE, 0xC170, 0xD16D, 0xD16D, 0xCE73, 0xCF0A, 0xCF99, 0xD025, 0xD0B3, 
    0xD148, 0xD1E8, 0xD296, 0xD359, 0xD434, 0xD52C, 0xD646, 0xD785, 0xD8EE, 
    0xDA87, 0xDD4C, 0xE19D, 0xE68D, 0xEB31, 0xEE9D, 0xF112, 0xF363, 0xF581, 
    0xF75E, 0xF8EB, 0xFA19, 0xFAD9, 0xFB1C, 0xDE5E, 0xDE5E, 0xE000, 0xE1D5, 
    0xE3E6, 0xE625, 0xE87F, 0xEAE5, 0xED45, 0xEF8F, 0xF1B2, 0xF39E, 0xF542, 
    0xF68D, 0xF76F, 0xF7D7, 0xF7B4, 0xF492, 0xED8C, 0xE4E7, 0xDCEB, 0xD7DC, 
    0xD579, 0xD3E3, 0xD2F4, 0xD286, 0xD272, 0xD293, 0xD2C3, 0xD2DB, 0x098D, 
    0x098D, 0x0DB0, 0x0BE9, 0x0A07, 0x080D, 0x05FF, 0x03E0, 0x01B2, 0xFF79, 
    0xFD38, 0xFAF3, 0xF8AB, 0xF666, 0xF425, 0xF1EC, 0xEFBD, 0xED8D, 0xEB51, 
    0xE914, 0xE6E0, 0xE4BE, 0xE276, 0xDFE5, 0xDD3A, 0xDAA4, 0xD850, 0xD66D, 
    0xD529, 0xD4B3, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xD516, 0xD516, 0xCCC0, 0xC910, 
    0xC65A, 0xC568, 0xC979, 0xCDBF, 0xCAD1, 0xC7E2, 0xCF95, 0xD129, 0xD28C, 
    0xD398, 0xD429, 0xD41A, 0xD345, 0xCE13, 0xC65E, 0xC431, 0xD490, 0xE39A, 
    0xE2FB, 0xE056, 0xDC50, 0xD791, 0xD2BD, 0xCE7D, 0xCB76, 0xCA4E, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xF97B, 
    0xED8B, 0x0001, 0xFFFE, 0xC170, 0x17D3, 0x17D3, 0x271F, 0x2756, 0x275D, 
    0x2736, 0x26E4, 0x2668, 0x25C7, 0x2502, 0x241B, 0x2316, 0x21F6, 0x20BB, 
    0x1F6B, 0x1E06, 0x1C8F, 0x1A70, 0x1603, 0x0DBA, 0xF198, 0xFAE7, 0xEA1A, 
    0xEF9D, 0xF21F, 0xF663, 0xFB6D, 0x0040, 0x03DE, 0x054B, 0x500D, 0x500D, 
    0x4EFF, 0x4BD6, 0x4897, 0x4548, 0x41ED, 0x3E89, 0x3B21, 0x37B9, 0x3456, 
    0x30FC, 0x2DAF, 0x2A73, 0x274C, 0x2440, 0x2151, 0x1E67, 0x1CB7, 0x1E3D, 
    0x307A, 0x27E7, 0x2764, 0x2CE6, 0x2D29, 0x2D0F, 0x2CBC, 0x2C55, 0x2BFC, 
    0x2BD6, 0xD724, 0xD724, 0xE339, 0xE5E6, 0xE891, 0xEB34, 0xEDC9, 0xF04A, 
    0xF2B0, 0xF4F5, 0xF713, 0xF903, 0xFABF, 0xFC41, 0xFD82, 0xFE7C, 0xFF29, 
    0xFC30, 0xF49D, 0xEBFF, 0xDF58, 0xD6DC, 0xC269, 0xC6C6, 0xC660, 0xC747, 
    0xC8F0, 0xCACE, 0xCC54, 0xCCF5, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xDDE6, 
    0xDDE6, 0xDD0C, 0xD88E, 0xD376, 0xCFBD, 0xD37F, 0xCF20, 0xC96D, 0xC6D2, 
    0xD52A, 0xD6EF, 0xD797, 0xD796, 0xD761, 0xD76B, 0xD828, 0xDA44, 0xDD6A, 
    0xE094, 0xE2BB, 0xE2D7, 0xE0B9, 0xDD37, 0xD8D6, 0xD419, 0xCF84, 0xCB9B, 
    0xC8E2, 0xC7DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFF5, 0xFFD8, 0xFFAE, 0xFF7B, 
    0xFF45, 0xFF11, 0xFEE4, 0xFEC2, 0xFEB0, 0xFEB4, 0xFED3, 0xFF11, 0xFF74, 
    0xFFFF, 0x0223, 0x0605, 0x09BE, 0x0B68, 0xFFFF, 0xFF07, 0xFE92, 0xFE83, 
    0xFEBB, 0xFF1B, 0xFF86, 0xFFDC, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFEC, 
    0xFFB7, 0xFF6A, 0xFF0E, 0xFEAC, 0xFE4D, 0xFDFA, 0xFDBD, 0xFD9D, 0xFDA4, 
    0xFDDC, 0xFE4D, 0xFF01, 0xFFFF, 0x03E5, 0x0AF7, 0x11BF, 0x14C7, 0xFFFF, 
    0xFE3B, 0xFD67, 0xFD4B, 0xFDB0, 0xFE60, 0xFF22, 0xFFBF, 0xFFFF, 0xEB58, 
    0xEB58, 0xE7D6, 0xE79B, 0xE760, 0xE729, 0xE6F7, 0xE6CD, 0xE6AB, 0xE695, 
    0xE68C, 0xE692, 0xE6A9, 0xE6D3, 0xE712, 0xE768, 0xE7D6, 0xE91A, 0xEB73, 
    0xEE2B, 0xF08B, 0xF1A9, 0xF238, 0xF2D1, 0xF36C, 0xF3FF, 0xF482, 0xF4EA, 
    0xF52F, 0xF548, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xBF32, 0xBF5E, 0xC07B, 
    0xC1B8, 0xC30C, 0xC470, 0xC5DB, 0xC746, 0xC8A8, 0xC9FB, 0xCB35, 0xCC4F, 
    0xCD41, 0xCE04, 0xCE8E, 0xCED9, 0xCD8B, 0xCA29, 0xC5F6, 0xC237, 0xBF5E, 
    0xBF20, 0xBF03, 0xBEFF, 0xBF0D, 0xBF25, 0xBF40, 0xBF55, 0xBF5E, 0xEFE9, 
    0xEFE9, 0xE009, 0xDFA8, 0xDF81, 0xDF8F, 0xDFCE, 0xE038, 0xE0C9, 0xE17B, 
    0xE24A, 0xE330, 0xE429, 0xE52F, 0xE63D, 0xE74F, 0xE85F, 0xEA7D, 0xEDDB, 
    0xF121, 0xF2FA, 0xEBD4, 0xE876, 0xE4E0, 0xE146, 0xDDDE, 0xDADC, 0xD875, 
    0xD6DD, 0xD649, 0xEACA, 0xEACA, 0xE5CA, 0xE456, 0xE2DA, 0xE159, 0xDFDA, 
    0xDE60, 0xDCF1, 0xDB93, 0xDA49, 0xD91A, 0xD809, 0xD71D, 0xD65A, 0xD5C5, 
    0xD563, 0xD6D1, 0xDA6D, 0xDE60, 0xE0D4, 0xDAD0, 0xDC89, 0xDEF7, 0xE1D1, 
    0xE4CD, 0xE7A0, 0xEA00, 0xEBA4, 0xEC40, 0x99D8, 0x99D8, 0x81E3, 0x7FCB, 
    0x7E1F, 0x7CD0, 0x7BCF, 0x7B10, 0x7A85, 0x7A21, 0x79D6, 0x7996, 0x7956, 
    0x7906, 0x7899, 0x7803, 0x7736, 0x74F2, 0x719A, 0x6F8D, 0x712D, 0x8C84, 
    0x941A, 0x9B7D, 0xA26E, 0xA8AB, 0xADF5, 0xB20B, 0xB4AE, 0xB59D, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x392D, 
    0x38B3, 0x2670, 0x2C21, 0x3623, 0x3D4F, 0x3B06, 0x374D, 0x3B72, 0x3F45, 
    0x36D3, 0x3684, 0x36B6, 0x3757, 0x3858, 0x39A8, 0x3B37, 0x3DA1, 0x4102, 
    0x448A, 0x4766, 0x467A, 0x4223, 0x3D01, 0x3780, 0x320C, 0x2D11, 0x28FD, 
    0x263A, 0x2537, 0xFFFF, 0xFFFF, 0x0000, 0xFFD2, 0xFF9C, 0xFF68, 0xFF38, 
    0xFF0E, 0xFEEE, 0xFED3, 0xFEBE, 0xFEB8, 0xFE7B, 0xFE41, 0xFE46, 0xFEC7, 
    0x0000, 0x02F8, 0x078A, 0x0C2A, 0x0F4F, 0x096F, 0x06CD, 0x0489, 0x02AD, 
    0x0143, 0x0067, 0x000A, 0xFFF9, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 
    0xFFFC, 0xFFF2, 0xFFC9, 0xFFAA, 0xFFD2, 0xFFF1, 0xFF7A, 0xFF7F, 0xFF8A, 
    0xFF9C, 0xFFB5, 0xFFD6, 0x0000, 0x004C, 0x00B9, 0x0119, 0x013F, 0xFFE4, 
    0xFFC6, 0xFFD5, 0xFFF5, 0x0008, 0x0009, 0x0005, 0x0001, 0xFFFF, 0xCBE1, 
    0xD061, 0xDA8B, 0xDE5B, 0xE0D2, 0xE0CD, 0xD96D, 0xD252, 0xD75B, 0xDC5D, 
    0xCED7, 0xCF95, 0xD1D2, 0xD4CC, 0xD7BF, 0xD9EB, 0xDA8B, 0xD8D8, 0xD51B, 
    0xD02A, 0xCAE1, 0xC0A5, 0xBEA9, 0xBDC6, 0xBD85, 0xBD6C, 0xBD9C, 0xBE3F, 
    0xBEEE, 0xBF3F, 0x0038, 0x0038, 0xFFFF, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFF8, 
    0xFFF8, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFE, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF3A, 0xBF3A, 
    0xBF5E, 0xBF6A, 0xBF86, 0xBFAF, 0xBFDE, 0xC010, 0xC040, 0xC06A, 0xC089, 
    0xC098, 0xC093, 0xC076, 0xC03C, 0xBFE0, 0xBF5E, 0xBD62, 0xB9C7, 0xB652, 
    0xB4C6, 0xBF5E, 0xC045, 0xC0B1, 0xC0BF, 0xC08B, 0xC032, 0xBFCF, 0xBF7F, 
    0xBF5E, 0x0FB6, 0x0FB6, 0x0F7F, 0x0FD3, 0x1045, 0x10CE, 0x1165, 0x1203, 
    0x12A0, 0x1333, 0x13B5, 0x141D, 0x1463, 0x1480, 0x146B, 0x141C, 0x138C, 
    0x0FCF, 0x08FC, 0x038A, 0x067A, 0x0A09, 0x0C83, 0x0F43, 0x1217, 0x14D1, 
    0x1743, 0x193C, 0x1A8E, 0x1B09, 0x15FE, 0x15FE, 0x1AEC, 0x1A70, 0x19CC, 
    0x1906, 0x1826, 0x1734, 0x1636, 0x1533, 0x1434, 0x1340, 0x125C, 0x1192, 
    0x10E9, 0x1066, 0x1013, 0x115F, 0x1460, 0x1718, 0x17B2, 0x18CB, 0x17EC, 
    0x16D0, 0x1593, 0x1451, 0x1325, 0x122D, 0x1183, 0x1144, 0x8F56, 0x8F56, 
    0x86F9, 0x86AF, 0x869C, 0x86B8, 0x86F8, 0x8754, 0x87C1, 0x8836, 0x88A9, 
    0x8912, 0x8966, 0x899C, 0x89AA, 0x8987, 0x892A, 0x861D, 0x810C, 0x7E9B, 
    0x8AE6, 0x8EEF, 0x9308, 0x97AF, 0x9C8E, 0xA14E, 0xA596, 0xA912, 0xAB68, 
    0xAC43, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x286A, 0x286A, 
    0x1CA8, 0x1F50, 0x248E, 0x27F5, 0x2511, 0x21B5, 0x24AA, 0x283F, 0x25AF, 
    0x2758, 0x28D2, 0x2A8B, 0x2CF2, 0x3075, 0x3583, 0x3EA0, 0x4B80, 0x5859, 
    0x615F, 0x52C2, 0x4ACC, 0x422D, 0x396C, 0x3112, 0x29A6, 0x23B1, 0x1FBA, 
    0x1E4A, 0xFFAB, 0xFFAB, 0xFFB5, 0xFFC8, 0xFFDC, 0xFFFA, 0x0038, 0x0073, 
    0x0077, 0x0079, 0x00C7, 0x00D3, 0x0104, 0x012F, 0x012A, 0x00C9, 0xFFE0, 
    0xFD7D, 0xF9CB, 0xF649, 0xF477, 0xFD78, 0xFEFF, 0xFF7E, 0xFF82, 0xFF9A, 
    0xFFD7, 0xFFF5, 0xFFFF, 0x0000, 0xFF3C, 0xFF3C, 0xFF3D, 0xFF3C, 0xFF3B, 
    0xFF3D, 0xFF4A, 0xFF52, 0xFF43, 0xFF34, 0xFF53, 0xFF52, 0xFF51, 0xFF4E, 
    0xFF49, 0xFF3F, 0xFF31, 0xFF4B, 0xFF7B, 0xFF65, 0xFEAD, 0xF96E, 0xF92E, 
    0xF99C, 0xFA65, 0xFB35, 0xFC3B, 0xFD8E, 0xFEB2, 0xFF2F, 0xDABA, 0xDABA, 
    0xD883, 0xD857, 0xD87C, 0xD78B, 0xD2AB, 0xCEBE, 0xD2DD, 0xD756, 0xD0B9, 
    0xD06C, 0xD126, 0xD22F, 0xD2CF, 0xD24E, 0xCFF4, 0xC9D5, 0xC048, 0xB5F9, 
    0xAD91, 0xAF25, 0xB0A7, 0xB200, 0xB3BE, 0xB66C, 0xBB55, 0xC1CD, 0xC76F, 
    0xC9D7, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFD6, 
    0xFF8A, 0xFF60, 0xFF60, 0xFF60, 0xFF60, 0xFF60, 0xFF5D, 0xFF6A, 0xFFA3, 
    0xFFE4, 0xFFFE, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0001, 0x0001, 0x0030, 0x0087, 0x00B4, 0x00B4, 0x00B4, 0x00B4, 
    0x00B4, 0x009B, 0x0058, 0x0016, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFF, 0x26D8, 0x3587, 0x4436, 0x40A3, 0x39FA, 0x3667, 0x3960, 
    0x3EE8, 0x41E1, 0x4164, 0x407B, 0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
    0x38FB, 0x2654, 0x0E72, 0xFBB5, 0xF4AE, 0xF518, 0xF625, 0xF7A5, 0xF96C, 
    0xFB4B, 0xFD12, 0xFE93, 0xFF9C, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x001E, 0x0001, 0x0001, 0x001F, 0x0001, 0x0020, 0x0001, 
    0x0021, 0x0001, 0x0022, 0x001E, 0x0023, 0x001E, 0x0041, 0x001E, 0x005F, 
    0x001E, 0x007D, 0x001E, 0x009B, 0x001E, 0x00B9, 0x001E, 0x00D7, 0x001E, 
    0x00F5, 0x001E, 0x0113, 0x0001, 0x0131, 0x0001, 0x0132, 0x0001, 0x0133, 
    0x001E, 0x0134, 0x001E, 0x0152, 0x001E, 0x0170, 0x001E, 0x018E, 0x001B, 
    0x01AC, 0x001E, 0x01C7, 0x001B, 0x01E5, 0x0001, 0x0200, 0x0001, 0x0201, 
    0x0001, 0x0202, 0x0001, 0x0203, 0x0001, 0x0204, 0x001E, 0x0205, 0x001E, 
    0x0223, 0x001E, 0x0241, 0x001E, 0x025F, 0x001C, 0x027D, 0x001E, 0x0299, 
    0x001E, 0x02B7, 0x001E, 0x02D5, 0x001E, 0x02F3, 0x001B, 0x0311, 0x001E, 
    0x032C, 0x001E, 0x034A, 0x001E, 0x0368, 0x001E, 0x0386, 0x001E, 0x03A4, 
    0x001E, 0x03C2, 0x0018, 0x03E0, 0x001E, 0x03F8, 0x001E, 0x0416, 0x001E, 
    0x0434, 0x001E, 0x0452, 0x001D, 0x0470, 0x001E, 0x048D, 0x001E, 0x04AB, 
    0x001E, 0x04C9, 0x001E, 0x04E7, 0x001E, 0x0505, 0x0018, 0x0523, 0x001B, 
    0x053B, 0x001E, 0x0556, 0x001E, 0x0574, 0x001E, 0x0592, 0x001E, 0x05B0, 
    0x001E, 0x05CE, 0x001C, 0x05EC, 0x001E, 0x0608, 0x0016, 0x0626, 0x001A, 
    0x063C, 0x001E, 0x0656, 
})
    
smlua_anim_util_register_animation("MILNE_ANIM_FORWARD_KB",
    1,
    0,
    0,
    0,
    29,
    {
    0x0000, 0x00CA, 0x0089, 0x0017, 0xFFD2, 0xFFB9, 0xFFB5, 0xFFCA, 0xFFDF, 
    0xFFD8, 0xFFCB, 0xFFC0, 0xFFBE, 0xFFBD, 0xFFBB, 0xFFCC, 0xFFE1, 0xFFE3, 
    0xFFEC, 0xFFFE, 0x0017, 0x0034, 0x0051, 0x006D, 0x0083, 0x0094, 0x009F, 
    0x00A5, 0x00A9, 0x00AA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0001, 0x0005, 0x0009, 0x000F, 0x0013, 0x0017, 0x0018, 
    0x0016, 0x0012, 0x000C, 0x0006, 0x0002, 0x0000, 0x0000, 0x3FFF, 0x0000, 
    0x0003, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0B68, 0xFFFF, 0xFEB0, 0xFED6, 0xFF90, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x36DA, 0x492F, 0x5699, 0x6373, 0x6F17, 0x78DB, 
    0x7B44, 0x7961, 0x7A07, 0x7B73, 0x7CD7, 0x7D67, 0x7C57, 0x78DB, 0x6596, 
    0x50ED, 0x524B, 0x5B01, 0x63DB, 0x6CA1, 0x7425, 0x7617, 0x7073, 0x68D3, 
    0x600F, 0x56FE, 0x4E79, 0x4758, 0x4273, 0x40A1, 0xFFFF, 0xFFD2, 0xFFA4, 
    0xFFB8, 0xFFDF, 0x0000, 0x0006, 0x0003, 0x0003, 0x0002, 0x0002, 0x0001, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFE9, 0xFFB1, 0xFF6D, 0xFF2F, 0xFF0B, 
    0xFF15, 0xFF60, 0x0000, 0x0447, 0x0826, 0x06E0, 0x0413, 0x0145, 0x0000, 
    0xF638, 0xF719, 0xF8F8, 0xFB1F, 0xFD80, 0xFFFF, 0x0346, 0x054B, 0x04FE, 
    0x0436, 0x0322, 0x01F3, 0x00D7, 0xFFFF, 0xFFD6, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x012E, 0x015E, 0x0102, 0xFF16, 0xFCBF, 0xFBD5, 0xFF8A, 
    0x030A, 0x027A, 0x0113, 0xFF46, 0xFD82, 0xFC37, 0xFBD5, 0xFFBB, 0x04CC, 
    0x074C, 0x09B1, 0x0BF7, 0x0E19, 0x1015, 0x11E5, 0x1386, 0x14F4, 0x1457, 
    0x120A, 0x0F67, 0x0C41, 0x099E, 0x0884, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0023, 0x0069, 0x009D, 0x008C, 0x0000, 0xFE90, 
    0xFC5F, 0xFA0B, 0xF832, 0xF771, 0xF8C7, 0xFBB8, 0xFEA9, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xF7E5, 0x01E7, 0x0B1B, 0x03E9, 0xF7C5, 0xF008, 0xEDE8, 0xEC5E, 0xEB6D, 
    0xEB18, 0xEB61, 0xEC4A, 0xEDD7, 0xF008, 0x0755, 0xF3C1, 0xEB29, 0xE298, 
    0xDB62, 0xD6DC, 0xD65A, 0xDC00, 0xE6EC, 0xF3E6, 0xFFB8, 0x072B, 0x07D7, 
    0x03DE, 0xFEDA, 0xFC61, 0x0001, 0xFFFE, 0xC170, 0xDA73, 0xD080, 0xB7B0, 
    0x178D, 0xF79C, 0xDF70, 0xD8F9, 0xDDFF, 0xE3D8, 0xEAC7, 0xF27C, 0xFAA6, 
    0x02FB, 0x0B21, 0x16EE, 0x0029, 0x0811, 0x12C0, 0x1F0A, 0x2BC3, 0xB7BE, 
    0xC1D3, 0xCAF9, 0xD49A, 0xDE30, 0xE734, 0xEF20, 0xF56F, 0xF99A, 0xFB1C, 
    0xE188, 0xDCC1, 0xD0B5, 0xBF2C, 0xCF76, 0xDCBB, 0xE550, 0xE8BF, 0xE837, 
    0xE667, 0xE3F7, 0xE18F, 0xDFD8, 0xDF7B, 0xEC85, 0xF8E3, 0xF889, 0xF7AB, 
    0xF61A, 0xF3AB, 0x8FD0, 0x9485, 0x9B52, 0xA451, 0xAE8D, 0xB912, 0xC2EB, 
    0xCB22, 0xD0C4, 0xD2DB, 0xFBD4, 0x002E, 0x0AE5, 0x9877, 0xA566, 0xAE2E, 
    0xAAAC, 0xA298, 0x9ED4, 0x9AEA, 0x972A, 0x93E4, 0x9165, 0x8FFD, 0x9D29, 
    0xA87E, 0xA334, 0x9C71, 0x94CE, 0x8CE7, 0x0557, 0xFEB7, 0xF85A, 0xF173, 
    0xEA71, 0xE3C0, 0xDDCE, 0xD908, 0xD5DA, 0xD4B3, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xCF32, 0xD113, 0xD589, 0xDACC, 0xDF15, 0xE09D, 0xDF54, 
    0xDCA6, 0xD90C, 0xD4FC, 0xD0EC, 0xCD53, 0xCAA9, 0xC964, 0xDCC0, 0xF151, 
    0xF1D5, 0xF0E7, 0xEEE8, 0xEC38, 0xE939, 0xE64B, 0xE2F8, 0xDECD, 0xDA30, 
    0xD587, 0xD136, 0xCDA4, 0xCB35, 0xCA4E, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFCF, 0xFF58, 0xFEC5, 0xFE40, 0xFDF3, 0xFE08, 0xFEA9, 
    0x0000, 0x102A, 0x2483, 0x20C1, 0x1A91, 0x1321, 0x0B9F, 0x0537, 0x0116, 
    0xFF0E, 0xFE00, 0xFDB4, 0xFDF3, 0xFE85, 0xFF32, 0xFFC3, 0x0000, 0xF97B, 
    0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97C, 0xF97E, 0xF981, 0xF984, 
    0xF986, 0xF985, 0xF982, 0xF97B, 0xF923, 0xFFE3, 0xFA93, 0xF379, 0xEBC6, 
    0xE4AB, 0xDF59, 0xDD01, 0xDDE1, 0xE0F1, 0xE57B, 0xEACA, 0xF026, 0xF4DC, 
    0xF835, 0xF97B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED98, 
    0xEDB7, 0xEDDE, 0xEE01, 0xEE16, 0xEE10, 0xEDE5, 0xED8B, 0xE941, 0xF228, 
    0xF160, 0xEF9F, 0xED5E, 0xEB14, 0xE93B, 0xE84A, 0xE844, 0xE8BE, 0xE991, 
    0xEA97, 0xEBA6, 0xEC99, 0xED48, 0xED8B, 0x0001, 0xFFFE, 0xC170, 0x24EE, 
    0x2526, 0x25A7, 0x2633, 0x2690, 0x267F, 0x2512, 0x2271, 0x20BA, 0x2037, 
    0x1F8F, 0x1D69, 0x186F, 0x0F46, 0xCECF, 0xFEF3, 0x00D5, 0xFE8E, 0xF9DA, 
    0xF478, 0xF025, 0xEE9E, 0xEFF0, 0xF2AB, 0xF652, 0xFA68, 0xFE70, 0x01EC, 
    0x045F, 0x054B, 0x1C98, 0x1D57, 0x1F18, 0x2118, 0x2299, 0x22DB, 0x1D6A, 
    0x1848, 0x1916, 0x1B16, 0x1DAD, 0x203D, 0x222B, 0x22DB, 0x1747, 0x095F, 
    0x08C8, 0x090A, 0x0A02, 0x0B90, 0x0D92, 0x0FE7, 0x12FA, 0x1705, 0x1B9C, 
    0x2051, 0x24B8, 0x2864, 0x2AE8, 0x2BD6, 0xF3E0, 0xEEB4, 0xE1AD, 0xD083, 
    0xBEEF, 0xB0AB, 0xA7A2, 0xA449, 0xA5AC, 0xA901, 0xAD05, 0xB079, 0xB21B, 
    0xB0AB, 0x8C0C, 0xA26A, 0xA123, 0x9D0D, 0x97C4, 0x92DF, 0x8FF8, 0x90A9, 
    0x9591, 0x9D7C, 0xA748, 0xB1D5, 0xBC01, 0xC4AB, 0xCAB2, 0xCCF5, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xC774, 0xC92D, 0xCD3E, 0xD1FF, 0xD5CB, 0xD6FA, 0xD565, 
    0xD255, 0xCE53, 0xC9E5, 0xC592, 0xC1E3, 0xBF5D, 0xBE88, 0xD8BF, 0xF4B8, 
    0xF31A, 0xF097, 0xED59, 0xE98B, 0xE554, 0xE0DF, 0xDC55, 0xD7DF, 0xD3A7, 
    0xCFD7, 0xCC98, 0xCA12, 0xC871, 0xC7DC, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0001, 0x0002, 0x0002, 0x0003, 0x0003, 
    0x0003, 0xFFFF, 0xD897, 0xD564, 0xD4CA, 0xD61E, 0xD8B3, 0xDBDD, 0xDEEF, 
    0xE27F, 0xE740, 0xECAD, 0xF244, 0xF781, 0xFBE2, 0xFEE2, 0xFFFF, 0xFFFF, 
    0xFFCD, 0xFF69, 0xFF1E, 0xFF37, 0xFFFF, 0x0177, 0x0354, 0x057A, 0x07C9, 
    0x0A24, 0x0C6D, 0x0E84, 0x104C, 0x0EAA, 0xFA8F, 0xFBB2, 0xFEEF, 0x0346, 
    0x07B9, 0x0B47, 0x0CF1, 0x0CAE, 0x0B5A, 0x094C, 0x06DB, 0x045D, 0x022A, 
    0x0099, 0xFFFF, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF536, 
    0xF509, 0xF4D2, 0xF49F, 0xF482, 0xF48A, 0xF4C7, 0xF549, 0xFB65, 0xECA0, 
    0xE8C3, 0xE552, 0xE27A, 0xE068, 0xDF49, 0xDF48, 0xE0B2, 0xE369, 0xE6F7, 
    0xEAE6, 0xEEC1, 0xF213, 0xF467, 0xF548, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xBF5E, 0xEAE3, 0xEC16, 0xEF1D, 0xF31B, 0xF733, 0xFA88, 0xFCB4, 
    0xFD8A, 0xFD29, 0xFC41, 0xFB2E, 0xFA4C, 0xF9F6, 0xFA88, 0x00B4, 0x06D2, 
    0x058A, 0x01F4, 0xFF89, 0xFFBA, 0x00F0, 0x0217, 0x021E, 0xFB13, 0xF40C, 
    0xEC07, 0xE408, 0xDD12, 0xD827, 0xD649, 0xEF5C, 0xEFEA, 0xF14B, 0xF315, 
    0xF4DC, 0xF637, 0xF68D, 0xF662, 0xF68F, 0xF6F2, 0xF752, 0xF778, 0xF72C, 
    0xF637, 0xF122, 0xEB4F, 0xE932, 0xE858, 0xE86E, 0xE96D, 0xEB22, 0xED00, 
    0xEE78, 0xEDDE, 0xED88, 0xED2B, 0xECD3, 0xEC87, 0xEC53, 0xEC40, 0xCFCC, 
    0xCD2E, 0xC682, 0xBD8A, 0xB408, 0xABBF, 0xA32F, 0x9E2A, 0x9F14, 0xA163, 
    0xA473, 0xA79F, 0xAA45, 0xABBF, 0xA81E, 0xA3AE, 0xA4EE, 0xA794, 0xA724, 
    0xA1B3, 0x99CC, 0x919A, 0x8B49, 0x8FE1, 0x96D4, 0x9EFB, 0xA73C, 0xAE7D, 
    0xB3A6, 0xB59D, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x38C5, 0x38B2, 0x388C, 0x386F, 
    0x3879, 0x38C6, 0x3A89, 0x3C11, 0x3B4B, 0x3986, 0x3793, 0x3641, 0x3662, 
    0x38C6, 0x4B23, 0x5AFF, 0x520C, 0x40FE, 0x32DF, 0x2AEC, 0x24C1, 0x1FF9, 
    0x1C2D, 0x21B3, 0x232F, 0x23E5, 0x2465, 0x24DD, 0x2521, 0x2537, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x005F, 0x0000, 0xFE05, 0xFB6E, 0xF8C7, 
    0xF618, 0xF345, 0xF09E, 0xEE77, 0xEFC7, 0xF32B, 0xF697, 0xF8DD, 0xFAE6, 
    0xFE06, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x007F, 0x0000, 
    0xFC80, 0xF82E, 0xF64E, 0xF812, 0xFBA2, 0xFFB9, 0x030F, 0x02FD, 0x03A6, 
    0x03FE, 0x0305, 0x01B8, 0x009D, 0xFFFF, 0xCB78, 0xCB67, 0xCB37, 0xCAEF, 
    0xCA96, 0xCA33, 0xC955, 0xC8AB, 0xC857, 0xC7A6, 0xC70B, 0xC6F8, 0xC7DF, 
    0xCA33, 0xD66E, 0xE2A5, 0xE316, 0xDF64, 0xD981, 0xD1C9, 0xC852, 0xBEA6, 
    0xB64D, 0xB5A0, 0xB85A, 0xBB62, 0xBD72, 0xBED5, 0xBF47, 0xBF3F, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x04C5, 0x0513, 0x05C5, 0x068D, 
    0x0718, 0x0716, 0x047B, 0x0211, 0x027B, 0x0381, 0x04CE, 0x060E, 0x06ED, 
    0x0716, 0x03E4, 0xFF97, 0xFD1F, 0xFAEB, 0xF940, 0xF867, 0xF97D, 0xFBDD, 
    0xFD26, 0xF830, 0x00B4, 0x09F4, 0x0FD9, 0x155D, 0x1971, 0x1B09, 0x1482, 
    0x1475, 0x1457, 0x1437, 0x1424, 0x142C, 0x14BB, 0x153D, 0x1523, 0x14E5, 
    0x1497, 0x1450, 0x1425, 0x142C, 0x15E0, 0x167E, 0x134A, 0x0ECB, 0x0A9F, 
    0x0868, 0x0A52, 0x0EBF, 0x119F, 0x0B68, 0x0E4C, 0x11AA, 0x1225, 0x11F3, 
    0x1182, 0x1144, 0xADF8, 0xAE33, 0xAEA7, 0xAEF9, 0xAECE, 0xADCA, 0xA80B, 
    0xA314, 0xA3F1, 0xA615, 0xA8D2, 0xAB78, 0xAD5A, 0xADCA, 0xA870, 0x9EE2, 
    0x94A1, 0x8959, 0x7F84, 0x79A1, 0x7B35, 0x8253, 0x894B, 0x8DAC, 0x9219, 
    0x96CB, 0x9CFB, 0xA40C, 0xA9DA, 0xAC43, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x4A4A, 0x4E1A, 0x4F1F, 0x4606, 0x397E, 0x2EE6, 
    0x29DC, 0x28BD, 0x2839, 0x2739, 0x2690, 0x2713, 0x2994, 0x2EE6, 0x48CE, 
    0x61D3, 0x6363, 0x5F11, 0x5708, 0x4D74, 0x3F08, 0x2C94, 0x1E6D, 0x2887, 
    0x28F4, 0x27C0, 0x2813, 0x2481, 0x204F, 0x1E4A, 0xFFC1, 0xFFC2, 0xFFC3, 
    0xFFC4, 0xFFC6, 0xFFC8, 0xFFCA, 0xFFCC, 0xFFCD, 0xFFCF, 0xFFD0, 0xFFD0, 
    0xFFCE, 0xFFC8, 0xFFA3, 0xFF87, 0xFEF8, 0xFE0C, 0xFDFA, 0xFFFC, 0x097C, 
    0x1441, 0x11F7, 0x0C3C, 0x0C24, 0x0C08, 0x0857, 0x042F, 0x015A, 0x0000, 
    0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF37, 0xFF36, 0xFF36, 0xFF35, 
    0xFF34, 0xFF33, 0xFF33, 0xFF34, 0xFF37, 0xFEA3, 0xFF57, 0x0315, 0x07FF, 
    0x0C4F, 0x0E43, 0x0892, 0x0070, 0x0026, 0x001B, 0xFDED, 0xFC37, 0xFD28, 
    0xFEA4, 0xFF18, 0xFF2F, 0xD611, 0xD5FC, 0xD5C5, 0xD578, 0xD521, 0xD4CB, 
    0xD43F, 0xD3DC, 0xD3AB, 0xD346, 0xD2EE, 0xD2E5, 0xD36E, 0xD4CB, 0xDCCB, 
    0xE30E, 0xDF6C, 0xD901, 0xD1B3, 0xCB6A, 0xC820, 0xC437, 0xB847, 0xAF72, 
    0xB5B6, 0xBDC9, 0xC223, 0xC53F, 0xC848, 0xC9D7, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0390, 0x0C40, 0x16C2, 0x1F72, 0x2302, 
    0x2087, 0x1E0D, 0x1FC1, 0x22EB, 0x249F, 0x245C, 0x2361, 0x2163, 0x1E10, 
    0x1906, 0x11C0, 0x0795, 0xFA38, 0xEB1B, 0xDCED, 0xD2AA, 0xCEC0, 0xD157, 
    0xD838, 0xE1F9, 0xECC5, 0xF686, 0xFD68, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x001D, 0x0001, 0x001E, 0x001E, 0x0001, 0x003C, 0x0001, 
    0x003D, 0x0001, 0x003E, 0x001C, 0x003F, 0x001D, 0x005B, 0x001E, 0x0078, 
    0x001E, 0x0096, 0x001D, 0x00B4, 0x001E, 0x00D1, 0x001E, 0x00EF, 0x001C, 
    0x010D, 0x001E, 0x0129, 0x0001, 0x0147, 0x0001, 0x0148, 0x0001, 0x0149, 
    0x001E, 0x014A, 0x001E, 0x0168, 0x001E, 0x0186, 0x001E, 0x01A4, 0x001D, 
    0x01C2, 0x001E, 0x01DF, 0x001E, 0x01FD, 0x001E, 0x021B, 0x001E, 0x0239, 
    0x0001, 0x0257, 0x0001, 0x0258, 0x0001, 0x0259, 0x001E, 0x025A, 0x001E, 
    0x0278, 0x001E, 0x0296, 0x001B, 0x02B4, 0x001E, 0x02CF, 0x001E, 0x02ED, 
    0x001E, 0x030B, 0x001E, 0x0329, 0x001E, 0x0347, 0x001E, 0x0365, 0x001D, 
    0x0383, 0x0001, 0x03A0, 0x001E, 0x03A1, 0x001E, 0x03BF, 0x001E, 0x03DD, 
    0x001C, 0x03FB, 0x001D, 0x0417, 0x001E, 0x0434, 0x001E, 0x0452, 0x001E, 
    0x0470, 0x001E, 0x048E, 0x001E, 0x04AC, 0x001D, 0x04CA, 0x0001, 0x04E7, 
    0x001E, 0x04E8, 0x001E, 0x0506, 0x001E, 0x0524, 0x0017, 0x0542, 0x001D, 
    0x0559, 0x001E, 0x0576, 0x001E, 0x0594, 0x001E, 0x05B2, 0x001E, 0x05D0, 
    0x001D, 0x05EE, 0x001D, 0x060B, 0x001C, 0x0628, 0x0019, 0x0644, 0x001E, 
    0x065D, 0x001E, 0x067B, 
})

smlua_anim_util_register_animation("MILNE_ANIM_START_SLEEP_SITTING",
    1,
    0,
    0,
    0,
    63,
    {
    0x0000, 0x00AB, 0x00AA, 0x00A7, 0x00A3, 0x009F, 0x0099, 0x0092, 0x0084, 
    0x0077, 0x0073, 0x0071, 0x0068, 0x0052, 0x0031, 0x000A, 0xFFE3, 0xFFC1, 
    0xFFA9, 0xFF9F, 0xFFA0, 0xFFA0, 0xFFA1, 0xFFA2, 0xFFA3, 0xFFA4, 0xFFFF, 
    0xFFFE, 0xFFFB, 0xFFF6, 0xFFF0, 0xFFEA, 0xFFE2, 0xFFDA, 0xFFD1, 0xFFC6, 
    0xFFBA, 0xFFAC, 0xFF9D, 0xFF8D, 0xFF7D, 0xFF6F, 0xFF64, 0xFF5D, 0xFF5A, 
    0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x40A1, 0x40C8, 0x4129, 
    0x41A8, 0x4227, 0x4288, 0x42AF, 0x427E, 0x41D9, 0x40A1, 0x3E0E, 0x39EC, 
    0x3504, 0x301D, 0x2BFB, 0x2968, 0x2830, 0x278B, 0x275A, 0x2781, 0x27E2, 
    0x2861, 0x28E0, 0x2941, 0x2968, 0xFD9E, 0xFDCD, 0xFE04, 0xFE41, 0xFE82, 
    0xFEC3, 0xFF02, 0xFF3D, 0xFF70, 0xFF9A, 0xFFB6, 0xFFC4, 0xFFC9, 0xFFC7, 
    0xFFC1, 0xFFBD, 0xFFB8, 0xFFAF, 0xFFA3, 0xFF97, 0xFF8A, 0xFF7E, 0xFF74, 
    0xFF6E, 0xFF6B, 0x04A4, 0x0441, 0x03D0, 0x0356, 0x02D7, 0x0259, 0x01DF, 
    0x0170, 0x0110, 0x00C4, 0x0098, 0x008F, 0x009C, 0x00B3, 0x00C9, 0x00D2, 
    0x00CF, 0x00C9, 0x00C3, 0x00BC, 0x00B4, 0x00AE, 0x00A8, 0x00A4, 0x00A3, 
    0x0FC6, 0x113B, 0x128D, 0x13C1, 0x14E0, 0x15F1, 0x16FA, 0x1803, 0x1913, 
    0x1A30, 0x1B99, 0x1D52, 0x1F0B, 0x2075, 0x2140, 0x211E, 0x1FF6, 0x1E0E, 
    0x1BA3, 0x18F1, 0x1635, 0x13AB, 0x1190, 0x1020, 0x0F98, 0x0015, 0x0017, 
    0x0017, 0x0017, 0x0017, 0x0017, 0x0016, 0x0016, 0x0016, 0x0015, 0x0017, 
    0x001C, 0x0021, 0x0023, 0x0020, 0x0015, 0x0003, 0xFFEB, 0xFFCF, 0xFFB0, 
    0xFF92, 0xFF74, 0xFF59, 0xFF43, 0xFF34, 0xFF2B, 0xFF29, 0xFF2A, 0xFF2F, 
    0xFF35, 0xFF3B, 0xFF40, 0xFF41, 0xFF3D, 0xFF34, 0xFF25, 0xFF15, 0xFF04, 
    0xFEF1, 0xFEDC, 0xFEC7, 0xFEB1, 0xFE9B, 0xFE84, 0xFE6C, 0xFE55, 0xFE3E, 
    0xFE27, 0xFE11, 0xFDFB, 0xFDE7, 0xFDD3, 0xFDC1, 0xFDB0, 0xFDA1, 0xFD94, 
    0xFD88, 0xFD7F, 0xFD79, 0xFD74, 0xFD71, 0xFD70, 0xFD70, 0xFD72, 0xFD4B, 
    0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 0xFD4B, 
    0xFD4B, 0xFD4A, 0xFD4A, 0xFD49, 0xFD4A, 0xFD4B, 0xFD4E, 0xFD51, 0xFD55, 
    0xFD59, 0xFD5D, 0xFD61, 0xFD64, 0xFD67, 0xFD69, 0xFD6A, 0xFD68, 0xFD64, 
    0xFD60, 0xFD5C, 0xFD59, 0xFD59, 0xFD5A, 0xFD60, 0xFD69, 0xFD77, 0xFD85, 
    0xFD96, 0xFDA7, 0xFDBA, 0xFDCE, 0xFDE2, 0xFDF7, 0xFE0D, 0xFE22, 0xFE38, 
    0xFE4D, 0xFE62, 0xFE77, 0xFE8B, 0xFE9E, 0xFEAF, 0xFEC0, 0xFECE, 0xFEDC, 
    0xFEE7, 0xFEF0, 0xFEF7, 0xFEFB, 0xFEFD, 0xFEFE, 0xFEFC, 0xFEF8, 0xFEF3, 
    0xF587, 0xF576, 0xF56D, 0xF56B, 0xF56D, 0xF572, 0xF579, 0xF57F, 0xF585, 
    0xF587, 0xF567, 0xF521, 0xF4DB, 0xF4BB, 0xF4E8, 0xF587, 0xF6A0, 0xF810, 
    0xF9BD, 0xFB8C, 0xFD63, 0xFF28, 0x00C0, 0x0210, 0x0300, 0x0379, 0x038E, 
    0x0359, 0x02F7, 0x0283, 0x0219, 0x01D5, 0x01D2, 0x022C, 0x0300, 0x042D, 
    0x0581, 0x06F6, 0x088A, 0x0A37, 0x0BF9, 0x0DCD, 0x0FAD, 0x1197, 0x1385, 
    0x1574, 0x175F, 0x1942, 0x1B19, 0x1CE0, 0x1E93, 0x202D, 0x21AB, 0x2307, 
    0x243E, 0x254C, 0x262D, 0x26DC, 0x2757, 0x27A3, 0x27C2, 0x27BA, 0x278D, 
    0x2740, 0x10BE, 0x0679, 0xCB8B, 0x096F, 0x0A49, 0x0B9F, 0x0D40, 0x0EFB, 
    0x109E, 0x11F8, 0x12D8, 0x130B, 0x1262, 0x0FF5, 0x0B93, 0x061C, 0x0071, 
    0xFB71, 0xF7FF, 0xF5CA, 0xF3EB, 0xF25D, 0xF11A, 0xF01D, 0xEF61, 0xEEE2, 
    0xEE99, 0xEE82, 0xDC4F, 0xDCF6, 0xDC3D, 0xDA7E, 0xD811, 0xD551, 0xD296, 
    0xD039, 0xCE94, 0xCE01, 0xCF07, 0xD185, 0xD4D9, 0xD85E, 0xDB6F, 0xDD69, 
    0xDE78, 0xDF3F, 0xDFC9, 0xE020, 0xE04F, 0xE061, 0xE060, 0xE058, 0xE053, 
    0xB849, 0xB7DA, 0xB6B8, 0xB51D, 0xB343, 0xB162, 0xAFB6, 0xAE76, 0xADDE, 
    0xAE26, 0xB004, 0xB38E, 0xB80E, 0xBCD1, 0xC11F, 0xC445, 0xC68E, 0xC8BA, 
    0xCABF, 0xCC91, 0xCE26, 0xCF74, 0xD06F, 0xD10D, 0xD145, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xE4CA, 0xE3E0, 0xE351, 0xE30F, 0xE30C, 0xE33A, 
    0xE38B, 0xE3F3, 0xE461, 0xE4CA, 0xE551, 0xE619, 0xE713, 0xE82C, 0xE955, 
    0xEA7E, 0xEBC8, 0xED4E, 0xEEF7, 0xF0A7, 0xF244, 0xF3B3, 0xF4DA, 0xF59F, 
    0xF5E6, 0xFE4F, 0xFE3F, 0xFE16, 0xFDE0, 0xFDAB, 0xFD82, 0xFD72, 0xFD86, 
    0xFDCC, 0xFE4F, 0xFF65, 0x0122, 0x0333, 0x0543, 0x0700, 0x0816, 0x0899, 
    0x08DF, 0x08F3, 0x08E3, 0x08BA, 0x0885, 0x084F, 0x0826, 0x0816, 0xF9B3, 
    0xF9DA, 0xFA3B, 0xFABA, 0xFB38, 0xFB99, 0xFBC0, 0xFB90, 0xFAEA, 0xF9B3, 
    0xF721, 0xF301, 0xEE1B, 0xE936, 0xE516, 0xE284, 0xE14C, 0xE0A7, 0xE077, 
    0xE09D, 0xE0FF, 0xE17D, 0xE1FB, 0xE25D, 0xE284, 0xF844, 0xF85C, 0xF897, 
    0xF8E3, 0xF930, 0xF96B, 0xF983, 0xF965, 0xF901, 0xF844, 0xF6B4, 0xF433, 
    0xF139, 0xEE3F, 0xEBBE, 0xEA2E, 0xE971, 0xE90C, 0xE8EF, 0xE906, 0xE942, 
    0xE98E, 0xE9DB, 0xEA16, 0xEA2E, 0x1524, 0x22DF, 0xC75D, 0x12E8, 0x1350, 
    0x13AD, 0x1401, 0x144E, 0x1494, 0x14D6, 0x1515, 0x1552, 0x1590, 0x15D4, 
    0x161C, 0x165E, 0x168F, 0x16A3, 0x1690, 0x1651, 0x15EE, 0x1574, 0x14EC, 
    0x1464, 0x13E6, 0x137D, 0x1336, 0x131C, 0x0693, 0x0694, 0x07E5, 0x0A22, 
    0x0CE5, 0x0FC7, 0x1262, 0x1452, 0x1531, 0x1497, 0x1145, 0x0B1F, 0x0373, 
    0xFB94, 0xF4D3, 0xF07F, 0xEE3D, 0xECBB, 0xEBD8, 0xEB71, 0xEB68, 0xEB9A, 
    0xEBE6, 0xEC2C, 0xEC4B, 0xCABA, 0xCBF2, 0xCD02, 0xCDF0, 0xCEC6, 0xCF8C, 
    0xD04B, 0xD10B, 0xD1D6, 0xD2B3, 0xD3A2, 0xD498, 0xD592, 0xD68E, 0xD786, 
    0xD878, 0xD97C, 0xDAA0, 0xDBD6, 0xDD0A, 0xDE2C, 0xDF2C, 0xDFF7, 0xE07E, 
    0xE0AF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF09B, 0xF144, 0xF19E, 0xF1B9, 
    0xF1A4, 0xF16F, 0xF12A, 0xF0E5, 0xF0B0, 0xF09B, 0xF084, 0xF051, 0xF01E, 
    0xF007, 0xF028, 0xF09B, 0xF174, 0xF2A0, 0xF401, 0xF57C, 0xF6F2, 0xF848, 
    0xF960, 0xFA1D, 0xFA62, 0x0BDE, 0x0A32, 0x0973, 0x096A, 0x09DD, 0x0A97, 
    0x0B5E, 0x0BFD, 0x0C3A, 0x0BDE, 0x0AC6, 0x0918, 0x070C, 0x04DA, 0x02B9, 
    0x00E0, 0xFF1E, 0xFD2F, 0xFB2B, 0xF92F, 0xF754, 0xF5B4, 0xF46B, 0xF392, 
    0xF344, 0x04C8, 0x0445, 0x0386, 0x02B4, 0x01F6, 0x0172, 0x0151, 0x01BA, 
    0x02D5, 0x04C8, 0x08E3, 0x0F81, 0x1757, 0x1F1D, 0x2588, 0x294E, 0x2AB3, 
    0x2B00, 0x2A74, 0x294F, 0x27D1, 0x2638, 0x24C6, 0x23B9, 0x2351, 0xFA2C, 
    0xFA5F, 0xFA9E, 0xFADD, 0xFB13, 0xFB34, 0xFB39, 0xFB15, 0xFABE, 0xFA2C, 
    0xF924, 0xF794, 0xF5A9, 0xF391, 0xF179, 0xEF8E, 0xED9C, 0xEB65, 0xE90B, 
    0xE6B0, 0xE476, 0xE280, 0xE0EF, 0xDFE5, 0xDF85, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xBF5E, 0xD649, 0xD74D, 0xD9B6, 0xDD31, 0xE166, 0xE601, 0xEAAC, 0xEF12, 
    0xF2DC, 0xF5B6, 0xF788, 0xF892, 0xF902, 0xF905, 0xF8C9, 0xF87A, 0xF802, 
    0xF73D, 0xF643, 0xF52D, 0xF412, 0xF30C, 0xF233, 0xF19F, 0xF168, 0xEC40, 
    0xEC59, 0xEC96, 0xECED, 0xED55, 0xEDC3, 0xEE2F, 0xEE8E, 0xEED9, 0xEF04, 
    0xEEF3, 0xEEA7, 0xEE40, 0xEDDF, 0xEDA4, 0xEDB0, 0xEE08, 0xEE91, 0xEF3B, 
    0xEFF7, 0xF0B4, 0xF162, 0xF1F2, 0xF254, 0xF278, 0xB59D, 0xB447, 0xB118, 
    0xAC7F, 0xA6EC, 0xA0CD, 0x9A91, 0x94A8, 0x8F80, 0x8B89, 0x88B3, 0x869E, 
    0x853F, 0x848A, 0x8476, 0x84F6, 0x8633, 0x8834, 0x8ABB, 0x8D89, 0x9060, 
    0x9302, 0x9531, 0x96AD, 0x973A, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x2537, 0x266B, 0x2950, 0x2D6B, 0x3244, 0x3760, 0x3C47, 0x407F, 0x438F, 
    0x44FE, 0x440B, 0x40C9, 0x3BFE, 0x3671, 0x30E6, 0x2C24, 0x279F, 0x227D, 
    0x1D0D, 0x179B, 0x1277, 0x0DF0, 0x0A53, 0x07EE, 0x0710, 0x0000, 0x0008, 
    0x000D, 0x000E, 0x000D, 0x000A, 0x0007, 0x0003, 0x0001, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFB, 0xFFF9, 0xFFF8, 
    0xFFF9, 0xFFFA, 0xFFFC, 0xFFFE, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xBF3F, 0xBF37, 0xBF33, 0xBF32, 0xBF33, 0xBF35, 
    0xBF38, 0xBF3C, 0xBF3E, 0xBF3F, 0xBF1B, 0xBECA, 0xBE7A, 0xBE56, 0xBE89, 
    0xBF3F, 0xC097, 0xC272, 0xC4A1, 0xC6F9, 0xC94A, 0xCB66, 0xCD21, 0xCE4D, 
    0xCEBB, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x1B09, 0x1A7E, 0x1933, 0x1753, 
    0x150A, 0x1281, 0x0FE4, 0x0D5E, 0x0B18, 0x093E, 0x07A8, 0x0625, 0x04D2, 
    0x03CE, 0x0334, 0x0324, 0x03AB, 0x04AA, 0x05FD, 0x0781, 0x090F, 0x0A85, 
    0x0BBD, 0x0C93, 0x0CE2, 0x1144, 0x1142, 0x113D, 0x1136, 0x1131, 0x112E, 
    0x1130, 0x1139, 0x114B, 0x1168, 0x11AB, 0x121A, 0x1299, 0x130B, 0x1354, 
    0x1357, 0x1310, 0x1299, 0x1200, 0x1154, 0x10A5, 0x1003, 0x0F7C, 0x0F20, 
    0x0EFE, 0xAC43, 0xAB51, 0xA914, 0xA5D4, 0xA1D8, 0x9D67, 0x98CB, 0x944B, 
    0x902E, 0x8CBD, 0x8989, 0x8630, 0x8313, 0x8091, 0x7F0A, 0x7EDC, 0x8025, 
    0x828B, 0x85B7, 0x8952, 0x8D07, 0x907F, 0x9363, 0x955F, 0x961C, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x1E4A, 0x1FB6, 0x231D, 0x27F8, 0x2DBF, 0x33E9, 0x39EE, 
    0x3F46, 0x4369, 0x45CF, 0x45F1, 0x4401, 0x408D, 0x3C24, 0x3753, 0x32A9, 
    0x2D8E, 0x275D, 0x2088, 0x1983, 0x12C1, 0x0CB6, 0x07D7, 0x0495, 0x0366, 
    0x0000, 0x0002, 0x0007, 0x000E, 0x0016, 0x0020, 0x0029, 0x0032, 0x0039, 
    0x003F, 0x0043, 0x0046, 0x0048, 0x0048, 0x0045, 0x003F, 0x0033, 0x0023, 
    0x000F, 0xFFFB, 0xFFE7, 0xFFD4, 0xFFC5, 0xFFBB, 0xFFB7, 0xFF2F, 0xFF2F, 
    0xFF30, 0xFF31, 0xFF32, 0xFF34, 0xFF35, 0xFF37, 0xFF38, 0xFF39, 0xFF39, 
    0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF3A, 0xFF3A, 
    0xFF3B, 0xFF3B, 0xFF3C, 0xC9D7, 0xC96D, 0xC870, 0xC704, 0xC54D, 0xC36E, 
    0xC18C, 0xBFCA, 0xBE4C, 0xBD35, 0xBC61, 0xBBAB, 0xBB3E, 0xBB40, 0xBBDA, 
    0xBD35, 0xBF8A, 0xC2C3, 0xC68F, 0xCAA0, 0xCEA6, 0xD252, 0xD553, 0xD75B, 
    0xD81A, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFC, 0xFFF7, 0xFFEE, 
    0xFFDF, 0xFFCA, 0xFFAC, 0xFF85, 0xFF51, 0xFF11, 0xFEC1, 0xFE61, 0xFDEE, 
    0xFD67, 0xFCC9, 0xFC12, 0xFB40, 0xFA4F, 0xF93C, 0xF802, 0xF69D, 0xF506, 
    0xF334, 0xF11D, 0xEEB1, 0xEBE0, 0xE890, 0xE4A6, 0xDFFF, 0xDA81, 0xD452, 
    0xCDD3, 0x478D, 0x4210, 0x3DCD, 0x3B12, 0x3A1B, 0x3A53, 0x3AE4, 0x3BB3, 
    0x3CA1, 0x3D90, 0x3E60, 0x3EF4, 0x3F2C, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFB, 0xFFF1, 
    0xFFE0, 0xFFC5, 0xFF9E, 0xFF6A, 0xFF25, 0xFECD, 0xFE61, 0xFDDE, 0xFD42, 
    0xFC8A, 0xFBB4, 0xFABD, 0xF9A4, 0xF865, 0xF6FF, 0xF570, 0xF3B6, 0xF1D1, 
    0xEFC0, 0xED85, 0xEB22, 0xE89D, 0xE5FD, 0xE350, 0xE0A6, 0xDE17, 0xDBBF, 
    0xD9CE, 0xD869, 0xA867, 0xA8C0, 0xA8CB, 0xA8B8, 0xA8AD, 0xA8B1, 0xA8BA, 
    0xA8C5, 0xA8CF, 0xA8D8, 0xA8DD, 0xA8DF, 0xA8E0, 0x0000, 0x007E, 0x01E5, 
    0x041F, 0x0713, 0x0AA9, 0x0EC6, 0x134C, 0x1818, 0x1D08, 0x21F7, 0x26C2, 
    0x2B4C, 0x2F79, 0x3334, 0x366B, 0x390F, 0x3B10, 0x3C5D, 0x3D45, 0x3E22, 
    0x3EF4, 0x3FBB, 0x4076, 0x4127, 0x41CC, 0x4266, 0x42F6, 0x437B, 0x43F8, 
    0x446C, 0x44D9, 0x4541, 0x45A5, 0x4608, 0x466D, 0x46D8, 0x474C, 0x47D0, 
    0x4869, 0x4920, 0x49FE, 0x4B11, 0x4C69, 0x4E19, 0x503C, 0x52F1, 0x565B, 
    0x5A92, 0x5F78, 0x64BF, 0xE9EB, 0xEE7A, 0xF204, 0xF448, 0xF514, 0xF4E5, 
    0xF46B, 0xF3BD, 0xF2F4, 0xF22B, 0xF17B, 0xF0FF, 0xF0D0, 
    },
    {
    0x0001, 0x0000, 0x0019, 0x0001, 0x0013, 0x001A, 0x0001, 0x002D, 0x0001, 
    0x002E, 0x0001, 0x002F, 0x0018, 0x0030, 0x0018, 0x0048, 0x0019, 0x0060, 
    0x0019, 0x0079, 0x0019, 0x0092, 0x0019, 0x00AB, 0x0040, 0x00C4, 0x0040, 
    0x0104, 0x0040, 0x0144, 0x0001, 0x0184, 0x0001, 0x0185, 0x0001, 0x0186, 
    0x0019, 0x0187, 0x0019, 0x01A0, 0x0019, 0x01B9, 0x0019, 0x01D2, 0x0019, 
    0x01EB, 0x0019, 0x0204, 0x0019, 0x021D, 0x0019, 0x0236, 0x0019, 0x024F, 
    0x0001, 0x0268, 0x0001, 0x0269, 0x0001, 0x026A, 0x0019, 0x026B, 0x0019, 
    0x0284, 0x0019, 0x029D, 0x0019, 0x02B6, 0x0018, 0x02CF, 0x0019, 0x02E7, 
    0x0019, 0x0300, 0x0019, 0x0319, 0x0019, 0x0332, 0x0017, 0x034B, 0x0019, 
    0x0362, 0x0001, 0x037B, 0x0019, 0x037C, 0x0019, 0x0395, 0x0019, 0x03AE, 
    0x0019, 0x03C7, 0x0019, 0x03E0, 0x0019, 0x03F9, 0x0019, 0x0412, 0x0019, 
    0x042B, 0x0019, 0x0444, 0x0017, 0x045D, 0x0019, 0x0474, 0x0001, 0x048D, 
    0x0019, 0x048E, 0x0019, 0x04A7, 0x0019, 0x04C0, 0x0019, 0x04D9, 0x0017, 
    0x04F2, 0x0019, 0x0509, 0x0019, 0x0522, 0x0017, 0x053B, 0x0019, 0x0552, 
    0x0017, 0x056B, 0x0015, 0x0582, 0x0016, 0x0597, 0x0040, 0x05AD, 0x0040, 
    0x05ED, 0x0040, 0x062D, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLEEP_IDLE",
    0,
    0,
    0,
    0,
    39,
    {
    0x0000, 0xFFA4, 0xFF5A, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0x2968, 
    0xFF6B, 0x00A3, 0x0F98, 0xFD75, 0xFD79, 0xFD7E, 0xFD84, 0xFD8A, 0xFD91, 
    0xFD98, 0xFD9F, 0xFDA6, 0xFDAD, 0xFDB3, 0xFDB9, 0xFDBE, 0xFDC2, 0xFDC6, 
    0xFDC8, 0xFDC8, 0xFDC8, 0xFDC7, 0xFDC5, 0xFDC2, 0xFDC0, 0xFDBC, 0xFDB8, 
    0xFDB4, 0xFDB0, 0xFDAB, 0xFDA6, 0xFDA1, 0xFD9D, 0xFD98, 0xFD94, 0xFD8F, 
    0xFD8C, 0xFD88, 0xFD85, 0xFD83, 0xFD81, 0xFD80, 0xFD7F, 0xFEED, 0xFEE5, 
    0xFEDD, 0xFED3, 0xFECA, 0xFEBF, 0xFEB5, 0xFEAB, 0xFEA1, 0xFE98, 0xFE8F, 
    0xFE87, 0xFE80, 0xFE7A, 0xFE75, 0xFE73, 0xFE72, 0xFE72, 0xFE74, 0xFE78, 
    0xFE7C, 0xFE82, 0xFE88, 0xFE8F, 0xFE97, 0xFE9F, 0xFEA7, 0xFEB0, 0xFEB9, 
    0xFEC1, 0xFECA, 0xFED2, 0xFED9, 0xFEE0, 0xFEE7, 0xFEEC, 0xFEF1, 0xFEF4, 
    0xFEF6, 0xFEF7, 0x26D8, 0x2656, 0x25C1, 0x251C, 0x2469, 0x23AF, 0x22F0, 
    0x2231, 0x2174, 0x20C0, 0x2016, 0x1F7C, 0x1EF5, 0x1E85, 0x1E30, 0x1DFB, 
    0x1DE8, 0x1DF4, 0x1E19, 0x1E53, 0x1EA0, 0x1EFE, 0x1F6A, 0x1FE3, 0x2067, 
    0x20F2, 0x2183, 0x2217, 0x22AC, 0x2341, 0x23D1, 0x245D, 0x24E0, 0x2559, 
    0x25C6, 0x2624, 0x2671, 0x26AB, 0x26CF, 0x26DC, 0x10BE, 0x0679, 0xCB8B, 
    0xEE82, 0xE053, 0xD145, 0xFFFF, 0xFFFF, 0xF5E6, 0x0816, 0xE284, 0xEA2E, 
    0x1524, 0x22DF, 0xC75D, 0x131C, 0xEC4B, 0xE0AF, 0xFFFF, 0x0000, 0xFA62, 
    0xF344, 0x2351, 0xDF85, 0x0000, 0x0000, 0xBF5E, 0xF168, 0xF278, 0x973A, 
    0x0000, 0xFFFF, 0x0710, 0xFFFF, 0x0000, 0xCEBB, 0x0000, 0x0000, 0xBF5E, 
    0x0CE2, 0x0EFE, 0x961C, 0xFFFF, 0x0000, 0x0366, 0xFFB7, 0xFF3C, 0xD81A, 
    0x0000, 0x0000, 0x0000, 0x3F2C, 0xA8E0, 0xF0D0, 
    },
    {
    0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
    0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 0x0007, 0x0001, 0x0008, 
    0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 0x000B, 0x0028, 0x000C, 0x0028, 
    0x0034, 0x0028, 0x005C, 0x0001, 0x0084, 0x0001, 0x0085, 0x0001, 0x0086, 
    0x0001, 0x0087, 0x0001, 0x0088, 0x0001, 0x0089, 0x0001, 0x008A, 0x0001, 
    0x008B, 0x0001, 0x008C, 0x0001, 0x008D, 0x0001, 0x008E, 0x0001, 0x008F, 
    0x0001, 0x0090, 0x0001, 0x0091, 0x0001, 0x0092, 0x0001, 0x0093, 0x0001, 
    0x0094, 0x0001, 0x0095, 0x0001, 0x0096, 0x0001, 0x0097, 0x0001, 0x0098, 
    0x0001, 0x0099, 0x0001, 0x009A, 0x0001, 0x009B, 0x0001, 0x009C, 0x0001, 
    0x009D, 0x0001, 0x009E, 0x0001, 0x009F, 0x0001, 0x00A0, 0x0001, 0x00A1, 
    0x0001, 0x00A2, 0x0001, 0x00A3, 0x0001, 0x00A4, 0x0001, 0x00A5, 0x0001, 
    0x00A6, 0x0001, 0x00A7, 0x0001, 0x00A8, 0x0001, 0x00A9, 0x0001, 0x00AA, 
    0x0001, 0x00AB, 0x0001, 0x00AC, 0x0001, 0x00AD, 0x0001, 0x00AE, 0x0001, 
    0x00AF, 0x0001, 0x00B0, 0x0001, 0x00B1, 0x0001, 0x00B2, 0x0001, 0x00B3, 
    0x0001, 0x00B4, 0x0001, 0x00B5, 0x0001, 0x00B6, 0x0001, 0x00B7, 0x0001, 
    0x00B8, 0x0001, 0x00B9, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLEEP_START_LYING",
    1,
    0,
    0,
    0,
    39,
    {
    0x0000, 0xFFA4, 0xFFA4, 0xFFA4, 0xFFA5, 0xFFA5, 0xFFA5, 0xFFA5, 0xFFA5, 
    0xFFA5, 0xFFA5, 0xFFA6, 0xFFA6, 0xFFA7, 0xFFA8, 0xFFA8, 0xFFA9, 0xFFAA, 
    0xFFAB, 0xFFAB, 0xFFAC, 0xFFAD, 0xFFAD, 0xFFAE, 0xFFAE, 0xFFAE, 0xFFAE, 
    0xFFAE, 0xFFAD, 0xFFAD, 0xFFAD, 0xFFAD, 0xFFAD, 0xFFAE, 0xFFAE, 0xFFAE, 
    0xFFAF, 0xFFAF, 0xFFAF, 0xFFB0, 0xFF5A, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 
    0x010D, 0x030C, 0x05CA, 0x0914, 0x0CB5, 0x107B, 0x1431, 0x17A5, 0x1AA3, 
    0x1CF8, 0x1E70, 0x1ED7, 0x1DFB, 0x1BA7, 0x1692, 0x0E20, 0x031F, 0xF660, 
    0xE8B2, 0xDAE5, 0xCDC9, 0xC22D, 0xB8E1, 0xB2B5, 0xB078, 0x0000, 0x00FB, 
    0x0280, 0x047E, 0x06E2, 0x0999, 0x0C93, 0x0FBC, 0x1302, 0x1654, 0x199F, 
    0x1CD2, 0x1FD9, 0x22A3, 0x251D, 0x2784, 0x2A10, 0x2CAC, 0x2F46, 0x31C9, 
    0x3420, 0x3637, 0x37FB, 0x3957, 0x3A36, 0x3A85, 0x2968, 0x29EE, 0x2AF9, 
    0x2C6B, 0x2E27, 0x300E, 0x3202, 0x33E6, 0x359C, 0x3705, 0x3804, 0x387A, 
    0x384A, 0x3756, 0x3580, 0x31EE, 0x2C34, 0x24DA, 0x1C65, 0x135C, 0x0A46, 
    0x01A9, 0xFA0B, 0xF3F4, 0xEFEA, 0xEE74, 0xFF6B, 0xFEB6, 0xFD72, 0xFBBB, 
    0xF9AD, 0xF763, 0xF4F9, 0xF28B, 0xF035, 0xEE13, 0xEC3F, 0xEAD7, 0xE9F5, 
    0xE9B5, 0xEA34, 0xEBD5, 0xEEBC, 0xF2A7, 0xF74F, 0xFC72, 0x01CB, 0x0715, 
    0x0C0D, 0x106E, 0x13F5, 0x165B, 0x17DD, 0x18EA, 0x1990, 0x19DE, 0x19E1, 
    0x19A8, 0x1940, 0x18B9, 0x1820, 0x1783, 0x16F0, 0x1676, 0x1622, 0x1603, 
    0x00A3, 0x0062, 0xFFF5, 0xFF64, 0xFEB5, 0xFDF1, 0xFD1F, 0xFC47, 0xFB70, 
    0xFAA2, 0xF9E5, 0xF941, 0xF8BC, 0xF85E, 0xF830, 0xF842, 0xF897, 0xF922, 
    0xF9D5, 0xFAA3, 0xFB7D, 0xFC56, 0xFD21, 0xFDCF, 0xFE54, 0xFEA1, 0xFEC0, 
    0xFEC6, 0xFEB6, 0xFE95, 0xFE65, 0xFE2A, 0xFDE9, 0xFDA5, 0xFD61, 0xFD21, 
    0xFCE9, 0xFCBC, 0xFC9F, 0xFC94, 0x0F98, 0x0FBB, 0x0FF3, 0x103D, 0x1096, 
    0x10FB, 0x1168, 0x11DA, 0x124F, 0x12C2, 0x1332, 0x139B, 0x13FA, 0x144B, 
    0x148B, 0x14B8, 0x14D1, 0x14DC, 0x14DC, 0x14D5, 0x14CD, 0x14C6, 0x14C7, 
    0x14D2, 0x14EC, 0x1519, 0x155C, 0x15B3, 0x1618, 0x1688, 0x1700, 0x177C, 
    0x17F7, 0x186E, 0x18DE, 0x1941, 0x1996, 0x19D6, 0x1A00, 0x1A0F, 0xFD75, 
    0xFCB7, 0xFBD5, 0xFAD4, 0xF9BC, 0xF893, 0xF75E, 0xF626, 0xF4F0, 0xF3C2, 
    0xF2A4, 0xF19C, 0xF084, 0xEF4B, 0xEE11, 0xECF9, 0xEC24, 0xEBB4, 0xEBCA, 
    0xEC41, 0xECDB, 0xED94, 0xEE69, 0xEF53, 0xF050, 0xF15B, 0xF270, 0xF38B, 
    0xF4A7, 0xF5C1, 0xF6D4, 0xF7DC, 0xF8D4, 0xF9B9, 0xFA86, 0xFB37, 0xFBC9, 
    0xFC36, 0xFC7A, 0xFC92, 0xFEED, 0xFEC3, 0xFE95, 0xFE62, 0xFE2B, 0xFDEF, 
    0xFDB0, 0xFD6C, 0xFD25, 0xFCDA, 0xFC8B, 0xFC39, 0xFBCE, 0xFB41, 0xFAA4, 
    0xFA0B, 0xF987, 0xF92C, 0xF90D, 0xF917, 0xF92D, 0xF94C, 0xF973, 0xF9A2, 
    0xF9D7, 0xFA11, 0xFA4F, 0xFA8F, 0xFAD1, 0xFB13, 0xFB55, 0xFB94, 0xFBD1, 
    0xFC09, 0xFC3B, 0xFC67, 0xFC8C, 0xFCA7, 0xFCB8, 0xFCBE, 0x26D8, 0x2621, 
    0x2544, 0x2448, 0x2335, 0x2211, 0x20E5, 0x1FB8, 0x1E92, 0x1D7A, 0x1C79, 
    0x1B94, 0x1AC7, 0x1A0B, 0x1963, 0x18D6, 0x1868, 0x181F, 0x17FE, 0x17F9, 
    0x17FD, 0x180A, 0x181F, 0x183A, 0x185B, 0x1881, 0x18AB, 0x18D7, 0x1906, 
    0x1935, 0x1965, 0x1993, 0x19C0, 0x19EA, 0x1A10, 0x1A31, 0x1A4D, 0x1A61, 
    0x1A6F, 0x1A73, 0x10C1, 0x0679, 0xCB8B, 0xEE82, 0xEE08, 0xED3D, 0xEC2D, 
    0xEAE8, 0xE97A, 0xE7F2, 0xE65C, 0xE4C7, 0xE341, 0xE1D6, 0xE095, 0xDF8B, 
    0xDEC6, 0xDE54, 0xDE42, 0xDE8C, 0xDF24, 0xDFFA, 0xE0FF, 0xE226, 0xE35F, 
    0xE49C, 0xE5CD, 0xE6E5, 0xE7D5, 0xE8B8, 0xE9B2, 0xEABC, 0xEBCF, 0xECE6, 
    0xEDFA, 0xEF05, 0xF000, 0xF0E6, 0xF1B0, 0xF259, 0xF2D8, 0xF32A, 0xF346, 
    0xE053, 0xE0A2, 0xE127, 0xE1D9, 0xE2AF, 0xE39E, 0xE49F, 0xE5A7, 0xE6AD, 
    0xE7A8, 0xE88E, 0xE956, 0xE9F7, 0xEA66, 0xEA9C, 0xEA73, 0xE9DC, 0xE8F4, 
    0xE7D3, 0xE694, 0xE552, 0xE427, 0xE32D, 0xE27F, 0xE236, 0xE26E, 0xE32A, 
    0xE451, 0xE5CF, 0xE791, 0xE984, 0xEB94, 0xEDAE, 0xEFBF, 0xF1B3, 0xF378, 
    0xF4F9, 0xF625, 0xF6E6, 0xF72B, 0xD142, 0xD1B0, 0xD25E, 0xD345, 0xD459, 
    0xD592, 0xD6E6, 0xD84C, 0xD9BA, 0xDB28, 0xDC8B, 0xDDDB, 0xDF0D, 0xE019, 
    0xE0F5, 0xE1AA, 0xE246, 0xE2CA, 0xE338, 0xE391, 0xE3D5, 0xE406, 0xE424, 
    0xE432, 0xE42F, 0xE41C, 0xE3F2, 0xE3A7, 0xE343, 0xE2CB, 0xE244, 0xE1B3, 
    0xE11F, 0xE08D, 0xE002, 0xDF84, 0xDF18, 0xDEC5, 0xDE8E, 0xDE7B, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xF5E6, 0xF4D8, 0xF316, 0xF0C0, 
    0xEDF3, 0xEACC, 0xE769, 0xE3E6, 0xE063, 0xDCFB, 0xD9CD, 0xD6F7, 0xD494, 
    0xD2C4, 0xD1A4, 0xD2EA, 0xD731, 0xDCE7, 0xE27C, 0xE65E, 0xE6FC, 0xE25A, 
    0xD966, 0xCEF0, 0xC5CB, 0xC0C7, 0xBF0B, 0xBDD2, 0xBD0D, 0xBCAC, 0xBC9F, 
    0xBCD6, 0xBD42, 0xBDD2, 0xBE78, 0xBF22, 0xBFC3, 0xC049, 0xC0A4, 0xC0C7, 
    0x0816, 0x0804, 0x07F2, 0x07DC, 0x07C2, 0x07A2, 0x077B, 0x074A, 0x070E, 
    0x06C6, 0x066F, 0x0609, 0x0591, 0x0506, 0x0466, 0x0397, 0x0289, 0x0149, 
    0xFFE8, 0xFE74, 0xFCFC, 0xFB8F, 0xFA3C, 0xF911, 0xF81E, 0xF771, 0xF6FF, 
    0xF6AE, 0xF67B, 0xF662, 0xF65F, 0xF66D, 0xF689, 0xF6AE, 0xF6D9, 0xF705, 
    0xF72E, 0xF751, 0xF768, 0xF771, 0xE284, 0xE364, 0xE4DA, 0xE6CD, 0xE922, 
    0xEBC3, 0xEE95, 0xF17F, 0xF469, 0xF73A, 0xF9D9, 0xFC2E, 0xFE1E, 0xFF91, 
    0x006F, 0x008E, 0xFFED, 0xFEB1, 0xFCFE, 0xFAF9, 0xF8C6, 0xF689, 0xF467, 
    0xF284, 0xF104, 0xF00C, 0xEF7B, 0xEF16, 0xEED5, 0xEEB6, 0xEEB1, 0xEEC3, 
    0xEEE7, 0xEF16, 0xEF4C, 0xEF83, 0xEFB7, 0xEFE3, 0xF001, 0xF00C, 0xEA2E, 
    0xEA6C, 0xEADA, 0xEB6F, 0xEC22, 0xECE9, 0xEDBB, 0xEE8F, 0xEF5A, 0xF015, 
    0xF0B5, 0xF132, 0xF181, 0xF19A, 0xF173, 0xF0EB, 0xEFF7, 0xEEAE, 0xED26, 
    0xEB76, 0xE9B4, 0xE7F6, 0xE653, 0xE4E1, 0xE3B8, 0xE2EC, 0xE26C, 0xE212, 
    0xE1D9, 0xE1BD, 0xE1B9, 0xE1C9, 0xE1E8, 0xE212, 0xE242, 0xE273, 0xE2A1, 
    0xE2C8, 0xE2E2, 0xE2EC, 0x1527, 0x22DF, 0xC75D, 0x131C, 0x12B9, 0x11D7, 
    0x1096, 0x0F16, 0x0D76, 0x0BD7, 0x0A58, 0x091A, 0x083B, 0x07DD, 0x0820, 
    0x0922, 0x0B04, 0x0DE6, 0x146A, 0x1FD4, 0x2E31, 0x3D91, 0x4C03, 0x5795, 
    0x6146, 0x6AAA, 0x72B1, 0x784A, 0x7A64, 0xEC4B, 0xEC7B, 0xEC99, 0xECB1, 
    0xECCE, 0xECFC, 0xED47, 0xEDBA, 0xEE62, 0xEF49, 0xF07C, 0xF207, 0xF3F4, 
    0xF650, 0xF927, 0xFE38, 0x0655, 0x1024, 0x1A48, 0x2367, 0x2A26, 0x2E66, 
    0x3126, 0x32B6, 0x336A, 0x3394, 0xE0AF, 0xE145, 0xE238, 0xE378, 0xE4F8, 
    0xE6AA, 0xE881, 0xEA6E, 0xEC63, 0xEE52, 0xF02F, 0xF1E9, 0xF375, 0xF4C4, 
    0xF5C7, 0xF5E9, 0xF4F9, 0xF387, 0xF220, 0xF151, 0xF1A9, 0xF41B, 0xF858, 
    0xFD09, 0x00D5, 0x0265, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFA62, 0xF8FC, 0xF6C4, 0xF3D9, 0xF058, 0xEC60, 
    0xE80E, 0xE381, 0xDED6, 0xDA2C, 0xD5A0, 0xD150, 0xCD5A, 0xC9DD, 0xC6F5, 
    0xC52C, 0xC4AC, 0xC508, 0xC5D1, 0xC69A, 0xC6F5, 0xF344, 0xF56E, 0xFA07, 
    0xFFF3, 0x0614, 0x0B50, 0x0E8A, 0x0EA7, 0x0AC7, 0x039A, 0xFA5F, 0xF057, 
    0xE6C0, 0xDED9, 0xD9E1, 0xD84D, 0xD93C, 0xDBE6, 0xDF85, 0xE353, 0xE68A, 
    0xEA17, 0xEEB6, 0xF356, 0xF6E5, 0xF851, 0x2351, 0x232B, 0x22DB, 0x2273, 
    0x2203, 0x219C, 0x214F, 0x212D, 0x2120, 0x2113, 0x2115, 0x2136, 0x2185, 
    0x2212, 0x22EC, 0x24AE, 0x2771, 0x2A81, 0x2D2B, 0x2EBB, 0x2E7D, 0x2AC3, 
    0x23E0, 0x1C1E, 0x15C8, 0x1329, 0xDF85, 0xE020, 0xE166, 0xE30E, 0xE4D0, 
    0xE662, 0xE77B, 0xE7D4, 0xE7AA, 0xE755, 0xE6AE, 0xE58B, 0xE3C8, 0xE13B, 
    0xDDBE, 0xD82E, 0xD05A, 0xC786, 0xBEF7, 0xB7F3, 0xB3BD, 0xB3BF, 0xB737, 
    0xBC28, 0xC094, 0xC27E, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xBF5E, 
    0xF168, 0xF32B, 0xF6E8, 0xFB53, 0xFF21, 0x0108, 0x0174, 0x01A5, 0x0190, 
    0x0128, 0x0063, 0xFF33, 0xFF33, 0xFF31, 0xFF2C, 0xFF23, 0xFF14, 0xFEFD, 
    0xFEDD, 0xFEB2, 0xFE7C, 0xFE38, 0xFDE5, 0xFD81, 0xFD0B, 0xFC82, 0xFBE3, 
    0xFB2E, 0xFA61, 0xF97A, 0xF878, 0xF75A, 0xF567, 0xF237, 0xEE41, 0xE9FB, 
    0xE5DB, 0xE256, 0xDFE3, 0xDEF8, 0xF278, 0xF47C, 0xF8BE, 0xFDB8, 0x01E3, 
    0x03B7, 0x0363, 0x023F, 0x007E, 0xFE55, 0xFBF8, 0xF99B, 0xF7E6, 0xF66E, 
    0xF52E, 0xF420, 0xF33F, 0xF285, 0xF1EF, 0xF176, 0xF115, 0xF0C8, 0xF088, 
    0xF052, 0xF01E, 0xEFE9, 0xEFAE, 0xEF66, 0xEF0D, 0xEE9D, 0xEE12, 0xED66, 
    0xEC97, 0xEBB2, 0xEAC6, 0xE9E2, 0xE915, 0xE870, 0xE802, 0xE7DA, 0x973A, 
    0x9591, 0x9212, 0x8E0B, 0x8ACE, 0x89AB, 0x8A2B, 0x8AFA, 0x8C22, 0x8DAA, 
    0x8F9C, 0x91FF, 0x941E, 0x95D1, 0x9727, 0x982B, 0x98EC, 0x9975, 0x99D5, 
    0x9A18, 0x9A4B, 0x9A7B, 0x9AB5, 0x9B07, 0x9B7C, 0x9C23, 0x9D09, 0x9E3A, 
    0x9FC3, 0xA1B1, 0xA412, 0xA6F3, 0xAA57, 0xAE12, 0xB1E4, 0xB590, 0xB8D8, 
    0xBB7D, 0xBD41, 0xBDE5, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0710, 
    0x084D, 0x0AF5, 0x0E5C, 0x11D7, 0x14B8, 0x1710, 0x195E, 0x1BA3, 0x1DDB, 
    0x2006, 0x2223, 0x242F, 0x262A, 0x2811, 0x29F0, 0x2BD0, 0x2DAD, 0x2F82, 
    0x314A, 0x3302, 0x34A4, 0x362C, 0x3796, 0x38DE, 0x39FE, 0x3B03, 0x3BFA, 
    0x3CE3, 0x3DBC, 0x3E86, 0x3F3E, 0x3FE4, 0x4077, 0x40F6, 0x4160, 0x41B5, 
    0x41F2, 0x4217, 0x4224, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xCEBB, 0xCEAA, 0xCE86, 0xCE5C, 0xCE39, 0xCE2B, 0xCE26, 0xCE1C, 
    0xCE10, 0xCE08, 0xCE08, 0xCE16, 0xCE35, 0xCE6A, 0xCEBB, 0xCF30, 0xCFCA, 
    0xD080, 0xD148, 0xD219, 0xD2E9, 0xD3AF, 0xD462, 0xD4F8, 0xD567, 0xD5A8, 
    0xD5BC, 0xD5B1, 0xD58B, 0xD54F, 0xD502, 0xD4A9, 0xD448, 0xD3E5, 0xD384, 
    0xD32A, 0xD2DB, 0xD29D, 0xD274, 0xD265, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xBF5E, 0x0CE2, 0x0EC2, 0x12B9, 0x17D3, 0x1D1F, 0x21A9, 0x247E, 
    0x25F4, 0x2700, 0x27A0, 0x27D3, 0x2796, 0x26E7, 0x25C5, 0x242C, 0x221E, 
    0x1FA8, 0x1CDA, 0x19C3, 0x1676, 0x1303, 0x0F79, 0x0BEA, 0x0866, 0x04FD, 
    0x01C0, 0x0EFE, 0x1063, 0x135B, 0x1715, 0x1AC4, 0x1D9A, 0x1EC8, 0x1E57, 
    0x1D05, 0x1B0F, 0x18B3, 0x1630, 0x13C2, 0x11A8, 0x1020, 0x0F0B, 0x0E1C, 
    0x0D4F, 0x0C9B, 0x0BFD, 0x0B6C, 0x0AE4, 0x0A5E, 0x09D4, 0x093F, 0x089B, 
    0x961C, 0x9485, 0x9124, 0x8CE9, 0x88C2, 0x859F, 0x846D, 0x852E, 0x870C, 
    0x89B4, 0x8CD1, 0x9011, 0x9321, 0x95AC, 0x975F, 0x9864, 0x9923, 0x99A8, 
    0x99FC, 0x9A2B, 0x9A41, 0x9A48, 0x9A4B, 0x9A56, 0x9A73, 0x9AAD, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0366, 0x0609, 0x0B9D, 0x12D5, 0x1A64, 
    0x20FF, 0x2559, 0x277B, 0x2883, 0x28C9, 0x28A1, 0x2863, 0x2865, 0x28FE, 
    0x2A83, 0x2CCA, 0x2F65, 0x3248, 0x3565, 0x38AF, 0x3C18, 0x3F93, 0x4312, 
    0x4688, 0x49E8, 0x4D24, 0xFFB7, 0xFFB7, 0xFFB7, 0xFFB8, 0xFFB8, 0xFFB8, 
    0xFFB8, 0xFFB8, 0xFFB7, 0xFFB6, 0xFFB5, 0xFFB4, 0xFFB4, 0xFFB5, 0xFFB7, 
    0xFFBA, 0xFFBE, 0xFFC3, 0xFFC7, 0xFFCD, 0xFFD2, 0xFFD8, 0xFFDE, 0xFFE3, 
    0xFFE9, 0xFFEE, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3B, 0xFF3B, 
    0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3D, 0xFF3C, 0xFF3C, 0xFF3B, 
    0xFF3A, 0xFF39, 0xFF38, 0xFF37, 0xFF36, 0xFF35, 0xFF33, 0xFF32, 0xFF31, 
    0xFF30, 0xD81A, 0xD815, 0xD809, 0xD7FB, 0xD7EC, 0xD7E1, 0xD7DD, 0xD7EF, 
    0xD81D, 0xD856, 0xD88D, 0xD8B1, 0xD8B4, 0xD887, 0xD81A, 0xD776, 0xD6AF, 
    0xD5CA, 0xD4CE, 0xD3BF, 0xD2A4, 0xD181, 0xD05C, 0xCF3B, 0xCE23, 0xCD1A, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x3F2C, 0x4111, 
    0x46DA, 0xD0B7, 0xDD6D, 0xE99D, 0xF2C8, 0xF8D6, 0xFC9E, 0xFED9, 0x0000, 
    0x006D, 0x00B2, 0x019F, 0x057F, 0x1D10, 0xDF05, 0xEAC0, 0xEE06, 0xF021, 
    0xF290, 0xF50D, 0xF724, 0xF913, 0xFAF6, 0xFCCB, 0xFE7F, 0xFFF5, 0x0113, 
    0x01C5, 0x0202, 0x01FD, 0x01F0, 0x01DD, 0x01C6, 0x01AE, 0x0198, 0x0186, 
    0x0179, 0x0174, 0xA8E0, 0xA969, 0xAA97, 0xD49B, 0xD583, 0xD8F7, 0xDEBD, 
    0xE610, 0xEE46, 0xF6F8, 0x0000, 0x097B, 0x13E3, 0x1F8D, 0x2C59, 0x3860, 
    0x4B3B, 0x571B, 0x619C, 0x69AC, 0x6EF3, 0x726F, 0x755E, 0x77CE, 0x79BF, 
    0x7B31, 0x7C26, 0x7CB0, 0x7CEA, 0x7CF9, 0x7CF8, 0x7CF7, 0x7CF4, 0x7CF0, 
    0x7CEA, 0x7CE2, 0x7CDB, 0x7CD4, 0x7CCF, 0x7CCD, 0xF0D0, 0xEEF2, 0xE93F, 
    0x5F85, 0x52FD, 0x4707, 0x3E22, 0x3866, 0x3502, 0x3342, 0x32BA, 0x335B, 
    0x3524, 0x385C, 0x3EF1, 0x594E, 0x1DCD, 0x2B6B, 0x2F7D, 0x30D0, 0x3061, 
    0x2E37, 0x2A89, 0x25BA, 0x201B, 0x1A0B, 0x13F9, 0x0E62, 0x09CA, 0x06AE, 
    0x058A, 0x05D0, 0x068B, 0x079A, 0x08DB, 0x0A2D, 0x0B6F, 0x0C7E, 0x0D39, 
    0x0D7F, 
    },
    {
    0x0001, 0x0000, 0x0027, 0x0001, 0x0001, 0x0028, 0x0001, 0x0029, 0x0001, 
    0x002A, 0x0001, 0x002B, 0x001A, 0x002C, 0x001A, 0x0046, 0x001A, 0x0060, 
    0x0028, 0x007A, 0x0028, 0x00A2, 0x0028, 0x00CA, 0x0028, 0x00F2, 0x0028, 
    0x011A, 0x0028, 0x0142, 0x0001, 0x016A, 0x0001, 0x016B, 0x0001, 0x016C, 
    0x0028, 0x016D, 0x0028, 0x0195, 0x0028, 0x01BD, 0x0028, 0x01E5, 0x0026, 
    0x020D, 0x0028, 0x0233, 0x0028, 0x025B, 0x0028, 0x0283, 0x0028, 0x02AB, 
    0x0001, 0x02D3, 0x0001, 0x02D4, 0x0001, 0x02D5, 0x001A, 0x02D6, 0x001A, 
    0x02F0, 0x001A, 0x030A, 0x0020, 0x0324, 0x0028, 0x0344, 0x0015, 0x036C, 
    0x001A, 0x0381, 0x001A, 0x039B, 0x001A, 0x03B5, 0x001A, 0x03CF, 0x0018, 
    0x03E9, 0x0001, 0x0401, 0x0028, 0x0402, 0x0028, 0x042A, 0x0028, 0x0452, 
    0x0027, 0x047A, 0x0026, 0x04A1, 0x0028, 0x04C7, 0x0028, 0x04EF, 0x0027, 
    0x0517, 0x0028, 0x053E, 0x001A, 0x0566, 0x0018, 0x0580, 0x0001, 0x0598, 
    0x001A, 0x0599, 0x001A, 0x05B3, 0x001A, 0x05CD, 0x0018, 0x05E7, 0x001A, 
    0x05FF, 0x001A, 0x0619, 0x001A, 0x0633, 0x001A, 0x064D, 0x001A, 0x0667, 
    0x0019, 0x0681, 0x0014, 0x069A, 0x0019, 0x06AE, 0x0028, 0x06C7, 0x0028, 
    0x06EF, 0x0028, 0x0717, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLEEP_LYING",
    0,
    0,
    0,
    0,
    49,
    {
    0x0000, 0xFFB0, 0xFFB0, 0xFFB0, 0xFFB0, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 
    0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 
    0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 
    0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 0xFFB1, 
    0xFFB1, 0xFFB1, 0xFFB1, 0xFFB0, 0xFF5A, 0x0000, 0x3FFF, 0x0000, 0xB078, 
    0x3A85, 0xEE74, 0x1603, 0x15DB, 0x15AC, 0x1577, 0x153E, 0x1500, 0x14BE, 
    0x1479, 0x1432, 0x13EA, 0x13A0, 0x1357, 0x130D, 0x12C5, 0x127F, 0x123B, 
    0x11FA, 0x11BE, 0x1186, 0x1153, 0x1126, 0x1100, 0x10E1, 0x10CA, 0x10BB, 
    0x10B6, 0x10BD, 0x10CE, 0x10EB, 0x1111, 0x1140, 0x1177, 0x11B5, 0x11F8, 
    0x1240, 0x128B, 0x12DA, 0x132A, 0x137A, 0x13CB, 0x141A, 0x1467, 0x14B0, 
    0x14F6, 0x1536, 0x156F, 0x15A2, 0x15CC, 0x15ED, 0x1603, 0xFC94, 0xFC76, 
    0xFC57, 0xFC36, 0xFC15, 0xFBF4, 0xFBD2, 0xFBB0, 0xFB8F, 0xFB6D, 0xFB4C, 
    0xFB2C, 0xFB0C, 0xFAEE, 0xFAD1, 0xFAB5, 0xFA9C, 0xFA84, 0xFA6E, 0xFA5A, 
    0xFA49, 0xFA3A, 0xFA2F, 0xFA26, 0xFA21, 0xFA1F, 0xFA22, 0xFA2A, 0xFA38, 
    0xFA4A, 0xFA60, 0xFA79, 0xFA96, 0xFAB6, 0xFAD7, 0xFAFB, 0xFB1F, 0xFB44, 
    0xFB6A, 0xFB90, 0xFBB4, 0xFBD8, 0xFBFA, 0xFC1A, 0xFC38, 0xFC52, 0xFC69, 
    0xFC7C, 0xFC8A, 0xFC94, 0x1A0F, 0x1A21, 0x1A2D, 0x1A32, 0x1A32, 0x1A2C, 
    0x1A21, 0x1A12, 0x19FF, 0x19E9, 0x19D0, 0x19B5, 0x1998, 0x197A, 0x195C, 
    0x193D, 0x191F, 0x1902, 0x18E6, 0x18CD, 0x18B5, 0x18A1, 0x1891, 0x1884, 
    0x187C, 0x187A, 0x187B, 0x187E, 0x1884, 0x188C, 0x1896, 0x18A2, 0x18AF, 
    0x18BE, 0x18CE, 0x18E0, 0x18F3, 0x1906, 0x191B, 0x1930, 0x1946, 0x195C, 
    0x1973, 0x198A, 0x19A1, 0x19B8, 0x19CE, 0x19E4, 0x19FA, 0x1A0F, 0xFC92, 
    0xFCF1, 0xFD45, 0xFD8D, 0xFDCA, 0xFDFE, 0xFE28, 0xFE4A, 0xFE64, 0xFE77, 
    0xFE83, 0xFE8A, 0xFE8B, 0xFE88, 0xFE82, 0xFE78, 0xFE6C, 0xFE5F, 0xFE50, 
    0xFE41, 0xFE33, 0xFE25, 0xFE1A, 0xFE11, 0xFE0B, 0xFE08, 0xFE07, 0xFE04, 
    0xFDFF, 0xFDF8, 0xFDF0, 0xFDE5, 0xFDDA, 0xFDCC, 0xFDBE, 0xFDAE, 0xFD9D, 
    0xFD8C, 0xFD79, 0xFD66, 0xFD52, 0xFD3D, 0xFD28, 0xFD13, 0xFCFD, 0xFCE7, 
    0xFCD2, 0xFCBC, 0xFCA7, 0xFC92, 0xFCBE, 0xFCD4, 0xFCE7, 0xFCF7, 0xFD06, 
    0xFD12, 0xFD1C, 0xFD25, 0xFD2B, 0xFD31, 0xFD34, 0xFD37, 0xFD38, 0xFD39, 
    0xFD38, 0xFD37, 0xFD36, 0xFD34, 0xFD31, 0xFD2F, 0xFD2C, 0xFD2A, 0xFD28, 
    0xFD26, 0xFD25, 0xFD25, 0xFD24, 0xFD22, 0xFD20, 0xFD1C, 0xFD18, 0xFD13, 
    0xFD0D, 0xFD07, 0xFD00, 0xFCFA, 0xFCF3, 0xFCEC, 0xFCE5, 0xFCDF, 0xFCD8, 
    0xFCD2, 0xFCCD, 0xFCC8, 0xFCC4, 0xFCC1, 0xFCBE, 0xFCBD, 0xFCBD, 0xFCBE, 
    0x1A73, 0x1AA2, 0x1AD7, 0x1B12, 0x1B50, 0x1B92, 0x1BD8, 0x1C20, 0x1C69, 
    0x1CB4, 0x1D00, 0x1D4B, 0x1D95, 0x1DDE, 0x1E25, 0x1E6A, 0x1EAA, 0x1EE7, 
    0x1F1F, 0x1F52, 0x1F7E, 0x1FA5, 0x1FC3, 0x1FDA, 0x1FE8, 0x1FED, 0x1FE6, 
    0x1FD0, 0x1FAF, 0x1F81, 0x1F4A, 0x1F0A, 0x1EC3, 0x1E76, 0x1E24, 0x1DCE, 
    0x1D75, 0x1D1C, 0x1CC3, 0x1C6C, 0x1C18, 0x1BC7, 0x1B7C, 0x1B38, 0x1AFC, 
    0x1AC9, 0x1AA0, 0x1A84, 0x1A74, 0x1A73, 0x10C1, 0x0679, 0xCB8B, 0xF346, 
    0xF388, 0xF3BA, 0xF3DF, 0xF3F6, 0xF401, 0xF402, 0xF3F9, 0xF3E8, 0xF3D0, 
    0xF3B2, 0xF38F, 0xF36A, 0xF342, 0xF319, 0xF2F0, 0xF2C9, 0xF2A4, 0xF284, 
    0xF268, 0xF253, 0xF246, 0xF241, 0xF242, 0xF245, 0xF24A, 0xF250, 0xF258, 
    0xF262, 0xF26C, 0xF278, 0xF285, 0xF292, 0xF2A0, 0xF2AE, 0xF2BC, 0xF2CB, 
    0xF2D9, 0xF2E7, 0xF2F5, 0xF302, 0xF30F, 0xF31A, 0xF325, 0xF32E, 0xF337, 
    0xF33D, 0xF342, 0xF345, 0xF346, 0xF72B, 0xF78E, 0xF7D0, 0xF7F5, 0xF7FF, 
    0xF7F0, 0xF7CC, 0xF795, 0xF74E, 0xF6FA, 0xF69B, 0xF633, 0xF5C7, 0xF558, 
    0xF4E9, 0xF47D, 0xF417, 0xF3B8, 0xF365, 0xF320, 0xF2EB, 0xF2C9, 0xF2BE, 
    0xF2C2, 0xF2CF, 0xF2E4, 0xF301, 0xF324, 0xF34D, 0xF37B, 0xF3AD, 0xF3E3, 
    0xF41D, 0xF459, 0xF496, 0xF4D5, 0xF514, 0xF552, 0xF590, 0xF5CC, 0xF605, 
    0xF63C, 0xF66E, 0xF69C, 0xF6C5, 0xF6E8, 0xF704, 0xF719, 0xF727, 0xF72B, 
    0xDE7B, 0xDE66, 0xDE5A, 0xDE57, 0xDE5D, 0xDE6A, 0xDE7D, 0xDE96, 0xDEB3, 
    0xDED5, 0xDEF9, 0xDF20, 0xDF47, 0xDF6F, 0xDF97, 0xDFBD, 0xDFE1, 0xE001, 
    0xE01E, 0xE036, 0xE048, 0xE053, 0xE057, 0xE055, 0xE050, 0xE047, 0xE03B, 
    0xE02C, 0xE01B, 0xE008, 0xDFF3, 0xDFDC, 0xDFC4, 0xDFAB, 0xDF91, 0xDF76, 
    0xDF5C, 0xDF42, 0xDF28, 0xDF0F, 0xDEF7, 0xDEE0, 0xDECB, 0xDEB7, 0xDEA6, 
    0xDE97, 0xDE8B, 0xDE83, 0xDE7D, 0xDE7B, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xC0C7, 0xF771, 0xF00C, 0xE2EC, 0x1527, 0x22DF, 0xC75D, 0x7A64, 0x3394, 
    0x0265, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xC6F5, 0xF851, 0x1329, 0xC27E, 0x0000, 
    0xFFFF, 0xBF5E, 0xDEF8, 0xDEF7, 0xDEF5, 0xDEF2, 0xDEEE, 0xDEE9, 0xDEE4, 
    0xDEDE, 0xDED9, 0xDED4, 0xDECF, 0xDECB, 0xDEC8, 0xDEC6, 0xDEC5, 0xDEC5, 
    0xDEC5, 0xDEC6, 0xDEC7, 0xDEC8, 0xDEC9, 0xDECA, 0xDECC, 0xDECD, 0xDECF, 
    0xDED1, 0xDED3, 0xDED5, 0xDED7, 0xDED9, 0xDEDB, 0xDEDD, 0xDEDF, 0xDEE2, 
    0xDEE4, 0xDEE6, 0xDEE8, 0xDEEA, 0xDEEC, 0xDEEE, 0xDEEF, 0xDEF1, 0xDEF2, 
    0xDEF4, 0xDEF5, 0xDEF6, 0xDEF7, 0xDEF7, 0xDEF8, 0xE7DA, 0xE7DE, 0xE7EA, 
    0xE7FD, 0xE815, 0xE830, 0xE84F, 0xE86E, 0xE88E, 0xE8AC, 0xE8C8, 0xE8E0, 
    0xE8F3, 0xE8FF, 0xE903, 0xE902, 0xE900, 0xE8FD, 0xE8F8, 0xE8F3, 0xE8EC, 
    0xE8E4, 0xE8DB, 0xE8D2, 0xE8C8, 0xE8BD, 0xE8B2, 0xE8A6, 0xE89A, 0xE88E, 
    0xE881, 0xE875, 0xE868, 0xE85B, 0xE84F, 0xE842, 0xE836, 0xE82B, 0xE81F, 
    0xE815, 0xE80A, 0xE801, 0xE7F9, 0xE7F1, 0xE7EA, 0xE7E4, 0xE7E0, 0xE7DC, 
    0xE7DA, 0xBDE5, 0xBDE6, 0xBDE6, 0xBDE7, 0xBDE8, 0xBDE9, 0xBDEA, 0xBDEB, 
    0xBDEC, 0xBDED, 0xBDEE, 0xBDEF, 0xBDF0, 0xBDF0, 0xBDF0, 0xBDF0, 0xBDF0, 
    0xBDF0, 0xBDF0, 0xBDF0, 0xBDEF, 0xBDEF, 0xBDEF, 0xBDEE, 0xBDEE, 0xBDEE, 
    0xBDED, 0xBDED, 0xBDEC, 0xBDEC, 0xBDEB, 0xBDEB, 0xBDEB, 0xBDEA, 0xBDEA, 
    0xBDE9, 0xBDE9, 0xBDE8, 0xBDE8, 0xBDE8, 0xBDE7, 0xBDE7, 0xBDE6, 0xBDE6, 
    0xBDE6, 0xBDE6, 0xBDE6, 0xBDE5, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x4224, 0x4244, 0x4261, 0x427C, 
    0x4294, 0x42AA, 0x42BD, 0x42CE, 0x42DD, 0x42EB, 0x42F6, 0x42FF, 0x4307, 
    0x430C, 0x4311, 0x4313, 0x4314, 0x4314, 0x4313, 0x4310, 0x430C, 0x4307, 
    0x4301, 0x42FA, 0x42F3, 0x42EB, 0x42E2, 0x42D8, 0x42CE, 0x42C4, 0x42B9, 
    0x42AF, 0x42A4, 0x4298, 0x428E, 0x4283, 0x4278, 0x426D, 0x4263, 0x425A, 
    0x4251, 0x4248, 0x4240, 0x4239, 0x4233, 0x422E, 0x422A, 0x4227, 0x4225, 
    0x4224, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xD265, 0xD259, 0xD24D, 0xD242, 
    0xD239, 0xD230, 0xD228, 0xD221, 0xD21B, 0xD216, 0xD212, 0xD20E, 0xD20B, 
    0xD208, 0xD207, 0xD206, 0xD205, 0xD205, 0xD206, 0xD207, 0xD209, 0xD20B, 
    0xD20D, 0xD210, 0xD213, 0xD216, 0xD21A, 0xD21D, 0xD221, 0xD225, 0xD22A, 
    0xD22E, 0xD232, 0xD237, 0xD23B, 0xD240, 0xD244, 0xD248, 0xD24C, 0xD250, 
    0xD254, 0xD257, 0xD25A, 0xD25D, 0xD25F, 0xD261, 0xD263, 0xD264, 0xD265, 
    0x0000, 0xFFFF, 0xBF5E, 0x01C0, 0x089B, 0x9AAD, 0x0000, 0x0000, 0x4D24, 
    0xFFEE, 0xFF30, 0xCD1A, 0xFFFF, 0x0000, 0x0000, 0x0174, 0x7CCD, 0x0D7F, 
    
    },
    {
    0x0001, 0x0000, 0x0027, 0x0001, 0x0001, 0x0028, 0x0001, 0x0029, 0x0001, 
    0x002A, 0x0001, 0x002B, 0x0001, 0x002C, 0x0001, 0x002D, 0x0001, 0x002E, 
    0x0032, 0x002F, 0x0032, 0x0061, 0x0032, 0x0093, 0x0032, 0x00C5, 0x0032, 
    0x00F7, 0x0032, 0x0129, 0x0001, 0x015B, 0x0001, 0x015C, 0x0001, 0x015D, 
    0x0032, 0x015E, 0x0032, 0x0190, 0x0032, 0x01C2, 0x0032, 0x01F4, 0x002C, 
    0x0226, 0x0001, 0x0252, 0x0001, 0x0253, 0x0001, 0x0254, 0x0001, 0x0255, 
    0x0001, 0x0256, 0x0001, 0x0257, 0x0001, 0x0258, 0x0001, 0x0259, 0x0001, 
    0x025A, 0x0001, 0x025B, 0x0031, 0x025C, 0x002C, 0x028D, 0x0001, 0x02B9, 
    0x0001, 0x02BA, 0x0001, 0x02BB, 0x0001, 0x02BC, 0x0001, 0x02BD, 0x0001, 
    0x02BE, 0x0001, 0x02BF, 0x0031, 0x02C0, 0x0031, 0x02F1, 0x0030, 0x0322, 
    0x0032, 0x0352, 0x0032, 0x0384, 0x0032, 0x03B6, 0x0031, 0x03E8, 0x002D, 
    0x0419, 0x0031, 0x0446, 0x0001, 0x0477, 0x0001, 0x0478, 0x0001, 0x0479, 
    0x0001, 0x047A, 0x0001, 0x047B, 0x0001, 0x047C, 0x0001, 0x047D, 0x0001, 
    0x047E, 0x0001, 0x047F, 0x0001, 0x0480, 0x0001, 0x0481, 0x0001, 0x0482, 
    0x0001, 0x0483, 0x0001, 0x0484, 0x0001, 0x0485, 0x0001, 0x0486, 0x0001, 
    0x0487, 0x0001, 0x0488, 
})

smlua_anim_util_register_animation("MILNE_ANIM_SLIDE_KICK",
    1,
    0,
    0,
    0,
    7,
    {
    0xFFF4, 0xFFF8, 0xFFF8, 0xFFF3, 0xFFF2, 0xFFF7, 0xFFFE, 0x0000, 0xFFFF, 
    0xFFF2, 0xFFF2, 0x0009, 0x000E, 0xFFF8, 0xFFD1, 0xFFBC, 0xFFDD, 0x0000, 
    0x3FFF, 0x0000, 0xE4B4, 0xCB3E, 0xBF99, 0xC1CE, 0xD384, 0xE008, 0xEB46, 
    0xF1AB, 0x28AE, 0x2503, 0x18F0, 0x11D5, 0x088F, 0x042E, 0x00D4, 0xFF33, 
    0x3C1B, 0x1E3D, 0x0F8A, 0x0CC5, 0x0A3D, 0x0A19, 0x0A8B, 0x0D43, 0xEFB3, 
    0xEF84, 0xF074, 0xF75D, 0xF33A, 0xF297, 0xF2A5, 0xF33A, 0x02E4, 0xF760, 
    0xEB74, 0xF387, 0xFCB3, 0xFDAC, 0xFD1E, 0xFCB3, 0x277E, 0x16BC, 0x06CC, 
    0x072A, 0x1203, 0x12BB, 0x11A5, 0x1203, 0x23A0, 0x2883, 0x3464, 0x1DCF, 
    0x11CF, 0x10B9, 0x11A3, 0x11CF, 0xFB8F, 0xF5B1, 0xF48C, 0xF1E4, 0xF4A1, 
    0xF4C7, 0xF477, 0xF4A1, 0xD73C, 0xF15A, 0x0A3E, 0x186A, 0x1A18, 0x1B25, 
    0x1BEB, 0x1A18, 0x0001, 0xFFFE, 0xC170, 0xE522, 0xD802, 0xDF7A, 0xF7BF, 
    0x1877, 0xFCA7, 0xE780, 0xE896, 0xE133, 0xFBEF, 0x0413, 0xE9A6, 0xD45D, 
    0xE43F, 0xE6F5, 0xE6F9, 0xDDB8, 0xEB4E, 0x0B0A, 0x0EFF, 0x020A, 0x09EB, 
    0x1882, 0x1770, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xE5B5, 0xD6D5, 0xD97D, 0xDF43, 0xE25B, 0xDF3B, 0xD96C, 0xD5BA, 0xE53B, 
    0xE261, 0xDBB7, 0xD47E, 0xCFC6, 0xD00A, 0xD2CF, 0xD3BB, 0xEA27, 0xE979, 
    0xE81B, 0xE6B8, 0xE710, 0xEB4F, 0xF149, 0xF441, 0xE4CF, 0xED21, 0xF3BF, 
    0xF9DA, 0xFCDD, 0xFA21, 0xF44D, 0xF0C2, 0x0001, 0xFFFE, 0xC170, 0x46D0, 
    0x4A2C, 0x3FDA, 0xF60E, 0x456A, 0x5929, 0x4F8A, 0x49A0, 0x6076, 0x5CB5, 
    0x5EFC, 0x46E9, 0x2B9E, 0x14E1, 0x137B, 0x167A, 0x0791, 0x14DD, 0x1B46, 
    0xD84A, 0x16E6, 0x1F55, 0x21E9, 0x2327, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xD050, 0xCF45, 0xDEAE, 0xCBBB, 0xCFB1, 0xCDFF, 
    0xCE49, 0xCEA5, 0xC9CF, 0xCD40, 0xDDA6, 0xDD41, 0xD25C, 0xD135, 0xD89A, 
    0xE0EA, 0x0A52, 0x1260, 0x17EC, 0x161A, 0x0842, 0x00D7, 0x023C, 0x03F5, 
    0xD323, 0xD7F5, 0xDB3D, 0xDC27, 0xD379, 0xDD1C, 0xDFA4, 0xE245, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xBF5E, 0x02DD, 0x0307, 0x030E, 
    0x02E9, 0x0230, 0x0019, 0xFD6D, 0xFC1C, 0xEB65, 0xEB08, 0xEC66, 0xEE83, 
    0xEF9F, 0xEE86, 0xEC6D, 0xEB35, 0x949C, 0xA3D3, 0xA9DF, 0xABA1, 0xA994, 
    0xA133, 0x9503, 0x8D12, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x58CE, 0x5F56, 0x6186, 
    0x61E4, 0x61F7, 0x6276, 0x62AA, 0x61F7, 0xFA85, 0xFA9F, 0xFA97, 0xFA81, 
    0xFA7F, 0xFAAB, 0xFAEB, 0xFB09, 0x0137, 0x01C5, 0x01E8, 0x01C9, 0x0148, 
    0xFFEF, 0xFE33, 0xFD4C, 0xC3FA, 0xC804, 0xC916, 0xC85D, 0xC4BB, 0xBACA, 
    0xADF0, 0xA73D, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xBF5E, 
    0xEB3F, 0xF433, 0xFDBB, 0x0846, 0x0B59, 0x0A00, 0x07DF, 0x0675, 0x0075, 
    0xF8B3, 0xF7DA, 0xF46B, 0xFCFC, 0xFD9A, 0xFCC9, 0xFCFC, 0xDA05, 0xD3CC, 
    0xC8C2, 0xB3E3, 0xA81D, 0xA789, 0xA8EC, 0xA81D, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x229B, 0x3C67, 0x4F41, 0x324D, 0x1605, 
    0x1048, 0x122C, 0x1605, 0xFFB9, 0xFFCE, 0xFFB0, 0xFF75, 0xFF56, 0xFF83, 
    0xFFCB, 0xFFF7, 0xFF38, 0xFF30, 0xFF3A, 0xFF68, 0xFF87, 0xFF70, 0xFF48, 
    0xFF2F, 0xD7C9, 0xD3A1, 0xD9ED, 0xE8A3, 0xF10D, 0xE6CB, 0xD628, 0xCBF9, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x02FA, 0x0AFB, 0x167D, 0x234E, 0x2ED0, 0x36D1, 
    0x39CC, 
    },
    {
    0x0008, 0x0000, 0x0008, 0x0008, 0x0001, 0x0010, 0x0001, 0x0011, 0x0001, 
    0x0012, 0x0001, 0x0013, 0x0008, 0x0014, 0x0008, 0x001C, 0x0008, 0x0024, 
    0x0008, 0x002C, 0x0008, 0x0034, 0x0008, 0x003C, 0x0008, 0x0044, 0x0008, 
    0x004C, 0x0008, 0x0054, 0x0001, 0x005C, 0x0001, 0x005D, 0x0001, 0x005E, 
    0x0008, 0x005F, 0x0008, 0x0067, 0x0008, 0x006F, 0x0008, 0x0077, 0x0008, 
    0x007F, 0x0008, 0x0087, 0x0008, 0x008F, 0x0008, 0x0097, 0x0008, 0x009F, 
    0x0001, 0x00A7, 0x0001, 0x00A8, 0x0001, 0x00A9, 0x0008, 0x00AA, 0x0008, 
    0x00B2, 0x0008, 0x00BA, 0x0008, 0x00C2, 0x0008, 0x00CA, 0x0008, 0x00D2, 
    0x0008, 0x00DA, 0x0008, 0x00E2, 0x0008, 0x00EA, 0x0007, 0x00F2, 0x0008, 
    0x00F9, 0x0001, 0x0101, 0x0008, 0x0102, 0x0008, 0x010A, 0x0008, 0x0112, 
    0x0004, 0x011A, 0x0008, 0x011E, 0x0008, 0x0126, 0x0008, 0x012E, 0x0008, 
    0x0136, 0x0008, 0x013E, 0x0007, 0x0146, 0x0008, 0x014D, 0x0001, 0x0155, 
    0x0008, 0x0156, 0x0008, 0x015E, 0x0008, 0x0166, 0x0005, 0x016E, 0x0002, 
    0x0173, 0x0008, 0x0175, 0x0008, 0x017D, 0x0008, 0x0185, 0x0008, 0x018D, 
    0x0008, 0x0195, 0x0007, 0x019D, 0x0008, 0x01A4, 0x0007, 0x01AC, 0x0008, 
    0x01B3, 0x0008, 0x01BB, 
})

smlua_anim_util_register_animation("MILNE_ANIM_CROUCH_FROM_SLIDE_KICK",
    1,
    0,
    0,
    0,
    13,
    {
    0x0000, 0xFFBC, 0xFFBF, 0xFFC7, 0xFFD3, 0xFFE3, 0xFFF5, 0x0008, 0x001C, 
    0x0030, 0x0042, 0x0052, 0x005E, 0x0066, 0x0069, 0xFFDD, 0x0000, 0x3FFF, 
    0x0000, 0xF1AB, 0xF1E9, 0xF295, 0xF39B, 0xF4E8, 0xF666, 0xF802, 0xF9A9, 
    0xFB45, 0xFCC3, 0xFE10, 0xFF16, 0xFFC2, 0xFFFF, 0xFF33, 0xFF36, 0xFF40, 
    0xFF4E, 0xFF61, 0xFF76, 0xFF8D, 0xFFA5, 0xFFBC, 0xFFD1, 0xFFE4, 0xFFF2, 
    0xFFFC, 0xFFFF, 0x0D43, 0x0E67, 0x1193, 0x1669, 0x1C8A, 0x2397, 0x2B33, 
    0x32FE, 0x3A99, 0x41A6, 0x47C7, 0x4C9D, 0x4FC9, 0x50ED, 0xF33A, 0xF371, 
    0xF40A, 0xF4F4, 0xF61C, 0xF771, 0xF8E1, 0xFA59, 0xFBC9, 0xFD1D, 0xFE46, 
    0xFF2F, 0xFFC8, 0xFFFF, 0xFCB3, 0xFCC1, 0xFCE9, 0xFD25, 0xFD71, 0xFDC9, 
    0xFE28, 0xFE8A, 0xFEE9, 0xFF41, 0xFF8D, 0xFFCA, 0xFFF1, 0x0000, 0x1203, 
    0x1299, 0x143C, 0x16BB, 0x19E5, 0x1D89, 0x2176, 0x257B, 0x2969, 0x2D0C, 
    0x3036, 0x32B5, 0x3458, 0x34EF, 0x11CF, 0x11E8, 0x114D, 0x1023, 0x0E8D, 
    0x0CB0, 0x0AAE, 0x08AC, 0x06CC, 0x0533, 0x0397, 0x01E4, 0x008C, 0xFFFF, 
    0xF4A1, 0xF4BE, 0xF557, 0xF650, 0xF790, 0xF8FC, 0xFA78, 0xFBEA, 0xFD39, 
    0xFE48, 0xFF0F, 0xFF97, 0xFFE6, 0x0000, 0x1A18, 0x191A, 0x1563, 0x0F8E, 
    0x0835, 0xFFF3, 0xF760, 0xEF18, 0xE7B4, 0xE1CF, 0xDE16, 0xDC53, 0xDBCC, 
    0xDBC9, 0x0001, 0xFFFE, 0xC170, 0xE896, 0xEC3D, 0xFC1E, 0x04CD, 0x1B03, 
    0x3619, 0x4E8B, 0xDCD4, 0xDFD5, 0xDD00, 0xD6B2, 0x4F47, 0x4919, 0x4683, 
    0xE6F9, 0xE83B, 0xFEA3, 0xF8B6, 0xF21D, 0xEABF, 0xE39D, 0xA245, 0xA747, 
    0xAC32, 0xB0A7, 0xCBB4, 0xC942, 0xC85C, 0x1770, 0x0EEF, 0x033F, 0xF0D4, 
    0xE25A, 0xD3C4, 0xC34D, 0x2F33, 0x1414, 0xF2F9, 0xD0C7, 0x3257, 0x1C82, 
    0x1427, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xD5BA, 0xDA64, 0xDFDE, 0xE4FB, 0xEA7A, 0xF07B, 0xF4DB, 0xF579, 
    0xF172, 0xEA6D, 0xE213, 0xDA0D, 0xD405, 0xD1A4, 0xD3BB, 0xE7C9, 0xFC93, 
    0x04DD, 0xFABC, 0xE6BD, 0xD162, 0xC32D, 0xBCF7, 0xB976, 0xB7F5, 0xB7C1, 
    0xB826, 0xB86F, 0xF441, 0xF96D, 0xFD7F, 0xFE70, 0xFB2C, 0xF56C, 0xEF5B, 
    0xEB23, 0xE8EA, 0xE751, 0xE640, 0xE59D, 0xE54D, 0xE539, 0xF0C2, 0xE8C1, 
    0xDF16, 0xDA81, 0xDDDB, 0xE534, 0xED22, 0xF236, 0xF407, 0xF4B1, 0xF492, 
    0xF407, 0xF36F, 0xF328, 0x0001, 0xFFFE, 0xC170, 0x49A0, 0x39BB, 0x3739, 
    0x1D2A, 0x07C8, 0xFC13, 0x007E, 0xD539, 0xEBC8, 0xF37B, 0xF11E, 0xE97D, 
    0xE164, 0xDDA0, 0x167A, 0x18C2, 0x1F8C, 0x25E2, 0x1BF1, 0x153D, 0x11E0, 
    0x198D, 0x1E0B, 0x22D6, 0x2770, 0x2B58, 0x2E0E, 0x2F11, 0x2327, 0x1F4C, 
    0x1583, 0xE847, 0xC6BE, 0xC4D4, 0xBE7E, 0xB24B, 0xB4B3, 0xA0B4, 0x801B, 
    0x5CAE, 0x403F, 0x3498, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xCEA5, 0xD465, 0xDC18, 0xE4BC, 0xED4E, 0xF4CB, 
    0xFA30, 0xFC7A, 0xF9BB, 0xF241, 0xE860, 0xDE6E, 0xD6C1, 0xD3AD, 0xE0EA, 
    0xE88E, 0xFCC1, 0x042C, 0x0A4C, 0x0FB5, 0x14FB, 0x1AB3, 0x21BD, 0x29E0, 
    0x320D, 0x3935, 0x3E48, 0x4035, 0x03F5, 0x028E, 0x0500, 0x075D, 0x0A2B, 
    0x0D1E, 0x0FEC, 0x124B, 0x1469, 0x1688, 0x187D, 0x1A19, 0x1B32, 0x1B99, 
    0xE245, 0xE0CE, 0xE35D, 0xE5D6, 0xE8C4, 0xEBD9, 0xEEC8, 0xF142, 0xF379, 
    0xF5B1, 0xF7BC, 0xF96B, 0xFA91, 0xFAFD, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xFC1C, 0xFC10, 
    0xFC63, 0xFCF9, 0xFDB9, 0xFE87, 0xFF49, 0xFFE4, 0x006B, 0x00F8, 0x017E, 
    0x01EE, 0x023C, 0x0259, 0xEB35, 0xEB31, 0xEB4B, 0xEB7A, 0xEBB5, 0xEBF5, 
    0xEC31, 0xEC61, 0xEC8B, 0xECB7, 0xECE0, 0xED03, 0xED1B, 0xED24, 0x8D12, 
    0x8D3C, 0x8C1E, 0x8A14, 0x877C, 0x84B1, 0x8211, 0x7FF5, 0x7E23, 0x7C3B, 
    0x7A6C, 0x78E6, 0x77D9, 0x7774, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x61F7, 0x62F4, 0x62E6, 0x6206, 0x6090, 
    0x5EBF, 0x5CCD, 0x5AF4, 0x58AE, 0x55A3, 0x525A, 0x4F5B, 0x4D2C, 0x4C54, 
    0xFB09, 0xFB07, 0xFAFA, 0xFAE4, 0xFAC9, 0xFAAD, 0xFA94, 0xFA81, 0xFA72, 
    0xFA65, 0xFA5B, 0xFA52, 0xFA4D, 0xFA4B, 0xFD4C, 0xFD5B, 0xFD9A, 0xFDF8, 
    0xFE68, 0xFEDA, 0xFF3F, 0xFF89, 0xFFB7, 0xFFD8, 0xFFED, 0xFFF9, 0xFFFE, 
    0x0000, 0xA73D, 0xA7B0, 0xA97E, 0xAC38, 0xAF71, 0xB2BA, 0xB5A5, 0xB7C5, 
    0xB91F, 0xBA0F, 0xBAA8, 0xBAFE, 0xBB24, 0xBB2C, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x0675, 
    0x0642, 0x057E, 0x0497, 0x03FC, 0x03AF, 0x036B, 0x032F, 0x02FC, 0x02D1, 
    0x02AF, 0x0297, 0x0288, 0x0283, 0xFCFC, 0xFC6F, 0xFEBA, 0x0224, 0x04F3, 
    0x0708, 0x0958, 0x0BC1, 0x0E24, 0x1060, 0x1256, 0x13E4, 0x14EA, 0x1549, 
    0xA81D, 0xA6B8, 0x9E31, 0x93A5, 0x8C34, 0x880C, 0x8402, 0x8031, 0x7CAD, 
    0x7997, 0x7704, 0x750F, 0x73CF, 0x735F, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x1605, 0x1AFD, 0x277C, 
    0x35F2, 0x40CF, 0x45E6, 0x47E4, 0x4882, 0x4898, 0x480A, 0x471F, 0x4620, 
    0x4552, 0x44FE, 0xFFF7, 0xFFF6, 0xFFF8, 0xFFFB, 0xFFFE, 0x0000, 0x0003, 
    0x0006, 0x0009, 0x000C, 0x000E, 0x0010, 0x0012, 0xFF2F, 0xFF2F, 0xFF2F, 
    0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF30, 0xCBF9, 0xCC33, 0xCBC9, 0xCB16, 
    0xCA78, 0xC9F5, 0xC95E, 0xC8BE, 0xC81C, 0xC782, 0xC6FB, 0xC68E, 0xC646, 
    0xC62C, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
    0x0000, 0x4166, 0x4068, 0x3D98, 0x392A, 0x3355, 0x2C60, 0x24AE, 0x1CB9, 
    0x1506, 0x0E11, 0x083C, 0x03CE, 0x00FE, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x000E, 0x0001, 0x0001, 0x000F, 0x0001, 0x0010, 0x0001, 
    0x0011, 0x0001, 0x0012, 0x000E, 0x0013, 0x000E, 0x0021, 0x000E, 0x002F, 
    0x000E, 0x003D, 0x000E, 0x004B, 0x000E, 0x0059, 0x000E, 0x0067, 0x000E, 
    0x0075, 0x000E, 0x0083, 0x0001, 0x0091, 0x0001, 0x0092, 0x0001, 0x0093, 
    0x000E, 0x0094, 0x000E, 0x00A2, 0x000E, 0x00B0, 0x000D, 0x00BE, 0x000E, 
    0x00CB, 0x000E, 0x00D9, 0x000E, 0x00E7, 0x000E, 0x00F5, 0x000E, 0x0103, 
    0x0001, 0x0111, 0x0001, 0x0112, 0x0001, 0x0113, 0x000E, 0x0114, 0x000E, 
    0x0122, 0x000E, 0x0130, 0x000E, 0x013E, 0x000D, 0x014C, 0x000E, 0x0159, 
    0x000E, 0x0167, 0x000E, 0x0175, 0x000E, 0x0183, 0x000E, 0x0191, 0x000E, 
    0x019F, 0x0001, 0x01AD, 0x000E, 0x01AE, 0x000E, 0x01BC, 0x000E, 0x01CA, 
    0x000E, 0x01D8, 0x000D, 0x01E6, 0x000E, 0x01F3, 0x000E, 0x0201, 0x000E, 
    0x020F, 0x000E, 0x021D, 0x000E, 0x022B, 0x000E, 0x0239, 0x0001, 0x0247, 
    0x000E, 0x0248, 0x000E, 0x0256, 0x000E, 0x0264, 0x000E, 0x0272, 0x000E, 
    0x0280, 0x000E, 0x028E, 0x000D, 0x029C, 0x0008, 0x02A9, 0x000E, 0x02B1, 
    0x000E, 0x02BF, 0x000E, 0x02CD, 0x000E, 0x02DB, 0x000E, 0x02E9, 0x0007, 
    0x02F7, 0x000E, 0x02FE, 
})

local slideObjValues = {
    0x0000, 0xFFB3, 0xFFB3, 0xFFB3, 0x0015, 0x003A, 0x0042, 0x0054, 0x006C, 
    0x0085, 0x0099, 0x00A1, 0x009D, 0x009A, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0006, 0x0006, 0x0007, 
    0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x1E68, 0x1D8E, 
    0x1E68, 0x2226, 0x2672, 0x2B15, 0x2FDD, 0x3495, 0x3907, 0x3D00, 0x3BBD, 
    0x3A6B, 0x3921, 0x388D, 0x0000, 0xFFA8, 0xFF39, 0xFF1B, 0xFF15, 0xFF15, 
    0xFF1B, 0xFF33, 0xFF5D, 0xFF93, 0xFFC7, 0xFFF0, 0xFFFF, 0xFCBD, 0xFCB1, 
    0xFCD5, 0xFD5A, 0xFE05, 0xFEA6, 0xFF31, 0xFF8F, 0xFFBA, 0xFFDA, 0xFFF0, 
    0xFFFC, 0x0000, 0x13EC, 0x1831, 0x1DBB, 0x1F39, 0x1FAB, 0x20A4, 0x2596, 
    0x268C, 0x1D6F, 0x10B0, 0x038E, 0xF94B, 0xF526, 0xFE8D, 0xFE61, 0xFE44, 
    0xFE69, 0xFE9A, 0xFED1, 0xFF0C, 0xFF48, 0xFF81, 0xFFB3, 0xFFDB, 0xFFF6, 
    0xFFFF, 0x0000, 0x02EB, 0x02E6, 0x02C2, 0x027C, 0x0229, 0x01CE, 0x0170, 
    0x0113, 0x00BD, 0x0071, 0x0035, 0x000E, 0x0000, 0x054A, 0x0303, 0x0135, 
    0x0267, 0x0404, 0x05EB, 0x07FC, 0x0A15, 0x0C17, 0x0DDF, 0x0F4D, 0x1041, 
    0x109A, 0xFFFE, 0x0001, 0xC170, 0xC19F, 0xC221, 0xC2E6, 0xC3DE, 0xC4F6, 
    0xC61F, 0xC748, 0xC861, 0xC958, 0xCA1D, 0xCA9F, 0xCACF, 0x25D3, 0x2D40, 
    0xB72E, 0x34DA, 0x31E2, 0x2D89, 0x2542, 0x1CF9, 0x18C1, 0x1595, 0x1145, 
    0xC8D1, 0xF0A5, 0xEEC7, 0x93C9, 0xEC6E, 0xEE1D, 0xEFDF, 0xF0F2, 0xF1E4, 
    0xF2E8, 0xF453, 0xF7A3, 0x8E27, 0x828D, 0x7EF5, 0xF8FE, 0x745B, 0x6F2B, 
    0x6B98, 0x6C10, 0x6F6C, 0x7616, 0x7DC9, 0x834A, 0x00CA, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xE9FF, 0xEA4A, 0xEB17, 
    0xEC4D, 0xEDD3, 0xEF8C, 0xF160, 0xF334, 0xF4ED, 0xF672, 0xF7A9, 0xF876, 
    0xF8C1, 0xDFBF, 0xD30D, 0xC71C, 0xCA33, 0xCFCD, 0xD6EC, 0xDE94, 0xE5C9, 
    0xEB8F, 0xEEEB, 0xEEDF, 0xB46C, 0xF9D6, 0xF72E, 0xF474, 0xF491, 0xF514, 
    0xF5D8, 0xF6B9, 0xF792, 0xF83E, 0xF89A, 0xF87F, 0xF10A, 0xF87A, 0x0052, 
    0x080C, 0x0740, 0x0580, 0x0310, 0x0038, 0xFD3D, 0xFA63, 0xF7F2, 0xF62E, 
    0xFC05, 0xFFFE, 0x0001, 0xC170, 0xC19B, 0xC212, 0xC2C6, 0xC3A8, 0xC4A8, 
    0xC5B7, 0xC6C6, 0xC7C6, 0xC8A8, 0xC95C, 0xC9D3, 0xC9FE, 0x3BD6, 0x378D, 
    0x32A8, 0x34AC, 0x36FC, 0x30CF, 0xC514, 0xD891, 0xE036, 0xE760, 0xED5C, 
    0xF177, 0xF2FD, 0x6A91, 0x699B, 0x68C6, 0x6A1A, 0x6BA2, 0x6ACB, 0x1222, 
    0x13F3, 0x12AF, 0x10E6, 0x0F0E, 0x0D9D, 0x0D07, 0xFD16, 0xFA88, 0xF643, 
    0xF372, 0xEF62, 0xE484, 0x67CE, 0x7350, 0x7A60, 0x81C3, 0x8865, 0x8D2C, 
    0x8F02, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xEB38, 0xEB51, 0xEB97, 0xEBFF, 0xEC82, 0xED17, 0xEDB5, 
    0xEE53, 0xEEE8, 0xEF6B, 0xEFD4, 0xF019, 0xF032, 0x3E9F, 0x48B9, 0x50AA, 
    0x4B36, 0x43E0, 0x3B3B, 0x31DC, 0x2857, 0x1F41, 0x172E, 0x10B1, 0x0C61, 
    0x0ACF, 0x0F58, 0x0EB2, 0x0D7D, 0x0C45, 0x0AE2, 0x0964, 0x07DE, 0x0663, 
    0x0504, 0x03D3, 0x02E3, 0x0246, 0x020D, 0x057C, 0x0DD5, 0x1531, 0x127E, 
    0x0E92, 0x09C9, 0x047E, 0xFF0A, 0xF9C8, 0xF514, 0xF147, 0xEEBE, 0xEDD1, 
    0x0000, 0xFFF9, 0x0000, 0x0026, 0x005A, 0x0089, 0x00B5, 0x00C7, 0x0096, 
    0x0058, 0x002F, 0x000E, 0xFFFF, 0x0000, 0xFF48, 0x0000, 0x0411, 0x0968, 
    0x0E57, 0x12F3, 0x14D5, 0x0FBF, 0x0938, 0x04FA, 0x0176, 0x0000, 0xBF5E, 
    0xBF5A, 0xBF5E, 0xBF77, 0xBF98, 0xBFB6, 0xBFD3, 0xBFDE, 0xBFBF, 0xBF97, 
    0xBF7D, 0xBF67, 0xBF5E, 0xFAB1, 0xFCF0, 0xFFB2, 0x002F, 0x0003, 0xFFD6, 
    0x0162, 0xFFE2, 0xF439, 0xE79F, 0xE014, 0xDA65, 0xD826, 0xF79C, 0xFB84, 
    0x004B, 0x0114, 0x00B7, 0x0058, 0x0117, 0x005E, 0xFB03, 0xF4A2, 0xEEFF, 
    0xE9C1, 0xE771, 0x9D31, 0x8FC2, 0x8106, 0x82EA, 0x89E8, 0x902A, 0x91EE, 
    0x94BD, 0x9E23, 0xA84C, 0xB066, 0xB785, 0xBA93, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x09C7, 0x204B, 0x3DED, 0x48E5, 0x4E99, 
    0x50E8, 0x4CD2, 0x4421, 0x3937, 0x3108, 0x319A, 0x354C, 0x378C, 0x00D0, 
    0x0069, 0x0095, 0x0259, 0x04AD, 0x068B, 0x05C5, 0x07E6, 0x0A48, 0x0AE7, 
    0x06F7, 0x018D, 0xFED3, 0xFF37, 0xFF1F, 0xFF08, 0xFF0F, 0xFF22, 0xFF3F, 
    0xFF94, 0xFFA4, 0x0067, 0x00EF, 0x0098, 0xFFF8, 0xFFA1, 0xC1A9, 0xC70A, 
    0xCC41, 0xC9B7, 0xC4AC, 0xC008, 0xBE5E, 0xBF90, 0xBC8E, 0xB929, 0xB676, 
    0xB411, 0xB309, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
    0xFFC2, 0xFF80, 0x00AA, 0x0495, 0x0991, 0x0E04, 0x10BF, 0x12E8, 0x15DD, 
    0x180E, 0x1868, 0x180C, 0x17C1, 0x0BBA, 0x0577, 0xFED9, 0x0043, 0x0437, 
    0x0821, 0x0B4E, 0x0E01, 0x0F54, 0x1065, 0x127D, 0x14BF, 0x15CC, 0x9C0C, 
    0x8E42, 0x7F98, 0x82B9, 0x8B66, 0x9350, 0x9741, 0x9AC2, 0xA054, 0xA597, 
    0xA9AC, 0xAD1B, 0xAE8D, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0640, 0x1F1C, 0x3F4A, 0x49A5, 0x4DD5, 
    0x4F7A, 0x4DCA, 0x4735, 0x39E2, 0x2EA6, 0x2E01, 0x3106, 0x3311, 0xFFA0, 
    0x00AB, 0x001B, 0xFB57, 0xF50A, 0xEF94, 0xEF22, 0xEFEF, 0xF504, 0xF9F4, 
    0xFD24, 0xFF94, 0x008C, 0x0254, 0x027C, 0x025B, 0x01BD, 0x00DD, 0xFF88, 
    0xFBD4, 0xF9EB, 0xFAFF, 0xFCAF, 0xFE95, 0x0088, 0x016D, 0xC292, 0xC6EE, 
    0xCB24, 0xC939, 0xC545, 0xC11E, 0xBC96, 0xBBDC, 0xBF74, 0xC21A, 0xC062, 
    0xBD41, 0xBB93, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0x0000, 
    0x4166, 0x3F98, 0x3A79, 0x3264, 0x27DA, 0x1BD2, 0x0FB3, 0x04F4, 0xFCA7, 
    0xF769, 0xF59E, 0xF855, 0xFD50, 0x0000, 
}

local slideObjIndices = {
    0x0001, 0x0000, 0x000D, 0x0001, 0x000D, 0x000E, 0x0001, 0x001B, 0x0001, 
    0x001C, 0x0001, 0x001D, 0x000B, 0x001E, 0x000B, 0x0029, 0x000E, 0x0034, 
    0x000D, 0x0042, 0x000D, 0x004F, 0x000D, 0x005C, 0x000E, 0x0069, 0x000D, 
    0x0077, 0x000D, 0x0084, 0x0001, 0x0091, 0x0001, 0x0092, 0x000D, 0x0093, 
    0x000C, 0x00A0, 0x000C, 0x00AC, 0x000C, 0x00B8, 0x000E, 0x00C4, 0x000C, 
    0x00D2, 0x000D, 0x00DE, 0x000C, 0x00EB, 0x000C, 0x00F7, 0x000C, 0x0103, 
    0x0001, 0x010F, 0x0001, 0x0110, 0x000D, 0x0111, 0x000D, 0x011E, 0x000D, 
    0x012B, 0x000D, 0x0138, 0x000E, 0x0145, 0x000E, 0x0153, 0x000D, 0x0161, 
    0x000D, 0x016E, 0x000D, 0x017B, 0x000D, 0x0188, 0x000D, 0x0195, 0x000D, 
    0x01A2, 0x000D, 0x01AF, 0x000D, 0x01BC, 0x000D, 0x01C9, 0x000D, 0x01D6, 
    0x000D, 0x01E3, 0x000C, 0x01F0, 0x000D, 0x01FC, 0x000D, 0x0209, 0x000D, 
    0x0216, 0x000D, 0x0223, 0x000D, 0x0230, 0x000B, 0x023D, 0x0001, 0x0248, 
    0x000D, 0x0249, 0x000D, 0x0256, 0x000D, 0x0263, 0x000E, 0x0270, 0x000E, 
    0x027E, 0x000D, 0x028C, 0x000D, 0x0299, 0x000D, 0x02A6, 0x000D, 0x02B3, 
    0x000E, 0x02C0, 0x000E, 0x02CE, 0x000E, 0x02DC, 0x000E, 0x02EA, 0x000E, 
    0x02F8, 0x000E, 0x0306, 
}

smlua_anim_util_register_animation("MILNE_ANIM_SLIDING_ON_BOTTOM_WITH_LIGHT_OBJ",
    1,
    0,
    0,
    0,
    1,
    slideObjValues,
    slideObjIndices)

smlua_anim_util_register_animation("MILNE_ANIM_STAND_UP_FROM_SLIDING_WITH_LIGHT_OBJ",
    1,
    0,
    0,
    0,
    13,
    slideObjValues,
    slideObjIndices)

smlua_anim_util_register_animation("MILNE_ANIM_RUNNING",
    0,
    0,
    0,
    0,
    71,
    {
    0x0000, 0x00BD, 0x00BD, 0x00BC, 0x00BB, 0x00BA, 0x00B9, 0x00B7, 0x00B5, 
    0x00B3, 0x00B1, 0x00AF, 0x00AD, 0x00AB, 0x00A9, 0x00A7, 0x00A5, 0x00A4, 
    0x00A2, 0x00A1, 0x00A1, 0x00A1, 0x00A1, 0x00A2, 0x00A3, 0x00A5, 0x00A7, 
    0x00AA, 0x00AC, 0x00AF, 0x00B1, 0x00B4, 0x00B6, 0x00B9, 0x00BA, 0x00BC, 
    0x00BD, 0x00BD, 0x00BD, 0x00BC, 0x00BB, 0x00BA, 0x00B9, 0x00B7, 0x00B5, 
    0x00B3, 0x00B1, 0x00AF, 0x00AD, 0x00AB, 0x00A9, 0x00A7, 0x00A5, 0x00A4, 
    0x00A2, 0x00A1, 0x00A1, 0x00A1, 0x00A1, 0x00A2, 0x00A3, 0x00A5, 0x00A7, 
    0x00AA, 0x00AC, 0x00AF, 0x00B1, 0x00B4, 0x00B6, 0x00B9, 0x00BA, 0x00BC, 
    0x00BD, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0E4F, 0x0E40, 0x0E13, 0x0DCA, 
    0x0D67, 0x0CEA, 0x0C55, 0x0BA9, 0x0AE9, 0x0A14, 0x092D, 0x0836, 0x0730, 
    0x061D, 0x0500, 0x03DA, 0x02AE, 0x017D, 0x0049, 0xFF14, 0xFDE1, 0xFCB1, 
    0xFB87, 0xFA63, 0xF949, 0xF83B, 0xF739, 0xF647, 0xF565, 0xF497, 0xF3DE, 
    0xF33C, 0xF2B2, 0xF244, 0xF1F3, 0xF1C1, 0xF1B0, 0xF1BF, 0xF1EC, 0xF235, 
    0xF298, 0xF315, 0xF3AA, 0xF456, 0xF516, 0xF5EB, 0xF6D2, 0xF7C9, 0xF8CF, 
    0xF9E2, 0xFAFF, 0xFC25, 0xFD51, 0xFE82, 0xFFB6, 0x00EB, 0x021E, 0x034E, 
    0x0478, 0x059B, 0x06B5, 0x07C4, 0x08C6, 0x09B8, 0x0A9A, 0x0B68, 0x0C21, 
    0x0CC3, 0x0D4D, 0x0DBB, 0x0E0C, 0x0E3E, 0x0E4F, 0xFFC8, 0xFFC8, 0xFFC8, 
    0xFFCA, 0xFFCB, 0xFFCD, 0xFFCF, 0xFFD2, 0xFFD5, 0xFFD8, 0xFFDB, 0xFFDF, 
    0xFFE3, 0xFFE7, 0xFFEB, 0xFFF0, 0xFFF4, 0xFFF9, 0xFFFE, 0x0003, 0x0008, 
    0x000D, 0x0011, 0x0015, 0x001A, 0x001E, 0x0022, 0x0025, 0x0029, 0x002C, 
    0x002F, 0x0031, 0x0033, 0x0035, 0x0036, 0x0037, 0x0037, 0x0037, 0x0036, 
    0x0035, 0x0034, 0x0032, 0x0030, 0x002D, 0x002A, 0x0027, 0x0023, 0x001F, 
    0x001C, 0x0017, 0x0013, 0x000F, 0x000A, 0x0005, 0x0001, 0xFFFB, 0xFFF7, 
    0xFFF2, 0xFFED, 0xFFE9, 0xFFE5, 0xFFE1, 0xFFDD, 0xFFD9, 0xFFD6, 0xFFD3, 
    0xFFD0, 0xFFCD, 0xFFCB, 0xFFCA, 0xFFC9, 0xFFC8, 0x43BB, 0x4406, 0x44CF, 
    0x45F3, 0x474C, 0x48B8, 0x4A11, 0x4B35, 0x4BFE, 0x4C49, 0x4C41, 0x4C28, 
    0x4C00, 0x4BCB, 0x4B89, 0x4B3C, 0x4AE5, 0x4A86, 0x4A20, 0x49B4, 0x4944, 
    0x48D0, 0x485A, 0x47E3, 0x476E, 0x46FA, 0x4689, 0x461D, 0x45B7, 0x4558, 
    0x4501, 0x44B4, 0x4473, 0x443D, 0x4415, 0x43FD, 0x43F4, 0x4433, 0x44DD, 
    0x45D2, 0x46F5, 0x4827, 0x494A, 0x4A3F, 0x4AE8, 0x4B28, 0x4B20, 0x4B0A, 
    0x4AE6, 0x4AB7, 0x4A7C, 0x4A38, 0x49EB, 0x4996, 0x493B, 0x48DB, 0x4876, 
    0x480F, 0x47A6, 0x473D, 0x46D4, 0x466C, 0x4608, 0x45A8, 0x454D, 0x44F8, 
    0x44AB, 0x4466, 0x442C, 0x43FC, 0x43D9, 0x43C3, 0x43BB, 0xE361, 0xE388, 
    0xE3F8, 0xE4A7, 0xE58E, 0xE6A2, 0xE7DA, 0xE92F, 0xEA97, 0xEC08, 0xED7C, 
    0xEEF5, 0xF075, 0xF1FF, 0xF396, 0xF53E, 0xF6FA, 0xF8CD, 0xFABA, 0xFCC3, 
    0xFEED, 0x013A, 0x03A0, 0x0617, 0x0897, 0x0B17, 0x0D8E, 0x0FF3, 0x123D, 
    0x1463, 0x165D, 0x1821, 0x19A7, 0x1AE6, 0x1BD5, 0x1C6B, 0x1C9E, 0x1C77, 
    0x1C08, 0x1B58, 0x1A72, 0x195F, 0x1826, 0x16D2, 0x156B, 0x13FA, 0x1286, 
    0x110D, 0x0F8E, 0x0E04, 0x0C6C, 0x0AC4, 0x0908, 0x0736, 0x0549, 0x033F, 
    0x0115, 0xFEC8, 0xFC62, 0xF9EB, 0xF76A, 0xF4EA, 0xF273, 0xF00E, 0xEDC3, 
    0xEB9D, 0xE9A3, 0xE7DE, 0xE658, 0xE519, 0xE42A, 0xE394, 0xE361, 0xFFDA, 
    0xFFCA, 0xFF9D, 0xFF5C, 0xFF10, 0xFEBF, 0xFE72, 0xFE32, 0xFE05, 0xFDF4, 
    0xFDF7, 0xFDFE, 0xFE09, 0xFE18, 0xFE29, 0xFE3C, 0xFE50, 0xFE65, 0xFE79, 
    0xFE8C, 0xFE9D, 0xFEAC, 0xFEBA, 0xFEC6, 0xFED1, 0xFEDD, 0xFEEA, 0xFEF8, 
    0xFF08, 0xFF1B, 0xFF31, 0xFF4C, 0xFF6B, 0xFF8F, 0xFFBA, 0xFFEB, 0x0025, 
    0x0065, 0x00AA, 0x00F0, 0x0134, 0x0173, 0x01AA, 0x01D6, 0x01F2, 0x01FC, 
    0x01FB, 0x01F6, 0x01EE, 0x01E3, 0x01D6, 0x01C6, 0x01B3, 0x019E, 0x0187, 
    0x016E, 0x0153, 0x0136, 0x0118, 0x00F9, 0x00D9, 0x00BA, 0x009A, 0x007C, 
    0x005F, 0x0044, 0x002B, 0x0014, 0x0001, 0xFFF0, 0xFFE4, 0xFFDD, 0xFFDA, 
    0xFF32, 0xFEEF, 0xFE38, 0xFD31, 0xFBF8, 0xFAAF, 0xF976, 0xF86E, 0xF7B8, 
    0xF774, 0xF7B1, 0xF858, 0xF951, 0xFA86, 0xFBDE, 0xFD41, 0xFE99, 0xFFCD, 
    0x00C8, 0x016F, 0x01AB, 0x01AB, 0x01AA, 0x01A7, 0x01A2, 0x0198, 0x018A, 
    0x0177, 0x015C, 0x013B, 0x0111, 0x00DE, 0x00A1, 0x0058, 0x0004, 0xFFA2, 
    0xFF33, 0xFE93, 0xFDB1, 0xFCA2, 0xFB7F, 0xFA5D, 0xF954, 0xF87A, 0xF7E7, 
    0xF7B1, 0xF7F2, 0xF8A5, 0xF9B1, 0xFAFB, 0xFC6C, 0xFDE9, 0xFF5A, 0x00A5, 
    0x01B1, 0x0264, 0x02A5, 0x029B, 0x027F, 0x0254, 0x021B, 0x01D9, 0x018E, 
    0x013E, 0x00EC, 0x009A, 0x004A, 0xFFFF, 0xFFBC, 0xFF84, 0xFF58, 0xFF3C, 
    0xFF32, 0x0E4C, 0x0E38, 0x0E01, 0x0DAB, 0x0D3A, 0x0CB3, 0x0C1A, 0x0B74, 
    0x0AC5, 0x0A12, 0x095E, 0x08A8, 0x07F0, 0x0731, 0x066C, 0x059F, 0x04C6, 
    0x03E2, 0x02EF, 0x01ED, 0x00D9, 0xFFB1, 0xFE7C, 0xFD3C, 0xFBF7, 0xFAB2, 
    0xF970, 0xF836, 0xF70A, 0xF5F0, 0xF4EC, 0xF403, 0xF33B, 0xF296, 0xF21B, 
    0xF1CE, 0xF1B3, 0xF1C7, 0xF1FD, 0xF253, 0xF2C4, 0xF34B, 0xF3E4, 0xF489, 
    0xF538, 0xF5EC, 0xF6A0, 0xF756, 0xF80F, 0xF8CE, 0xF994, 0xFA62, 0xFB3B, 
    0xFC20, 0xFD14, 0xFE17, 0xFF2B, 0x0053, 0x0188, 0x02C8, 0x040C, 0x0552, 
    0x0693, 0x07CC, 0x08F8, 0x0A11, 0x0B15, 0x0BFD, 0x0CC5, 0x0D69, 0x0DE4, 
    0x0E31, 0x0E4C, 0xFF5B, 0xFF64, 0xFF7B, 0xFF9D, 0xFFC5, 0xFFF1, 0x001B, 
    0x0040, 0x005B, 0x0069, 0x006F, 0x0073, 0x0076, 0x0078, 0x007A, 0x007B, 
    0x007C, 0x007D, 0x007D, 0x007E, 0x007F, 0x0081, 0x0083, 0x0085, 0x0088, 
    0x008B, 0x008E, 0x0091, 0x0094, 0x0097, 0x009A, 0x009D, 0x009F, 0x00A1, 
    0x00A2, 0x00A3, 0x00A4, 0x009D, 0x008C, 0x0072, 0x0052, 0x0030, 0x000D, 
    0xFFEC, 0xFFD1, 0xFFBE, 0xFFB2, 0xFFA7, 0xFFA0, 0xFF9A, 0xFF95, 0xFF92, 
    0xFF90, 0xFF8F, 0xFF8E, 0xFF8C, 0xFF8B, 0xFF89, 0xFF86, 0xFF83, 0xFF7F, 
    0xFF7C, 0xFF78, 0xFF73, 0xFF6F, 0xFF6C, 0xFF68, 0xFF64, 0xFF61, 0xFF5F, 
    0xFF5D, 0xFF5C, 0xFF5B, 0x01F8, 0x01DA, 0x018A, 0x0116, 0x008C, 0xFFFA, 
    0xFF70, 0xFEFC, 0xFEAC, 0xFE8E, 0xFEB5, 0xFF20, 0xFFC0, 0x0087, 0x0163, 
    0x0247, 0x0324, 0x03E9, 0x0489, 0x04F4, 0x051B, 0x0518, 0x050F, 0x0500, 
    0x04EB, 0x04D0, 0x04AE, 0x0487, 0x0458, 0x0424, 0x03E8, 0x03A6, 0x035E, 
    0x030F, 0x02B9, 0x025C, 0x01F8, 0x018E, 0x0121, 0x00B5, 0x004F, 0xFFF1, 
    0xFFA1, 0xFF63, 0xFF3B, 0xFF2D, 0xFF50, 0xFFAF, 0x003F, 0x00EF, 0x01B3, 
    0x027E, 0x0343, 0x03F3, 0x0481, 0x04E1, 0x0503, 0x04FB, 0x04E2, 0x04BB, 
    0x048A, 0x044F, 0x040D, 0x03C6, 0x037E, 0x0335, 0x02EF, 0x02AD, 0x0272, 
    0x0240, 0x0219, 0x0201, 0x01F8, 0xFFFE, 0x0001, 0xC170, 0xFB27, 0xFB2E, 
    0xFB41, 0xFB5F, 0xFB8A, 0xFBBF, 0xFC00, 0xFC4A, 0xFC9E, 0xFCFC, 0xFD63, 
    0xFDD2, 0xFE48, 0xFEC4, 0xFF45, 0xFFCA, 0x0054, 0x00E0, 0x016D, 0x01FA, 
    0x0287, 0x0313, 0x039D, 0x0423, 0x04A5, 0x0522, 0x059A, 0x060A, 0x0672, 
    0x06D2, 0x0728, 0x0773, 0x07B3, 0x07E6, 0x080C, 0x0823, 0x082B, 0x0824, 
    0x080D, 0x07EA, 0x07B9, 0x077C, 0x0734, 0x06E2, 0x0687, 0x0623, 0x05B7, 
    0x0544, 0x04CC, 0x044E, 0x03CC, 0x0346, 0x02BE, 0x0234, 0x01AA, 0x011F, 
    0x0095, 0x000D, 0xFF87, 0xFF05, 0xFE87, 0xFE0E, 0xFD9C, 0xFD30, 0xFCCC, 
    0xFC70, 0xFC1E, 0xFBD6, 0xFB9A, 0xFB69, 0xFB45, 0xFB2F, 0xFB27, 0xE7E8, 
    0xE7F0, 0xE806, 0xE826, 0xE84C, 0xE874, 0xE89A, 0xE8BA, 0xE8D1, 0xE8D9, 
    0xE8D3, 0xE8C3, 0xE8A9, 0xE887, 0xE85C, 0xE82A, 0xE7F2, 0xE7B4, 0xE772, 
    0xE72C, 0xE6E3, 0xE697, 0xE64B, 0xE5FE, 0xE5B2, 0xE566, 0xE51D, 0xE4D7, 
    0xE495, 0xE457, 0xE41F, 0xE3ED, 0xE3C2, 0xE3A0, 0xE386, 0xE376, 0xE370, 
    0xE373, 0xE37B, 0xE387, 0xE398, 0xE3AC, 0xE3C5, 0xE3E1, 0xE401, 0xE423, 
    0xE448, 0xE46F, 0xE499, 0xE4C4, 0xE4F1, 0xE51E, 0xE54D, 0xE57C, 0xE5AC, 
    0xE5DC, 0xE60B, 0xE639, 0xE667, 0xE694, 0xE6BF, 0xE6E9, 0xE710, 0xE735, 
    0xE757, 0xE777, 0xE793, 0xE7AB, 0xE7C0, 0xE7D1, 0xE7DD, 0xE7E5, 0xE7E8, 
    0x9F49, 0x9F9C, 0xA08B, 0xA203, 0xA3F4, 0xA64D, 0xA8FC, 0xABF1, 0xAF1B, 
    0xB268, 0xB5CA, 0xB93B, 0xBCB7, 0xC03A, 0xC3C0, 0xC747, 0xCAC9, 0xCE44, 
    0xD1B4, 0xD514, 0xD862, 0xDB9A, 0xDEB7, 0xE1B6, 0xE494, 0xE74D, 0xE9DC, 
    0xEC3F, 0xEE71, 0xF06F, 0xF235, 0xF3BF, 0xF50A, 0xF612, 0xF6D3, 0xF74A, 
    0xF772, 0xF73F, 0xF6A9, 0xF5B6, 0xF46C, 0xF2D1, 0xF0EA, 0xEEBE, 0xEC52, 
    0xE9AC, 0xE6D1, 0xE3C8, 0xE097, 0xDD42, 0xD9D1, 0xD649, 0xD2AF, 0xCF09, 
    0xCB5E, 0xC7B2, 0xC40D, 0xC073, 0xBCEA, 0xB979, 0xB624, 0xB2F3, 0xAFEA, 
    0xAD10, 0xAA69, 0xA7FD, 0xA5D1, 0xA3EA, 0xA24F, 0xA105, 0xA012, 0x9F7D, 
    0x9F49, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 
    0xFFFB, 0xFFF9, 0xFFF6, 0xFFF3, 0xFFEF, 0xFFEA, 0xFFE5, 0xFFDF, 0xFFD8, 
    0xFFD1, 0xFFCA, 0xFFC3, 0xFFBB, 0xFFB3, 0xFFAC, 0xFFA4, 0xFF9C, 0xFF95, 
    0xFF8E, 0xFF87, 0xFF80, 0xFF7A, 0xFF75, 0xFF70, 0xFF6C, 0xFF69, 0xFF66, 
    0xFF65, 0xFF64, 0xFF64, 0xFF66, 0xFF67, 0xFF69, 0xFF6C, 0xFF70, 0xFF73, 
    0xFF78, 0xFF7C, 0xFF81, 0xFF87, 0xFF8C, 0xFF92, 0xFF98, 0xFF9E, 0xFFA5, 
    0xFFAB, 0xFFB2, 0xFFB8, 0xFFBE, 0xFFC5, 0xFFCB, 0xFFD1, 0xFFD7, 0xFFDC, 
    0xFFE2, 0xFFE7, 0xFFEB, 0xFFF0, 0xFFF4, 0xFFF7, 0xFFFA, 0xFFFC, 0xFFFE, 
    0xFFFF, 0x0000, 0x0000, 0xFFFE, 0xFFFD, 0xFFFB, 0xFFF8, 0xFFF5, 0xFFF1, 
    0xFFED, 0xFFE9, 0xFFE5, 0xFFE2, 0xFFDE, 0xFFDB, 0xFFD8, 0xFFD5, 0xFFD2, 
    0xFFCF, 0xFFCD, 0xFFCB, 0xFFC9, 0xFFC7, 0xFFC5, 0xFFC4, 0xFFC2, 0xFFC1, 
    0xFFC0, 0xFFBF, 0xFFBE, 0xFFBD, 0xFFBC, 0xFFBC, 0xFFBB, 0xFFBB, 0xFFBB, 
    0xFFBA, 0xFFBA, 0xFFBA, 0xFFBA, 0xFFBB, 0xFFBC, 0xFFBD, 0xFFBE, 0xFFBF, 
    0xFFC1, 0xFFC3, 0xFFC5, 0xFFC7, 0xFFCA, 0xFFCC, 0xFFCF, 0xFFD1, 0xFFD4, 
    0xFFD7, 0xFFDA, 0xFFDD, 0xFFE0, 0xFFE2, 0xFFE5, 0xFFE8, 0xFFEB, 0xFFED, 
    0xFFF0, 0xFFF2, 0xFFF4, 0xFFF6, 0xFFF8, 0xFFFA, 0xFFFB, 0xFFFD, 0xFFFE, 
    0xFFFE, 0xFFFF, 0x0000, 0xE380, 0xE2BD, 0xE0B1, 0xDDBA, 0xDA37, 0xD684, 
    0xD301, 0xD00A, 0xCDFE, 0xCD3A, 0xCD6B, 0xCDF7, 0xCED8, 0xD006, 0xD17A, 
    0xD32D, 0xD516, 0xD730, 0xD972, 0xDBD5, 0xDE51, 0xE0E1, 0xE37B, 0xE619, 
    0xE8B3, 0xEB42, 0xEDBF, 0xF022, 0xF263, 0xF47D, 0xF667, 0xF819, 0xF98D, 
    0xFABB, 0xFB9C, 0xFC28, 0xFC59, 0xFC4A, 0xFC20, 0xFBDC, 0xFB7F, 0xFB0B, 
    0xFA82, 0xF9E5, 0xF936, 0xF877, 0xF7A9, 0xF6CE, 0xF5E8, 0xF4F8, 0xF3FF, 
    0xF300, 0xF1FC, 0xF0F5, 0xEFED, 0xEEE4, 0xEDDD, 0xECD9, 0xEBDA, 0xEAE2, 
    0xE9F1, 0xE90B, 0xE830, 0xE762, 0xE6A3, 0xE5F4, 0xE557, 0xE4CE, 0xE45A, 
    0xE3FD, 0xE3B9, 0xE38F, 0xE380, 0x01CB, 0x01CB, 0x01CB, 0x01CA, 0x01CA, 
    0x01C9, 0x01C8, 0x01C6, 0x01C4, 0x01C2, 0x01BE, 0x01BA, 0x01B5, 0x01B0, 
    0x01A9, 0x01A1, 0x0198, 0x018E, 0x0183, 0x0176, 0x0168, 0x0158, 0x0147, 
    0x0134, 0x0120, 0x010A, 0x00F1, 0x00D7, 0x00BB, 0x009D, 0x007D, 0x005A, 
    0x0036, 0x000E, 0xFFE4, 0xFFB8, 0xFF89, 0xFF4C, 0xFEF9, 0xFE99, 0xFE32, 
    0xFDCE, 0xFD72, 0xFD27, 0xFCF4, 0xFCE2, 0xFCE7, 0xFCF5, 0xFD0D, 0xFD2C, 
    0xFD53, 0xFD80, 0xFDB3, 0xFDEB, 0xFE27, 0xFE67, 0xFEA9, 0xFEED, 0xFF33, 
    0xFF79, 0xFFBE, 0x0003, 0x0045, 0x0085, 0x00C1, 0x00F9, 0x012C, 0x0159, 
    0x0180, 0x01A0, 0x01B7, 0x01C6, 0x01CB, 0xF9BB, 0xF9BB, 0xF9BA, 0xF9BA, 
    0xF9B9, 0xF9B8, 0xF9B6, 0xF9B5, 0xF9B3, 0xF9B1, 0xF9AF, 0xF9AD, 0xF9AB, 
    0xF9A9, 0xF9A7, 0xF9A4, 0xF9A2, 0xF99F, 0xF99D, 0xF99A, 0xF998, 0xF995, 
    0xF993, 0xF991, 0xF98E, 0xF98C, 0xF98A, 0xF988, 0xF987, 0xF985, 0xF983, 
    0xF982, 0xF981, 0xF980, 0xF980, 0xF97F, 0xF97F, 0xF986, 0xF99A, 0xF9B6, 
    0xF9D7, 0xF9FA, 0xFA1B, 0xFA37, 0xFA4A, 0xFA52, 0xFA51, 0xFA4F, 0xFA4C, 
    0xFA49, 0xFA44, 0xFA3E, 0xFA38, 0xFA32, 0xFA2A, 0xFA23, 0xFA1B, 0xFA13, 
    0xFA0A, 0xFA02, 0xF9FA, 0xF9F1, 0xF9E9, 0xF9E2, 0xF9DB, 0xF9D4, 0xF9CE, 
    0xF9C8, 0xF9C4, 0xF9C0, 0xF9BD, 0xF9BB, 0xE223, 0xE223, 0xE224, 0xE225, 
    0xE228, 0xE22D, 0xE234, 0xE23E, 0xE24B, 0xE25C, 0xE271, 0xE28B, 0xE2AB, 
    0xE2CF, 0xE2FA, 0xE32C, 0xE364, 0xE3A4, 0xE3EC, 0xE43D, 0xE496, 0xE4F9, 
    0xE566, 0xE5DD, 0xE65F, 0xE6EC, 0xE785, 0xE82B, 0xE8DD, 0xE99C, 0xEA69, 
    0xEB43, 0xEC2D, 0xED25, 0xEE2D, 0xEF46, 0xF06E, 0xF1FA, 0xF418, 0xF695, 
    0xF93E, 0xFBDF, 0xFE45, 0x003C, 0x018F, 0x020B, 0x01EA, 0x018B, 0x00F3, 
    0x0026, 0xFF2A, 0xFE03, 0xFCB8, 0xFB4C, 0xF9C5, 0xF827, 0xF678, 0xF4BC, 
    0xF2F9, 0xF134, 0xEF71, 0xEDB5, 0xEC06, 0xEA68, 0xE8E1, 0xE775, 0xE62A, 
    0xE504, 0xE408, 0xE33B, 0xE2A3, 0xE244, 0xE223, 0xFFFE, 0x0001, 0xC170, 
    0xFFD3, 0xFFDA, 0xFFEE, 0x0011, 0x003D, 0x0076, 0x00B8, 0x0104, 0x0158, 
    0x01B5, 0x0218, 0x0282, 0x02F1, 0x0366, 0x03DE, 0x0459, 0x04D7, 0x0556, 
    0x05D6, 0x0656, 0x06D5, 0x0753, 0x07CE, 0x0846, 0x08BA, 0x092A, 0x0994, 
    0x09F7, 0x0A54, 0x0AA8, 0x0AF4, 0x0B36, 0x0B6E, 0x0B9B, 0x0BBC, 0x0BD1, 
    0x0BD8, 0x0BD1, 0x0BBC, 0x0B9B, 0x0B6E, 0x0B36, 0x0AF4, 0x0AA8, 0x0A54, 
    0x09F7, 0x0994, 0x092A, 0x08BA, 0x0846, 0x07CE, 0x0753, 0x06D5, 0x0656, 
    0x05D6, 0x0556, 0x04D7, 0x0459, 0x03DE, 0x0366, 0x02F1, 0x0282, 0x0218, 
    0x01B5, 0x0158, 0x0104, 0x00B8, 0x0076, 0x003D, 0x0011, 0xFFEE, 0xFFDA, 
    0xFFD3, 0x1C74, 0x1C72, 0x1C6B, 0x1C60, 0x1C51, 0x1C3F, 0x1C29, 0x1C10, 
    0x1BF4, 0x1BD5, 0x1BB5, 0x1B92, 0x1B6D, 0x1B46, 0x1B1F, 0x1AF6, 0x1ACD, 
    0x1AA3, 0x1A78, 0x1A4E, 0x1A24, 0x19FA, 0x19D2, 0x19AA, 0x1984, 0x195F, 
    0x193C, 0x191B, 0x18FD, 0x18E1, 0x18C8, 0x18B2, 0x189F, 0x1890, 0x1885, 
    0x187F, 0x187C, 0x187F, 0x1885, 0x1890, 0x189F, 0x18B2, 0x18C8, 0x18E1, 
    0x18FD, 0x191B, 0x193C, 0x195F, 0x1984, 0x19AA, 0x19D2, 0x19FA, 0x1A24, 
    0x1A4E, 0x1A78, 0x1AA3, 0x1ACD, 0x1AF6, 0x1B1F, 0x1B46, 0x1B6D, 0x1B92, 
    0x1BB5, 0x1BD5, 0x1BF4, 0x1C10, 0x1C29, 0x1C3F, 0x1C51, 0x1C60, 0x1C6B, 
    0x1C72, 0x1C74, 0xFE3B, 0xFE06, 0xFD6A, 0xFC6D, 0xFB16, 0xF96A, 0xF770, 
    0xF52D, 0xF2A8, 0xEFE6, 0xECEE, 0xE9C6, 0xE673, 0xE2FC, 0xDF67, 0xDBBA, 
    0xD7FB, 0xD42F, 0xD05E, 0xCC8D, 0xC8C1, 0xC502, 0xC155, 0xBDC0, 0xBA49, 
    0xB6F6, 0xB3CE, 0xB0D6, 0xAE14, 0xAB8F, 0xA94C, 0xA752, 0xA5A6, 0xA44F, 
    0xA352, 0xA2B6, 0xA281, 0xA2B6, 0xA352, 0xA44F, 0xA5A6, 0xA752, 0xA94C, 
    0xAB8F, 0xAE14, 0xB0D6, 0xB3CE, 0xB6F6, 0xBA49, 0xBDC0, 0xC155, 0xC502, 
    0xC8C1, 0xCC8D, 0xD05E, 0xD42F, 0xD7FB, 0xDBBA, 0xDF67, 0xE2FC, 0xE673, 
    0xE9C6, 0xECEE, 0xEFE6, 0xF2A8, 0xF52D, 0xF770, 0xF96A, 0xFB16, 0xFC6D, 
    0xFD6A, 0xFE06, 0xFE3B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFF38, 0xFF37, 0xFF34, 0xFF2D, 0xFF22, 
    0xFF12, 0xFEFC, 0xFEDF, 0xFEBA, 0xFE8D, 0xFE56, 0xFE15, 0xFDC9, 0xFD71, 
    0xFD0C, 0xFC99, 0xFC18, 0xFB87, 0xFAE5, 0xFA33, 0xF96E, 0xF897, 0xF7AB, 
    0xF6AB, 0xF596, 0xF46A, 0xF326, 0xF1CB, 0xF057, 0xEEC8, 0xED1F, 0xEB5A, 
    0xE979, 0xE77B, 0xE55E, 0xE322, 0xE0C7, 0xDE4E, 0xDBCB, 0xD955, 0xD702, 
    0xD4E8, 0xD31E, 0xD1BB, 0xD0D6, 0xD084, 0xD0B4, 0xD13F, 0xD21E, 0xD34A, 
    0xD4BA, 0xD669, 0xD84E, 0xDA63, 0xDCA0, 0xDEFE, 0xE175, 0xE3FE, 0xE692, 
    0xE92A, 0xEBBF, 0xEE48, 0xF0BF, 0xF31D, 0xF559, 0xF76E, 0xF953, 0xFB02, 
    0xFC73, 0xFD9E, 0xFE7D, 0xFF08, 0xFF38, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xED8B, 0xEE25, 0xEFC3, 0xF219, 0xF4DF, 0xF7CA, 0xFA8F, 0xFCE6, 0xFE84, 
    0xFF1E, 0xFF04, 0xFEB9, 0xFE42, 0xFDA1, 0xFCDB, 0xFBF3, 0xFAEF, 0xF9D0, 
    0xF89D, 0xF757, 0xF604, 0xF4A8, 0xF345, 0xF1E0, 0xF07E, 0xEF21, 0xEDCE, 
    0xEC88, 0xEB55, 0xEA37, 0xE932, 0xE84B, 0xE784, 0xE6E4, 0xE66C, 0xE621, 
    0xE607, 0xE60F, 0xE624, 0xE645, 0xE671, 0xE6A6, 0xE6E2, 0xE725, 0xE76C, 
    0xE7B5, 0xE800, 0xE84C, 0xE899, 0xE8E6, 0xE933, 0xE980, 0xE9CC, 0xEA18, 
    0xEA62, 0xEAAB, 0xEAF3, 0xEB38, 0xEB7B, 0xEBBB, 0xEBF9, 0xEC33, 0xEC6A, 
    0xEC9D, 0xECCC, 0xECF6, 0xED1C, 0xED3D, 0xED58, 0xED6E, 0xED7E, 0xED88, 
    0xED8B, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x0B9B, 0x0B7C, 0x0B25, 0x0A9D, 0x09EB, 
    0x0916, 0x0826, 0x0722, 0x0612, 0x04FB, 0x03E6, 0x02D7, 0x01D3, 0x00DD, 
    0xFFF9, 0xFF2D, 0xFE7C, 0xFDEC, 0xFD7F, 0xFD3B, 0xFD23, 0xFD26, 0xFD2D, 
    0xFD38, 0xFD46, 0xFD57, 0xFD6A, 0xFD7E, 0xFD92, 0xFDA7, 0xFDBB, 0xFDCE, 
    0xFDDF, 0xFDED, 0xFDF8, 0xFDFF, 0xFE02, 0xFDFB, 0xFDE7, 0xFDCB, 0xFDAA, 
    0xFD87, 0xFD66, 0xFD4A, 0xFD37, 0xFD2F, 0xFD30, 0xFD31, 0xFD35, 0xFD3D, 
    0xFD4A, 0xFD5E, 0xFD79, 0xFD9D, 0xFDCB, 0xFE05, 0xFE4C, 0xFEAF, 0xFF3B, 
    0xFFEC, 0x00BD, 0x01A8, 0x02A9, 0x03BC, 0x04DC, 0x0605, 0x0730, 0x0852, 
    0x095D, 0x0A44, 0x0AFA, 0x0B70, 0x0B9B, 0xF786, 0xF77C, 0xF760, 0xF737, 
    0xF707, 0xF6D4, 0xF6A4, 0xF67B, 0xF65F, 0xF655, 0xF690, 0xF733, 0xF826, 
    0xF952, 0xFAA1, 0xFBFC, 0xFD4B, 0xFE77, 0xFF6A, 0x000E, 0x0049, 0x0008, 
    0xFF4D, 0xFE2E, 0xFCB8, 0xFAFF, 0xF911, 0xF702, 0xF4E2, 0xF2C2, 0xF0B2, 
    0xEEC5, 0xED0C, 0xEB96, 0xEA77, 0xE9BD, 0xE97C, 0xE9B4, 0xEA54, 0xEB4A, 
    0xEC88, 0xEDFE, 0xEF9C, 0xF151, 0xF310, 0xF4C7, 0xF669, 0xF7F1, 0xF95D, 
    0xFAA9, 0xFBD2, 0xFCD5, 0xFDB0, 0xFE60, 0xFEE1, 0xFF30, 0xFF4B, 0xFF03, 
    0xFE41, 0xFD29, 0xFBDC, 0xFA7E, 0xF932, 0xF819, 0xF758, 0xF70F, 0xF716, 
    0xF727, 0xF73E, 0xF757, 0xF76F, 0xF77F, 0xF786, 0xDA3E, 0xDA3A, 0xDA1B, 
    0xD9C8, 0xD926, 0xD81C, 0xD68D, 0xD462, 0xD17E, 0xCDC9, 0xC8D4, 0xC284, 
    0xBB34, 0xB343, 0xAB0E, 0xA2F1, 0x9B4B, 0x9479, 0x8ED7, 0x8AC4, 0x889C, 
    0x879A, 0x86B8, 0x85F4, 0x854C, 0x84BD, 0x8447, 0x83E6, 0x8398, 0x835C, 
    0x832E, 0x830D, 0x82F8, 0x82EA, 0x82E4, 0x82E1, 0x82E1, 0x833F, 0x8443, 
    0x85CC, 0x87BA, 0x89EA, 0x8C3C, 0x8E8F, 0x90C1, 0x92B2, 0x944C, 0x95A2, 
    0x96D5, 0x9803, 0x994D, 0x9AD0, 0x9CAD, 0x9F04, 0xA1F2, 0xA598, 0xAA16, 
    0xAF77, 0xB57F, 0xBBDE, 0xC245, 0xC864, 0xCDEB, 0xD28C, 0xD5F6, 0xD7DA, 
    0xD8BD, 0xD95F, 0xD9CC, 0xDA0E, 0xDA30, 0xDA3D, 0xDA3E, 0xFFE6, 0xFFE1, 
    0xFFD3, 0xFFBC, 0xFF9E, 0xFF7A, 0xFF50, 0xFF23, 0xFEF2, 0xFEBF, 0xFE8C, 
    0xFE58, 0xFE25, 0xFDF4, 0xFDC7, 0xFD9D, 0xFD79, 0xFD5B, 0xFD44, 0xFD36, 
    0xFD31, 0xFD39, 0xFD50, 0xFD73, 0xFDA1, 0xFDD8, 0xFE14, 0xFE55, 0xFE98, 
    0xFEDB, 0xFF1C, 0xFF58, 0xFF8F, 0xFFBD, 0xFFE0, 0xFFF7, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFFA, 0xFFFA, 0xFFF9, 0xFFF9, 
    0xFFF8, 0xFFF9, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 
    0x0000, 0xFFFE, 0xFFFA, 0xFFF5, 0xFFF0, 0xFFEB, 0xFFE7, 0xFFE6, 0x0026, 
    0x0023, 0x001B, 0x000E, 0xFFFB, 0xFFE6, 0xFFCE, 0xFFB4, 0xFF98, 0xFF7A, 
    0xFF5C, 0xFF3E, 0xFF21, 0xFF04, 0xFEEA, 0xFED2, 0xFEBD, 0xFEAC, 0xFE9E, 
    0xFE96, 0xFE93, 0xFE97, 0xFEA3, 0xFEB5, 0xFECC, 0xFEE8, 0xFF06, 0xFF27, 
    0xFF49, 0xFF6B, 0xFF8C, 0xFFAB, 0xFFC6, 0xFFDD, 0xFFEF, 0xFFFB, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0001, 0x0002, 0x0004, 0x0007, 0x000A, 0x000D, 0x0010, 0x0013, 0x0015, 
    0x0016, 0x0017, 0x0016, 0x0014, 0x0011, 0x000D, 0x000A, 0x0006, 0x0003, 
    0x0001, 0x0000, 0x0002, 0x0008, 0x000F, 0x0017, 0x001E, 0x0024, 0x0026, 
    0x169C, 0x1708, 0x183C, 0x1A22, 0x1CA4, 0x1FAC, 0x2323, 0x26F3, 0x2B06, 
    0x2F46, 0x339B, 0x37F1, 0x3C31, 0x4043, 0x4414, 0x478B, 0x4A92, 0x4D14, 
    0x4EFB, 0x502F, 0x509A, 0x5087, 0x5047, 0x4FD3, 0x4F24, 0x4E32, 0x4CF7, 
    0x4B6A, 0x4985, 0x4740, 0x4493, 0x4177, 0x3DE4, 0x39D4, 0x353F, 0x301E, 
    0x2A68, 0x2425, 0x1D8F, 0x16EE, 0x108C, 0x0AB0, 0x05A3, 0x01AE, 0xFF18, 
    0xFE2C, 0xFF3F, 0x0232, 0x0699, 0x0C0A, 0x121B, 0x1861, 0x1E71, 0x23E2, 
    0x2849, 0x2B3B, 0x2C4E, 0x2AC9, 0x26B7, 0x20D2, 0x19D4, 0x127A, 0x0B7D, 
    0x0597, 0x0185, 0xFFFF, 0x0141, 0x047C, 0x08E6, 0x0DB6, 0x1221, 0x155C, 
    0x169C, 0x0064, 0x0065, 0x0068, 0x006D, 0x0073, 0x007B, 0x0083, 0x008D, 
    0x0097, 0x00A2, 0x00AC, 0x00B7, 0x00C2, 0x00CC, 0x00D6, 0x00DE, 0x00E6, 
    0x00EC, 0x00F1, 0x00F4, 0x00F5, 0x00F5, 0x00F5, 0x00F5, 0x00F5, 0x00F5, 
    0x00F5, 0x00F4, 0x00F4, 0x00F4, 0x00F3, 0x00F3, 0x00F2, 0x00F1, 0x00F1, 
    0x00F0, 0x00EE, 0x00EB, 0x00E4, 0x00DB, 0x00D0, 0x00C4, 0x00B9, 0x00B0, 
    0x00AA, 0x00A8, 0x00AA, 0x00AF, 0x00B6, 0x00BF, 0x00C9, 0x00D4, 0x00DE, 
    0x00E7, 0x00EE, 0x00F3, 0x00F5, 0x00EE, 0x00DD, 0x00C4, 0x00A7, 0x0088, 
    0x006A, 0x0051, 0x0040, 0x0039, 0x003C, 0x0042, 0x004A, 0x0053, 0x005C, 
    0x0062, 0x0064, 0xFEFB, 0xFEFC, 0xFEFF, 0xFF04, 0xFF0A, 0xFF12, 0xFF1B, 
    0xFF24, 0xFF2E, 0xFF39, 0xFF44, 0xFF4F, 0xFF59, 0xFF64, 0xFF6D, 0xFF76, 
    0xFF7D, 0xFF84, 0xFF88, 0xFF8B, 0xFF8C, 0xFF8C, 0xFF8C, 0xFF8C, 0xFF8B, 
    0xFF8A, 0xFF89, 0xFF87, 0xFF84, 0xFF82, 0xFF7E, 0xFF7B, 0xFF76, 0xFF71, 
    0xFF6B, 0xFF64, 0xFF5D, 0xFF54, 0xFF4B, 0xFF42, 0xFF3A, 0xFF32, 0xFF2B, 
    0xFF26, 0xFF22, 0xFF21, 0xFF23, 0xFF2A, 0xFF35, 0xFF41, 0xFF4F, 0xFF5E, 
    0xFF6C, 0xFF79, 0xFF83, 0xFF8A, 0xFF8C, 0xFF8A, 0xFF83, 0xFF78, 0xFF6A, 
    0xFF5B, 0xFF4A, 0xFF3A, 0xFF2B, 0xFF1D, 0xFF12, 0xFF0A, 0xFF04, 0xFF00, 
    0xFEFD, 0xFEFC, 0xFEFB, 0xDF8B, 0xDF47, 0xDE84, 0xDD50, 0xDBB9, 0xD9CD, 
    0xD79A, 0xD530, 0xD29A, 0xCFE9, 0xCD29, 0xCA69, 0xC7B8, 0xC522, 0xC2B7, 
    0xC084, 0xBE98, 0xBD00, 0xBBCB, 0xBB07, 0xBAC2, 0xBAC1, 0xBAC0, 0xBABF, 
    0xBABF, 0xBABE, 0xBABE, 0xBABD, 0xBABD, 0xBABD, 0xBABC, 0xBABC, 0xBABC, 
    0xBABC, 0xBABC, 0xBABC, 0xBABC, 0xBB4C, 0xBCCE, 0xBEFD, 0xC194, 0xC44D, 
    0xC6E4, 0xC913, 0xCA95, 0xCB25, 0xCAC4, 0xC9B8, 0xC827, 0xC638, 0xC411, 
    0xC1D6, 0xBFAF, 0xBDC0, 0xBC2F, 0xBB23, 0xBAC2, 0xBB05, 0xBBC9, 0xBD06, 
    0xBEB4, 0xC0CD, 0xC347, 0xC61B, 0xC942, 0xCCB4, 0xD060, 0xD417, 0xD7A0, 
    0xDAC2, 0xDD45, 0xDEF0, 0xDF8B, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x00FF, 0x0106, 
    0x0118, 0x0132, 0x0151, 0x0172, 0x0191, 0x01AB, 0x01BD, 0x01C4, 0x01BE, 
    0x01AF, 0x0196, 0x0174, 0x0149, 0x0117, 0x00DD, 0x009C, 0x0055, 0x0009, 
    0xFFB6, 0xFF5F, 0xFF00, 0xFE97, 0xFE21, 0xFD9A, 0xFD00, 0xFC4F, 0xFB85, 
    0xFA9F, 0xF999, 0xF877, 0xF74D, 0xF636, 0xF54E, 0xF4AF, 0xF474, 0xF48A, 
    0xF4CA, 0xF52F, 0xF5B3, 0xF652, 0xF706, 0xF7CA, 0xF899, 0xF96E, 0xFA44, 
    0xFB18, 0xFBE7, 0xFCAD, 0xFD68, 0xFE14, 0xFEB0, 0xFF36, 0xFFA5, 0xFFF9, 
    0x0031, 0x0055, 0x0075, 0x0090, 0x00A8, 0x00BC, 0x00CD, 0x00DA, 0x00E5, 
    0x00EE, 0x00F4, 0x00F9, 0x00FC, 0x00FE, 0x00FF, 0x18F2, 0x18B8, 0x1814, 
    0x1714, 0x15C8, 0x143E, 0x1284, 0x10AA, 0x0EBE, 0x0CCE, 0x0AE9, 0x0914, 
    0x0758, 0x05B9, 0x043E, 0x02EC, 0x01CA, 0x00DF, 0x002F, 0xFFBF, 0xFF99, 
    0xFFD6, 0x007D, 0x0170, 0x0298, 0x03DA, 0x051C, 0x0644, 0x0738, 0x07DD, 
    0x081A, 0x07F6, 0x079C, 0x0728, 0x06B4, 0x065A, 0x0636, 0x0641, 0x065E, 
    0x0687, 0x06B8, 0x06EC, 0x071D, 0x0746, 0x0762, 0x076D, 0x073C, 0x06B7, 
    0x05EF, 0x04F9, 0x03E6, 0x02C9, 0x01B6, 0x00C0, 0xFFF7, 0xFF71, 0xFF41, 
    0xFF8B, 0x005C, 0x01A1, 0x0345, 0x0537, 0x0762, 0x09B4, 0x0C1A, 0x0E7F, 
    0x10D1, 0x12FD, 0x14EE, 0x1693, 0x17D7, 0x18A8, 0x18F2, 0x820B, 0x825E, 
    0x8346, 0x84AB, 0x8674, 0x888A, 0x8AD5, 0x8D3B, 0x8FA5, 0x91FA, 0x942A, 
    0x963A, 0x983B, 0x9A3A, 0x9C45, 0x9E6C, 0xA0BB, 0xA342, 0xA60F, 0xA930, 
    0xACB3, 0xB0A0, 0xB4DE, 0xB950, 0xBDD5, 0xC24F, 0xC6A0, 0xCAA7, 0xCE46, 
    0xD15F, 0xD3D1, 0xD593, 0xD6C0, 0xD777, 0xD7D5, 0xD7F7, 0xD7FC, 0xD7F8, 
    0xD7DF, 0xD798, 0xD70F, 0xD62D, 0xD4DC, 0xD306, 0xD094, 0xCD70, 0xC8F5, 
    0xC2D2, 0xBB74, 0xB347, 0xAAB6, 0xA22D, 0x9A17, 0x92E0, 0x8CF4, 0x88BF, 
    0x86AC, 0x85DB, 0x8525, 0x8487, 0x83FF, 0x838C, 0x832D, 0x82DE, 0x829F, 
    0x826F, 0x824A, 0x8230, 0x821E, 0x8213, 0x820E, 0x820C, 0x820B, 0xFFE8, 
    0xFFEB, 0xFFF2, 0xFFFE, 0x000C, 0x001A, 0x0027, 0x0032, 0x003A, 0x003D, 
    0x003B, 0x0036, 0x002E, 0x0024, 0x0019, 0x000D, 0x0002, 0xFFF7, 0xFFEF, 
    0xFFEA, 0xFFE8, 0xFFE9, 0xFFEB, 0xFFED, 0xFFF1, 0xFFF4, 0xFFF8, 0xFFFB, 
    0xFFFE, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0xFFFF, 
    0xFFFE, 0xFFFC, 0xFFFA, 0xFFF8, 0xFFF5, 0xFFF1, 0xFFEE, 0xFFEA, 0xFFE6, 
    0xFFE2, 0xFFDE, 0xFFDB, 0xFFD7, 0xFFD4, 0xFFD1, 0xFFCE, 0xFFCC, 0xFFCA, 
    0xFFC9, 0xFFC9, 0xFFC9, 0xFFCA, 0xFFCC, 0xFFCE, 0xFFD0, 0xFFD3, 0xFFD6, 
    0xFFD8, 0xFFDB, 0xFFDE, 0xFFE1, 0xFFE3, 0xFFE5, 0xFFE7, 0xFFE8, 0xFF99, 
    0xFF9A, 0xFF9C, 0xFFA0, 0xFFA5, 0xFFAA, 0xFFB0, 0xFFB5, 0xFFBB, 0xFFBF, 
    0xFFC2, 0xFFC5, 0xFFC7, 0xFFC8, 0xFFC9, 0xFFC9, 0xFFCA, 0xFFCA, 0xFFCB, 
    0xFFCC, 0xFFCD, 0xFFCF, 0xFFD2, 0xFFD5, 0xFFD9, 0xFFDD, 0xFFE1, 0xFFE5, 
    0xFFE9, 0xFFEE, 0xFFF1, 0xFFF5, 0xFFF8, 0xFFFB, 0xFFFD, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFFB, 0xFFFA, 0xFFF9, 
    0xFFF7, 0xFFF6, 0xFFF4, 0xFFF0, 0xFFEB, 0xFFE5, 0xFFDD, 0xFFD6, 0xFFCD, 
    0xFFC5, 0xFFBD, 0xFFB4, 0xFFAD, 0xFFA6, 0xFFA1, 0xFF9C, 0xFF9A, 0xFF99, 
    0x281E, 0x26B8, 0x22F7, 0x1D87, 0x1716, 0x104E, 0x09DC, 0x046D, 0x00AC, 
    0xFF44, 0x0043, 0x02FC, 0x070E, 0x0C16, 0x11B1, 0x177E, 0x1D19, 0x2220, 
    0x2632, 0x28EB, 0x29E9, 0x28E6, 0x2624, 0x2214, 0x1D25, 0x17C7, 0x1269, 
    0x0D7B, 0x096B, 0x06A9, 0x05A5, 0x0678, 0x08BA, 0x0C1C, 0x104C, 0x14FC, 
    0x19D9, 0x1EA2, 0x2346, 0x27C2, 0x2C14, 0x3039, 0x342E, 0x37F0, 0x3B7C, 
    0x3ED0, 0x41E8, 0x44C2, 0x475C, 0x49B2, 0x4BC1, 0x4D87, 0x4F00, 0x502B, 
    0x5103, 0x5188, 0x51B4, 0x513D, 0x4FEB, 0x4DDE, 0x4B35, 0x480F, 0x448C, 
    0x40CA, 0x3CE9, 0x3909, 0x3547, 0x31C4, 0x2E9E, 0x2BF5, 0x29E8, 0x2896, 
    0x281E, 0xFEE9, 0xFEF2, 0xFF0C, 0xFF31, 0xFF5E, 0xFF8C, 0xFFB8, 0xFFDE, 
    0xFFF7, 0x0002, 0xFFFC, 0xFFEF, 0xFFDB, 0xFFC2, 0xFFA7, 0xFF8B, 0xFF6F, 
    0xFF57, 0xFF43, 0xFF35, 0xFF31, 0xFF31, 0xFF34, 0xFF3A, 0xFF45, 0xFF55, 
    0xFF6C, 0xFF8A, 0xFFB2, 0xFFE3, 0x0021, 0x0068, 0x00B4, 0x00FC, 0x0139, 
    0x0164, 0x0174, 0x0170, 0x0166, 0x0156, 0x0140, 0x0126, 0x0108, 0x00E6, 
    0x00C2, 0x009C, 0x0074, 0x004C, 0x0024, 0xFFFB, 0xFFD5, 0xFFB1, 0xFF8F, 
    0xFF71, 0xFF57, 0xFF41, 0xFF31, 0xFF24, 0xFF19, 0xFF0F, 0xFF07, 0xFF00, 
    0xFEFA, 0xFEF5, 0xFEF2, 0xFEEF, 0xFEED, 0xFEEB, 0xFEEA, 0xFEE9, 0x0218, 
    0x0209, 0x01E2, 0x01AA, 0x0168, 0x0122, 0x00DF, 0x00A7, 0x0080, 0x0072, 
    0x0079, 0x008C, 0x00A8, 0x00CD, 0x00F6, 0x0121, 0x014D, 0x0177, 0x019D, 
    0x01BB, 0x01D0, 0x01DF, 0x01EA, 0x01F3, 0x01FA, 0x01FE, 0x0202, 0x0204, 
    0x0205, 0x0205, 0x0205, 0x0202, 0x01FB, 0x01F2, 0x01E8, 0x01E0, 0x01DC, 
    0x01DA, 0x01D9, 0x01D7, 0x01D6, 0x01D5, 0x01D4, 0x01D3, 0x01D3, 0x01D2, 
    0x01D2, 0x01D1, 0x01D1, 0x01D1, 0x01D1, 0x01D0, 0x01D0, 0x01D0, 0x01D0, 
    0x01D0, 0x01D0, 0x01D1, 0x01D3, 0x01D7, 0x01DB, 0x01E1, 0x01E7, 0x01ED, 
    0x01F4, 0x01FB, 0x0201, 0x0207, 0x020D, 0x0211, 0x0215, 0x0217, 0x0218, 
    0xB5C9, 0xB66E, 0xB82A, 0xBAAC, 0xBDA5, 0xC0C5, 0xC3BE, 0xC640, 0xC7FC, 
    0xC8A1, 0xC840, 0xC737, 0xC5AA, 0xC3C0, 0xC19D, 0xBF68, 0xBD46, 0xBB5C, 
    0xB9CF, 0xB8C6, 0xB865, 0xB86A, 0xB88B, 0xB8E2, 0xB989, 0xBA99, 0xBC2D, 
    0xBE5F, 0xC148, 0xC502, 0xC9A8, 0xCF34, 0xD525, 0xDADB, 0xDFB6, 0xE315, 
    0xE458, 0xE40D, 0xE334, 0xE1DD, 0xE016, 0xDDF0, 0xDB78, 0xD8BD, 0xD5D0, 
    0xD2BE, 0xCF97, 0xCC6A, 0xC946, 0xC639, 0xC353, 0xC0A3, 0xBE37, 0xBC20, 
    0xBA6B, 0xB927, 0xB865, 0xB7EF, 0xB788, 0xB72F, 0xB6E3, 0xB6A2, 0xB66C, 
    0xB640, 0xB61C, 0xB601, 0xB5EC, 0xB5DD, 0xB5D3, 0xB5CD, 0xB5CA, 0xB5C9, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x1891, 0x1872, 0x1818, 0x1785, 0x16BF, 0x15C7, 0x14A1, 
    0x1352, 0x11DB, 0x1043, 0x0E8B, 0x0CB7, 0x0ACA, 0x08C7, 0x06B2, 0x048E, 
    0x025F, 0x002A, 0xFDF1, 0xFBBA, 0xF988, 0xF75F, 0xF541, 0xF332, 0xF133, 
    0xEF46, 0xED6C, 0xEBA8, 0xE9FA, 0xE862, 0xE6E2, 0xE56B, 0xE403, 0xE2C8, 
    0xE1D7, 0xE140, 0xE10C, 0xE11A, 0xE145, 0xE191, 0xE200, 0xE296, 0xE355, 
    0xE440, 0xE55C, 0xE6AB, 0xE82F, 0xE9E5, 0xEBC9, 0xEDD4, 0xF001, 0xF24A, 
    0xF4A9, 0xF717, 0xF98D, 0xFC07, 0xFE7E, 0x00EE, 0x0350, 0x05A2, 0x07DF, 
    0x0A04, 0x0C0F, 0x0DFB, 0x0FC5, 0x116C, 0x12FF, 0x1483, 0x15E3, 0x1707, 
    0x17DF, 0x1864, 0x1891, 0x0853, 0x0846, 0x0821, 0x07E7, 0x079C, 0x0742, 
    0x06DD, 0x066F, 0x05FA, 0x0581, 0x0506, 0x048A, 0x0409, 0x0380, 0x02EC, 
    0x024C, 0x019E, 0x00E1, 0x0015, 0xFF3B, 0xFE54, 0xFD63, 0xFC6A, 0xFB6D, 
    0xFA6D, 0xF971, 0xF879, 0xF78C, 0xF6AC, 0xF5DC, 0xF520, 0xF4B0, 0xF4B5, 
    0xF50C, 0xF58A, 0xF5FB, 0xF62C, 0xF630, 0xF63A, 0xF64C, 0xF666, 0xF689, 
    0xF6B5, 0xF6EE, 0xF733, 0xF788, 0xF7ED, 0xF863, 0xF8EC, 0xF98A, 0xFA3F, 
    0xFB0C, 0xFBF0, 0xFCEB, 0xFDFA, 0xFF19, 0x0047, 0x017C, 0x02B3, 0x03E7, 
    0x0513, 0x0631, 0x073C, 0x082E, 0x0904, 0x09B9, 0x0A28, 0x0A34, 0x09F0, 
    0x0977, 0x08EF, 0x0880, 0x0853, 0x132B, 0x132F, 0x1337, 0x1341, 0x134A, 
    0x1350, 0x134E, 0x1343, 0x132A, 0x1301, 0x12BB, 0x1253, 0x11CB, 0x1129, 
    0x1072, 0x0FAA, 0x0ED7, 0x0DFD, 0x0D24, 0x0C4F, 0x0B84, 0x0AC8, 0x0A1F, 
    0x098E, 0x0917, 0x08BF, 0x0886, 0x0871, 0x0880, 0x08B6, 0x0914, 0x0A35, 
    0x0C51, 0x0ED6, 0x113B, 0x1302, 0x13B4, 0x13B0, 0x13A3, 0x138B, 0x1366, 
    0x1331, 0x12EC, 0x1294, 0x1228, 0x11A6, 0x1108, 0x104C, 0x0F78, 0x0E90, 
    0x0D9C, 0x0CA0, 0x0BA4, 0x0AAD, 0x09C1, 0x08E6, 0x081F, 0x0772, 0x06E1, 
    0x066E, 0x061B, 0x05E8, 0x05D5, 0x05E1, 0x060D, 0x0655, 0x0752, 0x094D, 
    0x0BD5, 0x0E7B, 0x10D6, 0x1286, 0x132B, 
    },
    {
    0x0001, 0x0000, 0x0048, 0x0001, 0x0001, 0x0049, 0x0001, 0x004A, 0x0001, 
    0x004B, 0x0001, 0x004C, 0x0049, 0x004D, 0x0048, 0x0096, 0x0049, 0x00DE, 
    0x0049, 0x0127, 0x0049, 0x0170, 0x0049, 0x01B9, 0x0049, 0x0202, 0x0049, 
    0x024B, 0x0049, 0x0294, 0x0001, 0x02DD, 0x0001, 0x02DE, 0x0001, 0x02DF, 
    0x0049, 0x02E0, 0x0049, 0x0329, 0x0049, 0x0372, 0x0049, 0x03BB, 0x0049, 
    0x0404, 0x0049, 0x044D, 0x0049, 0x0496, 0x0048, 0x04DF, 0x0049, 0x0527, 
    0x0001, 0x0570, 0x0001, 0x0571, 0x0001, 0x0572, 0x0049, 0x0573, 0x0049, 
    0x05BC, 0x0049, 0x0605, 0x0036, 0x064E, 0x0049, 0x0684, 0x0049, 0x06CD, 
    0x0049, 0x0716, 0x0042, 0x075F, 0x0049, 0x07A1, 0x0049, 0x07EA, 0x0049, 
    0x0833, 0x0001, 0x087C, 0x0049, 0x087D, 0x0049, 0x08C6, 0x0049, 0x090F, 
    0x0049, 0x0958, 0x0049, 0x09A1, 0x0049, 0x09EA, 0x0049, 0x0A33, 0x0049, 
    0x0A7C, 0x0049, 0x0AC5, 0x0049, 0x0B0E, 0x0049, 0x0B57, 0x0001, 0x0BA0, 
    0x0047, 0x0BA1, 0x0049, 0x0BE8, 0x0049, 0x0C31, 0x0048, 0x0C7A, 0x0049, 
    0x0CC2, 0x0049, 0x0D0B, 0x0046, 0x0D54, 0x0049, 0x0D9A, 0x0048, 0x0DE3, 
    0x0049, 0x0E2B, 0x0048, 0x0E74, 0x0049, 0x0EBC, 0x0049, 0x0F05, 0x0049, 
    0x0F4E, 0x0049, 0x0F97, 
})

smlua_anim_util_register_animation("MILNE_ANIM_DYING_ON_BACK",
    1,
    0,
    0,
    0,
    63,
    {0x0000, 0xFFB6, 0xFFDB, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x02FE, 0x035D, 0x03BD, 0x041E, 0x047F, 0x04DF, 
    0x053E, 0x059B, 0x05F4, 0x064B, 0x069D, 0x06EA, 0x0732, 0x0774, 0x07AF, 
    0x07E2, 0x080D, 0x0832, 0x0852, 0x086B, 0x0880, 0x0891, 0x089D, 0x08A6, 
    0x08AC, 0x08B0, 0x08B2, 0x08B2, 0x08B2, 0x08B1, 0x08B0, 0x08AF, 0x08B1, 
    0x08B7, 0x08BF, 0x08C5, 0x08C9, 0x08C7, 0x08BF, 0x08AD, 0x0891, 0x0866, 
    0x082D, 0x07E2, 0x0783, 0x0712, 0x0692, 0x0605, 0x056C, 0x04CC, 0x0426, 
    0x037D, 0x02D3, 0x022A, 0x0186, 0x00E9, 0x0055, 0xFFCD, 0xFF52, 0xFEE9, 
    0xFE92, 0xFE51, 0xFE29, 0xFE1B, 0x0480, 0x0252, 0x0000, 0xFFF3, 0x0097, 
    0x00F9, 0x00BD, 0x004A, 0xFFD5, 0xFF92, 0xFFA4, 0xFFE8, 0x0028, 0x002C, 
    0xFFC9, 0xFF28, 0xFE88, 0xFE2D, 0xFE0D, 0xFDF2, 0xFDDD, 0xFDCD, 0xFDC0, 
    0xFDB8, 0xFDB2, 0xFDAF, 0xFDAD, 0xFDAE, 0xFDAF, 0xFDB0, 0xFDB1, 0xFDB2, 
    0xFDA3, 0xFE2D, 0xFF88, 0x011F, 0x02D1, 0x047E, 0x0608, 0x074F, 0x076F, 
    0x0701, 0x0731, 0x074F, 0x072A, 0x0700, 0x06D2, 0x06A0, 0x066C, 0x0636, 
    0x05FE, 0x05C6, 0x058F, 0x0558, 0x0523, 0x04F1, 0x04C2, 0x0496, 0x046F, 
    0x044E, 0x0433, 0x041F, 0x0412, 0x040E, 0xF73B, 0xF6F2, 0xF671, 0xF64C, 
    0xF63D, 0xF634, 0xF62D, 0xF62B, 0xF62B, 0xF62A, 0xF628, 0xF626, 0xF626, 
    0xF629, 0xF632, 0xF640, 0xF64D, 0xF653, 0xF653, 0xF651, 0xF64F, 0xF64C, 
    0xF648, 0xF644, 0xF640, 0xF63C, 0xF638, 0xF634, 0xF631, 0xF62F, 0xF62D, 
    0xF62D, 0xF626, 0xF653, 0xF6C9, 0xF755, 0xF7EB, 0xF87D, 0xF8FD, 0xF95F, 
    0xF926, 0xF8C5, 0xF917, 0xF95F, 0xF949, 0xF92D, 0xF90E, 0xF8EC, 0xF8C8, 
    0xF8A1, 0xF879, 0xF850, 0xF827, 0xF7FF, 0xF7D7, 0xF7B1, 0xF78E, 0xF76D, 
    0xF74F, 0xF736, 0xF721, 0xF711, 0xF707, 0xF704, 0xFF83, 0x0900, 0x1321, 
    0x135E, 0x109E, 0x0EF5, 0x0FEF, 0x11CE, 0x13B9, 0x14D5, 0x1489, 0x136A, 
    0x125F, 0x1250, 0x13ED, 0x1694, 0x1932, 0x1AB3, 0x1B3D, 0x1BB0, 0x1C0C, 
    0x1C56, 0x1C8E, 0x1CB8, 0x1CD4, 0x1CE6, 0x1CEF, 0x1CF1, 0x1CF0, 0x1CEC, 
    0x1CE8, 0x1CE6, 0x1D2E, 0x1AB3, 0x1472, 0x0D1E, 0x054B, 0xFD91, 0xF685, 
    0xF0BC, 0xF0A8, 0xF30E, 0xF1BB, 0xF0BC, 0xF174, 0xF247, 0xF331, 0xF42E, 
    0xF53A, 0xF651, 0xF770, 0xF892, 0xF9B3, 0xFAD0, 0xFBE5, 0xFCED, 0xFDE4, 
    0xFEC8, 0xFF93, 0x0042, 0x00D1, 0x013C, 0x017F, 0x0197, 0x04DC, 0x048B, 
    0x043C, 0x03F1, 0x03AA, 0x0365, 0x0324, 0x02E5, 0x02A9, 0x026F, 0x0238, 
    0x0203, 0x01D0, 0x019F, 0x0170, 0x0143, 0x0117, 0x00ED, 0x00C4, 0x009D, 
    0x0076, 0x0050, 0x002C, 0x0007, 0xFFE4, 0xFFC0, 0xFF9D, 0xFF7A, 0xFF57, 
    0xFF34, 0xFF11, 0xFEED, 0xFEF1, 0xFF2C, 0xFF7C, 0xFFBC, 0xFFCA, 0xFF35, 
    0xFE55, 0xFE30, 0x000F, 0x029B, 0x0458, 0x05D8, 0x0716, 0x085C, 0x0A57, 
    0x0C6E, 0x0D67, 0xF7F9, 0xF7F9, 0xF7F9, 0xF7FA, 0xF7FB, 0xF7FD, 0xF7FF, 
    0xF802, 0xF804, 0xF807, 0xF80A, 0xF80C, 0xF80F, 0xF812, 0xF814, 0xF817, 
    0xF819, 0xF81A, 0xF81C, 0xF81D, 0xF81D, 0xF81D, 0xF81C, 0xF81B, 0xF818, 
    0xF815, 0xF812, 0xF80D, 0xF807, 0xF800, 0xF7F9, 0xF7F0, 0xF7BE, 0xF75A, 
    0xF6ED, 0xF6A1, 0xF6A2, 0xF767, 0xF8B1, 0xF996, 0xF955, 0xF898, 0xF7D8, 
    0xF749, 0xF755, 0xF7CF, 0xF8D0, 0xF9FE, 0xFA90, 0x1580, 0x15DC, 0x1636, 
    0x168C, 0x16E1, 0x1733, 0x1783, 0x17D3, 0x1821, 0x186F, 0x18BD, 0x190B, 
    0x195A, 0x19AA, 0x19FB, 0x1A4E, 0x1AA3, 0x1AFB, 0x1B55, 0x1BB3, 0x1C15, 
    0x1C7A, 0x1CE4, 0x1D52, 0x1DC6, 0x1E3F, 0x1EBE, 0x1F43, 0x1FCF, 0x2061, 
    0x20FB, 0x219D, 0x2357, 0x2677, 0x29D9, 0x2C59, 0x2CD2, 0x28BF, 0x2128, 
    0x1A47, 0x15EF, 0x1334, 0x126C, 0x12AC, 0x137E, 0x13DC, 0x1244, 0x1016, 
    0x0EFC, 0x0001, 0xFFFE, 0xC170, 0x9A4F, 0xBB2D, 0xD8EC, 0xDAE0, 0xDC90, 
    0xDE01, 0xDF36, 0xE032, 0xE0FA, 0xE190, 0xE1FA, 0xE239, 0xE253, 0xE24A, 
    0xE222, 0xE1E0, 0xE186, 0xE118, 0xE09B, 0xE011, 0xDF7E, 0xDEE7, 0xDE4E, 
    0xDDB7, 0xDD27, 0xDCA0, 0xDC27, 0xDBBE, 0xDB6B, 0xDB30, 0xDB10, 0xDB11, 
    0xDB0B, 0xDB0F, 0xDB1C, 0xDB03, 0xDAD6, 0xDAA5, 0xDA80, 0xDA79, 0xDA9F, 
    0xDB04, 0xDBB8, 0xDCCB, 0xDE38, 0xDFE7, 0xE1CF, 0xE3E7, 0xE626, 0xE882, 
    0xEAF3, 0xED6F, 0xEFEC, 0xF263, 0xF4C9, 0xF715, 0xF93F, 0xFB3D, 0xFD05, 
    0xFE8F, 0xFFD2, 0x00C3, 0x015B, 0x0190, 0xD17A, 0xD244, 0xD357, 0xD422, 
    0xD4EF, 0xD5BB, 0xD688, 0xD755, 0xD822, 0xD8F0, 0xD9BD, 0xDA8B, 0xDB58, 
    0xDC25, 0xDCF2, 0xDDBE, 0xDE8A, 0xDF56, 0xE021, 0xE0EB, 0xE1B5, 0xE27E, 
    0xE345, 0xE40C, 0xE4D2, 0xE597, 0xE65A, 0xE71D, 0xE7DE, 0xE89D, 0xE95B, 
    0xEA17, 0xEAD6, 0xEA0C, 0xE779, 0xE47F, 0xE141, 0xDDE0, 0xDA7D, 0xD73B, 
    0xD43C, 0xD1A0, 0xCF8B, 0xCE1E, 0xCD23, 0xCC4D, 0xCB9A, 0xCB06, 0xCA90, 
    0xCA34, 0xC9F0, 0xC9C2, 0xC9A6, 0xC99B, 0xC99D, 0xC9A9, 0xC9BF, 0xC9D9, 
    0xC9F7, 0xCA16, 0xCA32, 0xCA49, 0xCA59, 0xCA5F, 0x1BD0, 0x1AB9, 0x1986, 
    0x18A2, 0x17BE, 0x16DA, 0x15F6, 0x1511, 0x142D, 0x1348, 0x1263, 0x117F, 
    0x109B, 0x0FB7, 0x0ED4, 0x0DF1, 0x0D0F, 0x0C2D, 0x0B4D, 0x0A6D, 0x098E, 
    0x08B0, 0x07D3, 0x06F7, 0x061C, 0x0543, 0x046B, 0x0395, 0x02C0, 0x01EC, 
    0x011B, 0x004B, 0xFF6F, 0x007C, 0x03F8, 0x0834, 0x0CEB, 0x11D7, 0x16B3, 
    0x1B39, 0x1F22, 0x2229, 0x2409, 0x247B, 0x23D2, 0x2297, 0x20DD, 0x1EB4, 
    0x1C2B, 0x1954, 0x1640, 0x12FE, 0x0FA0, 0x0C36, 0x08D0, 0x0580, 0x0255, 
    0xFF61, 0xFCB3, 0xFA5D, 0xF86F, 0xF6FA, 0xF60D, 0xF5BB, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xE7C7, 0xE72C, 0xE68C, 0xE5E8, 
    0xE540, 0xE493, 0xE3E2, 0xE32E, 0xE277, 0xE1BD, 0xE100, 0xE040, 0xDF7E, 
    0xDEBA, 0xDDF5, 0xDD2E, 0xDC66, 0xDB9D, 0xDAD4, 0xDA0A, 0xD940, 0xD877, 
    0xD7AE, 0xD6E5, 0xD61E, 0xD558, 0xD493, 0xD3D0, 0xD310, 0xD251, 0xD195, 
    0xD0DD, 0xD057, 0xD025, 0xD010, 0xCFF3, 0xCFD2, 0xCFB2, 0xCF99, 0xCF8B, 
    0xCF8D, 0xCFA4, 0xCFD5, 0xD025, 0xD092, 0xD115, 0xD1AA, 0xD24E, 0xD2FF, 
    0xD3BA, 0xD47C, 0xD542, 0xD608, 0xD6CD, 0xD78D, 0xD845, 0xD8F2, 0xD992, 
    0xDA21, 0xDA9C, 0xDB02, 0xDB4E, 0xDB7D, 0xDB8E, 0xFF2C, 0xFF28, 0xFF25, 
    0xFF22, 0xFF21, 0xFF20, 0xFF1F, 0xFF1F, 0xFF1F, 0xFF20, 0xFF22, 0xFF23, 
    0xFF25, 0xFF28, 0xFF2A, 0xFF2D, 0xFF30, 0xFF34, 0xFF37, 0xFF3B, 0xFF3E, 
    0xFF42, 0xFF45, 0xFF49, 0xFF4C, 0xFF4F, 0xFF53, 0xFF55, 0xFF58, 0xFF5B, 
    0xFF5D, 0xFF5F, 0xFF60, 0xFF61, 0xFF61, 0xFF62, 0xFF62, 0xFF63, 0xFF63, 
    0xFF64, 0xFF64, 0xFF64, 0xFF65, 0xF5E5, 0xF5CE, 0xF5B9, 0xF5A7, 0xF597, 
    0xF58A, 0xF57F, 0xF576, 0xF56F, 0xF56A, 0xF567, 0xF565, 0xF564, 0xF565, 
    0xF567, 0xF56A, 0xF56E, 0xF572, 0xF577, 0xF57D, 0xF583, 0xF589, 0xF58F, 
    0xF595, 0xF59B, 0xF5A0, 0xF5A5, 0xF5A9, 0xF5AD, 0xF5B0, 0xF5B1, 0xF5B2, 
    0xF5A4, 0xF5E1, 0xF689, 0xF749, 0xF81A, 0xF8F3, 0xF9CC, 0xFA9B, 0xFB58, 
    0xFBFB, 0xFC7A, 0xFCCE, 0xFD04, 0xFD2E, 0xFD4E, 0xFD66, 0xFD74, 0xFD7C, 
    0xFD7D, 0xFD78, 0xFD6F, 0xFD62, 0xFD52, 0xFD40, 0xFD2C, 0xFD19, 0xFD06, 
    0xFCF4, 0xFCE5, 0xFCD9, 0xFCD1, 0xFCCE, 0xE924, 0xE904, 0xE8E6, 0xE8CC, 
    0xE8B5, 0xE8A1, 0xE890, 0xE881, 0xE875, 0xE86A, 0xE862, 0xE85B, 0xE856, 
    0xE853, 0xE851, 0xE850, 0xE850, 0xE851, 0xE852, 0xE854, 0xE857, 0xE859, 
    0xE85B, 0xE85D, 0xE85F, 0xE860, 0xE861, 0xE861, 0xE85F, 0xE85C, 0xE858, 
    0xE853, 0xE84F, 0xE84D, 0xE84A, 0xE847, 0xE844, 0xE840, 0xE83D, 0xE83A, 
    0xE837, 0xE835, 0xE833, 0xE832, 0xE831, 0xE830, 0xE830, 0xE830, 0xE82F, 
    0xE82F, 0xE82F, 0xE82F, 0xE82F, 0xE830, 0xE830, 0xE830, 0xE830, 0xE831, 
    0xE831, 0xE831, 0xE832, 0x0001, 0xFFFE, 0xC4F4, 0xC509, 0xC51B, 0xC52B, 
    0xC539, 0xC544, 0xC54D, 0xC554, 0xC559, 0xC55C, 0xC55E, 0xC55E, 0xC55D, 
    0xC55B, 0xC558, 0xC553, 0xC54E, 0xC548, 0xC542, 0xC53B, 0xC533, 0xC52C, 
    0xC524, 0xC51D, 0xC516, 0xC50F, 0xC509, 0xC503, 0xC4FE, 0xC4FA, 0xC4F7, 
    0xC4F5, 0xC4F4, 0x92BB, 0x88ED, 0x7B01, 0x6A58, 0x584E, 0x4641, 0x358E, 
    0x2793, 0x1DAF, 0x1714, 0x11E9, 0x0DF8, 0x0B0B, 0x08EB, 0x0764, 0x063E, 
    0x0544, 0x0440, 0x02FB, 0x0140, 0xFEDA, 0xFB6E, 0xF75C, 0xF383, 0xF0BF, 
    0xF1E3, 0xF33D, 0xF080, 0xEC89, 0xE930, 0xE704, 0xE576, 0xE4AB, 0xE4AD, 
    0xE53C, 0xE608, 0xE6C3, 0xE720, 0xE6D1, 0xE586, 0x5F28, 0x55AA, 0x51D6, 
    0xD744, 0xE12A, 0xEBB1, 0xF304, 0xF485, 0xF29A, 0xF0FD, 0xF118, 0xF180, 
    0xF1AC, 0xF13D, 0xF092, 0xF039, 0x2B21, 0x29D2, 0x27E1, 0x2589, 0x2304, 
    0x208B, 0x1E5A, 0x1CAA, 0x1BB5, 0x1B5F, 0x1B59, 0x1B97, 0x1C0A, 0x1CA5, 
    0x1D5B, 0x1E1F, 0x1EE2, 0x1F98, 0x2033, 0x20A6, 0x20E3, 0x2061, 0x1F23, 
    0x1DEF, 0x1D8D, 0x2063, 0x2291, 0x1F76, 0x1AC7, 0x185D, 0x1AC8, 0x1F77, 
    0x228F, 0x230D, 0x22BF, 0x2207, 0x2143, 0x20D6, 0x211E, 0x227C, 0x576A, 
    0x4E22, 0x4912, 0x34E3, 0x2F93, 0x29AC, 0x25D9, 0x25E7, 0x2812, 0x29AF, 
    0x298C, 0x28DA, 0x288A, 0x2937, 0x2A46, 0x2AD2, 0x1257, 0x1060, 0x0DF5, 
    0x0B26, 0x0804, 0x049D, 0x0101, 0xFD42, 0xF96F, 0xF585, 0xF17A, 0xED53, 
    0xE913, 0xE4BF, 0xE05A, 0xDBE7, 0xD76B, 0xD2EA, 0xCE68, 0xC9E8, 0xC56E, 
    0xC0E9, 0xBC38, 0xB74E, 0xB21B, 0xABE6, 0xA546, 0x9EB1, 0x9834, 0x931D, 
    0x901C, 0x8E81, 0x8D8E, 0x8CC3, 0x8C20, 0x8B9E, 0x8B36, 0x8AE3, 0x8A9C, 
    0x8A5D, 0x0778, 0x04E7, 0x0B25, 0x9EE4, 0xBA20, 0xD53F, 0xE8A6, 0xEDDB, 
    0xE9D9, 0xE633, 0xE652, 0xE6CE, 0xE702, 0xE681, 0xE5B9, 0xE550, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xDD97, 0xD571, 0xC7D0, 0xBB1A, 
    0xB5B1, 0xB62D, 0xB6E3, 0xB7CF, 0xB8ED, 0xBA3A, 0xBBB1, 0xBD50, 0xBF12, 
    0xC0F5, 0xC2F3, 0xC50A, 0xC736, 0xC973, 0xCBBE, 0xCE13, 0xD06E, 0xD2CC, 
    0xD528, 0xD780, 0xD9CF, 0xDC13, 0xDE46, 0xE067, 0xE270, 0xE45E, 0xE62E, 
    0xE7DD, 0xE965, 0xEA76, 0xEADD, 0xEAC2, 0xEA51, 0xE9B3, 0xE912, 0xE897, 
    0xE82D, 0xE7A8, 0xE70F, 0xE66A, 0xE5C0, 0xE519, 0xE47B, 0xFDE6, 0xFDA3, 
    0xFD61, 0xFD1E, 0xFCDA, 0xFC96, 0xFC51, 0xFC0D, 0xFBC8, 0xFB83, 0xFB3D, 
    0xFAF8, 0xFAB3, 0xFA6E, 0xFA29, 0xF9E5, 0xF9A0, 0xF95C, 0xF919, 0xF8D6, 
    0xF893, 0xF851, 0xF810, 0xF7D0, 0xF790, 0xF751, 0xF714, 0xF6D7, 0xF69B, 
    0xF660, 0xF627, 0xF5EF, 0xF5B8, 0xF590, 0xF57E, 0xF57E, 0xF588, 0xF596, 
    0xF5A2, 0xF5A6, 0xF5A3, 0xF5A0, 0xF59D, 0xF59A, 0xF597, 0xF593, 0xF590, 
    0xFF6A, 0xFFCA, 0x0035, 0x00AB, 0x012A, 0x01B0, 0x023F, 0x02D3, 0x036D, 
    0x040B, 0x04AC, 0x0550, 0x05F5, 0x069A, 0x073F, 0x07E2, 0x0883, 0x0920, 
    0x09B9, 0x0A4C, 0x0AD9, 0x0B5F, 0x0BDC, 0x0C4F, 0x0CB9, 0x0D16, 0x0D68, 
    0x0DAC, 0x0DE2, 0x0E09, 0x0E1F, 0x0E24, 0x0E17, 0x0D27, 0x0AD7, 0x07A7, 
    0x0414, 0x009E, 0xFDC2, 0xFC00, 0xFB5D, 0xFB6C, 0xFBFB, 0xFCDA, 0xFDDA, 
    0xFECA, 0xFF79, 0xF5FA, 0xF596, 0xF52C, 0xF4BC, 0xF447, 0xF3CE, 0xF350, 
    0xF2CE, 0xF249, 0xF1C1, 0xF136, 0xF0A9, 0xF01B, 0xEF8B, 0xEEFA, 0xEE69, 
    0xEDD8, 0xED47, 0xECB7, 0xEC29, 0xEB9C, 0xEB11, 0xEA89, 0xEA04, 0xE983, 
    0xE905, 0xE88C, 0xE817, 0xE7A8, 0xE73E, 0xE6DA, 0xE67D, 0xE627, 0xE60E, 
    0xE656, 0xE6E2, 0xE793, 0xE84B, 0xE8EF, 0xE95E, 0xE9A0, 0xE9CE, 0xE9F0, 
    0xEA08, 0xEA1E, 0xEA35, 0xEA52, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
    0xE7E1, 0xE833, 0xE885, 0xE8D7, 0xE929, 0xE97B, 0xE9CE, 0xEA20, 0xEA73, 
    0xEAC6, 0xEB19, 0xEB6C, 0xEBBF, 0xEC12, 0xEC65, 0xECB8, 0xED0A, 0xED5D, 
    0xEDB0, 0xEE02, 0xEE54, 0xEEA6, 0xEEF7, 0xEF49, 0xEF9A, 0xEFEA, 0xF03B, 
    0xF08B, 0xF0DA, 0xF129, 0xF178, 0xF1C6, 0xF20B, 0xF1EC, 0xF171, 0xF0F2, 
    0xF06D, 0xEFE3, 0xEF52, 0xEEBC, 0xEE1F, 0xED7B, 0xECCF, 0xEC1C, 0xEB59, 
    0xEA83, 0xE99B, 0xE8A5, 0xE7A5, 0xE69E, 0xE593, 0xE487, 0xE37E, 0xE27B, 
    0xE180, 0xE093, 0xDFB5, 0xDEEA, 0xDE35, 0xDD9A, 0xDD1C, 0xDCBD, 0xDC82, 
    0xDC6E, 0xEBFF, 0xEBB4, 0xEB6B, 0xEB23, 0xEADC, 0xEA97, 0xEA52, 0xEA0F, 
    0xE9CD, 0xE98C, 0xE94C, 0xE90D, 0xE8CF, 0xE891, 0xE854, 0xE818, 0xE7DC, 
    0xE7A1, 0xE766, 0xE72C, 0xE6F2, 0xE6B8, 0xE67E, 0xE644, 0xE60B, 0xE5D1, 
    0xE597, 0xE55D, 0xE523, 0xE4E8, 0xE4AD, 0xE472, 0xE440, 0xE44F, 0xE49E, 
    0xE4F8, 0xE55C, 0xE5C3, 0xE62D, 0xE693, 0xE6F3, 0xE74A, 0xE793, 0xE7CB, 
    0xE7F8, 0xE823, 0xE84C, 0xE873, 0xE898, 0xE8BB, 0xE8DB, 0xE8FA, 0xE916, 
    0xE930, 0xE948, 0xE95E, 0xE971, 0xE982, 0xE990, 0xE99B, 0xE9A5, 0xE9AB, 
    0xE9AF, 0xE9B1, 0xB41C, 0xB387, 0xB2F2, 0xB25E, 0xB1C9, 0xB135, 0xB0A1, 
    0xB00C, 0xAF78, 0xAEE4, 0xAE50, 0xADBD, 0xAD29, 0xAC96, 0xAC03, 0xAB70, 
    0xAADE, 0xAA4C, 0xA9BA, 0xA929, 0xA898, 0xA808, 0xA777, 0xA6E8, 0xA659, 
    0xA5CA, 0xA53C, 0xA4AE, 0xA421, 0xA395, 0xA309, 0xA27E, 0xA205, 0xA236, 
    0xA308, 0xA3E9, 0xA4D7, 0xA5CF, 0xA6CF, 0xA7D5, 0xA8DD, 0xA9E7, 0xAAEF, 
    0xABF2, 0xAD00, 0xAE25, 0xAF5C, 0xB0A3, 0xB1F4, 0xB34D, 0xB4A8, 0xB603, 
    0xB759, 0xB8A5, 0xB9E5, 0xBB15, 0xBC2F, 0xBD30, 0xBE15, 0xBED9, 0xBF79, 
    0xBFF0, 0xC03A, 0xC054, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x1783, 0x181F, 0x18C3, 0x1970, 
    0x1A24, 0x1AE1, 0x1BA4, 0x1C6E, 0x1D3D, 0x1E12, 0x1EED, 0x1FCC, 0x20AE, 
    0x2195, 0x227E, 0x236A, 0x2459, 0x2548, 0x2639, 0x272B, 0x281D, 0x290E, 
    0x29FF, 0x2AEE, 0x2BDC, 0x2CC7, 0x2DB0, 0x2E95, 0x2F76, 0x3054, 0x312C, 
    0x3200, 0x32BA, 0x3267, 0x30FE, 0x2F61, 0x2DA0, 0x2BCB, 0x29F1, 0x2822, 
    0x266C, 0x24E0, 0x238E, 0x2283, 0x21A5, 0x20CC, 0x1FF9, 0x1F2D, 0x1E69, 
    0x1DAC, 0x1CF8, 0x1C4E, 0x1BAD, 0x1B17, 0x1A8C, 0x1A0D, 0x199B, 0x1935, 
    0x18DE, 0x1895, 0x185B, 0x1831, 0x1817, 0x180F, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xDBA8, 0xDBA2, 0xDB9A, 0xDB92, 
    0xDB8A, 0xDB80, 0xDB76, 0xDB6B, 0xDB5F, 0xDB53, 0xDB46, 0xDB39, 0xDB2B, 
    0xDB1D, 0xDB0E, 0xDB00, 0xDAF1, 0xDAE2, 0xDAD2, 0xDAC3, 0xDAB3, 0xDAA4, 
    0xDA95, 0xDA85, 0xDA76, 0xDA67, 0xDA58, 0xDA4A, 0xDA3B, 0xDA2E, 0xDA20, 
    0xDA13, 0xDA0A, 0xDA07, 0xDA10, 0xDA29, 0xDA4C, 0xDA72, 0xDA93, 0xDAA9, 
    0xDAAC, 0xDA97, 0xDA62, 0xDA07, 0xD988, 0xD8F0, 0xD843, 0xD783, 0xD6B5, 
    0xD5DC, 0xD4FA, 0xD414, 0xD32D, 0xD249, 0xD16A, 0xD093, 0xCFCA, 0xCF10, 
    0xCE6A, 0xCDDA, 0xCD64, 0xCD0C, 0xCCD4, 0xCCC1, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xBF5E, 0x01CD, 0x017A, 0x00FA, 0x0062, 0xFFC5, 0xFF36, 0xFECA, 
    0xFEB6, 0xFEDD, 0xFED9, 0xFE96, 0xFE43, 0xFDE1, 0xFD6D, 0xFCE6, 0xFC32, 
    0xFB55, 0xFA77, 0xF9C1, 0xF94B, 0xF8FA, 0xF8AE, 0xF845, 0xF7AA, 0xF6F5, 
    0xF642, 0xF5B0, 0xF542, 0xF4E5, 0xF496, 0xF450, 0xF40F, 0xF3B2, 0xF3F4, 
    0xF500, 0xF627, 0xF761, 0xF8A8, 0xF9F5, 0xFB42, 0xFC88, 0xFDC0, 0xFEE5, 
    0xFFEF, 0x00F1, 0x0200, 0x031B, 0x043D, 0x0564, 0x068D, 0x07B6, 0x08DA, 
    0x09F8, 0x0B0C, 0x0C14, 0x0D0C, 0x0DF2, 0x0EC3, 0x0F7B, 0x1019, 0x1098, 
    0x10F7, 0x1132, 0x1146, 0x179B, 0x1791, 0x1782, 0x176F, 0x175A, 0x1745, 
    0x1732, 0x1723, 0x1715, 0x1703, 0x16ED, 0x16D5, 0x16BC, 0x16A0, 0x1681, 
    0x1658, 0x1627, 0x15F7, 0x15D1, 0x15BD, 0x15B3, 0x15AA, 0x1595, 0x156D, 
    0x153A, 0x1508, 0x14E4, 0x14CF, 0x14C3, 0x14BC, 0x14B7, 0x14B1, 0x149E, 
    0x14AF, 0x14FC, 0x155E, 0x15CE, 0x1644, 0x16B6, 0x171E, 0x1772, 0x17AB, 
    0x17C1, 0x17AA, 0x1770, 0x1722, 0x16C1, 0x1651, 0x15D4, 0x154D, 0x14BE, 
    0x1429, 0x1392, 0x12FA, 0x1265, 0x11D4, 0x114B, 0x10CD, 0x105A, 0x0FF7, 
    0x0FA5, 0x0F68, 0x0F41, 0x0F33, 0xAC84, 0xAC13, 0xAB3E, 0xAA2D, 0xA90C, 
    0xA804, 0xA742, 0xA722, 0xA76A, 0xA75E, 0xA6DC, 0xA63D, 0xA57E, 0xA49F, 
    0xA39B, 0xA242, 0xA099, 0x9EEF, 0x9D93, 0x9CB1, 0x9C19, 0x9B88, 0x9ABF, 
    0x9993, 0x982F, 0x96D0, 0x95B4, 0x94E1, 0x9432, 0x939D, 0x931A, 0x92A0, 
    0x91F0, 0x926C, 0x9473, 0x96BA, 0x9930, 0x9BC0, 0x9E58, 0xA0E4, 0xA351, 
    0xA58B, 0xA77F, 0xA91B, 0xAA85, 0xABF0, 0xAD5A, 0xAEC0, 0xB021, 0xB17B, 
    0xB2CB, 0xB40F, 0xB546, 0xB66D, 0xB781, 0xB882, 0xB96C, 0xBA3E, 0xBAF5, 
    0xBB90, 0xBC0C, 0xBC67, 0xBC9F, 0xBCB3, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x2090, 0x209E, 0x2130, 0x2228, 0x2367, 0x24CF, 0x2643, 
    0x27A3, 0x28D3, 0x29B3, 0x29C3, 0x2929, 0x28C4, 0x2971, 0x2B8D, 0x2E85, 
    0x31CF, 0x34E4, 0x373A, 0x384D, 0x387F, 0x38A1, 0x3984, 0x3B9F, 0x3E6E, 
    0x4148, 0x4388, 0x4514, 0x4652, 0x4758, 0x483A, 0x490D, 0x4A2D, 0x494E, 
    0x45D6, 0x41E1, 0x3D95, 0x391A, 0x3498, 0x3036, 0x2C1B, 0x286F, 0x2559, 
    0x2301, 0x2122, 0x1F5A, 0x1DAA, 0x1C13, 0x1A94, 0x192D, 0x17DE, 0x16A8, 
    0x158B, 0x1486, 0x139A, 0x12C6, 0x120B, 0x1169, 0x10DF, 0x106F, 0x1017, 
    0x0FD9, 0x0FB3, 0x0FA6, 0x0013, 0x0013, 0x0014, 0x0014, 0x0014, 0x0014, 
    0x0014, 0x0014, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0016, 0x0016, 
    0x0016, 0x0016, 0x0016, 0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0018, 
    0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0019, 0x0019, 0x0019, 0x0019, 
    0x0019, 0x0019, 0x001A, 0x001A, 0x001A, 0x001A, 0x001B, 0x001B, 0x001A, 
    0x001A, 0x0019, 0x0018, 0x0017, 0x0015, 0x0014, 0x0012, 0x0010, 0x000E, 
    0x000C, 0x000A, 0x0008, 0x0007, 0x0005, 0x0003, 0x0002, 0x0000, 0x0000, 
    0xFFFE, 0xFFFD, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF31, 0xFF31, 
    0xFF31, 0xFF31, 0xFF31, 0xFF31, 0xFF31, 0xFF31, 0xFF31, 0xFF31, 0xFF31, 
    0xFF31, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
    0xFF30, 0xFF30, 0xFF30, 0xFF2F, 0xC62C, 0xC624, 0xC61C, 0xC614, 0xC60B, 
    0xC602, 0xC5F9, 0xC5F0, 0xC5E6, 0xC5DD, 0xC5D3, 0xC5C9, 0xC5BF, 0xC5B5, 
    0xC5AB, 0xC5A0, 0xC596, 0xC58B, 0xC581, 0xC577, 0xC56C, 0xC562, 0xC557, 
    0xC54D, 0xC542, 0xC538, 0xC52E, 0xC524, 0xC51A, 0xC510, 0xC506, 0xC4FD, 
    0xC4F6, 0xC4F3, 0xC4EE, 0xC4E2, 0xC4D2, 0xC4C1, 0xC4B3, 0xC4A9, 0xC4A8, 
    0xC4B2, 0xC4CA, 0xC4F3, 0xC52C, 0xC571, 0xC5BF, 0xC615, 0xC672, 0xC6D4, 
    0xC739, 0xC7A1, 0xC809, 0xC870, 0xC8D4, 0xC934, 0xC98F, 0xC9E3, 0xCA2E, 
    0xCA6F, 0xCAA4, 0xCACB, 0xCAE4, 0xCAED, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xBF2E, 0xCE1A, 0x1D62,
    },
    {
    0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
    0x0004, 0x0001, 0x0005, 0x003D, 0x0006, 0x003E, 0x0043, 0x0040, 0x0081, 
    0x0040, 0x00C1, 0x0040, 0x0101, 0x0040, 0x0141, 0x0031, 0x0181, 0x0031, 
    0x01B2, 0x0031, 0x01E3, 0x0001, 0x0214, 0x0001, 0x0215, 0x0001, 0x0216, 
    0x0040, 0x0217, 0x0040, 0x0257, 0x0040, 0x0297, 0x003C, 0x02D7, 0x0040, 
    0x0313, 0x0040, 0x0353, 0x002B, 0x0393, 0x0040, 0x03BE, 0x003D, 0x03FE, 
    0x0001, 0x043B, 0x0001, 0x043C, 0x0021, 0x043D, 0x0038, 0x045E, 0x0038, 
    0x0496, 0x0038, 0x04CE, 0x0040, 0x0506, 0x003B, 0x0546, 0x002F, 0x0581, 
    0x002F, 0x05B0, 0x002F, 0x05DF, 0x002F, 0x060E, 0x003F, 0x063D, 0x003A, 
    0x067C, 0x0001, 0x06B6, 0x0040, 0x06B7, 0x0040, 0x06F7, 0x0040, 0x0737, 
    0x0038, 0x0777, 0x003F, 0x07AF, 0x0040, 0x07EE, 0x0040, 0x082E, 0x003D, 
    0x086E, 0x0040, 0x08AB, 0x003F, 0x08EB, 0x003A, 0x092A, 0x0001, 0x0964, 
    0x0040, 0x0965, 0x0040, 0x09A5, 0x0040, 0x09E5, 0x003C, 0x0A25, 0x003F, 
    0x0A61, 0x0040, 0x0AA0, 0x003E, 0x0AE0, 0x0038, 0x0B1E, 0x0040, 0x0B56, 
    0x0038, 0x0B96, 0x0040, 0x0BCE, 0x0040, 0x0C0E, 0x0001, 0x0C4E, 0x0001, 
    0x0C4F, 0x0001, 0x0C50, 
})

smlua_anim_util_register_animation("MILNE_ANIM_DYING_ON_STOMACH",
    1,
    0,
    0,
    0,
    46,
    {
    0x0000, 0xFFA8, 0xFFBD, 0xFFCA, 0xFFCC, 0xFFD3, 0xFFDD, 0xFFE7, 0xFFEB, 
    0xFFEB, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEA, 
    0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFE9, 0xFFE9, 
    0xFFE9, 0xFFE8, 0xFFE8, 0xFFE7, 0xFFE4, 0xFFDD, 0xFFD4, 0xFFCA, 0xFFC1, 
    0xFFBA, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB9, 
    0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x7FAA, 0x7F5F, 0x7EEB, 0x7E37, 0x7D59, 0x7C69, 0x7B7C, 0x7AA9, 
    0x7A07, 0x79AB, 0x797C, 0x7951, 0x792A, 0x7907, 0x78E8, 0x78CE, 0x78B7, 
    0x78A5, 0x7898, 0x788F, 0x788B, 0x788B, 0x7891, 0x789B, 0x78AA, 0x78BF, 
    0x78D9, 0x78F8, 0x791C, 0x7946, 0x7976, 0x79AB, 0x7AA6, 0x7C8A, 0x7E6C, 
    0x7F5F, 0x7F2C, 0x7E65, 0x7D4F, 0x7C2F, 0x7B4C, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x01A6, 0x0197, 0x0246, 
    0x035D, 0x04B5, 0x0625, 0x0786, 0x08AF, 0x097A, 0x09BD, 0x09A4, 0x0979, 
    0x093B, 0x08ED, 0x0890, 0x0827, 0x07B2, 0x0734, 0x06AD, 0x0621, 0x058F, 
    0x04FB, 0x0465, 0x03D0, 0x033C, 0x02AC, 0x0222, 0x019E, 0x0123, 0x00B2, 
    0x004D, 0xFFF5, 0xFFF4, 0x0064, 0x0105, 0x0197, 0x0211, 0x0294, 0x0319, 
    0x0397, 0x0408, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFF, 0x0006, 0x0010, 0x001A, 0x0027, 0x0039, 0x004C, 
    0x005E, 0x0068, 0x006F, 0x007D, 0x009D, 0x00C1, 0x00D5, 0x00E9, 0x010C, 
    0x0128, 0x0123, 0x0118, 0x012D, 0x0121, 0x00AA, 0xFFFF, 0xFF80, 0xFE67, 
    0xFD23, 0xF87A, 0xEC53, 0xDDA3, 0xD30F, 0xD027, 0xD15C, 0xD2A0, 0xD297, 
    0xD296, 0xD299, 0xD29E, 0xD2A0, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0x0004, 0x000D, 0x001A, 0x0027, 
    0x0030, 0x0038, 0x0041, 0x004B, 0x0057, 0x0060, 0x0061, 0x0066, 0x007F, 
    0x009A, 0x00A7, 0x00B1, 0x00CA, 0x00D7, 0x00BD, 0x008D, 0x0075, 0x0000, 
    0xFE82, 0xFCC5, 0xFB03, 0xFA38, 0xFBAB, 0xFDE7, 0xFF32, 0xFE82, 0xFCE1, 
    0xFBBC, 0xFB75, 0xFB6C, 0xFB87, 0xFBAA, 0xFBBC, 0xDD2E, 0xDDD2, 0xDEB3, 
    0xE000, 0xE198, 0xE35E, 0xE534, 0xE6FB, 0xE894, 0xE9E0, 0xEA30, 0xE96E, 
    0xE6BA, 0xE55A, 0xE681, 0xE813, 0xE87E, 0xE6A7, 0xE45C, 0xE407, 0xE56E, 
    0xE5B6, 0xE381, 0xE13A, 0xE15B, 0xE2A1, 0xE1A5, 0xDDE0, 0xDEE9, 0xE038, 
    0xDA41, 0xD975, 0xD965, 0xD910, 0xD5C0, 0xD523, 0xDF1F, 0xEC76, 0xF6D4, 
    0xFB71, 0xFD16, 0xFDC4, 0xFE52, 0xFE64, 0xFE2F, 0xFDE8, 0xFDC4, 0x0001, 
    0xFFFE, 0xC170, 0xE11B, 0xE733, 0xE836, 0xE9C7, 0xEBB4, 0xEDCB, 0xEFD9, 
    0xF1AB, 0xF30F, 0xF3D2, 0xF42E, 0xF480, 0xF4C8, 0xF506, 0xF53A, 0xF563, 
    0xF583, 0xF598, 0xF5A3, 0xF5A4, 0xF59B, 0xF588, 0xF56B, 0xF544, 0xF513, 
    0xF4D7, 0xF492, 0xF443, 0xF3E9, 0xF386, 0xF319, 0xF2A1, 0xF0A0, 0xECD2, 
    0xE910, 0xE733, 0xE7B1, 0xE961, 0xEBB3, 0xEE17, 0xEFFD, 0xD37A, 0xD3BB, 
    0xD5B2, 0xD8B8, 0xDC70, 0xE07C, 0xE480, 0xE81F, 0xEAFB, 0xECB9, 0xEDC5, 
    0xEECB, 0xEFC7, 0xF0B9, 0xF1A0, 0xF278, 0xF341, 0xF3FA, 0xF4A0, 0xF531, 
    0xF5AD, 0xF611, 0xF65C, 0xF68D, 0xF6A1, 0xF696, 0xF66C, 0xF621, 0xF5B2, 
    0xF51F, 0xF466, 0xF384, 0xEEB8, 0xE50A, 0xDAA7, 0xD3BB, 0xD11F, 0xD05B, 
    0xD0AA, 0xD142, 0xD15E, 0x9DB8, 0x9B97, 0x9AB7, 0x995A, 0x97AC, 0x95DC, 
    0x9417, 0x928A, 0x9164, 0x90D2, 0x90A0, 0x907B, 0x9062, 0x9056, 0x9054, 
    0x905E, 0x9072, 0x9090, 0x90B7, 0x90E6, 0x911D, 0x915C, 0x91A2, 0x91ED, 
    0x923F, 0x9296, 0x92F1, 0x9350, 0x93B3, 0x9418, 0x9480, 0x94E9, 0x9640, 
    0x98A1, 0x9AD1, 0x9B97, 0x9A9D, 0x98AF, 0x9644, 0x93D2, 0x91D1, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xDCEC, 0xDCA4, 
    0xDC11, 0xDB2A, 0xDA0D, 0xD8DA, 0xD7B2, 0xD6B4, 0xD601, 0xD5B7, 0xD5B3, 
    0xD5BC, 0xD5D1, 0xD5F1, 0xD61C, 0xD64F, 0xD68B, 0xD6CD, 0xD717, 0xD765, 
    0xD7B9, 0xD80F, 0xD869, 0xD8C4, 0xD920, 0xD97B, 0xD9D6, 0xDA2F, 0xDA85, 
    0xDAD6, 0xDB24, 0xDB6B, 0xDB67, 0xDB36, 0xDB6E, 0xDCA4, 0xDF16, 0xE255, 
    0xE5F1, 0xE97C, 0xEC88, 0xFC43, 0xF75D, 0xFAA2, 0xFFBB, 0x0600, 0x0CCA, 
    0x1371, 0x194F, 0x1DBC, 0x2010, 0x210D, 0x21E1, 0x228F, 0x2316, 0x2378, 
    0x23B6, 0x23D1, 0x23CA, 0x23A1, 0x2357, 0x22EE, 0x2267, 0x21C1, 0x20FF, 
    0x2021, 0x1F29, 0x1E16, 0x1CEA, 0x1BA6, 0x1A4C, 0x18DA, 0x1754, 0x121E, 
    0x0857, 0xFE10, 0xF75D, 0xF517, 0xF4CE, 0xF5A8, 0xF6CB, 0xF75D, 0xF939, 
    0xF2EF, 0xF44F, 0xF673, 0xF915, 0xFBEF, 0xFEBC, 0x0136, 0x0317, 0x041A, 
    0x048F, 0x04F4, 0x054B, 0x0592, 0x05CB, 0x05F5, 0x0611, 0x061E, 0x061E, 
    0x0610, 0x05F5, 0x05CC, 0x0596, 0x0553, 0x0504, 0x04A8, 0x043F, 0x03CA, 
    0x034A, 0x02BD, 0x0225, 0x0182, 0xFF2A, 0xFAB3, 0xF5FF, 0xF2EF, 0xF1E5, 
    0xF1C4, 0xF228, 0xF2AC, 0xF2EF, 0xF2D8, 0xEE09, 0xEC9E, 0xEA6F, 0xE7C0, 
    0xE4D4, 0xE1F1, 0xDF5A, 0xDD55, 0xDC24, 0xDB7A, 0xDAD7, 0xDA3D, 0xD9AE, 
    0xD928, 0xD8AF, 0xD841, 0xD7E0, 0xD78D, 0xD748, 0xD713, 0xD6ED, 0xD6D8, 
    0xD6D5, 0xD6E4, 0xD706, 0xD73C, 0xD786, 0xD7E5, 0xD85B, 0xD8E8, 0xD98C, 
    0xDCB5, 0xE2FF, 0xE9AE, 0xEE09, 0xEF7E, 0xEFAC, 0xEF20, 0xEE66, 0xEE09, 
    0x0001, 0xFFFE, 0xC170, 0xF85D, 0xF746, 0xF869, 0xFA2B, 0xFC55, 0xFEAF, 
    0x00FF, 0x030F, 0x04A6, 0x058C, 0x0602, 0x066F, 0x06D3, 0x072C, 0x077B, 
    0x07C0, 0x07FA, 0x0829, 0x084D, 0x0865, 0x0872, 0x0873, 0x0867, 0x084F, 
    0x082A, 0x07F8, 0x07B9, 0x076D, 0x0713, 0x06AA, 0x0634, 0x05AE, 0x02DD, 
    0xFD84, 0xF8A6, 0xF746, 0xFA3B, 0xFF90, 0x0619, 0x0CAA, 0x1218, 0x3339, 
    0x2EFF, 0x2D53, 0x2AC7, 0x27A6, 0x2439, 0x20CA, 0x1DA2, 0x1B0C, 0x1950, 
    0x1816, 0x16D5, 0x1591, 0x144D, 0x130B, 0x11CF, 0x109C, 0x0F74, 0x0E5B, 
    0x0D54, 0x0C62, 0x0B87, 0x0AC7, 0x0A25, 0x09A4, 0x0947, 0x0910, 0x0904, 
    0x0925, 0x0975, 0x09F9, 0x0AB2, 0x103A, 0x1BA3, 0x27A7, 0x2EFF, 0x3088, 
    0x2F6C, 0x2CD6, 0x29F4, 0x27F3, 0x7A16, 0x79BB, 0x7B53, 0x7DCA, 0x80D4, 
    0x8420, 0x8761, 0x8A4A, 0x8C8C, 0x8DDB, 0x8E91, 0x8F3C, 0x8FDB, 0x906E, 
    0x90F4, 0x916D, 0x91D7, 0x9232, 0x927E, 0x92BA, 0x92E5, 0x92FE, 0x9305, 
    0x92FA, 0x92DA, 0x92A7, 0x925F, 0x9202, 0x918E, 0x9104, 0x9062, 0x8FA8, 
    0x8B9A, 0x83CB, 0x7C6D, 0x79BB, 0x7CCF, 0x82FA, 0x8ABA, 0x928E, 0x98F8, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xE8D5, 0xE7A4, 0xE6E9, 0xE5C5, 0xE45E, 0xE2DA, 0xE15F, 0xE015, 
    0xDF23, 0xDEAD, 0xDE8A, 0xDE72, 0xDE66, 0xDE64, 0xDE6C, 0xDE7E, 0xDE99, 
    0xDEBC, 0xDEE7, 0xDF19, 0xDF51, 0xDF90, 0xDFD3, 0xE01C, 0xE068, 0xE0B8, 
    0xE10B, 0xE160, 0xE1B7, 0xE20F, 0xE268, 0xE2C0, 0xE41E, 0xE674, 0xE82A, 
    0xE7A4, 0xE45C, 0xDF6D, 0xD9B1, 0xD3FF, 0xCF32, 0x1102, 0x028B, 0x003C, 
    0xFCA8, 0xF842, 0xF37B, 0xEEC7, 0xEA96, 0xE75C, 0xE58A, 0xE49C, 0xE3C2, 
    0xE2FB, 0xE249, 0xE1AC, 0xE125, 0xE0B3, 0xE057, 0xE013, 0xDFE5, 0xDFD0, 
    0xDFD3, 0xDFEE, 0xE022, 0xE071, 0xE0D9, 0xE15C, 0xE1FA, 0xE2B3, 0xE389, 
    0xE47B, 0xE58A, 0xEA18, 0xF2FD, 0xFC68, 0x028B, 0x049B, 0x04DD, 0x0417, 
    0x030F, 0x028B, 0x0DEF, 0x1035, 0x10C7, 0x11AA, 0x12C1, 0x13F0, 0x151B, 
    0x1624, 0x16F1, 0x1764, 0x179F, 0x17D5, 0x1806, 0x1833, 0x1859, 0x187B, 
    0x1897, 0x18AE, 0x18BF, 0x18CA, 0x18CF, 0x18CF, 0x18C8, 0x18BB, 0x18A8, 
    0x188E, 0x186D, 0x1846, 0x1818, 0x17E3, 0x17A7, 0x1764, 0x1643, 0x140F, 
    0x11BA, 0x1035, 0x0FB2, 0x0FA2, 0x0FD3, 0x1014, 0x1035, 0xEA5A, 0xE4FE, 
    0xE36E, 0xE104, 0xDE0C, 0xDAD3, 0xD7A5, 0xD4D1, 0xD2A4, 0xD169, 0xD0C9, 
    0xD035, 0xCFAF, 0xCF37, 0xCECD, 0xCE72, 0xCE25, 0xCDE7, 0xCDB9, 0xCD9A, 
    0xCD8C, 0xCD8D, 0xCDA0, 0xCDC3, 0xCDF8, 0xCE3F, 0xCE97, 0xCF02, 0xCF7F, 
    0xD00F, 0xD0B2, 0xD169, 0xD47C, 0xDA7D, 0xE0D9, 0xE4FE, 0xE662, 0xE68E, 
    0xE609, 0xE557, 0xE4FE, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xBF5E, 0xF807, 0xF7C7, 0xF83B, 0xF8EC, 0xF9C5, 0xFAB3, 0xFBA1, 
    0xFC7B, 0xFD2D, 0xFDA3, 0xFDF4, 0xFE47, 0xFE9A, 0xFEED, 0xFF3F, 0xFF90, 
    0xFFDD, 0x0028, 0x006E, 0x00B0, 0x00EC, 0x0122, 0x0150, 0x0177, 0x0196, 
    0x01AB, 0x01B6, 0x01B6, 0x01AB, 0x0193, 0x016E, 0x013C, 0xFFDE, 0xFD07, 
    0xF9EE, 0xF7C7, 0xF6D0, 0xF654, 0xF620, 0xF604, 0xF5CD, 0xF484, 0xF4B9, 
    0xF488, 0xF43C, 0xF3DE, 0xF378, 0xF314, 0xF2BA, 0xF275, 0xF24D, 0xF238, 
    0xF224, 0xF212, 0xF201, 0xF1F2, 0xF1E5, 0xF1D9, 0xF1CF, 0xF1C7, 0xF1C1, 
    0xF1BD, 0xF1BB, 0xF1BC, 0xF1BE, 0xF1C3, 0xF1CA, 0xF1D3, 0xF1DF, 0xF1EE, 
    0xF1FF, 0xF212, 0xF229, 0xF286, 0xF340, 0xF412, 0xF4B9, 0xF52A, 0xF58A, 
    0xF5DF, 0xF62C, 0xF676, 0xA6F9, 0xA7EF, 0xA674, 0xA432, 0xA16B, 0x9E62, 
    0x9B5A, 0x9894, 0x9653, 0x94DA, 0x93D9, 0x92D5, 0x91D1, 0x90CF, 0x8FD0, 
    0x8ED9, 0x8DE9, 0x8D05, 0x8C2F, 0x8B67, 0x8AB2, 0x8A11, 0x8986, 0x8914, 
    0x88BD, 0x8883, 0x8868, 0x8870, 0x889B, 0x88ED, 0x8968, 0x8A0E, 0x8E5A, 
    0x9744, 0xA10C, 0xA7EF, 0xAB37, 0xAD12, 0xAE0F, 0xAEC2, 0xAFBB, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x2789, 0x2124, 0x230B, 0x25F3, 0x2986, 0x2D6D, 
    0x3153, 0x34DF, 0x37BD, 0x3996, 0x3AD0, 0x3C0C, 0x3D46, 0x3E7B, 0x3FAB, 
    0x40D0, 0x41EA, 0x42F5, 0x43EF, 0x44D5, 0x45A5, 0x465B, 0x46F5, 0x4771, 
    0x47CC, 0x4804, 0x4815, 0x47FD, 0x47B9, 0x4747, 0x46A5, 0x45CF, 0x4071, 
    0x3561, 0x295E, 0x2124, 0x1DA0, 0x1C0E, 0x1BA2, 0x1B8E, 0x1B07, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xE31A, 0xE31A, 
    0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
    0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
    0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
    0xE31A, 0xE31A, 0xE31A, 0xE2E8, 0xE294, 0xE284, 0xE31A, 0xE47E, 0xE666, 
    0xE88C, 0xEAAA, 0xEC79, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xBF5E, 0x0B1D, 0x0ABC, 0x0A7A, 0x0A1B, 0x09A7, 0x0924, 0x089C, 
    0x0816, 0x079B, 0x0731, 0x06CF, 0x0665, 0x05F4, 0x057D, 0x0503, 0x0486, 
    0x0407, 0x0389, 0x030C, 0x0292, 0x021D, 0x01AE, 0x0146, 0x00E6, 0x0091, 
    0x0047, 0x000A, 0xFFDB, 0xFFBC, 0xFFAE, 0xFFB2, 0xFFCA, 0x0153, 0x04A8, 
    0x084A, 0x0ABC, 0x0BB0, 0x0C07, 0x0C02, 0x0BE3, 0x0BEC, 0x0A60, 0x0AC1, 
    0x0AF4, 0x0B42, 0x0BA2, 0x0C0B, 0x0C75, 0x0CD5, 0x0D25, 0x0D5A, 0x0D80, 
    0x0DA6, 0x0DCD, 0x0DF4, 0x0E1A, 0x0E40, 0x0E65, 0x0E88, 0x0EAA, 0x0ECA, 
    0x0EE7, 0x0F01, 0x0F18, 0x0F2B, 0x0F3B, 0x0F46, 0x0F4C, 0x0F4E, 0x0F4A, 
    0x0F40, 0x0F31, 0x0F1A, 0x0E7C, 0x0D32, 0x0BC5, 0x0AC1, 0x0A3E, 0x09EF, 
    0x09BD, 0x0997, 0x0969, 0xAA40, 0xA8CB, 0xA7EA, 0xA69D, 0xA504, 0xA33E, 
    0xA168, 0x9FA2, 0x9E09, 0x9CBD, 0x9B95, 0x9A56, 0x9905, 0x97A6, 0x963C, 
    0x94CD, 0x935B, 0x91EB, 0x9082, 0x8F23, 0x8DD1, 0x8C93, 0x8B6A, 0x8A5C, 
    0x896C, 0x889F, 0x87F9, 0x877D, 0x8730, 0x8716, 0x8733, 0x878B, 0x8C35, 
    0x9649, 0xA14E, 0xA8CB, 0xABE1, 0xAD29, 0xAD63, 0xAD4D, 0xADA5, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x23B7, 
    0x1FEB, 0x2151, 0x2368, 0x25F9, 0x28CF, 0x2BB4, 0x2E73, 0x30D7, 0x32A9, 
    0x342E, 0x35CA, 0x377A, 0x3937, 0x3AFE, 0x3CC8, 0x3E92, 0x4056, 0x420F, 
    0x43B9, 0x454E, 0x46CA, 0x4827, 0x4961, 0x4A72, 0x4B57, 0x4C0A, 0x4C85, 
    0x4CC5, 0x4CC4, 0x4C7D, 0x4BEB, 0x4578, 0x37C7, 0x2927, 0x1FEB, 0x1D65, 
    0x1DD5, 0x1FF0, 0x226C, 0x23FE, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
    0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
    0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
    0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
    0xFF93, 0xFF94, 0xFF94, 0xFF93, 0xFF90, 0xFF8C, 0xFF88, 0xFF83, 0xFF80, 
    0xFF4D, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
    0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
    0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
    0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4D, 0xFF4D, 0xFF4D, 0xFF4E, 
    0xFF50, 0xFF52, 0xFF55, 0xFF58, 0xFF5B, 0xE03B, 0xE041, 0xE041, 0xE041, 
    0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
    0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
    0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
    0xE041, 0xE029, 0xE001, 0xDFF9, 0xE041, 0xE0EB, 0xE1D4, 0xE2DC, 0xE3DF, 
    0xE4BC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xCFC1, 0xCF49, 0xCE01, 0xCC1C, 0xC9CD, 
    0xC749, 0xC4C6, 0xC277, 0xC092, 0xBF4A, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 
    0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 
    0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBED2, 0xBFC0, 
    0xC22A, 0xC57A, 0xC918, 0xCC69, 0xCED2, 0xCFC1,
    },
    {
    0x0001, 0x0000, 0x002C, 0x0001, 0x0001, 0x002D, 0x0001, 0x002E, 0x0001, 
    0x002F, 0x0001, 0x0030, 0x0028, 0x0031, 0x0026, 0x0059, 0x0029, 0x007F, 
    0x0029, 0x00A8, 0x0028, 0x00D1, 0x0029, 0x00F9, 0x002F, 0x0122, 0x002F, 
    0x0151, 0x002F, 0x0180, 0x0001, 0x01AF, 0x0001, 0x01B0, 0x0001, 0x01B1, 
    0x0029, 0x01B2, 0x0029, 0x01DB, 0x0029, 0x0204, 0x0028, 0x022D, 0x0028, 
    0x0255, 0x0029, 0x027D, 0x0029, 0x02A6, 0x0029, 0x02CF, 0x0029, 0x02F8, 
    0x0001, 0x0321, 0x0001, 0x0322, 0x0001, 0x0323, 0x0029, 0x0324, 0x0029, 
    0x034D, 0x0029, 0x0376, 0x0029, 0x039F, 0x0029, 0x03C8, 0x0029, 0x03F1, 
    0x0029, 0x041A, 0x0029, 0x0443, 0x0029, 0x046C, 0x0029, 0x0495, 0x0026, 
    0x04BE, 0x0001, 0x04E4, 0x0029, 0x04E5, 0x0029, 0x050E, 0x0029, 0x0537, 
    0x0028, 0x0560, 0x0024, 0x0588, 0x0029, 0x05AC, 0x0028, 0x05D5, 0x0028, 
    0x05FD, 0x0029, 0x0625, 0x0029, 0x064E, 0x0026, 0x0677, 0x0001, 0x069D, 
    0x0029, 0x069E, 0x0029, 0x06C7, 0x0029, 0x06F0, 0x0024, 0x0719, 0x0024, 
    0x073D, 0x0029, 0x0761, 0x0029, 0x078A, 0x0029, 0x07B3, 0x0029, 0x07DC, 
    0x0029, 0x0805, 0x0027, 0x082E, 0x0029, 0x0855, 0x0022, 0x087E, 0x0001, 
    0x08A0, 0x0026, 0x08A1,
})

smlua_anim_util_register_animation("MILNE_ANIM_WAKE_FROM_SLEEP",
    1,
    0,
    0,
    0,
    19,
    {
    0x0000, 0xFFA4, 0xFFA6, 0xFFAC, 0xFFB6, 0xFFC5, 0xFFD8, 0xFFF0, 0x000B, 
    0x0028, 0x0044, 0x005B, 0x006B, 0x0077, 0x0081, 0x008B, 0x0094, 0x009D, 
    0x00A4, 0x00A8, 0x00AA, 0xFF5A, 0xFF5B, 0xFF5E, 0xFF63, 0xFF6A, 0xFF72, 
    0xFF7C, 0xFF87, 0xFF94, 0xFFA1, 0xFFAE, 0xFFBB, 0xFFC8, 0xFFD5, 0xFFE0, 
    0xFFEA, 0xFFF3, 0xFFF9, 0xFFFE, 0xFFFF, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x2968, 0x2968, 0x2968, 0x2968, 0x2968, 0x2968, 
    0x2968, 0x2968, 0x2968, 0x32C3, 0x4489, 0x4F4C, 0x5048, 0x4F61, 0x4D21, 
    0x4A13, 0x46C1, 0x43B6, 0x417D, 0x40A1, 0xFF6B, 0xFF6E, 0xFF77, 0xFF83, 
    0xFF91, 0xFFA0, 0xFFAD, 0xFFB6, 0xFFBE, 0xFFC7, 0xFFCF, 0xFFD7, 0xFFDF, 
    0xFFE7, 0xFFEE, 0xFFF4, 0xFFF8, 0xFFFC, 0xFFFF, 0x0000, 0x00A3, 0x00A7, 
    0x00AF, 0x00BB, 0x00C7, 0x00D0, 0x00D4, 0x00D0, 0x00C5, 0x00B4, 0x00A1, 
    0x008B, 0x0073, 0x005B, 0x0043, 0x002E, 0x001B, 0x000D, 0x0003, 0xFFFF, 
    0x0F98, 0x108B, 0x12FA, 0x1648, 0x19D8, 0x1D0B, 0x1F44, 0x1FE5, 0x1F1F, 
    0x1DA5, 0x1B9D, 0x192B, 0x1677, 0x13A5, 0x10DB, 0x0E3F, 0x0BF5, 0x0A24, 
    0x08F2, 0x0884, 0xFD75, 0xFDA4, 0xFE02, 0xFE86, 0xFF18, 0xFFA5, 0x0017, 
    0x0058, 0x0073, 0x0081, 0x0083, 0x007D, 0x0070, 0x005F, 0x004A, 0x0035, 
    0x0020, 0x000F, 0x0004, 0x0000, 0xFEED, 0xFEDE, 0xFE9F, 0xFE4A, 0xFDEF, 
    0xFD9E, 0xFD67, 0xFD5A, 0xFD73, 0xFDA0, 0xFDDB, 0xFE23, 0xFE71, 0xFEC2, 
    0xFF12, 0xFF5C, 0xFF9D, 0xFFD1, 0xFFF3, 0x0000, 0x26D8, 0x2434, 0x1D4C, 
    0x13B5, 0x0902, 0xFEC8, 0xF698, 0xF206, 0xF059, 0xEFAF, 0xEFDE, 0xF0BC, 
    0xF21D, 0xF3D9, 0xF5C4, 0xF7B5, 0xF981, 0xFAFD, 0xFC01, 0xFC61, 0x10BE, 
    0x10BE, 0x10BE, 0x10BE, 0x10BE, 0x10BE, 0x10BE, 0x10BE, 0x10BE, 0x10BE, 
    0x10BE, 0x10BE, 0x0FD3, 0x0D9A, 0x0ADA, 0x085E, 0x05E2, 0x0322, 0x00E9, 
    0xFFFE, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 
    0x0679, 0x0679, 0x0679, 0x0679, 0x061F, 0x0543, 0x0433, 0x033D, 0x0248, 
    0x0138, 0x005C, 0x0001, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 
    0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCAFE, 0xC9A6, 0xC7FD, 
    0xC67D, 0xC4FD, 0xC355, 0xC1FD, 0xC170, 0xEE82, 0xEE82, 0xEE82, 0xEE82, 
    0xEE82, 0xEE82, 0xEE82, 0xEE82, 0xEE82, 0xEE82, 0xEE82, 0xEE82, 0xE832, 
    0xD8DF, 0xC5F0, 0xB4CE, 0x23AE, 0x10BF, 0x016C, 0xFB1C, 0xE053, 0xE053, 
    0xE053, 0xE053, 0xE053, 0xE053, 0xE053, 0xE053, 0xE053, 0xE053, 0xE053, 
    0xE053, 0xDD86, 0xD6BA, 0xCE54, 0xC6BB, 0xC0DC, 0xC942, 0xD00E, 0xD2DB, 
    0xD145, 0xD145, 0xD145, 0xD145, 0xD145, 0xD145, 0xD145, 0xD145, 0xD145, 
    0xD145, 0xD145, 0xD145, 0xD875, 0xE9E9, 0xFF79, 0x12FD, 0xA67E, 0xBC0E, 
    0xCD83, 0xD4B3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 
    0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 0xF5E6, 0xF20D, 0xE90A, 0xDEAB, 
    0xD6BB, 0xD1BA, 0xCDCB, 0xCB3A, 0xCA4E, 0x0816, 0x0816, 0x0816, 0x0816, 
    0x0816, 0x0816, 0x0816, 0x0816, 0x0816, 0x06F9, 0x04B6, 0x02E5, 0x0208, 
    0x0175, 0x010F, 0x00B6, 0x0065, 0x002C, 0x000B, 0x0000, 0xE284, 0xE284, 
    0xE284, 0xE284, 0xE284, 0xE284, 0xE284, 0xE284, 0xE284, 0xE90C, 0xF5EF, 
    0xFF1E, 0x0160, 0x0118, 0xFFA5, 0xFE63, 0xFD39, 0xFB95, 0xFA1D, 0xF97B, 
    0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 0xEA2E, 
    0xEECF, 0xF7BA, 0xFD78, 0xFD94, 0xFB77, 0xF870, 0xF5CF, 0xF366, 0xF0AE, 
    0xEE76, 0xED8B, 0x1524, 0x1524, 0x1524, 0x1524, 0x1524, 0x1524, 0x1524, 
    0x1524, 0x1524, 0x1524, 0x1524, 0x1524, 0x13FC, 0x112D, 0x0DB5, 0x0A91, 
    0x076E, 0x03F5, 0x0127, 0xFFFE, 0x22DF, 0x22DF, 0x22DF, 0x22DF, 0x22DF, 
    0x22DF, 0x22DF, 0x22DF, 0x22DF, 0x22DF, 0x22DF, 0x22DF, 0x20F6, 0x1C55, 
    0x169D, 0x1170, 0x0C43, 0x068B, 0x01EA, 0x0001, 0xC75D, 0xC75D, 0xC75D, 
    0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 
    0xC70A, 0xC640, 0xC547, 0xC466, 0xC385, 0xC28C, 0xC1C3, 0xC170, 0x131C, 
    0x131C, 0x131C, 0x131C, 0x131C, 0x131C, 0x131C, 0x131C, 0x131C, 0x131C, 
    0x131C, 0x131C, 0x1566, 0x1A42, 0x1EB0, 0x1FAE, 0x1A96, 0x11A0, 0x0918, 
    0x054B, 0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 
    0xEC4B, 0xEC4B, 0xEC4B, 0xEC4B, 0xF47A, 0x0745, 0x1C0C, 0x2A30, 0x2EEA, 
    0x2EFC, 0x2D12, 0x2BD6, 0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 
    0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 0xE0AF, 0xE44E, 0xEC06, 0xF320, 
    0xF4E6, 0xED45, 0xDFB2, 0xD2BC, 0xCCF5, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFA62, 0xFA62, 0xFA62, 0xFA62, 0xFA62, 0xFA62, 
    0xFA62, 0xFA62, 0xFA62, 0xFA62, 0xFA62, 0xFA62, 0xF618, 0xEC05, 0xE05F, 
    0xD758, 0xD15F, 0xCC72, 0xC919, 0xC7DC, 0xF344, 0xF344, 0xF344, 0xF344, 
    0xF344, 0xF344, 0xF344, 0xF344, 0xF344, 0xF599, 0xFA48, 0xFDD6, 0xFF2A, 
    0xFFBC, 0xFFEA, 0x0013, 0x0037, 0x002C, 0x0010, 0xFFFF, 0x2351, 0x2351, 
    0x2351, 0x2351, 0x2351, 0x2351, 0x2351, 0x2351, 0x2351, 0x1DD2, 0x12B4, 
    0x0A05, 0x0646, 0x0424, 0x02E3, 0x01CC, 0x00D0, 0x0045, 0x000B, 0xFFFF, 
    0xDF85, 0xDF85, 0xDF85, 0xDF85, 0xDF85, 0xDF85, 0xDF85, 0xDF85, 0xDF85, 
    0xE290, 0xE8C0, 0xEDB0, 0xF004, 0xF186, 0xF290, 0xF377, 0xF448, 0xF4D9, 
    0xF52D, 0xF548, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xF168, 0xF1AF, 0xF270, 0xF38A, 0xF4DC, 
    0xF648, 0xF7AB, 0xF8E7, 0xF9DA, 0xFAEA, 0xFB76, 0xF9DA, 0xF5D9, 0xF0A9, 
    0xEACF, 0xE4D6, 0xDF44, 0xDAA2, 0xD776, 0xD649, 0xF278, 0xF24C, 0xF1D4, 
    0xF124, 0xF051, 0xEF6F, 0xEE92, 0xEDCD, 0xED36, 0xED04, 0xED25, 0xED36, 
    0xED1A, 0xECF6, 0xECCE, 0xECA4, 0xEC7E, 0xEC5E, 0xEC48, 0xEC40, 0x973A, 
    0x9685, 0x949D, 0x91D3, 0x8E79, 0x8AE1, 0x875C, 0x843D, 0x81D4, 0x7FEB, 
    0x7F4F, 0x81D4, 0x87A9, 0x8F37, 0x97BB, 0xA06E, 0xA88A, 0xAF4A, 0xB3E7, 
    0xB59D, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0710, 0x090A, 0x0E60, 0x162F, 0x1F95, 0x29B0, 
    0x339C, 0x3C76, 0x435D, 0x46E6, 0x470A, 0x44FE, 0x4187, 0x3CF2, 0x37BA, 
    0x325D, 0x2D57, 0x2927, 0x2647, 0x2537, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xCEBB, 0xCEF1, 0xCF74, 0xD015, 0xD0A8, 0xD0FD, 
    0xD0E5, 0xD034, 0xCEBB, 0xC8B2, 0xBF3C, 0xB98B, 0xB8B6, 0xB8DA, 0xB9B3, 
    0xBAFD, 0xBC74, 0xBDD4, 0xBED9, 0xBF3F, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x0CE2, 0x0C9B, 
    0x0BD9, 0x0ABD, 0x0968, 0x07FB, 0x0695, 0x0557, 0x0462, 0x0395, 0x034C, 
    0x0462, 0x06EF, 0x0A3D, 0x0DF7, 0x11C5, 0x1551, 0x1844, 0x1A49, 0x1B09, 
    0x0EFE, 0x0F21, 0x0F7F, 0x1008, 0x10AE, 0x115F, 0x120C, 0x12A7, 0x131D, 
    0x1352, 0x1346, 0x131D, 0x12E8, 0x12A3, 0x1255, 0x1206, 0x11BC, 0x117E, 
    0x1154, 0x1144, 0x961C, 0x956E, 0x939A, 0x90ED, 0x8DB7, 0x8A45, 0x86E5, 
    0x83E6, 0x8197, 0x7FE7, 0x7F75, 0x8197, 0x8665, 0x8C9F, 0x93A3, 0x9ACE, 
    0xA17D, 0xA70C, 0xAADA, 0xAC43, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0366, 0x052F, 0x0A05, 0x111A, 
    0x19A4, 0x22D5, 0x2BE3, 0x3402, 0x3A66, 0x3E0B, 0x3ED1, 0x3D40, 0x39F7, 
    0x358A, 0x3076, 0x2B37, 0x264A, 0x222B, 0x1F57, 0x1E4A, 0xFFB7, 0xFFB6, 
    0xFFB3, 0xFFB0, 0xFFAD, 0xFFAB, 0xFFAB, 0xFFAF, 0xFFB7, 0xFFD7, 0x000A, 
    0x0028, 0x002C, 0x0029, 0x0023, 0x001A, 0x0011, 0x0008, 0x0002, 0x0000, 
    0xFF3C, 0xFF47, 0xFF63, 0xFF86, 0xFFA5, 0xFFB7, 0xFFB2, 0xFF8C, 0xFF3C, 
    0xFDE2, 0xFBCC, 0xFAB7, 0xFAE8, 0xFB69, 0xFC20, 0xFCF2, 0xFDC4, 0xFE7C, 
    0xFEFE, 0xFF2F, 0xD81A, 0xD852, 0xD8DA, 0xD983, 0xDA1B, 0xDA73, 0xDA5B, 
    0xD9A3, 0xD81A, 0xD1CB, 0xC7EC, 0xC215, 0xC16C, 0xC1D6, 0xC304, 0xC4AA, 
    0xC679, 0xC824, 0xC95D, 0xC9D7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x3F2C, 0x4127, 0x49D8, 0xE318, 0xFDD0, 0x05BB, 0x059D, 
    0x0336, 0x00EE, 0xFFFF, 0xA8E0, 0xAAA0, 0xAF07, 0xCE15, 0xD516, 0xE274, 
    0xEF57, 0xF8BE, 0xFE30, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
    0x0001, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xF0D0, 0xED5D, 0xE07E, 0x4085, 
    0x1CC0, 0x0A0A, 0xFED3, 0xF719, 0xF23D, 0xF07F, 0xF519, 0x0082, 0x0E71, 
    0x19D6, 0x1E6E, 0x1B51, 0x13C4, 0x0AAA, 0x031D, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x0014, 0x0001, 0x0014, 0x0015, 0x0001, 0x0029, 0x0001, 
    0x002A, 0x0001, 0x002B, 0x0014, 0x002C, 0x0014, 0x0040, 0x0014, 0x0054, 
    0x0014, 0x0068, 0x0014, 0x007C, 0x0014, 0x0090, 0x0014, 0x00A4, 0x0014, 
    0x00B8, 0x0014, 0x00CC, 0x0014, 0x00E0, 0x0014, 0x00F4, 0x0014, 0x0108, 
    0x0014, 0x011C, 0x0014, 0x0130, 0x0014, 0x0144, 0x0011, 0x0158, 0x0014, 
    0x0169, 0x0014, 0x017D, 0x0014, 0x0191, 0x0014, 0x01A5, 0x0014, 0x01B9, 
    0x0014, 0x01CD, 0x0014, 0x01E1, 0x0014, 0x01F5, 0x0014, 0x0209, 0x0014, 
    0x021D, 0x0014, 0x0231, 0x0013, 0x0245, 0x000F, 0x0258, 0x0014, 0x0267, 
    0x0014, 0x027B, 0x0014, 0x028F, 0x0014, 0x02A3, 0x0014, 0x02B7, 0x0011, 
    0x02CB, 0x0001, 0x02DC, 0x0014, 0x02DD, 0x0014, 0x02F1, 0x0014, 0x0305, 
    0x0013, 0x0319, 0x0013, 0x032C, 0x0014, 0x033F, 0x0013, 0x0353, 0x000F, 
    0x0366, 0x0014, 0x0375, 0x0014, 0x0389, 0x0011, 0x039D, 0x0001, 0x03AE, 
    0x0014, 0x03AF, 0x0014, 0x03C3, 0x0014, 0x03D7, 0x0013, 0x03EB, 0x0012, 
    0x03FE, 0x0014, 0x0410, 0x0014, 0x0424, 0x0014, 0x0438, 0x0014, 0x044C, 
    0x0011, 0x0460, 0x0011, 0x0471, 0x0012, 0x0482, 0x000A, 0x0494, 0x0014, 
    0x049E, 0x0014, 0x04B2, 
})

smlua_anim_util_register_animation("MILNE_ANIM_WAKE_FROM_LYING",
    1,
    0,
    0,
    0,
    19,
    {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFC, 0xFFF9, 0xFFF7, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFF8, 0xFFFA, 0xFFFC, 
    0xFFFE, 0x0000, 0xFFB0, 0xFFB1, 0xFFB7, 0xFFC8, 0xFFE4, 0x0006, 0x0027, 
    0x0043, 0x0054, 0x0059, 0x0061, 0x0068, 0x006F, 0x0075, 0x007B, 0x0082, 
    0x0089, 0x0092, 0x009D, 0x00A6, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5B, 0xFF5D, 
    0xFF61, 0xFF67, 0xFF70, 0xFF7B, 0xFF89, 0xFF99, 0xFFA8, 0xFFB5, 0xFFC0, 
    0xFFCA, 0xFFD4, 0xFFDE, 0xFFE8, 0xFFF3, 0xFFFB, 0x0000, 0x3FFF, 0x0000, 
    0xB078, 0xB90F, 0xC911, 0xDC51, 0xEEA2, 0x0148, 0x1396, 0x1E70, 0x2121, 
    0x2085, 0x1DE1, 0x1A76, 0x1788, 0x14CE, 0x115D, 0x0D8A, 0x09A8, 0x0609, 
    0x0301, 0x00E3, 0x3A85, 0x3A0B, 0x390F, 0x3710, 0x338C, 0x2CE4, 0x2426, 
    0x1CD2, 0x1728, 0x116B, 0x0C18, 0x07AE, 0x04AB, 0x02D3, 0x0185, 0x00AB, 
    0x002E, 0xFFF5, 0xFFEA, 0xFFF5, 0xEE74, 0xF836, 0x0A30, 0x1E0C, 0x2D76, 
    0x3480, 0x3699, 0x387A, 0x3C5B, 0x40D0, 0x4519, 0x4876, 0x4A27, 0x4A38, 
    0x4962, 0x47EB, 0x4619, 0x4430, 0x4275, 0x412F, 0x1603, 0x15DF, 0x157E, 
    0x13D8, 0x0FE8, 0x093F, 0x00D1, 0xF7AA, 0xEED9, 0xE76C, 0xE2D7, 0xE02B, 
    0xDCDA, 0xD57A, 0xDB10, 0xE264, 0xEA84, 0xF27E, 0xF95D, 0xFE2E, 0xFC94, 
    0xFA17, 0xF5B8, 0xF1AF, 0xF034, 0xF1B4, 0xF4BE, 0xF8BA, 0xFD10, 0x0129, 
    0x0596, 0x0A71, 0x0E71, 0x0DBE, 0x0BA7, 0x092D, 0x0690, 0x0415, 0x01FC, 
    0x008A, 0x1A0F, 0x1955, 0x1798, 0x14BF, 0x10B5, 0x0A66, 0x0225, 0xF9FA, 
    0xF3E9, 0xF1F8, 0xF9D5, 0x0969, 0x1716, 0x1807, 0x15D5, 0x1318, 0x1023, 
    0x0D48, 0x0AD9, 0x0927, 0xFC92, 0xFC5A, 0xFB1B, 0xF960, 0xF7B7, 0xF507, 
    0xF23C, 0xF2EA, 0xF7C3, 0xFE76, 0x0607, 0x0D7A, 0x13D5, 0x181D, 0x1757, 
    0x1231, 0x0D2D, 0x092E, 0x04DD, 0x0169, 0xFCBE, 0xFA74, 0xF5E3, 0xF147, 
    0xEEDB, 0xF0CA, 0xF555, 0xF8D6, 0xFA6C, 0xFBAE, 0xFCAD, 0xFD7C, 0xFE2C, 
    0xFED0, 0xFEFF, 0xFEB4, 0xFE94, 0xFEE5, 0xFF5F, 0xFFCF, 0x1A73, 0x170A, 
    0x105C, 0x098B, 0x05B9, 0x0882, 0x0EDA, 0x11E2, 0x1041, 0x0D6F, 0x09C9, 
    0x05AD, 0x0175, 0xFD80, 0xF884, 0xF31E, 0xF080, 0xF244, 0xF65C, 0xFA7E, 
    0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10F6, 0x112A, 0x10C1, 0x0FA0, 
    0x0E2F, 0x0C90, 0x0AE6, 0x0955, 0x07CB, 0x0639, 0x04BB, 0x0371, 0x0245, 
    0x012E, 0x005D, 0x0679, 0x0679, 0x0679, 0x0679, 0x0679, 0x068E, 0x06A2, 
    0x0679, 0x060A, 0x057B, 0x04DB, 0x0437, 0x039B, 0x0304, 0x0268, 0x01D5, 
    0x0155, 0x00E1, 0x0076, 0x0025, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 0xCB8B, 
    0xCBAB, 0xCBCB, 0xCB8B, 0xCADD, 0xC9FE, 0xC904, 0xC803, 0xC710, 0xC623, 
    0xC530, 0xC44A, 0xC383, 0xC2CD, 0xC225, 0xC1A7, 0xF346, 0xF422, 0xF4ED, 
    0xF4E5, 0xF346, 0xEEDD, 0xE815, 0xE095, 0xDBE1, 0xD676, 0xC76E, 0x9912, 
    0xEE93, 0xE58F, 0xE579, 0xE98A, 0xECFD, 0xEFFD, 0xF49D, 0xF8F3, 0xF72B, 
    0xF830, 0xF8BC, 0xF87F, 0xF72B, 0xF463, 0xEFD8, 0xE956, 0xDEA5, 0xD1FC, 
    0xC9C7, 0xCF72, 0xA9D9, 0xAD80, 0xB3BA, 0xBAC6, 0xC0E4, 0xC679, 0xCC36, 
    0xD0C6, 0xDE7B, 0xDE52, 0xDE5F, 0xDE79, 0xDE7B, 0xDD9C, 0xDCA9, 0xDDDB, 
    0xDF0F, 0xE269, 0xF085, 0x203E, 0xCDA9, 0xD9A2, 0xDCEE, 0xDBFF, 0xDB46, 
    0xDACA, 0xD88F, 0xD60C, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xC0C7, 0xC027, 0xBF1E, 
    0xBEE8, 0xC0C7, 0xC71D, 0xD02C, 0xD6F7, 0xD846, 0xD715, 0xD7AF, 0xDF90, 
    0xE5A2, 0xE30E, 0xDDF1, 0xD827, 0xD38F, 0xD03F, 0xCD54, 0xCB37, 0xF771, 
    0xF708, 0xF65A, 0xF637, 0xF771, 0xFBD1, 0x01FB, 0x0609, 0x0748, 0x07B1, 
    0x0763, 0x0679, 0x0512, 0x022B, 0xFDD1, 0xF9B6, 0xF78C, 0xF874, 0xFB4C, 
    0xFE5F, 0xF00C, 0xEFB5, 0xEF24, 0xEF07, 0xF00C, 0xF3A8, 0xF8C0, 0xFC2E, 
    0xFD65, 0xFDFC, 0xFDFC, 0xFD72, 0xFC67, 0xF9EC, 0xF616, 0xF27A, 0xF0AE, 
    0xF1CB, 0xF4BC, 0xF7D9, 0xE2EC, 0xE286, 0xE1DB, 0xE1B9, 0xE2EC, 0xE72D, 
    0xED2C, 0xF132, 0xF283, 0xF300, 0xF2D5, 0xF231, 0xF140, 0xEF4C, 0xEC4B, 
    0xE96F, 0xE7E9, 0xE87E, 0xEA63, 0xEC73, 0x1527, 0x1527, 0x1527, 0x1527, 
    0x1527, 0x1555, 0x1583, 0x1527, 0x136E, 0x1142, 0x0F21, 0x0CEB, 0x0B00, 
    0x0917, 0x073E, 0x0585, 0x03FC, 0x0294, 0x0152, 0x0067, 0x22DF, 0x22DF, 
    0x22DF, 0x22DF, 0x22DF, 0x232B, 0x2378, 0x22DF, 0x2009, 0x1C73, 0x18F1, 
    0x154B, 0x1222, 0x0EFB, 0x0BEF, 0x0918, 0x0691, 0x043F, 0x022D, 0x00A9, 
    0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC75D, 0xC76A, 0xC777, 0xC75D, 0xC6E1, 
    0xC645, 0xC5AD, 0xC50E, 0xC484, 0xC3FB, 0xC377, 0xC2FB, 0xC28D, 0xC228, 
    0xC1CE, 0xC18C, 0x7A64, 0x6F06, 0x59F3, 0x4186, 0x2C17, 0x1BA9, 0x0E0D, 
    0x0356, 0xFF58, 0xFFFC, 0x011F, 0x036E, 0x0645, 0x09A4, 0x0CE6, 0x0F68, 
    0x1085, 0x0EF5, 0x0B36, 0x0752, 0x3394, 0x2C36, 0x1E8F, 0x0EBA, 0x00D5, 
    0xF527, 0xEB4B, 0xE661, 0xEE3D, 0xFA2B, 0x00CF, 0x0691, 0x0B6D, 0x1013, 
    0x1488, 0x18D4, 0x1CFD, 0x218D, 0x264C, 0x2A19, 0x0265, 0x0084, 0xFD12, 
    0xF971, 0xF701, 0xF66F, 0xF743, 0xF924, 0xFFA7, 0x01F1, 0xEE8D, 0xDBC5, 
    0xD93E, 0xDA42, 0xDCE6, 0xDF3D, 0xDF5C, 0xDBAD, 0xD5A1, 0xCFDB, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xC6F5, 0xC665, 0xC574, 0xC544, 0xC6F5, 0xCD51, 
    0xD623, 0xDB17, 0xD1E1, 0xCB48, 0xE132, 0xF860, 0xEC6B, 0xE2ED, 0xD966, 
    0xD105, 0xCAF4, 0xC7E9, 0xC719, 0xC770, 0xF851, 0xF6AC, 0xF39F, 0xF00B, 
    0xECD1, 0xEABC, 0xE8F4, 0xE5E2, 0xDDF3, 0xD88C, 0xE027, 0xE9BE, 0xEE1A, 
    0xF1BB, 0xF4CE, 0xF781, 0xF9FE, 0xFC4A, 0xFE2C, 0xFF77, 0x1329, 0x107B, 
    0x0BAA, 0x075C, 0x0636, 0x0B97, 0x14EC, 0x1BF4, 0x1BDB, 0x1850, 0x12AF, 
    0x0D1F, 0x0A70, 0x0843, 0x0675, 0x04E6, 0x0372, 0x021B, 0x0107, 0x004C, 
    0xC27E, 0xC840, 0xD2C7, 0xDDC4, 0xE4E6, 0xE52D, 0xE0E5, 0xDBB4, 0xD440, 
    0xCFBF, 0xD864, 0xE2A9, 0xE6CC, 0xE9FE, 0xEC83, 0xEEA5, 0xF0A8, 0xF285, 
    0xF3F6, 0xF4E8, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0xDEF8, 0xDF35, 
    0xE000, 0xE178, 0xE3BB, 0xE6E7, 0xEB1B, 0xF075, 0xF680, 0xFBBE, 0xFFDF, 
    0x028E, 0x037B, 0x017B, 0xFC93, 0xF637, 0xEFDD, 0xE8B0, 0xE075, 0xD98B, 
    0xE7DA, 0xE7F9, 0xE84B, 0xE8BA, 0xE934, 0xE9A3, 0xE9F4, 0xEA14, 0xE7B0, 
    0xE64C, 0xE592, 0xE52E, 0xE4CB, 0xE46A, 0xE453, 0xE49A, 0xE552, 0xE6E9, 
    0xE92B, 0xEB3C, 0xBDE5, 0xBC8F, 0xB902, 0xB3F0, 0xAE0A, 0xA800, 0xA284, 
    0x9E46, 0x9BCC, 0x9AFB, 0x9B34, 0x9BD9, 0x9C4C, 0x9C48, 0x9C65, 0x9D4B, 
    0x9FA3, 0xA4CD, 0xABF5, 0xB271, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x4224, 0x426F, 0x4331, 0x4439, 
    0x455A, 0x4663, 0x4725, 0x4770, 0x457A, 0x424E, 0x3E9F, 0x3B1F, 0x3881, 
    0x3752, 0x36FC, 0x3682, 0x34E7, 0x3120, 0x2C06, 0x2772, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFF09, 0xFDAF, 0xFC3D, 
    0xFB03, 0xFA4D, 0xFA57, 0xFAF2, 0xFBD3, 0xFCAD, 0xFD99, 0xFEAA, 0xFF92, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFF3, 
    0xFFE2, 0xFFCF, 0xFFC0, 0xFFB7, 0xFFB7, 0xFFBF, 0xFFCA, 0xFFD5, 0xFFE1, 
    0xFFEE, 0xFFFA, 0xD265, 0xD22C, 0xD193, 0xD0B3, 0xCFA6, 0xCE86, 0xCD6D, 
    0xCC74, 0xCB7A, 0xC9CB, 0xC7C9, 0xC5D5, 0xC450, 0xC34C, 0xC285, 0xC1DF, 
    0xC13E, 0xC091, 0xBFF0, 0xBF75, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 
    0x01C0, 0x017F, 0x00FA, 0xFFF2, 0xFE2B, 0xFA8B, 0xF5E4, 0xF2D3, 0xF18B, 
    0xF09F, 0xF048, 0xF0BA, 0xF22E, 0xF571, 0xFA85, 0x006A, 0x0623, 0x0C4B, 
    0x12FE, 0x187C, 0x089B, 0x071C, 0x0484, 0x030A, 0x04E7, 0x0E7D, 0x1C63, 
    0x2526, 0x26AD, 0x25D8, 0x23A1, 0x2106, 0x1F01, 0x1D6F, 0x1B9D, 0x19B2, 
    0x17D5, 0x15D5, 0x13BB, 0x120B, 0x9AAD, 0x9697, 0x8F02, 0x8623, 0x7E2F, 
    0x7733, 0x7107, 0x6D9B, 0x6CA0, 0x6C87, 0x6D60, 0x6F3B, 0x722A, 0x7736, 
    0x7E88, 0x86DE, 0x8EF2, 0x97A4, 0xA109, 0xA8B5, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x4D24, 0x4DE6, 0x4F29, 0x4F69, 0x4D24, 0x448F, 0x38AD, 0x322A, 0x3365, 
    0x37B9, 0x3D57, 0x426C, 0x4527, 0x4516, 0x4332, 0x3FCE, 0x3B3E, 0x3407, 
    0x2AA2, 0x2251, 0xFFEE, 0xFFFD, 0x0019, 0x0035, 0x0046, 0x0041, 0x002E, 
    0x001C, 0xFFF6, 0xFFCF, 0xFFF7, 0x012B, 0x027B, 0x0314, 0x0388, 0x03BE, 
    0x039E, 0x02E5, 0x01B4, 0x0091, 0xFF30, 0xFF32, 0xFF36, 0xFF39, 0xFF3B, 
    0xFF39, 0xFF34, 0xFF30, 0xFF2F, 0xFF2E, 0xFF2E, 0xFF2B, 0xFF2E, 0xFF42, 
    0xFF5C, 0xFF73, 0xFF7D, 0xFF71, 0xFF57, 0xFF3D, 0xCD1A, 0xCA0E, 0xC481, 
    0xBEDF, 0xBB94, 0xBCBC, 0xC0B6, 0xC451, 0xC70A, 0xC9C0, 0xCB55, 0xCA4E, 
    0xC803, 0xC5B9, 0xC32E, 0xC12A, 0xC07A, 0xC204, 0xC51E, 0xC83D, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0174, 0x0190, 0x01E3, 0x0271, 0x0345, 
    0x047B, 0x0654, 0x097E, 0x1067, 0x2955, 0xE26D, 0xF33A, 0xF8B1, 0xFB6D, 
    0xFD1A, 0xFE3D, 0xFF08, 0xFF92, 0xFFE3, 0xFFFF, 0x7CCD, 0x7C27, 0x7A3F, 
    0x7712, 0x728F, 0x6C99, 0x6517, 0x5C0F, 0x51DE, 0x4879, 0x3572, 0x2B23, 
    0x20CF, 0x17BD, 0x1037, 0x0A3F, 0x05BB, 0x028F, 0x00A6, 0x0000, 0x0D7F, 
    0x0D83, 0x0D92, 0x0DB5, 0x0DFB, 0x0E87, 0x0F9C, 0x11EF, 0x17F2, 0x2FF1, 
    0xE816, 0xF7F0, 0xFC7C, 0xFE59, 0xFF3A, 0xFFA8, 0xFFDD, 0xFFF4, 0xFFFD, 
    0x0000,
    },
    {
    0x0014, 0x0000, 0x0014, 0x0014, 0x0014, 0x0028, 0x0001, 0x003C, 0x0001, 
    0x003D, 0x0001, 0x003E, 0x0014, 0x003F, 0x0014, 0x0053, 0x0014, 0x0067, 
    0x0014, 0x007B, 0x0014, 0x008F, 0x0014, 0x00A3, 0x0014, 0x00B7, 0x0014, 
    0x00CB, 0x0014, 0x00DF, 0x0014, 0x00F3, 0x0014, 0x0107, 0x0014, 0x011B, 
    0x0014, 0x012F, 0x0014, 0x0143, 0x0014, 0x0157, 0x000B, 0x016B, 0x0013, 
    0x0176, 0x0014, 0x0189, 0x0014, 0x019D, 0x0014, 0x01B1, 0x0014, 0x01C5, 
    0x0014, 0x01D9, 0x0014, 0x01ED, 0x0014, 0x0201, 0x0014, 0x0215, 0x0014, 
    0x0229, 0x0014, 0x023D, 0x0014, 0x0251, 0x0014, 0x0265, 0x0014, 0x0279, 
    0x0014, 0x028D, 0x0014, 0x02A1, 0x0014, 0x02B5, 0x0014, 0x02C9, 0x0014, 
    0x02DD, 0x0001, 0x02F1, 0x0014, 0x02F2, 0x0014, 0x0306, 0x0014, 0x031A, 
    0x0014, 0x032E, 0x0011, 0x0342, 0x0014, 0x0353, 0x0014, 0x0367, 0x0014, 
    0x037B, 0x0014, 0x038F, 0x0014, 0x03A3, 0x0014, 0x03B7, 0x0001, 0x03CB, 
    0x0014, 0x03CC, 0x0014, 0x03E0, 0x0014, 0x03F4, 0x0014, 0x0408, 0x0013, 
    0x041C, 0x0014, 0x042F, 0x0014, 0x0443, 0x0014, 0x0457, 0x0014, 0x046B, 
    0x0013, 0x047F, 0x0014, 0x0492, 0x0014, 0x04A6, 0x0014, 0x04BA, 0x0014, 
    0x04CE, 0x0014, 0x04E2, 
})

smlua_anim_util_register_animation("MILNE_ANIM_LAND_ON_STOMACH",
    1,
    0,
    0,
    0,
    19,
    {
    0x0000, 0x0096, 0x0095, 0x008B, 0x0070, 0x003B, 0xFF94, 0xFFB5, 0xFFE0, 
    0x0001, 0x0015, 0x001B, 0x001A, 0x0012, 0xFFFD, 0xFFCB, 0xFFA8, 0xFFAF, 
    0xFFB6, 0xFFAF, 0xFFA8, 0xFFA8, 0xFFA8, 0xFFA8, 0xFFA8, 0xFFAD, 0xFFB8, 
    0xFFC6, 0xFFD1, 0xFFD5, 0xFFD5, 0xFFD2, 0xFFCF, 0xFFCA, 0xFFC5, 0xFFBF, 
    0xFFB9, 0xFFB2, 0xFFAC, 0xFFA5, 0xFF9F, 0xFF9A, 0xFF95, 0xFF92, 0xFF90, 
    0xFF8F, 0xFF8F, 0xFF8F, 0xFF8F, 0xFF8F, 0xFF90, 0xFF91, 0xFF92, 0xFF94, 
    0xFF96, 0xFF99, 0xFF9C, 0xFF9F, 0xFFA2, 0xFFA7, 0xFFAC, 0xFFB1, 0xFFB8, 
    0xFFBF, 0xFFC8, 0xFFD2, 0xFFDD, 0xFFE8, 0xFFF2, 0xFFFB, 0x001D, 0x007B, 
    0x0085, 0x0081, 0x007E, 0x0084, 0x0092, 0x009D, 0x00A4, 0x00A9, 0x00AA, 
    0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x5639, 0x5639, 0x595E, 0x60C9, 0x6971, 0x704C, 0x7419, 
    0x7681, 0x78DB, 0x7BB6, 0x7E26, 0x7FD1, 0x809A, 0x80A2, 0x807A, 0x8033, 
    0x7FDD, 0x7F92, 0x7F5F, 0x7FAA, 0x8048, 0x8070, 0x7F5F, 0x7D1C, 0x7A43, 
    0x76FD, 0x7374, 0x6FCF, 0x6C39, 0x6869, 0x643B, 0x6014, 0x5C55, 0x58C3, 
    0x54FF, 0x5141, 0x4DBE, 0x4AAE, 0x4846, 0x46BD, 0x45C9, 0x44FB, 0x4453, 
    0x43D0, 0x4373, 0x433C, 0x432A, 0x433E, 0x4376, 0x43D4, 0x4457, 0x44FF, 
    0x45CC, 0x46BD, 0x47E3, 0x4946, 0x4AE0, 0x4CA9, 0x4E9A, 0x50AB, 0x52D6, 
    0x5511, 0x5757, 0x599F, 0x5BE3, 0x5E1A, 0x603D, 0x6246, 0x642C, 0x65CA, 
    0x65B4, 0x6378, 0x6031, 0x5C43, 0x575B, 0x5170, 0x4B5B, 0x45F6, 0x421B, 
    0x40A1, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFF3, 0xFFD9, 
    0xFFC6, 0xFFCD, 0x0000, 0x0093, 0x017B, 0x0268, 0x030C, 0x0319, 0x0062, 
    0xFD8E, 0xFD2D, 0xFD24, 0xFD59, 0xFDB3, 0xFE18, 0xFE6E, 0xFEED, 0xFF98, 
    0x0000, 0x001A, 0x0028, 0x002C, 0x0029, 0x0021, 0x0016, 0x000B, 0x0003, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x131B, 0x131B, 0x12AA, 
    0x11D4, 0x1153, 0x11E3, 0x161D, 0x1BCE, 0x1C7A, 0x0DE8, 0xFDEC, 0xFDBB, 
    0x012E, 0x0186, 0x01AD, 0x01B3, 0x01A6, 0x0198, 0x0197, 0x01A6, 0x01B6, 
    0x01B6, 0x0197, 0x013F, 0x00B7, 0x0024, 0xFFAA, 0xFF6B, 0xFF8D, 0x009B, 
    0x0279, 0x044E, 0x0541, 0x0511, 0x0446, 0x0336, 0x0236, 0x019F, 0x0168, 
    0x015A, 0x017C, 0x01DA, 0x027D, 0x04A3, 0x0720, 0x0883, 0x09C5, 0x0AEF, 
    0x0C0A, 0x0D1E, 0x0E35, 0x0F50, 0x1051, 0x1112, 0x119F, 0x1222, 0x129D, 
    0x1310, 0x137E, 0x13E7, 0x144D, 0x14B1, 0x1515, 0x1556, 0x1567, 0x1572, 
    0x159E, 0x1612, 0x16F5, 0x1AC3, 0x1E58, 0x1C48, 0x19C5, 0x1C3E, 0x1D94, 
    0x19CF, 0x1464, 0x0EBF, 0x0A4F, 0x0884, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0009, 0x0018, 
    0x001B, 0x0000, 0xFF7C, 0xFE9F, 0xFDD7, 0xFD94, 0xFE46, 0x0292, 0x08B8, 
    0x0A8F, 0x0233, 0xF589, 0xF016, 0xFB07, 0x0D2F, 0x1688, 0x0C43, 0xF92F, 
    0xEDAB, 0xF346, 0x0072, 0x08E3, 0x05E8, 0xFE31, 0xF989, 0xFC35, 0x01F1, 
    0x05B4, 0x0589, 0x03C8, 0x01DF, 0x013E, 0x0207, 0x034D, 0x04E4, 0x06A0, 
    0x0853, 0x09D1, 0x0AEE, 0x0B7E, 0x0B6E, 0x0AE0, 0x09F0, 0x08BB, 0x075D, 
    0x05F3, 0x049B, 0x01FB, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xFFF9, 0xFFF9, 
    0x0000, 0x000D, 0x001F, 0x0034, 0x004F, 0x006F, 0x00A9, 0x00F2, 0x011A, 
    0x0108, 0x00D6, 0x009E, 0x004E, 0xFFFA, 0xFFF6, 0x00B7, 0x01CA, 0x0229, 
    0x0104, 0xFF2C, 0xFE14, 0xFE97, 0xFFDA, 0x00BC, 0x00C5, 0x006D, 0x0000, 
    0xFF93, 0xFF15, 0xFE93, 0xFE19, 0xFD9B, 0xFD09, 0xFC71, 0xFBDD, 0xFB5B, 
    0xFAF5, 0xFAB8, 0xFAB0, 0xFAF1, 0xFB79, 0xFC33, 0xFD0A, 0xFDE8, 0xFEB9, 
    0xFF69, 0xFFDA, 0x0000, 0xE927, 0xE8CB, 0xE7C9, 0xE643, 0xE457, 0xE0FE, 
    0xDC83, 0xD8FD, 0xD886, 0xE3F7, 0xEEEF, 0xE619, 0xDBC9, 0xDA6C, 0xDA52, 
    0xDB0C, 0xDC29, 0xDD3B, 0xDDD2, 0xDD2E, 0xDBE8, 0xDB97, 0xDDD2, 0xE325, 
    0xEA61, 0xF282, 0xFA86, 0x0169, 0x0628, 0x0723, 0x04DA, 0x017C, 0xFF3B, 
    0xFE81, 0xFE26, 0xFDF9, 0xFDC9, 0xFD65, 0xFCA2, 0xFBAA, 0xFAC6, 0xFA41, 
    0xF9D0, 0xF8E0, 0xF6E0, 0xF462, 0xF286, 0xF22E, 0xF279, 0xF1EB, 0xEF88, 
    0xEC4B, 0xE9A6, 0xE858, 0xE7A2, 0xE6B7, 0xE4E4, 0xE2DC, 0xE1E5, 0xE25E, 
    0xE38F, 0xE51C, 0xE6A9, 0xE837, 0xE9F6, 0xEBCD, 0xEDA3, 0xEF61, 0xF0ED, 
    0xF230, 0xF311, 0xF348, 0xF2CF, 0xF1F2, 0xF0FD, 0xF03B, 0xEFFA, 0xF083, 
    0xF6B4, 0xFC61, 0x0001, 0xFFFE, 0xC170, 0xA9CD, 0xA9CD, 0x9934, 0xF167, 
    0x4174, 0x185D, 0x0527, 0xC379, 0x92F8, 0x9A9A, 0x0168, 0xC142, 0x0884, 
    0xF868, 0xEE91, 0xE93E, 0xE6AA, 0xE514, 0xE2B8, 0xE11B, 0xE21E, 0xE48E, 
    0xE733, 0xEA0D, 0xED9D, 0xF173, 0xF51F, 0xF832, 0xFA3B, 0xFA38, 0xF861, 
    0xF625, 0xF4EF, 0xF4CD, 0xF4D6, 0xF501, 0xF546, 0xF59B, 0xF5F8, 0xF655, 
    0xF6A8, 0xF6EA, 0xF710, 0xF723, 0xF72F, 0xF735, 0xF736, 0xF734, 0xF72E, 
    0xF726, 0xF71E, 0xF715, 0xF70E, 0xF709, 0xF707, 0xF709, 0xF710, 0xF6DD, 
    0xF658, 0xF5C4, 0xF560, 0xF56F, 0xF632, 0xF7E9, 0xFBC1, 0x01C4, 0x0882, 
    0x0E87, 0x1262, 0x0C43, 0x07F5, 0x13BB, 0xAA0E, 0xC97B, 0xEF10, 0x16CF, 
    0xBCAE, 0xDCB1, 0xF2D6, 0xFB1C, 0xDCC8, 0xDCC8, 0xDB40, 0xA883, 0xD2B8, 
    0xCE34, 0xCB2E, 0xB2CA, 0xCFBA, 0xCB79, 0xB843, 0xB44B, 0xD058, 0xD197, 
    0xD268, 0xD2E9, 0xD338, 0xD374, 0xD3BB, 0xD37A, 0xD2B7, 0xD276, 0xD3BB, 
    0xD6C9, 0xDADE, 0xDF7B, 0xE41D, 0xE845, 0xEB71, 0xED5A, 0xEE23, 0xEDEF, 
    0xECE0, 0xEB30, 0xE915, 0xE6AC, 0xE415, 0xE16C, 0xDED2, 0xDC64, 0xDA40, 
    0xD885, 0xD752, 0xD688, 0xD5F3, 0xD58C, 0xD550, 0xD539, 0xD540, 0xD561, 
    0xD596, 0xD5DA, 0xD628, 0xD67A, 0xD6CA, 0xD714, 0xD752, 0xD76F, 0xD777, 
    0xD791, 0xD7E3, 0xD896, 0xD9D2, 0xDBBD, 0xDF40, 0xE46D, 0xEA2F, 0xEF6F, 
    0xF316, 0xF216, 0xED2E, 0xE5C0, 0xA22D, 0xA8D8, 0xAEE8, 0xB269, 0xCD87, 
    0xCF70, 0xD1BD, 0xD2DB, 0x076C, 0x076C, 0x1296, 0xAD6F, 0x4E05, 0x6A5D, 
    0x7885, 0xD38C, 0x2194, 0x1591, 0x9F64, 0xCCC0, 0x772D, 0x8427, 0x8CCD, 
    0x924C, 0x95D0, 0x9885, 0x9B97, 0x9DB8, 0x9DA0, 0x9C84, 0x9B97, 0x9AD2, 
    0x999E, 0x9852, 0x9743, 0x96CA, 0x973D, 0x9B03, 0xA17D, 0xA67E, 0xA5D5, 
    0x9FDE, 0x9810, 0x8EEA, 0x84EC, 0x7A91, 0x705C, 0x66CB, 0x5E5C, 0x578E, 
    0x52DF, 0x4FC0, 0x4D44, 0x4B62, 0x4A10, 0x4943, 0x48F0, 0x490F, 0x4994, 
    0x4A75, 0x4BA9, 0x4D24, 0x4EDD, 0x50CA, 0x52DF, 0x5683, 0x5C8D, 0x641D, 
    0x6C51, 0x744B, 0x7B2A, 0x8010, 0x81FB, 0x816B, 0x7FB3, 0x7E2C, 0x7E29, 
    0x8429, 0x8864, 0x8230, 0xF4C9, 0xE1D5, 0xCBCD, 0xB4C1, 0x18E2, 0xF94B, 
    0xDF6B, 0xD4B3, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xE258, 
    0xE258, 0xE1CD, 0xE05A, 0xDE47, 0xDBDB, 0xD95E, 0xD718, 0xD54E, 0xD4F2, 
    0xD54E, 0xD514, 0xD54E, 0xD662, 0xD7B2, 0xD91C, 0xDA7E, 0xDBB7, 0xDCA4, 
    0xDCEC, 0xDCA9, 0xDC63, 0xDCA4, 0xDD7D, 0xDE95, 0xDFD4, 0xE123, 0xE26A, 
    0xE391, 0xE568, 0xE7B7, 0xE8DE, 0xE73C, 0xE30A, 0xDDCB, 0xD7CC, 0xD157, 
    0xCAB9, 0xC43E, 0xBE30, 0xB8DB, 0xB48C, 0xB18E, 0xAF74, 0xAD9F, 0xAC14, 
    0xAAD6, 0xA9E7, 0xA94B, 0xA906, 0xA919, 0xA988, 0xAA58, 0xAB89, 0xAD21, 
    0xAF21, 0xB18E, 0xBD4C, 0xD13F, 0xDE6E, 0xE286, 0xE55D, 0xE733, 0xE848, 
    0xE8DD, 0xE933, 0xE988, 0xEA1F, 0xEB37, 0xED7C, 0xF053, 0xF20E, 0xF103, 
    0xECAB, 0xE649, 0xDED9, 0xD757, 0xD0C2, 0xCC15, 0xCA4E, 0xE6B3, 0xE6B3, 
    0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 
    0xE60D, 0xE6B3, 0xE9C3, 0xED7E, 0xF182, 0xF570, 0xF8E8, 0xFB89, 0xFC43, 
    0xFB64, 0xFA97, 0xFB89, 0xFEF4, 0x03D7, 0x0942, 0x0E41, 0x11E4, 0x133A, 
    0x1284, 0x10CA, 0x0E3F, 0x0B1A, 0x078F, 0x03D3, 0x001C, 0xFC9F, 0xF990, 
    0xF667, 0xF2E3, 0xEFA2, 0xED43, 0xEC66, 0xECB4, 0xED61, 0xEE5D, 0xEF97, 
    0xF100, 0xF288, 0xF41D, 0xF5B0, 0xF730, 0xF88E, 0xF9B9, 0xFAA0, 0xFB35, 
    0xFB65, 0xF891, 0xF296, 0xED24, 0xEBE9, 0xF098, 0xF8CF, 0x0221, 0x0A1F, 
    0x0E5C, 0x1141, 0x14D4, 0x1611, 0x13B3, 0x0F80, 0x0B07, 0x07DA, 0x05F2, 
    0x0440, 0x02CC, 0x019E, 0x00BD, 0x0030, 0x0000, 0xF989, 0xF989, 0xF989, 
    0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF98B, 
    0xF989, 0xF980, 0xF975, 0xF969, 0xF95E, 0xF954, 0xF94C, 0xF939, 0xF91F, 
    0xF91B, 0xF94C, 0xF970, 0xF95F, 0xF961, 0xF9BE, 0xFABB, 0xFCA0, 0x01A2, 
    0x094C, 0x0FE4, 0x11B2, 0x0CEA, 0x040E, 0xF9D3, 0xF0F1, 0xEC20, 0xECD9, 
    0xF14C, 0xF743, 0xFC87, 0xFEE1, 0xFEDC, 0xFE82, 0xFDDD, 0xFCF9, 0xFBDF, 
    0xFA99, 0xF932, 0xF7B4, 0xF62A, 0xF49C, 0xF317, 0xF1A3, 0xF04C, 0xEF1C, 
    0xEDD3, 0xEC73, 0xEB64, 0xEB0E, 0xEB35, 0xEB61, 0xEBA7, 0xEC18, 0xECC9, 
    0xEDCC, 0xEF34, 0xF114, 0xF533, 0xFB90, 0x0196, 0x04AE, 0x049F, 0x033D, 
    0x0105, 0xFE73, 0xFC03, 0xFA31, 0xF97B, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 
    0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2EA, 0xF2E8, 
    0xF2DB, 0xF2CC, 0xF2BB, 0xF2AB, 0xF29D, 0xF292, 0xF2D8, 0xF355, 0xF371, 
    0xF292, 0xF07D, 0xEDA3, 0xEA72, 0xE752, 0xE4B1, 0xE2F8, 0xE328, 0xE4F5, 
    0xE6DA, 0xE752, 0xE597, 0xE296, 0xDF56, 0xDCDF, 0xDC39, 0xDE49, 0xE260, 
    0xE725, 0xEB3D, 0xED51, 0xEDC6, 0xEDF1, 0xEDDB, 0xED8F, 0xED18, 0xEC80, 
    0xEBD1, 0xEB16, 0xEA58, 0xE9A3, 0xE901, 0xE87C, 0xE81E, 0xE7F2, 0xE8A2, 
    0xEA32, 0xEBB5, 0xEC3C, 0xEBBA, 0xEAD3, 0xE9AB, 0xE863, 0xE71E, 0xE5FE, 
    0xE525, 0xE4B6, 0xE54A, 0xE6E1, 0xE8B7, 0xEA08, 0xEAD1, 0xEB8C, 0xEC33, 
    0xECC0, 0xED2C, 0xED72, 0xED8B, 0x0001, 0xFFFE, 0xC170, 0x6508, 0x6508, 
    0x6F8C, 0x08BD, 0x2705, 0xC0D9, 0xCCAD, 0x232A, 0xF080, 0x71AB, 0x0A2F, 
    0xBD89, 0xE8B6, 0xF31D, 0xF818, 0xF957, 0xF88D, 0xF76A, 0xF7A2, 0xF85D, 
    0xF818, 0xF782, 0xF746, 0xF7BB, 0xF86B, 0xF8D5, 0xF8D6, 0xF890, 0xF7F4, 
    0xF71C, 0xF635, 0xF542, 0xF445, 0xF340, 0xF237, 0xF12B, 0xF021, 0xEF1B, 
    0xEE1B, 0xED23, 0xEC38, 0xEB5B, 0xEA8F, 0xE9D8, 0xE937, 0xE8AF, 0xE852, 
    0xE82A, 0xE82E, 0xE855, 0xE895, 0xE8E5, 0xE93C, 0xE991, 0xE9DB, 0xEA11, 
    0xEA2A, 0xEA1C, 0xE9DE, 0xE967, 0xE8AF, 0xE6C3, 0xE343, 0xDF01, 0xDACB, 
    0xD773, 0xD5D6, 0xD51F, 0xD38F, 0x50EE, 0x4A96, 0x3E0C, 0x2B8E, 0x123E, 
    0xF436, 0x54A3, 0x36A0, 0x1D4E, 0x0BD2, 0x054B, 0x2753, 0x2753, 0x28B0, 
    0x5408, 0x5007, 0x337E, 0x3552, 0x4EDC, 0x5492, 0x2ADF, 0x5492, 0x2AAD, 
    0x2A83, 0x2BBF, 0x2D62, 0x2F2C, 0x30E1, 0x3242, 0x3312, 0x3339, 0x32B0, 
    0x3154, 0x2EFF, 0x2AC8, 0x24EE, 0x1F0D, 0x185F, 0x11A9, 0x0ED8, 0x0F71, 
    0x1053, 0x1176, 0x12D0, 0x1459, 0x1607, 0x17D1, 0x19AD, 0x1B94, 0x1D7B, 
    0x1F59, 0x2126, 0x22D7, 0x2465, 0x25C6, 0x26F0, 0x27DB, 0x289A, 0x2946, 
    0x29DD, 0x2A5E, 0x2AC5, 0x2B12, 0x2B43, 0x2B55, 0x2B46, 0x2B15, 0x2AC0, 
    0x2A45, 0x29A1, 0x28D4, 0x27DB, 0x2562, 0x20DC, 0x1B73, 0x1651, 0x129D, 
    0x1142, 0x11BD, 0x1313, 0x69CD, 0x6630, 0x649F, 0x6343, 0x6129, 0x5EEA, 
    0x2367, 0x25B6, 0x27F0, 0x2A01, 0x2BD6, 0x193F, 0x193F, 0x1ED9, 0xAC51, 
    0xBCAB, 0x4AE9, 0x520C, 0xBF8F, 0xA6B1, 0x1FD2, 0xA6B1, 0x4991, 0x694D, 
    0x717D, 0x7609, 0x7809, 0x7894, 0x78C3, 0x79AD, 0x7A16, 0x7923, 0x7877, 
    0x79BB, 0x7ECA, 0x8651, 0x8D20, 0x926D, 0x9704, 0x9A24, 0x9C49, 0x9E6D, 
    0xA08E, 0xA2A9, 0xA4BC, 0xA6C5, 0xA8C2, 0xAAB0, 0xAC8D, 0xAE56, 0xB00A, 
    0xB1A6, 0xB328, 0xB48D, 0xB5D3, 0xB6F7, 0xB7F8, 0xB8EC, 0xB9E3, 0xBAD5, 
    0xBBB9, 0xBC86, 0xBD34, 0xBDB8, 0xBE0B, 0xBE24, 0xBDF9, 0xBD82, 0xBCB5, 
    0xBB8B, 0xB9FA, 0xB7F8, 0xB2F9, 0xA9DE, 0x9ECB, 0x93E2, 0x8B46, 0x86C0, 
    0x84AA, 0x81F8, 0xFDEC, 0xF73C, 0xEC64, 0xDCBC, 0xC721, 0xADC9, 0x132A, 
    0xF9B7, 0xE3E5, 0xD428, 0xCCF5, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xEE91, 0xEE91, 0xED94, 0xEAF4, 0xE732, 0xE2CF, 0xDE4D, 0xDA2D, 
    0xD6F0, 0xD648, 0xD6F0, 0xD66A, 0xD6F0, 0xD964, 0xDC61, 0xDF9A, 0xE2C1, 
    0xE588, 0xE7A4, 0xE8D5, 0xE927, 0xE8B7, 0xE7A4, 0xE3FE, 0xDF23, 0xDE28, 
    0xE648, 0xF247, 0xF788, 0xF593, 0xF314, 0xF01E, 0xECC1, 0xE910, 0xE51E, 
    0xE0FB, 0xDCBB, 0xD870, 0xD42B, 0xCFFE, 0xCBFC, 0xC837, 0xC4C1, 0xC1AC, 
    0xBF09, 0xBCEC, 0xBB30, 0xB9A7, 0xB856, 0xB73D, 0xB660, 0xB5C1, 0xB564, 
    0xB54B, 0xB578, 0xB5EF, 0xB6B2, 0xB7C3, 0xB926, 0xBADE, 0xBCEC, 0xC21D, 
    0xCB9B, 0xD6F6, 0xE1BC, 0xE97E, 0xEB99, 0xE9D6, 0xE869, 0xE95F, 0xEB01, 
    0xEBDC, 0xEA7E, 0xE666, 0xE09B, 0xD9F7, 0xD351, 0xCD85, 0xC96B, 0xC7DC, 
    0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 
    0x2D60, 0x2B98, 0x1C67, 0x0F13, 0x0CC7, 0x0C4D, 0x0D08, 0x0E5A, 0x0FA5, 
    0x104B, 0x1102, 0x1214, 0x1241, 0x104B, 0x0A17, 0x00D3, 0xF835, 0xF078, 
    0xE960, 0xE5F1, 0xE5A3, 0xE5DC, 0xE684, 0xE782, 0xE8BD, 0xEA1E, 0xEB8A, 
    0xECEB, 0xEE26, 0xEF24, 0xEFCD, 0xEFFA, 0xEFB6, 0xEF2D, 0xEE8D, 0xEE02, 
    0xEDB8, 0xEDA6, 0xED9E, 0xEDA1, 0xEDAB, 0xEDBA, 0xEDCD, 0xEDE1, 0xEDF5, 
    0xEE05, 0xEE11, 0xEE16, 0xEE11, 0xEE01, 0xEDE5, 0xEDB8, 0xED38, 0xEC4E, 
    0xEB3A, 0xEA3E, 0xE99E, 0xE880, 0xE7E5, 0xEACF, 0xF3AD, 0xFFFC, 0x0B5B, 
    0x1168, 0x11DB, 0x0FEB, 0x0C71, 0x0844, 0x043C, 0x0133, 0xFFFF, 0x0E42, 
    0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 
    0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 
    0x0DEF, 0x0D64, 0x0D48, 0x0E42, 0x11B1, 0x16AB, 0x1A66, 0x1BE9, 0x1C2C, 
    0x1B53, 0x19D2, 0x1812, 0x1623, 0x1415, 0x11F7, 0x0FD8, 0x0DC8, 0x0BD7, 
    0x0A14, 0x088E, 0x0755, 0x06BF, 0x06E8, 0x0789, 0x085A, 0x0917, 0x0976, 
    0x097E, 0x0966, 0x0936, 0x08F3, 0x08A7, 0x0857, 0x080A, 0x07C8, 0x0798, 
    0x0781, 0x0789, 0x07B9, 0x0816, 0x08A8, 0x0976, 0x0B63, 0x0EDD, 0x133F, 
    0x17E0, 0x1C1B, 0x2182, 0x2701, 0x27FB, 0x2221, 0x1891, 0x0ECD, 0x0858, 
    0x0536, 0x02FB, 0x017F, 0x009D, 0x002B, 0x0004, 0xFFFF, 0xEA48, 0xEA48, 
    0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 
    0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA5A, 
    0xEA78, 0xEA7E, 0xEA48, 0xEAC8, 0xEAF2, 0xE7A7, 0xDC2E, 0xCD40, 0xC5EC, 
    0xC6B5, 0xC89D, 0xCB6E, 0xCEF4, 0xD2F8, 0xD746, 0xDBA9, 0xDFEB, 0xE3D7, 
    0xE738, 0xE9D8, 0xEB70, 0xEC0F, 0xEC04, 0xEB9F, 0xEB2E, 0xEB00, 0xEB13, 
    0xEB2E, 0xEB4F, 0xEB73, 0xEB97, 0xEBBA, 0xEBD8, 0xEBEF, 0xEBFD, 0xEBFF, 
    0xEBF3, 0xEBD6, 0xEBA5, 0xEB5F, 0xEB00, 0xEA15, 0xE86A, 0xE65C, 0xE44C, 
    0xE298, 0xE0C6, 0xDF44, 0xDFC6, 0xE34D, 0xE88B, 0xEDC1, 0xF12F, 0xF2D9, 
    0xF3FE, 0xF4B6, 0xF51B, 0xF545, 0xF54B, 0xF548, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xBF5E, 0xE7BB, 0xE87F, 0xEA76, 0xED1D, 0xEFF3, 0xF277, 0xF529, 0xF7E5, 
    0xF934, 0xF660, 0xF303, 0xF3C9, 0xF559, 0xF5EC, 0xF66F, 0xF6E3, 0xF747, 
    0xF79D, 0xF7E4, 0xF807, 0xF7FF, 0xF7EA, 0xF7E4, 0xF7A3, 0xF704, 0xF669, 
    0xF62F, 0xF6B5, 0xF85B, 0xFC39, 0x023D, 0x0908, 0x0F39, 0x150C, 0x1B5F, 
    0x21C9, 0x27E1, 0xAD3D, 0xB176, 0xB422, 0xB5B9, 0xB6FD, 0xB7F2, 0xB89F, 
    0xB909, 0xB934, 0xB925, 0xB8E2, 0xB870, 0xB7D3, 0xB712, 0xB630, 0xB534, 
    0xB422, 0xB2DA, 0xB140, 0xAF5D, 0xAD39, 0x2ADF, 0x2856, 0x25A8, 0x22DF, 
    0x2004, 0x1D20, 0x1A3C, 0x1761, 0x14AF, 0x11A6, 0x0D5F, 0x06F4, 0xF070, 
    0xF160, 0xF1A0, 0xF064, 0xEC1B, 0xE69D, 0xE0CC, 0xDB8C, 0xD7C0, 0xD649, 
    0xF849, 0xF8D8, 0xFA25, 0xFB9D, 0xFCB1, 0xFCCE, 0xFA4F, 0xF631, 0xF3D3, 
    0xF71D, 0xFAFA, 0xF95F, 0xF6FA, 0xF649, 0xF5C6, 0xF564, 0xF51A, 0xF4DE, 
    0xF4A4, 0xF484, 0xF48A, 0xF49D, 0xF4A4, 0xF4CA, 0xF526, 0xF580, 0xF5A0, 
    0xF54F, 0xF454, 0xF1C6, 0xEDC7, 0xE9AC, 0xE6CD, 0xE528, 0xE3D1, 0xE2BF, 
    0xE1E9, 0x9EB9, 0x9F34, 0x9F8E, 0x9FE1, 0xA03C, 0xA099, 0xA0F3, 0xA146, 
    0xA18C, 0xA1C0, 0xA1DD, 0xA1DE, 0xA1BE, 0xA178, 0xA107, 0xA065, 0x9F8E, 
    0x9E63, 0x9CD6, 0x9AF6, 0x98D6, 0xE977, 0xEBE5, 0xEE60, 0xF0D6, 0xF336, 
    0xF570, 0xF772, 0xF92A, 0xFA30, 0xFA59, 0xF9F5, 0xF952, 0xF5E8, 0xF42A, 
    0xF3B8, 0xF2F4, 0xF1C5, 0xF056, 0xEEDC, 0xED8C, 0xEC9C, 0xEC40, 0xD24C, 
    0xD1D4, 0xD057, 0xCDB9, 0xC9DD, 0xC4A8, 0xB985, 0xAAD5, 0xA2EC, 0xAFE0, 
    0xBF39, 0xBA28, 0xB1C1, 0xAF14, 0xACEC, 0xAB2E, 0xA9C4, 0xA893, 0xA785, 
    0xA6F9, 0xA717, 0xA76C, 0xA785, 0xA772, 0xA778, 0xA775, 0xA746, 0xA6C8, 
    0xA5DA, 0xA43B, 0xA1DD, 0x9EEC, 0x9B95, 0x97A1, 0x9302, 0x8E1B, 0x8950, 
    0x0507, 0x01A2, 0xFF82, 0xFE56, 0xFD7C, 0xFCE9, 0xFC95, 0xFC78, 0xFC89, 
    0xFCBF, 0xFD12, 0xFD79, 0xFDEC, 0xFE63, 0xFED3, 0xFF36, 0xFF82, 0xFFCE, 
    0x0038, 0x00B4, 0x0141, 0x81D8, 0x8278, 0x831A, 0x83BB, 0x8454, 0x84E2, 
    0x855F, 0x85C8, 0x857D, 0x849A, 0x842F, 0x854B, 0x90F0, 0x9186, 0x9353, 
    0x95FB, 0x9B75, 0xA231, 0xA92E, 0xAF6B, 0xB3E6, 0xB59D, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x1DE1, 0x1E7F, 
    0x2005, 0x21F9, 0x23DD, 0x2537, 0x259F, 0x256B, 0x2537, 0x2614, 0x2537, 
    0x1D5C, 0x175C, 0x1881, 0x1B09, 0x1E5E, 0x21E8, 0x2510, 0x2740, 0x2789, 
    0x2670, 0x258A, 0x2670, 0x2958, 0x2D2D, 0x3192, 0x3629, 0x3A95, 0x3E79, 
    0x41A1, 0x444D, 0x46CF, 0x4979, 0x4C94, 0x5007, 0x5393, 0x56F9, 0x59FB, 
    0x5C5B, 0x5DD8, 0x5EB1, 0x5F50, 0x5FBB, 0x5FF7, 0x600C, 0x6000, 0x5FD9, 
    0x5F9C, 0x5F51, 0x5EFE, 0x5EA8, 0x5E56, 0x5E0F, 0x5DD8, 0x5DBA, 0x5DB1, 
    0x5DB3, 0x5DB6, 0x5DB1, 0x5D99, 0x5D64, 0x5D0A, 0x5C7E, 0x5BB9, 0x5AAF, 
    0x5958, 0x571E, 0x5349, 0x4D92, 0x45B6, 0x2C3B, 0x2A22, 0x2D65, 0x2F9D, 
    0x2E6A, 0x2C5F, 0x29F4, 0x27A3, 0x25E6, 0x2537, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x000F, 0x0038, 0x0074, 0x00BC, 0x0108, 0x0153, 0x0193, 0x01C4, 
    0x01DC, 0x01D6, 0x01AB, 0x0153, 0x00C6, 0x0000, 0xFEEE, 0xFD90, 0xFBEF, 
    0xFA16, 0xF811, 0xF5E9, 0xF3AA, 0xF15F, 0xEF12, 0xECCF, 0xEAA0, 0xE88F, 
    0xE626, 0xE3A4, 0xE22A, 0xE632, 0xFA21, 0xFAA1, 0xF98F, 0xF92E, 0xFA27, 
    0xFB8B, 0xFD18, 0xFE87, 0xFF96, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0012, 0x0045, 0x008F, 0x00E7, 0x0145, 0x01A0, 0x01F0, 0x022B, 0x024A, 
    0x0242, 0x020D, 0x01A0, 0x00F4, 0xFFFF, 0xFEAF, 0xFD00, 0xFAFE, 0xF8B7, 
    0xF639, 0xF392, 0xF0CE, 0xEDFC, 0xEB29, 0xE862, 0xE5B6, 0xE331, 0xE02B, 
    0xDD15, 0xDBA2, 0xE2EC, 0x0201, 0x0244, 0x0032, 0xFECB, 0xFEAF, 0xFEDA, 
    0xFF2F, 0xFF8F, 0xFFDF, 0xFFFF, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 
    0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBD02, 0xBF3F, 0xD24B, 0xE31A, 0xE636, 
    0xE716, 0xE676, 0xE518, 0xE3B9, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
    0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE2E4, 0xE28C, 0xE27A, 
    0xE31A, 0xE486, 0xE66C, 0xE892, 0xEAC2, 0xECC3, 0xEE5B, 0xEF53, 0xEFE1, 
    0xF060, 0xF0CF, 0xF12C, 0xF174, 0xF1A6, 0xF1C1, 0xF1C3, 0xF1A9, 0xF172, 
    0xF11D, 0xF0A7, 0xF00F, 0xEF53, 0xEE5F, 0xED28, 0xEBB7, 0xEA14, 0xE84A, 
    0xE660, 0xE460, 0xE253, 0xE043, 0xDE37, 0xDC3B, 0xDA56, 0xDA64, 0xDA36, 
    0xD3C4, 0xABFB, 0xAF9C, 0xB416, 0xB1B4, 0xB06D, 0xB27E, 0xB582, 0xB8E2, 
    0xBC06, 0xBE58, 0xBF3F, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x100E, 0x0FFF, 
    0x0FD0, 0x0F83, 0x0F17, 0x0E8D, 0x0D7E, 0x0C1A, 0x0B40, 0x0C07, 0x0D15, 
    0x0CCE, 0x0C48, 0x0C0B, 0x0BD2, 0x0B9E, 0x0B6F, 0x0B47, 0x0B26, 0x0B1D, 
    0x0B2A, 0x0B35, 0x0B26, 0x0B30, 0x0B6D, 0x0BA2, 0x0B93, 0x0B05, 0x09BB, 
    0x074B, 0x03A2, 0xFF0D, 0xF9D5, 0xF3A8, 0xEC6C, 0xE4BF, 0xDD3D, 0xD685, 
    0xD133, 0xCDE5, 0xCC05, 0x4A90, 0x497D, 0x48C3, 0x485C, 0x483E, 0x4862, 
    0x48BF, 0x494E, 0x4A07, 0x4AE1, 0xCBD3, 0xCCD7, 0xCDE5, 0xCF14, 0xD082, 
    0xD22B, 0xD40D, 0xD623, 0xD86A, 0xDAE0, 0xDD81, 0xE049, 0xE335, 0xE643, 
    0xE96E, 0xEDA2, 0xF36A, 0xFA37, 0x0179, 0x0DEC, 0x09D5, 0x02CB, 0xFC77, 
    0xFA84, 0xFED4, 0x0703, 0x1049, 0x17E3, 0x1B09, 0x0F96, 0x0E80, 0x0BE1, 
    0x08A7, 0x05C3, 0x0424, 0x0542, 0x082C, 0x0A36, 0x0934, 0x07AF, 0x0825, 
    0x08EF, 0x093F, 0x0986, 0x09C5, 0x09FC, 0x0A2B, 0x0A52, 0x0A60, 0x0A53, 
    0x0A45, 0x0A52, 0x0A36, 0x09D2, 0x0975, 0x0970, 0x0A12, 0x0BAA, 0x1000, 
    0x16BF, 0x1D11, 0x201E, 0x1FB4, 0x1DDC, 0x1B17, 0x17E6, 0x14CA, 0x1243, 
    0x10D2, 0x1031, 0x7042, 0x708C, 0x70B2, 0x70BA, 0x70A9, 0x7085, 0x7053, 
    0x7018, 0x6FDA, 0x6F9E, 0x1096, 0x10BD, 0x10D2, 0x10DB, 0x10E2, 0x10E8, 
    0x10F0, 0x10FA, 0x1106, 0x1116, 0x112C, 0x1147, 0x116A, 0x1195, 0x11CA, 
    0x1283, 0x13B6, 0x149B, 0x146B, 0x0CD6, 0x0B41, 0x0A6A, 0x0A31, 0x0A79, 
    0x0B7F, 0x0D38, 0x0F1D, 0x10A4, 0x1144, 0xC65D, 0xC5F9, 0xC4D3, 0xC2F7, 
    0xC071, 0xBD4C, 0xB76D, 0xAFBF, 0xAAD3, 0xAE3C, 0xB334, 0xB1C6, 0xAF3E, 
    0xAE31, 0xAD3B, 0xAC5F, 0xAB9C, 0xAAF6, 0xAA6C, 0xAA40, 0xAA72, 0xAAA1, 
    0xAA6C, 0xA9E2, 0xA94A, 0xA895, 0xA7B0, 0xA68D, 0xA51B, 0xA304, 0xA041, 
    0x9D2F, 0x9A30, 0x9718, 0x93A8, 0x901F, 0x8CBA, 0x89BA, 0x875C, 0x85DF, 
    0x8500, 0x0451, 0x03CD, 0x0372, 0x033C, 0x0329, 0x0334, 0x035C, 0x039C, 
    0x03F2, 0x045A, 0x84D0, 0x8553, 0x85DF, 0x8683, 0x874E, 0x883E, 0x894D, 
    0x8A78, 0x8BBB, 0x8D12, 0x8E78, 0x8FEA, 0x9164, 0x92E1, 0x945D, 0x9682, 
    0x995C, 0x9C04, 0x9D91, 0x97D4, 0x94F2, 0x9214, 0x9066, 0x9117, 0x955F, 
    0x9C4A, 0xA3C9, 0xA9CC, 0xAC43, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x3996, 0x3A60, 0x3C0F, 0x3D97, 0x3DED, 
    0x3C07, 0x343C, 0x2829, 0x1EB2, 0x1D3A, 0x1EB2, 0x1E87, 0x1EB2, 0x1F7B, 
    0x2070, 0x2179, 0x227A, 0x235A, 0x23FE, 0x23B7, 0x22BA, 0x2246, 0x2395, 
    0x26EC, 0x2B60, 0x306E, 0x3592, 0x3A4A, 0x3E11, 0x400F, 0x40A7, 0x412D, 
    0x42F5, 0x465D, 0x4A9A, 0x4F3F, 0x53E0, 0x5811, 0x5B65, 0x5D70, 0x5E96, 
    0x5F85, 0x603F, 0x60C6, 0x611E, 0x6148, 0x6148, 0x611F, 0x60D1, 0x6060, 
    0x5FCE, 0x5F1F, 0x5E54, 0x5D70, 0x5C55, 0x5AEA, 0x593A, 0x5750, 0x5537, 
    0x52FB, 0x50A7, 0x4E47, 0x4BE4, 0x498C, 0x4748, 0x4524, 0x43A2, 0x4276, 
    0x4073, 0x3C6D, 0x2A0B, 0x2AD9, 0x2EBB, 0x32B7, 0x33D5, 0x30C2, 0x2B4F, 
    0x253F, 0x2052, 0x1E4A, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0006, 0xFFFF, 0xFFCD, 0xFF9F, 0xFF95, 0xFF90, 
    0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF93, 0xFF94, 0xFF95, 0xFF93, 0xFF8E, 
    0xFF88, 0xFF81, 0xFF79, 0xFF72, 0xFF6B, 0xFF65, 0xFF5E, 0xFF58, 0xFF53, 
    0xFF4F, 0xFF4B, 0xFF47, 0xFF43, 0xFF40, 0xFF3E, 0xFF3C, 0xFF36, 0xFF25, 
    0xFF0E, 0xFEF2, 0xFED5, 0xFEB9, 0xFEA0, 0xFE8E, 0xFE85, 0xFE87, 0xFE99, 
    0xFEBB, 0xFEF0, 0xFF3C, 0xFFAA, 0x003D, 0x00EF, 0x01BA, 0x0295, 0x037B, 
    0x0464, 0x0549, 0x0624, 0x06EE, 0x079F, 0x0831, 0x07B9, 0x065C, 0x05AD, 
    0x0741, 0x1856, 0x1A74, 0x1900, 0x1865, 0x0D0A, 0x09F9, 0x0872, 0x069C, 
    0x02A7, 0x0000, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 
    0xFF2F, 0xFF2F, 0xFF2D, 0xFF2F, 0xFF3B, 0xFF46, 0xFF4A, 0xFF4B, 0xFF4C, 
    0xFF4D, 0xFF4D, 0xFF4E, 0xFF4D, 0xFF4C, 0xFF4C, 0xFF4E, 0xFF51, 0xFF56, 
    0xFF5B, 0xFF61, 0xFF67, 0xFF6D, 0xFF73, 0xFF7B, 0xFF82, 0xFF8A, 0xFF91, 
    0xFF98, 0xFFA0, 0xFFA7, 0xFFAE, 0xFFB3, 0xFFB6, 0xFFA7, 0xFF7B, 0xFF3A, 
    0xFEEC, 0xFE99, 0xFE47, 0xFE00, 0xFDCB, 0xFDAF, 0xFDB5, 0xFDE4, 0xFE44, 
    0xFEDC, 0xFFB6, 0x00E9, 0x027E, 0x0465, 0x068E, 0x08E7, 0x0B62, 0x0DEC, 
    0x1077, 0x12F0, 0x1549, 0x1770, 0x1955, 0x1B03, 0x1C42, 0x1C9D, 0x1B9F, 
    0x1044, 0x1A12, 0x177F, 0x1662, 0x14B0, 0x10C7, 0x0C72, 0x080E, 0x028B, 
    0xFF2F, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 
    0xC9D7, 0xC89E, 0xC9D7, 0xD424, 0xDD66, 0xDF84, 0xE081, 0xE0B7, 0xE081, 
    0xE03B, 0xE041, 0xE03B, 0xDFE8, 0xDFC1, 0xE041, 0xE16B, 0xE2E5, 0xE497, 
    0xE669, 0xE841, 0xEA08, 0xEBD9, 0xEDC6, 0xEFAA, 0xF15D, 0xF2FE, 0xF4B3, 
    0xF665, 0xF7FB, 0xF95D, 0xFA73, 0xFB24, 0xFB9A, 0xFC0B, 0xFC73, 0xFCD0, 
    0xFD1F, 0xFD5B, 0xFD81, 0xFD8F, 0xFD81, 0xFD54, 0xFD04, 0xFC8E, 0xFBEF, 
    0xFB24, 0xFA26, 0xF8F3, 0xF78E, 0xF5FA, 0xF43B, 0xF251, 0xF042, 0xEE10, 
    0xEBBD, 0xE94D, 0xE6C2, 0xE420, 0xE143, 0xDD84, 0xD820, 0xD053, 0xB5D2, 
    0xBF0E, 0xBBD2, 0xBC3A, 0xBB80, 0xBD00, 0xBEF4, 0xC17D, 0xC662, 0xC9D7, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
    0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xF813, 0xE58E, 0xD309, 0xCB1D, 0xCCE1, 0xD17F, 0xD7E8, 0xDEF1, 
    0xE55A, 0xE9F8, 0xEBBD, 0xE76A, 0xDDBF, 0xD414, 0xCFC1, 0xD00D, 0xD0EC, 
    0xD257, 0xD44A, 0xD6C1, 0xD9BA, 0xDD32, 0xE123, 0xE585, 0xEA4A, 0xEF62, 
    0xF4B5, 0xFA29, 0xFFA2, 0x0501, 0x0A2A, 0x0F04, 0x137B, 0x177F, 0x1B07, 
    0x1E0B, 0x2086, 0x2273, 0x23D0, 0x2497, 0x24C2, 0x2487, 0x2424, 0x239D, 
    0x22F2, 0x2228, 0x213F, 0x203B, 0x1F1D, 0x1DE7, 0x1C9D, 0x1B3F, 0x19D1, 
    0x1855, 0x16CD, 0x153D, 0x13A6, 0x120D, 0x1073, 0x0EDC, 0x0D4B, 0x0BC3, 
    0x0A46, 0x08D8, 0x077B, 0x0633, 0x0502, 0x03EB, 0x02F1, 0x0216, 0x015D, 
    0x00C8, 0x005B, 0x0017, 0x0000, 
    },
    {
    0x0001, 0x0000, 0x0050, 0x0001, 0x0001, 0x0051, 0x0001, 0x0052, 0x0001, 
    0x0053, 0x0001, 0x0054, 0x0050, 0x0055, 0x0050, 0x00A5, 0x0050, 0x00F5, 
    0x004F, 0x0145, 0x004F, 0x0194, 0x0050, 0x01E3, 0x0050, 0x0233, 0x0050, 
    0x0283, 0x0050, 0x02D3, 0x0001, 0x0323, 0x0001, 0x0324, 0x0001, 0x0325, 
    0x0050, 0x0326, 0x0050, 0x0376, 0x0050, 0x03C6, 0x004F, 0x0416, 0x0050, 
    0x0465, 0x0050, 0x04B5, 0x0050, 0x0505, 0x0050, 0x0555, 0x0050, 0x05A5, 
    0x0001, 0x05F5, 0x0001, 0x05F6, 0x0001, 0x05F7, 0x0050, 0x05F8, 0x0050, 
    0x0648, 0x0050, 0x0698, 0x0050, 0x06E8, 0x004F, 0x0738, 0x0050, 0x0787, 
    0x0050, 0x07D7, 0x0050, 0x0827, 0x0050, 0x0877, 0x004F, 0x08C7, 0x004D, 
    0x0916, 0x0001, 0x0963, 0x0050, 0x0964, 0x0050, 0x09B4, 0x0050, 0x0A04, 
    0x004B, 0x0A54, 0x004E, 0x0A9F, 0x0050, 0x0AED, 0x0050, 0x0B3D, 0x0050, 
    0x0B8D, 0x0050, 0x0BDD, 0x004F, 0x0C2D, 0x004D, 0x0C7C, 0x0001, 0x0CC9, 
    0x0050, 0x0CCA, 0x0050, 0x0D1A, 0x0050, 0x0D6A, 0x004D, 0x0DBA, 0x004C, 
    0x0E07, 0x0050, 0x0E53, 0x0050, 0x0EA3, 0x0050, 0x0EF3, 0x0050, 0x0F43, 
    0x0050, 0x0F93, 0x004D, 0x0FE3, 0x0050, 0x1030, 0x0042, 0x1080, 0x0047, 
    0x10C2, 0x0050, 0x1109,
})

smlua_anim_util_register_animation("MILNE_ANIM_CRAWLING",
    0,
    0,
    0,
    0,
    91,
    {
    0x0000, 0xFFD1, 0xFFD1, 0xFFD1, 0xFFD1, 0xFFD1, 0xFFD1, 0xFFD0, 0xFFD0, 
    0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFCF, 0xFFCF, 
    0xFFCF, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFCE, 0xFFCE, 0xFFCE, 0xFFCE, 0xFFCE, 
    0xFFCE, 0xFFCE, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 
    0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 
    0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 
    0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 
    0xFFCD, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCE, 0xFFCE, 0xFFCE, 0xFFCE, 0xFFCE, 
    0xFFCE, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFCF, 0xFFD0, 
    0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD0, 0xFFD1, 0xFFDD, 
    0x0000, 0x3FFF, 0x0000, 0xFDEA, 0xFDEA, 0xFDEA, 0xFDEA, 0xFDEC, 0xFDF1, 
    0xFDF9, 0xFE05, 0xFE13, 0xFE25, 0xFE38, 0xFE4F, 0xFE67, 0xFE82, 0xFE9F, 
    0xFEBD, 0xFEDD, 0xFEFF, 0xFF22, 0xFF46, 0xFF6B, 0xFF91, 0xFFB7, 0xFFDE, 
    0x0006, 0x002D, 0x0055, 0x007C, 0x00A3, 0x00C9, 0x00EF, 0x0114, 0x0138, 
    0x015B, 0x017D, 0x019D, 0x01BB, 0x01D8, 0x01F3, 0x020C, 0x0222, 0x0236, 
    0x0247, 0x0256, 0x0261, 0x026A, 0x026F, 0x0271, 0x026F, 0x026A, 0x0261, 
    0x0256, 0x0247, 0x0236, 0x0222, 0x020C, 0x01F3, 0x01D8, 0x01BB, 0x019D, 
    0x017D, 0x015B, 0x0138, 0x0114, 0x00EF, 0x00C9, 0x00A3, 0x007C, 0x0055, 
    0x002D, 0x0006, 0xFFDE, 0xFFB7, 0xFF91, 0xFF6B, 0xFF46, 0xFF22, 0xFEFF, 
    0xFEDD, 0xFEBD, 0xFE9F, 0xFE82, 0xFE67, 0xFE4F, 0xFE38, 0xFE25, 0xFE13, 
    0xFE05, 0xFDF9, 0xFDF1, 0xFDEC, 0xFDEA, 0x0708, 0x0708, 0x0708, 0x0708, 
    0x0702, 0x06F1, 0x06D4, 0x06AD, 0x067D, 0x0642, 0x05FF, 0x05B4, 0x0561, 
    0x0507, 0x04A7, 0x0440, 0x03D4, 0x0363, 0x02ED, 0x0274, 0x01F7, 0x0178, 
    0x00F6, 0x0073, 0xFFEF, 0xFF6A, 0xFEE5, 0xFE60, 0xFDDD, 0xFD5B, 0xFCDC, 
    0xFC5F, 0xFBE6, 0xFB71, 0xFAFF, 0xFA93, 0xFA2D, 0xF9CC, 0xF972, 0xF91F, 
    0xF8D4, 0xF891, 0xF857, 0xF826, 0xF7FF, 0xF7E2, 0xF7D1, 0xF7CB, 0xF7D1, 
    0xF7E2, 0xF7FF, 0xF826, 0xF857, 0xF891, 0xF8D4, 0xF91F, 0xF972, 0xF9CC, 
    0xFA2D, 0xFA93, 0xFAFF, 0xFB71, 0xFBE6, 0xFC5F, 0xFCDC, 0xFD5B, 0xFDDD, 
    0xFE60, 0xFEE5, 0xFF6A, 0xFFEF, 0x0073, 0x00F6, 0x0178, 0x01F7, 0x0274, 
    0x02ED, 0x0363, 0x03D4, 0x0440, 0x04A7, 0x0507, 0x0561, 0x05B4, 0x05FF, 
    0x0642, 0x067D, 0x06AD, 0x06D4, 0x06F1, 0x0702, 0x0708, 0x7431, 0x7431, 
    0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7430, 0x7430, 0x7430, 
    0x7430, 0x742F, 0x742F, 0x742E, 0x742E, 0x742D, 0x742D, 0x742C, 0x742C, 
    0x742B, 0x742B, 0x742A, 0x742A, 0x7429, 0x7429, 0x7428, 0x7427, 0x7427, 
    0x7426, 0x7426, 0x7425, 0x7425, 0x7424, 0x7424, 0x7423, 0x7423, 0x7422, 
    0x7422, 0x7422, 0x7421, 0x7421, 0x7421, 0x7420, 0x7420, 0x7420, 0x7420, 
    0x7420, 0x7420, 0x7420, 0x7420, 0x7420, 0x7421, 0x7421, 0x7421, 0x7422, 
    0x7422, 0x7422, 0x7423, 0x7423, 0x7424, 0x7424, 0x7425, 0x7425, 0x7426, 
    0x7426, 0x7427, 0x7427, 0x7428, 0x7429, 0x7429, 0x742A, 0x742A, 0x742B, 
    0x742B, 0x742C, 0x742C, 0x742D, 0x742D, 0x742E, 0x742E, 0x742F, 0x742F, 
    0x7430, 0x7430, 0x7430, 0x7430, 0x7431, 0x070C, 0x070C, 0x070C, 0x070C, 
    0x0706, 0x06F3, 0x06D4, 0x06AB, 0x0677, 0x063A, 0x05F6, 0x05A9, 0x0556, 
    0x04FD, 0x04A0, 0x043E, 0x03D8, 0x0371, 0x0308, 0x029E, 0x0234, 0x01CB, 
    0x0163, 0x00FF, 0x009D, 0x0040, 0xFFE8, 0xFF96, 0xFF43, 0xFEE9, 0xFE8A, 
    0xFE25, 0xFDBD, 0xFD53, 0xFCE8, 0xFC7E, 0xFC16, 0xFBB1, 0xFB50, 0xFAF5, 
    0xFAA0, 0xFA54, 0xFA12, 0xF9DA, 0xF9AF, 0xF990, 0xF981, 0xF981, 0xF993, 
    0xF9B7, 0xF9EB, 0xFA2C, 0xFA7B, 0xFAD5, 0xFB39, 0xFBA4, 0xFC17, 0xFC8E, 
    0xFD09, 0xFD86, 0xFE03, 0xFE7F, 0xFEF9, 0xFF6E, 0xFFDD, 0x0045, 0x00A4, 
    0x00F9, 0x0149, 0x019C, 0x01F1, 0x0247, 0x029E, 0x02F6, 0x034D, 0x03A4, 
    0x03FA, 0x044E, 0x04A0, 0x04EF, 0x053B, 0x0583, 0x05C6, 0x0605, 0x063E, 
    0x0672, 0x069F, 0x06C5, 0x06E3, 0x06FA, 0x0708, 0x070C, 0xF13B, 0xF13B, 
    0xF13B, 0xF13B, 0xF149, 0xF170, 0xF1B0, 0xF206, 0xF271, 0xF2F0, 0xF37F, 
    0xF41E, 0xF4CB, 0xF584, 0xF647, 0xF713, 0xF7E6, 0xF8BE, 0xF999, 0xFA77, 
    0xFB54, 0xFC2F, 0xFD07, 0xFDD9, 0xFEA5, 0xFF67, 0x0020, 0x00CC, 0x017A, 
    0x0237, 0x0301, 0x03D5, 0x04B0, 0x058F, 0x0670, 0x0750, 0x082D, 0x0903, 
    0x09D0, 0x0A91, 0x0B43, 0x0BE5, 0x0C72, 0x0CE9, 0x0D46, 0x0D88, 0x0DAA, 
    0x0DAB, 0x0D87, 0x0D3F, 0x0CD5, 0x0C4E, 0x0BAC, 0x0AF2, 0x0A25, 0x0946, 
    0x0859, 0x0762, 0x0663, 0x0560, 0x045C, 0x035A, 0x025D, 0x0169, 0x0081, 
    0xFFA8, 0xFEE2, 0xFE31, 0xFD88, 0xFCD9, 0xFC26, 0xFB6F, 0xFAB6, 0xF9FC, 
    0xF941, 0xF888, 0xF7D1, 0xF71E, 0xF66F, 0xF5C5, 0xF523, 0xF489, 0xF3F8, 
    0xF371, 0xF2F6, 0xF287, 0xF227, 0xF1D5, 0xF193, 0xF163, 0xF145, 0xF13B, 
    0xF8F6, 0xF8F6, 0xF8F6, 0xF8F6, 0xF8F1, 0xF8E3, 0xF8CD, 0xF8B0, 0xF88D, 
    0xF864, 0xF836, 0xF804, 0xF7CE, 0xF797, 0xF75D, 0xF723, 0xF6E9, 0xF6B0, 
    0xF679, 0xF644, 0xF612, 0xF5E5, 0xF5BC, 0xF599, 0xF57D, 0xF568, 0xF55C, 
    0xF558, 0xF55F, 0xF572, 0xF590, 0xF5B7, 0xF5E5, 0xF61B, 0xF656, 0xF695, 
    0xF6D8, 0xF71D, 0xF762, 0xF7A6, 0xF7E9, 0xF829, 0xF865, 0xF89C, 0xF8CC, 
    0xF8F4, 0xF913, 0xF928, 0xF933, 0xF936, 0xF933, 0xF929, 0xF91A, 0xF907, 
    0xF8EF, 0xF8D5, 0xF8B8, 0xF89A, 0xF87B, 0xF85B, 0xF83D, 0xF820, 0xF805, 
    0xF7ED, 0xF7D9, 0xF7C9, 0xF7BF, 0xF7BA, 0xF7BB, 0xF7BE, 0xF7C5, 0xF7CE, 
    0xF7DA, 0xF7E8, 0xF7F7, 0xF808, 0xF81A, 0xF82D, 0xF841, 0xF854, 0xF868, 
    0xF87C, 0xF88F, 0xF8A2, 0xF8B3, 0xF8C3, 0xF8D1, 0xF8DE, 0xF8E8, 0xF8EF, 
    0xF8F4, 0xF8F6, 0xF53E, 0xF53E, 0xF53E, 0xF53E, 0xF546, 0xF55D, 0xF582, 
    0xF5B4, 0xF5F2, 0xF63B, 0xF68F, 0xF6EB, 0xF750, 0xF7BC, 0xF82E, 0xF8A5, 
    0xF920, 0xF99E, 0xFA1F, 0xFAA1, 0xFB23, 0xFBA4, 0xFC23, 0xFC9F, 0xFD18, 
    0xFD8C, 0xFDFA, 0xFE61, 0xFECA, 0xFF3D, 0xFFB8, 0x003A, 0x00C0, 0x0149, 
    0x01D4, 0x025E, 0x02E7, 0x036B, 0x03EB, 0x0463, 0x04D2, 0x0537, 0x0590, 
    0x05DB, 0x0616, 0x0640, 0x0657, 0x0659, 0x0645, 0x061B, 0x05DC, 0x058B, 
    0x052A, 0x04BB, 0x043F, 0x03B9, 0x032B, 0x0295, 0x01FC, 0x0160, 0x00C3, 
    0x0027, 0xFF8F, 0xFEFC, 0xFE70, 0xFDED, 0xFD75, 0xFD0B, 0xFCA5, 0xFC3C, 
    0xFBD0, 0xFB62, 0xFAF3, 0xFA83, 0xFA13, 0xF9A3, 0xF935, 0xF8C9, 0xF85F, 
    0xF7FA, 0xF798, 0xF73B, 0xF6E4, 0xF692, 0xF648, 0xF606, 0xF5CC, 0xF59A, 
    0xF573, 0xF556, 0xF544, 0xF53E, 0x0253, 0x0253, 0x0253, 0x0253, 0x0252, 
    0x024D, 0x0245, 0x023A, 0x022D, 0x021E, 0x020C, 0x01F8, 0x01E3, 0x01CC, 
    0x01B4, 0x019A, 0x0180, 0x0165, 0x014A, 0x012E, 0x0112, 0x00F7, 0x00DB, 
    0x00C1, 0x00A7, 0x008E, 0x0076, 0x0060, 0x0049, 0x0030, 0x0015, 0xFFF8, 
    0xFFDB, 0xFFBC, 0xFF9E, 0xFF7F, 0xFF61, 0xFF43, 0xFF27, 0xFF0C, 0xFEF3, 
    0xFEDD, 0xFEC9, 0xFEB8, 0xFEAB, 0xFEA2, 0xFE9D, 0xFE9C, 0xFEA1, 0xFEAA, 
    0xFEB8, 0xFECA, 0xFEDF, 0xFEF8, 0xFF14, 0xFF31, 0xFF51, 0xFF72, 0xFF94, 
    0xFFB7, 0xFFDA, 0xFFFC, 0x001E, 0x003E, 0x005D, 0x007A, 0x0094, 0x00AB, 
    0x00C1, 0x00D8, 0x00EF, 0x0106, 0x011E, 0x0136, 0x014E, 0x0166, 0x017D, 
    0x0194, 0x01AA, 0x01C0, 0x01D5, 0x01E8, 0x01FB, 0x020C, 0x021B, 0x0229, 
    0x0236, 0x0240, 0x0248, 0x024E, 0x0252, 0x0253, 0xD9D8, 0xD9D8, 0xD9D8, 
    0xD9D8, 0xD9D8, 0xD9D8, 0xD9D7, 0xD9D7, 0xD9D6, 0xD9D4, 0xD9D3, 0xD9D2, 
    0xD9D1, 0xD9CF, 0xD9CE, 0xD9CD, 0xD9CB, 0xD9CA, 0xD9C9, 0xD9C8, 0xD9C7, 
    0xD9C6, 0xD9C6, 0xD9C6, 0xD9C6, 0xD9C6, 0xD9C6, 0xD9C7, 0xD9C9, 0xD9CA, 
    0xD9CC, 0xD9CE, 0xD9D0, 0xD9D3, 0xD9D6, 0xD9D9, 0xD9DC, 0xD9DF, 0xD9E3, 
    0xD9E7, 0xD9EB, 0xD9EF, 0xD9F3, 0xD9F7, 0xD9FC, 0xDA01, 0xDA05, 0xDA0A, 
    0xDA10, 0xDA16, 0xDA1E, 0xDA26, 0xDA2E, 0xDA37, 0xDA40, 0xDA4A, 0xDA53, 
    0xDA5C, 0xDA65, 0xDA6D, 0xDA75, 0xDA7C, 0xDA82, 0xDA87, 0xDA8B, 0xDA8E, 
    0xDA8F, 0xDA8F, 0xDA8D, 0xDA89, 0xDA85, 0xDA7E, 0xDA77, 0xDA6F, 0xDA65, 
    0xDA5C, 0xDA51, 0xDA46, 0xDA3B, 0xDA30, 0xDA25, 0xDA1A, 0xDA10, 0xDA06, 
    0xD9FC, 0xD9F4, 0xD9EC, 0xD9E5, 0xD9E0, 0xD9DC, 0xD9D9, 0xD9D8, 0x0001, 
    0xFFFE, 0xC170, 0x0B54, 0x0B54, 0x0B54, 0x0B54, 0x0B58, 0x0B64, 0x0B78, 
    0x0B93, 0x0BB4, 0x0BDC, 0x0C09, 0x0C3C, 0x0C73, 0x0CAF, 0x0CEE, 0x0D30, 
    0x0D76, 0x0DBD, 0x0E07, 0x0E51, 0x0E9D, 0x0EE9, 0x0F35, 0x0F81, 0x0FCB, 
    0x1014, 0x105B, 0x10A0, 0x10E9, 0x113D, 0x119A, 0x11FF, 0x126A, 0x12D8, 
    0x134A, 0x13BB, 0x142C, 0x149B, 0x1504, 0x1568, 0x15C4, 0x1616, 0x165D, 
    0x1697, 0x16C3, 0x16DE, 0x16E7, 0x16DC, 0x16C3, 0x16A4, 0x167E, 0x1651, 
    0x161F, 0x15E8, 0x15AB, 0x1569, 0x1523, 0x14D9, 0x148C, 0x143B, 0x13E6, 
    0x1390, 0x1337, 0x12DB, 0x127F, 0x1221, 0x11C2, 0x1163, 0x1103, 0x10A3, 
    0x1044, 0x0FE6, 0x0F89, 0x0F2D, 0x0ED4, 0x0E7C, 0x0E28, 0x0DD6, 0x0D87, 
    0x0D3C, 0x0CF5, 0x0CB3, 0x0C75, 0x0C3C, 0x0C08, 0x0BDA, 0x0BB3, 0x0B91, 
    0x0B77, 0x0B64, 0x0B58, 0x0B54, 0xE6DF, 0xE6DF, 0xE6DF, 0xE6DF, 0xE6E8, 
    0xE702, 0xE72B, 0xE763, 0xE7A7, 0xE7F8, 0xE853, 0xE8B8, 0xE925, 0xE999, 
    0xEA13, 0xEA91, 0xEB13, 0xEB96, 0xEC1B, 0xEC9F, 0xED21, 0xEDA0, 0xEE1C, 
    0xEE92, 0xEF01, 0xEF69, 0xEFC8, 0xF01C, 0xF06D, 0xF0C1, 0xF118, 0xF170, 
    0xF1C9, 0xF220, 0xF277, 0xF2CA, 0xF31A, 0xF365, 0xF3AA, 0xF3E8, 0xF41F, 
    0xF44C, 0xF470, 0xF489, 0xF496, 0xF496, 0xF488, 0xF46B, 0xF442, 0xF413, 
    0xF3DC, 0xF3A0, 0xF35D, 0xF316, 0xF2C9, 0xF277, 0xF220, 0xF1C6, 0xF168, 
    0xF107, 0xF0A3, 0xF03D, 0xEFD4, 0xEF69, 0xEEFD, 0xEE90, 0xEE23, 0xEDB5, 
    0xED47, 0xECDA, 0xEC6D, 0xEC02, 0xEB98, 0xEB31, 0xEACB, 0xEA68, 0xEA09, 
    0xE9AD, 0xE954, 0xE900, 0xE8B1, 0xE866, 0xE821, 0xE7E1, 0xE7A8, 0xE775, 
    0xE749, 0xE724, 0xE706, 0xE6F1, 0xE6E4, 0xE6DF, 0x9B41, 0x9B41, 0x9B41, 
    0x9B41, 0x9B2C, 0x9AEF, 0x9A8E, 0x9A0A, 0x9968, 0x98AA, 0x97D4, 0x96E8, 
    0x95E9, 0x94DB, 0x93C1, 0x929D, 0x9173, 0x9045, 0x8F17, 0x8DEC, 0x8CC7, 
    0x8BAB, 0x8A9B, 0x8999, 0x88AA, 0x87D0, 0x870E, 0x8667, 0x85D0, 0x853B, 
    0x84AA, 0x841D, 0x8397, 0x8317, 0x829F, 0x822F, 0x81CA, 0x816F, 0x8120, 
    0x80DD, 0x80A9, 0x8083, 0x806E, 0x8069, 0x8075, 0x8095, 0x80C9, 0x8112, 
    0x816C, 0x81D2, 0x8244, 0x82C1, 0x8349, 0x83DB, 0x8475, 0x8519, 0x85C3, 
    0x8675, 0x872D, 0x87EB, 0x88AE, 0x8975, 0x8A3F, 0x8B0D, 0x8BDC, 0x8CAE, 
    0x8D80, 0x8E52, 0x8F24, 0x8FF4, 0x90C3, 0x918F, 0x9257, 0x931C, 0x93DC, 
    0x9497, 0x954C, 0x95FA, 0x96A1, 0x9740, 0x97D6, 0x9862, 0x98E4, 0x995C, 
    0x99C8, 0x9A28, 0x9A7B, 0x9AC0, 0x9AF8, 0x9B20, 0x9B39, 0x9B41, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xCD91, 0xCD91, 
    0xCD91, 0xCD91, 0xCD88, 0xCD6F, 0xCD49, 0xCD1B, 0xCCE9, 0xCCB4, 0xCC82, 
    0xCC55, 0xCC32, 0xCC1B, 0xCC15, 0xCC23, 0xCC3D, 0xCC59, 0xCC7A, 0xCCA2, 
    0xCCD4, 0xCD11, 0xCD5B, 0xCDB6, 0xCE23, 0xCEA5, 0xCF3E, 0xCFF0, 0xD0C3, 
    0xD1B8, 0xD2CB, 0xD3F8, 0xD538, 0xD687, 0xD7E1, 0xD93F, 0xDA9D, 0xDBF6, 
    0xDD45, 0xDE85, 0xDFB1, 0xE0C4, 0xE1B9, 0xE28B, 0xE335, 0xE3B1, 0xE3FC, 
    0xE410, 0xE3FE, 0xE3DC, 0xE3AA, 0xE36A, 0xE31C, 0xE2C1, 0xE25A, 0xE1E7, 
    0xE16A, 0xE0E2, 0xE051, 0xDFB8, 0xDF18, 0xDE70, 0xDDC2, 0xDD10, 0xDC58, 
    0xDB9D, 0xDADF, 0xDA1F, 0xD95E, 0xD89C, 0xD7DA, 0xD71A, 0xD65B, 0xD59E, 
    0xD4E5, 0xD430, 0xD380, 0xD2D6, 0xD232, 0xD196, 0xD101, 0xD075, 0xCFF3, 
    0xCF7B, 0xCF0F, 0xCEAE, 0xCE5A, 0xCE14, 0xCDDC, 0xCDB2, 0xCD99, 0xCD91, 
    0x18A4, 0x18A4, 0x18A4, 0x18A4, 0x1899, 0x187C, 0x184F, 0x1816, 0x17D4, 
    0x178B, 0x1740, 0x16F5, 0x16AE, 0x166E, 0x1637, 0x160D, 0x15EC, 0x15CC, 
    0x15AE, 0x1592, 0x157B, 0x1567, 0x1559, 0x1550, 0x154E, 0x1552, 0x155F, 
    0x1574, 0x1592, 0x15B7, 0x15E3, 0x1615, 0x164C, 0x1687, 0x16C5, 0x1705, 
    0x1746, 0x1787, 0x17C7, 0x1805, 0x1841, 0x1878, 0x18AB, 0x18D8, 0x18EC, 
    0x18E1, 0x18CB, 0x18BF, 0x18BE, 0x18BC, 0x18BB, 0x18BA, 0x18B9, 0x18B8, 
    0x18B7, 0x18B6, 0x18B5, 0x18B4, 0x18B4, 0x18B3, 0x18B2, 0x18B1, 0x18B0, 
    0x18AF, 0x18AF, 0x18AE, 0x18AD, 0x18AC, 0x18AC, 0x18AB, 0x18AA, 0x18AA, 
    0x18A9, 0x18A9, 0x18A8, 0x18A8, 0x18A7, 0x18A7, 0x18A6, 0x18A6, 0x18A6, 
    0x18A5, 0x18A5, 0x18A5, 0x18A4, 0xFA04, 0xFA04, 0xFA04, 0xFA04, 0xFA20, 
    0xFA6B, 0xFADE, 0xFB6D, 0xFC10, 0xFCBD, 0xFD6A, 0xFE0D, 0xFE9D, 0xFF10, 
    0xFF5C, 0xFF78, 0xFF65, 0xFF2D, 0xFED6, 0xFE67, 0xFDE4, 0xFD54, 0xFCBC, 
    0xFC21, 0xFB8B, 0xFAFD, 0xFA7E, 0xFA14, 0xF9B3, 0xF94E, 0xF8E7, 0xF87D, 
    0xF814, 0xF7AC, 0xF748, 0xF6E7, 0xF68D, 0xF63A, 0xF5EF, 0xF5AF, 0xF57A, 
    0xF553, 0xF53A, 0xF532, 0xF5EF, 0xF794, 0xF93F, 0xFA10, 0xFA29, 0xFA3F, 
    0xFA53, 0xFA65, 0xFA75, 0xFA83, 0xFA8F, 0xFA99, 0xFAA1, 0xFAA8, 0xFAAD, 
    0xFAB1, 0xFAB4, 0xFAB5, 0xFAB4, 0xFAB3, 0xFAB1, 0xFAAD, 0xFAA9, 0xFAA4, 
    0xFA9E, 0xFA98, 0xFA90, 0xFA89, 0xFA81, 0xFA78, 0xFA70, 0xFA67, 0xFA5E, 
    0xFA55, 0xFA4C, 0xFA44, 0xFA3B, 0xFA33, 0xFA2B, 0xFA24, 0xFA1D, 0xFA17, 
    0xFA11, 0xFA0D, 0xFA09, 0xFA06, 0xFA05, 0xFA04, 0xE39A, 0xE39A, 0xE39A, 
    0xE39A, 0xE3D3, 0xE46F, 0xE55A, 0xE681, 0xE7D0, 0xE931, 0xEA91, 0xEBDD, 
    0xECFE, 0xEDE3, 0xEE76, 0xEEA3, 0xEE66, 0xEDD3, 0xECF7, 0xEBE4, 0xEAA7, 
    0xE950, 0xE7EE, 0xE690, 0xE545, 0xE41E, 0xE328, 0xE273, 0xE1EB, 0xE171, 
    0xE104, 0xE0A3, 0xE04E, 0xE004, 0xDFC5, 0xDF90, 0xDF64, 0xDF40, 0xDF24, 
    0xDF10, 0xDF02, 0xDEFA, 0xDEF7, 0xDEF8, 0xDF8D, 0xE0D0, 0xE219, 0xE2BD, 
    0xE2D5, 0xE2EB, 0xE300, 0xE314, 0xE326, 0xE337, 0xE346, 0xE354, 0xE362, 
    0xE36E, 0xE378, 0xE382, 0xE38B, 0xE393, 0xE399, 0xE39F, 0xE3A5, 0xE3A9, 
    0xE3AD, 0xE3AF, 0xE3B2, 0xE3B3, 0xE3B4, 0xE3B5, 0xE3B5, 0xE3B5, 0xE3B4, 
    0xE3B3, 0xE3B2, 0xE3B0, 0xE3AE, 0xE3AD, 0xE3AB, 0xE3A8, 0xE3A6, 0xE3A4, 
    0xE3A2, 0xE3A0, 0xE39F, 0xE39D, 0xE39C, 0xE39B, 0xE39A, 0x0001, 0xFFFE, 
    0xC170, 0xEFE2, 0xEFE2, 0xEFE2, 0xEFE2, 0xEFE8, 0xEFF9, 0xF015, 0xF03B, 
    0xF06C, 0xF0A5, 0xF0E7, 0xF131, 0xF183, 0xF1DC, 0xF23B, 0xF2A0, 0xF30B, 
    0xF37A, 0xF3EE, 0xF465, 0xF4E0, 0xF55D, 0xF5DC, 0xF65D, 0xF6DF, 0xF761, 
    0xF7E4, 0xF865, 0xF8E6, 0xF965, 0xF9E1, 0xFA5B, 0xFAD1, 0xFB43, 0xFBB1, 
    0xFC1A, 0xFC7E, 0xFCDB, 0xFD32, 0xFD81, 0xFDC9, 0xFE09, 0xFE3F, 0xFE6D, 
    0xFE90, 0xFEA9, 0xFEB7, 0xFEB9, 0xFE9D, 0xFE52, 0xFDDD, 0xFD44, 0xFC8A, 
    0xFBB5, 0xFAC8, 0xF9CA, 0xF8BD, 0xF7A8, 0xF68F, 0xF577, 0xF464, 0xF35A, 
    0xF260, 0xF178, 0xF0A9, 0xEFF6, 0xEF65, 0xEEFA, 0xEEAC, 0xEE6E, 0xEE3E, 
    0xEE1C, 0xEE06, 0xEDFB, 0xEDFB, 0xEE03, 0xEE14, 0xEE2C, 0xEE49, 0xEE6B, 
    0xEE91, 0xEEB9, 0xEEE2, 0xEF0C, 0xEF35, 0xEF5C, 0xEF81, 0xEFA1, 0xEFBB, 
    0xEFD0, 0xEFDD, 0xEFE2, 0x11CD, 0x11CD, 0x11CD, 0x11CD, 0x11D1, 0x11DC, 
    0x11EF, 0x1208, 0x1228, 0x124E, 0x127A, 0x12AB, 0x12E1, 0x131C, 0x135B, 
    0x139F, 0x13E5, 0x142F, 0x147C, 0x14CB, 0x151D, 0x1570, 0x15C5, 0x161B, 
    0x1671, 0x16C8, 0x171F, 0x1776, 0x17CB, 0x1820, 0x1873, 0x18C5, 0x1914, 
    0x1961, 0x19AB, 0x19F2, 0x1A35, 0x1A74, 0x1AAE, 0x1AE5, 0x1B16, 0x1B41, 
    0x1B67, 0x1B87, 0x1BA0, 0x1BB3, 0x1BBE, 0x1BC2, 0x1BB2, 0x1B85, 0x1B3C, 
    0x1ADD, 0x1A68, 0x19E2, 0x194D, 0x18AC, 0x1803, 0x1753, 0x16A1, 0x15EF, 
    0x153F, 0x1496, 0x13F6, 0x1362, 0x12DC, 0x1269, 0x120A, 0x11C4, 0x118E, 
    0x1162, 0x113F, 0x1123, 0x110F, 0x1101, 0x10FA, 0x10F8, 0x10FB, 0x1102, 
    0x110D, 0x111A, 0x112B, 0x113C, 0x1150, 0x1163, 0x1177, 0x118A, 0x119C, 
    0x11AC, 0x11B9, 0x11C4, 0x11CA, 0x11CD, 0x7D14, 0x7D14, 0x7D14, 0x7D14, 
    0x7D24, 0x7D51, 0x7D9A, 0x7DFE, 0x7E7B, 0x7F11, 0x7FBD, 0x8080, 0x8155, 
    0x823D, 0x8335, 0x843E, 0x8554, 0x8677, 0x87A6, 0x88DF, 0x8A20, 0x8B69, 
    0x8CB8, 0x8E0A, 0x8F60, 0x90B8, 0x9210, 0x9367, 0x94BB, 0x960B, 0x9756, 
    0x989A, 0x99D6, 0x9B08, 0x9C30, 0x9D4B, 0x9E58, 0x9F56, 0xA044, 0xA120, 
    0xA1E8, 0xA29B, 0xA339, 0xA3BF, 0xA42C, 0xA47E, 0xA4B5, 0xA4CF, 0xA49E, 
    0xA400, 0xA2FD, 0xA1A3, 0x9FFA, 0x9E0F, 0x9BEC, 0x999D, 0x972B, 0x94A2, 
    0x920D, 0x8F77, 0x8CEB, 0x8A74, 0x881C, 0x85EF, 0x83F7, 0x823F, 0x80D3, 
    0x7FBB, 0x7EE4, 0x7E29, 0x7D8B, 0x7D07, 0x7C9B, 0x7C45, 0x7C04, 0x7BD6, 
    0x7BB8, 0x7BAA, 0x7BA8, 0x7BB3, 0x7BC6, 0x7BE2, 0x7C04, 0x7C2A, 0x7C52, 
    0x7C7A, 0x7CA2, 0x7CC6, 0x7CE6, 0x7CFE, 0x7D0F, 0x7D14, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xE1F0, 0xE1F0, 0xE1F0, 0xE1F0, 0xE1E6, 0xE1C9, 0xE199, 0xE158, 
    0xE106, 0xE0A4, 0xE034, 0xDFB5, 0xDF29, 0xDE90, 0xDDEB, 0xDD3C, 0xDC83, 
    0xDBC0, 0xDAF6, 0xDA24, 0xD94B, 0xD86C, 0xD789, 0xD6A2, 0xD5B7, 0xD4CA, 
    0xD3DB, 0xD2EC, 0xD1FD, 0xD10E, 0xD022, 0xCF38, 0xCE52, 0xCD70, 0xCC93, 
    0xCBBC, 0xCAED, 0xCA24, 0xC965, 0xC8AF, 0xC803, 0xC762, 0xC6CD, 0xC645, 
    0xC5CB, 0xC55F, 0xC502, 0xC4B5, 0xC486, 0xC47F, 0xC49E, 0xC4DE, 0xC53D, 
    0xC5B7, 0xC64A, 0xC6F3, 0xC7AE, 0xC877, 0xC94D, 0xCA2B, 0xCB0F, 0xCBF6, 
    0xCCDC, 0xCDBE, 0xCE99, 0xCF6A, 0xD02D, 0xD0E1, 0xD193, 0xD254, 0xD323, 
    0xD3FD, 0xD4DF, 0xD5C9, 0xD6B8, 0xD7AA, 0xD89C, 0xD98E, 0xDA7D, 0xDB66, 
    0xDC49, 0xDD22, 0xDDF1, 0xDEB2, 0xDF64, 0xE005, 0xE092, 0xE10B, 0xE16C, 
    0xE1B4, 0xE1E0, 0xE1F0, 0xED56, 0xED56, 0xED56, 0xED56, 0xED56, 0xED56, 
    0xED55, 0xED55, 0xED54, 0xED53, 0xED52, 0xED51, 0xED4F, 0xED4E, 0xED4C, 
    0xED49, 0xED47, 0xED44, 0xED41, 0xED3D, 0xED39, 0xED35, 0xED31, 0xED2C, 
    0xED27, 0xED21, 0xED1B, 0xED15, 0xED0E, 0xED06, 0xECFF, 0xECF6, 0xECEE, 
    0xECE4, 0xECDB, 0xECD0, 0xECC6, 0xECBA, 0xECAF, 0xECA2, 0xEC95, 0xEC87, 
    0xEC79, 0xEC6A, 0xEC5B, 0xEC4B, 0xEC3A, 0xEC29, 0xEC0F, 0xEBE9, 0xEBB6, 
    0xEB7B, 0xEB39, 0xEAF3, 0xEAAA, 0xEA62, 0xEA1D, 0xE9DD, 0xE9A4, 0xE975, 
    0xE94C, 0xE926, 0xE905, 0xE8EA, 0xE8D8, 0xE8D1, 0xE8D5, 0xE8E7, 0xE905, 
    0xE92D, 0xE95C, 0xE992, 0xE9CD, 0xEA0B, 0xEA4B, 0xEA8B, 0xEACA, 0xEB06, 
    0xEB3E, 0xEB71, 0xEBA2, 0xEBD6, 0xEC0C, 0xEC43, 0xEC78, 0xECAA, 0xECD9, 
    0xED02, 0xED25, 0xED3F, 0xED50, 0xED56, 0xFE52, 0xFE52, 0xFE52, 0xFE52, 
    0xFE52, 0xFE4F, 0xFE4B, 0xFE45, 0xFE3E, 0xFE35, 0xFE2B, 0xFE1F, 0xFE12, 
    0xFE04, 0xFDF4, 0xFDE2, 0xFDCF, 0xFDBB, 0xFDA6, 0xFD8F, 0xFD77, 0xFD5E, 
    0xFD43, 0xFD28, 0xFD0B, 0xFCED, 0xFCCE, 0xFCAD, 0xFC8C, 0xFC6A, 0xFC47, 
    0xFC22, 0xFBFD, 0xFBD7, 0xFBB0, 0xFB87, 0xFB5E, 0xFB35, 0xFB0A, 0xFADF, 
    0xFAB2, 0xFA85, 0xFA58, 0xFA29, 0xF9FA, 0xF9CB, 0xF99A, 0xF969, 0xF922, 
    0xF8B4, 0xF828, 0xF788, 0xF6DA, 0xF628, 0xF57B, 0xF4DC, 0xF451, 0xF3E6, 
    0xF3A1, 0xF38C, 0xF3C1, 0xF447, 0xF50C, 0xF5FB, 0xF701, 0xF80A, 0xF902, 
    0xF9D6, 0xFA99, 0xFB6A, 0xFC43, 0xFD1F, 0xFDFA, 0xFECE, 0xFF97, 0x004F, 
    0x00F1, 0x0179, 0x01E2, 0x0225, 0x023A, 0x021F, 0x01DD, 0x017D, 0x0107, 
    0x0084, 0xFFFD, 0xFF7B, 0xFF06, 0xFEA8, 0xFE69, 0xFE52, 0xEC69, 0xEC69, 
    0xEC69, 0xEC69, 0xEC66, 0xEC5A, 0xEC48, 0xEC2E, 0xEC0F, 0xEBE9, 0xEBBE, 
    0xEB8D, 0xEB58, 0xEB1E, 0xEAE0, 0xEA9E, 0xEA59, 0xEA11, 0xE9C6, 0xE978, 
    0xE929, 0xE8D8, 0xE887, 0xE834, 0xE7E1, 0xE78D, 0xE73B, 0xE6E8, 0xE697, 
    0xE647, 0xE5F9, 0xE5AD, 0xE564, 0xE51E, 0xE4DB, 0xE49B, 0xE460, 0xE429, 
    0xE3F6, 0xE3C9, 0xE3A2, 0xE380, 0xE364, 0xE34F, 0xE341, 0xE33B, 0xE33C, 
    0xE345, 0xE37C, 0xE3FE, 0xE4C0, 0xE5B6, 0xE6D5, 0xE810, 0xE95E, 0xEAB2, 
    0xEC01, 0xED3E, 0xEE60, 0xEF5A, 0xF04D, 0xF156, 0xF261, 0xF359, 0xF42A, 
    0xF4C1, 0xF50A, 0xF4EF, 0xF475, 0xF3B3, 0xF2B7, 0xF191, 0xF04E, 0xEEFB, 
    0xEDA8, 0xEC63, 0xEB39, 0xEA38, 0xE970, 0xE8ED, 0xE8B2, 0xE8B1, 0xE8DF, 
    0xE933, 0xE9A2, 0xEA23, 0xEAAB, 0xEB31, 0xEBAB, 0xEC0E, 0xEC51, 0xEC69, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFCEE, 0xFCEE, 0xFCEE, 0xFCEE, 
    0xFCEC, 0xFCE7, 0xFCE0, 0xFCD6, 0xFCC9, 0xFCBA, 0xFCA8, 0xFC94, 0xFC7F, 
    0xFC67, 0xFC4E, 0xFC33, 0xFC17, 0xFBF9, 0xFBDA, 0xFBBA, 0xFB9A, 0xFB78, 
    0xFB56, 0xFB34, 0xFB11, 0xFAEF, 0xFACC, 0xFAA9, 0xFA87, 0xFA65, 0xFA43, 
    0xFA23, 0xFA03, 0xF9E4, 0xF9C7, 0xF9AA, 0xF98F, 0xF976, 0xF95E, 0xF949, 
    0xF935, 0xF924, 0xF914, 0xF907, 0xF8FD, 0xF8F6, 0xF8F1, 0xF8F0, 0xF8F1, 
    0xF8F6, 0xF8FD, 0xF907, 0xF914, 0xF924, 0xF935, 0xF949, 0xF95E, 0xF976, 
    0xF98F, 0xF9AA, 0xF9C7, 0xF9E4, 0xFA03, 0xFA23, 0xFA43, 0xFA65, 0xFA87, 
    0xFAA9, 0xFACC, 0xFAEF, 0xFB11, 0xFB34, 0xFB56, 0xFB78, 0xFB9A, 0xFBBA, 
    0xFBDA, 0xFBF9, 0xFC17, 0xFC33, 0xFC4E, 0xFC67, 0xFC7F, 0xFC94, 0xFCA8, 
    0xFCBA, 0xFCC9, 0xFCD6, 0xFCE0, 0xFCE7, 0xFCEC, 0xFCEE, 0xE6A8, 0xE6A8, 
    0xE6A8, 0xE6A8, 0xE6A8, 0xE6A9, 0xE6AB, 0xE6AC, 0xE6AF, 0xE6B1, 0xE6B4, 
    0xE6B8, 0xE6BC, 0xE6C0, 0xE6C5, 0xE6C9, 0xE6CE, 0xE6D4, 0xE6D9, 0xE6DF, 
    0xE6E5, 0xE6EA, 0xE6F0, 0xE6F7, 0xE6FD, 0xE703, 0xE709, 0xE70F, 0xE715, 
    0xE71B, 0xE721, 0xE727, 0xE72D, 0xE732, 0xE738, 0xE73D, 0xE741, 0xE746, 
    0xE74A, 0xE74E, 0xE751, 0xE755, 0xE757, 0xE75A, 0xE75B, 0xE75D, 0xE75D, 
    0xE75E, 0xE75D, 0xE75D, 0xE75B, 0xE75A, 0xE757, 0xE755, 0xE751, 0xE74E, 
    0xE74A, 0xE746, 0xE741, 0xE73D, 0xE738, 0xE732, 0xE72D, 0xE727, 0xE721, 
    0xE71B, 0xE715, 0xE70F, 0xE709, 0xE703, 0xE6FD, 0xE6F7, 0xE6F0, 0xE6EA, 
    0xE6E5, 0xE6DF, 0xE6D9, 0xE6D4, 0xE6CE, 0xE6C9, 0xE6C5, 0xE6C0, 0xE6BC, 
    0xE6B8, 0xE6B4, 0xE6B1, 0xE6AF, 0xE6AC, 0xE6AB, 0xE6A9, 0xE6A8, 0x8E9A, 
    0x8E9A, 0x8E9A, 0x8E9A, 0x8E9D, 0x8EA5, 0x8EB2, 0x8EC4, 0x8EDA, 0x8EF4, 
    0x8F13, 0x8F35, 0x8F5A, 0x8F83, 0x8FAF, 0x8FDE, 0x900F, 0x9042, 0x9078, 
    0x90AF, 0x90E8, 0x9121, 0x915C, 0x9198, 0x91D4, 0x9211, 0x924D, 0x9289, 
    0x92C5, 0x9300, 0x9339, 0x9372, 0x93A9, 0x93DF, 0x9412, 0x9443, 0x9472, 
    0x949E, 0x94C7, 0x94EC, 0x950E, 0x952D, 0x9547, 0x955D, 0x956F, 0x957C, 
    0x9584, 0x9587, 0x9584, 0x957C, 0x956F, 0x955D, 0x9547, 0x952D, 0x950E, 
    0x94EC, 0x94C7, 0x949E, 0x9472, 0x9443, 0x9412, 0x93DF, 0x93A9, 0x9372, 
    0x9339, 0x9300, 0x92C5, 0x9289, 0x924D, 0x9211, 0x91D4, 0x9198, 0x915C, 
    0x9121, 0x90E8, 0x90AF, 0x9078, 0x9042, 0x900F, 0x8FDE, 0x8FAF, 0x8F83, 
    0x8F5A, 0x8F35, 0x8F13, 0x8EF4, 0x8EDA, 0x8EC4, 0x8EB2, 0x8EA5, 0x8E9D, 
    0x8E9A, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x4FFE, 0x4FFE, 0x4FFE, 0x4FFE, 0x4FFC, 
    0x4FF6, 0x4FEC, 0x4FDF, 0x4FCE, 0x4FB9, 0x4FA2, 0x4F88, 0x4F6B, 0x4F4C, 
    0x4F2A, 0x4F07, 0x4EE1, 0x4EBA, 0x4E91, 0x4E67, 0x4E3B, 0x4E0F, 0x4DE2, 
    0x4DB4, 0x4D86, 0x4D58, 0x4D2A, 0x4CFC, 0x4CCE, 0x4CA1, 0x4C75, 0x4C4A, 
    0x4C20, 0x4BF7, 0x4BCF, 0x4BAA, 0x4B86, 0x4B65, 0x4B45, 0x4B28, 0x4B0E, 
    0x4AF7, 0x4AE3, 0x4AD2, 0x4AC4, 0x4ABA, 0x4AB4, 0x4AB2, 0x4AB4, 0x4ABA, 
    0x4AC4, 0x4AD2, 0x4AE3, 0x4AF7, 0x4B0E, 0x4B28, 0x4B45, 0x4B65, 0x4B86, 
    0x4BAA, 0x4BCF, 0x4BF7, 0x4C20, 0x4C4A, 0x4C75, 0x4CA1, 0x4CCE, 0x4CFC, 
    0x4D2A, 0x4D58, 0x4D86, 0x4DB4, 0x4DE2, 0x4E0F, 0x4E3B, 0x4E67, 0x4E91, 
    0x4EBA, 0x4EE1, 0x4F07, 0x4F2A, 0x4F4C, 0x4F6B, 0x4F88, 0x4FA2, 0x4FB9, 
    0x4FCE, 0x4FDF, 0x4FEC, 0x4FF6, 0x4FFC, 0x4FFE, 0xF768, 0xF768, 0xF768, 
    0xF768, 0xF770, 0xF784, 0xF7A4, 0xF7CF, 0xF803, 0xF83E, 0xF87F, 0xF8C4, 
    0xF90C, 0xF956, 0xF9A0, 0xF9E8, 0xFA2E, 0xFA6F, 0xFAAA, 0xFADD, 0xFB08, 
    0xFB28, 0xFB3D, 0xFB44, 0xFB40, 0xFB33, 0xFB1E, 0xFB03, 0xFAE1, 0xFABA, 
    0xFA8E, 0xFA5E, 0xFA2A, 0xF9F4, 0xF9BC, 0xF982, 0xF948, 0xF90D, 0xF8D4, 
    0xF89C, 0xF867, 0xF834, 0xF805, 0xF7DA, 0xF7B4, 0xF794, 0xF77B, 0xF768, 
    0xF75B, 0xF74E, 0xF743, 0xF738, 0xF72F, 0xF727, 0xF721, 0xF71B, 0xF716, 
    0xF712, 0xF70F, 0xF70C, 0xF70B, 0xF70A, 0xF70A, 0xF70A, 0xF70B, 0xF70D, 
    0xF70F, 0xF712, 0xF715, 0xF719, 0xF71C, 0xF720, 0xF725, 0xF729, 0xF72E, 
    0xF733, 0xF738, 0xF73C, 0xF741, 0xF746, 0xF74A, 0xF74F, 0xF753, 0xF757, 
    0xF75B, 0xF75E, 0xF761, 0xF764, 0xF766, 0xF767, 0xF768, 0xF7BA, 0xF7BA, 
    0xF7BA, 0xF7BA, 0xF7B4, 0xF7A2, 0xF786, 0xF761, 0xF734, 0xF701, 0xF6C9, 
    0xF68C, 0xF64E, 0xF60D, 0xF5CD, 0xF58E, 0xF552, 0xF51A, 0xF4E6, 0xF4BA, 
    0xF495, 0xF478, 0xF467, 0xF460, 0xF464, 0xF46F, 0xF481, 0xF499, 0xF4B6, 
    0xF4D8, 0xF4FF, 0xF528, 0xF555, 0xF584, 0xF5B5, 0xF5E8, 0xF61A, 0xF64D, 
    0xF67F, 0xF6AF, 0xF6DE, 0xF70A, 0xF733, 0xF758, 0xF779, 0xF794, 0xF7AB, 
    0xF7BA, 0xF7C6, 0xF7D1, 0xF7DB, 0xF7E4, 0xF7EC, 0xF7F3, 0xF7F9, 0xF7FE, 
    0xF802, 0xF806, 0xF809, 0xF80B, 0xF80C, 0xF80D, 0xF80D, 0xF80C, 0xF80B, 
    0xF80A, 0xF808, 0xF806, 0xF803, 0xF800, 0xF7FD, 0xF7F9, 0xF7F5, 0xF7F1, 
    0xF7ED, 0xF7E9, 0xF7E5, 0xF7E1, 0xF7DD, 0xF7D8, 0xF7D4, 0xF7D1, 0xF7CD, 
    0xF7C9, 0xF7C6, 0xF7C3, 0xF7C1, 0xF7BF, 0xF7BD, 0xF7BC, 0xF7BB, 0xF7BA, 
    0xD552, 0xD552, 0xD552, 0xD552, 0xD538, 0xD4EE, 0xD478, 0xD3DD, 0xD321, 
    0xD24B, 0xD15F, 0xD062, 0xCF5B, 0xCE4F, 0xCD43, 0xCC3C, 0xCB3F, 0xCA53, 
    0xC97D, 0xC8C1, 0xC826, 0xC7B0, 0xC766, 0xC74C, 0xC75C, 0xC78A, 0xC7D5, 
    0xC838, 0xC8B3, 0xC941, 0xC9E1, 0xCA91, 0xCB4C, 0xCC12, 0xCCDF, 0xCDB1, 
    0xCE84, 0xCF58, 0xD029, 0xD0F4, 0xD1B7, 0xD26F, 0xD31A, 0xD3B6, 0xD43F, 
    0xD4B3, 0xD510, 0xD552, 0xD585, 0xD5B2, 0xD5DC, 0xD601, 0xD622, 0xD63F, 
    0xD658, 0xD66D, 0xD67F, 0xD68E, 0xD699, 0xD6A1, 0xD6A7, 0xD6AA, 0xD6AA, 
    0xD6A8, 0xD6A4, 0xD69E, 0xD696, 0xD68C, 0xD681, 0xD675, 0xD667, 0xD658, 
    0xD648, 0xD638, 0xD627, 0xD616, 0xD604, 0xD5F3, 0xD5E1, 0xD5D0, 0xD5BF, 
    0xD5AF, 0xD5A0, 0xD591, 0xD584, 0xD578, 0xD56D, 0xD564, 0xD55C, 0xD557, 
    0xD553, 0xD552, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFF1C, 0xFF1C, 
    0xFF1C, 0xFF1C, 0xFF1A, 0xFF15, 0xFF0C, 0xFF00, 0xFEF1, 0xFEDF, 0xFECB, 
    0xFEB4, 0xFE9A, 0xFE7F, 0xFE62, 0xFE43, 0xFE22, 0xFE00, 0xFDDC, 0xFDB8, 
    0xFD92, 0xFD6C, 0xFD46, 0xFD1F, 0xFCF7, 0xFCD0, 0xFCA9, 0xFC82, 0xFC5C, 
    0xFC37, 0xFC12, 0xFBEF, 0xFBCC, 0xFBAB, 0xFB8C, 0xFB6E, 0xFB53, 0xFB39, 
    0xFB22, 0xFB0D, 0xFAFB, 0xFAEC, 0xFADF, 0xFAD6, 0xFAD0, 0xFACE, 0xFAD0, 
    0xFAD5, 0xFAE6, 0xFB08, 0xFB3A, 0xFB7A, 0xFBC6, 0xFC1D, 0xFC7B, 0xFCE0, 
    0xFD4A, 0xFDB7, 0xFE24, 0xFE90, 0xFEFA, 0xFF5F, 0xFFBD, 0x0013, 0x005E, 
    0x009D, 0x00CF, 0x00F0, 0x0105, 0x0111, 0x0115, 0x0113, 0x010A, 0x00FB, 
    0x00E7, 0x00CF, 0x00B3, 0x0095, 0x0074, 0x0051, 0x002D, 0x0009, 0xFFE5, 
    0xFFC2, 0xFFA0, 0xFF81, 0xFF65, 0xFF4C, 0xFF38, 0xFF29, 0xFF1F, 0xFF1C, 
    0x13FB, 0x13FB, 0x13FB, 0x13FB, 0x13FA, 0x13F9, 0x13F7, 0x13F4, 0x13F1, 
    0x13ED, 0x13E9, 0x13E4, 0x13DF, 0x13D9, 0x13D3, 0x13CC, 0x13C5, 0x13BE, 
    0x13B7, 0x13B0, 0x13A8, 0x13A1, 0x1399, 0x1391, 0x138A, 0x1383, 0x137C, 
    0x1375, 0x136E, 0x1368, 0x1362, 0x135C, 0x1357, 0x1353, 0x134E, 0x134B, 
    0x1348, 0x1346, 0x1344, 0x1344, 0x1344, 0x1345, 0x1347, 0x1349, 0x134D, 
    0x1352, 0x1358, 0x135F, 0x136A, 0x137D, 0x1395, 0x13B3, 0x13D6, 0x13FC, 
    0x1425, 0x1451, 0x147E, 0x14AB, 0x14D9, 0x1505, 0x152F, 0x1557, 0x157C, 
    0x159C, 0x15B7, 0x15CD, 0x15DC, 0x15E3, 0x15E4, 0x15DF, 0x15D6, 0x15C9, 
    0x15B7, 0x15A3, 0x158B, 0x1571, 0x1555, 0x1537, 0x1519, 0x14F9, 0x14DA, 
    0x14BB, 0x149D, 0x147F, 0x1464, 0x144B, 0x1434, 0x1421, 0x1411, 0x1405, 
    0x13FD, 0x13FB, 0x9574, 0x9574, 0x9574, 0x9574, 0x9570, 0x9565, 0x9552, 
    0x9539, 0x951A, 0x94F4, 0x94C9, 0x9498, 0x9463, 0x9429, 0x93EB, 0x93A9, 
    0x9364, 0x931C, 0x92D1, 0x9284, 0x9235, 0x91E4, 0x9192, 0x913F, 0x90EC, 
    0x9099, 0x9046, 0x8FF3, 0x8FA2, 0x8F52, 0x8F04, 0x8EB8, 0x8E6E, 0x8E27, 
    0x8DE4, 0x8DA4, 0x8D68, 0x8D31, 0x8CFE, 0x8CD0, 0x8CA8, 0x8C86, 0x8C69, 
    0x8C54, 0x8C45, 0x8C3E, 0x8C3E, 0x8C46, 0x8C66, 0x8CA9, 0x8D0C, 0x8D8B, 
    0x8E23, 0x8ECF, 0x8F8D, 0x9057, 0x912C, 0x9206, 0x92E2, 0x93BC, 0x9491, 
    0x955D, 0x961C, 0x96CA, 0x9764, 0x97E5, 0x984B, 0x9892, 0x98BF, 0x98DC, 
    0x98EA, 0x98EB, 0x98E0, 0x98C9, 0x98A9, 0x9881, 0x9851, 0x981C, 0x97E1, 
    0x97A3, 0x9763, 0x9722, 0x96E1, 0x96A2, 0x9665, 0x962D, 0x95FA, 0x95CD, 
    0x95A8, 0x958C, 0x957A, 0x9574, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x4C54, 0x4C54, 0x4C54, 0x4C54, 0x4C56, 
    0x4C5C, 0x4C67, 0x4C76, 0x4C88, 0x4C9E, 0x4CB7, 0x4CD3, 0x4CF2, 0x4D14, 
    0x4D39, 0x4D60, 0x4D89, 0x4DB4, 0x4DE0, 0x4E0E, 0x4E3E, 0x4E6F, 0x4EA0, 
    0x4ED3, 0x4F06, 0x4F39, 0x4F6D, 0x4FA0, 0x4FD4, 0x5006, 0x5039, 0x506A, 
    0x509B, 0x50CA, 0x50F7, 0x5124, 0x514E, 0x5176, 0x519C, 0x51C0, 0x51E1, 
    0x5200, 0x521B, 0x5233, 0x5248, 0x5259, 0x5267, 0x5270, 0x5270, 0x5264, 
    0x524B, 0x5228, 0x51FB, 0x51C6, 0x518A, 0x5149, 0x5102, 0x50B9, 0x506D, 
    0x5020, 0x4FD4, 0x4F89, 0x4F41, 0x4EFC, 0x4EBD, 0x4E84, 0x4E53, 0x4E2B, 
    0x4E08, 0x4DE6, 0x4DC5, 0x4DA5, 0x4D87, 0x4D69, 0x4D4D, 0x4D32, 0x4D19, 
    0x4D01, 0x4CEA, 0x4CD5, 0x4CC1, 0x4CAE, 0x4C9E, 0x4C8F, 0x4C81, 0x4C75, 
    0x4C6B, 0x4C63, 0x4C5C, 0x4C57, 0x4C54, 0xFFAC, 0xFFAC, 0xFFAC, 0xFFAC, 
    0xFFAD, 0xFFAD, 0xFFAF, 0xFFB0, 0xFFB2, 0xFFB5, 0xFFB8, 0xFFBB, 0xFFBE, 
    0xFFC1, 0xFFC5, 0xFFC9, 0xFFCD, 0xFFD1, 0xFFD5, 0xFFD9, 0xFFDD, 0xFFE0, 
    0xFFE4, 0xFFE8, 0xFFEB, 0xFFEE, 0xFFF1, 0xFFF4, 0xFFF6, 0xFFF8, 0xFFF9, 
    0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFF8, 0xFFF6, 0xFFF4, 0xFFF0, 0xFFEC, 
    0xFFE8, 0xFFE2, 0xFFDB, 0xFFD4, 0xFFCC, 0xFFC2, 0xFFB8, 0xFFAC, 0xFF9C, 
    0xFF84, 0xFF64, 0xFF3E, 0xFF13, 0xFEE4, 0xFEB1, 0xFE7D, 0xFE46, 0xFE10, 
    0xFDDA, 0xFDA5, 0xFD74, 0xFD45, 0xFD1B, 0xFCF7, 0xFCD9, 0xFCC2, 0xFCB4, 
    0xFCAF, 0xFCB3, 0xFCBE, 0xFCD0, 0xFCE8, 0xFD05, 0xFD27, 0xFD4C, 0xFD75, 
    0xFDA1, 0xFDCF, 0xFDFE, 0xFE2E, 0xFE5D, 0xFE8C, 0xFEBA, 0xFEE6, 0xFF0F, 
    0xFF35, 0xFF57, 0xFF74, 0xFF8B, 0xFF9D, 0xFFA8, 0xFFAC, 0x03BB, 0x03BB, 
    0x03BB, 0x03BB, 0x03BB, 0x03BA, 0x03B9, 0x03B7, 0x03B5, 0x03B2, 0x03AF, 
    0x03AB, 0x03A8, 0x03A4, 0x03A0, 0x039C, 0x0397, 0x0393, 0x038E, 0x038A, 
    0x0386, 0x0381, 0x037D, 0x0379, 0x0375, 0x0372, 0x036F, 0x036C, 0x0369, 
    0x0367, 0x0366, 0x0365, 0x0364, 0x0364, 0x0365, 0x0367, 0x0369, 0x036C, 
    0x036F, 0x0374, 0x0379, 0x0380, 0x0387, 0x038F, 0x0399, 0x03A3, 0x03AF, 
    0x03BB, 0x03CE, 0x03E9, 0x040C, 0x0436, 0x0467, 0x049B, 0x04D4, 0x050F, 
    0x054B, 0x0588, 0x05C5, 0x05FF, 0x0637, 0x066B, 0x0699, 0x06C2, 0x06E4, 
    0x06FD, 0x070D, 0x0712, 0x070E, 0x0702, 0x06EE, 0x06D3, 0x06B2, 0x068D, 
    0x0663, 0x0635, 0x0604, 0x05D1, 0x059C, 0x0567, 0x0532, 0x04FD, 0x04CA, 
    0x0499, 0x046B, 0x0441, 0x041B, 0x03FB, 0x03E0, 0x03CC, 0x03C0, 0x03BB, 
    0xDA83, 0xDA83, 0xDA83, 0xDA83, 0xDA85, 0xDA8A, 0xDA92, 0xDA9C, 0xDAAA, 
    0xDAB9, 0xDACB, 0xDADE, 0xDAF3, 0xDB09, 0xDB21, 0xDB39, 0xDB52, 0xDB6B, 
    0xDB84, 0xDB9E, 0xDBB7, 0xDBCF, 0xDBE7, 0xDBFE, 0xDC13, 0xDC27, 0xDC39, 
    0xDC49, 0xDC57, 0xDC63, 0xDC6C, 0xDC72, 0xDC75, 0xDC74, 0xDC70, 0xDC68, 
    0xDC5B, 0xDC4B, 0xDC36, 0xDC1C, 0xDBFD, 0xDBD9, 0xDBAF, 0xDB7F, 0xDB4A, 
    0xDB0E, 0xDACC, 0xDA83, 0xDA1B, 0xD97F, 0xD8B5, 0xD7C4, 0xD6B1, 0xD583, 
    0xD441, 0xD2EF, 0xD196, 0xD039, 0xCEE1, 0xCD92, 0xCC54, 0xCB2C, 0xCA21, 
    0xC938, 0xC879, 0xC7E8, 0xC78D, 0xC76D, 0xC786, 0xC7CD, 0xC83F, 0xC8D7, 
    0xC991, 0xCA69, 0xCB5A, 0xCC60, 0xCD77, 0xCE9B, 0xCFC7, 0xD0F8, 0xD229, 
    0xD355, 0xD479, 0xD590, 0xD697, 0xD788, 0xD85F, 0xD919, 0xD9B1, 0xDA23, 
    0xDA6A, 0xDA83, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xFAF3, 0xFAF8, 0xFB07, 0xFB20, 0xFB41, 0xFB6A, 
    0xFB9B, 0xFBD3, 0xFC12, 0xFC57, 0xFCA1, 0xFCF1, 0xFD44, 0xFD9C, 0xFDF7, 
    0xFE56, 0xFEB6, 0xFF18, 0xFF7C, 0xFFE0, 0x0046, 0x00AA, 0x010E, 0x0170, 
    0x01D0, 0x022E, 0x028A, 0x02E1, 0x0335, 0x0385, 0x03CF, 0x0414, 0x0453, 
    0x048B, 0x04BC, 0x04E6, 0x0507, 0x051F, 0x052E, 0x0533, 0x0533, 0x0533, 
    0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 
    0x0533, 0x0533, 0x0533, 0x0533, 0x0533, 0x052D, 0x051C, 0x04FF, 0x04D9, 
    0x04A9, 0x0470, 0x042F, 0x03E7, 0x0398, 0x0343, 0x02E9, 0x028A, 0x0227, 
    0x01C0, 0x0157, 0x00EC, 0x0080, 0x0013, 0xFFA5, 0xFF39, 0xFECE, 0xFE65, 
    0xFDFF, 0xFD9C, 0xFD3D, 0xFCE3, 0xFC8E, 0xFC3F, 0xFBF7, 0xFBB6, 0xFB7D, 
    0xFB4D, 0xFB27, 0xFB0B, 0xFAF9, 0xFAF3, 0x0518, 0x0513, 0x0504, 0x04EC, 
    0x04CB, 0x04A2, 0x0471, 0x0439, 0x03FB, 0x03B6, 0x036B, 0x031B, 0x02C7, 
    0x026E, 0x0212, 0x01B3, 0x0152, 0x00EE, 0x0089, 0x0024, 0xFFBD, 0xFF57, 
    0xFEF2, 0xFE8E, 0xFE2D, 0xFDCE, 0xFD72, 0xFD19, 0xFCC5, 0xFC75, 0xFC2A, 
    0xFBE6, 0xFBA7, 0xFB6F, 0xFB3E, 0xFB15, 0xFAF4, 0xFADC, 0xFACD, 0xFAC8, 
    0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 
    0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFAC8, 0xFACE, 0xFADF, 
    0xFAFC, 0xFB22, 0xFB51, 0xFB8A, 0xFBCB, 0xFC13, 0xFC62, 0xFCB7, 0xFD12, 
    0xFD72, 0xFDD6, 0xFE3D, 0xFEA7, 0xFF13, 0xFF81, 0xFFF0, 0x005F, 0x00CD, 
    0x0139, 0x01A3, 0x020B, 0x026E, 0x02CE, 0x0329, 0x037E, 0x03CD, 0x0415, 
    0x0456, 0x048F, 0x04BE, 0x04E5, 0x0501, 0x0512, 0x0518, 0x0511, 0x0511, 
    0x0513, 0x0516, 0x051A, 0x051F, 0x0524, 0x052A, 0x0530, 0x0537, 0x053D, 
    0x0544, 0x054A, 0x054F, 0x0555, 0x0559, 0x055C, 0x055F, 0x0561, 0x0562, 
    0x0562, 0x0561, 0x055E, 0x055C, 0x0558, 0x0553, 0x054E, 0x0548, 0x0542, 
    0x053B, 0x0534, 0x052E, 0x0527, 0x0521, 0x051B, 0x0516, 0x0512, 0x050F, 
    0x050E, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 
    0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 0x050D, 
    0x050E, 0x0510, 0x0513, 0x0518, 0x051E, 0x0524, 0x052B, 0x0532, 0x0539, 
    0x0540, 0x0547, 0x054E, 0x0553, 0x0558, 0x055C, 0x055F, 0x0561, 0x0562, 
    0x0561, 0x0560, 0x055D, 0x055A, 0x0555, 0x054F, 0x0549, 0x0543, 0x053C, 
    0x0535, 0x052E, 0x0527, 0x0521, 0x051B, 0x0517, 0x0513, 0x0511, 
    },
    {
    0x0001, 0x0000, 0x0058, 0x0001, 0x0001, 0x0059, 0x0001, 0x005A, 0x0001, 
    0x005B, 0x0001, 0x005C, 0x005C, 0x005D, 0x005C, 0x00B9, 0x0058, 0x0115, 
    0x005C, 0x016D, 0x005C, 0x01C9, 0x005C, 0x0225, 0x005C, 0x0281, 0x005C, 
    0x02DD, 0x005C, 0x0339, 0x0001, 0x0395, 0x0001, 0x0396, 0x0001, 0x0397, 
    0x005C, 0x0398, 0x005C, 0x03F4, 0x005C, 0x0450, 0x005C, 0x04AC, 0x0057, 
    0x0508, 0x005C, 0x055F, 0x0055, 0x05BB, 0x005C, 0x0610, 0x005B, 0x066C, 
    0x0001, 0x06C7, 0x0001, 0x06C8, 0x0001, 0x06C9, 0x005C, 0x06CA, 0x005C, 
    0x0726, 0x005C, 0x0782, 0x005C, 0x07DE, 0x005B, 0x083A, 0x005C, 0x0895, 
    0x005C, 0x08F1, 0x005C, 0x094D, 0x005C, 0x09A9, 0x005C, 0x0A05, 0x005C, 
    0x0A61, 0x0001, 0x0ABD, 0x005C, 0x0ABE, 0x005B, 0x0B1A, 0x005C, 0x0B75, 
    0x005C, 0x0BD1, 0x005B, 0x0C2D, 0x005C, 0x0C88, 0x005B, 0x0CE4, 0x005C, 
    0x0D3F, 0x005C, 0x0D9B, 0x005C, 0x0DF7, 0x005C, 0x0E53, 0x0001, 0x0EAF, 
    0x005C, 0x0EB0, 0x005C, 0x0F0C, 0x005C, 0x0F68, 0x0058, 0x0FC4, 0x005C, 
    0x101C, 0x005B, 0x1078, 0x005C, 0x10D3, 0x005C, 0x112F, 0x005C, 0x118B, 
    0x005A, 0x11E7, 0x005B, 0x1241, 0x005A, 0x129C, 0x005C, 0x12F6, 0x005C, 
    0x1352, 0x005B, 0x13AE, 
})

smlua_anim_util_register_animation("MILNE_ANIM_STOP_CRAWLING",
    1,
    0,
    0,
    0,
    7,
    {
    0x0000, 0xFFD1, 0xFFD9, 0xFFEF, 0x000D, 0x002D, 0x004B, 0x0061, 0x0069, 
    0xFFDD, 0x0000, 0x3FFF, 0x0000, 0xFDEA, 0xFDEA, 0xFEB9, 0xFEE7, 0xFF07, 
    0xFF64, 0xFFCE, 0xFFFF, 0x0708, 0x0708, 0x060E, 0x04DF, 0x03A5, 0x0229, 
    0x00AD, 0xFFFF, 0x7431, 0x7431, 0x70CE, 0x6957, 0x61C2, 0x5A8F, 0x53DF, 
    0x50ED, 0x070C, 0x070C, 0x04EC, 0x02E7, 0x01CA, 0x00DD, 0x003B, 0xFFFF, 
    0xF13B, 0xF13B, 0xF3A0, 0xF664, 0xF947, 0xFC6D, 0xFEF5, 0x0000, 0xF8F6, 
    0xF8F6, 0x03DB, 0x0FEB, 0x1B53, 0x276C, 0x3106, 0x34EF, 0xF53E, 0xF53E, 
    0xF71B, 0xF965, 0xFBC6, 0xFDE4, 0xFF6A, 0xFFFF, 0x0253, 0x0253, 0x01EC, 
    0x016D, 0x00EA, 0x0074, 0x0020, 0x0000, 0xD9D8, 0xD9D8, 0xDA2E, 0xDA98, 
    0xDB06, 0xDB68, 0xDBAE, 0xDBC9, 0x0001, 0xFFFE, 0xC170, 0x0B54, 0x0B54, 
    0x19E7, 0x2991, 0x1EFF, 0xD84B, 0x7759, 0x4683, 0xE6DF, 0xE6DF, 0xE85B, 
    0xE9E4, 0xE7D3, 0xDD68, 0xCF63, 0xC85C, 0x9B41, 0x9B41, 0x8FBC, 0x832A, 
    0x883F, 0xB579, 0xF45C, 0x1427, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xCD91, 0xCD91, 0xD2A3, 0xD87E, 0xDBAA, 0xD95E, 0xD464, 0xD1A4, 0x18A4, 
    0x18A4, 0x16A9, 0x13DA, 0x09AE, 0xED7D, 0xC9EF, 0xB86F, 0xFA04, 0xFA04, 
    0xFAAA, 0xFB4C, 0xF9B1, 0xF2D8, 0xE9C2, 0xE539, 0xE39A, 0xE39A, 0xE543, 
    0xE741, 0xE9A3, 0xED42, 0xF143, 0xF328, 0x0001, 0xFFFE, 0xC170, 0xEFE2, 
    0xEFE2, 0xEF78, 0xF050, 0x068A, 0x4FE9, 0xAEAB, 0xDDA0, 0x11CD, 0x11CD, 
    0x15E0, 0x1ABA, 0x1FBC, 0x25E1, 0x2C2D, 0x2F11, 0x7D14, 0x7D14, 0x83DF, 
    0x8CB2, 0xA1C2, 0xD56C, 0x1552, 0x3498, 0x0000, 0x0000, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xE1F0, 0xE1F0, 0xDD8B, 0xD86A, 0xD4A7, 0xD358, 0xD367, 
    0xD3AD, 0xED56, 0xED56, 0xF000, 0xF35E, 0xF8AB, 0x13C0, 0x31EE, 0x4035, 
    0xFE52, 0xFE52, 0x0D07, 0x123A, 0xFF57, 0x07B5, 0x14CB, 0x1B99, 0xEC69, 
    0xEC69, 0xE846, 0xE939, 0xF1CC, 0xF627, 0xF997, 0xFAFD, 0xFFFF, 0xFFFF, 
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xFCEE, 0xFCEE, 0xFDC8, 
    0xFECA, 0xFFA3, 0xFF9A, 0x0133, 0x0259, 0xE6A8, 0xE6A8, 0xE79B, 0xE8BC, 
    0xE9E6, 0xEB36, 0xEC72, 0xED24, 0x8E9A, 0x8E9A, 0x8B18, 0x86F0, 0x8308, 
    0x80A7, 0x7B16, 0x7774, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x4FFE, 
    0x4FFE, 0x4EC4, 0x4D4D, 0x4BB7, 0x4991, 0x4AFF, 0x4C54, 0xF768, 0xF768, 
    0xF437, 0xEF3B, 0xEC2F, 0xF49E, 0xF8A2, 0xFA4B, 0xF7BA, 0xF7BA, 0xEA55, 
    0xF196, 0xFB92, 0xFE94, 0xFFA8, 0x0000, 0xD552, 0xD552, 0xC4A3, 0xB39D, 
    0xA6D9, 0xAFB8, 0xB724, 0xBB2C, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xBF5E, 0xFF1C, 0xFF1C, 0xFF9D, 0x0036, 0x00D0, 0x0181, 
    0x0233, 0x0283, 0x13FB, 0x13FB, 0x142C, 0x1467, 0x14A2, 0x14E6, 0x152A, 
    0x1549, 0x9574, 0x9574, 0x9068, 0x8A69, 0x846B, 0x7D78, 0x7687, 0x735F, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
    0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x4C54, 0x4C54, 
    0x4DF5, 0x4FCA, 0x4FFE, 0x4C99, 0x4793, 0x44FE, 0xFFAC, 0xFFAC, 0x0705, 
    0x0B19, 0x0D0A, 0x0792, 0x02BE, 0x0012, 0x03BB, 0x03BB, 0x125A, 0x0901, 
    0xFD57, 0xFE0B, 0xFEC5, 0xFF30, 0xDA83, 0xDA83, 0xBFA6, 0xA9D5, 0x9B5F, 
    0xACA0, 0xBCF7, 0xC62C, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFAF3, 
    0x0518, 0x0511,
    },
    {
    0x0001, 0x0000, 0x0008, 0x0001, 0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 
    0x000B, 0x0001, 0x000C, 0x0008, 0x000D, 0x0008, 0x0015, 0x0008, 0x001D, 
    0x0008, 0x0025, 0x0008, 0x002D, 0x0008, 0x0035, 0x0008, 0x003D, 0x0008, 
    0x0045, 0x0008, 0x004D, 0x0001, 0x0055, 0x0001, 0x0056, 0x0001, 0x0057, 
    0x0008, 0x0058, 0x0008, 0x0060, 0x0008, 0x0068, 0x0008, 0x0070, 0x0006, 
    0x0078, 0x0008, 0x007E, 0x0008, 0x0086, 0x0008, 0x008E, 0x0008, 0x0096, 
    0x0001, 0x009E, 0x0001, 0x009F, 0x0001, 0x00A0, 0x0008, 0x00A1, 0x0008, 
    0x00A9, 0x0008, 0x00B1, 0x0007, 0x00B9, 0x0008, 0x00C0, 0x0008, 0x00C8, 
    0x0008, 0x00D0, 0x0008, 0x00D8, 0x0008, 0x00E0, 0x0008, 0x00E8, 0x0008, 
    0x00F0, 0x0001, 0x00F8, 0x0008, 0x00F9, 0x0008, 0x0101, 0x0008, 0x0109, 
    0x0006, 0x0111, 0x0008, 0x0117, 0x0008, 0x011F, 0x0008, 0x0127, 0x0008, 
    0x012F, 0x0008, 0x0137, 0x0008, 0x013F, 0x0008, 0x0147, 0x0001, 0x014F, 
    0x0008, 0x0150, 0x0008, 0x0158, 0x0008, 0x0160, 0x0008, 0x0168, 0x0008, 
    0x0170, 0x0008, 0x0178, 0x0008, 0x0180, 0x0008, 0x0188, 0x0008, 0x0190, 
    0x0007, 0x0198, 0x0008, 0x019F, 0x0008, 0x01A7, 0x0001, 0x01AF, 0x0001, 
    0x01B0, 0x0001, 0x01B1, 
})

smlua_anim_util_register_animation("MILNE_ANIM_START_CRAWLING",
    1,
    0,
    0,
    0,
    7,
    {
    0x0000, 0x0069, 0x006B, 0x0073, 0x0088, 0x006B, 0x002C, 0xFFED, 0xFFD1, 
    0xFFDD, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x000E, 0x0026, 0x002A, 0x0000, 
    0xFF53, 0xFE63, 0xFDEA, 0xFFFF, 0xFFCF, 0xFF7F, 0xFF6F, 0x0000, 0x0245, 
    0x056F, 0x0708, 0x50ED, 0x5242, 0x55B1, 0x5A62, 0x5F7F, 0x671A, 0x6FF2, 
    0x7431, 0xFFFF, 0xFFD6, 0xFF84, 0xFF46, 0xFF5A, 0x0000, 0x03C6, 0x070C, 
    0x0000, 0x0056, 0x0103, 0x0184, 0x0159, 0xFFFF, 0xF816, 0xF13B, 0x34EF, 
    0x31D4, 0x29E6, 0x1F39, 0x13DE, 0x09E8, 0xFF4B, 0xF8F6, 0xFFFF, 0x0049, 
    0x00C4, 0x00DD, 0x0000, 0xFC87, 0xF7B0, 0xF53E, 0x0000, 0xFFF0, 0xFFD5, 
    0xFFD0, 0x0000, 0x00C0, 0x01CC, 0x0253, 0xDBC9, 0xDD3F, 0xE06E, 0xE38C, 
    0xE4CD, 0xE1D7, 0xDCA0, 0xD9D8, 0x0001, 0xFFFE, 0xC170, 0x4683, 0x516A, 
    0x6D87, 0x93FB, 0xBDDE, 0xE44F, 0x006D, 0x0B54, 0xC85C, 0xCA0D, 0xCE68, 
    0xD45E, 0xDADD, 0xE0D3, 0xE52E, 0xE6DF, 0x1427, 0x0D75, 0xFC2F, 0xE492, 
    0xCAD6, 0xB339, 0xA1F3, 0x9B41, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xD1A4, 0xD16A, 0xD0D5, 0xD009, 0xCF2B, 0xCE5F, 0xCDCA, 
    0xCD91, 0xB86F, 0xBDC4, 0xCB82, 0xDE4D, 0xF2C6, 0x0591, 0x134F, 0x18A4, 
    0xE539, 0xE660, 0xE958, 0xED68, 0xF1D5, 0xF5E5, 0xF8DD, 0xFA04, 0xF328, 
    0xF24B, 0xF012, 0xED09, 0xE9B9, 0xE6B0, 0xE477, 0xE39A, 0x0001, 0xFFFE, 
    0xC170, 0xDDA0, 0xD075, 0xAE7F, 0x800E, 0x4D74, 0x1F03, 0xFD0D, 0xEFE2, 
    0x2F11, 0x2D72, 0x2944, 0x238C, 0x1D52, 0x179A, 0x136C, 0x11CD, 0x3498, 
    0x2A6E, 0x1037, 0xEC5E, 0xC550, 0xA178, 0x8741, 0x7D14, 0x0000, 0x0000, 
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0xD3AD, 0xD477, 0xD681, 0xD94A, 0xDC53, 0xDF1C, 0xE125, 
    0xE1F0, 0x4035, 0x3B9E, 0x2FC7, 0x1F97, 0x0DF4, 0xFDC4, 0xF1ED, 0xED56, 
    0x1B99, 0x19FA, 0x15CB, 0x1013, 0x09D8, 0x0420, 0xFFF2, 0xFE52, 0xFAFD, 
    0xFA2E, 0xF819, 0xF540, 0xF226, 0xEF4D, 0xED38, 0xEC69, 0xFFFF, 0xFFFF, 
    0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFF, 0x0000, 0xBF5E, 0x0259, 0x020C, 0x0146, 0x0037, 0xFF10, 0xFE01, 
    0xFD3A, 0xFCEE, 0xED24, 0xECC8, 0xEBDB, 0xEA97, 0xE936, 0xE7F1, 0xE704, 
    0xE6A8, 0x7774, 0x78BC, 0x7C0B, 0x8092, 0x857F, 0x8A04, 0x8D52, 0x8E9A, 
    0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0x4C54, 0x4C88, 0x4D0E, 0x4DC5, 0x4E8D, 0x4F44, 
    0x4FCA, 0x4FFE, 0xFA4B, 0xFA22, 0xF9B9, 0xF929, 0xF88B, 0xF7FB, 0xF791, 
    0xF768, 0x0000, 0xFF8A, 0xFE5C, 0xFCBE, 0xFAFC, 0xF95E, 0xF830, 0xF7BA, 
    0xBB2C, 0xBC9F, 0xC05B, 0xC577, 0xCB08, 0xD023, 0xD3DF, 0xD552, 0xFFFF, 
    0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x0283, 0x0253, 0x01D7, 0x012C, 0x0073, 
    0xFFC9, 0xFF4C, 0xFF1C, 0x1549, 0x1536, 0x1506, 0x14C5, 0x147E, 0x143D, 
    0x140D, 0x13FB, 0x735F, 0x7542, 0x7A20, 0x80CA, 0x880B, 0x8EB3, 0x9391, 
    0x9574, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x44FE, 0x4566, 
    0x4672, 0x47E1, 0x4971, 0x4ADF, 0x4BEC, 0x4C54, 0x0012, 0x000D, 0xFFFE, 
    0xFFEA, 0xFFD4, 0xFFC1, 0xFFB2, 0xFFAC, 0xFF30, 0xFF70, 0x0016, 0x00FA, 
    0x01F1, 0x02D5, 0x037B, 0x03BB, 0xC62C, 0xC74D, 0xCA34, 0xCE2E, 0xD282, 
    0xD67B, 0xD963, 0xDA83, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
    0xFFFF, 0x0000, 0x0000, 0xFFB4, 0xFEF3, 0xFDF0, 0xFCDD, 0xFBE7, 0xFB37, 
    0xFAF3, 0x0000, 0x0044, 0x00F5, 0x01EE, 0x0304, 0x0409, 0x04CC, 0x0518, 
    0x0000, 0x004C, 0x010D, 0x0210, 0x0324, 0x041C, 0x04CD, 0x0511, 
    },
    {
    0x0001, 0x0000, 0x0008, 0x0001, 0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 
    0x000B, 0x0001, 0x000C, 0x0008, 0x000D, 0x0008, 0x0015, 0x0008, 0x001D, 
    0x0008, 0x0025, 0x0008, 0x002D, 0x0008, 0x0035, 0x0008, 0x003D, 0x0008, 
    0x0045, 0x0008, 0x004D, 0x0001, 0x0055, 0x0001, 0x0056, 0x0001, 0x0057, 
    0x0008, 0x0058, 0x0008, 0x0060, 0x0008, 0x0068, 0x0008, 0x0070, 0x0008, 
    0x0078, 0x0008, 0x0080, 0x0008, 0x0088, 0x0008, 0x0090, 0x0008, 0x0098, 
    0x0001, 0x00A0, 0x0001, 0x00A1, 0x0001, 0x00A2, 0x0008, 0x00A3, 0x0008, 
    0x00AB, 0x0008, 0x00B3, 0x0007, 0x00BB, 0x0006, 0x00C2, 0x0008, 0x00C8, 
    0x0008, 0x00D0, 0x0008, 0x00D8, 0x0008, 0x00E0, 0x0008, 0x00E8, 0x0005, 
    0x00F0, 0x0001, 0x00F5, 0x0008, 0x00F6, 0x0008, 0x00FE, 0x0008, 0x0106, 
    0x0008, 0x010E, 0x0004, 0x0116, 0x0008, 0x011A, 0x0008, 0x0122, 0x0008, 
    0x012A, 0x0008, 0x0132, 0x0008, 0x013A, 0x0005, 0x0142, 0x0001, 0x0147, 
    0x0008, 0x0148, 0x0008, 0x0150, 0x0008, 0x0158, 0x0008, 0x0160, 0x0007, 
    0x0168, 0x0008, 0x016F, 0x0008, 0x0177, 0x0008, 0x017F, 0x0008, 0x0187, 
    0x0005, 0x018F, 0x0005, 0x0194, 0x0007, 0x0199, 0x0008, 0x01A0, 0x0008, 
    0x01A8, 0x0008, 0x01B0,  
})

-------------------------
-- Original Animations --
-------------------------

smlua_anim_util_register_animation("MILNE_ANIM_TWISTER_THOK",
    0,
    0,
    0,
    0,
    1,
    {
    0x0000, 0x00BD, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0x40A1, 
    0x0000, 0x0000, 0xFF25, 0xF14C, 0x00A8, 0x01F6, 0xFFFE, 0x0001, 0xC170, 
    0xC020, 0xC137, 0xFEA5, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
    0xFFFE, 0x0001, 0xC170, 0x4021, 0x3EC8, 0xFEE9, 0xFFFF, 0x0000, 0xFFFF, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xBF5E, 0x0041, 0x0055, 0x8CA2, 
    0x002B, 0x00B4, 0x5952, 0x0095, 0xFF08, 0xCC41, 0xFC20, 0x0000, 0xBF5E, 
    0xFEE8, 0xFF3E, 0xBC51, 0x0000, 0x0000, 0x0640, 0x015C, 0x01E0, 0xF67F, 
    0x0000, 0xFFFF, 0xFFFF, 0x4001, 0xF45A, 0x6877, 
    },
    {
    0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
    0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 0x0007, 0x0001, 0x0008, 
    0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 0x000B, 0x0001, 0x000C, 0x0001, 
    0x000D, 0x0001, 0x000E, 0x0001, 0x000F, 0x0001, 0x0010, 0x0001, 0x0011, 
    0x0001, 0x0012, 0x0001, 0x0013, 0x0001, 0x0014, 0x0001, 0x0015, 0x0001, 
    0x0016, 0x0001, 0x0017, 0x0001, 0x0018, 0x0001, 0x0019, 0x0001, 0x001A, 
    0x0001, 0x001B, 0x0001, 0x001C, 0x0001, 0x001D, 0x0001, 0x001E, 0x0001, 
    0x001F, 0x0001, 0x0020, 0x0001, 0x0021, 0x0001, 0x0022, 0x0001, 0x0023, 
    0x0001, 0x0024, 0x0001, 0x0025, 0x0001, 0x0026, 0x0001, 0x0027, 0x0001, 
    0x0028, 0x0001, 0x0029, 0x0001, 0x002A, 0x0001, 0x002B, 0x0001, 0x002C, 
    0x0001, 0x002D, 0x0001, 0x002E, 0x0001, 0x002F, 0x0001, 0x0030, 0x0001, 
    0x0031, 0x0001, 0x0032, 0x0001, 0x0033, 0x0001, 0x0034, 0x0001, 0x0035, 
    0x0001, 0x0036, 0x0001, 0x0037, 0x0001, 0x0038, 0x0001, 0x0039, 0x0001, 
    0x003A, 0x0001, 0x003B, 0x0001, 0x003C, 0x0001, 0x003D, 0x0001, 0x003E, 
    0x0001, 0x003F, 0x0001, 0x0040, 0x0001, 0x0041, 0x0001, 0x0042, 0x0001, 
    0x0043, 0x0001, 0x0044, 
})

smlua_anim_util_register_animation("MILNE_ANIM_CRYSTAL_LANCE",
    1,
    0,
    0,
    0,
    5,
    {
    0x0000, 0x00BD, 0x00B4, 0x00A1, 0x008D, 0x0084, 0x0000, 0x0000, 0x3FFF, 
    0x0000, 0xF976, 0xFCB4, 0x03D8, 0x0AFA, 0x0E38, 0x001A, 0x000D, 0xFFF0, 
    0xFFD5, 0xFFC8, 0x38E3, 0x3A17, 0x3CBD, 0x3F63, 0x4097, 0x000F, 0x0023, 
    0x004F, 0x007B, 0x008F, 0xFF98, 0x004D, 0x01DB, 0x0368, 0x041C, 0xFAB0, 
    0xFD2D, 0x02A9, 0x0823, 0x0AA0, 0x0689, 0x035B, 0xFC5D, 0xF55F, 0xF231, 
    0xFFD2, 0xFF4D, 0xFE29, 0xFD05, 0xFC81, 0x084B, 0x0584, 0xFF65, 0xF948, 
    0xF680, 0xFFFE, 0x0001, 0xC170, 0x2C2E, 0x23EC, 0x11C3, 0xFF98, 0xF756, 
    0xF18B, 0xEFA2, 0xEB6F, 0xE73C, 0xE554, 0x8374, 0x9667, 0xC016, 0xE9C5, 
    0xFCB8, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
    0xFFFF, 0x0000, 0x0000, 0xFAD5, 0xEF79, 0xE41D, 0xDEF3, 0xF96E, 0xFACA, 
    0xFDC7, 0x00C6, 0x0222, 0xE2A0, 0xE640, 0xEE3B, 0xF635, 0xF9D6, 0xEF2F, 
    0xECCC, 0xE78B, 0xE24A, 0xDFE7, 0xFFFE, 0x0001, 0xC170, 0x13DF, 0x0605, 
    0xE78A, 0x4911, 0x3B37, 0x0DBB, 0x0EFC, 0x11BE, 0x6B7F, 0x6A3E, 0x0077, 
    0xEA06, 0xB8A9, 0x074C, 0xF0DB, 0xFFFF, 0x0000, 0xA51B, 0xB34E, 0xD28D, 
    0xF1CB, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x2C1C, 0x2537, 
    0x160E, 0x06E4, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 
    0xFB54, 0xFD6D, 0x0255, 0x07B2, 0x0A44, 0xFC04, 0xFA29, 0xF760, 0xF64C, 
    0xF624, 0xA2CC, 0xB72B, 0xD434, 0xDE4F, 0xDFC1, 0xFFFF, 0xFFFC, 0xFFF5, 
    0xFFEE, 0xFFEA, 0xFFFF, 0x0004, 0x000E, 0x0018, 0x001C, 0x0000, 0x02E2, 
    0x093A, 0x0F93, 0x1275, 0x0072, 0x0093, 0x00B4, 0x00A5, 0x0095, 0xFFF5, 
    0xFFF2, 0xFFDA, 0xFF67, 0xFF08, 0xD265, 0xC53E, 0xB817, 0xC22C, 0xCC41, 
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xF861, 0xFB53, 0x01CE, 0x0848, 
    0x0B3A, 0xFEDE, 0x0244, 0x09BC, 0x1135, 0x149A, 0xBDBB, 0xB7A0, 0xAA33, 
    0x9CC5, 0x96AA, 0x0002, 0xFFEE, 0xFFC5, 0xFF9C, 0xFF89, 0xFEDB, 0xFEC5, 
    0xFE95, 0xFE66, 0xFE50, 0x2AA8, 0x2E26, 0x35D3, 0x3D80, 0x40FD, 0xFFAB, 
    0xFFB1, 0xFFBF, 0xFFCD, 0xFFD3, 0x0233, 0x0236, 0x023D, 0x0244, 0x0247, 
    0xBCDB, 0xBDB2, 0xBF8B, 0xC164, 0xC23B, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
    0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFA9E, 0xFD71, 0x0426, 
    0x0B1E, 0x0E39, 0xFC46, 0xFD99, 0xFF9B, 0x002B, 0xFFEF, 0x003F, 0x03E7, 
    0x0C63, 0x1516, 0x18F5, 
    },
    {
    0x0001, 0x0000, 0x0005, 0x0001, 0x0001, 0x0006, 0x0001, 0x0007, 0x0001, 
    0x0008, 0x0001, 0x0009, 0x0005, 0x000A, 0x0005, 0x000F, 0x0005, 0x0014, 
    0x0005, 0x0019, 0x0005, 0x001E, 0x0005, 0x0023, 0x0005, 0x0028, 0x0005, 
    0x002D, 0x0005, 0x0032, 0x0001, 0x0037, 0x0001, 0x0038, 0x0001, 0x0039, 
    0x0005, 0x003A, 0x0005, 0x003F, 0x0005, 0x0044, 0x0005, 0x0049, 0x0005, 
    0x004E, 0x0005, 0x0053, 0x0005, 0x0058, 0x0005, 0x005D, 0x0005, 0x0062, 
    0x0001, 0x0067, 0x0001, 0x0068, 0x0001, 0x0069, 0x0005, 0x006A, 0x0005, 
    0x006F, 0x0005, 0x0074, 0x0001, 0x0079, 0x0001, 0x007A, 0x0005, 0x007B, 
    0x0005, 0x0080, 0x0005, 0x0085, 0x0001, 0x008A, 0x0001, 0x008B, 0x0003, 
    0x008C, 0x0001, 0x008F, 0x0005, 0x0090, 0x0005, 0x0095, 0x0005, 0x009A, 
    0x0005, 0x009F, 0x0005, 0x00A4, 0x0005, 0x00A9, 0x0005, 0x00AE, 0x0005, 
    0x00B3, 0x0005, 0x00B8, 0x0001, 0x00BD, 0x0003, 0x00BE, 0x0001, 0x00C1, 
    0x0005, 0x00C2, 0x0005, 0x00C7, 0x0005, 0x00CC, 0x0005, 0x00D1, 0x0005, 
    0x00D6, 0x0005, 0x00DB, 0x0005, 0x00E0, 0x0005, 0x00E5, 0x0005, 0x00EA, 
    0x0004, 0x00EF, 0x0002, 0x00F3, 0x0004, 0x00F5, 0x0005, 0x00F9, 0x0005, 
    0x00FE, 0x0005, 0x0103, 
})