-- name: [CS] Extra Characters Plus
-- description: [CS] Extra Characters Plus v1.2\nBy: \\#00ff00\\ULTRA BROS TEAM\n\ \n\\\#ffffff\\A CS Pack done by CoopDX members that not only gives opportunity to new roster additions but also provides unique movesets.\n\ \n\\\#00ff00\\It is RECOMMENDED to have the interpolation set to ACCURATE.\n\ \n\Delete the modcache file in sm64coopdx's roaming file and restart if multiplayer causes issues.\n\ \n\\\#ff0000\\REQUIRES Character Select v1.16 or newer for all of it's features to be used.
-- category: cs

local TEXT_VANILLA_CAST = "CoopDX Characters"
local TEXT_PACK_NAME = "Extra Characters"
if not charSelect then
    djui_popup_create(
    "\\#ffffa0\\Extra Characters requires\nCharacter Select to be enabled.\n\nPlease rehost with it enabled.", 4)
    return
end


-- Additional Voicelines used for Characters
YOSHI_SOUND_FLUTTER = CHAR_SOUND_MAX + 1

GAMEMODE_ACTIVE = false
for i in pairs(gActiveMods) do
    local mod = gActiveMods[i]
    if (mod.incompatible and mod.incompatible:find("gamemode")) or (mod.category and mod.category:find("gamemode")) then
        GAMEMODE_ACTIVE = true
    end
end

-- Characters are stored in a table for ease of addition

extraCharacters = {
    --------------
    -- Toadette --
    --------------
    {
        name = "Toadette",
        description =
        "A very rare female toad with a bubbly personality who lives in a world of male toads! She seems to enjoy her hobby as a construction boss! Although for some reason, she seems to hate unions. Wonder why?",
        credits = "Coop Team / VA: MelissaMekrose",
        color = { r = 255, g = 70, b = 161 },
        model = smlua_model_util_get_id("toadette_geo"),
        forceChar = CT_TOAD,
        lifeIcon = get_texture_info("icon-toadette"),
        camScale = 0.8,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-toadette-meter-left"),
                right = get_texture_info("char-select-toadette-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("toadette_cap_geo"),
            wing = smlua_model_util_get_id("toadette_wing_cap_geo"),
            metal = smlua_model_util_get_id("toadette_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("toadette_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'ffffff',
                [SHIRT]  = 'ff0000',
                [GLOVES] = 'ffffff',
                [SHOES]  = '68401b',
                [HAIR]   = '730600',
                [SKIN]   = 'fed5a1',
                [CAP]    = 'f30080',
                [EMBLEM] = 'f30080'
            },

            {
                name     = "Drill",
                [PANTS]  = 'ffffff',
                [SHIRT]  = 'ee9900',
                [GLOVES] = 'ff98dd',
                [SHOES]  = '666977',
                [HAIR]   = 'db0808',
                [SKIN]   = 'fed5a1',
                [CAP]    = '666977',
                [EMBLEM] = 'ff98dd'
            },

            {
                name     = "Chanterelle",
                [PANTS]  = '7342a5',
                [SHIRT]  = '7342a5',
                [GLOVES] = '7342a5',
                [SHOES]  = '7b214a',
                [HAIR]   = '7b214a',
                [SKIN]   = 'bd9c84',
                [CAP]    = 'bdbdbd',
                [EMBLEM] = '555555'
            },

            {
                name     = "Poison",
                [PANTS]  = '000000',
                [SHIRT]  = '000000',
                [GLOVES] = '000000',
                [SHOES]  = '000000',
                [HAIR]   = '994b0c',
                [SKIN]   = 'ffc8b8',
                [CAP]    = '994b0c',
                [EMBLEM] = '994b0c'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "toadette_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "toadette_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "toadette_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "toadette_coughing3.ogg",
            [CHAR_SOUND_DOH] = "toadette_doh.ogg",
            [CHAR_SOUND_DROWNING] = "toadette_drowning.ogg",
            [CHAR_SOUND_DYING] = "toadette_dying.ogg",
            [CHAR_SOUND_EEUH] = "toadette_euuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "toadette_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "toadette_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "toadette_haha2.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "toadette_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "toadette_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "toadette_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "toadette_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "toadette_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "toadette_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "toadette_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "toadette_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "toadette_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "toadette_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "toadette_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "toadette_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "toadette_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "toadette_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "toadette_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "toadette_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "toadette_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "toadette_snoring2.ogg", "toadette_snoring1.ogg", "toadette_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "toadette_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "toadette_uh.ogg",
            [CHAR_SOUND_UH2] = "toadette_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "toadette_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "toadette_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "toadette_ground_pound_wah.ogg",
            [CHAR_SOUND_WHOA] = "toadette_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "toadette_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "toadette_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "toadette_yahoo.ogg", "toadette_yahoo1.ogg", "toadette_yahoo2.ogg", "toadette_yahoo3.ogg", "toadette_yahoo4.ogg", "toadette_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "toadette_yah_wah_hoo1.ogg", "toadette_yah_wah_hoo2.ogg", "toadette_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "toadette_hello.ogg"
        },
        anims = {
            [CS_ANIM_MENU] = 'cs_toadette',
        }
    },
    --------------------
    -- Princess Peach --
    --------------------
    {
        name = "Peach",
        description =
        "The ruler of the Mushroom Kingdom, always ready to help Mario in his adventures and save her kingdom from the evil clutches of King Bowser! .........wait. What?! Why is she here?! How did she escape?! And who's the Peach we saw earlier?! This is confusing!",
        credits = "Coop Team / VA: SuperKirbyLover",
        color = { r = 239, g = 128, b = 177 },
        model = smlua_model_util_get_id("peach_player_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-peach"),
        camScale = 1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-peach-meter-left"),
                right = get_texture_info("char-select-peach-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("peach_player_cap_geo"),
            wing = smlua_model_util_get_id("peach_player_wing_cap_geo"),
            metal = smlua_model_util_get_id("peach_player_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("peach_player_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'ff5096',
                [SHIRT]  = 'f8c8bb',
                [GLOVES] = 'ffffff',
                [SHOES]  = '0000ff',
                [HAIR]   = 'ffd302',
                [SKIN]   = 'fec179',
                [CAP]    = 'ffff00',
                [EMBLEM] = '0082ff'
            },
            {
                name     = "Classic",
                [PANTS]  = 'b53120',
                [SHIRT]  = 'ffffff',
                [GLOVES] = 'ffffff',
                [SHOES]  = 'ea9e22',
                [HAIR]   = 'b53120',
                [SKIN]   = 'ea9e22',
                [CAP]    = 'ea9e22',
                [EMBLEM] = 'b53120'
            },
            {
                name     = "Ice Cream",
                [PANTS]  = 'a850f8',
                [SHIRT]  = '50d0f8',
                [GLOVES] = 'f8f8f8',
                [SHOES]  = '48b0e0',
                [HAIR]   = 'f88000',
                [SKIN]   = 'f8d098',
                [CAP]    = 'f8f800',
                [EMBLEM] = 'f8f800'
            },
            {
                name     = "Shadow Queen",
                [PANTS]  = '4a384a',
                [SHIRT]  = '6b5563',
                [GLOVES] = 'ad9ea5',
                [SHOES]  = 'ff1c63',
                [HAIR]   = 'ffe331',
                [SKIN]   = 'cbb6c8',
                [CAP]    = 'c69a18',
                [EMBLEM] = 'ff1c63'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "peach_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "peach_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "peach_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "peach_coughing3.ogg",
            [CHAR_SOUND_DOH] = "peach_doh.ogg",
            [CHAR_SOUND_DROWNING] = "peach_drowning.ogg",
            [CHAR_SOUND_DYING] = "peach_dying.ogg",
            [CHAR_SOUND_EEUH] = "peach_euuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "peach_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "peach_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "peach_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "peach_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "peach_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "peach_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "peach_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "peach_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "peach_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "peach_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "peach_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "peach_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "peach_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "peach_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "peach_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "peach_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "peach_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "peach_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "peach_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "peach_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "peach_snoring2.ogg", "peach_snoring1.ogg", "peach_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "peach_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "peach_uh.ogg",
            [CHAR_SOUND_UH2] = "peach_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "peach_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "peach_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "peach_ground_pound_wah.ogg",
            [CHAR_SOUND_WHOA] = "peach_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "peach_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "peach_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "peach_yahoo.ogg", "peach_yahoo1.ogg", "peach_yahoo2.ogg", "peach_yahoo3.ogg", "peach_yahoo4.ogg", "peach_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "peach_yah_wah_hoo1.ogg", "peach_yah_wah_hoo2.ogg", "peach_yah_wha_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "peach_float.ogg"
        },
        anims = {
            [CHAR_ANIM_RUNNING] = 'princess_running',
            [CHAR_ANIM_IDLE_HEAD_CENTER] = 'princess_idle_head_center',
            [CHAR_ANIM_IDLE_HEAD_LEFT] = 'princess_idle_head_left',
            [CHAR_ANIM_IDLE_HEAD_RIGHT] = 'princess_idle_head_right',
            [CHAR_ANIM_BACKWARD_KB] = 'princess_backward_kb',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_FLUTTERKICK] = 'princess_flutterkick',
            [CHAR_ANIM_FLUTTERKICK_WITH_OBJ] = 'princess_flutterkick_with_obj',
            [CHAR_ANIM_FORWARD_KB] = 'princess_forward_kb',
            [CHAR_ANIM_GROUND_BONK] = 'princess_ground_bonk',
            [CHAR_ANIM_GROUND_KICK] = 'princess_ground_kick',
            [CHAR_ANIM_GROUND_THROW] = 'princess_ground_throw',
            [CHAR_ANIM_HEAVY_THROW] = 'princess_heavy_throw',
            [CHAR_ANIM_MISSING_CAP] = 'princess_missing_cap',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'princess_pull_door_walk_in',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_RELEASE_BOWSER] = 'princess_release_bowser',
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = 'princess_return_from_star_dance',
            [CHAR_ANIM_RETURN_STAR_APPROACH_DOOR] = 'princess_return_star_approach_door',
            [CHAR_ANIM_SLIDEFLIP_LAND] = 'princess_sideflip_land',
            [CHAR_ANIM_SLEEP_IDLE] = 'princess_sleep_idle',
            [CHAR_ANIM_START_SLEEP_SITTING] = 'princess_sleep_sitting',
            [CHAR_ANIM_SOFT_BACK_KB] = 'princess_soft_back_kb',
            [CHAR_ANIM_SOFT_FRONT_KB] = 'princess_soft_front_kb',
            [CHAR_ANIM_STAR_DANCE] = 'princess_star_dance',
            [CHAR_ANIM_START_CROUCHING] = 'princess_start_crouch',
            [CHAR_ANIM_STOP_CROUCHING] = 'princess_stop_crouch',
            [CHAR_ANIM_START_SLEEP_IDLE] = 'princess_start_sleep',
            [CHAR_ANIM_STOP_SLIDE] = 'princess_stop_slide',
            [CHAR_ANIM_SUMMON_STAR] = 'princess_summon_star',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART1] = 'princess_swim_with_obj1',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART2] = 'princess_swim_with_obj2',
            [CHAR_ANIM_TRIPLE_JUMP_LAND] = 'princess_triple_jump_land',
            [CHAR_ANIM_TURNING_PART1] = 'princess_turning_part1',
            [CHAR_ANIM_TURNING_PART2] = 'princess_turning_part2',
            [CHAR_ANIM_TWIRL_LAND] = 'princess_twirl_land',
            [CHAR_ANIM_WAKE_FROM_LYING] = 'princess_wake_from_lying',
            [CHAR_ANIM_WAKE_FROM_SLEEP] = 'princess_wake_from_sleep',
            [CHAR_ANIM_CREDITS_RAISE_HAND] = 'princess_credits_raise_hand',
            [CHAR_ANIM_CREDITS_RETURN_FROM_LOOK_UP] = 'princess_credits_return_from_look_up',
            [CHAR_ANIM_CREDITS_START_WALK_LOOK_UP] = 'princess_credits_start_walk_look_up',
            [CHAR_ANIM_CREDITS_TAKE_OFF_CAP] = 'princess_credits_take_off_cap',
            [CHAR_ANIM_DYING_FALL_OVER] = 'princess_dying_fall_over',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'princess_fall_over_backwards',
            [CHAR_ANIM_FAST_LEDGE_GRAB] = 'princess_fast_ledge_grab',
            --[CHAR_ANIM_FINAL_BOWSER_RAISE_HAND_SPIN] = 'princess_final_bowser_raise_hand_spin',
            [CHAR_ANIM_FIRST_PUNCH_FAST] = 'princess_first_punch_fast',
            [CHAR_ANIM_GENERAL_LAND] = 'princess_general_land',
            [CHAR_ANIM_HEAD_STUCK_IN_GROUND] = 'princess_head_stuck_in_ground',
            [CHAR_ANIM_LAND_FROM_DOUBLE_JUMP] = 'princess_land_from_double_jump',
            [CHAR_ANIM_LAND_FROM_SINGLE_JUMP] = 'princess_land_from_single_jump',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'princess_land_on_stomach',
            [CHAR_ANIM_LEGS_STUCK_IN_GROUND] = 'princess_legs_stuck_in_ground',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'princess_place_light_obj',
            [CHAR_ANIM_PUSH_DOOR_WALK_IN] = 'princess_push_door_walk_in',
            [CHAR_ANIM_PUT_CAP_ON] = 'princess_put_cap_on',
            [CHAR_ANIM_RUN_WITH_LIGHT_OBJ] = 'princess_run_with_light_obj',
            [CHAR_ANIM_SECOND_PUNCH_FAST] = 'princess_second_punch_fast',
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = 'princess_shivering_returning_to_idle',
            [CHAR_ANIM_SKID_ON_GROUND] = 'princess_skid_on_ground',
            [CHAR_ANIM_SLOW_LAND_FROM_DIVE] = 'princess_slow_land_from_dive',
            [CHAR_ANIM_SLOW_LEDGE_GRAB] = 'princess_slow_ledge_grab',
            [CHAR_ANIM_SLOW_WALK_WITH_LIGHT_OBJ] = 'princess_slow_walk_with_light_obj',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'princess_stand_up_from_lava_boost',
            [CHAR_ANIM_STOP_SKID] = 'princess_stop_skid',
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'princess_take_cap_off_then_on',
            [CHAR_ANIM_THROW_CATCH_KEY] = 'princess_throw_catch_key',
            [CHAR_ANIM_WALK_WITH_LIGHT_OBJ] = 'princess_walk_with_light_obj',
            [CHAR_ANIM_BOTTOM_STUCK_IN_GROUND] = 'princess_bottom_stuck_in_ground',
            --[CHAR_ANIM_CREDITS_PEACE_SIGN] = 'princess_credits_peace_sign',
            [CHAR_ANIM_FIRE_LAVA_BURN] = 'princess_fire_lava_burn',
            [CHAR_ANIM_GROUND_POUND] = 'princess_ground_pound',
            [CHAR_ANIM_GROUND_POUND_LANDING] = 'princess_ground_pound_landing',
            [CHAR_ANIM_TRIPLE_JUMP_GROUND_POUND] = 'princess_triple_jump_ground_pound_anim',
            [CHAR_ANIM_UNLOCK_DOOR] = 'princess_unlock_door',
            [CHAR_ANIM_SWINGING_BOWSER] = 'princess_swinging_bowser',
            [CHAR_ANIM_HOLDING_BOWSER] = 'princess_holding_bowser',
            [CHAR_ANIM_GRAB_BOWSER] = 'princess_grab_bowser',
            [CHAR_ANIM_BEND_KNESS_RIDING_SHELL] = "peach_dressfloating",
            [CS_ANIM_MENU] = 'cs_peach',
        }
    },
    --------------------
    -- Princess Daisy --
    --------------------
    {
        name = "Daisy",
        description =
        "Princess of the Sarasaland who was once rescued by Mario against the evil alien, Tatanga! Boasting with energy, she has joined Mario and friends on occasional friendly events, such as golf, tennis, and parties! Try to stay on her good side, if you know what's best for ya!",
        credits = "Coop Team / VA: MorphiGalaxi",
        color = { r = 255, g = 97, b = 0 },
        model = smlua_model_util_get_id("daisy_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-daisy"),
        camScale = 1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-daisy-meter-left"),
                right = get_texture_info("char-select-daisy-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("daisy_cap_geo"),
            wing = smlua_model_util_get_id("daisy_wing_cap_geo"),
            metal = smlua_model_util_get_id("daisy_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("daisy_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'FFFFFF',
                [SHIRT]  = 'EFCA11',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '0000FF',
                [HAIR]   = 'FF6100',
                [SKIN]   = 'FDAE82',
                [CAP]    = 'FF0000',
                [EMBLEM] = '00FFFF'
            },
            {
                name     = "Modern",
                [PANTS]  = 'F1662F',
                [SHIRT]  = 'FFD01C',
                [GLOVES] = 'FEFFFF',
                [SHOES]  = '25BD8C',
                [HAIR]   = 'CF550C',
                [SKIN]   = 'FDAE82',
                [CAP]    = 'E4A349',
                [EMBLEM] = '25BD8C'
            },
            {
                name     = "Chai",
                [PANTS]  = 'f7ea6e',
                [SHIRT]  = '9bdf7c',
                [GLOVES] = '69b289',
                [SHOES]  = 'ce53b2',
                [HAIR]   = 'FF6100',
                [SKIN]   = 'FDAE82',
                [CAP]    = 'f7ea6e',
                [EMBLEM] = 'ce53b2',
            },

            {
                name     = "LCD",
                [PANTS]  = 'A8A8A8',
                [SHIRT]  = '505050',
                [GLOVES] = '505050',
                [SHOES]  = 'A8A8A8',
                [HAIR]   = '161616',
                [SKIN]   = 'A8A8A8',
                [CAP]    = '505050',
                [EMBLEM] = 'A8A8A8'
            },

        },
        voices = {
            [CHAR_SOUND_ATTACKED] = { 'daisy_attacked_1.ogg', 'daisy_attacked_2.ogg', 'daisy_attacked_3.ogg' },
            [CHAR_SOUND_COUGHING1] = 'daisy_coughing1.ogg',
            [CHAR_SOUND_COUGHING2] = 'daisy_coughing2.ogg',
            [CHAR_SOUND_COUGHING3] = 'daisy_coughing3.ogg',
            [CHAR_SOUND_DOH] = { 'daisy_doh_1.ogg', 'daisy_doh_2.ogg' },
            [CHAR_SOUND_DROWNING] = 'daisy_drowning_1.ogg',
            [CHAR_SOUND_DYING] = 'daisy_dying.ogg',
            [CHAR_SOUND_EEUH] = 'daisy_eeuh.ogg',
            [CHAR_SOUND_GROUND_POUND_WAH] = 'daisy_ground_pound_wah.ogg',
            [CHAR_SOUND_HAHA] = 'daisy_haha.ogg',
            [CHAR_SOUND_HAHA_2] = 'daisy_haha_2.ogg',
            [CHAR_SOUND_HERE_WE_GO] = 'daisy_here_we_go.ogg',
            [CHAR_SOUND_HOOHOO] = 'daisy_hoohoo.ogg',
            [CHAR_SOUND_HRMM] = 'daisy_hrmm.ogg',
            [CHAR_SOUND_IMA_TIRED] = 'daisy_ima_tired.ogg',
            [CHAR_SOUND_MAMA_MIA] = 'daisy_mama_mia.ogg',
            [CHAR_SOUND_LETS_A_GO] = 'daisy_lets_a_go.ogg',
            [CHAR_SOUND_ON_FIRE] = 'daisy_on_fire.ogg',
            [CHAR_SOUND_OOOF] = 'daisy_oof.ogg',
            [CHAR_SOUND_OOOF2] = 'daisy_ooof2.ogg',
            [CHAR_SOUND_PANTING] = 'daisy_panting.ogg',
            [CHAR_SOUND_PANTING_COLD] = 'daisy_panting_cold.ogg',
            [CHAR_SOUND_PUNCH_HOO] = 'daisy_punch_hoo.ogg',
            [CHAR_SOUND_PUNCH_WAH] = 'daisy_punch_wah.ogg',
            [CHAR_SOUND_PUNCH_YAH] = 'daisy_punch_yah.ogg',
            [CHAR_SOUND_SO_LONGA_BOWSER] = 'daisy_so_longa_bowser.ogg',
            [CHAR_SOUND_SNORING1] = 'daisy_snoring1.ogg',
            [CHAR_SOUND_SNORING2] = 'daisy_snoring2.ogg',
            [CHAR_SOUND_SNORING3] = { 'daisy_snoring2.ogg', 'daisy_snoring1.ogg', 'daisy_snoring3.ogg' },
            [CHAR_SOUND_TWIRL_BOUNCE] = 'daisy_twirl_bounce.ogg',
            [CHAR_SOUND_UH] = 'daisy_uh.ogg',
            [CHAR_SOUND_UH2] = 'daisy_uh2.ogg',
            [CHAR_SOUND_UH2_2] = 'daisy_uh2_2.ogg',
            [CHAR_SOUND_WAAAOOOW] = 'daisy_waaaooow.ogg',
            [CHAR_SOUND_WAH2] = 'daisy_wah2.ogg',
            [CHAR_SOUND_WHOA] = 'daisy_whoa.ogg',
            [CHAR_SOUND_YAHOO] = 'daisy_yahoo.ogg',
            [CHAR_SOUND_YAWNING] = 'daisy_yawning.ogg',
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'daisy_yahoo.ogg', 'daisy_yahoo2.ogg', 'daisy_yahoo3.ogg', 'daisy_yahoo4.ogg' },
            [CHAR_SOUND_YAH_WAH_HOO] = { 'daisy_yah1.ogg', 'daisy_yah2.ogg', 'daisy_yah3.ogg' },
            [CHAR_SOUND_HELLO] = 'daisy_double_jump.ogg'
        },
        anims = {
            [CHAR_ANIM_RUNNING] = 'princess_running',
            [CHAR_ANIM_IDLE_HEAD_CENTER] = 'princess_idle_head_center',
            [CHAR_ANIM_IDLE_HEAD_LEFT] = 'princess_idle_head_left',
            [CHAR_ANIM_IDLE_HEAD_RIGHT] = 'princess_idle_head_right',
            [CHAR_ANIM_BACKWARD_KB] = 'princess_backward_kb',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_FLUTTERKICK] = 'princess_flutterkick',
            [CHAR_ANIM_FLUTTERKICK_WITH_OBJ] = 'princess_flutterkick_with_obj',
            [CHAR_ANIM_FORWARD_KB] = 'princess_forward_kb',
            [CHAR_ANIM_GROUND_BONK] = 'princess_ground_bonk',
            [CHAR_ANIM_GROUND_KICK] = 'princess_ground_kick',
            [CHAR_ANIM_GROUND_THROW] = 'princess_ground_throw',
            [CHAR_ANIM_HEAVY_THROW] = 'princess_heavy_throw',
            [CHAR_ANIM_MISSING_CAP] = 'princess_missing_cap',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'princess_pull_door_walk_in',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_RELEASE_BOWSER] = 'princess_release_bowser',
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = 'princess_return_from_star_dance',
            [CHAR_ANIM_RETURN_STAR_APPROACH_DOOR] = 'princess_return_star_approach_door',
            [CHAR_ANIM_SLIDEFLIP_LAND] = 'princess_sideflip_land',
            [CHAR_ANIM_SLEEP_IDLE] = 'princess_sleep_idle',
            [CHAR_ANIM_START_SLEEP_SITTING] = 'princess_sleep_sitting',
            [CHAR_ANIM_SOFT_BACK_KB] = 'princess_soft_back_kb',
            [CHAR_ANIM_SOFT_FRONT_KB] = 'princess_soft_front_kb',
            [CHAR_ANIM_STAR_DANCE] = 'princess_star_dance',
            [CHAR_ANIM_START_CROUCHING] = 'princess_start_crouch',
            [CHAR_ANIM_STOP_CROUCHING] = 'princess_stop_crouch',
            [CHAR_ANIM_START_SLEEP_IDLE] = 'princess_start_sleep',
            [CHAR_ANIM_STOP_SLIDE] = 'princess_stop_slide',
            [CHAR_ANIM_SUMMON_STAR] = 'princess_summon_star',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART1] = 'princess_swim_with_obj1',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART2] = 'princess_swim_with_obj2',
            [CHAR_ANIM_TRIPLE_JUMP_LAND] = 'princess_triple_jump_land',
            [CHAR_ANIM_TURNING_PART1] = 'princess_turning_part1',
            [CHAR_ANIM_TURNING_PART2] = 'princess_turning_part2',
            [CHAR_ANIM_TWIRL_LAND] = 'princess_twirl_land',
            [CHAR_ANIM_WAKE_FROM_LYING] = 'princess_wake_from_lying',
            [CHAR_ANIM_WAKE_FROM_SLEEP] = 'princess_wake_from_sleep',
            [CHAR_ANIM_CREDITS_RAISE_HAND] = 'princess_credits_raise_hand',
            [CHAR_ANIM_CREDITS_RETURN_FROM_LOOK_UP] = 'princess_credits_return_from_look_up',
            [CHAR_ANIM_CREDITS_START_WALK_LOOK_UP] = 'princess_credits_start_walk_look_up',
            [CHAR_ANIM_CREDITS_TAKE_OFF_CAP] = 'princess_credits_take_off_cap',
            [CHAR_ANIM_DYING_FALL_OVER] = 'princess_dying_fall_over',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'princess_fall_over_backwards',
            [CHAR_ANIM_FAST_LEDGE_GRAB] = 'princess_fast_ledge_grab',
            --[CHAR_ANIM_FINAL_BOWSER_RAISE_HAND_SPIN] = 'princess_final_bowser_raise_hand_spin',
            [CHAR_ANIM_FIRST_PUNCH_FAST] = 'princess_first_punch_fast',
            [CHAR_ANIM_GENERAL_LAND] = 'princess_general_land',
            [CHAR_ANIM_HEAD_STUCK_IN_GROUND] = 'princess_head_stuck_in_ground',
            [CHAR_ANIM_LAND_FROM_DOUBLE_JUMP] = 'princess_land_from_double_jump',
            [CHAR_ANIM_LAND_FROM_SINGLE_JUMP] = 'princess_land_from_single_jump',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'princess_land_on_stomach',
            [CHAR_ANIM_LEGS_STUCK_IN_GROUND] = 'princess_legs_stuck_in_ground',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'princess_place_light_obj',
            [CHAR_ANIM_PUSH_DOOR_WALK_IN] = 'princess_push_door_walk_in',
            [CHAR_ANIM_PUT_CAP_ON] = 'princess_put_cap_on',
            [CHAR_ANIM_RUN_WITH_LIGHT_OBJ] = 'princess_run_with_light_obj',
            [CHAR_ANIM_SECOND_PUNCH_FAST] = 'princess_second_punch_fast',
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = 'princess_shivering_returning_to_idle',
            [CHAR_ANIM_SKID_ON_GROUND] = 'princess_skid_on_ground',
            [CHAR_ANIM_SLOW_LAND_FROM_DIVE] = 'princess_slow_land_from_dive',
            [CHAR_ANIM_SLOW_LEDGE_GRAB] = 'princess_slow_ledge_grab',
            [CHAR_ANIM_SLOW_WALK_WITH_LIGHT_OBJ] = 'princess_slow_walk_with_light_obj',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'princess_stand_up_from_lava_boost',
            [CHAR_ANIM_STOP_SKID] = 'princess_stop_skid',
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'princess_take_cap_off_then_on',
            [CHAR_ANIM_THROW_CATCH_KEY] = 'princess_throw_catch_key',
            [CHAR_ANIM_WALK_WITH_LIGHT_OBJ] = 'princess_walk_with_light_obj',
            [CHAR_ANIM_BOTTOM_STUCK_IN_GROUND] = 'princess_bottom_stuck_in_ground',
            --[CHAR_ANIM_CREDITS_PEACE_SIGN] = 'princess_credits_peace_sign',
            [CHAR_ANIM_FIRE_LAVA_BURN] = 'princess_fire_lava_burn',
            [CHAR_ANIM_GROUND_POUND] = 'princess_ground_pound',
            [CHAR_ANIM_GROUND_POUND_LANDING] = 'princess_ground_pound_landing',
            [CHAR_ANIM_TRIPLE_JUMP_GROUND_POUND] = 'princess_triple_jump_ground_pound_anim',
            [CHAR_ANIM_UNLOCK_DOOR] = 'princess_unlock_door',
            [CHAR_ANIM_SWINGING_BOWSER] = 'princess_swinging_bowser',
            [CHAR_ANIM_HOLDING_BOWSER] = 'princess_holding_bowser',
            [CHAR_ANIM_GRAB_BOWSER] = 'princess_grab_bowser',
            [CHAR_ANIM_BEND_KNESS_RIDING_SHELL] = 'daisy_dressjump',
            [CS_ANIM_MENU] = 'cs_daisy'
        }
    },

    -----------
    -- Yoshi --
    -----------
    {
        name = "Yoshi",
        description =
        "A friendly dinosuar originating from Dinosuar Land where he reunited with Mario! These cute little guys come in different colors! Might suggest to stay back when they're in a very hungry mood...",
        credits = "Coop Team / VA: FunkyLion 'Yuyake'",
        color = { r = 0, g = 255, b = 0 },
        model = smlua_model_util_get_id("yoshi_player_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-yoshi"),
        camScale = 1.1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-yoshi-meter-left"),
                right = get_texture_info("char-select-yoshi-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("yoshi_player_cap_geo"),
            wing = smlua_model_util_get_id("yoshi_player_wing_cap_geo"),
            metal = smlua_model_util_get_id("yoshi_player_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("yoshi_player_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = { r = 0xFF, g = 0x00, b = 0x00 },
                [SHIRT]  = { r = 0x00, g = 0xFF, b = 0x00 },
                [GLOVES] = { r = 0xFF, g = 0xFF, b = 0xFF },
                [SHOES]  = { r = 0xFF, g = 0x00, b = 0x00 },
                [HAIR]   = { r = 0xFF, g = 0x00, b = 0x00 },
                [SKIN]   = { r = 0xFF, g = 0xDE, b = 0x39 },
                [CAP]    = { r = 0x00, g = 0xFF, b = 0x00 },
                [EMBLEM] = { r = 0xFF, g = 0x00, b = 0x00 }
            },
            {
                name     = "Red",
                [PANTS]  = 'FFFF00',
                [SHIRT]  = 'FE0000',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '0000FF',
                [HAIR]   = 'FF6800',
                [SKIN]   = 'FEC179',
                [CAP]    = 'FF0000',
                [EMBLEM] = 'FF0000'
            },
            {
                name     = "Blue",
                [PANTS]  = '004098',
                [SHIRT]  = '004098',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'cb2998',
                [HAIR]   = 'ff6800',
                [SKIN]   = 'fec179',
                [CAP]    = '004098',
                [EMBLEM] = 'ff0000'
            },
            {
                name     = "Yellow",
                [PANTS]  = 'FFFF00',
                [SHIRT]  = 'FFFF00',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '00ff00',
                [HAIR]   = 'ff8600',
                [SKIN]   = 'fec179',
                [CAP]    = 'ffff00',
                [EMBLEM] = 'ff0000'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "yoshi_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "yoshi_coughing1.ogg", -- missing all three
            [CHAR_SOUND_COUGHING2] = "yoshi_coughing2.ogg", -- missing all three
            [CHAR_SOUND_COUGHING3] = "yoshi_coughing3.ogg", -- missing all three
            [CHAR_SOUND_DOH] = "yoshi_doh.ogg",
            [CHAR_SOUND_DROWNING] = "yoshi_drowning.ogg",
            [CHAR_SOUND_DYING] = "yoshi_dying.ogg",
            [CHAR_SOUND_EEUH] = "yoshi_euuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "yoshi_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "yoshi_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "yoshi_haha2.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "yoshi_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "yoshi_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "yoshi_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "yoshi_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "yoshi_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "yoshi_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "yoshi_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "yoshi_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "yoshi_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "yoshi_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "yoshi_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "yoshi_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "yoshi_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "yoshi_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "yoshi_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "yoshi_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "yoshi_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "yoshi_snoring2.ogg", "yoshi_snoring1.ogg", "yoshi_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "yoshi_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "yoshi_uh.ogg",
            [CHAR_SOUND_UH2] = "yoshi_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "yoshi_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "yoshi_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "yoshi_wah.ogg",
            [CHAR_SOUND_WHOA] = "yoshi_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "yoshi_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "yoshi_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "yoshi_yahoo.ogg", "yoshi_yahoo1.ogg", "yoshi_yahoo2.ogg", "yoshi_yahoo3.ogg", "yoshi_yahoo4.ogg", "yoshi_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "yoshi_yah_wah_hoo1.ogg", "yoshi_yah_wah_hoo2.ogg", "yoshi_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "yoshi_hello.ogg",
            -- Non-vanilla lines
            [YOSHI_SOUND_FLUTTER] = "yoshi_flutter.ogg",
        },
        anims = {
            [CS_ANIM_MENU] = "cs_yoshi",
        }
    },
    -----------
    -- Birdo --
    -----------
    {
        name = "Birdo",
        description =
        "A very feminine dinosuar who has fought against Mario during his dreams! How she came into reality is anyone's guess. It is said she was once a boy before she learned more about herself in life and eventually became a girl!",
        credits = "Coop Team / VA: LuUvvUCY 'Lucy'",
        color = { r = 254, g = 77, b = 127 },
        model = smlua_model_util_get_id("birdo_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-birdo"),
        camScale = 1.1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-birdo-meter-left"),
                right = get_texture_info("char-select-birdo-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("birdo_cap_geo"),
            wing = smlua_model_util_get_id("birdo_wing_cap_geo"),
            metal = smlua_model_util_get_id("birdo_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("birdo_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'FF0000',
                [SHIRT]  = 'FE4D7F',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'FE4D7F',
                [HAIR]   = 'FF0000',
                [SKIN]   = 'FEC179',
                [CAP]    = 'FE4D7F',
                [EMBLEM] = 'FF0000'
            },
            {
                name     = "Green",
                [PANTS]  = 'FDE400',
                [SHIRT]  = 'A4E784',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'A4E784',
                [HAIR]   = 'C91812',
                [SKIN]   = 'E88FFF',
                [CAP]    = 'A4E784',
                [EMBLEM] = '72FFFF'
            },
            {
                name     = "Red",
                [PANTS]  = 'ff5ec9',
                [SHIRT]  = 'eb1905',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '5b1905',
                [HAIR]   = 'c91812',
                [SKIN]   = 'e88fff',
                [CAP]    = 'eb1905',
                [EMBLEM] = '72ffff'
            },
            {
                name     = "Grey",
                [PANTS]  = 'CFCFCF',
                [SHIRT]  = '646464',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '646464',
                [HAIR]   = '468BCC',
                [SKIN]   = '646464',
                [CAP]    = '646464',
                [EMBLEM] = '646464'
            }
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "birdo_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "birdo_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "birdo_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "birdo_coughing3.ogg",
            [CHAR_SOUND_DOH] = "birdo_doh.ogg",
            [CHAR_SOUND_DROWNING] = "birdo_drowning.ogg", -- missing
            [CHAR_SOUND_DYING] = "birdo_dying.ogg",
            [CHAR_SOUND_EEUH] = "birdo_euuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "birdo_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "birdo_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "birdo_haha2.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "birdo_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "birdo_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "birdo_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "birdo_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "birdo_mamamia.ogg", -- Missing
            [CHAR_SOUND_LETS_A_GO] = "birdo_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "birdo_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "birdo_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "birdo_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "birdo_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "birdo_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "birdo_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "birdo_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "birdo_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "birdo_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "birdo_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "birdo_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "birdo_snoring2.ogg", "birdo_snoring1.ogg", "birdo_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "birdo_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "birdo_uh.ogg",
            [CHAR_SOUND_UH2] = "birdo_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "birdo_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "birdo_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "birdo_ground_pound_wah.ogg",
            [CHAR_SOUND_WHOA] = "birdo_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "birdo_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "birdo_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "birdo_yahoo.ogg", "birdo_yahoo1.ogg", "birdo_yahoo2.ogg", "birdo_yahoo3.ogg", "birdo_yahoo4.ogg", "birdo_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "birdo_yah_wah_hoo1.ogg", "birdo_yah_wah_hoo2.ogg", "birdo_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "birdo_hello.ogg"
        },
        anims = {
            [CS_ANIM_MENU] = "cs_birdo",
        }
    },

    --------------------------------
    -- Extra Characters - Wave II --
    --------------------------------

    -----------
    -- Spike --
    -----------
    {
        name = "Spike",
        description =
        "Owner of the Wrecking Crew company and former boss of the Mario Brothers before they moved to the plumbing business! He's had a vendetta against the bros since! Quite versitile with his hammer!",
        credits = "Coop Team / VA: VinnyVinesauce",
        color = { r = 88, g = 142, b = 255 },
        model = smlua_model_util_get_id("foreman_spike_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-spike"),
        camScale = 1.1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-foremanspike-meter-left"),
                right = get_texture_info("char-select-foremanspike-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("foreman_spike_cap_geo"),
            wing = smlua_model_util_get_id("foreman_spike_wing_cap_geo"),
            metal = smlua_model_util_get_id("foreman_spike_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("foreman_spike_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = '0000FF',
                [SHIRT]  = '568EFF',
                [GLOVES] = '613E21',
                [SHOES]  = '613E21',
                [HAIR]   = '000000',
                [SKIN]   = 'FEC179',
                [CAP]    = '568EFF',
                [EMBLEM] = 'FFFF00'
            },
            {
                name     = "Classic",
                [PANTS]  = 'c39e4e',
                [SHIRT]  = 'f0f1dd',
                [GLOVES] = 'ffffff',
                [SHOES]  = '721c0e',
                [HAIR]   = '000000',
                [SKIN]   = 'e9d9b0',
                [CAP]    = 'c39e4e',
                [EMBLEM] = '721c0e'
            },
            {
                name     = "Retro",
                [PANTS]  = 'c84c0c',
                [SHIRT]  = 'c84c0c',
                [GLOVES] = 'fcbcb0',
                [SHOES]  = '0000a8',
                [HAIR]   = '0000a8',
                [SKIN]   = 'fcbcb0',
                [CAP]    = 'c84c0c',
                [EMBLEM] = '0000a8'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "foreman_spike_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "foreman_spike_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "foreman_spike_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "foreman_spike_coughing3.ogg",
            [CHAR_SOUND_DOH] = "foreman_spike_doh.ogg",
            [CHAR_SOUND_DROWNING] = "foreman_spike_drowning.ogg",
            [CHAR_SOUND_DYING] = "foreman_spike_dying.ogg",
            [CHAR_SOUND_EEUH] = "foreman_spike_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "foreman_spike_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "foreman_spike_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "foreman_spike_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "foreman_spike_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "foreman_spike_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "foreman_spike_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "foreman_spike_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "foreman_spike_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "foreman_spike_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "foreman_spike_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "foreman_spike_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "foreman_spike_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "foreman_spike_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "foreman_spike_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "foreman_spike_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "foreman_spike_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "foreman_spike_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "foreman_spike_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "foreman_spike_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "foreman_spike_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "foreman_spike_snoring2.ogg", "foreman_spike_snoring1.ogg", "foreman_spike_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "foreman_spike_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "foreman_spike_uh.ogg",
            [CHAR_SOUND_UH2] = "foreman_spike_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "foreman_spike_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "foreman_spike_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "foreman_spike_wah2.ogg",
            [CHAR_SOUND_WHOA] = "foreman_spike_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "foreman_spike_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "foreman_spike_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "foreman_spike_yahoo.ogg", "foreman_spike_yahoo1.ogg", "foreman_spike_yahoo2.ogg", "foreman_spike_yahoo3.ogg", "foreman_spike_yahoo4.ogg", "foreman_spike_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "foreman_spike_yah_wah_hoo1.ogg", "foreman_spike_yah_wah_hoo2.ogg", "foreman_spike_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "foreman_spike_hello.ogg"
        },
        anims = {
            [CS_ANIM_MENU] = "cs_foremanspike",
        }
    },
    -------------
    -- Pauline --
    -------------
    {
        name = "Pauline",
        description =
        "Mayor of New Donk City who was originally saved by Mario in his days as a carpenter against the big ape, Donkey Kong!",
        credits = "Coop Team / VA: BeckyVO",
        color = { r = 207, g = 66, b = 57 },
        model = smlua_model_util_get_id("pauline_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-pauline"),
        camScale = 1.1,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-pauline-meter-left"),
                right = get_texture_info("char-select-pauline-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("pauline_cap_geo"),
            wing = smlua_model_util_get_id("pauline_wing_cap_geo"),
            metal = smlua_model_util_get_id("pauline_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("pauline_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'CF4239',
                [SHIRT]  = 'CF4239',
                [GLOVES] = 'FFFF00',
                [SHOES]  = 'CF4239',
                [HAIR]   = '793127',
                [SKIN]   = 'F8C1AC',
                [CAP]    = 'CF4239',
                [EMBLEM] = 'FFFF00'
            },
            {
                name     = "Classic",
                [PANTS]  = 'ff9fd5',
                [SHIRT]  = 'ff9fd5',
                [GLOVES] = 'ff9fd5',
                [SHOES]  = 'ff0000',
                [HAIR]   = 'fbe34b',
                [SKIN]   = 'f6e9b7',
                [CAP]    = 'ff9fd5',
                [EMBLEM] = 'ffffff'
            },
            {
                name     = "Odd Rock",
                [PANTS]  = '7234F5',
                [SHIRT]  = '7234F5',
                [GLOVES] = '7234F5',
                [SHOES]  = '412969',
                [HAIR]   = '412969',
                [SKIN]   = 'A68FFF',
                [CAP]    = '7234F5',
                [EMBLEM] = '72FFFF'
            },
            {
                name     = "Family",
                [PANTS]  = 'D8B51D',
                [SHIRT]  = '9D2121',
                [GLOVES] = '7234F5',
                [SHOES]  = '131315',
                [HAIR]   = '793127',
                [SKIN]   = 'F8C1AC',
                [CAP]    = '131315',
                [EMBLEM] = '7234F5'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "pauline_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "pauline_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "pauline_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "pauline_coughing3.ogg",
            [CHAR_SOUND_DOH] = "pauline_doh.ogg",
            [CHAR_SOUND_DROWNING] = "pauline_drowning.ogg",
            [CHAR_SOUND_DYING] = "pauline_dying.ogg",
            [CHAR_SOUND_EEUH] = "pauline_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "pauline_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "pauline_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "pauline_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "pauline_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "pauline_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "pauline_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "pauline_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "pauline_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "pauline_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "pauline_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "pauline_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "pauline_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "pauline_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "pauline_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "pauline_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "pauline_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "pauline_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "pauline_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "pauline_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "pauline_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "pauline_snoring2.ogg", "pauline_snoring1.ogg", "pauline_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "pauline_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "pauline_uh.ogg",
            [CHAR_SOUND_UH2] = "pauline_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "pauline_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "pauline_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "pauline_ground_pound_wah.ogg",
            [CHAR_SOUND_WHOA] = "pauline_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "pauline_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "pauline_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "pauline_yahoo.ogg", "pauline_yahoo1.ogg", "pauline_yahoo2.ogg", "pauline_yahoo3.ogg", "pauline_yahoo4.ogg", "pauline_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "pauline_yah_wah_hoo1.ogg", "pauline_yah_wah_hoo2.ogg", "pauline_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = "pauline_hello.ogg"
        },
        anims = {
            [CHAR_ANIM_RUNNING] = 'princess_running',
            [CHAR_ANIM_IDLE_HEAD_CENTER] = 'princess_idle_head_center',
            [CHAR_ANIM_IDLE_HEAD_LEFT] = 'princess_idle_head_left',
            [CHAR_ANIM_IDLE_HEAD_RIGHT] = 'princess_idle_head_right',
            [CHAR_ANIM_BACKWARD_KB] = 'princess_backward_kb',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_FLUTTERKICK] = 'princess_flutterkick',
            [CHAR_ANIM_FLUTTERKICK_WITH_OBJ] = 'princess_flutterkick_with_obj',
            [CHAR_ANIM_FORWARD_KB] = 'princess_forward_kb',
            [CHAR_ANIM_GROUND_BONK] = 'princess_ground_bonk',
            [CHAR_ANIM_GROUND_KICK] = 'princess_ground_kick',
            [CHAR_ANIM_GROUND_THROW] = 'princess_ground_throw',
            [CHAR_ANIM_HEAVY_THROW] = 'princess_heavy_throw',
            [CHAR_ANIM_MISSING_CAP] = 'princess_missing_cap',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'princess_pull_door_walk_in',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_RELEASE_BOWSER] = 'princess_release_bowser',
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = 'princess_return_from_star_dance',
            [CHAR_ANIM_RETURN_STAR_APPROACH_DOOR] = 'princess_return_star_approach_door',
            [CHAR_ANIM_SLIDEFLIP_LAND] = 'princess_sideflip_land',
            [CHAR_ANIM_SLEEP_IDLE] = 'princess_sleep_idle',
            [CHAR_ANIM_START_SLEEP_SITTING] = 'princess_sleep_sitting',
            [CHAR_ANIM_SOFT_BACK_KB] = 'princess_soft_back_kb',
            [CHAR_ANIM_SOFT_FRONT_KB] = 'princess_soft_front_kb',
            [CHAR_ANIM_STAR_DANCE] = 'princess_star_dance',
            [CHAR_ANIM_START_CROUCHING] = 'princess_start_crouch',
            [CHAR_ANIM_STOP_CROUCHING] = 'princess_stop_crouch',
            [CHAR_ANIM_START_SLEEP_IDLE] = 'princess_start_sleep',
            [CHAR_ANIM_STOP_SLIDE] = 'princess_stop_slide',
            [CHAR_ANIM_SUMMON_STAR] = 'princess_summon_star',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART1] = 'princess_swim_with_obj1',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART2] = 'princess_swim_with_obj2',
            [CHAR_ANIM_TRIPLE_JUMP_LAND] = 'princess_triple_jump_land',
            [CHAR_ANIM_TURNING_PART1] = 'princess_turning_part1',
            [CHAR_ANIM_TURNING_PART2] = 'princess_turning_part2',
            [CHAR_ANIM_TWIRL_LAND] = 'princess_twirl_land',
            [CHAR_ANIM_WAKE_FROM_LYING] = 'princess_wake_from_lying',
            [CHAR_ANIM_WAKE_FROM_SLEEP] = 'princess_wake_from_sleep',
            [CHAR_ANIM_CREDITS_RAISE_HAND] = 'princess_credits_raise_hand',
            [CHAR_ANIM_CREDITS_RETURN_FROM_LOOK_UP] = 'princess_credits_return_from_look_up',
            [CHAR_ANIM_CREDITS_START_WALK_LOOK_UP] = 'princess_credits_start_walk_look_up',
            [CHAR_ANIM_CREDITS_TAKE_OFF_CAP] = 'princess_credits_take_off_cap',
            [CHAR_ANIM_DYING_FALL_OVER] = 'princess_dying_fall_over',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'princess_fall_over_backwards',
            [CHAR_ANIM_FAST_LEDGE_GRAB] = 'princess_fast_ledge_grab',
            --[CHAR_ANIM_FINAL_BOWSER_RAISE_HAND_SPIN] = 'princess_final_bowser_raise_hand_spin',
            [CHAR_ANIM_FIRST_PUNCH_FAST] = 'princess_first_punch_fast',
            [CHAR_ANIM_GENERAL_LAND] = 'princess_general_land',
            [CHAR_ANIM_HEAD_STUCK_IN_GROUND] = 'princess_head_stuck_in_ground',
            [CHAR_ANIM_LAND_FROM_DOUBLE_JUMP] = 'princess_land_from_double_jump',
            [CHAR_ANIM_LAND_FROM_SINGLE_JUMP] = 'princess_land_from_single_jump',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'princess_land_on_stomach',
            [CHAR_ANIM_LEGS_STUCK_IN_GROUND] = 'princess_legs_stuck_in_ground',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'princess_place_light_obj',
            [CHAR_ANIM_PUSH_DOOR_WALK_IN] = 'princess_push_door_walk_in',
            [CHAR_ANIM_PUT_CAP_ON] = 'princess_put_cap_on',
            [CHAR_ANIM_RUN_WITH_LIGHT_OBJ] = 'princess_run_with_light_obj',
            [CHAR_ANIM_SECOND_PUNCH_FAST] = 'princess_second_punch_fast',
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = 'princess_shivering_returning_to_idle',
            [CHAR_ANIM_SKID_ON_GROUND] = 'princess_skid_on_ground',
            [CHAR_ANIM_SLOW_LAND_FROM_DIVE] = 'princess_slow_land_from_dive',
            [CHAR_ANIM_SLOW_LEDGE_GRAB] = 'princess_slow_ledge_grab',
            [CHAR_ANIM_SLOW_WALK_WITH_LIGHT_OBJ] = 'princess_slow_walk_with_light_obj',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'princess_stand_up_from_lava_boost',
            [CHAR_ANIM_STOP_SKID] = 'princess_stop_skid',
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'princess_take_cap_off_then_on',
            [CHAR_ANIM_THROW_CATCH_KEY] = 'princess_throw_catch_key',
            [CHAR_ANIM_WALK_WITH_LIGHT_OBJ] = 'princess_walk_with_light_obj',
            [CHAR_ANIM_BOTTOM_STUCK_IN_GROUND] = 'princess_bottom_stuck_in_ground',
            --[CHAR_ANIM_CREDITS_PEACE_SIGN] = 'princess_credits_peace_sign',
            [CHAR_ANIM_FIRE_LAVA_BURN] = 'princess_fire_lava_burn',
            [CHAR_ANIM_GROUND_POUND] = 'princess_ground_pound',
            [CHAR_ANIM_GROUND_POUND_LANDING] = 'princess_ground_pound_landing',
            [CHAR_ANIM_TRIPLE_JUMP_GROUND_POUND] = 'princess_triple_jump_ground_pound_anim',
            [CHAR_ANIM_UNLOCK_DOOR] = 'princess_unlock_door',
            [CHAR_ANIM_SWINGING_BOWSER] = 'princess_swinging_bowser',
            [CHAR_ANIM_HOLDING_BOWSER] = 'princess_holding_bowser',
            [CHAR_ANIM_GRAB_BOWSER] = 'princess_grab_bowser',
            [CS_ANIM_MENU] = "cs_pauline",
        },
        eyes = {
            [CS_ANIM_MENU] = MARIO_EYES_LOOK_LEFT,
        },
    },
    --------------
    -- Rosalina --
    --------------
    {
        name = "Rosalina",
        description =
        "Protector of the cosmos and mother to billions of Lumas. She was once a little girl who lost her own mother after traveling the cosmos to help a little Luma find their own mother. She has taken her role as their mother since.",
        credits = "Coop Team / VA: GauntletQueen",
        color = { r = 143, g = 239, b = 246 },
        model = smlua_model_util_get_id("rosalina_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-rosalina"),
        graffiti = get_texture_info("char-select-graffiti-rosalina"),
        camScale = 1.5,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-rosalina-meter-left"),
                right = get_texture_info("char-select-rosalina-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("rosalina_cap_geo"),
            wing = smlua_model_util_get_id("rosalina_wing_cap_geo"),
            metal = smlua_model_util_get_id("rosalina_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("rosalina_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = '8FEFF6',
                [SHIRT]  = '8FEFF6',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'FFFF00',
                [HAIR]   = 'FCC69A',
                [SKIN]   = 'FCE3CD',
                [CAP]    = 'B7B7BB',
                [EMBLEM] = 'FFFF00'
            },
            {
                name     = "Super Bell",
                [PANTS]  = '272F40',
                [SHIRT]  = '272F40',
                [GLOVES] = 'FFF9E9',
                [SHOES]  = 'FFFF00',
                [HAIR]   = 'FCC69A',
                [SKIN]   = 'FCE3CD',
                [CAP]    = 'B7B7BB',
                [EMBLEM] = 'FFF9E9'
            },
            {
                name     = "Witch",
                [PANTS]  = '411545',
                [SHIRT]  = '272F40',
                [GLOVES] = '7D3692',
                [SHOES]  = 'FFFF00',
                [HAIR]   = 'FCC69A',
                [SKIN]   = 'FCE3CD',
                [CAP]    = 'B7B7BB',
                [EMBLEM] = 'FFF9E9'
            }
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "rosalina_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "rosalina_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "rosalina_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "rosalina_coughing3.ogg",
            [CHAR_SOUND_DOH] = "rosalina_doh.ogg",
            [CHAR_SOUND_DROWNING] = "rosalina_drowning.ogg",
            [CHAR_SOUND_DYING] = "rosalina_dying.ogg",
            [CHAR_SOUND_EEUH] = "rosalina_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "rosalina_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "rosalina_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "rosalina_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "rosalina_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "rosalina_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "rosalina_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "rosalina_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "rosalina_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "rosalina_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "rosalina_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "rosalina_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "rosalina_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "rosalina_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "rosalina_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "rosalina_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "rosalina_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "rosalina_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "rosalina_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "rosalina_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "rosalina_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "rosalina_snoring2.ogg", "rosalina_snoring1.ogg", "rosalina_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "rosalina_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "rosalina_uh.ogg",
            [CHAR_SOUND_UH2] = "rosalina_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "rosalina_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "rosalina_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "rosalina_ground_pound_wah.ogg",
            [CHAR_SOUND_WHOA] = "rosalina_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "rosalina_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "rosalina_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "rosalina_yahoo.ogg", "rosalina_yahoo1.ogg", "rosalina_yahoo2.ogg", "rosalina_yahoo3.ogg", "rosalina_yahoo4.ogg", "rosalina_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "rosalina_yah_wah_hoo1.ogg", "rosalina_yah_wah_hoo2.ogg", "rosalina_yah_wah_hoo3.ogg" },
            [CHAR_SOUND_HELLO] = { "rosalina_hello.ogg", "rosalina_hello1.ogg", "rosalina_hello2.ogg", "rosalina_hello3.ogg", "rosalina_hello4.ogg" }
        },
        anims = {
            [CHAR_ANIM_RUNNING] = 'rosalina_running',
            [CHAR_ANIM_IDLE_HEAD_CENTER] = 'princess_idle_head_center',
            [CHAR_ANIM_IDLE_HEAD_LEFT] = 'princess_idle_head_left',
            [CHAR_ANIM_IDLE_HEAD_RIGHT] = 'princess_idle_head_right',
            [CHAR_ANIM_BACKWARD_KB] = 'princess_backward_kb',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_FLUTTERKICK] = 'princess_flutterkick',
            [CHAR_ANIM_FLUTTERKICK_WITH_OBJ] = 'princess_flutterkick_with_obj',
            [CHAR_ANIM_FORWARD_KB] = 'princess_forward_kb',
            [CHAR_ANIM_GROUND_BONK] = 'princess_ground_bonk',
            [CHAR_ANIM_GROUND_KICK] = 'princess_ground_kick',
            [CHAR_ANIM_GROUND_THROW] = 'princess_ground_throw',
            [CHAR_ANIM_HEAVY_THROW] = 'princess_heavy_throw',
            [CHAR_ANIM_MISSING_CAP] = 'princess_missing_cap',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'princess_pull_door_walk_in',
            [CHAR_ANIM_FIRST_PERSON] = 'princess_first_person',
            [CHAR_ANIM_RELEASE_BOWSER] = 'princess_release_bowser',
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = 'princess_return_from_star_dance',
            [CHAR_ANIM_RETURN_STAR_APPROACH_DOOR] = 'princess_return_star_approach_door',
            [CHAR_ANIM_SLIDEFLIP_LAND] = 'princess_sideflip_land',
            [CHAR_ANIM_SLEEP_IDLE] = 'princess_sleep_idle',
            [CHAR_ANIM_START_SLEEP_SITTING] = 'princess_sleep_sitting',
            [CHAR_ANIM_SOFT_BACK_KB] = 'princess_soft_back_kb',
            [CHAR_ANIM_SOFT_FRONT_KB] = 'princess_soft_front_kb',
            [CHAR_ANIM_STAR_DANCE] = 'princess_star_dance',
            [CHAR_ANIM_START_CROUCHING] = 'princess_start_crouch',
            [CHAR_ANIM_STOP_CROUCHING] = 'princess_stop_crouch',
            [CHAR_ANIM_START_SLEEP_IDLE] = 'princess_start_sleep',
            [CHAR_ANIM_STOP_SLIDE] = 'princess_stop_slide',
            [CHAR_ANIM_SUMMON_STAR] = 'princess_summon_star',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART1] = 'princess_swim_with_obj1',
            [CHAR_ANIM_SWIM_WITH_OBJ_PART2] = 'princess_swim_with_obj2',
            [CHAR_ANIM_TRIPLE_JUMP_LAND] = 'princess_triple_jump_land',
            [CHAR_ANIM_TURNING_PART1] = 'princess_turning_part1',
            [CHAR_ANIM_TURNING_PART2] = 'princess_turning_part2',
            [CHAR_ANIM_TWIRL_LAND] = 'princess_twirl_land',
            [CHAR_ANIM_WAKE_FROM_LYING] = 'princess_wake_from_lying',
            [CHAR_ANIM_WAKE_FROM_SLEEP] = 'princess_wake_from_sleep',
            [CHAR_ANIM_CREDITS_RAISE_HAND] = 'princess_credits_raise_hand',
            [CHAR_ANIM_CREDITS_RETURN_FROM_LOOK_UP] = 'princess_credits_return_from_look_up',
            [CHAR_ANIM_CREDITS_START_WALK_LOOK_UP] = 'princess_credits_start_walk_look_up',
            [CHAR_ANIM_CREDITS_TAKE_OFF_CAP] = 'princess_credits_take_off_cap',
            [CHAR_ANIM_DYING_FALL_OVER] = 'princess_dying_fall_over',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'princess_fall_over_backwards',
            [CHAR_ANIM_FAST_LEDGE_GRAB] = 'princess_fast_ledge_grab',
            --[CHAR_ANIM_FINAL_BOWSER_RAISE_HAND_SPIN] = 'princess_final_bowser_raise_hand_spin',
            [CHAR_ANIM_FIRST_PUNCH_FAST] = 'princess_first_punch_fast',
            [CHAR_ANIM_GENERAL_LAND] = 'princess_general_land',
            [CHAR_ANIM_HEAD_STUCK_IN_GROUND] = 'princess_head_stuck_in_ground',
            [CHAR_ANIM_LAND_FROM_DOUBLE_JUMP] = 'princess_land_from_double_jump',
            [CHAR_ANIM_LAND_FROM_SINGLE_JUMP] = 'princess_land_from_single_jump',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'princess_land_on_stomach',
            [CHAR_ANIM_LEGS_STUCK_IN_GROUND] = 'princess_legs_stuck_in_ground',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'princess_place_light_obj',
            [CHAR_ANIM_PUSH_DOOR_WALK_IN] = 'princess_push_door_walk_in',
            [CHAR_ANIM_PUT_CAP_ON] = 'princess_put_cap_on',
            [CHAR_ANIM_RUN_WITH_LIGHT_OBJ] = 'princess_run_with_light_obj',
            [CHAR_ANIM_SECOND_PUNCH_FAST] = 'princess_second_punch_fast',
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = 'princess_shivering_returning_to_idle',
            [CHAR_ANIM_SKID_ON_GROUND] = 'princess_skid_on_ground',
            [CHAR_ANIM_SLOW_LAND_FROM_DIVE] = 'princess_slow_land_from_dive',
            [CHAR_ANIM_SLOW_LEDGE_GRAB] = 'princess_slow_ledge_grab',
            [CHAR_ANIM_SLOW_WALK_WITH_LIGHT_OBJ] = 'princess_slow_walk_with_light_obj',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'princess_stand_up_from_lava_boost',
            [CHAR_ANIM_STOP_SKID] = 'princess_stop_skid',
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'princess_take_cap_off_then_on',
            [CHAR_ANIM_THROW_CATCH_KEY] = 'princess_throw_catch_key',
            [CHAR_ANIM_WALK_WITH_LIGHT_OBJ] = 'princess_walk_with_light_obj',
            [CHAR_ANIM_BOTTOM_STUCK_IN_GROUND] = 'princess_bottom_stuck_in_ground',
            --[CHAR_ANIM_CREDITS_PEACE_SIGN] = 'princess_credits_peace_sign',
            [CHAR_ANIM_FIRE_LAVA_BURN] = 'princess_fire_lava_burn',
            [CHAR_ANIM_GROUND_POUND] = 'princess_ground_pound',
            [CHAR_ANIM_GROUND_POUND_LANDING] = 'princess_ground_pound_landing',
            [CHAR_ANIM_TRIPLE_JUMP_GROUND_POUND] = 'princess_triple_jump_ground_pound_anim',
            [CHAR_ANIM_UNLOCK_DOOR] = 'princess_unlock_door',
            [CHAR_ANIM_SWINGING_BOWSER] = 'princess_swinging_bowser',
            [CHAR_ANIM_HOLDING_BOWSER] = 'princess_holding_bowser',
            [CHAR_ANIM_GRAB_BOWSER] = 'princess_grab_bowser',
            [CHAR_ANIM_BEND_KNESS_RIDING_SHELL] = 'rosalina_spinjump',
            [CS_ANIM_MENU] = "cs_rosalina",
        },
        eyes = {
            [CS_ANIM_MENU] = MARIO_EYES_OPEN,
        },
        hands = {
            [CS_ANIM_MENU] = MARIO_HAND_PEACE_SIGN,
        }
    },
    -------------
    -- WaPeach --
    -------------
    {
        name        = "WaPeach",
        description = "Who is this?! A Princess Peach imposter?! A very angsty girl who holds a very large axe for neferious purposes! How did she get here?! And why?",
        credits     = "Coop Team / VA: SlashOLantern",
        color       = { r = 255, g = 129, b = 69 },
        model       = smlua_model_util_get_id("wapeach_geo"),
        forceChar   = CT_MARIO,
        lifeIcon    = get_texture_info("icon-wapeach"),
        camScale    = 1,
        offset      = 0,
        meter = {
            label = {
                left    = get_texture_info("char-select-wapeach-meter-left"),
                right   = get_texture_info("char-select-wapeach-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("wapeach_cap_geo"),
            wing = smlua_model_util_get_id("wapeach_wing_cap_geo"),
            metal = smlua_model_util_get_id("wapeach_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("wapeach_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = '6C3AAC',
                [SHIRT]  = '6C3AAC',
                [GLOVES] = '6C3AAC',
                [SHOES]  = '6C3AAC',
                [HAIR]   = 'FF8145',
                [SKIN]   = 'BF9468',
                [CAP]    = 'EFCA11',
                [EMBLEM] = 'FF0000'
            },
            {
                name     = "Classic",
                [PANTS]  = '151010',
                [SHIRT]  = '151010',
                [GLOVES] = '151010',
                [SHOES]  = '151010',
                [HAIR]   = 'FEC431',
                [SKIN]   = 'BF9468',
                [CAP]    = 'FFC836',
                [EMBLEM] = 'FF258C'
            },
            {
                name     = "Scene",
                [PANTS]  = 'FF009E',
                [SHIRT]  = 'FF0077',
                [GLOVES] = 'FF005D',
                [SHOES]  = '372B2C',
                [HAIR]   = '00BE00',
                [SKIN]   = 'BF9468',
                [CAP]    = 'FF5581',
                [EMBLEM] = 'FFFFFF'
            }
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "wapeach_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "wapeach_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "wapeach_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "wapeach_coughing3.ogg",
            [CHAR_SOUND_DOH] = "wapeach_doh.ogg",
            [CHAR_SOUND_DROWNING] = "wapeach_drowning.ogg",
            [CHAR_SOUND_DYING] = "wapeach_dying.ogg",
            [CHAR_SOUND_EEUH] = "wapeach_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "wapeach_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "wapeach_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "wapeach_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "wapeach_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "wapeach_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "wapeach_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "wapeach_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "wapeach_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "wapeach_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "wapeach_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "wapeach_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "wapeach_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "wapeach_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "wapeach_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "wapeach_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "wapeach_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "wapeach_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "wapeach_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "wapeach_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "wapeach_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "wapeach_snoring2.ogg", "wapeach_snoring1.ogg", "wapeach_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "wapeach_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "wapeach_uh.ogg",
            [CHAR_SOUND_UH2] = "wapeach_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "wapeach_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "wapeach_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "wapeach_wah2.ogg",
            [CHAR_SOUND_WHOA] = "wapeach_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "wapeach_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "wapeach_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "wapeach_yahoo.ogg", "wapeach_yahoo1.ogg", "wapeach_yahoo2.ogg", "wapeach_yahoo3.ogg", "wapeach_yahoo4.ogg", "wapeach_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "wapeach_yah_wah_hoo1.ogg", "wapeach_yah_wah_hoo2.ogg", "wapeach_yah_wah_hoo3.ogg" },
            --[CHAR_SOUND_HELLO] = "wapeach_hello.ogg"
        },
        anims = {
            [CS_ANIM_MENU] = "cs_wapeach",
        },
        eyes = {
            [CS_ANIM_MENU] = MARIO_EYES_LOOK_RIGHT
        },
    },
    -----------------
    -- Donkey Kong --
    -----------------
    {
        name = "Donkey Kong",
        description =
        "King of the Apes! Son of the original Donkey Kong who battled Mario in the arcades. No matter which generation, the beef continues!",
        credits = "Coop Team / VA: Dean Seavor",
        color = { r = 131, g = 30, b = 20 },
        model = smlua_model_util_get_id("dk_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-dk"),
        camScale = 1.5,
        offset = 0,
        meter = {
            label = {
                left = get_texture_info("char-select-dk-meter-left"),
                right = get_texture_info("char-select-dk-meter-right"),
            },
            pie = {
                [1] = get_texture_info("char_select_custom_meter_pie1"),
                [2] = get_texture_info("char_select_custom_meter_pie2"),
                [3] = get_texture_info("char_select_custom_meter_pie3"),
                [4] = get_texture_info("char_select_custom_meter_pie4"),
                [5] = get_texture_info("char_select_custom_meter_pie5"),
                [6] = get_texture_info("char_select_custom_meter_pie6"),
                [7] = get_texture_info("char_select_custom_meter_pie7"),
                [8] = get_texture_info("char_select_custom_meter_pie8"),
            }
        },
        caps = {
            normal = smlua_model_util_get_id("dk_cap_geo"),
            wing = smlua_model_util_get_id("dk_wing_cap_geo"),
            metal = smlua_model_util_get_id("dk_metal_cap_geo"),
            metalWing = smlua_model_util_get_id("dk_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = 'FF0000',
                [SHIRT]  = '831E14',
                [GLOVES] = '6C3AAC',
                [SHOES]  = 'fec179',
                [HAIR]   = '831E14',
                [SKIN]   = 'fec179',
                [CAP]    = '831E14',
                [EMBLEM] = 'FFE900'
            },
            {
                name     = "Gorilla",
                [PANTS]  = 'eec52b',
                [SHIRT]  = '1b1b1b',
                [GLOVES] = 'ae794f',
                [SHOES]  = 'ae794f',
                [HAIR]   = '1b1b1b',
                [SKIN]   = 'ae794f',
                [CAP]    = '1b1b1b',
                [EMBLEM] = '2d5b2d'
            },
            {
                name     = "Yeti",
                [PANTS]  = 'FF0000',
                [SHIRT]  = 'ffffff',
                [GLOVES] = 'fec179',
                [SHOES]  = 'fec179',
                [HAIR]   = 'ffffff',
                [SKIN]   = 'fec179',
                [CAP]    = 'ffffff',
                [EMBLEM] = 'FFE900',
            },
            {
                name     = "Retro",
                [PANTS]  = 'ee7511',
                [SHIRT]  = 'ab0507',
                [GLOVES] = 'f5bb9f',
                [SHOES]  = 'f5bb9f',
                [HAIR]   = 'ab0507',
                [SKIN]   = 'f5bb9f',
                [CAP]    = 'ab0507',
                [EMBLEM] = 'f5bb9f'
            }
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "dk_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "dk_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "dk_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "dk_coughing3.ogg",
            [CHAR_SOUND_DOH] = "dk_doh.ogg",
            [CHAR_SOUND_DROWNING] = "dk_drowning.ogg",
            [CHAR_SOUND_DYING] = "dk_dying.ogg",
            [CHAR_SOUND_EEUH] = "dk_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "dk_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "dk_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "dk_haha.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "dk_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "dk_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "dk_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "dk_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "dk_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "dk_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "dk_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "dk_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "dk_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "dk_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "dk_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "dk_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "dk_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "dk_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "dk_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "dk_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "dk_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "dk_snoring2.ogg", "dk_snoring1.ogg", "dk_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "dk_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "dk_uh.ogg",
            [CHAR_SOUND_UH2] = "dk_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "dk_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "dk_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "dk_wah2.ogg",
            [CHAR_SOUND_WHOA] = "dk_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "dk_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "dk_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "dk_yahoo.ogg", "dk_yahoo1.ogg", "dk_yahoo2.ogg", "dk_yahoo3.ogg", "dk_yahoo4.ogg", "dk_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "dk_yah_wah_hoo1.ogg", "dk_yah_wah_hoo2.ogg", "dk_yah_wah_hoo3.ogg" },
            --[CHAR_SOUND_HELLO] = "dk_hello.ogg"
        },
        anims = {
            [CHAR_ANIM_IDLE_HEAD_CENTER] = 'donkey_idle_3',
            [CHAR_ANIM_IDLE_HEAD_LEFT] = 'donkey_idle_1',
            [CHAR_ANIM_IDLE_HEAD_RIGHT] = 'donkey_idle_2',
            [CHAR_ANIM_FIRST_PERSON] = 'donkey_first_person',
            [CHAR_ANIM_SLOW_LEDGE_GRAB] = 'donkey_00_slow_ledge_grab',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'donkey_01_fall_over_backwards',
            [CHAR_ANIM_SKID_ON_GROUND] = 'donkey_0F_skid_on_ground',
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = 'donkey_1a_shivering_return_to_idle',
            [CHAR_ANIM_CLIMB_DOWN_LEDGE] = 'donkey_1C_climb_down_ledge',
            [CHAR_ANIM_FALL_OVER_BACKWARDS] = 'donkey_02_fall',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'donkey_2C_anim_land_on_stomach',
            [CHAR_ANIM_SUFFOCATING] = 'donkey_2F_suffocating',
            [CHAR_ANIM_LAND_FROM_DOUBLE_JUMP] = 'donkey_4B_land_from_double_jump',
            [CHAR_ANIM_SINGLE_JUMP] = 'donkey_4D_single_jump',
            [CHAR_ANIM_LAND_FROM_SINGLE_JUMP] = 'donkey_4E_land_from_single_jump',
            [CHAR_ANIM_SLOW_LAND_FROM_DIVE] = 'donkey_5A_slow_land_from_dive',
            [CHAR_ANIM_MISSING_CAP] = 'donkey_5E_missing_cap',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'donkey_5F_pull_door_walk_in',
            [CHAR_ANIM_STOP_SKID] = 'donkey_10_stop_skid',
            [CHAR_ANIM_SHIVERING_WARMING_HAND] = 'donkey_19_shivering_warming_hand',
            --[CHAR_ANIM_CREDITS_RAISE_HAND] = 'donkey_20_credits_raide_hand',
            [CHAR_ANIM_CREDITS_TAKE_OFF_CAP] = 'donkey_22_credits_take_off_cap',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'donkey_28_standup_from_lava_boost',
            [CHAR_ANIM_LAND_ON_STOMACH] = 'donkey_2c_land_on_stomach',
            [CHAR_ANIM_AIR_FORWARD_KB] = 'donkey_2c_land_on_stomach',
            [CHAR_ANIM_DYING_ON_STOMACH] = 'donkey_2e_dying_on_stomach',
            [CHAR_ANIM_THROW_CATCH_KEY] = 'donkey_31_throw_catch_key',
            [CHAR_ANIM_DYING_FALL_OVER] = 'donkey_32_dying_fall_over',
            [CHAR_ANIM_PUT_CAP_ON] = 'donkey_36_put_cap_on',
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'donkey_37_take_cap_off_then_on',
            [CHAR_ANIM_HEAD_STUCK_IN_GROUND] = 'donkey_39_head_stuck_in_ground',
            [CHAR_ANIM_LEGS_STUCK_IN_GROUND] = 'donkey_55_legs_stuck_in_ground',
            [CHAR_ANIM_GENERAL_LAND] = 'donkey_57_general_land',
            [CHAR_ANIM_RUNNING] = 'donkey_72_running',
            [CHAR_ANIM_GROUND_THROW] = 'donkey_65_ground_throw',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'donkey_6E_place_light_obj',
            [CHAR_ANIM_WALKING] = 'donkey_48_walking',
            [CHAR_ANIM_GROUND_THROW] = 'donkey_65_ground_throw',
            [CHAR_ANIM_PLACE_LIGHT_OBJ] = 'donkey_6E_place_light_obj',
            [CHAR_ANIM_SOFT_BACK_KB] = 'donkey_74_soft_back_kb',
            [CHAR_ANIM_SOFT_FRONT_KB] = 'donkey_75_soft_front_kb',
            [CHAR_ANIM_BACKWARD_KB] = 'donkey_7B_backward_kb',
            [CHAR_ANIM_FORWARD_KB] = 'donkey_7C _forward_kb',
            [CHAR_ANIM_GROUND_BONK] = 'donkey_8A _ground_bonk',
            [CHAR_ANIM_TWIRL_LAND] = 'donkey_93_twirl_land',
            [CHAR_ANIM_SUMMON_STAR] = 'donkey_9C_summon_star',
            [CHAR_ANIM_RETURN_STAR_APPROACH_DOOR] = 'donkey_9D_return_star_approach_door',
            [CHAR_ANIM_RELEASE_BOWSER] = 'donkey_B7_release_bowser',
            [CHAR_ANIM_HEAVY_THROW] = 'donkey_B9_heavy_throw',
            [CHAR_ANIM_SLIDEFLIP_LAND] = 'donkey_BE_sideflip_land',
            [CHAR_ANIM_TRIPLE_JUMP_LAND] = 'donkey_C0_triple_jump_land',
            [CHAR_ANIM_CROUCHING] = 'donkey_98_crouching',
            [CHAR_ANIM_START_CRAWLING] = 'donkey_9B_start_crawling',
            [CHAR_ANIM_STOP_CRAWLING] = 'donkey_9A_stop_crawling',
            [CHAR_ANIM_STOP_CROUCHING] = 'donkey_96_stop_crouching',
            [CHAR_ANIM_START_CROUCHING] = 'donkey_97_start_crouching',
            [CHAR_ANIM_IDLE_ON_LEDGE] = 'donkey_33_idle_on_ledge',
            [CHAR_ANIM_FAST_LEDGE_GRAB] = 'donkey_34_fast_ledge_grab',
            [CHAR_ANIM_CRAWLING] = 'donkey_99_crawling',
            [CHAR_ANIM_CROUCH_FROM_SLIDE_KICK] = 'donkey_8D_crouch_from_slide_kick',
            [CHAR_ANIM_CROUCH_FROM_FAST_LONGJUMP] = 'donkey_11_crouch_from_fast_long_jump',
            [CHAR_ANIM_CROUCH_FROM_SLOW_LONGJUMP] = 'donkey_12_crouch_from_slow_long_jump',
            [CHAR_ANIM_WALK_PANTING] = 'donkey_ba_walk_panting',
            [CHAR_ANIM_STAND_UP_FROM_LAVA_BOOST] = 'donkey_28_standup_from_lava_boost',
            [CHAR_ANIM_FIRE_LAVA_BURN] = 'donkey_29_fire_lave_burn',
            [CHAR_ANIM_DIVE] = 'donkey_88_dive',
            [CHAR_ANIM_MISSING_CAP] = 'donkey_5E_missingcap',
            [CHAR_ANIM_STAR_DANCE] = 'donkey_CD_stardance',
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = 'donkey_CE_stardance_stop',
            [CHAR_ANIM_GROUND_KICK] = 'donkey_66_GroundKick',
            [CHAR_ANIM_PULL_DOOR_WALK_IN] = 'donkey_5F_pulldoor',
            [CHAR_ANIM_PUSH_DOOR_WALK_IN] = 'donkey_60_pushdoor',
            [CHAR_ANIM_START_TIPTOE] = 'donkey_CA_starttiptoe',
            [CHAR_ANIM_TIPTOE] = 'donkey_92_tiptoe',
            [CHAR_ANIM_UNLOCK_DOOR] = 'donkey_61_unlock_door',
            [CHAR_ANIM_STOP_SLIDE] = 'donkey_8F_stop_slide',
            [CHAR_ANIM_FIRST_PUNCH_FAST] = 'donkey_69_first_punch_fast',
            [CHAR_ANIM_SECOND_PUNCH_FAST] = 'donkey_6A_second_punch_fast',
            [CHAR_ANIM_TURNING_PART1] = 'donkey_BC_turningpart1',
            [CHAR_ANIM_TURNING_PART2] = 'donkey_BD_turningpart2',

            [CS_ANIM_MENU] = 'cs_donkey',
        },
    },
    -----------
    -- Sonic --
    -----------
    {
        name = "Sonic",
        description =
        "A rebellious teenage hedgehog with a blue of attitude, originating from Christmas Island. How'd he got here is anyone's guess.",
        credits = "Coop Team / VA: ReeseiMental",
        color = { r = 0, g = 0, b = 255 },
        model = smlua_model_util_get_id("segasonic_geo"),
        forceChar = CT_MARIO,
        lifeIcon = get_texture_info("icon-segasonic"),
        graffiti = get_texture_info("char-select-graffiti-sonic"),
        camScale = 0.9,
        offset = 0,
        meter = nil, -- meter code in moveset
        caps = {
            normal =     smlua_model_util_get_id("segasonic_cap_geo"),
            wing =       smlua_model_util_get_id("segasonic_wing_cap_geo"),
            metal =      smlua_model_util_get_id("segasonic_metal_cap_geo"),
            metalWing =  smlua_model_util_get_id("segasonic_metal_wing_cap_geo")
        },
        palettes = {
            {
                name     = "Default",
                [PANTS]  = '0000FF',
                [SHIRT]  = 'FEC179',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'FF0000',
                [HAIR]   = 'FFFF00',
                [SKIN]   = 'FEC179',
                [CAP]    = '0000FF',
                [EMBLEM] = '000000'
            },
            {
                name     = "Mirror",
                [PANTS]  = '555555',
                [SHIRT]  = 'cccccc',
                [GLOVES] = 'cccccc',
                [SHOES]  = '555555',
                [HAIR]   = 'cccccc',
                [SKIN]   = 'cccccc',
                [CAP]    = '555555',
                [EMBLEM] = '000000'
            },
            {
                name     = "Ashura",
                [PANTS]  = '000000',
                [SHIRT]  = 'ffb493',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = 'ff9000',
                [HAIR]   = 'FFFF00',
                [SKIN]   = 'ffb493',
                [CAP]    = '49fc00',
                [EMBLEM] = '006cff'
            },
            {
                name     = "Origin",
                [PANTS]  = 'ea7640',
                [SHIRT]  = 'e7eae5',
                [GLOVES] = 'FFFFFF',
                [SHOES]  = '248bbf',
                [HAIR]   = 'ba6864',
                [SKIN]   = 'e7eae5',
                [CAP]    = 'ea7640',
                [EMBLEM] = '000000'
            },
        },
        voices = {
            [CHAR_SOUND_ATTACKED] = "sonic_attacked.ogg",
            [CHAR_SOUND_COUGHING1] = "sonic_coughing1.ogg",
            [CHAR_SOUND_COUGHING2] = "sonic_coughing2.ogg",
            [CHAR_SOUND_COUGHING3] = "sonic_coughing3.ogg",
            [CHAR_SOUND_DOH] = "sonic_doh.ogg",
            [CHAR_SOUND_DROWNING] = "sonic_drowning.ogg",
            [CHAR_SOUND_DYING] = "sonic_dying.ogg",
            [CHAR_SOUND_EEUH] = "sonic_eeuh.ogg",
            [CHAR_SOUND_GROUND_POUND_WAH] = "sonic_ground_pound_wah.ogg",
            [CHAR_SOUND_HAHA] = "sonic_haha.ogg",
            [CHAR_SOUND_HAHA_2] = "sonic_haha2.ogg",
            [CHAR_SOUND_HERE_WE_GO] = "sonic_herewego.ogg",
            [CHAR_SOUND_HOOHOO] = "sonic_hoohoo.ogg",
            [CHAR_SOUND_HRMM] = "sonic_hrmm.ogg",
            [CHAR_SOUND_IMA_TIRED] = "sonic_imatired.ogg",
            [CHAR_SOUND_MAMA_MIA] = "sonic_mamamia.ogg",
            [CHAR_SOUND_LETS_A_GO] = "sonic_letsago.ogg",
            [CHAR_SOUND_ON_FIRE] = "sonic_on_fire.ogg",
            [CHAR_SOUND_OOOF] = "sonic_ooof.ogg",
            [CHAR_SOUND_OOOF2] = "sonic_ooof2.ogg",
            [CHAR_SOUND_PANTING] = "sonic_panting.ogg",
            [CHAR_SOUND_PANTING_COLD] = "sonic_panting_cold.ogg",
            [CHAR_SOUND_PUNCH_HOO] = "sonic_punch_hoo.ogg",
            [CHAR_SOUND_PUNCH_WAH] = "sonic_punch_wah.ogg",
            [CHAR_SOUND_PUNCH_YAH] = "sonic_punch_yah.ogg",
            [CHAR_SOUND_SO_LONGA_BOWSER] = "sonic_solonga_bowser.ogg",
            [CHAR_SOUND_SNORING1] = "sonic_snoring1.ogg",
            [CHAR_SOUND_SNORING2] = "sonic_snoring2.ogg",
            [CHAR_SOUND_SNORING3] = { "sonic_snoring2.ogg", "sonic_snoring1.ogg", "sonic_snoring3.ogg" },
            [CHAR_SOUND_TWIRL_BOUNCE] = "sonic_twirl_bounce.ogg",
            [CHAR_SOUND_UH] = "sonic_uh.ogg",
            [CHAR_SOUND_UH2] = "sonic_uh2.ogg",
            [CHAR_SOUND_UH2_2] = "sonic_uh2_2.ogg",
            [CHAR_SOUND_WAAAOOOW] = "sonic_waaaooow.ogg",
            [CHAR_SOUND_WAH2] = "sonic_wah2.ogg",
            [CHAR_SOUND_WHOA] = "sonic_whoa.ogg",
            [CHAR_SOUND_YAHOO] = "sonic_yahoo.ogg",
            [CHAR_SOUND_YAWNING] = "sonic_yawning.ogg",
            [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { "sonic_yahoo.ogg", "sonic_yahoo1.ogg", "sonic_yahoo2.ogg", "sonic_yahoo3.ogg", "sonic_yahoo4.ogg", "sonic_yahoo5.ogg" },
            [CHAR_SOUND_YAH_WAH_HOO] = { "sonic_yah_wah_hoo1.ogg", "sonic_yah_wah_hoo2.ogg", "sonic_yah_wah_hoo3.ogg" },
            --[CHAR_SOUND_HELLO] = "sonic_hello.ogg"
        },
        anims = {
            [CHAR_ANIM_WALKING] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_walk'
                end
            end,
            [CHAR_ANIM_RUNNING] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_running'
                end
            end,
            [CHAR_ANIM_SHIVERING_RETURN_TO_IDLE] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_shivering_stop'
                end
            end,
            [CHAR_ANIM_RUNNING_UNUSED] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_running3'
                end
            end,
            [CHAR_ANIM_STAR_DANCE] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_victory'
                end
            end,
            [CHAR_ANIM_RETURN_FROM_STAR_DANCE] = function(m)
                if gCSPlayers[m.playerIndex].movesetToggle then
                    return 'sonic_after_victory'
                end
            end,
            [CHAR_ANIM_TAKE_CAP_OFF_THEN_ON] = 'sonic_star_exit_with_hat',
            [CHAR_ANIM_PUT_CAP_ON] = 'sonic_putting_on_hat',
            [CS_ANIM_MENU] = 'cs_sonic',
        },
        eyes = {
            [CS_ANIM_MENU] = MARIO_EYES_LOOK_LEFT
        },
    },
}

local ultraBrosCredits = {
    {
        name = TEXT_PACK_NAME,
        "FunkyLion,Lead Dev",
        "Melzinoff,Co-Lead",
        "MlopsFunny,Animation",
        "Sharen,Animation",
        "WBmario,Animation",
        "FluffaMario,Models",
        "EmilyEmmi,Moveset",
        "Wibblus,Moveset",
        "SwagSkeleton95,Moveset",
        "steven3004,Moveset, Coder",
        "PeachyPeach,Moveset, Coder",
        "Squishy6094,CS Coder",
        "xLuigiGamerx,Moveset, Coder",
        'Strawberii "Oreo",Render Icons',
        "Chars_64,Render Icons",
        "WaterVapor,DK Render",
        "wwolforam,Sonic Render",
        "SMSAlfredo,Coder",
    },
    {
        name = TEXT_PACK_NAME .. " Voice Actors",
        "MelissaMekrose,Toadette",
        "SuperKirbyLover,Peach",
        "MorphiGalaxi,Daisy",
        "FunkyLion,Yoshi",
        "LuUvvUCY,Birdo",
        "VinnyVinesauce,Spike",
        "BeckyVO,Pauline",
        "GauntletQueen,Rosalina",
        "SlashOLantern,WaPeach",
        "Dean Seavor,Donkey Kong",
        "ReeseiMental,Sonic",
    },
    {
        name = TEXT_PACK_NAME .. " Graffiti Artists",
        "SAWhane,Sonic",
    },
}

local function on_character_select_load()
    for i, char in pairs(extraCharacters) do
        local _ENV = setmetatable(char, { __index = _G })
        tablePos = character_add(name, description, credits, color, model, forceChar, lifeIcon, camScale, offset, meter, graffiti)
        if caps then character_add_caps(model, caps) end
        if voices then character_add_voice(model, voices) end
        if palettes then
            for i = 1, #palettes do
                character_add_palette_preset(model, palettes[i], palettes[i].name)
            end
        end
        character_set_category(tablePos, "CoopDX")
        if anims then character_add_animations(model, anims, eyes, hands) end
        if meter then character_add_health_meter(tablePos, meter) end
        if graffiti then character_add_graffiti(tablePos, graffiti) end
    end

    for i = 1, #ultraBrosCredits do
        for c = 1, #ultraBrosCredits[i] do
            local creditSplit = string.split(ultraBrosCredits[i][c], ",")
            charSelect.credit_add(ultraBrosCredits[i].name, creditSplit[1], creditSplit[2])
        end
    end
end

hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)