--- @diagnostic disable
if not charSelect then return end

-- Disables Torso Tilting to fix DK Walk
local function mario_update(m)
	if m.action == ACT_WALKING and character_get_current_number(m.playerIndex) == CT_DONKEY_KONG then
        m.marioBodyState.torsoAngle.x = 0
        m.marioBodyState.torsoAngle.z = 0
        --results in double step sounds when going at the usual 32 speed (sigh)
        m.marioObj.header.gfx.animInfo.animAccel = m.marioObj.header.gfx.animInfo.animAccel * 0.85
    end
end
hook_event(HOOK_MARIO_UPDATE, mario_update)


smlua_anim_util_register_animation('donkey_first_person',0, 0, 0, 0, 30, { 
	0x0000, 0x008B, 0x008B, 0x008B, 0x008B, 0x008A, 0x008A, 0x0089, 0x0088, 
	0x0087, 0x0086, 0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0085, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 
	0x008A, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0x0000, 0x039F, 0x03A3, 0x03AD, 0x03BF, 0x03D8, 0x03F9, 0x0420, 
	0x044F, 0x0483, 0x04B1, 0x04D9, 0x04F9, 0x0512, 0x0524, 0x052F, 0x0532, 
	0x052F, 0x0524, 0x0512, 0x04F9, 0x04D9, 0x04B1, 0x0483, 0x044F, 0x0420, 
	0x03F9, 0x03D8, 0x03BF, 0x03AD, 0x03A3, 0x039F, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xEE2F, 0xEE24, 0xEE03, 0xEDCC, 0xED7E, 0xED1B, 0xECA2, 
	0xEC13, 0xEB73, 0xEAE3, 0xEA6A, 0xEA07, 0xE9BA, 0xE983, 0xE962, 0xE956, 
	0xE962, 0xE983, 0xE9BA, 0xEA07, 0xEA6A, 0xEAE3, 0xEB73, 0xEC13, 0xECA2, 
	0xED1B, 0xED7E, 0xEDCC, 0xEE03, 0xEE24, 0xEE2F, 0xFFFE, 0x0001, 0xC170, 
	0x1DCC, 0x1DC2, 0x1DA5, 0x1D73, 0x1D2E, 0x1CD5, 0x1C69, 0x1BE9, 0x1B59, 
	0x1AD9, 0x1A6D, 0x1A14, 0x19CF, 0x199D, 0x1980, 0x1976, 0x1980, 0x199D, 
	0x19CF, 0x1A14, 0x1A6D, 0x1AD9, 0x1B59, 0x1BE9, 0x1C69, 0x1CD5, 0x1D2E, 
	0x1D73, 0x1DA5, 0x1DC2, 0x1DCC, 0xD901, 0xD8F8, 0xD8DC, 0xD8AE, 0xD86E, 
	0xD81B, 0xD7B6, 0xD73E, 0xD6B8, 0xD641, 0xD5DB, 0xD589, 0xD548, 0xD51A, 
	0xD4FE, 0xD4F5, 0xD4FE, 0xD51A, 0xD548, 0xD589, 0xD5DB, 0xD641, 0xD6B8, 
	0xD73E, 0xD7B6, 0xD81B, 0xD86E, 0xD8AE, 0xD8DC, 0xD8F8, 0xD901, 0xB867, 
	0xB874, 0xB89D, 0xB8E0, 0xB93E, 0xB9B7, 0xBA4B, 0xBAFA, 0xBBBD, 0xBC6C, 
	0xBD00, 0xBD79, 0xBDD8, 0xBE1B, 0xBE43, 0xBE51, 0xBE43, 0xBE1B, 0xBDD8, 
	0xBD79, 0xBD00, 0xBC6C, 0xBBBD, 0xBAFA, 0xBA4B, 0xB9B7, 0xB93E, 0xB8E0, 
	0xB89D, 0xB874, 0xB867, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xC9F4, 
	0xC9E4, 0xC9B3, 0xC962, 0xC8F1, 0xC85F, 0xC7AD, 0xC6DB, 0xC5F0, 0xC51E, 
	0xC46C, 0xC3DA, 0xC369, 0xC318, 0xC2E8, 0xC2D7, 0xC2E8, 0xC318, 0xC369, 
	0xC3DA, 0xC46C, 0xC51E, 0xC5F0, 0xC6DB, 0xC7AD, 0xC85F, 0xC8F1, 0xC962, 
	0xC9B3, 0xC9E4, 0xC9F4, 0x071C, 0x071D, 0x071F, 0x0724, 0x072A, 0x0733, 
	0x073D, 0x0748, 0x0756, 0x0762, 0x076C, 0x0774, 0x077A, 0x077F, 0x0782, 
	0x0783, 0x0782, 0x077F, 0x077A, 0x0774, 0x076C, 0x0762, 0x0756, 0x0748, 
	0x073D, 0x0733, 0x072A, 0x0724, 0x071F, 0x071D, 0x071C, 0x0306, 0x0301, 
	0x02F2, 0x02D9, 0x02B5, 0x0288, 0x0251, 0x0210, 0x01C8, 0x0187, 0x0150, 
	0x0122, 0x00FF, 0x00E6, 0x00D7, 0x00D2, 0x00D7, 0x00E6, 0x00FF, 0x0122, 
	0x0150, 0x0187, 0x01C8, 0x0210, 0x0251, 0x0288, 0x02B5, 0x02D9, 0x02F2, 
	0x0301, 0x0306, 0x0A90, 0x0A91, 0x0A96, 0x0A9E, 0x0AAA, 0x0AB9, 0x0ACB, 
	0x0AE1, 0x0AF9, 0x0B0E, 0x0B20, 0x0B2F, 0x0B3B, 0x0B43, 0x0B48, 0x0B4A, 
	0x0B48, 0x0B43, 0x0B3B, 0x0B2F, 0x0B20, 0x0B0E, 0x0AF9, 0x0AE1, 0x0ACB, 
	0x0AB9, 0x0AAA, 0x0A9E, 0x0A96, 0x0A91, 0x0A90, 0xFFFE, 0x0001, 0xC170, 
	0x36DA, 0x36CF, 0x36AE, 0x3677, 0x362A, 0x35C7, 0x354F, 0x34C0, 0x3420, 
	0x3391, 0x3318, 0x32B5, 0x3269, 0x3232, 0x3211, 0x3206, 0x3211, 0x3232, 
	0x3269, 0x32B5, 0x3318, 0x3391, 0x3420, 0x34C0, 0x354F, 0x35C7, 0x362A, 
	0x3677, 0x36AE, 0x36CF, 0x36DA, 0x54F5, 0x54E9, 0x54C4, 0x5487, 0x5431, 
	0x53C3, 0x533C, 0x529D, 0x51EB, 0x514B, 0x50C4, 0x5056, 0x5000, 0x4FC3, 
	0x4F9E, 0x4F92, 0x4F9E, 0x4FC3, 0x5000, 0x5056, 0x50C4, 0x514B, 0x51EB, 
	0x529D, 0x533C, 0x53C3, 0x5431, 0x5487, 0x54C4, 0x54E9, 0x54F5, 0x175C, 
	0x174F, 0x1726, 0x16E2, 0x1683, 0x1609, 0x1574, 0x14C4, 0x13FF, 0x134F, 
	0x12BA, 0x1240, 0x11E1, 0x119D, 0x1175, 0x1167, 0x1175, 0x119D, 0x11E1, 
	0x1240, 0x12BA, 0x134F, 0x13FF, 0x14C4, 0x1574, 0x1609, 0x1683, 0x16E2, 
	0x1726, 0x174F, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCB4E, 0xCB19, 0xCAC0, 0xCA43, 
	0xC9A3, 0xC8DF, 0xC7F8, 0xC6F6, 0xC60E, 0xC54A, 0xC4AA, 0xC42E, 0xC3D5, 
	0xC39F, 0xC38D, 0xC39F, 0xC3D5, 0xC42E, 0xC4AA, 0xC54A, 0xC60E, 0xC6F6, 
	0xC7F8, 0xC8DF, 0xC9A3, 0xCA43, 0xCAC0, 0xCB19, 0xCB4E, 0xCB60, 0xFA42, 
	0xFA41, 0xFA41, 0xFA41, 0xFA40, 0xFA3F, 0xFA3D, 0xFA3C, 0xFA3A, 0xFA39, 
	0xFA38, 0xFA36, 0xFA36, 0xFA35, 0xFA35, 0xFA35, 0xFA35, 0xFA35, 0xFA36, 
	0xFA36, 0xFA38, 0xFA39, 0xFA3A, 0xFA3C, 0xFA3D, 0xFA3F, 0xFA40, 0xFA41, 
	0xFA41, 0xFA41, 0xFA42, 0x0197, 0x0198, 0x019C, 0x01A2, 0x01AA, 0x01B4, 
	0x01C1, 0x01D1, 0x01E2, 0x01F1, 0x01FE, 0x0208, 0x0210, 0x0216, 0x021A, 
	0x021B, 0x021A, 0x0216, 0x0210, 0x0208, 0x01FE, 0x01F1, 0x01E2, 0x01D1, 
	0x01C1, 0x01B4, 0x01AA, 0x01A2, 0x019C, 0x0198, 0x0197, 0x0624, 0x0628, 
	0x0632, 0x0644, 0x065D, 0x067C, 0x06A3, 0x06D1, 0x0704, 0x0732, 0x0759, 
	0x0779, 0x0791, 0x07A3, 0x07AE, 0x07B1, 0x07AE, 0x07A3, 0x0791, 0x0779, 
	0x0759, 0x0732, 0x0704, 0x06D1, 0x06A3, 0x067C, 0x065D, 0x0644, 0x0632, 
	0x0628, 0x0624, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFEA3, 0xFEBC, 0xFEE4, 
	0xFF1D, 0xFF66, 0xFFBF, 0x002A, 0x009F, 0x0109, 0x0162, 0x01AB, 0x01E4, 
	0x020C, 0x0225, 0x022D, 0x0225, 0x020C, 0x01E4, 0x01AB, 0x0162, 0x0109, 
	0x009F, 0x002A, 0xFFBF, 0xFF66, 0xFF1D, 0xFEE4, 0xFEBC, 0xFEA3, 0xFE9B, 
	0xEFF9, 0xEFF8, 0xEFF3, 0xEFEC, 0xEFE1, 0xEFD4, 0xEFC4, 0xEFB1, 0xEF9B, 
	0xEF88, 0xEF78, 0xEF6B, 0xEF60, 0xEF59, 0xEF54, 0xEF53, 0xEF54, 0xEF59, 
	0xEF60, 0xEF6B, 0xEF78, 0xEF88, 0xEF9B, 0xEFB1, 0xEFC4, 0xEFD4, 0xEFE1, 
	0xEFEC, 0xEFF3, 0xEFF8, 0xEFF9, 0x839E, 0x8390, 0x8364, 0x831B, 0x82B5, 
	0x8232, 0x8192, 0x80D4, 0x8001, 0x7F44, 0x7EA4, 0x7E20, 0x7DBA, 0x7D72, 
	0x7D46, 0x7D37, 0x7D46, 0x7D72, 0x7DBA, 0x7E20, 0x7EA4, 0x7F44, 0x8001, 
	0x80D4, 0x8192, 0x8232, 0x82B5, 0x831B, 0x8364, 0x8390, 0x839E, 0x0000, 
	0xFFFF, 0x49EE, 0x4A01, 0x4A3A, 0x4A98, 0x4B1D, 0x4BC8, 0x4C98, 0x4D8F, 
	0x4EA1, 0x4F98, 0x5068, 0x5113, 0x5198, 0x51F6, 0x522F, 0x5242, 0x522F, 
	0x51F6, 0x5198, 0x5113, 0x5068, 0x4F98, 0x4EA1, 0x4D8F, 0x4C98, 0x4BC8, 
	0x4B1D, 0x4A98, 0x4A3A, 0x4A01, 0x49EE, 0xF7AE, 0xF7AB, 0xF7A3, 0xF797, 
	0xF785, 0xF76E, 0xF752, 0xF731, 0xF70C, 0xF6EB, 0xF6D0, 0xF6B9, 0xF6A7, 
	0xF69A, 0xF693, 0xF690, 0xF693, 0xF69A, 0xF6A7, 0xF6B9, 0xF6D0, 0xF6EB, 
	0xF70C, 0xF731, 0xF752, 0xF76E, 0xF785, 0xF797, 0xF7A3, 0xF7AB, 0xF7AE, 
	0x03C6, 0x03C6, 0x03C5, 0x03C4, 0x03C3, 0x03C1, 0x03BF, 0x03BD, 0x03BB, 
	0x03B8, 0x03B6, 0x03B5, 0x03B4, 0x03B3, 0x03B2, 0x03B2, 0x03B2, 0x03B3, 
	0x03B4, 0x03B5, 0x03B6, 0x03B8, 0x03BB, 0x03BD, 0x03BF, 0x03C1, 0x03C3, 
	0x03C4, 0x03C5, 0x03C6, 0xAB92, 0xAB8D, 0xAB7D, 0xAB63, 0xAB3E, 0xAB0F, 
	0xAAD5, 0xAA91, 0xAA45, 0xAA01, 0xA9C7, 0xA998, 0xA973, 0xA959, 0xA949, 
	0xA944, 0xA949, 0xA959, 0xA973, 0xA998, 0xA9C7, 0xAA01, 0xAA45, 0xAA91, 
	0xAAD5, 0xAB0F, 0xAB3E, 0xAB63, 0xAB7D, 0xAB8D, 0xAB92, 0xFFFF, 0x0000, 
	0xBF5E, 0x01C0, 0x01B7, 0x019D, 0x0171, 0x0134, 0x00E5, 0x0085, 0x0013, 
	0xFF93, 0xFF21, 0xFEC1, 0xFE72, 0xFE35, 0xFE09, 0xFDEF, 0xFDE6, 0xFDEF, 
	0xFE09, 0xFE35, 0xFE72, 0xFEC1, 0xFF21, 0xFF93, 0x0013, 0x0085, 0x00E5, 
	0x0134, 0x0171, 0x019D, 0x01B7, 0x01C0, 0x1192, 0x1194, 0x1198, 0x11A0, 
	0x11AB, 0x11B9, 0x11CA, 0x11DE, 0x11F4, 0x1208, 0x1219, 0x1227, 0x1232, 
	0x1239, 0x123E, 0x123F, 0x123E, 0x1239, 0x1232, 0x1227, 0x1219, 0x1208, 
	0x11F4, 0x11DE, 0x11CA, 0x11B9, 0x11AB, 0x11A0, 0x1198, 0x1194, 0x1192, 
	0x842B, 0x841C, 0x83EF, 0x83A3, 0x833A, 0x82B1, 0x820B, 0x8147, 0x806C, 
	0x7FA7, 0x7F01, 0x7E79, 0x7E0F, 0x7DC4, 0x7D96, 0x7D87, 0x7D96, 0x7DC4, 
	0x7E0F, 0x7E79, 0x7F01, 0x7FA7, 0x806C, 0x8147, 0x820B, 0x82B1, 0x833A, 
	0x83A3, 0x83EF, 0x841C, 0x842B, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x4A21, 0x4A34, 0x4A6C, 0x4ACA, 0x4B4E, 0x4BF7, 
	0x4CC6, 0x4DBA, 0x4ECA, 0x4FBF, 0x508E, 0x5137, 0x51BA, 0x5218, 0x5251, 
	0x5264, 0x5251, 0x5218, 0x51BA, 0x5137, 0x508E, 0x4FBF, 0x4ECA, 0x4DBA, 
	0x4CC6, 0x4BF7, 0x4B4E, 0x4ACA, 0x4A6C, 0x4A34, 0x4A21, 0x09D3, 0x09D6, 
	0x09DF, 0x09EF, 0x0A06, 0x0A22, 0x0A45, 0x0A6F, 0x0A9D, 0x0AC6, 0x0AE9, 
	0x0B06, 0x0B1C, 0x0B2C, 0x0B36, 0x0B39, 0x0B36, 0x0B2C, 0x0B1C, 0x0B06, 
	0x0AE9, 0x0AC6, 0x0A9D, 0x0A6F, 0x0A45, 0x0A22, 0x0A06, 0x09EF, 0x09DF, 
	0x09D6, 0x09D3, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 0xFE38, 0xFE3A, 0xFE3E, 
	0xFE42, 0xFE47, 0xFE4B, 0xFE4F, 0xFE52, 0xFE54, 0xFE56, 0xFE57, 0xFE57, 
	0xFE57, 0xFE56, 0xFE54, 0xFE52, 0xFE4F, 0xFE4B, 0xFE47, 0xFE42, 0xFE3E, 
	0xFE3A, 0xFE38, 0xFE35, 0xFE34, 0xFE33, 0xFE32, 0xABC3, 0xABBD, 0xABAD, 
	0xAB92, 0xAB6C, 0xAB3B, 0xAAFF, 0xAAB8, 0xAA69, 0xAA22, 0xA9E7, 0xA9B6, 
	0xA990, 0xA974, 0xA964, 0xA95F, 0xA964, 0xA974, 0xA990, 0xA9B6, 0xA9E7, 
	0xAA22, 0xAA69, 0xAAB8, 0xAAFF, 0xAB3B, 0xAB6C, 0xAB92, 0xABAD, 0xABBD, 
	0xABC3, 

},{ 
	0x0001, 0x0000, 0x001C, 0x0001, 0x0001, 0x001D, 0x0001, 0x001E, 0x0001, 
	0x001F, 0x0001, 0x0020, 0x0001, 0x0021, 0x0001, 0x0022, 0x0001, 0x0023, 
	0x0001, 0x0024, 0x0001, 0x0025, 0x001F, 0x0026, 0x001F, 0x0045, 0x0001, 
	0x0064, 0x001F, 0x0065, 0x0001, 0x0084, 0x0001, 0x0085, 0x0001, 0x0086, 
	0x001F, 0x0087, 0x001F, 0x00A6, 0x001F, 0x00C5, 0x001F, 0x00E4, 0x001C, 
	0x0103, 0x001F, 0x011F, 0x001F, 0x013E, 0x001F, 0x015D, 0x001F, 0x017C, 
	0x0001, 0x019B, 0x0001, 0x019C, 0x0001, 0x019D, 0x001F, 0x019E, 0x001F, 
	0x01BD, 0x001F, 0x01DC, 0x0001, 0x01FB, 0x001B, 0x01FC, 0x001F, 0x0217, 
	0x001F, 0x0236, 0x001F, 0x0255, 0x001F, 0x0274, 0x0001, 0x0293, 0x0001, 
	0x0294, 0x0001, 0x0295, 0x001F, 0x0296, 0x001F, 0x02B5, 0x001F, 0x02D4, 
	0x0001, 0x02F3, 0x0001, 0x02F4, 0x001F, 0x02F5, 0x001F, 0x0314, 0x001E, 
	0x0333, 0x001F, 0x0351, 0x0001, 0x0370, 0x0001, 0x0371, 0x0001, 0x0372, 
	0x001F, 0x0373, 0x001F, 0x0392, 0x001F, 0x03B1, 0x0001, 0x03D0, 0x0019, 
	0x03D1, 0x001F, 0x03EA, 0x001F, 0x0409, 0x001F, 0x0428, 0x001F, 0x0447, 
	

});

smlua_anim_util_register_animation('donkey_idle_1',1, 0, 0, 0, 30, { 
	0x0000, 0x008B, 0x008B, 0x008B, 0x008B, 0x008A, 0x008A, 0x0089, 0x0088, 
	0x0087, 0x0086, 0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0085, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 
	0x008A, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0x0000, 0x039F, 0x03A3, 0x03AD, 0x03BF, 0x03D8, 0x03F9, 0x0420, 
	0x044F, 0x0483, 0x04B1, 0x04D9, 0x04F9, 0x0512, 0x0524, 0x052F, 0x0532, 
	0x052F, 0x0524, 0x0512, 0x04F9, 0x04D9, 0x04B1, 0x0483, 0x044F, 0x0420, 
	0x03F9, 0x03D8, 0x03BF, 0x03AD, 0x03A3, 0x039F, 0x0000, 0x0012, 0x0049, 
	0x00A4, 0x0124, 0x01C9, 0x0292, 0x037F, 0x0491, 0x05C8, 0x0723, 0x08A2, 
	0x0A46, 0x0C0F, 0x0DFC, 0x100E, 0x1220, 0x140D, 0x15D6, 0x177A, 0x18F9, 
	0x1A54, 0x1B8B, 0x1C9D, 0x1D8A, 0x1E53, 0x1EF8, 0x1F78, 0x1FD3, 0x200A, 
	0x201C, 0x0000, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFB, 0xFFF9, 0xFFF7, 0xFFF4, 
	0xFFF1, 0xFFED, 0xFFE9, 0xFFE4, 0xFFDF, 0xFFDA, 0xFFD4, 0xFFCD, 0xFFC7, 
	0xFFC1, 0xFFBC, 0xFFB7, 0xFFB2, 0xFFAE, 0xFFAA, 0xFFA7, 0xFFA4, 0xFFA1, 
	0xFF9F, 0xFF9E, 0xFF9D, 0xFF9C, 0xEE2F, 0xEE2E, 0xEE29, 0xEE23, 0xEE19, 
	0xEE0D, 0xEDFE, 0xEDEC, 0xEDD7, 0xEDC0, 0xEDA6, 0xED89, 0xED6A, 0xED48, 
	0xED23, 0xECFB, 0xECD3, 0xECAE, 0xEC8C, 0xEC6D, 0xEC50, 0xEC36, 0xEC1F, 
	0xEC0A, 0xEBF8, 0xEBE9, 0xEBDD, 0xEBD3, 0xEBCD, 0xEBC8, 0xEBC7, 0xFFFE, 
	0x0001, 0xC170, 0x1DCC, 0x1DC2, 0x1DA5, 0x1D73, 0x1D2E, 0x1CD5, 0x1C69, 
	0x1BE9, 0x1B59, 0x1AD9, 0x1A6D, 0x1A14, 0x19CF, 0x199D, 0x1980, 0x1976, 
	0x1980, 0x199D, 0x19CF, 0x1A14, 0x1A6D, 0x1AD9, 0x1B59, 0x1BE9, 0x1C69, 
	0x1CD5, 0x1D2E, 0x1D73, 0x1DA5, 0x1DC2, 0x1DCC, 0xD901, 0xD8F8, 0xD8DC, 
	0xD8AE, 0xD86E, 0xD81B, 0xD7B6, 0xD73E, 0xD6B8, 0xD641, 0xD5DB, 0xD589, 
	0xD548, 0xD51A, 0xD4FE, 0xD4F5, 0xD4FE, 0xD51A, 0xD548, 0xD589, 0xD5DB, 
	0xD641, 0xD6B8, 0xD73E, 0xD7B6, 0xD81B, 0xD86E, 0xD8AE, 0xD8DC, 0xD8F8, 
	0xD901, 0xB867, 0xB874, 0xB89D, 0xB8E0, 0xB93E, 0xB9B7, 0xBA4B, 0xBAFA, 
	0xBBBD, 0xBC6C, 0xBD00, 0xBD79, 0xBDD8, 0xBE1B, 0xBE43, 0xBE51, 0xBE43, 
	0xBE1B, 0xBDD8, 0xBD79, 0xBD00, 0xBC6C, 0xBBBD, 0xBAFA, 0xBA4B, 0xB9B7, 
	0xB93E, 0xB8E0, 0xB89D, 0xB874, 0xB867, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xC9F4, 0xC9E4, 0xC9B3, 0xC962, 0xC8F1, 0xC85F, 0xC7AD, 0xC6DB, 
	0xC5F0, 0xC51E, 0xC46C, 0xC3DA, 0xC369, 0xC318, 0xC2E8, 0xC2D7, 0xC2E8, 
	0xC318, 0xC369, 0xC3DA, 0xC46C, 0xC51E, 0xC5F0, 0xC6DB, 0xC7AD, 0xC85F, 
	0xC8F1, 0xC962, 0xC9B3, 0xC9E4, 0xC9F4, 0x071C, 0x071D, 0x071F, 0x0724, 
	0x072A, 0x0733, 0x073D, 0x0748, 0x0756, 0x0762, 0x076C, 0x0774, 0x077A, 
	0x077F, 0x0782, 0x0783, 0x0782, 0x077F, 0x077A, 0x0774, 0x076C, 0x0762, 
	0x0756, 0x0748, 0x073D, 0x0733, 0x072A, 0x0724, 0x071F, 0x071D, 0x071C, 
	0x0306, 0x0301, 0x02F2, 0x02D9, 0x02B5, 0x0288, 0x0251, 0x0210, 0x01C8, 
	0x0187, 0x0150, 0x0122, 0x00FF, 0x00E6, 0x00D7, 0x00D2, 0x00D7, 0x00E6, 
	0x00FF, 0x0122, 0x0150, 0x0187, 0x01C8, 0x0210, 0x0251, 0x0288, 0x02B5, 
	0x02D9, 0x02F2, 0x0301, 0x0306, 0x0A90, 0x0A91, 0x0A96, 0x0A9E, 0x0AAA, 
	0x0AB9, 0x0ACB, 0x0AE1, 0x0AF9, 0x0B0E, 0x0B20, 0x0B2F, 0x0B3B, 0x0B43, 
	0x0B48, 0x0B4A, 0x0B48, 0x0B43, 0x0B3B, 0x0B2F, 0x0B20, 0x0B0E, 0x0AF9, 
	0x0AE1, 0x0ACB, 0x0AB9, 0x0AAA, 0x0A9E, 0x0A96, 0x0A91, 0x0A90, 0xFFFE, 
	0x0001, 0xC170, 0x36DA, 0x36CF, 0x36AE, 0x3677, 0x362A, 0x35C7, 0x354F, 
	0x34C0, 0x3420, 0x3391, 0x3318, 0x32B5, 0x3269, 0x3232, 0x3211, 0x3206, 
	0x3211, 0x3232, 0x3269, 0x32B5, 0x3318, 0x3391, 0x3420, 0x34C0, 0x354F, 
	0x35C7, 0x362A, 0x3677, 0x36AE, 0x36CF, 0x36DA, 0x54F5, 0x54E9, 0x54C4, 
	0x5487, 0x5431, 0x53C3, 0x533C, 0x529D, 0x51EB, 0x514B, 0x50C4, 0x5056, 
	0x5000, 0x4FC3, 0x4F9E, 0x4F92, 0x4F9E, 0x4FC3, 0x5000, 0x5056, 0x50C4, 
	0x514B, 0x51EB, 0x529D, 0x533C, 0x53C3, 0x5431, 0x5487, 0x54C4, 0x54E9, 
	0x54F5, 0x175C, 0x174F, 0x1726, 0x16E2, 0x1683, 0x1609, 0x1574, 0x14C4, 
	0x13FF, 0x134F, 0x12BA, 0x1240, 0x11E1, 0x119D, 0x1175, 0x1167, 0x1175, 
	0x119D, 0x11E1, 0x1240, 0x12BA, 0x134F, 0x13FF, 0x14C4, 0x1574, 0x1609, 
	0x1683, 0x16E2, 0x1726, 0x174F, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCB4E, 0xCB19, 
	0xCAC0, 0xCA43, 0xC9A3, 0xC8DF, 0xC7F8, 0xC6F6, 0xC60E, 0xC54A, 0xC4AA, 
	0xC42E, 0xC3D5, 0xC39F, 0xC38D, 0xC39F, 0xC3D5, 0xC42E, 0xC4AA, 0xC54A, 
	0xC60E, 0xC6F6, 0xC7F8, 0xC8DF, 0xC9A3, 0xCA43, 0xCAC0, 0xCB19, 0xCB4E, 
	0xCB60, 0xFA42, 0xFA41, 0xFA41, 0xFA41, 0xFA40, 0xFA3F, 0xFA3D, 0xFA3C, 
	0xFA3A, 0xFA39, 0xFA38, 0xFA36, 0xFA36, 0xFA35, 0xFA35, 0xFA35, 0xFA35, 
	0xFA35, 0xFA36, 0xFA36, 0xFA38, 0xFA39, 0xFA3A, 0xFA3C, 0xFA3D, 0xFA3F, 
	0xFA40, 0xFA41, 0xFA41, 0xFA41, 0xFA42, 0x0197, 0x0198, 0x019C, 0x01A2, 
	0x01AA, 0x01B4, 0x01C1, 0x01D1, 0x01E2, 0x01F1, 0x01FE, 0x0208, 0x0210, 
	0x0216, 0x021A, 0x021B, 0x021A, 0x0216, 0x0210, 0x0208, 0x01FE, 0x01F1, 
	0x01E2, 0x01D1, 0x01C1, 0x01B4, 0x01AA, 0x01A2, 0x019C, 0x0198, 0x0197, 
	0x0624, 0x0628, 0x0632, 0x0644, 0x065D, 0x067C, 0x06A3, 0x06D1, 0x0704, 
	0x0732, 0x0759, 0x0779, 0x0791, 0x07A3, 0x07AE, 0x07B1, 0x07AE, 0x07A3, 
	0x0791, 0x0779, 0x0759, 0x0732, 0x0704, 0x06D1, 0x06A3, 0x067C, 0x065D, 
	0x0644, 0x0632, 0x0628, 0x0624, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFEA3, 
	0xFEBC, 0xFEE4, 0xFF1D, 0xFF66, 0xFFBF, 0x002A, 0x009F, 0x0109, 0x0162, 
	0x01AB, 0x01E4, 0x020C, 0x0225, 0x022D, 0x0225, 0x020C, 0x01E4, 0x01AB, 
	0x0162, 0x0109, 0x009F, 0x002A, 0xFFBF, 0xFF66, 0xFF1D, 0xFEE4, 0xFEBC, 
	0xFEA3, 0xFE9B, 0xEFF9, 0xEFF8, 0xEFF3, 0xEFEC, 0xEFE1, 0xEFD4, 0xEFC4, 
	0xEFB1, 0xEF9B, 0xEF88, 0xEF78, 0xEF6B, 0xEF60, 0xEF59, 0xEF54, 0xEF53, 
	0xEF54, 0xEF59, 0xEF60, 0xEF6B, 0xEF78, 0xEF88, 0xEF9B, 0xEFB1, 0xEFC4, 
	0xEFD4, 0xEFE1, 0xEFEC, 0xEFF3, 0xEFF8, 0xEFF9, 0x839E, 0x8390, 0x8364, 
	0x831B, 0x82B5, 0x8232, 0x8192, 0x80D4, 0x8001, 0x7F44, 0x7EA4, 0x7E20, 
	0x7DBA, 0x7D72, 0x7D46, 0x7D37, 0x7D46, 0x7D72, 0x7DBA, 0x7E20, 0x7EA4, 
	0x7F44, 0x8001, 0x80D4, 0x8192, 0x8232, 0x82B5, 0x831B, 0x8364, 0x8390, 
	0x839E, 0x0000, 0xFFFF, 0x49EE, 0x4A01, 0x4A3A, 0x4A98, 0x4B1D, 0x4BC8, 
	0x4C98, 0x4D8F, 0x4EA1, 0x4F98, 0x5068, 0x5113, 0x5198, 0x51F6, 0x522F, 
	0x5242, 0x522F, 0x51F6, 0x5198, 0x5113, 0x5068, 0x4F98, 0x4EA1, 0x4D8F, 
	0x4C98, 0x4BC8, 0x4B1D, 0x4A98, 0x4A3A, 0x4A01, 0x49EE, 0xF7AE, 0xF7AB, 
	0xF7A3, 0xF797, 0xF785, 0xF76E, 0xF752, 0xF731, 0xF70C, 0xF6EB, 0xF6D0, 
	0xF6B9, 0xF6A7, 0xF69A, 0xF693, 0xF690, 0xF693, 0xF69A, 0xF6A7, 0xF6B9, 
	0xF6D0, 0xF6EB, 0xF70C, 0xF731, 0xF752, 0xF76E, 0xF785, 0xF797, 0xF7A3, 
	0xF7AB, 0xF7AE, 0x03C6, 0x03C6, 0x03C5, 0x03C4, 0x03C3, 0x03C1, 0x03BF, 
	0x03BD, 0x03BB, 0x03B8, 0x03B6, 0x03B5, 0x03B4, 0x03B3, 0x03B2, 0x03B2, 
	0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B8, 0x03BB, 0x03BD, 0x03BF, 
	0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0xAB92, 0xAB8D, 0xAB7D, 0xAB63, 
	0xAB3E, 0xAB0F, 0xAAD5, 0xAA91, 0xAA45, 0xAA01, 0xA9C7, 0xA998, 0xA973, 
	0xA959, 0xA949, 0xA944, 0xA949, 0xA959, 0xA973, 0xA998, 0xA9C7, 0xAA01, 
	0xAA45, 0xAA91, 0xAAD5, 0xAB0F, 0xAB3E, 0xAB63, 0xAB7D, 0xAB8D, 0xAB92, 
	0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x01B7, 0x019D, 0x0171, 0x0134, 0x00E5, 
	0x0085, 0x0013, 0xFF93, 0xFF21, 0xFEC1, 0xFE72, 0xFE35, 0xFE09, 0xFDEF, 
	0xFDE6, 0xFDEF, 0xFE09, 0xFE35, 0xFE72, 0xFEC1, 0xFF21, 0xFF93, 0x0013, 
	0x0085, 0x00E5, 0x0134, 0x0171, 0x019D, 0x01B7, 0x01C0, 0x1192, 0x1194, 
	0x1198, 0x11A0, 0x11AB, 0x11B9, 0x11CA, 0x11DE, 0x11F4, 0x1208, 0x1219, 
	0x1227, 0x1232, 0x1239, 0x123E, 0x123F, 0x123E, 0x1239, 0x1232, 0x1227, 
	0x1219, 0x1208, 0x11F4, 0x11DE, 0x11CA, 0x11B9, 0x11AB, 0x11A0, 0x1198, 
	0x1194, 0x1192, 0x842B, 0x841C, 0x83EF, 0x83A3, 0x833A, 0x82B1, 0x820B, 
	0x8147, 0x806C, 0x7FA7, 0x7F01, 0x7E79, 0x7E0F, 0x7DC4, 0x7D96, 0x7D87, 
	0x7D96, 0x7DC4, 0x7E0F, 0x7E79, 0x7F01, 0x7FA7, 0x806C, 0x8147, 0x820B, 
	0x82B1, 0x833A, 0x83A3, 0x83EF, 0x841C, 0x842B, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x4A21, 0x4A34, 0x4A6C, 0x4ACA, 
	0x4B4E, 0x4BF7, 0x4CC6, 0x4DBA, 0x4ECA, 0x4FBF, 0x508E, 0x5137, 0x51BA, 
	0x5218, 0x5251, 0x5264, 0x5251, 0x5218, 0x51BA, 0x5137, 0x508E, 0x4FBF, 
	0x4ECA, 0x4DBA, 0x4CC6, 0x4BF7, 0x4B4E, 0x4ACA, 0x4A6C, 0x4A34, 0x4A21, 
	0x09D3, 0x09D6, 0x09DF, 0x09EF, 0x0A06, 0x0A22, 0x0A45, 0x0A6F, 0x0A9D, 
	0x0AC6, 0x0AE9, 0x0B06, 0x0B1C, 0x0B2C, 0x0B36, 0x0B39, 0x0B36, 0x0B2C, 
	0x0B1C, 0x0B06, 0x0AE9, 0x0AC6, 0x0A9D, 0x0A6F, 0x0A45, 0x0A22, 0x0A06, 
	0x09EF, 0x09DF, 0x09D6, 0x09D3, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 0xFE38, 
	0xFE3A, 0xFE3E, 0xFE42, 0xFE47, 0xFE4B, 0xFE4F, 0xFE52, 0xFE54, 0xFE56, 
	0xFE57, 0xFE57, 0xFE57, 0xFE56, 0xFE54, 0xFE52, 0xFE4F, 0xFE4B, 0xFE47, 
	0xFE42, 0xFE3E, 0xFE3A, 0xFE38, 0xFE35, 0xFE34, 0xFE33, 0xFE32, 0xABC3, 
	0xABBD, 0xABAD, 0xAB92, 0xAB6C, 0xAB3B, 0xAAFF, 0xAAB8, 0xAA69, 0xAA22, 
	0xA9E7, 0xA9B6, 0xA990, 0xA974, 0xA964, 0xA95F, 0xA964, 0xA974, 0xA990, 
	0xA9B6, 0xA9E7, 0xAA22, 0xAA69, 0xAAB8, 0xAAFF, 0xAB3B, 0xAB6C, 0xAB92, 
	0xABAD, 0xABBD, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001C, 0x0001, 0x0001, 0x001D, 0x0001, 0x001E, 0x0001, 
	0x001F, 0x0001, 0x0020, 0x0001, 0x0021, 0x0001, 0x0022, 0x0001, 0x0023, 
	0x0001, 0x0024, 0x0001, 0x0025, 0x001F, 0x0026, 0x001F, 0x0045, 0x001E, 
	0x0064, 0x001F, 0x0082, 0x0001, 0x00A1, 0x0001, 0x00A2, 0x0001, 0x00A3, 
	0x001F, 0x00A4, 0x001F, 0x00C3, 0x001F, 0x00E2, 0x001F, 0x0101, 0x001C, 
	0x0120, 0x001F, 0x013C, 0x001F, 0x015B, 0x001F, 0x017A, 0x001F, 0x0199, 
	0x0001, 0x01B8, 0x0001, 0x01B9, 0x0001, 0x01BA, 0x001F, 0x01BB, 0x001F, 
	0x01DA, 0x001F, 0x01F9, 0x0001, 0x0218, 0x001B, 0x0219, 0x001F, 0x0234, 
	0x001F, 0x0253, 0x001F, 0x0272, 0x001F, 0x0291, 0x0001, 0x02B0, 0x0001, 
	0x02B1, 0x0001, 0x02B2, 0x001F, 0x02B3, 0x001F, 0x02D2, 0x001F, 0x02F1, 
	0x0001, 0x0310, 0x0001, 0x0311, 0x001F, 0x0312, 0x001F, 0x0331, 0x001E, 
	0x0350, 0x001F, 0x036E, 0x0001, 0x038D, 0x0001, 0x038E, 0x0001, 0x038F, 
	0x001F, 0x0390, 0x001F, 0x03AF, 0x001F, 0x03CE, 0x0001, 0x03ED, 0x0019, 
	0x03EE, 0x001F, 0x0407, 0x001F, 0x0426, 0x001F, 0x0445, 0x001F, 0x0464, 
	

});

smlua_anim_util_register_animation('donkey_idle_2',1, 0, 0, 0, 30, { 
	0x0000, 0x008B, 0x008B, 0x008B, 0x008B, 0x008A, 0x008A, 0x0089, 0x0088, 
	0x0087, 0x0086, 0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0085, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 
	0x008A, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0x0000, 0x039F, 0x03A3, 0x03AD, 0x03BF, 0x03D8, 0x03F9, 0x0420, 
	0x044F, 0x0483, 0x04B1, 0x04D9, 0x04F9, 0x0512, 0x0524, 0x052F, 0x0532, 
	0x052F, 0x0524, 0x0512, 0x04F9, 0x04D9, 0x04B1, 0x0483, 0x044F, 0x0420, 
	0x03F9, 0x03D8, 0x03BF, 0x03AD, 0x03A3, 0x039F, 0x201C, 0x1FF8, 0x1F8B, 
	0x1ED6, 0x1DD8, 0x1C91, 0x1B02, 0x192B, 0x170B, 0x14A2, 0x11F1, 0x0EF8, 
	0x0BB6, 0x082B, 0x0458, 0x003C, 0xFC1F, 0xF84C, 0xF4C1, 0xF17F, 0xEE86, 
	0xEBD5, 0xE96C, 0xE74C, 0xE575, 0xE3E6, 0xE29F, 0xE1A1, 0xE0EC, 0xE07F, 
	0xE05B, 0xFF9C, 0xFF9B, 0xFF9A, 0xFF97, 0xFF93, 0xFF8F, 0xFF89, 0xFF82, 
	0xFF7A, 0xFF70, 0xFF66, 0xFF5B, 0xFF4F, 0xFF41, 0xFF33, 0xFF23, 0xFF14, 
	0xFF05, 0xFEF8, 0xFEEB, 0xFEE0, 0xFED6, 0xFECD, 0xFEC5, 0xFEBE, 0xFEB8, 
	0xFEB3, 0xFEAF, 0xFEAD, 0xFEAB, 0xFEAA, 0xEBC7, 0xEBC5, 0xEBBE, 0xEBB2, 
	0xEBA1, 0xEB8C, 0xEB72, 0xEB54, 0xEB30, 0xEB08, 0xEADB, 0xEAAA, 0xEA73, 
	0xEA39, 0xE9F9, 0xE9B4, 0xE970, 0xE930, 0xE8F5, 0xE8BF, 0xE88E, 0xE861, 
	0xE839, 0xE815, 0xE7F7, 0xE7DD, 0xE7C8, 0xE7B7, 0xE7AB, 0xE7A4, 0xE7A2, 
	0xFFFE, 0x0001, 0xC170, 0x1DCC, 0x1DC2, 0x1DA5, 0x1D73, 0x1D2E, 0x1CD5, 
	0x1C69, 0x1BE9, 0x1B59, 0x1AD9, 0x1A6D, 0x1A14, 0x19CF, 0x199D, 0x1980, 
	0x1976, 0x1980, 0x199D, 0x19CF, 0x1A14, 0x1A6D, 0x1AD9, 0x1B59, 0x1BE9, 
	0x1C69, 0x1CD5, 0x1D2E, 0x1D73, 0x1DA5, 0x1DC2, 0x1DCC, 0xD901, 0xD8F8, 
	0xD8DC, 0xD8AE, 0xD86E, 0xD81B, 0xD7B6, 0xD73E, 0xD6B8, 0xD641, 0xD5DB, 
	0xD589, 0xD548, 0xD51A, 0xD4FE, 0xD4F5, 0xD4FE, 0xD51A, 0xD548, 0xD589, 
	0xD5DB, 0xD641, 0xD6B8, 0xD73E, 0xD7B6, 0xD81B, 0xD86E, 0xD8AE, 0xD8DC, 
	0xD8F8, 0xD901, 0xB867, 0xB874, 0xB89D, 0xB8E0, 0xB93E, 0xB9B7, 0xBA4B, 
	0xBAFA, 0xBBBD, 0xBC6C, 0xBD00, 0xBD79, 0xBDD8, 0xBE1B, 0xBE43, 0xBE51, 
	0xBE43, 0xBE1B, 0xBDD8, 0xBD79, 0xBD00, 0xBC6C, 0xBBBD, 0xBAFA, 0xBA4B, 
	0xB9B7, 0xB93E, 0xB8E0, 0xB89D, 0xB874, 0xB867, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xC9F4, 0xC9E4, 0xC9B3, 0xC962, 0xC8F1, 0xC85F, 0xC7AD, 
	0xC6DB, 0xC5F0, 0xC51E, 0xC46C, 0xC3DA, 0xC369, 0xC318, 0xC2E8, 0xC2D7, 
	0xC2E8, 0xC318, 0xC369, 0xC3DA, 0xC46C, 0xC51E, 0xC5F0, 0xC6DB, 0xC7AD, 
	0xC85F, 0xC8F1, 0xC962, 0xC9B3, 0xC9E4, 0xC9F4, 0x071C, 0x071D, 0x071F, 
	0x0724, 0x072A, 0x0733, 0x073D, 0x0748, 0x0756, 0x0762, 0x076C, 0x0774, 
	0x077A, 0x077F, 0x0782, 0x0783, 0x0782, 0x077F, 0x077A, 0x0774, 0x076C, 
	0x0762, 0x0756, 0x0748, 0x073D, 0x0733, 0x072A, 0x0724, 0x071F, 0x071D, 
	0x071C, 0x0306, 0x0301, 0x02F2, 0x02D9, 0x02B5, 0x0288, 0x0251, 0x0210, 
	0x01C8, 0x0187, 0x0150, 0x0122, 0x00FF, 0x00E6, 0x00D7, 0x00D2, 0x00D7, 
	0x00E6, 0x00FF, 0x0122, 0x0150, 0x0187, 0x01C8, 0x0210, 0x0251, 0x0288, 
	0x02B5, 0x02D9, 0x02F2, 0x0301, 0x0306, 0x0A90, 0x0A91, 0x0A96, 0x0A9E, 
	0x0AAA, 0x0AB9, 0x0ACB, 0x0AE1, 0x0AF9, 0x0B0E, 0x0B20, 0x0B2F, 0x0B3B, 
	0x0B43, 0x0B48, 0x0B4A, 0x0B48, 0x0B43, 0x0B3B, 0x0B2F, 0x0B20, 0x0B0E, 
	0x0AF9, 0x0AE1, 0x0ACB, 0x0AB9, 0x0AAA, 0x0A9E, 0x0A96, 0x0A91, 0x0A90, 
	0xFFFE, 0x0001, 0xC170, 0x36DA, 0x36CF, 0x36AE, 0x3677, 0x362A, 0x35C7, 
	0x354F, 0x34C0, 0x3420, 0x3391, 0x3318, 0x32B5, 0x3269, 0x3232, 0x3211, 
	0x3206, 0x3211, 0x3232, 0x3269, 0x32B5, 0x3318, 0x3391, 0x3420, 0x34C0, 
	0x354F, 0x35C7, 0x362A, 0x3677, 0x36AE, 0x36CF, 0x36DA, 0x54F5, 0x54E9, 
	0x54C4, 0x5487, 0x5431, 0x53C3, 0x533C, 0x529D, 0x51EB, 0x514B, 0x50C4, 
	0x5056, 0x5000, 0x4FC3, 0x4F9E, 0x4F92, 0x4F9E, 0x4FC3, 0x5000, 0x5056, 
	0x50C4, 0x514B, 0x51EB, 0x529D, 0x533C, 0x53C3, 0x5431, 0x5487, 0x54C4, 
	0x54E9, 0x54F5, 0x175C, 0x174F, 0x1726, 0x16E2, 0x1683, 0x1609, 0x1574, 
	0x14C4, 0x13FF, 0x134F, 0x12BA, 0x1240, 0x11E1, 0x119D, 0x1175, 0x1167, 
	0x1175, 0x119D, 0x11E1, 0x1240, 0x12BA, 0x134F, 0x13FF, 0x14C4, 0x1574, 
	0x1609, 0x1683, 0x16E2, 0x1726, 0x174F, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCB4E, 
	0xCB19, 0xCAC0, 0xCA43, 0xC9A3, 0xC8DF, 0xC7F8, 0xC6F6, 0xC60E, 0xC54A, 
	0xC4AA, 0xC42E, 0xC3D5, 0xC39F, 0xC38D, 0xC39F, 0xC3D5, 0xC42E, 0xC4AA, 
	0xC54A, 0xC60E, 0xC6F6, 0xC7F8, 0xC8DF, 0xC9A3, 0xCA43, 0xCAC0, 0xCB19, 
	0xCB4E, 0xCB60, 0xFA42, 0xFA41, 0xFA41, 0xFA41, 0xFA40, 0xFA3F, 0xFA3D, 
	0xFA3C, 0xFA3A, 0xFA39, 0xFA38, 0xFA36, 0xFA36, 0xFA35, 0xFA35, 0xFA35, 
	0xFA35, 0xFA35, 0xFA36, 0xFA36, 0xFA38, 0xFA39, 0xFA3A, 0xFA3C, 0xFA3D, 
	0xFA3F, 0xFA40, 0xFA41, 0xFA41, 0xFA41, 0xFA42, 0x0197, 0x0198, 0x019C, 
	0x01A2, 0x01AA, 0x01B4, 0x01C1, 0x01D1, 0x01E2, 0x01F1, 0x01FE, 0x0208, 
	0x0210, 0x0216, 0x021A, 0x021B, 0x021A, 0x0216, 0x0210, 0x0208, 0x01FE, 
	0x01F1, 0x01E2, 0x01D1, 0x01C1, 0x01B4, 0x01AA, 0x01A2, 0x019C, 0x0198, 
	0x0197, 0x0624, 0x0628, 0x0632, 0x0644, 0x065D, 0x067C, 0x06A3, 0x06D1, 
	0x0704, 0x0732, 0x0759, 0x0779, 0x0791, 0x07A3, 0x07AE, 0x07B1, 0x07AE, 
	0x07A3, 0x0791, 0x0779, 0x0759, 0x0732, 0x0704, 0x06D1, 0x06A3, 0x067C, 
	0x065D, 0x0644, 0x0632, 0x0628, 0x0624, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 
	0xFEA3, 0xFEBC, 0xFEE4, 0xFF1D, 0xFF66, 0xFFBF, 0x002A, 0x009F, 0x0109, 
	0x0162, 0x01AB, 0x01E4, 0x020C, 0x0225, 0x022D, 0x0225, 0x020C, 0x01E4, 
	0x01AB, 0x0162, 0x0109, 0x009F, 0x002A, 0xFFBF, 0xFF66, 0xFF1D, 0xFEE4, 
	0xFEBC, 0xFEA3, 0xFE9B, 0xEFF9, 0xEFF8, 0xEFF3, 0xEFEC, 0xEFE1, 0xEFD4, 
	0xEFC4, 0xEFB1, 0xEF9B, 0xEF88, 0xEF78, 0xEF6B, 0xEF60, 0xEF59, 0xEF54, 
	0xEF53, 0xEF54, 0xEF59, 0xEF60, 0xEF6B, 0xEF78, 0xEF88, 0xEF9B, 0xEFB1, 
	0xEFC4, 0xEFD4, 0xEFE1, 0xEFEC, 0xEFF3, 0xEFF8, 0xEFF9, 0x839E, 0x8390, 
	0x8364, 0x831B, 0x82B5, 0x8232, 0x8192, 0x80D4, 0x8001, 0x7F44, 0x7EA4, 
	0x7E20, 0x7DBA, 0x7D72, 0x7D46, 0x7D37, 0x7D46, 0x7D72, 0x7DBA, 0x7E20, 
	0x7EA4, 0x7F44, 0x8001, 0x80D4, 0x8192, 0x8232, 0x82B5, 0x831B, 0x8364, 
	0x8390, 0x839E, 0x0000, 0xFFFF, 0x49EE, 0x4A01, 0x4A3A, 0x4A98, 0x4B1D, 
	0x4BC8, 0x4C98, 0x4D8F, 0x4EA1, 0x4F98, 0x5068, 0x5113, 0x5198, 0x51F6, 
	0x522F, 0x5242, 0x522F, 0x51F6, 0x5198, 0x5113, 0x5068, 0x4F98, 0x4EA1, 
	0x4D8F, 0x4C98, 0x4BC8, 0x4B1D, 0x4A98, 0x4A3A, 0x4A01, 0x49EE, 0xF7AE, 
	0xF7AB, 0xF7A3, 0xF797, 0xF785, 0xF76E, 0xF752, 0xF731, 0xF70C, 0xF6EB, 
	0xF6D0, 0xF6B9, 0xF6A7, 0xF69A, 0xF693, 0xF690, 0xF693, 0xF69A, 0xF6A7, 
	0xF6B9, 0xF6D0, 0xF6EB, 0xF70C, 0xF731, 0xF752, 0xF76E, 0xF785, 0xF797, 
	0xF7A3, 0xF7AB, 0xF7AE, 0x03C6, 0x03C6, 0x03C5, 0x03C4, 0x03C3, 0x03C1, 
	0x03BF, 0x03BD, 0x03BB, 0x03B8, 0x03B6, 0x03B5, 0x03B4, 0x03B3, 0x03B2, 
	0x03B2, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B8, 0x03BB, 0x03BD, 
	0x03BF, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0xAB92, 0xAB8D, 0xAB7D, 
	0xAB63, 0xAB3E, 0xAB0F, 0xAAD5, 0xAA91, 0xAA45, 0xAA01, 0xA9C7, 0xA998, 
	0xA973, 0xA959, 0xA949, 0xA944, 0xA949, 0xA959, 0xA973, 0xA998, 0xA9C7, 
	0xAA01, 0xAA45, 0xAA91, 0xAAD5, 0xAB0F, 0xAB3E, 0xAB63, 0xAB7D, 0xAB8D, 
	0xAB92, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x01B7, 0x019D, 0x0171, 0x0134, 
	0x00E5, 0x0085, 0x0013, 0xFF93, 0xFF21, 0xFEC1, 0xFE72, 0xFE35, 0xFE09, 
	0xFDEF, 0xFDE6, 0xFDEF, 0xFE09, 0xFE35, 0xFE72, 0xFEC1, 0xFF21, 0xFF93, 
	0x0013, 0x0085, 0x00E5, 0x0134, 0x0171, 0x019D, 0x01B7, 0x01C0, 0x1192, 
	0x1194, 0x1198, 0x11A0, 0x11AB, 0x11B9, 0x11CA, 0x11DE, 0x11F4, 0x1208, 
	0x1219, 0x1227, 0x1232, 0x1239, 0x123E, 0x123F, 0x123E, 0x1239, 0x1232, 
	0x1227, 0x1219, 0x1208, 0x11F4, 0x11DE, 0x11CA, 0x11B9, 0x11AB, 0x11A0, 
	0x1198, 0x1194, 0x1192, 0x842B, 0x841C, 0x83EF, 0x83A3, 0x833A, 0x82B1, 
	0x820B, 0x8147, 0x806C, 0x7FA7, 0x7F01, 0x7E79, 0x7E0F, 0x7DC4, 0x7D96, 
	0x7D87, 0x7D96, 0x7DC4, 0x7E0F, 0x7E79, 0x7F01, 0x7FA7, 0x806C, 0x8147, 
	0x820B, 0x82B1, 0x833A, 0x83A3, 0x83EF, 0x841C, 0x842B, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x4A21, 0x4A34, 0x4A6C, 
	0x4ACA, 0x4B4E, 0x4BF7, 0x4CC6, 0x4DBA, 0x4ECA, 0x4FBF, 0x508E, 0x5137, 
	0x51BA, 0x5218, 0x5251, 0x5264, 0x5251, 0x5218, 0x51BA, 0x5137, 0x508E, 
	0x4FBF, 0x4ECA, 0x4DBA, 0x4CC6, 0x4BF7, 0x4B4E, 0x4ACA, 0x4A6C, 0x4A34, 
	0x4A21, 0x09D3, 0x09D6, 0x09DF, 0x09EF, 0x0A06, 0x0A22, 0x0A45, 0x0A6F, 
	0x0A9D, 0x0AC6, 0x0AE9, 0x0B06, 0x0B1C, 0x0B2C, 0x0B36, 0x0B39, 0x0B36, 
	0x0B2C, 0x0B1C, 0x0B06, 0x0AE9, 0x0AC6, 0x0A9D, 0x0A6F, 0x0A45, 0x0A22, 
	0x0A06, 0x09EF, 0x09DF, 0x09D6, 0x09D3, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 
	0xFE38, 0xFE3A, 0xFE3E, 0xFE42, 0xFE47, 0xFE4B, 0xFE4F, 0xFE52, 0xFE54, 
	0xFE56, 0xFE57, 0xFE57, 0xFE57, 0xFE56, 0xFE54, 0xFE52, 0xFE4F, 0xFE4B, 
	0xFE47, 0xFE42, 0xFE3E, 0xFE3A, 0xFE38, 0xFE35, 0xFE34, 0xFE33, 0xFE32, 
	0xABC3, 0xABBD, 0xABAD, 0xAB92, 0xAB6C, 0xAB3B, 0xAAFF, 0xAAB8, 0xAA69, 
	0xAA22, 0xA9E7, 0xA9B6, 0xA990, 0xA974, 0xA964, 0xA95F, 0xA964, 0xA974, 
	0xA990, 0xA9B6, 0xA9E7, 0xAA22, 0xAA69, 0xAAB8, 0xAAFF, 0xAB3B, 0xAB6C, 
	0xAB92, 0xABAD, 0xABBD, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001C, 0x0001, 0x0001, 0x001D, 0x0001, 0x001E, 0x0001, 
	0x001F, 0x0001, 0x0020, 0x0001, 0x0021, 0x0001, 0x0022, 0x0001, 0x0023, 
	0x0001, 0x0024, 0x0001, 0x0025, 0x001F, 0x0026, 0x001F, 0x0045, 0x001F, 
	0x0064, 0x001F, 0x0083, 0x0001, 0x00A2, 0x0001, 0x00A3, 0x0001, 0x00A4, 
	0x001F, 0x00A5, 0x001F, 0x00C4, 0x001F, 0x00E3, 0x001F, 0x0102, 0x001C, 
	0x0121, 0x001F, 0x013D, 0x001F, 0x015C, 0x001F, 0x017B, 0x001F, 0x019A, 
	0x0001, 0x01B9, 0x0001, 0x01BA, 0x0001, 0x01BB, 0x001F, 0x01BC, 0x001F, 
	0x01DB, 0x001F, 0x01FA, 0x0001, 0x0219, 0x001B, 0x021A, 0x001F, 0x0235, 
	0x001F, 0x0254, 0x001F, 0x0273, 0x001F, 0x0292, 0x0001, 0x02B1, 0x0001, 
	0x02B2, 0x0001, 0x02B3, 0x001F, 0x02B4, 0x001F, 0x02D3, 0x001F, 0x02F2, 
	0x0001, 0x0311, 0x0001, 0x0312, 0x001F, 0x0313, 0x001F, 0x0332, 0x001E, 
	0x0351, 0x001F, 0x036F, 0x0001, 0x038E, 0x0001, 0x038F, 0x0001, 0x0390, 
	0x001F, 0x0391, 0x001F, 0x03B0, 0x001F, 0x03CF, 0x0001, 0x03EE, 0x0019, 
	0x03EF, 0x001F, 0x0408, 0x001F, 0x0427, 0x001F, 0x0446, 0x001F, 0x0465, 
	

});

smlua_anim_util_register_animation('donkey_idle_3',1, 0, 0, 0, 30, { 
	0x0000, 0x008B, 0x008B, 0x008B, 0x008B, 0x008A, 0x008A, 0x0089, 0x0088, 
	0x0087, 0x0086, 0x0085, 0x0085, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 
	0x0084, 0x0084, 0x0085, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 
	0x008A, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0x0000, 0x039F, 0x03A3, 0x03AD, 0x03BF, 0x03D8, 0x03F9, 0x0420, 
	0x044F, 0x0483, 0x04B1, 0x04D9, 0x04F9, 0x0512, 0x0524, 0x052F, 0x0532, 
	0x052F, 0x0524, 0x0512, 0x04F9, 0x04D9, 0x04B1, 0x0483, 0x044F, 0x0420, 
	0x03F9, 0x03D8, 0x03BF, 0x03AD, 0x03A3, 0x039F, 0xE05B, 0xE06D, 0xE0A3, 
	0xE0FD, 0xE17B, 0xE21D, 0xE2E3, 0xE3CD, 0xE4DB, 0xE60D, 0xE763, 0xE8DD, 
	0xEA7B, 0xEC3D, 0xEE23, 0xF02D, 0xF237, 0xF41D, 0xF5DF, 0xF77D, 0xF8F7, 
	0xFA4D, 0xFB7F, 0xFC8D, 0xFD77, 0xFE3D, 0xFEDF, 0xFF5D, 0xFFB7, 0xFFED, 
	0x0000, 0xFEAA, 0xFEAB, 0xFEAE, 0xFEB1, 0xFEB7, 0xFEBD, 0xFEC6, 0xFED0, 
	0xFEDB, 0xFEE8, 0xFEF6, 0xFF06, 0xFF17, 0xFF2A, 0xFF3F, 0xFF55, 0xFF6B, 
	0xFF7F, 0xFF92, 0xFFA3, 0xFFB3, 0xFFC2, 0xFFCF, 0xFFDA, 0xFFE4, 0xFFEC, 
	0xFFF3, 0xFFF8, 0xFFFC, 0xFFFE, 0x0000, 0xE7A2, 0xE7A6, 0xE7B1, 0xE7C3, 
	0xE7DD, 0xE7FF, 0xE828, 0xE858, 0xE890, 0xE8D0, 0xE916, 0xE965, 0xE9BA, 
	0xEA18, 0xEA7C, 0xEAE8, 0xEB54, 0xEBB9, 0xEC16, 0xEC6C, 0xECBA, 0xED01, 
	0xED40, 0xED78, 0xEDA9, 0xEDD2, 0xEDF3, 0xEE0D, 0xEE20, 0xEE2B, 0xEE2F, 
	0xFFFE, 0x0001, 0xC170, 0x1DCC, 0x1DC2, 0x1DA5, 0x1D73, 0x1D2E, 0x1CD5, 
	0x1C69, 0x1BE9, 0x1B59, 0x1AD9, 0x1A6D, 0x1A14, 0x19CF, 0x199D, 0x1980, 
	0x1976, 0x1980, 0x199D, 0x19CF, 0x1A14, 0x1A6D, 0x1AD9, 0x1B59, 0x1BE9, 
	0x1C69, 0x1CD5, 0x1D2E, 0x1D73, 0x1DA5, 0x1DC2, 0x1DCC, 0xD901, 0xD8F8, 
	0xD8DC, 0xD8AE, 0xD86E, 0xD81B, 0xD7B6, 0xD73E, 0xD6B8, 0xD641, 0xD5DB, 
	0xD589, 0xD548, 0xD51A, 0xD4FE, 0xD4F5, 0xD4FE, 0xD51A, 0xD548, 0xD589, 
	0xD5DB, 0xD641, 0xD6B8, 0xD73E, 0xD7B6, 0xD81B, 0xD86E, 0xD8AE, 0xD8DC, 
	0xD8F8, 0xD901, 0xB867, 0xB874, 0xB89D, 0xB8E0, 0xB93E, 0xB9B7, 0xBA4B, 
	0xBAFA, 0xBBBD, 0xBC6C, 0xBD00, 0xBD79, 0xBDD8, 0xBE1B, 0xBE43, 0xBE51, 
	0xBE43, 0xBE1B, 0xBDD8, 0xBD79, 0xBD00, 0xBC6C, 0xBBBD, 0xBAFA, 0xBA4B, 
	0xB9B7, 0xB93E, 0xB8E0, 0xB89D, 0xB874, 0xB867, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xC9F4, 0xC9E4, 0xC9B3, 0xC962, 0xC8F1, 0xC85F, 0xC7AD, 
	0xC6DB, 0xC5F0, 0xC51E, 0xC46C, 0xC3DA, 0xC369, 0xC318, 0xC2E8, 0xC2D7, 
	0xC2E8, 0xC318, 0xC369, 0xC3DA, 0xC46C, 0xC51E, 0xC5F0, 0xC6DB, 0xC7AD, 
	0xC85F, 0xC8F1, 0xC962, 0xC9B3, 0xC9E4, 0xC9F4, 0x071C, 0x071D, 0x071F, 
	0x0724, 0x072A, 0x0733, 0x073D, 0x0748, 0x0756, 0x0762, 0x076C, 0x0774, 
	0x077A, 0x077F, 0x0782, 0x0783, 0x0782, 0x077F, 0x077A, 0x0774, 0x076C, 
	0x0762, 0x0756, 0x0748, 0x073D, 0x0733, 0x072A, 0x0724, 0x071F, 0x071D, 
	0x071C, 0x0306, 0x0301, 0x02F2, 0x02D9, 0x02B5, 0x0288, 0x0251, 0x0210, 
	0x01C8, 0x0187, 0x0150, 0x0122, 0x00FF, 0x00E6, 0x00D7, 0x00D2, 0x00D7, 
	0x00E6, 0x00FF, 0x0122, 0x0150, 0x0187, 0x01C8, 0x0210, 0x0251, 0x0288, 
	0x02B5, 0x02D9, 0x02F2, 0x0301, 0x0306, 0x0A90, 0x0A91, 0x0A96, 0x0A9E, 
	0x0AAA, 0x0AB9, 0x0ACB, 0x0AE1, 0x0AF9, 0x0B0E, 0x0B20, 0x0B2F, 0x0B3B, 
	0x0B43, 0x0B48, 0x0B4A, 0x0B48, 0x0B43, 0x0B3B, 0x0B2F, 0x0B20, 0x0B0E, 
	0x0AF9, 0x0AE1, 0x0ACB, 0x0AB9, 0x0AAA, 0x0A9E, 0x0A96, 0x0A91, 0x0A90, 
	0xFFFE, 0x0001, 0xC170, 0x36DA, 0x36CF, 0x36AE, 0x3677, 0x362A, 0x35C7, 
	0x354F, 0x34C0, 0x3420, 0x3391, 0x3318, 0x32B5, 0x3269, 0x3232, 0x3211, 
	0x3206, 0x3211, 0x3232, 0x3269, 0x32B5, 0x3318, 0x3391, 0x3420, 0x34C0, 
	0x354F, 0x35C7, 0x362A, 0x3677, 0x36AE, 0x36CF, 0x36DA, 0x54F5, 0x54E9, 
	0x54C4, 0x5487, 0x5431, 0x53C3, 0x533C, 0x529D, 0x51EB, 0x514B, 0x50C4, 
	0x5056, 0x5000, 0x4FC3, 0x4F9E, 0x4F92, 0x4F9E, 0x4FC3, 0x5000, 0x5056, 
	0x50C4, 0x514B, 0x51EB, 0x529D, 0x533C, 0x53C3, 0x5431, 0x5487, 0x54C4, 
	0x54E9, 0x54F5, 0x175C, 0x174F, 0x1726, 0x16E2, 0x1683, 0x1609, 0x1574, 
	0x14C4, 0x13FF, 0x134F, 0x12BA, 0x1240, 0x11E1, 0x119D, 0x1175, 0x1167, 
	0x1175, 0x119D, 0x11E1, 0x1240, 0x12BA, 0x134F, 0x13FF, 0x14C4, 0x1574, 
	0x1609, 0x1683, 0x16E2, 0x1726, 0x174F, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCB4E, 
	0xCB19, 0xCAC0, 0xCA43, 0xC9A3, 0xC8DF, 0xC7F8, 0xC6F6, 0xC60E, 0xC54A, 
	0xC4AA, 0xC42E, 0xC3D5, 0xC39F, 0xC38D, 0xC39F, 0xC3D5, 0xC42E, 0xC4AA, 
	0xC54A, 0xC60E, 0xC6F6, 0xC7F8, 0xC8DF, 0xC9A3, 0xCA43, 0xCAC0, 0xCB19, 
	0xCB4E, 0xCB60, 0xFA42, 0xFA41, 0xFA41, 0xFA41, 0xFA40, 0xFA3F, 0xFA3D, 
	0xFA3C, 0xFA3A, 0xFA39, 0xFA38, 0xFA36, 0xFA36, 0xFA35, 0xFA35, 0xFA35, 
	0xFA35, 0xFA35, 0xFA36, 0xFA36, 0xFA38, 0xFA39, 0xFA3A, 0xFA3C, 0xFA3D, 
	0xFA3F, 0xFA40, 0xFA41, 0xFA41, 0xFA41, 0xFA42, 0x0197, 0x0198, 0x019C, 
	0x01A2, 0x01AA, 0x01B4, 0x01C1, 0x01D1, 0x01E2, 0x01F1, 0x01FE, 0x0208, 
	0x0210, 0x0216, 0x021A, 0x021B, 0x021A, 0x0216, 0x0210, 0x0208, 0x01FE, 
	0x01F1, 0x01E2, 0x01D1, 0x01C1, 0x01B4, 0x01AA, 0x01A2, 0x019C, 0x0198, 
	0x0197, 0x0624, 0x0628, 0x0632, 0x0644, 0x065D, 0x067C, 0x06A3, 0x06D1, 
	0x0704, 0x0732, 0x0759, 0x0779, 0x0791, 0x07A3, 0x07AE, 0x07B1, 0x07AE, 
	0x07A3, 0x0791, 0x0779, 0x0759, 0x0732, 0x0704, 0x06D1, 0x06A3, 0x067C, 
	0x065D, 0x0644, 0x0632, 0x0628, 0x0624, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 
	0xFEA3, 0xFEBC, 0xFEE4, 0xFF1D, 0xFF66, 0xFFBF, 0x002A, 0x009F, 0x0109, 
	0x0162, 0x01AB, 0x01E4, 0x020C, 0x0225, 0x022D, 0x0225, 0x020C, 0x01E4, 
	0x01AB, 0x0162, 0x0109, 0x009F, 0x002A, 0xFFBF, 0xFF66, 0xFF1D, 0xFEE4, 
	0xFEBC, 0xFEA3, 0xFE9B, 0xEFF9, 0xEFF8, 0xEFF3, 0xEFEC, 0xEFE1, 0xEFD4, 
	0xEFC4, 0xEFB1, 0xEF9B, 0xEF88, 0xEF78, 0xEF6B, 0xEF60, 0xEF59, 0xEF54, 
	0xEF53, 0xEF54, 0xEF59, 0xEF60, 0xEF6B, 0xEF78, 0xEF88, 0xEF9B, 0xEFB1, 
	0xEFC4, 0xEFD4, 0xEFE1, 0xEFEC, 0xEFF3, 0xEFF8, 0xEFF9, 0x839E, 0x8390, 
	0x8364, 0x831B, 0x82B5, 0x8232, 0x8192, 0x80D4, 0x8001, 0x7F44, 0x7EA4, 
	0x7E20, 0x7DBA, 0x7D72, 0x7D46, 0x7D37, 0x7D46, 0x7D72, 0x7DBA, 0x7E20, 
	0x7EA4, 0x7F44, 0x8001, 0x80D4, 0x8192, 0x8232, 0x82B5, 0x831B, 0x8364, 
	0x8390, 0x839E, 0x0000, 0xFFFF, 0x49EE, 0x4A01, 0x4A3A, 0x4A98, 0x4B1D, 
	0x4BC8, 0x4C98, 0x4D8F, 0x4EA1, 0x4F98, 0x5068, 0x5113, 0x5198, 0x51F6, 
	0x522F, 0x5242, 0x522F, 0x51F6, 0x5198, 0x5113, 0x5068, 0x4F98, 0x4EA1, 
	0x4D8F, 0x4C98, 0x4BC8, 0x4B1D, 0x4A98, 0x4A3A, 0x4A01, 0x49EE, 0xF7AE, 
	0xF7AB, 0xF7A3, 0xF797, 0xF785, 0xF76E, 0xF752, 0xF731, 0xF70C, 0xF6EB, 
	0xF6D0, 0xF6B9, 0xF6A7, 0xF69A, 0xF693, 0xF690, 0xF693, 0xF69A, 0xF6A7, 
	0xF6B9, 0xF6D0, 0xF6EB, 0xF70C, 0xF731, 0xF752, 0xF76E, 0xF785, 0xF797, 
	0xF7A3, 0xF7AB, 0xF7AE, 0x03C6, 0x03C6, 0x03C5, 0x03C4, 0x03C3, 0x03C1, 
	0x03BF, 0x03BD, 0x03BB, 0x03B8, 0x03B6, 0x03B5, 0x03B4, 0x03B3, 0x03B2, 
	0x03B2, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B8, 0x03BB, 0x03BD, 
	0x03BF, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0xAB92, 0xAB8D, 0xAB7D, 
	0xAB63, 0xAB3E, 0xAB0F, 0xAAD5, 0xAA91, 0xAA45, 0xAA01, 0xA9C7, 0xA998, 
	0xA973, 0xA959, 0xA949, 0xA944, 0xA949, 0xA959, 0xA973, 0xA998, 0xA9C7, 
	0xAA01, 0xAA45, 0xAA91, 0xAAD5, 0xAB0F, 0xAB3E, 0xAB63, 0xAB7D, 0xAB8D, 
	0xAB92, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x01B7, 0x019D, 0x0171, 0x0134, 
	0x00E5, 0x0085, 0x0013, 0xFF93, 0xFF21, 0xFEC1, 0xFE72, 0xFE35, 0xFE09, 
	0xFDEF, 0xFDE6, 0xFDEF, 0xFE09, 0xFE35, 0xFE72, 0xFEC1, 0xFF21, 0xFF93, 
	0x0013, 0x0085, 0x00E5, 0x0134, 0x0171, 0x019D, 0x01B7, 0x01C0, 0x1192, 
	0x1194, 0x1198, 0x11A0, 0x11AB, 0x11B9, 0x11CA, 0x11DE, 0x11F4, 0x1208, 
	0x1219, 0x1227, 0x1232, 0x1239, 0x123E, 0x123F, 0x123E, 0x1239, 0x1232, 
	0x1227, 0x1219, 0x1208, 0x11F4, 0x11DE, 0x11CA, 0x11B9, 0x11AB, 0x11A0, 
	0x1198, 0x1194, 0x1192, 0x842B, 0x841C, 0x83EF, 0x83A3, 0x833A, 0x82B1, 
	0x820B, 0x8147, 0x806C, 0x7FA7, 0x7F01, 0x7E79, 0x7E0F, 0x7DC4, 0x7D96, 
	0x7D87, 0x7D96, 0x7DC4, 0x7E0F, 0x7E79, 0x7F01, 0x7FA7, 0x806C, 0x8147, 
	0x820B, 0x82B1, 0x833A, 0x83A3, 0x83EF, 0x841C, 0x842B, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x4A21, 0x4A34, 0x4A6C, 
	0x4ACA, 0x4B4E, 0x4BF7, 0x4CC6, 0x4DBA, 0x4ECA, 0x4FBF, 0x508E, 0x5137, 
	0x51BA, 0x5218, 0x5251, 0x5264, 0x5251, 0x5218, 0x51BA, 0x5137, 0x508E, 
	0x4FBF, 0x4ECA, 0x4DBA, 0x4CC6, 0x4BF7, 0x4B4E, 0x4ACA, 0x4A6C, 0x4A34, 
	0x4A21, 0x09D3, 0x09D6, 0x09DF, 0x09EF, 0x0A06, 0x0A22, 0x0A45, 0x0A6F, 
	0x0A9D, 0x0AC6, 0x0AE9, 0x0B06, 0x0B1C, 0x0B2C, 0x0B36, 0x0B39, 0x0B36, 
	0x0B2C, 0x0B1C, 0x0B06, 0x0AE9, 0x0AC6, 0x0A9D, 0x0A6F, 0x0A45, 0x0A22, 
	0x0A06, 0x09EF, 0x09DF, 0x09D6, 0x09D3, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 
	0xFE38, 0xFE3A, 0xFE3E, 0xFE42, 0xFE47, 0xFE4B, 0xFE4F, 0xFE52, 0xFE54, 
	0xFE56, 0xFE57, 0xFE57, 0xFE57, 0xFE56, 0xFE54, 0xFE52, 0xFE4F, 0xFE4B, 
	0xFE47, 0xFE42, 0xFE3E, 0xFE3A, 0xFE38, 0xFE35, 0xFE34, 0xFE33, 0xFE32, 
	0xABC3, 0xABBD, 0xABAD, 0xAB92, 0xAB6C, 0xAB3B, 0xAAFF, 0xAAB8, 0xAA69, 
	0xAA22, 0xA9E7, 0xA9B6, 0xA990, 0xA974, 0xA964, 0xA95F, 0xA964, 0xA974, 
	0xA990, 0xA9B6, 0xA9E7, 0xAA22, 0xAA69, 0xAAB8, 0xAAFF, 0xAB3B, 0xAB6C, 
	0xAB92, 0xABAD, 0xABBD, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001C, 0x0001, 0x0001, 0x001D, 0x0001, 0x001E, 0x0001, 
	0x001F, 0x0001, 0x0020, 0x0001, 0x0021, 0x0001, 0x0022, 0x0001, 0x0023, 
	0x0001, 0x0024, 0x0001, 0x0025, 0x001F, 0x0026, 0x001F, 0x0045, 0x001F, 
	0x0064, 0x001F, 0x0083, 0x0001, 0x00A2, 0x0001, 0x00A3, 0x0001, 0x00A4, 
	0x001F, 0x00A5, 0x001F, 0x00C4, 0x001F, 0x00E3, 0x001F, 0x0102, 0x001C, 
	0x0121, 0x001F, 0x013D, 0x001F, 0x015C, 0x001F, 0x017B, 0x001F, 0x019A, 
	0x0001, 0x01B9, 0x0001, 0x01BA, 0x0001, 0x01BB, 0x001F, 0x01BC, 0x001F, 
	0x01DB, 0x001F, 0x01FA, 0x0001, 0x0219, 0x001B, 0x021A, 0x001F, 0x0235, 
	0x001F, 0x0254, 0x001F, 0x0273, 0x001F, 0x0292, 0x0001, 0x02B1, 0x0001, 
	0x02B2, 0x0001, 0x02B3, 0x001F, 0x02B4, 0x001F, 0x02D3, 0x001F, 0x02F2, 
	0x0001, 0x0311, 0x0001, 0x0312, 0x001F, 0x0313, 0x001F, 0x0332, 0x001E, 
	0x0351, 0x001F, 0x036F, 0x0001, 0x038E, 0x0001, 0x038F, 0x0001, 0x0390, 
	0x001F, 0x0391, 0x001F, 0x03B0, 0x001F, 0x03CF, 0x0001, 0x03EE, 0x0019, 
	0x03EF, 0x001F, 0x0408, 0x001F, 0x0427, 0x001F, 0x0446, 0x001F, 0x0465, 
	

});

smlua_anim_util_register_animation('donkey_00_slow_ledge_grab',1, 0, 0, 0, 33, { 
	0x0000, 0xFEF5, 0xFEFE, 0xFF16, 0xFF3A, 0xFF65, 0xFF93, 0xFFD0, 0xFFFF, 
	0x0021, 0x0035, 0x003C, 0x0045, 0x004B, 0x0050, 0x0052, 0x0054, 0x0055, 
	0x0056, 0x0058, 0x005A, 0x005D, 0x0061, 0x0065, 0x0069, 0x006E, 0x0072, 
	0x0077, 0x007C, 0x0080, 0x0084, 0x0087, 0x0089, 0x008B, 0xFFBC, 0xFFB8, 
	0xFFAD, 0xFFA0, 0xFF95, 0xFF91, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF96, 
	0xFF97, 0xFF99, 0xFF9B, 0xFF9D, 0xFFA0, 0xFFA3, 0xFFA8, 0xFFAE, 0xFFB5, 
	0xFFBE, 0xFFC7, 0xFFD1, 0xFFDC, 0xFFE6, 0xFFF1, 0xFFFB, 0x0005, 0x000E, 
	0x0016, 0x001C, 0x0021, 0x0024, 0x0025, 0x0000, 0x3FFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x4912, 0x48DC, 0x4841, 
	0x474A, 0x4603, 0x4475, 0x42AB, 0x40AF, 0x3E8B, 0x3C4A, 0x39F6, 0x379B, 
	0x354D, 0x3320, 0x3129, 0x2F7D, 0x2E31, 0x2D5B, 0x2D0F, 0x2D96, 0x2F12, 
	0x315D, 0x3452, 0x37CB, 0x3BA1, 0x3FB1, 0x43D3, 0x47E2, 0x4BB9, 0x4F32, 
	0x5227, 0x5472, 0x55EE, 0x5675, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xDCA3, 
	0xDDA5, 0xE07A, 0xE4D7, 0xEA72, 0xF100, 0xF836, 0xFFCB, 0x0775, 0x0EE8, 
	0x15D9, 0x1C0C, 0x2170, 0x2606, 0x29CA, 0x2CBC, 0x2ED8, 0x301E, 0x308B, 
	0x2FF9, 0x2E5C, 0x2BDF, 0x28AA, 0x24E6, 0x20BB, 0x1C53, 0x17D7, 0x136F, 
	0x0F45, 0x0B80, 0x084B, 0x05CE, 0x0432, 0x039F, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xF371, 0xF3E5, 0xF51F, 0xF6EE, 0xF921, 0xFB85, 0xFDE9, 0x001D, 0x01EC, 
	0x0326, 0x039A, 0x02AA, 0x0032, 0xFCB3, 0xF8B2, 0xF4B1, 0xF133, 0xEEBB, 
	0xEDCB, 0xEDCC, 0xEDD0, 0xEDD5, 0xEDDD, 0xEDE5, 0xEDEE, 0xEDF8, 0xEE02, 
	0xEE0C, 0xEE15, 0xEE1D, 0xEE24, 0xEE2A, 0xEE2E, 0xEE2F, 0xFFFE, 0x0001, 
	0xC170, 0xC2FB, 0xCA40, 0xDDA8, 0xF997, 0x9A70, 0xB163, 0x22FF, 0x1436, 
	0x0C9E, 0x09D2, 0x096C, 0x0B19, 0x0F82, 0x15C0, 0x1CE7, 0x240E, 0x2A4B, 
	0x2EB5, 0xB061, 0x2E84, 0x2942, 0x2123, 0x16AC, 0x0A61, 0xFCC8, 0xEE68, 
	0xDFC5, 0xD165, 0xC3CC, 0x3782, 0x2D0B, 0x24EC, 0x1FAA, 0x1DCC, 0xA528, 
	0xA609, 0xA7F9, 0xA9E8, 0xD535, 0xDA6C, 0xAE58, 0xB75B, 0xBBFC, 0xBDB0, 
	0xBDEF, 0xBDE9, 0xBDD2, 0xBDA6, 0xBD5C, 0xBCF0, 0xBC5B, 0xBB96, 0xC562, 
	0xB969, 0xB805, 0xB67B, 0xB4D4, 0xB31B, 0xB15A, 0xAF9D, 0xADEC, 0xAC54, 
	0xAADE, 0xD66A, 0xD77D, 0xD84E, 0xD8D3, 0xD901, 0xEB11, 0xE407, 0xD245, 
	0xBAD5, 0x22BF, 0x1452, 0xBDDF, 0xCED5, 0xD78B, 0xDAC1, 0xDB36, 0xD986, 
	0xD513, 0xCEC9, 0xC793, 0xC05D, 0xBA13, 0xB5A0, 0x33F1, 0xB5A1, 0xBA60, 
	0xC1B7, 0xCB2D, 0xD648, 0xE291, 0xEF8E, 0xFCC8, 0x09C7, 0x1610, 0xA12B, 
	0xAAA0, 0xB1F7, 0xB6B7, 0xB867, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xD1C6, 0xCDC4, 0xC37E, 
	0xB597, 0xA6AF, 0x9D44, 0xA4B1, 0xAA77, 0xAE97, 0xB110, 0xB1E4, 0xB1BD, 
	0xB155, 0xB0C4, 0xB01D, 0xAF75, 0xAEE4, 0xAE7D, 0xAE55, 0xAEB0, 0xAFAD, 
	0xB135, 0xB32E, 0xB57E, 0xB80E, 0xBAC4, 0xBD86, 0xC03B, 0xC2CB, 0xC51C, 
	0xC715, 0xC89C, 0xC99A, 0xC9F4, 0xFEF4, 0xFEF1, 0xFEDD, 0xFEA8, 0xFE40, 
	0xFD94, 0xF0C4, 0xF2C4, 0xF72C, 0xFB93, 0xFD94, 0xFD91, 0xFD8A, 0xFD81, 
	0xFD76, 0xFD6B, 0xFD62, 0xFD5B, 0xFD59, 0xFD79, 0xFDD2, 0xFE5D, 0xFF0F, 
	0xFFE0, 0x00C9, 0x01BE, 0x02B7, 0x03AC, 0x0494, 0x0566, 0x0618, 0x06A2, 
	0x06FC, 0x071C, 0xECCF, 0xECD3, 0xECDD, 0xECE9, 0xECF3, 0xECF7, 0xCEEC, 
	0xD39E, 0xDDF2, 0xE846, 0xECF7, 0xECB7, 0xEC0E, 0xEB1F, 0xEA0C, 0xE8FA, 
	0xE80B, 0xE761, 0xE721, 0xE77C, 0xE87C, 0xEA08, 0xEC05, 0xEE5C, 0xF0F2, 
	0xF3AE, 0xF677, 0xF934, 0xFBCA, 0xFE20, 0x001F, 0x01AB, 0x02AB, 0x0306, 
	0x0BBF, 0x0BC6, 0x0BF1, 0x0C68, 0x0D4F, 0x0ECD, 0x1F90, 0x1CF2, 0x172F, 
	0x116B, 0x0ECD, 0x0ED1, 0x0EDD, 0x0EEE, 0x0F01, 0x0F14, 0x0F25, 0x0F30, 
	0x0F35, 0x0F26, 0x0EFB, 0x0EB9, 0x0E64, 0x0E01, 0x0D92, 0x0D1E, 0x0CA7, 
	0x0C32, 0x0BC4, 0x0B60, 0x0B0B, 0x0AC9, 0x0A9F, 0x0A90, 0xFFFE, 0x0001, 
	0xC170, 0x3BA9, 0x3779, 0x2993, 0x0FF2, 0x6895, 0x46B1, 0xDA9A, 0xEF13, 
	0xF997, 0xFD78, 0xFE06, 0xFCFB, 0xFA18, 0xF5BC, 0xF045, 0xEA10, 0xE37C, 
	0xDCE6, 0xD6AE, 0xD11E, 0x4C3E, 0x4802, 0x445E, 0x4147, 0x3EB2, 0x3C92, 
	0x3ADE, 0x3989, 0x3887, 0x37CE, 0x3752, 0x3708, 0x36E4, 0x36DA, 0x598E, 
	0x5983, 0x596B, 0x5951, 0x26BD, 0x272D, 0x50D4, 0x48E9, 0x44A9, 0x42F1, 
	0x429E, 0x42B8, 0x42FC, 0x435C, 0x43CA, 0x4438, 0x4498, 0x44DC, 0x44F6, 
	0x44A1, 0x3C4C, 0x3DBC, 0x3F96, 0x41C2, 0x4429, 0x46B4, 0x494B, 0x4BD6, 
	0x4E3D, 0x5069, 0x5243, 0x53B3, 0x54A1, 0x54F5, 0xEA82, 0xE5F9, 0xD89D, 
	0xC2CC, 0x24E4, 0x0D0C, 0xBEFF, 0xD41C, 0xDEF3, 0xE2F1, 0xE384, 0xE27B, 
	0xDF9C, 0xDB44, 0xD5CC, 0xCF91, 0xC8ED, 0xC23B, 0xBBD7, 0xB60B, 0x30E0, 
	0x2C4C, 0x2847, 0x24C8, 0x21C8, 0x1F3C, 0x1D1E, 0x1B63, 0x1A04, 0x18F9, 
	0x1837, 0x17B8, 0x1772, 0x175C, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xCEEE, 0xCB04, 
	0xC123, 0xB41A, 0xA6B8, 0x9EB6, 0xA602, 0xABAE, 0xAFBC, 0xB22B, 0xB2FA, 
	0xB2DB, 0xB288, 0xB214, 0xB18E, 0xB108, 0xB094, 0xB041, 0xB022, 0xB07B, 
	0xB175, 0xB2F7, 0xB4E9, 0xB732, 0xB9B9, 0xBC65, 0xBF1D, 0xC1C9, 0xC450, 
	0xC699, 0xC88B, 0xCA0D, 0xCB07, 0xCB60, 0xFD8D, 0xFD91, 0xFDAF, 0xFE01, 
	0xFEA1, 0xFFA8, 0x085D, 0x0708, 0x0417, 0x011C, 0xFFA8, 0xFF88, 0xFF78, 
	0xFF72, 0xFF71, 0xFF71, 0xFF6B, 0xFF5A, 0xFF3B, 0xFF07, 0xFEC0, 0xFE68, 
	0xFE04, 0xFD96, 0xFD23, 0xFCAD, 0xFC38, 0xFBC7, 0xFB5E, 0xFB01, 0xFAB2, 
	0xFA76, 0xFA4F, 0xFA42, 0x1311, 0x1311, 0x1312, 0x1313, 0x1317, 0x131D, 
	0x363D, 0x30C0, 0x24AD, 0x189A, 0x131D, 0x135D, 0x1406, 0x14F5, 0x1606, 
	0x1718, 0x1807, 0x18B0, 0x18F0, 0x18A4, 0x17CD, 0x1682, 0x14D7, 0x12E2, 
	0x10B8, 0x0E6E, 0x0C19, 0x09CF, 0x07A5, 0x05AF, 0x0405, 0x02BA, 0x01E3, 
	0x0197, 0x05A0, 0x05A9, 0x05EC, 0x06A1, 0x0801, 0x0A45, 0x1B4E, 0x18A5, 
	0x12CA, 0x0CEF, 0x0A45, 0x0A47, 0x0A4B, 0x0A52, 0x0A59, 0x0A60, 0x0A67, 
	0x0A6B, 0x0A6D, 0x0A5F, 0x0A38, 0x09FB, 0x09AD, 0x0951, 0x08EB, 0x087F, 
	0x0812, 0x07A6, 0x0741, 0x06E5, 0x0696, 0x065A, 0x0632, 0x0624, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xBF5E, 0xF275, 0xF1E8, 0xF06B, 0xEE3A, 0xEB90, 0xE8AA, 
	0xE5C3, 0xE319, 0xE0E8, 0xDF6B, 0xDEDE, 0xEA1D, 0x02DD, 0x1B9C, 0x26DB, 
	0x236F, 0x1B9C, 0x130C, 0x0D68, 0x0AA4, 0x083E, 0x0630, 0x0472, 0x02FE, 
	0x01CE, 0x00DB, 0x001D, 0xFF8D, 0xFF27, 0xFEE3, 0xFEB9, 0xFEA4, 0xFE9C, 
	0xFE9B, 0xF0B5, 0xF032, 0xEECF, 0xECC3, 0xEA48, 0xE795, 0xE4E1, 0xE266, 
	0xE05B, 0xDEF8, 0xDE75, 0xDEF9, 0xE09D, 0xE384, 0xE7D2, 0xED68, 0xF321, 
	0xF797, 0xF964, 0xF945, 0xF8EE, 0xF869, 0xF7BD, 0xF6F3, 0xF613, 0xF527, 
	0xF436, 0xF34A, 0xF26A, 0xF1A0, 0xF0F4, 0xF06E, 0xF018, 0xEFF9, 0xA61C, 
	0xA69B, 0xA7F5, 0xA9F4, 0xAC5F, 0xAF01, 0xB1A3, 0xB40E, 0xB60C, 0xB766, 
	0xB7E6, 0xAB1C, 0x8EF9, 0x72D6, 0x660B, 0x6692, 0x67F6, 0x69EF, 0x6C32, 
	0x6E82, 0x70CF, 0x7313, 0x7548, 0x7769, 0x7970, 0x7B58, 0x7D1B, 0x7EB4, 
	0x801E, 0x8152, 0x824B, 0x8304, 0x8377, 0x839E, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x1BBC, 0x1BC2, 0x1BEB, 0x1C5B, 0x1D36, 
	0x1E9F, 0x20B9, 0x23A8, 0x278F, 0x2C92, 0x32D4, 0x3B35, 0x44A2, 0x4C53, 
	0x4F81, 0x4E54, 0x4B35, 0x46C3, 0x419C, 0x3C46, 0x36E9, 0x3194, 0x2C55, 
	0x273B, 0x2256, 0x1DB4, 0x1984, 0x166E, 0x153A, 0x1AB5, 0x27C7, 0x3761, 
	0x4473, 0x49EE, 0x0000, 0xFFE3, 0xFF98, 0xFF26, 0xFE99, 0xFDFC, 0xFD58, 
	0xFCB9, 0xFC28, 0xFBB0, 0xFB5C, 0xFB2C, 0xFB13, 0xFB0A, 0xFB09, 0xFB9D, 
	0xFCFD, 0xFEA0, 0x0000, 0x00E8, 0x018A, 0x01F5, 0x0235, 0x0258, 0x0269, 
	0x0277, 0x028A, 0x029D, 0x02A6, 0x0182, 0xFEC9, 0xFB8A, 0xF8D2, 0xF7AE, 
	0x0C88, 0x0C84, 0x0C7B, 0x0C6D, 0x0C59, 0x0C41, 0x0C26, 0x0C07, 0x0BE5, 
	0x0BC1, 0x0B9C, 0x0B74, 0x0B44, 0x0B02, 0x0AA9, 0x0A33, 0x09AD, 0x0927, 
	0x08AF, 0x0852, 0x0807, 0x07C4, 0x077D, 0x0725, 0x06B1, 0x0616, 0x0553, 
	0x049A, 0x0427, 0x03F8, 0x03DB, 0x03CC, 0x03C7, 0x03C6, 0xDE2A, 0xDDE3, 
	0xDD1B, 0xDBE7, 0xDA5B, 0xD88D, 0xD691, 0xD47B, 0xD260, 0xD055, 0xCE6F, 
	0xCCC3, 0xCB6E, 0xCA8C, 0xCA3A, 0xCF54, 0xDAF8, 0xE7A9, 0xEFEA, 0xF38C, 
	0xF626, 0xF7E5, 0xF8F3, 0xF97E, 0xF9B2, 0xF9B9, 0xF7A0, 0xF155, 0xE6DB, 
	0xD8A6, 0xC8F1, 0xBA69, 0xAFBA, 0xAB92, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x1E07, 
	0x1E07, 0x1E05, 0x1E00, 0x1DF5, 0x1DE4, 0x1DCB, 0x1DA7, 0x1D78, 0x1D3B, 
	0x1CEF, 0x1BE1, 0x19A0, 0x168E, 0x130C, 0x0F7D, 0x0C3B, 0x097C, 0x0771, 
	0x0636, 0x0598, 0x0553, 0x0521, 0x04BD, 0x03E1, 0x0248, 0xFFE7, 0xFDA7, 
	0xFCA7, 0xFD2E, 0xFE72, 0xFFF4, 0x0138, 0x01C0, 0x0C91, 0x0C91, 0x0C96, 
	0x0CA2, 0x0CB9, 0x0CDF, 0x0D19, 0x0D69, 0x0DD3, 0x0E5C, 0x0F07, 0x10F6, 
	0x1481, 0x187C, 0x1BBC, 0x1D14, 0x17FD, 0x0E88, 0x0971, 0x098A, 0x09CF, 
	0x0A3A, 0x0AC5, 0x0B69, 0x0C21, 0x0CE4, 0x0DAD, 0x0E77, 0x0F3C, 0x0FF6, 
	0x1099, 0x111C, 0x1173, 0x1192, 0xB7B3, 0xB7A1, 0xB76E, 0xB723, 0xB6C6, 
	0xB65E, 0xB5F1, 0xB588, 0xB52A, 0xB4DC, 0xB4A6, 0xB47D, 0xB405, 0xB2D2, 
	0xB077, 0xAC87, 0x9F4C, 0x8BD4, 0x81D8, 0x81FE, 0x825E, 0x82E2, 0x8372, 
	0x83F6, 0x8456, 0x847C, 0x808A, 0x7938, 0x7546, 0x76D3, 0x7A84, 0x7EED, 
	0x829F, 0x842B, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x07D2, 
	0x07D4, 0x07E1, 0x0804, 0x0848, 0x08B8, 0x095E, 0x0A47, 0x0B7D, 0x0D0B, 
	0x0EFC, 0x13BF, 0x1C00, 0x2522, 0x2C87, 0x2F92, 0x2ED0, 0x2CB2, 0x2970, 
	0x254D, 0x20AB, 0x1BF3, 0x1790, 0x13EA, 0x116D, 0x1081, 0x12FB, 0x1982, 
	0x22BC, 0x2D51, 0x37E5, 0x4120, 0x47A7, 0x4A21, 0xF94E, 0xF94E, 0xF94E, 
	0xF94E, 0xF94E, 0xF94E, 0xF94E, 0xF94E, 0xF94E, 0xF94E, 0xF94E, 0xF94F, 
	0xF952, 0xF958, 0xF962, 0xF971, 0xF984, 0xF99E, 0xF9BE, 0xF9EC, 0xFA44, 
	0xFAE4, 0xFBCB, 0xFCF0, 0xFE49, 0xFFCF, 0x0177, 0x032D, 0x04DA, 0x066A, 
	0x07C7, 0x08DC, 0x0991, 0x09D3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFE5, 0xFF9F, 0xFF3D, 
	0xFECD, 0xFE5C, 0xFDFA, 0xFDB5, 0xFD9A, 0xFEE0, 0x0027, 0x001C, 0xFFFE, 
	0xFFD2, 0xFF9D, 0xFF64, 0xFF2A, 0xFEF3, 0xFEBF, 0xFE91, 0xFE6A, 0xFE4C, 
	0xFE39, 0xFE32, 0xF22C, 0xF22C, 0xF22C, 0xF22C, 0xF22C, 0xF22C, 0xF22C, 
	0xF22C, 0xF22C, 0xF22C, 0xF22C, 0xF189, 0xEFDC, 0xED7F, 0xEAC8, 0xE811, 
	0xE5B3, 0xE407, 0xE364, 0xE6A6, 0xED5E, 0xF3BA, 0xF8DE, 0xFCAD, 0xFF0B, 
	0xFFDB, 0xFC3E, 0xF2B8, 0xE540, 0xD5CF, 0xC65E, 0xB8E7, 0xAF60, 0xABC3, 
	

},{ 
	0x0001, 0x0000, 0x0021, 0x0001, 0x0022, 0x0022, 0x0001, 0x0044, 0x0001, 
	0x0045, 0x0001, 0x0046, 0x0013, 0x0047, 0x0021, 0x005A, 0x0022, 0x007B, 
	0x0014, 0x009D, 0x0014, 0x00B1, 0x0022, 0x00C5, 0x0001, 0x00E7, 0x001D, 
	0x00E8, 0x0022, 0x0105, 0x0001, 0x0127, 0x0001, 0x0128, 0x0001, 0x0129, 
	0x0022, 0x012A, 0x0022, 0x014C, 0x0022, 0x016E, 0x0020, 0x0190, 0x0021, 
	0x01B0, 0x0022, 0x01D1, 0x0022, 0x01F3, 0x0022, 0x0215, 0x0022, 0x0237, 
	0x0001, 0x0259, 0x0001, 0x025A, 0x0001, 0x025B, 0x0022, 0x025C, 0x0022, 
	0x027E, 0x0022, 0x02A0, 0x0022, 0x02C2, 0x0020, 0x02E4, 0x0022, 0x0304, 
	0x0022, 0x0326, 0x0022, 0x0348, 0x0022, 0x036A, 0x0021, 0x038C, 0x0021, 
	0x03AD, 0x0001, 0x03CE, 0x0022, 0x03CF, 0x0022, 0x03F1, 0x0022, 0x0413, 
	0x001E, 0x0435, 0x001F, 0x0453, 0x0022, 0x0472, 0x0022, 0x0494, 0x0022, 
	0x04B6, 0x0022, 0x04D8, 0x0020, 0x04FA, 0x0021, 0x051A, 0x0001, 0x053B, 
	0x0022, 0x053C, 0x0022, 0x055E, 0x0022, 0x0580, 0x001B, 0x05A2, 0x0021, 
	0x05BD, 0x0022, 0x05DE, 0x0022, 0x0600, 0x0022, 0x0622, 0x0022, 0x0644, 
	

});

smlua_anim_util_register_animation('donkey_01_fall_over_backwards',1, 0, 0, 0, 79, { 
	0x0000, 0x0064, 0x0063, 0x0060, 0x005D, 0x0059, 0x0056, 0x0053, 0x0052, 
	0x0052, 0x0052, 0x0052, 0x0062, 0x0088, 0x00B6, 0x00DD, 0x00ED, 0x00D5, 
	0x009F, 0x006A, 0x0052, 0x0055, 0x005D, 0x0067, 0x0073, 0x007D, 0x0085, 
	0x0088, 0x007F, 0x006D, 0x005A, 0x0052, 0x0057, 0x005D, 0x005D, 0x005D, 
	0x005C, 0x005C, 0x005C, 0x005C, 0x005B, 0x005A, 0x005A, 0x0059, 0x0058, 
	0x0057, 0x0056, 0x0056, 0x0055, 0x0054, 0x0053, 0x0052, 0x0052, 0x0051, 
	0x0050, 0x0050, 0x004F, 0x004F, 0x004F, 0x004F, 0x0055, 0x0065, 0x0075, 
	0x007E, 0x0080, 0x0081, 0x0081, 0x0083, 0x0088, 0x008D, 0x008F, 0x008F, 
	0x008F, 0x008E, 0x008E, 0x008D, 0x008D, 0x008C, 0x008C, 0x008B, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFEA, 0xFFEA, 0xFFEB, 0xFFEC, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFEE, 0xFFEF, 0xFFF1, 
	0xFFF4, 0xFFF7, 0xFFF9, 0xFFFC, 0xFFFE, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0xFFFA, 0xFFF6, 0xFFF3, 
	0xFFF3, 0xFFF6, 0xFFFF, 0x0014, 0x0036, 0x005E, 0x0089, 0x00D0, 0x00CA, 
	0x00BA, 0x00A3, 0x0087, 0x0068, 0x0049, 0x002D, 0x0015, 0x0006, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFE, 0xFFF9, 0xFFF2, 0xFFE9, 0xFFDE, 0xFFD2, 0xFFC6, 0xFFB9, 
	0xFFAD, 0xFFA3, 0xFF99, 0xFF92, 0xFF8D, 0xFF8C, 0xFF8D, 0xFF93, 0xFF9E, 
	0xFFAD, 0xFFC3, 0xFFDE, 0x0000, 0x0057, 0x00FB, 0x01CB, 0x02A3, 0x0364, 
	0x03E9, 0x0413, 0x0330, 0x0161, 0xFFB9, 0xFF4B, 0x036D, 0x027F, 0x01C1, 
	0x012C, 0x00BD, 0x006D, 0x0038, 0x0017, 0x0007, 0x0000, 0xFFFE, 0x3400, 
	0x31EB, 0x2CC1, 0x2625, 0x1D43, 0x12EE, 0x0B42, 0x068A, 0x0254, 0xFE9B, 
	0xFB5D, 0xF899, 0xF64B, 0xF471, 0xF32F, 0xF293, 0xF27B, 0xF2C2, 0xF345, 
	0xF3E1, 0xF471, 0xF51C, 0xF60F, 0xF734, 0xF872, 0xF9B3, 0xFADF, 0xFC0F, 
	0xFD53, 0xFE81, 0xFF71, 0xFFA2, 0xFF71, 0xFF4B, 0xFF0B, 0xFEFE, 0xFF71, 
	0x0034, 0x00E5, 0x018A, 0x0224, 0x02B7, 0x0347, 0x03D7, 0x046C, 0x0507, 
	0x05AD, 0x0661, 0x0726, 0x0801, 0x08F4, 0x0A03, 0x0B31, 0x0C82, 0x0DF9, 
	0x0F9A, 0x1169, 0x1368, 0x1687, 0x1B59, 0x2154, 0x27EF, 0x2E9F, 0x34DC, 
	0x3A1C, 0x3DF2, 0x40BC, 0x431F, 0x45C0, 0x49B5, 0x4D29, 0x4FEE, 0x5215, 
	0x53B4, 0x54DD, 0x55A4, 0x561D, 0x565B, 0x5672, 0x5675, 0x011C, 0x0233, 
	0x0435, 0x0542, 0x0417, 0x01F6, 0x00CA, 0x00F9, 0x0033, 0xFEC2, 0xFDFB, 
	0xFE9C, 0x001D, 0x01E7, 0x0367, 0x0408, 0x034A, 0x01A8, 0x0006, 0xFF47, 
	0x00CA, 0x00C2, 0x00F2, 0x014A, 0x01B7, 0x0228, 0x028B, 0x02F0, 0x0365, 
	0x03D4, 0x042D, 0x043E, 0x042D, 0x042C, 0x042C, 0x042C, 0x042D, 0x0432, 
	0x043D, 0x044C, 0x045E, 0x0471, 0x0482, 0x0491, 0x049A, 0x049E, 0x0499, 
	0x048B, 0x0471, 0x0449, 0x03F8, 0x0370, 0x02C6, 0x020F, 0x0160, 0x00CF, 
	0x006F, 0x0057, 0x0080, 0x00D8, 0x015E, 0x0215, 0x02FB, 0x0413, 0x055C, 
	0x0954, 0x0CC9, 0x0A7C, 0x06CD, 0x0487, 0x034D, 0x0251, 0x018E, 0x00FA, 
	0x0091, 0x004A, 0x001F, 0x0009, 0x0001, 0x0000, 0xF993, 0xF9B0, 0xF9D8, 
	0xF9C5, 0xF92B, 0xF857, 0xF7E6, 0xF7F3, 0xF948, 0xFB98, 0xFCD2, 0xFC72, 
	0xFB8C, 0xFA79, 0xF993, 0xF933, 0xF934, 0xF936, 0xF938, 0xF938, 0xF7E6, 
	0xF793, 0xF735, 0xF6CE, 0xF663, 0xF5F9, 0xF593, 0xF52C, 0xF4C1, 0xF45F, 
	0xF411, 0xF401, 0xF411, 0xF402, 0xF3E9, 0xF3E4, 0xF411, 0xF469, 0xF4CF, 
	0xF53F, 0xF5B6, 0xF633, 0xF6B1, 0xF72E, 0xF7A8, 0xF81B, 0xF884, 0xF8E2, 
	0xF92F, 0xF96B, 0xF98C, 0xF98D, 0xF974, 0xF946, 0xF909, 0xF8C1, 0xF875, 
	0xF82A, 0xF7DD, 0xF788, 0xF72A, 0xF6BF, 0xF645, 0xF5B9, 0xF51A, 0xF393, 
	0xF22D, 0xF261, 0xF37F, 0xF554, 0xF5A1, 0xF670, 0xF7A2, 0xF916, 0xFAAA, 
	0xFC3E, 0xFDB1, 0xFEE3, 0xFFB3, 0x0000, 0x10FB, 0x0B03, 0xFFFD, 0xFA3E, 
	0x00BE, 0x0C85, 0x1303, 0x1210, 0x0F19, 0x0B0B, 0x0721, 0x0455, 0x02A3, 
	0x01C4, 0x0171, 0x0165, 0x037A, 0x084F, 0x0DC7, 0x11C3, 0x1303, 0x133B, 
	0x1240, 0x1070, 0x0E2D, 0x0BD4, 0x09C5, 0x07AE, 0x0545, 0x02F2, 0x011F, 
	0x00C2, 0x011F, 0x011F, 0x0121, 0x0121, 0x011F, 0x0107, 0x00D0, 0x0082, 
	0x0027, 0xFFC9, 0xFF70, 0xFF28, 0xFEF9, 0xFEED, 0xFF0E, 0xFF64, 0xFFFB, 
	0x00DB, 0x0298, 0x0576, 0x090A, 0x0CE7, 0x10A1, 0x13CC, 0x15FB, 0x16C3, 
	0x15D4, 0x136C, 0x0FF8, 0x0BDF, 0x078E, 0x036E, 0xFFE9, 0xFC6E, 0xFB15, 
	0xFEF4, 0x04B4, 0x0AFA, 0x0AC5, 0x0A36, 0x0963, 0x0863, 0x074C, 0x0636, 
	0x0536, 0x0463, 0x03D4, 0x039F, 0xFF65, 0x0E89, 0x071E, 0xFE98, 0xFE5E, 
	0x0095, 0x021F, 0x01D0, 0x00F0, 0x0010, 0xFFC2, 0x00B4, 0x0253, 0x034B, 
	0x034F, 0x030A, 0x029A, 0x0222, 0x01C2, 0x019A, 0x01CB, 0x0270, 0x0376, 
	0x04BA, 0x0618, 0x076E, 0x0896, 0x0993, 0x0A7D, 0x0B4E, 0x0C04, 0x0C6F, 
	0x0C7D, 0x0C77, 0x0C6A, 0x0C30, 0x0BA5, 0x0AD1, 0x09DD, 0x08D2, 0x07B9, 
	0x069C, 0x0584, 0x0478, 0x0383, 0x02AE, 0x01F5, 0x014D, 0x00B4, 0x0029, 
	0xFFAA, 0xFF33, 0xFEC5, 0xFE5B, 0xFDF6, 0xFDCB, 0xFDE3, 0xFDF6, 0xFDE8, 
	0xFDD4, 0xFDBD, 0xFDA8, 0xFD9A, 0xFD97, 0xFDA3, 0xFE04, 0xFEAA, 0xFF1D, 
	0xFEE6, 0xFBBB, 0xFBD9, 0xFC2C, 0xFCA7, 0xFD3B, 0xFDDD, 0xFE7F, 0xFF13, 
	0xFF8D, 0xFFE0, 0x0000, 0xF0B6, 0xF827, 0xF4D3, 0xF0C2, 0xEFE7, 0xF00B, 
	0xF0D7, 0xF22E, 0xF3FB, 0xF5F8, 0xF7E2, 0xF9FC, 0xFC1A, 0xFD4D, 0xFD92, 
	0xFD91, 0xFD5F, 0xFD0F, 0xFCB2, 0xFC5E, 0xFC23, 0xFC06, 0xFBF5, 0xFBE5, 
	0xFBCD, 0xFBA1, 0xFB58, 0xFAC6, 0xF9F1, 0xF920, 0xF894, 0xF8F2, 0xF96C, 
	0xF92B, 0xF8B7, 0xF843, 0xF7FF, 0xF7E9, 0xF7DE, 0xF7DB, 0xF7DF, 0xF7E6, 
	0xF7EF, 0xF7F8, 0xF7FE, 0xF7FF, 0xF7FB, 0xF7F7, 0xF7F1, 0xF7EC, 0xF7E5, 
	0xF7DF, 0xF7D9, 0xF7D4, 0xF7CF, 0xF79D, 0xF76E, 0xF7CF, 0xF895, 0xF94B, 
	0xFA10, 0xFB06, 0xFC4C, 0xFE04, 0x004E, 0x04DE, 0x0B8B, 0x11AC, 0x1495, 
	0x0C3F, 0x08ED, 0x0645, 0x0433, 0x02A5, 0x0188, 0x00C9, 0x0055, 0x0019, 
	0x0003, 0x0000, 0x17B1, 0xEB77, 0xE93B, 0xE953, 0xEB3F, 0xEE7F, 0xF292, 
	0xF6F8, 0xFB33, 0x05F1, 0x0F3A, 0x0BCF, 0x046A, 0x0087, 0x01C6, 0x0468, 
	0x07DE, 0x0B9B, 0x0F0F, 0x11AB, 0x12E3, 0x11F4, 0x0F26, 0x0B73, 0x07D8, 
	0x0551, 0x04D8, 0x0965, 0x11FA, 0x199F, 0x1A96, 0x15DF, 0x149F, 0x13F1, 
	0x1387, 0x1353, 0x1346, 0x134E, 0x1365, 0x138A, 0x13BF, 0x1404, 0x145C, 
	0x14C6, 0x1545, 0x15D9, 0x168F, 0x176A, 0x1861, 0x196A, 0x1A79, 0x1B85, 
	0x1C85, 0x1D6C, 0x1E33, 0x1EF8, 0x1F46, 0x1E33, 0x1BAC, 0x1876, 0x14E3, 
	0x1146, 0x0DF2, 0x0B3B, 0x0973, 0x0A8B, 0x0E32, 0x1159, 0x10F2, 0x0345, 
	0xFD8D, 0xF8FA, 0xF56A, 0xF2BD, 0xF0D2, 0xEF88, 0xEEC1, 0xEE5A, 0xEE34, 
	0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xCA37, 0xCC80, 0xCEC8, 0xCA37, 0xB677, 
	0x9BDD, 0x0C8F, 0x0B3E, 0x0B4C, 0x0BA1, 0x8C80, 0x8E10, 0x9002, 0x91EB, 
	0x935F, 0x93F2, 0x91DD, 0x8CE6, 0x06F9, 0x0201, 0xFFEB, 0x056D, 0x90BE, 
	0x9A19, 0x9D10, 0x9F06, 0x9F15, 0x9B1A, 0x8F4F, 0x000B, 0xF2D4, 0xED32, 
	0xEEBE, 0xF2BA, 0xF82A, 0xFE12, 0x0377, 0x075C, 0x0988, 0x0C0A, 0x8EDC, 
	0x91F8, 0x9559, 0x98F6, 0x9CCA, 0xA0CF, 0xA4FE, 0xA951, 0xADC2, 0xB249, 
	0xB782, 0xBDCD, 0xC4CC, 0xCC20, 0xD36C, 0xDA52, 0xE073, 0xE573, 0xE912, 
	0xEB8B, 0xED39, 0xEE73, 0xEF95, 0xF0F6, 0xF2F1, 0xF696, 0xFB04, 0xFFE8, 
	0x02D1, 0xFDDD, 0x01FF, 0x0D51, 0x9E3B, 0xB325, 0xCA77, 0xE27C, 0xF912, 
	0x0BFB, 0x18F8, 0x1DCC, 0xC606, 0xC60A, 0xC60E, 0xC606, 0xC559, 0xC4A1, 
	0xBA5D, 0xB750, 0xB564, 0xB460, 0xCD1C, 0xD012, 0xD3F9, 0xD7E6, 0xDAED, 
	0xDC23, 0xDA8B, 0xD6BE, 0xADCA, 0xB197, 0xB330, 0xB16F, 0xD237, 0xD55D, 
	0xD694, 0xD77C, 0xD7BA, 0xD6B9, 0xD3C3, 0xB00F, 0xB35F, 0xB4C8, 0xB458, 
	0xB341, 0xB1D5, 0xB06A, 0xAF52, 0xAEE2, 0xAEEC, 0xAEF3, 0xD108, 0xD10E, 
	0xD11F, 0xD13E, 0xD16D, 0xD1B0, 0xD209, 0xD27B, 0xD309, 0xD3B5, 0xD49A, 
	0xD5C9, 0xD738, 0xD8DB, 0xDAA8, 0xDC94, 0xDE96, 0xE0A1, 0xE300, 0xE5D7, 
	0xE8E9, 0xEBF4, 0xEEBA, 0xF0FA, 0xF277, 0xEE95, 0xE9CC, 0xECCF, 0xEF54, 
	0xECCC, 0xCCDA, 0xB99C, 0xD037, 0xD3F1, 0xD4DE, 0xD5B1, 0xD6C5, 0xD7D8, 
	0xD8AC, 0xD901, 0xE104, 0xDEAB, 0xDC52, 0xE104, 0xF592, 0x112B, 0xA061, 
	0xA04E, 0x9EF6, 0x9C09, 0x188D, 0x155B, 0x12B3, 0x10AF, 0x0F67, 0x0EF4, 
	0x113A, 0x16A6, 0x9D1E, 0xA28A, 0xA4D0, 0x9F17, 0x1343, 0x0959, 0x05F0, 
	0x03A9, 0x038E, 0x0805, 0x14E9, 0xA573, 0xB3B7, 0xB9CA, 0xB7F4, 0xB35A, 
	0xAD56, 0xA746, 0xA283, 0xA069, 0xA04E, 0x9FF0, 0x1F54, 0x1E7F, 0x1D78, 
	0x1C46, 0x1AEF, 0x197A, 0x17EC, 0x164C, 0x14A1, 0x12F0, 0x1103, 0x0EAD, 
	0x0C03, 0x091A, 0x0608, 0x02E2, 0xFFBC, 0xFCAB, 0xF9BC, 0xF6DB, 0xF3F0, 
	0xF0E4, 0xED9E, 0xEA09, 0xE60A, 0xDF37, 0xD69E, 0xCCE1, 0xC6F5, 0xC728, 
	0xC3BC, 0xBA41, 0x2BE6, 0x19DA, 0x054D, 0xEF98, 0xDAD0, 0xC931, 0xBCF9, 
	0xB867, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xCA4E, 0xC9CF, 
	0xC94F, 0xCA4E, 0xCE20, 0xD371, 0xD7C0, 0xDAB2, 0xDD8B, 0xE039, 0xE2AE, 
	0xE4D8, 0xE6A7, 0xE80C, 0xE8E7, 0xE93C, 0xE930, 0xE8E7, 0xE886, 0xE831, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE7C8, 0xE729, 0xE673, 0xE5EA, 0xE5D3, 0xE673, 0xE80C, 
	0xED63, 0xF61A, 0xFDC8, 0x0000, 0xFC71, 0xF5B0, 0xE927, 0xDAFD, 0xCF59, 
	0xCA60, 0xCA2B, 0xCA0B, 0xC9FB, 0xC9F5, 0xC9F4, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0003, 0x0009, 0x000A, 0xFFFF, 0xFFE8, 0xFFC7, 
	0xFF9F, 0xFF71, 0xFF3F, 0xFF09, 0xFED1, 0xFE9A, 0xFE63, 0xFE2F, 0xFDFE, 
	0xFDD3, 0xFDAF, 0xFD92, 0xFD80, 0xFD78, 0xFD7D, 0x008A, 0x07B9, 0x1046, 
	0x176E, 0x1A6E, 0xEF6E, 0x90D7, 0x323F, 0x0740, 0x0872, 0x087C, 0x044D, 
	0xFCC5, 0xF75B, 0xFE5F, 0xFE93, 0xFED0, 0xFF76, 0x006C, 0x0195, 0x02D8, 
	0x041B, 0x0544, 0x0639, 0x06DF, 0x071C, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF99B, 0xF9D0, 0xF9DB, 0xF97B, 0xF8CE, 0xF81F, 0xF76D, 
	0xF6B8, 0xF600, 0xF546, 0xF488, 0xF3C7, 0xF303, 0xF23C, 0xF171, 0xF0A3, 
	0xEFD2, 0xEEFD, 0xEE25, 0xED48, 0xEC68, 0xE959, 0xE499, 0xDF84, 0xDB78, 
	0xD9D1, 0xDAD3, 0xDD0A, 0xDF40, 0xE042, 0xDF3B, 0xDF0A, 0xE1DC, 0xE755, 
	0xEBE6, 0xEAC2, 0xEB60, 0xEC09, 0xEDD5, 0xF07B, 0xF3B2, 0xF732, 0xFAB2, 
	0xFDE9, 0x0090, 0x025C, 0x0306, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xEDAA, 0xEDDD, 0xEDE8, 0xED8B, 0xECE1, 0xEC31, 0xEB79, 0xEABC, 
	0xE9FA, 0xE934, 0xE869, 0xE79C, 0xE6CC, 0xE5FB, 0xE529, 0xE457, 0xE385, 
	0xE2B5, 0xE1E7, 0xE11B, 0xE053, 0xDD4B, 0xD882, 0xD35C, 0xCF3F, 0xCD91, 
	0xCF35, 0xD2E4, 0xD6C0, 0xD8E9, 0xD924, 0xDA49, 0xDFE5, 0xE8CB, 0xEE20, 
	0xDF52, 0xDF49, 0xE07F, 0xE3C9, 0xE8A2, 0xEE84, 0xF4EC, 0xFB53, 0x0137, 
	0x0610, 0x0959, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC15E, 0xC142, 0xC13C, 0xC170, 0xC1D3, 0xC244, 0xC2BF, 
	0xC342, 0xC3CA, 0xC455, 0xC4E0, 0xC568, 0xC5EB, 0xC665, 0xC6D6, 0xC739, 
	0xC78C, 0xC7C5, 0xC7E0, 0xC7E3, 0xC7D7, 0xC7C1, 0xC7A8, 0xC794, 0xC78C, 
	0xC78F, 0xC796, 0xC79E, 0xC7A3, 0xC7A4, 0xC79E, 0xC78C, 0xC75B, 0xC705, 
	0xC69F, 0xC62D, 0xC5AB, 0xC51F, 0xC48D, 0xC3FA, 0xC36B, 0xC2E4, 0xC26B, 
	0xC204, 0xC1B5, 0xC182, 0xC170, 0xFF42, 0xFF32, 0xFF23, 0xFF42, 0xFD7F, 
	0xFBEA, 0x00E0, 0x0CEC, 0x19BC, 0x22F0, 0x2CE5, 0x3ADD, 0x4B9E, 0x5CCF, 
	0x6C19, 0x7724, 0x7D1D, 0x81E1, 0x859B, 0x887D, 0x8ABA, 0x8B80, 0x8A59, 
	0x87F7, 0x850D, 0x81EF, 0x7FD2, 0x7FD5, 0x7FE7, 0x8018, 0x0078, 0x0115, 
	0x078C, 0x92C3, 0x98BA, 0x9363, 0x925C, 0x928A, 0x9272, 0x922E, 0x91D7, 
	0x9188, 0x915B, 0x9167, 0x91C9, 0x9298, 0x93EF, 0x95E7, 0x989B, 0x9C23, 
	0xA19D, 0xA99A, 0xB361, 0xBE3A, 0xC96E, 0xD444, 0xDE05, 0xE5F7, 0xEBCD, 
	0xF015, 0xF361, 0xF644, 0xF952, 0xFD1D, 0x0239, 0x10BB, 0x223A, 0x2186, 
	0x0DE8, 0xF554, 0xE466, 0xD6D7, 0x4C48, 0x4459, 0x3EAA, 0x3ADA, 0x388A, 
	0x375A, 0x36EA, 0x36DA, 0x2D41, 0x2D42, 0x2D43, 0x2D41, 0x2D51, 0x2D5D, 
	0x2D1D, 0x2C69, 0x2B18, 0x29BA, 0x2919, 0x2920, 0x294B, 0x29C0, 0x2AA3, 
	0x2C1B, 0x2F0B, 0x320A, 0x349F, 0x364C, 0x3695, 0x34C9, 0x311B, 0x2C6A, 
	0x2796, 0x2540, 0x22C6, 0x2348, 0x249F, 0x2686, 0x5746, 0x550C, 0x5312, 
	0x2E58, 0x2EE3, 0x2A6D, 0x2A60, 0x2A6A, 0x2A84, 0x2AAA, 0x2AD6, 0x2B04, 
	0x2B2E, 0x2B51, 0x2B66, 0x2B69, 0x2B55, 0x2B26, 0x2AD6, 0x2A60, 0x297C, 
	0x2809, 0x263A, 0x2445, 0x225D, 0x20B9, 0x1F8B, 0x1F09, 0x1F91, 0x2115, 
	0x232A, 0x2566, 0x275E, 0x28A6, 0x28D5, 0x26EB, 0x2437, 0x23BF, 0x2691, 
	0x2B01, 0x2B03, 0x2B05, 0x54F9, 0x54F7, 0x54F7, 0x54F6, 0x54F6, 0x54F6, 
	0x54F5, 0x932B, 0x9356, 0x9382, 0x932B, 0x8FBD, 0x8BCD, 0x8E9B, 0x98CA, 
	0xA1D1, 0xA9F1, 0xB4A3, 0xC43B, 0xD667, 0xE7AF, 0xF499, 0xF9AD, 0x007C, 
	0x0636, 0x0ACA, 0x0E28, 0x1042, 0x0FE8, 0x0CC1, 0x07FC, 0x02C8, 0x04F2, 
	0x021C, 0x04B8, 0x0B05, 0x12B7, 0x9984, 0x9D21, 0x9E03, 0x1E57, 0x1E62, 
	0x141A, 0x14E8, 0x1517, 0x14E4, 0x1468, 0x13BB, 0x12F5, 0x1230, 0x1184, 
	0x110A, 0x10D9, 0x110C, 0x11B9, 0x12FA, 0x14E8, 0x1792, 0x1B07, 0x1F5D, 
	0x24A8, 0x2B00, 0x3279, 0x3B28, 0x4524, 0x516D, 0x6061, 0x7122, 0x82D5, 
	0x9497, 0xA58D, 0xB4DA, 0xC664, 0xD529, 0xD2F1, 0xC0E1, 0xAA5F, 0xA538, 
	0xA118, 0x1DE2, 0x1B78, 0x19BD, 0x1894, 0x17E0, 0x1783, 0x1761, 0x175C, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC758, 
	0xC6D4, 0xC7DC, 0xCAA7, 0xCE28, 0xD20F, 0xD606, 0xD9BC, 0xDCDD, 0xDF16, 
	0xE057, 0xE0E8, 0xE0F0, 0xE09C, 0xE015, 0xDF84, 0xDF16, 0xDEA7, 0xDE07, 
	0xDD47, 0xDC7B, 0xDBB5, 0xDB06, 0xDA4C, 0xD986, 0xD8FD, 0xD8F9, 0xDAED, 
	0xDD0C, 0xDD6E, 0xDD63, 0xDD2D, 0xDD0C, 0xDD13, 0xDD26, 0xDD41, 0xDD61, 
	0xDD82, 0xDDA0, 0xDDB9, 0xDDC8, 0xDDCB, 0xDDBC, 0xDD9A, 0xDD61, 0xDD0C, 
	0xDC90, 0xDBE6, 0xDB11, 0xDA14, 0xD8F4, 0xD7B5, 0xD65A, 0xD4E6, 0xD2DA, 
	0xD004, 0xCCDD, 0xC9DF, 0xC786, 0xC649, 0xC6A4, 0xCE00, 0xDA91, 0xE1F9, 
	0xE281, 0xE195, 0xDB90, 0xD6BF, 0xD2FE, 0xD02C, 0xCE27, 0xCCCC, 0xCBF9, 
	0xCB8D, 0xCB66, 0xCB60, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFE4, 0xFF9B, 0xFF32, 0xFEB7, 0xFE37, 
	0xFDC0, 0xFD60, 0xFD25, 0xFD1C, 0xFD52, 0xFDD7, 0xFEB7, 0xFFFF, 0x0248, 
	0x05D9, 0x0A4C, 0x0F3A, 0x143A, 0x18E7, 0x1CD9, 0x1FA9, 0x2160, 0x225E, 
	0x22B9, 0x228A, 0x21E8, 0x20EA, 0x1FA9, 0x1C01, 0x163D, 0x1215, 0x0FF4, 
	0x0DD0, 0x0B62, 0x08CF, 0x062D, 0x0396, 0x0122, 0xFEE9, 0xFD04, 0xFB8C, 
	0xFA98, 0xFA42, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFF8, 0xFFE4, 0xFFC6, 0xFFA4, 0xFF81, 0xFF60, 
	0xFF45, 0xFF35, 0xFF32, 0xFF41, 0xFF66, 0xFFA4, 0xFFFF, 0x00A2, 0x01A0, 
	0x02DC, 0x043A, 0x059E, 0x06EA, 0x0803, 0x08CB, 0x093D, 0x0972, 0x0977, 
	0x095A, 0x092B, 0x08F6, 0x08CB, 0x0884, 0x0808, 0x0775, 0x06D1, 0x0617, 
	0x055E, 0x04AD, 0x0408, 0x0371, 0x02EB, 0x0277, 0x0219, 0x01D2, 0x01A6, 
	0x0197, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF551, 0xF569, 0xF58C, 0xF5B5, 0xF5DF, 0xF606, 0xF626, 
	0xF639, 0xF63C, 0xF62A, 0xF5FE, 0xF5B5, 0xF548, 0xF488, 0xF35B, 0xF1E3, 
	0xF044, 0xEE9D, 0xED13, 0xEBC6, 0xEAD9, 0xEA51, 0xEA13, 0xEA0D, 0xEA2E, 
	0xEA67, 0xEAA5, 0xEAD9, 0xEB2D, 0xEBBF, 0xEC6F, 0xED31, 0xF49E, 0xF51C, 
	0xF671, 0xF867, 0xFAC9, 0xFD61, 0xFFF9, 0x025B, 0x0452, 0x05A7, 0x0624, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xEA48, 
	0xEA71, 0xEAD5, 0xEB54, 0xEBB2, 0xEC2B, 0xED56, 0xEF4F, 0xF1AA, 0xF437, 
	0xF6C3, 0xF91D, 0xFB12, 0xFC71, 0xFD49, 0xFDCE, 0xFDFE, 0xFDDB, 0xFD65, 
	0xFC9B, 0xFB7F, 0xF9C5, 0xF751, 0xF46D, 0xF15F, 0xEE73, 0xEBF0, 0xE9ED, 
	0xE83E, 0xE6C5, 0xE562, 0xE42D, 0xE3A8, 0xE3DB, 0xE456, 0xE4E8, 0xE562, 
	0xE5BF, 0xE61B, 0xE675, 0xE6CD, 0xE724, 0xE779, 0xE7CD, 0xE81E, 0xE86F, 
	0xE899, 0xE8A5, 0xE8D4, 0xE968, 0xEA3E, 0xEB10, 0xEBEC, 0xECE1, 0xEDFC, 
	0xEF4C, 0xF0DF, 0xF2C3, 0xF550, 0xF89B, 0xFC4E, 0x0013, 0x0393, 0x0678, 
	0x086D, 0x0755, 0x0390, 0x0084, 0x0230, 0xFB05, 0xFB1E, 0xFB64, 0xFBCB, 
	0xFC48, 0xFCD0, 0xFD58, 0xFDD5, 0xFE3C, 0xFE81, 0xFE9B, 0xF262, 0xF21D, 
	0xF17C, 0xF0C3, 0xEF6B, 0xEDFA, 0xEE4D, 0xF0A6, 0xF3CD, 0xF765, 0xFB13, 
	0xFE7C, 0x0142, 0x030B, 0x03AF, 0x0370, 0x0296, 0x0169, 0x002F, 0xFF31, 
	0xFEB4, 0xFF01, 0xFFE6, 0x00FC, 0x01D9, 0x0213, 0x0143, 0xFE27, 0xF901, 
	0xF3AA, 0xEFFB, 0xF154, 0xF3CD, 0xF354, 0xF238, 0xF0F3, 0xEFFB, 0xEF56, 
	0xEEBB, 0xEE27, 0xED9B, 0xED16, 0xEC96, 0xEC1D, 0xEBA9, 0xEB39, 0xEAF7, 
	0xEAE5, 0xEAC9, 0xEA67, 0xE993, 0xE867, 0xE710, 0xE5BB, 0xE497, 0xE3D0, 
	0xE394, 0xE410, 0xE594, 0xE817, 0xEB45, 0xEEC7, 0xF249, 0xF574, 0xF7F4, 
	0xF8F5, 0xF8BB, 0xF890, 0xF91B, 0xF999, 0xF6FD, 0xF4E6, 0xF346, 0xF20D, 
	0xF12D, 0xF097, 0xF03B, 0xF00D, 0xEFFB, 0xEFF9, 0x8A9D, 0x8A22, 0x88FB, 
	0x8799, 0x83D7, 0x7FD9, 0x827F, 0x8CFC, 0x9AE0, 0xAA88, 0xBA50, 0xC895, 
	0xD3B3, 0xDA06, 0xDA6F, 0xD601, 0xCE69, 0xC555, 0xBC6F, 0xB566, 0xB1E5, 
	0xB2DD, 0xB71F, 0xBD26, 0xC36F, 0xC875, 0xCAB4, 0xC88F, 0xC2ED, 0xBC0F, 
	0xB634, 0xB2D7, 0xB1BD, 0xB2F7, 0xB578, 0xB7F4, 0xB91D, 0xB903, 0xB89E, 
	0xB7FC, 0xB72E, 0xB643, 0xB54A, 0xB453, 0xB36C, 0xB2A6, 0xB229, 0xB1D2, 
	0xB145, 0xB021, 0xAEB0, 0xAD63, 0xAC12, 0xAA97, 0xA8C9, 0xA683, 0xA39D, 
	0x9FF0, 0x9AA7, 0x9392, 0x8B87, 0x835B, 0x7BE3, 0x75F6, 0x7269, 0x75EE, 
	0x8052, 0x8B0F, 0x955E, 0x9BC3, 0x9538, 0x8FFB, 0x8BE6, 0x88D5, 0x86A3, 
	0x852A, 0x8445, 0x83D0, 0x83A4, 0x839E, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x2537, 0x2584, 0x25D1, 0x2537, 
	0x22AE, 0x1F3D, 0x1D11, 0x1CA3, 0x1CCE, 0x1D4B, 0x1DD6, 0x1E28, 0x1DFE, 
	0x1D11, 0x1B05, 0x17FA, 0x1462, 0x10B0, 0x0D59, 0x0ACD, 0x0982, 0x09DA, 
	0x0B96, 0x0E35, 0x1134, 0x1413, 0x1650, 0x17E3, 0x1927, 0x1A2D, 0x1B07, 
	0x1B3A, 0x1B07, 0x1B18, 0x1B35, 0x1B3B, 0x1B07, 0x1AA4, 0x1A33, 0x19B8, 
	0x1935, 0x18AD, 0x1822, 0x1797, 0x170F, 0x168C, 0x1611, 0x15A1, 0x153E, 
	0x14EB, 0x142F, 0x12D7, 0x114C, 0x0FF7, 0x0F40, 0x0F90, 0x1151, 0x14EB, 
	0x1B55, 0x2497, 0x2FB4, 0x3BAD, 0x4785, 0x523E, 0x5ADB, 0x5B2C, 0x55F2, 
	0x50DE, 0x4B62, 0x43B0, 0x43DC, 0x4456, 0x4509, 0x45E2, 0x46CF, 0x47BB, 
	0x4895, 0x4948, 0x49C1, 0x49EE, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x000F, 0x0036, 0x0066, 0x0092, 0x00AB, 0x00A4, 0x006F, 0x0000, 0xFF2E, 
	0xFDF9, 0xFC87, 0xFB00, 0xF98A, 0xF84E, 0xF771, 0xF86A, 0xFA69, 0xFBB7, 
	0xF903, 0xF8E3, 0xF88F, 0xF84C, 0xF818, 0xF7F0, 0xF7D4, 0xF7C1, 0xF7B6, 
	0xF7B0, 0xF7AE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0x0009, 0x001F, 0x0037, 
	0x004B, 0x0051, 0x0042, 0x0015, 0xFF2B, 0xFDCD, 0xFCA0, 0xFB70, 0xFB05, 
	0xFB43, 0xFBEE, 0xFCE9, 0xFE19, 0xFF65, 0x00B1, 0x01E2, 0x02DD, 0x0387, 
	0x03C6, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBEA2, 0xBE04, 0xBF3F, 0xC2CC, 
	0xC77F, 0xCCBD, 0xD1EA, 0xD66A, 0xD9A1, 0xDAF4, 0xD9AE, 0xD61F, 0xD12E, 
	0xCBC3, 0xC6C5, 0xC31D, 0xC1B1, 0xC336, 0xC71E, 0xCC6D, 0xD228, 0xD754, 
	0xDAF4, 0xDC5F, 0xDC37, 0xDB6D, 0xDAF4, 0xDAF4, 0xDAF4, 0xDAF0, 0xDAEB, 
	0xDAE9, 0xDAF4, 0xDB08, 0xDB1E, 0xDB37, 0xDB51, 0xDB6C, 0xDB88, 0xDBA4, 
	0xDBBF, 0xDBD9, 0xDBF2, 0xDC08, 0xDC1C, 0xDC2D, 0xDC5C, 0xDCB8, 0xDD24, 
	0xDD83, 0xDDB6, 0xDDA2, 0xDD29, 0xDC2D, 0xDAA8, 0xD8AF, 0xD648, 0xD37C, 
	0xD052, 0xCCD2, 0xC904, 0xC1D9, 0xB8A7, 0xB107, 0xA99A, 0xA758, 0xA777, 
	0xA7C9, 0xA842, 0xA8D5, 0xA975, 0xAA15, 0xAAA9, 0xAB22, 0xAB74, 0xAB92, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xC017, 
	0xC0D1, 0xBF5E, 0xB8D9, 0xB028, 0xABD0, 0xACDA, 0xAF8C, 0xB340, 0xB754, 
	0xBB22, 0xBE07, 0xBF5E, 0xBED0, 0xBCD1, 0xB9F0, 0xB6BB, 0xB3C0, 0xB18E, 
	0xB0B3, 0xB195, 0xB3DA, 0xB6EF, 0xBA43, 0xBD43, 0xBF5E, 0xC031, 0xC01A, 
	0xBFA4, 0xBF5E, 0x160A, 0x1561, 0x140E, 0x1310, 0x12F2, 0x1328, 0x1310, 
	0x129B, 0x1220, 0x1198, 0x10FE, 0x104C, 0x0F7C, 0x0E89, 0x0D42, 0x0BA0, 
	0x09D0, 0x0806, 0x0670, 0x0540, 0x04A6, 0x0507, 0x0654, 0x0815, 0x09D2, 
	0x0B13, 0x0B5E, 0x09C7, 0x069F, 0x034E, 0x013A, 0x030E, 0x056C, 0x04F5, 
	0x03C9, 0x0285, 0x01C2, 0x018D, 0x0181, 0x0190, 0x01AF, 0x01D1, 0x01E9, 
	0x01EC, 0x01CD, 0x017F, 0x00F8, 0x003F, 0xFF61, 0xFE6A, 0xFD66, 0xFC63, 
	0xFB6E, 0xFA91, 0xF9DB, 0xF958, 0xF915, 0xF91D, 0xF9D3, 0xFB5C, 0xFD6E, 
	0xFFC0, 0x0206, 0x03F7, 0x0548, 0x057D, 0x04BF, 0x03BB, 0x031D, 0x0B95, 
	0x0B4E, 0x0A8F, 0x0975, 0x081F, 0x06AA, 0x0536, 0x03DF, 0x02C5, 0x0206, 
	0x01C0, 0x1789, 0x1810, 0x191D, 0x19E7, 0x1A3B, 0x1A4C, 0x19E7, 0x190A, 
	0x17EA, 0x16A8, 0x1568, 0x144B, 0x1373, 0x1303, 0x1314, 0x1393, 0x1458, 
	0x153E, 0x161D, 0x16D0, 0x1730, 0x1725, 0x16CA, 0x1643, 0x15B7, 0x154B, 
	0x1525, 0x157D, 0x1638, 0x1706, 0x1792, 0x1763, 0x170A, 0x171B, 0x1744, 
	0x1771, 0x178B, 0x1794, 0x179B, 0x17A0, 0x17A3, 0x17A4, 0x17A3, 0x179F, 
	0x1798, 0x178F, 0x1787, 0x1783, 0x1782, 0x1781, 0x177F, 0x1779, 0x176F, 
	0x175D, 0x1743, 0x171F, 0x16EE, 0x16AF, 0x163C, 0x1586, 0x14AB, 0x13CC, 
	0x1309, 0x1281, 0x1254, 0x12C6, 0x13E0, 0x156B, 0x1732, 0x18E8, 0x18B3, 
	0x1825, 0x1752, 0x1653, 0x153D, 0x1427, 0x1328, 0x1256, 0x11C7, 0x1192, 
	0xA1EE, 0xA0C6, 0x9E75, 0x9CB8, 0x9B6E, 0x9AB7, 0x9CB8, 0xA1CB, 0xA85B, 
	0xAFAA, 0xB6FA, 0xBD8D, 0xC2A5, 0xC584, 0xC59A, 0xC361, 0xBFA7, 0xBB3B, 
	0xB6EC, 0xB388, 0xB1DE, 0xB299, 0xB533, 0xB8AE, 0xBC11, 0xBE5E, 0xBE9B, 
	0xB84C, 0xAD9A, 0xA749, 0xA64D, 0xA75E, 0xA875, 0xA8D8, 0xA956, 0xA9CA, 
	0xAA1D, 0xAA85, 0xAAFF, 0xAB80, 0xABF8, 0xAC5C, 0xAC9E, 0xACB0, 0xAC85, 
	0xAC10, 0xAB6E, 0xAAC1, 0xAA04, 0xA930, 0xA83F, 0xA72D, 0xA5F1, 0xA488, 
	0xA2EA, 0xA112, 0x9EFA, 0x9C9C, 0x9962, 0x9504, 0x8FE8, 0x8A7A, 0x8520, 
	0x8046, 0x7C51, 0x79AB, 0x783A, 0x77A9, 0x77A4, 0x8A65, 0x88B5, 0x875C, 
	0x864E, 0x8584, 0x84F3, 0x8491, 0x8456, 0x8438, 0x842D, 0x842B, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x1E4A, 0x1E4A, 0x1E4A, 0x1E4A, 0x1DF8, 0x1DA7, 0x1E4A, 
	0x202B, 0x22B6, 0x258E, 0x2853, 0x2AA9, 0x2C30, 0x2C8C, 0x2B3E, 0x2870, 
	0x24BF, 0x20C9, 0x1D29, 0x1A7F, 0x1966, 0x1A5B, 0x1D00, 0x20AA, 0x24B0, 
	0x2868, 0x2B26, 0x2C9F, 0x2D42, 0x2D7F, 0x2DC5, 0x2DE1, 0x2DC5, 0x2DFD, 
	0x2E59, 0x2E6C, 0x2DC5, 0x2C68, 0x2AB6, 0x28CB, 0x26C3, 0x24B9, 0x22C9, 
	0x2111, 0x1FAA, 0x1EB2, 0x1E25, 0x1DE3, 0x1DDF, 0x1E07, 0x1E4F, 0x1EA6, 
	0x1EFD, 0x1F47, 0x1F73, 0x1F73, 0x1F37, 0x1EB2, 0x1D43, 0x1ABA, 0x17A9, 
	0x14A4, 0x1240, 0x1110, 0x11A8, 0x1513, 0x1BB6, 0x2532, 0x3126, 0x4AF7, 
	0x4AF1, 0x4AE0, 0x4AC9, 0x4AAB, 0x4A8C, 0x4A6C, 0x4A4F, 0x4A37, 0x4A27, 
	0x4A21, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0002, 0x0005, 0xFFFF, 0xFFF1, 
	0xFFDD, 0xFFC7, 0xFFB1, 0xFF9E, 0xFF91, 0xFF8C, 0xFF92, 0xFFA2, 0xFFB7, 
	0xFFCF, 0xFFE5, 0xFFF6, 0xFFFC, 0xFFF3, 0xFFDE, 0xFFC2, 0xFFA7, 0xFF93, 
	0xFF8C, 0xFF9E, 0xFFC5, 0xFFF2, 0x0013, 0x0019, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0017, 0x0021, 0x002B, 0x0033, 
	0x0035, 0x002B, 0x0013, 0xFFE1, 0xFF91, 0xFF28, 0xFEAC, 0xFB05, 0xFB6F, 
	0xFC8F, 0xFE37, 0x003B, 0x026C, 0x049D, 0x06A0, 0x0849, 0x0969, 0x09D3, 
	0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2E, 0xFF2D, 0xFF2F, 0xFF33, 0xFF39, 
	0xFF40, 0xFF47, 0xFF4D, 0xFF51, 0xFF52, 0xFF50, 0xFF4B, 0xFF43, 0xFF3C, 
	0xFF35, 0xFF30, 0xFF2F, 0xFF33, 0xFF3D, 0xFF48, 0xFF54, 0xFF5D, 0xFF60, 
	0xFF5A, 0xFF4C, 0xFF3C, 0xFF30, 0xFF2E, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF32, 0xFF36, 0xFF3A, 0xFF3E, 0xFF3E, 
	0xFF3A, 0xFF30, 0xFF1F, 0xFF03, 0xFED7, 0xFE95, 0xFC71, 0xFC7D, 0xFCA0, 
	0xFCD2, 0xFD0F, 0xFD52, 0xFD94, 0xFDD1, 0xFE04, 0xFE26, 0xFE32, 0xC9D7, 
	0xC9D7, 0xC9D7, 0xC9D7, 0xC94E, 0xC8C6, 0xC9D7, 0xCCEF, 0xD10C, 0xD5A3, 
	0xDA28, 0xDE11, 0xE0D3, 0xE1E2, 0xE094, 0xDD2C, 0xD883, 0xD371, 0xCECF, 
	0xCB76, 0xCA3F, 0xCC47, 0xD120, 0xD756, 0xDD76, 0xE20A, 0xE39E, 0xDFB5, 
	0xD725, 0xCD75, 0xC62C, 0xC4F2, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC62C, 0xC62C, 0xC635, 0xC648, 0xC65F, 0xC670, 0xC672, 0xC65F, 
	0xC62C, 0xC62A, 0xC62C, 0xC571, 0xC337, 0xADE1, 0xAD4E, 0xACD9, 0xAC7D, 
	0xAC38, 0xAC06, 0xABE5, 0xABD1, 0xABC7, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x004F, 0x0001, 0x0050, 0x0050, 0x0001, 0x00A0, 0x0001, 
	0x00A1, 0x0001, 0x00A2, 0x0050, 0x00A3, 0x0050, 0x00F3, 0x0050, 0x0143, 
	0x0050, 0x0193, 0x0050, 0x01E3, 0x0050, 0x0233, 0x0050, 0x0283, 0x0050, 
	0x02D3, 0x0050, 0x0323, 0x0001, 0x0373, 0x0001, 0x0374, 0x0001, 0x0375, 
	0x0050, 0x0376, 0x0050, 0x03C6, 0x0050, 0x0416, 0x004F, 0x0466, 0x0050, 
	0x04B5, 0x0050, 0x0505, 0x0050, 0x0555, 0x0050, 0x05A5, 0x0050, 0x05F5, 
	0x0001, 0x0645, 0x0001, 0x0646, 0x0050, 0x0647, 0x0050, 0x0697, 0x004F, 
	0x06E7, 0x0050, 0x0736, 0x0050, 0x0786, 0x004D, 0x07D6, 0x0050, 0x0823, 
	0x0050, 0x0873, 0x0050, 0x08C3, 0x0050, 0x0913, 0x0050, 0x0963, 0x0050, 
	0x09B3, 0x0001, 0x0A03, 0x0050, 0x0A04, 0x0050, 0x0A54, 0x0050, 0x0AA4, 
	0x000B, 0x0AF4, 0x004F, 0x0AFF, 0x0050, 0x0B4E, 0x004F, 0x0B9E, 0x0050, 
	0x0BED, 0x0050, 0x0C3D, 0x0050, 0x0C8D, 0x0050, 0x0CDD, 0x001F, 0x0D2D, 
	0x0050, 0x0D4C, 0x0050, 0x0D9C, 0x0050, 0x0DEC, 0x0019, 0x0E3C, 0x004D, 
	0x0E55, 0x0050, 0x0EA2, 0x0050, 0x0EF2, 0x0050, 0x0F42, 0x004F, 0x0F92, 
	

});

smlua_anim_util_register_animation('donkey_0F_skid_on_ground',1, 0, 0, 0, 1, { 
	0x0000, 0x007C, 0x007C, 0x007D, 0x007D, 0x007E, 0x007F, 0x0080, 0x0081, 
	0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 
	0xFFDD, 0xFFDD, 0xFFDE, 0xFFE0, 0xFFE1, 0xFFE4, 0xFFE6, 0xFFE9, 0xFFEC, 
	0xFFEF, 0xFFF1, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFFC, 0xFFFD, 0xFFFF, 0x0000, 
	0x0000, 0x3FFF, 0x0000, 0x2475, 0x241F, 0x2329, 0x21A9, 0x1FB3, 0x1D5A, 
	0x1AB3, 0x17D3, 0x14CE, 0x11B8, 0x0EA5, 0x0BAB, 0x08DC, 0x064E, 0x0414, 
	0x0244, 0x00F1, 0x0030, 0xFFFF, 0xFA1D, 0xFA2C, 0xFA58, 0xFA9B, 0xFAF3, 
	0xFB5B, 0xFBD1, 0xFC50, 0xFCD4, 0xFD5B, 0xFDDF, 0xFE5E, 0xFED4, 0xFF3D, 
	0xFF94, 0xFFD8, 0x0004, 0x0013, 0xFFFE, 0x3A1E, 0x3A67, 0x3B35, 0x3C78, 
	0x3E1C, 0x4010, 0x4242, 0x44A2, 0x471B, 0x499E, 0x4C18, 0x4E77, 0x50AA, 
	0x529E, 0x5442, 0x5584, 0x5652, 0x569B, 0x5675, 0x0000, 0xFFFF, 0xFE8E, 
	0xFB15, 0xF6E1, 0xF33B, 0xF16E, 0xF438, 0xF9B2, 0xFC32, 0xF8E4, 0xF2CF, 
	0xED0F, 0xEF02, 0xF3A9, 0xF936, 0xFDDD, 0xFFD1, 0x0000, 0x06ED, 0x06ED, 
	0x0761, 0x088C, 0x0A25, 0x0BE2, 0x0D79, 0x0F9D, 0x120D, 0x1316, 0x1238, 
	0x1065, 0x0E12, 0x0B4E, 0x0851, 0x0566, 0x02D2, 0x00E0, 0x0000, 0x0CFE, 
	0x0CFE, 0x0D78, 0x0EC3, 0x10AD, 0x1305, 0x1599, 0x1A4C, 0x2054, 0x2374, 
	0x225A, 0x1F41, 0x1B4E, 0x163D, 0x1090, 0x0B18, 0x06A9, 0x0416, 0x039F, 
	0xE0E9, 0xE0E9, 0xE0D4, 0xE0DF, 0xE17C, 0xE31D, 0xE633, 0xEB46, 0xF20B, 
	0xF9BA, 0x0189, 0x08AF, 0x0E63, 0x0D4C, 0x0A93, 0x0710, 0x0396, 0x00FB, 
	0x0000, 0xF9D4, 0xF9D4, 0xFAE9, 0xFD8A, 0x00C3, 0x03A5, 0x053D, 0x0590, 
	0x055D, 0x04C8, 0x03FA, 0x0318, 0x0249, 0x0157, 0x0053, 0xFF65, 0xFEB8, 
	0xFE75, 0x0000, 0x02C2, 0x02C2, 0x0287, 0x01F1, 0x012E, 0x0068, 0xFFCB, 
	0xFF52, 0xFEDA, 0xFE66, 0xFDF8, 0xFD92, 0xFD37, 0xFCE9, 0xFC05, 0xF9BB, 
	0xF53B, 0xEDB5, 0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xDFFF, 0xDFFF, 0xDFBF, 
	0xDF3D, 0xDEDB, 0xDEFB, 0xDFFF, 0xE1DD, 0xE435, 0xE6E9, 0xE9D8, 0xECE5, 
	0xEFEE, 0xF839, 0x048B, 0x1183, 0x1BC4, 0x1FEE, 0x19C6, 0xECD8, 0xECD8, 
	0xEA14, 0xE363, 0xDB2F, 0xD3E2, 0xCFE7, 0xCEAF, 0xCE03, 0xCDCC, 0xCDF7, 
	0xCE6D, 0xCF19, 0xD0E6, 0xD385, 0xD644, 0xD86D, 0xD94E, 0xDC99, 0xE269, 
	0xE269, 0xE2B1, 0xE34F, 0xE3EE, 0xE43A, 0xE3DD, 0xE2E4, 0xE1A0, 0xE024, 
	0xDE81, 0xDCCB, 0xDB14, 0xD9EE, 0xD806, 0xD37B, 0xCA6F, 0xBB01, 0xBCE3, 
	0xFFFF, 0xFFFE, 0xFFFD, 0xFFFB, 0xFFF8, 0xFFF4, 0xFFF0, 0xFFEC, 0xFFE7, 
	0xFFE3, 0xFFDE, 0xFFDA, 0xFFD6, 0xFFD2, 0xFFCF, 0xFFCD, 0xFFCC, 0xFFCB, 
	0xFFFF, 0xFFFF, 0x0006, 0x0018, 0x0033, 0x0057, 0x0081, 0x00B1, 0x00E4, 
	0x011A, 0x0150, 0x0186, 0x01B9, 0x01E9, 0x0213, 0x0237, 0x0252, 0x0264, 
	0x026A, 0x0000, 0xC484, 0xC484, 0xC69F, 0xCBAA, 0xD1BC, 0xD6EA, 0xD94B, 
	0xD948, 0xD8A7, 0xD786, 0xD602, 0xD43B, 0xD24F, 0xD13E, 0xD0BB, 0xD011, 
	0xCE8B, 0xCB72, 0xCC9F, 0xFF89, 0xFF89, 0xFF88, 0xFF86, 0xFF85, 0xFF85, 
	0xFF89, 0xFF92, 0xFF9C, 0xFFA8, 0xFFB4, 0xFFC2, 0xFFCF, 0xFFC8, 0xFF94, 
	0xFF07, 0xFDF5, 0xFC32, 0x04C7, 0xF97F, 0xF97F, 0xF97F, 0xF97F, 0xF97F, 
	0xF97F, 0xF97F, 0xF97F, 0xF97E, 0xF97E, 0xF97D, 0xF97D, 0xF97C, 0xF99C, 
	0xF9E9, 0xFA45, 0xFA92, 0xFAB3, 0x0306, 0xF06E, 0xF06E, 0xF075, 0xF083, 
	0xF08D, 0xF08A, 0xF06E, 0xF03B, 0xEFFB, 0xEFB2, 0xEF61, 0xEF0E, 0xEEBB, 
	0xF142, 0xF747, 0xFE77, 0x047E, 0x0705, 0x0A90, 0xFFFE, 0x0001, 0xC170, 
	0x4CE0, 0x4CE0, 0x4D82, 0x4EC3, 0x4FAA, 0x4F3F, 0x4C88, 0x479C, 0x4170, 
	0x3A56, 0x22A2, 0x05EB, 0xEA52, 0x523E, 0x4016, 0x3575, 0x30CD, 0x2FC5, 
	0x36DA, 0x2C94, 0x2C94, 0x29BD, 0x22F5, 0x1ADD, 0x1411, 0x1131, 0x11AD, 
	0x131A, 0x1548, 0x1E73, 0x2866, 0x306D, 0x4A35, 0x4841, 0x4BC7, 0x5252, 
	0x55D8, 0x54F5, 0x0951, 0x0951, 0x09ED, 0x0B27, 0x0C1E, 0x0BEE, 0x09B7, 
	0x058D, 0x004F, 0xFA43, 0xE60A, 0xC7AE, 0xAC99, 0x190E, 0x1150, 0x111C, 
	0x1118, 0x10E3, 0x175C, 0x0000, 0x000B, 0x002A, 0x005A, 0x009A, 0x00E6, 
	0x013D, 0x019A, 0x01FD, 0x0263, 0x02C8, 0x032B, 0x0389, 0x03DF, 0x042B, 
	0x046B, 0x049B, 0x04BA, 0x04C5, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xC897, 0xC897, 0xCBB0, 0xD314, 
	0xDBE4, 0xE344, 0xE655, 0xE5B2, 0xE404, 0xE1A7, 0xDED0, 0xDBAC, 0xD866, 
	0xD529, 0xD221, 0xCF7A, 0xCD5F, 0xCBFC, 0xCB7B, 0x0000, 0x0000, 0xFFC0, 
	0xFF2A, 0xFE77, 0xFDE0, 0xFDA1, 0xFDAD, 0xFDCE, 0xFE2A, 0xFEBF, 0xFF7A, 
	0x004A, 0x011C, 0x01DE, 0x027E, 0x02EC, 0x0315, 0xFA42, 0x0000, 0xFFFF, 
	0x00FC, 0x0357, 0x0626, 0x0881, 0x097E, 0x094E, 0x08CA, 0x0860, 0x081C, 
	0x07EA, 0x07B7, 0x076C, 0x06F7, 0x0644, 0x053C, 0x03CD, 0x0197, 0xED8B, 
	0xED8B, 0xEA8F, 0xE379, 0xDB15, 0xD42E, 0xD18F, 0xD2A4, 0xD4D6, 0xD919, 
	0xDF45, 0xE6B6, 0xEEC7, 0xF6D2, 0xFE33, 0x0445, 0x0862, 0x09E6, 0x0624, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xBF5E, 0xFFB7, 0xFFB7, 0x0001, 0x0096, 0x0106, 0x00E1, 0xFFB7, 
	0xFC9F, 0xF7D8, 0xF2AE, 0xEE70, 0xEAD4, 0xE6E3, 0xE95A, 0xEF3B, 0xF63E, 
	0xFC1F, 0xFE96, 0xFE9B, 0x0050, 0x0050, 0x009D, 0x0137, 0x01AA, 0x0184, 
	0x0050, 0xFCC4, 0xF740, 0xF1CD, 0xEE72, 0xED1C, 0xEC47, 0xEC96, 0xED53, 
	0xEE35, 0xEEF2, 0xEF42, 0xEFF9, 0x82F6, 0x82F6, 0x82BF, 0x8250, 0x81FC, 
	0x8218, 0x82F6, 0x84F8, 0x8808, 0x8BC8, 0x8FD9, 0x949D, 0x9A5D, 0x9A32, 
	0x9900, 0x95C1, 0x8F70, 0x8506, 0x839E, 0x0000, 0xFFFE, 0xFFFC, 0xFFF8, 
	0xFFF4, 0xFFEE, 0xFFE8, 0xFFE1, 0xFFDA, 0xFFD3, 0xFFCC, 0xFFC5, 0xFFBF, 
	0xFFB9, 0xFFB4, 0xFFB1, 0xFFAE, 0xFFAE, 0x0000, 0xFFFF, 0x0005, 0x0015, 
	0x002C, 0x004B, 0x0070, 0x009A, 0x00C6, 0x00F5, 0x0124, 0x0153, 0x0180, 
	0x01A9, 0x01CE, 0x01ED, 0x0205, 0x0214, 0x021A, 0xFFFF, 0x5730, 0x5730, 
	0x5816, 0x5A1F, 0x5C53, 0x5DB6, 0x5D4C, 0x59D9, 0x53ED, 0x4D48, 0x47A7, 
	0x42B2, 0x3D29, 0x3DDD, 0x3FB7, 0x4251, 0x4545, 0x482C, 0x49EE, 0x011B, 
	0x011B, 0x00EC, 0x008C, 0x0040, 0x004C, 0x00F4, 0x0325, 0x0698, 0x09C2, 
	0x0B1B, 0x0A91, 0x0948, 0x0699, 0x02DD, 0xFECB, 0xFB19, 0xF87D, 0xF792, 
	0xFFC7, 0xFFC7, 0xFF4B, 0xFE23, 0xFCC1, 0xFB98, 0xFB19, 0xFBB9, 0xFD2A, 
	0xFEB4, 0xFFA4, 0xFFF6, 0x0025, 0x00E9, 0x02BC, 0x04EA, 0x06BE, 0x0782, 
	0x03C6, 0xAA71, 0xAA71, 0xAA1E, 0xA968, 0xA8B3, 0xA864, 0xA8DF, 0xAAD7, 
	0xAE0B, 0xB173, 0xB405, 0xB5E4, 0xB7D0, 0xB7B4, 0xB6EC, 0xB4CF, 0xB0B0, 
	0xA9E5, 0xAB92, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x1711, 0x1711, 0x14EE, 0x0FBD, 0x0951, 
	0x0381, 0x0020, 0x0020, 0x0021, 0x0024, 0x0029, 0x0032, 0x003E, 0x0050, 
	0x0068, 0x0087, 0x00AD, 0x00DC, 0x01C0, 0x1373, 0x1373, 0x145A, 0x168F, 
	0x1950, 0x1BDE, 0x1D79, 0x1D3D, 0x1C98, 0x1B9F, 0x1A67, 0x1904, 0x178C, 
	0x1614, 0x14B0, 0x1375, 0x1279, 0x11D1, 0x1192, 0xA1B5, 0xA1B5, 0x9E4A, 
	0x95EC, 0x8B6E, 0x81A6, 0x7B67, 0x7B98, 0x7C21, 0x7CED, 0x7DE9, 0x7F02, 
	0x8025, 0x813E, 0x823B, 0x8307, 0x838F, 0x83C1, 0x842B, 0xFFFF, 0xFFFD, 
	0xFFF9, 0xFFF2, 0xFFE9, 0xFFDF, 0xFFD3, 0xFFC6, 0xFFB8, 0xFFAB, 0xFF9D, 
	0xFF90, 0xFF84, 0xFF7A, 0xFF71, 0xFF6A, 0xFF65, 0xFF64, 0xFFFF, 0x0000, 
	0xFFFB, 0xFFF1, 0xFFE0, 0xFFCA, 0xFFB0, 0xFF93, 0xFF73, 0xFF53, 0xFF31, 
	0xFF10, 0xFEF1, 0xFED4, 0xFEBA, 0xFEA4, 0xFE93, 0xFE89, 0xFE85, 0x0000, 
	0x091A, 0x091A, 0x0EA4, 0x1C48, 0x2D8C, 0x3DF7, 0x4911, 0x492A, 0x493A, 
	0x4943, 0x4947, 0x4948, 0x4948, 0x4949, 0x494D, 0x4956, 0x4966, 0x497F, 
	0x4A21, 0xFF56, 0xFF56, 0xFF5C, 0xFF63, 0xFF54, 0xFF1D, 0xFEA9, 0xFEC6, 
	0xFF14, 0xFF89, 0x001B, 0x00BC, 0x0163, 0x0205, 0x0295, 0x030A, 0x0359, 
	0x0375, 0x09D3, 0xFC90, 0xFC90, 0xFC15, 0xFAEC, 0xF981, 0xF841, 0xF796, 
	0xF7A3, 0xF7C7, 0xF7FD, 0xF840, 0xF88A, 0xF8D7, 0xF921, 0xF963, 0xF999, 
	0xF9BD, 0xF9CA, 0xFE32, 0xBDC4, 0xBDC4, 0xBE6F, 0xC01D, 0xC250, 0xC48C, 
	0xC654, 0xC64F, 0xC62A, 0xC5C7, 0xC505, 0xC3C5, 0xC1E8, 0xBF4F, 0xBBD9, 
	0xB767, 0xB1DB, 0xAB14, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0011, 0x0001, 0x0012, 0x0012, 0x0001, 0x0024, 0x0001, 
	0x0025, 0x0001, 0x0026, 0x0013, 0x0027, 0x0013, 0x003A, 0x0013, 0x004D, 
	0x0013, 0x0060, 0x0013, 0x0073, 0x0013, 0x0086, 0x0013, 0x0099, 0x0013, 
	0x00AC, 0x0013, 0x00BF, 0x0001, 0x00D2, 0x0001, 0x00D3, 0x0001, 0x00D4, 
	0x0013, 0x00D5, 0x0013, 0x00E8, 0x0013, 0x00FB, 0x0013, 0x010E, 0x0013, 
	0x0121, 0x0013, 0x0134, 0x0013, 0x0147, 0x0013, 0x015A, 0x0013, 0x016D, 
	0x0001, 0x0180, 0x0001, 0x0181, 0x0001, 0x0182, 0x0013, 0x0183, 0x0013, 
	0x0196, 0x0013, 0x01A9, 0x0013, 0x01BC, 0x0013, 0x01CF, 0x0013, 0x01E2, 
	0x0013, 0x01F5, 0x0013, 0x0208, 0x0013, 0x021B, 0x0013, 0x022E, 0x0012, 
	0x0241, 0x0001, 0x0253, 0x0013, 0x0254, 0x0013, 0x0267, 0x0013, 0x027A, 
	0x0013, 0x028D, 0x0013, 0x02A0, 0x0013, 0x02B3, 0x0013, 0x02C6, 0x0013, 
	0x02D9, 0x0013, 0x02EC, 0x0013, 0x02FF, 0x0012, 0x0312, 0x0001, 0x0324, 
	0x0013, 0x0325, 0x0013, 0x0338, 0x0013, 0x034B, 0x0013, 0x035E, 0x0013, 
	0x0371, 0x0013, 0x0384, 0x0013, 0x0397, 0x0013, 0x03AA, 0x0013, 0x03BD, 
	

});

smlua_anim_util_register_animation('donkey_1a_shivering_return_to_idle',0, 0, 0, 0, 16, { 
	0x0000, 0x007F, 0x007F, 0x0080, 0x0081, 0x0083, 0x0086, 0x0087, 0x0088, 
	0x0088, 0x0088, 0x0089, 0x0089, 0x0089, 0x0089, 0x008A, 0x008B, 0x0000, 
	0x0000, 0x3FFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFE, 0x40A1, 0x40A3, 0x40B3, 0x40DF, 0x4133, 0x41BF, 
	0x4290, 0x43B3, 0x4537, 0x4745, 0x49D7, 0x4CAF, 0x4F8E, 0x5236, 0x5468, 
	0x55E7, 0x5675, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFB, 
	0x0000, 0xFFFF, 0x0008, 0x000D, 0x000F, 0x0010, 0x0010, 0x000F, 0x000E, 
	0x000D, 0x0017, 0x0030, 0x0052, 0x0077, 0x0099, 0x00B2, 0x00BC, 0x0000, 
	0x1D2F, 0x1DC9, 0x1EC8, 0x1FFB, 0x212E, 0x222C, 0x22C3, 0x22BF, 0x21ED, 
	0x1F1F, 0x1AB6, 0x155E, 0x0FC2, 0x0A8E, 0x066F, 0x0410, 0x039F, 0xE3C5, 
	0xE39D, 0xE461, 0xE5E3, 0xE7F4, 0xEA67, 0xED0C, 0xEFB7, 0xF238, 0xF4D8, 
	0xF78B, 0xFA23, 0xFC75, 0xFE54, 0xFF95, 0x000A, 0x0000, 0xFEA7, 0xFEEE, 
	0xFF46, 0xFFAB, 0x0017, 0x0088, 0x00F7, 0x0163, 0x01C5, 0x01CC, 0x01D1, 
	0x01D5, 0x01D7, 0x01D8, 0x01D8, 0x01D8, 0x0000, 0xF45D, 0xF4C9, 0xF5AA, 
	0xF6EA, 0xF872, 0xFA2C, 0xFC02, 0xFDDD, 0xFFA8, 0xFF9B, 0xFF41, 0xFE4E, 
	0xFC73, 0xF964, 0xF4D4, 0xEE77, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x2C6B, 
	0x2C1F, 0x2C1D, 0x2C42, 0x2C6B, 0x2C75, 0x2C3D, 0x2B9F, 0x2A78, 0x29A2, 
	0x2918, 0x2886, 0x2798, 0x25FB, 0x235A, 0x1F61, 0x19C6, 0xF34A, 0xF2C3, 
	0xF260, 0xF20F, 0xF1BE, 0xF15B, 0xF0D4, 0xF017, 0xEF12, 0xEE58, 0xEDC7, 
	0xECFE, 0xEB9E, 0xE948, 0xE59C, 0xE03A, 0xDC99, 0x9598, 0x9619, 0x9640, 
	0x9637, 0x962A, 0x9645, 0x96B1, 0x979B, 0x992D, 0x9CCD, 0xA22D, 0xA877, 
	0xAED3, 0xB468, 0xB860, 0xB9E2, 0xBCE3, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xC444, 0xC47A, 0xC513, 0xC5FE, 0xC72D, 0xC891, 0xCA1B, 0xCBBB, 
	0xCD63, 0xCF03, 0xD08D, 0xD1F1, 0xD320, 0xD40B, 0xD4A3, 0xD4D9, 0xCC9F, 
	0x0000, 0xFFF3, 0xFFCF, 0xFF99, 0xFF53, 0xFF01, 0xFEA6, 0xFE46, 0xFDE4, 
	0xFD84, 0xFD29, 0xFCD6, 0xFC90, 0xFC5A, 0xFC37, 0xFC2A, 0x04C7, 0xF97B, 
	0xF9AB, 0xFA34, 0xFB06, 0xFC16, 0xFD55, 0xFEB5, 0x002B, 0x01A6, 0x031B, 
	0x047C, 0x05BB, 0x06CA, 0x079D, 0x0825, 0x0855, 0x0306, 0xED8B, 0xEDDA, 
	0xEEB6, 0xF00B, 0xF1C3, 0xF3C7, 0xF602, 0xF85E, 0xFAC5, 0xFD20, 0xFF5B, 
	0x0161, 0x0318, 0x046D, 0x054A, 0x0598, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0xE1D8, 0xE163, 0xE07A, 0xDF4A, 0xDDFE, 0xDCC4, 0xDBC7, 0xDB33, 0xDB34, 
	0xDB22, 0xDAA1, 0xD943, 0xD69B, 0xD239, 0xCBAF, 0x428F, 0x36DA, 0x063D, 
	0x06FE, 0x080F, 0x0966, 0x0AFC, 0x0CC7, 0x0EC0, 0x10DD, 0x1316, 0x169C, 
	0x1B46, 0x2077, 0x2592, 0x29F9, 0x2D11, 0x51C4, 0x54F5, 0x9061, 0x9087, 
	0x90B2, 0x90F9, 0x9170, 0x922F, 0x934B, 0x94D9, 0x96EF, 0x9937, 0x9B7E, 
	0x9DA4, 0x9F88, 0xA10B, 0xA20A, 0x2267, 0x175C, 0x0000, 0x000E, 0x0034, 
	0x0071, 0x00BF, 0x011B, 0x0182, 0x01F1, 0x0263, 0x02D5, 0x0343, 0x03AA, 
	0x0407, 0x0455, 0x0491, 0x04B8, 0x04C5, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xC087, 0xC085, 0xC0B1, 0xC102, 0xC171, 
	0xC1F6, 0xC289, 0xC324, 0xC3BD, 0xC49C, 0xC5BD, 0xC703, 0xC850, 0xC987, 
	0xCA89, 0xCB3A, 0xCB7B, 0x01A1, 0x01A2, 0x0198, 0x0186, 0x016D, 0x0150, 
	0x012F, 0x010D, 0x00EA, 0x00D3, 0x00C3, 0x00B2, 0x0094, 0x0062, 0x0010, 
	0xFF95, 0xFA42, 0xFB47, 0xFB45, 0xFB61, 0xFB96, 0xFBDD, 0xFC33, 0xFC92, 
	0xFCF5, 0xFD58, 0xFD56, 0xFD45, 0xFD17, 0xFCBE, 0xFC2A, 0xFB4F, 0xFA1C, 
	0x0197, 0xEBB8, 0xEBB6, 0xEBEF, 0xEC58, 0xECE9, 0xED97, 0xEE57, 0xEF20, 
	0xEFE8, 0xF262, 0xF673, 0xFB63, 0x007B, 0x0501, 0x083F, 0x097D, 0x0624, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0xEE59, 0xEE90, 0xEF2C, 0xF01D, 0xF153, 0xF2BF, 0xF452, 0xF5FC, 
	0xF7AD, 0xF957, 0xFAEA, 0xFC56, 0xFD8C, 0xFE7D, 0xFF19, 0xFF50, 0xFE9B, 
	0xD7CC, 0xD81E, 0xD904, 0xDA68, 0xDC33, 0xDE4D, 0xE0A1, 0xE316, 0xE598, 
	0xE80D, 0xEA61, 0xEC7C, 0xEE46, 0xEFAA, 0xF090, 0xF0E2, 0xEFF9, 0x9591, 
	0x9590, 0x9585, 0x9566, 0x952B, 0x94C9, 0x9437, 0x936C, 0x925D, 0x9102, 
	0x8F50, 0x8D3D, 0x8AC1, 0x87D2, 0x8466, 0x8073, 0x839E, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x583C, 0x5813, 0x579E, 0x56EA, 0x55FF, 0x54EA, 0x53B5, 0x526A, 
	0x5115, 0x4FBF, 0x4E74, 0x4D3F, 0x4C2A, 0x4B40, 0x4A8B, 0x4A17, 0x49EE, 
	0xFFFF, 0xFFFE, 0xFFFB, 0xFFF0, 0xFFDC, 0xFFBA, 0xFF87, 0xFF41, 0xFEE3, 
	0xFE6B, 0xFDD5, 0xFD1D, 0xFC41, 0xFB3E, 0xFA0E, 0xF8B1, 0xF792, 0x0000, 
	0x0000, 0x0001, 0x0002, 0x0006, 0x000B, 0x0014, 0x001F, 0x002F, 0x0043, 
	0x005B, 0x0079, 0x009E, 0x00C9, 0x00FA, 0x0134, 0x03C6, 0xA997, 0xA9A5, 
	0xA9CC, 0xAA07, 0xAA54, 0xAAAE, 0xAB11, 0xAB7B, 0xABE6, 0xAC4F, 0xACB3, 
	0xAD0D, 0xAD5A, 0xAD95, 0xADBC, 0xADC9, 0xAB92, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0x0924, 0x0924, 0x0922, 0x091C, 0x0912, 0x0900, 0x08E6, 0x08C2, 
	0x0891, 0x0853, 0x0805, 0x07A6, 0x0734, 0x06AE, 0x0611, 0x055C, 0x01C0, 
	0x1D10, 0x1CDB, 0x1C47, 0x1B62, 0x1A3B, 0x18E1, 0x1762, 0x15CC, 0x1430, 
	0x129B, 0x111C, 0x0FC1, 0x0E9A, 0x0DB5, 0x0D21, 0x0CEC, 0x1192, 0x8DDC, 
	0x8DDC, 0x8DD6, 0x8DC7, 0x8DA8, 0x8D77, 0x8D2D, 0x8CC6, 0x8C3C, 0x8B8C, 
	0x8AB0, 0x89A3, 0x8860, 0x86E3, 0x8526, 0x8325, 0x842B, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x5981, 0x5954, 0x58D8, 0x5815, 0x571A, 0x55F0, 0x54A3, 0x5340, 0x51D1, 
	0x5062, 0x4EFE, 0x4DB2, 0x4C88, 0x4B8C, 0x4ACA, 0x4A4D, 0x4A21, 0x008C, 
	0x008C, 0x008F, 0x0096, 0x00A3, 0x00B9, 0x00DA, 0x0108, 0x0145, 0x0194, 
	0x01F6, 0x026E, 0x02FD, 0x03A7, 0x046D, 0x0552, 0x09D3, 0xFF70, 0xFF86, 
	0xFFC3, 0x0022, 0x009B, 0x012A, 0x01C8, 0x026F, 0x0318, 0x03BF, 0x045D, 
	0x04EC, 0x0565, 0x05C3, 0x0600, 0x0616, 0xFE32, 0xAA61, 0xAA67, 0xAA76, 
	0xAA8D, 0xAAAB, 0xAACE, 0xAAF4, 0xAB1D, 0xAB47, 0xAB70, 0xAB97, 0xABBA, 
	0xABD7, 0xABEE, 0xABFD, 0xAC03, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0010, 0x0001, 0x0001, 0x0011, 0x0001, 0x0012, 0x0001, 
	0x0013, 0x0001, 0x0014, 0x0002, 0x0015, 0x0010, 0x0017, 0x0011, 0x0027, 
	0x0011, 0x0038, 0x0011, 0x0049, 0x0011, 0x005A, 0x0011, 0x006B, 0x0011, 
	0x007C, 0x0011, 0x008D, 0x0001, 0x009E, 0x0001, 0x009F, 0x0001, 0x00A0, 
	0x0011, 0x00A1, 0x0011, 0x00B2, 0x0011, 0x00C3, 0x0010, 0x00D4, 0x0010, 
	0x00E4, 0x0011, 0x00F4, 0x0011, 0x0105, 0x0011, 0x0116, 0x0011, 0x0127, 
	0x0001, 0x0138, 0x0001, 0x0139, 0x0001, 0x013A, 0x0011, 0x013B, 0x0011, 
	0x014C, 0x0011, 0x015D, 0x0011, 0x016E, 0x0011, 0x017F, 0x0011, 0x0190, 
	0x0011, 0x01A1, 0x0011, 0x01B2, 0x0011, 0x01C3, 0x000F, 0x01D4, 0x000C, 
	0x01E3, 0x0001, 0x01EF, 0x0011, 0x01F0, 0x0011, 0x0201, 0x0011, 0x0212, 
	0x0004, 0x0223, 0x0011, 0x0227, 0x0011, 0x0238, 0x0011, 0x0249, 0x0011, 
	0x025A, 0x0011, 0x026B, 0x000F, 0x027C, 0x000F, 0x028B, 0x0001, 0x029A, 
	0x0011, 0x029B, 0x0011, 0x02AC, 0x0011, 0x02BD, 0x0005, 0x02CE, 0x000F, 
	0x02D3, 0x0011, 0x02E2, 0x0011, 0x02F3, 0x0011, 0x0304, 0x0011, 0x0315, 
	

});

smlua_anim_util_register_animation('donkey_1C_climb_down_ledge',1, 0, 0, 0, 9, { 
	0x0000, 0x0000, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0000, 0x0084, 
	0x006F, 0x003B, 0xFFF3, 0xFFA4, 0xFF5A, 0xFF22, 0xFF02, 0xFEF7, 0xFEF5, 
	0xFFFC, 0xFFF4, 0xFFE3, 0xFFD2, 0xFFC7, 0xFFC1, 0xFFBF, 0xFFBD, 0xFFBC, 
	0x0000, 0x3FFF, 0x0000, 0x5589, 0x487B, 0x3835, 0x1969, 0x09A0, 0x03E8, 
	0x02C3, 0x01BD, 0x0090, 0x0000, 0xDE18, 0xD19C, 0xCAAB, 0xD555, 0xDEA8, 
	0xF0AB, 0xFC65, 0xFEEE, 0xFFDD, 0xFFFF, 0x3DF7, 0x33C6, 0x2DBF, 0x35BC, 
	0x3F2E, 0x4544, 0x4800, 0x48C1, 0x4908, 0x4912, 0xCFAF, 0xCE8B, 0xD2FB, 
	0xE7D2, 0xE99C, 0xEE16, 0xF3E8, 0xF9BA, 0xFE35, 0xFFFF, 0x137E, 0x12FF, 
	0x1158, 0x13D4, 0x125C, 0x0EB0, 0x09EA, 0x0524, 0x0178, 0x0000, 0x01B5, 
	0xEBB1, 0xEE00, 0xED82, 0xE666, 0xE1A3, 0xDEBF, 0xDD43, 0xDCB7, 0xDCA3, 
	0x3A19, 0x3B0D, 0x3DBE, 0x45E6, 0x4809, 0x3B44, 0x292F, 0x1643, 0x068E, 
	0x0000, 0xF0EE, 0xFA6D, 0x0547, 0x016E, 0xFBC7, 0xFB89, 0xFBBB, 0xFCD6, 
	0xFEE4, 0x0000, 0xF4BE, 0xF443, 0xF404, 0xF5B1, 0xF696, 0xF4D3, 0xF1C6, 
	0xF235, 0xF302, 0xF371, 0xFFFE, 0x0001, 0xC170, 0x2709, 0xF5F6, 0x909A, 
	0xFCD0, 0xF17F, 0xA62E, 0x2560, 0x2D0D, 0xBB4E, 0xC2FB, 0xE3DC, 0xF135, 
	0xDE09, 0xAD6B, 0xA98C, 0xADA5, 0xDB70, 0xDB48, 0xA500, 0xA528, 0xA065, 
	0xCBD6, 0x1FBD, 0xBA98, 0xC593, 0xF1B6, 0x661A, 0x6763, 0xE9C7, 0xEB11, 
	0x0000, 0xFD6C, 0xFD88, 0xFDD3, 0xFE3C, 0xFEB5, 0xFF2E, 0xFF98, 0xFFE3, 
	0xFFFF, 0x0000, 0x0203, 0x01ED, 0x01B3, 0x0160, 0x0102, 0x00A3, 0x0050, 
	0x0016, 0x0000, 0xB68C, 0xAAE2, 0xB4FF, 0xB578, 0xC35E, 0xD1A3, 0xE643, 
	0xD7D8, 0xD289, 0xD1C6, 0xFFFF, 0x1A7D, 0xE5DA, 0xE7B5, 0xEB91, 0xFFAF, 
	0xFFCE, 0xFF35, 0xFEFC, 0xFEF4, 0xF97B, 0xFC7E, 0xFB04, 0xFB8A, 0xF074, 
	0xFFF4, 0xFD61, 0xF1B8, 0xED6C, 0xECCF, 0xED8B, 0xE780, 0xEEB6, 0xF029, 
	0xF45A, 0xEA85, 0xEE5C, 0xF5FA, 0x0421, 0x0BBF, 0xFFFE, 0x0001, 0xC170, 
	0x054B, 0xDEF3, 0x41FE, 0x348E, 0x49C0, 0xC075, 0xC786, 0xC473, 0x3EBD, 
	0x3BA9, 0x2BD6, 0x1E05, 0x6BCB, 0x7221, 0x6363, 0x1305, 0x0E23, 0x1470, 
	0x5FDB, 0x598E, 0xCCF5, 0x9EF3, 0xFC18, 0xEFFD, 0x046E, 0x658D, 0x6799, 
	0x685A, 0xE9C0, 0xEA82, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xC7DC, 0xD03B, 0xD4FA, 0xCB41, 0xC518, 
	0xEAD3, 0xF14F, 0xD91E, 0xD034, 0xCEEE, 0x0000, 0xFD14, 0xFC8D, 0x057C, 
	0x0C40, 0xF616, 0xF3FD, 0xF678, 0xFB12, 0xFD8D, 0xFFFF, 0x00DA, 0x01BA, 
	0xFF07, 0x03A9, 0x1E80, 0x17FB, 0x1486, 0x133F, 0x1311, 0xF548, 0xF515, 
	0xF4E0, 0xF5A4, 0xF46C, 0xED2F, 0xEEF9, 0xF4D8, 0xFFC0, 0x05A0, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0xED51, 0xF036, 0xEF4B, 0xDFAF, 0xD2CE, 0xD42B, 0xD91D, 0xDFAF, 
	0xEBE3, 0xF275, 0xFF66, 0xF511, 0xEC7B, 0xE8B7, 0xE794, 0xE722, 0xE716, 
	0xE994, 0xEE36, 0xF0B5, 0xAB33, 0xA233, 0x9EC9, 0xB04B, 0xBF17, 0xBB1E, 
	0xB24A, 0xA9B8, 0xA68F, 0xA61C, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x2124, 0x1E8B, 0x1C3B, 0x18C7, 
	0x198E, 0x22D0, 0x2F66, 0x2A4D, 0x20D5, 0x1BBC, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x006E, 
	0x0195, 0x0340, 0x053A, 0x074E, 0x0948, 0x0AF3, 0x0C1A, 0x0C88, 0xD195, 
	0xCE99, 0xCD63, 0xD36C, 0xD75E, 0xD29A, 0xCB2C, 0xD019, 0xD93E, 0xDE2A, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 
	0x056C, 0x028B, 0xFAA6, 0x05A9, 0x1123, 0x16B9, 0x1BAA, 0x1D54, 0x1DF1, 
	0x1E07, 0x1EFC, 0x3240, 0x21A7, 0x293A, 0x305D, 0x2CC2, 0x265C, 0x1BF1, 
	0x1163, 0x0C91, 0x87CF, 0x5D05, 0x8177, 0x9168, 0x9A12, 0x9F70, 0xA3DD, 
	0xA902, 0xB28F, 0xB7B3, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x4FFE, 0x51AF, 0x4AA3, 0x23F3, 
	0x0728, 0x0742, 0x0ED1, 0x0D01, 0x09A3, 0x07D2, 0x00D4, 0x06BC, 0x0084, 
	0xFFE7, 0x0051, 0x0038, 0x001C, 0xFE32, 0xFAFF, 0xF94E, 0xEDC0, 0xF6F0, 
	0xFF73, 0x001E, 0xFF5D, 0xFF52, 0xFF46, 0xFF76, 0xFFCF, 0xFFFF, 0x9A39, 
	0xBBDE, 0xABAF, 0xAF8D, 0xB6BB, 0xBC4C, 0xC278, 0xCED6, 0xE5CE, 0xF22C, 
	

},{ 
	0x0008, 0x0000, 0x000A, 0x0008, 0x0009, 0x0012, 0x0001, 0x001B, 0x0001, 
	0x001C, 0x0001, 0x001D, 0x000A, 0x001E, 0x000A, 0x0028, 0x000A, 0x0032, 
	0x000A, 0x003C, 0x000A, 0x0046, 0x000A, 0x0050, 0x000A, 0x005A, 0x000A, 
	0x0064, 0x000A, 0x006E, 0x0001, 0x0078, 0x0001, 0x0079, 0x0001, 0x007A, 
	0x000A, 0x007B, 0x000A, 0x0085, 0x000A, 0x008F, 0x000A, 0x0099, 0x000A, 
	0x00A3, 0x000A, 0x00AD, 0x000A, 0x00B7, 0x000A, 0x00C1, 0x000A, 0x00CB, 
	0x0001, 0x00D5, 0x0001, 0x00D6, 0x0001, 0x00D7, 0x000A, 0x00D8, 0x000A, 
	0x00E2, 0x000A, 0x00EC, 0x000A, 0x00F6, 0x0009, 0x0100, 0x000A, 0x0109, 
	0x000A, 0x0113, 0x000A, 0x011D, 0x000A, 0x0127, 0x000A, 0x0131, 0x0009, 
	0x013B, 0x0001, 0x0144, 0x000A, 0x0145, 0x000A, 0x014F, 0x000A, 0x0159, 
	0x0009, 0x0163, 0x000A, 0x016C, 0x000A, 0x0176, 0x000A, 0x0180, 0x000A, 
	0x018A, 0x000A, 0x0194, 0x000A, 0x019E, 0x0007, 0x01A8, 0x0001, 0x01AF, 
	0x000A, 0x01B0, 0x000A, 0x01BA, 0x000A, 0x01C4, 0x000A, 0x01CE, 0x000A, 
	0x01D8, 0x000A, 0x01E2, 0x000A, 0x01EC, 0x000A, 0x01F6, 0x000A, 0x0200, 
	

});

smlua_anim_util_register_animation('donkey_02_fall',1, 0, 0, 0, 79, { 
	0x0000, 0x0064, 0x0061, 0x0059, 0x004F, 0x0044, 0x0039, 0x0030, 0x002B, 
	0x002B, 0x0036, 0x004A, 0x0062, 0x007B, 0x008E, 0x0098, 0x0095, 0x008A, 
	0x0078, 0x0065, 0x0052, 0x0042, 0x0039, 0x003A, 0x0043, 0x004F, 0x005A, 
	0x005C, 0x0055, 0x0047, 0x0039, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 
	0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 
	0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 0x003A, 
	0x003A, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0024, 0x0027, 0x002D, 
	0x0037, 0x0042, 0x004F, 0x005B, 0x0066, 0x0070, 0x0076, 0x007C, 0x0081, 
	0x0084, 0x0087, 0x0089, 0x008A, 0x008B, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE9, 0xFFE9, 0xFFEA, 0xFFEE, 0xFFF2, 0xFFF8, 0xFFFD, 0x0002, 0x0006, 
	0x0007, 0x0007, 0x0006, 0x0006, 0x0005, 0x0004, 0x0003, 0x0002, 0x0001, 
	0x0001, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFC, 0xFFF4, 0xFFE8, 0xFFD7, 0xFFC2, 
	0xFFAA, 0xFF8F, 0xFF72, 0xFF53, 0xFF33, 0xFF11, 0xFEEF, 0xFECD, 0xFEAC, 
	0xFE8C, 0xFE6D, 0xFE4F, 0xFE35, 0xFE1D, 0xFE08, 0xFDF7, 0xFDEA, 0xFDE2, 
	0xFDE0, 0xFDED, 0xFE11, 0xFE49, 0xFE8F, 0xFEE0, 0xFF37, 0xFF90, 0xFFE7, 
	0x0039, 0x007F, 0x00B7, 0x00DB, 0x00E8, 0x00DE, 0x00C4, 0x009F, 0x0074, 
	0x0049, 0x0024, 0x000A, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0003, 0x000C, 0x001A, 0x002E, 0x0047, 0x0065, 
	0x0088, 0x00AF, 0x00DA, 0x0108, 0x013B, 0x0170, 0x01A9, 0x01E5, 0x0223, 
	0x0263, 0x02A6, 0x02EA, 0x0330, 0x0378, 0x03C0, 0x0409, 0x0453, 0x049C, 
	0x04E6, 0x052F, 0x0576, 0x05BB, 0x05FC, 0x0639, 0x0670, 0x06A2, 0x06CC, 
	0x06EF, 0x0708, 0x0718, 0x071E, 0x06D0, 0x0601, 0x04DD, 0x038F, 0x0240, 
	0x011C, 0x004E, 0xFFFE, 0x3400, 0x31EB, 0x2CC1, 0x2625, 0x1D43, 0x12EE, 
	0x0B42, 0x068A, 0x0254, 0xFE9B, 0xFB5D, 0xF899, 0xF64B, 0xF471, 0xF32F, 
	0xF293, 0xF27B, 0xF2C2, 0xF345, 0xF3E1, 0xF471, 0xF49E, 0xF29E, 0xF1E1, 
	0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 0xF1C6, 
	0xF1C6, 0xF1C6, 0xF1C7, 0xF1CA, 0xF1D4, 0xF1E6, 0xF205, 0xF233, 0xF272, 
	0xF2C7, 0xF334, 0xF3BC, 0xF463, 0xF52A, 0xF616, 0xF728, 0xF865, 0xF9CF, 
	0xFB6A, 0xFD37, 0xFF3B, 0x0179, 0x03F3, 0x06AB, 0x09A6, 0x0CE6, 0x1099, 
	0x14D7, 0x1987, 0x1E90, 0x23DA, 0x2949, 0x2EC5, 0x3435, 0x397F, 0x3E89, 
	0x433B, 0x477B, 0x4B30, 0x4E46, 0x50C6, 0x52BD, 0x5439, 0x5548, 0x55F9, 
	0x5658, 0x5675, 0x011C, 0x0233, 0x0435, 0x0542, 0x0417, 0x01F6, 0x00CA, 
	0x00F9, 0x0186, 0x024C, 0x0327, 0x03F1, 0x0485, 0x04BF, 0x048C, 0x0408, 
	0x0350, 0x0283, 0x01BF, 0x0122, 0x00CA, 0x00C2, 0x00F2, 0x014A, 0x01B7, 
	0x0228, 0x028B, 0x00F9, 0x00BB, 0x008D, 0x006E, 0x005A, 0x004E, 0x0049, 
	0x0048, 0x0048, 0x0046, 0x0041, 0x0036, 0x0022, 0x0002, 0xFFD4, 0xFF96, 
	0xFE26, 0xFE39, 0xFE6E, 0xFEBC, 0xFF1E, 0xFF8A, 0xFFFA, 0x0068, 0x00C9, 
	0x0118, 0x014D, 0x0160, 0x00CF, 0x006F, 0x0057, 0x0080, 0x00D8, 0x015E, 
	0x0215, 0x02FB, 0x0413, 0x055C, 0x0954, 0x0CC9, 0x0A7C, 0x06CD, 0x0487, 
	0x0326, 0x028E, 0x0206, 0x0166, 0x00BF, 0x0021, 0xFF9A, 0xFF3E, 0xFF1C, 
	0x0000, 0xF993, 0xF9B0, 0xF9D8, 0xF9C5, 0xF92B, 0xF857, 0xF7E6, 0xF7F3, 
	0xF826, 0xF870, 0xF8C3, 0xF910, 0xF949, 0xF95F, 0xF953, 0xF933, 0xF901, 
	0xF8C3, 0xF87D, 0xF831, 0xF7E6, 0xF793, 0xF735, 0xF6CE, 0xF663, 0xF5F9, 
	0xF593, 0xF59D, 0xF5A0, 0xF5A1, 0xF5A2, 0xF5A3, 0xF5A3, 0xF5A4, 0xF5A4, 
	0xF5A4, 0xF5A4, 0xF5A4, 0xF5A4, 0xF5A5, 0xF5A6, 0xF5A8, 0xF5AA, 0xF603, 
	0xF680, 0xF6F4, 0xF75E, 0xF7BE, 0xF812, 0xF85C, 0xF899, 0xF8C9, 0xF8EC, 
	0xF902, 0xF909, 0xF8C1, 0xF875, 0xF82A, 0xF7DD, 0xF788, 0xF72A, 0xF6BF, 
	0xF645, 0xF5B9, 0xF51A, 0xF393, 0xF22D, 0xF261, 0xF37F, 0xF5C0, 0xF7DD, 
	0xF90C, 0xFA41, 0xFBA9, 0xFD20, 0xFE82, 0xFFAB, 0x0079, 0x00C5, 0x0000, 
	0x10FB, 0x0B03, 0xFFFD, 0xFA3E, 0x00BE, 0x0C85, 0x1303, 0x1210, 0x0F16, 
	0x0AE0, 0x0638, 0x01EA, 0xFEC0, 0xFD85, 0xFE98, 0x0165, 0x0549, 0x09A1, 
	0x0DCA, 0x1121, 0x1303, 0x133B, 0x1240, 0x1070, 0x0E2D, 0x0BD4, 0x09C5, 
	0x10D5, 0x1214, 0x1329, 0x1416, 0x14DF, 0x1586, 0x160F, 0x167D, 0x16D2, 
	0x1712, 0x1740, 0x175F, 0x1772, 0x177C, 0x177F, 0x1780, 0x175E, 0x15B1, 
	0x1452, 0x1339, 0x125E, 0x11B9, 0x1143, 0x10F4, 0x10C4, 0x10AB, 0x10A2, 
	0x10A1, 0x13CC, 0x15FB, 0x16C3, 0x15D4, 0x136C, 0x0FF8, 0x0BDF, 0x078E, 
	0x036E, 0xFFE9, 0xFC6E, 0xFB15, 0xFEF4, 0x04B4, 0x0AFA, 0x0EF0, 0x0EFB, 
	0x0EBE, 0x0E0E, 0x0CF5, 0x0B7D, 0x09B2, 0x079D, 0x0548, 0x039F, 0xFF65, 
	0x0E89, 0x071E, 0xFE98, 0xFE5E, 0x0095, 0x021F, 0x01D0, 0x00F0, 0x0010, 
	0xFFC2, 0x00B4, 0x0253, 0x034B, 0x034F, 0x030A, 0x029A, 0x0222, 0x01C2, 
	0x019A, 0x01CB, 0x0270, 0x0376, 0x04BA, 0x0618, 0x076E, 0x0896, 0x0993, 
	0x0A7D, 0x0B4E, 0x0C04, 0x0C6F, 0x0C7D, 0x0C77, 0x0C6A, 0x0C30, 0x0BA5, 
	0x0AD1, 0x09DD, 0x08D2, 0x07B9, 0x069C, 0x0584, 0x0478, 0x0383, 0x02AE, 
	0x01F5, 0x014D, 0x00B4, 0x0029, 0xFFAA, 0xFF33, 0xFEC5, 0xFE5B, 0xFDF6, 
	0xFDCB, 0xFDE3, 0xFDF6, 0xFDE8, 0xFDD4, 0xFDBD, 0xFDA8, 0xFD9A, 0xFD97, 
	0xFDA3, 0xFE04, 0xFEAA, 0xFF1D, 0xFEE6, 0xFBF3, 0xF967, 0xF9B6, 0xFA9A, 
	0xFBE8, 0xFD6C, 0xFEF4, 0x004C, 0x0140, 0x019C, 0x0000, 0xF0B6, 0xF827, 
	0xF4D3, 0xF0C2, 0xEFE7, 0xF00B, 0xF0D7, 0xF22E, 0xF3FB, 0xF5F8, 0xF7E2, 
	0xF9FC, 0xFC1A, 0xFD4D, 0xFD92, 0xFD91, 0xFD5F, 0xFD0F, 0xFCB2, 0xFC5E, 
	0xFC23, 0xFC06, 0xFBF5, 0xFBE5, 0xFBCD, 0xFBA1, 0xFB58, 0xFAC6, 0xF9F1, 
	0xF920, 0xF894, 0xF8F2, 0xF96C, 0xF92B, 0xF8B7, 0xF843, 0xF7FF, 0xF7E9, 
	0xF7DE, 0xF7DB, 0xF7DF, 0xF7E6, 0xF7EF, 0xF7F8, 0xF7FE, 0xF7FF, 0xF7FB, 
	0xF7F7, 0xF7F1, 0xF7EC, 0xF7E5, 0xF7DF, 0xF7D9, 0xF7D4, 0xF7CF, 0xF79D, 
	0xF76E, 0xF7CF, 0xF895, 0xF94B, 0xFA10, 0xFB06, 0xFC4C, 0xFE04, 0x004E, 
	0x04DE, 0x0B8B, 0x11AC, 0x1495, 0x0C3F, 0x02C4, 0x0132, 0x0106, 0x00AF, 
	0x003E, 0xFFC6, 0xFF59, 0xFF0B, 0xFEED, 0x0000, 0x17B1, 0xEB77, 0xE93B, 
	0xE953, 0xEB3F, 0xEE7F, 0xF292, 0xF6F8, 0xFB33, 0x05F1, 0x0F3A, 0x0BCF, 
	0x046A, 0x0087, 0x01C6, 0x0468, 0x07DE, 0x0B9B, 0x0F0F, 0x11AB, 0x12E3, 
	0x11F4, 0x0F26, 0x0B73, 0x07D8, 0x0551, 0x04D8, 0x0965, 0x11FA, 0x199F, 
	0x1A96, 0x15DF, 0x149F, 0x13F1, 0x1387, 0x1353, 0x1346, 0x134E, 0x1365, 
	0x138A, 0x13BF, 0x1404, 0x145C, 0x14C6, 0x1545, 0x15D9, 0x168F, 0x176A, 
	0x1861, 0x196A, 0x1A79, 0x1B85, 0x1C85, 0x1D6C, 0x1E33, 0x1EF8, 0x1F46, 
	0x1E33, 0x1BAC, 0x1876, 0x14E3, 0x1146, 0x0DF2, 0x0B3B, 0x0973, 0x0A8B, 
	0x0E32, 0x1159, 0x10F2, 0x0345, 0xF643, 0xF4FF, 0xF3C2, 0xF326, 0xF2DB, 
	0xF28E, 0xF1EF, 0xF0AC, 0xEE74, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xCA37, 
	0xCC80, 0xCEC8, 0xCA37, 0xB677, 0x9BDD, 0x0C8F, 0x0B3E, 0x0DB2, 0x92A3, 
	0x98D0, 0x9EF3, 0xA3C7, 0xA607, 0xA580, 0xA340, 0x9FE8, 0x9C18, 0x9871, 
	0x9594, 0x9420, 0x94BB, 0x981A, 0x9C75, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 
	0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 
	0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 
	0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0x9E9E, 0xA076, 0xA58D, 0xAD37, 
	0xB6C7, 0xC192, 0xCCEC, 0xD828, 0xE29C, 0xEBBB, 0xF379, 0xF9EC, 0xFF28, 
	0x0343, 0x0650, 0x0864, 0x0994, 0x09F5, 0x02A7, 0x022F, 0x017B, 0x02AD, 
	0x05C2, 0x09F9, 0x0E91, 0x12C8, 0x15DD, 0x170F, 0x19C6, 0xC606, 0xC60A, 
	0xC60E, 0xC606, 0xC559, 0xC4A1, 0xBA5D, 0xB750, 0xB359, 0xD113, 0xD586, 
	0xD98A, 0xDCAC, 0xDE79, 0xDEA7, 0xDD83, 0xDB7D, 0xD908, 0xD694, 0xD493, 
	0xD377, 0xD373, 0xCF87, 0xC84B, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 
	0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 
	0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 
	0xC467, 0xC467, 0xC467, 0xC467, 0xC467, 0xC4E6, 0xC647, 0xC865, 0xCB19, 
	0xCE3D, 0xD1A9, 0xD538, 0xD8C2, 0xDC27, 0xDF57, 0xE24A, 0xE4F6, 0xE752, 
	0xE956, 0xEAF6, 0xEC2C, 0xECEC, 0xED2E, 0xEA63, 0xE722, 0xE538, 0xE447, 
	0xE3D4, 0xE360, 0xE26D, 0xE07F, 0xDD17, 0xDC99, 0xE104, 0xDEAB, 0xDC52, 
	0xE104, 0xF592, 0x112B, 0xA061, 0xA04E, 0x9BF6, 0x14DB, 0x0C77, 0x044A, 
	0xFDD3, 0xFA8F, 0xFAD0, 0xFD5B, 0x0162, 0x0614, 0x0AA3, 0x0E3E, 0x1016, 
	0x0F74, 0x0B0E, 0x04E0, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 
	0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 
	0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x01BD, 
	0x01BD, 0x01BD, 0x01BD, 0x01BD, 0x018F, 0x0121, 0x009D, 0x002E, 0x0000, 
	0x0529, 0x0EC0, 0x13E9, 0x1185, 0x0B1E, 0x01D8, 0xF6D9, 0xEB48, 0xE049, 
	0xD704, 0xD09C, 0xCE38, 0xC728, 0xC7F5, 0xC93B, 0xC933, 0xC8F7, 0xC854, 
	0xC716, 0xC50B, 0xC1FF, 0xBDBE, 0xBCE3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 
	0xFFFB, 0xFFFB, 0xFFFA, 0xFFF9, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFF6, 
	0xFFF5, 0xFFF4, 0xFFF3, 0xFFF2, 0xFFF2, 0xFFF1, 0xFFF0, 0xFFEF, 0xFFEE, 
	0xFFED, 0xFFEC, 0xFFEB, 0xFFEA, 0xFFE9, 0xFFE8, 0xFFE7, 0xFFE6, 0xFFE5, 
	0xFFE4, 0xFFE3, 0xFFE2, 0xFFE1, 0xFFE0, 0xFFDF, 0xFFDE, 0xFFDD, 0xFFDC, 
	0xFFDB, 0xFFDA, 0xFFD9, 0xFFD8, 0xFFD8, 0xFFD7, 0xFFD6, 0xFFD5, 0xFFD4, 
	0xFFD4, 0xFFD3, 0xFFD2, 0xFFD1, 0xFFD1, 0xFFD0, 0xFFCF, 0xFFCF, 0xFFCE, 
	0xFFCE, 0xFFCD, 0xFFCD, 0xFFCD, 0xFFCC, 0xFFCC, 0xFFCC, 0xFFCB, 0xFFCB, 
	0xFFCB, 0xFFCB, 0xFFCB, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0003, 0x0005, 
	0x0007, 0x000A, 0x000E, 0x0012, 0x0017, 0x001C, 0x0021, 0x0027, 0x002E, 
	0x0035, 0x003C, 0x0043, 0x004B, 0x0054, 0x005C, 0x0065, 0x006E, 0x0078, 
	0x0081, 0x008B, 0x0096, 0x00A0, 0x00AB, 0x00B6, 0x00C1, 0x00CC, 0x00D7, 
	0x00E3, 0x00EE, 0x00FA, 0x0106, 0x0111, 0x011D, 0x0129, 0x0135, 0x0141, 
	0x014D, 0x0159, 0x0164, 0x0170, 0x017C, 0x0187, 0x0193, 0x019E, 0x01A9, 
	0x01B4, 0x01BF, 0x01CA, 0x01D4, 0x01DE, 0x01E8, 0x01F2, 0x01FC, 0x0205, 
	0x020E, 0x0216, 0x021F, 0x0227, 0x022E, 0x0235, 0x023C, 0x0242, 0x0248, 
	0x024E, 0x0253, 0x0258, 0x025C, 0x025F, 0x0263, 0x0265, 0x0267, 0x0269, 
	0x026A, 0x026A, 0x0000, 0xCA4E, 0xC9CF, 0xC94F, 0xCA4E, 0xCE20, 0xD371, 
	0xD7C0, 0xDAB2, 0xDD8B, 0xE039, 0xE2AE, 0xE4D8, 0xE6A7, 0xE80C, 0xE8E7, 
	0xE93C, 0xE930, 0xE8E7, 0xE886, 0xE831, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 
	0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE80C, 0xE7C8, 0xE729, 
	0xE673, 0xE5EA, 0xE5D3, 0xE673, 0xE80C, 0xED63, 0xF61A, 0xFDC8, 0xFFFF, 
	0xFD1C, 0xF8AA, 0xF30D, 0xEF95, 0xED78, 0xEB76, 0xE84E, 0xE2C1, 0xD98D, 
	0xCB72, 0xCC9F, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0003, 
	0x0009, 0x000A, 0xFFFF, 0xFFE8, 0xFFC7, 0xFF9F, 0xFF71, 0xFF3F, 0xFF09, 
	0xFED1, 0xFE9A, 0xFE63, 0xFE2F, 0xFDFE, 0xFDD3, 0xFDAF, 0xFD92, 0xFD80, 
	0xFD78, 0xFD7D, 0xFD8F, 0xFDB0, 0xFDE3, 0xFE27, 0xFF07, 0x00C9, 0x0303, 
	0x054E, 0x0740, 0x0872, 0x087C, 0x044D, 0xFCC5, 0xF75B, 0xFE5F, 0xFF01, 
	0xFF7A, 0xFFD0, 0x016F, 0x043E, 0x0795, 0x0ACA, 0x0D33, 0x0E26, 0x07F6, 
	0x04C7, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF99B, 0xF9D0, 
	0xF9DB, 0xF97B, 0xF8CE, 0xF81F, 0xF76D, 0xF6B8, 0xF600, 0xF546, 0xF488, 
	0xF3C7, 0xF303, 0xF23C, 0xF171, 0xF0A3, 0xEFD2, 0xEEFD, 0xEE25, 0xED48, 
	0xEC68, 0xEB84, 0xEA9D, 0xE9B1, 0xE8C1, 0xE77C, 0xE5BD, 0xE3C6, 0xE1DD, 
	0xE042, 0xDF3B, 0xDF0A, 0xE1DC, 0xE755, 0xEBE6, 0xEAC2, 0xEC09, 0xED8F, 
	0xEF3E, 0xF22D, 0xF614, 0xFA46, 0xFE1A, 0x00E4, 0x01F7, 0xFEB7, 0x0306, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xEDAA, 0xEDDD, 0xEDE8, 
	0xED8B, 0xECE1, 0xEC31, 0xEB79, 0xEABC, 0xE9FA, 0xE934, 0xE869, 0xE79C, 
	0xE6CC, 0xE5FB, 0xE529, 0xE457, 0xE385, 0xE2B5, 0xE1E7, 0xE11B, 0xE053, 
	0xDF8F, 0xDECF, 0xDE16, 0xDD62, 0xDC80, 0xDB62, 0xDA43, 0xD95C, 0xD8E9, 
	0xD924, 0xDA49, 0xDFE5, 0xE8CB, 0xEE20, 0xDF52, 0xDF9C, 0xE07E, 0xE1D7, 
	0xE2CC, 0xE3DA, 0xE5E9, 0xE9E2, 0xF0AB, 0xFB2C, 0x0911, 0x0A90, 0x0001, 
	0xFFFE, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC15E, 0xC142, 
	0xC13C, 0xC170, 0xC1D3, 0xC244, 0xC2BF, 0xC342, 0xC3CA, 0xC455, 0xC4E0, 
	0xC568, 0xC5EB, 0xC665, 0xC6D6, 0xC739, 0xC78C, 0xC7C5, 0xC7E0, 0xC7E3, 
	0xC7D7, 0xC7C1, 0xC7A8, 0xC794, 0xC78C, 0xC78F, 0xC796, 0xC79E, 0xC7A3, 
	0xC7A4, 0xC79E, 0xC78C, 0xC75B, 0xC705, 0xC69F, 0xC62D, 0xC5AB, 0xC51F, 
	0xC48D, 0xC3FA, 0xC36B, 0xC2E4, 0xC26B, 0xC204, 0xC1B5, 0xC182, 0xC170, 
	0xFF42, 0xFF32, 0xFF23, 0xFF42, 0xFD7F, 0xFBEA, 0x00E0, 0x0CEC, 0x1B9F, 
	0x2BE3, 0x3CA1, 0x4CC0, 0x5B29, 0x66C6, 0x6FC1, 0x7724, 0x7D1D, 0x81E1, 
	0x859B, 0x887D, 0x8ABA, 0x8B80, 0x7C53, 0x6023, 0x50F5, 0x50F5, 0x50F5, 
	0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 
	0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 0x50F5, 
	0x50F5, 0x5377, 0x5A71, 0xE517, 0xF29C, 0x8231, 0x9308, 0xA454, 0xB548, 
	0xC515, 0xD2EE, 0xDE05, 0xE5F7, 0xEBCD, 0xF015, 0xF361, 0xF644, 0xF952, 
	0xFD1D, 0x0239, 0x10BB, 0x223A, 0x2186, 0x0DE8, 0xF591, 0x59B6, 0x3B84, 
	0x3BA9, 0x3C08, 0x3C8B, 0x3D19, 0x3D9B, 0x3DFA, 0x3E1F, 0x36DA, 0x2D41, 
	0x2D42, 0x2D43, 0x2D41, 0x2D51, 0x2D5D, 0x2D1D, 0x2C69, 0x2B66, 0x2A45, 
	0x2937, 0x286B, 0x2813, 0x285E, 0x29B9, 0x2C1B, 0x2F0B, 0x320A, 0x349F, 
	0x364C, 0x3695, 0x34C9, 0x3666, 0x3967, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 
	0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 
	0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 0x3B04, 
	0x3A76, 0x38EC, 0x4966, 0x4C4E, 0x3066, 0x2CEA, 0x2970, 0x2629, 0x234A, 
	0x2104, 0x1F8B, 0x1F09, 0x1F91, 0x2115, 0x232A, 0x2566, 0x275E, 0x28A6, 
	0x28D5, 0x26EB, 0x2437, 0x23BF, 0x2691, 0x2B01, 0x5005, 0x4B95, 0x4B9A, 
	0x4BBF, 0x4C24, 0x4CE8, 0x4E2C, 0x500F, 0x52B1, 0x54F5, 0x932B, 0x9356, 
	0x9382, 0x932B, 0x8FBD, 0x8BCD, 0x8E9B, 0x98CA, 0xA584, 0xB3CE, 0xC2AF, 
	0xD12A, 0xDE47, 0xE90A, 0xF1D7, 0xF9AD, 0x007C, 0x0636, 0x0ACA, 0x0E28, 
	0x1042, 0x0FE8, 0xFE0F, 0xDE06, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 
	0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 
	0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCCE1, 0xCE9E, 
	0xD380, 0x5B08, 0x64B8, 0xF00E, 0xFC8F, 0x09BC, 0x1712, 0x2416, 0x3047, 
	0x3B28, 0x4524, 0x516D, 0x6061, 0x7122, 0x82D5, 0x9497, 0xA58D, 0xB4DA, 
	0xC664, 0xD529, 0xD2F1, 0xC0E1, 0xAA5F, 0x108C, 0xF482, 0xF6BA, 0xFC73, 
	0x0447, 0x0CCE, 0x14A1, 0x1A5A, 0x1C92, 0x175C, 0x0000, 0x0001, 0x0002, 
	0x0005, 0x0009, 0x000E, 0x0015, 0x001C, 0x0024, 0x002D, 0x0037, 0x0042, 
	0x004E, 0x005A, 0x0068, 0x0076, 0x0085, 0x0095, 0x00A5, 0x00B6, 0x00C8, 
	0x00DA, 0x00ED, 0x0100, 0x0114, 0x0128, 0x013D, 0x0152, 0x0167, 0x017D, 
	0x0193, 0x01A9, 0x01C0, 0x01D7, 0x01EE, 0x0205, 0x021C, 0x0234, 0x024B, 
	0x0263, 0x027A, 0x0292, 0x02A9, 0x02C0, 0x02D7, 0x02EE, 0x0305, 0x031C, 
	0x0332, 0x0348, 0x035E, 0x0374, 0x0389, 0x039D, 0x03B2, 0x03C5, 0x03D9, 
	0x03EB, 0x03FE, 0x040F, 0x0420, 0x0431, 0x0440, 0x044F, 0x045D, 0x046B, 
	0x0478, 0x0483, 0x048E, 0x0498, 0x04A1, 0x04AA, 0x04B1, 0x04B7, 0x04BC, 
	0x04C0, 0x04C3, 0x04C5, 0x04C5, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC758, 0xC6D4, 0xC7DC, 0xCAA7, 
	0xCE28, 0xD20F, 0xD606, 0xD9BC, 0xDCDD, 0xDF16, 0xE057, 0xE0E8, 0xE0F0, 
	0xE09C, 0xE015, 0xDF84, 0xDF16, 0xDEA7, 0xDE07, 0xDD47, 0xDC7B, 0xDBB5, 
	0xDB06, 0xDA4C, 0xD986, 0xD8FD, 0xD8F9, 0xDAED, 0xDD0C, 0xDD6E, 0xDD63, 
	0xDD2D, 0xDD0C, 0xDD13, 0xDD26, 0xDD41, 0xDD61, 0xDD82, 0xDDA0, 0xDDB9, 
	0xDDC8, 0xDDCB, 0xDDBC, 0xDD9A, 0xDD61, 0xDD0C, 0xDC90, 0xDBE6, 0xDB11, 
	0xDA14, 0xD8F4, 0xD7B5, 0xD65A, 0xD4E6, 0xD2DA, 0xD004, 0xCCDD, 0xC9DF, 
	0xC786, 0xC649, 0xC6A4, 0xCE00, 0xDA91, 0xE1F9, 0xE281, 0xE195, 0xDF97, 
	0xDCE7, 0xDB12, 0xDA05, 0xD927, 0xD7DE, 0xD590, 0xD1A3, 0xCB7B, 0xCB60, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFE4, 0xFF9B, 0xFF32, 0xFEB7, 0xFE37, 0xFDC0, 0xFD60, 0xFD25, 
	0xFD1C, 0xFD52, 0xFDD7, 0xFEB7, 0x0000, 0x0248, 0x05D9, 0x0A4C, 0x0F3A, 
	0x143A, 0x18E7, 0x1CD9, 0x1FA9, 0x2160, 0x225E, 0x22B9, 0x228A, 0x21E8, 
	0x20EA, 0x1FA9, 0x1C01, 0x163D, 0x1215, 0x0FF4, 0x0DD0, 0x0BB2, 0x09A4, 
	0x07E2, 0x065C, 0x04E9, 0x035D, 0x018E, 0xFF52, 0xFC7F, 0xFA42, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFF8, 0xFFE4, 0xFFC6, 0xFFA4, 0xFF81, 0xFF60, 0xFF45, 0xFF35, 0xFF32, 
	0xFF41, 0xFF66, 0xFFA4, 0xFFFF, 0x00A2, 0x01A0, 0x02DC, 0x043A, 0x059E, 
	0x06EA, 0x0803, 0x08CB, 0x093D, 0x0972, 0x0977, 0x095A, 0x092B, 0x08F6, 
	0x08CB, 0x0884, 0x0808, 0x0775, 0x06D1, 0x0617, 0x054D, 0x047B, 0x03FD, 
	0x03C4, 0x03B5, 0x03B4, 0x03A5, 0x036C, 0x02EE, 0x0197, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF551, 
	0xF569, 0xF58C, 0xF5B5, 0xF5DF, 0xF606, 0xF626, 0xF639, 0xF63C, 0xF62A, 
	0xF5FE, 0xF5B5, 0xF548, 0xF488, 0xF35B, 0xF1E3, 0xF044, 0xEE9D, 0xED13, 
	0xEBC6, 0xEAD9, 0xEA51, 0xEA13, 0xEA0D, 0xEA2E, 0xEA67, 0xEAA5, 0xEAD9, 
	0xEB2D, 0xEBBF, 0xEC6F, 0xED31, 0xEE0E, 0xEEFD, 0xEFF7, 0xF22B, 0xF57F, 
	0xF96B, 0xFD65, 0x00E6, 0x0364, 0x0457, 0x0624, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xEA48, 0xEA71, 0xEAD5, 0xEB54, 0xEBB2, 
	0xEC2B, 0xED56, 0xEF4F, 0xF1AA, 0xF437, 0xF6C3, 0xF91D, 0xFB12, 0xFC71, 
	0xFD49, 0xFDCE, 0xFDFE, 0xFDDB, 0xFD65, 0xFC9B, 0xFB7F, 0xF9C5, 0xF751, 
	0xF46D, 0xF15F, 0xEE73, 0xEBF0, 0xE9ED, 0xE83E, 0xE6C5, 0xE562, 0xE42D, 
	0xE3A8, 0xE3DB, 0xE456, 0xE4E8, 0xE562, 0xE5BF, 0xE61B, 0xE675, 0xE6CD, 
	0xE724, 0xE779, 0xE7CD, 0xE81E, 0xE86F, 0xE899, 0xE8A5, 0xE8D4, 0xE968, 
	0xEA3E, 0xEB10, 0xEBEC, 0xECE1, 0xEDFC, 0xEF4C, 0xF0DF, 0xF2C3, 0xF550, 
	0xF89B, 0xFC4E, 0x0013, 0x0393, 0x0678, 0x086D, 0x0755, 0x0390, 0x0084, 
	0x0230, 0xFB50, 0xF750, 0xF289, 0xF334, 0xF4ED, 0xF747, 0xF9D8, 0xFC32, 
	0xFDEB, 0xFE96, 0xFE9B, 0xF262, 0xF21D, 0xF17C, 0xF0C3, 0xEF6B, 0xEDFA, 
	0xEE4D, 0xF0A6, 0xF3CD, 0xF765, 0xFB13, 0xFE7C, 0x0142, 0x030B, 0x03AF, 
	0x0370, 0x0296, 0x0169, 0x002F, 0xFF31, 0xFEB4, 0xFF01, 0xFFE6, 0x00FC, 
	0x01D9, 0x0213, 0x0143, 0xFE27, 0xF901, 0xF3AA, 0xEFFB, 0xF154, 0xF3CD, 
	0xF354, 0xF238, 0xF0F3, 0xEFFB, 0xEF56, 0xEEBB, 0xEE27, 0xED9B, 0xED16, 
	0xEC96, 0xEC1D, 0xEBA9, 0xEB39, 0xEAF7, 0xEAE5, 0xEAC9, 0xEA67, 0xE993, 
	0xE867, 0xE710, 0xE5BB, 0xE497, 0xE3D0, 0xE394, 0xE410, 0xE594, 0xE817, 
	0xEB45, 0xEEC7, 0xF249, 0xF574, 0xF7F4, 0xF8F5, 0xF8BB, 0xF890, 0xF91B, 
	0xFA4C, 0xFBCA, 0xFA31, 0xF89E, 0xF7CC, 0xF747, 0xF69C, 0xF55A, 0xF30C, 
	0xEF42, 0xEFF9, 0x8A9D, 0x8A22, 0x88FB, 0x8799, 0x83D7, 0x7FD9, 0x827F, 
	0x8CFC, 0x9AE0, 0xAA88, 0xBA50, 0xC895, 0xD3B3, 0xDA06, 0xDA6F, 0xD601, 
	0xCE69, 0xC555, 0xBC6F, 0xB566, 0xB1E5, 0xB2DD, 0xB71F, 0xBD26, 0xC36F, 
	0xC875, 0xCAB4, 0xC88F, 0xC2ED, 0xBC0F, 0xB634, 0xB2D7, 0xB1BD, 0xB2F7, 
	0xB578, 0xB7F4, 0xB91D, 0xB903, 0xB89E, 0xB7FC, 0xB72E, 0xB643, 0xB54A, 
	0xB453, 0xB36C, 0xB2A6, 0xB229, 0xB1D2, 0xB145, 0xB021, 0xAEB0, 0xAD63, 
	0xAC12, 0xAA97, 0xA8C9, 0xA683, 0xA39D, 0x9FF0, 0x9AA7, 0x9392, 0x8B87, 
	0x835B, 0x7BE3, 0x75F6, 0x7269, 0x75EE, 0x8052, 0x8B0F, 0x955E, 0x9BC3, 
	0xA0BE, 0xA3F3, 0xA3DC, 0xA33B, 0xA184, 0x9E2E, 0x98AE, 0x907A, 0x8506, 
	0x839E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFD, 
	0xFFFD, 0xFFFC, 0xFFFB, 0xFFFB, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFF6, 
	0xFFF5, 0xFFF4, 0xFFF3, 0xFFF2, 0xFFF0, 0xFFEF, 0xFFEE, 0xFFED, 0xFFEB, 
	0xFFEA, 0xFFE9, 0xFFE7, 0xFFE6, 0xFFE4, 0xFFE3, 0xFFE1, 0xFFE0, 0xFFDE, 
	0xFFDD, 0xFFDB, 0xFFD9, 0xFFD8, 0xFFD6, 0xFFD5, 0xFFD3, 0xFFD2, 0xFFD0, 
	0xFFCF, 0xFFCD, 0xFFCB, 0xFFCA, 0xFFC8, 0xFFC7, 0xFFC6, 0xFFC4, 0xFFC3, 
	0xFFC1, 0xFFC0, 0xFFBF, 0xFFBD, 0xFFBC, 0xFFBB, 0xFFBA, 0xFFB9, 0xFFB8, 
	0xFFB7, 0xFFB6, 0xFFB5, 0xFFB4, 0xFFB3, 0xFFB2, 0xFFB1, 0xFFB1, 0xFFB0, 
	0xFFAF, 0xFFAF, 0xFFAF, 0xFFAE, 0xFFAE, 0xFFAE, 0xFFAE, 0xFFAE, 0x0000, 
	0xFFFF, 0x0000, 0x0001, 0x0002, 0x0004, 0x0006, 0x0009, 0x000C, 0x0010, 
	0x0014, 0x0018, 0x001D, 0x0022, 0x0028, 0x002E, 0x0034, 0x003B, 0x0041, 
	0x0049, 0x0050, 0x0058, 0x0060, 0x0068, 0x0071, 0x0079, 0x0082, 0x008B, 
	0x0095, 0x009E, 0x00A8, 0x00B1, 0x00BB, 0x00C5, 0x00CF, 0x00D9, 0x00E4, 
	0x00EE, 0x00F8, 0x0102, 0x010D, 0x0117, 0x0121, 0x012C, 0x0136, 0x0140, 
	0x014A, 0x0154, 0x015E, 0x0168, 0x0172, 0x017B, 0x0185, 0x018E, 0x0197, 
	0x01A0, 0x01A9, 0x01B1, 0x01BA, 0x01C2, 0x01C9, 0x01D1, 0x01D8, 0x01DF, 
	0x01E6, 0x01EC, 0x01F2, 0x01F7, 0x01FC, 0x0201, 0x0206, 0x020A, 0x020D, 
	0x0210, 0x0213, 0x0215, 0x0217, 0x0218, 0x0219, 0x021A, 0xFFFF, 0x2537, 
	0x2584, 0x25D1, 0x2537, 0x22AE, 0x1F3D, 0x1D11, 0x1CA3, 0x1CCE, 0x1D4B, 
	0x1DD6, 0x1E28, 0x1DFE, 0x1D11, 0x1B05, 0x17FA, 0x1462, 0x10B0, 0x0D59, 
	0x0ACD, 0x0982, 0x09DA, 0x0B96, 0x0E35, 0x1134, 0x1413, 0x1650, 0x17E3, 
	0x1927, 0x1A2D, 0x1B07, 0x1B3A, 0x1B07, 0x1B18, 0x1B35, 0x1B3B, 0x1B07, 
	0x1AA4, 0x1A33, 0x19B8, 0x1935, 0x18AD, 0x1822, 0x1797, 0x170F, 0x168C, 
	0x1611, 0x15A1, 0x153E, 0x14EB, 0x142F, 0x12D7, 0x114C, 0x0FF7, 0x0F40, 
	0x0F90, 0x1151, 0x14EB, 0x1B55, 0x2497, 0x2FB4, 0x3BAD, 0x4785, 0x523E, 
	0x5ADB, 0x5B2C, 0x55F2, 0x50DE, 0x4B62, 0x43B0, 0x3C1B, 0x3671, 0x3715, 
	0x38D2, 0x3B60, 0x3E78, 0x41D1, 0x4525, 0x482C, 0x49EE, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x000F, 0x0036, 0x0066, 0x0092, 0x00AB, 0x00A4, 
	0x006F, 0x0000, 0xFF2E, 0xFDF9, 0xFC87, 0xFB00, 0xF98A, 0xF84E, 0xF771, 
	0xF86A, 0xFA69, 0xFBB7, 0xF903, 0xF924, 0xF69C, 0xF72F, 0xF72E, 0xF724, 
	0xF708, 0xF6D3, 0xF67C, 0xF5FA, 0xF544, 0xF792, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
	0x0000, 0x0009, 0x001F, 0x0037, 0x004B, 0x0051, 0x0042, 0x0015, 0xFF2B, 
	0xFDCD, 0xFCA0, 0xFB70, 0xFB64, 0xFBE8, 0xFCA8, 0xFCA7, 0xFC9E, 0xFC87, 
	0xFC5A, 0xFC0F, 0xFB9F, 0xFB04, 0x03C6, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 
	0xBEA2, 0xBE04, 0xBF3F, 0xC2CC, 0xC77F, 0xCCBD, 0xD1EA, 0xD66A, 0xD9A1, 
	0xDAF4, 0xD9AE, 0xD61F, 0xD12E, 0xCBC3, 0xC6C5, 0xC31D, 0xC1B1, 0xC336, 
	0xC71E, 0xCC6D, 0xD228, 0xD754, 0xDAF4, 0xDC5F, 0xDC37, 0xDB6D, 0xDAF4, 
	0xDAF4, 0xDAF4, 0xDAF0, 0xDAEB, 0xDAE9, 0xDAF4, 0xDB08, 0xDB1E, 0xDB37, 
	0xDB51, 0xDB6C, 0xDB88, 0xDBA4, 0xDBBF, 0xDBD9, 0xDBF2, 0xDC08, 0xDC1C, 
	0xDC2D, 0xDC5C, 0xDCB8, 0xDD24, 0xDD83, 0xDDB6, 0xDDA2, 0xDD29, 0xDC2D, 
	0xDAA8, 0xD8AF, 0xD648, 0xD37C, 0xD052, 0xCCD2, 0xC904, 0xC1D9, 0xB8A7, 
	0xB107, 0xA99A, 0xA758, 0xAA1B, 0xADEB, 0xADE5, 0xADBC, 0xAD4D, 0xAC74, 
	0xAB0F, 0xA8F9, 0xA611, 0xAB92, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF5E, 0xC017, 0xC0D1, 0xBF5E, 0xB8D9, 0xB028, 0xABD0, 0xACDA, 
	0xAF8C, 0xB340, 0xB754, 0xBB22, 0xBE07, 0xBF5E, 0xBED0, 0xBCD1, 0xB9F0, 
	0xB6BB, 0xB3C0, 0xB18E, 0xB0B3, 0xB195, 0xB3DA, 0xB6EF, 0xBA43, 0xBD43, 
	0xBF5E, 0xC031, 0xC01A, 0xBFA4, 0xBF5E, 0x160A, 0x1561, 0x140E, 0x1310, 
	0x12F2, 0x1328, 0x1310, 0x129B, 0x1220, 0x1198, 0x10FE, 0x104C, 0x0F7C, 
	0x0E89, 0x0D42, 0x0BA0, 0x09D0, 0x0806, 0x0670, 0x0540, 0x04A6, 0x0507, 
	0x0654, 0x0815, 0x09D2, 0x0B13, 0x0B5E, 0x09C7, 0x069F, 0x034E, 0x013A, 
	0x030E, 0x056C, 0x04F5, 0x03C9, 0x0285, 0x01C2, 0x018D, 0x0181, 0x0190, 
	0x01AF, 0x01D1, 0x01E9, 0x01EC, 0x01CD, 0x017F, 0x00F8, 0x003F, 0xFF61, 
	0xFE6A, 0xFD66, 0xFC63, 0xFB6E, 0xFA91, 0xF9DB, 0xF958, 0xF915, 0xF91D, 
	0xF9D3, 0xFB5C, 0xFD6E, 0xFFC0, 0x0206, 0x03F7, 0x0548, 0x057D, 0x04BF, 
	0x03BB, 0x031D, 0x0B95, 0x1095, 0x0FB3, 0x0DBC, 0x0B2B, 0x0855, 0x058E, 
	0x032A, 0x017D, 0x00DC, 0x01C0, 0x1789, 0x1810, 0x191D, 0x19E7, 0x1A3B, 
	0x1A4C, 0x19E7, 0x190A, 0x17EA, 0x16A8, 0x1568, 0x144B, 0x1373, 0x1303, 
	0x1314, 0x1393, 0x1458, 0x153E, 0x161D, 0x16D0, 0x1730, 0x1725, 0x16CA, 
	0x1643, 0x15B7, 0x154B, 0x1525, 0x157D, 0x1638, 0x1706, 0x1792, 0x1763, 
	0x170A, 0x171B, 0x1744, 0x1771, 0x178B, 0x1794, 0x179B, 0x17A0, 0x17A3, 
	0x17A4, 0x17A3, 0x179F, 0x1798, 0x178F, 0x1787, 0x1783, 0x1782, 0x1781, 
	0x177F, 0x1779, 0x176F, 0x175D, 0x1743, 0x171F, 0x16EE, 0x16AF, 0x163C, 
	0x1586, 0x14AB, 0x13CC, 0x1309, 0x1281, 0x1254, 0x12C6, 0x13E0, 0x156B, 
	0x1732, 0x18E8, 0x17B9, 0x16FF, 0x1666, 0x15A4, 0x14CA, 0x13EA, 0x1314, 
	0x125B, 0x11D1, 0x1192, 0xA1EE, 0xA0C6, 0x9E75, 0x9CB8, 0x9B6E, 0x9AB7, 
	0x9CB8, 0xA1CB, 0xA85B, 0xAFAA, 0xB6FA, 0xBD8D, 0xC2A5, 0xC584, 0xC59A, 
	0xC361, 0xBFA7, 0xBB3B, 0xB6EC, 0xB388, 0xB1DE, 0xB299, 0xB533, 0xB8AE, 
	0xBC11, 0xBE5E, 0xBE9B, 0xB84C, 0xAD9A, 0xA749, 0xA64D, 0xA75E, 0xA875, 
	0xA8D8, 0xA956, 0xA9CA, 0xAA1D, 0xAA85, 0xAAFF, 0xAB80, 0xABF8, 0xAC5C, 
	0xAC9E, 0xACB0, 0xAC85, 0xAC10, 0xAB6E, 0xAAC1, 0xAA04, 0xA930, 0xA83F, 
	0xA72D, 0xA5F1, 0xA488, 0xA2EA, 0xA112, 0x9EFA, 0x9C9C, 0x9962, 0x9504, 
	0x8FE8, 0x8A7A, 0x8520, 0x8046, 0x7C51, 0x79AB, 0x783A, 0x77A9, 0x77A4, 
	0x8A65, 0x946B, 0x986A, 0x985B, 0x97EF, 0x96CA, 0x948F, 0x90E3, 0x8B68, 
	0x83C1, 0x842B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 
	0xFFFB, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFF7, 0xFFF5, 0xFFF4, 0xFFF2, 0xFFF0, 
	0xFFEE, 0xFFEC, 0xFFEA, 0xFFE8, 0xFFE6, 0xFFE3, 0xFFE1, 0xFFDE, 0xFFDC, 
	0xFFD9, 0xFFD7, 0xFFD4, 0xFFD1, 0xFFCF, 0xFFCC, 0xFFC9, 0xFFC6, 0xFFC3, 
	0xFFC0, 0xFFBD, 0xFFBA, 0xFFB7, 0xFFB4, 0xFFB1, 0xFFAE, 0xFFAB, 0xFFA8, 
	0xFFA6, 0xFFA3, 0xFFA0, 0xFF9D, 0xFF9A, 0xFF97, 0xFF94, 0xFF91, 0xFF8F, 
	0xFF8C, 0xFF89, 0xFF87, 0xFF84, 0xFF82, 0xFF80, 0xFF7D, 0xFF7B, 0xFF79, 
	0xFF77, 0xFF75, 0xFF73, 0xFF71, 0xFF6F, 0xFF6E, 0xFF6C, 0xFF6B, 0xFF6A, 
	0xFF68, 0xFF67, 0xFF66, 0xFF66, 0xFF65, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFF9, 0xFFF6, 
	0xFFF4, 0xFFF1, 0xFFEE, 0xFFEB, 0xFFE7, 0xFFE3, 0xFFDF, 0xFFDA, 0xFFD6, 
	0xFFD1, 0xFFCC, 0xFFC7, 0xFFC1, 0xFFBC, 0xFFB6, 0xFFB0, 0xFFAA, 0xFFA3, 
	0xFF9D, 0xFF96, 0xFF90, 0xFF89, 0xFF82, 0xFF7B, 0xFF74, 0xFF6D, 0xFF66, 
	0xFF5F, 0xFF58, 0xFF50, 0xFF49, 0xFF42, 0xFF3B, 0xFF33, 0xFF2C, 0xFF25, 
	0xFF1E, 0xFF17, 0xFF10, 0xFF09, 0xFF02, 0xFEFB, 0xFEF4, 0xFEED, 0xFEE7, 
	0xFEE0, 0xFEDA, 0xFED4, 0xFECE, 0xFEC8, 0xFEC3, 0xFEBD, 0xFEB8, 0xFEB3, 
	0xFEAE, 0xFEA9, 0xFEA5, 0xFEA1, 0xFE9D, 0xFE99, 0xFE96, 0xFE93, 0xFE90, 
	0xFE8D, 0xFE8B, 0xFE89, 0xFE88, 0xFE86, 0xFE86, 0xFE85, 0xFE85, 0x0000, 
	0x1E4A, 0x1E4A, 0x1E4A, 0x1E4A, 0x1DF8, 0x1DA7, 0x1E4A, 0x202B, 0x22B6, 
	0x258E, 0x2853, 0x2AA9, 0x2C30, 0x2C8C, 0x2B3E, 0x2870, 0x24BF, 0x20C9, 
	0x1D29, 0x1A7F, 0x1966, 0x1A5B, 0x1D00, 0x20AA, 0x24B0, 0x2868, 0x2B26, 
	0x2C9F, 0x2D42, 0x2D7F, 0x2DC5, 0x2DE1, 0x2DC5, 0x2DFD, 0x2E59, 0x2E6C, 
	0x2DC5, 0x2C68, 0x2AB6, 0x28CB, 0x26C3, 0x24B9, 0x22C9, 0x2111, 0x1FAA, 
	0x1EB2, 0x1E25, 0x1DE3, 0x1DDF, 0x1E07, 0x1E4F, 0x1EA6, 0x1EFD, 0x1F47, 
	0x1F73, 0x1F73, 0x1F37, 0x1EB2, 0x1D43, 0x1ABA, 0x17A9, 0x14A4, 0x1240, 
	0x1110, 0x11A8, 0x1513, 0x1BB6, 0x2532, 0x3126, 0x4AF7, 0x491E, 0x44C9, 
	0x44EE, 0x4554, 0x45EF, 0x46B4, 0x4796, 0x4888, 0x497F, 0x4A21, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0002, 0x0005, 0xFFFF, 0xFFF1, 0xFFDD, 0xFFC7, 
	0xFFB1, 0xFF9E, 0xFF91, 0xFF8C, 0xFF92, 0xFFA2, 0xFFB7, 0xFFCF, 0xFFE5, 
	0xFFF6, 0xFFFC, 0xFFF3, 0xFFDE, 0xFFC2, 0xFFA7, 0xFF93, 0xFF8C, 0xFF9E, 
	0xFFC5, 0xFFF2, 0x0013, 0x0019, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 
	0x0013, 0x0013, 0x0013, 0x0017, 0x0021, 0x002B, 0x0033, 0x0035, 0x002B, 
	0x0013, 0xFFE1, 0xFF91, 0xFF28, 0xFEAC, 0xFB7C, 0xFA5E, 0xFD74, 0x016E, 
	0x0495, 0x06FE, 0x08BC, 0x09E3, 0x0A86, 0x0AB8, 0x09D3, 0xFF2F, 0xFF2F, 
	0xFF2F, 0xFF2F, 0xFF2E, 0xFF2D, 0xFF2F, 0xFF33, 0xFF39, 0xFF40, 0xFF47, 
	0xFF4D, 0xFF51, 0xFF52, 0xFF50, 0xFF4B, 0xFF43, 0xFF3C, 0xFF35, 0xFF30, 
	0xFF2F, 0xFF33, 0xFF3D, 0xFF48, 0xFF54, 0xFF5D, 0xFF60, 0xFF5A, 0xFF4C, 
	0xFF3C, 0xFF30, 0xFF2E, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 0xFF30, 
	0xFF30, 0xFF30, 0xFF32, 0xFF36, 0xFF3A, 0xFF3E, 0xFF3E, 0xFF3A, 0xFF30, 
	0xFF1F, 0xFF03, 0xFED7, 0xFE95, 0xFCD5, 0xFC2D, 0xFC5F, 0xFC5F, 0xFC5F, 
	0xFC5F, 0xFC5F, 0xFC5F, 0xFC5F, 0xFC5F, 0xFE32, 0xC9D7, 0xC9D7, 0xC9D7, 
	0xC9D7, 0xC94E, 0xC8C6, 0xC9D7, 0xCCEF, 0xD10C, 0xD5A3, 0xDA28, 0xDE11, 
	0xE0D3, 0xE1E2, 0xE094, 0xDD2C, 0xD883, 0xD371, 0xCECF, 0xCB76, 0xCA3F, 
	0xCC47, 0xD120, 0xD756, 0xDD76, 0xE20A, 0xE39E, 0xDFB5, 0xD725, 0xCD75, 
	0xC62C, 0xC4F2, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 0xC62C, 
	0xC62C, 0xC635, 0xC648, 0xC65F, 0xC670, 0xC672, 0xC65F, 0xC62C, 0xC62A, 
	0xC62C, 0xC571, 0xC337, 0xADE1, 0xA7EB, 0xA95C, 0xA95C, 0xA95C, 0xA95C, 
	0xA95C, 0xA95C, 0xA95C, 0xA95C, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x004C, 0x0001, 0x004E, 0x004D, 0x0001, 0x009B, 0x0001, 
	0x009C, 0x0001, 0x009D, 0x0050, 0x009E, 0x0050, 0x00EE, 0x0050, 0x013E, 
	0x0050, 0x018E, 0x0050, 0x01DE, 0x0050, 0x022E, 0x0050, 0x027E, 0x0050, 
	0x02CE, 0x0050, 0x031E, 0x0001, 0x036E, 0x0001, 0x036F, 0x0001, 0x0370, 
	0x0050, 0x0371, 0x0050, 0x03C1, 0x0050, 0x0411, 0x0050, 0x0461, 0x0050, 
	0x04B1, 0x0050, 0x0501, 0x0050, 0x0551, 0x0050, 0x05A1, 0x0050, 0x05F1, 
	0x0001, 0x0641, 0x0001, 0x0642, 0x0050, 0x0643, 0x0050, 0x0693, 0x0050, 
	0x06E3, 0x0050, 0x0733, 0x0050, 0x0783, 0x004D, 0x07D3, 0x0050, 0x0820, 
	0x0050, 0x0870, 0x0050, 0x08C0, 0x0050, 0x0910, 0x0050, 0x0960, 0x004F, 
	0x09B0, 0x0001, 0x09FF, 0x0050, 0x0A00, 0x0050, 0x0A50, 0x0050, 0x0AA0, 
	0x0050, 0x0AF0, 0x0050, 0x0B40, 0x0050, 0x0B90, 0x0050, 0x0BE0, 0x0050, 
	0x0C30, 0x0050, 0x0C80, 0x0050, 0x0CD0, 0x004F, 0x0D20, 0x001F, 0x0D6F, 
	0x0050, 0x0D8E, 0x0050, 0x0DDE, 0x0050, 0x0E2E, 0x0050, 0x0E7E, 0x0050, 
	0x0ECE, 0x0050, 0x0F1E, 0x0050, 0x0F6E, 0x0050, 0x0FBE, 0x0050, 0x100E, 
	

});

smlua_anim_util_register_animation('donkey_2c_land_on_stomach',1, 0, 0, 0, 79, { 
	0x0000, 0x005E, 0x005B, 0x0056, 0x0053, 0x003C, 0x003E, 0x003B, 0x0059, 
	0x006B, 0x0061, 0x004A, 0x0039, 0x003A, 0x0040, 0x003B, 0x0036, 0x0035, 
	0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0036, 0x0039, 0x003B, 
	0x003B, 0x003B, 0x003A, 0x0039, 0x0037, 0x0034, 0x0031, 0x002E, 0x002A, 
	0x0026, 0x0022, 0x001F, 0x001D, 0x001B, 0x001A, 0x0019, 0x0018, 0x0017, 
	0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0017, 0x0018, 0x0018, 0x001A, 
	0x001B, 0x001C, 0x001E, 0x0020, 0x0023, 0x0026, 0x0028, 0x002B, 0x002E, 
	0x0031, 0x0034, 0x0038, 0x003B, 0x003E, 0x0042, 0x0059, 0x007C, 0x009D, 
	0x00AB, 0x00AA, 0x00A6, 0x00A1, 0x009B, 0x0095, 0x0090, 0x008D, 0x008B, 
	0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x5639, 
	0x5639, 0x595E, 0x60C9, 0x6971, 0x704C, 0x7419, 0x7681, 0x78DB, 0x7BB6, 
	0x7E26, 0x7FD1, 0x809A, 0x80A2, 0x807A, 0x8033, 0x7FDD, 0x7F92, 0x7F5F, 
	0x7FAA, 0x8048, 0x8070, 0x7F5F, 0x7D1C, 0x7A43, 0x76FD, 0x7374, 0x6FCF, 
	0x6C39, 0x6869, 0x643B, 0x6014, 0x5C55, 0x58C3, 0x54FF, 0x5141, 0x4DBE, 
	0x4AAE, 0x4846, 0x46BD, 0x45C9, 0x44FB, 0x4453, 0x43D0, 0x4373, 0x433C, 
	0x432A, 0x433E, 0x4376, 0x43D4, 0x4457, 0x44FF, 0x45CC, 0x46BD, 0x47E3, 
	0x4946, 0x4AE0, 0x4CA9, 0x4E9A, 0x50AB, 0x52D6, 0x5511, 0x5757, 0x599F, 
	0x5BE3, 0x5E1A, 0x603D, 0x6246, 0x642C, 0x65CA, 0x65B4, 0x6378, 0x6082, 
	0x5DE8, 0x5BAD, 0x59D4, 0x585E, 0x5750, 0x56AC, 0x5675, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0093, 0x017B, 0x0268, 0x030C, 0x0319, 0x0062, 0xFD8E, 0xFD2D, 0xFD24, 
	0xFD59, 0xFDB3, 0xFE18, 0xFE6E, 0xFEED, 0xFF98, 0x0000, 0x001A, 0x0028, 
	0x002C, 0x0029, 0x0021, 0x0016, 0x000B, 0x0007, 0x0004, 0x0002, 0x0001, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x131B, 0x10CD, 0x0B4F, 0x04C0, 0xFF41, 
	0xFCF3, 0xFE79, 0x014E, 0x02D3, 0xFC1C, 0xEFA4, 0xE8ED, 0xE90A, 0xE958, 
	0xE9C8, 0xEA4D, 0xEADA, 0xEB5F, 0xEBCF, 0xEC1D, 0xEC3A, 0xEBD2, 0xEACD, 
	0xE97B, 0xE828, 0xE724, 0xE6BC, 0xE7AD, 0xEA2C, 0xEDBC, 0xF1DE, 0xF616, 
	0xF9E5, 0xFCE6, 0xFF17, 0x008E, 0x015E, 0x019F, 0x0168, 0x015A, 0x017C, 
	0x01DA, 0x027D, 0x04A3, 0x0720, 0x0883, 0x09C5, 0x0AEF, 0x0C0A, 0x0D1E, 
	0x0E35, 0x0F50, 0x1051, 0x1112, 0x119F, 0x1222, 0x129D, 0x1310, 0x137E, 
	0x13E7, 0x144D, 0x130D, 0x0FD6, 0x0B6F, 0x06A4, 0x023D, 0xFF05, 0xFDC5, 
	0x004F, 0x05E2, 0x0B76, 0x0DFF, 0x0D8D, 0x0C60, 0x0AB6, 0x08CF, 0x06E7, 
	0x053E, 0x0411, 0x039F, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0009, 0x0018, 0x001B, 0xFFFF, 
	0xFF7C, 0xFE9F, 0xFDD7, 0xFD94, 0xFE46, 0x0292, 0x08B8, 0x0A8F, 0x0233, 
	0xF589, 0xF016, 0xFB07, 0x0D2F, 0x1688, 0x0C43, 0xF92F, 0xEDAB, 0xF346, 
	0x0072, 0x08E3, 0x05E8, 0xFE31, 0xF989, 0xFC35, 0x01F1, 0x05B4, 0x0589, 
	0x03C8, 0x01DF, 0x013E, 0x0207, 0x034D, 0x04E4, 0x06A0, 0x0853, 0x09D1, 
	0x0AEE, 0x0B7E, 0x0B6E, 0x0AB9, 0x0930, 0x0724, 0x04E6, 0x02C7, 0x0117, 
	0x0027, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFD, 0xFFF9, 0xFFF9, 0xFFFF, 0x000D, 
	0x001F, 0x0034, 0x004F, 0x006F, 0x00A9, 0x00F2, 0x011A, 0x0108, 0x00D6, 
	0x009E, 0x004E, 0xFFFA, 0xFFF6, 0x00B7, 0x01CA, 0x0229, 0x0104, 0xFF2C, 
	0xFE14, 0xFE97, 0xFFDA, 0x00BC, 0x00C5, 0x006D, 0xFFFF, 0xFF93, 0xFF15, 
	0xFE93, 0xFE19, 0xFD9B, 0xFD09, 0xFC71, 0xFBDD, 0xFB5B, 0xFAF5, 0xFAB8, 
	0xFAB0, 0xFAF1, 0xFB87, 0xFC4E, 0xFD2B, 0xFE06, 0xFEC2, 0xFF47, 0xFF79, 
	0x0000, 0xE927, 0xE8CB, 0xE7C9, 0xE643, 0xDAAC, 0xC9F0, 0xC166, 0xC348, 
	0xC7C6, 0xCD23, 0xD1A1, 0xD383, 0xD30E, 0xD1D6, 0xD011, 0xCDF9, 0xCBC4, 
	0xC9AC, 0xC7E7, 0xC6AF, 0xC63A, 0xCA49, 0xD411, 0xDFF7, 0xEA61, 0xF282, 
	0xFA86, 0x0169, 0x0628, 0x0723, 0x04DA, 0x017C, 0xFF3B, 0xFE81, 0xFE26, 
	0xFDF9, 0xFDC9, 0xFD65, 0xFCA2, 0xFBAA, 0xFAC6, 0xFA41, 0xF9D0, 0xF8E0, 
	0xF6E0, 0xF462, 0xF286, 0xF22E, 0xF279, 0xF1EB, 0xEF88, 0xEC4B, 0xE9A6, 
	0xE858, 0xE7A2, 0xE6B7, 0xE4E4, 0xE2DC, 0xE1E5, 0xE25E, 0xE38F, 0xE51C, 
	0xE6A9, 0xE837, 0xE9F6, 0xEBCD, 0xEDA3, 0xEF61, 0xF0ED, 0xF230, 0xF311, 
	0xF348, 0xF34A, 0xF34B, 0xF34B, 0xF34C, 0xF34C, 0xF34C, 0xF34C, 0xEE2F, 
	0x0001, 0xFFFE, 0xC170, 0xA9CD, 0xA9CD, 0x9934, 0xF167, 0x4174, 0x185D, 
	0x0527, 0xC379, 0x92F8, 0x9A9A, 0x0168, 0xC142, 0x0884, 0xF868, 0xEE91, 
	0xE93E, 0xE6AA, 0xE514, 0xE2B8, 0xE11B, 0xE21F, 0xE48E, 0xE733, 0xEA0D, 
	0xED9D, 0xF173, 0xF51F, 0xF832, 0xFA3B, 0xFA38, 0xF861, 0xF625, 0xF4EF, 
	0xF4CD, 0xF4D6, 0xF501, 0xF546, 0xF59B, 0xF5F8, 0xF655, 0xF6A8, 0xF6EA, 
	0xF710, 0xF723, 0xF72F, 0xF735, 0xF736, 0xF734, 0xF72E, 0xF726, 0xF71E, 
	0xF715, 0xF70E, 0xF709, 0xF707, 0xF709, 0xF710, 0xF6DD, 0xF658, 0xF5C4, 
	0xF560, 0xF56F, 0xF632, 0xF7E9, 0xFBC1, 0x01C4, 0x0882, 0x0E87, 0x1262, 
	0x0C43, 0x07F5, 0x13BB, 0x20B6, 0xAA02, 0xB03E, 0x3406, 0x35F7, 0x36AF, 
	0x36C9, 0x1DCC, 0xDCC8, 0xDCC8, 0xDB40, 0xA883, 0xD2B8, 0xCE34, 0xCB2E, 
	0xB2CA, 0xCFBA, 0xCB79, 0xB843, 0xB44C, 0xD058, 0xD197, 0xD268, 0xD2E9, 
	0xD338, 0xD374, 0xD3BB, 0xD37A, 0xD2B7, 0xD276, 0xD3BB, 0xD6C9, 0xDADE, 
	0xDF7B, 0xE41D, 0xE845, 0xEB71, 0xED5A, 0xEE23, 0xEDEF, 0xECE0, 0xEB30, 
	0xE915, 0xE6AC, 0xE415, 0xE16C, 0xDED2, 0xDC64, 0xDA40, 0xD885, 0xD752, 
	0xD688, 0xD5F3, 0xD58C, 0xD550, 0xD539, 0xD540, 0xD561, 0xD596, 0xD5DA, 
	0xD628, 0xD67A, 0xD6CA, 0xD714, 0xD752, 0xD76F, 0xD777, 0xD791, 0xD7E3, 
	0xD896, 0xD9D2, 0xDBBD, 0xDF40, 0xE46D, 0xEA2F, 0xEF6F, 0xF316, 0xF216, 
	0xED2E, 0xE5C0, 0xE0C0, 0xA186, 0xA238, 0xDD8B, 0xDCA4, 0xD9EF, 0xD44B, 
	0xD901, 0x076C, 0x076C, 0x1296, 0xAD6F, 0x4E05, 0x6A5D, 0x7885, 0xD38C, 
	0x2194, 0x1591, 0x9F64, 0xD5C0, 0x772D, 0x8427, 0x8CCD, 0x924C, 0x95D0, 
	0x9885, 0x9B97, 0x9DB8, 0x93EC, 0x9C84, 0x9B97, 0x9AD2, 0x999E, 0x9852, 
	0x9743, 0x96CA, 0x973D, 0x9B03, 0xA17D, 0xA67E, 0xA5D5, 0x9FDE, 0x9810, 
	0x8EEA, 0x84EC, 0x7A91, 0x705C, 0x66CB, 0x5E5C, 0x578E, 0x52DF, 0x4FC0, 
	0x4D44, 0x4B62, 0x4A10, 0x4943, 0x48F0, 0x490F, 0x4994, 0x4A75, 0x4BA9, 
	0x4D24, 0x4EDD, 0x50CA, 0x52DF, 0x5683, 0x5C8D, 0x641D, 0x6C51, 0x744B, 
	0x7B2A, 0x8010, 0x81FB, 0x816B, 0x7FB3, 0x7E2C, 0x7E29, 0x8429, 0x8864, 
	0x8230, 0x8419, 0x0904, 0x0FBD, 0x9710, 0x9DC9, 0xA2B4, 0xA49C, 0xB867, 
	0xFFFF, 0x0024, 0x008F, 0x013B, 0x0227, 0x034D, 0x04AB, 0x063C, 0x07FE, 
	0x09EC, 0x0C02, 0x0E3E, 0x109B, 0x1316, 0x15AA, 0x1855, 0x1B13, 0x1DE0, 
	0x20B8, 0x2397, 0x267B, 0x295F, 0x2C3F, 0x2F19, 0x31E8, 0x34A8, 0x3757, 
	0x39EF, 0x3C6F, 0x3ED1, 0x4113, 0x4330, 0x4525, 0x46EE, 0x4889, 0xC9EF, 
	0xCB1F, 0xCC15, 0xCCCD, 0xCD43, 0xCD73, 0xCD80, 0xCD8B, 0xCD96, 0xCDA1, 
	0xCDAB, 0xCDB4, 0xCDBC, 0xCDC5, 0xCDCC, 0xCDD3, 0xCDDA, 0xCDE0, 0x4DE6, 
	0x4DEC, 0x4DF0, 0x4DF5, 0x4DF9, 0x4DFC, 0x4E00, 0x4E03, 0x4E05, 0x4E08, 
	0x4E0A, 0x4E0C, 0x4E0D, 0x4E0F, 0x4E10, 0x4E11, 0x4E12, 0x4E12, 0x4E13, 
	0x4E13, 0x4E13, 0x4E14, 0x4E14, 0x4E14, 0x4E14, 0x4E14, 0x0000, 0xFFFF, 
	0x0013, 0x004A, 0x00A4, 0x011E, 0x01B7, 0x026C, 0x033D, 0x0426, 0x0526, 
	0x063B, 0x0764, 0x089D, 0x09E6, 0x0B3D, 0x0C9E, 0x0E0A, 0x0F7D, 0x10F6, 
	0x1272, 0x13F1, 0x156F, 0x16EC, 0x1865, 0x19D8, 0x1B43, 0x1CA5, 0x1DFB, 
	0x1F44, 0x207E, 0x21A6, 0x22BC, 0x23BC, 0x24A5, 0x2575, 0x59D4, 0x593C, 
	0x58C1, 0x5868, 0x5831, 0x581E, 0x581E, 0x581F, 0x5822, 0x5827, 0x582F, 
	0x583C, 0x584E, 0x5865, 0x5883, 0x58A9, 0x58D7, 0x590F, 0x26AF, 0x2663, 
	0x260B, 0x25A7, 0x2535, 0x24B5, 0x2426, 0x2387, 0x22D7, 0x2215, 0x2142, 
	0x205B, 0x1F60, 0x1E50, 0x1D2A, 0x1BEE, 0x1A9A, 0x192E, 0x17A9, 0x160A, 
	0x1450, 0x127B, 0x1089, 0x0E7A, 0x0C4D, 0x0A01, 0x0000, 0xE258, 0xE23F, 
	0xE1F5, 0xE17C, 0xE0D8, 0xE00A, 0xDF16, 0xDDFD, 0xDCC4, 0xDB6B, 0xD9F6, 
	0xD867, 0xD6C1, 0xD507, 0xD33A, 0xD15E, 0xCF75, 0xCD82, 0xCB87, 0xC987, 
	0xC784, 0xC582, 0xC381, 0xC186, 0xBF93, 0xBDAA, 0xBBCE, 0xBA02, 0xB847, 
	0xB6A1, 0xB512, 0xB39D, 0xB245, 0xB10B, 0xAFF3, 0x2EFF, 0x2E31, 0x2D8D, 
	0x2D14, 0x2CCA, 0x2CB1, 0x2CC1, 0x2CF1, 0x2D3F, 0x2DA9, 0x2E2D, 0x2ECA, 
	0x2F7E, 0x3046, 0x3122, 0x3210, 0x330D, 0x3419, 0xB530, 0xB652, 0xB77D, 
	0xB8AF, 0xB9E7, 0xBB21, 0xBC5E, 0xBD9B, 0xBED5, 0xC00D, 0xC13F, 0xC26A, 
	0xC38C, 0xC4A4, 0xC5AF, 0xC6AD, 0xC79A, 0xC876, 0xC93F, 0xC9F3, 0xCA8F, 
	0xCB14, 0xCB7E, 0xCBCB, 0xCBFB, 0xCC0C, 0xC9F4, 0xE6B3, 0xE6B3, 0xE6B3, 
	0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE6B3, 0xE60D, 
	0xE6B3, 0xE9C3, 0xED7E, 0xF182, 0xF570, 0xF8E8, 0xFB89, 0xFC43, 0xFB64, 
	0xFA97, 0xFB89, 0xFEF4, 0x03D7, 0x0942, 0x0E41, 0x11E4, 0x133A, 0x1284, 
	0x10CA, 0x0E3F, 0x0B1A, 0x078F, 0x03D3, 0x001C, 0xFC9F, 0xF990, 0xF667, 
	0xF2E3, 0xEFA2, 0xED43, 0xEC66, 0xECB4, 0xED61, 0xEE5D, 0xEF97, 0xF100, 
	0xF288, 0xF41D, 0xF5B0, 0xF730, 0xF88E, 0xF9B9, 0xFAA0, 0xFB35, 0xFB65, 
	0xF891, 0xF296, 0xED24, 0xEBE9, 0xF098, 0xF8CF, 0x0221, 0x0A1F, 0x0E5C, 
	0x1141, 0x14D4, 0x1611, 0x13B3, 0x0F80, 0x0B07, 0x0167, 0xF30E, 0xE23F, 
	0xD13E, 0xC24C, 0xB7AC, 0xB3A1, 0x071C, 0xF989, 0xF989, 0xF989, 0xF989, 
	0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF989, 0xF98B, 0xF989, 
	0xF980, 0xF975, 0xF969, 0xF95E, 0xF954, 0xF94C, 0xF939, 0xF91F, 0xF91B, 
	0xF94C, 0xF970, 0xF95F, 0xF961, 0xF9BE, 0xFABB, 0xFCA0, 0x01A2, 0x094C, 
	0x0FE4, 0x11B2, 0x0CEA, 0x040E, 0xF9D3, 0xF0F1, 0xEC20, 0xECD9, 0xF14C, 
	0xF743, 0xFC87, 0xFEE1, 0xFEDC, 0xFE82, 0xFDDD, 0xFCF9, 0xFBDF, 0xFA99, 
	0xF932, 0xF7B4, 0xF62A, 0xF49C, 0xF317, 0xF1A3, 0xF04C, 0xEF1C, 0xEDD3, 
	0xEC73, 0xEB64, 0xEB0E, 0xEB35, 0xEB61, 0xEBA7, 0xEC18, 0xECC9, 0xEDCC, 
	0xEF34, 0xF114, 0xF533, 0xFB90, 0x0196, 0x019F, 0x01BA, 0x01E3, 0x0217, 
	0x0253, 0x0294, 0x02D8, 0x0306, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 
	0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2E8, 0xF2EA, 0xF2E8, 0xF2DB, 
	0xF2CC, 0xF2BB, 0xF2AB, 0xF29D, 0xF292, 0xF2D8, 0xF355, 0xF371, 0xF292, 
	0xF07D, 0xEDA3, 0xEA72, 0xE752, 0xE4B1, 0xE2F8, 0xE328, 0xE4F5, 0xE6DA, 
	0xE752, 0xE597, 0xE296, 0xDF56, 0xDCDF, 0xDC39, 0xDE49, 0xE260, 0xE725, 
	0xEB3D, 0xED51, 0xEDC6, 0xEDF1, 0xEDDB, 0xED8F, 0xED18, 0xEC80, 0xEBD1, 
	0xEB16, 0xEA58, 0xE9A3, 0xE901, 0xE87C, 0xE81E, 0xE7F2, 0xE8A2, 0xEA32, 
	0xEBB5, 0xEC3C, 0xEBBA, 0xEAD3, 0xE9AB, 0xE863, 0xE71E, 0xE5FE, 0xE525, 
	0xE4B6, 0xE54A, 0xE6E1, 0xE8B7, 0xEC76, 0xF1F3, 0xF856, 0xFEC6, 0x046D, 
	0x086F, 0x09F5, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0x6508, 0x6508, 0x6F8C, 
	0x08BD, 0x2705, 0xC0D9, 0xCCAD, 0x232A, 0xF080, 0x71AB, 0x0A2F, 0x3D89, 
	0xE8B6, 0xF31D, 0xF818, 0xF957, 0xF88D, 0xF76A, 0xF7A2, 0xF85D, 0xF818, 
	0xF782, 0xF746, 0xF7BB, 0xF86B, 0xF8D5, 0xF8D6, 0xF890, 0xF7F4, 0xF71C, 
	0xF635, 0xF542, 0xF445, 0xF340, 0xF237, 0xF12B, 0xF021, 0xEF1B, 0xEE1B, 
	0xED23, 0xEC38, 0xEB5B, 0xEA8F, 0xE9D8, 0xE937, 0xE8AF, 0xE852, 0xE82A, 
	0xE82E, 0xE855, 0xE895, 0xE8E5, 0xE93C, 0xE991, 0xE9DB, 0xEA11, 0xEA2A, 
	0xEA1C, 0xE9DE, 0xE967, 0xE8AF, 0xE6C3, 0xE343, 0xDF01, 0xDACB, 0xD773, 
	0xD5D6, 0xD51F, 0xD38F, 0x50EE, 0x4A96, 0x3E0C, 0x3E23, 0x3E5E, 0x3EB0, 
	0x3F09, 0x3F5A, 0x3F96, 0x3FAD, 0x36DA, 0x2753, 0x2753, 0x28B0, 0x5408, 
	0x5007, 0x337E, 0x3552, 0x4EDC, 0x5492, 0x2ADF, 0x5492, 0x5553, 0x2A83, 
	0x2BBF, 0x2D62, 0x2F2C, 0x30E1, 0x3242, 0x3312, 0x3339, 0x32B0, 0x3154, 
	0x2EFF, 0x2AC8, 0x24EE, 0x1F0D, 0x185F, 0x11A9, 0x0ED8, 0x0F71, 0x1053, 
	0x1176, 0x12D0, 0x1459, 0x1607, 0x17D1, 0x19AD, 0x1B94, 0x1D7B, 0x1F59, 
	0x2126, 0x22D7, 0x2465, 0x25C6, 0x26F0, 0x27DB, 0x289A, 0x2946, 0x29DD, 
	0x2A5E, 0x2AC5, 0x2B12, 0x2B43, 0x2B55, 0x2B46, 0x2B15, 0x2AC0, 0x2A45, 
	0x29A1, 0x28D4, 0x27DB, 0x2562, 0x20DC, 0x1B73, 0x1651, 0x129D, 0x1142, 
	0x11BD, 0x1313, 0x69CD, 0x6630, 0x649F, 0x63F3, 0x637F, 0x62FA, 0x621B, 
	0x609A, 0x5E30, 0x5A93, 0x54F5, 0x193F, 0x193F, 0x1ED9, 0xAC51, 0xBCAB, 
	0x4AE9, 0x520C, 0xBF8F, 0xA6B1, 0x1FD2, 0xA6B1, 0xDEA9, 0x694D, 0x717D, 
	0x7609, 0x7809, 0x7894, 0x78C3, 0x79AD, 0x7A16, 0x7923, 0x7877, 0x79BB, 
	0x7ECA, 0x8651, 0x8D20, 0x926D, 0x9704, 0x9A24, 0x9C49, 0x9E6D, 0xA08E, 
	0xA2A9, 0xA4BC, 0xA6C5, 0xA8C2, 0xAAB0, 0xAC8D, 0xAE56, 0xB00A, 0xB1A6, 
	0xB328, 0xB48D, 0xB5D3, 0xB6F7, 0xB7F8, 0xB8EC, 0xB9E3, 0xBAD5, 0xBBB9, 
	0xBC86, 0xBD34, 0xBDB8, 0xBE0B, 0xBE24, 0xBDF9, 0xBD82, 0xBCB5, 0xBB8B, 
	0xB9FA, 0xB7F8, 0xB2F9, 0xA9DE, 0x9ECB, 0x93E2, 0x8B46, 0x86C0, 0x84AA, 
	0x81F8, 0xFDEC, 0xF73C, 0xEC64, 0xEF0E, 0xF5ED, 0xFF51, 0x098E, 0x12F3, 
	0x19D2, 0x1C7C, 0x175C, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0028, 0x009A, 0x014B, 0x0231, 0x0341, 0x0471, 
	0x05B5, 0x0704, 0x0853, 0x0997, 0x0AC7, 0x0BD7, 0x0CBD, 0x0D6E, 0x0DE0, 
	0x0E08, 0x0DB4, 0x0CCF, 0x0B78, 0x09D1, 0x07F8, 0x0610, 0x0437, 0x0290, 
	0x0139, 0x0054, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0002, 0x0008, 0x0014, 0x0026, 
	0x0042, 0x0069, 0x009D, 0x00DF, 0x0132, 0x0197, 0x0211, 0x02A0, 0x0347, 
	0x0408, 0x04E5, 0x05DF, 0x06F8, 0x0832, 0x098F, 0x0B11, 0x0CB9, 0x0E8A, 
	0x1085, 0x12B0, 0x1508, 0x1781, 0x1A11, 0x1CAD, 0x1F49, 0x21DA, 0x2455, 
	0x26B0, 0x28DE, 0x2AD5, 0x2C89, 0x2DF0, 0x2EFE, 0x2FA8, 0x2FE3, 0x2EC6, 
	0x2BB7, 0x2725, 0x217F, 0x1B33, 0x14B0, 0x0E64, 0x08BE, 0x042C, 0x011E, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xEE91, 
	0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 
	0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 0xEE91, 
	0xEE91, 0xEE91, 0xEE67, 0xEDEF, 0xED30, 0xEC30, 0xEAF8, 0xE98D, 0xE7F8, 
	0xE63F, 0xE469, 0xE27E, 0xE085, 0xDE85, 0xDC85, 0xDA8B, 0xD8A0, 0xD6CB, 
	0xD512, 0xD37C, 0xD212, 0xD0D9, 0xCFDA, 0xCF1A, 0xCEA2, 0xCE79, 0xCE79, 
	0xCE7A, 0xCE7E, 0xCE85, 0xCE91, 0xCEA2, 0xCEBA, 0xCEDA, 0xCF04, 0xCF38, 
	0xCF77, 0xCFC3, 0xD01C, 0xD085, 0xD0FE, 0xD187, 0xD29E, 0xD497, 0xD73F, 
	0xDA5F, 0xDDC2, 0xE132, 0xE47A, 0xE765, 0xE9BC, 0xEB4B, 0xEBDC, 0xEBCA, 
	0xEB4F, 0xEA01, 0xE775, 0xE343, 0xDD00, 0xD444, 0xCB60, 0x2B98, 0x2B98, 
	0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2B98, 0x2D60, 0x2B98, 
	0x1C67, 0x0F13, 0x0CC7, 0x0C4D, 0x0D08, 0x0E5A, 0x0FA5, 0x104B, 0x1102, 
	0x1214, 0x1241, 0x104B, 0x0A17, 0x00D3, 0xF835, 0xF078, 0xE960, 0xE5F1, 
	0xE5A3, 0xE5DC, 0xE684, 0xE782, 0xE8BD, 0xEA1E, 0xEB8A, 0xECEB, 0xEE26, 
	0xEF24, 0xEFCD, 0xEFFA, 0xEFB6, 0xEF2D, 0xEE8D, 0xEE02, 0xEDB8, 0xEDA6, 
	0xED9E, 0xEDA1, 0xEDAB, 0xEDBA, 0xEDCD, 0xEDE1, 0xEDF5, 0xEE05, 0xEE11, 
	0xEE16, 0xEE11, 0xEE01, 0xEDE5, 0xEDB8, 0xED38, 0xEC4E, 0xEB3A, 0xEA3E, 
	0xE99E, 0xE880, 0xE7E5, 0xEACF, 0xF3AD, 0xFFFC, 0x0B5B, 0xFF76, 0xF6F1, 
	0xF13B, 0xEDC4, 0xEBFD, 0xEB55, 0xEB3D, 0xFA42, 0x0E42, 0x0E42, 0x0E42, 
	0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 
	0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0E42, 0x0DEF, 0x0D64, 
	0x0D48, 0x0E42, 0x11B1, 0x16AB, 0x1A66, 0x1BE9, 0x1C2C, 0x1B53, 0x19D2, 
	0x1812, 0x1623, 0x1415, 0x11F7, 0x0FD8, 0x0DC8, 0x0BD7, 0x0A14, 0x088E, 
	0x0755, 0x06BF, 0x06E8, 0x0789, 0x085A, 0x0917, 0x0976, 0x097E, 0x0966, 
	0x0936, 0x08F3, 0x08A7, 0x0857, 0x080A, 0x07C8, 0x0798, 0x0781, 0x0789, 
	0x07B9, 0x0816, 0x08A8, 0x0976, 0x0B63, 0x0EDD, 0x133F, 0x17E0, 0x1C1B, 
	0x2182, 0x2701, 0x27FB, 0x2221, 0x1891, 0x0ECD, 0x0DBE, 0x0D44, 0x0D24, 
	0x0D22, 0x0D01, 0x0C88, 0x0B79, 0x0197, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 
	0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 
	0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA48, 0xEA5A, 0xEA78, 0xEA7E, 
	0xEA48, 0xEAC8, 0xEAF2, 0xE7A7, 0xDC2E, 0xCD40, 0xC5EC, 0xC6B5, 0xC89D, 
	0xCB6E, 0xCEF4, 0xD2F8, 0xD746, 0xDBA9, 0xDFEB, 0xE3D7, 0xE738, 0xE9D8, 
	0xEB70, 0xEC0F, 0xEC04, 0xEB9F, 0xEB2E, 0xEB00, 0xEB13, 0xEB2E, 0xEB4F, 
	0xEB73, 0xEB97, 0xEBBA, 0xEBD8, 0xEBEF, 0xEBFD, 0xEBFF, 0xEBF3, 0xEBD6, 
	0xEBA5, 0xEB5F, 0xEB00, 0xEA15, 0xE86A, 0xE65C, 0xE44C, 0xE298, 0xE0C6, 
	0xDF44, 0xDFC6, 0xE34D, 0xE88B, 0xEDC1, 0xF22D, 0xF5BC, 0xF87F, 0xFA86, 
	0xFBE4, 0xFCA9, 0xFCE7, 0x0624, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0xE7BB, 0xE87F, 0xEA76, 0xED1D, 0xEFF3, 0xF277, 0xF529, 0xF7E5, 
	0xF934, 0xF660, 0xF303, 0xF3C9, 0xF559, 0xF5EC, 0xF66F, 0xF6E3, 0xF747, 
	0xF79D, 0xF7E4, 0xF807, 0xF7FF, 0xF7EA, 0xF7E4, 0xF7A3, 0xF704, 0xF669, 
	0xF62F, 0xF6B5, 0xF85B, 0xFC39, 0x023D, 0x0908, 0x0F39, 0x150C, 0x1B5F, 
	0x21C9, 0x27E1, 0xAD3D, 0xB176, 0xB422, 0xB5B9, 0xB6FD, 0xB7F2, 0xB89F, 
	0xB909, 0xB934, 0xB925, 0xB8E2, 0xB870, 0xB7D3, 0xB712, 0xB630, 0xB534, 
	0xB422, 0xB2DA, 0xB140, 0xAF5D, 0xAD39, 0x2ADF, 0x2856, 0x25A8, 0x22DF, 
	0x2004, 0x1D20, 0x1A3C, 0x1761, 0x14AF, 0x11A6, 0x0D5F, 0x06F4, 0xF070, 
	0xF160, 0xF1DC, 0xF2D6, 0xF417, 0xF56D, 0xF6A2, 0xF782, 0xF7D8, 0xFE9B, 
	0xF849, 0xF8D8, 0xFA25, 0xFB9D, 0xFCB1, 0xFCCE, 0xFA4F, 0xF631, 0xF3D3, 
	0xF71D, 0xFAFA, 0xF95F, 0xF6FA, 0xF649, 0xF5C6, 0xF564, 0xF51A, 0xF4DE, 
	0xF4A4, 0xF484, 0xF48A, 0xF49D, 0xF4A4, 0xF4CA, 0xF526, 0xF580, 0xF5A0, 
	0xF54F, 0xF454, 0xF1C6, 0xEDC7, 0xE9AC, 0xE6CD, 0xE528, 0xE3D1, 0xE2BF, 
	0xE1E9, 0x9EB9, 0x9F34, 0x9F8E, 0x9FE1, 0xA03C, 0xA099, 0xA0F3, 0xA146, 
	0xA18C, 0xA1C0, 0xA1DD, 0xA1DE, 0xA1BE, 0xA178, 0xA107, 0xA065, 0x9F8E, 
	0x9E63, 0x9CD6, 0x9AF6, 0x98D6, 0xE977, 0xEBE5, 0xEE60, 0xF0D6, 0xF336, 
	0xF570, 0xF772, 0xF92A, 0xFA30, 0xFA59, 0xF9F5, 0xF952, 0xF5E8, 0xF42A, 
	0xF3DB, 0xF3B8, 0xF3AE, 0xF3AD, 0xF3A4, 0xF380, 0xF331, 0xEFF9, 0xD24C, 
	0xD1D4, 0xD057, 0xCDB9, 0xC9DD, 0xC4A8, 0xB985, 0xAAD5, 0xA2EC, 0xAFE0, 
	0xBF39, 0xBA28, 0xB1C1, 0xAF14, 0xACEC, 0xAB2E, 0xA9C4, 0xA893, 0xA785, 
	0xA6F9, 0xA717, 0xA76C, 0xA785, 0xA772, 0xA778, 0xA775, 0xA746, 0xA6C8, 
	0xA5DA, 0xA43B, 0xA1DD, 0x9EEC, 0x9B95, 0x97A1, 0x9302, 0x8E1B, 0x8950, 
	0x0507, 0x01A2, 0xFF82, 0xFE56, 0xFD7C, 0xFCE9, 0xFC95, 0xFC78, 0xFC89, 
	0xFCBF, 0xFD12, 0xFD79, 0xFDEC, 0xFE63, 0xFED3, 0xFF36, 0xFF82, 0xFFCE, 
	0x0038, 0x00B4, 0x0141, 0x81D8, 0x8278, 0x831A, 0x83BB, 0x8454, 0x84E2, 
	0x855F, 0x85C8, 0x857D, 0x849A, 0x842F, 0x854B, 0x90F0, 0x9186, 0x917F, 
	0x9148, 0x90B3, 0x8F92, 0x8DB5, 0x8AEE, 0x870D, 0x839E, 0x0000, 0x0001, 
	0x0003, 0x0007, 0x000D, 0x0013, 0x001C, 0x0026, 0x0031, 0x003D, 0x004A, 
	0x0059, 0x0069, 0x007A, 0x008D, 0x00A0, 0x00B4, 0x00C9, 0x00DF, 0x00F6, 
	0x010E, 0x0127, 0x0140, 0x015A, 0x0175, 0x0190, 0x01AC, 0x01C9, 0x01E6, 
	0x0203, 0x0221, 0x023F, 0x025E, 0x027D, 0x029C, 0x02BB, 0x02DB, 0x02FA, 
	0x031A, 0x033A, 0x0359, 0x0379, 0x0399, 0x03B8, 0x03D8, 0x03F7, 0x0416, 
	0x0434, 0x0453, 0x0470, 0x048E, 0x04AB, 0x04C7, 0x04E3, 0x04FF, 0x0519, 
	0x0533, 0x054D, 0x0565, 0x057D, 0x0594, 0x05AA, 0x05C0, 0x05D4, 0x05E7, 
	0x05F9, 0x060A, 0x061A, 0x0629, 0x0637, 0x0643, 0x064E, 0x0658, 0x0660, 
	0x0667, 0x066C, 0x0670, 0x0673, 0x0673, 0x0000, 0xFFFF, 0xFFFD, 0xFFF5, 
	0xFFEA, 0xFFDA, 0xFFC5, 0xFFAC, 0xFF8F, 0xFF6E, 0xFF4A, 0xFF21, 0xFEF5, 
	0xFEC6, 0xFE93, 0xFE5D, 0xFE24, 0xFDE7, 0xFDA8, 0xFD66, 0xFD22, 0xFCDB, 
	0xFC92, 0xFC46, 0xFBF9, 0xFBA9, 0xFB58, 0xFB04, 0xFAB0, 0xFA59, 0xFA02, 
	0xF9A9, 0xF94F, 0xF8F4, 0xF898, 0xF83B, 0xF7DE, 0xF780, 0xF722, 0xF6C3, 
	0xF665, 0xF606, 0xF5A8, 0xF54A, 0xF4EC, 0xF48F, 0xF432, 0xF3D6, 0xF37B, 
	0xF321, 0xF2C8, 0xF271, 0xF21A, 0xF1C5, 0xF172, 0xF121, 0xF0D1, 0xF084, 
	0xF038, 0xEFEF, 0xEFA8, 0xEF64, 0xEF22, 0xEEE3, 0xEEA6, 0xEE6D, 0xEE37, 
	0xEE04, 0xEDD5, 0xEDA9, 0xED80, 0xED5B, 0xED3B, 0xED1E, 0xED05, 0xECF0, 
	0xECE0, 0xECD4, 0xECCD, 0xECCB, 0xFFFF, 0x1DE1, 0x1E7F, 0x2005, 0x21F9, 
	0x23DD, 0x2537, 0x259F, 0x256B, 0x2537, 0x2614, 0x2537, 0x1D5C, 0x175C, 
	0x1881, 0x1B09, 0x1E5E, 0x21E8, 0x2510, 0x2740, 0x2789, 0x2670, 0x258A, 
	0x2670, 0x2958, 0x2D2D, 0x3192, 0x3629, 0x3A95, 0x3E79, 0x41A1, 0x444D, 
	0x46CF, 0x4979, 0x4C94, 0x5007, 0x5393, 0x56F9, 0x59FB, 0x5C5B, 0x5DD8, 
	0x5EB1, 0x5F50, 0x5FBB, 0x5FF7, 0x600C, 0x6000, 0x5FD9, 0x5F9C, 0x5F51, 
	0x5EFE, 0x5EA8, 0x5E56, 0x5E0F, 0x5DD8, 0x5DBA, 0x5DB1, 0x5DB3, 0x5DB6, 
	0x5DB1, 0x5D99, 0x5D64, 0x5D0A, 0x5C7E, 0x5BB9, 0x5AAF, 0x5958, 0x571E, 
	0x5349, 0x4D92, 0x45B6, 0x2C3B, 0x2A22, 0x2B24, 0x2DE3, 0x31F2, 0x36E5, 
	0x3C51, 0x41C9, 0x46E2, 0x49EE, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x000F, 
	0x0038, 0x0074, 0x00BC, 0x0108, 0x0153, 0x0193, 0x01C4, 0x01DC, 0x01D6, 
	0x01AB, 0x0153, 0x00C6, 0xFFFF, 0xFEEE, 0xFD90, 0xFBEF, 0xFA16, 0xF811, 
	0xF5E9, 0xF3AA, 0xF15F, 0xEF12, 0xECCF, 0xEAA0, 0xE88F, 0xE626, 0xE3A4, 
	0xE22A, 0xE632, 0xFA21, 0xF031, 0xF031, 0xF031, 0xF031, 0xF031, 0xF031, 
	0xF031, 0xF031, 0xF7AE, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0012, 0x0045, 
	0x008F, 0x00E7, 0x0145, 0x01A0, 0x01F0, 0x022B, 0x024A, 0x0242, 0x020D, 
	0x01A0, 0x00F4, 0xFFFF, 0xFEAF, 0xFD00, 0xFAFE, 0xF8B7, 0xF639, 0xF392, 
	0xF0CE, 0xEDFC, 0xEB29, 0xE862, 0xE5B6, 0xE331, 0xE02B, 0xDD15, 0xDBA2, 
	0xE2EC, 0x0201, 0xF61D, 0xF61D, 0xF61D, 0xF61D, 0xF61D, 0xF61D, 0xF61D, 
	0xF61D, 0x03C6, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 0xBF3F, 
	0xBF3F, 0xBF3F, 0xBD02, 0xBF3F, 0xD24B, 0xE31A, 0xE636, 0xE716, 0xE676, 
	0xE518, 0xE3B9, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
	0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE2E4, 0xE28C, 0xE27A, 0xE31A, 0xE486, 
	0xE66C, 0xE892, 0xEAC2, 0xECC3, 0xEE5B, 0xEF53, 0xEFE1, 0xF060, 0xF0CF, 
	0xF12C, 0xF174, 0xF1A6, 0xF1C1, 0xF1C3, 0xF1A9, 0xF172, 0xF11D, 0xF0A7, 
	0xF00F, 0xEF53, 0xEE5F, 0xED28, 0xEBB7, 0xEA14, 0xE84A, 0xE660, 0xE460, 
	0xE253, 0xE043, 0xDE37, 0xDC3B, 0xDA56, 0xDA64, 0xDA36, 0xD3C4, 0xABFB, 
	0xAF9C, 0xA7ED, 0xA7ED, 0xA7ED, 0xA7ED, 0xA7ED, 0xA7ED, 0xA7ED, 0xA7ED, 
	0xAB92, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x100E, 0x0FFF, 0x0FD0, 0x0F83, 0x0F17, 
	0x0E8D, 0x0D7E, 0x0C1A, 0x0B40, 0x0C07, 0x0D15, 0x0CCE, 0x0C48, 0x0C0B, 
	0x0BD2, 0x0B9E, 0x0B6F, 0x0B47, 0x0B26, 0x0B1D, 0x0B2A, 0x0B35, 0x0B26, 
	0x0B30, 0x0B6D, 0x0BA2, 0x0B93, 0x0B05, 0x09BB, 0x074B, 0x03A2, 0xFF0D, 
	0xF9D5, 0xF3A8, 0xEC6C, 0xE4BF, 0xDD3D, 0xD685, 0xD133, 0xCDE5, 0xCC05, 
	0x4A90, 0x497D, 0x48C3, 0x485C, 0x483E, 0x4862, 0x48BF, 0x494E, 0x4A07, 
	0x4AE1, 0xCBD3, 0xCCD7, 0xCDE5, 0xCF14, 0xD082, 0xD22B, 0xD40D, 0xD623, 
	0xD86A, 0xDAE0, 0xDD81, 0xE049, 0xE335, 0xE643, 0xE96E, 0xEDA2, 0xF36A, 
	0xFA37, 0x0179, 0x0DEC, 0x09D5, 0x06B5, 0x0478, 0x02F8, 0x020F, 0x0197, 
	0x016B, 0x0165, 0x01C0, 0x0F96, 0x0E80, 0x0BE1, 0x08A7, 0x05C3, 0x0424, 
	0x0542, 0x082C, 0x0A36, 0x0934, 0x07AF, 0x0825, 0x08EF, 0x093F, 0x0986, 
	0x09C5, 0x09FC, 0x0A2B, 0x0A52, 0x0A60, 0x0A53, 0x0A45, 0x0A52, 0x0A36, 
	0x09D2, 0x0975, 0x0970, 0x0A12, 0x0BAA, 0x1000, 0x16BF, 0x1D11, 0x201E, 
	0x1FB4, 0x1DDC, 0x1B17, 0x17E6, 0x14CA, 0x1243, 0x10D2, 0x1031, 0x7042, 
	0x708C, 0x70B2, 0x70BA, 0x70A9, 0x7085, 0x7053, 0x7018, 0x6FDA, 0x6F9E, 
	0x1096, 0x10BD, 0x10D2, 0x10DB, 0x10E2, 0x10E8, 0x10F0, 0x10FA, 0x1106, 
	0x1116, 0x112C, 0x1147, 0x116A, 0x1195, 0x11CA, 0x1283, 0x13B6, 0x149B, 
	0x146B, 0x0CD6, 0x0B41, 0x0BAA, 0x0CB9, 0x0E2B, 0x0FBF, 0x1132, 0x1241, 
	0x12AA, 0x1192, 0xC65D, 0xC5F9, 0xC4D3, 0xC2F7, 0xC071, 0xBD4C, 0xB76D, 
	0xAFBF, 0xAAD3, 0xAE3C, 0xB334, 0xB1C6, 0xAF3E, 0xAE31, 0xAD3B, 0xAC5F, 
	0xAB9C, 0xAAF6, 0xAA6C, 0xAA40, 0xAA72, 0xAAA1, 0xAA6C, 0xA9E2, 0xA94A, 
	0xA895, 0xA7B0, 0xA68D, 0xA51B, 0xA304, 0xA041, 0x9D2F, 0x9A30, 0x9718, 
	0x93A8, 0x901F, 0x8CBA, 0x89BA, 0x875C, 0x85DF, 0x8500, 0x0451, 0x03CD, 
	0x0372, 0x033C, 0x0329, 0x0334, 0x035C, 0x039C, 0x03F2, 0x045A, 0x84D0, 
	0x8553, 0x85DF, 0x8683, 0x874E, 0x883E, 0x894D, 0x8A78, 0x8BBB, 0x8D12, 
	0x8E78, 0x8FEA, 0x9164, 0x92E1, 0x945D, 0x9682, 0x995C, 0x9C04, 0x9D91, 
	0x97D4, 0x94F2, 0x941E, 0x9382, 0x92BC, 0x9167, 0x8F20, 0x8B83, 0x862D, 
	0x842B, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x3996, 0x3A60, 
	0x3C0F, 0x3D97, 0x3DED, 0x3C07, 0x343C, 0x2829, 0x1EB2, 0x1D3A, 0x1EB2, 
	0x1E87, 0x1EB2, 0x1F7B, 0x2070, 0x2179, 0x227A, 0x235A, 0x23FE, 0x23B7, 
	0x22BA, 0x2246, 0x2395, 0x26EC, 0x2B60, 0x306E, 0x3592, 0x3A4A, 0x3E11, 
	0x400F, 0x40A7, 0x412D, 0x42F5, 0x465D, 0x4A9A, 0x4F3F, 0x53E0, 0x5811, 
	0x5B65, 0x5D70, 0x5E96, 0x5F85, 0x603F, 0x60C6, 0x611E, 0x6148, 0x6148, 
	0x611F, 0x60D1, 0x6060, 0x5FCE, 0x5F1F, 0x5E54, 0x5D70, 0x5C55, 0x5AEA, 
	0x593A, 0x5750, 0x5537, 0x52FB, 0x50A7, 0x4E47, 0x4BE4, 0x498C, 0x4748, 
	0x4524, 0x43A2, 0x4276, 0x4073, 0x3C6D, 0x2A0B, 0x2AD9, 0x2E44, 0x33DF, 
	0x3AAB, 0x41AC, 0x47E6, 0x4C5C, 0x4E11, 0x4A21, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0xFFFF, 0xFFCD, 
	0xFF9F, 0xFF95, 0xFF90, 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF93, 0xFF94, 
	0xFF95, 0xFF93, 0xFF8E, 0xFF88, 0xFF81, 0xFF79, 0xFF72, 0xFF6B, 0xFF65, 
	0xFF5E, 0xFF58, 0xFF53, 0xFF4F, 0xFF4B, 0xFF47, 0xFF43, 0xFF40, 0xFF3E, 
	0xFF3C, 0xFF36, 0xFF25, 0xFF0E, 0xFEF2, 0xFED5, 0xFEB9, 0xFEA0, 0xFE8E, 
	0xFE85, 0xFE87, 0xFE99, 0xFEBB, 0xFEF0, 0xFF3C, 0xFFAA, 0x003D, 0x00EF, 
	0x01BA, 0x0295, 0x037B, 0x0464, 0x0549, 0x0624, 0x06EE, 0x079F, 0x0831, 
	0x07B9, 0x065C, 0x05AD, 0x0741, 0x1856, 0x1A74, 0x1953, 0x166B, 0x1271, 
	0x0E1B, 0x0A21, 0x0739, 0x0618, 0x09D3, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 
	0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2D, 0xFF2F, 0xFF3B, 0xFF46, 
	0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4D, 0xFF4E, 0xFF4D, 0xFF4C, 0xFF4C, 
	0xFF4E, 0xFF51, 0xFF56, 0xFF5B, 0xFF61, 0xFF67, 0xFF6D, 0xFF73, 0xFF7B, 
	0xFF82, 0xFF8A, 0xFF91, 0xFF98, 0xFFA0, 0xFFA7, 0xFFAE, 0xFFB3, 0xFFB6, 
	0xFFA7, 0xFF7B, 0xFF3A, 0xFEEC, 0xFE99, 0xFE47, 0xFE00, 0xFDCB, 0xFDAF, 
	0xFDB5, 0xFDE4, 0xFE44, 0xFEDC, 0xFFB6, 0x00E9, 0x027E, 0x0465, 0x068E, 
	0x08E7, 0x0B62, 0x0DEC, 0x1077, 0x12F0, 0x1549, 0x1770, 0x1955, 0x1B03, 
	0x1C42, 0x1C9D, 0x1B9F, 0x1044, 0x1A12, 0x17C5, 0x11D6, 0x09B9, 0x00E3, 
	0xF8C5, 0xF2D6, 0xF089, 0xFE32, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 
	0xC9D7, 0xC9D7, 0xC9D7, 0xC9D7, 0xC89E, 0xC9D7, 0xD424, 0xDD66, 0xDF84, 
	0xE081, 0xE0B7, 0xE081, 0xE03B, 0xE041, 0xE03B, 0xDFE8, 0xDFC1, 0xE041, 
	0xE16B, 0xE2E5, 0xE497, 0xE669, 0xE841, 0xEA08, 0xEBD9, 0xEDC6, 0xEFAA, 
	0xF15D, 0xF2FE, 0xF4B3, 0xF665, 0xF7FB, 0xF95D, 0xFA73, 0xFB24, 0xFB9A, 
	0xFC0B, 0xFC73, 0xFCD0, 0xFD1F, 0xFD5B, 0xFD81, 0xFD8F, 0xFD81, 0xFD54, 
	0xFD04, 0xFC8E, 0xFBEF, 0xFB24, 0xFA26, 0xF8F3, 0xF78E, 0xF5FA, 0xF43B, 
	0xF251, 0xF042, 0xEE10, 0xEBBD, 0xE94D, 0xE6C2, 0xE420, 0xE143, 0xDD84, 
	0xD820, 0xD053, 0xB5D2, 0xBF0E, 0xBEFB, 0xBE70, 0xBCFA, 0xBA20, 0xB56D, 
	0xAE6B, 0xA4A2, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0050, 0x0001, 0x0001, 0x0051, 0x0001, 0x0052, 0x0001, 
	0x0053, 0x0001, 0x0054, 0x0002, 0x0055, 0x004A, 0x0057, 0x0050, 0x00A1, 
	0x004C, 0x00F1, 0x0002, 0x013D, 0x0050, 0x013F, 0x0050, 0x018F, 0x0050, 
	0x01DF, 0x0050, 0x022F, 0x0001, 0x027F, 0x0001, 0x0280, 0x0001, 0x0281, 
	0x0050, 0x0282, 0x0050, 0x02D2, 0x0050, 0x0322, 0x0050, 0x0372, 0x0050, 
	0x03C2, 0x0050, 0x0412, 0x0050, 0x0462, 0x0050, 0x04B2, 0x0050, 0x0502, 
	0x0001, 0x0552, 0x0001, 0x0553, 0x0001, 0x0554, 0x0050, 0x0555, 0x0050, 
	0x05A5, 0x0050, 0x05F5, 0x004F, 0x0645, 0x004F, 0x0694, 0x0050, 0x06E3, 
	0x0050, 0x0733, 0x0050, 0x0783, 0x0050, 0x07D3, 0x004F, 0x0823, 0x004F, 
	0x0872, 0x0001, 0x08C1, 0x0050, 0x08C2, 0x0050, 0x0912, 0x0050, 0x0962, 
	0x0050, 0x09B2, 0x0050, 0x0A02, 0x0050, 0x0A52, 0x0050, 0x0AA2, 0x0050, 
	0x0AF2, 0x0050, 0x0B42, 0x004C, 0x0B92, 0x004F, 0x0BDE, 0x0001, 0x0C2D, 
	0x0050, 0x0C2E, 0x0050, 0x0C7E, 0x0050, 0x0CCE, 0x0010, 0x0D1E, 0x0050, 
	0x0D2E, 0x0050, 0x0D7E, 0x0050, 0x0DCE, 0x0050, 0x0E1E, 0x0050, 0x0E6E, 
	

});

smlua_anim_util_register_animation('donkey_2e_dying_on_stomach',1, 0, 0, 0, 46, { 
	0x0000, 0x0038, 0x0038, 0x0039, 0x003B, 0x003D, 0x0040, 0x0042, 0x0044, 
	0x0046, 0x0047, 0x0047, 0x0047, 0x0048, 0x0048, 0x0048, 0x0049, 0x0049, 
	0x0049, 0x0049, 0x004A, 0x004A, 0x004A, 0x0049, 0x0049, 0x0049, 0x0049, 
	0x0048, 0x0048, 0x0048, 0x0048, 0x0047, 0x0047, 0x0045, 0x0040, 0x003C, 
	0x0038, 0x0036, 0x0034, 0x0032, 0x0031, 0x0000, 0x0000, 0x3FFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x7F9E, 0x7F5F, 0x7EEB, 0x7E37, 0x7D59, 
	0x7C69, 0x7B7C, 0x7AA9, 0x7A07, 0x79AB, 0x797C, 0x7951, 0x792A, 0x7907, 
	0x78E8, 0x78CE, 0x78B7, 0x78A5, 0x7898, 0x788F, 0x788B, 0x788B, 0x7891, 
	0x789B, 0x78AA, 0x78BF, 0x78D9, 0x78F8, 0x791C, 0x7946, 0x7976, 0x79AB, 
	0x7AA6, 0x7C8A, 0x7E6C, 0x7F5F, 0x7F2C, 0x7E65, 0x7D4F, 0x7C2F, 0x7B4C, 
	0x0000, 0x0000, 0xEBC9, 0xEBB2, 0xEB71, 0xEB0C, 0xEA8A, 0xE9F1, 0xE946, 
	0xE890, 0xE7D6, 0xE71D, 0xE66B, 0xE5C8, 0xE537, 0xE4B7, 0xE445, 0xE3DF, 
	0xE380, 0xE327, 0xE2D0, 0xE278, 0xE21E, 0xE1C2, 0xE166, 0xE10B, 0xE0B5, 
	0xE064, 0xE01A, 0xDFDA, 0xDFA5, 0xDF7D, 0xDF63, 0xDF5A, 0xE2B4, 0xE8ED, 
	0xEC46, 0xEB13, 0xE9E0, 0xEBD5, 0xEDC9, 0xECC9, 0xEBC9, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x0000, 0x0006, 
	0x0010, 0x001A, 0x0027, 0x0039, 0x004C, 0x005E, 0x0068, 0x006F, 0x007D, 
	0x009D, 0x00C1, 0x00D5, 0x00E9, 0x010C, 0x0128, 0x0123, 0x0118, 0x012D, 
	0x0121, 0x00AA, 0x0000, 0xFF80, 0xFE67, 0xFD23, 0xF87A, 0xEC53, 0xDDA3, 
	0xD30F, 0xD027, 0xD15C, 0xD2A0, 0xD297, 0xD296, 0xD299, 0xD29E, 0xD2A0, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
	0x0000, 0x0004, 0x000D, 0x001A, 0x0027, 0x0030, 0x0038, 0x0041, 0x004B, 
	0x0057, 0x0060, 0x0061, 0x0066, 0x007F, 0x009A, 0x00A7, 0x00B1, 0x00CA, 
	0x00D7, 0x00BD, 0x008D, 0x0075, 0x0000, 0xFE82, 0xFCC5, 0xFB03, 0xFA38, 
	0xFBAB, 0xFDE7, 0xFF32, 0xFE82, 0xFCE1, 0xFBBC, 0xFB75, 0xFB6C, 0xFB87, 
	0xFBAA, 0xFBBC, 0xDD4F, 0xDDD2, 0xDEB3, 0xE000, 0xE198, 0xE35E, 0xE534, 
	0xE6FB, 0xE894, 0xE9E0, 0xEA30, 0xE96E, 0xE6BA, 0xE55A, 0xE681, 0xE813, 
	0xE87E, 0xE6A7, 0xE45C, 0xE407, 0xE56E, 0xE5B6, 0xE381, 0xE13A, 0xE15B, 
	0xE2A1, 0xE1A5, 0xDDE0, 0xDEE9, 0xE038, 0xDA41, 0xD975, 0xD965, 0xD910, 
	0xD5C0, 0xD523, 0xDF1F, 0xEC76, 0xF6D4, 0xFB71, 0xFD16, 0xFDC4, 0xFE52, 
	0xFE64, 0xFE2F, 0xFDE8, 0xFDC4, 0x0001, 0xFFFE, 0xC170, 0xE685, 0xE733, 
	0xE836, 0xE9C7, 0xEBB4, 0xEDCB, 0xEFD9, 0xF1AB, 0xF30F, 0xF3D2, 0xF42E, 
	0xF480, 0xF4C8, 0xF506, 0xF53A, 0xF563, 0xF583, 0xF598, 0xF5A3, 0xF5A4, 
	0xF59B, 0xF588, 0xF56B, 0xF544, 0xF513, 0xF4D7, 0xF492, 0xF443, 0xF3E9, 
	0xF386, 0xF319, 0xF2A1, 0xF0A0, 0xECD2, 0xE910, 0xE733, 0xE7B1, 0xE961, 
	0xEBB3, 0xEE17, 0xEFFD, 0xD2A8, 0xD3BB, 0xD5B2, 0xD8B8, 0xDC70, 0xE07C, 
	0xE480, 0xE81F, 0xEAFB, 0xECB9, 0xEDC5, 0xEECB, 0xEFC7, 0xF0B9, 0xF1A0, 
	0xF278, 0xF341, 0xF3FA, 0xF4A0, 0xF531, 0xF5AD, 0xF611, 0xF65C, 0xF68D, 
	0xF6A1, 0xF696, 0xF66C, 0xF621, 0xF5B2, 0xF51F, 0xF466, 0xF384, 0xEEB8, 
	0xE50A, 0xDAA7, 0xD3BB, 0xD11F, 0xD05B, 0xD0AA, 0xD142, 0xD15E, 0x9C33, 
	0x9B97, 0x9AB7, 0x995A, 0x97AC, 0x95DC, 0x9417, 0x928A, 0x9164, 0x90D2, 
	0x90A0, 0x907B, 0x9062, 0x9056, 0x9054, 0x905E, 0x9072, 0x9090, 0x90B7, 
	0x90E6, 0x911D, 0x915C, 0x91A2, 0x91ED, 0x923F, 0x9296, 0x92F1, 0x9350, 
	0x93B3, 0x9418, 0x9480, 0x94E9, 0x9640, 0x98A1, 0x9AD1, 0x9B97, 0x9A9D, 
	0x98AF, 0x9644, 0x93D2, 0x91D1, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xDCF8, 0xDCA4, 0xDC11, 0xDB2A, 0xDA0D, 0xD8DA, 0xD7B2, 
	0xD6B4, 0xD601, 0xD5B7, 0xD5B3, 0xD5BC, 0xD5D1, 0xD5F1, 0xD61C, 0xD64F, 
	0xD68B, 0xD6CD, 0xD717, 0xD765, 0xD7B9, 0xD80F, 0xD869, 0xD8C4, 0xD920, 
	0xD97B, 0xD9D6, 0xDA2F, 0xDA85, 0xDAD6, 0xDB24, 0xDB6B, 0xDB67, 0xDB36, 
	0xDB6E, 0xDCA4, 0xDF16, 0xE255, 0xE5F1, 0xE97C, 0xEC88, 0x16C1, 0x1770, 
	0x1950, 0x1C1D, 0x1F94, 0x2370, 0x276F, 0x2B4B, 0x2EC2, 0x318F, 0x336F, 
	0x341E, 0x341E, 0x341E, 0x341E, 0x341E, 0x341E, 0x341E, 0x341E, 0x341E, 
	0x3446, 0x34B5, 0x355C, 0x362D, 0x371B, 0x3816, 0x3912, 0x39FF, 0x3AD1, 
	0x3B78, 0x3BE6, 0x3C0E, 0x0368, 0xF58D, 0x0001, 0xFFFE, 0xC170, 0xF6B6, 
	0xF746, 0xF869, 0xFA2B, 0xFC55, 0xFEAF, 0x00FF, 0x030F, 0x04A6, 0x058C, 
	0x0602, 0x066F, 0x06D3, 0x072C, 0x077B, 0x07C0, 0x07FA, 0x0829, 0x084D, 
	0x0865, 0x0872, 0x0873, 0x0867, 0x084F, 0x082A, 0x07F8, 0x07B9, 0x076D, 
	0x0713, 0x06AA, 0x0634, 0x05AE, 0x02DD, 0xFD84, 0xF8A6, 0xF746, 0xFA3B, 
	0xFF90, 0x0619, 0x0CAA, 0x1218, 0x2FF5, 0x2EFF, 0x2D53, 0x2AC7, 0x27A6, 
	0x2439, 0x20CA, 0x1DA2, 0x1B0C, 0x1950, 0x1816, 0x16D5, 0x1591, 0x144D, 
	0x130B, 0x11CF, 0x109C, 0x0F74, 0x0E5B, 0x0D54, 0x0C62, 0x0B87, 0x0AC7, 
	0x0A25, 0x09A4, 0x0947, 0x0910, 0x0904, 0x0925, 0x0975, 0x09F9, 0x0AB2, 
	0x103A, 0x1BA3, 0x27A7, 0x2EFF, 0x3088, 0x2F6C, 0x2CD6, 0x29F4, 0x27F3, 
	0x78EB, 0x79BB, 0x7B53, 0x7DCA, 0x80D4, 0x8420, 0x8761, 0x8A4A, 0x8C8C, 
	0x8DDB, 0x8E91, 0x8F3C, 0x8FDB, 0x906E, 0x90F4, 0x916D, 0x91D7, 0x9232, 
	0x927E, 0x92BA, 0x92E5, 0x92FE, 0x9305, 0x92FA, 0x92DA, 0x92A7, 0x925F, 
	0x9202, 0x918E, 0x9104, 0x9062, 0x8FA8, 0x8B9A, 0x83CB, 0x7C6D, 0x79BB, 
	0x7CCF, 0x82FA, 0x8ABA, 0x928E, 0x98F8, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xE819, 0xE7A4, 0xE6E9, 
	0xE5C5, 0xE45E, 0xE2DA, 0xE15F, 0xE015, 0xDF23, 0xDEAD, 0xDE8A, 0xDE72, 
	0xDE66, 0xDE64, 0xDE6C, 0xDE7E, 0xDE99, 0xDEBC, 0xDEE7, 0xDF19, 0xDF51, 
	0xDF90, 0xDFD3, 0xE01C, 0xE068, 0xE0B8, 0xE10B, 0xE160, 0xE1B7, 0xE20F, 
	0xE268, 0xE2C0, 0xE41E, 0xE674, 0xE82A, 0xE7A4, 0xE45C, 0xDF6D, 0xD9B1, 
	0xD3FF, 0xCF32, 0xE5E1, 0xE546, 0xE39C, 0xE120, 0xDE0E, 0xDAA2, 0xD717, 
	0xD3AB, 0xD098, 0xCE1C, 0xCC73, 0xCBD7, 0xCBD7, 0xCBD7, 0xCBD7, 0xCBD7, 
	0xCBD7, 0xCBD7, 0xCBD7, 0xCBD7, 0xCBCF, 0xCBB7, 0xCB94, 0xCB68, 0xCB36, 
	0xCB00, 0xCACB, 0xCA99, 0xCA6C, 0xCA49, 0xCA32, 0xCA29, 0xFBB8, 0xED97, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0xF786, 0xF7C7, 0xF83B, 0xF8EC, 0xF9C5, 0xFAB3, 0xFBA1, 0xFC7B, 0xFD2D, 
	0xFDA3, 0xFDF4, 0xFE47, 0xFE9A, 0xFEED, 0xFF3F, 0xFF90, 0xFFDD, 0x0028, 
	0x006E, 0x00B0, 0x00EC, 0x0122, 0x0150, 0x0177, 0x0196, 0x01AB, 0x01B6, 
	0x01B6, 0x01AB, 0x0193, 0x016E, 0x013C, 0xFFDE, 0xFD07, 0xF9EE, 0xF7C7, 
	0xF6D0, 0xF654, 0xF620, 0xF604, 0xF5CD, 0xF4D4, 0xF4B9, 0xF488, 0xF43C, 
	0xF3DE, 0xF378, 0xF314, 0xF2BA, 0xF275, 0xF24D, 0xF238, 0xF224, 0xF212, 
	0xF201, 0xF1F2, 0xF1E5, 0xF1D9, 0xF1CF, 0xF1C7, 0xF1C1, 0xF1BD, 0xF1BB, 
	0xF1BC, 0xF1BE, 0xF1C3, 0xF1CA, 0xF1D3, 0xF1DF, 0xF1EE, 0xF1FF, 0xF212, 
	0xF229, 0xF286, 0xF340, 0xF412, 0xF4B9, 0xF52A, 0xF58A, 0xF5DF, 0xF62C, 
	0xF676, 0xA8C4, 0xA7EF, 0xA674, 0xA432, 0xA16B, 0x9E62, 0x9B5A, 0x9894, 
	0x9653, 0x94DA, 0x93D9, 0x92D5, 0x91D1, 0x90CF, 0x8FD0, 0x8ED9, 0x8DE9, 
	0x8D05, 0x8C2F, 0x8B67, 0x8AB2, 0x8A11, 0x8986, 0x8914, 0x88BD, 0x8883, 
	0x8868, 0x8870, 0x889B, 0x88ED, 0x8968, 0x8A0E, 0x8E5A, 0x9744, 0xA10C, 
	0xA7EF, 0xAB37, 0xAD12, 0xAE0F, 0xAEC2, 0xAFBB, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x201D, 0x2124, 0x230B, 0x25F3, 0x2986, 0x2D6D, 
	0x3153, 0x34DF, 0x37BD, 0x3996, 0x3AD0, 0x3C0C, 0x3D46, 0x3E7B, 0x3FAB, 
	0x40D0, 0x41EA, 0x42F5, 0x43EF, 0x44D5, 0x45A5, 0x465B, 0x46F5, 0x4771, 
	0x47CC, 0x4804, 0x4815, 0x47FD, 0x47B9, 0x4747, 0x46A5, 0x45CF, 0x4071, 
	0x3561, 0x295E, 0x2124, 0x1DA0, 0x1C0E, 0x1BA2, 0x1B8E, 0x1B07, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
	0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
	0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 
	0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE31A, 0xE2E8, 0xE294, 0xE284, 0xE31A, 
	0xE47E, 0xE666, 0xE88C, 0xEAAA, 0xEC79, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x0AE3, 0x0ABC, 0x0A7A, 0x0A1B, 
	0x09A7, 0x0924, 0x089C, 0x0816, 0x079B, 0x0731, 0x06CF, 0x0665, 0x05F4, 
	0x057D, 0x0503, 0x0486, 0x0407, 0x0389, 0x030C, 0x0292, 0x021D, 0x01AE, 
	0x0146, 0x00E6, 0x0091, 0x0047, 0x000A, 0xFFDB, 0xFFBC, 0xFFAE, 0xFFB2, 
	0xFFCA, 0x0153, 0x04A8, 0x084A, 0x0ABC, 0x0BB0, 0x0C07, 0x0C02, 0x0BE3, 
	0x0BEC, 0x0AA4, 0x0AC1, 0x0AF4, 0x0B42, 0x0BA2, 0x0C0B, 0x0C75, 0x0CD5, 
	0x0D25, 0x0D5A, 0x0D80, 0x0DA6, 0x0DCD, 0x0DF4, 0x0E1A, 0x0E40, 0x0E65, 
	0x0E88, 0x0EAA, 0x0ECA, 0x0EE7, 0x0F01, 0x0F18, 0x0F2B, 0x0F3B, 0x0F46, 
	0x0F4C, 0x0F4E, 0x0F4A, 0x0F40, 0x0F31, 0x0F1A, 0x0E7C, 0x0D32, 0x0BC5, 
	0x0AC1, 0x0A3E, 0x09EF, 0x09BD, 0x0997, 0x0969, 0xA951, 0xA8CB, 0xA7EA, 
	0xA69D, 0xA504, 0xA33E, 0xA168, 0x9FA2, 0x9E09, 0x9CBD, 0x9B95, 0x9A56, 
	0x9905, 0x97A6, 0x963C, 0x94CD, 0x935B, 0x91EB, 0x9082, 0x8F23, 0x8DD1, 
	0x8C93, 0x8B6A, 0x8A5C, 0x896C, 0x889F, 0x87F9, 0x877D, 0x8730, 0x8716, 
	0x8733, 0x878B, 0x8C35, 0x9649, 0xA14E, 0xA8CB, 0xABE1, 0xAD29, 0xAD63, 
	0xAD4D, 0xADA5, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x1F1B, 0x1FEB, 
	0x2151, 0x2368, 0x25F9, 0x28CF, 0x2BB4, 0x2E73, 0x30D7, 0x32A9, 0x342E, 
	0x35CA, 0x377A, 0x3937, 0x3AFE, 0x3CC8, 0x3E92, 0x4056, 0x420F, 0x43B9, 
	0x454E, 0x46CA, 0x4827, 0x4961, 0x4A72, 0x4B57, 0x4C0A, 0x4C85, 0x4CC5, 
	0x4CC4, 0x4C7D, 0x4BEB, 0x4578, 0x37C7, 0x2927, 0x1FEB, 0x1D65, 0x1DD5, 
	0x1FF0, 0x226C, 0x23FE, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
	0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
	0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
	0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 0xFF93, 
	0xFF94, 0xFF94, 0xFF93, 0xFF90, 0xFF8C, 0xFF88, 0xFF83, 0xFF80, 0xFF4E, 
	0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
	0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
	0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 
	0xFF4E, 0xFF4E, 0xFF4E, 0xFF4E, 0xFF4D, 0xFF4D, 0xFF4D, 0xFF4E, 0xFF50, 
	0xFF52, 0xFF55, 0xFF58, 0xFF5B, 0xE043, 0xE041, 0xE041, 0xE041, 0xE041, 
	0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
	0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
	0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 0xE041, 
	0xE029, 0xE001, 0xDFF9, 0xE041, 0xE0EB, 0xE1D4, 0xE2DC, 0xE3DF, 0xE4BC, 
	

},{ 
	0x0001, 0x0000, 0x0028, 0x0001, 0x0001, 0x0029, 0x0001, 0x002A, 0x0001, 
	0x002B, 0x0001, 0x002C, 0x0027, 0x002D, 0x0001, 0x0054, 0x0029, 0x0055, 
	0x0001, 0x007E, 0x0001, 0x007F, 0x0029, 0x0080, 0x002F, 0x00A9, 0x002F, 
	0x00D8, 0x002F, 0x0107, 0x0001, 0x0136, 0x0001, 0x0137, 0x0001, 0x0138, 
	0x0029, 0x0139, 0x0029, 0x0162, 0x0029, 0x018B, 0x0029, 0x01B4, 0x0026, 
	0x01DD, 0x0029, 0x0203, 0x0020, 0x022C, 0x0001, 0x024C, 0x0001, 0x024D, 
	0x0001, 0x024E, 0x0001, 0x024F, 0x0001, 0x0250, 0x0029, 0x0251, 0x0029, 
	0x027A, 0x0029, 0x02A3, 0x0029, 0x02CC, 0x0029, 0x02F5, 0x0029, 0x031E, 
	0x0020, 0x0347, 0x0001, 0x0367, 0x0001, 0x0368, 0x0029, 0x0369, 0x0027, 
	0x0392, 0x0001, 0x03B9, 0x0029, 0x03BA, 0x0029, 0x03E3, 0x0029, 0x040C, 
	0x0028, 0x0435, 0x0026, 0x045D, 0x0029, 0x0483, 0x0029, 0x04AC, 0x0029, 
	0x04D5, 0x0029, 0x04FE, 0x0029, 0x0527, 0x0027, 0x0550, 0x0001, 0x0577, 
	0x0029, 0x0578, 0x0029, 0x05A1, 0x0029, 0x05CA, 0x0028, 0x05F3, 0x0025, 
	0x061B, 0x0029, 0x0640, 0x0029, 0x0669, 0x0029, 0x0692, 0x0029, 0x06BB, 
	

});

smlua_anim_util_register_animation('donkey_2F_suffocating',1, 0, 0, 0, 79, { 
	0x0000, 0x008B, 0x008C, 0x008D, 0x008F, 0x0091, 0x0094, 0x0096, 0x0097, 
	0x0097, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0, 
	0x00A0, 0x00A1, 0x00A2, 0x00A2, 0x00A2, 0x00A3, 0x00A3, 0x00A3, 0x00A4, 
	0x00A4, 0x00A4, 0x00A4, 0x00A4, 0x00A4, 0x00A5, 0x00A5, 0x00A5, 0x00A5, 
	0x00A5, 0x00A5, 0x00A6, 0x00A6, 0x00A6, 0x00A7, 0x00A7, 0x00A8, 0x00A8, 
	0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0, 0x00B1, 
	0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B5, 0x00B6, 0x00B7, 0x00B7, 0x00B7, 
	0x00B7, 0x00B4, 0x00AC, 0x00A0, 0x0090, 0x0080, 0x006E, 0x005D, 0x004E, 
	0x0042, 0x003B, 0x0036, 0x0030, 0x002E, 0x002D, 0x002E, 0x0036, 0x0033, 
	0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0xFFFF, 0xFFF5, 0xFFE6, 0xFFD3, 0xFFC0, 0xFFAC, 0xFF9A, 0xFF8B, 0xFF80, 
	0xFF7D, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0001, 0x0001, 0x0002, 0x0002, 0x0003, 0x0004, 0x0004, 
	0x0005, 0x0006, 0x0007, 0x0007, 0x0008, 0x0009, 0x0009, 0x000A, 0x000B, 
	0x000B, 0x000C, 0x000D, 0x000E, 0x000F, 0x000F, 0x000F, 0x000F, 0x000E, 
	0x000D, 0x000B, 0x0009, 0x0007, 0x0005, 0x0003, 0x0002, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFF8, 
	0xFFF6, 0xFFF5, 0xFFF5, 0xFFF5, 0xFFF7, 0xFFF9, 0xFFFB, 0xFFFB, 0xFFFA, 
	0xFFF5, 0xFFEB, 0xFFDB, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 0x0000, 
	0xFFFD, 0xFFFB, 0xFFF8, 0xFFF5, 0xFFF2, 0xFFEF, 0xFFEB, 0xFFE8, 0xFFE4, 
	0xFFE1, 0xFFDD, 0xFFDA, 0xFFD6, 0xFFD3, 0xFFD0, 0xFFCD, 0xFFCA, 0xFFC7, 
	0xFFC4, 0xFFC1, 0xFFBE, 0xFFBC, 0xFFBB, 0xFFBB, 0xFFBD, 0xFFC2, 0xFFC7, 
	0xFFCF, 0xFFD6, 0xFFDF, 0xFFE7, 0xFFEF, 0xFFF6, 0xFFFB, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0026, 0x005B, 0x009B, 0x00E3, 0x0130, 0x017D, 0x01C7, 0x020A, 
	0x0244, 0x0271, 0x028C, 0x0297, 0x0296, 0x028D, 0x0281, 0x0276, 0x0271, 
	0x0270, 0x026F, 0x5675, 0x5606, 0x54B7, 0x528A, 0x4F7E, 0x4C72, 0x4A45, 
	0x48F7, 0x4888, 0x49C0, 0x4AF1, 0x4C03, 0x4CE1, 0x4D76, 0x4DAB, 0x4D9E, 
	0x4D7D, 0x4D4A, 0x4D07, 0x4CB5, 0x4C55, 0x4BEA, 0x4B74, 0x4AF7, 0x4A72, 
	0x49E8, 0x495A, 0x48CB, 0x483B, 0x47AC, 0x4720, 0x4698, 0x4617, 0x4584, 
	0x44D2, 0x440F, 0x4347, 0x4288, 0x41E1, 0x415F, 0x40FA, 0x40A1, 0x4051, 
	0x400B, 0x3FCE, 0x3F99, 0x3F6A, 0x3F42, 0x3F1F, 0x3F00, 0x3F00, 0x3F00, 
	0x3F00, 0x3F00, 0x3F00, 0x3F00, 0x3F00, 0x3F00, 0x3F00, 0x3F00, 0x3F00, 
	0x3B67, 0x366D, 0x3065, 0x29A3, 0x227C, 0x1B45, 0x1450, 0x0DF4, 0x0884, 
	0x0454, 0x01D9, 0x00FC, 0x0144, 0x0238, 0x035D, 0x043A, 0x0454, 0x03AB, 
	0x02AC, 0x0000, 0xFF5C, 0xFF5C, 0xFF5B, 0xFF57, 0xFF4F, 0xFF42, 0xFF2F, 
	0xFF15, 0xFE47, 0xFD8E, 0xFD22, 0xFD3F, 0xFE20, 0xFFFF, 0x048A, 0x0C06, 
	0x1499, 0x1C66, 0x218F, 0x2239, 0x1C32, 0x1089, 0x023D, 0xF44D, 0xE9BA, 
	0xE584, 0xE8BA, 0xF115, 0xFC94, 0x0935, 0x14F6, 0x1DD5, 0x21D0, 0x20D4, 
	0x1CB5, 0x1650, 0x0E84, 0x062D, 0xFE29, 0xF755, 0xF28E, 0xF18B, 0xF3CD, 
	0xF6DC, 0xF842, 0xF700, 0xF484, 0xF1F8, 0xF084, 0xF084, 0xF084, 0xF084, 
	0xF084, 0xF084, 0xF084, 0xF084, 0xF084, 0xF084, 0xF084, 0xF084, 0xF09F, 
	0xF0C5, 0xF0F3, 0xF127, 0xF15D, 0xF194, 0xF1C9, 0xF1FA, 0xF223, 0xF243, 
	0xF251, 0xF24D, 0xF23F, 0xF22E, 0xF224, 0xF228, 0xF243, 0xF281, 0xF2DF, 
	0x0000, 0xFF57, 0xFF60, 0xFF78, 0xFF99, 0xFFBD, 0xFFDE, 0xFFF6, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0072, 0x0110, 
	0x01D0, 0x02A6, 0x038A, 0x046F, 0x054C, 0x0616, 0x06C3, 0x0748, 0x0792, 
	0x07A0, 0x0788, 0x075F, 0x0739, 0x072A, 0x0748, 0x07A2, 0x0829, 0x039F, 
	0x047D, 0x0764, 0x0BF0, 0x117F, 0x176F, 0x1D1E, 0x21E9, 0x252E, 0x26CB, 
	0x281E, 0x292F, 0x2A06, 0x2AAB, 0x2B25, 0x2B34, 0x2AB1, 0x29CC, 0x28B3, 
	0x2798, 0x26AA, 0x25E0, 0x2514, 0x2445, 0x2372, 0x229E, 0x21C6, 0x2116, 
	0x209C, 0x202D, 0x1FA1, 0x1ECD, 0x1D89, 0x1BAA, 0x1930, 0x1644, 0x12FE, 
	0x0F74, 0x0BBC, 0x07EC, 0x041A, 0x005E, 0xFC61, 0xF803, 0xF3A6, 0xEFA9, 
	0xEBFE, 0xE87D, 0xE56A, 0xE308, 0xE4CA, 0xE448, 0xE263, 0xE417, 0xE4C5, 
	0xE2BB, 0xE23B, 0xE34F, 0xE42C, 0xE347, 0xE308, 0xE4AE, 0xE694, 0xE8A8, 
	0xEAD8, 0xED10, 0xEF3F, 0xF151, 0xF336, 0xF4D9, 0xF629, 0xF6E5, 0xF702, 
	0xF6B9, 0xF644, 0xF5DF, 0xF5C2, 0xF629, 0xF717, 0xF858, 0x0000, 0x004F, 
	0x0000, 0x00E2, 0xEE2F, 0xED25, 0xF2C4, 0xF6CB, 0xF97F, 0xFB22, 0xFBF9, 
	0xFC49, 0xFC54, 0xFC51, 0xFC4D, 0xFC4A, 0xFC46, 0xFC43, 0xFC3F, 0xFC3B, 
	0xFC37, 0xFC33, 0xFC30, 0xFC2C, 0xFC28, 0xFC25, 0xFC21, 0xFC1E, 0xFC1B, 
	0xFC19, 0xFC16, 0xFC14, 0xFC13, 0xFC11, 0xFC11, 0xFC10, 0xFC10, 0xFC11, 
	0xFC12, 0xFC14, 0xFC16, 0xFC19, 0xFC1D, 0xFC21, 0xFC26, 0xFC2C, 0xFC33, 
	0xFC3A, 0xFC42, 0xFC4C, 0xFC56, 0xFC61, 0xFD74, 0xFE98, 0xFEAA, 0xFE93, 
	0xFE5F, 0xFE1A, 0xFDD2, 0xFD93, 0xFD69, 0xFD62, 0xFD89, 0xFDEC, 0xFE98, 
	0xFF97, 0x00EA, 0x028A, 0x0470, 0x0697, 0x08F8, 0x0B8C, 0x0E4E, 0x14D8, 
	0x1AF6, 0x1B23, 0x1963, 0x1846, 0x1905, 0x1A68, 0x1B50, 0x1B1B, 0x1A6B, 
	0x1A05, 0x0001, 0xFFFE, 0xC170, 0x1DCC, 0x1CDD, 0x1EB0, 0x1FF5, 0x20C9, 
	0x2147, 0x218C, 0x21B3, 0x21DB, 0x2200, 0x2195, 0x20D6, 0x1FFE, 0x1F49, 
	0x1EF3, 0x1EE0, 0x1ECC, 0x1EB8, 0x1EA3, 0x1E8D, 0x1E77, 0x1E60, 0x1E48, 
	0x1E31, 0x1E19, 0x1E00, 0x1DE7, 0x1DCF, 0x1DB5, 0x1D9C, 0x1D83, 0x1D6A, 
	0x1D50, 0x1D37, 0x1D1E, 0x1D05, 0x1CEC, 0x1CD3, 0x1CBB, 0x1CA3, 0x1C8C, 
	0x1C74, 0x1C5E, 0x1C48, 0x1C32, 0x1C1D, 0x1C09, 0x1BF6, 0x1BE3, 0x1BD1, 
	0x1BC3, 0x1BBC, 0x1BBB, 0x1BBD, 0x1BC2, 0x1BC9, 0x1BCF, 0x1BD5, 0x1BD8, 
	0x1BD7, 0x1BD1, 0x1BC8, 0x1BBC, 0x1BB0, 0x1BA2, 0x1B93, 0x1B84, 0x1B73, 
	0x1B63, 0x1B51, 0x1B40, 0x1B2F, 0x1B1E, 0x1B0D, 0x1AFD, 0x1AED, 0x1ADF, 
	0x1AD1, 0x1AC5, 0x1ABA, 0xD901, 0xD596, 0xE14A, 0xE9A1, 0xEF32, 0xF28F, 
	0xF44E, 0xF503, 0xF543, 0xF56D, 0xF516, 0xF471, 0xF3B0, 0xF306, 0xF2A5, 
	0xF278, 0xF24A, 0xF21A, 0xF1E9, 0xF1B6, 0xF182, 0xF14C, 0xF116, 0xF0DF, 
	0xF0A6, 0xF06D, 0xF034, 0xEFF9, 0xEFBF, 0xEF84, 0xEF49, 0xEF0D, 0xEED2, 
	0xEE97, 0xEE5C, 0xEE22, 0xEDE8, 0xEDAE, 0xED76, 0xED3E, 0xED07, 0xECD1, 
	0xEC9C, 0xEC68, 0xEC36, 0xEC05, 0xEBD6, 0xEBA9, 0xEB7D, 0xEB53, 0xEB34, 
	0xEB23, 0xEB1F, 0xEB24, 0xEB30, 0xEB3F, 0xEB4F, 0xEB5C, 0xEB63, 0xEB61, 
	0xEB53, 0xEB3D, 0xEB23, 0xEB06, 0xEAE6, 0xEAC3, 0xEA9F, 0xEA79, 0xEA51, 
	0xEA29, 0xEA01, 0xE9D8, 0xE9B0, 0xE989, 0xE963, 0xE93F, 0xE91D, 0xE8FD, 
	0xE8E1, 0xE8C7, 0xB867, 0xB796, 0xB483, 0xAC8B, 0xA18E, 0x956E, 0x8A0B, 
	0x8145, 0x7CFE, 0x7C86, 0x7D57, 0x7EF5, 0x80E4, 0x82A4, 0x83BB, 0x8457, 
	0x84F9, 0x85A1, 0x864F, 0x8701, 0x87B9, 0x8874, 0x8933, 0x89F6, 0x8ABB, 
	0x8B83, 0x8C4E, 0x8D1A, 0x8DE8, 0x8EB7, 0x8F87, 0x9057, 0x9126, 0x91F6, 
	0x92C4, 0x9392, 0x945D, 0x9527, 0x95EE, 0x96B2, 0x9773, 0x9831, 0x98EA, 
	0x999F, 0x9A4F, 0x9AFA, 0x9BA0, 0x9C3F, 0x9CD9, 0x9D6B, 0x9DDB, 0x9E15, 
	0x9E23, 0x9E10, 0x9DE7, 0x9DB2, 0x9D7B, 0x9D4E, 0x9D36, 0x9D3C, 0x9D6B, 
	0x9DBA, 0x9E15, 0x9E7C, 0x9EEC, 0x9F65, 0x9FE6, 0xA06B, 0xA0F5, 0xA182, 
	0xA210, 0xA29E, 0xA32A, 0xA3B4, 0xA439, 0xA4B8, 0xA530, 0xA59F, 0xA604, 
	0xA65D, 0x0000, 0x01D1, 0x0000, 0xFD1B, 0xC9F4, 0xC92F, 0xC968, 0xC992, 
	0xC9AD, 0xC9BE, 0xC9C7, 0xC9CA, 0xC9CA, 0xC9A9, 0xC985, 0xC95E, 0xC934, 
	0xC907, 0xC8D7, 0xC8A6, 0xC871, 0xC83B, 0xC803, 0xC7C9, 0xC78D, 0xC750, 
	0xC712, 0xC6D2, 0xC691, 0xC64F, 0xC60C, 0xC5C9, 0xC586, 0xC542, 0xC4FD, 
	0xC4B9, 0xC475, 0xC431, 0xC3EE, 0xC3AB, 0xC369, 0xC328, 0xC2E8, 0xC2A9, 
	0xC26B, 0xC22F, 0xC1F5, 0xC1BC, 0xC185, 0xC151, 0xC11E, 0xC0EE, 0xC0C1, 
	0xC096, 0xC075, 0xC065, 0xC062, 0xC069, 0xC076, 0xC086, 0xC096, 0xC0A3, 
	0xC0AA, 0xC0A6, 0xC096, 0xC07B, 0xC05C, 0xC03A, 0xC013, 0xBFEB, 0xBFBF, 
	0xBF92, 0xBF63, 0xBF34, 0xBF04, 0xBED4, 0xBEA5, 0xBE76, 0xBE49, 0xBE1E, 
	0xBDF6, 0xBDD0, 0xBDAE, 0xBD90, 0x071C, 0xFAE8, 0xF7B4, 0xEF6D, 0xE412, 
	0xD7A2, 0xCC1B, 0xC37D, 0xBFC6, 0xBF93, 0xC04E, 0xC191, 0xC2F5, 0xC416, 
	0xC48D, 0x0306, 0x0A73, 0x08B2, 0x042A, 0xFDF5, 0xF72F, 0xF0F1, 0xEC57, 
	0xEA79, 0xEA6E, 0xEA99, 0xEAE5, 0xEB38, 0xEB7B, 0xEB97, 0x0A90, 0x0D32, 
	0x0C0D, 0x0919, 0x050F, 0x00A8, 0xFC9D, 0xF9A9, 0xF884, 0xF88D, 0xF86D, 
	0xF836, 0xF7F9, 0xF7C7, 0xF7B3, 0x0001, 0xFFFE, 0xC170, 0x36DA, 0x3C93, 
	0xCE2D, 0xDACA, 0xE33E, 0xE85F, 0xEB01, 0xEBFA, 0xEC1D, 0xEC19, 0xEC71, 
	0xECF9, 0xED82, 0xEDE2, 0xEDEB, 0xEDB8, 0xED84, 0xED4D, 0xED15, 0xECDB, 
	0xECA0, 0xEC63, 0xEC25, 0xEBE6, 0xEBA6, 0xEB65, 0xEB24, 0xEAE1, 0xEA9F, 
	0xEA5C, 0xEA18, 0xE9D5, 0xE992, 0xE94E, 0xE90C, 0xE8C9, 0xE887, 0xE846, 
	0xE805, 0xE7C6, 0xE787, 0xE74A, 0xE70E, 0xE6D3, 0xE69A, 0xE662, 0xE62D, 
	0xE5F9, 0xE5C7, 0xE598, 0xE574, 0xE561, 0xE55C, 0xE562, 0xE570, 0xE581, 
	0xE593, 0xE5A1, 0xE5A9, 0xE5A7, 0xE598, 0xE57F, 0xE561, 0xE540, 0xE51B, 
	0xE4F4, 0xE4CA, 0xE49F, 0xE472, 0xE445, 0xE417, 0xE3E9, 0xE3BB, 0xE38F, 
	0xE364, 0xE33A, 0xE314, 0xE2EF, 0xE2CF, 0xE2B2, 0x54F5, 0x56B6, 0x24E6, 
	0x1ED2, 0x17E1, 0x10EA, 0x0AC1, 0x063D, 0x0432, 0x0405, 0x046C, 0x052C, 
	0x060A, 0x06CA, 0x0733, 0x075C, 0x0787, 0x07B3, 0x07E1, 0x0810, 0x0840, 
	0x0872, 0x08A4, 0x08D7, 0x090C, 0x0940, 0x0976, 0x09AC, 0x09E2, 0x0A19, 
	0x0A50, 0x0A87, 0x0ABD, 0x0AF4, 0x0B2B, 0x0B61, 0x0B97, 0x0BCC, 0x0C00, 
	0x0C34, 0x0C67, 0x0C99, 0x0CCA, 0x0CFA, 0x0D28, 0x0D55, 0x0D81, 0x0DAB, 
	0x0DD4, 0x0DFA, 0x0E18, 0x0E27, 0x0E2B, 0x0E26, 0x0E1B, 0x0E0D, 0x0DFF, 
	0x0DF3, 0x0DEC, 0x0DEE, 0x0DFA, 0x0E0F, 0x0E27, 0x0E42, 0x0E60, 0x0E80, 
	0x0EA2, 0x0EC5, 0x0EEA, 0x0F0F, 0x0F34, 0x0F5A, 0x0F7F, 0x0FA3, 0x0FC6, 
	0x0FE8, 0x1007, 0x1025, 0x103F, 0x1057, 0x175C, 0x1DD4, 0x9C96, 0x995E, 
	0x94E9, 0x8FF5, 0x8B43, 0x878F, 0x8598, 0x8550, 0x8612, 0x8771, 0x88FF, 
	0x8A50, 0x8AF6, 0x8B25, 0x8B55, 0x8B87, 0x8BBB, 0x8BF0, 0x8C26, 0x8C5E, 
	0x8C97, 0x8CD0, 0x8D0B, 0x8D47, 0x8D83, 0x8DC0, 0x8DFD, 0x8E3A, 0x8E78, 
	0x8EB6, 0x8EF4, 0x8F31, 0x8F6F, 0x8FAC, 0x8FE8, 0x9024, 0x905F, 0x909A, 
	0x90D3, 0x910B, 0x9142, 0x9178, 0x91AD, 0x91DF, 0x9211, 0x9240, 0x926E, 
	0x9299, 0x92BA, 0x92CC, 0x92D0, 0x92CA, 0x92BE, 0x92AE, 0x929E, 0x9291, 
	0x9289, 0x928B, 0x9299, 0x92B0, 0x92CC, 0x92EA, 0x930C, 0x9330, 0x9356, 
	0x937E, 0x93A7, 0x93D0, 0x93FB, 0x9425, 0x944F, 0x9477, 0x949F, 0x94C5, 
	0x94E8, 0x9509, 0x9527, 0x9542, 0xFFFF, 0xFFF4, 0xFFFF, 0x051B, 0xCB60, 
	0xC7E6, 0xC7F9, 0xC804, 0xC809, 0xC80C, 0xC80E, 0xC813, 0xC81E, 0xC82F, 
	0xC841, 0xC855, 0xC86A, 0xC880, 0xC898, 0xC8B1, 0xC8CB, 0xC8E6, 0xC902, 
	0xC91F, 0xC93D, 0xC95C, 0xC97B, 0xC99B, 0xC9BB, 0xC9DC, 0xC9FD, 0xCA1F, 
	0xCA41, 0xCA63, 0xCA85, 0xCAA7, 0xCAC9, 0xCAEB, 0xCB0D, 0xCB2E, 0xCB4F, 
	0xCB70, 0xCB90, 0xCBAF, 0xCBCE, 0xCBEC, 0xCC09, 0xCC26, 0xCC41, 0xCC5B, 
	0xCC75, 0xCC8D, 0xCCA3, 0xCCB9, 0xCCC9, 0xCCD1, 0xCCD2, 0xCCCF, 0xCCC9, 
	0xCCC0, 0xCCB8, 0xCCB2, 0xCCAF, 0xCCB1, 0xCCB9, 0xCCC6, 0xCCD5, 0xCCE7, 
	0xCCFA, 0xCD0E, 0xCD24, 0xCD3B, 0xCD52, 0xCD6A, 0xCD82, 0xCD9A, 0xCDB1, 
	0xCDC9, 0xCDDF, 0xCDF5, 0xCE09, 0xCE1C, 0xCE2D, 0xCE3C, 0xFA42, 0xFC14, 
	0x018E, 0x0AAC, 0x1771, 0x2435, 0x2D53, 0x32CC, 0x349F, 0x34AD, 0x33FA, 
	0x32E2, 0x31C1, 0x30F3, 0x30D3, 0x312B, 0x3186, 0x31E4, 0x3246, 0x32AA, 
	0x3311, 0x337B, 0x33E6, 0x3453, 0x34C3, 0x3533, 0x35A5, 0x3618, 0x368C, 
	0x3700, 0x3775, 0x37EA, 0x385F, 0x38D3, 0x3947, 0x39BB, 0x3A2D, 0x3A9F, 
	0x3B0F, 0x3B7D, 0x3BE9, 0x3C54, 0x3CBC, 0x3D22, 0x3D85, 0x3DE5, 0x3E42, 
	0x3E9C, 0x3EF2, 0x3F45, 0x3F84, 0x3FA4, 0x3FAC, 0x3FA1, 0x3F8A, 0x3F6C, 
	0x3F4E, 0x3F34, 0x3F27, 0x3F2A, 0x3F45, 0x3F71, 0x3FA4, 0x3FDE, 0x401D, 
	0x4061, 0x40A9, 0x40F5, 0x4142, 0x4191, 0x41E1, 0x4231, 0x4280, 0x42CD, 
	0x4318, 0x435F, 0x43A3, 0x43E1, 0x441A, 0x444C, 0x0197, 0x01A2, 0x01C2, 
	0x01F7, 0x0241, 0x028B, 0x02C1, 0x02E0, 0x02EB, 0x02ED, 0x02E5, 0x02D6, 
	0x02C6, 0x02B9, 0x02B3, 0x0624, 0x05F6, 0x056B, 0x0484, 0x0340, 0x01FC, 
	0x0114, 0x0089, 0x005B, 0x0064, 0x0044, 0x000C, 0xFFCF, 0xFF9D, 0xFF88, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0xFAC2, 0xFA89, 0xF887, 
	0xF35A, 0xEC47, 0xE491, 0xDD7D, 0xD850, 0xD64E, 0xD652, 0xD655, 0xD657, 
	0xD657, 0xD652, 0xD649, 0xD63D, 0xD62F, 0xD620, 0xD610, 0xD5FF, 0xD5EE, 
	0xD5DC, 0xD5C9, 0xD5B6, 0xD5A2, 0xD58E, 0xD57A, 0xD566, 0xD552, 0xD53E, 
	0xD52A, 0xD517, 0xD504, 0xD4F1, 0xD4DF, 0xD4CE, 0xD4BE, 0xD4AE, 0xD4A0, 
	0xD492, 0xD486, 0xD47B, 0xD472, 0xD46A, 0xD464, 0xD45F, 0xD45C, 0xD45B, 
	0xD549, 0xD649, 0xD644, 0xD5F9, 0xD580, 0xD4F0, 0xD461, 0xD3EB, 0xD3A5, 
	0xD3A7, 0xD409, 0xD4E1, 0xD649, 0xD850, 0xDAED, 0xDE11, 0xE1AB, 0xE5AE, 
	0xEA0A, 0xEEAF, 0xF38E, 0xF897, 0x0950, 0x0AD4, 0x0B60, 0x0B3D, 0x0AAF, 
	0x09FF, 0x0972, 0x0950, 0x0990, 0x09F0, 0xF119, 0xEB2C, 0xEB92, 0xEBDB, 
	0xEC0C, 0xEC29, 0xEC38, 0xEC3E, 0xEC40, 0xEC41, 0xEC41, 0xEC42, 0xEC42, 
	0xEC41, 0xEC40, 0xEC3E, 0xEC3C, 0xEC3A, 0xEC38, 0xEC36, 0xEC33, 0xEC31, 
	0xEC2E, 0xEC2B, 0xEC29, 0xEC26, 0xEC23, 0xEC20, 0xEC1D, 0xEC1B, 0xEC18, 
	0xEC15, 0xEC13, 0xEC10, 0xEC0E, 0xEC0B, 0xEC09, 0xEC07, 0xEC05, 0xEC03, 
	0xEC01, 0xEC00, 0xEBFE, 0xEBFD, 0xEBFC, 0xEBFC, 0xEBFB, 0xEBFB, 0xEC1C, 
	0xEC40, 0xEC3C, 0xEC28, 0xEC0B, 0xEBE9, 0xEBC9, 0xEBAE, 0xEB9F, 0xEBA0, 
	0xEBB8, 0xEBEC, 0xEC40, 0xECC5, 0xED80, 0xEE63, 0xEF62, 0xF070, 0xF181, 
	0xF287, 0xF376, 0xF441, 0xF354, 0xF33A, 0xF327, 0xF31B, 0xF319, 0xF322, 
	0xF335, 0xF354, 0xF38E, 0xF3E4, 0x80C8, 0x7CA9, 0x8E45, 0x9AE3, 0xA358, 
	0xA879, 0xAB1B, 0xAC14, 0xAC37, 0xAADA, 0xA98B, 0xA864, 0xA782, 0xA6FD, 
	0xA6F2, 0xA732, 0xA77B, 0xA7CD, 0xA828, 0xA88B, 0xA8F6, 0xA967, 0xA9E0, 
	0xAA5E, 0xAAE2, 0xAB6A, 0xABF8, 0xAC89, 0xAD1E, 0xADB6, 0xAE50, 0xAEEC, 
	0xAF89, 0xB028, 0xB0C6, 0xB165, 0xB203, 0xB2A0, 0xB33B, 0xB3D3, 0xB46A, 
	0xB4FC, 0xB58B, 0xB616, 0xB69C, 0xB71D, 0xB798, 0xB80D, 0xB762, 0xB66E, 
	0xB66D, 0xB69F, 0xB6F3, 0xB758, 0xB7BD, 0xB811, 0xB844, 0xB844, 0xB801, 
	0xB76A, 0xB66E, 0xB543, 0xB410, 0xB2B0, 0xB0FC, 0xAECF, 0xAC01, 0xA86C, 
	0xA3EB, 0x9E57, 0x78C4, 0x7563, 0x7436, 0x7498, 0x75E3, 0x7772, 0x789E, 
	0x78C4, 0x77E1, 0x768A, 0x0000, 0xFFFF, 0x49EE, 0x4954, 0x4785, 0x4482, 
	0x404A, 0x3C12, 0x390F, 0x3740, 0x36A6, 0x36F1, 0x36F5, 0x36BF, 0x3657, 
	0x35C7, 0x351A, 0x345D, 0x3396, 0x32C6, 0x31ED, 0x310D, 0x3026, 0x2F39, 
	0x2E46, 0x2D4F, 0x2C53, 0x2B54, 0x2A52, 0x294F, 0x284A, 0x2744, 0x263F, 
	0x253A, 0x2436, 0x2335, 0x2237, 0x213C, 0x2046, 0x1F55, 0x1E69, 0x1D83, 
	0x1CA5, 0x1BCE, 0x1B00, 0x1A3B, 0x1980, 0x18D0, 0x182A, 0x1791, 0x1BF3, 
	0x20FB, 0x2186, 0x21BF, 0x21B9, 0x2185, 0x2136, 0x20DC, 0x208B, 0x2053, 
	0x2048, 0x207A, 0x20FB, 0x2613, 0x29E0, 0x2757, 0x23C6, 0x1F90, 0x1B14, 
	0x16B4, 0x12CF, 0x0FC8, 0x0DFE, 0x0D47, 0x0D46, 0x0E0A, 0x0FA7, 0x122C, 
	0x15AC, 0x1A37, 0x206F, 0x287D, 0xF7AE, 0xF501, 0xF59B, 0xF728, 0xF949, 
	0xFB9D, 0xFDC3, 0xFF5B, 0x0005, 0x000B, 0x000F, 0x0012, 0x0011, 0x000C, 
	0xFFFF, 0xFFF0, 0xFFE2, 0xFFD4, 0xFFC8, 0xFFBB, 0xFFB0, 0xFFA4, 0xFF98, 
	0xFF8C, 0xFF80, 0xFF73, 0xFF66, 0xFF58, 0xFF48, 0xFF38, 0xFF26, 0xFF12, 
	0xFEFD, 0xFEE5, 0xFECC, 0xFEB0, 0xFE92, 0xFE71, 0xFE4E, 0xFE27, 0xFDFE, 
	0xFDD1, 0xFD76, 0xFCD7, 0xFC11, 0xFB40, 0xFA84, 0xF9F8, 0xFA1E, 0xFA7F, 
	0xFA82, 0xFA79, 0xFA68, 0xFA52, 0xFA3C, 0xFA28, 0xFA1C, 0xFA1B, 0xFA29, 
	0xFA49, 0xFA7F, 0xFAD6, 0xFB4D, 0xFBDE, 0xFC80, 0xFD2C, 0xFDD9, 0xFE80, 
	0xFF18, 0xFF9B, 0x0000, 0x003C, 0x0054, 0x0051, 0x003C, 0x0021, 0x000A, 
	0xFFFF, 0x0000, 0x03C6, 0x0298, 0x01A2, 0x00F2, 0x007C, 0x0034, 0x000F, 
	0x0002, 0xFFFF, 0xFFFF, 0x0001, 0x0001, 0x0001, 0xFFFF, 0x0000, 0xFFFE, 
	0xFFFB, 0xFFF8, 0xFFF3, 0xFFEE, 0xFFE9, 0xFFE3, 0xFFDD, 0xFFD7, 0xFFD0, 
	0xFFCA, 0xFFC4, 0xFFBF, 0xFFBA, 0xFFB5, 0xFFB1, 0xFFAE, 0xFFAC, 0xFFAB, 
	0xFFAB, 0xFFAD, 0xFFB0, 0xFFB4, 0xFFBB, 0xFFC3, 0xFFCD, 0xFFD9, 0xFFFD, 
	0x0045, 0x00A4, 0x010A, 0x0168, 0x01B0, 0x01B3, 0x0199, 0x0199, 0x019D, 
	0x01A2, 0x01A8, 0x01AF, 0x01B4, 0x01B7, 0x01B7, 0x01B3, 0x01A9, 0x0199, 
	0x0180, 0x015D, 0x0133, 0x0104, 0x00D2, 0x00A0, 0x006F, 0x0043, 0x001D, 
	0x0000, 0xFFEE, 0xFFE7, 0xFFE8, 0xFFEE, 0xFFF6, 0xFFFD, 0x0000, 0xFFFF, 
	0xAB92, 0xB2CE, 0xB297, 0xB204, 0xB134, 0xB044, 0xAF50, 0xAE77, 0xADD6, 
	0xAD92, 0xAD92, 0xADCC, 0xAE33, 0xAEBC, 0xAF5C, 0xB003, 0xB0AC, 0xB156, 
	0xB202, 0xB2B1, 0xB361, 0xB415, 0xB4CC, 0xB586, 0xB643, 0xB705, 0xB7CB, 
	0xB895, 0xB965, 0xBA39, 0xBB13, 0xBBF3, 0xBCD9, 0xBDC5, 0xBEB7, 0xBFB1, 
	0xC0B2, 0xC1BA, 0xC2CA, 0xC3E3, 0xC504, 0xC62D, 0xC7F1, 0xCA9B, 0xCDC5, 
	0xD10A, 0xD403, 0xD649, 0xD5E5, 0xD48B, 0xD482, 0xD4A5, 0xD4E6, 0xD535, 
	0xD587, 0xD5CC, 0xD5F7, 0xD5FA, 0xD5C8, 0xD552, 0xD48B, 0xD350, 0xD19C, 
	0xCF8B, 0xCD3C, 0xCAC9, 0xC851, 0xC5F0, 0xC3C3, 0xC1E7, 0xC078, 0xBFCA, 
	0xBFE4, 0xC071, 0xC11B, 0xC18E, 0xC174, 0xC078, 0xBE25, 0xBAA0, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x01C0, 0x0183, 0x0309, 0x06F8, 
	0x0C59, 0x1234, 0x1795, 0x1B84, 0x1D0A, 0x1D09, 0x1D00, 0x1CF4, 0x1CE9, 
	0x1CE4, 0x1CE8, 0x1CF3, 0x1CFE, 0x1D0B, 0x1D18, 0x1D27, 0x1D35, 0x1D45, 
	0x1D55, 0x1D65, 0x1D76, 0x1D86, 0x1D97, 0x1DA8, 0x1DBA, 0x1DCA, 0x1DDB, 
	0x1DEC, 0x1DFC, 0x1E0C, 0x1E1B, 0x1E29, 0x1E37, 0x1E44, 0x1E51, 0x1E5C, 
	0x1E66, 0x1E70, 0x1E78, 0x1E7E, 0x1E84, 0x1E88, 0x1E8A, 0x1E8B, 0x1DC1, 
	0x1CE8, 0x1CF9, 0x1D5A, 0x1DEF, 0x1E9C, 0x1F46, 0x1FD1, 0x2021, 0x201A, 
	0x1FA1, 0x1E99, 0x1CE8, 0x1A41, 0x1694, 0x1221, 0x0D25, 0x07DE, 0x028B, 
	0xFD6A, 0xF8B8, 0xF4B5, 0xF19E, 0xEFC0, 0xEF05, 0xEF20, 0xEFC0, 0xF094, 
	0xF14F, 0xF19E, 0x1192, 0x0A73, 0x0A98, 0x0AF8, 0x0B7C, 0x0C0B, 0x0C8E, 
	0x0CEE, 0x0D13, 0x0D0F, 0x0D1B, 0x0D30, 0x0D47, 0x0D5A, 0x0D63, 0x0D65, 
	0x0D67, 0x0D68, 0x0D6A, 0x0D6D, 0x0D6F, 0x0D71, 0x0D73, 0x0D76, 0x0D78, 
	0x0D7B, 0x0D7D, 0x0D80, 0x0D82, 0x0D85, 0x0D87, 0x0D8A, 0x0D8C, 0x0D8F, 
	0x0D91, 0x0D93, 0x0D95, 0x0D97, 0x0D99, 0x0D9B, 0x0D9C, 0x0D9D, 0x0D9F, 
	0x0DA0, 0x0DA0, 0x0DA1, 0x0DA1, 0x0DA2, 0x0D84, 0x0D63, 0x0D66, 0x0D74, 
	0x0D8A, 0x0DA4, 0x0DBD, 0x0DD2, 0x0DDE, 0x0DDD, 0x0DCB, 0x0DA4, 0x0D63, 
	0x0CFE, 0x0C73, 0x0BC9, 0x0B0C, 0x0A43, 0x0978, 0x08B5, 0x0802, 0x076A, 
	0x06F4, 0x06AD, 0x0691, 0x0695, 0x06AD, 0x06CD, 0x06E8, 0x06F4, 0x842B, 
	0x7A2D, 0x8BE4, 0x9896, 0xA119, 0xA642, 0xA8E9, 0xA9E3, 0xAA06, 0xA8A0, 
	0xA72B, 0xA5D1, 0xA4B7, 0xA406, 0xA3E6, 0xA41F, 0xA463, 0xA4B0, 0xA505, 
	0xA564, 0xA5CA, 0xA637, 0xA6AB, 0xA725, 0xA7A5, 0xA82A, 0xA8B3, 0xA941, 
	0xA9D2, 0xAA66, 0xAAFD, 0xAB96, 0xAC2F, 0xACCA, 0xAD65, 0xAE00, 0xAE9B, 
	0xAF34, 0xAFCB, 0xB05F, 0xB0F1, 0xB180, 0xB20A, 0xB290, 0xB311, 0xB38D, 
	0xB402, 0xB471, 0xB3A5, 0xB290, 0xB2B6, 0xB354, 0xB43F, 0xB54E, 0xB656, 
	0xB72B, 0xB7A3, 0xB794, 0xB6D3, 0xB536, 0xB290, 0xAE6E, 0xA8B3, 0xA1C2, 
	0x99FC, 0x91C2, 0x8974, 0x8174, 0x7A20, 0x73DE, 0x6F0D, 0x6C22, 0x6B00, 
	0x6B29, 0x6C22, 0x6D6E, 0x6E91, 0x6F0D, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x4A21, 0x4998, 0x47FC, 
	0x454E, 0x418D, 0x3DCD, 0x3B1F, 0x3983, 0x38FA, 0x394D, 0x3938, 0x38D4, 
	0x3838, 0x377E, 0x36BC, 0x35F9, 0x352E, 0x345A, 0x337E, 0x329A, 0x31B1, 
	0x30C1, 0x2FCC, 0x2ED2, 0x2DD4, 0x2CD3, 0x2BCF, 0x2AC9, 0x29C1, 0x28B8, 
	0x27AF, 0x26A7, 0x25A0, 0x249A, 0x2396, 0x2296, 0x2199, 0x20A0, 0x1FAD, 
	0x1EBE, 0x1DD6, 0x1CF5, 0x1C1B, 0x1B49, 0x1A80, 0x19C0, 0x190A, 0x185F, 
	0x1BE8, 0x2010, 0x2082, 0x20B1, 0x20AC, 0x2081, 0x2040, 0x1FF7, 0x1FB5, 
	0x1F88, 0x1F7E, 0x1FA7, 0x2010, 0x2446, 0x2751, 0x24FD, 0x21C4, 0x1DFA, 
	0x19F7, 0x1610, 0x129D, 0x0FF2, 0x0E66, 0x0DD1, 0x0DE0, 0x0EA4, 0x102F, 
	0x1294, 0x15E6, 0x1A37, 0x201C, 0x27BB, 0x09D3, 0x089E, 0x06DB, 0x0534, 
	0x03B7, 0x0274, 0x0178, 0x00D2, 0x0092, 0x008F, 0x008B, 0x0086, 0x0083, 
	0x0084, 0x008A, 0x0096, 0x00A5, 0x00B8, 0x00CE, 0x00E7, 0x0102, 0x011E, 
	0x013B, 0x015A, 0x0178, 0x0196, 0x01B4, 0x01D0, 0x01EA, 0x0203, 0x0218, 
	0x022B, 0x023A, 0x0245, 0x024B, 0x024C, 0x0248, 0x023E, 0x022D, 0x0215, 
	0x01F6, 0x01CF, 0x014E, 0x0044, 0xFEE7, 0xFD6E, 0xFC0F, 0xFAFF, 0xFADC, 
	0xFB24, 0xFB22, 0xFB17, 0xFB06, 0xFAF3, 0xFAE0, 0xFAD1, 0xFAC8, 0xFAC9, 
	0xFAD7, 0xFAF4, 0xFB24, 0xFB70, 0xFBD8, 0xFC56, 0xFCE3, 0xFD79, 0xFE10, 
	0xFEA1, 0xFF26, 0xFF98, 0xFFEF, 0x0023, 0x0034, 0x002E, 0x0019, 0x0001, 
	0xFFF0, 0xFFEF, 0x0000, 0x001A, 0xFE32, 0x06FF, 0x0693, 0x057F, 0x0405, 
	0x0269, 0x00EF, 0xFFD9, 0xFF6E, 0xFF74, 0xFF79, 0xFF7B, 0xFF79, 0xFF71, 
	0xFF64, 0xFF51, 0xFF3D, 0xFF26, 0xFF0E, 0xFEF5, 0xFEDA, 0xFEBE, 0xFEA1, 
	0xFE84, 0xFE66, 0xFE48, 0xFE2B, 0xFE0D, 0xFDF0, 0xFDD4, 0xFDB8, 0xFD9E, 
	0xFD85, 0xFD6E, 0xFD58, 0xFD45, 0xFD34, 0xFD25, 0xFD19, 0xFD0F, 0xFD09, 
	0xFD06, 0xFD25, 0xFD77, 0xFDE8, 0xFE67, 0xFEDF, 0xFF3E, 0xFF66, 0xFF69, 
	0xFF6C, 0xFF6E, 0xFF70, 0xFF71, 0xFF72, 0xFF71, 0xFF71, 0xFF70, 0xFF6E, 
	0xFF6C, 0xFF69, 0xFF66, 0xFF61, 0xFF5B, 0xFF54, 0xFF4D, 0xFF46, 0xFF3F, 
	0xFF39, 0xFF34, 0xFF30, 0xFF2D, 0xFF2A, 0xFF29, 0xFF29, 0xFF2A, 0xFF2C, 
	0xFF30, 0xFF35, 0xFF3E, 0xABC3, 0xB9EB, 0xB91C, 0xB6FF, 0xB40E, 0xB0C2, 
	0xAD95, 0xAB00, 0xA97B, 0xA930, 0xA961, 0xA9E8, 0xAAA2, 0xAB69, 0xAC18, 
	0xACB0, 0xAD4A, 0xADE4, 0xAE81, 0xAF20, 0xAFC1, 0xB064, 0xB10A, 0xB1B4, 
	0xB260, 0xB311, 0xB3C5, 0xB47D, 0xB53A, 0xB5FB, 0xB6C1, 0xB78C, 0xB85D, 
	0xB933, 0xBA0F, 0xBAF2, 0xBBDB, 0xBCCA, 0xBDC1, 0xBEBE, 0xBFC4, 0xC0D0, 
	0xC25C, 0xC4AA, 0xC76A, 0xCA4E, 0xCD07, 0xCF46, 0xD021, 0xD00F, 0xD01F, 
	0xD030, 0xD040, 0xD04E, 0xD059, 0xD05F, 0xD060, 0xD059, 0xD04B, 0xD032, 
	0xD00F, 0xCFDA, 0xCF91, 0xCF39, 0xCED5, 0xCE6C, 0xCE02, 0xCD9C, 0xCD3F, 
	0xCCEF, 0xCCB1, 0xCCD7, 0xCD79, 0xCE44, 0xCEE7, 0xCF11, 0xCE6F, 0xCCB1, 
	0xC90E, 0xC389, 

},{ 
	0x0001, 0x0000, 0x0050, 0x0001, 0x0049, 0x0051, 0x0001, 0x009A, 0x0001, 
	0x009B, 0x0001, 0x009C, 0x0050, 0x009D, 0x0050, 0x00ED, 0x0050, 0x013D, 
	0x0050, 0x018D, 0x0050, 0x01DD, 0x0050, 0x022D, 0x0002, 0x027D, 0x0002, 
	0x027F, 0x0050, 0x0281, 0x0001, 0x02D1, 0x0001, 0x02D2, 0x0001, 0x02D3, 
	0x0050, 0x02D4, 0x0050, 0x0324, 0x0050, 0x0374, 0x0002, 0x03C4, 0x0002, 
	0x03C6, 0x0050, 0x03C8, 0x000F, 0x0418, 0x000F, 0x0427, 0x000F, 0x0436, 
	0x0001, 0x0445, 0x0001, 0x0446, 0x0001, 0x0447, 0x0050, 0x0448, 0x0050, 
	0x0498, 0x0050, 0x04E8, 0x0002, 0x0538, 0x0002, 0x053A, 0x0050, 0x053C, 
	0x0050, 0x058C, 0x000F, 0x05DC, 0x000F, 0x05EB, 0x004F, 0x05FA, 0x004F, 
	0x0649, 0x0001, 0x0698, 0x0050, 0x0699, 0x0050, 0x06E9, 0x0050, 0x0739, 
	0x0001, 0x0789, 0x0001, 0x078A, 0x0050, 0x078B, 0x004F, 0x07DB, 0x004F, 
	0x082A, 0x0050, 0x0879, 0x004F, 0x08C9, 0x004F, 0x0918, 0x0001, 0x0967, 
	0x004E, 0x0968, 0x004E, 0x09B6, 0x004E, 0x0A04, 0x0001, 0x0A52, 0x0012, 
	0x0A53, 0x0050, 0x0A65, 0x0050, 0x0AB5, 0x0050, 0x0B05, 0x0050, 0x0B55, 
	

});

smlua_anim_util_register_animation('donkey_4B_land_from_double_jump',1, 0, 0, 0, 17, { 
	0x0000, 0x00B4, 0x009A, 0x0088, 0x007D, 0x007A, 0x0077, 0x0075, 0x0074, 
	0x0073, 0x0074, 0x0077, 0x007B, 0x007F, 0x0084, 0x0088, 0x008A, 0x008B, 
	0x0000, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 
	0xFFFC, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x40A1, 
	0x4C9E, 0x552F, 0x5A52, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5BD2, 
	0x5B38, 0x5A50, 0x593F, 0x582E, 0x5746, 0x56AB, 0x5675, 0x0112, 0x009A, 
	0x0045, 0x0011, 0x0000, 0xFFFF, 0x0000, 0x0B88, 0x0BED, 0x0C36, 0x0C61, 
	0x0C70, 0x0D25, 0x0DA7, 0x0DF5, 0x0E0E, 0x0DA9, 0x0C87, 0x0AD6, 0x08D7, 
	0x06D8, 0x0526, 0x0405, 0x039F, 0xFEC1, 0xFF39, 0xFF8B, 0xFFC0, 0xFFE1, 
	0xFFF3, 0xFFFB, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFEBF, 0xFF37, 0xFF8A, 0xFFC0, 0xFFE0, 
	0xFFF2, 0xFFFB, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF4FC, 0xF409, 0xF362, 0xF2F5, 0xF2B3, 
	0xF28F, 0xF27E, 0xF277, 0xF276, 0xF276, 0xF24C, 0xF1D5, 0xF124, 0xF052, 
	0xEF81, 0xEECF, 0xEE59, 0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xC04D, 0xC659, 
	0xD87F, 0xEAA4, 0xF0B1, 0xEE92, 0xED0F, 0xEC27, 0xEBD9, 0xECEB, 0xF021, 
	0xF57B, 0xFCF8, 0x069B, 0x137D, 0x1B39, 0x1DCC, 0xCF99, 0xD1E8, 0xD8D5, 
	0xDFC1, 0xE210, 0xE259, 0xE28D, 0xE2AC, 0xE2B7, 0xE265, 0xE16E, 0xDFD4, 
	0xDD96, 0xDAB4, 0xD9C3, 0xD932, 0xD901, 0xF5D2, 0xF25B, 0xE7F4, 0xDD8E, 
	0xDA16, 0xDCBD, 0xDEA2, 0xDFC5, 0xE026, 0xDF41, 0xDC90, 0xD815, 0xD1CE, 
	0xC9BC, 0xC01B, 0xBA54, 0xB867, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xD2B7, 
	0xCE82, 0xC1E4, 0xB545, 0xB110, 0xAEE3, 0xAD55, 0xAC66, 0xAC16, 0xAD05, 
	0xAFD2, 0xB47C, 0xBB05, 0xC18D, 0xC638, 0xC905, 0xC9F4, 0xFFFF, 0x023E, 
	0x08F6, 0x0FAF, 0x11ED, 0x13BA, 0x1503, 0x15C8, 0x160A, 0x1593, 0x142C, 
	0x11D7, 0x0E93, 0x0B4F, 0x08F9, 0x0793, 0x071C, 0xFFFF, 0x0076, 0x01D9, 
	0x033C, 0x03B3, 0x041A, 0x0463, 0x0490, 0x049E, 0x0492, 0x046B, 0x042B, 
	0x03D2, 0x0379, 0x0339, 0x0312, 0x0306, 0xF1C6, 0xF48D, 0xFCE1, 0x0536, 
	0x07FD, 0x0759, 0x06E5, 0x069E, 0x0687, 0x06A7, 0x0708, 0x07A9, 0x088B, 
	0x096D, 0x0A0F, 0x0A6F, 0x0A90, 0xFFFE, 0x0001, 0xC170, 0x3213, 0x32AC, 
	0x3477, 0x3641, 0x36DA, 0x2F46, 0x309C, 0x349B, 0x389B, 0x39F0, 0x3773, 
	0x35AC, 0x349B, 0x3440, 0x3545, 0x3856, 0x3D73, 0x449B, 0x4BC2, 0x50DF, 
	0x53F0, 0x54F5, 0xFCD7, 0xFE4A, 0x02A3, 0x06FB, 0x086D, 0x086D, 0x086D, 
	0x086D, 0x086D, 0x08E5, 0x0A4B, 0x0CA0, 0x0FE5, 0x1329, 0x157E, 0x16E5, 
	0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xD757, 0xD21C, 0xC26D, 0xB2BD, 0xAD82, 0xAB55, 0xA9C6, 0xA8D8, 
	0xA888, 0xA99F, 0xACE3, 0xB255, 0xB9F4, 0xC193, 0xC705, 0xCA49, 0xCB60, 
	0xF76B, 0xF7CD, 0xF8F3, 0xFA18, 0xFA7A, 0xFA64, 0xFA55, 0xFA4C, 0xFA49, 
	0xFA48, 0xFA48, 0xFA47, 0xFA45, 0xFA44, 0xFA42, 0x0F23, 0x0D87, 0x08B1, 
	0x03DB, 0x023E, 0x0200, 0x01D4, 0x01B9, 0x01B0, 0x01AF, 0x01AD, 0x01A9, 
	0x01A4, 0x019E, 0x019A, 0x0198, 0x0197, 0xF1E2, 0xF501, 0xFE5C, 0x07B8, 
	0x0AD6, 0x0916, 0x07D6, 0x0715, 0x06D5, 0x06D0, 0x06BF, 0x06A4, 0x067D, 
	0x0656, 0x063A, 0x062A, 0x0624, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBFC6, 
	0xBFD3, 0xBF5E, 0xBB4B, 0xBF5E, 0xFEAA, 0x0230, 0x04B3, 0x0635, 0x06B5, 
	0x07F3, 0x08D6, 0x095E, 0x098C, 0x0921, 0x07F2, 0x062C, 0x0414, 0x01FC, 
	0x0036, 0xFF06, 0xFE9B, 0xEEA3, 0xEFCF, 0xF0A5, 0xF126, 0xF151, 0xF206, 
	0xF288, 0xF2D5, 0xF2EF, 0xF2D2, 0xF280, 0xF205, 0xF174, 0xF0E3, 0xF068, 
	0xF016, 0xEFF9, 0x79CC, 0x74A9, 0x70FE, 0x6ECA, 0x6E0E, 0x6A5A, 0x67B4, 
	0x661E, 0x6596, 0x66BB, 0x69FC, 0x6EDB, 0x749A, 0x7A59, 0x7F38, 0x827A, 
	0x839E, 0x0000, 0x0000, 0xFFFF, 0x4884, 0x514E, 0x5795, 0x5B59, 0x5C9B, 
	0x6050, 0x62F5, 0x648C, 0x6514, 0x640B, 0x611A, 0x5CB2, 0x5781, 0x524F, 
	0x4DE8, 0x4AF6, 0x49EE, 0xFFFF, 0xFC2B, 0xF96E, 0xF7CA, 0xF73E, 0xF747, 
	0xF74D, 0xF750, 0xF751, 0xF755, 0xF75F, 0xF76E, 0xF780, 0xF791, 0xF7A0, 
	0xF7AA, 0xF7AE, 0xFFFF, 0x0122, 0x01F1, 0x026D, 0x0296, 0x02B2, 0x02C6, 
	0x02D2, 0x02D6, 0x02DF, 0x02F9, 0x0320, 0x034E, 0x037C, 0x03A3, 0x03BD, 
	0x03C6, 0xD467, 0xC019, 0xB198, 0xA8E4, 0xA5FE, 0xA67D, 0xA6D8, 0xA70F, 
	0xA721, 0xA74C, 0xA7C7, 0xA880, 0xA95A, 0xAA33, 0xAAEC, 0xAB67, 0xAB92, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xFFFF, 0xFCD3, 0xFA8F, 0xF933, 
	0xF8BF, 0xF74B, 0xF642, 0xF5A3, 0xF56E, 0xF5E6, 0xF73C, 0xF93B, 0xFB96, 
	0xFDF2, 0xFFF1, 0x0148, 0x01C0, 0xFFFF, 0x0714, 0x0C23, 0x0F2C, 0x102E, 
	0x0F5C, 0x0EC6, 0x0E6C, 0x0E4E, 0x0E6E, 0x0EC9, 0x0F50, 0x0FF0, 0x1090, 
	0x1118, 0x1172, 0x1192, 0xB90D, 0x9855, 0x80F5, 0x72F0, 0x6E43, 0x6A4F, 
	0x677D, 0x65CB, 0x653B, 0x6668, 0x69C3, 0x6EC8, 0x74B3, 0x7A9F, 0x7FA3, 
	0x82FE, 0x842B, 0x0000, 0xFFFF, 0x0000, 0x0F93, 0x315D, 0x497F, 0x57FA, 
	0x5CCE, 0x60C0, 0x6392, 0x6543, 0x65D4, 0x64C6, 0x61C5, 0x5D47, 0x57FA, 
	0x52AD, 0x4E2F, 0x4B2F, 0x4A21, 0xFFFF, 0x045D, 0x077B, 0x095A, 0x09F9, 
	0x09F7, 0x09F4, 0x09F3, 0x09F3, 0x09F2, 0x09EE, 0x09E9, 0x09E3, 0x09DD, 
	0x09D7, 0x09D4, 0x09D3, 0xFFFF, 0xFFCF, 0xFFAD, 0xFF98, 0xFF91, 0xFF64, 
	0xFF43, 0xFF30, 0xFF29, 0xFF20, 0xFF05, 0xFEDD, 0xFEAE, 0xFE7F, 0xFE57, 
	0xFE3C, 0xFE32, 0xD659, 0xC14D, 0xB244, 0xA93E, 0xA63D, 0xA6F3, 0xA775, 
	0xA7C3, 0xA7DD, 0xA803, 0xA870, 0xA911, 0xA9D0, 0xAA8F, 0xAB31, 0xAB9D, 
	0xABC3, 

},{ 
	0x0001, 0x0000, 0x0011, 0x0001, 0x0010, 0x0012, 0x0001, 0x0022, 0x0001, 
	0x0023, 0x0001, 0x0024, 0x0002, 0x0025, 0x000E, 0x0027, 0x0011, 0x0035, 
	0x0005, 0x0046, 0x0002, 0x004B, 0x0011, 0x004D, 0x0012, 0x005E, 0x0012, 
	0x0070, 0x0012, 0x0082, 0x0001, 0x0094, 0x0001, 0x0095, 0x0001, 0x0096, 
	0x0011, 0x0097, 0x0011, 0x00A8, 0x0011, 0x00B9, 0x0010, 0x00CA, 0x000F, 
	0x00DA, 0x0011, 0x00E9, 0x0011, 0x00FA, 0x0011, 0x010B, 0x0011, 0x011C, 
	0x0001, 0x012D, 0x0001, 0x012E, 0x0001, 0x012F, 0x0005, 0x0130, 0x0011, 
	0x0135, 0x0011, 0x0146, 0x0001, 0x0157, 0x0011, 0x0158, 0x0011, 0x0169, 
	0x000F, 0x017A, 0x0011, 0x0189, 0x0011, 0x019A, 0x000F, 0x01AB, 0x0010, 
	0x01BA, 0x0005, 0x01CA, 0x0011, 0x01CF, 0x0011, 0x01E0, 0x0011, 0x01F1, 
	0x0001, 0x0202, 0x0002, 0x0203, 0x0011, 0x0205, 0x0011, 0x0216, 0x0011, 
	0x0227, 0x0011, 0x0238, 0x000F, 0x0249, 0x0010, 0x0258, 0x0001, 0x0268, 
	0x0011, 0x0269, 0x0011, 0x027A, 0x0011, 0x028B, 0x0002, 0x029C, 0x0001, 
	0x029E, 0x0011, 0x029F, 0x0011, 0x02B0, 0x0011, 0x02C1, 0x0011, 0x02D2, 
	

});

smlua_anim_util_register_animation('donkey_4D_single_jump',0, 0, 0, 12, 12, { 
	0x0000, 0x008B, 0x008B, 0x008A, 0x0088, 0x0085, 0x0081, 0x007D, 0x0079, 
	0x0075, 0x0072, 0x0070, 0x006F, 0x0000, 0x0000, 0x00E4, 0x038E, 0x0800, 
	0x0E39, 0x1639, 0x2000, 0x29C7, 0x31C7, 0x3800, 0x3C72, 0x3F1C, 0x4000, 
	0x3FFF, 0x3FFB, 0x3FEE, 0x3FD9, 0x3FBC, 0x3F96, 0x3F68, 0x3F3B, 0x3F15, 
	0x3EF8, 0x3EE3, 0x3ED6, 0x3ED2, 0x0000, 0x00E4, 0x038E, 0x0800, 0x0E39, 
	0x1639, 0x2000, 0x29C7, 0x31C7, 0x3800, 0x3C72, 0x3F1C, 0x4000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x5675, 0x56A5, 0x5735, 0x580D, 
	0x589D, 0x58CD, 0x57E6, 0x5592, 0x5262, 0x4EE9, 0x4BBA, 0x4965, 0x487E, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFF3, 0xFFD7, 0xFFBC, 
	0xFFB0, 0xFFC4, 0xFFEA, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFF1, 0xFFD1, 0xFFB2, 0xFFA3, 0xFFBB, 0xFFE7, 0x0000, 0x039F, 
	0x01D2, 0xFC68, 0xF44B, 0xEEE3, 0xED15, 0xEC8A, 0xEC42, 0xEC28, 0xEC24, 
	0xEE2A, 0xF1EC, 0xF3F2, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFD, 0xFFF8, 0xFFF4, 0xFFF2, 0xFFF5, 0xFFFC, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0004, 0x000C, 0x0015, 0x0019, 0x0012, 
	0x0006, 0xFFFF, 0xEE2F, 0xF0E1, 0xF8F6, 0x0517, 0x0D2C, 0x0FDE, 0x0DD3, 
	0x0954, 0x04D5, 0x02CA, 0x0395, 0x050F, 0x05DA, 0x0000, 0xFFFF, 0xB1C6, 
	0x1DCC, 0x1DD5, 0x1DF0, 0x1E18, 0x1E32, 0x1E3B, 0x1E3D, 0x1E44, 0x1E4A, 
	0x1E4C, 0x1E4C, 0x1E4B, 0x1E49, 0xD902, 0xD8FD, 0xD8F0, 0xD8DD, 0xD8D0, 
	0xD8CC, 0xD9DF, 0xDD18, 0xE051, 0xE164, 0xE193, 0xE221, 0xE30D, 0xC5E8, 
	0xC1AB, 0xB4F4, 0xA1E1, 0x952A, 0x90ED, 0x8D02, 0x8142, 0x7581, 0x7196, 
	0x71FC, 0x732E, 0x752C, 0xFFFF, 0x024C, 0x0931, 0x1389, 0x1A6E, 0x1CBA, 
	0x1C2E, 0x1AE1, 0x1953, 0x1805, 0x1779, 0x1954, 0x1B2E, 0xFFFF, 0x02CE, 
	0x0B37, 0x17D5, 0x203F, 0x230C, 0x2260, 0x20C3, 0x1ED7, 0x1D3B, 0x1C8E, 
	0x1E93, 0x2098, 0xC9F4, 0xCC9B, 0xD48F, 0xE07D, 0xE871, 0xEB18, 0xEC6F, 
	0xECCB, 0xECD2, 0xED2D, 0xEE84, 0xF299, 0xF5A7, 0x071C, 0x068A, 0x04D5, 
	0x0246, 0x0092, 0xFFFF, 0x000A, 0x0023, 0x0041, 0x005A, 0x0065, 0x000C, 
	0xFFB2, 0x0306, 0x02B5, 0x01C4, 0x005A, 0xFF68, 0xFF17, 0xFA99, 0xF34B, 
	0xEB5E, 0xE501, 0xE265, 0xE747, 0xEC28, 0x0A90, 0x09B7, 0x072E, 0x0361, 
	0x00D8, 0x0000, 0xFF60, 0xFF00, 0xFECF, 0xFEBD, 0xFEBA, 0x0034, 0x01AE, 
	0x0000, 0xFFFF, 0xB1C6, 0x36DA, 0x3A78, 0x4553, 0xD59A, 0xE075, 0xE413, 
	0xE2F4, 0xE091, 0xDA01, 0xD58E, 0xD487, 0xD410, 0xD3E1, 0x54F5, 0x55CE, 
	0x585A, 0x23D5, 0x214A, 0x2071, 0x2064, 0x2029, 0x1F43, 0x1E90, 0x1E64, 
	0x1E4F, 0x1E46, 0x24DD, 0x23CC, 0x2097, 0x9BC7, 0x9892, 0x9781, 0x8BFE, 
	0x7CF3, 0x6F8E, 0x6900, 0x6802, 0x67A4, 0x6797, 0xFFFF, 0xFDB3, 0xF6CE, 
	0xEC76, 0xE591, 0xE345, 0xE36A, 0xE3FB, 0xE548, 0xE754, 0xE88C, 0xE7BB, 
	0xE711, 0x0000, 0xFD31, 0xF4C8, 0xE82A, 0xDFC0, 0xDCF3, 0xDD28, 0xDDF4, 
	0xDFCA, 0xE2A3, 0xE446, 0xE2D3, 0xE1B9, 0xCB60, 0xCDEA, 0xD586, 0xE0F1, 
	0xE88E, 0xEB18, 0xECF6, 0xEDC4, 0xEE11, 0xEE6D, 0xEF69, 0xF12B, 0xF22F, 
	0xFA42, 0xFAB7, 0xFC18, 0xFE29, 0xFF89, 0x0000, 0x0005, 0x0018, 0x0041, 
	0x007C, 0x0091, 0xFF88, 0xFEE0, 0x0197, 0x0189, 0x015F, 0x0120, 0x00F6, 
	0x00E8, 0x01D9, 0x04FC, 0x0C0F, 0x175F, 0x1EBF, 0x1409, 0x0C3B, 0x0624, 
	0x05A6, 0x042D, 0x01F7, 0x007E, 0x0000, 0x0011, 0x0038, 0x0067, 0x008E, 
	0x009F, 0xFFB7, 0xFED0, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x9FFF, 0xFE9A, 0xFEAB, 0xFEDE, 0xFF33, 0xFFA9, 0x0043, 0x00FE, 0x01B8, 
	0x0251, 0x02C8, 0x031C, 0x034F, 0x0360, 0xEFF9, 0xF00E, 0xF04D, 0xF0B5, 
	0xF148, 0xF205, 0xF2EB, 0xF3D2, 0xF48E, 0xF521, 0xF58A, 0xF5C9, 0xF5DE, 
	0xAF1A, 0xAF0E, 0xAEE9, 0xAEAB, 0xAE55, 0xADE5, 0xAD5D, 0xACD5, 0xAC66, 
	0xAC0F, 0xABD2, 0xABAD, 0xABA0, 0x00DC, 0x010C, 0x019C, 0x028C, 0x03DC, 
	0x058C, 0x079C, 0x09AC, 0x0B5C, 0x0CAC, 0x0D9C, 0x0E2C, 0x0E5C, 0x0450, 
	0x0466, 0x04A8, 0x0515, 0x05AF, 0x0674, 0x0765, 0x0857, 0x091C, 0x09B5, 
	0x0A23, 0x0A65, 0x0A7B, 0x3F60, 0x3F10, 0x3E1E, 0x3C8B, 0x3A57, 0x3782, 
	0x340B, 0x3095, 0x2DC0, 0x2B8C, 0x29F9, 0x2907, 0x28B6, 0xF8E9, 0xF8BF, 
	0xF83F, 0xF76A, 0xF640, 0xF4C1, 0xF2ED, 0xF119, 0xEF9A, 0xEE70, 0xED9B, 
	0xED1B, 0xECF1, 0x03F1, 0x03EB, 0x03D8, 0x03B8, 0x038C, 0x0353, 0x030D, 
	0x02C7, 0x028E, 0x0262, 0x0242, 0x022F, 0x0229, 0xAEAA, 0xAF97, 0xB260, 
	0xB704, 0xBD83, 0xC5DC, 0xD011, 0xDA46, 0xE2A0, 0xE91F, 0xEDC3, 0xF08C, 
	0xF179, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x9FFF, 
	0x01BF, 0x01AC, 0x0176, 0x011B, 0x009B, 0xFFF6, 0xFF2E, 0xFE66, 0xFDC2, 
	0xFD43, 0xFCE8, 0xFCB1, 0xFC9F, 0x1192, 0x1178, 0x1128, 0x10A4, 0x0FEB, 
	0x0EFD, 0x0DDA, 0x0CB7, 0x0BC9, 0x0B0F, 0x0A8B, 0x0A3C, 0x0A21, 0xAFA7, 
	0xAF98, 0xAF6D, 0xAF26, 0xAEC2, 0xAE41, 0xADA3, 0xAD06, 0xAC85, 0xAC21, 
	0xABD9, 0xABAE, 0xABA0, 0xFEF9, 0xFECA, 0xFE3C, 0xFD4F, 0xFC03, 0xFA58, 
	0xF84E, 0xF645, 0xF49A, 0xF34E, 0xF261, 0xF1D3, 0xF1A3, 0xFB4D, 0xFB39, 
	0xFAFB, 0xFA94, 0xFA04, 0xF94B, 0xF869, 0xF787, 0xF6CE, 0xF63E, 0xF5D7, 
	0xF599, 0xF584, 0x3FC4, 0x3F72, 0x3E7C, 0x3CE2, 0x3AA5, 0x37C3, 0x343D, 
	0x30B8, 0x2DD6, 0x2B98, 0x29FE, 0x2908, 0x28B6, 0x087A, 0x08A0, 0x0911, 
	0x09CD, 0x0AD4, 0x0C27, 0x0DC4, 0x0F62, 0x10B4, 0x11BC, 0x1278, 0x12E9, 
	0x130E, 0xFE09, 0xFE09, 0xFE07, 0xFE03, 0xFDFE, 0xFDF8, 0xFDF0, 0xFDE8, 
	0xFDE1, 0xFDDC, 0xFDD9, 0xFDD7, 0xFDD6, 0xAEBF, 0xAFAD, 0xB274, 0xB717, 
	0xBD93, 0xC5EB, 0xD01C, 0xDA4E, 0xE2A5, 0xE922, 0xEDC4, 0xF08C, 0xF179, 
	

},{ 
	0x0001, 0x0000, 0x000C, 0x0001, 0x0001, 0x000D, 0x000D, 0x000E, 0x000D, 
	0x001B, 0x000D, 0x0028, 0x000B, 0x0035, 0x000D, 0x0040, 0x000D, 0x004D, 
	0x000D, 0x005A, 0x000D, 0x0067, 0x000D, 0x0074, 0x000D, 0x0081, 0x000D, 
	0x008E, 0x000D, 0x009B, 0x0001, 0x00A8, 0x0001, 0x00A9, 0x0001, 0x00AA, 
	0x000D, 0x00AB, 0x000D, 0x00B8, 0x000D, 0x00C5, 0x000D, 0x00D2, 0x000D, 
	0x00DF, 0x000D, 0x00EC, 0x000D, 0x00F9, 0x000D, 0x0106, 0x000D, 0x0113, 
	0x0001, 0x0120, 0x0001, 0x0121, 0x0001, 0x0122, 0x000D, 0x0123, 0x000D, 
	0x0130, 0x000D, 0x013D, 0x000D, 0x014A, 0x000D, 0x0157, 0x000D, 0x0164, 
	0x000D, 0x0171, 0x000D, 0x017E, 0x000D, 0x018B, 0x000B, 0x0198, 0x000D, 
	0x01A3, 0x0001, 0x01B0, 0x000D, 0x01B1, 0x000D, 0x01BE, 0x000D, 0x01CB, 
	0x000D, 0x01D8, 0x000D, 0x01E5, 0x000D, 0x01F2, 0x000D, 0x01FF, 0x000D, 
	0x020C, 0x000D, 0x0219, 0x000D, 0x0226, 0x000C, 0x0233, 0x0001, 0x023F, 
	0x000D, 0x0240, 0x000D, 0x024D, 0x000D, 0x025A, 0x000D, 0x0267, 0x000D, 
	0x0274, 0x000D, 0x0281, 0x000D, 0x028E, 0x000D, 0x029B, 0x000D, 0x02A8, 
	

});

smlua_anim_util_register_animation('donkey_4E_land_from_single_jump',0, 0, 0, 0, 37, { 
	0x0000, 0x008B, 0x008B, 0x008A, 0x0088, 0x0085, 0x0081, 0x007D, 0x0079, 
	0x0075, 0x0072, 0x0070, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 
	0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x006F, 0x0070, 0x0074, 0x0078, 
	0x007A, 0x0076, 0x0074, 0x0073, 0x0074, 0x0078, 0x007D, 0x0082, 0x0087, 
	0x008A, 0x008B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFE, 0xFFFD, 
	0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x00E4, 0x038E, 0x0800, 0x0E39, 0x1639, 0x2000, 
	0x29C7, 0x31C7, 0x3800, 0x3C72, 0x3F1C, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3600, 0x2000, 
	0x0A00, 0x0000, 0x3FFF, 0x3FFB, 0x3FEE, 0x3FD9, 0x3FBC, 0x3F96, 0x3F68, 
	0x3F3B, 0x3F15, 0x3EF8, 0x3EE3, 0x3ED6, 0x3ED2, 0x3ED2, 0x3ED2, 0x3ED2, 
	0x3ED2, 0x3ED2, 0x3ED2, 0x3ED2, 0x3ED2, 0x3ED2, 0x3ED2, 0x3F01, 0x3F68, 
	0x3FD0, 0x3FFF, 0x0000, 0x00E4, 0x038E, 0x0800, 0x0E39, 0x1639, 0x2000, 
	0x29C7, 0x31C7, 0x3800, 0x3C72, 0x3F1C, 0x4000, 0x4000, 0x4000, 0x4000, 
	0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x3600, 0x2000, 
	0x0A00, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFE, 0x5675, 0x56A5, 0x5735, 0x580D, 0x589D, 0x58CD, 
	0x57E6, 0x5592, 0x5262, 0x4EE9, 0x4BBA, 0x4965, 0x487E, 0x487E, 0x487E, 
	0x487E, 0x487E, 0x487E, 0x487E, 0x487E, 0x487E, 0x487E, 0x487E, 0x4B8C, 
	0x5243, 0x58FB, 0x5C09, 0x5C09, 0x5C09, 0x5C09, 0x5BC2, 0x5AFC, 0x59DE, 
	0x58A0, 0x5782, 0x56BC, 0x5675, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFF3, 0xFFD7, 0xFFBC, 0xFFB0, 0xFFC4, 0xFFEA, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFF1, 0xFFD1, 
	0xFFB2, 0xFFA3, 0xFFBB, 0xFFE7, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x039F, 0x01D2, 0xFC68, 
	0xF44B, 0xEEE3, 0xED15, 0xEC8A, 0xEC42, 0xEC28, 0xEC24, 0xEE2A, 0xF1EC, 
	0xF3F2, 0xF364, 0xF25D, 0xF1CF, 0xF1D0, 0xF1DC, 0xF1FA, 0xF235, 0xF296, 
	0xF327, 0xF3F2, 0xF7FB, 0xFFD6, 0x07DF, 0x0C70, 0x0D56, 0x0DE0, 0x0E0E, 
	0x0D8A, 0x0C18, 0x0A00, 0x07AE, 0x0596, 0x0423, 0x039F, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFD, 0xFFF8, 0xFFF4, 0xFFF2, 0xFFF5, 
	0xFFFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0004, 0x000C, 0x0015, 
	0x0019, 0x0012, 0x0006, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xEE2F, 0xF0E1, 0xF8F6, 0x0517, 0x0D2C, 0x0FDE, 0x0DD3, 
	0x0954, 0x04D5, 0x02CA, 0x0395, 0x050F, 0x05DA, 0x0593, 0x04E2, 0x03FD, 
	0x0317, 0x0266, 0x021F, 0x02B4, 0x03FD, 0x0545, 0x05DA, 0x0538, 0x0382, 
	0x0101, 0xFDFD, 0xFABE, 0xF78D, 0xF4B2, 0xF276, 0xF23F, 0xF1A8, 0xF0CC, 
	0xEFD8, 0xEEFD, 0xEE65, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x1DCC, 0x1DD5, 
	0x1DF0, 0x1E18, 0x1E32, 0x1E3B, 0x1E3D, 0x1E44, 0x1E4A, 0x1E4C, 0x1E4C, 
	0x1E4B, 0x1E49, 0x1E49, 0x1E49, 0x1E49, 0x1E49, 0x1E49, 0x1E49, 0x1E49, 
	0x1E49, 0x1E49, 0x1E49, 0x1825, 0x05B9, 0xF34D, 0xED29, 0xEABE, 0xE94B, 
	0xE8CF, 0xEB6F, 0xF2C9, 0xFD68, 0x0933, 0x13D3, 0x1B2D, 0x1DCC, 0xD901, 
	0xD8FD, 0xD8F0, 0xD8DD, 0xD8D0, 0xD8CC, 0xD9DF, 0xDD18, 0xE051, 0xE164, 
	0xE193, 0xE221, 0xE30D, 0xE30D, 0xE30D, 0xE30D, 0xE30D, 0xE30D, 0xE30D, 
	0xE30D, 0xE30D, 0xE30D, 0xE30D, 0xE112, 0xDB20, 0xD52D, 0xD332, 0xD3A5, 
	0xD3EA, 0xD402, 0xD441, 0xD4F2, 0xD5F3, 0xD710, 0xD810, 0xD8C2, 0xD901, 
	0xB867, 0xB53E, 0xABC5, 0x9D8F, 0x9416, 0x90ED, 0x8D02, 0x8142, 0x7581, 
	0x7196, 0x71FC, 0x732E, 0x752C, 0x74CF, 0x73B7, 0x72A0, 0x7243, 0x7257, 
	0x7296, 0x72FD, 0x738E, 0x7448, 0x752C, 0x82F4, 0xAC4E, 0xD5A8, 0xE371, 
	0xE4DB, 0xE5B4, 0xE5FC, 0xE3BB, 0xDD68, 0xD444, 0xCA1F, 0xC0FC, 0xBAA9, 
	0xB867, 0x0000, 0x024C, 0x0931, 0x1389, 0x1A6E, 0x1CBA, 0x1C2E, 0x1AE1, 
	0x1953, 0x1805, 0x1779, 0x1954, 0x1B2E, 0x1B0B, 0x1AB1, 0x1A3D, 0x19C9, 
	0x1970, 0x194C, 0x1998, 0x1A3D, 0x1AE3, 0x1B2E, 0x16EF, 0x0D97, 0x043F, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x02CE, 0x0B37, 0x17D5, 0x203F, 0x230C, 0x2260, 
	0x20C3, 0x1ED7, 0x1D3B, 0x1C8E, 0x1E93, 0x2098, 0x2074, 0x2019, 0x1FA4, 
	0x1F2F, 0x1ED5, 0x1EB0, 0x1EFD, 0x1FA4, 0x204C, 0x2098, 0x1B80, 0x104C, 
	0x0518, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xC9F4, 0xCC9B, 0xD48F, 0xE07D, 0xE871, 0xEB18, 
	0xEC6F, 0xECCB, 0xECD2, 0xED2D, 0xEE84, 0xF299, 0xF5A7, 0xF571, 0xF4E8, 
	0xF436, 0xF383, 0xF2FB, 0xF2C4, 0xF337, 0xF436, 0xF534, 0xF5A7, 0xEAEA, 
	0xD301, 0xBA62, 0xAD82, 0xABEE, 0xAAFB, 0xAAAA, 0xAC37, 0xB08E, 0xB6D4, 
	0xBDCA, 0xC410, 0xC867, 0xC9F4, 0x071C, 0x068A, 0x04D5, 0x0246, 0x0092, 
	0xFFFF, 0x000A, 0x0023, 0x0041, 0x005A, 0x0065, 0x000C, 0xFFB2, 0xFFB2, 
	0xFFB3, 0xFFB5, 0xFFB6, 0xFFB7, 0xFFB8, 0xFFB8, 0xFFB7, 0xFFB5, 0xFFB2, 
	0xFF63, 0xFEBD, 0xFE17, 0xFDCC, 0xFDCC, 0xFDCC, 0xFDCC, 0xFE42, 0xFF8D, 
	0x016B, 0x037E, 0x055B, 0x06A6, 0x071C, 0x0306, 0x02B5, 0x01C4, 0x005A, 
	0xFF68, 0xFF17, 0xFA99, 0xF34B, 0xEB5E, 0xE501, 0xE265, 0xE747, 0xEC28, 
	0xEC0C, 0xEBC4, 0xEB67, 0xEB0A, 0xEAC2, 0xEAA6, 0xEAAC, 0xEAD6, 0xEB49, 
	0xEC28, 0xEFCB, 0xF650, 0xFC8D, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF84, 
	0x0008, 0x00C5, 0x0197, 0x0254, 0x02D7, 0x0306, 0x0A90, 0x09B7, 0x072E, 
	0x0361, 0x00D8, 0x0000, 0xFF60, 0xFF00, 0xFECF, 0xFEBD, 0xFEBA, 0x0034, 
	0x01AE, 0x01A8, 0x019B, 0x0189, 0x0177, 0x0169, 0x0164, 0x0165, 0x016D, 
	0x0183, 0x01AE, 0x0339, 0x0658, 0x0969, 0x0ACB, 0x0ACB, 0x0ACB, 0x0ACB, 
	0x0AC8, 0x0AC0, 0x0AB4, 0x0AA7, 0x0A9B, 0x0A93, 0x0A90, 0xFFFE, 0x0001, 
	0xC170, 0x36DA, 0x3A78, 0x4553, 0xD59B, 0xE075, 0xE413, 0xE2F4, 0xE091, 
	0xDA01, 0xD58E, 0xD487, 0xD410, 0xD3E1, 0xD3E1, 0xD3E1, 0xD3E1, 0xD3E1, 
	0xD3E1, 0xD3E1, 0xD3E1, 0xD3E1, 0xD3E1, 0xD3E1, 0xD37F, 0x51DF, 0x4C34, 
	0x43C1, 0x4353, 0x4311, 0x42FB, 0x4261, 0x40B2, 0x3E44, 0x3B91, 0x3923, 
	0x3774, 0x36DA, 0x54F5, 0x55CF, 0x585A, 0x23D5, 0x214A, 0x2071, 0x2064, 
	0x2029, 0x1F43, 0x1E90, 0x1E64, 0x1E4F, 0x1E46, 0x1E46, 0x1E46, 0x1E46, 
	0x1E46, 0x1E46, 0x1E46, 0x1E46, 0x1E46, 0x1E46, 0x1E46, 0x1F39, 0x5CBA, 
	0x4EAF, 0x3A14, 0x3935, 0x38B0, 0x3883, 0x39EC, 0x3DDE, 0x4392, 0x49E7, 
	0x4F9B, 0x538D, 0x54F5, 0x175C, 0x175F, 0x1768, 0x9775, 0x977E, 0x9781, 
	0x9080, 0x80F5, 0x710F, 0x6900, 0x681D, 0x67DA, 0x6797, 0x66DF, 0x65E7, 
	0x650C, 0x64AE, 0x64B2, 0x64CA, 0x650B, 0x658B, 0x665D, 0x6797, 0x7033, 
	0x0141, 0x11F0, 0x1975, 0x184E, 0x179D, 0x1762, 0x1761, 0x1761, 0x1760, 
	0x175E, 0x175D, 0x175C, 0xFFFF, 0xFDB3, 0xF6CE, 0xEC76, 0xE591, 0xE345, 
	0xE36A, 0xE3FB, 0xE548, 0xE754, 0xE88C, 0xE7BB, 0xE711, 0xE72D, 0xE773, 
	0xE7CC, 0xE827, 0xE86F, 0xE88E, 0xE86F, 0xE817, 0xE791, 0xE711, 0xE7B1, 
	0xEA5E, 0xF388, 0xFFFF, 0xFFFF, 0xFD31, 0xF4C8, 0xE82A, 0xDFC0, 0xDCF3, 
	0xDD28, 0xDDF4, 0xDFCA, 0xE2A3, 0xE446, 0xE2D3, 0xE1B9, 0xE1E7, 0xE256, 
	0xE2E5, 0xE376, 0xE3EA, 0xE41B, 0xE3E9, 0xE35C, 0xE286, 0xE1B9, 0xE27D, 
	0xE5BB, 0xF0DC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCDEA, 0xD586, 0xE0F1, 0xE88E, 0xEB18, 
	0xECF6, 0xEDC4, 0xEE11, 0xEE6D, 0xEF69, 0xF12B, 0xF22F, 0xF20A, 0xF1AE, 
	0xF136, 0xF0BE, 0xF061, 0xF03C, 0xF08A, 0xF136, 0xF1E1, 0xF22F, 0xE815, 
	0xD182, 0xBA0B, 0xAD47, 0xAB4D, 0xAA1E, 0xA9B9, 0xAB63, 0xB00F, 0xB6CE, 
	0xBE4B, 0xC50A, 0xC9B5, 0xCB60, 0xFA42, 0xFAB7, 0xFC18, 0xFE29, 0xFF89, 
	0x0000, 0x0005, 0x0018, 0x0041, 0x007C, 0x0091, 0xFF88, 0xFEE0, 0xFEE2, 
	0xFEE6, 0xFEEA, 0xFEEF, 0xFEF3, 0xFEF5, 0xFEF3, 0xFEEE, 0xFEE7, 0xFEE0, 
	0xFEC0, 0xFE37, 0xFC62, 0xF9E3, 0xF9E3, 0xF9E3, 0xF9E3, 0xF9E7, 0xF9F4, 
	0xFA08, 0xFA1D, 0xFA30, 0xFA3D, 0xFA42, 0x0197, 0x0189, 0x015F, 0x0120, 
	0x00F6, 0x00E8, 0x01D9, 0x04FC, 0x0C0F, 0x175F, 0x1EBF, 0x1409, 0x0C3B, 
	0x0C59, 0x0CA0, 0x0CFC, 0x0D59, 0x0DA4, 0x0DC3, 0x0DA3, 0x0D48, 0x0CBF, 
	0x0C3B, 0x0C0C, 0x0B44, 0x0895, 0x04F0, 0x04F0, 0x04F0, 0x04F0, 0x04C5, 
	0x044E, 0x03A3, 0x02E4, 0x0238, 0x01C1, 0x0197, 0x0624, 0x05A6, 0x042D, 
	0x01F7, 0x007E, 0x0000, 0x0011, 0x0038, 0x0067, 0x008E, 0x009F, 0xFFB7, 
	0xFED0, 0xFED1, 0xFED6, 0xFEDB, 0xFEE0, 0xFEE4, 0xFEE6, 0xFEE2, 0xFEDB, 
	0xFED3, 0xFED0, 0x0029, 0x031F, 0x0615, 0x076D, 0x076D, 0x076D, 0x076D, 
	0x075D, 0x072F, 0x06ED, 0x06A4, 0x0662, 0x0635, 0x0624, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0xFE9B, 0xFEAC, 0xFEDF, 0xFF34, 0xFFAA, 0x0044, 0x00FE, 0x01B9, 0x0251, 
	0x02C8, 0x031C, 0x034F, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 
	0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x03A5, 0x045E, 0x056E, 0x06B5, 
	0x0849, 0x093B, 0x098C, 0x0901, 0x077D, 0x054B, 0x02DC, 0x00AB, 0xFF26, 
	0xFE9B, 0xEFF9, 0xF00E, 0xF04D, 0xF0B6, 0xF148, 0xF205, 0xF2EB, 0xF3D2, 
	0xF48E, 0xF521, 0xF58A, 0xF5C9, 0xF5DE, 0xF5DE, 0xF5DE, 0xF5DE, 0xF5DE, 
	0xF5DE, 0xF5DE, 0xF5DE, 0xF5DE, 0xF5DE, 0xF5DE, 0xF528, 0xF397, 0xF207, 
	0xF151, 0xF237, 0xF2C1, 0xF2EF, 0xF2CA, 0xF260, 0xF1C8, 0xF120, 0xF088, 
	0xF01F, 0xEFF9, 0x839E, 0x842C, 0x85D7, 0x889E, 0x8C82, 0x9182, 0x979F, 
	0x9DBC, 0xA2BC, 0xA6A0, 0xA967, 0xAB12, 0xABA0, 0xAAF9, 0xA989, 0xA819, 
	0xA771, 0xA7C1, 0xA887, 0xA989, 0xAA8B, 0xAB51, 0xABA0, 0xA398, 0x9113, 
	0x7C70, 0x6E0E, 0x695A, 0x6687, 0x6596, 0x6713, 0x6B3D, 0x7143, 0x77F2, 
	0x7DF7, 0x8222, 0x839E, 0x0000, 0x0033, 0x00CC, 0x01CB, 0x0331, 0x04FC, 
	0x072E, 0x095F, 0x0B2B, 0x0C90, 0x0D8F, 0x0E29, 0x0E5C, 0x0EF4, 0x0F48, 
	0x0F6B, 0x0F73, 0x0F71, 0x0F68, 0x0F50, 0x0F20, 0x0ED1, 0x0E5C, 0x0BCF, 
	0x06E8, 0x0224, 0x0000, 0xFFFF, 0x0025, 0x0095, 0x014F, 0x0254, 0x03A3, 
	0x053D, 0x06D7, 0x0826, 0x092B, 0x09E6, 0x0A55, 0x0A7B, 0x0A53, 0x09FC, 
	0x09A4, 0x097D, 0x098F, 0x09BE, 0x09FC, 0x0A39, 0x0A68, 0x0A7B, 0x08D7, 
	0x053D, 0x01A3, 0xFFFF, 0x49EE, 0x4978, 0x4815, 0x45C7, 0x428C, 0x3E65, 
	0x3952, 0x343F, 0x3018, 0x2CDD, 0x2A8F, 0x292C, 0x28B6, 0x299A, 0x2B8D, 
	0x2D81, 0x2E65, 0x2DF9, 0x2CEC, 0x2B8D, 0x2A2F, 0x2922, 0x28B6, 0x2F3B, 
	0x3E6C, 0x4FBB, 0x5C9B, 0x6150, 0x6423, 0x6514, 0x63BB, 0x5FF7, 0x5A86, 
	0x547B, 0x4F0A, 0x4B46, 0x49EE, 0xF7AE, 0xF787, 0xF715, 0xF656, 0xF54B, 
	0xF3F3, 0xF24F, 0xF0AB, 0xEF54, 0xEE48, 0xED89, 0xED17, 0xECF1, 0xED1B, 
	0xED79, 0xEDD7, 0xEE02, 0xEDED, 0xEDBB, 0xED79, 0xED38, 0xED05, 0xECF1, 
	0xEE89, 0xF20E, 0xF597, 0xF73E, 0xF749, 0xF74F, 0xF751, 0xF756, 0xF763, 
	0xF775, 0xF78A, 0xF79C, 0xF7A9, 0xF7AE, 0x03C6, 0x03C0, 0x03AF, 0x0392, 
	0x036A, 0x0336, 0x02F7, 0x02B8, 0x0285, 0x025D, 0x0240, 0x022F, 0x0229, 
	0x01C1, 0x015E, 0x0114, 0x00F6, 0x0106, 0x012F, 0x016A, 0x01AD, 0x01EF, 
	0x0229, 0x0254, 0x0271, 0x0286, 0x0296, 0x02B9, 0x02CF, 0x02D6, 0x02E1, 
	0x0303, 0x0333, 0x0368, 0x0399, 0x03BA, 0x03C6, 0xAB92, 0xAC8B, 0xAF74, 
	0xB44F, 0xBB1B, 0xC3D8, 0xCE86, 0xD934, 0xE1F0, 0xE8BC, 0xED97, 0xF081, 
	0xF179, 0xF035, 0xED6C, 0xEAA3, 0xE95F, 0xE9F9, 0xEB79, 0xED6C, 0xEF5F, 
	0xF0DF, 0xF179, 0xE5AE, 0xCBBB, 0xB1C9, 0xA5FE, 0xA69F, 0xA700, 0xA721, 
	0xA759, 0xA7F7, 0xA8DB, 0xA9D8, 0xAABC, 0xAB5A, 0xAB92, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 
	0x01AD, 0x0177, 0x011C, 0x009C, 0xFFF7, 0xFF2F, 0xFE66, 0xFDC2, 0xFD43, 
	0xFCE8, 0xFCB1, 0xFC9F, 0xFC9F, 0xFC9F, 0xFC9F, 0xFC9F, 0xFC9F, 0xFC9F, 
	0xFC9F, 0xFC9F, 0xFC9F, 0xFC9F, 0xFC98, 0xFC77, 0xFBCB, 0xF8BF, 0xF6E7, 
	0xF5CD, 0xF56E, 0xF60A, 0xF7C0, 0xFA38, 0xFCF5, 0xFF6D, 0x0124, 0x01C0, 
	0x1192, 0x1178, 0x1128, 0x10A4, 0x0FEB, 0x0EFD, 0x0DDA, 0x0CB7, 0x0BC9, 
	0x0B0F, 0x0A8B, 0x0A3C, 0x0A21, 0x0A21, 0x0A21, 0x0A21, 0x0A21, 0x0A21, 
	0x0A21, 0x0A21, 0x0A21, 0x0A21, 0x0A21, 0x0A48, 0x0AEE, 0x0D28, 0x102E, 
	0x0F24, 0x0E84, 0x0E4E, 0x0E78, 0x0EEC, 0x0F93, 0x104D, 0x10F5, 0x1169, 
	0x1192, 0x842B, 0x84B8, 0x865C, 0x891A, 0x8CF0, 0x91DF, 0x97E6, 0x9DED, 
	0xA2DC, 0xA6B2, 0xA96F, 0xAB14, 0xABA0, 0xAAF9, 0xA989, 0xA819, 0xA771, 
	0xA7C1, 0xA887, 0xA989, 0xAA8B, 0xAB51, 0xABA0, 0xA3BB, 0x9176, 0x7CEE, 
	0x6E43, 0x693E, 0x663C, 0x653B, 0x66C3, 0x6B0E, 0x7142, 0x7824, 0x7E58, 
	0x82A3, 0x842B, 0xFFFF, 0xFFCC, 0xFF33, 0xFE34, 0xFCCE, 0xFB03, 0xF8D1, 
	0xF6A0, 0xF4D4, 0xF36F, 0xF270, 0xF1D6, 0xF1A3, 0xF180, 0xF127, 0xF0C0, 
	0xF08C, 0xF0A4, 0xF0E0, 0xF128, 0xF168, 0xF194, 0xF1A3, 0xF200, 0xF38A, 
	0xF8D1, 0xFFFF, 0x0000, 0xFFDA, 0xFF6A, 0xFEB0, 0xFDAB, 0xFC5C, 0xFAC2, 
	0xF928, 0xF7D9, 0xF6D4, 0xF619, 0xF5AA, 0xF584, 0xF5A5, 0xF5F6, 0xF653, 
	0xF682, 0xF66C, 0xF637, 0xF5F5, 0xF5BA, 0xF592, 0xF584, 0xF5C8, 0xF6E8, 
	0xFAC2, 0x0000, 0x4A21, 0x49AA, 0x4846, 0x45F4, 0x42B4, 0x3E87, 0x396C, 
	0x3451, 0x3023, 0x2CE4, 0x2A92, 0x292D, 0x28B6, 0x299A, 0x2B8D, 0x2D81, 
	0x2E65, 0x2DF9, 0x2CEC, 0x2B8D, 0x2A2F, 0x2922, 0x28B6, 0x2F29, 0x3E3F, 
	0x4F97, 0x5CCE, 0x61D1, 0x64D3, 0x65D4, 0x6474, 0x609D, 0x5B0F, 0x54E5, 
	0x4F58, 0x4B80, 0x4A21, 0x09D3, 0x09F3, 0x0A56, 0x0AFA, 0x0BE0, 0x0D07, 
	0x0E70, 0x0FDA, 0x1101, 0x11E7, 0x128B, 0x12ED, 0x130E, 0x12FA, 0x12B9, 
	0x1251, 0x11FD, 0x122C, 0x1290, 0x12D3, 0x12F8, 0x1309, 0x130E, 0x12D4, 
	0x11DB, 0x0E87, 0x09F9, 0x09F6, 0x09F4, 0x09F3, 0x09F1, 0x09ED, 0x09E6, 
	0x09DF, 0x09D9, 0x09D4, 0x09D3, 0xFE32, 0xFE31, 0xFE2D, 0xFE27, 0xFE1E, 
	0xFE12, 0xFE04, 0xFDF6, 0xFDEA, 0xFDE1, 0xFDDB, 0xFDD7, 0xFDD6, 0xFDED, 
	0xFE36, 0xFEAB, 0xFF09, 0xFED5, 0xFE64, 0xFE19, 0xFDEF, 0xFDDC, 0xFDD6, 
	0xFDE1, 0xFE11, 0xFEB4, 0xFF91, 0xFF57, 0xFF35, 0xFF29, 0xFF1D, 0xFEFB, 
	0xFEC9, 0xFE92, 0xFE61, 0xFE3F, 0xFE32, 0xABC3, 0xACBA, 0xAFA2, 0xB479, 
	0xBB41, 0xC3F7, 0xCE9E, 0xD944, 0xE1FB, 0xE8C2, 0xED9A, 0xF081, 0xF179, 
	0xF035, 0xED6C, 0xEAA3, 0xE95F, 0xE9F9, 0xEB79, 0xED6C, 0xEF5F, 0xF0DF, 
	0xF179, 0xE5B8, 0xCBDB, 0xB1FE, 0xA63D, 0xA724, 0xA7AF, 0xA7DD, 0xA80F, 
	0xA899, 0xA961, 0xAA3F, 0xAB07, 0xAB91, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0025, 0x0001, 0x0024, 0x0026, 0x001B, 0x004A, 0x001B, 
	0x0065, 0x001B, 0x0080, 0x000B, 0x009B, 0x0023, 0x00A6, 0x0025, 0x00C9, 
	0x0018, 0x00EE, 0x0017, 0x0106, 0x0025, 0x011D, 0x0026, 0x0142, 0x0026, 
	0x0168, 0x0026, 0x018E, 0x0001, 0x01B4, 0x0001, 0x01B5, 0x0001, 0x01B6, 
	0x0025, 0x01B7, 0x0025, 0x01DC, 0x0025, 0x0201, 0x0025, 0x0226, 0x0025, 
	0x024B, 0x0025, 0x0270, 0x0025, 0x0295, 0x0025, 0x02BA, 0x0025, 0x02DF, 
	0x0001, 0x0304, 0x0001, 0x0305, 0x0001, 0x0306, 0x0025, 0x0307, 0x0025, 
	0x032C, 0x0024, 0x0351, 0x001B, 0x0375, 0x0024, 0x0390, 0x0025, 0x03B4, 
	0x0025, 0x03D9, 0x0025, 0x03FE, 0x0025, 0x0423, 0x0025, 0x0448, 0x001B, 
	0x046D, 0x0001, 0x0488, 0x0025, 0x0489, 0x0025, 0x04AE, 0x0025, 0x04D3, 
	0x001B, 0x04F8, 0x001B, 0x0513, 0x0025, 0x052E, 0x0025, 0x0553, 0x0025, 
	0x0578, 0x0025, 0x059D, 0x0024, 0x05C2, 0x001B, 0x05E6, 0x0001, 0x0601, 
	0x0025, 0x0602, 0x0025, 0x0627, 0x0025, 0x064C, 0x001B, 0x0671, 0x001B, 
	0x068C, 0x0025, 0x06A7, 0x0025, 0x06CC, 0x0025, 0x06F1, 0x0025, 0x0716, 
	

});

smlua_anim_util_register_animation('donkey_5A_slow_land_from_dive',1, 0, 0, 0, 37, { 
	0x0000, 0x0052, 0x0052, 0x0054, 0x0056, 0x0059, 0x005D, 0x0061, 0x0065, 
	0x006A, 0x006E, 0x0073, 0x0078, 0x007C, 0x0080, 0x0084, 0x0087, 0x0089, 
	0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0003, 0x0005, 0x0009, 0x000E, 0x0014, 0x001D, 0x0028, 0x0035, 
	0x0045, 0x0057, 0x006D, 0x0086, 0x00A3, 0x00C3, 0x00E8, 0x0444, 0x0755, 
	0x04AA, 0x015E, 0x008D, 0x0022, 0xFFFD, 0xFFFC, 0x0000, 0xFFFB, 0xFF49, 
	0xFF51, 0xFF65, 0xFF82, 0xFFA4, 0xFFC5, 0xFFE2, 0xFFF7, 0xFFFE, 0x7F62, 
	0x7F01, 0x7DEE, 0x7C38, 0x79F4, 0x7734, 0x740A, 0x7088, 0x6CC1, 0x68C8, 
	0x64AF, 0x6089, 0x5C67, 0x585D, 0x547D, 0x50DA, 0x4D85, 0x4A92, 0x4813, 
	0x462A, 0x44EB, 0x43EF, 0x43D6, 0x44F7, 0x469B, 0x484B, 0x4990, 0x49F2, 
	0x4983, 0x48B4, 0x494B, 0x4ADA, 0x4D0E, 0x4F94, 0x521B, 0x544F, 0x55DE, 
	0x5675, 0x0000, 0xFFE1, 0xFF8D, 0xFF0A, 0xFE5D, 0xFD8E, 0xFCA4, 0xFBA5, 
	0xFA99, 0xF986, 0xF873, 0xF767, 0xF668, 0xF57E, 0xF4AF, 0xF403, 0xF37F, 
	0xF32B, 0xF30D, 0xEE7B, 0xEC6E, 0xEBFD, 0xECE1, 0xEF52, 0xF23C, 0xF562, 
	0xF887, 0xFB6F, 0xFDDC, 0xFF92, 0xFF97, 0xFFA3, 0xFFB4, 0xFFC9, 0xFFDD, 
	0xFFEE, 0xFFFA, 0x0000, 0x0000, 0x0001, 0x0003, 0x0006, 0x000A, 0x000F, 
	0x0015, 0x001B, 0x0022, 0x0028, 0x002F, 0x0036, 0x003C, 0x0042, 0x0047, 
	0x004B, 0x004E, 0x0050, 0x0051, 0xFFFF, 0xFD2F, 0x00A4, 0x03BE, 0x0414, 
	0x0410, 0x03CB, 0x035D, 0x02DE, 0x0266, 0x020F, 0x01BA, 0x0161, 0x0109, 
	0x00B6, 0x006E, 0x0034, 0x000E, 0x0000, 0xE6A8, 0xE729, 0xE897, 0xEAD6, 
	0xEDC9, 0xF151, 0xF552, 0xF9AF, 0xFE49, 0x0306, 0x07C5, 0x0C6A, 0x10D9, 
	0x14F3, 0x189C, 0x1BB6, 0x1E24, 0x1FC9, 0x2087, 0x212F, 0x2534, 0x2661, 
	0x25EC, 0x2408, 0x21D4, 0x1F6B, 0x1CEB, 0x1A6E, 0x1813, 0x15F5, 0x1375, 
	0x1094, 0x0D89, 0x0A8E, 0x07DA, 0x05A6, 0x042A, 0x039F, 0x01B4, 0x01D4, 
	0x0241, 0x0309, 0x0422, 0x057D, 0x070A, 0x08BA, 0x0A7E, 0x0C46, 0x0E03, 
	0x0FA6, 0x111F, 0x125F, 0x1357, 0x13F7, 0x142F, 0x12AA, 0x0E5D, 0x07C8, 
	0xFFE7, 0xF7D8, 0xF0B8, 0xEBA0, 0xE9AF, 0xF0A8, 0xFFFE, 0x0F56, 0x164F, 
	0x0FDF, 0x01B7, 0xF38E, 0xED1F, 0xEF15, 0xF3C4, 0xF95A, 0xFE08, 0x0000, 
	0x0165, 0x0151, 0x0126, 0x00FD, 0x00D8, 0x00B9, 0x009F, 0x0088, 0x0075, 
	0x0066, 0x005A, 0x0051, 0x004A, 0x0045, 0x0042, 0x0040, 0x003F, 0x003F, 
	0x003F, 0x009E, 0x018C, 0x02C0, 0x03F5, 0x04E3, 0x0542, 0x02C3, 0xFD46, 
	0xF7CA, 0xF54C, 0xF7BE, 0xFD21, 0x0285, 0x04F7, 0x0473, 0x0338, 0x01BF, 
	0x0084, 0x0000, 0xD8CA, 0xDA59, 0xDD2A, 0xDF82, 0xE184, 0xE336, 0xE4A1, 
	0xE5C9, 0xE6B6, 0xE76E, 0xE7F9, 0xE85C, 0xE89F, 0xE8C8, 0xE8DF, 0xE8E9, 
	0xE8ED, 0xE8F1, 0xE8F3, 0xE312, 0xE3E4, 0xE600, 0xE8E4, 0xEC0D, 0xEEF6, 
	0xF13B, 0xF2EE, 0xF43D, 0xF559, 0xF664, 0xF74C, 0xF7EF, 0xF82C, 0xF722, 
	0xF4A8, 0xF1B3, 0xEF39, 0xEE2F, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x004C, 0x00E2, 0x0153, 
	0x012D, 0x0001, 0xF839, 0xF32C, 0xF842, 0xFF94, 0x0817, 0x10B1, 0x1857, 
	0x1DF7, 0x2081, 0x2080, 0x1F59, 0x1D3F, 0x1A65, 0x16FE, 0x133D, 0x0F57, 
	0x0B7D, 0x07E3, 0x04BD, 0x023E, 0x0099, 0x0001, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x0038, 
	0x00A5, 0x00F7, 0x00DB, 0xFFFE, 0xFBAD, 0xF6AD, 0xF3CF, 0xF0C5, 0xEDCE, 
	0xEB2B, 0xE91C, 0xE7E0, 0xE7B8, 0xE886, 0xE9EF, 0xEBD4, 0xEE17, 0xF09C, 
	0xF344, 0xF5F2, 0xF888, 0xFAE8, 0xFCF5, 0xFE91, 0xFF9D, 0xFFFE, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC148, 0xC0F7, 0xC0BB, 0xC0CF, 0xC170, 0xC591, 0xC84A, 0xC5AF, 
	0xC1EA, 0xBD88, 0xB917, 0xB522, 0xB238, 0xB0E5, 0xB0E2, 0xB176, 0xB286, 
	0xB3F9, 0xB5B5, 0xB79E, 0xB99C, 0xBB93, 0xBD69, 0xBF05, 0xC04B, 0xC122, 
	0xC170, 0x22E6, 0x2664, 0x2EB8, 0x38A8, 0xC0FC, 0xC47A, 0xBE1D, 0xAE00, 
	0x989B, 0x0263, 0xEFCF, 0xE556, 0xE1A0, 0xDFD9, 0xDF44, 0xDF1E, 0xDEAA, 
	0xDD27, 0xD9D5, 0xD423, 0xCC3D, 0xC27C, 0xB73B, 0xAB68, 0xA244, 0x9E61, 
	0x9D3C, 0x9B0F, 0x1414, 0x0F30, 0x1551, 0xA578, 0xBC4F, 0xD67D, 0xF0AC, 
	0x0784, 0x17AB, 0x1DCC, 0xDDA9, 0xDC8E, 0xD9B1, 0xD5C3, 0xAE88, 0xB285, 
	0xB5A2, 0xB7E1, 0xB963, 0xC5B2, 0xC540, 0xC522, 0xC5D3, 0xC7B9, 0xCA8D, 
	0xCE09, 0xD1EA, 0xD5E7, 0xD9BD, 0xDD3E, 0xE0A7, 0xE44B, 0xE881, 0xED05, 
	0xEF3D, 0xE8EA, 0xDB02, 0xCD19, 0xB938, 0xBD53, 0xB5F4, 0xCF95, 0xD38D, 
	0xD636, 0xD7D4, 0xD8A8, 0xD8F6, 0xD901, 0x6D00, 0x6A6F, 0x644F, 0x5D00, 
	0xD6E0, 0xD44F, 0xDAB3, 0xEB83, 0x0331, 0x9E2F, 0xB8F0, 0xCFE8, 0xE118, 
	0xED68, 0xF5A9, 0xFAAB, 0xFD3D, 0xFE2F, 0xFE52, 0xFB74, 0xF526, 0xEED8, 
	0xEBFB, 0xF7FF, 0x0D30, 0x19E4, 0x1EF7, 0x21E5, 0xA829, 0xB025, 0xAB00, 
	0x1D70, 0x0A43, 0xF446, 0xDE4A, 0xCB1C, 0xBD8C, 0xB867, 0xFFFF, 0x015F, 
	0x04A5, 0x088C, 0x0BD2, 0x0D31, 0x0D2F, 0x0D25, 0x0D07, 0x0CCF, 0x0C71, 
	0x0BE5, 0x0B22, 0x0A1E, 0x08D0, 0x0730, 0x0533, 0x02D1, 0x0000, 0xFD3C, 
	0xFD50, 0xFD85, 0xFDD5, 0xFE35, 0xFE9D, 0xFF06, 0xFF66, 0xFFB5, 0xFFEB, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x036F, 0x0B9D, 0x1562, 0x1D91, 0x20FF, 0x20FB, 0x20E1, 0x2097, 0x2009, 
	0x1F1F, 0x1DC1, 0x1BD8, 0x194F, 0x160C, 0x11FA, 0x0D02, 0x070B, 0x0000, 
	0xF0D6, 0xF143, 0xF26A, 0xF41C, 0xF62C, 0xF86A, 0xFAA9, 0xFCB9, 0xFE6B, 
	0xFF92, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xF3AE, 0xF26F, 
	0xEF23, 0xEA71, 0xE501, 0xDF7B, 0xDA69, 0xD5E3, 0xD1E3, 0xCE61, 0xCB59, 
	0xC8C3, 0xC699, 0xC4D6, 0xC372, 0xC269, 0xC1B3, 0xC14A, 0xC128, 0xD08E, 
	0xD08D, 0xD08B, 0xD089, 0xD087, 0xD085, 0xD074, 0xD004, 0xCED2, 0xCC7F, 
	0xCBE1, 0xCB3E, 0xCAC4, 0xCA6C, 0xCA31, 0xCA0E, 0xC9FC, 0xC9F5, 0xC9F4, 
	0xD8BF, 0xD8B8, 0xD8A6, 0xD890, 0xD87E, 0xD876, 0xD966, 0xDC02, 0xDFFD, 
	0xE507, 0xEAD4, 0xF116, 0xF77F, 0xFDC1, 0x038F, 0x089A, 0x0C94, 0x0F30, 
	0x1020, 0x0F77, 0x0D30, 0x0AED, 0x08C8, 0x06DC, 0x0543, 0x03B5, 0x01EB, 
	0xFFFE, 0xFE08, 0xFC21, 0xFC9A, 0xFDD8, 0xFF9A, 0x019F, 0x03A3, 0x0565, 
	0x06A3, 0x071C, 0xFA43, 0xF5B1, 0xEACA, 0xDDC7, 0xD2E0, 0xCE4D, 0xCE68, 
	0xCEC4, 0xCF74, 0xD08B, 0xD21A, 0xD436, 0xD6F0, 0xDA5C, 0xDE8B, 0xE390, 
	0xE97E, 0xF068, 0xF860, 0xFEC0, 0xFF42, 0xFFA9, 0xFFED, 0x0007, 0xFFEE, 
	0xFF79, 0xFE99, 0xFD68, 0xFC05, 0xFA8B, 0xFAE8, 0xFBDE, 0xFD3A, 0xFEC8, 
	0x0057, 0x01B3, 0x02A8, 0x0306, 0xF4F6, 0xF82D, 0xFFD7, 0x08FF, 0x10A9, 
	0x13E0, 0x13DC, 0x13C2, 0x137B, 0x12F1, 0x120C, 0x10B8, 0x0EDD, 0x0C65, 
	0x0939, 0x0543, 0x006D, 0xFA9F, 0xF3C5, 0xE623, 0xE5C5, 0xE591, 0xE591, 
	0xE5CA, 0xE645, 0xE759, 0xE936, 0xEBA0, 0xEE5F, 0xF138, 0xF24F, 0xF52E, 
	0xF93C, 0xFDE3, 0x028B, 0x069A, 0x0979, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 0xC170, 
	0xC170, 0xC15E, 0xC13A, 0xC11F, 0xC128, 0xC170, 0xC1F9, 0xC2AB, 0xC378, 
	0xC452, 0xC52E, 0xC5FD, 0xC6B2, 0xC73F, 0xC799, 0xC79F, 0xC74E, 0xC6C3, 
	0xC61A, 0xC56F, 0xC4DF, 0xC455, 0xC3B5, 0xC30E, 0xC271, 0xC1EC, 0xC192, 
	0xC170, 0x3DB9, 0x3DE0, 0x3E4D, 0x3EF7, 0x3FD7, 0x40E3, 0x4212, 0x435C, 
	0x44B8, 0x461C, 0x4780, 0x48DC, 0x4A26, 0x4B55, 0xCC60, 0xCD40, 0xCDEB, 
	0xCE58, 0xCE7E, 0xCC30, 0x4C75, 0x4D44, 0x4EA2, 0x5093, 0x531A, 0xD626, 
	0xD956, 0xDC30, 0xDE3E, 0xDF08, 0xDD4E, 0xD8C1, 0xD251, 0xCAF1, 0x4391, 
	0x3D21, 0x3894, 0x36DA, 0x647A, 0x6477, 0x646D, 0x645B, 0x6440, 0x641D, 
	0x63EF, 0x63B5, 0x6370, 0x631E, 0x62BE, 0x6250, 0x61D2, 0x6144, 0x1F5B, 
	0x200C, 0x20D0, 0x21A8, 0x2294, 0x2412, 0x5828, 0x52C8, 0x4D36, 0x48D7, 
	0x4713, 0x3689, 0x30D4, 0x2A05, 0x2451, 0x21ED, 0x2251, 0x2359, 0x24CF, 
	0x267B, 0x57D8, 0x5662, 0x555A, 0x54F5, 0xE3C1, 0xE442, 0xE5B2, 0xE7F3, 
	0xEAE6, 0xEE6F, 0xF26F, 0xF6C9, 0xFB5F, 0x0013, 0x04C6, 0x095B, 0x0DB5, 
	0x11B5, 0x953E, 0x9831, 0x9A72, 0x9BE2, 0x9C63, 0x9AAB, 0x1B00, 0x1BF0, 
	0x1D68, 0x1F55, 0x21A2, 0xA432, 0xA6BF, 0xA8F6, 0xAA86, 0xAB1D, 0xAA44, 
	0xA807, 0xA4DD, 0xA13D, 0x1D9C, 0x1A72, 0x1835, 0x175C, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xE52C, 0xE52B, 0xE525, 0xE515, 0xE4F5, 0xE4C0, 0xE471, 0xE402, 0xE36F, 
	0xE2B3, 0xE1C8, 0xE0A8, 0xDF4F, 0xDDB8, 0xDBDD, 0xD9B9, 0xD747, 0xD481, 
	0xD163, 0xC8CD, 0xC7D8, 0xC744, 0xC6F7, 0xC6DB, 0xC6D7, 0xC7CF, 0xCA1E, 
	0xCCE0, 0xCF2F, 0xD027, 0xCFF3, 0xCF68, 0xCEA4, 0xCDC4, 0xCCE3, 0xCC1F, 
	0xCB94, 0xCB60, 0x408F, 0x3DC0, 0x3685, 0x2CA3, 0x21E4, 0x180F, 0x1036, 
	0x0A1A, 0x0583, 0x0239, 0x0004, 0xFEAD, 0xFDFD, 0xFDBC, 0xFDB3, 0xFF81, 
	0x037B, 0x0775, 0x0943, 0xF71E, 0xF72E, 0xF755, 0xF784, 0xF7AB, 0xF7BB, 
	0xF631, 0xF284, 0xEE20, 0xEA73, 0xE8E8, 0xE9A7, 0xEB9E, 0xEE65, 0xF195, 
	0xF4C4, 0xF78C, 0xF983, 0xFA42, 0x122C, 0x12DE, 0x14B5, 0x1751, 0x1A54, 
	0x1D5E, 0x2020, 0x228B, 0x24A0, 0x2660, 0x27CD, 0x28E6, 0x29AE, 0x2A25, 
	0x2A4D, 0x27EC, 0x229A, 0x1D10, 0x1A09, 0x19BF, 0x1990, 0x1916, 0x183E, 
	0x16F7, 0x152F, 0x12E0, 0x1034, 0x0D64, 0x0AA7, 0x0832, 0x0632, 0x04A4, 
	0x037B, 0x02A7, 0x021B, 0x01C8, 0x01A1, 0x0197, 0x143B, 0x1416, 0x1379, 
	0x1223, 0x0FD0, 0x0C3E, 0x0747, 0x013F, 0xFA95, 0xF3BD, 0xED26, 0xE741, 
	0xE280, 0xDF53, 0xDE2B, 0xDF8E, 0xE29A, 0xE5A7, 0xE70A, 0xDC81, 0xDE35, 
	0xE243, 0xE71B, 0xEB29, 0xECDD, 0xEB23, 0xE707, 0xE21F, 0xDE03, 0xDC4A, 
	0xDE16, 0xE2D4, 0xE988, 0xF137, 0xF8E6, 0xFF99, 0x0458, 0x0624, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E1, 0xC5DD, 0xC5DA, 0xC5DB, 0xC5E3, 
	0xC5F7, 0xC615, 0xC636, 0xC650, 0xC647, 0xC62B, 0xC61A, 0xC5E3, 0xC56D, 
	0xC4E6, 0xC454, 0xC3BA, 0xC31B, 0xC27D, 0xC1E2, 0xC14F, 0xC0C8, 0xC050, 
	0xBFEC, 0xBFA0, 0xBF6F, 0xBF5E, 0xF96A, 0xF96B, 0xF970, 0xF97F, 0xF99B, 
	0xF9C9, 0xFA0F, 0xFA70, 0xFAF0, 0xFB96, 0xFC64, 0xFD61, 0xFE8F, 0xFFF5, 
	0x0197, 0x0378, 0x059E, 0x080C, 0x0AC9, 0x0EF4, 0x040A, 0xFCB2, 0x01A8, 
	0x0538, 0x0277, 0xFF18, 0xFB3B, 0xF704, 0xF293, 0xEE0B, 0xEEC1, 0xF0A2, 
	0xF349, 0xF653, 0xF95D, 0xFC05, 0xFDE5, 0xFE9B, 0xF580, 0xF56E, 0xF538, 
	0xF4E3, 0xF471, 0xF3E6, 0xF343, 0xF28C, 0xF1C5, 0xF0F0, 0xF00F, 0xEF27, 
	0xEE3A, 0xED4B, 0xEC5E, 0xEB74, 0xEA91, 0xE9B9, 0xE8ED, 0xE86D, 0xE903, 
	0xEAE1, 0xEAB5, 0xEA5A, 0xEA74, 0xEA95, 0xEABC, 0xEAE7, 0xEB15, 0xEB44, 
	0xEB78, 0xEC00, 0xECC1, 0xED9F, 0xEE7C, 0xEF3D, 0xEFC5, 0xEFF9, 0xA41F, 
	0xA41A, 0xA409, 0xA3E8, 0xA3B3, 0xA366, 0xA2FE, 0xA277, 0xA1CD, 0xA0FD, 
	0xA002, 0x9EDA, 0x9D80, 0x9BF1, 0x9A28, 0x9823, 0x95DD, 0x9353, 0x9080, 
	0x8E79, 0x97A3, 0x9638, 0x8AA2, 0x8366, 0x85D3, 0x8911, 0x8CF7, 0x915C, 
	0x9618, 0x9B02, 0x934A, 0x8D7C, 0x8954, 0x868B, 0x84DA, 0x83FC, 0x83AA, 
	0x839E, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x45A0, 0x45DE, 
	0x468F, 0x47A8, 0x491A, 0x4ADA, 0x4CDB, 0x4F0F, 0x516B, 0x53E1, 0x5665, 
	0x58EB, 0x5B64, 0x5DC5, 0x6002, 0x620C, 0x63D8, 0x6559, 0x6682, 0x6717, 
	0x5C47, 0x65A9, 0x62E4, 0x5DD8, 0x598C, 0x54CA, 0x4FB3, 0x4A66, 0x4503, 
	0x3FAA, 0x401B, 0x4144, 0x42E9, 0x44CC, 0x46AE, 0x4853, 0x497D, 0x49EE, 
	0x0000, 0xFFE2, 0xFF90, 0xFF10, 0xFE67, 0xFD9D, 0xFCB9, 0xFBC1, 0xFABB, 
	0xF9AF, 0xF8A2, 0xF79D, 0xF6A4, 0xF5C0, 0xF4F6, 0xF44E, 0xF3CD, 0xF37B, 
	0xF35E, 0xED0D, 0xFD5B, 0x0CDF, 0x0365, 0xF5AC, 0xF9E3, 0xF9EF, 0xF93C, 
	0xF909, 0xF99C, 0xFA5C, 0xF979, 0xF8CF, 0xF855, 0xF803, 0xF7D2, 0xF7B8, 
	0xF7AF, 0xF7AE, 0xFFFF, 0xFFEF, 0xFFC3, 0xFF7D, 0xFF21, 0xFEB4, 0xFE38, 
	0xFDB1, 0xFD22, 0xFC91, 0xFBFF, 0xFB71, 0xFAEA, 0xFA6D, 0xFA00, 0xF9A4, 
	0xF95E, 0xF932, 0xF922, 0xEBAA, 0xEB5E, 0xF0FA, 0xFAE9, 0x0570, 0x07DD, 
	0x06CE, 0x051E, 0x03E8, 0x034F, 0x02BA, 0x02C5, 0x02E4, 0x030F, 0x0340, 
	0x0371, 0x039C, 0x03BA, 0x03C6, 0xD708, 0xD70C, 0xD716, 0xD727, 0xD73C, 
	0xD756, 0xD773, 0xD793, 0xD7B5, 0xD7D7, 0xD7FA, 0xD81B, 0xD83B, 0xD858, 
	0xD872, 0xD887, 0xD898, 0xD8A2, 0xD8A6, 0xCF3D, 0xB500, 0x9D6B, 0x9DCB, 
	0xA4DA, 0xA5B7, 0xA6FA, 0xA856, 0xAA0A, 0xAC3A, 0xAEC3, 0xADB6, 0xACEB, 
	0xAC5A, 0xABF8, 0xABBD, 0xAB9F, 0xAB94, 0xAB92, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF5E, 0x03AC, 0x0385, 0x0316, 0x0268, 0x0185, 0x0074, 0xFF3E, 
	0xFDEF, 0xFC8D, 0xFB23, 0xF9B8, 0xF856, 0xF707, 0xF5D2, 0xF4C1, 0xF3DE, 
	0xF330, 0xF2C1, 0xF29A, 0xF1CB, 0xF157, 0xF15C, 0xF1FA, 0xF3AE, 0xF690, 
	0xFA23, 0xFDE9, 0x0167, 0x04DD, 0x086F, 0x0825, 0x0764, 0x0652, 0x0517, 
	0x03DD, 0x02CB, 0x0209, 0x01C0, 0x057F, 0x05B6, 0x0654, 0x074C, 0x0890, 
	0x0A14, 0x0BCB, 0x0DA9, 0x0FA0, 0x11A4, 0x13A9, 0x15A0, 0x177E, 0x1935, 
	0x1AB9, 0x1BFD, 0x1CF5, 0x1D92, 0x1DCA, 0x1A30, 0x169E, 0x1382, 0x1146, 
	0x102D, 0x0FEF, 0x1031, 0x1093, 0x10B8, 0x109C, 0x1083, 0x108F, 0x10AD, 
	0x10D9, 0x110B, 0x113C, 0x1168, 0x1187, 0x1192, 0xBF8A, 0xBF35, 0xBE3F, 
	0xBCB6, 0xBAA8, 0xB823, 0xB536, 0xB1ED, 0xAE58, 0xAA84, 0xA67F, 0xA257, 
	0x9E1B, 0x99D8, 0x959C, 0x9175, 0x8D72, 0x89A1, 0x860E, 0x82CE, 0x800E, 
	0x7E1F, 0x7D5E, 0x7E8A, 0x81A6, 0x85E7, 0x8A82, 0x8EAF, 0x92DA, 0x9747, 
	0x90F9, 0x8C3B, 0x88D6, 0x868F, 0x852D, 0x8478, 0x8435, 0x842B, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x3388, 0x33E7, 0x34F7, 0x36A0, 0x38CD, 0x3B69, 
	0x3E5C, 0x4192, 0x44F3, 0x486B, 0x4BE2, 0x4F44, 0x5279, 0x556D, 0x5808, 
	0x5A36, 0x5BDF, 0x5CEE, 0x5D4E, 0x5B19, 0x588A, 0x55E4, 0x536A, 0x50E7, 
	0x4E03, 0x4ACB, 0x474A, 0x438C, 0x3ECF, 0x3953, 0x3A0C, 0x3BF3, 0x3EA4, 
	0x41BA, 0x44D0, 0x4781, 0x4968, 0x4A21, 0xFFFF, 0x0001, 0x0005, 0x0012, 
	0x002A, 0x0052, 0x008E, 0x00E2, 0x0151, 0x01E0, 0x0292, 0x036C, 0x0471, 
	0x05A6, 0x070E, 0x08AE, 0x0A88, 0x0CA2, 0x0EFF, 0x12B9, 0x0A91, 0x0BC4, 
	0x0D8E, 0x0CB5, 0x0B60, 0x09CD, 0x0835, 0x06D4, 0x05B8, 0x04C7, 0x04FE, 
	0x0591, 0x0660, 0x074D, 0x083A, 0x0909, 0x099B, 0x09D3, 0xFFFF, 0x0000, 
	0x0001, 0x0002, 0x0005, 0x000A, 0x0010, 0x001A, 0x0027, 0x0038, 0x004C, 
	0x0066, 0x0084, 0x00A8, 0x00D1, 0x0102, 0x0139, 0x0177, 0x01BD, 0xFDCF, 
	0xFDE1, 0xFD1D, 0xFCA4, 0xFCF7, 0xFD80, 0xFE20, 0xFEB8, 0xFF2A, 0xFF59, 
	0xFF56, 0xFEF6, 0xFEAD, 0xFE7A, 0xFE57, 0xFE42, 0xFE37, 0xFE33, 0xFE32, 
	0xC595, 0xC594, 0xC58E, 0xC57D, 0xC55C, 0xC525, 0xC4D4, 0xC462, 0xC3CA, 
	0xC308, 0xC215, 0xC0EC, 0xBF89, 0xBDE4, 0xBBFA, 0xB9C4, 0xB73E, 0xB462, 
	0xB12A, 0xADF4, 0xAEB8, 0xB5E3, 0xBB4B, 0xBB3B, 0xB9C1, 0xB7B3, 0xB5E7, 
	0xB534, 0xB6A4, 0xB992, 0xB503, 0xB196, 0xAF22, 0xAD7D, 0xAC7D, 0xABFA, 
	0xABCA, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0012, 0x0001, 0x0001, 0x0013, 0x0001, 0x0014, 0x0001, 
	0x0015, 0x0001, 0x0016, 0x0001, 0x0017, 0x0026, 0x0018, 0x0026, 0x003E, 
	0x0026, 0x0064, 0x0026, 0x008A, 0x0026, 0x00B0, 0x0026, 0x00D6, 0x0026, 
	0x00FC, 0x0026, 0x0122, 0x0026, 0x0148, 0x0026, 0x016E, 0x0026, 0x0194, 
	0x0026, 0x01BA, 0x0026, 0x01E0, 0x0026, 0x0206, 0x0025, 0x022C, 0x0023, 
	0x0251, 0x0026, 0x0274, 0x0026, 0x029A, 0x0026, 0x02C0, 0x0026, 0x02E6, 
	0x0001, 0x030C, 0x0001, 0x030D, 0x0026, 0x030E, 0x0026, 0x0334, 0x0026, 
	0x035A, 0x0026, 0x0380, 0x0026, 0x03A6, 0x0024, 0x03CC, 0x0026, 0x03F0, 
	0x0026, 0x0416, 0x0026, 0x043C, 0x0026, 0x0462, 0x0026, 0x0488, 0x0025, 
	0x04AE, 0x0026, 0x04D3, 0x0026, 0x04F9, 0x0026, 0x051F, 0x0026, 0x0545, 
	0x001F, 0x056B, 0x0026, 0x058A, 0x0026, 0x05B0, 0x0026, 0x05D6, 0x0026, 
	0x05FC, 0x0026, 0x0622, 0x0026, 0x0648, 0x0026, 0x066E, 0x0001, 0x0694, 
	0x0026, 0x0695, 0x0026, 0x06BB, 0x0026, 0x06E1, 0x000E, 0x0707, 0x0023, 
	0x0715, 0x0026, 0x0738, 0x0026, 0x075E, 0x0026, 0x0784, 0x0026, 0x07AA, 
	

});

smlua_anim_util_register_animation('donkey_5E_missing_cap',1, 0, 0, 0, 154, { 
	0x0000, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 
	0x0012, 0x0012, 0x0000, 0xFFD4, 0xFFA2, 0xFF6C, 0xFF32, 0xFEF4, 0xFEB4, 
	0xFE71, 0xFE2E, 0xFDE9, 0xFDA5, 0xFD62, 0xFD20, 0xFCE0, 0xFCA3, 0xFC69, 
	0xFC34, 0xFC04, 0xFBD9, 0xFBB4, 0xFB97, 0xFB81, 0xFB74, 0xFB6F, 0xFB74, 
	0xFB84, 0xFB9D, 0xFBBC, 0xFBE2, 0xFC0F, 0xFC43, 0xFC7C, 0xFCBD, 0xFD03, 
	0xFD51, 0xFDA4, 0xFDFD, 0xFE5D, 0xFEC3, 0xFF2E, 0xFFA0, 0x0017, 0x0094, 
	0x0117, 0x01A0, 0x022E, 0x02C2, 0x035B, 0x03F9, 0x04BE, 0x05C0, 0x06F3, 
	0x0848, 0x09B3, 0x0B24, 0x0C8F, 0x0DE6, 0x0F1B, 0x1021, 0x10EA, 0x1181, 
	0x11F7, 0x124C, 0x127B, 0x1284, 0x1262, 0x1214, 0x1198, 0x10EA, 0x1004, 
	0x0EE3, 0x0D89, 0x0BF7, 0x0A30, 0x0835, 0x0609, 0x03AE, 0x00DF, 0xFD7D, 
	0xF9C2, 0xF5E7, 0xF227, 0xEEBB, 0xEBDD, 0xE9C7, 0xE869, 0xE785, 0xE70F, 
	0xE6FD, 0xE745, 0xE7DB, 0xE8B4, 0xE9C7, 0xEB2E, 0xECFB, 0xEF17, 0xF16A, 
	0xF3DD, 0xF659, 0xF8C4, 0xFB09, 0xFD0F, 0xFEBE, 0x0000, 0x00D5, 0x015A, 
	0x019A, 0x01A2, 0x0180, 0x0140, 0x013D, 0x013A, 0x0138, 0x0136, 0x0134, 
	0x0132, 0x0131, 0x0130, 0x012F, 0x012F, 0x012E, 0x012E, 0x012E, 0x012E, 
	0x012E, 0x012E, 0x012E, 0x012E, 0x012E, 0x012D, 0x012D, 0x012D, 0x012C, 
	0x012C, 0x012B, 0x012A, 0x0129, 0x0127, 0x0126, 0x0124, 0x0121, 0x011E, 
	0x011B, 0x0000, 0x0000, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 
	0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFFD, 
	0xFFFE, 0x0000, 0xFFFF, 0x0005, 0x0014, 0x002A, 0x0047, 0x0068, 0x008D, 
	0x00B4, 0x00DC, 0x0104, 0x012A, 0x014E, 0x016C, 0x0186, 0x0198, 0x01A3, 
	0x01A4, 0x019A, 0x0184, 0x0160, 0x012E, 0x00EC, 0x0098, 0x0032, 0xFF8C, 
	0xFE86, 0xFD34, 0xFBA9, 0xF9FA, 0xF839, 0xF67B, 0xF4D3, 0xF354, 0xF213, 
	0xF124, 0xF070, 0xEFDA, 0xEF68, 0xEF21, 0xEF0B, 0xEF2D, 0xEF8E, 0xF033, 
	0xF124, 0xF29D, 0xF4B9, 0xF745, 0xFA0F, 0xFCE5, 0xFF96, 0x01EF, 0x03C0, 
	0x0511, 0x0617, 0x06DF, 0x0774, 0x07E5, 0x083C, 0x0888, 0x08D5, 0x0920, 
	0x095D, 0x0988, 0x099E, 0x099A, 0x097A, 0x0939, 0x08D5, 0x0847, 0x078F, 
	0x06B9, 0x05CC, 0x04D2, 0x03D6, 0x02E0, 0x01F9, 0x012B, 0x007F, 0x0000, 
	0xFFAB, 0xFF76, 0xFF5C, 0xFF59, 0xFF67, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 
	0xFF80, 0xFF80, 0xFF80, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7E, 0xFF7D, 0xFF7D, 
	0xFF7C, 0xFF7B, 0xFF7A, 0xFF78, 0xFF77, 0xFF75, 0xFF73, 0xFF71, 0xFF6F, 
	0xFF6C, 0xFF69, 0xFF66, 0xFF62, 0xFF5F, 0xFF5B, 0xFF57, 0xFF52, 0xFF4D, 
	0xFF48, 0xFF42, 0xFF3C, 0x0000, 0x039F, 0x03CB, 0x03AF, 0x0365, 0x02FA, 
	0x027A, 0x01F4, 0x0175, 0x0109, 0x00BF, 0x00A3, 0x00C6, 0x00B9, 0x00AC, 
	0x009F, 0x0091, 0x0083, 0x0075, 0x0066, 0x0058, 0x0049, 0x003A, 0x002B, 
	0x001C, 0x000D, 0xFFFE, 0xFFEF, 0xFFE1, 0xFFD2, 0xFFC4, 0xFFB6, 0xFFA9, 
	0xFF9C, 0xFF8F, 0xFF82, 0xFF77, 0xFF6B, 0xFF53, 0xFF21, 0xFEDA, 0xFE82, 
	0xFE1C, 0xFDAD, 0xFD37, 0xFCBF, 0xFC49, 0xFBD8, 0xFB70, 0xFB15, 0xFACA, 
	0xFA94, 0xFA76, 0xFA75, 0xFA92, 0xFAD4, 0xFB3C, 0xFBD0, 0xFC92, 0xFD88, 
	0xFEB3, 0x009B, 0x039D, 0x0780, 0x0C08, 0x10FD, 0x1625, 0x1B45, 0x2024, 
	0x2489, 0x2839, 0x2AFA, 0x2CD5, 0x2E08, 0x2EA7, 0x2EC8, 0x2E81, 0x2DE7, 
	0x2D0E, 0x2C0E, 0x2AFA, 0x295F, 0x26EF, 0x23FB, 0x20D4, 0x1DCA, 0x1B2E, 
	0x1950, 0x1882, 0x18F1, 0x1A66, 0x1C96, 0x1F35, 0x21F9, 0x2498, 0x26C6, 
	0x2838, 0x2932, 0x2A1A, 0x2AD4, 0x2B46, 0x2B57, 0x2AEC, 0x29EA, 0x2838, 
	0x25C7, 0x22B4, 0x1F21, 0x1B31, 0x1706, 0x12C3, 0x0E8A, 0x0A7F, 0x06C3, 
	0x037A, 0x00C6, 0xFE82, 0xFC72, 0xFA99, 0xF8F7, 0xF78E, 0xF661, 0xF668, 
	0xF67C, 0xF69B, 0xF6C7, 0xF6FC, 0xF73B, 0xF783, 0xF7D3, 0xF82A, 0xF888, 
	0xF8EB, 0xF952, 0xF9BD, 0xFA2B, 0xFA9B, 0xFB0D, 0xFB7F, 0xFBF0, 0xFC60, 
	0xFCCF, 0xFD3A, 0xFDA1, 0xFE04, 0xFE61, 0xFEB8, 0xFF08, 0xFF50, 0xFF90, 
	0xFFC5, 0xFFF0, 0x0011, 0x0025, 0x002C, 0x039F, 0x0000, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 
	0xFFF7, 0xFFE7, 0xFFD7, 0xFFC6, 0xFFB4, 0xFFA3, 0xFF99, 0xFFCE, 0x0050, 
	0x00E7, 0x015A, 0x016E, 0x00EC, 0xFF99, 0xFCE1, 0xF8C7, 0xF3F9, 0xEF25, 
	0xEAF8, 0xE820, 0xE6AD, 0xE583, 0xE49A, 0xE3F4, 0xE394, 0xE37E, 0xE3B3, 
	0xE438, 0xE50E, 0xE63A, 0xE7E2, 0xEB9B, 0xF111, 0xF746, 0xFD3A, 0x0210, 
	0x05EF, 0x0906, 0x0B6D, 0x0D3F, 0x0E96, 0x0F8B, 0x1038, 0x10B8, 0x1124, 
	0x1197, 0x122A, 0x12F7, 0x13CF, 0x1476, 0x14F3, 0x154B, 0x1587, 0x15AD, 
	0x15C4, 0x15D3, 0x15E0, 0x15F3, 0x1612, 0x165C, 0x16D5, 0x1762, 0x17E5, 
	0x1844, 0x1861, 0x1820, 0x1765, 0x1612, 0x13E5, 0x10D5, 0x0D24, 0x0912, 
	0x04DD, 0x00C7, 0xFD0F, 0xF9F6, 0xF757, 0xF4E6, 0xF2A6, 0xF09B, 0xEEC8, 
	0xED31, 0xEBD9, 0xEAC3, 0xE9EA, 0xE947, 0xE8DD, 0xE8B2, 0xE8C9, 0xE926, 
	0xE9CE, 0xEAC3, 0xEC27, 0xEE01, 0xF034, 0xF2A0, 0xF528, 0xF7AE, 0xFA13, 
	0xFC38, 0xFE01, 0xFF4D, 0x0000, 0xFFCC, 0xFEA7, 0xFCD2, 0xFA90, 0xF821, 
	0xF5C9, 0xF5CF, 0xF5E0, 0xF5FC, 0xF622, 0xF651, 0xF689, 0xF6C8, 0xF70E, 
	0xF75B, 0xF7AD, 0xF804, 0xF85E, 0xF8BD, 0xF91D, 0xF980, 0xF9E3, 0xFA47, 
	0xFAAB, 0xFB0E, 0xFB6E, 0xFBCC, 0xFC27, 0xFC7E, 0xFCD0, 0xFD1C, 0xFD63, 
	0xFDA2, 0xFDDA, 0xFE09, 0xFE2F, 0xFE4B, 0xFE5C, 0xFE62, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0002, 0x0005, 0x0005, 0xFFFF, 0xFFF7, 0xFFEF, 0xFFEA, 
	0xFFE8, 0xFFE7, 0xFFE7, 0xFFE8, 0xFFE9, 0xFFE9, 0xFFEA, 0xFFEA, 0xFFEA, 
	0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 
	0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 
	0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFF2, 0x0006, 0x001C, 0x002D, 0x0030, 
	0x001C, 0xFFEA, 0xFF54, 0xFE53, 0xFD39, 0xFC22, 0xFAF8, 0xF9C0, 0xF882, 
	0xF745, 0xF60F, 0xF4E6, 0xF3D2, 0xF2D9, 0xF201, 0xF152, 0xF0D6, 0xF08C, 
	0xF06D, 0xF06F, 0xF08B, 0xF0B8, 0xF0EE, 0xF124, 0xF152, 0xF173, 0xF18B, 
	0xF1A7, 0xF1D2, 0xF217, 0xF282, 0xF31F, 0xF3F8, 0xF531, 0xF6CE, 0xF8AD, 
	0xFAA9, 0xFCA0, 0xFE6F, 0xFFF2, 0x0106, 0x01A7, 0x01F6, 0x0205, 0x01E5, 
	0x01A9, 0x0164, 0x0127, 0x0106, 0x00F5, 0x00E0, 0x00C7, 0x00AC, 0x008F, 
	0x0072, 0x0055, 0x003A, 0x0022, 0x000E, 0x0000, 0xFFF6, 0xFFF0, 0xFFED, 
	0xFFEC, 0xFFEE, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 
	0xFFF1, 0xFFF0, 0xFFF0, 0xFFF0, 0xFFF0, 0xFFEF, 0xFFEF, 0xFFEE, 0xFFED, 
	0xFFED, 0xFFEC, 0xFFEB, 0xFFEA, 0xFFE8, 0xFFE7, 0xFFE6, 0xFFE4, 0xFFE2, 
	0xFFE0, 0xFFDE, 0xFFDC, 0xFFD9, 0xFFD7, 0xFFD4, 0xFFD1, 0xFFCE, 0xFFCA, 
	0x0000, 0xEE2F, 0xED4B, 0xF230, 0xF5CC, 0xF85A, 0xFA13, 0xFB30, 0xFBED, 
	0xFC83, 0xFD2B, 0xFE20, 0xFF00, 0x031F, 0x084F, 0x0A43, 0x06EA, 0x00CF, 
	0xFA88, 0xF6AD, 0xF55E, 0xF4DC, 0xF4EE, 0xF55E, 0xF5F3, 0xF675, 0xF6AD, 
	0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 
	0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 
	0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF6AD, 0xF69C, 0xF677, 0xF64B, 
	0xF62B, 0xF625, 0xF64B, 0xF6AD, 0xF7CD, 0xF9BB, 0xFBDA, 0xFDF3, 0x0031, 
	0x0289, 0x04ED, 0x0750, 0x09A6, 0x0BE1, 0x0DF4, 0x0FD4, 0x1172, 0x12C3, 
	0x13AF, 0x1437, 0x146B, 0x145E, 0x1422, 0x13C8, 0x1364, 0x1307, 0x12C3, 
	0x1268, 0x11CF, 0x1115, 0x1056, 0x0FB1, 0x0F41, 0x0F25, 0x0F79, 0x1060, 
	0x11CF, 0x139A, 0x1596, 0x1799, 0x1978, 0x1B07, 0x1C1D, 0x1CE2, 0x1D92, 
	0x1E1C, 0x1E6C, 0x1E73, 0x1E1F, 0x1D5D, 0x1C1D, 0x1A3E, 0x17C6, 0x14DB, 
	0x11A3, 0x0E44, 0x0AE5, 0x07AB, 0x04BE, 0x0242, 0x005F, 0xFF3B, 0xFEF2, 
	0xFF6C, 0x0083, 0x020C, 0x03E1, 0x05D9, 0x05D9, 0x05D8, 0x05D5, 0x05D0, 
	0x05C7, 0x05B9, 0x05A6, 0x058D, 0x056D, 0x0545, 0x0514, 0x04DA, 0x0494, 
	0x0443, 0x03E6, 0x037C, 0x0303, 0x027B, 0x01E3, 0x013B, 0x0080, 0xFFB2, 
	0xFED2, 0xFDDD, 0xFCD3, 0xFBB3, 0xFA7B, 0xF92C, 0xF7C4, 0xF642, 0xF4A6, 
	0xF2EE, 0xF119, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x1DCC, 0x19CC, 0x18FD, 
	0x16C7, 0x1378, 0x0F61, 0x0AD1, 0x061A, 0x0189, 0xFD6F, 0xFA1D, 0xF869, 
	0xF8E9, 0xFD52, 0x05A1, 0x1041, 0x1C89, 0xA9D3, 0x3779, 0x44D3, 0x5139, 
	0x5C06, 0x6491, 0x6A35, 0x6C4A, 0x6A95, 0x65AC, 0x5E1D, 0x5477, 0x494B, 
	0x3D26, 0x3098, 0x2431, 0x187E, 0x0E10, 0x0575, 0xFF3D, 0xFB1E, 0xF84D, 
	0xF698, 0xF5CB, 0xF5B3, 0xF61D, 0xF6D6, 0xF7AC, 0xF86A, 0xF8DF, 0xF8D6, 
	0xF81E, 0xF657, 0xF3A7, 0xF0A6, 0xEDE9, 0xEC05, 0xEAA6, 0xE924, 0xE79B, 
	0xE626, 0xE4E1, 0xE3E7, 0xE354, 0xE343, 0xE3D0, 0xE516, 0xE801, 0xECE7, 
	0xF305, 0xF998, 0xFFDE, 0x0513, 0x0873, 0x0A3E, 0x0B48, 0x0BB4, 0x0BA1, 
	0x0B32, 0x0A88, 0x09C4, 0x0908, 0x0873, 0x07F3, 0x075E, 0x06B7, 0x0600, 
	0x053E, 0x0472, 0x03A0, 0x02CB, 0x01F5, 0x0122, 0x0055, 0xFF90, 0xFED7, 
	0xFE2D, 0xFD93, 0xFD0F, 0xFCFC, 0xFD83, 0xFE5B, 0xFF38, 0xFFD0, 0xFFD8, 
	0xFF06, 0xFD0F, 0xF9E7, 0xF5D7, 0xF116, 0xEBD8, 0xE653, 0xE0BB, 0xDB46, 
	0xD62A, 0xD19B, 0xCDCF, 0xCAFB, 0xC8E7, 0xC738, 0xC5F0, 0xC511, 0xC49C, 
	0xC494, 0xC537, 0xC6EF, 0xC978, 0xCC8C, 0xCFE6, 0xD33F, 0xD654, 0xD8DD, 
	0xDA95, 0xDB37, 0xD874, 0xD0D9, 0xC56A, 0xB72D, 0xA724, 0x1656, 0x05C6, 
	0xF678, 0xE973, 0xDF79, 0xD84D, 0xD36F, 0xD061, 0xCEA3, 0xCDB7, 0xCD1E, 
	0xCC5A, 0xCAEA, 0x4851, 0x4410, 0x3DA7, 0x3497, 0x2863, 0x1DCC, 0xD901, 
	0xD617, 0xDB97, 0xDFE0, 0xE318, 0xE567, 0xE6F3, 0xE7E3, 0xE85E, 0xE88C, 
	0xE892, 0xE890, 0xE7F4, 0xE6BE, 0xE502, 0xE2E2, 0xE079, 0xA220, 0xDB2C, 
	0xD87C, 0xD5E7, 0xD386, 0xD173, 0xCFC7, 0xCE9B, 0xCDE2, 0xCD76, 0xCD50, 
	0xCD65, 0xCDAE, 0xCE21, 0xCEB5, 0xCF61, 0xD01C, 0xD0DE, 0xD19D, 0xD250, 
	0xD31E, 0xD428, 0xD55F, 0xD6B5, 0xD81A, 0xD97F, 0xDAD5, 0xDC0E, 0xDD19, 
	0xDDE9, 0xDE6D, 0xDE97, 0xDD44, 0xDA24, 0xD665, 0xD337, 0xD1C8, 0xD1CE, 
	0xD22F, 0xD2DF, 0xD3D1, 0xD4F7, 0xD645, 0xD7AD, 0xD924, 0xDA9C, 0xDC08, 
	0xDDAD, 0xDFBA, 0xE1FC, 0xE443, 0xE65D, 0xE819, 0xE945, 0xE9EE, 0xEA4C, 
	0xEA6C, 0xEA5E, 0xEA2E, 0xE9EC, 0xE9A6, 0xE969, 0xE945, 0xE92F, 0xE916, 
	0xE8FA, 0xE8DB, 0xE8BA, 0xE898, 0xE875, 0xE851, 0xE82D, 0xE809, 0xE7E7, 
	0xE7C6, 0xE7A7, 0xE78A, 0xE770, 0xE75A, 0xE72E, 0xE6E3, 0xE68F, 0xE647, 
	0xE621, 0xE634, 0xE695, 0xE75A, 0xE895, 0xEA3A, 0xEC2C, 0xEE53, 0xF091, 
	0xF2CE, 0xF4EE, 0xF6D7, 0xF86D, 0xF996, 0xFA37, 0xFA4A, 0xF9E6, 0xF920, 
	0xF80D, 0xF6BF, 0xF54C, 0xF378, 0xF142, 0xEEBA, 0xEBF6, 0xE906, 0xE5FF, 
	0xE2F2, 0xDFF2, 0xDD13, 0xDA67, 0xD7FD, 0xD5DA, 0xD3FD, 0xD269, 0xD11C, 
	0xAFE6, 0xB0A0, 0xB111, 0xB136, 0xB10F, 0xB0A1, 0xAFF8, 0xAF20, 0xAE25, 
	0xAD12, 0xABF4, 0xAAD5, 0xA9C3, 0xD737, 0xD80F, 0xD8B8, 0xD926, 0xD94D, 
	0xD901, 0xB867, 0xBAC0, 0xC326, 0xC8E6, 0xCC96, 0xCECF, 0xD026, 0xD133, 
	0xD28D, 0xD4CA, 0xD881, 0xDBF3, 0xDAE4, 0xD1E0, 0xC14D, 0xAC99, 0x94E1, 
	0xFB3D, 0x60D1, 0x46B3, 0x2E01, 0x17D8, 0x0552, 0xF78C, 0xEFA3, 0xEDC0, 
	0xF0C1, 0xF7D6, 0x022C, 0x0EF3, 0x1D58, 0x2C8A, 0x3BB6, 0x4A0D, 0x56BB, 
	0x60EF, 0x67D8, 0x6BC4, 0x6DC8, 0x6E3F, 0x6D86, 0x6BF5, 0x69E9, 0x67BD, 
	0x65CB, 0x646D, 0x6400, 0x64DE, 0x6762, 0x6EA6, 0x7B65, 0x8A71, 0x9895, 
	0xA2A2, 0xA96B, 0xAFDA, 0xB5E0, 0xBB6E, 0xC074, 0xC4E3, 0xC8AB, 0xCBBD, 
	0xCE0A, 0xCF81, 0xCEF6, 0xCBD7, 0xC705, 0xC15F, 0xBBC4, 0xB714, 0xB42F, 
	0xB2BD, 0xB1C7, 0xB13F, 0xB119, 0xB146, 0xB1BA, 0xB265, 0xB33C, 0xB42F, 
	0xB546, 0xB68B, 0xB7F7, 0xB983, 0xBB2A, 0xBCE6, 0xBEAE, 0xC07E, 0xC24E, 
	0xC419, 0xC5D8, 0xC783, 0xC916, 0xCA89, 0xCBD6, 0xCCF7, 0xCDE9, 0xCEA8, 
	0xCF2C, 0xCF6B, 0xCF5B, 0xCEF3, 0xCE2A, 0xCCF7, 0xCB41, 0xC90C, 0xC674, 
	0xC399, 0xC097, 0xBD8D, 0xBA9A, 0xB7DA, 0xB56C, 0xB36F, 0xB1FF, 0xB105, 
	0xB052, 0xAFE3, 0xAFB4, 0xAFC2, 0xB009, 0xB051, 0xB0B0, 0xB15F, 0xB294, 
	0xB487, 0xB76F, 0xBB83, 0xC0FB, 0xC80D, 0xD0F1, 0xDD8E, 0xEECE, 0x036C, 
	0x1A22, 0x31A9, 0xC8BD, 0xDE19, 0xF076, 0xFE8F, 0x094C, 0x1281, 0x1A4C, 
	0x20CB, 0x261C, 0x2A5F, 0x2DB0, 0x302E, 0x31F7, 0xB329, 0xB3E3, 0xB443, 
	0xB466, 0xB46B, 0xB867, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFF86, 0xFE3C, 0xFC57, 0xFA09, 0xF788, 0xF507, 0xF2B9, 0xF0D4, 
	0xEF8A, 0xEF11, 0xEF29, 0xEF6E, 0xEFDB, 0xF06D, 0xF11F, 0xF1EC, 0xF2D1, 
	0xF3C9, 0xF4D1, 0xF5E3, 0xF6FB, 0xF815, 0xF92E, 0xFA40, 0xFB47, 0xFC3F, 
	0xFD24, 0xFDF2, 0xFEA3, 0xFF35, 0xFFA2, 0xFFE7, 0xFFFF, 0x0000, 0xC9F4, 
	0xCBE1, 0xD50C, 0xDC2F, 0xE18C, 0xE564, 0xE7F8, 0xE988, 0xEA56, 0xEAA1, 
	0xEAAC, 0xEA9D, 0xE9B8, 0xE80C, 0xE5AD, 0xE2BC, 0xDF5F, 0xDBBD, 0xD7FD, 
	0xD446, 0xD0BD, 0xCD8A, 0xCAD3, 0xC8BF, 0xC774, 0xC6AF, 0xC611, 0xC598, 
	0xC541, 0xC50A, 0xC4EE, 0xC4ED, 0xC503, 0xC52E, 0xC56B, 0xC5B7, 0xC610, 
	0xC673, 0xC6DD, 0xC74C, 0xC7BD, 0xC82D, 0xC89A, 0xC902, 0xC960, 0xC9B3, 
	0xC9F8, 0xCA2D, 0xCA4E, 0xCA53, 0xCA3B, 0xCA16, 0xC9EE, 0xC9D3, 0xC9D1, 
	0xC9F6, 0xCA4E, 0xCB63, 0xCD4A, 0xCF68, 0xD185, 0xD3CA, 0xD628, 0xD893, 
	0xDAFE, 0xDD5C, 0xDF9E, 0xE1BA, 0xE3A0, 0xE544, 0xE698, 0xE785, 0xE808, 
	0xE834, 0xE81E, 0xE7DA, 0xE77D, 0xE71B, 0xE6C8, 0xE698, 0xE67F, 0xE661, 
	0xE640, 0xE61C, 0xE5F5, 0xE5CD, 0xE5A3, 0xE579, 0xE54F, 0xE525, 0xE4FC, 
	0xE4D5, 0xE4B0, 0xE48E, 0xE470, 0xE456, 0xE479, 0xE4F2, 0xE591, 0xE626, 
	0xE681, 0xE672, 0xE5C9, 0xE456, 0xE214, 0xDF34, 0xDBDB, 0xD829, 0xD443, 
	0xD04B, 0xCC63, 0xC8AE, 0xC54F, 0xC269, 0xC01F, 0xBE41, 0xBC8F, 0xBB11, 
	0xB9CC, 0xB8C8, 0xB80D, 0xB84D, 0xB8FF, 0xBA0C, 0xBB5E, 0xBCE0, 0xBE7C, 
	0xC01B, 0xC1A8, 0xC30D, 0xC434, 0xC529, 0xC609, 0xC6D5, 0xC78D, 0xC833, 
	0xC8C8, 0xC94B, 0xC9C0, 0xCA26, 0xCA7E, 0xCACA, 0xCB0A, 0xCB40, 0xCB6B, 
	0xCB8E, 0xCBAA, 0xCBBE, 0xCBCD, 0xCBD7, 0xCBDD, 0xCBE0, 0xCBE1, 0xCBE1, 
	0xC9F4, 0x071C, 0x00B7, 0x00B8, 0x00C0, 0x00D4, 0x00FD, 0x013F, 0x01A2, 
	0x022C, 0x02E5, 0x03D1, 0x05BA, 0x0517, 0xFFFF, 0xF586, 0xE725, 0xD68F, 
	0xC574, 0xB587, 0xA87A, 0xA42C, 0xA795, 0xAEAB, 0xB7E4, 0xBE5B, 0xC14C, 
	0xC35B, 0xC4BA, 0xC599, 0xC62A, 0xC69E, 0xC705, 0xC753, 0xC78B, 0xC7AF, 
	0xC7C4, 0xC7CD, 0xC7CD, 0xC7C7, 0xC7C0, 0xC7BB, 0xC7BB, 0xC7C3, 0xC7D7, 
	0xC7FA, 0xC831, 0xC87D, 0xC8E3, 0xC967, 0xCA3E, 0xCB8A, 0xCD27, 0xCEF6, 
	0xD0D6, 0xD2A4, 0xD442, 0xD58C, 0xD5FE, 0xD5AC, 0xD55E, 0xD554, 0xD54A, 
	0xD53F, 0xD536, 0xD52C, 0xD523, 0xD51A, 0xD512, 0xD50B, 0xD504, 0xD4FF, 
	0xD4FC, 0xD4FB, 0xD4FC, 0xD4FD, 0xD500, 0xD502, 0xD503, 0xD502, 0xD4FF, 
	0xD4FA, 0xD4F5, 0xD4EF, 0xD4E8, 0xD4E1, 0xD4DA, 0xD4D2, 0xD4CB, 0xD4C3, 
	0xD4BB, 0xD4B4, 0xD4AD, 0xD4A6, 0xD4A0, 0xD49A, 0xD495, 0xD495, 0xD49A, 
	0xD4A1, 0xD4A9, 0xD4AF, 0xD4AF, 0xD4A8, 0xD495, 0xD480, 0xD46F, 0xD460, 
	0xD44F, 0xD43B, 0xD41F, 0xD3F9, 0xD3C6, 0xD384, 0xD32F, 0xD2C5, 0xD20D, 
	0xD0E9, 0xCF7D, 0xCDEA, 0xCC56, 0xCAE3, 0xCB08, 0xCB73, 0xCC20, 0xCD0B, 
	0xCE2E, 0xCF86, 0xD10D, 0xD2C0, 0xD499, 0xD694, 0xD8AD, 0xDADF, 0xDD25, 
	0xDF7B, 0xE1DC, 0xE445, 0xE6AF, 0xE918, 0xEB79, 0xEDCF, 0xF016, 0xF248, 
	0xF460, 0xF65C, 0xF835, 0xF9E7, 0xFB6F, 0xFCC6, 0xFDE9, 0xFED4, 0xFF81, 
	0xFFEC, 0x0012, 0x071C, 0x0306, 0x0727, 0x06B9, 0x0592, 0x03E6, 0x01EB, 
	0xFFD5, 0xFDDB, 0xFC2F, 0xFB08, 0xFA9A, 0xFB29, 0xFAF9, 0xF97B, 0xF5FE, 
	0xF0DE, 0xEB18, 0xE5AA, 0xE191, 0xDFCC, 0xEA97, 0xF740, 0xF73F, 0xF391, 
	0xF114, 0xF12E, 0xF1D8, 0xF2CF, 0xF3CD, 0xF490, 0xF4D2, 0xF4B1, 0xF47B, 
	0xF431, 0xF3D7, 0xF371, 0xF301, 0xF28A, 0xF210, 0xF195, 0xF11C, 0xF0AA, 
	0xF03F, 0xEFE1, 0xEF91, 0xEF53, 0xEF2A, 0xEF19, 0xEF23, 0xEF7C, 0xF043, 
	0xF15A, 0xF2A1, 0xF3FB, 0xF54B, 0xF670, 0xF74E, 0xF77B, 0xF711, 0xF6B3, 
	0xF693, 0xF672, 0xF651, 0xF632, 0xF613, 0xF5F6, 0xF5DA, 0xF5C1, 0xF5AA, 
	0xF596, 0xF585, 0xF57B, 0xF578, 0xF57A, 0xF57F, 0xF586, 0xF58C, 0xF590, 
	0xF58E, 0xF585, 0xF577, 0xF567, 0xF554, 0xF540, 0xF52B, 0xF515, 0xF4FE, 
	0xF4E6, 0xF4CF, 0xF4B7, 0xF4A1, 0xF48B, 0xF477, 0xF464, 0xF453, 0xF445, 
	0xF43E, 0xF441, 0xF44A, 0xF455, 0xF45E, 0xF461, 0xF45A, 0xF445, 0xF428, 
	0xF40B, 0xF3ED, 0xF3CC, 0xF3A6, 0xF37B, 0xF348, 0xF30B, 0xF2C4, 0xF270, 
	0xF20E, 0xF187, 0xF0D1, 0xEFFA, 0xEF0F, 0xEE1E, 0xED37, 0xED43, 0xED68, 
	0xEDA2, 0xEDF1, 0xEE54, 0xEEC8, 0xEF4C, 0xEFDF, 0xF07F, 0xF12A, 0xF1DF, 
	0xF29D, 0xF362, 0xF42C, 0xF4FA, 0xF5CA, 0xF69B, 0xF76B, 0xF839, 0xF903, 
	0xF9C7, 0xFA85, 0xFB3A, 0xFBE6, 0xFC86, 0xFD18, 0xFD9C, 0xFE11, 0xFE73, 
	0xFEC2, 0xFEFD, 0xFF21, 0xFF2D, 0x0306, 0x0A90, 0x015D, 0x00C2, 0xFF1C, 
	0xFCAF, 0xF9BE, 0xF68A, 0xF357, 0xF066, 0xEDFC, 0xEC59, 0xEBC0, 0xEBF3, 
	0xED8B, 0xF0D8, 0xF566, 0xFAA5, 0x0005, 0x04F6, 0x08E8, 0x095C, 0x079A, 
	0x05C5, 0x03B7, 0x0315, 0x0465, 0x06A9, 0x0949, 0x0BAA, 0x0D33, 0x0D4B, 
	0x0C54, 0x0B1E, 0x09AF, 0x0811, 0x064B, 0x0464, 0x0266, 0x0058, 0xFE42, 
	0xFC2B, 0xFA1D, 0xF81E, 0xF637, 0xF470, 0xF2D0, 0xF160, 0xF028, 0xEF30, 
	0xEED0, 0xEF3B, 0xF041, 0xF1AE, 0xF351, 0xF4F8, 0xF671, 0xF78C, 0xF823, 
	0xF863, 0xF88C, 0xF8C2, 0xF8F7, 0xF92C, 0xF95F, 0xF991, 0xF9C0, 0xF9EC, 
	0xFA15, 0xFA3A, 0xFA5B, 0xFA76, 0xFA87, 0xFA8C, 0xFA89, 0xFA80, 0xFA74, 
	0xFA6A, 0xFA65, 0xFA68, 0xFA76, 0xFA8D, 0xFAA7, 0xFAC5, 0xFAE6, 0xFB08, 
	0xFB2D, 0xFB52, 0xFB78, 0xFB9E, 0xFBC4, 0xFBE9, 0xFC0C, 0xFC2D, 0xFC4B, 
	0xFC66, 0xFC7E, 0xFC87, 0xFC7D, 0xFC67, 0xFC4F, 0xFC3D, 0xFC39, 0xFC4C, 
	0xFC7E, 0xFCBE, 0xFCF7, 0xFD2F, 0xFD6C, 0xFDB4, 0xFE0E, 0xFE7E, 0xFF0B, 
	0xFFBB, 0x0094, 0x019C, 0x0310, 0x0511, 0x0774, 0x0A12, 0x0CC1, 0x0F59, 
	0x0F4F, 0x0F33, 0x0F05, 0x0EC6, 0x0E79, 0x0E1D, 0x0DB5, 0x0D41, 0x0CC3, 
	0x0C3C, 0x0BAD, 0x0B18, 0x0A7D, 0x09DE, 0x093B, 0x0897, 0x07F3, 0x074F, 
	0x06AC, 0x060D, 0x0572, 0x04DD, 0x044E, 0x03C7, 0x0349, 0x02D5, 0x026D, 
	0x0212, 0x01C4, 0x0186, 0x0157, 0x013B, 0x0131, 0x0A90, 0x0001, 0xFFFE, 
	0xC170, 0x36DA, 0x384A, 0x3DA4, 0xC66C, 0xD18E, 0xDDF5, 0xEA8D, 0xF641, 
	0xFFFC, 0x06AC, 0x093A, 0x0945, 0x09DD, 0x0AE8, 0x0C16, 0x0D17, 0x0D9C, 
	0x0D57, 0x0BF8, 0x091E, 0x04E9, 0xFFC3, 0xFA19, 0xF458, 0xEEEC, 0xE964, 
	0xE32E, 0xDC8A, 0xD5B5, 0xCEEE, 0xC873, 0xC283, 0xBD5C, 0xB93C, 0xB661, 
	0xB50A, 0xB71B, 0xBD68, 0xC69F, 0xD16A, 0xDC75, 0xE66C, 0xF060, 0xFB99, 
	0x0713, 0x11C7, 0x1AAF, 0xA0C6, 0xA4D6, 0xA845, 0xAAFF, 0xACED, 0xADF8, 
	0xAE0B, 0xAD0F, 0xAAEF, 0x2795, 0x1C3A, 0x075B, 0x70C5, 0x58B1, 0x3DD3, 
	0x25A1, 0x1592, 0x0D29, 0x07C7, 0x04B2, 0x0332, 0x028D, 0x0209, 0x00ED, 
	0xFF62, 0xFE12, 0xFCF6, 0xFC0B, 0xFB4B, 0xFAB3, 0xFA40, 0xF9EC, 0xF9B5, 
	0xF995, 0xF990, 0xF9A9, 0xF9DD, 0xFA26, 0xFA83, 0xFAEE, 0xFB64, 0xFBE1, 
	0xFC62, 0xFCE3, 0xFD5F, 0xFDD3, 0xFE3C, 0xFE95, 0xFEDA, 0xFE15, 0xFBDD, 
	0xF909, 0xF66D, 0xF4DF, 0xF533, 0xF840, 0xFEDA, 0x0943, 0x16A9, 0x265E, 
	0x37B0, 0x49EB, 0xDC5B, 0xEE51, 0xFF17, 0x0DFC, 0x1A4C, 0x2354, 0x2937, 
	0x2CC8, 0x2E5D, 0x2E4E, 0x2CF1, 0x2A9D, 0x2807, 0x2543, 0x2253, 0x1F3B, 
	0x1BFD, 0x189E, 0x1520, 0x1186, 0x0DD3, 0x0A0B, 0x0631, 0x0248, 0xFE51, 
	0xFA53, 0xF64F, 0xF249, 0xEE43, 0xEA41, 0xE646, 0xE255, 0xDE72, 0xDA9E, 
	0xD6DF, 0xD335, 0xCFA6, 0xCC34, 0xC8E2, 0xC5B3, 0x42AB, 0x3FCD, 0x3D1B, 
	0x3A99, 0x384A, 0x36DA, 0x54F5, 0x5449, 0x54FD, 0x291E, 0x2662, 0x2323, 
	0x1FB9, 0x1C7B, 0x19BE, 0x17DA, 0x1726, 0x18A9, 0x1BDC, 0x200B, 0x24B5, 
	0x2958, 0x2D71, 0x307E, 0x31FE, 0x3110, 0x2DE0, 0x297E, 0x24FC, 0x216A, 
	0x1FD8, 0x1FE6, 0x2071, 0x2166, 0x22AF, 0x2439, 0x25EF, 0x27BE, 0x2990, 
	0x2B52, 0x2CF0, 0x2E54, 0x2FAE, 0x3121, 0x328B, 0x33C8, 0x34B5, 0x3530, 
	0x34FA, 0x3425, 0x32FF, 0x31DB, 0x3107, 0x4F2C, 0x4EEC, 0x4E99, 0x4E2A, 
	0x4D97, 0x4CD8, 0x4BE5, 0x4AB4, 0x493F, 0x3883, 0x3C27, 0x41ED, 0x3820, 
	0x3212, 0x2B81, 0x25AA, 0x21CE, 0x1FC8, 0x1E81, 0x1DCB, 0x1D7A, 0x1D60, 
	0x1D50, 0x1D1D, 0x1CB9, 0x1C3F, 0x1BBF, 0x1B45, 0x1AE2, 0x1AA3, 0x1A97, 
	0x1ACC, 0x1B51, 0x1C35, 0x1D71, 0x1EEF, 0x20A6, 0x228B, 0x2495, 0x26BA, 
	0x28F1, 0x2B2E, 0x2D69, 0x2F97, 0x31AF, 0x33A6, 0x3574, 0x370E, 0x386A, 
	0x3909, 0x38B5, 0x37D0, 0x36BE, 0x35E1, 0x359D, 0x3654, 0x386A, 0x3BEE, 
	0x4081, 0x45E2, 0x4BD1, 0x520D, 0x27AC, 0x219B, 0x1C01, 0x171E, 0x1334, 
	0x1085, 0x0F18, 0x0EAE, 0x0F1B, 0x1032, 0x11C7, 0x13AC, 0x158B, 0x1752, 
	0x1900, 0x1A96, 0x1C15, 0x1D7E, 0x1ED0, 0x200E, 0x2137, 0x224C, 0x234E, 
	0x243E, 0x251B, 0x25E8, 0x26A4, 0x2750, 0x27EC, 0x287B, 0x28FB, 0x296E, 
	0x29D4, 0x2A2E, 0x2A7D, 0x2AC2, 0x2AFC, 0x2B2D, 0x2B56, 0x2B76, 0x5471, 
	0x545E, 0x5452, 0x544B, 0x5449, 0x54F5, 0x175C, 0x1813, 0x2A61, 0xB8A2, 
	0xC358, 0xCB05, 0xD02A, 0xD349, 0xD4E3, 0xD57B, 0xD590, 0xD1C6, 0xC823, 
	0xBC64, 0xAF5B, 0xA1D9, 0x94B0, 0x88B0, 0x7EAA, 0x7728, 0x71A1, 0x6D51, 
	0x6972, 0x6541, 0x5FF8, 0x5966, 0x5208, 0x4A22, 0x41F7, 0x39C9, 0x31DC, 
	0x2A72, 0x23D0, 0x1E38, 0x19EE, 0x1734, 0x17D2, 0x1C92, 0x243B, 0x2D91, 
	0x375C, 0x4060, 0x4975, 0x53BF, 0x5E7D, 0x68ED, 0x724D, 0xF9DA, 0x0024, 
	0x061F, 0x0BB7, 0x10D6, 0x1566, 0x1950, 0x1C7E, 0x1ED9, 0xA049, 0x9C2C, 
	0x916E, 0x055A, 0xF834, 0xE925, 0xDBAB, 0xD349, 0xCFD1, 0xCE5E, 0xCE62, 
	0xCF50, 0xD099, 0xD1B1, 0xD208, 0xD1AB, 0xD115, 0xD05E, 0xCF9E, 0xCEEC, 
	0xCE60, 0xCE12, 0xCE1A, 0xCE90, 0xCF8C, 0xD100, 0xD2C8, 0xD4D8, 0xD724, 
	0xD99E, 0xDC3B, 0xDEEE, 0xE1AC, 0xE466, 0xE712, 0xE9A3, 0xEC0D, 0xEE42, 
	0xF037, 0xF1E0, 0xF289, 0xF1E7, 0xF087, 0xEEF6, 0xEDC3, 0xED7B, 0xEEAA, 
	0xF1E0, 0xF732, 0xFE1C, 0x063F, 0x0F34, 0x189D, 0xA21A, 0xAB4C, 0xB3D1, 
	0xBB49, 0xC153, 0xC58F, 0xC7DE, 0xC894, 0xC7FE, 0xC667, 0xC41E, 0xC16D, 
	0xBEEA, 0xBCB4, 0xBAC6, 0xB91A, 0xB7AB, 0xB673, 0xB56D, 0xB493, 0xB3DF, 
	0xB34D, 0xB2D6, 0xB275, 0xB225, 0xB1DF, 0xB19F, 0xB15F, 0xB119, 0xB0C8, 
	0xB066, 0xAFEE, 0xAF5A, 0xAEA5, 0xADC9, 0xACC0, 0xAB86, 0xAA14, 0xA865, 
	0xA673, 0x243A, 0x21B2, 0x1ED8, 0x1BA5, 0x1813, 0x175C, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xCB60, 0xCB6B, 0xD315, 0xD90C, 0xDD88, 0xE0BF, 0xE2E7, 0xE435, 
	0xE4E1, 0xE520, 0xE529, 0xE329, 0xDEFC, 0xD976, 0xD34C, 0xCD37, 0xC7EC, 
	0xC422, 0xC291, 0xC4A4, 0xCA29, 0xD168, 0xD8A9, 0xDE33, 0xE04F, 0xDFF5, 
	0xDF4D, 0xDE5C, 0xDD2A, 0xDBC0, 0xDA23, 0xD85C, 0xD673, 0xD46E, 0xD255, 
	0xD030, 0xCE05, 0xCBDE, 0xC9C0, 0xC7B4, 0xC5C0, 0xC3ED, 0xC242, 0xC0C6, 
	0xBF81, 0xBE7A, 0xBDB9, 0xBD45, 0xBDAA, 0xBF45, 0xC1D4, 0xC516, 0xC8CA, 
	0xCCAE, 0xD081, 0xD402, 0xD6F0, 0xD91B, 0xDAAE, 0xDBF0, 0xDD24, 0xDE5E, 
	0xDF98, 0xE0D0, 0xE200, 0xE324, 0xE438, 0xE537, 0xE61D, 0xE6E6, 0xE78D, 
	0xE815, 0xE883, 0xE8D2, 0xE901, 0xE90B, 0xE8EE, 0xE8A7, 0xE832, 0xE78D, 
	0xE692, 0xE531, 0xE388, 0xE1B5, 0xDFD5, 0xDE06, 0xDC66, 0xDB13, 0xDA2A, 
	0xD9CF, 0xD9F6, 0xDA78, 0xDB2C, 0xDBEC, 0xDC8F, 0xDCEE, 0xDD41, 0xDDC5, 
	0xDE55, 0xDECD, 0xDF0A, 0xDEE6, 0xDE3E, 0xDCEE, 0xDAEE, 0xD864, 0xD56E, 
	0xD22A, 0xCEB7, 0xCB34, 0xC7BF, 0xC477, 0xC17A, 0xBEE7, 0xBCDC, 0xBB30, 
	0xB9A9, 0xB84D, 0xB724, 0xB634, 0xB583, 0xB596, 0xB5CB, 0xB622, 0xB698, 
	0xB72A, 0xB7D6, 0xB89A, 0xB973, 0xBA60, 0xBB5F, 0xBC6B, 0xBD85, 0xBEA9, 
	0xBFD4, 0xC106, 0xC23A, 0xC370, 0xC4A5, 0xC5D6, 0xC702, 0xC826, 0xC93F, 
	0xCA4C, 0xCB4A, 0xCC37, 0xCD11, 0xCDD5, 0xCE81, 0xCF13, 0xCF88, 0xCFDF, 
	0xD015, 0xD027, 0xCB60, 0xFA42, 0xF7DF, 0xF9A3, 0xFB02, 0xFC0B, 0xFCC8, 
	0xFD47, 0xFD94, 0xFDBB, 0xFDCA, 0xFDCC, 0xFFFF, 0x05F6, 0x0D79, 0x15D4, 
	0x1E51, 0x263D, 0x2CE4, 0x3190, 0x3394, 0x3350, 0x31A3, 0x2F6B, 0x2D86, 
	0x2CD4, 0x2D28, 0x2DB8, 0x2E77, 0x2F58, 0x304E, 0x314A, 0x3241, 0x3325, 
	0x33E7, 0x347C, 0x34D6, 0x34F3, 0x34DF, 0x34A5, 0x344D, 0x33E2, 0x336B, 
	0x32F4, 0x3285, 0x3228, 0x31E6, 0x31C9, 0x31DA, 0x3223, 0x32A2, 0x334B, 
	0x3414, 0x34F2, 0x35D9, 0x36C0, 0x379B, 0x385F, 0x3911, 0x39BB, 0x3A59, 
	0x3AF4, 0x3B96, 0x3C3C, 0x3CE3, 0x3D89, 0x3E29, 0x3EC1, 0x3F4F, 0x3FCF, 
	0x403D, 0x4098, 0x40D0, 0x40DF, 0x40D0, 0x40B0, 0x4089, 0x4068, 0x4058, 
	0x4064, 0x4098, 0x40EC, 0x414D, 0x41BA, 0x4231, 0x42AF, 0x4334, 0x43BD, 
	0x4448, 0x44D3, 0x455C, 0x45E2, 0x4662, 0x46DA, 0x4749, 0x47AD, 0x4804, 
	0x4835, 0x4838, 0x481B, 0x47F1, 0x47C9, 0x47B3, 0x47C1, 0x4804, 0x4873, 
	0x48FC, 0x4999, 0x4A46, 0x4AFF, 0x4BBE, 0x4C80, 0x4D40, 0x4DF9, 0x4EA7, 
	0x4F46, 0x5024, 0x5174, 0x530B, 0x54BB, 0x5659, 0x57B9, 0x57B8, 0x57B4, 
	0x57A8, 0x5792, 0x576C, 0x5735, 0x56E7, 0x5680, 0x55FB, 0x5556, 0x548B, 
	0x5399, 0x527A, 0x512C, 0x4FAB, 0x4DF2, 0x4BFF, 0x49CD, 0x475A, 0x44A1, 
	0x419E, 0x3E4F, 0x3AAF, 0x36BB, 0x326E, 0x2DC6, 0x28BF, 0x2355, 0x1D84, 
	0x1748, 0x109F, 0x0984, 0x01F4, 0xFA42, 0x0197, 0xFFF7, 0xFFF7, 0xFFF5, 
	0xFFF0, 0xFFE7, 0xFFD7, 0xFFBF, 0xFF9F, 0xFF73, 0xFF3B, 0xFFFF, 0x0206, 
	0x0486, 0x074C, 0x0A27, 0x0CE4, 0x0F51, 0x113B, 0x1284, 0x134A, 0x13B9, 
	0x13FE, 0x1446, 0x14BB, 0x1563, 0x1621, 0x16ED, 0x17BF, 0x188F, 0x1954, 
	0x1A08, 0x1AA2, 0x1B1A, 0x1B68, 0x1B85, 0x1B6A, 0x1B1E, 0x1AA9, 0x1A13, 
	0x1965, 0x18A8, 0x17E4, 0x1721, 0x1669, 0x15C4, 0x1539, 0x14D3, 0x1493, 
	0x1471, 0x1467, 0x146F, 0x1483, 0x149E, 0x14B8, 0x14CC, 0x14D3, 0x14D1, 
	0x14CF, 0x14CB, 0x14C8, 0x14C4, 0x14C1, 0x14BD, 0x14B9, 0x14B6, 0x14B2, 
	0x14AF, 0x14AC, 0x14A9, 0x14A7, 0x14A6, 0x14A6, 0x14A6, 0x14A7, 0x14A8, 
	0x14A9, 0x14A9, 0x14A9, 0x14A7, 0x14A5, 0x14A2, 0x149F, 0x149C, 0x1499, 
	0x1495, 0x1491, 0x148D, 0x148A, 0x1486, 0x1482, 0x147F, 0x147B, 0x1478, 
	0x1476, 0x1473, 0x1474, 0x1479, 0x1481, 0x1488, 0x148C, 0x148C, 0x1484, 
	0x1473, 0x1460, 0x1453, 0x1447, 0x143B, 0x142A, 0x1412, 0x13F1, 0x13C2, 
	0x1383, 0x1330, 0x12C7, 0x1244, 0x11A6, 0x10F3, 0x102F, 0x0F5E, 0x0E85, 
	0x0DAE, 0x0CDB, 0x0C0D, 0x0B44, 0x0A7F, 0x09C0, 0x0906, 0x0851, 0x07A1, 
	0x06F7, 0x0652, 0x05B4, 0x051B, 0x0488, 0x03FC, 0x0376, 0x02F7, 0x027E, 
	0x020C, 0x01A1, 0x013D, 0x00E0, 0x008A, 0x003C, 0xFFF5, 0xFFB6, 0xFF80, 
	0xFF51, 0xFF2A, 0xFF0C, 0xFEF7, 0xFEE9, 0xFEE5, 0x0197, 0x0624, 0x0239, 
	0x01C6, 0x0091, 0xFED2, 0xFCC1, 0xFA94, 0xF883, 0xF6C4, 0xF590, 0xF51D, 
	0xF548, 0xF5EB, 0xF6E8, 0xF805, 0xF907, 0xF9B3, 0xF9CF, 0xF921, 0xF70A, 
	0xF390, 0xEF6C, 0xEB59, 0xE812, 0xE650, 0xE5CB, 0xE5B3, 0xE5F6, 0xE681, 
	0xE743, 0xE829, 0xE921, 0xEA1A, 0xEB00, 0xEBC3, 0xEC4F, 0xECB8, 0xED1C, 
	0xED7C, 0xEDD6, 0xEE2C, 0xEE7D, 0xEEC9, 0xEF0F, 0xEF4F, 0xEF8A, 0xEFBF, 
	0xEFEE, 0xF00D, 0xF014, 0xF00A, 0xEFF7, 0xEFE0, 0xEFCD, 0xEFC5, 0xEFCE, 
	0xEFEE, 0xF063, 0xF135, 0xF221, 0xF310, 0xF410, 0xF51C, 0xF62D, 0xF73F, 
	0xF84B, 0xF94B, 0xFA3A, 0xFB11, 0xFBCB, 0xFC62, 0xFCBC, 0xFCD3, 0xFCB8, 
	0xFC80, 0xFC3F, 0xFC08, 0xFBEE, 0xFC06, 0xFC62, 0xFCF4, 0xFD9E, 0xFE5C, 
	0xFF2C, 0x000A, 0x00F2, 0x01E1, 0x02D4, 0x03C7, 0x04B8, 0x05A1, 0x0681, 
	0x0754, 0x0817, 0x08C5, 0x095C, 0x09B2, 0x09B1, 0x097A, 0x092A, 0x08E0, 
	0x08BC, 0x08DB, 0x095C, 0x0A30, 0x0B2D, 0x0C4C, 0x0D88, 0x0EDC, 0x1041, 
	0x11B0, 0x1325, 0x1499, 0x1606, 0x1767, 0x18FB, 0x1AF2, 0x1D26, 0x1F75, 
	0x21BC, 0x23D7, 0x23CE, 0x23B2, 0x2385, 0x2347, 0x22F7, 0x2298, 0x2228, 
	0x21AA, 0x211C, 0x2080, 0x1FD6, 0x1F1E, 0x1E59, 0x1D88, 0x1CAB, 0x1BC2, 
	0x1ACD, 0x19CE, 0x18C5, 0x17B2, 0x1696, 0x1571, 0x1443, 0x130E, 0x11D1, 
	0x108D, 0x0F43, 0x0DF2, 0x0C9C, 0x0B41, 0x09E1, 0x087D, 0x0716, 0x0624, 
	0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xEFF9, 0x839E, 0x0000, 0xFFFF, 0x49EE, 
	0xF7AE, 0x03C6, 0xAB92, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x1192, 0x842B, 
	0xFFFF, 0x0000, 0x4A21, 0x09D3, 0xFE32, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
	0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 0x0007, 0x0001, 0x0008, 
	0x009B, 0x0009, 0x009B, 0x00A4, 0x009B, 0x013F, 0x009B, 0x01DA, 0x009B, 
	0x0275, 0x009B, 0x0310, 0x0001, 0x03AB, 0x0001, 0x03AC, 0x0001, 0x03AD, 
	0x009B, 0x03AE, 0x009B, 0x0449, 0x009B, 0x04E4, 0x008A, 0x057F, 0x009B, 
	0x0609, 0x009B, 0x06A4, 0x009B, 0x073F, 0x009B, 0x07DA, 0x009B, 0x0875, 
	0x0001, 0x0910, 0x0001, 0x0911, 0x0001, 0x0912, 0x009B, 0x0913, 0x009B, 
	0x09AE, 0x009B, 0x0A49, 0x009B, 0x0AE4, 0x009A, 0x0B7F, 0x009B, 0x0C19, 
	0x009B, 0x0CB4, 0x009B, 0x0D4F, 0x009B, 0x0DEA, 0x0001, 0x0E85, 0x0001, 
	0x0E86, 0x0001, 0x0E87, 0x0001, 0x0E88, 0x0001, 0x0E89, 0x0001, 0x0E8A, 
	0x0001, 0x0E8B, 0x0001, 0x0E8C, 0x0001, 0x0E8D, 0x0001, 0x0E8E, 0x0001, 
	0x0E8F, 0x0001, 0x0E90, 0x0001, 0x0E91, 0x0001, 0x0E92, 0x0001, 0x0E93, 
	0x0001, 0x0E94, 0x0001, 0x0E95, 0x0001, 0x0E96, 0x0001, 0x0E97, 0x0001, 
	0x0E98, 0x0001, 0x0E99, 0x0001, 0x0E9A, 0x0001, 0x0E9B, 0x0001, 0x0E9C, 
	

});

smlua_anim_util_register_animation('donkey_5F_pull_door_walk_in',1, 0, 0, 0, 59, { 
	0x0003, 0x0005, 0x000B, 0x0018, 0x0028, 0x0039, 0x0059, 0x007E, 0x009A, 
	0x00B3, 0x00C8, 0x00CF, 0x00D1, 0x00D1, 0x00D3, 0x00DD, 0x00E8, 0x00EF, 
	0x00EC, 0x00E5, 0x00DD, 0x00D5, 0x00CE, 0x00C7, 0x00BD, 0x00AC, 0x009A, 
	0x0086, 0x0073, 0x005E, 0x0048, 0x0034, 0x0024, 0x0019, 0x0012, 0x000D, 
	0x0007, 0xFFFF, 0xFFF8, 0xFFF5, 0xFFF4, 0xFFF4, 0xFFF5, 0xFFF5, 0xFFF3, 
	0xFFF0, 0xFFEE, 0xFFEC, 0xFFEB, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFEB, 
	0xFFF1, 0xFFF9, 0xFFFF, 0x0001, 0x008B, 0x008C, 0x008F, 0x0093, 0x0099, 
	0x009F, 0x00A4, 0x00A6, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 
	0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 
	0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 
	0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 
	0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 0x00A7, 
	0x00A7, 0x00A7, 0x00A6, 0x00A4, 0x00A0, 0x009B, 0x0094, 0x008B, 0xFEED, 
	0xFEED, 0xFEED, 0xFEED, 0xFEEE, 0xFEEE, 0xFEF0, 0xFEF6, 0xFF07, 0xFF1A, 
	0xFF27, 0xFF22, 0xFF15, 0xFF07, 0xFEFA, 0xFEF1, 0xFEEA, 0xFEE8, 0xFEE7, 
	0xFEE7, 0xFEEA, 0xFEF4, 0xFEFB, 0xFEFE, 0xFF09, 0xFF20, 0xFF3C, 0xFF5A, 
	0xFF76, 0xFF8F, 0xFFA7, 0xFFC0, 0xFFD9, 0xFFF2, 0x0009, 0x0023, 0x0043, 
	0x006E, 0x0097, 0x00C0, 0x00EA, 0x0116, 0x013A, 0x015B, 0x018C, 0x01CE, 
	0x020D, 0x0238, 0x0255, 0x0271, 0x0292, 0x02B6, 0x02D4, 0x02E1, 0x02EA, 
	0x02ED, 0x02EE, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFF78, 0x003D, 0x0229, 
	0x04A7, 0x0726, 0x0911, 0x09D6, 0x071C, 0x02C5, 0xFFFF, 0x006C, 0x0256, 
	0x03EE, 0x0365, 0x0080, 0xFC83, 0xF7E0, 0xF30A, 0xEE74, 0xEA90, 0xE7D0, 
	0xE90C, 0xED42, 0xEF21, 0xEC5A, 0xE78F, 0xE2DA, 0xE052, 0xE08C, 0xE268, 
	0xE571, 0xE932, 0xEE60, 0xF4F3, 0xFB58, 0x0000, 0x0172, 0x00B9, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 0x0088, 0x0061, 
	0x0000, 0xFF82, 0xFF04, 0xFEA4, 0xFE7D, 0xFF33, 0xFEFF, 0x0000, 0x0375, 
	0x0822, 0x0C6B, 0x0EB6, 0x0F1D, 0x0EDF, 0x0E1D, 0x0CF7, 0x0B8B, 0x09FA, 
	0x0863, 0x0580, 0x0197, 0xFF1E, 0xFEFA, 0xFFE8, 0x011D, 0x01CD, 0x01B5, 
	0x0148, 0x00C2, 0x0061, 0x0034, 0x001A, 0x000C, 0x0000, 0xFFF9, 0xFFFC, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFE, 0x5675, 0x5762, 0x55FE, 0x5283, 0x4DFD, 0x4978, 
	0x45FD, 0x4499, 0x458C, 0x4650, 0x46BE, 0x46D2, 0x46AF, 0x4669, 0x4614, 
	0x45B1, 0x453A, 0x44BA, 0x4438, 0x43BF, 0x4357, 0x430B, 0x4363, 0x440C, 
	0x43C6, 0x41F7, 0x3F60, 0x3CC7, 0x3AF4, 0x3A35, 0x3A17, 0x3A41, 0x3A5C, 
	0x3A50, 0x3A41, 0x3A36, 0x3A32, 0x3A3B, 0x3A55, 0x3A85, 0x3B5A, 0x3C7D, 
	0x3D5E, 0x3E50, 0x3F4E, 0x404F, 0x4150, 0x424A, 0x4337, 0x4411, 0x44D2, 
	0x4574, 0x45F1, 0x4502, 0x464D, 0x4988, 0x4DBB, 0x51EF, 0x552A, 0x5675, 
	0x0000, 0x009A, 0x0386, 0x0864, 0x0E41, 0x1428, 0x1924, 0x1C41, 0x1D3A, 
	0x1DB1, 0x1C9A, 0x1996, 0x1576, 0x10F0, 0x0CBD, 0x091C, 0x05B6, 0x0263, 
	0xFEFE, 0xFB5F, 0xF760, 0xF2DB, 0xEB13, 0xE187, 0xDC67, 0xDD09, 0xE052, 
	0xE5C4, 0xECE1, 0xFB74, 0x0B1C, 0x14DF, 0x1C57, 0x1E9E, 0x1853, 0x0CD8, 
	0x0373, 0xFED7, 0xFC44, 0xFAD7, 0xFB29, 0xFD9E, 0x01E8, 0x06E5, 0x0946, 
	0x0884, 0x068F, 0x02F6, 0x0013, 0x00BC, 0x02A4, 0x04E6, 0x06AA, 0x0508, 
	0x034B, 0x0245, 0x01AD, 0x0137, 0x009A, 0x0000, 0x0000, 0xFF40, 0xFE94, 
	0xFCE4, 0xFAB3, 0xF882, 0xF6D3, 0xF626, 0xF657, 0xF7B1, 0xF86D, 0xF7A6, 
	0xF63D, 0xF50C, 0xF4EF, 0xF5E2, 0xF73D, 0xF8E4, 0xFABA, 0xFCA3, 0xFE83, 
	0x003C, 0x0268, 0x0493, 0x0510, 0x0329, 0xFFF9, 0xFC86, 0xF9D8, 0xF8BC, 
	0xF956, 0xFBCF, 0xFF0B, 0x012B, 0x00FD, 0xFFB2, 0xFF02, 0xFFD3, 0x0140, 
	0x024B, 0x023E, 0x01A1, 0x00E4, 0x0009, 0xFF4C, 0xFEC1, 0xFE9B, 0xFF54, 
	0x000D, 0x002D, 0x002E, 0x001E, 0x000A, 0xFFFE, 0xFFFC, 0xFFF2, 0xFFD5, 
	0xFF9D, 0xFF40, 0x0000, 0x039F, 0x0309, 0x0363, 0x0444, 0x0569, 0x068E, 
	0x076F, 0x07C9, 0x04FF, 0x010E, 0xFF11, 0x0050, 0x031A, 0x0617, 0x07EF, 
	0x0890, 0x08DA, 0x08E3, 0x08C0, 0x0885, 0x0848, 0x081D, 0x07DE, 0x076B, 
	0x06E9, 0x0651, 0x05A1, 0x0502, 0x049C, 0x04F9, 0x05AF, 0x056F, 0x04C6, 
	0x0484, 0x0589, 0x076C, 0x0869, 0x0719, 0x051E, 0x04EE, 0x064C, 0x07BE, 
	0x07BB, 0x048C, 0x030E, 0x05D4, 0x078A, 0x05AC, 0x03D2, 0x03BD, 0x0402, 
	0x0473, 0x04E7, 0x0631, 0x05DD, 0x0514, 0x0425, 0x035D, 0x0309, 0x039F, 
	0x0000, 0x0078, 0xFDBB, 0xF6E6, 0xEE04, 0xE522, 0xDE4D, 0xDB91, 0xDDBB, 
	0xE485, 0xE9B3, 0xEA9F, 0xEA04, 0xE9BE, 0xEBA6, 0xEFB5, 0xF488, 0xF9EE, 
	0xFFB5, 0x05AD, 0x0BA5, 0x116B, 0x182C, 0x1F43, 0x23C9, 0x258A, 0x25FE, 
	0x24B9, 0x2151, 0x15E0, 0x081B, 0xFEF1, 0xF742, 0xF2EA, 0xF397, 0xF79A, 
	0xFBC4, 0xFFF0, 0x0456, 0x0656, 0x04A2, 0x00EA, 0xFC81, 0xF8B9, 0xF70C, 
	0xF868, 0xFADA, 0xFD74, 0xFF84, 0x0034, 0xFF19, 0xFC53, 0xF931, 0xFA33, 
	0xFA33, 0xFA33, 0xFA33, 0xFA33, 0xFA33, 0x0000, 0x0000, 0xFEE4, 0xFEE4, 
	0xFEE4, 0xFEE4, 0xFEE4, 0xFEE4, 0xFEE4, 0xFEA0, 0xFE3E, 0xFDA9, 0xFCA4, 
	0xFB57, 0xFA43, 0xF9E8, 0xFA44, 0xFAEC, 0xFBCB, 0xFCC9, 0xFDD0, 0xFECA, 
	0xFFA0, 0x006A, 0x0114, 0x0144, 0x00BC, 0xFFC7, 0xFEDE, 0xFE76, 0xFFF0, 
	0x014E, 0x0041, 0xFE7B, 0xFD6C, 0xFDE6, 0xFF17, 0xFFFF, 0x0030, 0x0018, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFC, 
	0xFFF8, 0xFFF4, 0xFFF3, 0xFFEE, 0xFFEA, 0x00BE, 0x006E, 0x0038, 0x0018, 
	0x0007, 0x0001, 0x0000, 0xEE2F, 0xEC4F, 0xEC4F, 0xEC4F, 0xEC4F, 0xEC4F, 
	0xEC4F, 0xEC4F, 0xEB32, 0xEB08, 0xEB84, 0xECA3, 0xEE47, 0xEFFA, 0xF145, 
	0xF21B, 0xF2C6, 0xF356, 0xF3DC, 0xF46A, 0xF50F, 0xF5DD, 0xF717, 0xF8B4, 
	0xFA56, 0xFBE1, 0xFD71, 0xFF00, 0x0089, 0x0227, 0x037B, 0x0439, 0x049B, 
	0x0469, 0x0388, 0x0256, 0x0147, 0x00B6, 0x008D, 0x00CD, 0x0208, 0x0337, 
	0x0371, 0x0355, 0x02E9, 0x01A8, 0x0069, 0xFFA2, 0xFF75, 0xFFB9, 0xFFBA, 
	0xFF0E, 0xFE3D, 0x0148, 0xF93C, 0xF3D7, 0xF092, 0xEEE4, 0xEE46, 0xEE2F, 
	0x0001, 0xFFFE, 0xC170, 0x1DCC, 0x2295, 0x1FA9, 0x1859, 0x0ED9, 0x0559, 
	0xFE08, 0xFB1C, 0xFB1C, 0xFB1C, 0xFB1C, 0xFB1C, 0xFB1C, 0xFB1C, 0xFB1C, 
	0xFB4A, 0xFBB5, 0xFC30, 0xFC8C, 0xFC9C, 0xFC30, 0xFB1C, 0xF984, 0xF7B4, 
	0xF5B2, 0xF387, 0xF13C, 0xEED8, 0xEC64, 0xE9E9, 0xE76D, 0xE4F9, 0xE296, 
	0xE04C, 0xDE22, 0xDC22, 0xDA52, 0xD8BC, 0xD768, 0xD65E, 0xD679, 0xD866, 
	0xDBE9, 0xE0C4, 0xE6BB, 0xF09D, 0xFE1C, 0x0A4F, 0x104C, 0x0EB2, 0x08C8, 
	0x00A2, 0xF854, 0xEAA7, 0xF078, 0xFE57, 0x0EE5, 0x1CC4, 0x2295, 0x1DCC, 
	0xD901, 0xD753, 0xD6FE, 0xD62A, 0xD517, 0xD404, 0xD330, 0xD2DB, 0xD2DB, 
	0xD2DB, 0xD2DB, 0xD2DB, 0xD2DB, 0xD2DB, 0xD2DB, 0xD2D5, 0xD2C8, 0xD2B9, 
	0xD2AE, 0xD2AC, 0xD2B9, 0xD2DB, 0xD30A, 0xD33A, 0xD36C, 0xD3A0, 0xD3D7, 
	0xD40F, 0xD449, 0xD485, 0xD4C3, 0xD503, 0xD545, 0xD589, 0xD5D0, 0xD618, 
	0xD663, 0xD6B0, 0xD6FF, 0xD750, 0xD7D3, 0xD893, 0xD95D, 0xD9FE, 0xDA42, 
	0xDA05, 0xD95F, 0xD878, 0xD774, 0xD618, 0xD457, 0xD2A2, 0xD169, 0xD790, 
	0xD790, 0xD78C, 0xD783, 0xD771, 0xD753, 0xD901, 0xB867, 0xB2E2, 0xC121, 
	0xCAAE, 0xD079, 0xD373, 0xD48B, 0xD4B3, 0xD4B3, 0xD4B3, 0xD4B3, 0xD4B3, 
	0xD4B3, 0xD4B3, 0xD4B3, 0xD492, 0xD448, 0xD3F2, 0xD3B2, 0xD3A7, 0xD3F2, 
	0xD4B3, 0xD5D1, 0xD71E, 0xD891, 0xDA24, 0xDBD0, 0xDD8E, 0xDF57, 0xE125, 
	0xE2F0, 0xE4B2, 0xE664, 0xE800, 0xE97D, 0xEAD6, 0xEC04, 0xECFF, 0xEDC1, 
	0xEE44, 0xEDDB, 0xEBEA, 0xE87A, 0xE39A, 0xDD55, 0xD249, 0xC307, 0xB582, 
	0xAFAE, 0xB36C, 0xBCBB, 0xC8BC, 0xD48E, 0xE2C8, 0xE266, 0xDFB7, 0xD86F, 
	0xCA42, 0xB2E2, 0xB867, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xC9F4, 0xCD1B, 0xCC9E, 0xCB67, 
	0xC9D3, 0xC83F, 0xC708, 0xC68B, 0xC707, 0xC83B, 0xCA4E, 0xD175, 0xDDCD, 
	0xE95C, 0xEE29, 0xE425, 0xD1A7, 0xC647, 0xC798, 0xCE34, 0xD63D, 0xDBD3, 
	0xDEF0, 0xE20D, 0xE50C, 0xE7D1, 0xEA3F, 0xEC37, 0xED9D, 0xEE54, 0xEE3E, 
	0xEC5E, 0xE85C, 0xE310, 0xDD55, 0xD805, 0xD3F8, 0xD14D, 0xD04B, 0xD20C, 
	0xD721, 0xDE4A, 0xE5E7, 0xEC56, 0xEFF5, 0xEF0D, 0xEAA2, 0xE52B, 0xE120, 
	0xDF36, 0xDE14, 0xDD22, 0xDBC6, 0xCD5D, 0xCD5D, 0xCD5D, 0xCD5D, 0xCD5D, 
	0xCD5D, 0xC9F4, 0x071C, 0x0745, 0x06BB, 0x0562, 0x03A2, 0x01E2, 0x008A, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0027, 
	0x0082, 0x00EA, 0x0138, 0x0145, 0x00EA, 0xFFFF, 0xFE81, 0xFC97, 0xFA5B, 
	0xF7E8, 0xF558, 0xF2C5, 0xF04C, 0xEE05, 0xEC0B, 0xEA2F, 0xE83E, 0xE64F, 
	0xE478, 0xE2D0, 0xE16E, 0xE067, 0xDFD4, 0xDFC9, 0xE134, 0xE45E, 0xE868, 
	0xEC73, 0xEFA1, 0xF1C0, 0xF358, 0xF4A7, 0xF5EA, 0xF728, 0xF84B, 0xF95B, 
	0xFA64, 0xFD88, 0xFD88, 0xFD88, 0xFD88, 0xFD88, 0xFD88, 0x071C, 0x0306, 
	0x0373, 0x02B6, 0x00DE, 0xFE77, 0xFC10, 0xFA38, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF96D, 0xF94E, 0xF92B, 0xF910, 
	0xF90B, 0xF92B, 0xF97B, 0xFA0A, 0xFAD0, 0xFBBB, 0xFCB9, 0xFDB8, 0xFEA5, 
	0xFF6F, 0x0002, 0x004D, 0x0041, 0xFFE9, 0xFF5A, 0xFEA6, 0xFDE3, 0xFD24, 
	0xFC7C, 0xFC00, 0xFBC3, 0xFC04, 0xFCC3, 0xFDB6, 0xFE94, 0xFF13, 0xFF10, 
	0xFEB7, 0xFE34, 0xFDB2, 0xFD35, 0xFCA9, 0xFC18, 0xFB8B, 0xFA43, 0xFB38, 
	0xFD7F, 0x0037, 0x027F, 0x0373, 0x0306, 0x0A90, 0x08C7, 0x06C3, 0x01B8, 
	0xFB29, 0xF49A, 0xEF8F, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED97, 0xEDB5, 0xEDDC, 0xEE03, 0xEE21, 0xEE2D, 0xEE1E, 0xEDEB, 0xED8B, 
	0xECDF, 0xEBE2, 0xEAAE, 0xE95F, 0xE811, 0xE6DD, 0xE5E0, 0xE534, 0xE4F5, 
	0xE5AF, 0xE77B, 0xE9C6, 0xEBFC, 0xED8B, 0xEE3E, 0xEE70, 0xEE60, 0xEE4C, 
	0xEE3C, 0xEE15, 0xEDE1, 0xEDAF, 0xED7B, 0xF052, 0xF717, 0xFF2B, 0x05F1, 
	0x08C7, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0x36DA, 0x3C0A, 0x0454, 0x34C9, 
	0x522D, 0x6145, 0x66D4, 0x67A0, 0x49A1, 0x284F, 0x0AA0, 0xFB99, 0xFD52, 
	0x821A, 0x856E, 0x800C, 0x7BEF, 0x73F5, 0x6D11, 0x6687, 0x5F8A, 0x574F, 
	0x4CC1, 0x4078, 0x342A, 0x2508, 0x13A1, 0x06BE, 0x0526, 0x0CE6, 0x172F, 
	0x237F, 0x3157, 0x4036, 0x4F9B, 0xDF06, 0xEDF7, 0xFBED, 0x0867, 0x12E6, 
	0x198E, 0x1BF8, 0x1BD0, 0x1AC6, 0x1A85, 0x1B32, 0x1BB0, 0x1BC8, 0x1B41, 
	0x19E4, 0x16BC, 0x11FD, 0x0D30, 0x06DB, 0xFC4E, 0xEE40, 0xDE51, 0xCE25, 
	0x3F5F, 0x36DA, 0x54F5, 0x561F, 0x2A1F, 0x2B02, 0x2CC0, 0x2F91, 0x33AD, 
	0x394D, 0x40BC, 0x49D8, 0x51D0, 0x56AE, 0x59C4, 0x2381, 0x211A, 0x2056, 
	0x2439, 0x2082, 0x2402, 0x28B7, 0x2D53, 0x308B, 0x3121, 0x3001, 0x2F19, 
	0x2EB0, 0x2E31, 0x2E3E, 0x2F7C, 0x31A5, 0x3403, 0x368E, 0x393F, 0x3C0E, 
	0x3EF5, 0x3E14, 0x3B14, 0x3811, 0x3514, 0x3224, 0x2F0C, 0x2BB3, 0x284B, 
	0x2502, 0x2209, 0x1F19, 0x1C12, 0x195E, 0x1768, 0x169B, 0x17D3, 0x1AD3, 
	0x1E61, 0x25E3, 0x2A1C, 0x2CAB, 0x2DFC, 0x2E78, 0x5176, 0x54F5, 0x175C, 
	0x19BC, 0xC6B0, 0xE4D3, 0xF71A, 0x007E, 0x03F4, 0x0472, 0xE1F6, 0xBDDB, 
	0xA028, 0xA624, 0xA2E5, 0x1DEB, 0x18D8, 0x13D4, 0x117F, 0x10C7, 0x0C07, 
	0x06D1, 0x0116, 0xFAC4, 0xF327, 0xEA8C, 0xE273, 0xD841, 0xCC58, 0xC4B8, 
	0xC760, 0xD2C1, 0xE0E4, 0xF129, 0x02F5, 0x15A0, 0x288E, 0xBB1F, 0xCCB6, 
	0xDCB1, 0xEA71, 0xF556, 0xF910, 0xF45F, 0xEB3C, 0xE1A3, 0xDB8C, 0xD940, 
	0xD819, 0xD7AA, 0xD785, 0xD740, 0xD72B, 0xD784, 0xD7BA, 0xD3A8, 0xD002, 
	0xCCD7, 0xC691, 0xB99A, 0x225C, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xCB60, 0xD0F3, 0xD0F3, 0xD0F3, 
	0xD0F3, 0xD0F3, 0xD0F3, 0xD0F3, 0xD2FB, 0xD4FC, 0xD6E3, 0xDBFF, 0xDDE0, 
	0xDF25, 0xE04F, 0xE120, 0xE189, 0xE1DE, 0xE251, 0xE2AF, 0xE2C3, 0xE258, 
	0xE08C, 0xDDC1, 0xDBAF, 0xDAA2, 0xD9CC, 0xD93E, 0xD90A, 0xD940, 0xD9D2, 
	0xDA99, 0xDB89, 0xDC96, 0xDDB2, 0xDED0, 0xDFE3, 0xE0DE, 0xE1B4, 0xE258, 
	0xE2F0, 0xE39F, 0xE452, 0xE4F8, 0xE57D, 0xE5D1, 0xE5E1, 0xE59B, 0xE4EC, 
	0xE3C3, 0xE025, 0xD9C3, 0xD30A, 0xCA39, 0xCA39, 0xCA39, 0xCA39, 0xCA39, 
	0xCA39, 0xCB60, 0xFA42, 0xFADB, 0xFC0E, 0xFD8D, 0xFF33, 0x00DA, 0x025E, 
	0x039A, 0x04A4, 0x05C9, 0x0709, 0x0E4F, 0x164A, 0x1E55, 0x2559, 0x26D5, 
	0x26FA, 0x29B0, 0x2CD3, 0x3004, 0x32E1, 0x350C, 0x3680, 0x36B5, 0x3480, 
	0x2F86, 0x28F1, 0x21DC, 0x1B65, 0x16A8, 0x134C, 0x1036, 0x0D63, 0x0AD0, 
	0x087B, 0x0660, 0x047C, 0x02CC, 0x014F, 0xFFFF, 0xFEF7, 0xFE47, 0xFDDF, 
	0xFDB2, 0xFDB1, 0xFDCC, 0xFDF6, 0xFE20, 0xFE3B, 0xFE39, 0xFE3B, 0xFE60, 
	0xFE97, 0xFF44, 0xFF2F, 0xFEA0, 0xFD1A, 0xFA22, 0xF53D, 0xFA42, 0x0197, 
	0x00D7, 0x016A, 0x02F8, 0x0543, 0x080E, 0x0B1B, 0x0E2C, 0x1117, 0x13D3, 
	0x1640, 0x1878, 0x173D, 0x1570, 0x14D2, 0x1ABC, 0x1F2D, 0x1B42, 0x15FC, 
	0x1083, 0x0C00, 0x099A, 0x0CA5, 0x136C, 0x178E, 0x175E, 0x15D4, 0x1389, 
	0x1118, 0x0F19, 0x0D7A, 0x0BC7, 0x0A0A, 0x084D, 0x069A, 0x04FA, 0x0378, 
	0x021C, 0x00F0, 0xFFFF, 0xFF50, 0xFEDA, 0xFE95, 0xFE77, 0xFE76, 0xFE88, 
	0xFEA4, 0xFEC0, 0xFED2, 0xFED1, 0xFED2, 0xFEEB, 0xFF0F, 0xFF82, 0xFFAD, 
	0xFFC7, 0xFFD4, 0xFFD9, 0xFFDA, 0x0197, 0x0624, 0x03AA, 0x0280, 0xFF91, 
	0xFBB4, 0xF7BC, 0xF47E, 0xF2D0, 0xF29B, 0xF296, 0xF2CF, 0xF93C, 0xFDEE, 
	0x0243, 0x05E7, 0x05FC, 0x04C8, 0x044D, 0x03B1, 0x0340, 0x0348, 0x0417, 
	0x0803, 0x0D87, 0x0F24, 0x0B13, 0x0469, 0xFCF0, 0xF673, 0xF2BE, 0xF167, 
	0xF0C1, 0xF0AB, 0xF106, 0xF1B0, 0xF289, 0xF372, 0xF44B, 0xF4F2, 0xF548, 
	0xF566, 0xF57A, 0xF585, 0xF58A, 0xF58B, 0xF587, 0xF583, 0xF57E, 0xF57B, 
	0xF57B, 0xF57B, 0xF577, 0xF571, 0xF55D, 0xF727, 0xFB6B, 0x0084, 0x04C8, 
	0x0692, 0x0624, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x00AB, 0x0157, 0x0000, 0xF7B5, 0xF0EC, 0xF231, 0xF553, 0xF956, 0xFD39, 
	0xFFFF, 0x00D6, 0x006B, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xBF5E, 0xBF5E, 0xBF5E, 0xBF5F, 0xBF5F, 0xBF60, 0xBF61, 
	0xBF61, 0xBF61, 0xBF61, 0xBF5E, 0xBF55, 0xBF4A, 0xBF3E, 0xBF30, 0xBF21, 
	0xBF14, 0xBF11, 0xBF1F, 0xBF2C, 0xBF40, 0xBF5E, 0xBF9C, 0xBFEF, 0xC049, 
	0xC0A1, 0xC0F6, 0xC152, 0xC1C0, 0xC513, 0xC880, 0xC3A3, 0xA548, 0x86BC, 
	0x7EFA, 0x7F58, 0x86BC, 0x9945, 0xB2D2, 0xC5E3, 0xC7B7, 0xBF5E, 0xB4D6, 
	0xA856, 0x9B70, 0x8FB6, 0x86BC, 0x82E6, 0x83C8, 0x86BC, 0x8B26, 0x91A2, 
	0x995F, 0xA3DC, 0xB06A, 0xBAF2, 0xBF5E, 0xFE9B, 0x0210, 0xFE3E, 0xF4B4, 
	0xE84E, 0xDBE7, 0xD25D, 0xCE8C, 0xD137, 0xE1A9, 0xF3A4, 0xF975, 0xFB58, 
	0xFB0A, 0xF86A, 0xF398, 0xEEBB, 0xEA59, 0xE7EF, 0xE691, 0xE587, 0xE7D2, 
	0xF22B, 0xFEB0, 0x06ED, 0x01EF, 0xFAB0, 0xF3B9, 0xEF95, 0xF0E2, 0xF5B3, 
	0xF9BB, 0xFA96, 0xFAA3, 0xFB38, 0xFBDF, 0xFCBD, 0xFEC2, 0x00FE, 0x00CE, 
	0xF8C8, 0xF155, 0xF2DA, 0xF74E, 0xFB1C, 0xFC6C, 0xFCBD, 0xFD54, 0xFDB0, 
	0xFC96, 0xF95C, 0xF4AC, 0xEF4B, 0xD92B, 0xDD22, 0xE695, 0xF1DD, 0xFB50, 
	0xFF47, 0xFE9B, 0xEFF9, 0xE9CC, 0xEB10, 0xEE74, 0xF359, 0xF924, 0xFF36, 
	0x04F2, 0x085C, 0x00FE, 0xF8CC, 0xFB21, 0x00AC, 0x0597, 0x088D, 0x0AE3, 
	0x0CC3, 0x0C67, 0x0A3F, 0x07AE, 0x0574, 0x0256, 0xFC90, 0xF678, 0xF381, 
	0xF74D, 0xFC5B, 0x00FF, 0x0390, 0x01D0, 0xFD5C, 0xFA4E, 0xFBFC, 0xFE9C, 
	0xFEFE, 0xFED2, 0xFEC7, 0xFF2F, 0xFFB8, 0x001F, 0x0045, 0x0000, 0xFF0E, 
	0xFDE0, 0xFD29, 0xFDBB, 0xFEC7, 0xFFA9, 0x0081, 0x00B1, 0x002A, 0xFEFC, 
	0xFCBC, 0xEE47, 0xEE98, 0xEF58, 0xF03E, 0xF0FE, 0xF14F, 0xEFF9, 0x839E, 
	0x87DB, 0xA084, 0xB0BA, 0xBA61, 0xBF5D, 0xC191, 0xC2E2, 0xC40D, 0xBE72, 
	0xB854, 0xB969, 0xBC8B, 0xBDD3, 0xBB4D, 0xB6ED, 0xB2AB, 0xAFA1, 0xB2C1, 
	0xB743, 0xBC4F, 0xC0C7, 0xC300, 0xC3C8, 0xC188, 0xC41B, 0xC7F4, 0xCA7D, 
	0xC91F, 0xBCC0, 0xAAFA, 0xA446, 0xBF42, 0xDEC0, 0xE7A8, 0xE97F, 0xE6FC, 
	0xDF64, 0xD372, 0xC806, 0xBCBC, 0xB751, 0xBD60, 0xC820, 0xD311, 0xDD47, 
	0xE6FC, 0xF064, 0xF929, 0xFDB9, 0xFCA8, 0xF762, 0xEE9A, 0xBC96, 0xAA66, 
	0xA593, 0xA534, 0xA061, 0x8E31, 0x839E, 0x0000, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 0x0763, 
	0x0763, 0x0000, 0xFFFF, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 
	0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0x0A1C, 0xFFFF, 0x49EE, 
	0x4865, 0x43B1, 0x3CD6, 0x352B, 0x2E08, 0x28C4, 0x26B6, 0x27C8, 0x264B, 
	0x2124, 0x16EC, 0x0AF3, 0x0377, 0x0404, 0x090E, 0x0E27, 0x1215, 0x101D, 
	0x0D17, 0x0A51, 0x091A, 0x0C3B, 0x120E, 0x1947, 0x2303, 0x2DB4, 0x36F3, 
	0x3C5B, 0x3B34, 0x34A4, 0x2C10, 0x1D0C, 0x1211, 0x16B0, 0x20EB, 0x2A1A, 
	0x2F78, 0x33CB, 0x38C5, 0x43F9, 0x4770, 0x3437, 0x1978, 0x08BD, 0x1649, 
	0x2A1A, 0x2CFA, 0x2B67, 0x2A1A, 0x2B14, 0x2C55, 0x2C91, 0x263B, 0x2934, 
	0x3084, 0x39C2, 0x4285, 0x4865, 0x49EE, 0xF7AE, 0xFEFB, 0xFFC6, 0x0013, 
	0x001D, 0x0028, 0x0073, 0x013F, 0xFFD6, 0xFD09, 0xFA48, 0xF911, 0xF86A, 
	0xF84B, 0xFAD8, 0xFE1F, 0x0192, 0x04E3, 0x032E, 0x005A, 0xFD0A, 0xFA4E, 
	0xF9F0, 0xFA66, 0xFAD5, 0xFB20, 0xFB63, 0xFBAC, 0xFC0B, 0xFC86, 0xFD1E, 
	0xFDD7, 0xFF02, 0xFFFF, 0x0031, 0x0018, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFD, 0xFFEE, 0xFFC7, 0xFF7A, 
	0xFEFB, 0xF7AE, 0x03C6, 0x0B44, 0x0A8D, 0x08C5, 0x0675, 0x0424, 0x025C, 
	0x01A6, 0x01C5, 0x0122, 0x0066, 0x0067, 0x009F, 0x00C4, 0x0077, 0xFFEC, 
	0xFFB8, 0xFFE7, 0x0017, 0x002D, 0x0003, 0xFFA8, 0xFF06, 0xFE63, 0xFE4B, 
	0xFE68, 0xFE8D, 0xFEB6, 0xFEDE, 0xFF03, 0xFF2A, 0xFF5C, 0xFFB4, 0xFFFF, 
	0x000E, 0x0007, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x012C, 0x03F7, 0x074D, 0x0A18, 0x0B44, 0x03C6, 0xAB92, 
	0xAA07, 0xB043, 0xB41C, 0xB640, 0xB761, 0xB82F, 0xB958, 0xBA91, 0xB5DB, 
	0xB32D, 0xBAD8, 0xC607, 0xCF9C, 0xCF7D, 0xCC1C, 0xC80A, 0xC448, 0xC399, 
	0xC396, 0xC41E, 0xC3C1, 0xC002, 0xBBE7, 0xBBD5, 0xBD97, 0xBF93, 0xC1C0, 
	0xC416, 0xC744, 0xCABF, 0xCCA8, 0xCAB8, 0xC695, 0xC0BE, 0xBA84, 0xB923, 
	0xC185, 0xCEBF, 0xD749, 0xD194, 0xC836, 0xC430, 0xC0B5, 0xBDBB, 0xBB38, 
	0xB923, 0xB835, 0xB88A, 0xB923, 0xB9C0, 0xBAA1, 0xBB8E, 0xBED5, 0xBEAB, 
	0xBD80, 0xBA57, 0xB42E, 0xAA07, 0xAB92, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x0792, 0x0783, 0x071C, 
	0x0604, 0x03E2, 0x005E, 0xFB1F, 0x05E9, 0x132C, 0x1B09, 0x1C7D, 0x1CBC, 
	0x1CB0, 0x1B89, 0x18C5, 0x14E6, 0x10A8, 0x0BF8, 0x06CF, 0x01F8, 0xFE40, 
	0xFC80, 0xFC44, 0xFC61, 0xFC67, 0xFCA2, 0xFD09, 0xFD92, 0xFE77, 0xFF9E, 
	0x007B, 0x0089, 0x003E, 0x0003, 0x0034, 0x0068, 0x0070, 0x006B, 0x0063, 
	0x0052, 0x0068, 0x007C, 0x0090, 0x00A1, 0x00A8, 0x00B5, 0x008E, 0x0070, 
	0x012F, 0x0315, 0x0597, 0x0856, 0x0FA6, 0x0F93, 0x0F11, 0x0DB0, 0x0B00, 
	0x0692, 0x01C0, 0x1192, 0x10B4, 0x109B, 0x0FED, 0x0E15, 0x0A7C, 0x048E, 
	0xFBB5, 0x01B8, 0x0920, 0x1144, 0x16D4, 0x15F5, 0x13F8, 0x1378, 0x1719, 
	0x1C35, 0x1D75, 0x189E, 0x10BD, 0x086B, 0x023F, 0xFFC0, 0xFF8A, 0xFFCE, 
	0xFFFC, 0x0086, 0x0127, 0x0195, 0x01CB, 0x01D3, 0x017F, 0x003A, 0xFEBC, 
	0xFE70, 0xFE8A, 0xFEC7, 0xFF28, 0xFF97, 0xFFE0, 0xFF57, 0xFEC7, 0xFEBE, 
	0xFECF, 0xFEE0, 0xFEE0, 0xFEEC, 0xFF07, 0xFF2E, 0xFF7F, 0xFFE2, 0x004C, 
	0x00EF, 0x0796, 0x0B6F, 0x0D5B, 0x0E33, 0x0ED3, 0x1015, 0x1192, 0x842B, 
	0x829F, 0x8C7B, 0x91DA, 0x9468, 0x95D3, 0x97C7, 0x9BF2, 0xA451, 0xAD39, 
	0xAC43, 0xA98C, 0xA5CE, 0xA1DB, 0x9DAF, 0x98AE, 0x9373, 0x8FD5, 0x8E6D, 
	0x8E27, 0x8E54, 0x8E43, 0x8CD9, 0x8B69, 0x8CEB, 0x91FC, 0x98E2, 0xA115, 
	0xAA0D, 0xB546, 0xC22D, 0xCD20, 0xD33A, 0xD5E0, 0xD2B0, 0xC11D, 0xAFFC, 
	0xA568, 0x9D51, 0x97F2, 0xA038, 0xA705, 0xB7AD, 0xC992, 0xD1C0, 0xBEE8, 
	0xA563, 0x9930, 0x90C4, 0x8D5A, 0x8F91, 0x957A, 0x9C74, 0xA3EC, 0xA3AF, 
	0xA1FE, 0x9D67, 0x9476, 0x85BA, 0x842B, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x4A21, 0x4865, 0x4331, 0x3A86, 0x2F41, 0x2696, 0x2163, 
	0x1FA7, 0x19E6, 0x1869, 0x1E4A, 0x1CB0, 0x19A1, 0x1738, 0x1791, 0x1D78, 
	0x2706, 0x2F49, 0x3571, 0x3B3D, 0x3F92, 0x4153, 0x3DE3, 0x3687, 0x2FF7, 
	0x2B16, 0x264E, 0x22AC, 0x213D, 0x24AC, 0x2B64, 0x300E, 0x2E11, 0x2A83, 
	0x2C35, 0x3C97, 0x469F, 0x3CB7, 0x2B76, 0x1B99, 0x159A, 0x24CE, 0x2738, 
	0x276D, 0x2AD0, 0x3A09, 0x469F, 0x435F, 0x3A99, 0x3240, 0x2BB3, 0x250C, 
	0x1F50, 0x236E, 0x2AEE, 0x3365, 0x3BC9, 0x4310, 0x4830, 0x4A21, 0x09D3, 
	0x012A, 0x012F, 0x013A, 0x0148, 0x0157, 0x0162, 0x0166, 0x0115, 0x014D, 
	0x04FE, 0x004F, 0xFA2D, 0xF449, 0xF053, 0xEFF1, 0xF1FD, 0xF3F4, 0xF50C, 
	0xF61C, 0xF718, 0xF7F4, 0xF894, 0xF901, 0xF96A, 0xF9D7, 0xFA3C, 0xFAA9, 
	0xFB2F, 0xFC5D, 0xFCD5, 0xFD63, 0xFEAF, 0xFFFF, 0x003A, 0x0020, 0xFFFF, 
	0xFFFA, 0xFFFD, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x002A, 0x0055, 0x0000, 0xFEE4, 0xFD5C, 0xFBD6, 0xFB9B, 0xFC79, 
	0xFE8B, 0x0104, 0x0315, 0x03F3, 0x09D3, 0xFE32, 0xF9F7, 0xFC23, 0xFD98, 
	0xFE7A, 0xFEEE, 0xFF19, 0xFF1F, 0xFF1E, 0xFF20, 0xFF31, 0xFFD6, 0x009E, 
	0x014A, 0x0198, 0x011D, 0x0023, 0xFF7A, 0xFF6A, 0xFF95, 0xFFD3, 0xFFFE, 
	0x000A, 0x000B, 0x000B, 0x0017, 0x002A, 0x002D, 0x0009, 0xFED5, 0xFF5A, 
	0x0005, 0x0015, 0xFFFF, 0x000A, 0x0005, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFA, 0xFFF4, 
	0xFFFF, 0x002D, 0x006F, 0x00A6, 0xFF90, 0xFF8C, 0xFF6F, 0xFF21, 0xFE8A, 
	0xFD90, 0xFE32, 0xABC3, 0xAD06, 0xB805, 0xBF64, 0xC3DD, 0xC629, 0xC701, 
	0xC720, 0xC6B5, 0xC621, 0xC48B, 0xC724, 0xCA8E, 0xCD9A, 0xCF19, 0xCD5F, 
	0xC997, 0xC6D3, 0xC61B, 0xC61B, 0xC662, 0xC680, 0xC65E, 0xC635, 0xC609, 
	0xC64E, 0xC6DC, 0xC6D4, 0xC553, 0xB964, 0xBE4E, 0xC469, 0xC4F7, 0xC1B1, 
	0xB3AC, 0xAF35, 0xAF5C, 0xB4B9, 0xBC6F, 0xC352, 0xC502, 0xC695, 0xB5FC, 
	0xC937, 0xD966, 0xC9B9, 0xB6B1, 0xB3B4, 0xB587, 0xB8BA, 0xBCA2, 0xC1D2, 
	0xC6C5, 0xC36A, 0xC093, 0xBF22, 0xBD24, 0xB8A6, 0xAFB2, 0xABC3, 

},{ 
	0x003A, 0x0000, 0x003A, 0x003A, 0x0039, 0x0074, 0x0001, 0x00AD, 0x0001, 
	0x00AE, 0x0001, 0x00AF, 0x0037, 0x00B0, 0x003C, 0x00E7, 0x003C, 0x0123, 
	0x003C, 0x015F, 0x003C, 0x019B, 0x003C, 0x01D7, 0x003C, 0x0213, 0x003C, 
	0x024F, 0x003C, 0x028B, 0x0001, 0x02C7, 0x0001, 0x02C8, 0x0001, 0x02C9, 
	0x003C, 0x02CA, 0x003C, 0x0306, 0x003C, 0x0342, 0x003C, 0x037E, 0x003B, 
	0x03BA, 0x003C, 0x03F5, 0x003C, 0x0431, 0x003C, 0x046D, 0x003C, 0x04A9, 
	0x0001, 0x04E5, 0x0001, 0x04E6, 0x0001, 0x04E7, 0x003C, 0x04E8, 0x003C, 
	0x0524, 0x003C, 0x0560, 0x0027, 0x059C, 0x003C, 0x05C3, 0x003C, 0x05FF, 
	0x003C, 0x063B, 0x003C, 0x0677, 0x003C, 0x06B3, 0x003C, 0x06EF, 0x0039, 
	0x072B, 0x0039, 0x0764, 0x003C, 0x079D, 0x003C, 0x07D9, 0x003C, 0x0815, 
	0x003C, 0x0851, 0x003C, 0x088D, 0x003C, 0x08C9, 0x003C, 0x0905, 0x003C, 
	0x0941, 0x003C, 0x097D, 0x0028, 0x09B9, 0x0028, 0x09E1, 0x0001, 0x0A09, 
	0x003C, 0x0A0A, 0x003C, 0x0A46, 0x003C, 0x0A82, 0x0001, 0x0ABE, 0x0020, 
	0x0ABF, 0x003C, 0x0ADF, 0x003C, 0x0B1B, 0x003C, 0x0B57, 0x003C, 0x0B93, 
	

});

smlua_anim_util_register_animation('donkey_10_stop_skid',1, 0, 0, 0, 18, { 
	0x0000, 0x007C, 0x007C, 0x007D, 0x007D, 0x007E, 0x007F, 0x0080, 0x0081, 
	0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 
	0xFFDD, 0xFFDD, 0xFFDE, 0xFFE0, 0xFFE1, 0xFFE4, 0xFFE6, 0xFFE9, 0xFFEC, 
	0xFFEF, 0xFFF1, 0xFFF4, 0xFFF7, 0xFFF9, 0xFFFC, 0xFFFD, 0xFFFF, 0x0000, 
	0x0000, 0x3FFF, 0x0000, 0x2475, 0x241F, 0x2329, 0x21A9, 0x1FB3, 0x1D5A, 
	0x1AB3, 0x17D3, 0x14CE, 0x11B8, 0x0EA5, 0x0BAB, 0x08DC, 0x064E, 0x0414, 
	0x0244, 0x00F1, 0x0030, 0xFFFF, 0xFA1D, 0xFA2C, 0xFA58, 0xFA9B, 0xFAF3, 
	0xFB5B, 0xFBD1, 0xFC50, 0xFCD4, 0xFD5B, 0xFDDF, 0xFE5E, 0xFED4, 0xFF3D, 
	0xFF94, 0xFFD8, 0x0004, 0x0013, 0xFFFE, 0x3A1E, 0x3A67, 0x3B35, 0x3C78, 
	0x3E1C, 0x4010, 0x4242, 0x44A2, 0x471B, 0x499E, 0x4C18, 0x4E77, 0x50AA, 
	0x529E, 0x5442, 0x5584, 0x5652, 0x569B, 0x5675, 0x0000, 0xFFFF, 0xFE8E, 
	0xFB15, 0xF6E1, 0xF33B, 0xF16E, 0xF438, 0xF9B2, 0xFC32, 0xF8E4, 0xF2CF, 
	0xED0F, 0xEF02, 0xF3A9, 0xF936, 0xFDDD, 0xFFD1, 0x0000, 0x06ED, 0x06ED, 
	0x0761, 0x088C, 0x0A25, 0x0BE2, 0x0D79, 0x0F9D, 0x120D, 0x1316, 0x1238, 
	0x1065, 0x0E12, 0x0B4E, 0x0851, 0x0566, 0x02D2, 0x00E0, 0x0000, 0x0CFE, 
	0x0CFE, 0x0D78, 0x0EC3, 0x10AD, 0x1305, 0x1599, 0x1A4C, 0x2054, 0x2374, 
	0x225A, 0x1F41, 0x1B4E, 0x163D, 0x1090, 0x0B18, 0x06A9, 0x0416, 0x039F, 
	0xE0E9, 0xE0E9, 0xE0D4, 0xE0DF, 0xE17C, 0xE31D, 0xE633, 0xEB46, 0xF20B, 
	0xF9BA, 0x0189, 0x08AF, 0x0E63, 0x0D4C, 0x0A93, 0x0710, 0x0396, 0x00FB, 
	0x0000, 0xF9D4, 0xF9D4, 0xFAE9, 0xFD8A, 0x00C3, 0x03A5, 0x053D, 0x0590, 
	0x055D, 0x04C8, 0x03FA, 0x0318, 0x0249, 0x0157, 0x0053, 0xFF65, 0xFEB8, 
	0xFE75, 0x0000, 0x02C2, 0x02C2, 0x0287, 0x01F1, 0x012E, 0x0068, 0xFFCB, 
	0xFF52, 0xFEDA, 0xFE66, 0xFDF8, 0xFD92, 0xFD37, 0xFCE9, 0xFC05, 0xF9BB, 
	0xF53B, 0xEDB5, 0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xDFFF, 0xDFFF, 0xDFBF, 
	0xDF3D, 0xDEDB, 0xDEFB, 0xDFFF, 0xE1DD, 0xE435, 0xE6E9, 0xE9D8, 0xECE5, 
	0xEFEE, 0xF839, 0x048B, 0x1183, 0x1BC4, 0x1FEE, 0x19C6, 0xECD8, 0xECD8, 
	0xEA14, 0xE363, 0xDB2F, 0xD3E2, 0xCFE7, 0xCEAF, 0xCE03, 0xCDCC, 0xCDF7, 
	0xCE6D, 0xCF19, 0xD0E6, 0xD385, 0xD644, 0xD86D, 0xD94E, 0xDC99, 0xE269, 
	0xE269, 0xE2B1, 0xE34F, 0xE3EE, 0xE43A, 0xE3DD, 0xE2E4, 0xE1A0, 0xE024, 
	0xDE81, 0xDCCB, 0xDB14, 0xD9EE, 0xD806, 0xD37B, 0xCA6F, 0xBB01, 0xBCE3, 
	0xFFFF, 0xFFFE, 0xFFFD, 0xFFFB, 0xFFF8, 0xFFF4, 0xFFF0, 0xFFEC, 0xFFE7, 
	0xFFE3, 0xFFDE, 0xFFDA, 0xFFD6, 0xFFD2, 0xFFCF, 0xFFCD, 0xFFCC, 0xFFCB, 
	0xFFFF, 0xFFFF, 0x0006, 0x0018, 0x0033, 0x0057, 0x0081, 0x00B1, 0x00E4, 
	0x011A, 0x0150, 0x0186, 0x01B9, 0x01E9, 0x0213, 0x0237, 0x0252, 0x0264, 
	0x026A, 0x0000, 0xC484, 0xC484, 0xC69F, 0xCBAA, 0xD1BC, 0xD6EA, 0xD94B, 
	0xD948, 0xD8A7, 0xD786, 0xD602, 0xD43B, 0xD24F, 0xD13E, 0xD0BB, 0xD011, 
	0xCE8B, 0xCB72, 0xCC9F, 0xFF89, 0xFF89, 0xFF88, 0xFF86, 0xFF85, 0xFF85, 
	0xFF89, 0xFF92, 0xFF9C, 0xFFA8, 0xFFB4, 0xFFC2, 0xFFCF, 0xFFC8, 0xFF94, 
	0xFF07, 0xFDF5, 0xFC32, 0x04C7, 0xF97F, 0xF97F, 0xF97F, 0xF97F, 0xF97F, 
	0xF97F, 0xF97F, 0xF97F, 0xF97E, 0xF97E, 0xF97D, 0xF97D, 0xF97C, 0xF99C, 
	0xF9E9, 0xFA45, 0xFA92, 0xFAB3, 0x0306, 0xF06E, 0xF06E, 0xF075, 0xF083, 
	0xF08D, 0xF08A, 0xF06E, 0xF03B, 0xEFFB, 0xEFB2, 0xEF61, 0xEF0E, 0xEEBB, 
	0xF142, 0xF747, 0xFE77, 0x047E, 0x0705, 0x0A90, 0xFFFE, 0x0001, 0xC170, 
	0x4CE0, 0x4CE0, 0x4D82, 0x4EC3, 0x4FAA, 0x4F3F, 0x4C88, 0x479C, 0x4170, 
	0x3A56, 0x22A2, 0x05EB, 0xEA52, 0x523E, 0x4016, 0x3575, 0x30CD, 0x2FC5, 
	0x36DA, 0x2C94, 0x2C94, 0x29BD, 0x22F5, 0x1ADD, 0x1411, 0x1131, 0x11AD, 
	0x131A, 0x1548, 0x1E73, 0x2866, 0x306D, 0x4A35, 0x4841, 0x4BC7, 0x5252, 
	0x55D8, 0x54F5, 0x0951, 0x0951, 0x09ED, 0x0B27, 0x0C1E, 0x0BEE, 0x09B7, 
	0x058D, 0x004F, 0xFA43, 0xE60A, 0xC7AE, 0xAC99, 0x190E, 0x1150, 0x111C, 
	0x1118, 0x10E3, 0x175C, 0x0000, 0x000B, 0x002A, 0x005A, 0x009A, 0x00E6, 
	0x013D, 0x019A, 0x01FD, 0x0263, 0x02C8, 0x032B, 0x0389, 0x03DF, 0x042B, 
	0x046B, 0x049B, 0x04BA, 0x04C5, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xC897, 0xC897, 0xCBB0, 0xD314, 
	0xDBE4, 0xE344, 0xE655, 0xE5B2, 0xE404, 0xE1A7, 0xDED0, 0xDBAC, 0xD866, 
	0xD529, 0xD221, 0xCF7A, 0xCD5F, 0xCBFC, 0xCB7B, 0x0000, 0x0000, 0xFFC0, 
	0xFF2A, 0xFE77, 0xFDE0, 0xFDA1, 0xFDAD, 0xFDCE, 0xFE2A, 0xFEBF, 0xFF7A, 
	0x004A, 0x011C, 0x01DE, 0x027E, 0x02EC, 0x0315, 0xFA42, 0x0000, 0xFFFF, 
	0x00FC, 0x0357, 0x0626, 0x0881, 0x097E, 0x094E, 0x08CA, 0x0860, 0x081C, 
	0x07EA, 0x07B7, 0x076C, 0x06F7, 0x0644, 0x053C, 0x03CD, 0x0197, 0xED8B, 
	0xED8B, 0xEA8F, 0xE379, 0xDB15, 0xD42E, 0xD18F, 0xD2A4, 0xD4D6, 0xD919, 
	0xDF45, 0xE6B6, 0xEEC7, 0xF6D2, 0xFE33, 0x0445, 0x0862, 0x09E6, 0x0624, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xBF5E, 0xFFB7, 0xFFB7, 0x0001, 0x0096, 0x0106, 0x00E1, 0xFFB7, 
	0xFC9F, 0xF7D8, 0xF2AE, 0xEE70, 0xEAD4, 0xE6E3, 0xE95A, 0xEF3B, 0xF63E, 
	0xFC1F, 0xFE96, 0xFE9B, 0x0050, 0x0050, 0x009D, 0x0137, 0x01AA, 0x0184, 
	0x0050, 0xFCC4, 0xF740, 0xF1CD, 0xEE72, 0xED1C, 0xEC47, 0xEC96, 0xED53, 
	0xEE35, 0xEEF2, 0xEF42, 0xEFF9, 0x82F6, 0x82F6, 0x82BF, 0x8250, 0x81FC, 
	0x8218, 0x82F6, 0x84F8, 0x8808, 0x8BC8, 0x8FD9, 0x949D, 0x9A5D, 0x9A32, 
	0x9900, 0x95C1, 0x8F70, 0x8506, 0x839E, 0x0000, 0xFFFE, 0xFFFC, 0xFFF8, 
	0xFFF4, 0xFFEE, 0xFFE8, 0xFFE1, 0xFFDA, 0xFFD3, 0xFFCC, 0xFFC5, 0xFFBF, 
	0xFFB9, 0xFFB4, 0xFFB1, 0xFFAE, 0xFFAE, 0x0000, 0xFFFF, 0x0005, 0x0015, 
	0x002C, 0x004B, 0x0070, 0x009A, 0x00C6, 0x00F5, 0x0124, 0x0153, 0x0180, 
	0x01A9, 0x01CE, 0x01ED, 0x0205, 0x0214, 0x021A, 0xFFFF, 0x5730, 0x5730, 
	0x5816, 0x5A1F, 0x5C53, 0x5DB6, 0x5D4C, 0x59D9, 0x53ED, 0x4D48, 0x47A7, 
	0x42B2, 0x3D29, 0x3DDD, 0x3FB7, 0x4251, 0x4545, 0x482C, 0x49EE, 0x011B, 
	0x011B, 0x00EC, 0x008C, 0x0040, 0x004C, 0x00F4, 0x0325, 0x0698, 0x09C2, 
	0x0B1B, 0x0A91, 0x0948, 0x0699, 0x02DD, 0xFECB, 0xFB19, 0xF87D, 0xF792, 
	0xFFC7, 0xFFC7, 0xFF4B, 0xFE23, 0xFCC1, 0xFB98, 0xFB19, 0xFBB9, 0xFD2A, 
	0xFEB4, 0xFFA4, 0xFFF6, 0x0025, 0x00E9, 0x02BC, 0x04EA, 0x06BE, 0x0782, 
	0x03C6, 0xAA71, 0xAA71, 0xAA1E, 0xA968, 0xA8B3, 0xA864, 0xA8DF, 0xAAD7, 
	0xAE0B, 0xB173, 0xB405, 0xB5E4, 0xB7D0, 0xB7B4, 0xB6EC, 0xB4CF, 0xB0B0, 
	0xA9E5, 0xAB92, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x1711, 0x1711, 0x14EE, 0x0FBD, 0x0951, 
	0x0381, 0x0020, 0x0020, 0x0021, 0x0024, 0x0029, 0x0032, 0x003E, 0x0050, 
	0x0068, 0x0087, 0x00AD, 0x00DC, 0x01C0, 0x1373, 0x1373, 0x145A, 0x168F, 
	0x1950, 0x1BDE, 0x1D79, 0x1D3D, 0x1C98, 0x1B9F, 0x1A67, 0x1904, 0x178C, 
	0x1614, 0x14B0, 0x1375, 0x1279, 0x11D1, 0x1192, 0xA1B5, 0xA1B5, 0x9E4A, 
	0x95EC, 0x8B6E, 0x81A6, 0x7B67, 0x7B98, 0x7C21, 0x7CED, 0x7DE9, 0x7F02, 
	0x8025, 0x813E, 0x823B, 0x8307, 0x838F, 0x83C1, 0x842B, 0xFFFF, 0xFFFD, 
	0xFFF9, 0xFFF2, 0xFFE9, 0xFFDF, 0xFFD3, 0xFFC6, 0xFFB8, 0xFFAB, 0xFF9D, 
	0xFF90, 0xFF84, 0xFF7A, 0xFF71, 0xFF6A, 0xFF65, 0xFF64, 0xFFFF, 0x0000, 
	0xFFFB, 0xFFF1, 0xFFE0, 0xFFCA, 0xFFB0, 0xFF93, 0xFF73, 0xFF53, 0xFF31, 
	0xFF10, 0xFEF1, 0xFED4, 0xFEBA, 0xFEA4, 0xFE93, 0xFE89, 0xFE85, 0x0000, 
	0x091A, 0x091A, 0x0EA4, 0x1C48, 0x2D8C, 0x3DF7, 0x4911, 0x492A, 0x493A, 
	0x4943, 0x4947, 0x4948, 0x4948, 0x4949, 0x494D, 0x4956, 0x4966, 0x497F, 
	0x4A21, 0xFF56, 0xFF56, 0xFF5C, 0xFF63, 0xFF54, 0xFF1D, 0xFEA9, 0xFEC6, 
	0xFF14, 0xFF89, 0x001B, 0x00BC, 0x0163, 0x0205, 0x0295, 0x030A, 0x0359, 
	0x0375, 0x09D3, 0xFC90, 0xFC90, 0xFC15, 0xFAEC, 0xF981, 0xF841, 0xF796, 
	0xF7A3, 0xF7C7, 0xF7FD, 0xF840, 0xF88A, 0xF8D7, 0xF921, 0xF963, 0xF999, 
	0xF9BD, 0xF9CA, 0xFE32, 0xBDC4, 0xBDC4, 0xBE6F, 0xC01D, 0xC250, 0xC48C, 
	0xC654, 0xC64F, 0xC62A, 0xC5C7, 0xC505, 0xC3C5, 0xC1E8, 0xBF4F, 0xBBD9, 
	0xB767, 0xB1DB, 0xAB14, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0011, 0x0001, 0x0012, 0x0012, 0x0001, 0x0024, 0x0001, 
	0x0025, 0x0001, 0x0026, 0x0013, 0x0027, 0x0013, 0x003A, 0x0013, 0x004D, 
	0x0013, 0x0060, 0x0013, 0x0073, 0x0013, 0x0086, 0x0013, 0x0099, 0x0013, 
	0x00AC, 0x0013, 0x00BF, 0x0001, 0x00D2, 0x0001, 0x00D3, 0x0001, 0x00D4, 
	0x0013, 0x00D5, 0x0013, 0x00E8, 0x0013, 0x00FB, 0x0013, 0x010E, 0x0013, 
	0x0121, 0x0013, 0x0134, 0x0013, 0x0147, 0x0013, 0x015A, 0x0013, 0x016D, 
	0x0001, 0x0180, 0x0001, 0x0181, 0x0001, 0x0182, 0x0013, 0x0183, 0x0013, 
	0x0196, 0x0013, 0x01A9, 0x0013, 0x01BC, 0x0013, 0x01CF, 0x0013, 0x01E2, 
	0x0013, 0x01F5, 0x0013, 0x0208, 0x0013, 0x021B, 0x0013, 0x022E, 0x0012, 
	0x0241, 0x0001, 0x0253, 0x0013, 0x0254, 0x0013, 0x0267, 0x0013, 0x027A, 
	0x0013, 0x028D, 0x0013, 0x02A0, 0x0013, 0x02B3, 0x0013, 0x02C6, 0x0013, 
	0x02D9, 0x0013, 0x02EC, 0x0013, 0x02FF, 0x0012, 0x0312, 0x0001, 0x0324, 
	0x0013, 0x0325, 0x0013, 0x0338, 0x0013, 0x034B, 0x0013, 0x035E, 0x0013, 
	0x0371, 0x0013, 0x0384, 0x0013, 0x0397, 0x0013, 0x03AA, 0x0013, 0x03BD, 
	

});

smlua_anim_util_register_animation('donkey_19_shivering_warming_hand',0, 0, 0, 0, 85, { 
	0x0000, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFC, 0xFFF4, 
	0xFFE6, 0xFFD2, 0xFFB9, 0xFFA0, 0xFF8C, 0xFF7E, 0xFF76, 0xFF73, 0xFF73, 
	0xFF73, 0xFF73, 0xFF74, 0xFF74, 0xFF74, 0xFF75, 0xFF75, 0xFF76, 0xFF76, 
	0xFF77, 0xFF77, 0xFF78, 0xFF78, 0xFF79, 0xFF7A, 0xFF7A, 0xFF7B, 0xFF7B, 
	0xFF7C, 0xFF7D, 0xFF7D, 0xFF7E, 0xFF7E, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF80, 
	0xFFFE, 0x0006, 0x0018, 0x0036, 0x0061, 0x0098, 0x00CF, 0x00FA, 0x0118, 
	0x012B, 0x0131, 0x0131, 0x0132, 0x0132, 0x0133, 0x0133, 0x0134, 0x0134, 
	0x0134, 0x0134, 0x0135, 0x0135, 0x0135, 0x0135, 0x0136, 0x0136, 0x0136, 
	0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0137, 
	0x5675, 0x5691, 0x56E6, 0x5772, 0x5837, 0x5934, 0x5A32, 0x5AF7, 0x5B83, 
	0x5BD8, 0x5BF4, 0x5C1C, 0x5C42, 0x5C66, 0x5C87, 0x5CA5, 0x5CC2, 0x5CDC, 
	0x5CF5, 0x5D0B, 0x5D20, 0x5D33, 0x5D44, 0x5D53, 0x5D61, 0x5D6E, 0x5D79, 
	0x5D83, 0x5D8B, 0x5D93, 0x5D99, 0x5D9E, 0x5DA3, 0x5DA6, 0x5DA9, 0x5DAC, 
	0x5DAD, 0x5DAF, 0x5DAF, 0x5DB0, 0x0000, 0xFFFB, 0xFFF7, 0xFFF3, 0xFFF0, 
	0xFFED, 0xFFEA, 0xFFE7, 0xFFE4, 0xFFE1, 0xFFDF, 0xFFDD, 0xFFDB, 0xFFD9, 
	0xFFD7, 0xFFD6, 0xFFD4, 0xFFD3, 0xFFD2, 0xFFD1, 0xFFD0, 0xFFCF, 0xFFCE, 
	0xFFCD, 0xFFCC, 0xFFCC, 0xFFCB, 0xFFCB, 0xFFCA, 0xFFCA, 0xFFC9, 0xFFC9, 
	0xFFC8, 0xFFC8, 0xFFC8, 0xFFC7, 0xFFC7, 0xFFC7, 0xFFC6, 0xFFC6, 0xFFC5, 
	0xFFC5, 0xFFC4, 0xFFC3, 0xFFC3, 0xFFC2, 0xFFC1, 0xFFC0, 0xFFBF, 0xFFBE, 
	0xFFBD, 0xFFBC, 0xFFBB, 0xFFBA, 0xFFB9, 0xFFB8, 0xFFB7, 0xFFB5, 0xFFB4, 
	0xFFB3, 0xFFB2, 0xFFB1, 0xFFAF, 0xFFAE, 0xFFAD, 0xFFAC, 0xFFAB, 0xFFAA, 
	0xFFA9, 0xFFA8, 0xFFA7, 0xFFA6, 0xFFA5, 0xFFA4, 0xFFA3, 0xFFA2, 0xFFA2, 
	0xFFA1, 0xFFA0, 0xFFA0, 0xFF9F, 0xFF9F, 0xFF9F, 0xFF9E, 0x0000, 0x00BC, 
	0x00BC, 0x00BC, 0x00BC, 0x00BC, 0x00BC, 0x00BC, 0x00BB, 0x00BB, 0x00BB, 
	0x00BB, 0x00BB, 0x00BB, 0x00BB, 0x00BB, 0x00BB, 0x00BA, 0x00BA, 0x00BA, 
	0x00BA, 0x00BA, 0x00B9, 0x00B9, 0x00B9, 0x00B9, 0x00B8, 0x00B8, 0x00B8, 
	0x00B7, 0x00B7, 0x00B7, 0x00B6, 0x00B6, 0x00B6, 0x00B5, 0x00B5, 0x00B4, 
	0x00B4, 0x00B4, 0x00B3, 0x00B3, 0x00B2, 0x00B2, 0x00B1, 0x00B1, 0x00B0, 
	0x00B0, 0x00AF, 0x00AF, 0x00AE, 0x00AE, 0x00AD, 0x00AD, 0x00AC, 0x00AC, 
	0x00AB, 0x00AA, 0x00AA, 0x00A9, 0x00A9, 0x00A8, 0x00A8, 0x00A7, 0x00A7, 
	0x00A6, 0x00A6, 0x00A5, 0x00A5, 0x00A5, 0x00A4, 0x00A4, 0x00A3, 0x00A3, 
	0x00A3, 0x00A3, 0x00A2, 0x00A2, 0x00A2, 0x00A2, 0x00A1, 0x039F, 0x0410, 
	0x04D9, 0x05C0, 0x06BA, 0x07BB, 0x08B8, 0x09A4, 0x0A73, 0x0B1A, 0x0B8D, 
	0x0BDF, 0x0C2A, 0x0C6F, 0x0CAF, 0x0CE9, 0x0D1F, 0x0D4F, 0x0D7B, 0x0DA2, 
	0x0DC6, 0x0DE6, 0x0E02, 0x0E1C, 0x0E32, 0x0E46, 0x0E57, 0x0E66, 0x0E74, 
	0x0E80, 0x0E8B, 0x0E95, 0x0E9F, 0x0EA7, 0x0EB0, 0x0EB9, 0x0EC3, 0x0ECD, 
	0x0ED9, 0x0EE5, 0x0EF3, 0x0F03, 0x0F16, 0x0F2A, 0x0F41, 0x0F5A, 0x0F75, 
	0x0F92, 0x0FB0, 0x0FD1, 0x0FF2, 0x1015, 0x103A, 0x105F, 0x1085, 0x10AD, 
	0x10D4, 0x10FD, 0x1126, 0x114F, 0x1178, 0x11A1, 0x11CA, 0x11F3, 0x121C, 
	0x1244, 0x126B, 0x1291, 0x12B7, 0x12DC, 0x12FF, 0x1321, 0x1342, 0x1361, 
	0x137E, 0x139A, 0x13B3, 0x13CB, 0x13E0, 0x13F2, 0x1403, 0x1410, 0x141B, 
	0x1423, 0x1428, 0x1429, 0x0000, 0x009B, 0x01F3, 0x03BF, 0x05D5, 0x080C, 
	0x0A39, 0x0C33, 0x0DD0, 0x0EE7, 0x0F4D, 0x0E65, 0x0D35, 0x0BC9, 0x0A29, 
	0x085F, 0x0676, 0x0478, 0x026E, 0x0062, 0xFE5F, 0xFC6F, 0xFA9A, 0xF8EC, 
	0xF76E, 0xF62A, 0xF52B, 0xF4B1, 0xF4DC, 0xF584, 0xF680, 0xF7A8, 0xF8D5, 
	0xF9DC, 0xFA97, 0xFB1C, 0xFBA0, 0xFC22, 0xFCA0, 0xFD1B, 0xFD92, 0xFE04, 
	0xFE71, 0xFED9, 0xFF3A, 0xFF95, 0xFFE9, 0x0035, 0x006B, 0x0083, 0x0083, 
	0x0073, 0x005D, 0x0047, 0x003A, 0x0037, 0x003A, 0x003F, 0x0043, 0x0043, 
	0x003A, 0x0026, 0x0004, 0xFFCF, 0xFF6F, 0xFEDB, 0xFE27, 0xFD67, 0xFCB1, 
	0xFC18, 0xFBB2, 0xFB93, 0xFBCF, 0xFDE3, 0x01BA, 0x0508, 0x0584, 0x0329, 
	0xFFB2, 0xFB73, 0xF6C1, 0xF1F2, 0xED5A, 0xE94E, 0xE624, 0xE42F, 0x0000, 
	0x0026, 0x0025, 0x0022, 0x001D, 0x0017, 0x0011, 0x000B, 0x0006, 0x0002, 
	0x0001, 0x0005, 0x000B, 0x0013, 0x001C, 0x0025, 0x002E, 0x0036, 0x003D, 
	0x0042, 0x0044, 0x0044, 0x003F, 0x0037, 0x002A, 0x0018, 0x0000, 0xFFCD, 
	0xFF77, 0xFF09, 0xFE91, 0xFE1C, 0xFDB8, 0xFD71, 0xFD54, 0xFD5B, 0xFD71, 
	0xFD94, 0xFDC2, 0xFDF9, 0xFE36, 0xFE77, 0xFEBA, 0xFEFC, 0xFF3B, 0xFF74, 
	0xFFA6, 0xFFCE, 0xFFE9, 0xFFFA, 0x0001, 0x0002, 0x0001, 0xFFFE, 0xFFFE, 
	0x0001, 0x0005, 0x000A, 0x000D, 0x000F, 0x000D, 0x0008, 0xFFFE, 0xFFEE, 
	0xFFD8, 0xFFBD, 0xFF9C, 0xFF78, 0xFF51, 0xFF28, 0xFEFD, 0xFED2, 0xFEA7, 
	0xFE6D, 0xFE24, 0xFDE5, 0xFDCA, 0xFDD2, 0xFDE6, 0xFE03, 0xFE26, 0xFE4B, 
	0xFE6F, 0xFE8D, 0xFEA3, 0xFEAD, 0xEE2F, 0xF2C8, 0xF5A4, 0xF7DA, 0xF981, 
	0xFAAE, 0xFB76, 0xFBF1, 0xFC34, 0xFC56, 0xFC6B, 0xFC88, 0xFCB4, 0xFCEA, 
	0xFD26, 0xFD65, 0xFDA3, 0xFDDC, 0xFE0B, 0xFE2D, 0xFE3E, 0xFE3A, 0xFE1D, 
	0xFDE4, 0xFD89, 0xFD09, 0xFC61, 0xFB16, 0xF8E7, 0xF61F, 0xF30C, 0xEFFA, 
	0xED37, 0xEB10, 0xE9D0, 0xE941, 0xE8F2, 0xE8DA, 0xE8F4, 0xE938, 0xE99E, 
	0xEA20, 0xEAB5, 0xEB58, 0xEC00, 0xECA7, 0xED45, 0xEDD3, 0xEE6A, 0xEF24, 
	0xEFFC, 0xF0EC, 0xF1EF, 0xF300, 0xF418, 0xF55B, 0xF6DE, 0xF884, 0xFA33, 
	0xFBD1, 0xFD43, 0xFE6D, 0xFF35, 0xFF81, 0xFF48, 0xFEA4, 0xFDA6, 0xFC60, 
	0xFAE6, 0xF94A, 0xF79D, 0xF5F3, 0xF45D, 0xF22A, 0xEF4C, 0xECCF, 0xEBBF, 
	0xEBF8, 0xEC94, 0xED7B, 0xEE97, 0xEFCE, 0xF10B, 0xF236, 0xF336, 0xF3F6, 
	0x0001, 0xFFFE, 0xC170, 0x19C6, 0x1F61, 0x2370, 0x2666, 0x2878, 0x29D9, 
	0x2ABC, 0x2B55, 0x2BD6, 0x2C75, 0x2D63, 0x2E82, 0x2ED7, 0x2E93, 0x2DEA, 
	0x2D0E, 0x2C32, 0x2B89, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 0x2B46, 
	0x2B46, 0x2B46, 0x2B46, 0x2B73, 0x2BE0, 0x2C67, 0x2CE1, 0x2D28, 0x2D15, 
	0x2C81, 0x2B46, 0x28F0, 0x2576, 0x214E, 0x1CEF, 0x18CF, 0x1566, 0x132A, 
	0x11D0, 0x10BA, 0x0FE0, 0x0F3A, 0x0EC0, 0x0E6A, 0x0E30, 0x0E0A, 0x0DF1, 
	0x0DDC, 0x0DC4, 0x0DA1, 0x0D6A, 0x0D31, 0x0D0C, 0x0CF7, 0x0CF1, 0x0CF7, 
	0x0D09, 0x0D23, 0x0D44, 0x0D6A, 0x0D75, 0x0D58, 0x0D2B, 0x0D06, 0x0D03, 
	0x0D3A, 0x0DC3, 0x0EB8, 0x102F, 0x127A, 0x15A6, 0x196C, 0x1D81, 0x219D, 
	0x2578, 0x28C9, 0x2B46, 0x2CBB, 0x2D51, 0x2D4F, 0x2CF7, 0x2C91, 0xDC99, 
	0xE03A, 0xE4CD, 0xE840, 0xEAC1, 0xEC7C, 0xEDA0, 0xEE5A, 0xEED7, 0xEF45, 
	0xEFD0, 0xF075, 0xF0A6, 0xF07F, 0xF01E, 0xEF9F, 0xEF20, 0xEEBF, 0xEE98, 
	0xEE98, 0xEE98, 0xEE98, 0xEE98, 0xEE98, 0xEE98, 0xEE98, 0xEE98, 0xEE99, 
	0xEE9C, 0xEE9F, 0xEEA3, 0xEEA4, 0xEEA4, 0xEEA0, 0xEE98, 0xEE88, 0xEE6E, 
	0xEE4F, 0xEE30, 0xEE15, 0xEE02, 0xEDFB, 0xEDFE, 0xEE04, 0xEE0F, 0xEE1C, 
	0xEE2B, 0xEE3B, 0xEE4D, 0xEE5F, 0xEE70, 0xEE80, 0xEE8F, 0xEE9B, 0xEEA4, 
	0xEEA9, 0xEEAA, 0xEEA7, 0xEEA2, 0xEE9D, 0xEE9A, 0xEE99, 0xEE9C, 0xEEA4, 
	0xEEB5, 0xEECE, 0xEEEC, 0xEF0C, 0xEF2D, 0xEF4B, 0xEF63, 0xEF74, 0xEF79, 
	0xEF66, 0xEF37, 0xEEF8, 0xEEB7, 0xEE80, 0xEE60, 0xEE64, 0xEE98, 0xEF36, 
	0xF045, 0xF185, 0xF2B8, 0xF39F, 0xBCE3, 0xB9E2, 0xB8DC, 0xB612, 0xB1F4, 
	0xACF3, 0xA77E, 0xA204, 0x9CF6, 0x98C2, 0x95D9, 0x9472, 0x9408, 0x945D, 
	0x9530, 0x9643, 0x9756, 0x9829, 0x987E, 0x987E, 0x987E, 0x987E, 0x987E, 
	0x987E, 0x987E, 0x987E, 0x987E, 0x9888, 0x98A2, 0x98C1, 0x98DE, 0x98EE, 
	0x98EA, 0x98C7, 0x987E, 0x97F2, 0x9722, 0x9629, 0x9523, 0x942D, 0x9362, 
	0x92DE, 0x9291, 0x9254, 0x9225, 0x9203, 0x91EC, 0x91DD, 0x91D5, 0x91D1, 
	0x91D0, 0x91D0, 0x91CF, 0x91CA, 0x91C0, 0x91B5, 0x91AD, 0x91A7, 0x91A4, 
	0x91A5, 0x91A8, 0x91AD, 0x91B6, 0x91C0, 0x91C8, 0x91C8, 0x91C6, 0x91C7, 
	0x91CF, 0x91E4, 0x920A, 0x9245, 0x929C, 0x9325, 0x93E7, 0x94CC, 0x95C0, 
	0x96AE, 0x9780, 0x9822, 0x987E, 0x9866, 0x97DD, 0x9716, 0x9648, 0x95A6, 
	0xFFFF, 0x00D6, 0x0000, 0xF1AE, 0xCC9F, 0xD2A4, 0xD268, 0xD1C5, 0xD0D3, 
	0xCFAA, 0xCE61, 0xCD10, 0xCBD1, 0xCABA, 0xC9E4, 0xC948, 0xC88A, 0xC7BC, 
	0xC6ED, 0xC630, 0xC593, 0xC529, 0xC502, 0xC533, 0xC5B6, 0xC674, 0xC754, 
	0xC83E, 0xC91B, 0xC9D3, 0xCA4E, 0xCA83, 0xCA83, 0xCA61, 0xCA30, 0xCA03, 
	0xC9ED, 0xCA00, 0xCA4E, 0xCAD2, 0xCB74, 0xCC2E, 0xCCFB, 0xCDD5, 0xCEB6, 
	0xCF98, 0xD075, 0xD147, 0xD209, 0xD2B5, 0xD345, 0xD3B0, 0xD3F8, 0xD423, 
	0xD439, 0xD441, 0xD441, 0xD443, 0xD44C, 0xD45A, 0xD467, 0xD470, 0xD476, 
	0xD477, 0xD475, 0xD46D, 0xD460, 0xD44C, 0xD43B, 0xD430, 0xD427, 0xD419, 
	0xD3FF, 0xD3D4, 0xD392, 0xD333, 0xD2B0, 0xD1FB, 0xD111, 0xD001, 0xCED8, 
	0xCDA3, 0xCC72, 0xCB51, 0xCA4E, 0xC94C, 0xC836, 0xC729, 0xC645, 0xC5A6, 
	0x04C7, 0xFC2A, 0xFC4C, 0xFCA6, 0xFD29, 0xFDC3, 0xFE66, 0xFF01, 0xFF83, 
	0xFFDD, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x003A, 0x00C7, 0x0175, 0x0213, 0x026E, 0x0255, 0x0196, 0x0000, 0xFDA2, 
	0xFAC0, 0xF772, 0xF3D0, 0xEFF4, 0xEBF5, 0xE7EB, 0xE3F0, 0xE01C, 0xDC87, 
	0xD949, 0xD67B, 0xD42D, 0xD253, 0xD0DC, 0xCFB6, 0xCECF, 0xCE17, 0xCD7C, 
	0xCCEC, 0xCC4D, 0xCBA1, 0xCAFD, 0xCA7A, 0xCA2D, 0xCA2F, 0xCA95, 0xCB77, 
	0xCCEC, 0xCF1F, 0xD20E, 0xD58E, 0xD973, 0xDD91, 0xE1BD, 0xE5C9, 0xE98B, 
	0xECD6, 0xEFD0, 0xF2B4, 0xF579, 0xF813, 0xFA78, 0xFC9D, 0xFE79, 0x0000, 
	0x00EF, 0x0132, 0x0102, 0x0099, 0x002F, 0x0306, 0x0855, 0x07D3, 0x0676, 
	0x047C, 0x0224, 0xFFAC, 0xFD55, 0xFB5B, 0xF9FD, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF98C, 0xF9B7, 0xF9EC, 0xFA1B, 
	0xFA37, 0xFA2F, 0xF9F6, 0xF97B, 0xF8C1, 0xF7DB, 0xF6D2, 0xF5AE, 0xF479, 
	0xF33A, 0xF1FB, 0xF0C5, 0xEFA0, 0xEE95, 0xEDAD, 0xECF1, 0xEC72, 0xEC31, 
	0xEC22, 0xEC34, 0xEC5B, 0xEC88, 0xECAB, 0xECB8, 0xECA9, 0xEC88, 0xEC5F, 
	0xEC36, 0xEC18, 0xEC0C, 0xEC1D, 0xEC53, 0xECB8, 0xED58, 0xEE31, 0xEF34, 
	0xF053, 0xF181, 0xF2AF, 0xF3CF, 0xF4D2, 0xF5AC, 0xF662, 0xF703, 0xF792, 
	0xF80F, 0xF87D, 0xF8DD, 0xF931, 0xF97B, 0xF9AA, 0xF9B8, 0xF9AE, 0xF999, 
	0xF984, 0x0A90, 0x0598, 0x04C5, 0x0290, 0xFF5B, 0xFB90, 0xF792, 0xF3C7, 
	0xF094, 0xEE5E, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8D, 0xED94, 0xED9C, 0xEDA4, 0xEDA8, 0xEDA7, 0xED9E, 0xED8B, 
	0xED70, 0xED51, 0xED30, 0xED0B, 0xECE4, 0xECBA, 0xEC8E, 0xEC5F, 0xEC2E, 
	0xEBFB, 0xEBC7, 0xEB90, 0xEB50, 0xEB02, 0xEAAC, 0xEA52, 0xE9FB, 0xE9AC, 
	0xE96B, 0xE93C, 0xE924, 0xE91E, 0xE925, 0xE933, 0xE945, 0xE953, 0xE95A, 
	0xE954, 0xE93C, 0xE905, 0xE8AD, 0xE840, 0xE7CC, 0xE75C, 0xE6FE, 0xE6BE, 
	0xE6A8, 0xE6CA, 0xE738, 0xE7F3, 0xE8E3, 0xE9F1, 0xEB07, 0xEC0C, 0xECEA, 
	0xED8B, 0xEDDF, 0xEDF7, 0xEDE6, 0xEDC1, 0xED9B, 0x0001, 0xFFFE, 0xC170, 
	0x36DA, 0x428F, 0xCB96, 0xD29F, 0xD7E7, 0xDBB1, 0xDE3A, 0xDFC5, 0xE08F, 
	0xE0D9, 0xE0E4, 0xDF9E, 0xDECF, 0xDE61, 0xDE3C, 0xDE47, 0xDE6D, 0xDE95, 
	0xDEA7, 0xDECD, 0xDF32, 0xDFC4, 0xE070, 0xE124, 0xE1CE, 0xE25C, 0xE2BA, 
	0xE2D5, 0xE2B4, 0xE272, 0xE227, 0xE1EF, 0xE1E4, 0xE21F, 0xE2BA, 0xE3BC, 
	0xE50A, 0xE693, 0xE845, 0xEA0C, 0xEBD6, 0xED90, 0xEF28, 0xF08B, 0xF1A7, 
	0xF283, 0xF336, 0xF3C6, 0xF437, 0xF491, 0xF4D8, 0xF511, 0xF542, 0xF571, 
	0xF5A4, 0xF5CE, 0xF5E4, 0xF5EA, 0xF5E3, 0xF5D5, 0xF5C4, 0xF5B3, 0xF5A7, 
	0xF5A4, 0xF5C4, 0xF60F, 0xF672, 0xF6D4, 0xF722, 0xF745, 0xF727, 0xF6B4, 
	0xF5D4, 0xF44F, 0xF21E, 0xEF78, 0xEC92, 0xE9A3, 0xE6E0, 0xE481, 0xE2BA, 
	0xE1B0, 0xE140, 0xE13C, 0xE173, 0xE1B7, 0x54F5, 0x51C4, 0x2CFC, 0x299C, 
	0x24AA, 0x1EB3, 0x1846, 0x11F0, 0x0C40, 0x07C4, 0x0509, 0x042B, 0x03EA, 
	0x041E, 0x04A1, 0x054A, 0x05F4, 0x0677, 0x06AB, 0x06AB, 0x06AB, 0x06AB, 
	0x06AB, 0x06AB, 0x06AB, 0x06AB, 0x06AB, 0x06A0, 0x0686, 0x0667, 0x064A, 
	0x0639, 0x063E, 0x0661, 0x06AB, 0x0721, 0x07BD, 0x0874, 0x093E, 0x0A12, 
	0x0AE5, 0x0BB0, 0x0C68, 0x0D04, 0x0D7B, 0x0DD0, 0x0E0B, 0x0E33, 0x0E49, 
	0x0E53, 0x0E54, 0x0E51, 0x0E4C, 0x0E4B, 0x0E52, 0x0E5D, 0x0E66, 0x0E6D, 
	0x0E72, 0x0E74, 0x0E72, 0x0E6D, 0x0E62, 0x0E52, 0x0E43, 0x0E38, 0x0E2D, 
	0x0E1F, 0x0E07, 0x0DE3, 0x0DAE, 0x0D63, 0x0CFE, 0x0C6E, 0x0BAD, 0x0ACC, 
	0x09DB, 0x08E9, 0x0805, 0x0741, 0x06AB, 0x064E, 0x0622, 0x0619, 0x0623, 
	0x0634, 0x175C, 0x2267, 0xA21F, 0xA159, 0xA02D, 0x9EB1, 0x9D00, 0x9B30, 
	0x9959, 0x9794, 0x95F8, 0x94BE, 0x9461, 0x94AB, 0x9564, 0x9655, 0x9745, 
	0x97FE, 0x9848, 0x9848, 0x9848, 0x9848, 0x9848, 0x9848, 0x9848, 0x9848, 
	0x9848, 0x984B, 0x9852, 0x985B, 0x9863, 0x9868, 0x9867, 0x985D, 0x9848, 
	0x9827, 0x97FB, 0x97C7, 0x978F, 0x9753, 0x9718, 0x96DF, 0x96AB, 0x967F, 
	0x965E, 0x9647, 0x9636, 0x962C, 0x9626, 0x9624, 0x9625, 0x9627, 0x9628, 
	0x9629, 0x9628, 0x9625, 0x9622, 0x9620, 0x961F, 0x961E, 0x961E, 0x9620, 
	0x9623, 0x9628, 0x962D, 0x9631, 0x9635, 0x963B, 0x9643, 0x964E, 0x965E, 
	0x9674, 0x9690, 0x96C8, 0x9722, 0x978F, 0x97FB, 0x9856, 0x988D, 0x988E, 
	0x9848, 0x9765, 0x95D9, 0x9401, 0x923C, 0x90E8, 0x04C5, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xCB7B, 0xCB6F, 0xCB49, 0xCB0D, 0xCABB, 0xCA54, 0xC9DB, 
	0xC94F, 0xC8B4, 0xC80A, 0xC752, 0xC686, 0xC58D, 0xC47F, 0xC371, 0xC279, 
	0xC1AD, 0xC122, 0xC0EF, 0xC12F, 0xC1DB, 0xC2D2, 0xC3F7, 0xC52A, 0xC64B, 
	0xC73B, 0xC7DC, 0xC831, 0xC859, 0xC85E, 0xC84B, 0xC82A, 0xC806, 0xC7E9, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC7EB, 0xC80E, 0xC839, 0xC860, 0xC877, 0xC871, 
	0xC842, 0xC7DC, 0xC6F6, 0xC580, 0xC3CF, 0xC233, 0xC100, 0xFA42, 0xF60E, 
	0xF665, 0xF74F, 0xF8A2, 0xFA33, 0xFBDA, 0xFD6B, 0xFEBE, 0xFFA8, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFC8, 0xFF41, 
	0xFE9B, 0xFE05, 0xFDAE, 0xFDC5, 0xFE7C, 0x0000, 0x0234, 0x04D2, 0x07CA, 
	0x0B09, 0x0E81, 0x1222, 0x15D9, 0x1998, 0x1D4E, 0x20EA, 0x245D, 0x2795, 
	0x2AAD, 0x2D8F, 0x2FE6, 0x315D, 0x3188, 0x30B0, 0x2F92, 0x2EE9, 0x2EFA, 
	0x2F6F, 0x301D, 0x30D5, 0x316B, 0x31B1, 0x317C, 0x309D, 0x2EE9, 0x2C1C, 
	0x2844, 0x23A8, 0x1E90, 0x1943, 0x140A, 0x0F2C, 0x0AF2, 0x07A2, 0x053D, 
	0x037E, 0x0248, 0x017A, 0x00F8, 0x00A1, 0x0059, 0x0000, 0xFFD3, 0x000C, 
	0x007F, 0x0105, 0x0173, 0x0197, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFE5, 0xFFA5, 0xFF56, 0xFF0F, 0xFEE5, 0xFEF1, 
	0xFF47, 0xFFFF, 0x011E, 0x028D, 0x043A, 0x0614, 0x0808, 0x0A05, 0x0BFA, 
	0x0DD4, 0x0F81, 0x10F1, 0x1210, 0x12CE, 0x11B7, 0x0E81, 0x0ADA, 0x0872, 
	0x07D5, 0x0816, 0x08A8, 0x08FE, 0x08FE, 0x08EB, 0x08CE, 0x08AF, 0x0895, 
	0x0888, 0x0890, 0x08B5, 0x08FE, 0x0990, 0x0A75, 0x0B8E, 0x0CBC, 0x0DE0, 
	0x0EDB, 0x0F8D, 0x0FD9, 0x0F9F, 0x0EB3, 0x0D1F, 0x0B10, 0x08B6, 0x063F, 
	0x03D9, 0x01B5, 0xFFFF, 0xFEA8, 0xFD81, 0xFC90, 0xFBDD, 0xFB6D, 0x0624, 
	0x02D0, 0x0259, 0x011B, 0xFF4D, 0xFD2B, 0xFAEC, 0xF8CA, 0xF6FD, 0xF5BF, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF541, 
	0xF531, 0xF51D, 0xF50A, 0xF500, 0xF503, 0xF519, 0xF548, 0xF58B, 0xF5D6, 
	0xF629, 0xF684, 0xF6E5, 0xF74D, 0xF7BA, 0xF82D, 0xF8A4, 0xF920, 0xF99F, 
	0xFA21, 0xFADF, 0xFBE0, 0xFCD8, 0xFD7B, 0xFDA2, 0xFD7D, 0xFD3D, 0xFD17, 
	0xFD1A, 0xFD2D, 0xFD49, 0xFD66, 0xFD7E, 0xFD89, 0xFD81, 0xFD5D, 0xFD17, 
	0xFCA5, 0xFC09, 0xFB4D, 0xFA7E, 0xF9A6, 0xF8D1, 0xF809, 0xF75A, 0xF6CF, 
	0xF67A, 0xF658, 0xF656, 0xF65D, 0xF65B, 0xF63A, 0xF5E5, 0xF548, 0xF408, 
	0xF21C, 0xEFEB, 0xEDDA, 0xEC52, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0xFE9B, 0xFE9A, 0xFE95, 0xFE8E, 0xFE84, 0xFE7A, 0xFE73, 0xFE6F, 0xFE6D, 
	0xEFF9, 0xEFB2, 0xEEDC, 0xED78, 0xEB85, 0xE992, 0xE82E, 0xE758, 0xE711, 
	0x839E, 0x83A1, 0x83AA, 0x83B9, 0x83CD, 0x83E2, 0x83F1, 0x83FA, 0x83FD, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x49EE, 0x499F, 0x48B4, 0x472C, 
	0x4508, 0x426D, 0x4049, 0x3EC1, 0x3DD5, 0x3D87, 0xF792, 0xF795, 0xF79F, 
	0xF7B0, 0xF7C7, 0xF7E5, 0xF803, 0xF81A, 0xF82A, 0xF834, 0xF838, 0x03C6, 
	0x03CC, 0x03DE, 0x03FD, 0x0429, 0x0460, 0x0498, 0x04C3, 0x04E2, 0x04F5, 
	0x04FB, 0xAB92, 0xABB1, 0xAC0E, 0xACA8, 0xAD80, 0xAE95, 0xAFAA, 0xB082, 
	0xB11C, 0xB179, 0xB198, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x0075, 0xFD3A, 
	0xFBEF, 0x1192, 0x142D, 0x1AAE, 0x1D49, 0x842B, 0x812B, 0x79AC, 0x76AC, 
	0xFFFF, 0x0000, 0xFFFF, 0x4A21, 0x488F, 0x43DA, 0x3CCB, 0x3816, 0x3684, 
	0x369D, 0x36EA, 0x3768, 0x381A, 0x38FE, 0x09D3, 0x09CB, 0x09B3, 0x098C, 
	0x0955, 0x090F, 0x08C9, 0x0892, 0x086B, 0x0853, 0x084B, 0xFE32, 0xFE1F, 
	0xFDE5, 0xFD84, 0xFCFC, 0xFC4D, 0xFB9E, 0xFB16, 0xFAB5, 0xFA7A, 0xFA67, 
	0xABC3, 0xAC18, 0xAD17, 0xAEC0, 0xB114, 0xB411, 0xB70F, 0xB962, 0xBB0C, 
	0xBC0B, 0xBC60, 

},{ 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
	0x0004, 0x0001, 0x0005, 0x0027, 0x0006, 0x0024, 0x002D, 0x0028, 0x0051, 
	0x0054, 0x0079, 0x0051, 0x00CD, 0x0056, 0x011E, 0x0056, 0x0174, 0x0056, 
	0x01CA, 0x0056, 0x0220, 0x0001, 0x0276, 0x0001, 0x0277, 0x0001, 0x0278, 
	0x0056, 0x0279, 0x0056, 0x02CF, 0x0056, 0x0325, 0x0002, 0x037B, 0x0002, 
	0x037D, 0x0056, 0x037F, 0x0056, 0x03D5, 0x0056, 0x042B, 0x0056, 0x0481, 
	0x0001, 0x04D7, 0x0001, 0x04D8, 0x0001, 0x04D9, 0x0056, 0x04DA, 0x0056, 
	0x0530, 0x0056, 0x0586, 0x0001, 0x05DC, 0x0055, 0x05DD, 0x0056, 0x0632, 
	0x0056, 0x0688, 0x0056, 0x06DE, 0x0056, 0x0734, 0x002A, 0x078A, 0x002B, 
	0x07B4, 0x0001, 0x07DF, 0x0009, 0x07E0, 0x0009, 0x07E9, 0x0009, 0x07F2, 
	0x0001, 0x07FB, 0x000D, 0x07FC, 0x000A, 0x0809, 0x000B, 0x0813, 0x000B, 
	0x081E, 0x000B, 0x0829, 0x002A, 0x0834, 0x0029, 0x085E, 0x0001, 0x0887, 
	0x0004, 0x0888, 0x0004, 0x088C, 0x0004, 0x0890, 0x0001, 0x0894, 0x0002, 
	0x0895, 0x000B, 0x0897, 0x000B, 0x08A2, 0x000B, 0x08AD, 0x000B, 0x08B8, 
	

});

smlua_anim_util_register_animation('donkey_22_credits_take_off_cap',1, 0, 0, 0, 26, { 
	0x0000, 0x008B, 0x008B, 0x0097, 0x00A3, 0x0000, 0x0000, 0x0009, 0x0012, 
	0x0012, 0x000F, 0x000C, 0x0007, 0x0003, 0x0001, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFE, 0x5675, 
	0x55F6, 0x5477, 0x51FA, 0x4E7E, 0x4A03, 0x4588, 0x420C, 0x3F8F, 0x3E11, 
	0x3D92, 0x0000, 0xFD40, 0xFD3E, 0xFD38, 0xFD30, 0xFD26, 0xFD1B, 0xFD11, 
	0xFD08, 0xFD02, 0xFD00, 0xFD35, 0xFD6F, 0xFDAC, 0xFDEA, 0xFE2A, 0xFE6A, 
	0xFEA9, 0xFEE5, 0xFF1F, 0xFF54, 0xFF84, 0xFFAE, 0xFFD0, 0xFFEA, 0xFFFA, 
	0xFFFF, 0x0000, 0xFE93, 0x039F, 0x0273, 0x02C6, 0x03A2, 0x04E1, 0x065B, 
	0x07E9, 0x0963, 0x0AA2, 0x0B7E, 0x0BD0, 0x0B39, 0x0A9A, 0x09F6, 0x094F, 
	0x08A7, 0x0802, 0x0761, 0x06C7, 0x0636, 0x05B0, 0x0539, 0x04D1, 0x047D, 
	0x043E, 0x0416, 0x0408, 0x0000, 0x03A5, 0x033D, 0x0226, 0x0092, 0xFEB2, 
	0xFCBA, 0xFADA, 0xF946, 0xF82F, 0xF7C7, 0xF949, 0xFA4A, 0xFAE7, 0xFB82, 
	0xFC19, 0xFCAC, 0xFD39, 0xFDBD, 0xFE38, 0xFEA7, 0xFF0A, 0xFF5E, 0xFFA2, 
	0xFFD5, 0xFFF5, 0xFFFF, 0x0000, 0x0276, 0x0308, 0x037A, 0x03D0, 0x040D, 
	0x0436, 0x044F, 0x045C, 0x0460, 0x0461, 0x035D, 0x02B9, 0x025E, 0x0209, 
	0x01B9, 0x0170, 0x012C, 0x00EF, 0x00B9, 0x0089, 0x0060, 0x003D, 0x0023, 
	0x000F, 0x0003, 0xFFFF, 0xEE2F, 0xF1FA, 0xF732, 0xFBCC, 0xFFC7, 0x0326, 
	0x05E5, 0x0808, 0x098E, 0x0A77, 0x0AC5, 0x05B5, 0x0245, 0x0005, 0xFDCE, 
	0xFBA7, 0xF993, 0xF79A, 0xF5BF, 0xF408, 0xF27A, 0xF11B, 0xEFF1, 0xEEFF, 
	0xEE4C, 0xEDDC, 0xEDB6, 0x0001, 0xFFFE, 0xC170, 0x1DCC, 0x120B, 0x1145, 
	0x0F32, 0x0C2D, 0x0892, 0x04BD, 0x010A, 0xFDD4, 0xFB79, 0xFA53, 0xFA2F, 
	0xFA0A, 0xF9E3, 0xF9BB, 0xF992, 0xF968, 0xF93F, 0xF916, 0xF8ED, 0xF8B4, 
	0xF861, 0xF803, 0xF7A3, 0xF750, 0xF715, 0xF6FE, 0xD901, 0xDFBF, 0xDF67, 
	0xDE7C, 0xDD29, 0xDB96, 0xD9EE, 0xD85B, 0xD707, 0xD61D, 0xD5C5, 0xD649, 
	0xD6D2, 0xD760, 0xD7F0, 0xD882, 0xD915, 0xD9A7, 0xDA36, 0xDAC3, 0xDB80, 
	0xDC89, 0xDDB7, 0xDEE5, 0xDFEC, 0xE0A6, 0xE0EC, 0xB867, 0xC2C3, 0xC67E, 
	0xC966, 0xCB95, 0xCD25, 0xCE32, 0xCED4, 0xCF28, 0xCF47, 0xCF4B, 0xCE52, 
	0xCD4C, 0xCC3D, 0xCB25, 0xCA08, 0xC8E7, 0xC7C4, 0xC6A1, 0xC581, 0xC3E8, 
	0xC199, 0xBEEC, 0xBC3C, 0xB9E1, 0xB835, 0xB793, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xC9F4, 0xCB72, 0xCB62, 0xCB37, 
	0xCAF8, 0xCAAC, 0xCA59, 0xCA06, 0xC9BB, 0xC97D, 0xC954, 0xC941, 0xC936, 
	0xC935, 0xC93E, 0xC954, 0xC979, 0xC9AE, 0xC9F4, 0xCA4E, 0xCB28, 0xCCBA, 
	0xCEB3, 0xD0C5, 0xD2A2, 0xD3FA, 0xD47E, 0x071C, 0x0512, 0x04E7, 0x0473, 
	0x03C8, 0x02FA, 0x021B, 0x013E, 0x0076, 0xFFD6, 0xFF72, 0xFF46, 0xFF10, 
	0xFED2, 0xFE8A, 0xFE37, 0xFDD8, 0xFD6D, 0xFCF6, 0xFC70, 0xFB71, 0xF9C1, 
	0xF7B0, 0xF58B, 0xF3A1, 0xF241, 0xF1BB, 0x0306, 0x0504, 0x048F, 0x0351, 
	0x017C, 0xFF43, 0xFCD8, 0xFA6E, 0xF836, 0xF663, 0xF527, 0xF482, 0xF3E0, 
	0xF346, 0xF2B6, 0xF233, 0xF1C2, 0xF165, 0xF120, 0xF0F6, 0xF133, 0xF1FD, 
	0xF31D, 0xF45D, 0xF584, 0xF65E, 0xF6B3, 0x0A90, 0x1318, 0x11C4, 0x0E2D, 
	0x08E9, 0x0290, 0xFBB8, 0xF4FA, 0xEEEC, 0xEA25, 0xE73D, 0xE62B, 0xE513, 
	0xE3F6, 0xE2D8, 0xE1BC, 0xE0A6, 0xDF99, 0xDE98, 0xDDA6, 0xDC8C, 0xDB2D, 
	0xD9B2, 0xD843, 0xD70A, 0xD630, 0xD5DE, 0x0001, 0xFFFE, 0xC170, 0x36DA, 
	0x42AD, 0xCEB8, 0xD81B, 0xDF28, 0xE435, 0xE798, 0xE9A6, 0xEAB4, 0xEB18, 
	0xEB26, 0xE797, 0xE83D, 0xEE95, 0xF7CE, 0x01DD, 0x0AB1, 0x103F, 0x1086, 
	0x0CD8, 0x0821, 0x054B, 0x04FC, 0x0594, 0x0697, 0x078D, 0x07FA, 0x54F5, 
	0x5202, 0x2CDF, 0x29DE, 0x2586, 0x205E, 0x1AF2, 0x15CB, 0x1172, 0x0E72, 
	0x0D53, 0x1114, 0x1481, 0x1701, 0x194C, 0x1B85, 0x1DCB, 0x2040, 0x2343, 
	0x26A7, 0x29BE, 0x2BD6, 0x2CCC, 0x2D19, 0x2CFF, 0x2CC0, 0x2C9C, 0x175C, 
	0x2288, 0xA16A, 0x9E56, 0x99B4, 0x93EA, 0x8D5F, 0x867B, 0x7FA4, 0x7943, 
	0x73BE, 0x70A6, 0x74BE, 0x8213, 0x9414, 0xA7A0, 0xB993, 0xC6C9, 0xCCFB, 
	0xCE04, 0xCCFB, 0xCCF5, 0xCEB2, 0xD0AA, 0xD280, 0xD3DC, 0xD464, 0x0A41, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x01CC, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xCDBD, 0xC466, 0xC671, 0xCBEB, 0xD3D9, 
	0xDD40, 0xE725, 0xF08B, 0xF87A, 0xFDF4, 0xFFFF, 0xFFFF, 0x0000, 0xF433, 
	0xE453, 0xD354, 0xC429, 0xB9C5, 0xB99B, 0xC140, 0xC7DC, 0xCB1B, 0xCE5C, 
	0xD15B, 0xD3D3, 0xD581, 0xD61F, 0xFA42, 0xFC7F, 0x003D, 0x0475, 0x0923, 
	0x0E3F, 0x13C4, 0x19AC, 0x1FF0, 0x268A, 0x2D75, 0x3237, 0x3184, 0x2877, 
	0x1AF1, 0x0C53, 0x0000, 0xFF3F, 0x0204, 0x0555, 0x08F5, 0x0CA9, 0x1036, 
	0x1360, 0x15EC, 0x179F, 0x183D, 0x0197, 0x02EE, 0x0462, 0x054C, 0x05EF, 
	0x068F, 0x0771, 0x08D8, 0x0B07, 0x0E43, 0x12CF, 0x1B3F, 0x1E78, 0x1A01, 
	0x119F, 0x080B, 0x0000, 0xFE9B, 0xFF19, 0xFFC0, 0x0082, 0x014E, 0x0217, 
	0x02CE, 0x0363, 0x03C7, 0x03EC, 0x0624, 0x0457, 0x0309, 0xFF88, 0xFA77, 
	0xF475, 0xEE23, 0xE821, 0xE310, 0xDF8F, 0xDE41, 0xDE85, 0xE06C, 0xE4B5, 
	0xEA82, 0xF07C, 0xF548, 0xF339, 0xEEF5, 0xEA05, 0xE4B9, 0xDF63, 0xDA52, 
	0xD5D5, 0xD23E, 0xCFDB, 0xCEFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFE96, 
	0xFD2C, 0xF961, 0xF3E4, 0xED62, 0xE68A, 0xE008, 0xDA8B, 0xD6C0, 0xD556, 
	0xD559, 0xD560, 0xD56C, 0xD57C, 0xD58E, 0xD5A3, 0xD5B9, 0xD5CF, 0xD5E6, 
	0xD5FC, 0xD611, 0xD623, 0xD633, 0xD63F, 0xD646, 0xD649, 0xEFF9, 0xEF42, 
	0xEF5E, 0xEF74, 0xEF85, 0xEF91, 0xEF99, 0xEF9E, 0xEFA0, 0xEFA1, 0xEFA1, 
	0xEF97, 0xEF7C, 0xEF51, 0xEF1A, 0xEED8, 0xEE8F, 0xEE41, 0xEDF1, 0xEDA0, 
	0xED52, 0xED09, 0xECC7, 0xEC90, 0xEC65, 0xEC4A, 0xEC40, 0x839E, 0x8506, 
	0x9426, 0x9FED, 0xA8C7, 0xAF1F, 0xB35F, 0xB5F3, 0xB746, 0xB7C3, 0xB7D5, 
	0xB7CF, 0xB7BD, 0xB7A1, 0xB77C, 0xB751, 0xB721, 0xB6EE, 0xB6B9, 0xB684, 
	0xB651, 0xB621, 0xB5F6, 0xB5D2, 0xB5B6, 0xB5A4, 0xB59D, 0xFFFF, 0x0085, 
	0x01A8, 0x02CD, 0x0354, 0x0357, 0x035A, 0x035B, 0x035B, 0x035C, 0x0000, 
	0x00E1, 0x02D0, 0x04BF, 0x05A0, 0x0432, 0x00A0, 0xFBFB, 0xF757, 0xF3C5, 
	0xF258, 0x49EE, 0x482C, 0x3D8C, 0x2ED3, 0x25E5, 0x2398, 0x220D, 0x211D, 
	0x20A2, 0x2075, 0x206E, 0x207C, 0x20A3, 0x20DF, 0x212D, 0x218A, 0x21F2, 
	0x2260, 0x22D2, 0x2345, 0x23B3, 0x241B, 0x2477, 0x24C6, 0x2502, 0x2529, 
	0x2537, 0xF7AE, 0xF87D, 0xF810, 0xF745, 0xF6D8, 0xF6F7, 0xF745, 0xF7AB, 
	0xF810, 0xF85E, 0xF87D, 0x03C6, 0x0782, 0x0783, 0x0784, 0x0784, 0x0784, 
	0x0783, 0x0783, 0x0782, 0xAB92, 0xA9E5, 0xB0FB, 0xB37A, 0xB437, 0xB57D, 
	0xB76F, 0xB9A9, 0xBBC4, 0xBD5C, 0xBE0A, 0xBE12, 0xBE20, 0xBE32, 0xBE48, 
	0xBE60, 0xBE7A, 0xBE95, 0xBEB1, 0xBECC, 0xBEE6, 0xBEFE, 0xBF13, 0xBF25, 
	0xBF33, 0xBF3C, 0xBF3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 0x00DC, 0x01B2, 0x03F2, 0x0734, 
	0x0B12, 0x0F28, 0x130D, 0x165C, 0x18B0, 0x19A1, 0x19AB, 0x19BC, 0x19D0, 
	0x19E9, 0x1A05, 0x1A24, 0x1A43, 0x1A63, 0x1A83, 0x1AA1, 0x1ABD, 0x1AD6, 
	0x1AEB, 0x1AFB, 0x1B05, 0x1B09, 0x1192, 0x11D1, 0x1227, 0x1274, 0x12B7, 
	0x12F0, 0x131F, 0x1344, 0x135F, 0x136F, 0x1374, 0x1364, 0x134B, 0x132B, 
	0x1304, 0x12D8, 0x12A9, 0x1278, 0x1246, 0x1215, 0x11E6, 0x11BA, 0x1194, 
	0x1173, 0x115A, 0x114A, 0x1144, 0x842B, 0x83C1, 0x8ED9, 0x977A, 0x9DF3, 
	0xA295, 0xA5AF, 0xA792, 0xA88D, 0xA8F0, 0xA90B, 0xA922, 0xA947, 0xA977, 
	0xA9B0, 0xA9F0, 0xAA36, 0xAA7E, 0xAAC7, 0xAB10, 0xAB55, 0xAB95, 0xABCE, 
	0xABFE, 0xAC23, 0xAC3B, 0xAC43, 0x0000, 0xFFEB, 0xFFBF, 0xFF92, 0xFF7E, 
	0xFF88, 0xFFA0, 0xFFBF, 0xFFDE, 0xFFF5, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFE5B, 0xFABF, 0xF723, 0xF57F, 
	0xF646, 0xF838, 0xFABF, 0xFD46, 0xFF38, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x4A21, 0x497F, 0x4138, 0x3339, 0x2A0B, 0x2750, 
	0x2582, 0x246D, 0x23DE, 0x23A3, 0x2388, 0x2362, 0x2326, 0x22D8, 0x227B, 
	0x2212, 0x21A1, 0x212B, 0x20B4, 0x203E, 0x1FCD, 0x1F64, 0x1F07, 0x1EB9, 
	0x1E7D, 0x1E57, 0x1E4A, 0x09D3, 0x0914, 0x084E, 0x07B8, 0x06F7, 0x05CA, 
	0x0453, 0x02C9, 0x0168, 0x0069, 0x0005, 0x0004, 0x0004, 0x0004, 0x0004, 
	0x0003, 0x0003, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFE32, 0xFD43, 0xFDDD, 0xFE13, 0xFE25, 0xFE48, 
	0xFE7E, 0xFEBB, 0xFEF4, 0xFF1E, 0xFF2F, 0xABC3, 0xADC6, 0xB82F, 0xBBE4, 
	0xBCDC, 0xBE53, 0xC091, 0xC322, 0xC591, 0xC76B, 0xC83A, 0xC846, 0xC858, 
	0xC870, 0xC88D, 0xC8AD, 0xC8D0, 0xC8F4, 0xC919, 0xC93D, 0xC960, 0xC980, 
	0xC99D, 0xC9B5, 0xC9C7, 0xC9D3, 0xC9D7, 

},{ 
	0x0001, 0x0000, 0x0004, 0x0001, 0x000B, 0x0005, 0x0001, 0x0010, 0x0001, 
	0x0011, 0x0001, 0x0012, 0x0006, 0x0013, 0x0001, 0x0019, 0x000B, 0x001A, 
	0x001B, 0x0025, 0x0002, 0x0040, 0x001B, 0x0042, 0x001B, 0x005D, 0x001B, 
	0x0078, 0x001B, 0x0093, 0x0001, 0x00AE, 0x0001, 0x00AF, 0x0001, 0x00B0, 
	0x001B, 0x00B1, 0x001B, 0x00CC, 0x001B, 0x00E7, 0x001A, 0x0102, 0x001B, 
	0x011C, 0x001B, 0x0137, 0x001B, 0x0152, 0x001B, 0x016D, 0x001B, 0x0188, 
	0x0001, 0x01A3, 0x0001, 0x01A4, 0x0001, 0x01A5, 0x001B, 0x01A6, 0x001B, 
	0x01C1, 0x001B, 0x01DC, 0x0018, 0x01F7, 0x001A, 0x020F, 0x001B, 0x0229, 
	0x001B, 0x0244, 0x001B, 0x025F, 0x001B, 0x027A, 0x0009, 0x0295, 0x000B, 
	0x029E, 0x0001, 0x02A9, 0x001B, 0x02AA, 0x001B, 0x02C5, 0x001B, 0x02E0, 
	0x000A, 0x02FB, 0x000B, 0x0305, 0x001B, 0x0310, 0x000B, 0x032B, 0x0009, 
	0x0336, 0x001B, 0x033F, 0x0008, 0x035A, 0x000A, 0x0362, 0x0001, 0x036C, 
	0x001B, 0x036D, 0x001B, 0x0388, 0x001B, 0x03A3, 0x001B, 0x03BE, 0x001A, 
	0x03D9, 0x001B, 0x03F3, 0x001B, 0x040E, 0x000B, 0x0429, 0x001B, 0x0434, 
	

});

smlua_anim_util_register_animation('donkey_28_standup_from_lava_boost',1, 0, 0, 0, 14, { 
	0x0000, 0x002F, 0x002F, 0x0032, 0x0037, 0x003E, 0x0046, 0x0051, 0x005D, 
	0x0069, 0x0074, 0x007C, 0x0083, 0x0087, 0x008A, 0x008B, 0x0000, 0x0000, 
	0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x3B1B, 
	0x399E, 0x367D, 0x33BC, 0x335E, 0x3886, 0x40BB, 0x4593, 0x4643, 0x47DD, 
	0x4AF9, 0x4ECB, 0x5284, 0x5556, 0x5675, 0x0000, 0xFFFF, 0x0000, 0x0B68, 
	0x07AD, 0xFFB1, 0xF844, 0xF638, 0x007A, 0x116F, 0x1B21, 0x1BC0, 0x19F6, 
	0x157E, 0x0FAF, 0x09E0, 0x0569, 0x039F, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0826, 0x0826, 0x0826, 0x0826, 
	0x0826, 0x07F3, 0x0766, 0x068E, 0x0443, 0x0075, 0xFBC2, 0xF6E0, 0xF284, 
	0xEF62, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x2A0A, 0x2995, 0x28EC, 0x28D3, 
	0x2A0B, 0x2FB9, 0x3758, 0x3931, 0x2E1D, 0x2B21, 0x2A57, 0x2A47, 0x297D, 
	0x2681, 0x1DCC, 0xD336, 0xD2B9, 0xD203, 0xD1E8, 0xD337, 0xD875, 0xDFC9, 
	0xE37B, 0xE1B8, 0xE03D, 0xDF92, 0xDEC4, 0xDCDE, 0xD8EE, 0xD901, 0xEE79, 
	0xEFC7, 0xF1A9, 0xF1F3, 0xEE75, 0xE0F3, 0xCDE0, 0xC31D, 0xC268, 0xC252, 
	0xC1B8, 0xC015, 0xBCE5, 0xB7A4, 0xB867, 0x0000, 0xEC1F, 0xEDF0, 0xEF75, 
	0xF0B2, 0xF1B1, 0xF277, 0xF30C, 0xF377, 0xF3BE, 0xF3EA, 0xF400, 0xF408, 
	0xF409, 0x0000, 0x0000, 0xF841, 0xFB39, 0xFDB3, 0xFFB9, 0x015A, 0x029D, 
	0x0390, 0x043F, 0x04B3, 0x04FA, 0x051F, 0x052C, 0x052E, 0x0000, 0xC00E, 
	0xBB92, 0xBDBB, 0xC34B, 0xCAE7, 0xD331, 0xDACC, 0xE05D, 0xE285, 0xE264, 
	0xE17D, 0xDF0A, 0xDA46, 0xD269, 0xC9F4, 0xB53D, 0xB595, 0xB6C9, 0xB93C, 
	0xBD51, 0xC592, 0xD09D, 0xD8EF, 0xE390, 0xEEE1, 0xF945, 0x01D3, 0x07A0, 
	0x09C3, 0x071C, 0xE3D7, 0xE8D8, 0xF287, 0xFBE4, 0xFFEE, 0xF813, 0xE9B2, 
	0xE1B5, 0xE38B, 0xE763, 0xEBF8, 0xF060, 0xF3B0, 0xF4FF, 0x0306, 0x019B, 
	0x08E1, 0x172B, 0x2579, 0x2CCC, 0x2616, 0x1721, 0x0C2D, 0x02C3, 0x02C9, 
	0x02F3, 0x0365, 0x0443, 0x05B2, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0xD6DC, 
	0xD754, 0xD802, 0xD81C, 0xD6DB, 0xD10A, 0xC939, 0xC741, 0xCBE2, 0xCBC9, 
	0xCB1A, 0xC93F, 0xC5A2, 0x3FAD, 0x36DA, 0x2F54, 0x3000, 0x30F9, 0x311F, 
	0x2F52, 0x2830, 0x1E30, 0x18F9, 0x1949, 0x19A2, 0x1A58, 0x1C18, 0x1F90, 
	0x5A93, 0x54F5, 0xE7FA, 0xE952, 0xEB43, 0xEB8F, 0xE7F6, 0xDA0B, 0xC664, 
	0xBB49, 0xBA19, 0xB9DD, 0xB834, 0xB3B4, 0xAAEF, 0x1C7C, 0x175C, 0xFFFF, 
	0x07E9, 0x2694, 0x345D, 0x3805, 0x384D, 0x3BF6, 0x49BF, 0x6869, 0x4E5D, 
	0x4D3C, 0x455B, 0x2FF6, 0x064D, 0xFFFF, 0xFFFF, 0x0B52, 0x0BA5, 0x0C7C, 
	0x0DA1, 0x0EE1, 0x1006, 0x10DD, 0x1130, 0x0452, 0x0423, 0x02D6, 0xFF4F, 
	0xF872, 0xFFFF, 0xC078, 0xC00D, 0xC03E, 0xC18F, 0xC523, 0xCC1B, 0xD797, 
	0xE8BA, 0x00A5, 0xFBEC, 0xFB65, 0xF7B8, 0xEDBF, 0xDA52, 0xCB60, 0x4C08, 
	0x4BB3, 0x4AB0, 0x48D2, 0x45EF, 0x40D1, 0x39E8, 0x3381, 0xF7CC, 0xF1AB, 
	0xEDF3, 0xEC0B, 0xEB57, 0xEB3D, 0xFA42, 0x11A0, 0x0D25, 0x0457, 0xFB89, 
	0xF709, 0xFBB7, 0x057D, 0x0B3B, 0x0B79, 0x0B79, 0x0B79, 0x0B79, 0x0B79, 
	0x0B79, 0x0197, 0xFC5D, 0x03C0, 0x1227, 0x2055, 0x270B, 0x1E1B, 0x0C2E, 
	0x004F, 0xFCE7, 0xFCE7, 0xFCE7, 0xFCE7, 0xFCE7, 0xFCE7, 0x0624, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF5E, 0x03A2, 0x03A2, 0x03A2, 0x03A2, 0x03A2, 0x02D3, 0x00A9, 
	0xFD87, 0xF99A, 0xF8EA, 0xF8BB, 0xF8B7, 0xF889, 0xF7D8, 0xFE9B, 0xE5C0, 
	0xE5C0, 0xE5C0, 0xE5C0, 0xE5C0, 0xE5DE, 0xE62E, 0xE6A2, 0xE732, 0xE92E, 
	0xEC3F, 0xEF86, 0xF221, 0xF331, 0xEFF9, 0x6A17, 0x6A17, 0x6A17, 0x6A17, 
	0x6A17, 0x6B63, 0x6EE5, 0x7410, 0x7A9B, 0x7FE5, 0x837B, 0x85AB, 0x86C1, 
	0x870D, 0x839E, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x22A4, 0x23E2, 0x2708, 
	0x2BDA, 0x321C, 0x3E18, 0x4CEC, 0x53A4, 0x518A, 0x4EE9, 0x4CEC, 0x4B81, 
	0x4A94, 0x4A14, 0x49EE, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x01BD, 
	0x044F, 0x0648, 0x0752, 0x0743, 0x06DB, 0x05BF, 0x0398, 0x000A, 0xF7AE, 
	0xFEF8, 0xFEF8, 0xFEF8, 0xFEF8, 0xFEF8, 0xFEE0, 0xFEBD, 0xFEC5, 0xFF09, 
	0xFFBA, 0x00B0, 0x01AB, 0x026F, 0x02BE, 0x03C6, 0xD125, 0xD125, 0xD125, 
	0xD125, 0xD125, 0xCD85, 0xC62C, 0xC066, 0xBD6B, 0xBC02, 0xBAA6, 0xB7D9, 
	0xB21D, 0xA7F0, 0xAB92, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xF971, 0xF971, 
	0xF971, 0xF971, 0xF971, 0xFA02, 0xFB95, 0xFDFC, 0x0107, 0x0108, 0x010D, 
	0x011B, 0x0137, 0x0165, 0x01C0, 0x1C45, 0x1C45, 0x1C45, 0x1C45, 0x1C45, 
	0x1C16, 0x1B92, 0x1AC8, 0x19C9, 0x189B, 0x1746, 0x15D2, 0x1445, 0x12AA, 
	0x1192, 0x634A, 0x634A, 0x634A, 0x634A, 0x634A, 0x6485, 0x67F0, 0x6D27, 
	0x73C3, 0x79EB, 0x7F04, 0x82E0, 0x8552, 0x862D, 0x842B, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x29B6, 0x2B7B, 0x2F74, 0x34A1, 0x39FE, 0x41F3, 0x4AF3, 0x4E11, 
	0x4E11, 0x4E11, 0x4E11, 0x4E11, 0x4E11, 0x4E11, 0x4A21, 0x001B, 0x001B, 
	0x001B, 0x001B, 0x001B, 0xFEAB, 0xFBED, 0xFA3D, 0xFA33, 0xFBC3, 0xFF7E, 
	0x03F2, 0x07AC, 0x093D, 0x09D3, 0x025B, 0x025B, 0x025B, 0x025B, 0x025B, 
	0x0258, 0x0243, 0x020D, 0x01B0, 0x015D, 0x010D, 0x00A1, 0xFFFE, 0xFF0A, 
	0xFE32, 0xCB24, 0xCB24, 0xCB24, 0xCB24, 0xCB24, 0xCA56, 0xC8A7, 0xC72E, 
	0xC613, 0xC549, 0xC36E, 0xBEC8, 0xB59B, 0xA62C, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x000F, 0x0001, 0x0001, 0x0010, 0x0001, 0x0011, 0x0001, 
	0x0012, 0x0001, 0x0013, 0x0001, 0x0014, 0x000E, 0x0015, 0x000F, 0x0023, 
	0x0001, 0x0032, 0x0002, 0x0033, 0x000F, 0x0035, 0x000E, 0x0044, 0x000D, 
	0x0052, 0x000F, 0x005F, 0x0001, 0x006E, 0x0001, 0x006F, 0x0001, 0x0070, 
	0x000F, 0x0071, 0x000F, 0x0080, 0x000F, 0x008F, 0x000F, 0x009E, 0x000F, 
	0x00AD, 0x000F, 0x00BC, 0x000F, 0x00CB, 0x000F, 0x00DA, 0x000F, 0x00E9, 
	0x0001, 0x00F8, 0x0001, 0x00F9, 0x0001, 0x00FA, 0x000F, 0x00FB, 0x000F, 
	0x010A, 0x000F, 0x0119, 0x000F, 0x0128, 0x000F, 0x0137, 0x000F, 0x0146, 
	0x000F, 0x0155, 0x000F, 0x0164, 0x000F, 0x0173, 0x000F, 0x0182, 0x000E, 
	0x0191, 0x0001, 0x019F, 0x000F, 0x01A0, 0x000F, 0x01AF, 0x000F, 0x01BE, 
	0x0007, 0x01CD, 0x000F, 0x01D4, 0x000F, 0x01E3, 0x000F, 0x01F2, 0x000F, 
	0x0201, 0x000F, 0x0210, 0x000F, 0x021F, 0x000F, 0x022E, 0x0001, 0x023D, 
	0x000F, 0x023E, 0x000F, 0x024D, 0x000F, 0x025C, 0x0006, 0x026B, 0x000F, 
	0x0271, 0x000F, 0x0280, 0x000F, 0x028F, 0x000F, 0x029E, 0x000F, 0x02AD, 
	

});

smlua_anim_util_register_animation('donkey_31_throw_catch_key',1, 0, 0, 0, 139, { 
	0x0000, 0x008B, 0x008B, 0x008C, 0x008C, 0x008D, 0x008E, 0x008F, 0x0090, 
	0x0092, 0x0094, 0x0096, 0x0098, 0x0099, 0x009B, 0x009C, 0x009D, 0x009E, 
	0x009F, 0x009F, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x009F, 0x009E, 
	0x009C, 0x009A, 0x0097, 0x0093, 0x0090, 0x008B, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0xFFFF, 0xFFFE, 0x5675, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0013, 0x003F, 0x0072, 0x0098, 0x009E, 
	0x0072, 0xFFFF, 0xFF47, 0xFE5B, 0xFD47, 0xFC18, 0xFAD8, 0xF993, 0xF855, 
	0xF72A, 0xF693, 0xF685, 0xF665, 0xF63E, 0xF61A, 0xF605, 0xF60B, 0xF636, 
	0xF693, 0xF75A, 0xF8A7, 0xFA53, 0xFC37, 0xFEB4, 0x01BA, 0x047C, 0x062A, 
	0x06E6, 0x075C, 0x078F, 0x077E, 0x072D, 0x069D, 0x05CE, 0x04C1, 0x037C, 
	0x0209, 0x0073, 0xFEC6, 0xFD0D, 0xFB53, 0xF9A3, 0xF808, 0xF68D, 0xF53E, 
	0xF465, 0xF445, 0xF4DF, 0xF67F, 0xF8DA, 0xFB12, 0xFD1B, 0xFF01, 0x000B, 
	0x0060, 0x00A4, 0x00D9, 0x0100, 0x011B, 0x012B, 0x0132, 0x0131, 0x012A, 
	0x011F, 0x0110, 0x00FF, 0x00EE, 0x00B3, 0x003A, 0xFFAB, 0xFF2C, 0xFEE4, 
	0xFEC8, 0xFEB3, 0xFEA5, 0xFE9C, 0xFE99, 0xFE9A, 0xFE9F, 0xFEA6, 0xFEB0, 
	0xFEBA, 0xFEC6, 0xFED1, 0xFEE1, 0xFEF8, 0xFF14, 0xFF35, 0xFF57, 0xFF79, 
	0xFF79, 0xFF79, 0xFF79, 0xFF79, 0xFF79, 0xFF79, 0xFF79, 0xFF79, 0x0000, 
	0x0000, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0008, 0x001D, 0x0034, 0x0046, 0x0049, 0x0034, 0xFFFF, 0xFFAA, 0xFF3D, 
	0xFEBD, 0xFE31, 0xFD9D, 0xFD06, 0xFC73, 0xFBE9, 0xFBA3, 0xFB8C, 0xFB56, 
	0xFB13, 0xFAD6, 0xFAB3, 0xFABC, 0xFB06, 0xFBA3, 0xFDD0, 0x0170, 0x0490, 
	0x0539, 0x01A5, 0xFB4A, 0xF510, 0xF1E1, 0xF1F9, 0xF359, 0xF58D, 0xF820, 
	0xFA9F, 0xFC96, 0xFD91, 0xFDC8, 0xFDC5, 0xFD8E, 0xFD2B, 0xFCA3, 0xFBFE, 
	0xFB44, 0xFA7B, 0xF9AB, 0xF8DB, 0xF813, 0xF657, 0xF3FB, 0xF2F7, 0xF474, 
	0xF74B, 0xFA02, 0xFC7E, 0xFEDB, 0xFFF2, 0xFFF3, 0xFFD2, 0xFF94, 0xFF3F, 
	0xFED6, 0xFE5F, 0xFDDF, 0xFD5B, 0xFCD8, 0xFC5B, 0xFBE8, 0xFB85, 0xFB36, 
	0xFB06, 0xFAF5, 0xFAFE, 0xFB19, 0xFB40, 0xFB6C, 0xFB9F, 0xFBD6, 0xFC11, 
	0xFC4F, 0xFC8E, 0xFCCF, 0xFD0F, 0xFD4E, 0xFD8B, 0xFDC5, 0xFDFA, 0xFE2C, 
	0xFE5C, 0xFE89, 0xFEB5, 0xFEDE, 0xFF06, 0xFF06, 0xFF06, 0xFF06, 0xFF06, 
	0xFF06, 0xFF06, 0xFF06, 0xFF06, 0x0000, 0x039F, 0x0247, 0x0230, 0x01EE, 
	0x0183, 0x00F1, 0x003B, 0xFF62, 0xFE6B, 0xFD56, 0xFC28, 0xFAE1, 0xF984, 
	0xF814, 0xF694, 0xF505, 0xF36A, 0xF1C6, 0xF01B, 0xEE6B, 0xECB9, 0xEB1A, 
	0xE9D4, 0xE924, 0xE96B, 0xEA6A, 0xEB7E, 0xEBFF, 0xEB08, 0xE931, 0xE80B, 
	0xE924, 0xEEC8, 0xF780, 0xFF41, 0x01FF, 0xFF3D, 0xF9E4, 0xF2FF, 0xEB9B, 
	0xE4C4, 0xDF85, 0xDCEB, 0xDCCB, 0xDE10, 0xE06F, 0xE398, 0xE73D, 0xEB11, 
	0xEEC5, 0xF20B, 0xF38A, 0xF36F, 0xF32E, 0xF2DE, 0xF295, 0xF26B, 0xF276, 
	0xF2CE, 0xF38A, 0xF5FA, 0xFA0A, 0xFDBA, 0xFF08, 0xFC79, 0xF770, 0xF237, 
	0xEF1C, 0xEE20, 0xEDB2, 0xEDBB, 0xEE27, 0xEEDF, 0xEFCE, 0xF0DE, 0xF216, 
	0xF384, 0xF51E, 0xF6D9, 0xF8AB, 0xFA8A, 0xFC6B, 0xFE43, 0x0009, 0x01B2, 
	0x0333, 0x0434, 0x0496, 0x04A7, 0x046D, 0x03E3, 0x0342, 0x02A3, 0x01EE, 
	0x0116, 0x0010, 0xFEE1, 0xFD95, 0xFC38, 0xFAD5, 0xF978, 0xF82D, 0xF6FE, 
	0xF5F9, 0xF527, 0xF496, 0xF44F, 0xF460, 0xF60E, 0xF9CE, 0xFE70, 0x02C4, 
	0x059B, 0x074B, 0x08EE, 0x0A7E, 0x0BF5, 0x0D4D, 0x0E80, 0x0F88, 0x105F, 
	0x10FD, 0x115E, 0x117C, 0x114F, 0x1078, 0x0EC5, 0x0C72, 0x09BC, 0x06E0, 
	0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 0x041B, 
	0x039F, 0x0000, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 
	0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD25, 
	0xFD25, 0xFD25, 0xFD25, 0xFD25, 0xFD46, 0xFD77, 0xFDB0, 0xFDED, 0xFE27, 
	0xFE58, 0xFE7B, 0xFE8A, 0xFE80, 0xFE56, 0xFE06, 0xFD8B, 0xFCE0, 0xFBE3, 
	0xFA85, 0xF8DA, 0xF6F5, 0xF4EA, 0xF2CC, 0xF0AE, 0xEEA5, 0xECC3, 0xEB1C, 
	0xE9C4, 0xE945, 0xE9C0, 0xEAA3, 0xEB5F, 0xEC05, 0xECAE, 0xECEE, 0xED29, 
	0xED6F, 0xEDB3, 0xEDE6, 0xEDF8, 0xEDDB, 0xED81, 0xECDB, 0xEB0C, 0xE800, 
	0xE4D6, 0xE2AB, 0xE172, 0xE0B0, 0xE0E0, 0xE280, 0xE58C, 0xE978, 0xEDEA, 
	0xF28D, 0xF709, 0xFB08, 0xFE31, 0x007A, 0x022C, 0x0376, 0x0485, 0x0587, 
	0x06A9, 0x0818, 0x0A02, 0x0DFC, 0x1346, 0x168D, 0x178E, 0x1841, 0x18B2, 
	0x18E9, 0x18F1, 0x18D4, 0x189C, 0x1852, 0x1802, 0x17AA, 0x1744, 0x16D0, 
	0x164D, 0x15BE, 0x1522, 0x147A, 0x13C7, 0x1308, 0x123E, 0x116A, 0x108C, 
	0x0FA5, 0x0E86, 0x0D10, 0x0B56, 0x0970, 0x0771, 0x0533, 0x02A0, 0xFFE2, 
	0xFD23, 0xFA8D, 0xF84C, 0xF689, 0xF570, 0xF4F3, 0xF4E1, 0xF525, 0xF5AF, 
	0xF66B, 0xF748, 0xF833, 0xF91A, 0xF9EB, 0xFA93, 0xFB56, 0xFC39, 0xFD2A, 
	0xFE18, 0xFEF0, 0xFFA0, 0x0018, 0x0044, 0x0000, 0x0000, 0x017D, 0x017D, 
	0x017D, 0x017D, 0x017D, 0x017D, 0x017D, 0x017D, 0x017D, 0x017D, 0x017D, 
	0x017D, 0x017D, 0x017D, 0x017D, 0x017C, 0x017C, 0x017C, 0x017C, 0x017C, 
	0x017A, 0x0174, 0x016A, 0x015E, 0x014F, 0x013F, 0x012F, 0x011F, 0x0110, 
	0x0103, 0x00F8, 0x00F1, 0x00EE, 0x00FB, 0x011B, 0x0142, 0x0160, 0x016A, 
	0x0151, 0x011D, 0x00E1, 0x00AF, 0x009B, 0x00B8, 0x0156, 0x0262, 0x035A, 
	0x03BB, 0x0292, 0x00B6, 0x0010, 0xFFDF, 0xFFCC, 0xFFCE, 0xFFDF, 0xFFF9, 
	0x0014, 0x0029, 0x0031, 0x0035, 0x003A, 0x003B, 0x0031, 0x001A, 0xFFF8, 
	0xFFD2, 0xFFAD, 0xFF88, 0xFF5F, 0xFF34, 0xFF0C, 0xFEE7, 0xFEC8, 0xFEB2, 
	0xFEBA, 0xFEE7, 0xFF26, 0xFF62, 0xFF88, 0xFF84, 0xFF44, 0xFEB2, 0xFC5A, 
	0xF8AC, 0xF66F, 0xF5F8, 0xF5BC, 0xF5B2, 0xF5D1, 0xF610, 0xF666, 0xF6CA, 
	0xF734, 0xF79A, 0xF807, 0xF889, 0xF91C, 0xF9BA, 0xFA61, 0xFB0C, 0xFBB7, 
	0xFC5E, 0xFCFC, 0xFD8E, 0xFE0F, 0xFE7C, 0xFECF, 0xFEBC, 0xFE2C, 0xFD69, 
	0xFCC0, 0xFC7B, 0xFC96, 0xFCD5, 0xFD2F, 0xFD98, 0xFE09, 0xFE77, 0xFED9, 
	0xFF25, 0xFF62, 0xFF9D, 0xFFD5, 0x000A, 0x003B, 0x0066, 0x008C, 0x00AB, 
	0x00C3, 0x00D3, 0x00D3, 0x00D2, 0x00D0, 0x00CD, 0x00C7, 0x00BD, 0x00B1, 
	0x00A0, 0x0000, 0xEE2F, 0xEFF6, 0xF2BA, 0xF59A, 0xF88F, 0xFB91, 0xFE99, 
	0x01A0, 0x049C, 0x0786, 0x0A58, 0x0D09, 0x0F92, 0x11EB, 0x140D, 0x15F0, 
	0x178C, 0x18DA, 0x19D1, 0x1A6C, 0x1AA1, 0x1A85, 0x1A30, 0x19AC, 0x1903, 
	0x183F, 0x176B, 0x1690, 0x15B9, 0x14F1, 0x1441, 0x13B3, 0x1352, 0x1328, 
	0x13E3, 0x15A7, 0x17B5, 0x194B, 0x19A9, 0x1890, 0x1688, 0x1401, 0x1169, 
	0x0F2D, 0x0DBD, 0x0DCD, 0x0F0D, 0x1061, 0x10AB, 0x0E41, 0x0AC7, 0x0990, 
	0x0932, 0x090C, 0x0910, 0x0932, 0x0963, 0x0997, 0x09C0, 0x09D1, 0x09F2, 
	0x0A29, 0x0A34, 0x09D1, 0x08FE, 0x07DA, 0x0651, 0x044D, 0x01B5, 0xFEA3, 
	0xFB57, 0xF80F, 0xF50A, 0xF287, 0xF0C4, 0xEFA4, 0xEEDE, 0xEE6D, 0xEE4E, 
	0xEE7E, 0xEEF9, 0xEFBC, 0xF0C4, 0xF43F, 0xF9CA, 0xFD83, 0xFEEA, 0x0015, 
	0x0109, 0x01C8, 0x0258, 0x02BD, 0x02FA, 0x0315, 0x030F, 0x02D8, 0x0261, 
	0x01B9, 0x00EC, 0x0008, 0xFF19, 0xFE2E, 0xFD54, 0xFC97, 0xFC06, 0xFBAD, 
	0xFB99, 0xFBD9, 0xFDA8, 0x015C, 0x05A6, 0x0938, 0x0AC5, 0x0A50, 0x08EE, 
	0x06E8, 0x0486, 0x0213, 0xFFD7, 0xFE1B, 0xFD27, 0xFCED, 0xFD1E, 0xFDA1, 
	0xFE5F, 0xFF3F, 0x002A, 0x0109, 0x01C2, 0x023F, 0x0267, 0x0178, 0xFF02, 
	0xFB87, 0xF78B, 0xF38E, 0xF014, 0xED9F, 0xECB0, 0xEE2F, 0x0001, 0xFFFE, 
	0xC170, 0x1DCC, 0x1CDD, 0x1CDB, 0x1CD4, 0x1CCB, 0x1CBE, 0x1CAE, 0x1C9D, 
	0x1C8A, 0x1C75, 0x1C60, 0x1C4B, 0x1C36, 0x1C21, 0x1C0E, 0x1BFC, 0x1BED, 
	0x1BE0, 0x1BD6, 0x1BD0, 0x1BCE, 0x1C09, 0x1C32, 0x1C75, 0x1CFE, 0x1DB9, 
	0x1E76, 0x1F33, 0x1FEE, 0x20A8, 0x215E, 0x2210, 0x22BC, 0x2362, 0x23FF, 
	0x2494, 0x251F, 0x259E, 0x2611, 0x2676, 0x26CD, 0x2714, 0x274A, 0x2722, 
	0x2670, 0x2562, 0x2424, 0x22E6, 0x21D4, 0x2125, 0x2128, 0x2151, 0x218C, 
	0x2219, 0x22C8, 0x2366, 0x23C1, 0x23A8, 0x22E9, 0x2151, 0x1F29, 0x1CDA, 
	0x1A68, 0x17D6, 0x1527, 0x1260, 0x0F82, 0x0C93, 0x0994, 0x068A, 0x0377, 
	0x0060, 0xFD47, 0xFA30, 0xF71F, 0xF416, 0xF119, 0xEE2B, 0xEB50, 0xE88B, 
	0xE5DF, 0xE351, 0xE0E2, 0xE0A8, 0xE2A9, 0xE3DA, 0xE2C0, 0xE0D4, 0xDF7A, 
	0xDE1E, 0xDBEC, 0xD9DE, 0xD8EF, 0xDA1A, 0xDE59, 0xE53B, 0xED7A, 0xF6CF, 
	0x00F4, 0x0BA3, 0x1696, 0x2186, 0xAC2D, 0xB646, 0xBF89, 0xC7B2, 0xCE79, 
	0xD399, 0xD2E8, 0xCACF, 0xBEE8, 0x32CB, 0x2A0D, 0x2477, 0x1FA5, 0x1BEA, 
	0x199B, 0x190C, 0x1B67, 0x2074, 0x2674, 0x2BA8, 0x2E52, 0x2EA5, 0x2E17, 
	0x2CC9, 0x2ADE, 0x2879, 0x25BB, 0x22C7, 0x1F3A, 0x1F2A, 0x1F21, 0x1F1E, 
	0x1F1E, 0x1F1D, 0x1F1A, 0x1F12, 0x1F01, 0x1DCC, 0xD901, 0xD596, 0xD67F, 
	0xD749, 0xD7F7, 0xD88B, 0xD908, 0xD970, 0xD9C6, 0xDA0C, 0xDA45, 0xDA73, 
	0xDA98, 0xDAB8, 0xDAD4, 0xDAEF, 0xDB0C, 0xDB2C, 0xDB53, 0xDB83, 0xDBBE, 
	0xDC00, 0xDC2F, 0xDC42, 0xDC35, 0xDC16, 0xDBFA, 0xDBDF, 0xDBC4, 0xDBA7, 
	0xDB87, 0xDB62, 0xDB36, 0xDB02, 0xDAC4, 0xDA7B, 0xDA24, 0xD9BF, 0xD94B, 
	0xD8C4, 0xD82A, 0xD77B, 0xD6B6, 0xD56F, 0xD369, 0xD0EB, 0xCE37, 0xCB93, 
	0xC943, 0xC7A9, 0xC7AF, 0xC815, 0xC80D, 0xC7F9, 0xC7E1, 0xC7CB, 0xC7BE, 
	0xC7C1, 0xC7DC, 0xC815, 0xC85C, 0xC89E, 0xC8DC, 0xC917, 0xC951, 0xC989, 
	0xC9C2, 0xC9FC, 0xCA39, 0xCA7A, 0xCABF, 0xCB0B, 0xCB5D, 0xCBB8, 0xCC1C, 
	0xCC8B, 0xCD05, 0xCD8D, 0xCE22, 0xCEC5, 0xCF7A, 0xD03F, 0xD117, 0xD408, 
	0xD979, 0xDEF5, 0xE4CD, 0xEAB1, 0xED3F, 0xEC08, 0xE94F, 0xE5C1, 0xE209, 
	0xDED4, 0xDCCD, 0xDBAB, 0xDAB0, 0xD9D8, 0xD920, 0xD884, 0xD803, 0xD798, 
	0xA8BE, 0xA905, 0xA940, 0xA971, 0xA99B, 0xA9C1, 0xA964, 0xA854, 0xA70E, 
	0xD9EC, 0xDA23, 0xD90C, 0xD6FB, 0xD4BC, 0xD318, 0xD2DA, 0xD492, 0xD7B7, 
	0xDB75, 0xDEF3, 0xE15B, 0xE2DF, 0xE436, 0xE54D, 0xE614, 0xE67A, 0xE66C, 
	0xE5DA, 0xE4A1, 0xE3B3, 0xE31C, 0xE299, 0xE1EB, 0xE0CF, 0xDF06, 0xDC4D, 
	0xD864, 0xD901, 0xB867, 0xB796, 0xB7EB, 0xB82D, 0xB861, 0xB886, 0xB8A0, 
	0xB8B1, 0xB8BB, 0xB8BF, 0xB8C0, 0xB8C0, 0xB8C1, 0xB8C6, 0xB8CF, 0xB8E0, 
	0xB8FA, 0xB920, 0xB953, 0xB996, 0xB9EA, 0xBA60, 0xBACB, 0xBAF3, 0xBA9F, 
	0xB9EA, 0xB915, 0xB826, 0xB724, 0xB614, 0xB4FC, 0xB3E1, 0xB2C9, 0xB1BA, 
	0xB0B9, 0xAFCC, 0xAEFA, 0xAE46, 0xADB8, 0xAD55, 0xAD23, 0xAD27, 0xAD67, 
	0xAEBA, 0xB19A, 0xB57E, 0xB9E0, 0xBE37, 0xC1FB, 0xC47C, 0xC471, 0xC3D6, 
	0xC3D7, 0xC3DA, 0xC3DE, 0xC3E2, 0xC3E4, 0xC3E3, 0xC3DF, 0xC3D6, 0xC3D2, 
	0xC3DE, 0xC3F7, 0xC41A, 0xC446, 0xC478, 0xC4AD, 0xC4E4, 0xC519, 0xC54B, 
	0xC577, 0xC59B, 0xC5B4, 0xC5C0, 0xC5BD, 0xC5A9, 0xC580, 0xC541, 0xC4E9, 
	0xC476, 0xC3E5, 0xC335, 0xC262, 0xBD17, 0xB38F, 0xACA1, 0xAB64, 0xACC1, 
	0xAE49, 0xAFA8, 0xB1BA, 0xB3D6, 0xB556, 0xB590, 0xB3DD, 0xB075, 0xAC21, 
	0xA714, 0xA17F, 0x9B94, 0x9585, 0x8F84, 0x09C4, 0x0473, 0xFFC3, 0xFBEB, 
	0xF91A, 0xF782, 0xFA77, 0x0340, 0x0EEC, 0x9A96, 0xA359, 0xA986, 0xAF0F, 
	0xB375, 0xB63B, 0xB6E2, 0xB41E, 0xAE43, 0xA744, 0xA113, 0x9DA4, 0x9CAD, 
	0x9C8C, 0x9D2F, 0x9E85, 0xA07C, 0xA302, 0xA606, 0xA9F4, 0xADB4, 0xB0F2, 
	0xB3AE, 0xB5EB, 0xB7A7, 0xB8E4, 0xB9A2, 0xB9E1, 0xB867, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xC9F4, 0xC92F, 0xC90E, 0xC8B2, 0xC820, 
	0xC760, 0xC67A, 0xC573, 0xC454, 0xC323, 0xC1E7, 0xC0A8, 0xBF6C, 0xBE3B, 
	0xBD1C, 0xBC15, 0xBB2F, 0xBA6F, 0xB9DD, 0xB981, 0xB960, 0xB9C9, 0xBA4D, 
	0xBAD1, 0xBB3B, 0xBB92, 0xBBED, 0xBC4C, 0xBCB1, 0xBD1B, 0xBD8B, 0xBE02, 
	0xBE80, 0xBF06, 0xBF94, 0xC02B, 0xC0CB, 0xC175, 0xC229, 0xC2E8, 0xC3B2, 
	0xC488, 0xC56B, 0xC6A6, 0xC865, 0xCA76, 0xCCA9, 0xCECB, 0xD0AB, 0xD1FE, 
	0xD1F9, 0xD1A4, 0xD196, 0xD174, 0xD14A, 0xD124, 0xD10E, 0xD114, 0xD142, 
	0xD1A4, 0xD22D, 0xD2CA, 0xD377, 0xD432, 0xD4FA, 0xD5CC, 0xD6A7, 0xD789, 
	0xD86F, 0xD957, 0xDA40, 0xDB27, 0xDC0B, 0xDCE9, 0xDDC0, 0xDE8D, 0xDF4E, 
	0xE001, 0xE0A5, 0xE138, 0xE1B6, 0xE21F, 0xE270, 0xE2A7, 0xE2C3, 0xE2C0, 
	0xDDA9, 0xD45D, 0xCF9A, 0xD18F, 0xD5CE, 0xDB2E, 0xE085, 0xE4A7, 0xE66B, 
	0xE66A, 0xE60C, 0xE557, 0xE456, 0xE310, 0xE18E, 0xDFD9, 0xDDF9, 0xDBF7, 
	0xD9DC, 0xD7AF, 0xD57A, 0xD345, 0xD051, 0xCC3C, 0xC796, 0xC2F4, 0xBEE6, 
	0xBB2B, 0xB761, 0xB3EC, 0xB12D, 0xAF88, 0xB0DE, 0xB48B, 0xB728, 0xB7EE, 
	0xB86B, 0xB8B4, 0xB8DF, 0xB901, 0xB930, 0xB980, 0xBA08, 0xBADD, 0xBC1C, 
	0xBE0C, 0xC08C, 0xC35B, 0xC638, 0xC8E3, 0xCB1A, 0xCC9E, 0xCD2E, 0xC9F4, 
	0x071C, 0xFAE8, 0xFAE8, 0xFAE5, 0xFADF, 0xFAD2, 0xFABD, 0xFA9E, 0xFA73, 
	0xFA39, 0xF9EF, 0xF992, 0xF921, 0xF899, 0xF7F8, 0xF73D, 0xF665, 0xF56F, 
	0xF457, 0xF31C, 0xF1BD, 0xEEA9, 0xEBF8, 0xE9DD, 0xE88A, 0xE7C9, 0xE742, 
	0xE6ED, 0xE6C3, 0xE6BF, 0xE6DA, 0xE70E, 0xE754, 0xE7A6, 0xE7FE, 0xE855, 
	0xE8A4, 0xE8E7, 0xE915, 0xE92A, 0xE91D, 0xE8EA, 0xE88A, 0xE7A5, 0xE614, 
	0xE413, 0xE1DE, 0xDFB4, 0xDDD0, 0xDC86, 0xDC8B, 0xDCDC, 0xDD04, 0xDD63, 
	0xDDDA, 0xDE44, 0xDE82, 0xDE72, 0xDDF0, 0xDCDC, 0xDB6C, 0xD9EA, 0xD85A, 
	0xD6BA, 0xD50D, 0xD354, 0xD190, 0xCFC1, 0xCDE9, 0xCC09, 0xCA22, 0xC835, 
	0xC642, 0xC44C, 0xC253, 0xC058, 0xBE5C, 0xBC60, 0xBA66, 0xB86E, 0xB679, 
	0xB489, 0xB29E, 0xB0BA, 0xAEDD, 0xAD09, 0xAAAA, 0xA876, 0xA860, 0xAE99, 
	0xB521, 0xB406, 0xB159, 0xB127, 0xB186, 0xB1D3, 0xB230, 0xB27F, 0xB2CE, 
	0xB322, 0xB356, 0xB343, 0xB228, 0xAFFF, 0xADBD, 0xAC55, 0xACBA, 0xAFE0, 
	0xB84D, 0xC599, 0xD45B, 0xE126, 0xE88E, 0xEBE5, 0xEECA, 0xF145, 0xF362, 
	0xF529, 0xF6A5, 0xF7DF, 0xF8E2, 0xF9B7, 0xFA69, 0xFB00, 0xFB87, 0xFC08, 
	0xFC8D, 0xFD1F, 0xFDC8, 0xFE92, 0xFF51, 0x00CE, 0x0306, 0x05B1, 0x0884, 
	0x0B37, 0x0D80, 0x0F14, 0x0FAC, 0x071C, 0x0306, 0x0A73, 0x0A50, 0x09ED, 
	0x0950, 0x0883, 0x078B, 0x0671, 0x053D, 0x03F5, 0x02A2, 0x014C, 0xFFF8, 
	0xFEB0, 0xFD7C, 0xFC62, 0xFB6B, 0xFA9D, 0xFA00, 0xF99D, 0xF97A, 0xF97A, 
	0xF97A, 0xF979, 0xF979, 0xF97D, 0xF988, 0xF999, 0xF9AE, 0xF9C5, 0xF9DE, 
	0xF9F7, 0xFA0F, 0xFA24, 0xFA35, 0xFA40, 0xFA44, 0xFA3F, 0xFA31, 0xFA17, 
	0xF9F1, 0xF9BD, 0xF979, 0xF8EB, 0xF7F0, 0xF6AE, 0xF54D, 0xF3F2, 0xF2C3, 
	0xF1F5, 0xF1F8, 0xF22B, 0xF239, 0xF25B, 0xF284, 0xF2AA, 0xF2C0, 0xF2BA, 
	0xF28C, 0xF22B, 0xF1A6, 0xF116, 0xF07C, 0xEFD9, 0xEF2E, 0xEE7C, 0xEDC5, 
	0xED08, 0xEC48, 0xEB85, 0xEAC0, 0xE9FB, 0xE937, 0xE874, 0xE7B4, 0xE6F7, 
	0xE640, 0xE58E, 0xE4E3, 0xE440, 0xE3A7, 0xE318, 0xE293, 0xE21B, 0xE1B1, 
	0xE155, 0xE31A, 0xE6B6, 0xE89A, 0xE4BE, 0xE093, 0xE27C, 0xE581, 0xE5EC, 
	0xE657, 0xE8C5, 0xEBA7, 0xECBE, 0xEAF1, 0xE7A3, 0xE44E, 0xE267, 0xE1CE, 
	0xE17D, 0xE197, 0xE240, 0xE39C, 0xE5CE, 0xEA08, 0xF053, 0xF718, 0xFCBE, 
	0xFFAD, 0x0096, 0x013F, 0x01AC, 0x01E4, 0x01EE, 0x01CF, 0x018D, 0x012F, 
	0x00BB, 0x0036, 0xFFA8, 0xFF16, 0xFE85, 0xFDFE, 0xFD84, 0xFD1F, 0xFCD5, 
	0xFC8E, 0xFCE2, 0xFDC0, 0xFEF9, 0x0061, 0x01C8, 0x0301, 0x03DE, 0x0432, 
	0x0306, 0x0A90, 0x0D32, 0x0CF7, 0x0C4B, 0x0B3C, 0x09D3, 0x081B, 0x0620, 
	0x03ED, 0x018D, 0xFF0A, 0xFC70, 0xF9CB, 0xF725, 0xF488, 0xF201, 0xEF9B, 
	0xED5F, 0xEB5A, 0xE997, 0xE820, 0xE6F4, 0xE5EF, 0xE522, 0xE4A1, 0xE453, 
	0xE414, 0xE3E1, 0xE3BA, 0xE39E, 0xE38D, 0xE385, 0xE385, 0xE38E, 0xE39D, 
	0xE3B1, 0xE3CB, 0xE3EA, 0xE40B, 0xE42F, 0xE454, 0xE47B, 0xE4A1, 0xE4E8, 
	0xE564, 0xE604, 0xE6B3, 0xE760, 0xE7F6, 0xE85D, 0xE85B, 0xE842, 0xE823, 
	0xE7D8, 0xE77C, 0xE728, 0xE6F7, 0xE705, 0xE76A, 0xE842, 0xE95D, 0xEA7C, 
	0xEB9F, 0xECC6, 0xEDF1, 0xEF21, 0xF057, 0xF193, 0xF2D5, 0xF41E, 0xF56E, 
	0xF6C6, 0xF826, 0xF98F, 0xFB01, 0xFC7C, 0xFE01, 0xFF91, 0x012B, 0x02D1, 
	0x0482, 0x0640, 0x080A, 0x09E1, 0x0BC6, 0x0DB8, 0x13BA, 0x1CD2, 0x2188, 
	0x1895, 0x0DDF, 0x1022, 0x138C, 0x0E24, 0x091B, 0x0B2D, 0x0F60, 0x1159, 
	0x0F56, 0x0B89, 0x078F, 0x0505, 0x04A3, 0x0582, 0x06C6, 0x0797, 0x071C, 
	0x0479, 0xFDA2, 0xF302, 0xE777, 0xDDE0, 0xD91A, 0xD7F0, 0xD73B, 0xD6F0, 
	0xD702, 0xD768, 0xD816, 0xD900, 0xDA1C, 0xDB5E, 0xDCBB, 0xDE27, 0xDF99, 
	0xE103, 0xE25C, 0xE397, 0xE4AA, 0xE589, 0xE660, 0xE8F6, 0xED41, 0xF29F, 
	0xF86F, 0xFE0E, 0x02DC, 0x0634, 0x0775, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0x36DA, 0x3C93, 0x3CF2, 0x3D48, 0x3D94, 0x3DD7, 0x3E12, 0x3E44, 0x3E70, 
	0x3E95, 0x3EB4, 0x3ECD, 0x3EE1, 0x3EF1, 0x3EFD, 0x3F05, 0x3F0B, 0x3F0E, 
	0x3F10, 0x3F11, 0x3F11, 0x3EAC, 0x400D, 0x41F2, 0x431B, 0x4481, 0xC62C, 
	0xC579, 0x41F7, 0x3D13, 0x36F0, 0x2FB0, 0x2500, 0x1701, 0x098E, 0x007E, 
	0xFFA5, 0x08BC, 0x18CA, 0x2CC9, 0x41AB, 0x5466, 0x61EE, 0xEAF3, 0xF265, 
	0xF892, 0xFDCA, 0x025D, 0x0699, 0x0AD0, 0x0F50, 0x1469, 0x147D, 0x14AA, 
	0x14E4, 0x151B, 0x153B, 0x1534, 0x14F4, 0x1469, 0x1125, 0x0BB5, 0x0887, 
	0x0C04, 0x1BD6, 0x3425, 0x4B13, 0x56C6, 0x596D, 0x5BD0, 0x5DF1, 0x5FD4, 
	0x617A, 0xE2E7, 0xE420, 0xE525, 0xE5FB, 0xE6A5, 0xE725, 0xE77E, 0xE7B3, 
	0xE7C8, 0xE7BF, 0xE79C, 0xE760, 0xE711, 0xE6AF, 0xE63F, 0xE5C4, 0xE540, 
	0xE4B6, 0xE429, 0xE39D, 0xE315, 0xE293, 0xE1E9, 0xE0EC, 0xDFA5, 0xDE1D, 
	0xDC5C, 0xDA6A, 0xD851, 0xD619, 0xD3CB, 0xD16F, 0xCF0D, 0xCCAF, 0xCA5D, 
	0xC81F, 0x45FF, 0x4405, 0x4238, 0x40A3, 0x3F0D, 0x3DA4, 0x3D0D, 0x3DEC, 
	0x40E3, 0x49AE, 0xD740, 0xE318, 0xE6AF, 0xE366, 0xDF10, 0xD9D4, 0x53D8, 
	0x4D41, 0x4637, 0x3EE0, 0x3763, 0x2FE5, 0x27F7, 0x1F36, 0x154B, 0x09DE, 
	0xFC97, 0xED22, 0xDB27, 0xC64F, 0x36DA, 0x54F5, 0x56B6, 0x5870, 0x59FB, 
	0x5B5B, 0x5C91, 0x5DA0, 0x5E8C, 0x5F55, 0x6000, 0x608E, 0x6103, 0x6160, 
	0x61A9, 0x61E0, 0x6207, 0x6221, 0x6231, 0x6239, 0x623C, 0x623D, 0x6025, 
	0x5DAE, 0x5B99, 0x5AA9, 0x5C8D, 0x1FCB, 0x1DB4, 0x620B, 0x60E8, 0x5EE3, 
	0x5C01, 0x5773, 0x5160, 0x4B3A, 0x4672, 0x447A, 0x4499, 0x4517, 0x45E9, 
	0x4705, 0x4861, 0x49F1, 0x3455, 0x327B, 0x308D, 0x2E95, 0x2C9D, 0x2AB1, 
	0x28DA, 0x2724, 0x2599, 0x25A1, 0x25C4, 0x25F2, 0x261C, 0x2637, 0x2633, 
	0x2603, 0x2599, 0x2370, 0x1FD8, 0x1D85, 0x1F2A, 0x2803, 0x35C8, 0x42E8, 
	0x49CF, 0x4BA6, 0x4D50, 0x4ECE, 0x5025, 0x5155, 0x2D9D, 0x2CB0, 0x2BE1, 
	0x2B2D, 0x2A91, 0x2A0B, 0x2999, 0x2937, 0x28E3, 0x289A, 0x285A, 0x2821, 
	0x27EB, 0x27B5, 0x277E, 0x2743, 0x2700, 0x26B4, 0x265B, 0x25F4, 0x257B, 
	0x24EE, 0x244F, 0x23A4, 0x22F1, 0x2237, 0x2179, 0x20BB, 0x1FFE, 0x1F47, 
	0x1E96, 0x1DF0, 0x1D57, 0x1CCD, 0x1C56, 0x1BF3, 0x6457, 0x6487, 0x6499, 
	0x648C, 0x637E, 0x610A, 0x5DE4, 0x5AC0, 0x5853, 0x5700, 0x29BC, 0x2A84, 
	0x2BFB, 0x2E24, 0x308E, 0x332B, 0x4A0E, 0x472B, 0x4436, 0x413B, 0x3E45, 
	0x3B61, 0x381C, 0x3486, 0x30DB, 0x2D55, 0x2A30, 0x27A7, 0x25F6, 0x2559, 
	0x54F5, 0x175C, 0x1DD4, 0x1DC5, 0x1D9C, 0x1D5B, 0x1D03, 0x1C97, 0x1C1A, 
	0x1B8E, 0x1AF5, 0x1A52, 0x19A7, 0x18F6, 0x1842, 0x178D, 0x16D9, 0x1629, 
	0x157F, 0x14DE, 0x1447, 0x13BE, 0x136A, 0x149D, 0x1650, 0x177C, 0x1951, 
	0x9B93, 0x9B18, 0x1761, 0x1219, 0x0B50, 0x031A, 0xF770, 0xE893, 0xD9ED, 
	0xCEE9, 0xCAF4, 0xCF33, 0xD904, 0xE625, 0xF457, 0x015F, 0x0AF4, 0x9194, 
	0x9759, 0x9C6B, 0xA0F7, 0xA528, 0xA928, 0xAD23, 0xB144, 0xB5B7, 0xB5B6, 
	0xB59F, 0xB581, 0xB564, 0xB552, 0xB554, 0xB572, 0xB5B7, 0xB50B, 0xB3EB, 
	0xB4BD, 0xB9E4, 0xC722, 0xDA25, 0xEC39, 0xF6A6, 0xFAFA, 0xFF3C, 0x036C, 
	0x0786, 0x0B8A, 0x8F76, 0x9348, 0x96FF, 0x9A9A, 0x9E16, 0xA172, 0xA4AC, 
	0xA7C4, 0xAAB6, 0xAD82, 0xB026, 0xB2A0, 0xB4EF, 0xB711, 0xB905, 0xBAC9, 
	0xBC5B, 0xBDBA, 0xBEE3, 0xBFD7, 0xC092, 0xC114, 0xC10D, 0xC03C, 0xBEB6, 
	0xBC8F, 0xB9DA, 0xB6AC, 0xB31A, 0xAF36, 0xAB16, 0xA6CE, 0xA271, 0x9E14, 
	0x99CB, 0x95AA, 0x11C6, 0x0E32, 0x0B02, 0x084A, 0x0604, 0x046E, 0x0403, 
	0x0540, 0x08A0, 0x1228, 0xA0DA, 0xADBA, 0xB1C3, 0xAE72, 0xAA05, 0xA4A5, 
	0x1E7B, 0x17AE, 0x1066, 0x08CC, 0x0108, 0xF942, 0xF917, 0xF7EA, 0xF4BA, 
	0xEE84, 0xE447, 0xD500, 0xBFAF, 0xA351, 0x175C, 0xF3C6, 0x0239, 0xCB60, 
	0xC7E6, 0xC7E6, 0xC7E5, 0xC7E4, 0xC7E1, 0xC7DC, 0xC7D5, 0xC7CB, 0xC7BE, 
	0xC7AD, 0xC798, 0xC77F, 0xC760, 0xC73C, 0xC711, 0xC6E0, 0xC6A8, 0xC669, 
	0xC622, 0xC5D2, 0xC312, 0xC000, 0xBD65, 0xBC0C, 0xBDB5, 0xC165, 0xC3C9, 
	0xC3C7, 0xC2DA, 0xC194, 0xC087, 0xBF34, 0xBD50, 0xBBBD, 0xBB5D, 0xBD11, 
	0xC14B, 0xC75D, 0xCE78, 0xD5CE, 0xDC90, 0xE1F0, 0xE61D, 0xE9DF, 0xED4A, 
	0xF074, 0xF371, 0xF655, 0xF936, 0xFC29, 0xFF41, 0xFF45, 0xFF45, 0xFF44, 
	0xFF43, 0xFF43, 0xFF42, 0xFF41, 0xFF41, 0xFFC4, 0x0000, 0x0000, 0xFF41, 
	0xFA67, 0xF33B, 0xEC93, 0xE940, 0xE8A0, 0xE829, 0xE7D7, 0xE7A7, 0xE796, 
	0xE7A0, 0xE7C1, 0xE7F7, 0xE83E, 0xE892, 0xE8F0, 0xE955, 0xE9BD, 0xEA25, 
	0xEA89, 0xEAE6, 0xEB39, 0xEB7D, 0xEBB1, 0xEBCF, 0xEBD6, 0xEBC0, 0xEB8C, 
	0xEB35, 0xEAB9, 0xEA13, 0xE940, 0xE830, 0xE6D7, 0xE53C, 0xE367, 0xE15D, 
	0xDF25, 0xDCC6, 0xDA47, 0xD7AE, 0xD503, 0xD24A, 0xCF8D, 0xCCD0, 0xCA1B, 
	0xC775, 0xC4E3, 0xC26D, 0xC01A, 0xBDEC, 0xBBD8, 0xB9CB, 0xB7B4, 0xB582, 
	0xB289, 0xAF07, 0xAC4D, 0xABA8, 0xACA7, 0xADF1, 0xAF7B, 0xB13C, 0xB327, 
	0xB531, 0xB751, 0xB97A, 0xBBA3, 0xBEAE, 0xC28A, 0xC6D7, 0xCB35, 0xCF42, 
	0xD29F, 0xD4EA, 0xD5C4, 0xCB60, 0xFA42, 0x0877, 0x08F7, 0x095D, 0x09AB, 
	0x09E4, 0x0A0C, 0x0A26, 0x0A34, 0x0A3B, 0x0A3C, 0x0A3C, 0x0A3E, 0x0A45, 
	0x0A53, 0x0A6D, 0x0A94, 0x0ACE, 0x0B1C, 0x0B81, 0x0C02, 0x0D62, 0x0EFB, 
	0x1079, 0x118C, 0x1165, 0x10AA, 0x1133, 0x13DF, 0x179C, 0x1B5B, 0x1E0C, 
	0x1F84, 0x206B, 0x20EE, 0x213A, 0x217B, 0x21CD, 0x221B, 0x224E, 0x224C, 
	0x21FC, 0x2146, 0x2034, 0x1EE6, 0x1D6B, 0x1BCD, 0x1A19, 0x185A, 0x169D, 
	0x14ED, 0x1358, 0x1355, 0x1355, 0x1355, 0x1356, 0x1356, 0x1357, 0x1357, 
	0x1358, 0x1148, 0x0DD8, 0x0D28, 0x1358, 0x3361, 0x5555, 0x5610, 0x4EB4, 
	0x4D5F, 0x4C0F, 0x4AC3, 0x497C, 0x4838, 0x46F7, 0x45BA, 0x4481, 0x434A, 
	0x4216, 0x40E5, 0x3FB5, 0x3E89, 0x3D5E, 0x3C34, 0x3B0C, 0x39E6, 0x38C0, 
	0x379C, 0x3678, 0x3554, 0x3431, 0x330D, 0x31E9, 0x30C5, 0x2FA0, 0x2E7B, 
	0x2D45, 0x2BF6, 0x2A96, 0x292F, 0x27C8, 0x266B, 0x2520, 0x23EF, 0x22E2, 
	0x2200, 0x2153, 0x20E4, 0x20BA, 0x21E7, 0x24D1, 0x287C, 0x2BF1, 0x2E36, 
	0x2F3A, 0x2FA4, 0x2F8C, 0x2F0A, 0x2E36, 0x2CB8, 0x2A7A, 0x27F2, 0x2599, 
	0x2364, 0x20FE, 0x1E70, 0x1BC5, 0x1907, 0x1640, 0x1379, 0x10BC, 0x0E13, 
	0x0ABF, 0x06CD, 0x0292, 0xFE5F, 0xFA8B, 0xF767, 0xF548, 0xF480, 0xFA42, 
	0x0197, 0x09C6, 0x0A78, 0x0B0B, 0x0B83, 0x0BE3, 0x0C2E, 0x0C68, 0x0C93, 
	0x0CB3, 0x0CCA, 0x0CDC, 0x0CEB, 0x0CFC, 0x0D11, 0x0D2C, 0x0D52, 0x0D86, 
	0x0DCA, 0x0E21, 0x0E8F, 0x0F12, 0x0F95, 0x0FE2, 0x0FC1, 0x0E37, 0x0BE3, 
	0x0AF1, 0x0C3B, 0x0E96, 0x1124, 0x1308, 0x141E, 0x14E4, 0x1575, 0x15EC, 
	0x1664, 0x16C8, 0x1706, 0x1739, 0x1779, 0x17E3, 0x1891, 0x197B, 0x1A84, 
	0x1BA6, 0x1CDB, 0x1E1B, 0x1F60, 0x20A4, 0x21E1, 0x230F, 0x2311, 0x2311, 
	0x2311, 0x2310, 0x2310, 0x2310, 0x230F, 0x230F, 0x236C, 0x2407, 0x2426, 
	0x230F, 0x1C74, 0x176E, 0x2008, 0x27F3, 0x27BF, 0x276D, 0x2701, 0x267C, 
	0x25E1, 0x2531, 0x246F, 0x239D, 0x22BE, 0x21D2, 0x20DD, 0x1FE0, 0x1EDE, 
	0x1DD8, 0x1CD2, 0x1BCC, 0x1AC9, 0x19CB, 0x18D5, 0x17E8, 0x1707, 0x1633, 
	0x1570, 0x14BE, 0x1420, 0x1398, 0x1329, 0x12EB, 0x12F0, 0x132D, 0x1397, 
	0x1424, 0x14CA, 0x157E, 0x1635, 0x16E6, 0x1785, 0x1808, 0x1864, 0x1890, 
	0x1839, 0x174D, 0x161F, 0x1500, 0x1445, 0x1410, 0x1429, 0x145E, 0x1478, 
	0x1445, 0x139E, 0x12A2, 0x1186, 0x107E, 0x0F86, 0x0E79, 0x0D5A, 0x0C2E, 
	0x0AFA, 0x09C2, 0x088A, 0x0757, 0x062C, 0x062C, 0x062C, 0x062C, 0x062C, 
	0x062C, 0x062C, 0x062C, 0x062C, 0x0197, 0x0624, 0x0C77, 0x0C1A, 0x0B0F, 
	0x096C, 0x0744, 0x04AC, 0x01B8, 0xFE7C, 0xFB0E, 0xF782, 0xF3EB, 0xF05E, 
	0xECF0, 0xE9B5, 0xE6C2, 0xE42A, 0xE202, 0xE05E, 0xDF54, 0xDEF6, 0xDF36, 
	0xDF76, 0xDF9C, 0xDF8C, 0xDEB1, 0xDD74, 0xDD35, 0xDE82, 0xE091, 0xE2C8, 
	0xE48E, 0xE5D1, 0xE6EC, 0xE7DE, 0xE8AA, 0xE94F, 0xEA0D, 0xEAF3, 0xEBBE, 
	0xEC2A, 0xEBF6, 0xEADC, 0xE8F5, 0xE694, 0xE3D2, 0xE0C8, 0xDD8F, 0xDA41, 
	0xD6F6, 0xD3C7, 0xD0CD, 0xD0C6, 0xD0C7, 0xD0C8, 0xD0C9, 0xD0CA, 0xD0CB, 
	0xD0CC, 0xD0CD, 0xCE80, 0xCAAA, 0xC9E5, 0xD0CD, 0xF59C, 0x1A71, 0x11AF, 
	0x020F, 0x00B7, 0xFF80, 0xFE67, 0xFD6B, 0xFC89, 0xFBC0, 0xFB0C, 0xFA6C, 
	0xF9DD, 0xF95D, 0xF8EB, 0xF882, 0xF823, 0xF7C9, 0xF774, 0xF720, 0xF6CC, 
	0xF675, 0xF619, 0xF5B6, 0xF54A, 0xF4D2, 0xF44C, 0xF3B6, 0xF30E, 0xF251, 
	0xF17D, 0xF070, 0xEF12, 0xED77, 0xEBAF, 0xE9CC, 0xE7DF, 0xE5FA, 0xE42E, 
	0xE28D, 0xE129, 0xE012, 0xDF5B, 0xDF14, 0xE0A1, 0xE47A, 0xE955, 0xEDE9, 
	0xF0E9, 0xF209, 0xF226, 0xF1B3, 0xF123, 0xF0E9, 0xF10D, 0xF143, 0xF180, 
	0xF1B9, 0xF1EF, 0xF229, 0xF267, 0xF2A7, 0xF2EA, 0xF32D, 0xF370, 0xF3B3, 
	0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 0xF3F3, 
	0x0624, 0xFFFF, 0x0000, 0xBF5E, 0xFAC2, 0xF119, 0x80C8, 0x80E0, 0x8127, 
	0x819F, 0x8246, 0x831D, 0x8424, 0x855B, 0x86C2, 0x8858, 0x8A1E, 0x8BE4, 
	0x8D7B, 0x8EE1, 0x9018, 0x911F, 0x91F6, 0x929E, 0x9315, 0x935D, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 0x9375, 
	0x9375, 0x9375, 0x933A, 0x9289, 0x9161, 0x8FC4, 0x8DB1, 0x8B28, 0x8828, 
	0x84B3, 0x80C8, 0x0000, 0x0003, 0x000D, 0x001D, 0x0033, 0x0050, 0x0073, 
	0x009D, 0x00CD, 0x0104, 0x0141, 0x017D, 0x01B4, 0x01E4, 0x020E, 0x0231, 
	0x024E, 0x0264, 0x0274, 0x027E, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 
	0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0281, 0x0279, 0x0261, 
	0x023A, 0x0202, 0x01BB, 0x0164, 0x00FD, 0x0087, 0x0000, 0xFFFF, 0x000E, 
	0x0038, 0x007E, 0x00E0, 0x015E, 0x01F8, 0x02AE, 0x0380, 0x046E, 0x0578, 
	0x0682, 0x0770, 0x0842, 0x08F8, 0x0992, 0x0A10, 0x0A72, 0x0AB8, 0x0AE2, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 0x0AF0, 
	0x0AF0, 0x0AF0, 0x0AF0, 0x0ACD, 0x0A66, 0x09B9, 0x08C7, 0x0790, 0x0613, 
	0x0452, 0x024C, 0xFFFF, 0x49EE, 0x49CA, 0x495F, 0x48AC, 0x47B1, 0x466F, 
	0x44E6, 0x4315, 0x40FC, 0x3E9C, 0x3BF4, 0x394C, 0x36EC, 0x34D4, 0x3303, 
	0x3179, 0x3037, 0x2F3D, 0x2E8A, 0x2E1E, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 
	0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2DFB, 0x2E53, 
	0x2F5C, 0x3116, 0x3380, 0x369B, 0x3A67, 0x3EE3, 0x4410, 0x49EE, 0xF7AE, 
	0xF7B5, 0xF7CA, 0xF7EC, 0xF81D, 0xF85C, 0xF8A9, 0xF904, 0xF96C, 0xF9E3, 
	0xFA68, 0xFAEC, 0xFB63, 0xFBCC, 0xFC27, 0xFC73, 0xFCB2, 0xFCE3, 0xFD06, 
	0xFD1B, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD22, 
	0xFD22, 0xFD22, 0xFD22, 0xFD22, 0xFD11, 0xFCDD, 0xFC87, 0xFC0E, 0xFB73, 
	0xFAB5, 0xF9D5, 0xF8D3, 0xF7AE, 0x03C6, 0x03C4, 0x03BF, 0x03B6, 0x03AA, 
	0x039B, 0x0388, 0x0372, 0x0358, 0x033B, 0x031B, 0x02FA, 0x02DD, 0x02C3, 
	0x02AD, 0x029A, 0x028B, 0x027F, 0x0277, 0x0271, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 0x0270, 
	0x0274, 0x0281, 0x0296, 0x02B3, 0x02D9, 0x0308, 0x033F, 0x037E, 0x03C6, 
	0xAB92, 0xABA5, 0xABDB, 0xAC37, 0xACB6, 0xAD5B, 0xAE23, 0xAF11, 0xB023, 
	0xB159, 0xB2B4, 0xB40F, 0xB545, 0xB657, 0xB744, 0xB80D, 0xB8B1, 0xB931, 
	0xB98C, 0xB9C3, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 
	0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9D5, 0xB9A8, 0xB921, 0xB840, 0xB704, 
	0xB56F, 0xB37F, 0xB135, 0xAE91, 0xAB92, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 
	0x01C0, 0x01C0, 0x01C0, 0x01C0, 0x01C0, 0x01C0, 0x01C0, 0x01C0, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 0x01BF, 
	0x01BF, 0x01BF, 0x01C0, 0x1192, 0x842B, 0x8443, 0x848C, 0x8505, 0x85AE, 
	0x8687, 0x8791, 0x88CB, 0x8A36, 0x8BD1, 0x8D9C, 0x8F67, 0x9102, 0x926C, 
	0x93A6, 0x94B0, 0x9589, 0x9633, 0x96AB, 0x96F4, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 0x970C, 
	0x96D0, 0x961D, 0x94F3, 0x9351, 0x9138, 0x8EA8, 0x8BA1, 0x8822, 0x842B, 
	0xFFFF, 0x0003, 0x000C, 0x001A, 0x002F, 0x0049, 0x0069, 0x0090, 0x00BB, 
	0x00ED, 0x0125, 0x015D, 0x018E, 0x01BA, 0x01E0, 0x0201, 0x021B, 0x022F, 
	0x023E, 0x0247, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 
	0x024A, 0x024A, 0x024A, 0x024A, 0x024A, 0x0243, 0x022D, 0x0209, 0x01D6, 
	0x0195, 0x0145, 0x00E7, 0x007B, 0xFFFF, 0x0000, 0xFFEA, 0xFFAA, 0xFF3F, 
	0xFEA9, 0xFDE9, 0xFCFE, 0xFBE8, 0xFAA8, 0xF93D, 0xF7A7, 0xF611, 0xF4A6, 
	0xF365, 0xF24F, 0xF164, 0xF0A4, 0xF00F, 0xEFA4, 0xEF64, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 0xEF4E, 
	0xEF4E, 0xEF83, 0xF021, 0xF129, 0xF29A, 0xF475, 0xF6B9, 0xF967, 0xFC7E, 
	0x0000, 0x4A21, 0x49EF, 0x495A, 0x4862, 0x4706, 0x4548, 0x4326, 0x40A0, 
	0x3DB7, 0x3A6B, 0x36BC, 0x330D, 0x2FC1, 0x2CD8, 0x2A53, 0x2831, 0x2672, 
	0x2516, 0x241E, 0x2389, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 
	0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x2357, 0x23D2, 0x2542, 0x27A7, 
	0x2B01, 0x2F50, 0x3495, 0x3ACE, 0x41FD, 0x4A21, 0x09D3, 0x09C7, 0x09A3, 
	0x0967, 0x0913, 0x08A7, 0x0823, 0x0787, 0x06D3, 0x0607, 0x0523, 0x043F, 
	0x0373, 0x02BF, 0x0223, 0x019F, 0x0133, 0x00DF, 0x00A3, 0x007F, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 
	0x0073, 0x0073, 0x0090, 0x00E9, 0x017D, 0x024D, 0x0357, 0x049D, 0x061E, 
	0x07DB, 0x09D3, 0xFE32, 0xFE34, 0xFE37, 0xFE3E, 0xFE46, 0xFE51, 0xFE5F, 
	0xFE6F, 0xFE82, 0xFE97, 0xFEAE, 0xFEC6, 0xFEDB, 0xFEED, 0xFEFD, 0xFF0B, 
	0xFF16, 0xFF1F, 0xFF25, 0xFF28, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 
	0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF2A, 0xFF27, 0xFF1E, 
	0xFF0E, 0xFEF9, 0xFEDD, 0xFEBC, 0xFE94, 0xFE66, 0xFE32, 0xABC3, 0xABDD, 
	0xAC2E, 0xACB4, 0xAD70, 0xAE62, 0xAF89, 0xB0E6, 0xB279, 0xB441, 0xB63F, 
	0xB83D, 0xBA06, 0xBB99, 0xBCF6, 0xBE1D, 0xBF0F, 0xBFCA, 0xC051, 0xC0A1, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 0xC0BC, 
	0xC0BC, 0xC0BC, 0xC0BC, 0xC07A, 0xBFB3, 0xBE68, 0xBC97, 0xBA43, 0xB76A, 
	0xB40C, 0xB02A, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x008C, 0x0001, 0x0001, 0x008D, 0x0001, 0x008E, 0x0001, 
	0x008F, 0x0001, 0x0090, 0x0001, 0x0091, 0x0001, 0x0092, 0x0001, 0x0093, 
	0x008C, 0x0094, 0x008C, 0x0120, 0x008C, 0x01AC, 0x008C, 0x0238, 0x008C, 
	0x02C4, 0x008C, 0x0350, 0x0001, 0x03DC, 0x0001, 0x03DD, 0x0001, 0x03DE, 
	0x008C, 0x03DF, 0x008C, 0x046B, 0x008C, 0x04F7, 0x008B, 0x0583, 0x0089, 
	0x060E, 0x008C, 0x0697, 0x008C, 0x0723, 0x008C, 0x07AF, 0x008C, 0x083B, 
	0x0001, 0x08C7, 0x0001, 0x08C8, 0x0001, 0x08C9, 0x008C, 0x08CA, 0x008C, 
	0x0956, 0x008C, 0x09E2, 0x0001, 0x0A6E, 0x0001, 0x0A6F, 0x008C, 0x0A70, 
	0x008C, 0x0AFC, 0x008C, 0x0B88, 0x008C, 0x0C14, 0x0001, 0x0CA0, 0x0001, 
	0x0CA1, 0x0001, 0x0CA2, 0x0001, 0x0CA3, 0x0001, 0x0CA4, 0x008C, 0x0CA5, 
	0x008C, 0x0D31, 0x008C, 0x0DBD, 0x008C, 0x0E49, 0x008C, 0x0ED5, 0x008C, 
	0x0F61, 0x008C, 0x0FED, 0x0001, 0x1079, 0x0001, 0x107A, 0x0001, 0x107B, 
	0x008B, 0x107C, 0x0001, 0x1107, 0x008C, 0x1108, 0x008C, 0x1194, 0x008C, 
	0x1220, 0x008C, 0x12AC, 0x008C, 0x1338, 0x008C, 0x13C4, 0x008C, 0x1450, 
	

});

smlua_anim_util_register_animation('donkey_32_dying_fall_over',1, 0, 0, 0, 95, { 
	0xFFF0, 0xFFF0, 0xFFF0, 0xFFF0, 0xFFF0, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 
	0xFFF1, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF2, 0xFFF2, 0xFFF2, 0xFFF2, 0xFFF2, 
	0xFFF2, 0xFFF3, 0xFFF3, 0xFFF3, 0xFFF3, 0xFFF4, 0xFFF4, 0xFFF4, 0xFFF4, 
	0xFFF5, 0xFFF5, 0xFFF5, 0xFFF5, 0xFFF6, 0xFFF6, 0xFFF6, 0xFFF7, 0xFFF7, 
	0xFFF7, 0xFFF7, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF9, 0xFFF9, 0xFFF9, 0xFFFA, 
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFC, 0xFFFC, 0xFFFC, 
	0xFFFC, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x00A5, 0x00A5, 0x00A6, 0x00A7, 0x00A9, 0x00AB, 0x00AC, 0x00AE, 0x00B0, 
	0x00B1, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 
	0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B2, 0x00B3, 0x00B3, 0x00B3, 
	0x00B3, 0x00B3, 0x00B3, 0x00B3, 0x00B3, 0x00B3, 0x00B3, 0x00B2, 0x00B2, 
	0x00B1, 0x00B0, 0x00AF, 0x00AE, 0x00AD, 0x00AC, 0x00AB, 0x00AA, 0x00A9, 
	0x00A8, 0x00A7, 0x00A6, 0x00A5, 0x00A4, 0x00A4, 0x00A3, 0x00A2, 0x00A2, 
	0x00A2, 0x00A1, 0x00A1, 0x00A1, 0x00A1, 0x00A1, 0x00A1, 0x00A2, 0x00A5, 
	0x00AA, 0x00B0, 0x00B6, 0x00BB, 0x00C0, 0x00C3, 0x00C5, 0x00C4, 0x00C2, 
	0x00BD, 0x00B2, 0x00A0, 0x0089, 0x0071, 0x005A, 0x004A, 0x0044, 0x0046, 
	0x004A, 0x004D, 0x004E, 0x004C, 0x004A, 0x004C, 0x004E, 0x0000, 0x0000, 
	0x3FFF, 0x0000, 0xFC7F, 0xFC74, 0xFC59, 0xFC2F, 0xFBFB, 0xFBC1, 0xFB84, 
	0xFB48, 0xFB12, 0xFAE4, 0xFAC3, 0xFAB2, 0xFAAD, 0xFAAB, 0xFAAE, 0xFAB5, 
	0xFABF, 0xFACC, 0xFADD, 0xFAF1, 0xFB07, 0xFB20, 0xFB3C, 0xFB5A, 0xFB7A, 
	0xFB9C, 0xFBC0, 0xFBE7, 0xFC12, 0xFC40, 0xFC72, 0xFCA6, 0xFCDD, 0xFD15, 
	0xFD4F, 0xFD8B, 0xFDC6, 0xFE03, 0xFE3F, 0xFE7B, 0xFEB5, 0xFEEF, 0xFF27, 
	0xFF5E, 0xFF95, 0xFFCD, 0x0004, 0x003C, 0x0074, 0x00AC, 0x00E4, 0x011C, 
	0x0154, 0x018B, 0x01C3, 0x01FA, 0x0232, 0x0269, 0x02A0, 0x02D6, 0x030C, 
	0x0363, 0x03E4, 0x046F, 0x04E4, 0x0520, 0x0503, 0x046C, 0x0352, 0x01D3, 
	0x000C, 0xFE15, 0xFC09, 0xFA04, 0xF81E, 0xF674, 0xF51F, 0xF43B, 0xF3A4, 
	0xF328, 0xF2C4, 0xF275, 0xF23A, 0xF211, 0xF1F7, 0xF1EB, 0xF1EA, 0xF1F2, 
	0xF201, 0xF214, 0xF22B, 0xF242, 0xF258, 0xF26A, 0xF276, 0xF27B, 0x0A02, 
	0x0A0E, 0x0A2C, 0x0A56, 0x0A83, 0x0AAD, 0x0ACA, 0x0AD5, 0x0AC5, 0x0A92, 
	0x0A36, 0x09A8, 0x08DE, 0x07DA, 0x06A7, 0x0550, 0x03DE, 0x025C, 0x00D5, 
	0xFF53, 0xFDE1, 0xFC8A, 0xFB58, 0xFA54, 0xF98B, 0xF907, 0xF8D1, 0xF8F6, 
	0xF970, 0xFA33, 0xFB34, 0xFC65, 0xFDBB, 0xFF2A, 0x00A4, 0x021E, 0x038B, 
	0x04E0, 0x060F, 0x070C, 0x07CC, 0x0842, 0x0861, 0x0837, 0x07DB, 0x0752, 
	0x06A1, 0x05CD, 0x04DA, 0x03CC, 0x02A9, 0x0175, 0x0035, 0xFEEE, 0xFDA4, 
	0xFC5C, 0xFB1A, 0xF9E4, 0xF8BD, 0xF7AB, 0xF6B3, 0xF5BA, 0xF4B3, 0xF3B2, 
	0xF2CB, 0xF213, 0xF19E, 0xF180, 0xF1B8, 0xF22C, 0xF2D0, 0xF395, 0xF46F, 
	0xF551, 0xF62C, 0xF6F5, 0xF79D, 0xF817, 0xF874, 0xF8CD, 0xF923, 0xF975, 
	0xF9C3, 0xFA0C, 0xFA51, 0xFA91, 0xFACD, 0xFB02, 0xFB33, 0xFB5D, 0xFB82, 
	0xFBA1, 0xFBB9, 0xFBCB, 0xFBD5, 0xFBD9, 0x4445, 0x4422, 0x43C5, 0x433F, 
	0x42A0, 0x41FB, 0x4160, 0x40E0, 0x408D, 0x4078, 0x40B2, 0x414C, 0x424C, 
	0x43A5, 0x4546, 0x4720, 0x4925, 0x4B45, 0x4D71, 0x4F9A, 0x51AF, 0x53A4, 
	0x5567, 0x56EA, 0x581E, 0x58F3, 0x595A, 0x5953, 0x58EF, 0x583A, 0x573E, 
	0x5608, 0x54A4, 0x531C, 0x517C, 0x4FD0, 0x4E23, 0x4C81, 0x4AF6, 0x498C, 
	0x4850, 0x474E, 0x468F, 0x4609, 0x45A2, 0x4558, 0x4527, 0x450C, 0x4503, 
	0x4509, 0x451A, 0x4533, 0x4550, 0x456D, 0x4588, 0x459C, 0x45A7, 0x45A5, 
	0x4592, 0x456A, 0x452B, 0x44E4, 0x4496, 0x4426, 0x437D, 0x427F, 0x4114, 
	0x3F21, 0x3C7B, 0x3927, 0x355A, 0x314B, 0x2D2E, 0x2937, 0x259C, 0x2292, 
	0x204E, 0x1F05, 0x1E7A, 0x1E47, 0x1E61, 0x1EBF, 0x1F58, 0x2022, 0x2113, 
	0x2222, 0x2345, 0x2472, 0x259F, 0x26C4, 0x27D6, 0x28CC, 0x299C, 0x2A3D, 
	0x2AA4, 0x2AC9, 0x01A2, 0x01AD, 0x01CD, 0x01FF, 0x0243, 0x0296, 0x02F7, 
	0x0364, 0x03DC, 0x045C, 0x04E3, 0x056F, 0x05FF, 0x0690, 0x0721, 0x07B1, 
	0x083D, 0x08C4, 0x0944, 0x09BC, 0x0A29, 0x0A8A, 0x0ADD, 0x0B21, 0x0B54, 
	0x0B73, 0x0B7E, 0x0B6D, 0x0B3C, 0x0AEF, 0x0A88, 0x0A0A, 0x097A, 0x08DA, 
	0x082D, 0x0776, 0x06B9, 0x05F9, 0x0538, 0x047B, 0x03C5, 0x0318, 0x0277, 
	0x01E7, 0x0169, 0x0102, 0x00B5, 0x0084, 0x0073, 0x07B1, 0x0B71, 0x0F14, 
	0x1285, 0x15A9, 0x1868, 0x1B00, 0x1DA9, 0x2044, 0x22B3, 0x24D7, 0x2691, 
	0x27C2, 0x284D, 0x2765, 0x24D5, 0x215C, 0x1DB9, 0x1875, 0x11C5, 0x0A79, 
	0x0362, 0xFD4F, 0xF912, 0xF77A, 0xF852, 0xFA70, 0xFD37, 0x000B, 0x024D, 
	0x0360, 0x0391, 0x03A2, 0x03A8, 0x03B8, 0x03E2, 0x041E, 0x0466, 0x04B5, 
	0x0504, 0x054C, 0x0587, 0x05B0, 0x05BF, 0xF92D, 0xF92D, 0xF92D, 0xF92D, 
	0xF92E, 0xF92F, 0xF930, 0xF932, 0xF934, 0xF937, 0xF93A, 0xF93F, 0xF944, 
	0xF94B, 0xF952, 0xF95A, 0xF964, 0xF96F, 0xF97C, 0xF989, 0xF999, 0xF9AA, 
	0xF9BC, 0xF9D1, 0xF9E7, 0xF9FF, 0xFA1A, 0xFA4B, 0xFAA5, 0xFB25, 0xFBC5, 
	0xFC81, 0xFD55, 0xFE3E, 0xFF36, 0x003A, 0x0145, 0x0253, 0x035F, 0x0466, 
	0x0564, 0x0653, 0x0730, 0x07F7, 0x08A3, 0x0930, 0x099B, 0x09DD, 0x09F5, 
	0x07FE, 0x06B1, 0x0575, 0x0455, 0x035B, 0x0291, 0x0207, 0x01B8, 0x0192, 
	0x0187, 0x0184, 0x017A, 0x0157, 0x010A, 0x0072, 0xFF97, 0xFEAA, 0xFDDC, 
	0xFE9D, 0x0091, 0x033A, 0x0621, 0x08CA, 0x0ABD, 0x0B7E, 0x0A88, 0x07FE, 
	0x0462, 0x0037, 0xFC00, 0xF840, 0xF567, 0xF3A1, 0xF304, 0xF435, 0xF593, 
	0xF70C, 0xF88F, 0xFA08, 0xFB66, 0xFC95, 0xFD85, 0xFE22, 0xFE5A, 0x1174, 
	0x115F, 0x1123, 0x10C2, 0x103F, 0x0F9F, 0x0EE4, 0x0E10, 0x0D28, 0x0C2E, 
	0x0B26, 0x0A12, 0x08F6, 0x07D5, 0x06B2, 0x0590, 0x0473, 0x035D, 0x0251, 
	0x0153, 0x0066, 0xFF8C, 0xFECB, 0xFE23, 0xFD99, 0xFD2F, 0xFCE9, 0xFCB9, 
	0xFC8C, 0xFC64, 0xFC40, 0xFC20, 0xFC03, 0xFBEA, 0xFBD3, 0xFBC0, 0xFBB0, 
	0xFBA2, 0xFB96, 0xFB8D, 0xFB85, 0xFB7F, 0xFB7B, 0xFB77, 0xFB75, 0xFB74, 
	0xFB73, 0xFB73, 0xFB73, 0xFC1F, 0xFDE4, 0x0066, 0x0344, 0x0623, 0x08A4, 
	0x0A69, 0x0B15, 0x0876, 0x0564, 0x021D, 0xFEE2, 0xFBF2, 0xF98C, 0xF7C9, 
	0xF676, 0xF569, 0xF473, 0xF30E, 0xF145, 0xEF51, 0xED69, 0xEBC7, 0xEAA3, 
	0xEA35, 0xEE13, 0xF7C7, 0x0477, 0x1148, 0x1B62, 0x1FEA, 0x2079, 0x20AE, 
	0x20B6, 0x213E, 0x20D8, 0x2021, 0x1F33, 0x1E25, 0x1D11, 0x1C0F, 0x1B38, 
	0x1AA4, 0x1A6E, 0xFD38, 0xFD4B, 0xFD7C, 0xFDBE, 0xFE02, 0xFE3A, 0xFE5B, 
	0xFE7B, 0xFEAB, 0xFECF, 0xFECE, 0xFE8D, 0xFDF1, 0xFCCF, 0xFB2D, 0xF938, 
	0xF71C, 0xF508, 0xF327, 0xF1A7, 0xF0B4, 0xF07C, 0xF12B, 0xF2EB, 0xF5A3, 
	0xF91E, 0xFD26, 0x0184, 0x0603, 0x0A6C, 0x0E8A, 0x1226, 0x150B, 0x1703, 
	0x17F3, 0x1801, 0x1759, 0x1626, 0x1492, 0x12C8, 0x10F3, 0x0F3F, 0x0DD6, 
	0x0C8F, 0x0B2B, 0x09B2, 0x082C, 0x06A2, 0x051B, 0x03A1, 0x023C, 0x00F4, 
	0xFFD2, 0xFEDD, 0xFE12, 0xFD6A, 0xFCEB, 0xFC9A, 0xFC7E, 0xFC9B, 0xFCF7, 
	0xFD98, 0xFEEF, 0x011F, 0x03B8, 0x064D, 0x086E, 0x09AD, 0x0A01, 0x09C8, 
	0x092C, 0x0857, 0x0774, 0x06AD, 0x062D, 0x05E9, 0x05C9, 0x05E3, 0x064C, 
	0x077C, 0x092B, 0x0A56, 0x09EE, 0x0923, 0x0907, 0x0917, 0x0942, 0x0992, 
	0x09FE, 0x0A57, 0x0A8F, 0x0AB4, 0x0AC2, 0xF617, 0xF68D, 0xF7C5, 0xF984, 
	0xFB8E, 0xFDA5, 0xFF8F, 0x019A, 0x0406, 0x0680, 0x08B6, 0x0A54, 0x0B08, 
	0x0B04, 0x0AB5, 0x0A25, 0x095C, 0x0862, 0x073F, 0x05FC, 0x04A1, 0x0336, 
	0x01C4, 0x000E, 0xFDE8, 0xFB73, 0xF8D2, 0xF627, 0xF391, 0xF135, 0xEF32, 
	0xEDAB, 0xECC1, 0xEC95, 0xED99, 0xEFEA, 0xF32C, 0xF706, 0xFB1B, 0xFF13, 
	0x0292, 0x053D, 0x06BA, 0x0734, 0x0722, 0x0699, 0x05B1, 0x0480, 0x031B, 
	0x0199, 0x0010, 0xFE97, 0xFD42, 0xFC2A, 0xFB25, 0xFA06, 0xF8DD, 0xF7BA, 
	0xF6AE, 0xF5C7, 0xF517, 0xF4AC, 0xF4CA, 0xF57B, 0xF679, 0xF77D, 0xF843, 
	0xF885, 0xF7F3, 0xF6B1, 0xF521, 0xF3A3, 0xF29A, 0xF268, 0xF36F, 0xF7F6, 
	0xFFCA, 0x078F, 0x0BEB, 0x098F, 0x0321, 0xFE32, 0xFEED, 0x0047, 0xFE17, 
	0xFAF5, 0xF8CD, 0xF89F, 0xF96B, 0xFA20, 0xFA63, 0xFA8E, 0xFA9D, 0xDD7F, 
	0xDCDD, 0xDB4A, 0xD945, 0xD749, 0xD5D5, 0xD565, 0xD5FC, 0xD734, 0xD8F3, 
	0xDB1F, 0xDD9D, 0xE053, 0xE378, 0xE734, 0xEB53, 0xEFA1, 0xF3EA, 0xF7F9, 
	0xFB9C, 0xFE9D, 0x00C9, 0x01EC, 0x01F8, 0x0120, 0xFF8B, 0xFD63, 0xFAD2, 
	0xF802, 0xF51C, 0xF24A, 0xEFB4, 0xED85, 0xEBE5, 0xEA9D, 0xE964, 0xE84B, 
	0xE763, 0xE6BF, 0xE670, 0xE687, 0xE715, 0xE82E, 0xE9F8, 0xEC74, 0xEF7B, 
	0xF2E1, 0xF67E, 0xFA28, 0xFDB7, 0x0100, 0x03DB, 0x061D, 0x079E, 0x0819, 
	0x078F, 0x063E, 0x0464, 0x0241, 0x0014, 0xFE19, 0xFC91, 0xFB07, 0xF924, 
	0xF752, 0xF5FD, 0xF58F, 0xF672, 0xF8F8, 0xFCD6, 0x0188, 0x068D, 0x0B64, 
	0x0F89, 0x127B, 0x12EB, 0x1120, 0x0EFD, 0x0E65, 0x1130, 0x159C, 0x1823, 
	0x147C, 0x1074, 0x11A6, 0x1466, 0x166D, 0x16AC, 0x1632, 0x15DC, 0x1612, 
	0x166E, 0x169E, 0xFFFE, 0x0001, 0xC170, 0x330E, 0x3348, 0x33E9, 0x34DF, 
	0x3616, 0x377D, 0x3901, 0x3A8E, 0x3C13, 0x3D7C, 0x3EB7, 0x3FB1, 0x408A, 
	0x416B, 0x424F, 0x432F, 0x4406, 0xC4CE, 0xC583, 0xC61E, 0xC699, 0xC6EF, 
	0xC71B, 0xC716, 0xC6DB, 0xC61D, 0xC4AD, 0xC2B5, 0x4062, 0x3DDA, 0x3B48, 
	0x38D8, 0x363D, 0x333E, 0x301F, 0x2D25, 0x2A96, 0x28B5, 0x27DD, 0x27EB, 
	0x286C, 0x28EA, 0x28F3, 0x287F, 0x27DF, 0x2724, 0x2661, 0x25A6, 0x2504, 
	0x248F, 0x2525, 0x2686, 0x270B, 0x2512, 0x1F2E, 0x1693, 0x0D8D, 0x0669, 
	0x00EF, 0xFB9B, 0xF6C6, 0xF2C9, 0xEFFD, 0xEEB9, 0xEE64, 0xEE28, 0xEE03, 
	0xEDE2, 0xEDBE, 0xED9A, 0xED7A, 0xED5F, 0xED4D, 0xED47, 0xED86, 0xEE2B, 
	0xEF11, 0xF011, 0xF106, 0xF1CB, 0xF253, 0xF2DD, 0xF366, 0xF3EF, 0xF475, 
	0xF4F7, 0xF573, 0xF5E8, 0xF655, 0xF6B8, 0xF70F, 0xF75A, 0xF797, 0xF7C4, 
	0xF7E1, 0xF7EA, 0xDEDA, 0xDF53, 0xE0A5, 0xE2A2, 0xE523, 0xE7FB, 0xEB01, 
	0xEE0B, 0xF0ED, 0xF37E, 0xF592, 0xF701, 0xF7F4, 0xF8B6, 0xF94B, 0xF9B5, 
	0xF9F7, 0x85E8, 0x85EA, 0x8609, 0x8643, 0x8693, 0x86F7, 0x876B, 0x87EC, 
	0x88BB, 0x8A08, 0x8BB3, 0xF264, 0xF061, 0xEE60, 0xEC84, 0xEA81, 0xE82A, 
	0xE5C8, 0xE3A8, 0xE214, 0xE156, 0xE1CE, 0xE35B, 0xE58C, 0xE7EC, 0xEA08, 
	0xEC16, 0xEE72, 0xF0E6, 0xF339, 0xF534, 0xF6A1, 0xF747, 0xF60C, 0xF2E0, 
	0xEF1E, 0xEC20, 0xEA09, 0xE833, 0xE6CC, 0xE600, 0xE5C7, 0xE5E9, 0xE649, 
	0xE6CB, 0xE750, 0xE7BD, 0xE815, 0xE873, 0xE8D6, 0xE71D, 0xE2AA, 0xDC95, 
	0xD5F5, 0xCFE0, 0xCB6D, 0xC9B4, 0xCC42, 0xD2B3, 0xDB31, 0xE3E5, 0xEAF9, 
	0xEE98, 0xEF05, 0xEF6F, 0xEFD6, 0xF038, 0xF095, 0xF0ED, 0xF13F, 0xF18B, 
	0xF1D0, 0xF20D, 0xF243, 0xF26F, 0xF293, 0xF2AD, 0xF2BE, 0xF2C3, 0x9EEE, 
	0x9EA8, 0x9DE5, 0x9CBD, 0x9B45, 0x9994, 0x97C1, 0x95E3, 0x9411, 0x9261, 
	0x90EA, 0x8FC2, 0x8EC6, 0x8DC5, 0x8CC6, 0x8BCC, 0x8ADF, 0x0A04, 0x093F, 
	0x0895, 0x080D, 0x07AC, 0x0778, 0x0774, 0x07A8, 0x0872, 0x0A09, 0x0C32, 
	0x8EB4, 0x9157, 0x93E1, 0x9619, 0x9869, 0x9B1B, 0x9DC5, 0x9FFE, 0xA15B, 
	0xA174, 0x9F52, 0x9B1D, 0x9618, 0x9186, 0x8EA8, 0x8D63, 0x8CB0, 0x8C76, 
	0x8C9D, 0x8D0C, 0x8DAA, 0x8E5E, 0x8EFF, 0x9003, 0x923D, 0x9682, 0x9DFA, 
	0xA7E4, 0xB234, 0xBADC, 0xC256, 0xCA09, 0xD14D, 0xD77B, 0xDBEB, 0xDDF4, 
	0xDE7F, 0xDEE7, 0xDF2E, 0xDFA9, 0xE05D, 0xE12F, 0xE202, 0xE2BC, 0xE33F, 
	0xE372, 0xE2EB, 0xE192, 0xDFBA, 0xDDB9, 0xDBE6, 0xDA94, 0xD9DE, 0xD926, 
	0xD86C, 0xD7B4, 0xD6FE, 0xD64E, 0xD5A6, 0xD506, 0xD471, 0xD3EA, 0xD372, 
	0xD30C, 0xD2B8, 0xD27A, 0xD253, 0xD246, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xE44B, 0xE457, 0xE478, 0xE4AF, 0xE4F9, 0xE555, 0xE5C2, 0xE63F, 
	0xE6C9, 0xE761, 0xE805, 0xE8B3, 0xE96A, 0xEA28, 0xEAED, 0xEBB7, 0xEC85, 
	0xED56, 0xEE27, 0xEEF9, 0xEFC9, 0xF096, 0xF15F, 0xF222, 0xF2DF, 0xF3B4, 
	0xF4B8, 0xF5DB, 0xF70F, 0xF847, 0xF973, 0xFA86, 0xFB71, 0xFC68, 0xFD90, 
	0xFEC2, 0xFFD7, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFDD8, 0xFA55, 0xF5FD, 
	0xF156, 0xECE8, 0xE938, 0xE5B6, 0xE1D8, 0xDE32, 0xDB58, 0xD9DC, 0xDA52, 
	0xDCD0, 0xE0C1, 0xE5BE, 0xEB5D, 0xF135, 0xF6DE, 0xFBEF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xF1EC, 0xD7C9, 0xC9B6, 0xCA42, 
	0xCE19, 0xD883, 0xECCC, 0xE753, 0xE566, 0xE0CF, 0xDB54, 0xD6BD, 0xD4D0, 
	0xD505, 0xD60B, 0xD7C4, 0xDA13, 0xDCDB, 0xDFFE, 0xE35F, 0xE6E1, 0xEA67, 
	0xEDD3, 0xF109, 0xF3EB, 0xF65C, 0xF83E, 0xF975, 0xF9E3, 0x0000, 0xFFF0, 
	0xFFC6, 0xFF87, 0xFF37, 0xFEDE, 0xFE80, 0xFE22, 0xFDCB, 0xFD80, 0xFD3F, 
	0xFD03, 0xFCCC, 0xFC98, 0xFC66, 0xFC35, 0xFC04, 0xFBD3, 0xFB9F, 0xFB69, 
	0xFB2F, 0xFAF1, 0xFAAD, 0xFA61, 0xFA0F, 0xF9B3, 0xF94E, 0xF8DE, 0xF852, 
	0xF79E, 0xF6CB, 0xF5E2, 0xF4EA, 0xF3EE, 0xF2F4, 0xF207, 0xF12E, 0xF073, 
	0xEFDD, 0xEF76, 0xEF45, 0xEF4D, 0xEF81, 0xEFDD, 0xF05A, 0xF0F1, 0xF19B, 
	0xF253, 0xF310, 0xF3CE, 0xF485, 0xF52F, 0xF5C5, 0xF641, 0xF69D, 0xF6D0, 
	0xF6D6, 0xF5E7, 0xF3A8, 0xF0BD, 0xEDC6, 0xEA88, 0xE6BC, 0xE2F8, 0xDFCF, 
	0xDDD6, 0xDC48, 0xD632, 0xC1D8, 0xC213, 0xC3AA, 0xC7FD, 0xD069, 0xDE4A, 
	0xF219, 0xF207, 0xF18C, 0xF03D, 0xEDB0, 0xE97B, 0xDD08, 0xD9F3, 0xD7B8, 
	0xD63E, 0xD56D, 0xD52D, 0xD565, 0xD5FE, 0xD6DF, 0xD7F1, 0xD91A, 0xDA44, 
	0xDB55, 0xDC37, 0xDCCF, 0xDD08, 0xFB84, 0xFB90, 0xFBB1, 0xFBDF, 0xFC15, 
	0xFC4C, 0xFC7D, 0xFCA4, 0xFCB9, 0xFCB5, 0xFC9E, 0xFC7D, 0xFC53, 0xFC22, 
	0xFBEB, 0xFBB0, 0xFB72, 0xFB32, 0xFAF3, 0xFAB5, 0xFA7A, 0xFA44, 0xFA13, 
	0xF9EA, 0xF9CA, 0xF9B4, 0xF9AA, 0xF9AE, 0xF9D6, 0xFA31, 0xFAB3, 0xFB50, 
	0xFBFD, 0xFCAD, 0xFD55, 0xFDE8, 0xFE5B, 0xFEA2, 0xFEB1, 0xFE7C, 0xFDF7, 
	0xFD29, 0xFC26, 0xFAF3, 0xF996, 0xF817, 0xF67C, 0xF4CA, 0xF308, 0xF13C, 
	0xEF6C, 0xED9F, 0xEBDB, 0xEA27, 0xE887, 0xE704, 0xE5A2, 0xE41B, 0xE2B7, 
	0xE256, 0xE3D8, 0xE819, 0xEE5F, 0xF52B, 0xFAFE, 0xFE5B, 0xFFB2, 0xF022, 
	0xE53B, 0xE564, 0xE67D, 0xE97A, 0xEF4B, 0xF8E3, 0xF19D, 0xF030, 0xECC9, 
	0xE8BA, 0xE553, 0xE3E6, 0xE5B3, 0xE604, 0xE63F, 0xE665, 0xE67B, 0xE682, 
	0xE67C, 0xE66C, 0xE655, 0xE639, 0xE61A, 0xE5FC, 0xE5E0, 0xE5C8, 0xE5B9, 
	0xE5B3, 0xEA98, 0xEB3B, 0xECF0, 0xEF6C, 0xF262, 0xF584, 0xF887, 0xFB1D, 
	0xFCF9, 0xFDD0, 0xFDE2, 0xFDAC, 0xFD35, 0xFC88, 0xFBAD, 0xFAAE, 0xF994, 
	0xF867, 0xF732, 0xF5FE, 0xF4D3, 0xF3BB, 0xF2BF, 0xF1E8, 0xF140, 0xF0CF, 
	0xF0A0, 0xF0BA, 0xF15A, 0xF29E, 0xF466, 0xF690, 0xF8FA, 0xFB85, 0xFE0D, 
	0x0073, 0x0295, 0x0452, 0x0588, 0x0616, 0x05DC, 0x04F1, 0x038F, 0x01C4, 
	0xFF9D, 0xFD28, 0xFA73, 0xF78B, 0xF47F, 0xF15C, 0xEE30, 0xEB09, 0xE7F5, 
	0xE501, 0xE23B, 0xDFB1, 0xDD72, 0xDB5F, 0xD9E4, 0xD9DB, 0xDC1B, 0xE192, 
	0xE974, 0xF20E, 0xF9A9, 0xFE8F, 0x016A, 0x2336, 0x4711, 0x3FF7, 0x2F08, 
	0x1AD1, 0x09E2, 0x02C8, 0xF71D, 0xF3B7, 0xEB9D, 0xE1F1, 0xD9D7, 0xD671, 
	0xD7CA, 0xD7D6, 0xD7DF, 0xD7E5, 0xD7E8, 0xD7E9, 0xD7E9, 0xD7E6, 0xD7E3, 
	0xD7DE, 0xD7DA, 0xD7D5, 0xD7D1, 0xD7CD, 0xD7CB, 0xD7CA, 0xFFFE, 0x0001, 
	0xC170, 0xDCCA, 0xDCCF, 0xDCDC, 0xDCF1, 0xDD0B, 0xDD29, 0xDD4B, 0xDD6E, 
	0xDD90, 0xDDB2, 0xDDD0, 0xDDF3, 0xDE1D, 0xDE4B, 0xDE76, 0xDE98, 0xDEAD, 
	0xDEAE, 0xDE8C, 0xDE42, 0xDDD7, 0xDD55, 0xDCC3, 0xDC29, 0xDB90, 0xDB00, 
	0xDA81, 0xDA1B, 0xD9D8, 0xD9BE, 0xD9D6, 0xDA28, 0xDABD, 0xDB9D, 0xDCD1, 
	0xDE9C, 0xE12A, 0xE457, 0xE800, 0xEC03, 0xF03D, 0xF48B, 0xF8CA, 0xFCD7, 
	0x0091, 0x03D3, 0x067C, 0x08F2, 0x0B8A, 0x0E08, 0x102E, 0x11BE, 0x127D, 
	0x122C, 0x108E, 0x0D67, 0x08A6, 0x028C, 0xFB57, 0xF344, 0xEA8F, 0xE176, 
	0xD836, 0x4F0C, 0x4633, 0x3DEA, 0x366C, 0x2EF7, 0x2808, 0x23C0, 0x2440, 
	0x29AD, 0x323A, 0x3D21, 0x4999, 0x56DC, 0xEA6F, 0x01A7, 0x0F6E, 0x127C, 
	0x12C6, 0x1112, 0x0E25, 0x0AC7, 0x07BD, 0x05CE, 0x049F, 0x035D, 0x0214, 
	0x00D0, 0xFF9D, 0xFE87, 0xFD9A, 0xFCE1, 0xFC6A, 0xFC3F, 0x16C7, 0x16C6, 
	0x16C2, 0x16BD, 0x16B5, 0x16AA, 0x169D, 0x168D, 0x167B, 0x1666, 0x164E, 
	0x1646, 0x1656, 0x1667, 0x1665, 0x163A, 0x15D0, 0x1513, 0x13FF, 0x12A3, 
	0x110F, 0x0F4F, 0x0D6F, 0x0B7D, 0x0987, 0x0798, 0x05BF, 0x0408, 0x0280, 
	0x0134, 0x0032, 0xFF86, 0xFF3D, 0xFF65, 0x000B, 0x019E, 0x0461, 0x0819, 
	0x0C8C, 0x1181, 0x16BF, 0x1C0A, 0x2129, 0x25E3, 0x29FE, 0x2D40, 0x2F6F, 
	0x303B, 0x2FB1, 0x2E22, 0x2BDE, 0x2937, 0x267D, 0x2401, 0x2213, 0x2105, 
	0x20A8, 0x2092, 0x20B7, 0x210E, 0x2189, 0x2220, 0x22C6, 0x5C8E, 0x5BEA, 
	0x5B56, 0x5ADF, 0x5A86, 0x5A32, 0x59BE, 0x5906, 0x5732, 0x545E, 0x51D5, 
	0x50E2, 0x52D1, 0x228D, 0x124E, 0x0883, 0x0714, 0x0785, 0x0951, 0x0BF5, 
	0x0EEA, 0x11AE, 0x13BC, 0x1561, 0x1735, 0x1924, 0x1B17, 0x1CF9, 0x1EB4, 
	0x2032, 0x215E, 0x2221, 0x2267, 0x90BD, 0x90BF, 0x90C6, 0x90D1, 0x90DE, 
	0x90ED, 0x90FB, 0x9109, 0x9115, 0x911D, 0x9122, 0x9137, 0x9164, 0x9195, 
	0x91B5, 0x91AF, 0x916F, 0x90E0, 0x8FFE, 0x8ED7, 0x8D7A, 0x8BF3, 0x8A4E, 
	0x8897, 0x86DD, 0x852A, 0x838C, 0x8210, 0x80C1, 0x7FAD, 0x7EE0, 0x7E66, 
	0x7E4D, 0x7EA0, 0x7F6D, 0x80F8, 0x836B, 0x86A2, 0x8A79, 0x8ECE, 0x937E, 
	0x9865, 0x9D62, 0xA250, 0xA70E, 0xAB78, 0xAF6B, 0xB3A5, 0xB8AF, 0xBE15, 
	0xC361, 0xC820, 0xCBDE, 0xCE27, 0xCE87, 0xCC89, 0xC832, 0xC20C, 0xBA67, 
	0xB192, 0xA7DD, 0x9D9A, 0x9318, 0x08A9, 0xFE99, 0xF53B, 0xECE0, 0xE476, 
	0xDC7A, 0xD78C, 0xD84B, 0xDEBF, 0xE8BC, 0xF591, 0x0490, 0x1507, 0xAE77, 
	0xCD46, 0xE017, 0xE51B, 0xE6B1, 0xE5C5, 0xE342, 0xE014, 0xDD26, 0xDB64, 
	0xDA68, 0xD93D, 0xD7F4, 0xD69D, 0xD54C, 0xD410, 0xD2FD, 0xD222, 0xD192, 
	0xD15E, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xE6BD, 0xE709, 0xE7DC, 0xE91C, 0xEAB1, 0xEC7F, 0xEE6D, 0xF062, 0xF245, 
	0xF3FA, 0xF569, 0xF6BA, 0xF81D, 0xF986, 0xFAE8, 0xFC38, 0xFD69, 0xFE6F, 
	0xFF3C, 0xFFC6, 0x0000, 0xFFE8, 0xFF8E, 0xFEFC, 0xFE3E, 0xFD5F, 0xFC69, 
	0xFB67, 0xFA64, 0xF96B, 0xF887, 0xF7C2, 0xF729, 0xF6C4, 0xF6A1, 0xF6C7, 
	0xF733, 0xF7D7, 0xF8A9, 0xF99C, 0xFAA5, 0xFBB7, 0xFCC6, 0xFDC8, 0xFEAF, 
	0xFF70, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFBAB, 0xF4E5, 0xED18, 0xE5B1, 0xE01D, 0xDDC6, 0xE000, 0xE5EC, 0xEDA9, 
	0xF55A, 0xFB1E, 0xFD18, 0xF447, 0xE3C7, 0xD8E3, 0xDAF5, 0xE2A3, 0xE725, 
	0x0003, 0xFFED, 0xFFB1, 0xFF57, 0xFEE8, 0xFE6C, 0xFDEA, 0xFD6D, 0xFCFB, 
	0xFC9D, 0xFC5C, 0xFC38, 0xFC28, 0xFC28, 0xFC33, 0xFC44, 0xFC55, 0xFC63, 
	0xFC67, 0xFC5E, 0xFC42, 0xFC13, 0xFBD5, 0xFB8C, 0xFB3A, 0xFAE2, 0xFA88, 
	0xFA2E, 0xF9D7, 0xF986, 0xF93D, 0xF901, 0xF8D4, 0xF8B8, 0xF8B1, 0xF8C2, 
	0xF8EB, 0xF928, 0xF976, 0xF9D2, 0xFA38, 0xFAA4, 0xFB14, 0xFB83, 0xFBEE, 
	0xFC52, 0xFCAB, 0xFCFF, 0xFD53, 0xFDA7, 0xFDFB, 0xFE4E, 0xFE9E, 0xFEEB, 
	0xFF34, 0xFF79, 0xFFBC, 0xFFFE, 0x003C, 0x0073, 0x00A0, 0x00C0, 0x00D0, 
	0x00D2, 0x00CA, 0x00BB, 0x00A6, 0x008D, 0x0072, 0x0056, 0x003C, 0x0024, 
	0x0011, 0x0004, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xF638, 0xF642, 0xF65C, 0xF685, 
	0xF6BA, 0xF6F9, 0xF73F, 0xF78B, 0xF7D9, 0xF828, 0xF876, 0xF8C9, 0xF929, 
	0xF991, 0xF9FF, 0xFA6D, 0xFAD9, 0xFB3E, 0xFB98, 0xFBE4, 0xFC1C, 0xFC42, 
	0xFC59, 0xFC64, 0xFC66, 0xFC61, 0xFC58, 0xFC4D, 0xFC45, 0xFC40, 0xFC43, 
	0xFC50, 0xFC69, 0xFC91, 0xFCCB, 0xFD20, 0xFD92, 0xFE1B, 0xFEB5, 0xFF5A, 
	0x0004, 0x00AC, 0x014D, 0x01E0, 0x025F, 0x02C5, 0x030A, 0x0325, 0x0316, 
	0x02E5, 0x029B, 0x0243, 0x01E5, 0x018A, 0x013C, 0x0103, 0x00D0, 0x0094, 
	0x005A, 0x002D, 0x0018, 0x0025, 0x0060, 0x00CA, 0x015A, 0x0206, 0x02C5, 
	0x038F, 0x045A, 0x051E, 0x05D3, 0x066E, 0x06E9, 0x0738, 0x0755, 0xECA1, 
	0xED0A, 0xEE2D, 0xEFE2, 0xF203, 0xF46A, 0xF6EE, 0xF96A, 0xFBB7, 0xFDAF, 
	0xFF2A, 0x0065, 0x01AA, 0x02E6, 0x0406, 0x04F8, 0x05A7, 0x0603, 0x05F7, 
	0x0571, 0x045D, 0x02A8, 0x0059, 0xFD8F, 0xFA63, 0xF6F4, 0xF35C, 0xEFB9, 
	0xEC25, 0xE8BE, 0xE59F, 0xE2E4, 0xE0A9, 0xDF0C, 0xDE26, 0xDE20, 0xDEF3, 
	0xE07C, 0xE299, 0xE524, 0xE7FB, 0xEAF9, 0xEDFC, 0xF0DF, 0xF37F, 0xF5B9, 
	0xF768, 0xF880, 0xF921, 0xF96B, 0xF97D, 0xF976, 0xF977, 0xF99D, 0xFA0A, 
	0xFADC, 0xFCA7, 0xFF82, 0x02D2, 0x05F8, 0x0859, 0x0957, 0x0855, 0x0564, 
	0x012A, 0xFBF4, 0xF60B, 0xEFBC, 0xE952, 0xE316, 0xDD54, 0xD857, 0xD46A, 
	0xD1D9, 0xD0ED, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xEB49, 0xEB5F, 0xEB9E, 0xEBFE, 0xEC78, 
	0xED06, 0xEDA1, 0xEE41, 0xEEE0, 0xEF77, 0xEFFF, 0xF071, 0xF0C7, 0xF0F8, 
	0xF107, 0xF0FA, 0xF0D7, 0xF0A1, 0xF05D, 0xF00F, 0xEFBB, 0xEF67, 0xEF16, 
	0xEECE, 0xEE91, 0xEE65, 0xEE4E, 0xEE48, 0xEE4B, 0xEE56, 0xEE69, 0xEE81, 
	0xEE9D, 0xEEBD, 0xEEDF, 0xEF02, 0xEF25, 0xEF47, 0xEF66, 0xEF82, 0xEF98, 
	0xEFA9, 0xEFB2, 0xEFB2, 0xEFAA, 0xEF96, 0xEF6B, 0xEF22, 0xEEC0, 0xEE4C, 
	0xEDCA, 0xED42, 0xECB8, 0xEC32, 0xEBB6, 0xEB4A, 0xEAF5, 0xEABA, 0xEAA1, 
	0xEAAF, 0xEAEB, 0xEB8B, 0xECAD, 0xEE2E, 0xEFEB, 0xF1C3, 0xF392, 0xF535, 
	0xF68A, 0xF76E, 0xF7BF, 0xF6F8, 0xF500, 0xF257, 0xEF7A, 0xECE8, 0xEB1E, 
	0xEA9B, 0xF17E, 0xEEA4, 0xF030, 0xF276, 0xF1B8, 0xEA38, 0xEE10, 0xECEE, 
	0xEE2A, 0xED87, 0xEE5A, 0xEF8F, 0xF0FE, 0xF280, 0xF3F0, 0xF527, 0xF5FD, 
	0xF64D, 0xECF8, 0xECDA, 0xEC84, 0xEBFF, 0xEB53, 0xEA87, 0xE9A4, 0xE8B1, 
	0xE7B6, 0xE6BB, 0xE5C9, 0xE4E6, 0xE41A, 0xE36F, 0xE2CF, 0xE224, 0xE174, 
	0xE0C2, 0xE014, 0xDF6F, 0xDED7, 0xDE51, 0xDDE2, 0xDD8F, 0xDD5D, 0xDD4F, 
	0xDD6C, 0xDDB3, 0xDE1B, 0xDEA1, 0xDF41, 0xDFF7, 0xE0BE, 0xE193, 0xE272, 
	0xE356, 0xE43C, 0xE51E, 0xE5FA, 0xE6CB, 0xE78D, 0xE83B, 0xE8D3, 0xE94F, 
	0xE9AB, 0xE9E4, 0xE9E9, 0xE9B1, 0xE947, 0xE8B3, 0xE800, 0xE737, 0xE662, 
	0xE58A, 0xE4B8, 0xE3F7, 0xE350, 0xE2CD, 0xE276, 0xE256, 0xE277, 0xE312, 
	0xE443, 0xE5E2, 0xE7C8, 0xE9CF, 0xEBCF, 0xEDA2, 0xEF20, 0xF024, 0xF085, 
	0xEFFB, 0xEE84, 0xEC64, 0xE9E1, 0xE73E, 0xE4C0, 0xE2AB, 0xE11A, 0xE06C, 
	0xE0BE, 0xE178, 0xE235, 0xE28C, 0xE1A6, 0xE07F, 0xE07E, 0xE09A, 0xE049, 
	0xDFE2, 0xDF6F, 0xDEFB, 0xDE8F, 0xDE36, 0xDDF9, 0xDDE2, 0xA771, 0xA73E, 
	0xA6B0, 0xA5D6, 0xA4BD, 0xA375, 0xA20B, 0xA090, 0x9F10, 0x9D9B, 0x9C40, 
	0x9B0C, 0x9A0E, 0x9956, 0x98D7, 0x987B, 0x983B, 0x9816, 0x9807, 0x9809, 
	0x9819, 0x9833, 0x9852, 0x9873, 0x9892, 0x98AA, 0x98B8, 0x98BB, 0x98B9, 
	0x98B1, 0x98A6, 0x9899, 0x988B, 0x987E, 0x9874, 0x986D, 0x986C, 0x9871, 
	0x987F, 0x9897, 0x98B9, 0x98E9, 0x9926, 0x9973, 0x99D1, 0x9A42, 0x9AD3, 
	0x9B8F, 0x9C6E, 0x9D6B, 0x9E80, 0x9FA6, 0xA0D6, 0xA20C, 0xA340, 0xA46B, 
	0xA589, 0xA692, 0xA781, 0xA84F, 0xA8F6, 0xA967, 0xA99F, 0xA9A9, 0xA98F, 
	0xA95D, 0xA91D, 0xA8DB, 0xA8A0, 0xA877, 0xA86C, 0xA891, 0xA8DF, 0xA93F, 
	0xA997, 0xA9CD, 0xA9C8, 0xA96E, 0xA651, 0xA381, 0xA47F, 0xA69F, 0xA8BF, 
	0xA9C2, 0xA73A, 0xA3F3, 0xA3F0, 0xA416, 0xA2C3, 0xA119, 0x9F42, 0x9D66, 
	0x9BAD, 0x9A40, 0x9947, 0x98EB, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x2855, 0x28A4, 0x2982, 
	0x2AD6, 0x2C89, 0x2E82, 0x30A9, 0x32E8, 0x3525, 0x3749, 0x393C, 0x3AE6, 
	0x3C2F, 0x3CFF, 0x3D3E, 0x3CDF, 0x3BF3, 0x3A8E, 0x38C7, 0x36B2, 0x3464, 
	0x31F3, 0x2F74, 0x2CFD, 0x2AA1, 0x2877, 0x2693, 0x2498, 0x223C, 0x1FB6, 
	0x1D3C, 0x1B06, 0x1949, 0x183D, 0x1818, 0x1911, 0x1BDF, 0x20A6, 0x26BD, 
	0x2D7B, 0x3437, 0x3A49, 0x3F06, 0x41C7, 0x4329, 0x443F, 0x450D, 0x459B, 
	0x45ED, 0x4609, 0x45F5, 0x45B5, 0x4551, 0x44CC, 0x442E, 0x437B, 0x42BA, 
	0x41EF, 0x4120, 0x4054, 0x3F8E, 0x3D15, 0x3847, 0x32CF, 0x2A98, 0x2CC7, 
	0x30C5, 0x3286, 0x3028, 0x2B8D, 0x264B, 0x209F, 0x1A14, 0x133B, 0x0CA3, 
	0x06DC, 0x0275, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x00C0, 0x019E, 0x027C, 0x0351, 0x0415, 0x04BC, 
	0x0540, 0x0595, 0x05B4, 0xFA59, 0xFA66, 0xFA87, 0xFAB7, 0xFAF0, 0xFB2D, 
	0xFB67, 0xFB98, 0xFBBB, 0xFBE5, 0xFC25, 0xFC72, 0xFCBF, 0xFD02, 0xFD2F, 
	0xFD3C, 0xFD1D, 0xFCC6, 0xFC2E, 0xFB06, 0xF935, 0xF6FA, 0xF495, 0xF248, 
	0xF051, 0xEEF2, 0xEE6A, 0xEE95, 0xEF1B, 0xEFEC, 0xF0FB, 0xF237, 0xF392, 
	0xF4FE, 0xF66B, 0xF7CB, 0xF90F, 0xFA27, 0xFB06, 0xFB9C, 0xFBEC, 0xFC09, 
	0xFBFB, 0xFBCA, 0xFB7E, 0xFB1E, 0xFAB3, 0xFA44, 0xF9D9, 0xF97A, 0xF930, 
	0xF901, 0xF8E2, 0xF8C3, 0xF8A8, 0xF894, 0xF88C, 0xF893, 0xF8AD, 0xF8DE, 
	0xF92A, 0xF9AE, 0xFA74, 0xFB66, 0xFC6B, 0xFD6D, 0xFE53, 0xFF36, 0x0020, 
	0x00E3, 0x0156, 0x017C, 0x017E, 0x0167, 0x0142, 0x0118, 0x00F3, 0x00DF, 
	0x00D7, 0x00CE, 0x00C6, 0x00BF, 0x00B7, 0x00B0, 0x00A9, 0x00A3, 0x009D, 
	0x0097, 0x0092, 0x008E, 0x008A, 0x0087, 0x0084, 0x0082, 0x0081, 0x02E9, 
	0x02F6, 0x0319, 0x034A, 0x0382, 0x03BA, 0x03EA, 0x040D, 0x0419, 0x0414, 
	0x0406, 0x03EF, 0x03D3, 0x03B0, 0x038A, 0x0361, 0x0336, 0x030B, 0x02E0, 
	0x02AB, 0x0266, 0x0217, 0x01C8, 0x0181, 0x014A, 0x012A, 0x012A, 0x0148, 
	0x0177, 0x01B5, 0x01FF, 0x0250, 0x02A7, 0x02FE, 0x0354, 0x03A5, 0x03ED, 
	0x042A, 0x0457, 0x0471, 0x047A, 0x0476, 0x0466, 0x044B, 0x0428, 0x03FD, 
	0x03CE, 0x039A, 0x0363, 0x032C, 0x02F6, 0x02C3, 0x028C, 0x024C, 0x0207, 
	0x01BD, 0x0171, 0x0126, 0x00DC, 0x0097, 0x0057, 0x001E, 0xFFE9, 0xFFB8, 
	0xFF8D, 0xFF69, 0xFF4B, 0xFF3E, 0xFF44, 0xFF4F, 0xFF55, 0xFF55, 0xFF54, 
	0xFF52, 0xFF50, 0xFF4E, 0xFF4B, 0xFF48, 0xFF44, 0xFF40, 0xFF3B, 0xFF36, 
	0xFF31, 0xFF2B, 0xFF25, 0xFF20, 0xFF1A, 0xFF15, 0xFF10, 0xFF0B, 0xFF07, 
	0xFF04, 0xFF01, 0xFEFF, 0xFEFD, 0xCC6C, 0xCCEB, 0xCE3E, 0xD024, 0xD25E, 
	0xD4AB, 0xD6CB, 0xD87E, 0xD983, 0xDA03, 0xDA53, 0xDA74, 0xDA6B, 0xDA38, 
	0xD9DF, 0xD963, 0xD8C7, 0xD80C, 0xD736, 0xD5F4, 0xD41B, 0xD1E5, 0xCF8F, 
	0xCD54, 0xCB6E, 0xCA1A, 0xC992, 0xC9C6, 0xCA6E, 0xCB72, 0xCCBD, 0xCE38, 
	0xCFCB, 0xD160, 0xD2E2, 0xD438, 0xD54C, 0xD608, 0xD656, 0xD61D, 0xD559, 
	0xD41F, 0xD27E, 0xD089, 0xCE4F, 0xCBE2, 0xC952, 0xC6B1, 0xC40E, 0xC17B, 
	0xBF09, 0xBCC8, 0xBA86, 0xB814, 0xB589, 0xB2FC, 0xB084, 0xAE39, 0xAC31, 
	0xAA83, 0xA946, 0xA8A5, 0xA8AE, 0xA94E, 0xAA73, 0xAC0A, 0xAE00, 0xB17E, 
	0xB691, 0xBB7B, 0xBE80, 0xBF82, 0xBFBA, 0xBF6C, 0xBEDF, 0xBE56, 0xBE17, 
	0xBE67, 0xBF29, 0xC010, 0xC116, 0xC235, 0xC368, 0xC4A7, 0xC5EF, 0xC738, 
	0xC87D, 0xC9B9, 0xCAE5, 0xCBFC, 0xCCF8, 0xCDD3, 0xCE88, 0xCF10, 0xCF66, 
	0xCF84, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0xBF5A, 
	0xBF50, 0xBF3F, 0xBF29, 0xBF0D, 0xBEED, 0xBEC9, 0xBEA2, 0xBE77, 0xBE4B, 
	0xBE1C, 0xBDED, 0xBDBD, 0xBD8D, 0xBD5D, 0xBD2F, 0xBD02, 0xBCD8, 0xBCB0, 
	0xBC8C, 0xBC6C, 0xBC51, 0xBC3A, 0xBC2A, 0xBC1F, 0xBC1C, 0xBC1D, 0xBC22, 
	0xBC29, 0xBC33, 0xBC40, 0xBC4F, 0xBC60, 0xBC73, 0xBC88, 0xBC9F, 0xBCB8, 
	0xBCD2, 0xBCEE, 0xBD0A, 0xBD28, 0xBD47, 0xBD66, 0xBD86, 0xBDA7, 0xBDC7, 
	0xBDE8, 0xBE09, 0xBE2A, 0xBE4A, 0xBE6B, 0xBE8A, 0xBEA9, 0xBEC6, 0xBEE3, 
	0xBEFF, 0xBF19, 0xBF32, 0xBF49, 0xBF5E, 0xBF6D, 0xBF73, 0xBF72, 0xBF6D, 
	0xBF66, 0xBF60, 0xBF5E, 0x126A, 0x1269, 0x1269, 0x1268, 0x1267, 0x1266, 
	0x1264, 0x1263, 0x1261, 0x125F, 0x125D, 0x125B, 0x1259, 0x1257, 0x1255, 
	0x1253, 0x1252, 0x1250, 0x124E, 0x124D, 0x124C, 0x124B, 0x124B, 0x124B, 
	0x124B, 0x124B, 0x124C, 0x124E, 0x1250, 0x1253, 0x1256, 0x125A, 0x125F, 
	0x1264, 0x1269, 0x126F, 0x1275, 0x127B, 0x1281, 0x1287, 0x128E, 0x1294, 
	0x129A, 0x12A0, 0x12A6, 0x12AB, 0x12B0, 0x12B5, 0x12B9, 0x12BC, 0x12BF, 
	0x12C1, 0x12C3, 0x12C3, 0x12C3, 0x12C2, 0x12C0, 0x12BD, 0x12B9, 0x12B4, 
	0x12AD, 0x1295, 0x1261, 0x121D, 0x11D0, 0x1187, 0x114A, 0x1125, 0x1110, 
	0x10FF, 0x10F4, 0x10EC, 0x10EA, 0x10EC, 0x10F3, 0x10FF, 0x110F, 0x1125, 
	0x11BD, 0x1244, 0x1236, 0x1221, 0x1205, 0x11E5, 0x11C0, 0x1199, 0x1170, 
	0x1147, 0x111E, 0x10F7, 0x10D3, 0x10B3, 0x1098, 0x1083, 0x1076, 0x1071, 
	0x0FA5, 0x0F8D, 0x0F49, 0x0EDC, 0x0E4A, 0x0D96, 0x0CC3, 0x0BD5, 0x0ACF, 
	0x09B5, 0x088B, 0x0754, 0x0613, 0x04CC, 0x0383, 0x023A, 0x00F6, 0xFFBA, 
	0xFE89, 0xFD67, 0xFC58, 0xFB5E, 0xFA7E, 0xF9BA, 0xF917, 0xF898, 0xF840, 
	0xF803, 0xF7D2, 0xF7AC, 0xF792, 0xF782, 0xF77C, 0xF780, 0xF78E, 0xF7A4, 
	0xF7C3, 0xF7E9, 0xF817, 0xF84C, 0xF888, 0xF8CA, 0xF911, 0xF95E, 0xF9B0, 
	0xFA06, 0xFA60, 0xFABD, 0xFB1D, 0xFB80, 0xFBE5, 0xFC4C, 0xFCB4, 0xFD1C, 
	0xFD85, 0xFDEE, 0xFE56, 0xFEBD, 0xFF23, 0xFF87, 0xFFE8, 0x008E, 0x01A3, 
	0x02FC, 0x046D, 0x05CC, 0x06ED, 0x07A4, 0x0809, 0x0852, 0x0880, 0x0896, 
	0x0896, 0x0883, 0x085F, 0x082C, 0x07ED, 0x07A4, 0x05BD, 0x0407, 0x0428, 
	0x045F, 0x04A8, 0x0501, 0x0566, 0x05D4, 0x0647, 0x06BB, 0x072F, 0x079E, 
	0x0805, 0x0861, 0x08AE, 0x08E9, 0x090F, 0x091C, 0xA0AD, 0xA0BF, 0xA0F1, 
	0xA141, 0xA1AD, 0xA230, 0xA2C8, 0xA373, 0xA42C, 0xA4F2, 0xA5C1, 0xA696, 
	0xA76F, 0xA848, 0xA91E, 0xA9EF, 0xAAB7, 0xAB74, 0xAC22, 0xACBE, 0xAD47, 
	0xADB8, 0xAE0E, 0xAE47, 0xAE60, 0xAE56, 0xAE26, 0xADDA, 0xAD81, 0xAD1A, 
	0xACA6, 0xAC26, 0xAB9A, 0xAB02, 0xAA5F, 0xA9B2, 0xA8FA, 0xA839, 0xA76F, 
	0xA69C, 0xA5C0, 0xA4DD, 0xA3F2, 0xA301, 0xA209, 0xA10B, 0xA008, 0x9F00, 
	0x9DF3, 0x9CE2, 0x9BCE, 0x9AB7, 0x999D, 0x9880, 0x9762, 0x9643, 0x9523, 
	0x9402, 0x92E2, 0x91C3, 0x90A4, 0x8F09, 0x8CAB, 0x89D9, 0x86E4, 0x841E, 
	0x81D7, 0x8060, 0x7F8B, 0x7EF1, 0x7E8F, 0x7E5F, 0x7E5D, 0x7E84, 0x7ED0, 
	0x7F3C, 0x7FC3, 0x8060, 0x8481, 0x8836, 0x87EB, 0x876F, 0x86CB, 0x8605, 
	0x8525, 0x8433, 0x8334, 0x8232, 0x8132, 0x803D, 0x7F5A, 0x7E90, 0x7DE6, 
	0x7D63, 0x7D0F, 0x7CF2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x3A66, 0x3A2E, 0x398A, 0x3884, 0x3725, 0x3575, 
	0x337C, 0x3144, 0x2ED6, 0x2C39, 0x2977, 0x2699, 0x23A6, 0x20A9, 0x1DAA, 
	0x1AB0, 0x17C6, 0x14F4, 0x1242, 0x0FBA, 0x0D63, 0x0B48, 0x0970, 0x07E4, 
	0x06AD, 0x05D3, 0x0560, 0x0537, 0x0534, 0x0554, 0x0597, 0x05FB, 0x067F, 
	0x071F, 0x07DC, 0x08B3, 0x09A3, 0x0AA9, 0x0BC5, 0x0CF5, 0x0E36, 0x0F88, 
	0x10E9, 0x1256, 0x13CF, 0x1552, 0x16DC, 0x186E, 0x1A03, 0x1B9C, 0x1D37, 
	0x1ED1, 0x206A, 0x21FE, 0x238E, 0x2517, 0x2698, 0x280E, 0x2979, 0x2AD6, 
	0x2C24, 0x2DEE, 0x3077, 0x3355, 0x3619, 0x3858, 0x39A6, 0x3996, 0x3827, 
	0x35C8, 0x32B6, 0x2F2A, 0x2B62, 0x2799, 0x240A, 0x20F2, 0x1E8A, 0x1D11, 
	0x207E, 0x282E, 0x2D70, 0x2CA2, 0x2968, 0x27F7, 0x2AC7, 0x2F62, 0x329A, 
	0x3401, 0x3543, 0x365F, 0x3754, 0x3820, 0x38C1, 0x3936, 0x397E, 0x3996, 
	0xF554, 0xF559, 0xF565, 0xF579, 0xF595, 0xF5B9, 0xF5E5, 0xF617, 0xF651, 
	0xF692, 0xF6D9, 0xF727, 0xF77B, 0xF7D6, 0xF836, 0xF89C, 0xF907, 0xF974, 
	0xF9E4, 0xFA53, 0xFAC2, 0xFB2E, 0xFB97, 0xFBFA, 0xFC57, 0xFCAB, 0xFCF7, 
	0xFD38, 0xFD6D, 0xFD94, 0xFDAD, 0xFDB5, 0xFD11, 0xFB5A, 0xF8DD, 0xF5EB, 
	0xF2D1, 0xEFDF, 0xED63, 0xEBAB, 0xEB07, 0xEB1A, 0xEB4E, 0xEB9B, 0xEBF7, 
	0xEC5A, 0xECBD, 0xED16, 0xED5D, 0xED93, 0xEDD9, 0xEE5D, 0xEF49, 0xF0CA, 
	0xF30A, 0xF636, 0xFA79, 0x0000, 0xFF65, 0xFF57, 0xFF4D, 0xFF46, 0xFF44, 
	0xFF44, 0xFF46, 0xFF49, 0xFF4C, 0xFF4D, 0xF777, 0xF7A8, 0xF833, 0xF909, 
	0xFA1A, 0xFB58, 0xFCB3, 0xFE1E, 0xFF88, 0x00E5, 0x0223, 0x0334, 0x0409, 
	0x0494, 0x04C6, 0x04C5, 0x04C3, 0x04BF, 0x04BB, 0x04B6, 0x04AF, 0x04A9, 
	0x04A2, 0x049B, 0x0494, 0x048E, 0x0487, 0x0482, 0x047E, 0x047A, 0x0478, 
	0x0477, 0x047F, 0x0496, 0x04B8, 0x04E2, 0x0510, 0x0540, 0x056D, 0x0595, 
	0x05B4, 0x05CB, 0x05DC, 0x05E8, 0x05F1, 0x05F5, 0x05F8, 0x05F9, 0x05F9, 
	0x05DC, 0x058D, 0x051A, 0x0490, 0x03FC, 0x036C, 0x02ED, 0x028C, 0x0257, 
	0x024D, 0x0246, 0x0241, 0x023F, 0x023E, 0x023E, 0x023F, 0x0240, 0x0241, 
	0xAE2E, 0xAE54, 0xAEC1, 0xAF6C, 0xB04E, 0xB15E, 0xB294, 0xB3E7, 0xB550, 
	0xB6C7, 0xB842, 0xB9BB, 0xBB29, 0xBC83, 0xBDC2, 0xBEDF, 0xBFDC, 0xC0BA, 
	0xC17E, 0xC22A, 0xC2C2, 0xC348, 0xC3BF, 0xC42A, 0xC48D, 0xC4EA, 0xC544, 
	0xC59E, 0xC5FC, 0xC660, 0xC6CD, 0xC746, 0xC7CD, 0xC85D, 0xC8EE, 0xC97C, 
	0xC9FE, 0xCA6F, 0xCAC7, 0xCB01, 0xCB16, 0xCB15, 0xCB0F, 0xCAFD, 0xCADC, 
	0xCAA4, 0xCA51, 0xC9DD, 0xC943, 0xC864, 0xC738, 0xC5D4, 0xC451, 0xC2C5, 
	0xC148, 0xBFF1, 0xBED7, 0xBE11, 0xBD9F, 0xBD38, 0xBCDC, 0xBC9C, 0xBC84, 
	0xBC87, 0xBC9C, 0xBCB9, 0xBCD1, 0xBCDC, 

},{ 
	0x0048, 0x0000, 0x0058, 0x0048, 0x0001, 0x00A0, 0x0001, 0x00A1, 0x0001, 
	0x00A2, 0x0001, 0x00A3, 0x0060, 0x00A4, 0x0060, 0x0104, 0x0060, 0x0164, 
	0x005D, 0x01C4, 0x005D, 0x0221, 0x005D, 0x027E, 0x005D, 0x02DB, 0x005D, 
	0x0338, 0x005D, 0x0395, 0x0001, 0x03F2, 0x0001, 0x03F3, 0x0001, 0x03F4, 
	0x0060, 0x03F5, 0x0060, 0x0455, 0x0060, 0x04B5, 0x0045, 0x0515, 0x0059, 
	0x055A, 0x0060, 0x05B3, 0x0060, 0x0613, 0x0060, 0x0673, 0x0060, 0x06D3, 
	0x0001, 0x0733, 0x0001, 0x0734, 0x0001, 0x0735, 0x0060, 0x0736, 0x0060, 
	0x0796, 0x0060, 0x07F6, 0x005D, 0x0856, 0x005F, 0x08B3, 0x0051, 0x0912, 
	0x005F, 0x0963, 0x004B, 0x09C2, 0x004B, 0x0A0D, 0x005E, 0x0A58, 0x0060, 
	0x0AB6, 0x0001, 0x0B16, 0x0060, 0x0B17, 0x0060, 0x0B77, 0x0060, 0x0BD7, 
	0x005F, 0x0C37, 0x0060, 0x0C96, 0x0060, 0x0CF6, 0x005F, 0x0D56, 0x005F, 
	0x0DB5, 0x0060, 0x0E14, 0x005E, 0x0E74, 0x005C, 0x0ED2, 0x0044, 0x0F2E, 
	0x0060, 0x0F72, 0x0060, 0x0FD2, 0x0060, 0x1032, 0x0060, 0x1092, 0x005D, 
	0x10F2, 0x0060, 0x114F, 0x0044, 0x11AF, 0x0043, 0x11F3, 0x0044, 0x1236, 
	

});

smlua_anim_util_register_animation('donkey_34_fast_ledge_grab',1, 0, 0, 0, 15, { 
	0x0000, 0xFF02, 0xFF04, 0xFF17, 0xFF49, 0xFFE3, 0x0044, 0x005E, 0x006F, 
	0x0077, 0x0078, 0x0078, 0x0078, 0x007B, 0x0082, 0x0088, 0x008B, 0xFFC3, 
	0xFFC0, 0xFFAA, 0xFF70, 0xFF62, 0xFF74, 0xFF9E, 0xFFCA, 0xFFED, 0x0000, 
	0x0007, 0x000B, 0x0012, 0x001B, 0x0022, 0x0025, 0x0000, 0x3FFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFE, 0x4973, 0x4907, 0x4612, 0x3E0C, 0x2E6D, 0x1BF9, 0x1241, 0x156A, 
	0x1D1B, 0x26F0, 0x31B8, 0x3C8E, 0x468A, 0x4EC9, 0x5464, 0x5675, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xDC43, 0xDD26, 0xE35B, 0xF436, 0x1508, 0x338F, 0x430A, 0x3F43, 
	0x36A8, 0x2CBD, 0x22B1, 0x191D, 0x109E, 0x09CD, 0x0544, 0x039F, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xF371, 0xF371, 
	0xF371, 0xF371, 0xF371, 0xF663, 0xFCDD, 0x0358, 0x064A, 0x04F4, 0x0183, 
	0xFCCD, 0xF7AB, 0xF2F6, 0xEF85, 0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xC465, 
	0xC479, 0xC507, 0xC685, 0xC96F, 0xC773, 0xC26B, 0x3BB8, 0x34B3, 0x2E7D, 
	0x294C, 0x2519, 0x21DF, 0x1F98, 0x1E3E, 0x1DCC, 0xACA7, 0xACD1, 0xADF8, 
	0xB119, 0xB72F, 0xBBE5, 0xBE31, 0xC4F6, 0xC81E, 0xC5D1, 0xC18C, 0xBF40, 
	0xC346, 0xCC20, 0xD4FB, 0xD901, 0xE94D, 0xE9BD, 0xECCE, 0xF520, 0x0554, 
	0x0C61, 0x1C07, 0xB905, 0xC9FF, 0xC905, 0xC682, 0xC312, 0xBF53, 0xBBE4, 
	0xB960, 0xB867, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xC739, 0xC70B, 
	0xC5CD, 0xC26C, 0xBBD8, 0xB6A0, 0xB5E1, 0xB6CA, 0xBD27, 0xBBA3, 0xB8D1, 
	0xB74D, 0xBA37, 0xC0A0, 0xC70A, 0xC9F4, 0xFD94, 0xFD94, 0xFD94, 0xFD94, 
	0xFD94, 0xFDDA, 0xFEA0, 0xFFD4, 0x0164, 0x032F, 0x04DF, 0x060C, 0x06A9, 
	0x06FA, 0x0717, 0x071C, 0xECF7, 0xECF7, 0xECF7, 0xECF7, 0xECF7, 0xED12, 
	0xEDCB, 0xEFC1, 0xF393, 0xFD7C, 0x0AB3, 0x114E, 0x0F13, 0x0A2A, 0x0541, 
	0x0306, 0x0ECD, 0x0ECD, 0x0ECD, 0x0ECD, 0x0ECD, 0x0E0D, 0x0C67, 0x0AC1, 
	0x0A01, 0x0A05, 0x0A13, 0x0A2B, 0x0A4A, 0x0A6B, 0x0A85, 0x0A90, 0xFFFE, 
	0x0001, 0xC170, 0x3A0E, 0x39F1, 0x3923, 0x36F6, 0x32B8, 0x3422, 0x3741, 
	0x3A63, 0xBBCF, 0x3472, 0x2174, 0x077B, 0xEB2E, 0xD136, 0x3E38, 0x36DA, 
	0x52A6, 0x527C, 0x5158, 0x4E40, 0x483A, 0x4575, 0x4451, 0x4757, 0x35A4, 
	0x48A0, 0x4426, 0x3E08, 0x375E, 0x3140, 0x5339, 0x54F5, 0xE8B9, 0xE920, 
	0xEBEE, 0xF38A, 0x025E, 0x0752, 0x14AB, 0x2FD1, 0xC009, 0x36B1, 0x1E99, 
	0xFDA5, 0xD9BF, 0xB8CC, 0x20B4, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xC4C1, 0xC49C, 0xC399, 0xC0DB, 0xBB83, 0xB59D, 0xB4C5, 0xB576, 
	0xBA4F, 0xB964, 0xB7AF, 0xB6C4, 0xB9FC, 0xC112, 0xC828, 0xCB60, 0xFFA8, 
	0xFFA8, 0xFFA8, 0xFFA8, 0xFFA8, 0xFFB5, 0xFFD2, 0xFFEF, 0xFFFC, 0xFFB0, 
	0xFEE7, 0xFDCF, 0xFC95, 0xFB6F, 0xFA96, 0xFA42, 0x131D, 0x131D, 0x131D, 
	0x131D, 0x131D, 0x131B, 0x130E, 0x12E9, 0x12A2, 0x0F5E, 0x093D, 0x04AC, 
	0x02E4, 0x01FA, 0x01A3, 0x0197, 0x0A45, 0x0A45, 0x0A45, 0x0A45, 0x0A45, 
	0x0B33, 0x0D3F, 0x0F4B, 0x1039, 0x0FC1, 0x0E7D, 0x0CA4, 0x0A76, 0x085B, 
	0x06C5, 0x0624, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xF470, 0xF4DA, 
	0xF7BE, 0xFF95, 0x0EDC, 0x074D, 0x036C, 0x01FE, 0x01CA, 0x023E, 0x0316, 
	0x038A, 0x02C5, 0x0113, 0xFF60, 0xFE9B, 0xEF59, 0xEF8A, 0xF0DF, 0xF47B, 
	0xFB83, 0xF9A5, 0xF8AF, 0xF855, 0xF848, 0xF6F4, 0xF58F, 0xF419, 0xF29D, 
	0xF14A, 0xF056, 0xEFF9, 0xA11F, 0xA0CA, 0x9E7B, 0x9837, 0x8C02, 0x8602, 
	0x82ED, 0x81CA, 0x81A0, 0x7BFD, 0x7658, 0x73C7, 0x7641, 0x7BB3, 0x8125, 
	0x839E, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFB4, 0xFF2A, 0xFEDF, 0xFF0C, 
	0xFF6F, 0xFFD2, 0xFFFF, 0x21C3, 0x22B4, 0x294D, 0x3B34, 0x5E10, 0x49FE, 
	0x3FAF, 0x3BE3, 0x3B58, 0x4422, 0x5474, 0x5D3E, 0x5A39, 0x5396, 0x4CF2, 
	0x49EE, 0x013B, 0x010E, 0xFFD7, 0xFC8C, 0xF623, 0xF73B, 0xF7CB, 0xF800, 
	0xF807, 0xF9CA, 0xFB94, 0xFC65, 0xFBA8, 0xFA09, 0xF86A, 0xF7AE, 0x0C6B, 
	0x0C58, 0x0BD5, 0x0A70, 0x07B9, 0x06F2, 0x068C, 0x0667, 0x0661, 0x0626, 
	0x05CA, 0x0553, 0x04CC, 0x044C, 0x03EB, 0x03C6, 0xE240, 0xE199, 0xDD0F, 
	0xD0BB, 0xB8BA, 0xB7B3, 0xB72B, 0xB6F9, 0xB6F2, 0xB55D, 0xB326, 0xB0C8, 
	0xAEAF, 0xAD09, 0xABF5, 0xAB92, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xBF5E, 0x1CEF, 0x1C77, 0x192D, 0x1040, 0xFEDC, 0xFE8C, 0xFE62, 0xFE53, 
	0xFE51, 0xFD49, 0xFBCC, 0xFB0A, 0xFC16, 0xFE64, 0x00B3, 0x01C0, 0x0F07, 
	0x0F2B, 0x102B, 0x12E1, 0x1828, 0x1059, 0x0C56, 0x0ADB, 0x0AA5, 0x0AD1, 
	0x0B64, 0x0C74, 0x0E02, 0x0FAF, 0x1106, 0x1192, 0xB4A6, 0xB455, 0xB21E, 
	0xAC19, 0xA061, 0x8FB0, 0x871D, 0x83F5, 0x8381, 0x7C93, 0x7737, 0x7511, 
	0x776D, 0x7C9E, 0x81CF, 0x842B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0060, 0x0112, 0x0172, 0x0138, 0x00B9, 0x003A, 0x0000, 0x0EFC, 
	0x1006, 0x1751, 0x2B1C, 0x51A6, 0x4540, 0x3EE2, 0x3C8A, 0x3C34, 0x44EC, 
	0x551F, 0x5DD7, 0x5AC3, 0x53FC, 0x4D35, 0x4A21, 0xF94E, 0xF960, 0xF9DB, 
	0xFB2C, 0xFDBB, 0x011F, 0x02DD, 0x0381, 0x0398, 0x0257, 0x0003, 0xFEC0, 
	0x007C, 0x044A, 0x0818, 0x09D3, 0x0000, 0xFFE6, 0xFF35, 0xFD57, 0xF9B2, 
	0xF9E6, 0xFA00, 0xFA0A, 0xFA0B, 0xFAA6, 0xFBAB, 0xFCB8, 0xFD78, 0xFDEC, 
	0xFE24, 0xFE32, 0xF22C, 0xF164, 0xEBF0, 0xDD21, 0xC04C, 0xBEA3, 0xBDCA, 
	0xBD79, 0xBD6E, 0xBAA2, 0xB6D3, 0xB2F3, 0xAFCF, 0xAD90, 0xAC36, 0xABC3, 
	

},{ 
	0x0001, 0x0000, 0x0010, 0x0001, 0x0010, 0x0011, 0x0001, 0x0021, 0x0001, 
	0x0022, 0x0001, 0x0023, 0x000C, 0x0024, 0x0010, 0x0030, 0x0010, 0x0040, 
	0x0003, 0x0050, 0x0008, 0x0053, 0x0010, 0x005B, 0x0004, 0x006B, 0x0004, 
	0x006F, 0x0010, 0x0073, 0x0001, 0x0083, 0x0001, 0x0084, 0x0001, 0x0085, 
	0x0010, 0x0086, 0x0010, 0x0096, 0x0010, 0x00A6, 0x0008, 0x00B6, 0x000F, 
	0x00BE, 0x0010, 0x00CD, 0x0010, 0x00DD, 0x0010, 0x00ED, 0x0010, 0x00FD, 
	0x0001, 0x010D, 0x0001, 0x010E, 0x0001, 0x010F, 0x0010, 0x0110, 0x0010, 
	0x0120, 0x0010, 0x0130, 0x000C, 0x0140, 0x000B, 0x014C, 0x0010, 0x0157, 
	0x0010, 0x0167, 0x0010, 0x0177, 0x0010, 0x0187, 0x000F, 0x0197, 0x0010, 
	0x01A6, 0x0001, 0x01B6, 0x0010, 0x01B7, 0x0010, 0x01C7, 0x0010, 0x01D7, 
	0x000D, 0x01E7, 0x0010, 0x01F4, 0x0010, 0x0204, 0x0010, 0x0214, 0x0010, 
	0x0224, 0x0010, 0x0234, 0x0010, 0x0244, 0x0010, 0x0254, 0x0001, 0x0264, 
	0x0010, 0x0265, 0x0010, 0x0275, 0x0010, 0x0285, 0x000F, 0x0295, 0x0010, 
	0x02A4, 0x0010, 0x02B4, 0x0010, 0x02C4, 0x0010, 0x02D4, 0x0010, 0x02E4, 
	

});

smlua_anim_util_register_animation('donkey_36_put_cap_on',1, 0, 0, 0, 46, { 
	0x0000, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0xFFFE, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x5675, 
	0x5712, 0x58EB, 0x5AC3, 0x5B60, 0x5B3D, 0x5AD4, 0x5A25, 0x5930, 0x57F6, 
	0x5675, 0x0826, 0x0CB3, 0x1546, 0x1D36, 0x20B4, 0x204B, 0x1D6E, 0x1612, 
	0x0C43, 0x03AE, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x001D, 0x0069, 0x00D5, 0x0151, 0x01CD, 0x0239, 0x0285, 0x02A2, 0x0151, 
	0xFFFF, 0x0000, 0xEA6A, 0xEEF7, 0xF8FB, 0x0300, 0x078D, 0x070A, 0x05B4, 
	0x03E5, 0x0209, 0x0096, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0005, 0x0012, 0x0024, 0x0038, 0x004D, 0x005F, 0x006C, 0x0071, 
	0x0038, 0x0000, 0x0FCD, 0x0FA5, 0x0F4C, 0x0EF3, 0x0ECA, 0x0FBE, 0x10B1, 
	0x0F8A, 0x0CF0, 0x0A2B, 0x0883, 0x080A, 0x07DE, 0x07D7, 0x07D1, 0x07A4, 
	0x072B, 0x063C, 0x04E1, 0x0346, 0x0196, 0xFFFA, 0xFEA0, 0xFDB1, 0xFD57, 
	0x0094, 0x03CF, 0x03CE, 0x03CA, 0x03C5, 0x03BE, 0x03B7, 0x03B0, 0x03A9, 
	0x03A4, 0x03A0, 0x039F, 0xD423, 0xD6BA, 0xDD2F, 0xE58B, 0xEDD5, 0xF474, 
	0xF94B, 0xFC9D, 0xFEAA, 0xFFB5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFE5F, 0xFE59, 
	0xFE4C, 0xFE3F, 0xFE39, 0xFE5A, 0xFEAE, 0xFF1C, 0xFF89, 0xFFDD, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000C, 0x0030, 0x006D, 
	0x00C2, 0x012F, 0x01B4, 0x0252, 0x0308, 0x03D6, 0x0367, 0x02F8, 0x02F5, 
	0x02EC, 0x02DD, 0x02C8, 0x02AE, 0x028D, 0x0266, 0x023A, 0x0216, 0x01AB, 
	0x00F9, 0x0000, 0xF23F, 0xF1B2, 0xF077, 0xEF33, 0xEE88, 0xEE66, 0xEE50, 
	0xEE42, 0xEE3B, 0xEE38, 0xEE38, 0xEE9A, 0xEFBE, 0xF1A6, 0xF38E, 0xF4B3, 
	0xF515, 0xF491, 0xF303, 0xF06E, 0xECCF, 0xE827, 0xE277, 0xDBBE, 0xD3FD, 
	0xCB32, 0xCACE, 0xCA6B, 0xCA7E, 0xCABA, 0xCB1D, 0xCBA8, 0xCC5A, 0xCD34, 
	0xCE35, 0xCF5E, 0xD0C6, 0xD4FD, 0xDC03, 0xE5D8, 0xE683, 0xE883, 0xE868, 
	0xE816, 0xE78D, 0xE6CE, 0xE5D8, 0x0001, 0xFFFE, 0xC170, 0xF932, 0xFD87, 
	0x094D, 0x1AAD, 0xAFD5, 0xC6EE, 0xDE24, 0xF3A2, 0x0593, 0x1221, 0x1777, 
	0x1786, 0x17B2, 0x17FC, 0x1862, 0x18E7, 0x1988, 0x1A40, 0x1AE2, 0x1B66, 
	0x1BCD, 0x1C16, 0x1C42, 0x1C51, 0x1C3C, 0x1BFF, 0x1B98, 0x1B09, 0x1A50, 
	0x1978, 0x18C0, 0x1830, 0x17C9, 0x178C, 0x1777, 0xC692, 0xC5BA, 0xC36B, 
	0xBFF8, 0xC449, 0xC906, 0xCDEB, 0xD2A2, 0xD6D9, 0xDA39, 0xDC71, 0xDC85, 
	0xDCC1, 0xDD25, 0xDDB1, 0xDE66, 0xDF42, 0xE03D, 0xE119, 0xE1CD, 0xE259, 
	0xE2BE, 0xE2FA, 0xE30E, 0xE2F2, 0xE29E, 0xE212, 0xE14E, 0xE052, 0xDF2C, 
	0xDE31, 0xDD6D, 0xDCE1, 0xDC8D, 0xDC71, 0xDD75, 0xD8FE, 0xCCDE, 0xBB00, 
	0x2545, 0x0D9B, 0xF5E7, 0xE014, 0xCE07, 0xC1A9, 0xBCE3, 0xBCDE, 0xBCD1, 
	0xBCBA, 0xBC9A, 0xBC72, 0xBC40, 0xBC07, 0xBBD5, 0xBBAD, 0xBB8D, 0xBB76, 
	0xBB69, 0xBB64, 0xBB6A, 0xBB7D, 0xBB9D, 0xBBC9, 0xBC02, 0xBC45, 0xBC7E, 
	0xBCAA, 0xBCCA, 0xBCDD, 0xBCE3, 0xFFCB, 0x0002, 0x0078, 0x00EE, 0x0123, 
	0x010E, 0x00D8, 0x0092, 0x004C, 0x0016, 0xFFFF, 0x0004, 0x000F, 0x0021, 
	0x003B, 0x005C, 0x0084, 0x00B2, 0x00DA, 0x00FB, 0x0115, 0x0127, 0x0132, 
	0x0136, 0x0131, 0x0122, 0x0108, 0x00E4, 0x00B6, 0x0080, 0x0052, 0x002E, 
	0x0015, 0x0005, 0xFFFF, 0x026A, 0x0269, 0x0261, 0x024C, 0x0223, 0x01D6, 
	0x0167, 0x00EA, 0x0076, 0x0021, 0x0000, 0x000A, 0x002A, 0x005D, 0x00A6, 
	0x0104, 0x0176, 0x01F7, 0x026A, 0x02C7, 0x0310, 0x0344, 0x0363, 0x036D, 
	0x035F, 0x0333, 0x02EB, 0x0285, 0x0203, 0x016A, 0x00E8, 0x0082, 0x003A, 
	0x000E, 0x0000, 0xCB72, 0xCF18, 0xD720, 0xDF27, 0xE2CE, 0xE12C, 0xDD19, 
	0xD7CD, 0xD281, 0xCE6D, 0xCCCC, 0xCCDE, 0xCD14, 0xCD6F, 0xCDED, 0xCE8F, 
	0xCF56, 0xD038, 0xD0FE, 0xD1A1, 0xD21F, 0xD27A, 0xD2B0, 0xD2C2, 0xD2A9, 
	0xD25D, 0xD1DF, 0xD12E, 0xD04B, 0xCF43, 0xCE60, 0xCDAF, 0xCD31, 0xCCE5, 
	0xCCCC, 0xFC10, 0xFC10, 0xFC10, 0xFC10, 0xFC10, 0xFC10, 0xFC10, 0xFC10, 
	0xFC10, 0xFC10, 0xFC10, 0xFC12, 0xFC17, 0xFC22, 0xFC33, 0xFC4B, 0xFC6D, 
	0xFC99, 0xFCD0, 0xFD14, 0xFD66, 0xFDC7, 0xFE39, 0xFEBC, 0xFF52, 0xFFF4, 
	0x009F, 0x014A, 0x01F2, 0x028F, 0x031D, 0x0396, 0x03F3, 0x042F, 0x0444, 
	0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 0xFFD2, 
	0xFFD2, 0xFFD2, 0xFFE4, 0x0016, 0x0062, 0x00C2, 0x0130, 0x01A7, 0x0221, 
	0x0299, 0x0307, 0x0367, 0x03B3, 0x03E4, 0x03F6, 0x03EF, 0x03DD, 0x03C2, 
	0x03A0, 0x037B, 0x0354, 0x032E, 0x030C, 0x02F1, 0x02DF, 0x02D8, 0x0B6E, 
	0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 0x0B6E, 
	0x0B6E, 0x0B62, 0x0B41, 0x0B0E, 0x0ACE, 0x0A85, 0x0A35, 0x09E4, 0x0994, 
	0x094B, 0x090A, 0x08D8, 0x08B7, 0x08AB, 0x08B3, 0x08C8, 0x08E7, 0x090E, 
	0x0939, 0x0966, 0x0992, 0x09B8, 0x09D8, 0x09ED, 0x09F5, 0x0001, 0xFFFE, 
	0xC170, 0x2947, 0x3B26, 0x62DC, 0x0B88, 0x204C, 0x2226, 0x224B, 0x2426, 
	0x32AD, 0x4F4A, 0xEF11, 0x0926, 0x1CDD, 0x2B9C, 0x36C8, 0x3FC3, 0x47F3, 
	0x4FB7, 0x535A, 0x5356, 0x533D, 0x52F7, 0x5270, 0x5191, 0x5044, 0x4E73, 
	0x17B7, 0x6206, 0x62B5, 0x6497, 0x6770, 0xEB01, 0xEF0E, 0xF359, 0xF7A3, 
	0xFBB0, 0xFF42, 0x021B, 0x03FE, 0x04AC, 0x01AA, 0xF91E, 0xEBC3, 0xDADC, 
	0xC9DA, 0x3CBA, 0x3777, 0x1E56, 0x1D42, 0x1A8C, 0x6902, 0x6CA1, 0x6F9D, 
	0x7199, 0x7252, 0x6B57, 0x5E5E, 0x289D, 0x2864, 0x27D4, 0x2719, 0x265F, 
	0x25CF, 0x2595, 0x28B3, 0x2C5D, 0x2D2C, 0x2D89, 0x2DA2, 0x2DA4, 0x2DBC, 
	0x2E1A, 0x2EE9, 0x317E, 0x4C78, 0x4CC7, 0x4DA3, 0x4EF0, 0x2F6F, 0x2D95, 
	0x2BA0, 0x29AB, 0x27D2, 0x2631, 0x24E4, 0x2408, 0x23B8, 0x264D, 0x2B17, 
	0x2DAC, 0x2D43, 0x2C5B, 0x548C, 0x54F5, 0xEDA8, 0x00AC, 0x2A7F, 0xD452, 
	0xE755, 0xE5FD, 0xE37E, 0xE225, 0xF089, 0x0F2C, 0xAB42, 0xBC1E, 0xC6B8, 
	0xCCC2, 0xCFEA, 0xD1E3, 0xD45B, 0xD829, 0xDAB7, 0xDB64, 0xDBE0, 0xDC33, 
	0xDC66, 0xDC7F, 0xDC89, 0xDC8A, 0xB161, 0x0638, 0x0682, 0x075B, 0x08B7, 
	0x8A8C, 0x8CD1, 0x8F7C, 0x9281, 0x95D7, 0x9974, 0x9D4D, 0xA159, 0xA58C, 
	0xA9B4, 0xACF3, 0xAE42, 0xAAB2, 0xA2DC, 0x1B07, 0x1777, 0xFFFF, 0x0001, 
	0x0004, 0x0007, 0x0009, 0x000D, 0x002B, 0x00E6, 0x024A, 0x03C0, 0x04B1, 
	0x051E, 0x056F, 0x05AA, 0x05D0, 0x05E8, 0x05F4, 0x05FA, 0x05FC, 0x05FE, 
	0x0604, 0x060F, 0x0622, 0x0640, 0x0669, 0x06A2, 0x06EB, 0x0747, 0x07AE, 
	0x081A, 0x0883, 0x08E1, 0x092E, 0x0962, 0x0975, 0x0848, 0x0550, 0x015E, 
	0xFD43, 0xF9D3, 0xF7AD, 0xF6A6, 0xF663, 0xF7E3, 0xFB31, 0xFE7F, 0xFFFF, 
	0x0000, 0x0002, 0x0005, 0x0009, 0x000A, 0x0007, 0x0005, 0x0027, 0x0072, 
	0x00BE, 0x00E0, 0x00D0, 0x009F, 0x0046, 0xFFC1, 0xFF0B, 0xFE1F, 0xFCF8, 
	0xFB91, 0xF9EA, 0xF81C, 0xF644, 0xF47F, 0xF2EC, 0xF1A7, 0xF0CE, 0xF07F, 
	0xF08E, 0xF0B6, 0xF0ED, 0xF12D, 0xF16D, 0xF1A5, 0xF1CC, 0xF1DB, 0xEF36, 
	0xE8E6, 0xE15E, 0xDB0F, 0xD86A, 0xDC10, 0xE491, 0xEE47, 0xF629, 0xFBAF, 
	0xFEEF, 0xFFFF, 0xEF31, 0xEB25, 0xE23D, 0xD955, 0xD548, 0xDF18, 0xE8E8, 
	0xE4E9, 0xDB2E, 0xCF16, 0xC401, 0xBBC1, 0xB5AB, 0xB165, 0xAE93, 0xACDC, 
	0xABE5, 0xAB54, 0xAACE, 0xAA09, 0xA901, 0xA7C3, 0xA65D, 0xA4D9, 0xA346, 
	0xA1B1, 0xA025, 0x9EAE, 0x9D55, 0x9C20, 0x9B14, 0x9A39, 0x9994, 0x992D, 
	0x9909, 0x9B02, 0xA078, 0xA8B9, 0xB313, 0xBED5, 0xCAE3, 0xD476, 0xD85D, 
	0xD655, 0xD1DE, 0xCD67, 0xCB60, 0x130F, 0x12AD, 0x11D5, 0x10FD, 0x109A, 
	0x11C4, 0x14AA, 0x1870, 0x1C35, 0x1F1C, 0x2045, 0x202D, 0x1FE9, 0x1F7B, 
	0x1EE5, 0x1E2A, 0x1D4E, 0x1C52, 0x1B39, 0x1A07, 0x18BE, 0x1760, 0x15F1, 
	0x1473, 0x12E9, 0x1155, 0x0FBA, 0x0E1C, 0x0C7C, 0x0ADE, 0x0943, 0x07B0, 
	0x0626, 0x04A9, 0x033B, 0x01DE, 0x0097, 0xFF65, 0xFE4E, 0xFD54, 0xFC7A, 
	0xFBC1, 0xFB2E, 0xFAC1, 0xFA78, 0xFA4E, 0xFA42, 0x0CF7, 0x0D72, 0x0E82, 
	0x0F92, 0x100D, 0x0F1D, 0x0CC2, 0x09AB, 0x068B, 0x0411, 0x02EE, 0x02B3, 
	0x027C, 0x0248, 0x0218, 0x01EB, 0x01C1, 0x019B, 0x0177, 0x0156, 0x0138, 
	0x011D, 0x0104, 0x00ED, 0x00D9, 0x00C7, 0x00B6, 0x00A8, 0x009C, 0x0091, 
	0x0088, 0x0080, 0x0079, 0x0074, 0x0070, 0x006C, 0x006A, 0x0068, 0x0067, 
	0x0066, 0x0066, 0x0065, 0x0065, 0x0095, 0x00FE, 0x0167, 0x0197, 0xE4D1, 
	0xE3B8, 0xE14E, 0xDEE4, 0xDDCC, 0xE0A6, 0xE7CA, 0xF111, 0xFA58, 0x017D, 
	0x0457, 0x0451, 0x043E, 0x041F, 0x03F5, 0x03C1, 0x0384, 0x033F, 0x02F2, 
	0x029E, 0x0245, 0x01E6, 0x0183, 0x011D, 0x00B5, 0x004A, 0xFFDE, 0xFF73, 
	0xFF09, 0xFEA0, 0xFE3A, 0xFDD7, 0xFD79, 0xFD1F, 0xFCCB, 0xFC7E, 0xFC39, 
	0xFBFC, 0xFBC8, 0xFB9E, 0xFB7F, 0xFB6C, 0xFB66, 0xFD01, 0x008C, 0x0415, 
	0x05B0, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE95, 0xFE85, 
	0xFE69, 0xFE42, 0xFE10, 0xFDD3, 0xFD8A, 0xFD37, 0xFCDB, 0xFC87, 0xFC3F, 
	0xFC02, 0xFBD0, 0xFBA9, 0xFB8D, 0xFB7C, 0xFB76, 0xFB79, 0xFB7F, 0xFB8B, 
	0xFB9A, 0xFBAE, 0xFBC7, 0xFBE4, 0xFC05, 0xFC2B, 0xFC55, 0xFC84, 0xFCB7, 
	0xFCEF, 0xFD2B, 0xFD6C, 0xFDB1, 0xFDFB, 0xFE49, 0xFE9B, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF2, 0xEFDE, 0xEFBC, 0xEF8D, 0xEF50, 0xEF06, 0xEEAE, 0xEE49, 0xEDD9, 
	0xED74, 0xED1C, 0xECD2, 0xEC95, 0xEC66, 0xEC44, 0xEC2F, 0xEC29, 0xEC2B, 
	0xEC34, 0xEC41, 0xEC54, 0xEC6C, 0xEC8A, 0xECAD, 0xECD6, 0xED04, 0xED37, 
	0xED70, 0xEDAE, 0xEDF2, 0xEE3B, 0xEE89, 0xEEDD, 0xEF36, 0xEF95, 0xEFF9, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x83A1, 0x83A8, 0x83B4, 0x83C4, 0x83DA, 0x83F4, 0x8413, 
	0x8436, 0x845D, 0x8481, 0x84A0, 0x84BA, 0x84CF, 0x84E0, 0x84EC, 0x84F3, 
	0x84F5, 0x84F4, 0x84F2, 0x84ED, 0x84E6, 0x84DE, 0x84D3, 0x84C7, 0x84B9, 
	0x84A8, 0x8496, 0x8482, 0x846D, 0x8455, 0x843B, 0x8420, 0x8402, 0x83E3, 
	0x83C1, 0x839E, 0x0000, 0xFFFF, 0x49EE, 0xF792, 0xF755, 0xF69F, 0xF5E9, 
	0xF5AC, 0xF5BA, 0xF5E2, 0xF626, 0xF684, 0xF6FE, 0xF792, 0xF790, 0xF78B, 
	0xF783, 0xF777, 0xF768, 0xF755, 0xF73F, 0xF726, 0xF709, 0xF6E9, 0xF6C5, 
	0xF69E, 0xF675, 0xF64E, 0xF62A, 0xF60A, 0xF5ED, 0xF5D4, 0xF5BE, 0xF5AB, 
	0xF59C, 0xF590, 0xF587, 0xF582, 0xF581, 0xF585, 0xF592, 0xF5A8, 0xF5C7, 
	0xF5EE, 0xF61E, 0xF657, 0xF699, 0xF6E3, 0xF736, 0xF792, 0x03C6, 0x03B7, 
	0x038C, 0x0360, 0x0352, 0x0355, 0x035F, 0x036F, 0x0385, 0x03A2, 0x03C6, 
	0x03C1, 0x03B3, 0x039B, 0x0379, 0x034E, 0x031A, 0x02DB, 0x0294, 0x0242, 
	0x01E7, 0x0183, 0x0115, 0x00A0, 0x0032, 0xFFCC, 0xFF71, 0xFF20, 0xFED8, 
	0xFE9A, 0xFE65, 0xFE3A, 0xFE19, 0xFE01, 0xFDF3, 0xFDEE, 0xFDFA, 0xFE1F, 
	0xFE5D, 0xFEB4, 0xFF23, 0xFFAB, 0x004C, 0x0106, 0x01D8, 0x02C2, 0x03C6, 
	0xAB92, 0xAAF8, 0xA928, 0xA758, 0xA6BD, 0xA6DF, 0xA746, 0xA7F2, 0xA8E3, 
	0xAA18, 0xAB92, 0xAB93, 0xAB96, 0xAB9B, 0xABA2, 0xABAB, 0xABB6, 0xABC2, 
	0xABD1, 0xABE2, 0xABF4, 0xAC09, 0xAC20, 0xAC38, 0xAC4E, 0xAC63, 0xAC76, 
	0xAC86, 0xAC95, 0xACA2, 0xACAD, 0xACB5, 0xACBC, 0xACC1, 0xACC4, 0xACC5, 
	0xACC3, 0xACBB, 0xACAE, 0xAC9D, 0xAC86, 0xAC6A, 0xAC49, 0xAC23, 0xABF8, 
	0xABC8, 0xAB92, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x00DC, 0x0255, 0x05D8, 
	0x0A09, 0x0D8C, 0x0F05, 0x0EBE, 0x0DF8, 0x0CCF, 0x0B59, 0x09B1, 0x07F0, 
	0x062F, 0x0488, 0x0312, 0x01E8, 0x0123, 0x00DC, 0x00F9, 0x0148, 0x01BC, 
	0x0249, 0x02E3, 0x037C, 0x0409, 0x047D, 0x04CC, 0x04E9, 0x04E3, 0x04D0, 
	0x04B3, 0x048D, 0x045F, 0x042A, 0x03F1, 0x03B4, 0x0374, 0x0335, 0x02F5, 
	0x02B8, 0x027F, 0x024A, 0x021C, 0x01F6, 0x01D9, 0x01C6, 0x01C0, 0x11D1, 
	0x1118, 0x0F5E, 0x0D4F, 0x0B96, 0x0ADD, 0x0AF7, 0x0B3F, 0x0BAF, 0x0C3F, 
	0x0CE7, 0x0DA2, 0x0E66, 0x0F2D, 0x0FEF, 0x10A5, 0x1148, 0x11D1, 0x123E, 
	0x1295, 0x12D9, 0x130D, 0x1331, 0x134A, 0x1359, 0x1360, 0x1363, 0x1364, 
	0x1360, 0x1355, 0x1344, 0x132E, 0x1314, 0x12F6, 0x12D5, 0x12B2, 0x128D, 
	0x1269, 0x1244, 0x1221, 0x1200, 0x11E2, 0x11C8, 0x11B1, 0x11A1, 0x1196, 
	0x1192, 0x83C1, 0x8D69, 0xA470, 0xBFEC, 0xD6F4, 0xE09C, 0xDEC8, 0xD9BB, 
	0xD21A, 0xC889, 0xBDAE, 0xB22E, 0xA6AF, 0x9BD4, 0x9243, 0x8AA2, 0x8595, 
	0x83C1, 0x83E7, 0x844D, 0x84E4, 0x859B, 0x8663, 0x872A, 0x87E1, 0x8878, 
	0x88DE, 0x8904, 0x88FA, 0x88DF, 0x88B3, 0x8879, 0x8834, 0x87E5, 0x878E, 
	0x8733, 0x86D4, 0x8674, 0x8615, 0x85B9, 0x8563, 0x8514, 0x84CF, 0x8495, 
	0x8469, 0x844E, 0x8444, 0xFF64, 0xFF76, 0xFFA6, 0xFFE7, 0x002F, 0x0071, 
	0x00A0, 0x00B3, 0x00AA, 0x0090, 0x006B, 0x003D, 0x000C, 0xFFD9, 0xFFAC, 
	0xFF87, 0xFF6D, 0xFF64, 0xFF64, 0xFF66, 0xFF68, 0xFF6C, 0xFF70, 0xFF75, 
	0xFF7B, 0xFF81, 0xFF87, 0xFF8E, 0xFF96, 0xFF9E, 0xFFA5, 0xFFAD, 0xFFB5, 
	0xFFBD, 0xFFC5, 0xFFCD, 0xFFD4, 0xFFDB, 0xFFE2, 0xFFE8, 0xFFEE, 0xFFF3, 
	0xFFF7, 0xFFFA, 0xFFFD, 0xFFFE, 0xFFFF, 0xFE85, 0xFE85, 0xFE87, 0xFE89, 
	0xFE8B, 0xFE8D, 0xFE8F, 0xFE8F, 0xFE8F, 0xFE8E, 0xFE8D, 0xFE8C, 0xFE8A, 
	0xFE89, 0xFE87, 0xFE86, 0xFE85, 0xFE85, 0xFE86, 0xFE8A, 0xFE90, 0xFE98, 
	0xFEA3, 0xFEAF, 0xFEBC, 0xFECB, 0xFEDB, 0xFEED, 0xFEFF, 0xFF11, 0xFF25, 
	0xFF38, 0xFF4C, 0xFF5F, 0xFF72, 0xFF85, 0xFF97, 0xFFA8, 0xFFB9, 0xFFC8, 
	0xFFD5, 0xFFE1, 0xFFEB, 0xFFF4, 0xFFFA, 0xFFFE, 0x0000, 0x497F, 0x4798, 
	0x42B0, 0x3BFB, 0x34AC, 0x2DF7, 0x290F, 0x2728, 0x281D, 0x2AB5, 0x2E89, 
	0x332F, 0x383F, 0x3D50, 0x41FB, 0x45D7, 0x487B, 0x497F, 0x498F, 0x499E, 
	0x49AC, 0x49B9, 0x49C5, 0x49D0, 0x49DA, 0x49E3, 0x49EC, 0x49F3, 0x49FA, 
	0x4A00, 0x4A06, 0x4A0A, 0x4A0F, 0x4A12, 0x4A15, 0x4A18, 0x4A1A, 0x4A1C, 
	0x4A1D, 0x4A1F, 0x4A1F, 0x4A20, 0x4A20, 0x4A21, 0x08E7, 0x08C4, 0x0868, 
	0x07EB, 0x0762, 0x06E5, 0x0689, 0x0666, 0x07A0, 0x09E8, 0x0B23, 0x0B03, 
	0x0AB1, 0x0A42, 0x09C8, 0x0959, 0x0907, 0x08E7, 0x090B, 0x096C, 0x09FC, 
	0x0AAA, 0x0B67, 0x0C24, 0x0CD2, 0x0D61, 0x0DC2, 0x0DE6, 0x0DDE, 0x0DC6, 
	0x0DA0, 0x0D6F, 0x0D33, 0x0CF0, 0x0CA6, 0x0C57, 0x0C06, 0x0BB3, 0x0B62, 
	0x0B13, 0x0AC9, 0x0A85, 0x0A4A, 0x0A18, 0x09F3, 0x09DB, 0x09D3, 0xFFBD, 
	0xFF68, 0xFE8E, 0xFD64, 0xFC1F, 0xFAF4, 0xFA1A, 0xF9C6, 0xFB04, 0xFD66, 
	0xFEE2, 0xFF28, 0xFF47, 0xFF4F, 0xFF50, 0xFF58, 0xFF77, 0xFFBD, 0x0036, 
	0x00DB, 0x019F, 0x0275, 0x034E, 0x041F, 0x04D8, 0x056D, 0x05D1, 0x05F5, 
	0x05E6, 0x05BB, 0x0577, 0x051D, 0x04B1, 0x0437, 0x03B1, 0x0322, 0x028F, 
	0x01FA, 0x0167, 0x00D8, 0x0052, 0xFFD7, 0xFF6B, 0xFF11, 0xFECD, 0xFEA2, 
	0xFE93, 0xB06F, 0xB219, 0xB663, 0xBC41, 0xC2A5, 0xC882, 0xCCCD, 0xCE77, 
	0xC249, 0xABAB, 0x9F7E, 0xA06E, 0xA2DA, 0xA629, 0xA9C4, 0xAD13, 0xAF7F, 
	0xB06F, 0xB036, 0xAF9A, 0xAEB5, 0xAD9F, 0xAC71, 0xAB42, 0xAA2C, 0xA947, 
	0xA8AC, 0xA873, 0xA87A, 0xA88F, 0xA8B1, 0xA8DD, 0xA912, 0xA94F, 0xA991, 
	0xA9D7, 0xAA20, 0xAA69, 0xAAB2, 0xAAF8, 0xAB3A, 0xAB77, 0xABAC, 0xABD8, 
	0xABF9, 0xAC0F, 0xAC16, 

},{ 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
	0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x000A, 0x0007, 0x000B, 0x0011, 
	0x001C, 0x001C, 0x001B, 0x0038, 0x0025, 0x0053, 0x0028, 0x0078, 0x0028, 
	0x00A0, 0x002F, 0x00C8, 0x0001, 0x00F7, 0x0001, 0x00F8, 0x0001, 0x00F9, 
	0x0023, 0x00FA, 0x0023, 0x011D, 0x0023, 0x0140, 0x0023, 0x0163, 0x0023, 
	0x0186, 0x0023, 0x01A9, 0x0023, 0x01CC, 0x0023, 0x01EF, 0x0023, 0x0212, 
	0x0001, 0x0235, 0x0001, 0x0236, 0x0001, 0x0237, 0x002F, 0x0238, 0x002F, 
	0x0267, 0x002F, 0x0296, 0x002F, 0x02C5, 0x002F, 0x02F4, 0x002F, 0x0323, 
	0x002F, 0x0352, 0x002F, 0x0381, 0x002F, 0x03B0, 0x000B, 0x03DF, 0x0001, 
	0x03EA, 0x0001, 0x03EB, 0x002F, 0x03EC, 0x002F, 0x041B, 0x002F, 0x044A, 
	0x0001, 0x0479, 0x0001, 0x047A, 0x0001, 0x047B, 0x002F, 0x047C, 0x002F, 
	0x04AB, 0x002F, 0x04DA, 0x000B, 0x0509, 0x0001, 0x0514, 0x0001, 0x0515, 
	0x002F, 0x0516, 0x002F, 0x0545, 0x002F, 0x0574, 0x002F, 0x05A3, 0x002F, 
	0x05D2, 0x002C, 0x0601, 0x002F, 0x062D, 0x002F, 0x065C, 0x002F, 0x068B, 
	

});

smlua_anim_util_register_animation('donkey_37_take_cap_off_then_on',1, 0, 0, 0, 100, { 
	0x0000, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0x5675, 
	0x0000, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF99, 
	0xFF99, 0xFF99, 0xFF99, 0xFF99, 0xFFA6, 0x0005, 0x00FA, 0x0270, 0x03FD, 
	0x0539, 0x05B9, 0x05B0, 0x0596, 0x056D, 0x0536, 0x04F4, 0x04A8, 0x0453, 
	0x03F7, 0x0397, 0x0333, 0x02CD, 0x0267, 0x0203, 0x01A2, 0x0146, 0x00F1, 
	0x00A4, 0x0061, 0x002A, 0x0000, 0xFFDF, 0xFFC3, 0xFFAB, 0xFF98, 0xFF88, 
	0xFF7B, 0xFF72, 0xFF6B, 0xFF67, 0xFF65, 0xFF65, 0xFF67, 0xFF6B, 0xFF6F, 
	0xFF74, 0xFF7A, 0xFF80, 0xFF86, 0xFF8C, 0xFF49, 0xFF56, 0xFF78, 0xFFA4, 
	0xFFD0, 0xFFF2, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x001D, 0x0069, 0x00D5, 0x0151, 0x01CD, 0x0239, 0x0285, 0x02A2, 0x0151, 
	0xFFFF, 0x0000, 0x0000, 0xFF70, 0xFF71, 0xFF7A, 0xFF94, 0xFFC6, 0x0019, 
	0x0093, 0x013D, 0x0220, 0x0344, 0x04B0, 0x066C, 0x08A6, 0x09C7, 0x0967, 
	0x07FE, 0x0622, 0x046D, 0x0376, 0x0316, 0x02BF, 0x026E, 0x0225, 0x01E3, 
	0x01A6, 0x0170, 0x013F, 0x0113, 0x00EC, 0x00C9, 0x00AA, 0x008D, 0x0074, 
	0x005D, 0x0048, 0x0035, 0x0022, 0x0011, 0xFFFF, 0xFFF0, 0xFFE3, 0xFFDA, 
	0xFFD4, 0xFFD0, 0xFFCF, 0xFFD0, 0xFFD3, 0xFFD7, 0xFFDE, 0xFFE5, 0xFFEE, 
	0xFFF8, 0x0002, 0x000D, 0x0019, 0x0024, 0x002F, 0x003A, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0005, 0x0012, 0x0024, 0x0038, 0x004D, 0x005F, 0x006C, 
	0x0071, 0x0038, 0x0000, 0x039F, 0x043E, 0x043E, 0x043D, 0x043B, 0x0439, 
	0x0437, 0x0434, 0x0432, 0x0430, 0x042E, 0x042D, 0x042D, 0x059E, 0x069D, 
	0x071D, 0x0762, 0x0780, 0x078B, 0x0797, 0x07AA, 0x07BD, 0x07CE, 0x07DE, 
	0x07EE, 0x07FD, 0x080B, 0x0818, 0x0825, 0x0831, 0x083C, 0x0846, 0x0850, 
	0x0859, 0x0862, 0x086A, 0x0871, 0x0878, 0x087E, 0x0884, 0x0889, 0x088D, 
	0x0890, 0x0893, 0x0895, 0x0897, 0x0898, 0x0898, 0x0899, 0x0898, 0x0898, 
	0x0897, 0x0896, 0x0895, 0x0893, 0x0892, 0x0890, 0x088F, 0x088D, 0x088C, 
	0x088B, 0x0889, 0x0888, 0x0886, 0x0884, 0x0883, 0x0881, 0x0875, 0x0857, 
	0x081D, 0x07BC, 0x072B, 0x063C, 0x04E1, 0x0346, 0x0196, 0xFFFA, 0xFEA0, 
	0xFDB1, 0xFD57, 0x0094, 0x03CF, 0x03CE, 0x03CA, 0x03C5, 0x03BE, 0x03B7, 
	0x03B0, 0x03A9, 0x03A4, 0x03A0, 0x039F, 0x0000, 0xFF2E, 0xFE95, 0xFCF0, 
	0xFA7C, 0xF773, 0xF412, 0xF092, 0xED30, 0xEA27, 0xE7B3, 0xE60E, 0xE575, 
	0xE68E, 0xEA92, 0xF064, 0xF724, 0xFDF1, 0x03EA, 0x082F, 0x0A52, 0x0AE1, 
	0x0A71, 0x0996, 0x08E6, 0x0878, 0x07FF, 0x077D, 0x06F3, 0x0661, 0x05CA, 
	0x052D, 0x048B, 0x03E7, 0x0340, 0x0298, 0x01F0, 0x0148, 0x00A2, 0x0000, 
	0xFF2E, 0xFE26, 0xFD29, 0xFC76, 0xFC4E, 0xFD01, 0xFE65, 0x0001, 0x015C, 
	0x01FF, 0x019D, 0x0086, 0xFF2D, 0xFE04, 0xFD7E, 0xFDBA, 0xFE6E, 0xFF6E, 
	0x0093, 0x016C, 0x0151, 0x010E, 0x00B6, 0x005E, 0x001B, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0058, 0x00E0, 0x0169, 0x01F0, 0x0273, 0x02EE, 0x035F, 
	0x03C2, 0x0414, 0x0452, 0x047A, 0x0488, 0x042B, 0x0375, 0x0285, 0x0173, 
	0x0058, 0xFF4F, 0xFE6F, 0xFDAA, 0xFCEE, 0xFC52, 0xFBEC, 0xFBD2, 0xFBEA, 
	0xFC0A, 0xFC30, 0xFC5E, 0xFC93, 0xFCCF, 0xFD12, 0xFD5B, 0xFDAA, 0xFDFF, 
	0xFE5B, 0xFEBC, 0xFF22, 0xFF8E, 0x0000, 0x00C8, 0x0200, 0x0350, 0x0462, 
	0x04DE, 0x047F, 0x037E, 0x0245, 0x013C, 0x00CC, 0x013A, 0x023E, 0x0374, 
	0x0475, 0x04DD, 0x04C5, 0x048C, 0x0437, 0x03CB, 0x0345, 0x0307, 0x026C, 
	0x01A3, 0x00D9, 0x003E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x000C, 0x0030, 0x006D, 0x00C2, 0x012F, 0x01B4, 0x0252, 0x0308, 
	0x03D6, 0x0367, 0x02F8, 0x02F5, 0x02EC, 0x02DD, 0x02C8, 0x02AE, 0x028D, 
	0x0266, 0x023A, 0x0216, 0x01AB, 0x00F9, 0x0000, 0xEE2F, 0xEBD8, 0xEC66, 
	0xEDED, 0xF034, 0xF306, 0xF62A, 0xF96A, 0xFC8F, 0xFF60, 0x01A9, 0x0330, 
	0x03BE, 0x021D, 0xFF21, 0xFB19, 0xF6AC, 0xF27C, 0xEF30, 0xED6D, 0xEE0F, 
	0xF0BF, 0xF453, 0xF7A1, 0xF97C, 0xFA2B, 0xFAB9, 0xFB2A, 0xFB82, 0xFBC3, 
	0xFBF1, 0xFC10, 0xFC23, 0xFC2C, 0xFC30, 0xFC31, 0xFC33, 0xFC3A, 0xFC48, 
	0xFC61, 0xFC6C, 0xFC57, 0xFC32, 0xFC0B, 0xFBF0, 0xFBE2, 0xFBD7, 0xFBCF, 
	0xFBC6, 0xFBBC, 0xFBAE, 0xFB9D, 0xFB8D, 0xFB81, 0xFB7C, 0xFB89, 0xFBA9, 
	0xFBD4, 0xFC03, 0xFC2F, 0xFB26, 0xF890, 0xF533, 0xF1D7, 0xEF41, 0xEE38, 
	0xEE9A, 0xEFBE, 0xF1A6, 0xF38E, 0xF4B3, 0xF515, 0xF491, 0xF303, 0xF06E, 
	0xECCF, 0xE827, 0xE277, 0xDBBE, 0xD3FD, 0xCB32, 0xCACE, 0xCA6B, 0xCA7E, 
	0xCABA, 0xCB1D, 0xCBA8, 0xCC5A, 0xCD34, 0xCE35, 0xCF5E, 0xD0C6, 0xD4FD, 
	0xDC03, 0xE5D8, 0xE683, 0xE883, 0xE859, 0xE7D9, 0xE703, 0xE5D8, 0x0001, 
	0xFFFE, 0xC170, 0x19C6, 0x1EE3, 0x1E2B, 0x1C30, 0x1932, 0x1572, 0x112F, 
	0x0CAC, 0x0827, 0x03E2, 0x001E, 0xFD19, 0xFB17, 0xFA02, 0xF8D2, 0xF791, 
	0xF649, 0xF503, 0xF3CA, 0xF2A7, 0xF1A4, 0xF0CC, 0xF027, 0xEFC0, 0xEFA0, 
	0xEFD2, 0xF060, 0xF17B, 0xF33D, 0xF58B, 0xF84B, 0xFB62, 0xFEB3, 0x0226, 
	0x059E, 0x0901, 0x0EAD, 0x15F1, 0x1C4B, 0x1F3A, 0x1F7F, 0x1F99, 0x1F9C, 
	0x1AA4, 0x1169, 0x0C71, 0x113A, 0x1A2F, 0x1F3A, 0x1F7F, 0x1F99, 0x1F9C, 
	0x1AA4, 0x1169, 0x0C71, 0x0C9B, 0x0DC4, 0x10EB, 0x170D, 0x212B, 0x3269, 
	0xCA65, 0xE4CD, 0xFD53, 0x0FA7, 0x1777, 0x1786, 0x17B2, 0x17FC, 0x1862, 
	0x18E7, 0x1988, 0x1A40, 0x1AE2, 0x1B66, 0x1BCD, 0x1C16, 0x1C42, 0x1C51, 
	0x1C3C, 0x1BFF, 0x1B98, 0x1B09, 0x1A50, 0x1978, 0x18C0, 0x1830, 0x17C9, 
	0x178C, 0x1777, 0xDC99, 0xDADD, 0xDE6D, 0xE13F, 0xE36B, 0xE50B, 0xE639, 
	0xE70D, 0xE7A1, 0xE80E, 0xE86E, 0xE8D9, 0xE969, 0xEA22, 0xEAC8, 0xEB5B, 
	0xEBDB, 0xEC48, 0xECA3, 0xECED, 0xED26, 0xED4F, 0xED68, 0xED72, 0xED6D, 
	0xED59, 0xED38, 0xECF5, 0xEC7E, 0xEBDC, 0xEB15, 0xEA31, 0xE935, 0xE829, 
	0xE713, 0xE5FC, 0xE6FE, 0xE969, 0xEC57, 0xEEE4, 0xF068, 0xF13D, 0xF1FC, 
	0xF30E, 0xF418, 0xF490, 0xF317, 0xF05C, 0xEEE4, 0xEF60, 0xF08D, 0xF1FC, 
	0xF348, 0xF435, 0xF490, 0xF430, 0xF2B0, 0xEF83, 0xEA19, 0xE1E4, 0xD6AF, 
	0xB64B, 0xC379, 0xCF47, 0xD820, 0xDC71, 0xDC85, 0xDCC1, 0xDD25, 0xDDB1, 
	0xDE66, 0xDF42, 0xE03D, 0xE119, 0xE1CD, 0xE259, 0xE2BE, 0xE2FA, 0xE30E, 
	0xE2F2, 0xE29E, 0xE212, 0xE14E, 0xE052, 0xDF2C, 0xDE31, 0xDD6D, 0xDCE1, 
	0xDC8D, 0xDC71, 0xBCE3, 0xB9AE, 0xBFF4, 0xC4FC, 0xC8EC, 0xCBEA, 0xCE1E, 
	0xCFAE, 0xD0C0, 0xD17B, 0xD207, 0xD288, 0xD326, 0xD3FA, 0xD4EB, 0xD5E9, 
	0xD6E9, 0xD7DB, 0xD8B2, 0xD95F, 0xD9D6, 0xDA08, 0xD9E7, 0xD966, 0xD876, 
	0xD709, 0xD512, 0xD240, 0xCE65, 0xC9AC, 0xC43D, 0xBE43, 0xB7E7, 0xB153, 
	0xAAAF, 0xA426, 0x9A89, 0x8EBF, 0x8304, 0x7995, 0x7414, 0x71C4, 0x714B, 
	0x76F1, 0x816F, 0x8715, 0x84CB, 0x7F81, 0x7995, 0x7503, 0x723B, 0x714B, 
	0x74B5, 0x7CF6, 0x8715, 0x9086, 0x987E, 0x9EA1, 0xA293, 0xA3F8, 0x9C62, 
	0x0967, 0xF0B0, 0xD7EB, 0xC4C3, 0xBCE3, 0xBCDE, 0xBCD1, 0xBCBA, 0xBC9A, 
	0xBC72, 0xBC40, 0xBC07, 0xBBD5, 0xBBAD, 0xBB8D, 0xBB76, 0xBB69, 0xBB64, 
	0xBB6A, 0xBB7D, 0xBB9D, 0xBBC9, 0xBC02, 0xBC45, 0xBC7E, 0xBCAA, 0xBCCA, 
	0xBCDD, 0xBCE3, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0004, 0x000F, 0x0021, 0x003B, 
	0x005C, 0x0084, 0x00B2, 0x00DA, 0x00FB, 0x0115, 0x0127, 0x0132, 0x0136, 
	0x0131, 0x0122, 0x0108, 0x00E4, 0x00B6, 0x0080, 0x0052, 0x002E, 0x0015, 
	0x0005, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x000A, 0x002A, 0x005D, 0x00A6, 
	0x0104, 0x0176, 0x01F7, 0x026A, 0x02C7, 0x0310, 0x0344, 0x0363, 0x036D, 
	0x035F, 0x0333, 0x02EB, 0x0285, 0x0203, 0x016A, 0x00E8, 0x0082, 0x003A, 
	0x000E, 0x0000, 0xCC9F, 0xCF31, 0xD0BE, 0xD1E5, 0xD2B7, 0xD347, 0xD3A6, 
	0xD3E5, 0xD417, 0xD44C, 0xD496, 0xD506, 0xD5AF, 0xD690, 0xD774, 0xD855, 
	0xD931, 0xDA03, 0xDAC7, 0xDB78, 0xDC14, 0xDC94, 0xDCF6, 0xDD35, 0xDD4E, 
	0xDD3B, 0xDCF9, 0xDC6B, 0xDB81, 0xDA48, 0xD8CE, 0xD720, 0xD54B, 0xD35C, 
	0xD161, 0xCF68, 0xCD7C, 0xCBAD, 0xCA07, 0xC897, 0xC771, 0xC698, 0xC5FE, 
	0xC597, 0xC554, 0xC550, 0xC593, 0xC5F7, 0xC657, 0xC68D, 0xC648, 0xC5A2, 
	0xC513, 0xC516, 0xC625, 0xC833, 0xCACB, 0xCDC5, 0xD0FA, 0xD444, 0xD3B7, 
	0xD254, 0xD088, 0xCEBC, 0xCD5A, 0xCCCC, 0xCCDE, 0xCD14, 0xCD6F, 0xCDED, 
	0xCE8F, 0xCF56, 0xD038, 0xD0FE, 0xD1A1, 0xD21F, 0xD27A, 0xD2B0, 0xD2C2, 
	0xD2A9, 0xD25D, 0xD1DF, 0xD12E, 0xD04B, 0xCF43, 0xCE60, 0xCDAF, 0xCD31, 
	0xCCE5, 0xCCCC, 0x04C7, 0xF7EE, 0xF8EB, 0xF9A3, 0xFA25, 0xFA7B, 0xFAB3, 
	0xFAD7, 0xFAF4, 0xFB17, 0xFB4A, 0xFB9B, 0xFC15, 0xFCBD, 0xFD81, 0xFE54, 
	0xFF2B, 0xFFF9, 0x00B2, 0x014C, 0x01B9, 0x01EE, 0x01E0, 0x0182, 0x00C9, 
	0xFFA8, 0xFE14, 0xFBC8, 0xF8A0, 0xF4C0, 0xF04A, 0xEB61, 0xE62A, 0xE0C8, 
	0xDB5D, 0xD60D, 0xD0FC, 0xCC4D, 0xC823, 0xC4A1, 0xC29A, 0xC258, 0xC335, 
	0xC48D, 0xC5BA, 0xC69A, 0xC77D, 0xC863, 0xC94B, 0xCA37, 0xCB26, 0xCC19, 
	0xCD10, 0xCE0C, 0xCF0D, 0xD013, 0xD120, 0xD232, 0xD34B, 0xD46B, 0xD901, 
	0xE0A5, 0xE9A7, 0xF259, 0xF90C, 0xFC10, 0xFC9B, 0xFD03, 0xFD4D, 0xFD80, 
	0xFDA1, 0xFDB6, 0xFDC3, 0xFDCF, 0xFDE0, 0xFDFA, 0xFE24, 0xFE63, 0xFEBC, 
	0xFF34, 0xFFC4, 0x0065, 0x0110, 0x01BC, 0x0263, 0x02FC, 0x0380, 0x03E8, 
	0x042C, 0x0444, 0x0306, 0xFFC0, 0xFF98, 0xFF28, 0xFE81, 0xFDB3, 0xFCCE, 
	0xFBE0, 0xFAFB, 0xFA2D, 0xF986, 0xF917, 0xF8EE, 0xF91C, 0xF950, 0xF988, 
	0xF9C1, 0xF9F6, 0xFA24, 0xFA49, 0xFA61, 0xFA69, 0xFA5D, 0xFA3A, 0xF9FD, 
	0xF9A3, 0xF928, 0xF879, 0xF78A, 0xF666, 0xF517, 0xF3A7, 0xF220, 0xF08D, 
	0xEEF6, 0xED67, 0xEBE9, 0xEA86, 0xE949, 0xE83C, 0xE79F, 0xE787, 0xE7BA, 
	0xE802, 0xE826, 0xE828, 0xE82E, 0xE838, 0xE845, 0xE855, 0xE865, 0xE877, 
	0xE888, 0xE898, 0xE8A7, 0xE8B2, 0xE8BB, 0xE8BF, 0xE8BF, 0xE8B8, 0xEA4C, 
	0xEE49, 0xF38E, 0xF8FB, 0xFD72, 0xFFD2, 0x00B5, 0x0174, 0x0214, 0x0297, 
	0x02FF, 0x0351, 0x038E, 0x03BA, 0x03D7, 0x03E9, 0x03F2, 0x03F6, 0x03F6, 
	0x03EF, 0x03DD, 0x03C2, 0x03A0, 0x037B, 0x0354, 0x032E, 0x030C, 0x02F1, 
	0x02DF, 0x02D8, 0x0A90, 0x09F5, 0x08FB, 0x064B, 0x0249, 0xFD53, 0xF7CC, 
	0xF215, 0xEC8E, 0xE799, 0xE397, 0xE0E8, 0xDFED, 0xE035, 0xE099, 0xE115, 
	0xE1A4, 0xE242, 0xE2ED, 0xE39F, 0xE455, 0xE50B, 0xE5BD, 0xE668, 0xE706, 
	0xE795, 0xE810, 0xE87F, 0xE8EC, 0xE956, 0xE9BE, 0xEA24, 0xEA87, 0xEAE8, 
	0xEB47, 0xEBA4, 0xEBFF, 0xEC58, 0xECAF, 0xED04, 0xED53, 0xED94, 0xEDC7, 
	0xEDEA, 0xEDFD, 0xEE09, 0xEE1A, 0xEE2E, 0xEE44, 0xEE5B, 0xEE74, 0xEE8B, 
	0xEEA2, 0xEEB6, 0xEEC7, 0xEED4, 0xEEDC, 0xEEDF, 0xEEDA, 0xEECE, 0xF0ED, 
	0xF63A, 0xFD1E, 0x0402, 0x094F, 0x0B6E, 0x0B62, 0x0B41, 0x0B0E, 0x0ACE, 
	0x0A85, 0x0A35, 0x09E4, 0x0994, 0x094B, 0x090A, 0x08D8, 0x08B7, 0x08AB, 
	0x08B3, 0x08C8, 0x08E7, 0x090E, 0x0939, 0x0966, 0x0992, 0x09B8, 0x09D8, 
	0x09ED, 0x09F5, 0x0001, 0xFFFE, 0xC170, 0x36DA, 0x39CD, 0x41F3, 0x489F, 
	0xCDF6, 0xD21F, 0xD540, 0xD77D, 0xD8FE, 0xD9E7, 0xDA5F, 0xDA8B, 0xDA91, 
	0xDA9D, 0xDAF1, 0x5BD4, 0x5D8E, 0x6067, 0xFAF2, 0x1244, 0x15D6, 0x16DD, 
	0x160A, 0x140F, 0x119A, 0x0F5D, 0x0E08, 0x0D59, 0x0C9C, 0x0BD5, 0x0B07, 
	0x0A37, 0x0969, 0x08A0, 0x07E2, 0x0731, 0x0693, 0x060A, 0x059C, 0x054B, 
	0x0511, 0x04E2, 0x04BC, 0x04A0, 0x048D, 0x0481, 0x047B, 0x047C, 0x0483, 
	0x048D, 0x049C, 0x04AD, 0x04C0, 0x04D5, 0x04EA, 0x04FF, 0x0513, 0x0525, 
	0x0535, 0x04FA, 0x035B, 0xFF4B, 0xFA05, 0xF4BF, 0xF0B0, 0xEF11, 0xF3FD, 
	0x00CB, 0x1289, 0x2645, 0x390E, 0x47F3, 0x50A5, 0x535A, 0x5356, 0x533D, 
	0x52F7, 0x5270, 0x5191, 0x5044, 0x4E73, 0x17B7, 0x6206, 0x62B5, 0x6497, 
	0x6770, 0xEB01, 0xEF0E, 0xF359, 0xF7A3, 0xFBB0, 0xFF42, 0x021B, 0x03FE, 
	0x04AC, 0x0281, 0xFACC, 0xEBC3, 0xD5A0, 0x40BC, 0x3777, 0x54F5, 0x51A3, 
	0x5219, 0x535C, 0x2AC0, 0x286B, 0x25D1, 0x2321, 0x2087, 0x1E32, 0x1C4F, 
	0x1B0C, 0x1A96, 0x1D36, 0x237A, 0x550C, 0x4EC8, 0x4C28, 0x2DBD, 0x26F4, 
	0x25A0, 0x24D6, 0x247A, 0x246F, 0x249C, 0x24E4, 0x252B, 0x257A, 0x25E5, 
	0x2667, 0x26FB, 0x279B, 0x2843, 0x28EB, 0x2991, 0x2A2D, 0x2ABA, 0x2B34, 
	0x2B94, 0x2BD6, 0x2C03, 0x2C27, 0x2C43, 0x2C59, 0x2C68, 0x2C71, 0x2C75, 
	0x2C74, 0x2C6F, 0x2C67, 0x2C5C, 0x2C4F, 0x2C40, 0x2C31, 0x2C20, 0x2C10, 
	0x2C01, 0x2BF3, 0x2BE7, 0x2BDE, 0x2BAA, 0x2B46, 0x2ABD, 0x2A17, 0x295F, 
	0x289D, 0x27DC, 0x2727, 0x2687, 0x2608, 0x25B4, 0x2595, 0x28B3, 0x2C5D, 
	0x2D2C, 0x2D89, 0x2DA2, 0x2DA4, 0x2DBC, 0x2E1A, 0x2EE9, 0x317E, 0x4C78, 
	0x4CC7, 0x4DA3, 0x4EF0, 0x2F6F, 0x2D95, 0x2BA0, 0x29AB, 0x27D2, 0x2631, 
	0x24E4, 0x2408, 0x23B8, 0x264D, 0x2B17, 0x2DAC, 0x2CFD, 0x5447, 0x54F5, 
	0x175C, 0x19C5, 0x1E64, 0x222D, 0xA534, 0xA790, 0xA956, 0xAA9B, 0xAB75, 
	0xABF9, 0xAC3D, 0xAC56, 0xAC5A, 0xA747, 0x9B2F, 0x0CC0, 0x00A8, 0xFB95, 
	0x9225, 0xA6A1, 0xAD78, 0xB2D3, 0xB6F5, 0xBA24, 0xBCA2, 0xBEB3, 0xC09C, 
	0xC26D, 0xC40C, 0xC57E, 0xC6C5, 0xC7E5, 0xC8E1, 0xC9BD, 0xCA7B, 0xCB20, 
	0xCBAE, 0xCC2A, 0xCC95, 0xCCF5, 0xCD47, 0xCD8A, 0xCDBF, 0xCDE7, 0xCE02, 
	0xCE13, 0xCE1B, 0xCE19, 0xCE11, 0xCE02, 0xCDED, 0xCDD5, 0xCDB9, 0xCD9C, 
	0xCD7E, 0xCD60, 0xCD44, 0xCD2B, 0xCD15, 0xCD04, 0xCA61, 0xC416, 0xBBFD, 
	0xB3EC, 0xADBB, 0xAB42, 0xAD7D, 0xB350, 0xBB6B, 0xC480, 0xCD3F, 0xD45B, 
	0xD8CE, 0xDAB7, 0xDB64, 0xDBE0, 0xDC33, 0xDC66, 0xDC7F, 0xDC89, 0xDC8A, 
	0xB161, 0x0638, 0x0682, 0x075B, 0x08B7, 0x8A8C, 0x8CD1, 0x8F7C, 0x9281, 
	0x95D7, 0x9974, 0x9D4D, 0xA159, 0xA58C, 0xA9B4, 0xACF3, 0xAE42, 0xA859, 
	0x1D60, 0x1777, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xCB60, 0xCFAB, 0xCF0B, 0xCD54, 0xCAC4, 
	0xC79A, 0xC413, 0xC06D, 0xBCE6, 0xB9BB, 0xB72C, 0xB575, 0xB4D5, 0xB9BF, 
	0xC575, 0xD370, 0xDF27, 0xE410, 0xDFE3, 0xDB93, 0xD917, 0xD6C4, 0xD495, 
	0xD286, 0xD093, 0xCEB7, 0xCCEF, 0xCB0C, 0xC8F4, 0xC6BA, 0xC474, 0xC236, 
	0xC015, 0xBE27, 0xBC80, 0xBB36, 0xBA5C, 0xBA08, 0xBA4F, 0xBAF8, 0xBBB9, 
	0xBC93, 0xBD83, 0xBE88, 0xBFA1, 0xC0CD, 0xC209, 0xC356, 0xC4B0, 0xC618, 
	0xC78B, 0xC908, 0xCA8E, 0xCC1C, 0xCDB0, 0xCF49, 0xD0E5, 0xD283, 0xD422, 
	0xD5C0, 0xD502, 0xD2FB, 0xCFF8, 0xCC45, 0xC82F, 0xC401, 0xBFFD, 0xBC32, 
	0xB8A3, 0xB553, 0xB246, 0xAF7E, 0xAD00, 0xAACE, 0xA8E8, 0xA746, 0xA5D9, 
	0xA496, 0xA36F, 0xA258, 0xA143, 0xA025, 0x9EF4, 0x9DBC, 0x9C8A, 0x9B6F, 
	0x9A79, 0x99B6, 0x9937, 0x9909, 0x9B02, 0xA078, 0xA8B9, 0xB313, 0xBED5, 
	0xCAE3, 0xD476, 0xD85D, 0xD4FF, 0xCEBE, 0xCB60, 0xFA42, 0x0641, 0x146D, 
	0x2007, 0x2951, 0x308D, 0x35FD, 0x39E2, 0x3C7E, 0x3E14, 0x3EE4, 0x3F31, 
	0x3F3C, 0x3F35, 0x3F07, 0x3E8B, 0x3D98, 0x3C08, 0x31D3, 0x2767, 0x22EB, 
	0x1EF4, 0x1B74, 0x1861, 0x15AD, 0x134E, 0x1135, 0x0F2B, 0x0D08, 0x0ADB, 
	0x08B3, 0x069F, 0x04AF, 0x02F2, 0x0177, 0x004D, 0xFF83, 0xFF29, 0xFF4D, 
	0xFFFF, 0x0112, 0x0249, 0x03A5, 0x0521, 0x06BC, 0x0874, 0x0A47, 0x0C32, 
	0x0E32, 0x1047, 0x126C, 0x14A1, 0x16E3, 0x1930, 0x1B85, 0x1DE0, 0x203F, 
	0x22A0, 0x2500, 0x275D, 0x2714, 0x264B, 0x251D, 0x23A5, 0x21FF, 0x2045, 
	0x1E8E, 0x1CDF, 0x1B38, 0x1999, 0x1802, 0x1674, 0x14EE, 0x1370, 0x11FC, 
	0x1090, 0x0F2D, 0x0DD4, 0x0C83, 0x0B3D, 0x09FF, 0x08CC, 0x07A2, 0x0683, 
	0x056D, 0x0462, 0x0361, 0x026B, 0x017F, 0x009E, 0xFFC8, 0xFEFD, 0xFE3D, 
	0xFD89, 0xFCE1, 0xFC44, 0xFBB3, 0xFB2E, 0xFAB8, 0xFA63, 0xFA42, 0x0197, 
	0xF52B, 0xF5DF, 0xF7CE, 0xFAB1, 0xFE42, 0x023D, 0x065A, 0x0A55, 0x0DE6, 
	0x10C9, 0x12B8, 0x136C, 0x12BF, 0x111D, 0x0F1B, 0x0D4D, 0x0C4B, 0x0C1D, 
	0x0AF3, 0x077A, 0x033A, 0xFEA4, 0xFA2B, 0xF643, 0xF35F, 0xF1F1, 0xF1B1, 
	0xF1FC, 0xF2BB, 0xF3D8, 0xF53C, 0xF6D2, 0xF882, 0xFA38, 0xFBDC, 0xFD58, 
	0xFE96, 0xFF80, 0x0000, 0x003F, 0x0078, 0x00AB, 0x00D9, 0x0100, 0x0123, 
	0x0140, 0x0159, 0x016D, 0x017C, 0x0188, 0x0190, 0x0194, 0x0194, 0x0192, 
	0x018C, 0x0184, 0x0179, 0x016C, 0x015D, 0x017B, 0x01C5, 0x0226, 0x0286, 
	0x02D1, 0x02EE, 0x02EC, 0x02E7, 0x02DE, 0x02D2, 0x02C4, 0x02B2, 0x029F, 
	0x0289, 0x0271, 0x0258, 0x023D, 0x0221, 0x0204, 0x01E6, 0x01C8, 0x01AA, 
	0x018B, 0x016D, 0x0150, 0x0133, 0x0117, 0x00FC, 0x00E3, 0x00CB, 0x00B5, 
	0x00A1, 0x0090, 0x0081, 0x0075, 0x006D, 0x0067, 0x0065, 0x00B5, 0x0148, 
	0x0197, 0x0624, 0xFD83, 0xFD5B, 0xFCED, 0xFC49, 0xFB7E, 0xFA9C, 0xF9B2, 
	0xF8D0, 0xF805, 0xF761, 0xF6F3, 0xF6CB, 0xF6CB, 0xF6CC, 0xF6CD, 0xF6D1, 
	0xF6D6, 0xF706, 0xF6AD, 0xF53F, 0xF371, 0xF17B, 0xEF93, 0xEDED, 0xECC2, 
	0xEC46, 0xEC5B, 0xECB4, 0xED47, 0xEE08, 0xEEEB, 0xEFE4, 0xF0E7, 0xF1E9, 
	0xF2DF, 0xF3BB, 0xF474, 0xF4FC, 0xF548, 0xF571, 0xF596, 0xF5B6, 0xF5D3, 
	0xF5ED, 0xF603, 0xF616, 0xF626, 0xF632, 0xF63C, 0xF644, 0xF649, 0xF64B, 
	0xF64C, 0xF64A, 0xF646, 0xF641, 0xF63A, 0xF632, 0xF628, 0xF735, 0xF9D5, 
	0xFD3F, 0x00AA, 0x034B, 0x0457, 0x0451, 0x043E, 0x041F, 0x03F5, 0x03C1, 
	0x0384, 0x033F, 0x02F2, 0x029E, 0x0245, 0x01E6, 0x0183, 0x011D, 0x00B5, 
	0x004A, 0xFFDE, 0xFF73, 0xFF09, 0xFEA0, 0xFE3A, 0xFDD7, 0xFD79, 0xFD1F, 
	0xFCCB, 0xFC7E, 0xFC39, 0xFBFC, 0xFBC8, 0xFB9E, 0xFB7F, 0xFB6C, 0xFB66, 
	0xFE11, 0x0306, 0x05B0, 0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 0xFE9B, 
	0xFE95, 0xFE85, 0xFE69, 0xFE42, 0xFE10, 0xFDD3, 0xFD8A, 0xFD37, 0xFCDB, 
	0xFC87, 0xFC3F, 0xFC02, 0xFBD0, 0xFBA9, 0xFB8D, 0xFB7C, 0xFB76, 0xFB79, 
	0xFB80, 0xFB8D, 0xFB9E, 0xFBB5, 0xFBD0, 0xFBF0, 0xFC15, 0xFC40, 0xFC6F, 
	0xFCA3, 0xFCDC, 0xFD1A, 0xFD5D, 0xFDA5, 0xFDF2, 0xFE44, 0xFE9B, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 0xEFF9, 
	0xEFF9, 0xEFF9, 0xEFF2, 0xEFDE, 0xEFBC, 0xEF8D, 0xEF50, 0xEF06, 0xEEAE, 
	0xEE49, 0xEDD9, 0xED74, 0xED1C, 0xECD2, 0xEC95, 0xEC66, 0xEC44, 0xEC2F, 
	0xEC29, 0xEC2C, 0xEC35, 0xEC44, 0xEC59, 0xEC74, 0xEC95, 0xECBC, 0xECEA, 
	0xED1D, 0xED56, 0xED95, 0xEDDB, 0xEE26, 0xEE77, 0xEECF, 0xEF2C, 0xEF90, 
	0xEFF9, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 0x839E, 
	0x839E, 0x839E, 0x839E, 0x839E, 0x83A1, 0x83A8, 0x83B4, 0x83C4, 0x83DA, 
	0x83F4, 0x8413, 0x8436, 0x845D, 0x8481, 0x84A0, 0x84BA, 0x84CF, 0x84E0, 
	0x84EC, 0x84F3, 0x84F5, 0x84F4, 0x84F1, 0x84EC, 0x84E4, 0x84DB, 0x84CF, 
	0x84C2, 0x84B2, 0x84A0, 0x848C, 0x8475, 0x845D, 0x8442, 0x8426, 0x8407, 
	0x83E6, 0x83C3, 0x839E, 0x0000, 0xFFFF, 0x49EE, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 0xF792, 
	0xF790, 0xF78B, 0xF783, 0xF777, 0xF768, 0xF755, 0xF73F, 0xF726, 0xF709, 
	0xF6E9, 0xF6C5, 0xF69E, 0xF675, 0xF64E, 0xF62A, 0xF60A, 0xF5ED, 0xF5D4, 
	0xF5BE, 0xF5AB, 0xF59C, 0xF590, 0xF587, 0xF582, 0xF581, 0xF586, 0xF596, 
	0xF5B0, 0xF5D5, 0xF605, 0xF63F, 0xF684, 0xF6D3, 0xF72D, 0xF792, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 0x03C6, 
	0x03C6, 0x03C6, 0x03C1, 0x03B3, 0x039B, 0x0379, 0x034E, 0x031A, 0x02DB, 
	0x0294, 0x0242, 0x01E7, 0x0183, 0x0115, 0x00A0, 0x0032, 0xFFCC, 0xFF71, 
	0xFF20, 0xFED8, 0xFE9A, 0xFE65, 0xFE3A, 0xFE19, 0xFE01, 0xFDF3, 0xFDEE, 
	0xFDFD, 0xFE2A, 0xFE74, 0xFEDD, 0xFF64, 0x0009, 0x00CB, 0x01AC, 0x02AA, 
	0x03C6, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB92, 
	0xAB92, 0xAB92, 0xAB92, 0xAB92, 0xAB93, 0xAB96, 0xAB9B, 0xABA2, 0xABAB, 
	0xABB6, 0xABC2, 0xABD1, 0xABE2, 0xABF4, 0xAC09, 0xAC20, 0xAC38, 0xAC4E, 
	0xAC63, 0xAC76, 0xAC86, 0xAC95, 0xACA2, 0xACAD, 0xACB5, 0xACBC, 0xACC1, 
	0xACC4, 0xACC5, 0xACC2, 0xACB9, 0xACAA, 0xAC94, 0xAC78, 0xAC57, 0xAC2F, 
	0xAC01, 0xABCD, 0xAB92, 0xFFFF, 0x0000, 0xBF5E, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 
	0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00DC, 0x00F9, 0x0148, 
	0x01BC, 0x0249, 0x02E3, 0x037C, 0x0409, 0x047D, 0x04CC, 0x04E9, 0x04E2, 
	0x04CE, 0x04AD, 0x0483, 0x0451, 0x0417, 0x03D9, 0x0398, 0x0355, 0x0311, 
	0x02D0, 0x0292, 0x0258, 0x0226, 0x01FC, 0x01DB, 0x01C7, 0x01C0, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 0x11D1, 
	0x11DC, 0x11FB, 0x1228, 0x125F, 0x129A, 0x12D6, 0x130D, 0x133A, 0x1358, 
	0x1364, 0x135F, 0x1354, 0x1341, 0x1329, 0x130C, 0x12EB, 0x12C7, 0x12A2, 
	0x127B, 0x1254, 0x122F, 0x120B, 0x11EA, 0x11CD, 0x11B5, 0x11A2, 0x1196, 
	0x1192, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 0x83C1, 
	0x83C1, 0x83C1, 0x83E7, 0x844D, 0x84E4, 0x859B, 0x8663, 0x872A, 0x87E1, 
	0x8878, 0x88DE, 0x8904, 0x88F9, 0x88DA, 0x88AA, 0x886B, 0x881F, 0x87C9, 
	0x876B, 0x8709, 0x86A4, 0x863F, 0x85DD, 0x857F, 0x8529, 0x84DD, 0x849E, 
	0x846D, 0x844F, 0x8444, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 
	0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF64, 0xFF66, 0xFF69, 0xFF6C, 0xFF71, 
	0xFF76, 0xFF7C, 0xFF83, 0xFF8A, 0xFF91, 0xFF99, 0xFFA1, 0xFFA9, 0xFFB1, 
	0xFFBA, 0xFFC2, 0xFFCA, 0xFFD2, 0xFFD9, 0xFFE0, 0xFFE7, 0xFFED, 0xFFF2, 
	0xFFF6, 0xFFFA, 0xFFFD, 0xFFFE, 0xFFFF, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 
	0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE85, 0xFE86, 0xFE8A, 0xFE91, 
	0xFE9A, 0xFEA5, 0xFEB1, 0xFEC0, 0xFED0, 0xFEE1, 0xFEF3, 0xFF06, 0xFF1A, 
	0xFF2E, 0xFF42, 0xFF56, 0xFF6A, 0xFF7E, 0xFF91, 0xFFA3, 0xFFB4, 0xFFC4, 
	0xFFD2, 0xFFDF, 0xFFEA, 0xFFF3, 0xFFF9, 0xFFFE, 0x0000, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 0x497F, 
	0x4981, 0x4984, 0x4988, 0x498C, 0x4992, 0x4998, 0x499F, 0x49A6, 0x49AE, 
	0x49B6, 0x49BF, 0x49C7, 0x49D0, 0x49D8, 0x49E1, 0x49E9, 0x49F2, 0x49F9, 
	0x4A01, 0x4A08, 0x4A0E, 0x4A13, 0x4A18, 0x4A1C, 0x4A1E, 0x4A20, 0x4A21, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 0x08E7, 
	0x08E7, 0x090B, 0x096C, 0x09FC, 0x0AAA, 0x0B67, 0x0C24, 0x0CD2, 0x0D61, 
	0x0DC2, 0x0DE6, 0x0DDD, 0x0DC2, 0x0D99, 0x0D62, 0x0D21, 0x0CD8, 0x0C87, 
	0x0C33, 0x0BDC, 0x0B86, 0x0B31, 0x0AE1, 0x0A97, 0x0A56, 0x0A20, 0x09F6, 
	0x09DC, 0x09D3, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBD, 0xFFE9, 0x0063, 0x0115, 0x01EE, 0x02D9, 0x03C5, 
	0x049D, 0x0550, 0x05C8, 0x05F5, 0x05E4, 0x05B4, 0x0569, 0x0507, 0x0491, 
	0x040B, 0x037A, 0x02E1, 0x0244, 0x01A8, 0x010F, 0x007E, 0xFFF7, 0xFF81, 
	0xFF1F, 0xFED4, 0xFEA4, 0xFE93, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 
	0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB06F, 0xB036, 0xAF9A, 0xAEB5, 0xAD9F, 
	0xAC71, 0xAB42, 0xAA2C, 0xA947, 0xA8AC, 0xA873, 0xA87B, 0xA893, 0xA8B8, 
	0xA8E8, 0xA922, 0xA964, 0xA9AC, 0xA9F7, 0xAA44, 0xAA92, 0xAADD, 0xAB25, 
	0xAB66, 0xABA1, 0xABD1, 0xABF6, 0xAC0E, 0xAC16, 

},{ 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
	0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 0x0007, 0x0001, 0x0008, 
	0x0053, 0x0009, 0x0052, 0x005C, 0x005C, 0x00AE, 0x005F, 0x010A, 0x005F, 
	0x0169, 0x0065, 0x01C8, 0x0001, 0x022D, 0x0001, 0x022E, 0x0001, 0x022F, 
	0x005A, 0x0230, 0x005A, 0x028A, 0x005A, 0x02E4, 0x005A, 0x033E, 0x005A, 
	0x0398, 0x005A, 0x03F2, 0x005A, 0x044C, 0x005A, 0x04A6, 0x005A, 0x0500, 
	0x0001, 0x055A, 0x0001, 0x055B, 0x0001, 0x055C, 0x0065, 0x055D, 0x0065, 
	0x05C2, 0x0065, 0x0627, 0x0001, 0x068C, 0x0049, 0x068D, 0x0065, 0x06D6, 
	0x0065, 0x073B, 0x0065, 0x07A0, 0x0065, 0x0805, 0x0001, 0x086A, 0x0001, 
	0x086B, 0x0001, 0x086C, 0x0065, 0x086D, 0x0065, 0x08D2, 0x0065, 0x0937, 
	0x0001, 0x099C, 0x0001, 0x099D, 0x0001, 0x099E, 0x0065, 0x099F, 0x0065, 
	0x0A04, 0x0065, 0x0A69, 0x0001, 0x0ACE, 0x0001, 0x0ACF, 0x0001, 0x0AD0, 
	0x0065, 0x0AD1, 0x0065, 0x0B36, 0x0065, 0x0B9B, 0x0065, 0x0C00, 0x0065, 
	0x0C65, 0x0065, 0x0CCA, 0x0065, 0x0D2F, 0x0065, 0x0D94, 0x0065, 0x0DF9, 
	

});

smlua_anim_util_register_animation('donkey_39_head_stuck_in_ground',1, 0, 0, 0, 154, { 
	0x0000, 0x002C, 0x001F, 0x001B, 0x001A, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 
	0x0019, 0x0019, 0x001A, 0x001A, 0x001A, 0x001B, 0x001B, 0x001B, 0x001C, 
	0x001D, 0x001D, 0x001E, 0x001F, 0x0020, 0x0020, 0x0022, 0x0023, 0x0024, 
	0x0025, 0x0026, 0x0027, 0x0029, 0x002A, 0x002C, 0x002E, 0x003B, 0x004C, 
	0x0054, 0x005B, 0x0060, 0x0062, 0x005E, 0x0052, 0x0042, 0x0032, 0x0024, 
	0x002C, 0x0031, 0x0035, 0x0037, 0x003E, 0x0046, 0x0046, 0x0041, 0x0040, 
	0x003F, 0x003F, 0x003E, 0x003E, 0x003D, 0x003D, 0x003C, 0x003C, 0x0047, 
	0x005D, 0x0074, 0x007F, 0x007E, 0x007C, 0x007A, 0x0079, 0x007B, 0x0081, 
	0x0089, 0x0092, 0x009A, 0x00A0, 0x00A2, 0x00A2, 0x00A1, 0x00A0, 0x009E, 
	0x009D, 0x009B, 0x0099, 0x0097, 0x0094, 0x0092, 0x0091, 0x008F, 0x008D, 
	0x008C, 0x008C, 0x008B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0003, 0x0003, 
	0x0004, 0x0004, 0x0005, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 
	0x0006, 0x0006, 0x0006, 0x0005, 0x0004, 0x0004, 0x0002, 0x0001, 0x0000, 
	0xFFEF, 0xFFCF, 0xFFAF, 0xFF8B, 0xFF6B, 0xFF55, 0xFF4C, 0xFF4B, 0xFF4F, 
	0xFF53, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 
	0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF55, 0xFF54, 0xFF54, 0xFF54, 0xFF54, 
	0xFF54, 0xFF58, 0xFF63, 0xFF72, 0xFF82, 0xFF92, 0xFFA0, 0xFFAD, 0xFFB8, 
	0xFFC0, 0xFFC7, 0xFFCC, 0xFFD0, 0xFFD4, 0xFFD7, 0xFFD9, 0xFFDC, 0xFFDF, 
	0xFFE2, 0xFFE6, 0xFFE9, 0xFFEC, 0xFFEF, 0xFFF2, 0xFFF5, 0xFFF8, 0xFFFA, 
	0xFFFC, 0xFFFE, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0001, 0x0002, 0x0004, 0x0006, 0x0008, 0x000B, 0x000D, 0x0010, 
	0x0012, 0x0014, 0x0016, 0x0017, 0x0018, 0x0018, 0x0017, 0x0016, 0x0013, 
	0x0010, 0x000C, 0x0006, 0xFFFF, 0xFFE2, 0xFFA6, 0xFF61, 0xFF28, 0xFF10, 
	0xFF2F, 0xFF82, 0xFFF4, 0x007C, 0x0113, 0x01B1, 0x024D, 0x02E1, 0x0362, 
	0x03CB, 0x0413, 0x043F, 0x045F, 0x0473, 0x047D, 0x047E, 0x0479, 0x046E, 
	0x045F, 0x044F, 0x043D, 0x042D, 0x0420, 0x0416, 0x0413, 0x0412, 0x0411, 
	0x0410, 0x040F, 0x0410, 0x0410, 0x0411, 0x0411, 0x0412, 0x0412, 0x0411, 
	0x0412, 0x0415, 0x041A, 0x0421, 0x042A, 0x0435, 0x0440, 0x044C, 0x0459, 
	0x0466, 0x0474, 0x0481, 0x048D, 0x0499, 0x04A4, 0x04AE, 0x04B6, 0x04BC, 
	0x04C1, 0x04C3, 0x04C2, 0x04BF, 0x04B8, 0x04AF, 0x04A1, 0x0490, 0x047A, 
	0x0460, 0x0441, 0x041E, 0x03F5, 0x0190, 0xFE73, 0xFD1B, 0xFC45, 0xFBEE, 
	0xFBF8, 0xFC3A, 0xFC9C, 0xFD04, 0xFD5B, 0xFD86, 0xFD90, 0xFD93, 0xFD90, 
	0xFD89, 0xFD7C, 0xFD6D, 0xFD5C, 0xFD49, 0xFD35, 0xFD22, 0xFD2E, 0xFD4A, 
	0xFD6C, 0xFD88, 0xFD94, 0xFCCE, 0xFCC0, 0xFCB1, 0xFCA3, 0xFC95, 0xFC88, 
	0xFC7C, 0xFC71, 0xFC76, 0xFC83, 0xFC97, 0xFCB3, 0xFCD5, 0xFCFC, 0xFD28, 
	0xFD58, 0xFD8B, 0xFDC1, 0xFDF7, 0xFE2F, 0xFE67, 0xFE9E, 0xFED3, 0xFF06, 
	0xFF36, 0xFF62, 0xFF89, 0xFFAB, 0xFFC7, 0xFFDC, 0xFFE9, 0xFFED, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0001, 0x0002, 0x0003, 0x0004, 
	0x0006, 0x0007, 0x0008, 0x0008, 0x0008, 0x0007, 0x0006, 0x0003, 0x0000, 
	0xFFF0, 0xFFD5, 0xFFBC, 0xFFB4, 0xFFBE, 0xFFCF, 0xFFE5, 0xFFFD, 0x0014, 
	0x0027, 0x0034, 0x003B, 0x0041, 0x0046, 0x004A, 0x004C, 0x004E, 0x004F, 
	0x004F, 0x004F, 0x004E, 0x004D, 0x004C, 0x004C, 0x004B, 0x004B, 0x004B, 
	0x004C, 0x004E, 0x0051, 0x0055, 0x005B, 0x0062, 0x006A, 0x0074, 0x0080, 
	0x008E, 0x009E, 0x00B0, 0x00C5, 0x00DD, 0x00F7, 0x0273, 0x03C4, 0x02D0, 
	0x0122, 0xFFCD, 0xFF06, 0xFE4E, 0xFDAC, 0xFD27, 0xFCC5, 0xFC8C, 0xFC6F, 
	0xFC5B, 0xFC50, 0xFC4D, 0xFC51, 0xFC5D, 0xFC6F, 0xFC88, 0xFCA5, 0xFCC8, 
	0xFCDB, 0xFCE0, 0xFCE1, 0xFCE6, 0xFCF9, 0xFDFC, 0xFE43, 0xFE8F, 0xFEDF, 
	0xFF32, 0xFF87, 0xFFDE, 0x0036, 0x0037, 0x0038, 0x003A, 0x003E, 0x0042, 
	0x0046, 0x004B, 0x0051, 0x0057, 0x005D, 0x0063, 0x006A, 0x0070, 0x0076, 
	0x007C, 0x0082, 0x0088, 0x008D, 0x0092, 0x0095, 0x0099, 0x009B, 0x009D, 
	0x009D, 0xFFFE, 0xB00A, 0xB647, 0xB6BE, 0xB71F, 0xB76B, 0xB7A5, 0xB7CD, 
	0xB7E5, 0xB7F0, 0xB7EE, 0xB7E1, 0xB7CB, 0xB7AE, 0xB78B, 0xB763, 0xB739, 
	0xB70D, 0xB6E3, 0xB6BA, 0xB695, 0xB676, 0xB65D, 0xB64D, 0xB647, 0xB647, 
	0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 
	0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB647, 0xB645, 0xB63D, 0xB632, 
	0xB625, 0xB618, 0xB60A, 0xB5FE, 0xB5F6, 0xB5F1, 0xB5F2, 0xB5FA, 0xB60A, 
	0xB623, 0xB647, 0xB6DD, 0xB7EC, 0xB8E4, 0xB937, 0xB8D9, 0xB82E, 0xB754, 
	0xB666, 0xB580, 0xB4C0, 0xB441, 0xB3FD, 0xB3DD, 0xB3DA, 0xB3F3, 0xB424, 
	0xB468, 0xB4BE, 0xB520, 0xB58C, 0xB5FE, 0xB673, 0xB6E7, 0xB756, 0xB7BD, 
	0xB819, 0xB866, 0xB8A0, 0xB8C4, 0xB8CF, 0xB8BD, 0xB88A, 0xB833, 0xB7B5, 
	0xB70C, 0xB634, 0xB529, 0xB3EA, 0xB271, 0xB0BB, 0xAEC6, 0xAC8C, 0x8EDF, 
	0x6658, 0x50D9, 0x4044, 0x3450, 0x2AFB, 0x2295, 0x1B59, 0x157D, 0x113A, 
	0x0ECA, 0x0D92, 0x0CCC, 0x0C70, 0x0C75, 0x0CD5, 0x0D86, 0x0E82, 0x0FBF, 
	0x1136, 0x12DF, 0x12D3, 0x12B8, 0x1297, 0x127C, 0x1270, 0x2032, 0x2328, 
	0x264C, 0x2998, 0x2D04, 0x3089, 0x341F, 0x37BE, 0x3B2C, 0x3E5C, 0x4151, 
	0x440C, 0x4690, 0x48DF, 0x4AFA, 0x4CE5, 0x4EA2, 0x5032, 0x5197, 0x52D5, 
	0x53ED, 0x54E1, 0x55B3, 0x5666, 0x56FC, 0x5777, 0x57D9, 0x5824, 0x585B, 
	0x587F, 0x5894, 0x589A, 0x5675, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0007, 0x0019, 
	0x0031, 0x0049, 0x005B, 0x0062, 0x0059, 0x003A, 0x0000, 0xFFA8, 0xFF3A, 
	0xFEB8, 0xFE28, 0xFD8D, 0xFCED, 0xFC4A, 0xFBAB, 0xFB13, 0xFA86, 0xFA8E, 
	0xFAA3, 0xFAC6, 0xFAF5, 0xFB2D, 0xFB6F, 0xFBB9, 0xFC09, 0xFC5E, 0xFCB8, 
	0xFD13, 0xFD70, 0xFDCE, 0xFE29, 0xFE83, 0xFED8, 0xFF28, 0xFF72, 0xFFB4, 
	0xFFEC, 0x001C, 0x003F, 0x0054, 0x005C, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFF0, 0xFFCA, 0xFF99, 0xFF67, 0xFF41, 0xFF32, 0xFF45, 0xFF86, 0x0000, 
	0x00B5, 0x019B, 0x02A9, 0x03D5, 0x0517, 0x0664, 0x07B6, 0x0901, 0x0A3D, 
	0x0B62, 0x0B53, 0x0B26, 0x0ADF, 0x0A81, 0x0A0D, 0x0987, 0x08F1, 0x084E, 
	0x07A0, 0x06EA, 0x062F, 0x0572, 0x04B4, 0x03F9, 0x0343, 0x0296, 0x01F3, 
	0x015D, 0x00D6, 0x0063, 0x0004, 0xFFBC, 0xFF90, 0xFF80, 0x0000, 0x0323, 
	0x094D, 0x0983, 0x09B3, 0x09DE, 0x0A05, 0x0A27, 0x0A45, 0x0A5F, 0x0A74, 
	0x0A86, 0x0A95, 0x0A9F, 0x0AA7, 0x0AAB, 0x0AAD, 0x0AAC, 0x0AA8, 0x0AA1, 
	0x0A99, 0x0A8E, 0x0A82, 0x0A73, 0x0A64, 0x0A52, 0x0A40, 0x0A2D, 0x0A19, 
	0x0A04, 0x09EE, 0x09D9, 0x09C3, 0x09AD, 0x0997, 0x0982, 0x096D, 0x0959, 
	0x0946, 0x0934, 0x0923, 0x0914, 0x0906, 0x08FA, 0x08F0, 0x08E8, 0x08E2, 
	0x08DF, 0x08DE, 0x08E0, 0x08E6, 0x08EE, 0x08FA, 0x0909, 0x091C, 0x0932, 
	0x094D, 0x0968, 0x097D, 0x098F, 0x099D, 0x09A8, 0x09B1, 0x09B8, 0x09BD, 
	0x09C1, 0x09C6, 0x09CA, 0x09CF, 0x09D5, 0x09DD, 0x09E7, 0x09F4, 0x0A05, 
	0x0A19, 0x0A32, 0x0A50, 0x0A73, 0x0A9C, 0x0ACC, 0x0B03, 0x0B41, 0x0B88, 
	0x0BD7, 0x0C30, 0x0C92, 0x0CFE, 0x0D76, 0x0DF8, 0x0E87, 0x0F22, 0x0FCA, 
	0x107F, 0x1142, 0x1214, 0x12F5, 0x13E5, 0x2327, 0x320B, 0x31E4, 0x3105, 
	0x2F8A, 0x2D8F, 0x2B31, 0x288C, 0x25BC, 0x22DE, 0x200E, 0x1D68, 0x1B09, 
	0x190D, 0x1790, 0x169E, 0x1620, 0x15FE, 0x1621, 0x1670, 0x16D4, 0x1736, 
	0x177C, 0x1790, 0x178E, 0x17A1, 0x17C3, 0x17EE, 0x181E, 0x184C, 0x1875, 
	0x1891, 0x189C, 0x1890, 0x1856, 0x17EC, 0x1755, 0x1696, 0x15B4, 0x14B3, 
	0x1398, 0x1267, 0x1126, 0x0FD8, 0x0E82, 0x0D29, 0x0BD1, 0x0A7F, 0x0937, 
	0x07FF, 0x06DA, 0x05CD, 0x04DE, 0x040F, 0x0366, 0x02E8, 0x0299, 0x027E, 
	0x039F, 0x0232, 0x0233, 0x0235, 0x0236, 0x0237, 0x0238, 0x023A, 0x023B, 
	0x023C, 0x023D, 0x023E, 0x023F, 0x0240, 0x0241, 0x0243, 0x0244, 0x0245, 
	0x0245, 0x0246, 0x0247, 0x0248, 0x0249, 0x024A, 0x024B, 0x024C, 0x024C, 
	0x024D, 0x024E, 0x024E, 0x024F, 0x0250, 0x0250, 0x0251, 0x0251, 0x0252, 
	0x0252, 0x0253, 0x0253, 0x0254, 0x0254, 0x0254, 0x0255, 0x0255, 0x0255, 
	0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 
	0x0256, 0x0256, 0x0256, 0x0256, 0x0255, 0x0255, 0x0255, 0x0254, 0x0254, 
	0x0254, 0x0253, 0x0253, 0x0252, 0x0252, 0x0251, 0x0251, 0x0250, 0x024F, 
	0x024E, 0x024E, 0x024D, 0x024C, 0x024B, 0x024A, 0x0249, 0x0248, 0x0247, 
	0x0246, 0x0245, 0x0244, 0x0242, 0x0241, 0x0240, 0x023E, 0x023D, 0x023C, 
	0x023A, 0x0239, 0x0237, 0x0235, 0x0234, 0x0232, 0x01E0, 0x018B, 0x0187, 
	0x0188, 0x018C, 0x0193, 0x019D, 0x01A7, 0x01B2, 0x01BD, 0x01C6, 0x01CE, 
	0x01D2, 0x01D3, 0x01D0, 0x01B3, 0x017C, 0x0143, 0x0124, 0x00F9, 0x00B3, 
	0x008B, 0x00B8, 0x0172, 0x02A8, 0x0417, 0x05B5, 0x0776, 0x094E, 0x0B32, 
	0x0D16, 0x0EEE, 0x10AE, 0x124C, 0x13BA, 0x13A2, 0x135E, 0x12F1, 0x125F, 
	0x11AD, 0x10DD, 0x0FF4, 0x0EF6, 0x0DE6, 0x0CC8, 0x0BA1, 0x0A74, 0x0946, 
	0x0819, 0x06F2, 0x05D4, 0x04C4, 0x03C6, 0x02DD, 0x020D, 0x015A, 0x00C9, 
	0x005C, 0x0018, 0x0000, 0x0025, 0x0022, 0x001F, 0x001C, 0x0019, 0x0017, 
	0x0015, 0x0013, 0x0011, 0x0010, 0x000E, 0x000D, 0x000C, 0x000C, 0x000B, 
	0x000B, 0x000A, 0x000A, 0x000A, 0x000A, 0x000B, 0x000B, 0x000C, 0x000C, 
	0x000D, 0x000E, 0x000F, 0x0010, 0x0011, 0x0013, 0x0014, 0x0015, 0x0017, 
	0x0019, 0x001A, 0x001C, 0x001E, 0x0020, 0x0021, 0x0023, 0x0025, 0x0027, 
	0x0029, 0x002B, 0x002D, 0x002F, 0x0031, 0x0033, 0x0035, 0x0037, 0x0039, 
	0x003B, 0x003D, 0x003F, 0x0040, 0x0042, 0x0044, 0x0046, 0x0047, 0x0049, 
	0x004A, 0x004B, 0x004D, 0x004E, 0x004F, 0x0050, 0x0050, 0x0051, 0x0052, 
	0x0052, 0x0053, 0x0053, 0x0053, 0x0053, 0x0052, 0x0052, 0x0051, 0x0051, 
	0x0050, 0x004F, 0x004D, 0x004C, 0x004A, 0x0048, 0x0046, 0x0044, 0x0042, 
	0x003F, 0x003C, 0x0039, 0x0035, 0x0032, 0x002E, 0x0029, 0x0025, 0xFF4E, 
	0xFE6E, 0xFE5B, 0xFE52, 0xFE51, 0xFE56, 0xFE61, 0xFE6F, 0xFE80, 0xFE91, 
	0xFEA1, 0xFEB0, 0xFEBB, 0xFEC0, 0xFEC0, 0xFEA7, 0xFE75, 0xFE41, 0xFE23, 
	0xFE0A, 0xFDE9, 0xFDD9, 0xFDF5, 0xFE57, 0xFEEE, 0xFF96, 0x004D, 0x0110, 
	0x01DC, 0x02AD, 0x0382, 0x0456, 0x0527, 0x05F2, 0x06B4, 0x06AC, 0x0695, 
	0x0670, 0x063E, 0x0602, 0x05BB, 0x056C, 0x0515, 0x04B9, 0x0458, 0x03F4, 
	0x038D, 0x0327, 0x02C0, 0x025C, 0x01FB, 0x019F, 0x0148, 0x00F9, 0x00B2, 
	0x0076, 0x0044, 0x001F, 0x0008, 0x0000, 0xF206, 0xF248, 0xF285, 0xF2BD, 
	0xF2F1, 0xF320, 0xF34B, 0xF371, 0xF394, 0xF3B2, 0xF3CD, 0xF3E4, 0xF3F7, 
	0xF406, 0xF412, 0xF41B, 0xF421, 0xF423, 0xF422, 0xF41F, 0xF419, 0xF410, 
	0xF404, 0xF3F6, 0xF3E6, 0xF3D3, 0xF3BE, 0xF3A7, 0xF38F, 0xF374, 0xF358, 
	0xF33A, 0xF31A, 0xF2FA, 0xF2D8, 0xF2B5, 0xF290, 0xF26B, 0xF245, 0xF21F, 
	0xF1F7, 0xF1D0, 0xF1A7, 0xF17F, 0xF156, 0xF12E, 0xF105, 0xF0DD, 0xF0B4, 
	0xF08D, 0xF065, 0xF03F, 0xF019, 0xEFF3, 0xEFCF, 0xEFAC, 0xEF8A, 0xEF69, 
	0xEF4A, 0xEF2C, 0xEF0F, 0xEEF5, 0xEEDC, 0xEEC5, 0xEEB0, 0xEE9D, 0xEE8C, 
	0xEE7E, 0xEE72, 0xEE69, 0xEE62, 0xEE5F, 0xEE5E, 0xEE60, 0xEE65, 0xEE6E, 
	0xEE7A, 0xEE89, 0xEE9C, 0xEEB2, 0xEECD, 0xEEEB, 0xEF0D, 0xEF33, 0xEF5E, 
	0xEF8D, 0xEFC0, 0xEFF8, 0xF034, 0xF075, 0xF0BB, 0xF106, 0xF156, 0xF1AC, 
	0xF206, 0x032A, 0x1508, 0x1669, 0x16FF, 0x16EC, 0x164D, 0x1546, 0x13F4, 
	0x127A, 0x10F6, 0x0F8A, 0x0E56, 0x0D7A, 0x0D16, 0x0D4A, 0x100B, 0x1582, 
	0x1B1D, 0x1E4F, 0x1E82, 0x1D47, 0x1B43, 0x191C, 0x177A, 0x1651, 0x152B, 
	0x1407, 0x12E5, 0x11C6, 0x10A9, 0x0F8E, 0x0E75, 0x0D5F, 0x0C4C, 0x0B3B, 
	0x0A16, 0x08D9, 0x0788, 0x0626, 0x04B5, 0x0338, 0x01B4, 0x0029, 0xFE9C, 
	0xFD10, 0xFB87, 0xFA06, 0xF88E, 0xF723, 0xF5C7, 0xF47F, 0xF34C, 0xF232, 
	0xF133, 0xF054, 0xEF96, 0xEEFE, 0xEE8D, 0xEE47, 0xEE2F, 0x0001, 0xFFFE, 
	0xC170, 0x34B5, 0x34B6, 0x34B8, 0x34BA, 0x34BC, 0x34BF, 0x34C2, 0x34C6, 
	0x34CB, 0x34D0, 0x34D5, 0x34DA, 0x34E0, 0x34E7, 0x34ED, 0x34F4, 0x34FC, 
	0x3503, 0x350B, 0x3513, 0x351B, 0x3524, 0x352C, 0x3535, 0x353E, 0x3547, 
	0x3550, 0x355A, 0x3563, 0x356C, 0x3576, 0x357F, 0x3589, 0x3592, 0x359C, 
	0x35A5, 0x35AF, 0x35B8, 0x35C1, 0x35CA, 0x35D3, 0x35DB, 0x35E4, 0x35EC, 
	0x35F4, 0x35FC, 0x3603, 0x360B, 0x3612, 0x3618, 0x361F, 0x3625, 0x362A, 
	0x362F, 0x3634, 0x3639, 0x363C, 0x3640, 0x3643, 0x3645, 0x3647, 0x3649, 
	0x364A, 0x364A, 0x364A, 0x3649, 0x3647, 0x3645, 0x3642, 0x363F, 0x363A, 
	0x3635, 0x3630, 0x3629, 0x3622, 0x361A, 0x3611, 0x3607, 0x35FD, 0x35F1, 
	0x35E5, 0x35D8, 0x35CA, 0x35BB, 0x35AB, 0x3599, 0x3587, 0x3574, 0x3560, 
	0x354B, 0x3535, 0x351E, 0x3505, 0x34EC, 0x34D1, 0x34B5, 0x2F7F, 0x29CF, 
	0x290B, 0x28CD, 0x28F6, 0x2963, 0xA9F5, 0xAA8D, 0xAB0A, 0xAB4C, 0xAB31, 
	0xAA9C, 0xA96A, 0xA77C, 0xA4B1, 0xA035, 0x99A8, 0x119F, 0x08A8, 0xFF54, 
	0xF63C, 0xEDEF, 0xE6FE, 0xE1FB, 0xDE19, 0xDA29, 0xD62E, 0xD22A, 0xCE20, 
	0xCA13, 0xC604, 0xC1F7, 0xBDEF, 0xB9EC, 0xBA65, 0xBBC2, 0xBDED, 0xC0D3, 
	0xC45F, 0xC87C, 0xCD15, 0xD216, 0xD769, 0xDCFA, 0xE2B5, 0xE885, 0xEE55, 
	0xF410, 0xF9A1, 0xFEF5, 0x03F6, 0x088F, 0x0CAC, 0x1038, 0x131E, 0x1549, 
	0x16A6, 0x171F, 0x19C6, 0xEDCB, 0xEDCB, 0xEDCC, 0xEDCD, 0xEDCE, 0xEDCF, 
	0xEDD0, 0xEDD2, 0xEDD4, 0xEDD6, 0xEDD8, 0xEDDB, 0xEDDD, 0xEDE0, 0xEDE3, 
	0xEDE6, 0xEDE9, 0xEDEC, 0xEDF0, 0xEDF3, 0xEDF7, 0xEDFA, 0xEDFE, 0xEE02, 
	0xEE06, 0xEE0A, 0xEE0E, 0xEE12, 0xEE16, 0xEE1A, 0xEE1E, 0xEE22, 0xEE26, 
	0xEE2A, 0xEE2E, 0xEE32, 0xEE36, 0xEE3A, 0xEE3E, 0xEE42, 0xEE46, 0xEE49, 
	0xEE4D, 0xEE50, 0xEE54, 0xEE57, 0xEE5B, 0xEE5E, 0xEE61, 0xEE63, 0xEE66, 
	0xEE69, 0xEE6B, 0xEE6D, 0xEE6F, 0xEE71, 0xEE73, 0xEE75, 0xEE76, 0xEE77, 
	0xEE78, 0xEE78, 0xEE79, 0xEE79, 0xEE79, 0xEE78, 0xEE78, 0xEE77, 0xEE75, 
	0xEE74, 0xEE72, 0xEE70, 0xEE6E, 0xEE6B, 0xEE68, 0xEE64, 0xEE60, 0xEE5C, 
	0xEE58, 0xEE53, 0xEE4D, 0xEE48, 0xEE42, 0xEE3B, 0xEE34, 0xEE2D, 0xEE25, 
	0xEE1D, 0xEE14, 0xEE0B, 0xEE02, 0xEDF8, 0xEDED, 0xEDE2, 0xEDD7, 0xEDCB, 
	0xEC18, 0xE91B, 0xE641, 0xE309, 0xDF8E, 0xDBEC, 0xA7BF, 0xAB5B, 0xAECA, 
	0xB1F0, 0xB4B3, 0xB6F4, 0xB899, 0xB986, 0xB99F, 0xB7D3, 0xB3A1, 0xD240, 
	0xD91C, 0xE038, 0xE6DF, 0xEC58, 0xEFED, 0xF0E5, 0xF031, 0xEF3D, 0xEE0D, 
	0xECA5, 0xEB09, 0xE93E, 0xE747, 0xE52A, 0xE2E9, 0xE089, 0xDFAD, 0xDEE4, 
	0xDE2B, 0xDD84, 0xDCED, 0xDC64, 0xDBEA, 0xDB7E, 0xDB1E, 0xDACA, 0xDA82, 
	0xDA44, 0xDA0F, 0xD9E3, 0xD9BF, 0xD9A2, 0xD98C, 0xD97B, 0xD96F, 0xD967, 
	0xD962, 0xD95F, 0xD95E, 0xD95E, 0xDC99, 0x4E6F, 0x4E6C, 0x4E68, 0x4E63, 
	0x4E5C, 0x4E54, 0x4E4A, 0x4E3F, 0x4E33, 0x4E25, 0x4E17, 0x4E07, 0x4DF7, 
	0x4DE5, 0x4DD2, 0x4DBF, 0x4DAB, 0x4D96, 0x4D80, 0x4D69, 0x4D52, 0x4D3B, 
	0x4D22, 0x4D0A, 0x4CF1, 0x4CD7, 0x4CBD, 0x4CA3, 0x4C89, 0x4C6F, 0x4C54, 
	0x4C3A, 0x4C1F, 0x4C05, 0x4BEB, 0x4BD0, 0x4BB6, 0x4B9D, 0x4B83, 0x4B6A, 
	0x4B52, 0x4B39, 0x4B22, 0x4B0B, 0x4AF4, 0x4ADE, 0x4AC9, 0x4AB5, 0x4AA2, 
	0x4A8F, 0x4A7D, 0x4A6D, 0x4A5D, 0x4A4F, 0x4A41, 0x4A35, 0x4A2A, 0x4A20, 
	0x4A18, 0x4A11, 0x4A0C, 0x4A08, 0x4A05, 0x4A04, 0x4A05, 0x4A08, 0x4A0C, 
	0x4A12, 0x4A1A, 0x4A24, 0x4A30, 0x4A3E, 0x4A4E, 0x4A60, 0x4A74, 0x4A8B, 
	0x4AA3, 0x4ABE, 0x4ADC, 0x4AFC, 0x4B1E, 0x4B43, 0x4B6B, 0x4B95, 0x4BC2, 
	0x4BF1, 0x4C24, 0x4C59, 0x4C91, 0x4CCC, 0x4D0A, 0x4D4B, 0x4D90, 0x4DD7, 
	0x4E22, 0x4E70, 0x5D07, 0x6CE3, 0x6F2E, 0x707C, 0x7102, 0x70F5, 0xF08B, 
	0xEFFB, 0xEF79, 0xEF3A, 0xEF74, 0xF05D, 0xF22A, 0xF510, 0xF945, 0xFFF7, 
	0x09A2, 0x956C, 0xA27D, 0xAFFC, 0xBD11, 0xC8E2, 0xD297, 0xD956, 0xDE57, 
	0xE35E, 0xE868, 0xED73, 0xF27D, 0xF783, 0xFC82, 0x017B, 0x0665, 0x0B40, 
	0x0AE2, 0x09D1, 0x081E, 0x05D8, 0x030E, 0xFFD0, 0xFC2E, 0xF836, 0xF3FA, 
	0xEF88, 0xEAEF, 0xE640, 0xE18A, 0xDCDC, 0xD846, 0xD3D7, 0xCF9F, 0xCBAE, 
	0xC813, 0xC4DE, 0xC21E, 0xBFE2, 0xBE3B, 0xBD38, 0xBCE3, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0001, 0x0004, 0x0008, 0x000D, 0x0014, 0x001C, 0x0025, 
	0x002F, 0x003A, 0x0044, 0x0050, 0x005B, 0x0066, 0x0072, 0x007C, 0x0087, 
	0x0091, 0x009A, 0x00A2, 0x00A9, 0x00AE, 0x00B2, 0x00B5, 0x00B6, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFB, 0xFFF1, 0xFFE0, 0xFFC9, 0xFFAD, 
	0xFF8D, 0xFF69, 0xFF42, 0xFF19, 0xFEED, 0xFEC0, 0xFE93, 0xFE66, 0xFE39, 
	0xFE0D, 0xFDE4, 0xFDBD, 0xFD99, 0xFD78, 0xFD5D, 0xFD46, 0xFD35, 0xFD2B, 
	0xFD27, 0x0000, 0xF3AF, 0xF3AF, 0xF3B1, 0xF3B2, 0xF3B4, 0xF3B7, 0xF3BA, 
	0xF3BD, 0xF3C1, 0xF3C5, 0xF3CA, 0xF3CE, 0xF3D4, 0xF3D9, 0xF3DF, 0xF3E5, 
	0xF3EB, 0xF3F1, 0xF3F8, 0xF3FF, 0xF406, 0xF40D, 0xF415, 0xF41C, 0xF424, 
	0xF42C, 0xF434, 0xF43C, 0xF444, 0xF44C, 0xF454, 0xF45C, 0xF464, 0xF46C, 
	0xF474, 0xF47D, 0xF485, 0xF48C, 0xF494, 0xF49C, 0xF4A3, 0xF4AB, 0xF4B2, 
	0xF4B9, 0xF4C0, 0xF4C7, 0xF4CD, 0xF4D4, 0xF4DA, 0xF4DF, 0xF4E5, 0xF4EA, 
	0xF4EF, 0xF4F3, 0xF4F7, 0xF4FB, 0xF4FE, 0xF501, 0xF504, 0xF506, 0xF508, 
	0xF509, 0xF50A, 0xF50A, 0xF50A, 0xF509, 0xF507, 0xF506, 0xF503, 0xF500, 
	0xF4FC, 0xF4F8, 0xF4F3, 0xF4EE, 0xF4E8, 0xF4E1, 0xF4D9, 0xF4D1, 0xF4C8, 
	0xF4BE, 0xF4B3, 0xF4A8, 0xF49C, 0xF48F, 0xF481, 0xF472, 0xF463, 0xF453, 
	0xF441, 0xF42F, 0xF41C, 0xF408, 0xF3F3, 0xF3DD, 0xF3C6, 0xF3AE, 0xF385, 
	0xF33C, 0xF2D6, 0xF256, 0xF1BE, 0xF111, 0xF052, 0xEF84, 0xEEA9, 0xEDC4, 
	0xECD8, 0xEBE7, 0xEAF5, 0xEA04, 0xE917, 0xE80B, 0xE6C8, 0xE560, 0xE3E4, 
	0xE265, 0xE0F6, 0xDFA6, 0xDE89, 0xDDAE, 0xDCF9, 0xDC41, 0xDB86, 0xDAC9, 
	0xDA09, 0xD949, 0xD888, 0xD7C7, 0xD705, 0xD645, 0xD59D, 0xD511, 0xD49C, 
	0xD43D, 0xD3F0, 0xD3B2, 0xD380, 0xD357, 0xD333, 0xD313, 0xD2F1, 0xD2CD, 
	0xD2A1, 0xD26C, 0xD22A, 0xD1D9, 0xD174, 0xD0F9, 0xD066, 0xCFB6, 0xCEE6, 
	0xCDF5, 0xCCDE, 0xCB9E, 0xCC9F, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 0xD8BF, 
	0xD8BF, 0xD8A7, 0xD866, 0xD805, 0xD790, 0xD711, 0xD692, 0xD61D, 0xD5BC, 
	0xD57B, 0xD563, 0xD57E, 0xD5D8, 0xD67A, 0xD76E, 0xD8BF, 0xDB19, 0xDED9, 
	0xE394, 0xE8DE, 0xEE4C, 0xF373, 0xF7E7, 0xFB3D, 0xFD0A, 0xFDE3, 0xFEA7, 
	0xFF56, 0xFFF2, 0x007B, 0x00F2, 0x0158, 0x01AE, 0x01F5, 0x022D, 0x022B, 
	0x0224, 0x021A, 0x020C, 0x01FC, 0x01E8, 0x01D2, 0x01BB, 0x01A2, 0x0187, 
	0x016C, 0x0151, 0x0135, 0x011A, 0x0100, 0x00E7, 0x00CF, 0x00B9, 0x00A6, 
	0x0095, 0x0087, 0x007D, 0x0077, 0x0074, 0x04C7, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 0xFA43, 
	0xFA43, 0xFA43, 0xFA43, 0xFA46, 0xFA50, 0xFA5E, 0xFA70, 0xFA83, 0xFA96, 
	0xFAA8, 0xFAB6, 0xFAC0, 0xFAC4, 0xFABF, 0xFAB2, 0xFA9A, 0xFA75, 0xFA43, 
	0xF9E5, 0xF94E, 0xF88F, 0xF7BA, 0xF6E2, 0xF619, 0xF572, 0xF4FE, 0xF4D1, 
	0xF4CF, 0xF4D4, 0xF4DE, 0xF4EE, 0xF502, 0xF51B, 0xF538, 0xF55A, 0xF57E, 
	0xF5A6, 0xF5EA, 0xF64F, 0xF6D0, 0xF76B, 0xF81D, 0xF8E3, 0xF9B9, 0xFA9C, 
	0xFB8A, 0xFC7F, 0xFD78, 0xFE72, 0xFF6A, 0x005E, 0x0148, 0x0227, 0x02F7, 
	0x03B6, 0x0460, 0x04F1, 0x0568, 0x05C1, 0x05F9, 0x060C, 0x0306, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 
	0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF4F6, 0xF500, 0xF519, 0xF53F, 0xF56D, 
	0xF5A0, 0xF5D2, 0xF600, 0xF626, 0xF640, 0xF649, 0xF63F, 0xF61B, 0xF5DB, 
	0xF57B, 0xF4F6, 0xF404, 0xF27E, 0xF091, 0xEE6C, 0xEC3B, 0xEA2F, 0xE872, 
	0xE735, 0xE6A4, 0xE680, 0xE668, 0xE65D, 0xE65D, 0xE668, 0xE67D, 0xE69B, 
	0xE6C2, 0xE6F0, 0xE726, 0xE79C, 0xE85B, 0xE95C, 0xEA98, 0xEC08, 0xEDA6, 
	0xEF6A, 0xF14D, 0xF349, 0xF557, 0xF76F, 0xF98B, 0xFBA3, 0xFDB2, 0xFFAF, 
	0x0195, 0x035B, 0x04FA, 0x066D, 0x07AD, 0x08B1, 0x0973, 0x09ED, 0x0A17, 
	0x0A90, 0x0001, 0xFFFE, 0xC170, 0xBAEC, 0xBAEB, 0xBAE9, 0xBAE6, 0xBAE3, 
	0xBADF, 0xBADA, 0xBAD4, 0xBACE, 0xBAC8, 0xBAC0, 0xBAB8, 0xBAB0, 0xBAA7, 
	0xBA9E, 0xBA94, 0xBA8A, 0xBA7F, 0xBA75, 0xBA69, 0xBA5E, 0xBA52, 0xBA46, 
	0xBA39, 0xBA2D, 0xBA20, 0xBA13, 0xBA06, 0xB9F9, 0xB9EC, 0xB9DF, 0xB9D1, 
	0xB9C4, 0xB9B7, 0xB9AA, 0xB99D, 0xB990, 0xB983, 0xB976, 0xB969, 0xB95D, 
	0xB951, 0xB945, 0xB93A, 0xB92E, 0xB923, 0xB919, 0xB90F, 0xB905, 0xB8FC, 
	0xB8F3, 0xB8EA, 0xB8E3, 0xB8DB, 0xB8D5, 0xB8CF, 0xB8C9, 0xB8C4, 0xB8C0, 
	0xB8BD, 0xB8BA, 0xB8B8, 0xB8B7, 0xB8B6, 0xB8B7, 0xB8B8, 0xB8BA, 0xB8BD, 
	0xB8C1, 0xB8C6, 0xB8CC, 0xB8D3, 0xB8DB, 0xB8E4, 0xB8EE, 0xB8F9, 0xB906, 
	0xB913, 0xB922, 0xB932, 0xB943, 0xB956, 0xB96A, 0xB97F, 0xB995, 0xB9AD, 
	0xB9C6, 0xB9E1, 0xB9FD, 0xBA1B, 0xBA3A, 0xBA5A, 0xBA7D, 0xBAA0, 0xBAC6, 
	0xBAED, 0xC1E5, 0xCA2C, 0xCCB6, 0xCEDB, 0x50B2, 0x524E, 0x53C6, 0x552E, 
	0x569D, 0x5826, 0x59E1, 0x5BE2, 0x5E3F, 0x610C, 0x6460, 0xE8F5, 0xEF21, 
	0xF658, 0xFE13, 0x05C9, 0x0CF1, 0x1304, 0x1777, 0x19C3, 0x1A5A, 0x1A1C, 
	0x1924, 0x178F, 0x157B, 0x1302, 0x1041, 0x0D54, 0x0A59, 0x076A, 0x04A4, 
	0x0209, 0xFF90, 0xFD35, 0xFAEF, 0xF8B7, 0xF686, 0xF455, 0xF21E, 0xEFD9, 
	0xED7F, 0xEB09, 0xE870, 0xE5AD, 0xE2B9, 0xDF8E, 0xDC23, 0xD872, 0xD474, 
	0xD022, 0xCB75, 0xC666, 0x40EE, 0x3B05, 0x36DA, 0x11FA, 0x11FA, 0x11FA, 
	0x11F9, 0x11F9, 0x11F9, 0x11F8, 0x11F8, 0x11F8, 0x11F7, 0x11F6, 0x11F6, 
	0x11F5, 0x11F5, 0x11F4, 0x11F3, 0x11F2, 0x11F2, 0x11F1, 0x11F0, 0x11EF, 
	0x11EE, 0x11ED, 0x11EC, 0x11EB, 0x11EA, 0x11EA, 0x11E9, 0x11E8, 0x11E7, 
	0x11E6, 0x11E5, 0x11E4, 0x11E3, 0x11E2, 0x11E1, 0x11E0, 0x11DF, 0x11DE, 
	0x11DD, 0x11DC, 0x11DB, 0x11DA, 0x11D9, 0x11D8, 0x11D8, 0x11D7, 0x11D6, 
	0x11D5, 0x11D5, 0x11D4, 0x11D3, 0x11D3, 0x11D2, 0x11D2, 0x11D1, 0x11D1, 
	0x11D0, 0x11D0, 0x11D0, 0x11D0, 0x11D0, 0x11CF, 0x11CF, 0x11CF, 0x11D0, 
	0x11D0, 0x11D0, 0x11D0, 0x11D1, 0x11D1, 0x11D2, 0x11D2, 0x11D3, 0x11D4, 
	0x11D4, 0x11D5, 0x11D6, 0x11D7, 0x11D9, 0x11DA, 0x11DB, 0x11DD, 0x11DE, 
	0x11E0, 0x11E2, 0x11E4, 0x11E6, 0x11E8, 0x11EA, 0x11EC, 0x11EF, 0x11F1, 
	0x11F4, 0x11F7, 0x11FA, 0x11F3, 0x131E, 0x15C3, 0x18D5, 0x63CA, 0x6036, 
	0x5C8D, 0x58ED, 0x5573, 0x523D, 0x4F66, 0x4D0E, 0x4B51, 0x4A4D, 0x4A1F, 
	0x3459, 0x30B1, 0x2B80, 0x255D, 0x1EDE, 0x189A, 0x1327, 0x0F1B, 0x0D0D, 
	0x0C82, 0x0C8D, 0x0D1C, 0x0E1B, 0x0F79, 0x1122, 0x1304, 0x150B, 0x1725, 
	0x193F, 0x1B2A, 0x1CDF, 0x1E61, 0x1FB3, 0x20DB, 0x21DA, 0x22B6, 0x2372, 
	0x2413, 0x249A, 0x250E, 0x2571, 0x25C7, 0x2614, 0x265C, 0x26A3, 0x26EC, 
	0x273C, 0x2796, 0x27FE, 0x2877, 0x2907, 0x5650, 0x558A, 0x54F5, 0x4CB3, 
	0x4CB0, 0x4CAC, 0x4CA6, 0x4C9F, 0x4C96, 0x4C8C, 0x4C80, 0x4C73, 0x4C65, 
	0x4C56, 0x4C46, 0x4C34, 0x4C21, 0x4C0E, 0x4BF9, 0x4BE4, 0x4BCE, 0x4BB7, 
	0x4B9F, 0x4B87, 0x4B6E, 0x4B55, 0x4B3B, 0x4B20, 0x4B06, 0x4AEB, 0x4ACF, 
	0x4AB4, 0x4A98, 0x4A7C, 0x4A60, 0x4A44, 0x4A28, 0x4A0D, 0x49F1, 0x49D6, 
	0x49BB, 0x49A0, 0x4986, 0x496C, 0x4952, 0x4939, 0x4921, 0x4909, 0x48F2, 
	0x48DC, 0x48C7, 0x48B2, 0x489F, 0x488C, 0x487B, 0x486A, 0x485B, 0x484D, 
	0x4840, 0x4834, 0x482A, 0x4822, 0x481A, 0x4814, 0x4810, 0x480E, 0x480D, 
	0x480E, 0x4810, 0x4815, 0x481B, 0x4824, 0x482E, 0x483B, 0x4849, 0x485A, 
	0x486D, 0x4882, 0x489A, 0x48B4, 0x48D1, 0x48F0, 0x4911, 0x4935, 0x495C, 
	0x4986, 0x49B2, 0x49E2, 0x4A14, 0x4A49, 0x4A81, 0x4ABC, 0x4AFA, 0x4B3B, 
	0x4B80, 0x4BC8, 0x4C13, 0x4C61, 0x4CB3, 0x5BC2, 0x6CBF, 0x7076, 0x7354, 
	0xF584, 0xF734, 0xF88D, 0xF9BB, 0xFAEB, 0xFC46, 0xFDFA, 0x0035, 0x031B, 
	0x06DC, 0x0BA2, 0x928D, 0x9C15, 0xA763, 0xB3A6, 0xC009, 0xCBB9, 0xD5E1, 
	0xDDAF, 0xE24F, 0xE470, 0xE567, 0xE55C, 0xE476, 0xE2DC, 0xE0B5, 0xDE29, 
	0xDB5E, 0xD87C, 0xD5A9, 0xD333, 0xD121, 0xCF67, 0xCDF6, 0xCCC2, 0xCBBD, 
	0xCAD9, 0xCA09, 0xC93F, 0xC86E, 0xC789, 0xC682, 0xC54C, 0xC3D8, 0xC21A, 
	0xC005, 0xBD8A, 0xBA9C, 0xB72E, 0xB332, 0xAE9C, 0xA95C, 0x2367, 0x1CAE, 
	0x175C, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFF0, 0xFFC6, 0xFF82, 0xFF27, 
	0xFEB8, 0xFE38, 0xFDA8, 0xFD0C, 0xFC65, 0xFBB7, 0xFB04, 0xFA4F, 0xF999, 
	0xF8E6, 0xF838, 0xF791, 0xF6F5, 0xF665, 0xF5E5, 0xF576, 0xF51B, 0xF4D8, 
	0xF4AD, 0xF49E, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFF7, 0xFFDF, 0xFFB9, 
	0xFF86, 0xFF47, 0xFEFF, 0xFEAE, 0xFE56, 0xFDF9, 0xFD97, 0xFD32, 0xFCCC, 
	0xFC66, 0xFC01, 0xFB9F, 0xFB41, 0xFAE9, 0xFA99, 0xFA50, 0xFA12, 0xF9DF, 
	0xF9B9, 0xF9A1, 0xF999, 0xE52C, 0xE52C, 0xE52C, 0xE52C, 0xE52D, 0xE52D, 
	0xE52E, 0xE52E, 0xE52F, 0xE530, 0xE531, 0xE532, 0xE533, 0xE534, 0xE535, 
	0xE536, 0xE537, 0xE538, 0xE53A, 0xE53B, 0xE53C, 0xE53E, 0xE53F, 0xE541, 
	0xE542, 0xE544, 0xE545, 0xE547, 0xE548, 0xE54A, 0xE54B, 0xE54D, 0xE54F, 
	0xE550, 0xE552, 0xE553, 0xE555, 0xE556, 0xE558, 0xE559, 0xE55B, 0xE55C, 
	0xE55E, 0xE55F, 0xE560, 0xE562, 0xE563, 0xE564, 0xE565, 0xE566, 0xE567, 
	0xE568, 0xE569, 0xE56A, 0xE56B, 0xE56C, 0xE56C, 0xE56D, 0xE56D, 0xE56E, 
	0xE56E, 0xE56E, 0xE56E, 0xE56E, 0xE56E, 0xE56E, 0xE56E, 0xE56E, 0xE56D, 
	0xE56D, 0xE56C, 0xE56B, 0xE56A, 0xE569, 0xE568, 0xE566, 0xE565, 0xE563, 
	0xE562, 0xE560, 0xE55E, 0xE55C, 0xE559, 0xE557, 0xE554, 0xE551, 0xE54E, 
	0xE54B, 0xE548, 0xE544, 0xE541, 0xE53D, 0xE539, 0xE535, 0xE530, 0xE52C, 
	0xE532, 0xE549, 0xE56E, 0xE599, 0xE5C5, 0xE5EE, 0xE60D, 0xE61D, 0xE619, 
	0xE5FB, 0xE5BD, 0xE55B, 0xE4CF, 0xE413, 0xE322, 0xE17F, 0xDEE5, 0xDBA4, 
	0xD80C, 0xD46E, 0xD118, 0xCE5B, 0xCC86, 0xCBE9, 0xCC4D, 0xCD38, 0xCE96, 
	0xD053, 0xD25B, 0xD49A, 0xD6FC, 0xD96C, 0xDBD8, 0xDE2A, 0xDE2A, 0xDE29, 
	0xDE26, 0xDE20, 0xDE17, 0xDE09, 0xDDF5, 0xDDDC, 0xDDBA, 0xDD91, 0xDD5E, 
	0xDD21, 0xDCD9, 0xDC85, 0xDC24, 0xDBB5, 0xDB38, 0xDAAB, 0xDA0D, 0xD95E, 
	0xD89C, 0xD7C7, 0xD6DE, 0xD5DF, 0xCB60, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 0x408F, 
	0x408F, 0x408F, 0x40AE, 0x4102, 0x417E, 0x4215, 0x42B8, 0x435C, 0x43F3, 
	0x446F, 0x44C3, 0x44E2, 0x44BF, 0x444C, 0x437B, 0x4241, 0x408F, 0x3D9C, 
	0x38FA, 0x3325, 0x2C97, 0x25CB, 0x1F3D, 0x1968, 0x14C6, 0x11D3, 0x1021, 
	0x0EE8, 0x0E19, 0x0DA7, 0x0D85, 0x0DA6, 0x0DFC, 0x0E79, 0x0F10, 0x0FB5, 
	0x1058, 0x10EE, 0x1168, 0x11B9, 0x11D3, 0x11DF, 0x1205, 0x123B, 0x1276, 
	0x1275, 0x126E, 0x125A, 0x1234, 0x11F4, 0x1196, 0x1112, 0x1063, 0x0F82, 
	0x0E69, 0x0D12, 0x0B77, 0x0991, 0x075A, 0x04CC, 0xFA42, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 0x122C, 
	0x122C, 0x122C, 0x122C, 0x122C, 0x1229, 0x1220, 0x1213, 0x1204, 0x11F3, 
	0x11E2, 0x11D2, 0x11C5, 0x11BC, 0x11B9, 0x11BD, 0x11C9, 0x11DE, 0x11FF, 
	0x122C, 0x127B, 0x12F6, 0x1391, 0x143F, 0x14F4, 0x15A2, 0x163D, 0x16B8, 
	0x1707, 0x173E, 0x177A, 0x17B8, 0x17F6, 0x182F, 0x1861, 0x188A, 0x18A6, 
	0x18B2, 0x18AB, 0x188E, 0x1859, 0x1808, 0x1798, 0x1707, 0x1636, 0x1513, 
	0x13AD, 0x1215, 0x106C, 0x0EBF, 0x0D12, 0x0B6B, 0x09CE, 0x0840, 0x06C7, 
	0x0568, 0x0427, 0x0309, 0x0215, 0x014E, 0x00B9, 0x005C, 0x003C, 0x0197, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 
	0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x143B, 0x1450, 0x1489, 0x14DD, 
	0x1543, 0x15B2, 0x1621, 0x1687, 0x16DB, 0x1714, 0x1729, 0x1711, 0x16C3, 
	0x1636, 0x1561, 0x143B, 0x123B, 0x0F18, 0x0B24, 0x06B4, 0x0219, 0xFDA9, 
	0xF9B5, 0xF692, 0xF492, 0xF36C, 0xF297, 0xF20A, 0xF1BC, 0xF1A4, 0xF1B9, 
	0xF1F2, 0xF246, 0xF2AC, 0xF31B, 0xF38A, 0xF3F0, 0xF444, 0xF47D, 0xF492, 
	0xF492, 0xF491, 0xF48F, 0xF48D, 0xF4B9, 0xF534, 0xF5F3, 0xF6E9, 0xF809, 
	0xF949, 0xFA9A, 0xFBF2, 0xFD44, 0xFE83, 0xFFA3, 0x009A, 0x0159, 0x01D4, 
	0x0200, 0x0624, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 0xC5E3, 
	0xC5E3, 0xC5E2, 0xC5E1, 0xC5E0, 0xC5DF, 0xC5DD, 0xC5DC, 0xC5DB, 0xC5DB, 
	0xC5DA, 0xC5DB, 0xC5DC, 0xC5DD, 0xC5E0, 0xC5E3, 0xC5ED, 0xC5FF, 0xC616, 
	0xC62A, 0xC641, 0xC659, 0xC65E, 0xC65F, 0xC660, 0xC642, 0xC5E3, 0xC53D, 
	0xC469, 0xC37A, 0xC281, 0xC18E, 0xC0B3, 0xC001, 0xBF8A, 0xBF5E, 0xFADF, 
	0xFE4F, 0x0255, 0x058A, 0x079D, 0x0912, 0x09C9, 0x09AB, 0x08FF, 0x082F, 
	0x07A4, 0x0780, 0x0788, 0x079E, 0x07A4, 0x0790, 0x0771, 0x074A, 0x0721, 
	0x06FA, 0x06DA, 0x06C4, 0x06BF, 0x06CE, 0x06F7, 0x0780, 0x087C, 0x099F, 
	0x0AA0, 0x0B32, 0x0B0A, 0x0A06, 0x085F, 0x0652, 0x041B, 0x01F6, 0x0020, 
	0xFED6, 0xFE52, 0xFF0C, 0x00F6, 0x038E, 0x064F, 0x08B5, 0x0A3C, 0x0A62, 
	0x08DA, 0x0604, 0x0256, 0xFE46, 0xFA4C, 0xF6E0, 0xF477, 0xF389, 0xF3E6, 
	0xF4F8, 0xF69D, 0xF8B4, 0xFB1B, 0xFDB1, 0x0054, 0x02E2, 0x053B, 0x073C, 
	0x08C4, 0x09B1, 0x0A3F, 0x0ABE, 0x0B30, 0x0B94, 0x0BED, 0x0C39, 0x0C7B, 
	0x0CB2, 0x0CDF, 0x0D03, 0x0D1E, 0x0D31, 0x0D3D, 0x0D42, 0x0D41, 0x0D3A, 
	0x0D2F, 0x0D1F, 0x0D0B, 0x0CF4, 0x0CDB, 0x0CC0, 0x0CA4, 0x0C87, 0x0C6A, 
	0x0C4E, 0x0C33, 0x0C1A, 0x0C03, 0x0BF0, 0x09DE, 0x077A, 0x06DA, 0x0664, 
	0x0610, 0x05D7, 0x05B1, 0x0596, 0x0580, 0x056E, 0x0566, 0x0565, 0x056B, 
	0x0576, 0x0583, 0x0592, 0x05A1, 0x05AF, 0x05B8, 0x05BD, 0x05BC, 0x05B2, 
	0x059F, 0x0580, 0x0566, 0x0560, 0x0566, 0x0574, 0x0583, 0x058C, 0x058B, 
	0x0579, 0x0550, 0x050A, 0x04A2, 0x0410, 0x0350, 0x025B, 0x012B, 0xFDF2, 
	0xF82C, 0xF1C4, 0xECA2, 0xECD8, 0xED71, 0xEE5E, 0xEF8E, 0xF0F4, 0xF280, 
	0xF422, 0xF5CC, 0xF76F, 0xF8FA, 0xFA60, 0xFB91, 0xFC7D, 0xFD16, 0xFD4C, 
	0xFE9B, 0xF57A, 0xF57E, 0xF5AF, 0xF62F, 0xF78A, 0xF95E, 0xFA67, 0xFA2A, 
	0xF954, 0xF85A, 0xF7B3, 0xF782, 0xF788, 0xF7A3, 0xF7B3, 0xF7AB, 0xF795, 
	0xF777, 0xF758, 0xF73C, 0xF72B, 0xF728, 0xF73C, 0xF76A, 0xF7BA, 0xF879, 
	0xF9BD, 0xFB38, 0xFC99, 0xFD93, 0xFDD5, 0xFD61, 0xFC81, 0xFB52, 0xF9F3, 
	0xF881, 0xF71A, 0xF5DA, 0xF4E0, 0xF420, 0xF37C, 0xF2F2, 0xF282, 0xF22D, 
	0xF1F1, 0xF1CE, 0xF1CC, 0xF1EB, 0xF224, 0xF26E, 0xF2C0, 0xF312, 0xF35B, 
	0xF393, 0xF3BE, 0xF3E8, 0xF411, 0xF438, 0xF45F, 0xF483, 0xF4A6, 0xF4C8, 
	0xF4E8, 0xF506, 0xF522, 0xF53D, 0xF558, 0xF574, 0xF592, 0xF5B1, 0xF5D1, 
	0xF5F2, 0xF613, 0xF635, 0xF657, 0xF678, 0xF69A, 0xF6BB, 0xF6DB, 0xF6FB, 
	0xF719, 0xF736, 0xF752, 0xF76C, 0xF784, 0xF799, 0xF7AD, 0xF7BE, 0xF7CC, 
	0xF7D7, 0xF7DF, 0xF7E4, 0xF7E5, 0xF7E3, 0xF7DC, 0xF7D1, 0xF5D9, 0xF39D, 
	0xF325, 0xF2DA, 0xF2B4, 0xF2A5, 0xF2A5, 0xF2A9, 0xF2A5, 0xF297, 0xF285, 
	0xF270, 0xF25A, 0xF245, 0xF230, 0xF21F, 0xF212, 0xF20A, 0xF20A, 0xF212, 
	0xF225, 0xF242, 0xF26C, 0xF2A5, 0xF2F6, 0xF366, 0xF3EF, 0xF48C, 0xF537, 
	0xF5EB, 0xF6A2, 0xF756, 0xF801, 0xF89F, 0xF929, 0xF99B, 0xF9ED, 0xFA1B, 
	0xFA20, 0xF8EE, 0xF645, 0xF353, 0xF148, 0xF144, 0xF141, 0xF13F, 0xF13D, 
	0xF13C, 0xF13C, 0xF13C, 0xF13C, 0xF13C, 0xF13C, 0xF13B, 0xF139, 0xF137, 
	0xF134, 0xF130, 0xEFF9, 0xA752, 0xAE56, 0xB548, 0xB849, 0xB2C4, 0xA888, 
	0xA248, 0xA32F, 0xA715, 0xABB7, 0xAECE, 0xAFA8, 0xAF83, 0xAF04, 0xAECE, 
	0xAF20, 0xAFB7, 0xB078, 0xB146, 0xB203, 0xB294, 0xB2DB, 0xB2BC, 0xB21B, 
	0xB0DB, 0xAD5A, 0xA72A, 0x9FF9, 0x9976, 0x9551, 0x9537, 0x99BA, 0xA183, 
	0xAB67, 0xB63D, 0xC0D9, 0xCA11, 0xD0BA, 0xD3AC, 0xD13C, 0xC9DB, 0xBF7E, 
	0xB41F, 0xA9B5, 0xA238, 0x9F9E, 0xA2BE, 0xAA1E, 0xB43A, 0xBF93, 0xCAA6, 
	0xD3F3, 0xD9F8, 0xDB33, 0xD82A, 0xD2B3, 0xCB45, 0xC25B, 0xB86E, 0xADF7, 
	0xA370, 0x9951, 0x9014, 0x8832, 0x8225, 0x7E63, 0x7C11, 0x79FB, 0x781E, 
	0x7678, 0x7506, 0x73C5, 0x72B3, 0x71CD, 0x7110, 0x707A, 0x7008, 0x6FB8, 
	0x6F87, 0x6F72, 0x6F76, 0x6F91, 0x6FC1, 0x7002, 0x7052, 0x70AF, 0x7115, 
	0x7183, 0x71F5, 0x7268, 0x72DB, 0x734A, 0x73B4, 0x7414, 0x7469, 0x74B0, 
	0x7CE0, 0x8647, 0x888C, 0x8A22, 0x8B2B, 0x8BCC, 0x8C29, 0x8C63, 0x8CA0, 
	0x8CF0, 0x8D4A, 0x8DA8, 0x8E06, 0x8E5F, 0x8EAE, 0x8EEE, 0x8F1B, 0x8F2F, 
	0x8F27, 0x8EFD, 0x8EAB, 0x8E2F, 0x8D82, 0x8CA0, 0x8B68, 0x89C6, 0x87CC, 
	0x858D, 0x831A, 0x8085, 0x7DDE, 0x7B3B, 0x78AC, 0x7643, 0x7411, 0x7228, 
	0x709B, 0x6F7B, 0x6ED9, 0x70DB, 0x7678, 0x7E04, 0x85D1, 0x85D1, 0x85D1, 
	0x85CF, 0x85CB, 0x85C4, 0x85BB, 0x85AD, 0x859B, 0x8584, 0x8568, 0x8545, 
	0x851B, 0x84E9, 0x84AF, 0x846C, 0x839E, 0xFFFF, 0x0000, 0x0000, 0x0001, 
	0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0008, 0x0009, 0x000B, 
	0x000D, 0x000F, 0x0011, 0x0013, 0x0015, 0x0018, 0x001A, 0x001D, 0x0020, 
	0x0022, 0x0026, 0x0029, 0x002C, 0x002F, 0x0033, 0x0036, 0x003A, 0x003E, 
	0x0042, 0x0045, 0x004A, 0x004E, 0x0052, 0x0056, 0x005B, 0x005F, 0x0064, 
	0x0068, 0x006D, 0x0072, 0x0076, 0x007B, 0x0080, 0x0085, 0x008A, 0x0090, 
	0x0095, 0x009A, 0x009F, 0x00A5, 0x00AA, 0x00B0, 0x00B5, 0x00BB, 0x00C1, 
	0x00C6, 0x00CC, 0x00D2, 0x00D7, 0x00DD, 0x00E3, 0x00E9, 0x00EF, 0x00F5, 
	0x00FB, 0x0101, 0x0106, 0x010C, 0x0112, 0x0118, 0x011E, 0x0124, 0x012B, 
	0x0131, 0x0137, 0x013D, 0x0143, 0x0149, 0x014F, 0x0155, 0x015B, 0x0161, 
	0x0167, 0x016D, 0x0172, 0x0178, 0x017E, 0x0184, 0x018A, 0x0190, 0x0196, 
	0x019B, 0x01A1, 0x01A7, 0x01AC, 0x01B2, 0x01B7, 0x01BD, 0x01C2, 0x01C8, 
	0x01CD, 0x01D2, 0x01D7, 0x01DD, 0x01E2, 0x01E7, 0x01EC, 0x01F1, 0x01F6, 
	0x01FA, 0x01FF, 0x0204, 0x0208, 0x020D, 0x0211, 0x0215, 0x0219, 0x021E, 
	0x0222, 0x0226, 0x0229, 0x022D, 0x0231, 0x0234, 0x0238, 0x023B, 0x023E, 
	0x0242, 0x0245, 0x0248, 0x024A, 0x024D, 0x0250, 0x0252, 0x0254, 0x0257, 
	0x0259, 0x025B, 0x025C, 0x025E, 0x0260, 0x0261, 0x0262, 0x0263, 0x0264, 
	0x0265, 0x0266, 0x0266, 0x0267, 0x0267, 0x0267, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFFA, 0xFFF9, 
	0xFFF7, 0xFFF6, 0xFFF5, 0xFFF3, 0xFFF1, 0xFFEF, 0xFFED, 0xFFEB, 0xFFE9, 
	0xFFE7, 0xFFE5, 0xFFE2, 0xFFE0, 0xFFDD, 0xFFDB, 0xFFD8, 0xFFD5, 0xFFD2, 
	0xFFCF, 0xFFCC, 0xFFC9, 0xFFC5, 0xFFC2, 0xFFBF, 0xFFBB, 0xFFB7, 0xFFB4, 
	0xFFB0, 0xFFAC, 0xFFA9, 0xFFA5, 0xFFA1, 0xFF9D, 0xFF99, 0xFF94, 0xFF90, 
	0xFF8C, 0xFF88, 0xFF83, 0xFF7F, 0xFF7B, 0xFF76, 0xFF72, 0xFF6D, 0xFF68, 
	0xFF64, 0xFF5F, 0xFF5A, 0xFF56, 0xFF51, 0xFF4C, 0xFF47, 0xFF42, 0xFF3E, 
	0xFF39, 0xFF34, 0xFF2F, 0xFF2A, 0xFF25, 0xFF20, 0xFF1B, 0xFF16, 0xFF11, 
	0xFF0C, 0xFF07, 0xFF02, 0xFEFD, 0xFEF8, 0xFEF3, 0xFEEE, 0xFEE9, 0xFEE4, 
	0xFEDF, 0xFEDA, 0xFED5, 0xFED0, 0xFECB, 0xFEC6, 0xFEC2, 0xFEBD, 0xFEB8, 
	0xFEB3, 0xFEAE, 0xFEA9, 0xFEA5, 0xFEA0, 0xFE9B, 0xFE97, 0xFE92, 0xFE8E, 
	0xFE89, 0xFE85, 0xFE80, 0xFE7C, 0xFE77, 0xFE73, 0xFE6F, 0xFE6B, 0xFE67, 
	0xFE63, 0xFE5F, 0xFE5B, 0xFE57, 0xFE53, 0xFE4F, 0xFE4B, 0xFE48, 0xFE44, 
	0xFE41, 0xFE3D, 0xFE3A, 0xFE37, 0xFE33, 0xFE30, 0xFE2D, 0xFE2A, 0xFE27, 
	0xFE25, 0xFE22, 0xFE1F, 0xFE1D, 0xFE1A, 0xFE18, 0xFE16, 0xFE14, 0xFE12, 
	0xFE10, 0xFE0E, 0xFE0C, 0xFE0B, 0xFE09, 0xFE08, 0xFE06, 0xFE05, 0xFE04, 
	0xFE03, 0xFE02, 0xFE02, 0xFE01, 0xFE01, 0xFE00, 0xFE00, 0xFE00, 0xFFFF, 
	0x455B, 0x449E, 0x4385, 0x422B, 0x40AC, 0x3F22, 0x3DAB, 0x3C60, 0x3B5D, 
	0x3ABF, 0x3AA0, 0x3D2C, 0x4261, 0x4712, 0x4812, 0x4494, 0x3EA8, 0x376D, 
	0x3001, 0x2983, 0x2361, 0x1DC1, 0x1AD8, 0x1A11, 0x195F, 0x18C2, 0x183E, 
	0x17D4, 0x1785, 0x1754, 0x1743, 0x1753, 0x1786, 0x17DF, 0x185E, 0x1906, 
	0x19D9, 0x1AD8, 0x1D2D, 0x215C, 0x2672, 0x2B7E, 0x2F8C, 0x31A9, 0x3277, 
	0x3339, 0x33EF, 0x349B, 0x353B, 0x35D2, 0x365E, 0x36E2, 0x375C, 0x37CD, 
	0x3837, 0x3899, 0x38F3, 0x3947, 0x3994, 0x39DB, 0x3A1C, 0x3A58, 0x3A8F, 
	0x3AC2, 0x3AF1, 0x3B1C, 0x3B45, 0x3B6A, 0x3B8D, 0x3BAE, 0x3BCE, 0x3BED, 
	0x3C0B, 0x3C29, 0x3C47, 0x3C66, 0x3C85, 0x3CA7, 0x3CCA, 0x3CCF, 0x3C9C, 
	0x3C3B, 0x3BB6, 0x3B16, 0x3A64, 0x39AB, 0x38F4, 0x3847, 0x37B0, 0x3738, 
	0x36E7, 0x36C9, 0x36E5, 0x3747, 0x37F7, 0x38FF, 0x46F7, 0x53E2, 0x4FAE, 
	0x46DF, 0x3C86, 0x33B3, 0x2C39, 0x25A3, 0x2296, 0x2335, 0x256C, 0x2884, 
	0x2BC9, 0x2E87, 0x3008, 0x2F76, 0x2D47, 0x2ABE, 0x291B, 0x28C4, 0x2903, 
	0x296D, 0x2998, 0x291B, 0x280F, 0x26DC, 0x2588, 0x241B, 0x229B, 0x2110, 
	0x1F82, 0x1DF8, 0x1C78, 0x1B0B, 0x19B7, 0x1883, 0x1777, 0x169B, 0x15F5, 
	0x16EE, 0x19D6, 0x1D0E, 0x1EF9, 0x209F, 0x225E, 0x243A, 0x2635, 0x2852, 
	0x2A93, 0x2CFC, 0x2F8F, 0x324F, 0x353F, 0x3862, 0x3BBA, 0x3F4A, 0x4315, 
	0x471D, 0x49EE, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0002, 0x0004, 0x0007, 0x000A, 0x000E, 0x0011, 0x0013, 0x0015, 0x0015, 
	0x0015, 0x0012, 0x000E, 0x0008, 0xFFFF, 0xFFF2, 0xFFDE, 0xFFC5, 0xFFA9, 
	0xFF89, 0xFF69, 0xFF48, 0xFF29, 0xFF0C, 0xFEF2, 0xFEDE, 0xFED0, 0xFECA, 
	0xFECC, 0xFED8, 0xFF4F, 0x0038, 0x010F, 0x0153, 0x0101, 0x0025, 0xFEE8, 
	0xFD72, 0xFBEC, 0xFA7C, 0xF94C, 0xF868, 0xF7BD, 0xF743, 0xF6F0, 0xF6BE, 
	0xF6A5, 0xF69B, 0xF69A, 0xF792, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFF9, 
	0xFFF8, 0xFFF8, 0xFFF8, 0xFFF9, 0xFFFA, 0xFFFC, 0xFFFF, 0x0005, 0x000F, 
	0x001B, 0x002A, 0x003A, 0x004A, 0x005A, 0x0069, 0x0076, 0x0080, 0x0086, 
	0x0087, 0x0083, 0x0079, 0x0068, 0x0010, 0xFF68, 0xFEC1, 0xFE6C, 0xFE4D, 
	0xFE35, 0xFE24, 0xFE19, 0xFE11, 0xFE0D, 0xFE0A, 0xFE08, 0xFE04, 0xFDFA, 
	0xFDE6, 0xFDC6, 0xFD96, 0xFD53, 0xFCF9, 0x03C6, 0xD716, 0xD73A, 0xD76C, 
	0xD7A3, 0xD7D7, 0xD801, 0xD817, 0xD811, 0xD7E8, 0xD792, 0xD708, 0xD529, 
	0xD1E0, 0xCEB9, 0xCD41, 0xCD24, 0xCD09, 0xCCEF, 0xCCD7, 0xCCBF, 0xCCAA, 
	0xCC95, 0xCC82, 0xCC70, 0xCC5F, 0xCC4F, 0xCC41, 0xCC33, 0xCC27, 0xCC1C, 
	0xCC12, 0xCC09, 0xCC00, 0xCBF9, 0xCBF3, 0xCBEE, 0xCBE9, 0xCBE6, 0xCBE3, 
	0xCBE1, 0xCBE0, 0xCBE0, 0xCBE0, 0xCBE1, 0xCBE3, 0xCBE5, 0xCBE8, 0xCBEC, 
	0xCBF0, 0xCBF5, 0xCBFA, 0xCC00, 0xCC06, 0xCC0C, 0xCC13, 0xCC1B, 0xCC22, 
	0xCC2A, 0xCC33, 0xCC3B, 0xCC44, 0xCC4D, 0xCC56, 0xCC60, 0xCC69, 0xCC73, 
	0xCC7D, 0xCC87, 0xCC90, 0xCC9A, 0xCCA4, 0xCCAE, 0xCCB7, 0xCCC1, 0xCCCA, 
	0xCCD4, 0xCCDD, 0xCCE5, 0xCCEE, 0xCCF6, 0xCCFE, 0xCD06, 0xCD0D, 0xCD14, 
	0xCD1B, 0xCD21, 0xCD27, 0xCD2C, 0xCD31, 0xCD35, 0xCD39, 0xCD3C, 0xCD3E, 
	0xCD40, 0xCD41, 0xCD41, 0xCD41, 0xCD41, 0xCD41, 0xCD41, 0xCD41, 0xCD41, 
	0xCD41, 0xCD41, 0xCD41, 0xCD3E, 0xCD34, 0xCD26, 0xCD16, 0xCD03, 0xCCF1, 
	0xCCE0, 0xCCD2, 0xCCC9, 0xCCC6, 0xCCC9, 0xCCD6, 0xCCEE, 0xCD11, 0xCD41, 
	0xCD86, 0xCDE1, 0xCE50, 0xCECF, 0xCF58, 0xCFE9, 0xD07E, 0xD112, 0xD1A2, 
	0xD229, 0xD2A4, 0xD30E, 0xD364, 0xD3A2, 0xD3C4, 0xD353, 0xD217, 0xD068, 
	0xCEA1, 0xCC85, 0xCA1E, 0xC793, 0xC50C, 0xC2B1, 0xC0A8, 0xBF1A, 0xBE17, 
	0xBD53, 0xBC6C, 0xBB00, 0xB8AD, 0xB50F, 0xAFC5, 0xA86C, 0xAB92, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x0414, 0x04FA, 0x05E3, 0x0652, 0x05C1, 
	0x04A2, 0x03F1, 0x0407, 0x0470, 0x04ED, 0x0540, 0x052A, 0x04DC, 0x04BF, 
	0x0540, 0x0669, 0x07E7, 0x0998, 0x0B5D, 0x0D15, 0x0EA0, 0x0FDC, 0x10AA, 
	0x1106, 0x1110, 0x10D6, 0x1069, 0x0FD9, 0x0F35, 0x0E8E, 0x0DF3, 0x0D68, 
	0x0CDF, 0x0C4F, 0x0BAD, 0x0AF0, 0x0A0C, 0x08F9, 0x07AB, 0x05DE, 0x0380, 
	0x00D6, 0xFE23, 0xFBAB, 0xF9B1, 0xF87A, 0xF808, 0xF81E, 0xF899, 0xF959, 
	0xFA3C, 0xFB20, 0xFBE4, 0xFC67, 0xFCBF, 0xFD16, 0xFD6C, 0xFDBF, 0xFE0D, 
	0xFE56, 0xFE98, 0xFED2, 0xFF02, 0xFF27, 0xFF3F, 0xFF4A, 0xFF4B, 0xFF47, 
	0xFF3D, 0xFF2F, 0xFF1C, 0xFF06, 0xFEEC, 0xFED0, 0xFEB1, 0xFE90, 0xFE6E, 
	0xFE4A, 0xFE26, 0xFE02, 0xFDDE, 0xFDBA, 0xFD98, 0xFD77, 0xFD58, 0xFD3C, 
	0xFD22, 0xFD0C, 0xFCF9, 0xFCEB, 0xFCE1, 0xFCDC, 0xFCDD, 0xFCE4, 0xFCF1, 
	0xFD05, 0xFF76, 0x023A, 0x02D7, 0x033C, 0x0377, 0x0392, 0x039C, 0x039F, 
	0x03A8, 0x03BA, 0x03CD, 0x03E1, 0x03F5, 0x0407, 0x0418, 0x0425, 0x042D, 
	0x0431, 0x042F, 0x0426, 0x0415, 0x03FB, 0x03D7, 0x03A8, 0x0365, 0x0307, 
	0x0294, 0x0210, 0x0181, 0x00EA, 0x0051, 0xFFBB, 0xFF2C, 0xFEAA, 0xFE3A, 
	0xFDDF, 0xFDA0, 0xFD80, 0xFD85, 0xFE05, 0xFF39, 0x00FD, 0x032C, 0x0321, 
	0x0303, 0x02D4, 0x0297, 0x0250, 0x0202, 0x01AF, 0x015A, 0x0107, 0x00B9, 
	0x0071, 0x0035, 0x0006, 0xFFE7, 0xFFDC, 0x01C0, 0x04F1, 0x03B8, 0x027D, 
	0x01EA, 0x02B7, 0x0449, 0x054E, 0x054D, 0x04E4, 0x045C, 0x0403, 0x03E5, 
	0x03DC, 0x03E6, 0x0403, 0x044D, 0x04CD, 0x0566, 0x05F9, 0x0669, 0x069A, 
	0x066D, 0x05C5, 0x0445, 0x01E0, 0xFEF3, 0xFBDB, 0xF8F6, 0xF69F, 0xF535, 
	0xF514, 0xF69E, 0xF9A7, 0xFDB0, 0x023F, 0x06D5, 0x0AF7, 0x0E27, 0x0FEA, 
	0x1001, 0x0EC2, 0x0C94, 0x09DA, 0x06FB, 0x045B, 0x025F, 0x00C3, 0xFF10, 
	0xFD61, 0xFBD2, 0xFA7E, 0xF981, 0xF8F6, 0xF8F9, 0xF986, 0xFA7D, 0xFBC8, 
	0xFD53, 0xFF08, 0x00D2, 0x029E, 0x0456, 0x05E5, 0x0737, 0x0836, 0x08CE, 
	0x0925, 0x0970, 0x09AE, 0x09E2, 0x0A0B, 0x0A2A, 0x0A40, 0x0A4E, 0x0A54, 
	0x0A52, 0x0A4A, 0x0A3C, 0x0A29, 0x0A12, 0x09F7, 0x09D8, 0x09B7, 0x0994, 
	0x0970, 0x094B, 0x0927, 0x0903, 0x08E1, 0x08C1, 0x08A4, 0x088A, 0x0874, 
	0x0863, 0x0858, 0x0852, 0x0871, 0x088D, 0x0881, 0x086E, 0x0857, 0x083F, 
	0x0829, 0x0817, 0x080D, 0x0808, 0x0807, 0x0807, 0x0809, 0x080C, 0x0810, 
	0x0815, 0x0819, 0x081C, 0x081F, 0x0820, 0x081F, 0x081C, 0x0816, 0x080D, 
	0x0804, 0x07FE, 0x07FA, 0x07F8, 0x07F5, 0x07F0, 0x07E9, 0x07DE, 0x07CE, 
	0x07B7, 0x0799, 0x0772, 0x0742, 0x0706, 0x06BD, 0x05F1, 0x0486, 0x0304, 
	0x01F4, 0x01F5, 0x01FB, 0x020B, 0x022A, 0x025D, 0x02A9, 0x0313, 0x03A1, 
	0x0457, 0x0539, 0x064F, 0x079B, 0x0924, 0x0AEE, 0x0CFE, 0x1192, 0xC3DD, 
	0xCD67, 0xD703, 0xDB8E, 0xD56A, 0xC94F, 0xC196, 0xC1EF, 0xC58A, 0xCA06, 
	0xCCFF, 0xCE0F, 0xCE68, 0xCE0C, 0xCCFF, 0xCB0F, 0xC84B, 0xC518, 0xC1DA, 
	0xBEF4, 0xBCCC, 0xBBC5, 0xBC43, 0xBF36, 0xC4A6, 0xCB99, 0xD318, 0xDA2B, 
	0xDFD8, 0xE327, 0xE321, 0xDEA0, 0xD613, 0xCAE1, 0xBE6E, 0xB21E, 0xA759, 
	0x9F81, 0x9BFD, 0x9E89, 0xA687, 0xB1D8, 0xBE5B, 0xC9F1, 0xD279, 0xD5D5, 
	0xD3DC, 0xCE78, 0xC6A3, 0xBD56, 0xB38A, 0xAA38, 0xA25B, 0x9CEA, 0x9948, 
	0x9626, 0x9378, 0x9131, 0x8F46, 0x8DAA, 0x8C51, 0x8B2F, 0x8A38, 0x895E, 
	0x8897, 0x87D6, 0x8714, 0x8652, 0x8592, 0x84D4, 0x8419, 0x8361, 0x82AE, 
	0x81FF, 0x8156, 0x80B3, 0x8018, 0x7F80, 0x7EF3, 0x7E6F, 0x7DF5, 0x7D85, 
	0x7D1F, 0x7CC5, 0x7C77, 0x7C37, 0x7C03, 0x7BDE, 0x7BC7, 0x7BC0, 0x7BCA, 
	0x7BE4, 0x7C0F, 0x7C4D, 0x7C9D, 0x7D02, 0x8888, 0x9597, 0x9887, 0x9A72, 
	0x9B93, 0x9C23, 0x9C5B, 0x9C73, 0x9CA5, 0x9D06, 0x9D7C, 0x9E01, 0x9E8C, 
	0x9F14, 0x9F92, 0x9FFC, 0xA04A, 0xA074, 0xA072, 0xA03B, 0x9FC6, 0x9F0C, 
	0x9E04, 0x9CA5, 0x9AA5, 0x97D5, 0x945D, 0x9063, 0x8C0D, 0x8783, 0x82EB, 
	0x7E68, 0x7A26, 0x764A, 0x72F9, 0x705A, 0x6E93, 0x6DCC, 0x6E2B, 0x747D, 
	0x8299, 0x942C, 0xA4E9, 0xA4E7, 0xA4D4, 0xA4A3, 0xA442, 0xA3A2, 0xA2B4, 
	0xA168, 0x9FAE, 0x9D76, 0x9AB1, 0x974F, 0x9341, 0x8E76, 0x88DE, 0x826C, 
	0x842B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFB, 
	0xFFFA, 0xFFF9, 0xFFF8, 0xFFF6, 0xFFF4, 0xFFF3, 0xFFF1, 0xFFEF, 0xFFED, 
	0xFFEA, 0xFFE8, 0xFFE5, 0xFFE3, 0xFFE0, 0xFFDD, 0xFFDA, 0xFFD7, 0xFFD4, 
	0xFFD1, 0xFFCD, 0xFFCA, 0xFFC6, 0xFFC2, 0xFFBF, 0xFFBB, 0xFFB7, 0xFFB3, 
	0xFFAF, 0xFFAA, 0xFFA6, 0xFFA2, 0xFF9D, 0xFF99, 0xFF94, 0xFF8F, 0xFF8B, 
	0xFF86, 0xFF81, 0xFF7C, 0xFF77, 0xFF72, 0xFF6D, 0xFF68, 0xFF62, 0xFF5D, 
	0xFF58, 0xFF52, 0xFF4D, 0xFF47, 0xFF42, 0xFF3C, 0xFF37, 0xFF31, 0xFF2B, 
	0xFF26, 0xFF20, 0xFF1A, 0xFF14, 0xFF0F, 0xFF09, 0xFF03, 0xFEFD, 0xFEF7, 
	0xFEF1, 0xFEEB, 0xFEE5, 0xFEE0, 0xFEDA, 0xFED4, 0xFECE, 0xFEC8, 0xFEC2, 
	0xFEBC, 0xFEB6, 0xFEB0, 0xFEAA, 0xFEA4, 0xFE9F, 0xFE99, 0xFE93, 0xFE8D, 
	0xFE87, 0xFE82, 0xFE7C, 0xFE76, 0xFE70, 0xFE6B, 0xFE65, 0xFE60, 0xFE5A, 
	0xFE55, 0xFE4F, 0xFE4A, 0xFE45, 0xFE3F, 0xFE3A, 0xFE35, 0xFE30, 0xFE2B, 
	0xFE26, 0xFE21, 0xFE1C, 0xFE17, 0xFE12, 0xFE0D, 0xFE09, 0xFE04, 0xFE00, 
	0xFDFB, 0xFDF7, 0xFDF3, 0xFDEF, 0xFDEB, 0xFDE7, 0xFDE3, 0xFDDF, 0xFDDB, 
	0xFDD8, 0xFDD4, 0xFDD1, 0xFDCE, 0xFDCA, 0xFDC7, 0xFDC4, 0xFDC2, 0xFDBF, 
	0xFDBC, 0xFDBA, 0xFDB7, 0xFDB5, 0xFDB3, 0xFDB1, 0xFDAF, 0xFDAD, 0xFDAB, 
	0xFDAA, 0xFDA9, 0xFDA7, 0xFDA6, 0xFDA5, 0xFDA4, 0xFDA4, 0xFDA3, 0xFDA3, 
	0xFDA3, 0xFDA3, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFC, 0xFFFA, 0xFFF7, 
	0xFFF4, 0xFFF0, 0xFFEC, 0xFFE7, 0xFFE1, 0xFFDB, 0xFFD4, 0xFFCD, 0xFFC5, 
	0xFFBD, 0xFFB4, 0xFFAB, 0xFFA1, 0xFF97, 0xFF8D, 0xFF81, 0xFF76, 0xFF6A, 
	0xFF5D, 0xFF51, 0xFF43, 0xFF35, 0xFF27, 0xFF19, 0xFF0A, 0xFEFB, 0xFEEB, 
	0xFEDB, 0xFECA, 0xFEBA, 0xFEA9, 0xFE97, 0xFE85, 0xFE73, 0xFE61, 0xFE4E, 
	0xFE3B, 0xFE28, 0xFE15, 0xFE01, 0xFDED, 0xFDD9, 0xFDC4, 0xFDAF, 0xFD9A, 
	0xFD85, 0xFD70, 0xFD5A, 0xFD44, 0xFD2E, 0xFD18, 0xFD02, 0xFCEB, 0xFCD5, 
	0xFCBE, 0xFCA7, 0xFC90, 0xFC79, 0xFC61, 0xFC4A, 0xFC33, 0xFC1B, 0xFC03, 
	0xFBEC, 0xFBD4, 0xFBBC, 0xFBA4, 0xFB8C, 0xFB74, 0xFB5C, 0xFB45, 0xFB2D, 
	0xFB15, 0xFAFD, 0xFAE5, 0xFACD, 0xFAB5, 0xFA9D, 0xFA85, 0xFA6E, 0xFA56, 
	0xFA3E, 0xFA27, 0xFA10, 0xF9F8, 0xF9E1, 0xF9CA, 0xF9B3, 0xF99C, 0xF986, 
	0xF96F, 0xF959, 0xF943, 0xF92D, 0xF917, 0xF901, 0xF8EC, 0xF8D7, 0xF8C2, 
	0xF8AD, 0xF898, 0xF884, 0xF870, 0xF85C, 0xF849, 0xF836, 0xF823, 0xF810, 
	0xF7FE, 0xF7EC, 0xF7DA, 0xF7C8, 0xF7B7, 0xF7A7, 0xF796, 0xF786, 0xF777, 
	0xF767, 0xF758, 0xF74A, 0xF73C, 0xF72E, 0xF721, 0xF714, 0xF707, 0xF6FB, 
	0xF6F0, 0xF6E4, 0xF6DA, 0xF6D0, 0xF6C6, 0xF6BD, 0xF6B4, 0xF6AC, 0xF6A4, 
	0xF69D, 0xF696, 0xF690, 0xF68A, 0xF685, 0xF681, 0xF67D, 0xF67A, 0xF677, 
	0xF675, 0xF673, 0xF672, 0xF672, 0x0000, 0x3358, 0x32D2, 0x3205, 0x3101, 
	0x2FD5, 0x2E91, 0x2D44, 0x2BFF, 0x2ACF, 0x29C5, 0x28F1, 0x28E3, 0x2981, 
	0x29D7, 0x28F1, 0x26A2, 0x2395, 0x2019, 0x1C7D, 0x190F, 0x161E, 0x13FA, 
	0x12F0, 0x12F4, 0x13B4, 0x151B, 0x1711, 0x1982, 0x1C57, 0x1F7A, 0x22D4, 
	0x28FE, 0x31F2, 0x39AB, 0x3C27, 0x35C1, 0x2978, 0x1D3F, 0x1703, 0x166E, 
	0x1708, 0x1892, 0x1ACD, 0x1D7B, 0x205E, 0x2337, 0x25C8, 0x27D2, 0x2917, 
	0x2959, 0x26AF, 0x20CE, 0x19E5, 0x1423, 0x11B7, 0x122B, 0x1377, 0x156F, 
	0x17E8, 0x1AB6, 0x1DAC, 0x20A1, 0x2367, 0x25D4, 0x27BB, 0x28F1, 0x297A, 
	0x298A, 0x2936, 0x2898, 0x27C7, 0x26DB, 0x25EB, 0x2510, 0x2462, 0x23F7, 
	0x23E8, 0x244D, 0x24F8, 0x25AA, 0x2668, 0x2732, 0x280B, 0x28F6, 0x29F5, 
	0x2B09, 0x2C36, 0x2D7D, 0x2EE1, 0x3064, 0x3208, 0x33D0, 0x35BD, 0x37D3, 
	0x3A13, 0x3C7F, 0x4B10, 0x5692, 0x4EA3, 0x410B, 0x324B, 0x26E7, 0x20A6, 
	0x1DB2, 0x1D20, 0x1E3C, 0x2089, 0x236F, 0x2655, 0x28A3, 0x29C1, 0x28AB, 
	0x25C1, 0x227F, 0x2062, 0x1F49, 0x1E55, 0x1DEF, 0x1E7C, 0x2062, 0x236C, 
	0x270B, 0x2B22, 0x2F92, 0x343F, 0x390A, 0x3DD7, 0x4287, 0x46FE, 0x4B1D, 
	0x4EC8, 0x51E0, 0x5448, 0x55E3, 0x5692, 0x5247, 0x4773, 0x39BA, 0x2CBF, 
	0x2CE8, 0x2D60, 0x2E23, 0x2F2D, 0x307A, 0x3205, 0x33C9, 0x35C4, 0x37F0, 
	0x3A49, 0x3CCB, 0x3F72, 0x423A, 0x451D, 0x4819, 0x4A21, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0001, 0x0003, 0x0005, 0x0007, 
	0x0009, 0x000C, 0x000D, 0x000E, 0x000F, 0x000E, 0x000D, 0x000A, 0x0006, 
	0x0000, 0xFFF6, 0xFFE8, 0xFFD7, 0xFFC3, 0xFFAD, 0xFF96, 0xFF80, 0xFF6A, 
	0xFF56, 0xFF44, 0xFF36, 0xFF2B, 0xFF27, 0xFF28, 0xFF30, 0xFF66, 0xFFD5, 
	0x0056, 0x00C0, 0x006E, 0xFF9B, 0xFE7B, 0xFD42, 0xFC22, 0xFB50, 0xFAFE, 
	0xFB01, 0xFB15, 0xFB4C, 0xFBB7, 0xFC66, 0xFD6C, 0xFED9, 0x00C0, 0x09D3, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0001, 
	0x0001, 0x0000, 0x0000, 0x0000, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFA, 0xFFF9, 
	0xFFF8, 0xFFF6, 0xFFF4, 0xFFF2, 0xFFF0, 0xFFED, 0xFFEA, 0xFFE6, 0xFFE2, 
	0xFFDA, 0xFFCD, 0xFFBF, 0xFFB2, 0xFFA0, 0xFF88, 0xFF6F, 0xFF56, 0xFF41, 
	0xFF33, 0xFF2D, 0xFF33, 0xFF42, 0xFF57, 0xFF70, 0xFF88, 0xFF9D, 0xFFAC, 
	0xFFB2, 0xFE32, 0xC595, 0xC595, 0xC595, 0xC595, 0xC595, 0xC595, 0xC595, 
	0xC595, 0xC595, 0xC595, 0xC595, 0xC552, 0xC4E3, 0xC4CC, 0xC595, 0xC740, 
	0xC95E, 0xCBC3, 0xCE48, 0xD0C1, 0xD306, 0xD4EC, 0xD649, 0xD6F9, 0xD714, 
	0xD6CB, 0xD650, 0xD5D3, 0xD588, 0xD59F, 0xD649, 0xD7B7, 0xD9CE, 0xDC4F, 
	0xDEFD, 0xE199, 0xE3E5, 0xE5A3, 0xE695, 0xE709, 0xE777, 0xE7DD, 0xE83D, 
	0xE895, 0xE8E5, 0xE92E, 0xE96E, 0xE9A5, 0xE9D4, 0xE9FA, 0xEA16, 0xEA29, 
	0xEA31, 0xEA30, 0xEA23, 0xEA0C, 0xE9EA, 0xE9BD, 0xE984, 0xE93F, 0xE8ED, 
	0xE88F, 0xE825, 0xE7AD, 0xE728, 0xE695, 0xE5F2, 0xE53C, 0xE474, 0xE39C, 
	0xE2B5, 0xE1BF, 0xE0BB, 0xDFAB, 0xDE90, 0xDD6B, 0xDC3C, 0xDB06, 0xD9C8, 
	0xD884, 0xD73B, 0xD5EE, 0xD49E, 0xD34C, 0xD1F9, 0xD0A7, 0xCF55, 0xCE06, 
	0xCCBA, 0xCB73, 0xCA31, 0xC8F5, 0xC7C1, 0xC695, 0xC573, 0xC45C, 0xC417, 
	0xC45C, 0xC45C, 0xC45C, 0xC45C, 0xC45C, 0xC45C, 0xC45C, 0xC45C, 0xC45D, 
	0xC461, 0xC468, 0xC46F, 0xC477, 0xC47F, 0xC486, 0xC48C, 0xC490, 0xC492, 
	0xC490, 0xC48B, 0xC480, 0xC471, 0xC45C, 0xC450, 0xC458, 0xC46E, 0xC48D, 
	0xC4AE, 0xC4CC, 0xC4E2, 0xC4E8, 0xC4D9, 0xC4B0, 0xC466, 0xC3F5, 0xC358, 
	0xC289, 0xC182, 0xBED4, 0xBA08, 0xB494, 0xAFE8, 0xABF7, 0xA8A7, 0xA5F7, 
	0xA3E4, 0xA26B, 0xA18B, 0xA141, 0xA1E2, 0xA38B, 0xA5E4, 0xA895, 0xAB45, 
	0xAD9E, 0xAF47, 0xAFE8, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x009B, 0x0001, 0x009A, 0x009C, 0x0001, 0x0136, 0x0001, 
	0x0137, 0x0001, 0x0138, 0x009B, 0x0139, 0x009B, 0x01D4, 0x009B, 0x026F, 
	0x009B, 0x030A, 0x009B, 0x03A5, 0x009B, 0x0440, 0x009B, 0x04DB, 0x009B, 
	0x0576, 0x009B, 0x0611, 0x0001, 0x06AC, 0x0001, 0x06AD, 0x0001, 0x06AE, 
	0x009B, 0x06AF, 0x009B, 0x074A, 0x009B, 0x07E5, 0x009B, 0x0880, 0x009B, 
	0x091B, 0x009B, 0x09B6, 0x009B, 0x0A51, 0x009B, 0x0AEC, 0x009B, 0x0B87, 
	0x0001, 0x0C22, 0x0001, 0x0C23, 0x0001, 0x0C24, 0x009B, 0x0C25, 0x009B, 
	0x0CC0, 0x009B, 0x0D5B, 0x009A, 0x0DF6, 0x009A, 0x0E90, 0x009B, 0x0F2A, 
	0x009B, 0x0FC5, 0x009B, 0x1060, 0x009B, 0x10FB, 0x009B, 0x1196, 0x009B, 
	0x1231, 0x009B, 0x12CC, 0x009B, 0x1367, 0x009B, 0x1402, 0x009B, 0x149D, 
	0x009B, 0x1538, 0x009B, 0x15D3, 0x009B, 0x166E, 0x009B, 0x1709, 0x009B, 
	0x17A4, 0x009B, 0x183F, 0x009B, 0x18DA, 0x009B, 0x1975, 0x0001, 0x1A10, 
	0x009B, 0x1A11, 0x009B, 0x1AAC, 0x009B, 0x1B47, 0x009B, 0x1BE2, 0x009B, 
	0x1C7D, 0x009B, 0x1D18, 0x009B, 0x1DB3, 0x009B, 0x1E4E, 0x009B, 0x1EE9, 
	

});

smlua_anim_util_register_animation('donkey_55_legs_stuck_in_ground',1, 0, 0, 0, 151, { 
	0x0000, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 0xFFED, 
	0xFFEE, 0xFFEF, 0xFFF0, 0xFFF2, 0xFFF4, 0xFFF6, 0xFFF8, 0xFFFB, 0xFFFE, 
	0x0001, 0x0005, 0x0009, 0x000D, 0x0011, 0x0016, 0x001B, 0x0021, 0x0026, 
	0x002C, 0x0031, 0x0036, 0x003B, 0x003E, 0x0040, 0x0042, 0x0049, 0x005D, 
	0x0083, 0x010B, 0x017A, 0x017A, 0x0177, 0x0170, 0x0159, 0x012E, 0x00FD, 
	0x00CF, 0x00B3, 0x00A7, 0x00A3, 0x00A2, 0x00A3, 0x00A5, 0x00A6, 0x00A5, 
	0x00A2, 0x009C, 0x0096, 0x0092, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091, 
	0x0090, 0x0090, 0x008F, 0x008F, 0x008E, 0x008E, 0x008D, 0x008C, 0x008B, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFC, 0xFFF7, 0xFFF1, 0xFFEF, 
	0xFFEF, 0xFFF0, 0xFFF1, 0xFFF3, 0xFFF5, 0xFFF7, 0xFFF9, 0xFFFA, 0xFFFC, 
	0xFFFE, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40A1, 0x40A1, 0x40A1, 0x444B, 0x4E46, 0x5D0A, 0x6F0F, 0x82D2, 0x96C8, 
	0xA96B, 0xB934, 0xC49C, 0xD1FE, 0xE6CF, 0x0032, 0x1B4A, 0x3539, 0x4B23, 
	0x4C9C, 0x4DF3, 0x4F2A, 0x5042, 0x513C, 0x521A, 0x52DE, 0x538A, 0x541F, 
	0x549F, 0x550B, 0x5565, 0x55AF, 0x55EA, 0x5618, 0x563A, 0x5653, 0x5664, 
	0x566E, 0x5673, 0x5675, 0x09BB, 0x07E7, 0x05CE, 0x03A5, 0x01A4, 0x0000, 
	0xFFA7, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFB, 0xFFF1, 0xFFE8, 0xFFE3, 0xFFE9, 
	0x0000, 0x002F, 0x0079, 0x00D9, 0x014A, 0x01C5, 0x0245, 0x02C4, 0x033E, 
	0x03AB, 0x0408, 0x044D, 0x0477, 0x047E, 0x045E, 0x0411, 0x0391, 0x02DA, 
	0x0105, 0xFDA2, 0xF956, 0xF4C6, 0xF098, 0xED70, 0xEBF5, 0xEBDA, 0xEC51, 
	0xED42, 0xEE93, 0xF02B, 0xF1F0, 0xF3C9, 0xF59C, 0xF750, 0xF8CC, 0xF9F6, 
	0xFAB4, 0xFB21, 0xFB68, 0xFB8F, 0xFB99, 0xFB8B, 0xFB69, 0xFB37, 0xFAFA, 
	0xFAB7, 0xFA70, 0xFA2B, 0xF9EC, 0xF9B8, 0xF991, 0xF97E, 0xF96E, 0xF959, 
	0xF947, 0xF943, 0xF958, 0xF990, 0xF9F5, 0xFAB9, 0xFBE0, 0xFD32, 0xFE76, 
	0xFF73, 0xFFF3, 0x001C, 0x003E, 0x005A, 0x0070, 0x0081, 0x008C, 0x0093, 
	0x0095, 0x0093, 0x008E, 0x0085, 0x0079, 0x006B, 0x005B, 0x004A, 0x0037, 
	0x0023, 0x000F, 0xFFFB, 0xFFE8, 0xFFD5, 0xFFC3, 0xFFB2, 0xFFA4, 0xFF98, 
	0xFF8F, 0xFF7C, 0xFF59, 0xFF32, 0xFF12, 0xFF04, 0xFF06, 0xFF0C, 0xFF16, 
	0xFF22, 0xFF31, 0xFF40, 0xFF50, 0xFF60, 0xFF6E, 0xFF7A, 0xFF79, 0xFF77, 
	0xFF75, 0xFF77, 0xFF7A, 0xFF80, 0xFF87, 0xFF8F, 0xFF99, 0xFFA4, 0xFFAF, 
	0xFFBA, 0xFFC6, 0xFFD1, 0xFFDB, 0xFFE5, 0xFFEE, 0xFFF5, 0xFFFA, 0xFFFE, 
	0x0000, 0x00BE, 0x009A, 0x0071, 0x0047, 0x0020, 0x0000, 0xFFF9, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x000A, 0x0020, 0x0036, 0x0040, 0x0032, 0x0000, 0xFFAC, 
	0xFF45, 0xFECF, 0xFE4C, 0xFDC0, 0xFD2E, 0xFC9B, 0xFC0A, 0xFB7E, 0xFAFA, 
	0xFA83, 0xFA1B, 0xF9C6, 0xF989, 0xF965, 0xF95F, 0xF97B, 0xFA26, 0xFB9A, 
	0xFD8A, 0xFFAC, 0x01B2, 0x0351, 0x043D, 0x049C, 0x04CC, 0x04D5, 0x04BC, 
	0x0489, 0x0442, 0x03EE, 0x0394, 0x033A, 0x02E7, 0x02A1, 0x0271, 0x024D, 
	0x022A, 0x0207, 0x01E6, 0x01C4, 0x01A3, 0x0181, 0x0160, 0x013F, 0x011D, 
	0x00FB, 0x00D8, 0x00B5, 0x0091, 0x006C, 0x0044, 0x0019, 0xFFEC, 0xFFBE, 
	0xFF90, 0xFF62, 0xFF37, 0xFF09, 0xFED7, 0xFEA6, 0xFE7A, 0xFE5A, 0xFE49, 
	0xFE43, 0xFE3D, 0xFE38, 0xFE35, 0xFE32, 0xFE30, 0xFE2E, 0xFE2D, 0xFE2D, 
	0xFE2D, 0xFE2E, 0xFE30, 0xFE31, 0xFE33, 0xFE36, 0xFE39, 0xFE3C, 0xFE3F, 
	0xFE42, 0xFE45, 0xFE48, 0xFE4C, 0xFE4F, 0xFE52, 0xFE55, 0xFE58, 0xFE5D, 
	0xFE66, 0xFE73, 0xFE84, 0xFE98, 0xFEB0, 0xFECA, 0xFEE7, 0xFF06, 0xFF25, 
	0xFF43, 0xFF60, 0xFF7A, 0xFF92, 0xFFA5, 0xFFCB, 0xFFF6, 0x000B, 0x000B, 
	0x000B, 0x000B, 0x000B, 0x000B, 0x000B, 0x000B, 0x000A, 0x000A, 0x0009, 
	0x0009, 0x0008, 0x0007, 0x0006, 0x0005, 0x0003, 0x0002, 0x0000, 0xFFBD, 
	0x03CF, 0x0862, 0x0D27, 0x11CC, 0x1600, 0x1A9F, 0x1AE3, 0x13F8, 0x0A63, 
	0x0064, 0xF83A, 0xF427, 0xF3E8, 0xF540, 0xF775, 0xF9CE, 0xFB92, 0xFC07, 
	0xFAFF, 0xF91F, 0xF6EB, 0xF4E5, 0xF391, 0xF373, 0xF400, 0xF45B, 0xF490, 
	0xF4A7, 0xF4AD, 0xF436, 0xF307, 0xF175, 0xEFD3, 0xEE74, 0xEDAC, 0xED69, 
	0xED5D, 0xED83, 0xEDD9, 0xEE58, 0xEEFE, 0xEFC6, 0xF02B, 0xEFDB, 0xEF1C, 
	0xEE36, 0xED6D, 0xED0A, 0xECF9, 0xECF6, 0xECFF, 0xED13, 0xED2E, 0xED4E, 
	0xED71, 0xED95, 0xEDB8, 0xEDD7, 0xEDF0, 0xEE00, 0xEE02, 0xEDF1, 0xEDD2, 
	0xEDA9, 0xED7C, 0xED4D, 0xED22, 0xECFE, 0xECE6, 0xECDF, 0xECEC, 0xED12, 
	0xED55, 0xEDBA, 0xEE44, 0xEF34, 0xF0B0, 0xF296, 0xF4C4, 0xF717, 0xF96C, 
	0xFBA3, 0xFE0A, 0x00D3, 0x03B0, 0x0652, 0x086B, 0x09AC, 0x0A5C, 0x0AF8, 
	0x0B80, 0x0BF7, 0x0C5E, 0x0CB8, 0x0D05, 0x0D49, 0x0D83, 0x0DB7, 0x0DE6, 
	0x0E12, 0x0E3D, 0x0E68, 0x0E95, 0x0EC6, 0x0EFC, 0x0F3B, 0x0F82, 0x0FD4, 
	0x1033, 0x10A1, 0x111F, 0x11AF, 0x1253, 0x130D, 0x14E9, 0x1847, 0x1C23, 
	0x1F7D, 0x2152, 0x21EE, 0x2250, 0x227C, 0x2279, 0x224A, 0x21F6, 0x2182, 
	0x20F3, 0x204D, 0x1F98, 0x2678, 0x333E, 0x3A1E, 0x39A2, 0x383F, 0x3614, 
	0x333C, 0x2FD4, 0x2BF9, 0x27C8, 0x235D, 0x1ED6, 0x1A4F, 0x15E5, 0x11B4, 
	0x0DD9, 0x0A71, 0x0799, 0x056D, 0x040B, 0x038E, 0xF77E, 0xF764, 0xF747, 
	0xF72A, 0xF713, 0xF705, 0xF6F4, 0xF746, 0xF81F, 0xF923, 0xFA38, 0xFB46, 
	0xFC34, 0xFCEB, 0xFD58, 0xFD8A, 0xFD96, 0xFD90, 0xFD8D, 0xFD8B, 0xFD7C, 
	0xFD65, 0xFD4D, 0xFD3A, 0xFD30, 0xFCF7, 0xFC89, 0xFC3F, 0xFC71, 0xFD75, 
	0xFF4B, 0x019F, 0x0454, 0x0749, 0x0A5E, 0x0D76, 0x1070, 0x132D, 0x158D, 
	0x1772, 0x18BB, 0x194A, 0x18FF, 0x15F1, 0x0F4E, 0x0697, 0xFD4E, 0xF4F3, 
	0xEF08, 0xEBD9, 0xEABE, 0xEBC8, 0xEF08, 0xF44E, 0xFB03, 0x029E, 0x0A99, 
	0x126A, 0x198A, 0x1F71, 0x2397, 0x2640, 0x2817, 0x292D, 0x2994, 0x295C, 
	0x2895, 0x2752, 0x25A2, 0x2397, 0x1FE0, 0x19E9, 0x12D8, 0x0BD5, 0x0607, 
	0x0296, 0x00F3, 0xFFC0, 0xFEEE, 0xFE71, 0xFE3A, 0xFE3C, 0xFE69, 0xFEB3, 
	0xFF0D, 0xFF69, 0xFFB9, 0xFFF0, 0xFFFF, 0xFFF7, 0xFFEF, 0xFFE8, 0xFFE1, 
	0xFFDB, 0xFFD5, 0xFFCF, 0xFFCA, 0xFFC6, 0xFFC2, 0xFFBE, 0xFFBB, 0xFFB8, 
	0xFFB6, 0xFFB4, 0xFFB2, 0xFFB0, 0xFFAF, 0xFFAF, 0xFFAE, 0xFFAE, 0xFFAE, 
	0xFFAF, 0xFFAF, 0xFFB0, 0xFFB1, 0xFFB3, 0xFFB4, 0xFFB6, 0xFFB8, 0xFFBA, 
	0xFFBC, 0xFFBE, 0xFFC1, 0xFFC3, 0xFFC6, 0xFFC9, 0xFFCB, 0xFFCE, 0xFFD1, 
	0xFFD4, 0xFFD1, 0xFFCA, 0xFFC2, 0xFFBB, 0xFFB8, 0xFFB8, 0xFFBB, 0xFFBE, 
	0xFFC3, 0xFFC8, 0xFFCE, 0xFFD5, 0xFFDB, 0xFFE2, 0xFFE8, 0xFFEE, 0xFFF4, 
	0xFFF8, 0xFFFC, 0xFFFE, 0x0000, 0x0410, 0x03CF, 0x0386, 0x033E, 0x0303, 
	0x02E2, 0x033A, 0x0396, 0x037D, 0x034E, 0x0314, 0x02D9, 0x02AB, 0x0292, 
	0x029B, 0x02BF, 0x02EE, 0x0318, 0x032E, 0x032D, 0x0320, 0x030C, 0x02F7, 
	0x02E6, 0x02DE, 0x02FD, 0x0340, 0x037A, 0x037D, 0x031B, 0x0269, 0x019C, 
	0x00B9, 0xFFC5, 0xFEC5, 0xFDBE, 0xFCB5, 0xFBAE, 0xFAB0, 0xF9BE, 0xF8DF, 
	0xF816, 0xF769, 0xF6FB, 0xF6DD, 0xF6F2, 0xF723, 0xF753, 0xF769, 0xF769, 
	0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 
	0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 0xF769, 
	0xF769, 0xF769, 0xF759, 0xF735, 0xF712, 0xF702, 0xF718, 0xF769, 0xF7EE, 
	0xF893, 0xF950, 0xFA1E, 0xFAF7, 0xFBD4, 0xFCAD, 0xFD7C, 0xFE3A, 0xFEE1, 
	0xFF68, 0xFFCA, 0xFFFF, 0x001C, 0x0036, 0x004E, 0x0065, 0x007A, 0x008E, 
	0x00A0, 0x00B0, 0x00BF, 0x00CC, 0x00D8, 0x00E3, 0x00EC, 0x00F5, 0x00FB, 
	0x0101, 0x0106, 0x0109, 0x010C, 0x010D, 0x010E, 0x010D, 0x010C, 0x010A, 
	0x0107, 0x0103, 0x00FF, 0x00FA, 0x00F4, 0x00EE, 0x00E7, 0x00E0, 0x00D8, 
	0x00D0, 0x00C8, 0x00BF, 0x00B6, 0x00AD, 0x00A3, 0x009A, 0x0090, 0x0076, 
	0x0051, 0x002B, 0x000C, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x1AEA, 0x1A44, 
	0x19ED, 0x194F, 0x17D5, 0x14E9, 0x1635, 0x181A, 0x1434, 0x0EB9, 0x0904, 
	0x046E, 0x0253, 0x02F2, 0x0538, 0x0881, 0x0C2C, 0x0F97, 0x121E, 0x131F, 
	0x121A, 0x0F98, 0x0C87, 0x09D9, 0x087A, 0x089C, 0x099E, 0x0B39, 0x0D26, 
	0x0F1F, 0x10FC, 0x12C7, 0x147F, 0x1625, 0x17B8, 0x193A, 0x1AA9, 0x1C07, 
	0x1D52, 0x1E8C, 0x1FB3, 0x20CA, 0x21CE, 0x227D, 0x22AE, 0x228B, 0x223E, 
	0x21F1, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 
	0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 
	0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21CE, 0x21F5, 0x224A, 0x22A0, 0x22C7, 
	0x2290, 0x21CE, 0x209A, 0x1F32, 0x1DA1, 0x1BF0, 0x1A27, 0x1851, 0x1677, 
	0x14A1, 0x12DA, 0x112B, 0x0F9D, 0x0E39, 0x0D09, 0x0C81, 0x0CC8, 0x0D79, 
	0x0E2B, 0x0E77, 0x0DE8, 0x0C94, 0x0AE6, 0x0948, 0x0825, 0x07F2, 0x0891, 
	0x0992, 0x0A85, 0x0AF9, 0x0A63, 0x08E3, 0x0707, 0x0560, 0x047C, 0x047B, 
	0x04F7, 0x05B7, 0x0688, 0x0730, 0x077B, 0x06E4, 0x0574, 0x03C7, 0x0279, 
	0x0228, 0x02EA, 0x03DB, 0x0427, 0x0389, 0x023C, 0x0029, 0xFC6B, 0xF77F, 
	0xF36A, 0xF1C6, 0xDDDA, 0xD1C4, 0xCB90, 0xC947, 0xC8F3, 0xC95E, 0xCA8D, 
	0xCC63, 0xCEC6, 0xD198, 0xD4BE, 0xD81C, 0xDB95, 0xDF0F, 0xE26D, 0xE593, 
	0xE865, 0xEAC7, 0xEC9E, 0xEDCD, 0xEE38, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 
	0xAC55, 0xAA0B, 0xA782, 0xA4F9, 0xA2AE, 0xA0E0, 0xA34C, 0xA1FC, 0x1716, 
	0x096C, 0xFAB3, 0xECA2, 0xE0EF, 0xD94F, 0xD58C, 0xD40A, 0xD465, 0xD63B, 
	0xD92B, 0xDCD0, 0xE0CA, 0xE584, 0xEB70, 0xF237, 0xF980, 0x00F3, 0x0838, 
	0x0EF6, 0x14D7, 0x1980, 0x1D43, 0x20AF, 0x23C6, 0x268E, 0x290A, 0x2B3F, 
	0x2D30, 0x2EE3, 0x305A, 0xB19A, 0xB2A8, 0xB388, 0xB41D, 0xB450, 0xB42E, 
	0xB3C5, 0xB321, 0xB24F, 0xB15E, 0x305A, 0x2F4F, 0x2E4B, 0x2D5B, 0x2C8C, 
	0x2BEB, 0x2B86, 0x2B69, 0x2BA1, 0x2C3C, 0x2D47, 0x2ECF, 0x30E1, 0xB388, 
	0xB6DE, 0xBAE5, 0xBF8A, 0xC4BF, 0xCA71, 0xD090, 0xD70B, 0xDDD2, 0xE4D2, 
	0xEBFD, 0xF340, 0xFA8C, 0x01D2, 0x08FB, 0x0FF9, 0x16BC, 0x1D33, 0x234D, 
	0x28F9, 0x2E27, 0xB2C4, 0xB6C2, 0xBA0E, 0xBC99, 0xBE51, 0xBF26, 0xBF13, 
	0xBE2B, 0xBC7E, 0xBA18, 0xB70B, 0x3365, 0x2F34, 0x2A87, 0x256E, 0x1FF7, 
	0x1A31, 0x142C, 0x0DF6, 0x079E, 0x0133, 0xFAC1, 0xF45D, 0xEE14, 0xE7F3, 
	0xE20A, 0xDC68, 0xD71C, 0xD234, 0xCDC0, 0xC9CF, 0xC66F, 0xC66F, 0xCB2B, 
	0xD28C, 0xDA76, 0xE0D3, 0xE5D9, 0xEB23, 0xF0AB, 0xF668, 0xFC53, 0x026B, 
	0x089E, 0x02FF, 0xEA79, 0xB390, 0xDBA3, 0x038C, 0xD4FF, 0xD3AE, 0xCFB9, 
	0xC920, 0xC288, 0xBE93, 0xBD41, 0xBDED, 0xBFEF, 0xC34A, 0xC7FB, 0xCE04, 
	0xD564, 0xDE1B, 0xE829, 0xF38F, 0x004D, 0x0E61, 0x1DCC, 0xB50B, 0xB4F3, 
	0xB4E5, 0xB4CE, 0xB499, 0xB431, 0xB319, 0xB152, 0xD0D9, 0xD360, 0xD5F5, 
	0xD84A, 0xDA0F, 0xDAF8, 0xDAFA, 0xDA5C, 0xD947, 0xD7E5, 0xD660, 0xD4E1, 
	0xD393, 0xD24E, 0xD0DB, 0xCF4F, 0xCDBF, 0xCC3F, 0xCAE3, 0xC9C0, 0xC8EB, 
	0xC877, 0xC860, 0xC88C, 0xC8EE, 0xC97D, 0xCA2B, 0xCAED, 0xCBB9, 0xCC82, 
	0xCD3D, 0xB21F, 0xB1A2, 0xB156, 0xB12A, 0xB106, 0xB0E9, 0xB0D3, 0xB0C4, 
	0xB0B9, 0xB0B4, 0xCF4A, 0xCF47, 0xCF40, 0xCF36, 0xCF29, 0xCF1B, 0xCF0B, 
	0xCEFB, 0xCEEB, 0xCEDA, 0xCECB, 0xCEBD, 0xCEB1, 0xB156, 0xB160, 0xB16D, 
	0xB17D, 0xB18F, 0xB1A4, 0xB1BA, 0xB1D2, 0xB1EB, 0xB205, 0xB21F, 0xB239, 
	0xB253, 0xB26C, 0xB284, 0xB29B, 0xB2B0, 0xB2C2, 0xB2D2, 0xB2E0, 0xB2EA, 
	0xCD0E, 0xCD0C, 0xCD0D, 0xCD14, 0xCD20, 0xCD31, 0xCD41, 0xCD4D, 0xCD55, 
	0xCD59, 0xCD5B, 0xB2A2, 0xB2A1, 0xB2A0, 0xB29C, 0xB295, 0xB28B, 0xB27B, 
	0xB265, 0xB248, 0xB223, 0xB1F5, 0xB1BD, 0xB179, 0xB12A, 0xB0CD, 0xB062, 
	0xAFE7, 0xAF5C, 0xAEC0, 0xAE11, 0xAD4F, 0xAAD2, 0xA60C, 0xA09D, 0x9C27, 
	0x9A4D, 0x9A5A, 0x9A81, 0x9AC2, 0x9B19, 0x9B85, 0x9C06, 0x9D27, 0xAC6D, 
	0xB0B3, 0xB5E9, 0xBBC4, 0xD4B1, 0xDC91, 0xDB90, 0xD88D, 0xD389, 0xCE84, 
	0xCB81, 0xCA80, 0xCA99, 0xCAE7, 0xCB68, 0xCC1C, 0xCD04, 0xCE20, 0xCF6F, 
	0xD0F2, 0xD2A9, 0xD493, 0xD6B0, 0xD901, 0x0683, 0x08FE, 0x0BDA, 0x0EA1, 
	0x10DD, 0x1215, 0x0B2A, 0x0A6F, 0x9A9E, 0xAF72, 0xC623, 0xDBEA, 0xEE00, 
	0xF99D, 0xFEC4, 0xFFF1, 0xFE18, 0xFA29, 0xF517, 0xEFD4, 0xEB53, 0xE70F, 
	0xE20A, 0xDC7F, 0xD6A4, 0xD0B5, 0xCAE9, 0xC579, 0xC09F, 0xBC94, 0xB918, 
	0xB5C7, 0xB2A4, 0xAFB3, 0xACF6, 0xAA6F, 0xA823, 0xA614, 0xA444, 0x22B7, 
	0x216F, 0x2070, 0x1FC4, 0x1F6F, 0x1F66, 0x1F9C, 0x2009, 0x20A0, 0x2156, 
	0xA221, 0xA2F6, 0xA3CB, 0xA493, 0xA544, 0xA5D4, 0xA637, 0xA662, 0xA64A, 
	0xA5E5, 0xA528, 0xA407, 0xA278, 0x2070, 0x1DDB, 0x1AB8, 0x1714, 0x12FD, 
	0x0E82, 0x09AF, 0x0493, 0xFF37, 0xF9B2, 0xF40D, 0xEE57, 0xE89C, 0xE2EB, 
	0xDD52, 0xD7DE, 0xD29E, 0xCD9F, 0xC8EF, 0xC49C, 0xC0B4, 0x3D46, 0x3A5C, 
	0x3808, 0x3655, 0x3553, 0x350E, 0x359A, 0x36F4, 0x390E, 0x3BD5, 0x3F3C, 
	0xC330, 0xC7A4, 0xCC86, 0xD1C7, 0xD756, 0xDD23, 0xE31E, 0xE938, 0xEF60, 
	0xF586, 0xFB99, 0x018F, 0x074F, 0x0CCC, 0x11F7, 0x16C0, 0x1B17, 0x1EEB, 
	0x222D, 0x24CC, 0x26B8, 0x21C5, 0x135E, 0x00D9, 0xEF89, 0xE4CD, 0xDF0F, 
	0xD934, 0xD341, 0xCD3A, 0xC724, 0xC105, 0xB8E3, 0xBD56, 0xD2C2, 0x0547, 
	0xD88E, 0xAE87, 0xE0AB, 0xE2D3, 0xE949, 0xF40F, 0xFED5, 0x054C, 0x0774, 
	0x06E7, 0x0542, 0x0283, 0xFEAA, 0xF9B9, 0xF3B0, 0xEC8D, 0xE451, 0xDAFC, 
	0xD08E, 0xC507, 0xB867, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 
	0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 
	0x0004, 0x0004, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 
	0x0004, 0x0004, 0x0003, 0x0003, 0x0002, 0x0001, 0x0001, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
	0xFFFE, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFC, 
	0xFFFC, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFF9, 
	0xFFF9, 0xFFF9, 0xFFF9, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF7, 0xFFF7, 0xFFF7, 
	0xFFF6, 0xFFF6, 0xFFF6, 0xFFF5, 0xFFF5, 0xFFF4, 0xFFF4, 0xFFF4, 0xFFF3, 
	0xFFF3, 0xFFF3, 0xFFF2, 0xFFF2, 0xFFF1, 0xFFF1, 0xFFF1, 0xFFF0, 0xFFF0, 
	0xFFEF, 0xFFEF, 0xFFEF, 0xFFEE, 0xFFEE, 0xFFED, 0xFFED, 0xFFED, 0xFFEC, 
	0xFFEC, 0xFFEB, 0xFFEB, 0xFFEB, 0xFFEA, 0xFFEA, 0xFFE9, 0xFFE9, 0xFFE9, 
	0xFFE8, 0xFFE8, 0xFFE7, 0xFFE7, 0xFFE7, 0xFFE6, 0xFFE6, 0xFFE6, 0xFFE5, 
	0xFFE5, 0xFFE5, 0xFFE4, 0xFFE4, 0xFFE4, 0xFFE3, 0xFFE3, 0xFFE3, 0xFFE2, 
	0xFFE2, 0xFFE2, 0xFFE1, 0xFFE1, 0xFFE1, 0xFFE0, 0xFFE0, 0xFFE0, 0xFFE0, 
	0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 
	0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDC, 
	0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 
	0xFFDC, 0xFFDE, 0xFFE1, 0xFFE4, 0xFFE7, 0xFFEB, 0xFFEE, 0xFFF1, 0xFFF4, 
	0xFFF6, 0xFFF8, 0xFFFA, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFF, 0x0000, 
	0xDB3A, 0xDA79, 0xD991, 0xD88F, 0xD77D, 0xD665, 0xD554, 0xD453, 0xD36E, 
	0xD2AF, 0xD221, 0xD1D0, 0xD1C5, 0xD20C, 0xD28D, 0xD328, 0xD3DA, 0xD4A2, 
	0xD57E, 0xD66C, 0xD76A, 0xD876, 0xD98E, 0xDAB1, 0xDBDD, 0xDD0F, 0xDE46, 
	0xDF80, 0xE0BB, 0xE1F6, 0xE32D, 0xE460, 0xE58C, 0xE6B0, 0xE7CA, 0xE8D8, 
	0xE9D7, 0xEAC7, 0xEBA5, 0xEC6F, 0xED23, 0xEDC0, 0xEE4A, 0xEEC7, 0xEF35, 
	0xEF96, 0xEFE9, 0xF02F, 0xF067, 0xF091, 0xF0AD, 0xF0BB, 0xF0BB, 0xF0AE, 
	0xF093, 0xF069, 0xF032, 0xEFED, 0xEF9A, 0xEF39, 0xEEC9, 0xEE4C, 0xEDC0, 
	0xED2A, 0xEC8C, 0xEBE5, 0xEB34, 0xEA78, 0xE9B1, 0xE8DC, 0xE7F9, 0xE708, 
	0xE606, 0xE4F3, 0xE3CF, 0xE297, 0xE14C, 0xDFEB, 0xDE75, 0xDCE7, 0xDB41, 
	0xD983, 0xD7AA, 0xD5B7, 0xD17F, 0xCA58, 0xC27D, 0xBC29, 0xB99A, 0xB9BB, 
	0xB9FA, 0xBA57, 0xBAD0, 0xBB65, 0xBC13, 0xBCDA, 0xBDB9, 0xBEAE, 0xBFB8, 
	0xC0D6, 0xC207, 0xC349, 0xC49C, 0xC5FE, 0xC76D, 0xC8EA, 0xCA72, 0xCC04, 
	0xCDA0, 0xCF43, 0xD0ED, 0xD29D, 0xD450, 0xD607, 0xD7C0, 0xDB49, 0xE133, 
	0xE7A0, 0xECB4, 0xEE91, 0xEE1F, 0xED85, 0xECC6, 0xEBE5, 0xEAE5, 0xE9C8, 
	0xE891, 0xE744, 0xE5E3, 0xE470, 0xD346, 0xB7F4, 0xA9B0, 0xA9F7, 0xAAC3, 
	0xAC04, 0xADAA, 0xAFA6, 0xB1E8, 0xB45F, 0xB6FB, 0xB9AA, 0xBC5B, 0xBEFC, 
	0xC17C, 0xC3CA, 0xC5D3, 0xC787, 0xC8D4, 0xC9A9, 0xC9F4, 0xFFE6, 0xFF62, 
	0xFED3, 0xFE3D, 0xFDA2, 0xFD05, 0xFC68, 0xFBCF, 0xFB3C, 0xFAB1, 0xFA32, 
	0xF9C0, 0xF960, 0xF912, 0xF8D1, 0xF894, 0xF859, 0xF822, 0xF7ED, 0xF7BB, 
	0xF78C, 0xF760, 0xF736, 0xF70E, 0xF6E8, 0xF6C4, 0xF6A3, 0xF683, 0xF664, 
	0xF648, 0xF62C, 0xF612, 0xF5F9, 0xF5E2, 0xF5CB, 0xF5B4, 0xF59F, 0xF58A, 
	0xF575, 0xF561, 0xF54D, 0xF539, 0xF4E7, 0xF426, 0xF309, 0xF1A3, 0xF006, 
	0xEE45, 0xEC73, 0xEAA4, 0xE8E9, 0xE755, 0xE5FC, 0xE4F0, 0xE444, 0xE40B, 
	0xE458, 0xE53D, 0xE6CE, 0xE91C, 0xEC3C, 0xF03F, 0xF539, 0xFB39, 0x0233, 
	0x0A13, 0x12C3, 0x1C2D, 0x263D, 0x30DD, 0x3BF8, 0xC777, 0xD347, 0xDF52, 
	0xEB82, 0xF7C3, 0x0402, 0x1023, 0x1C14, 0x27C0, 0xB310, 0xBDF2, 0xC84E, 
	0xD210, 0xDB23, 0xE370, 0xEAE3, 0xF166, 0xF6E4, 0xFB74, 0xFF45, 0x0263, 
	0x04DA, 0x06B6, 0x0803, 0x08CE, 0x0923, 0x090F, 0x089C, 0x07D9, 0x06D1, 
	0x058F, 0x0422, 0x0294, 0x00F3, 0xFF49, 0xFDA5, 0xFC11, 0xFA9A, 0xF94D, 
	0xF835, 0xF75F, 0xF6D8, 0xF6AA, 0xF6E4, 0xF77A, 0xF854, 0xF968, 0xFAAB, 
	0xFC14, 0xFD98, 0xFF2C, 0x00C8, 0x025F, 0x03E9, 0x055C, 0x06AC, 0x07D0, 
	0x08BD, 0x096A, 0x095B, 0x0935, 0x0903, 0x08CF, 0x089A, 0x0865, 0x0831, 
	0x07FD, 0x07CB, 0x079A, 0x076C, 0x0740, 0x0717, 0x06F1, 0x06CE, 0x06B0, 
	0x0697, 0x0682, 0x0673, 0x066A, 0x0666, 0xF983, 0xF98C, 0xF9A3, 0xF9C3, 
	0xF9E9, 0xFA11, 0xFA35, 0xFA53, 0xFA64, 0xFA66, 0xFA54, 0xFA2A, 0xF9E3, 
	0xF97B, 0xF8FA, 0xF86D, 0xF7D5, 0xF732, 0xF686, 0xF5D1, 0xF515, 0xF452, 
	0xF38A, 0xF2BE, 0xF1EE, 0xF11C, 0xF049, 0xEF76, 0xEEA3, 0xEDD2, 0xED03, 
	0xEC39, 0xEB73, 0xEAB3, 0xE9FA, 0xE948, 0xE8A0, 0xE801, 0xE76D, 0xE6E5, 
	0xE66A, 0xE5FD, 0xE5A9, 0xE577, 0xE561, 0xE566, 0xE57F, 0xE5AA, 0xE5E3, 
	0xE626, 0xE66E, 0xE6B8, 0xE700, 0xE742, 0xE77A, 0xE7A4, 0xE7BD, 0xE7BF, 
	0xE7A8, 0xE774, 0xE71E, 0xE6A2, 0xE5FD, 0xE531, 0xE443, 0xE336, 0xE20E, 
	0xE0CD, 0xDF77, 0xDE0C, 0xDC92, 0xA4F4, 0xA687, 0xA821, 0xA9C1, 0xAB62, 
	0xAD03, 0xAEA1, 0xB038, 0xB1C5, 0xCCB7, 0xCB44, 0xC9E3, 0xC896, 0xC761, 
	0xC646, 0xC548, 0xC46A, 0xC3AF, 0xC306, 0xC25F, 0xC1BB, 0xC11C, 0xC083, 
	0xBFF1, 0xBF68, 0xBEE9, 0xBE77, 0xBE12, 0xBDBC, 0xBD77, 0xBD43, 0xBD23, 
	0xBD18, 0xBD24, 0xBD47, 0xBD84, 0xBDDB, 0xBE4F, 0xBEE1, 0xBF92, 0xC065, 
	0xC159, 0xC271, 0xC3AF, 0xC580, 0xC836, 0xCBAD, 0xCFBD, 0xD442, 0xD916, 
	0xDE11, 0xE310, 0xE7EB, 0xEC7C, 0xF09F, 0xF42C, 0xF6FE, 0xF8EF, 0xFA45, 
	0xFB8C, 0xFCC4, 0xFDC5, 0xFE92, 0xFF48, 0xFFE8, 0x0075, 0x00EF, 0x0158, 
	0x01B0, 0x01FA, 0x0236, 0x0266, 0x028C, 0x02A8, 0x02BC, 0x02CA, 0x02D2, 
	0x02D6, 0x02D8, 0xED8B, 0xED8B, 0xED8C, 0xED8E, 0xED8F, 0xED91, 0xED93, 
	0xED94, 0xED95, 0xED95, 0xED94, 0xED92, 0xED8F, 0xED8B, 0xED85, 0xED7F, 
	0xED78, 0xED71, 0xED69, 0xED61, 0xED59, 0xED50, 0xED47, 0xED3E, 0xED35, 
	0xED2C, 0xED22, 0xED19, 0xED10, 0xED07, 0xECFD, 0xECF4, 0xECEC, 0xECE3, 
	0xECDB, 0xECD3, 0xECCC, 0xECC5, 0xECBE, 0xECB8, 0xECB3, 0xECAE, 0xECE8, 
	0xED94, 0xEE9F, 0xEFF5, 0xF184, 0xF339, 0xF502, 0xF6CB, 0xF881, 0xFA12, 
	0xFB6C, 0xFC7A, 0xFD2B, 0xFD6B, 0xFD27, 0xFC4E, 0xFACB, 0xF88D, 0xF580, 
	0xF191, 0xECAE, 0xE6C8, 0xDFEC, 0xD82F, 0xCFA5, 0xC663, 0xBC7F, 0xB20E, 
	0xA723, 0x1BD7, 0x103A, 0x0463, 0xF864, 0xEC59, 0xE053, 0xD467, 0xC8AA, 
	0xBD32, 0x3213, 0x2760, 0x1D31, 0x139A, 0x0AAF, 0x0286, 0xFB34, 0xF4CD, 
	0xEF67, 0xEAE7, 0xE71E, 0xE400, 0xE182, 0xDF99, 0xDE39, 0xDD58, 0xDCE9, 
	0xDCE1, 0xDD36, 0xDDDB, 0xDEC7, 0xDFEC, 0xE140, 0xE2B8, 0xE448, 0xE5E5, 
	0xE783, 0xE918, 0xEA98, 0xEBF8, 0xED2C, 0xEE29, 0xEEE5, 0xEF52, 0xEF67, 
	0xEF3F, 0xEF01, 0xEEB1, 0xEE52, 0xEDE9, 0xED7A, 0xED08, 0xEC98, 0xEC2D, 
	0xEBCB, 0xEB76, 0xEB33, 0xEB05, 0xEAF0, 0xEAF8, 0xEE38, 0xF4AB, 0xF9AA, 
	0xFC3B, 0xFE83, 0x0088, 0x024B, 0x03D2, 0x0521, 0x063D, 0x072A, 0x07EB, 
	0x0887, 0x08FF, 0x095A, 0x099B, 0x09C7, 0x09E1, 0x09EF, 0x09F4, 0x09F5, 
	0x0001, 0xFFFE, 0xC170, 0x3581, 0x27EA, 0x1946, 0x0A53, 0xFBC7, 0xEE67, 
	0x612D, 0x5DA0, 0xE74E, 0xF520, 0x04A5, 0x1366, 0x1EF3, 0x24DD, 0x21BB, 
	0x16E2, 0x08FD, 0xFCAF, 0xF6AB, 0xF853, 0xFE72, 0x06C7, 0x0F06, 0x14F1, 
	0x1643, 0x0E52, 0xFB60, 0xE4C5, 0xD1D5, 0xC9E4, 0xCC16, 0xD0EA, 0xD5BE, 
	0xD7F0, 0xD556, 0xCF9C, 0xC9E2, 0x4749, 0x4762, 0x4810, 0x49EB, 0x4D86, 
	0x5379, 0xDFED, 0xF449, 0x0CF8, 0x2665, 0x3CFD, 0x4D2A, 0x535B, 0x4F37, 
	0x4CBF, 0x4B4B, 0x4A30, 0x48C7, 0x4666, 0x422E, 0x3CBE, 0x37A8, 0x3480, 
	0x34DA, 0x38B6, 0x3EA4, 0x460E, 0x4E5E, 0x56FE, 0xDF56, 0xE6D4, 0xECDF, 
	0xF0E2, 0xF248, 0xF078, 0xEADA, 0xE1B2, 0xD5B8, 0x47A6, 0x3831, 0x2814, 
	0x1807, 0x08C1, 0xFAF9, 0xEF6D, 0xE6D3, 0xE1E3, 0xE86E, 0xFCB5, 0x171D, 
	0x2FFF, 0x3FBE, 0x47FA, 0xCF74, 0xD641, 0xDC74, 0xE220, 0xE759, 0xEC32, 
	0xF0BF, 0xF514, 0xF943, 0xFD60, 0x0180, 0x05B5, 0x0A13, 0x0EAE, 0x1388, 
	0x1885, 0x1D8C, 0x2284, 0x2752, 0x2BDE, 0x300D, 0x33C7, 0x36F1, 0x3972, 
	0x3B31, 0x39D3, 0x348D, 0x2D9A, 0x2736, 0x239D, 0x2229, 0x20B7, 0x1F47, 
	0x1DDA, 0x1C71, 0x1B0C, 0x19AD, 0x1853, 0x16FF, 0x15B3, 0x3F22, 0x0D9F, 
	0x3C72, 0x4221, 0x443A, 0x4486, 0x44C5, 0x3E12, 0x3B95, 0x389D, 0x3631, 
	0x33B6, 0x3092, 0x2C2C, 0x25E8, 0x1D2D, 0x1161, 0x01E9, 0xEE2B, 0xD58E, 
	0x3777, 0x4B56, 0x4590, 0x3F4A, 0x38ED, 0x32E3, 0x2D98, 0x5546, 0x5627, 
	0x28FD, 0x281E, 0x275D, 0x26DB, 0x26B8, 0x2715, 0x285D, 0x2A89, 0x2D10, 
	0x2F69, 0x310C, 0x3234, 0x3355, 0x3437, 0x34A0, 0x3458, 0x3325, 0x2C9F, 
	0x2214, 0x16A9, 0x0D81, 0x09C1, 0x0A11, 0x0ACE, 0x0BAA, 0x0C58, 0x0CAA, 
	0x0CF7, 0x0DB7, 0x709F, 0x6CEB, 0x675B, 0x6168, 0x5C8C, 0x5A43, 0x262E, 
	0x267F, 0x26B5, 0x26D6, 0x26E7, 0x26ED, 0x26EE, 0x26B6, 0x2641, 0x25A6, 
	0x24F9, 0x2451, 0x23C3, 0x22EC, 0x21B7, 0x20A9, 0x2049, 0x211D, 0x22F3, 
	0x2530, 0x27BD, 0x2A87, 0x2D76, 0x4F8A, 0x4C90, 0x49B0, 0x4701, 0x4498, 
	0x428A, 0x40AA, 0x3EC4, 0x3CE4, 0x44EC, 0x469F, 0x482A, 0x4981, 0x4A99, 
	0x4B66, 0x4BDC, 0x4BF1, 0x4B98, 0x4901, 0x438E, 0x3D03, 0x3721, 0x33AA, 
	0x3221, 0x4F29, 0x503B, 0x511C, 0x51D2, 0x5265, 0x52DC, 0x533C, 0x538E, 
	0x53D7, 0x541F, 0x546D, 0x54C6, 0x5534, 0x55BB, 0x5638, 0x568D, 0x56C9, 
	0x56F8, 0x572A, 0x576C, 0x57CC, 0x5859, 0x5922, 0x5A33, 0x5B9B, 0x5ED6, 
	0x6424, 0x69C2, 0x6DE9, 0x6ED4, 0x6D6D, 0x6BCE, 0x69FE, 0x67FF, 0x65D6, 
	0x6388, 0x6119, 0x5E8D, 0x5BE9, 0x5930, 0x5634, 0x2C50, 0x2D5F, 0x2CD0, 
	0x2BC7, 0x2B39, 0x2D10, 0x31E9, 0x3594, 0x355D, 0x34C5, 0x33DF, 0x32BF, 
	0x3179, 0x301F, 0x2EC5, 0x2D7F, 0x2C5F, 0x2B79, 0x2AE1, 0x5555, 0xC636, 
	0xBB12, 0xAF11, 0xA2D0, 0x96E9, 0x8BFB, 0xFFA9, 0xFE7E, 0x8E32, 0xA31A, 
	0xBA1A, 0xD014, 0xE1EB, 0xEC81, 0xEBCC, 0xE17A, 0xD307, 0xC5EF, 0xBFAF, 
	0xC220, 0xC995, 0xD341, 0xDC54, 0xE202, 0xE17C, 0xD55E, 0xBABD, 0x9B7C, 
	0x817C, 0x769F, 0x76B0, 0x76DD, 0x7719, 0x7756, 0x778B, 0x77B6, 0x77D5, 
	0xF7E9, 0xF80A, 0xF8B1, 0xFA6F, 0xFDD6, 0x0379, 0x91C6, 0xAB81, 0xCBB2, 
	0xED60, 0x0B97, 0x215B, 0x29B7, 0x2692, 0x2480, 0x2310, 0x21D0, 0x204E, 
	0x1E18, 0x1A4D, 0x1551, 0x109B, 0x0DA5, 0x0DE8, 0x1159, 0x169C, 0x1D2F, 
	0x2490, 0x2C3B, 0xB3AE, 0xBA68, 0xBFE6, 0xC3A5, 0xC523, 0xC3DD, 0xBF37, 
	0xB760, 0xAD03, 0x20CD, 0x1368, 0x0580, 0xF7BD, 0xEAD3, 0xDF69, 0xD62B, 
	0xCFC6, 0xCCE4, 0xD5AE, 0xEC7B, 0x0945, 0x23F8, 0x348B, 0x3CE5, 0xC457, 
	0xCAFA, 0xD0E6, 0xD632, 0xDAF8, 0xDF4E, 0xE34D, 0xE70C, 0xEAA4, 0xEE2C, 
	0xF1BD, 0xF56F, 0xF959, 0xFD94, 0x0252, 0x078F, 0x0D11, 0x129E, 0x17FA, 
	0x1CEC, 0x2139, 0x24A6, 0x26F9, 0x27F8, 0x2768, 0x203A, 0x10FF, 0xFEF3, 
	0xEF4F, 0xE74E, 0xE4F0, 0xE2B7, 0xE0A2, 0xDEB0, 0xDCE0, 0xDB31, 0xD9A1, 
	0xD830, 0xD6DC, 0xD555, 0xF7AD, 0xBBD7, 0xED82, 0xFDAE, 0x03A5, 0x047F, 
	0x089A, 0x024A, 0xFE75, 0xF9F1, 0xF69E, 0xF3E7, 0xF138, 0xEDFD, 0xE9A2, 
	0xE392, 0xDB3B, 0xD006, 0xC162, 0xAEB9, 0x1777, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xF04A, 
	0xED9D, 0xEAC9, 0xE7DC, 0xE4E4, 0xE1F0, 0xDEAD, 0xDAF0, 0xD701, 0xD328, 
	0xCFAC, 0xCCD6, 0xCAED, 0xCA3A, 0xCCA2, 0xD264, 0xD952, 0xDF3B, 0xE1F0, 
	0xE0E4, 0xDDA5, 0xD931, 0xD482, 0xD093, 0xCE61, 0xCE81, 0xD04C, 0xD2E2, 
	0xD563, 0xD6F0, 0xD7A3, 0xD824, 0xD863, 0xD850, 0xD7D9, 0xD6F0, 0xD5A4, 
	0xD41B, 0xD261, 0xD081, 0xCE88, 0xCC82, 0xCA7C, 0xC881, 0xC69D, 0xC4DE, 
	0xC34E, 0xC1FA, 0xC0EF, 0xC02F, 0xBFAE, 0xBF64, 0xBF48, 0xBF51, 0xBF77, 
	0xBFB0, 0xBFF5, 0xC03C, 0xC07D, 0xC0AF, 0xC0C9, 0xC099, 0xC033, 0xBFFE, 
	0xC05D, 0xC1B6, 0xC472, 0xC84D, 0xCCA8, 0xD0DF, 0xD453, 0xD661, 0xD77B, 
	0xD877, 0xD950, 0xD9FF, 0xDA7D, 0xDAC3, 0xDACB, 0xDA8D, 0xDA05, 0xD929, 
	0xD7F5, 0xD661, 0xD20E, 0xCA53, 0xC1BF, 0xBADD, 0xB83B, 0xB8A5, 0xB933, 
	0xB9E4, 0xBAB7, 0xBBA8, 0xBCB8, 0xBDE4, 0xBF2B, 0xC08B, 0xC202, 0xC390, 
	0xC532, 0xC6E7, 0xC8AD, 0xCA83, 0xCC66, 0xCE57, 0xD052, 0xD257, 0xD463, 
	0xD676, 0xD88D, 0xDAA8, 0xDCC3, 0xDEDF, 0xE0F9, 0xE4E1, 0xEB20, 0xF1C7, 
	0xF6EA, 0xF89A, 0xF7D3, 0xF6DD, 0xF5BA, 0xF46E, 0xF2FD, 0xF16B, 0xEFBA, 
	0xEDEF, 0xEC0D, 0xEA17, 0xD7EF, 0xBC61, 0xAE25, 0xAE38, 0xAE7C, 0xAEFE, 
	0xAFCB, 0xB0F0, 0xB27B, 0xB473, 0xB6C5, 0xB957, 0xBC10, 0xBED7, 0xC191, 
	0xC426, 0xC67C, 0xC87A, 0xCA05, 0xCB05, 0xCB60, 0xFFF6, 0xFFEE, 0xFFDD, 
	0xFFD2, 0xFFD9, 0x0000, 0x0042, 0x0090, 0x00EA, 0x014B, 0x01B2, 0x021D, 
	0x0289, 0x02F4, 0x035B, 0x03C5, 0x0438, 0x04BD, 0x055B, 0x0578, 0x04EE, 
	0x0472, 0x04B9, 0x0676, 0x0A5F, 0x126B, 0x1E54, 0x2B79, 0x3734, 0x3EE2, 
	0x4273, 0x43F0, 0x43D4, 0x42A0, 0x40D0, 0x3EE2, 0x3CDB, 0x3A76, 0x37C7, 
	0x34DE, 0x31CE, 0x2EA9, 0x2B81, 0x2868, 0x256F, 0x22AA, 0x2029, 0x1DFF, 
	0x1C3E, 0x1AF9, 0x1A29, 0x19B8, 0x1992, 0x19A0, 0x19CD, 0x1A04, 0x1A30, 
	0x1A3A, 0x1A0F, 0x1998, 0x18BF, 0x16BC, 0x1368, 0x0F9F, 0x0C43, 0x0A2F, 
	0x0929, 0x0877, 0x0843, 0x08B6, 0x09F9, 0x0C34, 0x0F4A, 0x12EF, 0x1705, 
	0x1B6E, 0x200A, 0x24BB, 0x2964, 0x2DE5, 0x3221, 0x35F9, 0x394E, 0x3C02, 
	0x3CC1, 0x3B1C, 0x384F, 0x3595, 0x342A, 0x33E1, 0x33B6, 0x33A6, 0x33AE, 
	0x33CB, 0x33F8, 0x3433, 0x3479, 0x34C5, 0x3515, 0x3564, 0x35B1, 0x35F7, 
	0x3632, 0x3661, 0x367E, 0x3687, 0x3679, 0x364F, 0x3607, 0x359E, 0x350F, 
	0x3457, 0x3374, 0x3261, 0x311B, 0x2C5D, 0x22F5, 0x1801, 0x0E9E, 0x09E9, 
	0x08A3, 0x0778, 0x0665, 0x056C, 0x0489, 0x03BD, 0x0306, 0x0264, 0x01D4, 
	0x0157, 0x4621, 0xC5E0, 0x0AAB, 0x0A8F, 0x0A52, 0x0A15, 0x09F9, 0x09FC, 
	0x0A03, 0x0A0E, 0x0A1C, 0x0A2D, 0x0A3F, 0x0A52, 0x0A65, 0x0A77, 0x0A87, 
	0x0A96, 0x0AA1, 0x0AA8, 0x0AAB, 0xFA4F, 0x0001, 0x0003, 0x0006, 0x0009, 
	0x0007, 0x0000, 0xFFC9, 0xFF54, 0xFEC6, 0xFE42, 0xFDEC, 0xFDE9, 0xFE5B, 
	0xFF68, 0x022A, 0x06C2, 0x0BD9, 0x1017, 0x1228, 0x11B8, 0x0FC4, 0x0CEB, 
	0x09CC, 0x0706, 0x0539, 0x0494, 0x04A8, 0x0520, 0x05AB, 0x05F8, 0x05F4, 
	0x05D4, 0x05AE, 0x0599, 0x05AA, 0x05F8, 0x0679, 0x0712, 0x07BE, 0x0878, 
	0x093D, 0x0A06, 0x0AD0, 0x0B95, 0x0C51, 0x0D00, 0x0D9B, 0x0E1F, 0x0E87, 
	0x0ED1, 0x0F02, 0x0F1D, 0x0F25, 0x0F1F, 0x0F0E, 0x0EF6, 0x0EDB, 0x0EC0, 
	0x0EA9, 0x0E9A, 0x0E96, 0x0E9B, 0x0EA3, 0x0EAC, 0x0EB5, 0x0EBD, 0x0E86, 
	0x0E05, 0x0D83, 0x0D4C, 0x0DA8, 0x0EE3, 0x10D1, 0x130D, 0x1589, 0x1837, 
	0x1B0B, 0x1DF6, 0x20EB, 0x23DC, 0x26BB, 0x297C, 0x2C0F, 0x2E68, 0x306D, 
	0x320B, 0x3345, 0x341C, 0x3492, 0x34DF, 0x3538, 0x359B, 0x3606, 0x3677, 
	0x36EC, 0x3762, 0x37D9, 0x384D, 0x38BD, 0x3926, 0x3987, 0x39DE, 0x3A28, 
	0x3A64, 0x3A8F, 0x3AA7, 0x3AAA, 0x3A97, 0x3A6A, 0x3A23, 0x39BF, 0x393C, 
	0x3897, 0x37D0, 0x36E3, 0x330D, 0x2B41, 0x2212, 0x1A15, 0x15DB, 0x1467, 
	0x1301, 0x11A9, 0x1060, 0x0F24, 0x0DF6, 0x0CD6, 0x0BC4, 0x0ABE, 0x09C6, 
	0x0749, 0x0460, 0x02FA, 0x032D, 0x039E, 0x040F, 0x0442, 0x0437, 0x041A, 
	0x03EC, 0x03B2, 0x036E, 0x0324, 0x02D7, 0x028A, 0x0240, 0x01FC, 0x01C2, 
	0x0194, 0x0177, 0x016C, 0xF545, 0xF542, 0xF53C, 0xF537, 0xF53A, 0xF548, 
	0xF576, 0xF5C6, 0xF626, 0xF683, 0xF6CA, 0xF6E9, 0xF6CC, 0xF662, 0xF53F, 
	0xF356, 0xF11D, 0xEF0B, 0xED98, 0xEC9B, 0xEBB3, 0xEB01, 0xEAAA, 0xEACF, 
	0xEB93, 0xED94, 0xF0D1, 0xF47D, 0xF7CD, 0xF9F4, 0xFAC8, 0xFADC, 0xFA80, 
	0xFA05, 0xF9BC, 0xF9F4, 0xFA99, 0xFB5C, 0xFC38, 0xFD27, 0xFE22, 0xFF24, 
	0x0026, 0x0123, 0x0213, 0x02F2, 0x03B9, 0x0462, 0x04E7, 0x0549, 0x0592, 
	0x05C2, 0x05DD, 0x05E6, 0x05DE, 0x05CA, 0x05AB, 0x0584, 0x0557, 0x0528, 
	0x04FA, 0x04A1, 0x0406, 0x0347, 0x0284, 0x01DA, 0x0111, 0x0008, 0xFF03, 
	0xFE45, 0xFE0F, 0xFEA4, 0xFFE2, 0x016F, 0x033B, 0x0538, 0x0758, 0x098B, 
	0x0BC2, 0x0DF0, 0x1004, 0x11F1, 0x13A7, 0x1518, 0x15DF, 0x15DE, 0x156A, 
	0x14D8, 0x1480, 0x146E, 0x1475, 0x1491, 0x14BF, 0x14FC, 0x1544, 0x1595, 
	0x15EB, 0x1644, 0x169B, 0x16EE, 0x1739, 0x177A, 0x17AD, 0x17D0, 0x17DE, 
	0x17D4, 0x17B0, 0x176F, 0x170C, 0x1686, 0x15D8, 0x14FF, 0x13F9, 0x12C3, 
	0x1158, 0x0BF4, 0x0141, 0xF4E4, 0xEA80, 0xE5B9, 0xE50E, 0xE490, 0xE43D, 
	0xE411, 0xE40B, 0xE427, 0xE464, 0xE4BE, 0xE532, 0xE5BF, 0xECB5, 0xF7E6, 
	0xFDC2, 0xFD33, 0xFBF7, 0xFABC, 0xFA2D, 0xFA58, 0xFAD0, 0xFB89, 0xFC75, 
	0xFD88, 0xFEB4, 0xFFEE, 0x0129, 0x0255, 0x0368, 0x0454, 0x050D, 0x0585, 
	0x05B0, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xF61C, 0xEF72, 
	0xEC12, 0xEBFC, 0xEBE6, 0xEBD0, 0xEBBB, 0xEBA7, 0xEB93, 0xEB7F, 0xEB6C, 
	0xEB5A, 0xEB47, 0xEB36, 0xEB24, 0xEB13, 0xEB03, 0xEAF3, 0xEAE3, 0xEAD4, 
	0xEAC5, 0xEAB7, 0xEAA9, 0xEA9C, 0xEA8F, 0xEA82, 0xEA76, 0xEA6A, 0xEA5F, 
	0xEA54, 0xEA4A, 0xEA40, 0xEA36, 0xEA2D, 0xEA24, 0xEA1B, 0xEA13, 0xEA0C, 
	0xEA05, 0xE9FE, 0xE9F8, 0xE9F2, 0xE9EC, 0xE9E7, 0xE9E2, 0xE9DE, 0xE9DA, 
	0xE9D6, 0xE9D3, 0xE9D0, 0xE9CE, 0xE9CC, 0xE9CA, 0xE9C9, 0xE9C8, 0xE9C7, 
	0xE9C7, 0xE9C8, 0xE9C8, 0xE9C9, 0xE9CB, 0xE9CC, 0xE9CE, 0xE9D1, 0xE9D4, 
	0xE9D7, 0xE9DA, 0xE9DE, 0xE9E3, 0xE9E7, 0xE9EC, 0xE9F2, 0xE9F7, 0xE9FD, 
	0xEA04, 0xEA0B, 0xEA12, 0xEA19, 0xEA21, 0xEA29, 0xEA32, 0xEA3A, 0xEA44, 
	0xEA4D, 0xEA57, 0xEA61, 0xEA6C, 0xEA76, 0xEA82, 0xEA8D, 0xEA99, 0xEAA5, 
	0xEAB1, 0xEABE, 0xEACB, 0xEAD9, 0xEAE6, 0xEAF5, 0xEB03, 0xEB12, 0xEB21, 
	0xEB30, 0xEB3F, 0xEB4F, 0xEB60, 0xEB70, 0xEB81, 0xEB92, 0xEBA3, 0xEBB5, 
	0xEBC7, 0xEBD9, 0xEBEC, 0xEBFF, 0xEC12, 0xED02, 0xEF39, 0xF20C, 0xF4CF, 
	0xF824, 0xFBD8, 0xFE08, 0xFEA9, 0xFF01, 0xFF1B, 0xFF05, 0xFECC, 0xFE7E, 
	0xFE26, 0xFDD3, 0xFDD4, 0xFDD8, 0xFDDE, 0xFDE5, 0xFDEE, 0xFDF9, 0xFE05, 
	0xFE11, 0xFE1F, 0xFE2C, 0xFE3A, 0xFE47, 0xFE55, 0xFE61, 0xFE6D, 0xFE77, 
	0xFE81, 0xFE88, 0xFE8E, 0xFE92, 0xFE93, 0xEF34, 0xF1D0, 0xF322, 0xF32B, 
	0xF333, 0xF33B, 0xF343, 0xF34A, 0xF351, 0xF357, 0xF35E, 0xF364, 0xF369, 
	0xF36F, 0xF374, 0xF379, 0xF37D, 0xF381, 0xF385, 0xF389, 0xF38C, 0xF390, 
	0xF392, 0xF395, 0xF397, 0xF39A, 0xF39B, 0xF39D, 0xF39F, 0xF3A0, 0xF3A1, 
	0xF3A2, 0xF3A2, 0xF3A3, 0xF3A3, 0xF3A3, 0xF3A3, 0xF3A3, 0xF3A2, 0xF3A2, 
	0xF3A1, 0xF3A0, 0xF39F, 0xF39D, 0xF39C, 0xF39B, 0xF399, 0xF397, 0xF395, 
	0xF393, 0xF391, 0xF38F, 0xF38D, 0xF38A, 0xF388, 0xF385, 0xF383, 0xF380, 
	0xF37D, 0xF37A, 0xF377, 0xF375, 0xF372, 0xF36F, 0xF36C, 0xF369, 0xF365, 
	0xF362, 0xF35F, 0xF35C, 0xF359, 0xF356, 0xF353, 0xF350, 0xF34D, 0xF34A, 
	0xF347, 0xF344, 0xF341, 0xF33E, 0xF33B, 0xF338, 0xF336, 0xF333, 0xF331, 
	0xF32E, 0xF32C, 0xF32A, 0xF327, 0xF325, 0xF323, 0xF321, 0xF320, 0xF31E, 
	0xF31D, 0xF31B, 0xF31A, 0xF319, 0xF318, 0xF317, 0xF317, 0xF316, 0xF316, 
	0xF316, 0xF316, 0xF316, 0xF317, 0xF317, 0xF318, 0xF319, 0xF31B, 0xF31C, 
	0xF31E, 0xF320, 0xF322, 0xF333, 0xF364, 0xF3B8, 0xF430, 0xF51F, 0xF652, 
	0xF706, 0xF71C, 0xF707, 0xF6D6, 0xF699, 0xF65F, 0xF639, 0xF635, 0xF664, 
	0xF664, 0xF663, 0xF660, 0xF659, 0xF64F, 0xF640, 0xF62B, 0xF60F, 0xF5EA, 
	0xF5BD, 0xF586, 0xF544, 0xF4F5, 0xF49A, 0xF431, 0xF3B8, 0xF330, 0xF296, 
	0xF1EB, 0xF12D, 0xF05A, 0x8FF7, 0xA371, 0xAD4F, 0xAD90, 0xADCF, 0xAE0D, 
	0xAE49, 0xAE83, 0xAEBC, 0xAEF4, 0xAF29, 0xAF5D, 0xAF90, 0xAFC1, 0xAFF1, 
	0xB01F, 0xB04B, 0xB076, 0xB0A0, 0xB0C8, 0xB0EE, 0xB113, 0xB137, 0xB15A, 
	0xB17B, 0xB19A, 0xB1B8, 0xB1D5, 0xB1F1, 0xB20B, 0xB224, 0xB23B, 0xB252, 
	0xB267, 0xB27A, 0xB28D, 0xB29E, 0xB2AE, 0xB2BD, 0xB2CB, 0xB2D7, 0xB2E3, 
	0xB2ED, 0xB2F6, 0xB2FE, 0xB304, 0xB30A, 0xB30F, 0xB312, 0xB314, 0xB316, 
	0xB316, 0xB316, 0xB314, 0xB311, 0xB30E, 0xB309, 0xB303, 0xB2FD, 0xB2F5, 
	0xB2ED, 0xB2E4, 0xB2DA, 0xB2CF, 0xB2C3, 0xB2B6, 0xB2A8, 0xB29A, 0xB28B, 
	0xB27B, 0xB26A, 0xB259, 0xB246, 0xB233, 0xB220, 0xB20B, 0xB1F6, 0xB1E0, 
	0xB1CA, 0xB1B2, 0xB19B, 0xB182, 0xB169, 0xB14F, 0xB135, 0xB11A, 0xB0FF, 
	0xB0E3, 0xB0C6, 0xB0A9, 0xB08C, 0xB06E, 0xB04F, 0xB030, 0xB010, 0xAFF1, 
	0xAFD0, 0xAFAF, 0xAF8E, 0xAF6D, 0xAF4B, 0xAF28, 0xAF06, 0xAEE3, 0xAEBF, 
	0xAE9C, 0xAE78, 0xAE53, 0xAE2F, 0xAE0A, 0xADE5, 0xADC0, 0xAD9A, 0xAD74, 
	0xAD4F, 0xAB7D, 0xA72D, 0xA1A1, 0x9C1C, 0x9517, 0x8D33, 0x88F2, 0x88B2, 
	0x898D, 0x8B27, 0x8D22, 0x8F21, 0x90C6, 0x91B5, 0x9190, 0x9160, 0x9137, 
	0x9112, 0x90EE, 0x90C9, 0x909F, 0x906E, 0x9032, 0x8FE9, 0x8F8F, 0x8F23, 
	0x8EA0, 0x8E05, 0x8D4D, 0x8C77, 0x8B7F, 0x8A62, 0x891D, 0x87AE, 0x8611, 
	0x8444, 0x839E, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x36A0, 0x2818, 0x20BB, 0x208B, 0x205E, 0x2033, 0x200A, 
	0x1FE4, 0x1FC0, 0x1F9F, 0x1F7F, 0x1F62, 0x1F47, 0x1F2E, 0x1F17, 0x1F02, 
	0x1EEF, 0x1EDD, 0x1ECE, 0x1EC1, 0x1EB5, 0x1EAB, 0x1EA3, 0x1E9C, 0x1E97, 
	0x1E94, 0x1E92, 0x1E91, 0x1E92, 0x1E95, 0x1E98, 0x1E9D, 0x1EA3, 0x1EAB, 
	0x1EB3, 0x1EBD, 0x1EC8, 0x1ED3, 0x1EE0, 0x1EEE, 0x1EFC, 0x1F0C, 0x1F1C, 
	0x1F2D, 0x1F3F, 0x1F51, 0x1F64, 0x1F78, 0x1F8C, 0x1FA0, 0x1FB5, 0x1FCB, 
	0x1FE1, 0x1FF7, 0x200D, 0x2024, 0x203B, 0x2052, 0x2069, 0x2080, 0x2097, 
	0x20AE, 0x20C5, 0x20DC, 0x20F3, 0x2109, 0x2120, 0x2136, 0x214B, 0x2160, 
	0x2175, 0x2189, 0x219D, 0x21B0, 0x21C3, 0x21D5, 0x21E6, 0x21F7, 0x2207, 
	0x2215, 0x2223, 0x2231, 0x223D, 0x2248, 0x2252, 0x225B, 0x2263, 0x2269, 
	0x226F, 0x2273, 0x2276, 0x2277, 0x2277, 0x2276, 0x2273, 0x226F, 0x2269, 
	0x2261, 0x2258, 0x224D, 0x2240, 0x2231, 0x2221, 0x220E, 0x21FA, 0x21E4, 
	0x21CC, 0x21B1, 0x2195, 0x2176, 0x2156, 0x2132, 0x210D, 0x20E5, 0x20BB, 
	0x1D72, 0x1681, 0x0FC7, 0x0D25, 0x0E16, 0x0F7F, 0x1156, 0x1392, 0x162B, 
	0x1918, 0x1C50, 0x1FCB, 0x237F, 0x2764, 0x2B72, 0x2F43, 0x32BF, 0x35E9, 
	0x38C7, 0x3B5B, 0x3DAA, 0x3FB7, 0x4186, 0x431B, 0x447A, 0x45A7, 0x46A5, 
	0x4779, 0x4826, 0x48B0, 0x491C, 0x496C, 0x49A5, 0x49CB, 0x49E1, 0x49EB, 
	0x49EE, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0016, 
	0x003C, 0x0044, 0x0000, 0xFF70, 0xFEBB, 0xFDED, 0xFD0E, 0xFC2A, 0xFB4C, 
	0xFA7E, 0xF9CC, 0xF93F, 0xF8E3, 0xF82D, 0xF89D, 0xF96D, 0xF9DE, 0xF9CC, 
	0xF99D, 0xF959, 0xF908, 0xF8B2, 0xF861, 0xF819, 0xF7DD, 0xF7AC, 0xF783, 
	0xF763, 0xF74A, 0xF738, 0xF72B, 0xF722, 0xF71D, 0xF71B, 0xF71B, 0xF7AE, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFC, 0xFFF6, 
	0xFFF5, 0x0000, 0x0017, 0x0033, 0x0055, 0x0078, 0x009D, 0x00C1, 0x00E2, 
	0x00FE, 0x0115, 0x0124, 0x00B6, 0x00B5, 0x00AC, 0x0096, 0x004E, 0xFFCC, 
	0xFF31, 0xFE9C, 0xFE2B, 0xFDFF, 0xFE0D, 0xFE34, 0xFE6F, 0xFEB9, 0xFF0D, 
	0xFF66, 0xFFBF, 0x0014, 0x005F, 0x009A, 0x00C1, 0x00CF, 0x03C6, 0xE040, 
	0xE040, 0xE040, 0xE040, 0xE040, 0xE041, 0xE042, 0xE044, 0xE045, 0xE047, 
	0xE04A, 0xE04C, 0xE04F, 0xE052, 0xE055, 0xE059, 0xE05C, 0xE060, 0xE064, 
	0xE069, 0xE06D, 0xE072, 0xE077, 0xE07C, 0xE081, 0xE086, 0xE08B, 0xE091, 
	0xE097, 0xE09C, 0xE0A2, 0xE0A8, 0xE0AE, 0xE0B4, 0xE0BA, 0xE0C0, 0xE0C6, 
	0xE0CD, 0xE0D3, 0xE0D9, 0xE0DF, 0xE0E6, 0xE0EC, 0xE0F2, 0xE0F8, 0xE0FE, 
	0xE105, 0xE10B, 0xE110, 0xE116, 0xE11C, 0xE122, 0xE127, 0xE12D, 0xE132, 
	0xE137, 0xE13D, 0xE141, 0xE146, 0xE14B, 0xE14F, 0xE154, 0xE158, 0xE15B, 
	0xE15F, 0xE162, 0xE166, 0xE169, 0xE16B, 0xE16E, 0xE170, 0xE172, 0xE173, 
	0xE175, 0xE176, 0xE176, 0xE177, 0xE177, 0xE177, 0xE176, 0xE175, 0xE174, 
	0xE172, 0xE170, 0xE16D, 0xE16A, 0xE167, 0xE163, 0xE15F, 0xE15B, 0xE156, 
	0xE150, 0xE14A, 0xE144, 0xE13D, 0xE135, 0xE12D, 0xE125, 0xE11C, 0xE113, 
	0xE109, 0xE0FE, 0xE0F3, 0xE0E7, 0xE0DB, 0xE0CE, 0xE0C1, 0xE0B3, 0xE0A4, 
	0xE095, 0xE085, 0xE075, 0xE064, 0xE052, 0xE040, 0xDF56, 0xDD2E, 0xDA70, 
	0xD7C2, 0xD553, 0xD2E2, 0xD06C, 0xCDF0, 0xCB6B, 0xC8DB, 0xC63E, 0xC391, 
	0xC0D3, 0xBE01, 0xBB19, 0xBA2C, 0xBA10, 0xB942, 0xB6A0, 0xB29C, 0xAE0B, 
	0xA9C0, 0xA691, 0xA552, 0xA578, 0xA5E2, 0xA681, 0xA748, 0xA82B, 0xA91B, 
	0xAA0B, 0xAAED, 0xABB5, 0xAC54, 0xACBD, 0xACE3, 0xAB92, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x0D37, 0x0D37, 
	0x0D37, 0x0D37, 0x0D38, 0x0D38, 0x0D39, 0x0D3A, 0x0D3B, 0x0D3C, 0x0D3E, 
	0x0D3F, 0x0D40, 0x0D42, 0x0D44, 0x0D45, 0x0D47, 0x0D49, 0x0D4B, 0x0D4D, 
	0x0D4F, 0x0D52, 0x0D54, 0x0D56, 0x0D59, 0x0D5B, 0x0D5E, 0x0D60, 0x0D63, 
	0x0D66, 0x0D68, 0x0D6B, 0x0D6E, 0x0D71, 0x0D73, 0x0D76, 0x0D79, 0x0D7C, 
	0x0D7F, 0x0D82, 0x0D84, 0x0D87, 0x0D8A, 0x0D8D, 0x0D90, 0x0D92, 0x0D95, 
	0x0D98, 0x0D9B, 0x0D9D, 0x0DA0, 0x0DA2, 0x0DA5, 0x0DA7, 0x0DAA, 0x0DAC, 
	0x0DAE, 0x0DB0, 0x0DB2, 0x0DB4, 0x0DB6, 0x0DB8, 0x0DBA, 0x0DBC, 0x0DBD, 
	0x0DBF, 0x0DC0, 0x0DC1, 0x0DC2, 0x0DC3, 0x0DC4, 0x0DC5, 0x0DC6, 0x0DC6, 
	0x0DC6, 0x0DC7, 0x0DC7, 0x0DC7, 0x0DC6, 0x0DC6, 0x0DC6, 0x0DC5, 0x0DC4, 
	0x0DC3, 0x0DC2, 0x0DC0, 0x0DBF, 0x0DBD, 0x0DBB, 0x0DB9, 0x0DB6, 0x0DB4, 
	0x0DB1, 0x0DAE, 0x0DAB, 0x0DA7, 0x0DA4, 0x0DA0, 0x0D9C, 0x0D97, 0x0D93, 
	0x0D8E, 0x0D89, 0x0D83, 0x0D7E, 0x0D78, 0x0D72, 0x0D6B, 0x0D65, 0x0D5E, 
	0x0D56, 0x0D4F, 0x0D47, 0x0D3F, 0x0D37, 0x0CA2, 0x0B5F, 0x0A0C, 0x0949, 
	0x0916, 0x0906, 0x0910, 0x092B, 0x094F, 0x0973, 0x098F, 0x0999, 0x098A, 
	0x0959, 0x08FC, 0x08A5, 0x085F, 0x0827, 0x07FD, 0x07DD, 0x07C8, 0x07BA, 
	0x07B2, 0x07AE, 0x07AD, 0x07AD, 0x07AC, 0x07A9, 0x07A1, 0x0793, 0x077D, 
	0x075E, 0x0733, 0x06FC, 0x06B5, 0x065F, 0x01C0, 0x0693, 0x0693, 0x0693, 
	0x0692, 0x0692, 0x0692, 0x0692, 0x0691, 0x0691, 0x0691, 0x0690, 0x0690, 
	0x068F, 0x068E, 0x068E, 0x068D, 0x068C, 0x068C, 0x068B, 0x068A, 0x0689, 
	0x0688, 0x0687, 0x0687, 0x0686, 0x0685, 0x0684, 0x0683, 0x0682, 0x0681, 
	0x0680, 0x067F, 0x067E, 0x067C, 0x067B, 0x067A, 0x0679, 0x0678, 0x0677, 
	0x0676, 0x0675, 0x0674, 0x0673, 0x0672, 0x0671, 0x066F, 0x066E, 0x066D, 
	0x066C, 0x066B, 0x066A, 0x0669, 0x0668, 0x0668, 0x0667, 0x0666, 0x0665, 
	0x0664, 0x0663, 0x0662, 0x0662, 0x0661, 0x0660, 0x0660, 0x065F, 0x065F, 
	0x065E, 0x065E, 0x065D, 0x065D, 0x065C, 0x065C, 0x065C, 0x065C, 0x065C, 
	0x065B, 0x065B, 0x065B, 0x065C, 0x065C, 0x065C, 0x065C, 0x065C, 0x065D, 
	0x065D, 0x065E, 0x065F, 0x065F, 0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 
	0x0665, 0x0666, 0x0668, 0x0669, 0x066A, 0x066C, 0x066E, 0x066F, 0x0671, 
	0x0673, 0x0675, 0x0677, 0x067A, 0x067C, 0x067F, 0x0681, 0x0684, 0x0687, 
	0x0689, 0x068C, 0x0690, 0x0693, 0x06DB, 0x0770, 0x07F7, 0x0815, 0x07CE, 
	0x076A, 0x06F0, 0x0666, 0x05D5, 0x0544, 0x04B9, 0x043C, 0x03D4, 0x0389, 
	0x0362, 0x0376, 0x03B1, 0x040E, 0x048A, 0x0521, 0x05CF, 0x0692, 0x0765, 
	0x0845, 0x092D, 0x0A1B, 0x0B0A, 0x0BF8, 0x0CE0, 0x0DBE, 0x0E90, 0x0F51, 
	0x0FFE, 0x1093, 0x110D, 0x1167, 0x1192, 0xB48F, 0xB48F, 0xB491, 0xB493, 
	0xB496, 0xB49A, 0xB49E, 0xB4A4, 0xB4AA, 0xB4B0, 0xB4B8, 0xB4C0, 0xB4C9, 
	0xB4D2, 0xB4DC, 0xB4E7, 0xB4F2, 0xB4FD, 0xB509, 0xB516, 0xB523, 0xB531, 
	0xB53E, 0xB54D, 0xB55B, 0xB56A, 0xB579, 0xB589, 0xB599, 0xB5A9, 0xB5B9, 
	0xB5C9, 0xB5DA, 0xB5EB, 0xB5FB, 0xB60C, 0xB61D, 0xB62E, 0xB640, 0xB651, 
	0xB662, 0xB673, 0xB684, 0xB694, 0xB6A5, 0xB6B6, 0xB6C6, 0xB6D6, 0xB6E6, 
	0xB6F6, 0xB706, 0xB715, 0xB724, 0xB732, 0xB741, 0xB74F, 0xB75C, 0xB769, 
	0xB776, 0xB782, 0xB78D, 0xB798, 0xB7A3, 0xB7AD, 0xB7B6, 0xB7BF, 0xB7C7, 
	0xB7CF, 0xB7D5, 0xB7DB, 0xB7E1, 0xB7E5, 0xB7E9, 0xB7EC, 0xB7EE, 0xB7F0, 
	0xB7F0, 0xB7F0, 0xB7EE, 0xB7EC, 0xB7E9, 0xB7E4, 0xB7DF, 0xB7D9, 0xB7D1, 
	0xB7C9, 0xB7BF, 0xB7B4, 0xB7A9, 0xB79B, 0xB78D, 0xB77E, 0xB76D, 0xB75B, 
	0xB747, 0xB733, 0xB71D, 0xB705, 0xB6EC, 0xB6D2, 0xB6B7, 0xB699, 0xB67B, 
	0xB65B, 0xB639, 0xB616, 0xB5F1, 0xB5CA, 0xB5A2, 0xB579, 0xB54D, 0xB520, 
	0xB4F1, 0xB4C1, 0xB48E, 0xB130, 0xA9CF, 0xA1E7, 0x9CF4, 0x9AFB, 0x9999, 
	0x98AA, 0x980B, 0x979C, 0x9738, 0x96BF, 0x960D, 0x94FF, 0x9375, 0x914A, 
	0x8F97, 0x8E36, 0x8D1F, 0x8C49, 0x8BAC, 0x8B3F, 0x8AF9, 0x8AD1, 0x8AC0, 
	0x8ABB, 0x8ABB, 0x8AB6, 0x8AA4, 0x8A7D, 0x8A37, 0x89C9, 0x892C, 0x8857, 
	0x8740, 0x85DF, 0x842B, 0xFFFF, 0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 
	0x0003, 0x0004, 0x0006, 0x0007, 0x0009, 0x000B, 0x000D, 0x000F, 0x0011, 
	0x0014, 0x0016, 0x0019, 0x001C, 0x001F, 0x0022, 0x0026, 0x0029, 0x002D, 
	0x0030, 0x0034, 0x0038, 0x003C, 0x0040, 0x0045, 0x0049, 0x004E, 0x0052, 
	0x0057, 0x005C, 0x0061, 0x0066, 0x006B, 0x0071, 0x0076, 0x007C, 0x0081, 
	0x0087, 0x008C, 0x0092, 0x0098, 0x009E, 0x00A4, 0x00AA, 0x00B0, 0x00B7, 
	0x00BD, 0x00C3, 0x00CA, 0x00D0, 0x00D7, 0x00DD, 0x00E4, 0x00EB, 0x00F1, 
	0x00F8, 0x00FF, 0x0106, 0x010C, 0x0113, 0x011A, 0x0121, 0x0128, 0x012F, 
	0x0136, 0x013D, 0x0144, 0x014B, 0x0152, 0x0159, 0x0160, 0x0167, 0x016E, 
	0x0175, 0x017C, 0x0183, 0x018A, 0x0191, 0x0198, 0x019F, 0x01A6, 0x01AD, 
	0x01B4, 0x01BB, 0x01C2, 0x01C8, 0x01CF, 0x01D6, 0x01DD, 0x01E3, 0x01EA, 
	0x01F0, 0x01F7, 0x01FD, 0x0204, 0x020A, 0x0210, 0x0216, 0x021C, 0x0222, 
	0x0228, 0x022E, 0x0234, 0x023A, 0x023F, 0x0245, 0x024A, 0x0250, 0x0255, 
	0x025A, 0x025F, 0x0264, 0x0269, 0x026E, 0x0273, 0x0277, 0x027C, 0x0280, 
	0x0284, 0x0288, 0x028C, 0x0290, 0x0294, 0x0297, 0x029B, 0x029E, 0x02A1, 
	0x02A4, 0x02A7, 0x02AA, 0x02AD, 0x02AF, 0x02B1, 0x02B4, 0x02B6, 0x02B7, 
	0x02B9, 0x02BB, 0x02BC, 0x02BD, 0x02BE, 0x02BF, 0x02C0, 0x02C0, 0x02C0, 
	0x02C0, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x1624, 0x1624, 0x1624, 0x1625, 0x1626, 0x1628, 0x162A, 0x162C, 
	0x162E, 0x1630, 0x1633, 0x1636, 0x163A, 0x163D, 0x1641, 0x1645, 0x1649, 
	0x164E, 0x1652, 0x1657, 0x165C, 0x1661, 0x1666, 0x166C, 0x1671, 0x1677, 
	0x167D, 0x1683, 0x1689, 0x168F, 0x1695, 0x169B, 0x16A1, 0x16A8, 0x16AE, 
	0x16B5, 0x16BB, 0x16C2, 0x16C8, 0x16CF, 0x16D5, 0x16DB, 0x16E2, 0x16E8, 
	0x16EF, 0x16F5, 0x16FB, 0x1701, 0x1707, 0x170D, 0x1713, 0x1719, 0x171F, 
	0x1724, 0x172A, 0x172F, 0x1734, 0x1739, 0x173E, 0x1742, 0x1747, 0x174B, 
	0x174F, 0x1753, 0x1756, 0x175A, 0x175D, 0x1760, 0x1762, 0x1764, 0x1766, 
	0x1768, 0x176A, 0x176B, 0x176C, 0x176C, 0x176C, 0x176C, 0x176C, 0x176B, 
	0x1769, 0x1768, 0x1766, 0x1763, 0x1761, 0x175D, 0x175A, 0x1756, 0x1751, 
	0x174C, 0x1747, 0x1741, 0x173A, 0x1734, 0x172C, 0x1724, 0x171C, 0x1713, 
	0x170A, 0x1700, 0x16F5, 0x16EA, 0x16DF, 0x16D2, 0x16C6, 0x16B8, 0x16AA, 
	0x169C, 0x168C, 0x167D, 0x166C, 0x165B, 0x1649, 0x1637, 0x1624, 0x146C, 
	0x10E3, 0x0DBD, 0x0D2D, 0x0ECC, 0x10B6, 0x12E8, 0x155D, 0x1811, 0x1B00, 
	0x1E26, 0x217E, 0x2505, 0x28B6, 0x2C8C, 0x3022, 0x3362, 0x364F, 0x38F0, 
	0x3B49, 0x3D5E, 0x3F35, 0x40D1, 0x423A, 0x4372, 0x447E, 0x4565, 0x4629, 
	0x46D1, 0x4761, 0x47DE, 0x484D, 0x48B2, 0x4912, 0x4973, 0x49D9, 0x4A21, 
	0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 
	0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 
	0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF7E, 
	0xFF7E, 0xFF7E, 0xFF7E, 0xFF7E, 0xFF7E, 0xFF7E, 0xFF7E, 0xFF7E, 0xFF7D, 
	0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7C, 
	0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 
	0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 
	0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 
	0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 
	0xFF7A, 0xFF7A, 0xFF7A, 0xFF7A, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 
	0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7C, 0xFF7C, 0xFF7C, 0xFF7C, 
	0xFF7C, 0xFF7C, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7E, 0xFF7E, 
	0xFF7E, 0xFF7E, 0xFF7F, 0xFF7F, 0xFF7F, 0xFF80, 0xFF80, 0xFF8A, 0xFF9F, 
	0xFFAE, 0xFFA8, 0xFF8D, 0xFF68, 0xFF3C, 0xFF0C, 0xFEDB, 0xFEAB, 0xFE80, 
	0xFE5D, 0xFE44, 0xFE38, 0xFDDD, 0xFD56, 0xFD24, 0xFD1D, 0xFD90, 0xFEB4, 
	0x003E, 0x01DC, 0x0342, 0x0422, 0x0491, 0x04DB, 0x0508, 0x051F, 0x0528, 
	0x0529, 0x052A, 0x0533, 0x054A, 0x0577, 0x05C1, 0x062F, 0x09D3, 0xFF5A, 
	0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 
	0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 
	0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 0xFF5B, 
	0xFF5B, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF59, 
	0xFF58, 0xFF57, 0xFF55, 0xFF54, 0xFF52, 0xFF51, 0xFF4F, 0xFF4E, 0xFF4C, 
	0xFF4B, 0xFF49, 0xFF48, 0xFF6B, 0xFFAD, 0xFFD0, 0xFFAF, 0xFF56, 0xFED9, 
	0xFE4A, 0xFDBA, 0xFD3D, 0xFCE0, 0xFCA1, 0xFC77, 0xFC5D, 0xFC49, 0xFC36, 
	0xFC1B, 0xFBF2, 0xFBB3, 0xFB56, 0xFAD5, 0xFA28, 0xFE32, 0xE4BC, 0xE4BC, 
	0xE4BD, 0xE4BE, 0xE4BF, 0xE4C0, 0xE4C2, 0xE4C3, 0xE4C6, 0xE4C8, 0xE4CB, 
	0xE4CD, 0xE4D1, 0xE4D4, 0xE4D7, 0xE4DB, 0xE4DF, 0xE4E3, 0xE4E7, 0xE4EC, 
	0xE4F0, 0xE4F5, 0xE4FA, 0xE4FF, 0xE504, 0xE50A, 0xE50F, 0xE514, 0xE51A, 
	0xE520, 0xE525, 0xE52B, 0xE531, 0xE537, 0xE53D, 0xE543, 0xE549, 0xE54F, 
	0xE555, 0xE55B, 0xE561, 0xE567, 0xE56D, 0xE573, 0xE579, 0xE57F, 0xE585, 
	0xE58A, 0xE590, 0xE595, 0xE59B, 0xE5A0, 0xE5A6, 0xE5AB, 0xE5B0, 0xE5B5, 
	0xE5B9, 0xE5BE, 0xE5C2, 0xE5C7, 0xE5CB, 0xE5CF, 0xE5D3, 0xE5D6, 0xE5D9, 
	0xE5DC, 0xE5DF, 0xE5E2, 0xE5E4, 0xE5E6, 0xE5E8, 0xE5EA, 0xE5EB, 0xE5EC, 
	0xE5ED, 0xE5EE, 0xE5EE, 0xE5EE, 0xE5ED, 0xE5EC, 0xE5EB, 0xE5EA, 0xE5E8, 
	0xE5E6, 0xE5E3, 0xE5E0, 0xE5DC, 0xE5D9, 0xE5D4, 0xE5D0, 0xE5CB, 0xE5C5, 
	0xE5BF, 0xE5B9, 0xE5B2, 0xE5AB, 0xE5A3, 0xE59B, 0xE592, 0xE589, 0xE57F, 
	0xE575, 0xE56A, 0xE55F, 0xE553, 0xE546, 0xE539, 0xE52C, 0xE51D, 0xE50F, 
	0xE4FF, 0xE4EF, 0xE4DF, 0xE4CE, 0xE4BC, 0xE3E7, 0xE1E3, 0xDF37, 0xDC65, 
	0xD99D, 0xD6B6, 0xD3B8, 0xD0A7, 0xCD8A, 0xCA67, 0xC745, 0xC42A, 0xC11C, 
	0xBE20, 0xBB3E, 0xBAFB, 0xBAF6, 0xBAB3, 0xB92B, 0xB62A, 0xB273, 0xAECA, 
	0xABF1, 0xAAAD, 0xAA7C, 0xAA5B, 0xAA47, 0xAA3D, 0xAA39, 0xAA39, 0xAA38, 
	0xAA34, 0xAA2A, 0xAA16, 0xA9F6, 0xA9C5, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0098, 0x0001, 0x0081, 0x0099, 0x0001, 0x011A, 0x0001, 
	0x011B, 0x0001, 0x011C, 0x0002, 0x011D, 0x008D, 0x011F, 0x0097, 0x01AC, 
	0x0097, 0x0243, 0x0097, 0x02DA, 0x0097, 0x0371, 0x0097, 0x0408, 0x0093, 
	0x049F, 0x0098, 0x0532, 0x0001, 0x05CA, 0x0001, 0x05CB, 0x0001, 0x05CC, 
	0x0097, 0x05CD, 0x0097, 0x0664, 0x0097, 0x06FB, 0x0098, 0x0792, 0x0097, 
	0x082A, 0x0097, 0x08C1, 0x0097, 0x0958, 0x0096, 0x09EF, 0x0097, 0x0A85, 
	0x0001, 0x0B1C, 0x0001, 0x0B1D, 0x0001, 0x0B1E, 0x0097, 0x0B1F, 0x0097, 
	0x0BB6, 0x0097, 0x0C4D, 0x0097, 0x0CE4, 0x0094, 0x0D7B, 0x0097, 0x0E0F, 
	0x0098, 0x0EA6, 0x0097, 0x0F3E, 0x0097, 0x0FD5, 0x0092, 0x106C, 0x0093, 
	0x10FE, 0x0001, 0x1191, 0x0097, 0x1192, 0x0097, 0x1229, 0x0098, 0x12C0, 
	0x0025, 0x1358, 0x0098, 0x137D, 0x0098, 0x1415, 0x0098, 0x14AD, 0x0098, 
	0x1545, 0x0098, 0x15DD, 0x0093, 0x1675, 0x0095, 0x1708, 0x0001, 0x179D, 
	0x0098, 0x179E, 0x0098, 0x1836, 0x0097, 0x18CE, 0x0098, 0x1965, 0x0098, 
	0x19FD, 0x0098, 0x1A95, 0x0098, 0x1B2D, 0x0098, 0x1BC5, 0x0098, 0x1C5D, 
	

});

smlua_anim_util_register_animation('donkey_57_general_land',1, 0, 9, 0, 23, { 
	0x0000, 0x006A, 0x006A, 0x006A, 0x006A, 0x006A, 0x006A, 0x006A, 0x006A, 
	0x006A, 0x00B4, 0x009A, 0x0088, 0x007D, 0x007A, 0x0075, 0x0073, 0x0074, 
	0x0078, 0x007D, 0x0082, 0x0087, 0x008A, 0x008B, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFE, 0xFFFD, 
	0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
	0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x430C, 0x45B9, 
	0x40A1, 0x4C9E, 0x552F, 0x5A52, 0x5C09, 0x5C09, 0x5C09, 0x5BC2, 0x5AFC, 
	0x59DE, 0x58A0, 0x5782, 0x56BC, 0x5675, 0x09BB, 0x0998, 0x0936, 0x08A2, 
	0x07E9, 0x0717, 0x0638, 0x0559, 0x0486, 0x0112, 0x009A, 0x0045, 0x0011, 
	0x0000, 0x00BE, 0x008D, 0x0005, 0xFF39, 0xFE37, 0xFD13, 0xFBDE, 0xFAA7, 
	0xF981, 0xFFFF, 0x0000, 0xFFBD, 0x0013, 0x0102, 0x026A, 0x042E, 0x062E, 
	0x084D, 0x0A6C, 0x0C6D, 0x0B88, 0x0BED, 0x0C36, 0x0C61, 0x0C70, 0x0DA7, 
	0x0E0E, 0x0D8A, 0x0C18, 0x0A00, 0x07AE, 0x0596, 0x0423, 0x039F, 0xF78A, 
	0xF7B1, 0xF820, 0xF8C9, 0xF9A2, 0xFA9E, 0xFBB1, 0xFCCE, 0xFDEB, 0xFE53, 
	0xFF18, 0xFF90, 0xFFD1, 0xFFF1, 0xFFFC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x042F, 0x0436, 0x0449, 0x0465, 
	0x0487, 0x04AC, 0x04D0, 0x04F1, 0x050B, 0xFF71, 0xFFB2, 0xFFDA, 0xFFF0, 
	0xFFFA, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x1AE7, 0x1A0D, 0x17BB, 0x144E, 0x1023, 0x0B97, 0x0706, 
	0x02CC, 0xFF48, 0x081B, 0xFE24, 0xF818, 0xF4C4, 0xF331, 0xF29B, 0xF278, 
	0xF276, 0xF23F, 0xF1A8, 0xF0CC, 0xEFD8, 0xEEFD, 0xEE65, 0xEE2F, 0xFFFE, 
	0x0001, 0xC170, 0xAD62, 0xB121, 0xBB7F, 0xCB2B, 0xDED6, 0xF52F, 0x0CE7, 
	0xA4AB, 0xBB2E, 0xC04D, 0xC659, 0xD87F, 0xEAA4, 0xF0B1, 0xED0F, 0xEBD9, 
	0xED85, 0xF289, 0xFAE6, 0x069B, 0x137D, 0x1B39, 0x1DCC, 0xB50C, 0xB4A6, 
	0xB38D, 0xB1E4, 0xAFCE, 0xAD70, 0xAAED, 0xD796, 0xD9F9, 0xCF99, 0xD1E8, 
	0xD8D5, 0xDFC1, 0xE210, 0xE28D, 0xE2B7, 0xE236, 0xE0B6, 0xDE35, 0xDAB4, 
	0xD9C3, 0xD932, 0xD901, 0x054A, 0x0245, 0xF9E8, 0xED45, 0xDD69, 0xCB64, 
	0xB845, 0x251C, 0x12F5, 0xF5D2, 0xF25B, 0xE7F4, 0xDD8E, 0xDA16, 0xDEA2, 
	0xE026, 0xDEC0, 0xDA8C, 0xD38A, 0xC9BC, 0xC01B, 0xBA54, 0xB867, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xDB6B, 0xDB33, 0xDA98, 
	0xD9AF, 0xD889, 0xD73C, 0xD5DB, 0xD478, 0xD329, 0xD2B7, 0xCE82, 0xC1E4, 
	0xB545, 0xB110, 0xAD55, 0xAC16, 0xAD4E, 0xB0F6, 0xB70F, 0xBEFB, 0xC514, 
	0xC8BC, 0xC9F4, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x7FFF, 0x7FFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x023E, 0x08F6, 0x0FAF, 0x11ED, 0x1503, 0x160A, 
	0x156E, 0x139A, 0x108E, 0x0C98, 0x098C, 0x07B8, 0x071C, 0xF97B, 0xF0ED, 
	0xD9FF, 0xB8CD, 0xEE8D, 0x17F6, 0x40AE, 0x1F7C, 0x088E, 0xFFFF, 0x0076, 
	0x01D9, 0x033C, 0x03B3, 0x0463, 0x049E, 0x048E, 0x045C, 0x0408, 0x039C, 
	0x0348, 0x0316, 0x0306, 0xED8B, 0xE4E9, 0xCDC5, 0xAC45, 0x048F, 0xDAC4, 
	0x330D, 0x118D, 0xFA68, 0xF1C6, 0xF48D, 0xFCE1, 0x0536, 0x07FD, 0x06E5, 
	0x0687, 0x06B1, 0x0730, 0x0802, 0x0914, 0x09E7, 0x0A65, 0x0A90, 0xFFFE, 
	0x0001, 0xC170, 0x3B5A, 0x3743, 0x2C0C, 0x1B4A, 0x0692, 0x6F7B, 0x5799, 
	0x4081, 0x2BCA, 0x3213, 0x32AC, 0x3477, 0x3641, 0x36DA, 0x4DDE, 0x4E55, 
	0x4F97, 0x5175, 0x53BC, 0x29C5, 0x273F, 0x24E3, 0x22E2, 0x2F46, 0x309C, 
	0x349B, 0x389B, 0x39F0, 0x35AC, 0x3440, 0x3595, 0x3997, 0x4044, 0x48F1, 
	0x4F9E, 0x53A0, 0x54F5, 0xCB05, 0xC85D, 0xC115, 0xB632, 0xA8B8, 0x19AD, 
	0x0A16, 0xFAF7, 0xED56, 0xFCD7, 0xFE4A, 0x02A3, 0x06FB, 0x086D, 0x086D, 
	0x086D, 0x0909, 0x0ADD, 0x0DEA, 0x11E0, 0x14EC, 0x16C0, 0x175C, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xF16B, 0xF0D5, 0xEF36, 
	0xECC6, 0xE9BA, 0xE649, 0xE2AA, 0xDF14, 0xDBBC, 0xD757, 0xD21C, 0xC26D, 
	0xB2BD, 0xAD82, 0xA9C6, 0xA888, 0xA9F4, 0xAE38, 0xB555, 0xBE93, 0xC5B0, 
	0xC9F4, 0xCB60, 0x0000, 0xFFB4, 0xFEEA, 0xFDC6, 0xFC6B, 0xFAFF, 0xF9A4, 
	0xF880, 0xF7B7, 0xF76B, 0xF7CD, 0xF8F3, 0xFA18, 0xFA7A, 0xFA55, 0xFA49, 
	0xFA48, 0xFA48, 0xFA46, 0xFA44, 0xFA43, 0xFA42, 0xFFFF, 0x0085, 0x01E9, 
	0x03ED, 0x0650, 0x08D3, 0x0B37, 0x0D3A, 0x0E9E, 0x0F23, 0x0D87, 0x08B1, 
	0x03DB, 0x023E, 0x01D4, 0x01B0, 0x01AF, 0x01AC, 0x01A7, 0x01A0, 0x019B, 
	0x0198, 0x0197, 0xF548, 0xEC63, 0xD48C, 0xB208, 0x891D, 0x5E0F, 0x3523, 
	0x12A0, 0xFAC8, 0xF1E2, 0xF501, 0xFE5C, 0x07B8, 0x0AD6, 0x07D6, 0x06D5, 
	0x06CE, 0x06B8, 0x0694, 0x0665, 0x0641, 0x062B, 0x0624, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 
	0xBF5E, 0xBF5E, 0xBF5E, 0xBF5E, 0xBF5E, 0xBF5E, 0xBF85, 0xBFC6, 0xBFD3, 
	0xBF5E, 0xBB4B, 0xBF5E, 0x000F, 0x002B, 0x0068, 0x00A5, 0x00C1, 0x009A, 
	0x000F, 0xFEB7, 0xFC9C, 0xFEAA, 0x0230, 0x04B3, 0x0635, 0x06B5, 0x08D6, 
	0x098C, 0x0901, 0x077D, 0x054B, 0x02DC, 0x00AB, 0xFF26, 0xFE9B, 0xEB4F, 
	0xEB48, 0xEB3A, 0xEB2C, 0xEB25, 0xEB2E, 0xEB4F, 0xEBA3, 0xEC29, 0xEEA3, 
	0xEFCF, 0xF0A5, 0xF126, 0xF151, 0xF288, 0xF2EF, 0xF2CA, 0xF260, 0xF1C8, 
	0xF120, 0xF088, 0xF01F, 0xEFF9, 0x72E2, 0x728D, 0x71D1, 0x7115, 0x70C0, 
	0x7137, 0x72E2, 0x7708, 0x7D8B, 0x79CC, 0x74A9, 0x70FE, 0x6ECA, 0x6E0E, 
	0x67B4, 0x6596, 0x6713, 0x6B3D, 0x7143, 0x77F2, 0x7DF7, 0x8222, 0x839E, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x4C54, 0x4C54, 0x4C55, 0x4C56, 0x4C57, 0x4C56, 0x4C54, 0x4C11, 0x4BA4, 
	0x4884, 0x514E, 0x5795, 0x5B59, 0x5C9B, 0x62F5, 0x6514, 0x63BB, 0x5FF7, 
	0x5A86, 0x547B, 0x4F0A, 0x4B46, 0x49EE, 0x0000, 0x0005, 0x0012, 0x001F, 
	0x0024, 0x001C, 0xFFFF, 0xFF97, 0xFEF0, 0x0000, 0xFC2B, 0xF96E, 0xF7CA, 
	0xF73E, 0xF74D, 0xF751, 0xF756, 0xF763, 0xF775, 0xF78A, 0xF79C, 0xF7A9, 
	0xF7AE, 0x0000, 0xFFF9, 0xFFEA, 0xFFDC, 0xFFD5, 0xFFDF, 0x0000, 0x0063, 
	0x0101, 0x0000, 0x0122, 0x01F1, 0x026D, 0x0296, 0x02C6, 0x02D6, 0x02E1, 
	0x0303, 0x0333, 0x0368, 0x0399, 0x03BA, 0x03C6, 0xE040, 0xDFE2, 0xDEC4, 
	0xDCE2, 0xDA35, 0xD6B8, 0xD265, 0xCBE0, 0xC2F4, 0xD467, 0xC019, 0xB198, 
	0xA8E4, 0xA5FE, 0xA6D8, 0xA721, 0xA759, 0xA7F7, 0xA8DB, 0xA9D8, 0xAABC, 
	0xAB5A, 0xAB92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF5E, 0x0D37, 0x0D6C, 0x0DEC, 0x0E8A, 0x0F18, 0x0F69, 0x0F4E, 
	0x0E72, 0x0CE9, 0xFFFF, 0xFCD3, 0xFA8F, 0xF933, 0xF8BF, 0xF642, 0xF56E, 
	0xF60A, 0xF7C0, 0xFA38, 0xFCF5, 0xFF6D, 0x0124, 0x01C0, 0x0693, 0x0635, 
	0x055D, 0x046A, 0x03BA, 0x03AF, 0x04A6, 0x079E, 0x0C76, 0xFFFF, 0x0714, 
	0x0C23, 0x0F2C, 0x102E, 0x0EC6, 0x0E4E, 0x0E78, 0x0EEC, 0x0F93, 0x104D, 
	0x10F5, 0x1169, 0x1192, 0xB48E, 0xB5DC, 0xB901, 0xBCD7, 0xC037, 0xC1FB, 
	0xC0FC, 0xBAD3, 0xAFFB, 0xB90D, 0x9855, 0x80F5, 0x72F0, 0x6E43, 0x677D, 
	0x653B, 0x66C3, 0x6B0E, 0x7142, 0x7824, 0x7E58, 0x82A3, 0x842B, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x1624, 0x14F1, 0x1232, 0x0F27, 0x0D13, 0x0D38, 0x10D8, 
	0x1B62, 0x2C6F, 0x0F93, 0x315D, 0x497F, 0x57FA, 0x5CCE, 0x6392, 0x65D4, 
	0x6474, 0x609D, 0x5B0F, 0x54E5, 0x4F58, 0x4B80, 0x4A21, 0xFF80, 0xFF5B, 
	0xFF08, 0xFEB5, 0xFE8E, 0xFEBF, 0xFF75, 0x0147, 0x0426, 0xFFFF, 0x045D, 
	0x077B, 0x095A, 0x09F9, 0x09F4, 0x09F3, 0x09F1, 0x09ED, 0x09E6, 0x09DF, 
	0x09D9, 0x09D4, 0x09D3, 0xFF5A, 0xFF54, 0xFF45, 0xFF36, 0xFF31, 0xFF3D, 
	0xFF64, 0xFFC5, 0x005D, 0xFFFF, 0xFFCF, 0xFFAD, 0xFF98, 0xFF91, 0xFF43, 
	0xFF29, 0xFF1D, 0xFEFB, 0xFEC9, 0xFE92, 0xFE61, 0xFE3F, 0xFE32, 0xE4BC, 
	0xE5D6, 0xE854, 0xEAFA, 0xEC8F, 0xEBD6, 0xE796, 0xDC29, 0xC9F3, 0xD659, 
	0xC14D, 0xB244, 0xA93E, 0xA63D, 0xA775, 0xA7DD, 0xA80F, 0xA899, 0xA961, 
	0xAA3F, 0xAB07, 0xAB91, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0017, 0x0001, 0x0016, 0x0018, 0x0001, 0x002E, 0x0001, 
	0x002F, 0x0001, 0x0030, 0x000B, 0x0031, 0x0015, 0x003C, 0x0017, 0x0051, 
	0x000E, 0x0068, 0x000B, 0x0076, 0x0017, 0x0081, 0x0018, 0x0098, 0x0018, 
	0x00B0, 0x0018, 0x00C8, 0x0001, 0x00E0, 0x0001, 0x00E1, 0x0001, 0x00E2, 
	0x0017, 0x00E3, 0x0017, 0x00FA, 0x0017, 0x0111, 0x0015, 0x0128, 0x0016, 
	0x013D, 0x0017, 0x0153, 0x0017, 0x016A, 0x0017, 0x0181, 0x0017, 0x0198, 
	0x0001, 0x01AF, 0x0001, 0x01B0, 0x0001, 0x01B1, 0x000E, 0x01B2, 0x0017, 
	0x01C0, 0x0017, 0x01D7, 0x0003, 0x01EE, 0x0016, 0x01F1, 0x0017, 0x0207, 
	0x0016, 0x021E, 0x0017, 0x0234, 0x0017, 0x024B, 0x0017, 0x0262, 0x000E, 
	0x0279, 0x000D, 0x0287, 0x0017, 0x0294, 0x0017, 0x02AB, 0x0017, 0x02C2, 
	0x000A, 0x02D9, 0x0008, 0x02E3, 0x0017, 0x02EB, 0x0017, 0x0302, 0x0017, 
	0x0319, 0x0017, 0x0330, 0x0016, 0x0347, 0x000D, 0x035D, 0x0001, 0x036A, 
	0x0017, 0x036B, 0x0017, 0x0382, 0x0017, 0x0399, 0x000B, 0x03B0, 0x000A, 
	0x03BB, 0x0017, 0x03C5, 0x0017, 0x03DC, 0x0017, 0x03F3, 0x0017, 0x040A, 
	

});

smlua_anim_util_register_animation('donkey_72_running',0, 0, 0, 1, 72, { 
	0x0000, 0x00C0, 0x00C1, 0x00C1, 0x00C2, 0x00C3, 0x00C5, 0x00C7, 0x00C8, 
	0x00CB, 0x00CD, 0x00D0, 0x00D3, 0x00D6, 0x00DA, 0x00DD, 0x00E1, 0x00E6, 
	0x00EA, 0x00EA, 0x00EA, 0x00EA, 0x00EA, 0x00EA, 0x00EA, 0x00E9, 0x00E9, 
	0x00E8, 0x00E7, 0x00E6, 0x00E4, 0x00E3, 0x00E1, 0x00DF, 0x00DC, 0x00D9, 
	0x00D6, 0x00D3, 0x00CF, 0x00CA, 0x00C6, 0x00C1, 0x00BD, 0x00B8, 0x00B3, 
	0x00AF, 0x00AA, 0x00A6, 0x00A2, 0x009F, 0x009C, 0x0099, 0x0098, 0x0097, 
	0x0096, 0x009B, 0x009F, 0x00A3, 0x00A7, 0x00AA, 0x00AD, 0x00B0, 0x00B3, 
	0x00B6, 0x00B8, 0x00BA, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 0x00C0, 0x0000, 
	0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x6198, 
	0x61CE, 0x6226, 0x62A3, 0x6343, 0x6406, 0x64ED, 0x65F8, 0x6726, 0x6877, 
	0x69ED, 0x6B85, 0x6D41, 0x6F21, 0x7125, 0x734B, 0x7596, 0x7804, 0x77ED, 
	0x77A9, 0x7736, 0x7693, 0x75BF, 0x74BA, 0x7381, 0x7215, 0x7073, 0x6E9C, 
	0x6C8D, 0x6A46, 0x67C6, 0x650B, 0x6215, 0x5EE3, 0x5B73, 0x57C5, 0x53D9, 
	0x4FBC, 0x4B78, 0x471D, 0x42B6, 0x3E51, 0x39FB, 0x35C0, 0x31AF, 0x2DD4, 
	0x2A3C, 0x26F5, 0x240A, 0x218A, 0x1F82, 0x1DFE, 0x1D0C, 0x1CB8, 0x2427, 
	0x2B29, 0x31BE, 0x37E7, 0x3DA3, 0x42F2, 0x47D4, 0x4C4A, 0x5053, 0x53EF, 
	0x571F, 0x59E1, 0x5C37, 0x5E21, 0x5F9D, 0x60AD, 0x6150, 0x6187, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0121, 0x0121, 0x0120, 
	0x011F, 0x011D, 0x011B, 0x0119, 0x0117, 0x0114, 0x0111, 0x010D, 0x010A, 
	0x0105, 0x0101, 0x00FC, 0x00F7, 0x00F2, 0x00EC, 0x0114, 0x0189, 0x0246, 
	0x0345, 0x0481, 0x05F4, 0x0799, 0x096B, 0x0B65, 0x0D81, 0x0FB9, 0x1209, 
	0x146A, 0x16D9, 0x194F, 0x1BC6, 0x1E3A, 0x20A6, 0x2304, 0x2551, 0x278C, 
	0x29B2, 0x2BC2, 0x2DB8, 0x2F92, 0x314F, 0x32EC, 0x3467, 0x35BE, 0x36EE, 
	0x37F6, 0x38D2, 0x3982, 0x3A02, 0x3A50, 0x3A6B, 0x343B, 0x2E65, 0x28EA, 
	0x23C9, 0x1F03, 0x1A97, 0x1686, 0x12D0, 0x0F74, 0x0C72, 0x09CB, 0x077F, 
	0x058D, 0x03F6, 0x02B9, 0x01D6, 0x014F, 0x0121, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xE01F, 0xDFFD, 
	0xDFC4, 0xDF74, 0xDF0E, 0xDE90, 0xDDFC, 0xDD51, 0xDC90, 0xDBB8, 0xDAC8, 
	0xD9C2, 0xD8A6, 0xD772, 0xD628, 0xD4C7, 0xD34F, 0xD1C1, 0xD12B, 0xD0A6, 
	0xD031, 0xCFCA, 0xCF71, 0xCF25, 0xCEE4, 0xCEAE, 0xCE82, 0xCE5F, 0xCE43, 
	0xCE2E, 0xCE20, 0xCE16, 0xCE10, 0xCE0D, 0xCE0B, 0xCE0B, 0xCE5D, 0xCF47, 
	0xD0B5, 0xD295, 0xD4D3, 0xD75D, 0xDA20, 0xDD08, 0xE004, 0xE2FF, 0xE5E8, 
	0xE8AB, 0xEB35, 0xED73, 0xEF53, 0xF0C1, 0xF1AA, 0xF1FC, 0xF010, 0xEE3F, 
	0xEC8A, 0xEAF2, 0xE976, 0xE816, 0xE6D2, 0xE5AA, 0xE49F, 0xE3AF, 0xE2DC, 
	0xE225, 0xE18A, 0xE10C, 0xE0A9, 0xE063, 0xE038, 0xE02A, 0xFFFE, 0x0001, 
	0xC170, 0x3406, 0x33F6, 0x33DA, 0x33B3, 0x3382, 0x3345, 0x32FD, 0x32AA, 
	0x324C, 0x31E3, 0x316F, 0x30EF, 0x3065, 0x2FD0, 0xAF2F, 0xAE83, 0xADCD, 
	0xAD0B, 0xAC8D, 0xAC15, 0xABA4, 0xAB3B, 0xAADC, 0xAA88, 0xAA40, 0xAA05, 
	0xA9D9, 0x29BD, 0x29AA, 0x299A, 0x2988, 0x296D, 0x2943, 0x2904, 0x28A9, 
	0x282D, 0x26F9, 0x2495, 0x2128, 0x1CD8, 0x17CD, 0x122E, 0x0C22, 0x05D0, 
	0xFF5E, 0xF8F4, 0xF2BA, 0xECD6, 0xE76E, 0xE2AB, 0xDEB2, 0xDBAC, 0xD9BF, 
	0xD912, 0xE2E6, 0xEC2A, 0xF4DE, 0xFD02, 0x0498, 0x0B9D, 0x1212, 0x17F8, 
	0x1D4E, 0x2214, 0x264A, 0x29F0, 0x2D07, 0x2F8E, 0x3185, 0x32EC, 0x33C4, 
	0x340C, 0xE884, 0xE870, 0xE84F, 0xE820, 0xE7E5, 0xE79C, 0xE746, 0xE6E2, 
	0xE671, 0xE5F3, 0xE568, 0xE4D0, 0xE42A, 0xE377, 0x9D48, 0x9E15, 0x9EF0, 
	0x9FD8, 0xA129, 0xA28A, 0xA3EC, 0xA542, 0xA67B, 0xA789, 0xA85C, 0xA8E6, 
	0xA918, 0xD6E7, 0xD6E8, 0xD6EA, 0xD6EC, 0xD6EE, 0xD6F0, 0xD6F2, 0xD6F4, 
	0xD6F6, 0xD6F8, 0xD6FA, 0xD6FE, 0xD704, 0xD70D, 0xD71A, 0xD72C, 0xD744, 
	0xD763, 0xD78A, 0xD7B9, 0xD7F1, 0xD834, 0xD883, 0xD8DD, 0xD944, 0xD9BA, 
	0xDA3E, 0xDBCA, 0xDD3E, 0xDE9D, 0xDFE4, 0xE115, 0xE230, 0xE334, 0xE421, 
	0xE4F7, 0xE5B8, 0xE661, 0xE6F4, 0xE770, 0xE7D6, 0xE825, 0xE85D, 0xE87F, 
	0xE88B, 0x6277, 0x62B8, 0x6323, 0x63BA, 0x647B, 0x6567, 0x667F, 0x67C1, 
	0x692E, 0x6AC7, 0x6C8A, 0x6E78, 0x7091, 0x72D5, 0xF544, 0xF7DE, 0xFAA3, 
	0xFD93, 0xFFCE, 0x0208, 0x0440, 0x0679, 0x08B2, 0x0AED, 0x0D2A, 0x0F6A, 
	0x11AD, 0x93F5, 0x9649, 0x98B1, 0x9B33, 0x9DD6, 0xA0A3, 0xA3A1, 0xA6D7, 
	0xAA4D, 0xAE06, 0xB1F8, 0xB616, 0xBA53, 0xBEA0, 0xC2F1, 0xC737, 0xCB65, 
	0xCF6D, 0xD343, 0xD6D8, 0xDA1E, 0xDD09, 0xDF8A, 0xE195, 0xE31B, 0xE40F, 
	0xE463, 0xD658, 0xC91A, 0xBCAA, 0xB107, 0xA631, 0x9C29, 0x92EF, 0x8A82, 
	0x82E2, 0x7C10, 0x760B, 0x70D4, 0x6C6A, 0x68CD, 0x65FE, 0x63FD, 0x62C9, 
	0x6262, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xEFAD, 0xEF76, 0xEF1A, 0xEE99, 0xEDF3, 0xED29, 0xEC39, 0xEB25, 
	0xE9EC, 0xE88E, 0xE70C, 0xE564, 0xE398, 0xE1A7, 0xDF91, 0xDD56, 0xDAF7, 
	0xD872, 0xD6F1, 0xD588, 0xD43A, 0xD30A, 0xD1F9, 0xD10B, 0xD042, 0xCF9F, 
	0xCF27, 0xCED8, 0xCEA9, 0xCE8F, 0xCE7E, 0xCE69, 0xCE47, 0xCE0A, 0xCDA7, 
	0xCD12, 0xCC16, 0xCA92, 0xC898, 0xC63B, 0xC38C, 0xC09E, 0xBD83, 0xBA4E, 
	0xB710, 0xB3DC, 0xB0C4, 0xADDB, 0xAB32, 0xA8DC, 0xA6EB, 0xA572, 0xA482, 
	0xA42E, 0xAC57, 0xB40A, 0xBB45, 0xC208, 0xC855, 0xCE29, 0xD387, 0xD86C, 
	0xDCDB, 0xE0D2, 0xE452, 0xE75A, 0xE9EB, 0xEC04, 0xEDA6, 0xEED1, 0xEF84, 
	0xEFBF, 0xFF91, 0xFF61, 0xFF38, 0xFF15, 0xFEF8, 0xFEE2, 0xFED2, 0xFEC8, 
	0xFEC5, 0xFED3, 0xFEFB, 0xFF3E, 0xFF9C, 0x0015, 0x00A9, 0x0157, 0x0220, 
	0x0304, 0x0303, 0x02FF, 0x02F9, 0x02F0, 0x02E6, 0x02DB, 0x02CF, 0x02C2, 
	0x02B5, 0x02A8, 0x029B, 0x028E, 0x0283, 0x0279, 0x0271, 0x026B, 0x0267, 
	0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 
	0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 0x0265, 
	0x0265, 0x021D, 0x01D9, 0x0199, 0x015D, 0x0125, 0x00F1, 0x00C2, 0x0097, 
	0x006F, 0x004C, 0x002D, 0x0012, 0xFFFB, 0xFFE8, 0xFFDA, 0xFFCF, 0xFFC9, 
	0xFFC7, 0xF40E, 0xF1EC, 0xF013, 0xEE83, 0xED3C, 0xEC3D, 0xEB87, 0xEB1A, 
	0xEAF6, 0xEB5D, 0xEC92, 0xEE95, 0xF166, 0xF505, 0xF972, 0xFEAC, 0x04B6, 
	0x0B8D, 0x0B60, 0x0AE0, 0x0A16, 0x090E, 0x07D2, 0x066C, 0x04E6, 0x034C, 
	0x01A8, 0x0003, 0xFE68, 0xFCE2, 0xFB7C, 0xFA40, 0xF938, 0xF86E, 0xF7EE, 
	0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 
	0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 0xF7C1, 
	0xF7C1, 0xF79D, 0xF77C, 0xF75C, 0xF73F, 0xF723, 0xF70A, 0xF6F3, 0xF6DD, 
	0xF6CA, 0xF6B9, 0xF6AA, 0xF69D, 0xF691, 0xF688, 0xF681, 0xF67C, 0xF679, 
	0xF678, 0xFE9B, 0xFE5A, 0xFE22, 0xFDF2, 0xFDCB, 0xFDAC, 0xFD97, 0xFD8A, 
	0xFD85, 0xFDAD, 0xFE25, 0xFEEC, 0x0003, 0x0169, 0x031F, 0x0524, 0x0779, 
	0x0A1E, 0x0A0E, 0x09E2, 0x099D, 0x0942, 0x08D5, 0x0859, 0x07D3, 0x0746, 
	0x06B5, 0x0625, 0x0597, 0x0511, 0x0496, 0x0429, 0x03CE, 0x0389, 0x035D, 
	0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 
	0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 0x034D, 
	0x034D, 0x02D3, 0x0260, 0x01F5, 0x0190, 0x0132, 0x00DB, 0x008B, 0x0042, 
	0xFFFF, 0xFFC4, 0xFF8F, 0xFF62, 0xFF3C, 0xFF1D, 0xFF04, 0xFEF3, 0xFEE8, 
	0xFEE5, 0xFFFE, 0x0001, 0xC170, 0xDBA4, 0xDBAF, 0xDBC0, 0xDBD9, 0xDBF8, 
	0xDC1F, 0xDC4D, 0xDC81, 0xDCBD, 0xDCFF, 0xDD49, 0xDD9A, 0xDDF1, 0xDE50, 
	0xDEB6, 0xDF22, 0xDF96, 0xE011, 0xE075, 0xE0D7, 0xE135, 0xE18B, 0xE1D9, 
	0xE219, 0xE24B, 0xE26B, 0xE276, 0xE259, 0xE20C, 0xE19D, 0xE11A, 0xE08F, 
	0xE00C, 0xDF9D, 0xDF50, 0xDF34, 0xDFC3, 0xE15A, 0xE3D8, 0xE71D, 0xEB06, 
	0xEF74, 0xF444, 0xF957, 0xFE8B, 0x03BF, 0x08D2, 0x0DA3, 0x1210, 0x15FA, 
	0x193E, 0x1BBC, 0x1D54, 0x1DE3, 0x16BA, 0x0FFB, 0x09A4, 0x03B6, 0xFE30, 
	0xF913, 0xF45F, 0xF014, 0xEC31, 0xE8B7, 0xE5A6, 0xE2FD, 0xE0BE, 0xDEE6, 
	0xDD78, 0xDC72, 0xDBD5, 0xDBA1, 0x1606, 0x1618, 0x1636, 0x1661, 0x1697, 
	0x16DA, 0x1729, 0x1784, 0x17EC, 0x185F, 0x18DF, 0x196A, 0x1A02, 0x1AA6, 
	0x1B57, 0x1C13, 0x1CDC, 0x1DB0, 0x1E93, 0x1F7A, 0x205D, 0x2134, 0x21F6, 
	0x229C, 0x231D, 0x2370, 0x238E, 0x2383, 0x2365, 0x233A, 0x2307, 0x22D2, 
	0x229F, 0x2274, 0x2257, 0x224C, 0x2259, 0x2281, 0x22BE, 0x230F, 0x2370, 
	0x23DD, 0x2454, 0x24D1, 0x2552, 0x25D2, 0x2650, 0x26C7, 0x2734, 0x2795, 
	0x27E5, 0x2823, 0x284A, 0x2858, 0x265D, 0x247E, 0x22BD, 0x2119, 0x1F91, 
	0x1E27, 0x1CD9, 0x1BA9, 0x1A96, 0x199F, 0x18C6, 0x1809, 0x176A, 0x16E7, 
	0x1682, 0x1639, 0x160E, 0x15FF, 0x72D5, 0x72FF, 0x7345, 0x73A7, 0x7424, 
	0x74BE, 0x7574, 0x7646, 0x7733, 0x783D, 0x7963, 0x7AA4, 0x7C02, 0x7D7B, 
	0x7F11, 0x80C2, 0x828F, 0x8479, 0x867F, 0x889E, 0x8AD1, 0x8D14, 0x8F64, 
	0x91BB, 0x9417, 0x9673, 0x98CB, 0x9B1C, 0x9D6B, 0x9FBA, 0xA210, 0xA472, 
	0xA6E3, 0xA969, 0xAC08, 0xAEC6, 0xB1A4, 0xB49D, 0xB7A8, 0xBABD, 0xBDD4, 
	0xC0E5, 0xC3E6, 0xC6D0, 0xC99B, 0xCC3E, 0xCEB0, 0xD0EA, 0xD2E3, 0xD493, 
	0xD5F2, 0xD6F6, 0xD799, 0xD7D1, 0xCCE7, 0xC29C, 0xB8F1, 0xAFE6, 0xA77B, 
	0x9FAF, 0x9883, 0x91F6, 0x8C09, 0x86BC, 0x820F, 0x7E01, 0x7A93, 0x77C4, 
	0x7595, 0x7406, 0x7317, 0x72C7, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xF0D6, 0xF0A0, 0xF045, 0xEFC5, 0xEF22, 0xEE5A, 
	0xED6D, 0xEC5D, 0xEB28, 0xE9CE, 0xE850, 0xE6AE, 0xE4E8, 0xE2FD, 0xE0EE, 
	0xDEBA, 0xDC62, 0xD9E6, 0xD868, 0xD704, 0xD5B9, 0xD48C, 0xD37F, 0xD293, 
	0xD1CC, 0xD12B, 0xD0B4, 0xD065, 0xD033, 0xD00F, 0xCFEA, 0xCFB5, 0xCF61, 
	0xCEE0, 0xCE22, 0xCD19, 0xCBB7, 0xCA01, 0xC804, 0xC5CC, 0xC366, 0xC0DF, 
	0xBE43, 0xBB9F, 0xB8FF, 0xB670, 0xB3FF, 0xB1B9, 0xAFA9, 0xADDD, 0xAC61, 
	0xAB42, 0xAA8D, 0xAA4E, 0xB1EE, 0xB91F, 0xBFE0, 0xC632, 0xCC14, 0xD187, 
	0xD68A, 0xDB1E, 0xDF42, 0xE2F6, 0xE63B, 0xE910, 0xEB76, 0xED6C, 0xEEF2, 
	0xF009, 0xF0B1, 0xF0E8, 0xF152, 0xF0B4, 0xF02C, 0xEFB9, 0xEF5A, 0xEF11, 
	0xEEDC, 0xEEBD, 0xEEB2, 0xEEAF, 0xEEA3, 0xEE91, 0xEE77, 0xEE56, 0xEE2D, 
	0xEDFD, 0xEDC5, 0xED86, 0xED70, 0xED55, 0xED34, 0xED10, 0xECE8, 0xECBE, 
	0xEC93, 0xEC67, 0xEC3B, 0xEC11, 0xEBE8, 0xEBC2, 0xEB9F, 0xEB81, 0xEB68, 
	0xEB56, 0xEB4A, 0xEB46, 0xEB46, 0xEB49, 0xEB4E, 0xEB56, 0xEB60, 0xEB6E, 
	0xEB7E, 0xEB92, 0xEBAA, 0xEBC6, 0xEBE6, 0xEC0B, 0xEC34, 0xEC62, 0xEC96, 
	0xECCF, 0xED0E, 0xED53, 0xEDD4, 0xEE4F, 0xEEC2, 0xEF2D, 0xEF91, 0xEFEE, 
	0xF043, 0xF091, 0xF0D8, 0xF117, 0xF14E, 0xF17E, 0xF1A7, 0xF1C9, 0xF1E3, 
	0xF1F5, 0xF200, 0xF204, 0x0FE7, 0x1130, 0x124C, 0x133D, 0x1402, 0x149B, 
	0x1508, 0x154A, 0x1560, 0x14EA, 0x1386, 0x1136, 0x0DF9, 0x09CF, 0x04B8, 
	0xFEB3, 0xF7C2, 0xEFE5, 0xF017, 0xF0A5, 0xF184, 0xF2A8, 0xF406, 0xF593, 
	0xF741, 0xF907, 0xFAD9, 0xFCAA, 0xFE70, 0x0020, 0x01AC, 0x030A, 0x042E, 
	0x050D, 0x059C, 0x05CE, 0x05C4, 0x05A9, 0x057E, 0x0546, 0x0502, 0x04B6, 
	0x0463, 0x040C, 0x03B3, 0x035A, 0x0302, 0x02B0, 0x0263, 0x0220, 0x01E8, 
	0x01BD, 0x01A2, 0x0198, 0x02FC, 0x044B, 0x0586, 0x06AC, 0x07BF, 0x08BD, 
	0x09A6, 0x0A7C, 0x0B3D, 0x0BE9, 0x0C82, 0x0D06, 0x0D75, 0x0DD1, 0x0E18, 
	0x0E4B, 0x0E69, 0x0E73, 0xF0B2, 0xEFBF, 0xEEEC, 0xEE39, 0xEDA7, 0xED36, 
	0xECE4, 0xECB4, 0xECA3, 0xECF5, 0xEDEA, 0xEF83, 0xF1BF, 0xF49F, 0xF821, 
	0xFC48, 0x0113, 0x0680, 0x067B, 0x066E, 0x0658, 0x063A, 0x0615, 0x05E9, 
	0x05B7, 0x057F, 0x0543, 0x0502, 0x04BD, 0x0475, 0x042A, 0x03DD, 0x038F, 
	0x033F, 0x02EF, 0x029F, 0x0250, 0x0201, 0x01B2, 0x0161, 0x010F, 0x00BB, 
	0x0064, 0x000A, 0xFFAA, 0xFF48, 0xFEE0, 0xFE73, 0xFDFF, 0xFD85, 0xFD03, 
	0xFC7A, 0xFBE8, 0xFB4D, 0xFA45, 0xF94D, 0xF864, 0xF789, 0xF6BE, 0xF602, 
	0xF555, 0xF4B7, 0xF428, 0xF3A8, 0xF337, 0xF2D5, 0xF282, 0xF23F, 0xF20A, 
	0xF1E4, 0xF1CE, 0xF1C6, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xF2FF, 0xF308, 0xF323, 0xF350, 
	0xF38E, 0xF3DF, 0xF442, 0xF4B7, 0xF53E, 0xF5D7, 0xF682, 0xF73F, 0xF80E, 
	0xF8EF, 0xF9E2, 0xFAE7, 0xFBFE, 0xFD26, 0xFE61, 0xFF03, 0xFF95, 0x0019, 
	0x008F, 0x00F7, 0x0152, 0x01A2, 0x01E7, 0x0222, 0x0254, 0x027C, 0x029D, 
	0x02B7, 0x02CA, 0x02D8, 0x02E1, 0x02E5, 0x02E7, 0x02BB, 0x0240, 0x017F, 
	0x0081, 0xFF51, 0xFDFA, 0xFC84, 0xFAFB, 0xF968, 0xF7D4, 0xF64B, 0xF4D6, 
	0xF37E, 0xF24F, 0xF152, 0xF090, 0xF015, 0xEFEA, 0xF03F, 0xF08F, 0xF0DB, 
	0xF121, 0xF163, 0xF1A0, 0xF1D8, 0xF20B, 0xF239, 0xF263, 0xF287, 0xF2A7, 
	0xF2C2, 0xF2D8, 0xF2E9, 0xF2F5, 0xF2FC, 0xE9C8, 0xE9CB, 0xE9D4, 0xE9E3, 
	0xE9F9, 0xEA14, 0xEA35, 0xEA5D, 0xEA8B, 0xEABE, 0xEAF8, 0xEB38, 0xEB7E, 
	0xEBCA, 0xEC1C, 0xEC74, 0xECD2, 0xED37, 0xEDA1, 0xEDFA, 0xEE55, 0xEEB0, 
	0xEF0B, 0xEF67, 0xEFC3, 0xF01E, 0xF078, 0xF0D1, 0xF129, 0xF17F, 0xF1D3, 
	0xF224, 0xF273, 0xF2BF, 0xF307, 0xF34C, 0xF38D, 0xF3CA, 0xF402, 0xF436, 
	0xF467, 0xF493, 0xF4BC, 0xF4E1, 0xF502, 0xF51F, 0xF539, 0xF550, 0xF563, 
	0xF574, 0xF581, 0xF58B, 0xF592, 0xF596, 0xF597, 0xF451, 0xF31D, 0xF1FB, 
	0xF0ED, 0xEFF1, 0xEF08, 0xEE31, 0xED6D, 0xECBC, 0xEC1D, 0xEB91, 0xEB18, 
	0xEAB1, 0xEA5D, 0xEA1C, 0xE9ED, 0xE9D1, 0xADF1, 0xADFF, 0xAE2A, 0xAE72, 
	0xAED6, 0xAF57, 0xAFF4, 0xB0AE, 0xB185, 0xB279, 0xB389, 0xB4B5, 0xB5FE, 
	0xB764, 0xB8E7, 0xBA86, 0xBC42, 0xBE1A, 0xC00F, 0xBF95, 0xBE39, 0xBC18, 
	0xB94E, 0xB5F7, 0xB22E, 0xAE12, 0xA9BD, 0xA54C, 0xA0DA, 0x9C85, 0x9869, 
	0x94A1, 0x9149, 0x8E7F, 0x8C5E, 0x8B02, 0x8A88, 0x8B05, 0x8C6A, 0x8E99, 
	0x9175, 0x94E3, 0x98C3, 0x9CFB, 0xA16C, 0xA5FB, 0xAA89, 0xAEFA, 0xB332, 
	0xB712, 0xBA80, 0xBD5C, 0xBF8B, 0xC0F0, 0xC16D, 0xBF52, 0xBD56, 0xBB79, 
	0xB9BA, 0xB81B, 0xB69A, 0xB538, 0xB3F5, 0xB2D0, 0xB1CA, 0xB0E3, 0xB01B, 
	0xAF72, 0xAEE7, 0xAE7C, 0xAE2F, 0xAE00, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0EEB, 0x0EEB, 
	0x0F0D, 0x0F74, 0x101F, 0x110E, 0x1242, 0x13BA, 0x1577, 0x1778, 0x19BE, 
	0x1C48, 0x1F16, 0x2229, 0x2580, 0x291C, 0x2CFC, 0x3120, 0x3589, 0x3A36, 
	0x3CA2, 0x3ED3, 0x40CC, 0x4291, 0x4424, 0x4588, 0x46BF, 0x47CD, 0x48B4, 
	0x4976, 0x4A18, 0x4A9B, 0x4B02, 0x4B51, 0x4B89, 0x4BAD, 0x4BC1, 0x4BC7, 
	0x4B1A, 0x492E, 0x462A, 0x4237, 0x3D7C, 0x3822, 0x3250, 0x2C2E, 0x25E4, 
	0x1F9A, 0x1978, 0x13A5, 0x0E4B, 0x0990, 0x059D, 0x0299, 0x00AD, 0x0000, 
	0x019D, 0x0321, 0x048F, 0x05E5, 0x0723, 0x0849, 0x0959, 0x0A50, 0x0B30, 
	0x0BF8, 0x0CA9, 0x0D42, 0x0DC4, 0x0E2E, 0x0E81, 0x0EBC, 0x1047, 0x1047, 
	0x103F, 0x1024, 0x0FF7, 0x0FB9, 0x0F69, 0x0F07, 0x0E94, 0x0E0E, 0x0D77, 
	0x0CCE, 0x0C13, 0x0B46, 0x0A68, 0x0978, 0x0876, 0x0762, 0x063D, 0x0505, 
	0x0445, 0x038F, 0x02E3, 0x0241, 0x01A9, 0x011C, 0x0099, 0x0021, 0xFFB2, 
	0xFF50, 0xFEF8, 0xFEAC, 0xFE6B, 0xFE35, 0xFE0B, 0xFDED, 0xFDDB, 0xFDD5, 
	0xFDD5, 0xFDD6, 0xFDD9, 0xFDDE, 0xFDE6, 0xFDF3, 0xFE05, 0xFE1C, 0xFE3A, 
	0xFE5F, 0xFE8D, 0xFEC4, 0xFF05, 0xFF50, 0xFFA7, 0x000C, 0x007D, 0x00FC, 
	0x02A3, 0x0431, 0x05A8, 0x0707, 0x084D, 0x097B, 0x0A91, 0x0B8F, 0x0C74, 
	0x0D42, 0x0DF7, 0x0E94, 0x0F19, 0x0F86, 0x0FDB, 0x1017, 0x08AF, 0x08AF, 
	0x08B6, 0x08CB, 0x08EF, 0x0921, 0x0961, 0x09AF, 0x0A0B, 0x0A76, 0x0AEF, 
	0x0B76, 0x0C0B, 0x0CAF, 0x0D61, 0x0E21, 0x0EEF, 0x0FCC, 0x10B6, 0x11AF, 
	0x11AD, 0x11A8, 0x119F, 0x1194, 0x1186, 0x1177, 0x1166, 0x1154, 0x1142, 
	0x1130, 0x111F, 0x110E, 0x10FF, 0x10F1, 0x10E6, 0x10DD, 0x10D7, 0x10D6, 
	0x10E3, 0x110A, 0x1146, 0x1195, 0x11F4, 0x1260, 0x12D4, 0x134F, 0x13CD, 
	0x144C, 0x14C6, 0x153B, 0x15A7, 0x1605, 0x1655, 0x1691, 0x16B8, 0x16C5, 
	0x1540, 0x13D0, 0x1277, 0x1135, 0x1008, 0x0EF2, 0x0DF2, 0x0D08, 0x0C34, 
	0x0B77, 0x0AD0, 0x0A40, 0x09C5, 0x0961, 0x0913, 0x08DB, 0xFAEB, 0xFAEB, 
	0xFAD1, 0xFA82, 0xF9FE, 0xF945, 0xF857, 0xF735, 0xF5DE, 0xF452, 0xF291, 
	0xF09C, 0xEE71, 0xEC12, 0xE97E, 0xE6B5, 0xE3B8, 0xE085, 0xDD1E, 0xD982, 
	0xD64A, 0xD302, 0xCFB3, 0xCC64, 0xC91D, 0xC5E5, 0xC2C3, 0xBFBF, 0xBCE1, 
	0xBA31, 0xB7B5, 0xB575, 0xB37A, 0xB1CA, 0xB06C, 0xAF69, 0xAEC9, 0xAE91, 
	0xAEB3, 0xAF17, 0xAFBA, 0xB099, 0xB1B3, 0xB304, 0xB48A, 0xB643, 0xB82B, 
	0xBA41, 0xBC81, 0xBEEA, 0xC177, 0xC428, 0xC6FA, 0xC9E9, 0xCCF3, 0xD016, 
	0xD4B6, 0xD913, 0xDD2C, 0xE102, 0xE494, 0xE7E2, 0xEAEC, 0xEDB3, 0xF036, 
	0xF275, 0xF471, 0xF629, 0xF79D, 0xF8CE, 0xF9BB, 0xFA64, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0x00C0, 0x00CA, 0x00E9, 0x011C, 0x0164, 0x01C0, 0x0231, 0x02B6, 0x0350, 
	0x03FF, 0x04C2, 0x0599, 0x0686, 0x0786, 0x089B, 0x09C5, 0x0B03, 0x0C56, 
	0x0DBD, 0x0D95, 0x0D23, 0x0C70, 0x0B86, 0x0A6E, 0x0931, 0x07D8, 0x066C, 
	0x04F8, 0x0383, 0x0217, 0x00BE, 0xFF80, 0xFE68, 0xFD7E, 0xFCCB, 0xFC59, 
	0xFC31, 0xFC53, 0xFCB5, 0xFD4D, 0xFE15, 0xFF04, 0x0013, 0x013A, 0x0270, 
	0x03AE, 0x04EC, 0x0622, 0x0748, 0x0857, 0x0946, 0x0A0D, 0x0AA6, 0x0B07, 
	0x0B29, 0x0A09, 0x08FA, 0x07FB, 0x070C, 0x062E, 0x0560, 0x04A3, 0x03F6, 
	0x035A, 0x02CE, 0x0253, 0x01E8, 0x018D, 0x0143, 0x010A, 0x00E0, 0x00C8, 
	0x1A6E, 0x1A71, 0x1A79, 0x1A87, 0x1A9A, 0x1AB3, 0x1AD2, 0x1AF6, 0x1B1F, 
	0x1B4E, 0x1B83, 0x1BBD, 0x1BFC, 0x1C41, 0x1C8C, 0x1CDC, 0x1D32, 0x1D8D, 
	0x1DED, 0x1DE3, 0x1DC6, 0x1D96, 0x1D54, 0x1D02, 0x1CA1, 0x1C31, 0x1BB4, 
	0x1B2B, 0x1A97, 0x19F8, 0x194F, 0x189F, 0x17E7, 0x172A, 0x1667, 0x159F, 
	0x14D5, 0x1409, 0x133C, 0x1270, 0x11A6, 0x10E0, 0x1020, 0x0F66, 0x0EB5, 
	0x0E0D, 0x0D71, 0x0CE2, 0x0C60, 0x0BEF, 0x0B8F, 0x0B42, 0x0B09, 0x0AE5, 
	0x0AD9, 0x0C88, 0x0E1E, 0x0F9C, 0x1101, 0x124E, 0x1381, 0x149D, 0x159F, 
	0x1689, 0x175A, 0x1813, 0x18B3, 0x193A, 0x19A9, 0x19FF, 0x1A3D, 0x1A62, 
	0xAC00, 0xAC33, 0xACCA, 0xADC7, 0xAF29, 0xB0F0, 0xB31C, 0xB5AD, 0xB8A3, 
	0xBBFE, 0xBFBF, 0xC3E4, 0xC86F, 0xCD5E, 0xD2B3, 0xD86D, 0xDE8B, 0xE50F, 
	0xEBF8, 0xEAFB, 0xE82A, 0xE3BF, 0xDDF5, 0xD707, 0xCF2F, 0xC6A8, 0xBDAB, 
	0xB474, 0xAB3D, 0xA241, 0x99B9, 0x91E1, 0x8AF3, 0x8529, 0x80BE, 0x7DED, 
	0x7CF0, 0x7D67, 0x7EBC, 0x80D2, 0x838D, 0x86D3, 0x8A87, 0x8E8E, 0x92CD, 
	0x9727, 0x9B81, 0x9FBF, 0xA3C6, 0xA77A, 0xAAC0, 0xAD7C, 0xAF92, 0xB0E6, 
	0xB15E, 0xB0C9, 0xB03E, 0xAFBA, 0xAF3F, 0xAECD, 0xAE63, 0xAE01, 0xADA8, 
	0xAD58, 0xAD10, 0xACD0, 0xAC99, 0xAC6A, 0xAC44, 0xAC26, 0xAC11, 0xAC05, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x2CE1, 0x2CE1, 0x2CEB, 0x2D0A, 0x2D3C, 0x2D83, 0x2DDE, 
	0x2E4E, 0x2ED2, 0x2F6A, 0x3016, 0x30D6, 0x31AB, 0x3294, 0x3392, 0x34A3, 
	0x35C9, 0x3703, 0x3851, 0x39B4, 0x3B04, 0x3C5D, 0x3DBB, 0x3F1C, 0x407C, 
	0x41D7, 0x432A, 0x4472, 0x45AB, 0x46D1, 0x47E2, 0x48D9, 0x49B4, 0x4A6E, 
	0x4B05, 0x4B76, 0x4BBC, 0x4BD4, 0x4B5A, 0x4A02, 0x47E5, 0x4521, 0x41D1, 
	0x3E11, 0x39FD, 0x35B2, 0x314A, 0x2CE2, 0x2897, 0x2483, 0x20C3, 0x1D73, 
	0x1AAF, 0x1892, 0x173A, 0x16C0, 0x1924, 0x1B65, 0x1D83, 0x1F7E, 0x2156, 
	0x230B, 0x249E, 0x260D, 0x2759, 0x2882, 0x2988, 0x2A6C, 0x2B2C, 0x2BC9, 
	0x2C44, 0x2C9B, 0xF233, 0xF233, 0xF23C, 0xF256, 0xF283, 0xF2C1, 0xF310, 
	0xF371, 0xF3E4, 0xF469, 0xF4FF, 0xF5A7, 0xF661, 0xF72C, 0xF809, 0xF8F8, 
	0xF9F8, 0xFB0A, 0xFC2E, 0xFD63, 0xFD91, 0xFDB9, 0xFDDD, 0xFDFC, 0xFE17, 
	0xFE2F, 0xFE42, 0xFE53, 0xFE60, 0xFE6B, 0xFE73, 0xFE79, 0xFE7E, 0xFE81, 
	0xFE83, 0xFE84, 0xFE84, 0xFE84, 0xFE7A, 0xFE5F, 0xFE32, 0xFDF6, 0xFDAC, 
	0xFD55, 0xFCF3, 0xFC87, 0xFC12, 0xFB95, 0xFB13, 0xFA8C, 0xFA02, 0xF977, 
	0xF8EA, 0xF85F, 0xF7D6, 0xF750, 0xF6C3, 0xF63D, 0xF5C0, 0xF54B, 0xF4DE, 
	0xF479, 0xF41C, 0xF3C7, 0xF37A, 0xF336, 0xF2F9, 0xF2C5, 0xF298, 0xF274, 
	0xF257, 0xF243, 0xF28A, 0xF28A, 0xF286, 0xF279, 0xF263, 0xF245, 0xF21E, 
	0xF1EF, 0xF1B7, 0xF176, 0xF12C, 0xF0DA, 0xF080, 0xF01C, 0xEFB0, 0xEF3C, 
	0xEEBE, 0xEE38, 0xEDAA, 0xED13, 0xEC73, 0xEBCD, 0xEB22, 0xEA74, 0xE9C6, 
	0xE918, 0xE86D, 0xE7C7, 0xE728, 0xE691, 0xE605, 0xE585, 0xE514, 0xE4B3, 
	0xE464, 0xE429, 0xE405, 0xE3F8, 0xE3FF, 0xE415, 0xE438, 0xE468, 0xE4A4, 
	0xE4EB, 0xE53D, 0xE599, 0xE5FF, 0xE66D, 0xE6E3, 0xE760, 0xE7E4, 0xE86E, 
	0xE8FC, 0xE990, 0xEA27, 0xEAC1, 0xEB98, 0xEC63, 0xED22, 0xEDD4, 0xEE7A, 
	0xEF14, 0xEFA2, 0xF023, 0xF098, 0xF100, 0xF15D, 0xF1AD, 0xF1F0, 0xF228, 
	0xF253, 0xF272, 0xEB86, 0xEB86, 0xEB70, 0xEB2E, 0xEAC0, 0xEA26, 0xE960, 
	0xE86D, 0xE74F, 0xE604, 0xE48E, 0xE2EB, 0xE11C, 0xDF21, 0xDCFB, 0xDAA8, 
	0xD829, 0xD57D, 0xD2A6, 0xCFA3, 0xCD82, 0xCB6D, 0xC967, 0xC772, 0xC58F, 
	0xC3C2, 0xC20D, 0xC072, 0xBEF3, 0xBD92, 0xBC53, 0xBB36, 0xBA40, 0xB970, 
	0xB8CB, 0xB852, 0xB808, 0xB7EF, 0xB808, 0xB851, 0xB8C7, 0xB96A, 0xBA36, 
	0xBB29, 0xBC42, 0xBD7D, 0xBED9, 0xC054, 0xC1EB, 0xC39C, 0xC566, 0xC745, 
	0xC938, 0xCB3C, 0xCD4F, 0xCF70, 0xD279, 0xD555, 0xD805, 0xDA89, 0xDCE0, 
	0xDF0B, 0xE109, 0xE2DB, 0xE481, 0xE5FA, 0xE747, 0xE867, 0xE95C, 0xEA23, 
	0xEABF, 0xEB2E, 

},{ 
	0x0001, 0x0000, 0x0046, 0x0001, 0x0001, 0x0047, 0x0001, 0x0048, 0x0001, 
	0x0049, 0x0001, 0x004A, 0x0044, 0x004B, 0x0024, 0x008F, 0x0048, 0x00B3, 
	0x0044, 0x00FB, 0x0041, 0x013F, 0x0048, 0x0180, 0x0036, 0x01C8, 0x0001, 
	0x01FE, 0x0048, 0x01FF, 0x0001, 0x0247, 0x0001, 0x0248, 0x0001, 0x0249, 
	0x0048, 0x024A, 0x0048, 0x0292, 0x0048, 0x02DA, 0x0045, 0x0322, 0x0042, 
	0x0367, 0x0048, 0x03A9, 0x0048, 0x03F1, 0x0048, 0x0439, 0x0048, 0x0481, 
	0x0001, 0x04C9, 0x0001, 0x04CA, 0x0001, 0x04CB, 0x0048, 0x04CC, 0x0048, 
	0x0514, 0x0048, 0x055C, 0x0046, 0x05A4, 0x0001, 0x05EA, 0x0048, 0x05EB, 
	0x0048, 0x0633, 0x0048, 0x067B, 0x0048, 0x06C3, 0x0048, 0x070B, 0x0001, 
	0x0753, 0x0001, 0x0754, 0x0048, 0x0755, 0x0048, 0x079D, 0x0048, 0x07E5, 
	0x0005, 0x082D, 0x003C, 0x0832, 0x0048, 0x086E, 0x0048, 0x08B6, 0x0048, 
	0x08FE, 0x0048, 0x0946, 0x0048, 0x098E, 0x0001, 0x09D6, 0x0001, 0x09D7, 
	0x0048, 0x09D8, 0x0048, 0x0A20, 0x0048, 0x0A68, 0x0040, 0x0AB0, 0x0001, 
	0x0AF0, 0x0048, 0x0AF1, 0x0048, 0x0B39, 0x0048, 0x0B81, 0x0048, 0x0BC9, 
	

});


smlua_anim_util_register_animation('donkey_48_walking',0, 0, 0, 0, 76, { 
	0x0000, 0x0097, 0x0097, 0x0097, 0x0097, 0x0098, 0x0098, 0x0099, 0x009A, 
	0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009E, 0x009F, 0x00A0, 0x00A0, 
	0x00A0, 0x00A1, 0x00A1, 0x00A1, 0x00A0, 0x00A0, 0x00A0, 0x009F, 0x009E, 
	0x009E, 0x009D, 0x009C, 0x009B, 0x009A, 0x009A, 0x0099, 0x0098, 0x0098, 
	0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0098, 0x0098, 
	0x0099, 0x009A, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009E, 0x009F, 
	0x00A0, 0x00A0, 0x00A0, 0x00A1, 0x00A1, 0x00A1, 0x00A0, 0x00A0, 0x00A0, 
	0x009F, 0x009E, 0x009E, 0x009D, 0x009C, 0x009B, 0x009A, 0x009A, 0x0099, 
	0x0098, 0x0098, 0x0097, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0C22, 0x0C17, 
	0x0BF6, 0x0BC0, 0x0B76, 0x0B1A, 0x0AAD, 0x0A30, 0x09A5, 0x090C, 0x0867, 
	0x07B7, 0x06FE, 0x063C, 0x0572, 0x04A3, 0x03CF, 0x02F8, 0x021E, 0x0143, 
	0x0068, 0xFF8D, 0xFEB6, 0xFDE3, 0xFD15, 0xFC4C, 0xFB8B, 0xFAD3, 0xFA24, 
	0xF981, 0xF8E9, 0xF85F, 0xF7E3, 0xF777, 0xF71C, 0xF6D4, 0xF69E, 0xF67D, 
	0xF672, 0xF67D, 0xF69E, 0xF6D4, 0xF71C, 0xF777, 0xF7E3, 0xF85F, 0xF8E9, 
	0xF981, 0xFA24, 0xFAD3, 0xFB8B, 0xFC4C, 0xFD15, 0xFDE3, 0xFEB6, 0xFF8D, 
	0x0068, 0x0143, 0x021E, 0x02F8, 0x03CF, 0x04A3, 0x0572, 0x063C, 0x06FE, 
	0x07B7, 0x0867, 0x090C, 0x09A5, 0x0A30, 0x0AAD, 0x0B1A, 0x0B76, 0x0BC0, 
	0x0BF6, 0x0C17, 0x0C22, 0xFA68, 0xFA6D, 0xFA7C, 0xFA94, 0xFAB5, 0xFADF, 
	0xFB10, 0xFB48, 0xFB87, 0xFBCC, 0xFC17, 0xFC66, 0xFCBB, 0xFD13, 0xFD6F, 
	0xFDCD, 0xFE2E, 0xFE91, 0xFEF5, 0xFF5A, 0xFFC0, 0x0026, 0x008A, 0x00ED, 
	0x014D, 0x01AB, 0x0206, 0x025C, 0x02AF, 0x02FC, 0x0344, 0x0385, 0x03C0, 
	0x03F3, 0x041E, 0x0441, 0x045A, 0x046A, 0x046F, 0x046A, 0x045A, 0x0441, 
	0x041E, 0x03F3, 0x03C0, 0x0385, 0x0344, 0x02FC, 0x02AF, 0x025C, 0x0206, 
	0x01AB, 0x014D, 0x00ED, 0x008A, 0x0026, 0xFFC0, 0xFF5A, 0xFEF5, 0xFE91, 
	0xFE2E, 0xFDCD, 0xFD6F, 0xFD13, 0xFCBB, 0xFC66, 0xFC17, 0xFBCC, 0xFB87, 
	0xFB48, 0xFB10, 0xFADF, 0xFAB5, 0xFA94, 0xFA7C, 0xFA6D, 0xFA68, 0x5113, 
	0x5118, 0x5125, 0x513A, 0x5155, 0x5176, 0x519B, 0x51C4, 0x51EF, 0x521C, 
	0x5249, 0x5276, 0x52A1, 0x52CA, 0x52F0, 0x5310, 0x532C, 0x5340, 0x534D, 
	0x5352, 0x534E, 0x5343, 0x5331, 0x531A, 0x52FD, 0x52DD, 0x52BA, 0x5295, 
	0x526F, 0x5248, 0x5221, 0x51FC, 0x51D9, 0x51B9, 0x519D, 0x5186, 0x5174, 
	0x5168, 0x5165, 0x5168, 0x5174, 0x5186, 0x519D, 0x51B9, 0x51D9, 0x51FC, 
	0x5221, 0x5248, 0x526F, 0x5295, 0x52BA, 0x52DD, 0x52FD, 0x531A, 0x5331, 
	0x5343, 0x534E, 0x5352, 0x534D, 0x5340, 0x532C, 0x5310, 0x52F0, 0x52CA, 
	0x52A1, 0x5276, 0x5249, 0x521C, 0x51EF, 0x51C4, 0x519B, 0x5176, 0x5155, 
	0x513A, 0x5125, 0x5118, 0x5113, 0xF60D, 0xF60E, 0xF611, 0xF618, 0xF623, 
	0xF634, 0xF64B, 0xF669, 0xF690, 0xF6C1, 0xF6FC, 0xF743, 0xF796, 0xF7F7, 
	0xF867, 0xF8E6, 0xF975, 0xFA17, 0xFACB, 0xFB93, 0xFC6F, 0xFD5C, 0xFE57, 
	0xFF5D, 0x006B, 0x017C, 0x028E, 0x039D, 0x04A6, 0x05A6, 0x0698, 0x077B, 
	0x084B, 0x0904, 0x09A2, 0x0A23, 0x0A84, 0x0AC0, 0x0AD5, 0x0AD4, 0x0AD0, 
	0x0AC8, 0x0ABB, 0x0AA9, 0x0A8F, 0x0A6E, 0x0A45, 0x0A12, 0x09D4, 0x098B, 
	0x0935, 0x08D1, 0x0860, 0x07DF, 0x074D, 0x06AB, 0x05F6, 0x052E, 0x0452, 
	0x0366, 0x026C, 0x0168, 0x005D, 0xFF4D, 0xFE3D, 0xFD31, 0xFC2A, 0xFB2D, 
	0xFA3D, 0xF95C, 0xF88F, 0xF7D9, 0xF73C, 0xF6BC, 0xF65D, 0xF621, 0xF60D, 
	0x0E77, 0x0E60, 0x0E1D, 0x0DB1, 0x0D20, 0x0C6D, 0x0B9B, 0x0AAD, 0x09A7, 
	0x088D, 0x0760, 0x0625, 0x04E0, 0x0392, 0x0240, 0x00ED, 0xFF9B, 0xFE4F, 
	0xFD0C, 0xFBD5, 0xFAAD, 0xF994, 0xF88A, 0xF790, 0xF6A6, 0xF5CB, 0xF500, 
	0xF445, 0xF39A, 0xF2FE, 0xF273, 0xF1F8, 0xF18D, 0xF132, 0xF0E8, 0xF0AE, 
	0xF084, 0xF06B, 0xF063, 0xF07A, 0xF0BD, 0xF128, 0xF1B9, 0xF26B, 0xF33D, 
	0xF42A, 0xF52F, 0xF649, 0xF774, 0xF8AE, 0xF9F3, 0xFB40, 0xFC91, 0xFDE4, 
	0xFF35, 0x0081, 0x01C4, 0x02FB, 0x0423, 0x053C, 0x0646, 0x0741, 0x082C, 
	0x0907, 0x09D3, 0x0A8F, 0x0B3B, 0x0BD7, 0x0C63, 0x0CDF, 0x0D4B, 0x0DA6, 
	0x0DF1, 0x0E2C, 0x0E56, 0x0E6F, 0x0E77, 0x14C1, 0x14C1, 0x14C3, 0x14C6, 
	0x14CA, 0x14CF, 0x14D5, 0x14DB, 0x14E1, 0x14E8, 0x14EF, 0x14F5, 0x14FC, 
	0x1502, 0x1507, 0x150C, 0x1510, 0x1513, 0x1515, 0x1516, 0x1515, 0x1511, 
	0x150B, 0x1503, 0x14F9, 0x14EE, 0x14E3, 0x14D6, 0x14C9, 0x14BC, 0x14AF, 
	0x14A2, 0x1496, 0x148B, 0x1482, 0x147A, 0x1474, 0x1470, 0x146F, 0x146F, 
	0x146F, 0x146F, 0x146F, 0x1470, 0x1470, 0x1471, 0x1472, 0x1473, 0x1474, 
	0x1475, 0x1477, 0x1478, 0x147A, 0x147C, 0x147F, 0x1481, 0x1484, 0x1487, 
	0x148A, 0x148E, 0x1492, 0x1496, 0x149A, 0x149E, 0x14A2, 0x14A6, 0x14AA, 
	0x14AD, 0x14B1, 0x14B4, 0x14B7, 0x14BA, 0x14BC, 0x14BE, 0x14BF, 0x14C0, 
	0x14C1, 0x06DB, 0x06D3, 0x06BC, 0x0696, 0x0662, 0x0622, 0x05D6, 0x057F, 
	0x051E, 0x04B4, 0x0441, 0x03C8, 0x0348, 0x02C3, 0x023A, 0x01AD, 0x011D, 
	0x008B, 0xFFF8, 0xFF66, 0xFED5, 0xFE45, 0xFDB8, 0xFD2E, 0xFCA8, 0xFC27, 
	0xFBAA, 0xFB34, 0xFAC4, 0xFA5C, 0xF9FB, 0xF9A4, 0xF955, 0xF911, 0xF8D8, 
	0xF8AA, 0xF888, 0xF874, 0xF86D, 0xF874, 0xF888, 0xF8AA, 0xF8D7, 0xF910, 
	0xF954, 0xF9A2, 0xF9FA, 0xFA5A, 0xFAC2, 0xFB31, 0xFBA7, 0xFC24, 0xFCA5, 
	0xFD2B, 0xFDB4, 0xFE41, 0xFED1, 0xFF62, 0xFFF4, 0x0087, 0x0119, 0x01A9, 
	0x0236, 0x02C0, 0x0345, 0x03C5, 0x043F, 0x04B2, 0x051C, 0x057D, 0x05D5, 
	0x0621, 0x0662, 0x0695, 0x06BC, 0x06D3, 0x06DB, 0xFEE7, 0xFEFB, 0xFF34, 
	0xFF8D, 0x0003, 0x0090, 0x0130, 0x01E0, 0x029A, 0x035B, 0x041E, 0x04DF, 
	0x059A, 0x0649, 0x06EA, 0x0777, 0x07EC, 0x0845, 0x087D, 0x0891, 0x0885, 
	0x0860, 0x0826, 0x07D9, 0x0779, 0x070A, 0x068D, 0x0604, 0x0572, 0x04D8, 
	0x0438, 0x0395, 0x02F0, 0x024C, 0x01AA, 0x010C, 0x0075, 0xFFE5, 0xFF61, 
	0xFEE9, 0xFE7D, 0xFE1C, 0xFDC5, 0xFD79, 0xFD36, 0xFCFC, 0xFCCA, 0xFCA0, 
	0xFC7C, 0xFC5F, 0xFC48, 0xFC35, 0xFC28, 0xFC1E, 0xFC17, 0xFC13, 0xFC11, 
	0xFC11, 0xFC16, 0xFC27, 0xFC41, 0xFC64, 0xFC8D, 0xFCBC, 0xFCF0, 0xFD27, 
	0xFD5F, 0xFD99, 0xFDD1, 0xFE08, 0xFE3C, 0xFE6B, 0xFE94, 0xFEB6, 0xFED1, 
	0xFEE1, 0xFEE7, 0xD8B7, 0xD8B8, 0xD8BA, 0xD8BD, 0xD8C2, 0xD8C7, 0xD8CD, 
	0xD8D4, 0xD8DB, 0xD8E2, 0xD8EA, 0xD8F1, 0xD8F8, 0xD8FF, 0xD905, 0xD90A, 
	0xD90F, 0xD912, 0xD914, 0xD915, 0xD915, 0xD914, 0xD914, 0xD913, 0xD912, 
	0xD911, 0xD910, 0xD90F, 0xD90E, 0xD90C, 0xD90B, 0xD90A, 0xD909, 0xD908, 
	0xD907, 0xD906, 0xD906, 0xD905, 0xD905, 0xD90C, 0xD921, 0xD941, 0xD96C, 
	0xD9A0, 0xD9DA, 0xDA1A, 0xDA5E, 0xDAA4, 0xDAEB, 0xDB32, 0xDB76, 0xDBB6, 
	0xDBF0, 0xDC23, 0xDC4E, 0xDC6F, 0xDC83, 0xDC8A, 0xDC83, 0xDC6C, 0xDC49, 
	0xDC1A, 0xDBE3, 0xDBA3, 0xDB5E, 0xDB14, 0xDAC7, 0xDA7A, 0xDA2E, 0xD9E4, 
	0xD99E, 0xD95F, 0xD927, 0xD8F8, 0xD8D5, 0xD8BF, 0xD8B7, 0x0001, 0xFFFE, 
	0xC170, 0xBB57, 0xBB07, 0xBA21, 0xB8B8, 0xB6DC, 0xB4A0, 0xB214, 0xAF4C, 
	0xAC57, 0x2948, 0x2631, 0x2322, 0x202D, 0x1D64, 0x1AD9, 0x189D, 0x16C1, 
	0x1557, 0x1472, 0x1421, 0x1434, 0x146B, 0x14C2, 0x1535, 0x15C2, 0x1665, 
	0x171A, 0x17DF, 0x18AF, 0x1987, 0x1A64, 0x1B43, 0x1C1F, 0x1CF6, 0x1DC4, 
	0x1E86, 0x1F38, 0x1FD6, 0x205E, 0x20CE, 0x2126, 0x216A, 0x219F, 0x21C5, 
	0x21E2, 0x21F7, 0x2208, 0x2219, 0x222C, 0x2244, 0x2266, 0x2293, 0x22CF, 
	0x231D, 0x2381, 0x23FD, 0x2495, 0x254C, 0xA62B, 0xA739, 0xA86D, 0xA9C1, 
	0xAB2F, 0xACB0, 0xAE3D, 0xAFD1, 0xB163, 0xB2EF, 0xB46D, 0xB5D6, 0xB725, 
	0xB852, 0xB957, 0xBA2D, 0xBACE, 0xBB34, 0xBB57, 0x9F0D, 0x9F37, 0x9FB0, 
	0xA06F, 0xA16A, 0xA298, 0xA3EF, 0xA567, 0xA6F6, 0xD76B, 0xD5CA, 0xD42C, 
	0xD29D, 0xD125, 0xCFCE, 0xCEA0, 0xCDA5, 0xCCE6, 0xCC6D, 0xCC43, 0xCC53, 
	0xCC81, 0xCCC9, 0xCD28, 0xCD9A, 0xCE1D, 0xCEAB, 0xCF42, 0xCFDF, 0xD07D, 
	0xD11A, 0xD1B1, 0xD23F, 0xD2C1, 0xD334, 0xD393, 0xD3DB, 0xD409, 0xD419, 
	0xD411, 0xD3F9, 0xD3D3, 0xD3A2, 0xD367, 0xD323, 0xD2D9, 0xD28A, 0xD239, 
	0xD1E7, 0xD196, 0xD147, 0xD0FD, 0xD0B9, 0xD07E, 0xD04D, 0xD027, 0xD00F, 
	0xD007, 0xAFD5, 0xAF72, 0xAED6, 0xAE09, 0xAD12, 0xABF9, 0xAAC5, 0xA97F, 
	0xA82D, 0xA6D7, 0xA586, 0xA43F, 0xA30C, 0xA1F3, 0xA0FC, 0xA02E, 0x9F92, 
	0x9F2F, 0x9F0D, 0xFAF0, 0xFB61, 0xFCA6, 0xFEA5, 0x0147, 0x0470, 0x0808, 
	0x0BF8, 0x1025, 0x9478, 0x98D7, 0x9D2A, 0xA158, 0xA547, 0xA8E0, 0xAC09, 
	0xAEA9, 0xB0A8, 0xB1ED, 0xB25F, 0xB25F, 0xB25E, 0xB25E, 0xB25C, 0xB259, 
	0xB255, 0xB250, 0xB249, 0xB23F, 0xB234, 0xB225, 0xB214, 0xB200, 0xB1E8, 
	0xB1CD, 0xB1AE, 0xB18B, 0xB163, 0xB137, 0xB0F1, 0xB07E, 0xAFDF, 0xAF18, 
	0xAE2B, 0xAD19, 0xABE6, 0xAA93, 0xA923, 0xA798, 0xA5F4, 0xA43A, 0xA26C, 
	0xA08C, 0x9E9D, 0x9CA0, 0x9A99, 0x9889, 0x9672, 0x1459, 0x123E, 0x1026, 
	0x0E14, 0x0C0B, 0x0A10, 0x0825, 0x064D, 0x048D, 0x02E8, 0x0160, 0xFFF9, 
	0xFEB7, 0xFD9E, 0xFCB0, 0xFBF1, 0xFB64, 0xFB0D, 0xFAF0, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xE221, 
	0xE1D5, 0xE0FD, 0xDFA8, 0xDDE8, 0xDBCD, 0xD967, 0xD6C8, 0xD3FF, 0xD11D, 
	0xCE33, 0xCB51, 0xC888, 0xC5E9, 0xC383, 0xC168, 0xBFA8, 0xBE53, 0xBD7B, 
	0xBD2F, 0xBD30, 0xBD33, 0xBD38, 0xBD3E, 0xBD46, 0xBD4F, 0xBD59, 0xBD64, 
	0xBD70, 0xBD7C, 0xBD88, 0xBD94, 0xBDA1, 0xBDAD, 0xBDB8, 0xBDC3, 0xBDCD, 
	0xBDD6, 0xBDDD, 0xBDE4, 0xBDEA, 0xBDF3, 0xBDFF, 0xBE11, 0xBE29, 0xBE4B, 
	0xBE76, 0xBEAE, 0xBEF4, 0xBF49, 0xBFAF, 0xC028, 0xC0B6, 0xC15A, 0xC215, 
	0xC2EB, 0xC3DC, 0xC4EA, 0xC625, 0xC799, 0xC93C, 0xCB07, 0xCCF0, 0xCEF0, 
	0xD0FF, 0xD313, 0xD525, 0xD72C, 0xD91F, 0xDAF8, 0xDCAC, 0xDE34, 0xDF88, 
	0xE09E, 0xE170, 0xE1F3, 0xE221, 0xE18E, 0xE19E, 0xE1CD, 0xE219, 0xE280, 
	0xE300, 0xE399, 0xE447, 0xE509, 0xE5DF, 0xE6C4, 0xE7B9, 0xE8BB, 0xE9C9, 
	0xEAE0, 0xEC00, 0xED26, 0xEE50, 0xEF7D, 0xF0AB, 0xF1D8, 0xF303, 0xF42A, 
	0xF54C, 0xF666, 0xF778, 0xF87F, 0xF97B, 0xFA69, 0xFB48, 0xFC16, 0xFCD2, 
	0xFD7A, 0xFE0D, 0xFE88, 0xFEEB, 0xFF34, 0xFF60, 0xFF70, 0xFF5E, 0xFF2A, 
	0xFED7, 0xFE66, 0xFDD9, 0xFD33, 0xFC76, 0xFBA3, 0xFABD, 0xF9C7, 0xF8C1, 
	0xF7AF, 0xF692, 0xF56D, 0xF441, 0xF312, 0xF1E0, 0xF0AE, 0xEF7E, 0xEE52, 
	0xED2C, 0xEC0D, 0xEAF6, 0xE9E7, 0xE8E3, 0xE7EB, 0xE700, 0xE622, 0xE554, 
	0xE496, 0xE3EB, 0xE352, 0xE2CD, 0xE25D, 0xE205, 0xE1C4, 0xE19C, 0xE18E, 
	0x0F51, 0x0F48, 0x0F2E, 0x0F03, 0x0EC8, 0x0E7F, 0x0E28, 0x0DC4, 0x0D53, 
	0x0CD8, 0x0C51, 0x0BC2, 0x0B29, 0x0A88, 0x09E1, 0x0933, 0x0880, 0x07C8, 
	0x070D, 0x064E, 0x058F, 0x04CE, 0x040E, 0x0350, 0x0295, 0x01DE, 0x012D, 
	0x0083, 0xFFE0, 0xFF47, 0xFEBA, 0xFE38, 0xFDC3, 0xFD5D, 0xFD07, 0xFCC1, 
	0xFC8E, 0xFC6E, 0xFC64, 0xFC64, 0xFC65, 0xFC68, 0xFC6E, 0xFC78, 0xFC86, 
	0xFC9B, 0xFCB6, 0xFCD9, 0xFD05, 0xFD3A, 0xFD7A, 0xFDC6, 0xFE1E, 0xFE84, 
	0xFEF8, 0xFF7B, 0x0011, 0x00B6, 0x0171, 0x0241, 0x0324, 0x0415, 0x0510, 
	0x0613, 0x071A, 0x0820, 0x0923, 0x0A1F, 0x0B0F, 0x0BF1, 0x0CC0, 0x0D7A, 
	0x0E1A, 0x0E9C, 0x0EFE, 0x0F3C, 0x0F51, 0x0377, 0x0398, 0x03F4, 0x0485, 
	0x0543, 0x0628, 0x072D, 0x084B, 0x097A, 0x0AB4, 0x0BF1, 0x0D2B, 0x0E5A, 
	0x0F78, 0x107D, 0x1162, 0x1221, 0x12B2, 0x130E, 0x132E, 0x132E, 0x132D, 
	0x132C, 0x1329, 0x1324, 0x131C, 0x1311, 0x1303, 0x12F1, 0x12DB, 0x12BF, 
	0x129E, 0x1277, 0x1249, 0x1215, 0x11D9, 0x1195, 0x1148, 0x10F3, 0x1079, 
	0x0FC5, 0x0EDE, 0x0DCB, 0x0C95, 0x0B42, 0x09DA, 0x0864, 0x06E7, 0x056C, 
	0x03F9, 0x0296, 0x014A, 0x001D, 0xFF15, 0xFE3B, 0xFD97, 0xFD2F, 0xFD0A, 
	0xFD18, 0xFD3D, 0xFD78, 0xFDC6, 0xFE24, 0xFE8F, 0xFF03, 0xFF7F, 0x0001, 
	0x0082, 0x0102, 0x017E, 0x01F3, 0x025E, 0x02BB, 0x0309, 0x0344, 0x036A, 
	0x0377, 0x0001, 0xFFFE, 0xC170, 0xD7EA, 0xD7DA, 0xD7AB, 0xD760, 0xD6FC, 
	0xD682, 0xD5F4, 0xD556, 0xD4A9, 0xD3F2, 0xD331, 0xD26B, 0xD1A2, 0x50D9, 
	0x5012, 0x4F50, 0x4E97, 0x4DE8, 0x4D47, 0x4CB6, 0x4C37, 0x4BC9, 0x4B68, 
	0x4B12, 0x4AC4, 0x4A7B, 0x4A35, 0x49EE, 0x49A5, 0x4955, 0x48FD, 0x489A, 
	0x4828, 0x47A6, 0x4710, 0x4663, 0x459D, 0x44BC, 0x43BB, 0x429B, 0x415D, 
	0x4009, 0x3EA2, 0x3D2E, 0x3BB1, 0x3A31, 0x38B3, 0x373C, 0x35D0, 0x3476, 
	0x3331, 0x3207, 0x30FD, 0x3019, 0x2F5E, 0x2ED2, 0x2E7B, 0x2E5D, 0x2EB2, 
	0x2FA5, 0x3124, 0x331D, 0x357B, 0x382D, 0x3B20, 0x3E42, 0x4180, 0x44C7, 
	0x4805, 0x4B27, 0xCE19, 0xD0CC, 0xD32A, 0xD522, 0xD6A1, 0xD795, 0xD7EA, 
	0x2E02, 0x2E02, 0x2E01, 0x2E01, 0x2E00, 0x2DFE, 0x2DFC, 0x2DF9, 0x2DF4, 
	0x2DEF, 0x2DE8, 0x2DDF, 0x2DD5, 0x5237, 0x5245, 0x5255, 0x5267, 0x527C, 
	0x5294, 0x52AF, 0x52E4, 0x534A, 0x53D9, 0x548D, 0x555F, 0x564A, 0x5748, 
	0x5853, 0x5965, 0x5A78, 0x5B87, 0x5C8C, 0x5D81, 0x5E60, 0x5F23, 0x5FC5, 
	0x6040, 0x608E, 0x60AA, 0x6085, 0x601D, 0x5F7A, 0x5EA3, 0x5DA1, 0x5C7A, 
	0x5B38, 0x59E2, 0x5880, 0x571B, 0x55B9, 0x5463, 0x5321, 0x51FB, 0x50F8, 
	0x5021, 0x4F7E, 0x4F16, 0x4EF1, 0x4EF8, 0x4F0A, 0x4F26, 0x4F4B, 0x4F77, 
	0x4FAA, 0x4FE1, 0x501C, 0x5059, 0x5096, 0x50D3, 0x510E, 0x2EBA, 0x2E87, 
	0x2E5B, 0x2E36, 0x2E1A, 0x2E08, 0x2E02, 0xAF1B, 0xAEF4, 0xAE83, 0xADCD, 
	0xACD7, 0xABA8, 0xAA45, 0xA8B3, 0xA6F9, 0xA51A, 0xA31E, 0xA109, 0x9EE1, 
	0x1CAD, 0x1A70, 0x1830, 0x15F4, 0x13C1, 0x119C, 0x0F8B, 0x0D93, 0x0BB4, 
	0x09EF, 0x0844, 0x06B3, 0x053C, 0x03E0, 0x029F, 0x0179, 0x006E, 0xFF7D, 
	0xFEA8, 0xFDF0, 0xFD53, 0xFCD2, 0xFC6E, 0xFC26, 0xFBFA, 0xFBEC, 0xFBEC, 
	0xFBEC, 0xFBEC, 0xFBED, 0xFBEE, 0xFBEF, 0xFBF1, 0xFBF3, 0xFBF6, 0xFBFA, 
	0xFBFE, 0xFC04, 0xFC0A, 0xFC12, 0xFC1B, 0xFC25, 0xFC30, 0xFC3D, 0xFC4B, 
	0xFCC1, 0xFDF5, 0xFFD2, 0x0240, 0x0529, 0x0877, 0x0C12, 0x0FE5, 0x13D8, 
	0x17D7, 0x1BC9, 0x1F98, 0xA32E, 0xA675, 0xA956, 0xABBB, 0xAD8C, 0xAEB4, 
	0xAF1B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xC25E, 0xC262, 0xC26F, 0xC285, 0xC2A5, 0xC2D1, 0xC309, 
	0xC34D, 0xC3A0, 0xC401, 0xC472, 0xC4F4, 0xC587, 0xC62C, 0xC6E4, 0xC7B0, 
	0xC891, 0xC988, 0xCA96, 0xCBBB, 0xCCF8, 0xCE48, 0xCFA9, 0xD116, 0xD289, 
	0xD400, 0xD576, 0xD6E6, 0xD84D, 0xD9A6, 0xDAEC, 0xDC1C, 0xDD32, 0xDE28, 
	0xDEFB, 0xDFA7, 0xE027, 0xE076, 0xE092, 0xE04E, 0xDF8A, 0xDE57, 0xDCC2, 
	0xDADB, 0xD8B1, 0xD653, 0xD3CF, 0xD135, 0xCE93, 0xCBF9, 0xC975, 0xC717, 
	0xC4ED, 0xC306, 0xC172, 0xC03E, 0xBF7B, 0xBF36, 0xBF3D, 0xBF4F, 0xBF6C, 
	0xBF92, 0xBFC1, 0xBFF5, 0xC02E, 0xC06B, 0xC0AA, 0xC0EA, 0xC129, 0xC166, 
	0xC19F, 0xC1D4, 0xC202, 0xC228, 0xC245, 0xC258, 0xC25E, 0xFE13, 0xFE13, 
	0xFE14, 0xFE15, 0xFE17, 0xFE1B, 0xFE21, 0xFE29, 0xFE34, 0xFE42, 0xFE53, 
	0xFE68, 0xFE82, 0xFE9F, 0xFEC2, 0xFEEB, 0xFF18, 0xFF4D, 0xFF87, 0xFFC9, 
	0x003A, 0x00FC, 0x0205, 0x034A, 0x04C3, 0x0664, 0x0825, 0x09FB, 0x0BDD, 
	0x0DBF, 0x0F9A, 0x1161, 0x130C, 0x1491, 0x15E5, 0x16FF, 0x17D5, 0x185C, 
	0x188C, 0x1882, 0x1864, 0x1833, 0x17F0, 0x179B, 0x1735, 0x16BF, 0x1639, 
	0x15A4, 0x1500, 0x144F, 0x1391, 0x12C6, 0x11EF, 0x110E, 0x1022, 0x0F2C, 
	0x0E2D, 0x0D25, 0x0C16, 0x0B02, 0x09EA, 0x08D2, 0x07BB, 0x06A7, 0x059A, 
	0x0495, 0x039A, 0x02AD, 0x01CE, 0x0102, 0x0049, 0xFFA5, 0xFF1A, 0xFEAB, 
	0xFE58, 0xFE25, 0xFE13, 0x09B9, 0x09B3, 0x09A0, 0x097F, 0x0951, 0x0915, 
	0x08CA, 0x0871, 0x0809, 0x0791, 0x0709, 0x0671, 0x05C8, 0x050F, 0x0444, 
	0x0367, 0x0278, 0x0177, 0x0062, 0xFF3A, 0xFDFF, 0xFCB5, 0xFB5F, 0xFA00, 
	0xF89D, 0xF739, 0xF5D7, 0xF47D, 0xF32D, 0xF1EB, 0xF0BB, 0xEFA1, 0xEEA0, 
	0xEDBC, 0xECFA, 0xEC5C, 0xEBE6, 0xEB9D, 0xEB84, 0xEB9A, 0xEBDA, 0xEC41, 
	0xECCC, 0xED78, 0xEE41, 0xEF26, 0xF022, 0xF133, 0xF255, 0xF386, 0xF4C2, 
	0xF607, 0xF751, 0xF89E, 0xF9EA, 0xFB32, 0xFC73, 0xFDAA, 0xFED5, 0xFFF2, 
	0x0103, 0x0205, 0x02F8, 0x03DD, 0x04B3, 0x057A, 0x0631, 0x06D9, 0x0770, 
	0x07F6, 0x086C, 0x08D1, 0x0923, 0x0965, 0x0993, 0x09B0, 0x09B9, 0x0959, 
	0x0935, 0x08CD, 0x0829, 0x0752, 0x064F, 0x0528, 0x03E6, 0x028F, 0x012D, 
	0xFFC6, 0xFE64, 0xFD0D, 0xFBCB, 0xFAA4, 0xF9A1, 0xF8CA, 0xF826, 0xF7BE, 
	0xF79A, 0xF7AB, 0xF7DB, 0xF82A, 0xF895, 0xF919, 0xF9B6, 0xFA6A, 0xFB31, 
	0xFC0B, 0xFCF6, 0xFDEF, 0xFEF4, 0x0005, 0x011E, 0x023E, 0x0362, 0x048A, 
	0x05B2, 0x06D9, 0x07FD, 0x091D, 0x0A38, 0x0B4C, 0x0C57, 0x0D59, 0x0E50, 
	0x0F3B, 0x1018, 0x10E6, 0x11A5, 0x1252, 0x12EC, 0x1372, 0x13E3, 0x143C, 
	0x147E, 0x14A7, 0x14B4, 0x149D, 0x145B, 0x13F2, 0x1368, 0x12C2, 0x1206, 
	0x1137, 0x105C, 0x0F79, 0x0E94, 0x0DB1, 0x0CD6, 0x0C08, 0x0B4B, 0x0AA5, 
	0x0A1B, 0x09B3, 0x0970, 0x0959, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xC5E3, 0x0EB8, 0x0EAD, 0x0E8E, 0x0E5C, 0x0E18, 
	0x0DC3, 0x0D5E, 0x0CEA, 0x0C69, 0x0BDB, 0x0B41, 0x0A9D, 0x09F0, 0x093A, 
	0x087E, 0x07BB, 0x06F3, 0x0628, 0x055A, 0x048A, 0x03BA, 0x02EA, 0x021C, 
	0x0151, 0x008B, 0xFFC9, 0xFF0F, 0xFE5D, 0xFDB4, 0xFD15, 0xFC82, 0xFBFC, 
	0xFB83, 0xFB1A, 0xFAC1, 0xFA7A, 0xFA46, 0xFA26, 0xFA1B, 0xFA22, 0xFA38, 
	0xFA5B, 0xFA8C, 0xFACB, 0xFB16, 0xFB6D, 0xFBD1, 0xFC40, 0xFCBA, 0xFD3F, 
	0xFDCE, 0xFE67, 0xFF0A, 0xFFB6, 0x006C, 0x0129, 0x01EE, 0x02BA, 0x038E, 
	0x0467, 0x0543, 0x0620, 0x06FE, 0x07D8, 0x08AF, 0x097F, 0x0A47, 0x0B05, 
	0x0BB8, 0x0C5C, 0x0CF1, 0x0D74, 0x0DE3, 0x0E3D, 0x0E80, 0x0EA9, 0x0EB8, 
	0xF60E, 0xF620, 0xF651, 0xF69F, 0xF706, 0xF781, 0xF80E, 0xF8A8, 0xF94B, 
	0xF9F4, 0xFA9F, 0xFB48, 0xFBEB, 0xFC85, 0xFD11, 0xFD8C, 0xFDF3, 0xFE41, 
	0xFE73, 0xFE84, 0xFE74, 0xFE48, 0xFE03, 0xFDA7, 0xFD39, 0xFCBC, 0xFC33, 
	0xFBA1, 0xFB0A, 0xFA72, 0xF9DB, 0xF949, 0xF8C0, 0xF843, 0xF7D5, 0xF779, 
	0xF734, 0xF707, 0xF6F8, 0xF708, 0xF737, 0xF780, 0xF7E1, 0xF855, 0xF8D9, 
	0xF96A, 0xFA03, 0xFAA2, 0xFB43, 0xFBE2, 0xFC7B, 0xFD0C, 0xFD90, 0xFE04, 
	0xFE65, 0xFEAE, 0xFEDD, 0xFEED, 0xFEDB, 0xFEA7, 0xFE55, 0xFDEA, 0xFD68, 
	0xFCD5, 0xFC34, 0xFB89, 0xFAD7, 0xFA24, 0xF973, 0xF8C8, 0xF827, 0xF793, 
	0xF712, 0xF6A6, 0xF655, 0xF621, 0xF60E, 0xBF5E, 0xBF0C, 0xBE1F, 0xBCA6, 
	0xBAB2, 0xB851, 0xB592, 0xB285, 0xAF39, 0xABBD, 0xA820, 0xA473, 0xA0C3, 
	0x9D20, 0x999A, 0x9640, 0x9321, 0x904C, 0x8DD1, 0x8BBE, 0x89FD, 0x886C, 
	0x8707, 0x85CC, 0x84B8, 0x83C9, 0x82FC, 0x824F, 0x81BE, 0x8148, 0x80E9, 
	0x809F, 0x8068, 0x8040, 0x8025, 0x8015, 0x800D, 0x800A, 0x8009, 0x8037, 
	0x80BD, 0x8194, 0x82B5, 0x841B, 0x85C0, 0x879C, 0x89A9, 0x8BE2, 0x8E40, 
	0x90BC, 0x9351, 0x95F7, 0x98A9, 0x9B60, 0x9E16, 0xA0C4, 0xA364, 0xA5F1, 
	0xA863, 0xAABA, 0xACF6, 0xAF14, 0xB115, 0xB2F8, 0xB4BB, 0xB65F, 0xB7E2, 
	0xB944, 0xBA84, 0xBBA1, 0xBC9A, 0xBD6F, 0xBE1F, 0xBEAA, 0xBF0D, 0xBF4A, 
	0xBF5E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x112B, 
	0x11C2, 0x136E, 0x1611, 0x1988, 0x1DB4, 0x2273, 0x27A4, 0x2D28, 0x32DD, 
	0x38A2, 0x3E57, 0x43DA, 0x490C, 0x4DCB, 0x51F7, 0x556E, 0x5810, 0x59BD, 
	0x5A53, 0x5A37, 0x59E4, 0x595E, 0x58AA, 0x57CA, 0x56C2, 0x5597, 0x544B, 
	0x52E2, 0x5161, 0x4FCB, 0x4E23, 0x4C6E, 0x4AAE, 0x48E8, 0x471F, 0x4557, 
	0x4395, 0x41DA, 0x402B, 0x3E87, 0x3CED, 0x3B5C, 0x39D3, 0x3852, 0x36D7, 
	0x3562, 0x33F0, 0x3282, 0x3116, 0x2FAC, 0x2E42, 0x2CD8, 0x2B6C, 0x29FE, 
	0x288C, 0x2716, 0x259A, 0x2419, 0x2294, 0x210E, 0x1F8A, 0x1E0B, 0x1C94, 
	0x1B27, 0x19C7, 0x1877, 0x173A, 0x1612, 0x1503, 0x140F, 0x1338, 0x1283, 
	0x11F1, 0x1185, 0x1142, 0x112B, 0x0000, 0xFFFA, 0xFFEC, 0xFFD5, 0xFFB7, 
	0xFF94, 0xFF6B, 0xFF3F, 0xFF10, 0xFEDF, 0xFEAD, 0xFE7D, 0xFE4D, 0xFE21, 
	0xFDF8, 0xFDD5, 0xFDB7, 0xFDA0, 0xFD92, 0xFD8D, 0xFD98, 0xFDB8, 0xFDE9, 
	0xFE2B, 0xFE79, 0xFED3, 0xFF34, 0xFF9C, 0x0009, 0x0075, 0x00E1, 0x0149, 
	0x01AB, 0x0204, 0x0252, 0x0294, 0x02C5, 0x02E5, 0x02F0, 0x02EE, 0x02E6, 
	0x02DB, 0x02CC, 0x02B9, 0x02A3, 0x028A, 0x026E, 0x0251, 0x0232, 0x0211, 
	0x01EF, 0x01CD, 0x01AA, 0x0188, 0x0166, 0x0144, 0x0124, 0x0106, 0x00E9, 
	0x00CE, 0x00B5, 0x009E, 0x0088, 0x0075, 0x0062, 0x0052, 0x0043, 0x0036, 
	0x002A, 0x0020, 0x0017, 0x0010, 0x000A, 0x0006, 0x0002, 0x0001, 0x0000, 
	0xFFFF, 0x0002, 0x0009, 0x0013, 0x0022, 0x0034, 0x004B, 0x0065, 0x0082, 
	0x00A3, 0x00C7, 0x00EF, 0x0119, 0x0147, 0x0177, 0x01AA, 0x01DF, 0x0217, 
	0x0251, 0x028E, 0x02CC, 0x030C, 0x034D, 0x038E, 0x03CF, 0x040F, 0x044F, 
	0x048C, 0x04C7, 0x04FE, 0x0533, 0x0563, 0x058F, 0x05B5, 0x05D6, 0x05F0, 
	0x0604, 0x0610, 0x0614, 0x0612, 0x0609, 0x05FC, 0x05E9, 0x05D2, 0x05B7, 
	0x0597, 0x0574, 0x054D, 0x0522, 0x04F5, 0x04C4, 0x0491, 0x045C, 0x0425, 
	0x03EB, 0x03B1, 0x0375, 0x0338, 0x02FA, 0x02BC, 0x027E, 0x0240, 0x0204, 
	0x01C9, 0x018F, 0x0158, 0x0123, 0x00F2, 0x00C3, 0x0099, 0x0073, 0x0052, 
	0x0035, 0x001F, 0x000E, 0x0004, 0xFFFF, 0xB0BD, 0xB092, 0xB018, 0xAF57, 
	0xAE59, 0xAD29, 0xABCE, 0xAA52, 0xA8BF, 0xA71D, 0xA578, 0xA3D6, 0xA243, 
	0xA0C7, 0x9F6C, 0x9E3C, 0x9D3E, 0x9C7E, 0x9C03, 0x9BD8, 0x9C15, 0x9CC2, 
	0x9DD2, 0x9F38, 0xA0E8, 0xA2D2, 0xA4EB, 0xA725, 0xA973, 0xABC7, 0xAE15, 
	0xB04F, 0xB268, 0xB452, 0xB601, 0xB767, 0xB878, 0xB925, 0xB961, 0xB953, 
	0xB929, 0xB8E7, 0xB88F, 0xB826, 0xB7AD, 0xB728, 0xB69A, 0xB606, 0xB56F, 
	0xB4D7, 0xB443, 0xB3B4, 0xB32F, 0xB2B5, 0xB24A, 0xB1F1, 0xB1AD, 0xB181, 
	0xB164, 0xB149, 0xB132, 0xB11D, 0xB10B, 0xB0FC, 0xB0EE, 0xB0E3, 0xB0D9, 
	0xB0D2, 0xB0CB, 0xB0C7, 0xB0C3, 0xB0C0, 0xB0BF, 0xB0BE, 0xB0BD, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xBF5E, 0x095B, 0x0953, 0x093C, 0x0916, 0x08E2, 0x08A2, 0x0855, 0x07FC, 
	0x0798, 0x072B, 0x06B4, 0x0634, 0x05AD, 0x051E, 0x0489, 0x03EF, 0x0350, 
	0x02AC, 0x0205, 0x015C, 0x00B1, 0x0005, 0xFF59, 0xFEAF, 0xFE07, 0xFD64, 
	0xFCC6, 0xFC2E, 0xFB9D, 0xFB14, 0xFA95, 0xFA21, 0xF9B8, 0xF95C, 0xF90F, 
	0xF8D1, 0xF8A3, 0xF887, 0xF87D, 0xF883, 0xF897, 0xF8B7, 0xF8E4, 0xF91C, 
	0xF95F, 0xF9AC, 0xFA04, 0xFA66, 0xFAD1, 0xFB44, 0xFBC0, 0xFC43, 0xFCCE, 
	0xFD60, 0xFDF8, 0xFE95, 0xFF39, 0xFFE1, 0x008E, 0x013E, 0x01EF, 0x02A0, 
	0x0350, 0x03FD, 0x04A7, 0x054B, 0x05E8, 0x067C, 0x0708, 0x0788, 0x07FB, 
	0x0861, 0x08B7, 0x08FD, 0x0930, 0x0950, 0x095B, 0x0F16, 0x0EF4, 0x0E95, 
	0x0DFF, 0x0D39, 0x0C4C, 0x0B3D, 0x0A16, 0x08DB, 0x0796, 0x064E, 0x0509, 
	0x03CE, 0x02A6, 0x0198, 0x00AB, 0xFFE4, 0xFF4E, 0xFEEF, 0xFECD, 0xFEDF, 
	0xFF14, 0xFF66, 0xFFD3, 0x0056, 0x00EB, 0x018D, 0x0239, 0x02EC, 0x03A0, 
	0x0453, 0x04FF, 0x05A2, 0x0636, 0x06B9, 0x0725, 0x0777, 0x07AC, 0x07BE, 
	0x07B2, 0x078F, 0x0759, 0x0711, 0x06BB, 0x0658, 0x05ED, 0x057A, 0x0504, 
	0x048D, 0x0417, 0x03A4, 0x0339, 0x02D7, 0x0280, 0x0238, 0x0202, 0x01DF, 
	0x01D3, 0x01EE, 0x023C, 0x02B6, 0x0357, 0x0419, 0x04F5, 0x05E6, 0x06E6, 
	0x07EF, 0x08FA, 0x0A03, 0x0B03, 0x0BF4, 0x0CD0, 0x0D92, 0x0E33, 0x0EAD, 
	0x0EFB, 0x0F16, 0x8614, 0x863F, 0x86BA, 0x8782, 0x8891, 0x89E2, 0x8B70, 
	0x8D37, 0x8F31, 0x9159, 0x93AA, 0x9620, 0x98B5, 0x9B64, 0x9E29, 0xA0FE, 
	0xA3DE, 0xA6C4, 0xA9AC, 0xAC90, 0xAF6C, 0xB23C, 0xB4FD, 0xB7AC, 0xBA45, 
	0xBCC6, 0xBF2C, 0xC172, 0xC397, 0xC596, 0xC76D, 0xC918, 0xCA95, 0xCBE0, 
	0xCCF5, 0xCDD3, 0xCE75, 0xCED9, 0xCEFB, 0xCE6F, 0xCCE2, 0xCA6F, 0xC735, 
	0xC352, 0xBEE4, 0xBA08, 0xB4DC, 0xAF7E, 0xAA0B, 0xA4A2, 0x9F60, 0x9A64, 
	0x95CA, 0x91B0, 0x8E35, 0x8B76, 0x8991, 0x88A4, 0x8842, 0x87EA, 0x879C, 
	0x8757, 0x871B, 0x86E6, 0x86B9, 0x8693, 0x8674, 0x865A, 0x8645, 0x8635, 
	0x8629, 0x8620, 0x861A, 0x8617, 0x8615, 0x8614, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x40FB, 0x40EB, 
	0x40BD, 0x406F, 0x4002, 0x3F77, 0x3ECE, 0x3E06, 0x3D20, 0x3C1C, 0x3AFA, 
	0x39BA, 0x385D, 0x36E2, 0x354B, 0x3396, 0x31C4, 0x2FD6, 0x2DCB, 0x2BA4, 
	0x2961, 0x2708, 0x24A0, 0x222D, 0x1FB6, 0x1D42, 0x1AD6, 0x1879, 0x1630, 
	0x1402, 0x11F5, 0x100F, 0x0E55, 0x0CCF, 0x0B82, 0x0A75, 0x09AD, 0x0930, 
	0x0905, 0x09A5, 0x0B6D, 0x0E3B, 0x11EB, 0x165C, 0x1B69, 0x20F0, 0x26CE, 
	0x2CE0, 0x3304, 0x3917, 0x3EF5, 0x447C, 0x4989, 0x4DF9, 0x51AA, 0x5477, 
	0x563F, 0x56DF, 0x56B2, 0x5632, 0x5568, 0x545F, 0x531F, 0x51B4, 0x5026, 
	0x4E7F, 0x4CCA, 0x4B10, 0x495B, 0x47B4, 0x4627, 0x44BB, 0x437B, 0x4272, 
	0x41A8, 0x4128, 0x40FB, 0xFCCC, 0xFCD4, 0xFCEB, 0xFD0F, 0xFD3F, 0xFD78, 
	0xFDBA, 0xFE01, 0xFE4D, 0xFE9C, 0xFEEB, 0xFF3A, 0xFF85, 0xFFCD, 0x000F, 
	0x0049, 0x0078, 0x009D, 0x00B4, 0x00BC, 0x00BB, 0x00B8, 0x00B3, 0x00AD, 
	0x00A6, 0x009D, 0x0093, 0x0088, 0x007D, 0x0070, 0x0064, 0x0057, 0x004A, 
	0x003C, 0x002F, 0x0023, 0x0016, 0x000B, 0x0000, 0xFFF5, 0xFFEC, 0xFFE3, 
	0xFFDB, 0xFFD2, 0xFFCA, 0xFFC1, 0xFFB8, 0xFFAE, 0xFFA4, 0xFF98, 0xFF8A, 
	0xFF7C, 0xFF6B, 0xFF59, 0xFF44, 0xFF2D, 0xFF14, 0xFEF7, 0xFED8, 0xFEB6, 
	0xFE93, 0xFE6E, 0xFE47, 0xFE20, 0xFDFA, 0xFDD3, 0xFDAD, 0xFD89, 0xFD66, 
	0xFD46, 0xFD28, 0xFD0E, 0xFCF7, 0xFCE5, 0xFCD7, 0xFCCF, 0xFCCC, 0xF93A, 
	0xF940, 0xF952, 0xF96F, 0xF995, 0xF9C5, 0xF9FC, 0xFA3A, 0xFA7E, 0xFAC8, 
	0xFB15, 0xFB66, 0xFBB8, 0xFC0C, 0xFC60, 0xFCB4, 0xFD06, 0xFD55, 0xFDA0, 
	0xFDE7, 0xFE29, 0xFE65, 0xFE9D, 0xFECF, 0xFEFD, 0xFF26, 0xFF4B, 0xFF6C, 
	0xFF89, 0xFFA2, 0xFFB8, 0xFFCA, 0xFFD9, 0xFFE6, 0xFFEF, 0xFFF6, 0xFFFB, 
	0xFFFE, 0x0000, 0xFFFB, 0xFFEE, 0xFFD9, 0xFFBC, 0xFF99, 0xFF70, 0xFF41, 
	0xFF0D, 0xFED4, 0xFE98, 0xFE58, 0xFE15, 0xFDD1, 0xFD8B, 0xFD43, 0xFCFC, 
	0xFCB4, 0xFC6E, 0xFC29, 0xFBE5, 0xFBA4, 0xFB65, 0xFB28, 0xFAEE, 0xFAB7, 
	0xFA83, 0xFA52, 0xFA24, 0xF9FA, 0xF9D3, 0xF9B1, 0xF992, 0xF978, 0xF962, 
	0xF951, 0xF944, 0xF93C, 0xF93A, 0xBB81, 0xBB65, 0xBB16, 0xBA9A, 0xB9F6, 
	0xB931, 0xB851, 0xB75B, 0xB657, 0xB549, 0xB438, 0xB32B, 0xB226, 0xB131, 
	0xB050, 0xAF8B, 0xAEE7, 0xAE6B, 0xAE1C, 0xAE00, 0xAE09, 0xAE24, 0xAE4E, 
	0xAE85, 0xAEC7, 0xAF12, 0xAF64, 0xAFBC, 0xB016, 0xB072, 0xB0CC, 0xB124, 
	0xB176, 0xB1C1, 0xB204, 0xB23A, 0xB264, 0xB27F, 0xB288, 0xB282, 0xB271, 
	0xB257, 0xB234, 0xB20A, 0xB1DB, 0xB1A7, 0xB170, 0xB136, 0xB0FD, 0xB0C3, 
	0xB08C, 0xB058, 0xB028, 0xAFFF, 0xAFDC, 0xAFC1, 0xAFB1, 0xAFAB, 0xAFC3, 
	0xB008, 0xB076, 0xB105, 0xB1B2, 0xB276, 0xB34E, 0xB432, 0xB51E, 0xB60D, 
	0xB6FA, 0xB7DE, 0xB8B5, 0xB97A, 0xBA27, 0xBAB6, 0xBB23, 0xBB69, 0xBB81, 
	

},{ 
	0x0001, 0x0000, 0x004A, 0x0001, 0x0001, 0x004B, 0x0001, 0x004C, 0x0001, 
	0x004D, 0x0001, 0x004E, 0x004D, 0x004F, 0x004D, 0x009C, 0x004D, 0x00E9, 
	0x004D, 0x0136, 0x004D, 0x0183, 0x004D, 0x01D0, 0x004D, 0x021D, 0x004D, 
	0x026A, 0x004D, 0x02B7, 0x0001, 0x0304, 0x0001, 0x0305, 0x0001, 0x0306, 
	0x004D, 0x0307, 0x004D, 0x0354, 0x004D, 0x03A1, 0x004D, 0x03EE, 0x004D, 
	0x043B, 0x004D, 0x0488, 0x004D, 0x04D5, 0x004D, 0x0522, 0x004D, 0x056F, 
	0x0001, 0x05BC, 0x0001, 0x05BD, 0x0001, 0x05BE, 0x004D, 0x05BF, 0x004D, 
	0x060C, 0x004D, 0x0659, 0x004D, 0x06A6, 0x004D, 0x06F3, 0x004D, 0x0740, 
	0x004D, 0x078D, 0x004D, 0x07DA, 0x004D, 0x0827, 0x004D, 0x0874, 0x004B, 
	0x08C1, 0x0001, 0x090C, 0x004D, 0x090D, 0x004D, 0x095A, 0x004D, 0x09A7, 
	0x004D, 0x09F4, 0x004A, 0x0A41, 0x004D, 0x0A8B, 0x004D, 0x0AD8, 0x004D, 
	0x0B25, 0x004B, 0x0B72, 0x0045, 0x0BBD, 0x004C, 0x0C02, 0x0001, 0x0C4E, 
	0x004D, 0x0C4F, 0x004D, 0x0C9C, 0x004C, 0x0CE9, 0x0048, 0x0D35, 0x0001, 
	0x0D7D, 0x004D, 0x0D7E, 0x004D, 0x0DCB, 0x004D, 0x0E18, 0x004D, 0x0E65, 
	

});

smlua_anim_util_register_animation('donkey_65_ground_throw',1, 0, 0, 0, 20, { 
	0x0009, 0x0008, 0x0006, 0x0004, 0x0002, 0x0003, 0x000B, 0x0017, 0x001B, 
	0x0016, 0x000D, 0x0002, 0xFFF9, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFD, 0xFFFE, 
	0xFFFF, 0x0000, 0x009B, 0x009B, 0x009E, 0x00A2, 0x00A8, 0x00AF, 0x00B5, 
	0x00B9, 0x00BB, 0x00BC, 0x00BC, 0x00BA, 0x00B8, 0x00B4, 0x00B0, 0x00AB, 
	0x00A5, 0x009E, 0x0096, 0x008D, 0x008B, 0xFFA5, 0xFFA8, 0xFFAF, 0xFFB9, 
	0xFFC4, 0xFFCC, 0xFFD0, 0xFFD2, 0xFFD6, 0xFFDB, 0xFFE1, 0xFFE8, 0xFFEE, 
	0xFFF3, 0xFFF7, 0xFFFB, 0xFFFD, 0xFFFE, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0xBACD, 0xBC0C, 0xBF69, 0xC454, 0xCA3E, 0xD096, 0xD6CD, 0xDC53, 
	0xE099, 0xE41F, 0xE7BB, 0xEB58, 0xEEE4, 0xF26E, 0xF5DB, 0xF901, 0xFBBB, 
	0xFDDE, 0xFF44, 0xFFC5, 0xFFFF, 0xFF08, 0xFF41, 0xFFD6, 0x00AA, 0x019E, 
	0x0294, 0x036C, 0x040A, 0x044D, 0x0442, 0x040D, 0x03B6, 0x0346, 0x02B3, 
	0x0208, 0x0156, 0x00AD, 0x0020, 0xFFBE, 0xFF99, 0xFFFE, 0x3511, 0x366C, 
	0x3A03, 0x3F1D, 0x4502, 0x4AF9, 0x504A, 0x543E, 0x561A, 0x562B, 0x5551, 
	0x53B9, 0x5190, 0x51DA, 0x529A, 0x53A0, 0x54BD, 0x55C4, 0x5683, 0x56CE, 
	0x5675, 0xE2F8, 0xE747, 0xF234, 0x00BE, 0x0FE7, 0x1CAD, 0x28CD, 0x33DC, 
	0x37A7, 0x34F3, 0x30E0, 0x2BBB, 0x25D3, 0x1F0A, 0x17BF, 0x1083, 0x09E7, 
	0x047B, 0x00D0, 0xFF76, 0x0000, 0x0EBF, 0x0C37, 0x05E7, 0xFDBA, 0xF59B, 
	0xEF74, 0xEBEC, 0xEA50, 0xEA89, 0xEBE2, 0xEDA8, 0xEFC0, 0xF210, 0xF48F, 
	0xF71C, 0xF98F, 0xFBBE, 0xFD80, 0xFEAC, 0xFF1A, 0x0000, 0xF69A, 0xF73D, 
	0xF8F2, 0xFB67, 0xFE4D, 0x0152, 0x05F0, 0x0B7A, 0x0E6D, 0x0EB7, 0x0EA8, 
	0x0E50, 0x0DBF, 0x0C6C, 0x0A6F, 0x0819, 0x05BB, 0x03A6, 0x022B, 0x019B, 
	0x039F, 0x387E, 0x35AD, 0x2E30, 0x2378, 0x16F5, 0x0A18, 0xFE51, 0xF510, 
	0xEFC7, 0xEDB9, 0xED0E, 0xED8B, 0xEEF6, 0xF15D, 0xF475, 0xF7DC, 0xFB2E, 
	0xFE09, 0x0009, 0x00C9, 0x0000, 0xEEEE, 0xEEF9, 0xEF1B, 0xEF56, 0xEFAA, 
	0xF019, 0xF0A5, 0xF150, 0xF21A, 0xF317, 0xF451, 0xF5B6, 0xF739, 0xF8C8, 
	0xFA50, 0xFBBD, 0xFCFB, 0xFDF7, 0xFE9C, 0xFED8, 0x0000, 0xF6C1, 0xF5D0, 
	0xF358, 0xEFDC, 0xEBE5, 0xE7F6, 0xE496, 0xE24A, 0xE198, 0xE25C, 0xE3F8, 
	0xE641, 0xE90A, 0xEB8E, 0xEDA0, 0xEF45, 0xF083, 0xF160, 0xF1E0, 0xF20A, 
	0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xD687, 0xD8D0, 0xDE94, 0xE637, 0xEE19, 
	0xF49C, 0xF821, 0xF70A, 0xEFB9, 0xE1B1, 0xCE5E, 0xB6FD, 0x1CCE, 0x0B97, 
	0x0282, 0xFC96, 0xF4DA, 0xE654, 0xCC0C, 0x2107, 0x1DCC, 0xC9F5, 0xCAAD, 
	0xCC96, 0xCF4F, 0xD276, 0xD5AC, 0xD88F, 0xDABF, 0xDBDC, 0xDC0E, 0xDBCF, 
	0xDB34, 0xA5AD, 0xA5A2, 0xA583, 0xA55A, 0xA52C, 0xA503, 0xA4E5, 0xDB26, 
	0xD901, 0xF7B1, 0xF6AE, 0xF442, 0xF15C, 0xEEE9, 0xEDD8, 0xEF16, 0xF393, 
	0xFC3A, 0x09C7, 0x1B9D, 0x30B4, 0xC7FF, 0xDF91, 0xF593, 0x0947, 0x19EA, 
	0x26BB, 0x2EF9, 0xB1E2, 0xB867, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFCE2, 
	0xF51B, 0xEB02, 0xE0ED, 0xD931, 0xD61B, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFA39, 0xED87, 0xE0D4, 0xDB0E, 0xDCBC, 0xE87A, 0xFFFF, 
	0xC97E, 0xCAB1, 0xCDDB, 0xD255, 0xD777, 0xDC9B, 0xE118, 0xE449, 0xE585, 
	0xE505, 0xE390, 0xE156, 0xDE8A, 0xDC3B, 0xDA66, 0xD8AF, 0xD6BB, 0xD479, 
	0xD308, 0xCBE1, 0xC9F4, 0xD384, 0xD379, 0xD369, 0xD36E, 0xD3A1, 0xD41B, 
	0xD4F6, 0xD64A, 0xD831, 0xDAD8, 0xDE3B, 0xE22A, 0xE678, 0xEE0F, 0xF84D, 
	0x0367, 0x0D8F, 0x14F8, 0x17D7, 0xFDE0, 0x071C, 0xF61D, 0xF55F, 0xF36C, 
	0xF0AB, 0xED87, 0xEA67, 0xE7B7, 0xE5DE, 0xE546, 0xE5D0, 0xE701, 0xE8B7, 
	0xEACF, 0xEE6B, 0xF353, 0xF8DA, 0xFE54, 0x0314, 0x066C, 0x07B0, 0x0306, 
	0xEEA1, 0xEEA6, 0xEEB3, 0xEEC4, 0xEED8, 0xEEE9, 0xEEF5, 0xEEF9, 0xEEF2, 
	0xEEDF, 0xEEC4, 0xEEA2, 0xEE7C, 0xF03F, 0xF4C9, 0xFAFF, 0x01C4, 0x07F9, 
	0x0C84, 0x0E47, 0x0A90, 0xFFFE, 0x0001, 0xC170, 0x61AB, 0x6296, 0x6511, 
	0x68B0, 0x6D0B, 0x71B6, 0x772B, 0xFE44, 0x0729, 0x11E9, 0x1E2C, 0x2B79, 
	0x395B, 0x395B, 0x3959, 0x3954, 0x394B, 0x393C, 0x3926, 0x3907, 0x36DA, 
	0x3273, 0x307E, 0x2B85, 0x24E4, 0x1DF6, 0x1816, 0x124F, 0x730B, 0x74AE, 
	0x72EF, 0x7072, 0x6D61, 0x69E9, 0x659B, 0x60B1, 0x5BA1, 0x56E2, 0x52EB, 
	0x5033, 0x4F31, 0x54F5, 0xD847, 0xDD3A, 0xEA01, 0xFB7E, 0x0E94, 0x2024, 
	0x32A5, 0xC6B1, 0xD65F, 0xE262, 0xEF28, 0xFC57, 0x099A, 0x0E48, 0x11A3, 
	0x13E2, 0x153F, 0x15F3, 0x1635, 0x163E, 0x175C, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xD4E6, 
	0xD7AD, 0xDE88, 0xE740, 0xEF9D, 0xF568, 0xF725, 0xF5D9, 0xF30C, 0xEFA6, 
	0xEBA2, 0xE72D, 0xE274, 0xDF64, 0xDDD9, 0xDD00, 0xDC08, 0xDA1D, 0xD66D, 
	0xD027, 0xCB60, 0x50DE, 0x5460, 0x5C83, 0x65B0, 0x6C53, 0x6CD5, 0x5DBF, 
	0x4447, 0x32DB, 0x2BC2, 0x2503, 0x1EAA, 0x18C5, 0x1509, 0x1337, 0x125D, 
	0x118A, 0x0FCA, 0x0C2B, 0x05BC, 0xFA42, 0x189A, 0x1691, 0x1194, 0x0B50, 
	0x0572, 0x01A7, 0x0218, 0x0532, 0x0707, 0x06CC, 0x065B, 0x05BE, 0x0502, 
	0x048B, 0x0455, 0x0447, 0x0446, 0x0437, 0x0402, 0x038B, 0x0197, 0x11C8, 
	0x147B, 0x1ABF, 0x21D6, 0x2702, 0x2786, 0x1BC2, 0x0820, 0xFBF2, 0xF900, 
	0xF6CD, 0xF541, 0xF444, 0xF4E8, 0xF690, 0xF8D3, 0xFB4A, 0xFD8E, 0xFF35, 
	0xFFDA, 0x0624, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0x0FC6, 0x0E7E, 0x0B1C, 0x0653, 0x00D5, 0xFB52, 0xF67D, 0xF199, 0xEDB0, 
	0xEB4C, 0xE8C3, 0xE627, 0xE388, 0xE52A, 0xE95F, 0xEF20, 0xF565, 0xFB26, 
	0xFF5B, 0x00FD, 0xFE9B, 0xE4BF, 0xE500, 0xE5AA, 0xE69B, 0xE7AE, 0xE8C0, 
	0xE9AD, 0xEA98, 0xEB33, 0xEB60, 0xEB89, 0xEBAD, 0xEBCD, 0xEC06, 0xEC56, 
	0xECB0, 0xED0B, 0xED5A, 0xED92, 0xEDA7, 0xEFF9, 0x6D6E, 0x6F06, 0x733B, 
	0x7930, 0x800A, 0x86E9, 0x8CF5, 0x932B, 0x9828, 0x9B2D, 0x9E5F, 0xA1A9, 
	0xA4F5, 0xA4DB, 0xA41F, 0xA220, 0x9E3F, 0x97D9, 0x8E4D, 0x80FA, 0x839E, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x49E2, 0x47D7, 0x426D, 
	0x3AB8, 0x31C9, 0x28B5, 0x208E, 0x15F7, 0x0F36, 0x0FED, 0x114E, 0x1336, 
	0x1582, 0x1AED, 0x2331, 0x2CFF, 0x370C, 0x400C, 0x46B1, 0x49AF, 0x49EE, 
	0xFEFF, 0xFEFC, 0xFEF4, 0xFEE9, 0xFEDB, 0xFECD, 0xFEC0, 0xFED7, 0xFE9E, 
	0xFDAF, 0xFC7C, 0xFB6A, 0xFA61, 0xF9F6, 0xF9C6, 0xF9BA, 0xF9B9, 0xF9AC, 
	0xF97C, 0xF912, 0xF7AE, 0x0149, 0x013C, 0x011C, 0x00F1, 0x00C4, 0x009E, 
	0x0086, 0x00A4, 0x00DD, 0x0110, 0x0143, 0x0153, 0x0125, 0x01D1, 0x038B, 
	0x05E8, 0x087B, 0x0AD8, 0x0C92, 0x0D3D, 0x03C6, 0xDE32, 0xDC45, 0xD760, 
	0xD0D9, 0xCA06, 0xC43D, 0xC0D3, 0xC752, 0xCFF0, 0xD087, 0xCEDB, 0xCD23, 
	0xCC33, 0xCB9C, 0xCAC1, 0xC8FC, 0xC5A6, 0xC01A, 0xB7B0, 0xABC3, 0xAB92, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x08F4, 0x08B9, 
	0x081D, 0x0743, 0x064C, 0x055A, 0x048E, 0x040A, 0x03EE, 0x0425, 0x0483, 
	0x050E, 0x05CD, 0x05AD, 0x0554, 0x04D2, 0x0432, 0x0381, 0x02CE, 0x0226, 
	0x01C0, 0x1FE3, 0x1EF1, 0x1C71, 0x18E2, 0x14C3, 0x1093, 0x0CD1, 0x09FD, 
	0x0896, 0x08BE, 0x0A0D, 0x0C2D, 0x0EC9, 0x0FCB, 0x1081, 0x10F8, 0x1140, 
	0x1166, 0x1179, 0x1187, 0x1192, 0x9F77, 0xA0FC, 0xA4FF, 0xAAA7, 0xB11F, 
	0xB78E, 0xBD1E, 0xC0F9, 0xC248, 0xC0A0, 0xBCA1, 0xB702, 0xB079, 0xAC1E, 
	0xA98A, 0xA73B, 0xA3B0, 0x9D66, 0x92DC, 0x8290, 0x842B, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x45CF, 0x45CC, 0x45C5, 
	0x45BD, 0x45B6, 0x45B1, 0x45B3, 0x45BC, 0x45CF, 0x464F, 0x4766, 0x48BB, 
	0x49FB, 0x49EC, 0x49C6, 0x4992, 0x4959, 0x4925, 0x48FF, 0x48F0, 0x4A21, 
	0x06C6, 0x061E, 0x0462, 0x01E7, 0xFF02, 0xFC0A, 0xF954, 0xF738, 0xF609, 
	0xF5CA, 0xF627, 0xF6FD, 0xF825, 0xFA25, 0xFCD9, 0xFFE2, 0x02E3, 0x057C, 
	0x0750, 0x0801, 0x09D3, 0x0437, 0x0464, 0x04DA, 0x057F, 0x0638, 0x06EA, 
	0x077D, 0x07D4, 0x07D7, 0x077D, 0x06DC, 0x0606, 0x050D, 0x0437, 0x0384, 
	0x02DF, 0x0233, 0x016B, 0x0073, 0xFF32, 0xFE32, 0xABDD, 0xACCA, 0xAF45, 
	0xB2DE, 0xB725, 0xBBA8, 0xBFF8, 0xC3A3, 0xC63A, 0xC7D3, 0xC8E3, 0xC987, 
	0xC9DC, 0xC9C8, 0xC93B, 0xC7BB, 0xC4CF, 0xBFFF, 0xB8D0, 0xAECA, 0xABC3, 
	

},{ 
	0x0014, 0x0000, 0x0015, 0x0014, 0x0014, 0x0029, 0x0001, 0x003D, 0x0001, 
	0x003E, 0x0001, 0x003F, 0x0015, 0x0040, 0x0015, 0x0055, 0x0015, 0x006A, 
	0x0015, 0x007F, 0x0015, 0x0094, 0x0015, 0x00A9, 0x0015, 0x00BE, 0x0015, 
	0x00D3, 0x0015, 0x00E8, 0x0001, 0x00FD, 0x0001, 0x00FE, 0x0001, 0x00FF, 
	0x0015, 0x0100, 0x0015, 0x0115, 0x0015, 0x012A, 0x0015, 0x013F, 0x0014, 
	0x0154, 0x0015, 0x0168, 0x0015, 0x017D, 0x0015, 0x0192, 0x0015, 0x01A7, 
	0x0001, 0x01BC, 0x0001, 0x01BD, 0x0001, 0x01BE, 0x0015, 0x01BF, 0x0015, 
	0x01D4, 0x0015, 0x01E9, 0x0015, 0x01FE, 0x0011, 0x0213, 0x0015, 0x0224, 
	0x0015, 0x0239, 0x0015, 0x024E, 0x0015, 0x0263, 0x0015, 0x0278, 0x0015, 
	0x028D, 0x0001, 0x02A2, 0x0015, 0x02A3, 0x0015, 0x02B8, 0x0015, 0x02CD, 
	0x0015, 0x02E2, 0x0015, 0x02F7, 0x0015, 0x030C, 0x0015, 0x0321, 0x0015, 
	0x0336, 0x0015, 0x034B, 0x0015, 0x0360, 0x0015, 0x0375, 0x0001, 0x038A, 
	0x0015, 0x038B, 0x0015, 0x03A0, 0x0015, 0x03B5, 0x0014, 0x03CA, 0x000F, 
	0x03DE, 0x0015, 0x03ED, 0x0015, 0x0402, 0x0015, 0x0417, 0x0015, 0x042C, 
	

});

smlua_anim_util_register_animation('donkey_6E_place_light_obj',1, 0, 0, 0, 15, { 
	0x0000, 0x00A3, 0x00A3, 0x00A2, 0x00A1, 0x00A0, 0x009E, 0x009C, 0x009A, 
	0x0099, 0x0097, 0x0095, 0x0094, 0x0092, 0x0090, 0x008D, 0x008B, 0x0004, 
	0x0004, 0x0002, 0xFFFF, 0xFFFC, 0xFFF8, 0xFFF6, 0xFFF4, 0xFFF3, 0xFFF4, 
	0xFFF6, 0xFFF9, 0xFFFC, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFE, 0x3979, 0x39EF, 0x3A75, 0x3B08, 0x3BA4, 0x3C45, 0x3CE8, 0x3D8A, 
	0x3E26, 0x40FB, 0x45C6, 0x4B6B, 0x50D1, 0x54DD, 0x5675, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xF526, 0xF9F9, 0x0051, 0x0781, 0x0ED8, 0x15A7, 0x1B40, 0x1CF9, 
	0x1B40, 0x1757, 0x124C, 0x0CF2, 0x081B, 0x0499, 0x033F, 0x039F, 0xFFFF, 
	0x0002, 0x0009, 0x0013, 0x0020, 0x0030, 0x0040, 0x0052, 0x0063, 0x0074, 
	0x0083, 0x0090, 0x009A, 0x00A1, 0x00A3, 0x0000, 0xFFFF, 0x0002, 0x0009, 
	0x0012, 0x001F, 0x002D, 0x003D, 0x004D, 0x005E, 0x006D, 0x007C, 0x0088, 
	0x0092, 0x0098, 0x009A, 0x0000, 0x109A, 0x102A, 0x0F4F, 0x0E1B, 0x0C9C, 
	0x0AE4, 0x0902, 0x0655, 0x02D4, 0xFF01, 0xFB24, 0xF76F, 0xF412, 0xF13E, 
	0xEF25, 0xEE2F, 0xFFFE, 0x0001, 0xCACF, 0xCA47, 0xC8E6, 0xC700, 0xC4E8, 
	0xC2F2, 0xC170, 0xC125, 0xC170, 0x1219, 0x11CC, 0x1167, 0x10F4, 0x107F, 
	0x1012, 0x0FB9, 0x1038, 0x0FB9, 0x1436, 0x1C8B, 0x2107, 0x1DCC, 0xF941, 
	0xF8AC, 0xF7E7, 0xF707, 0xF623, 0xF54F, 0xF4A1, 0xF56C, 0xF4A1, 0xF34A, 
	0xECE1, 0xDB26, 0xD901, 0x8A05, 0x8B5F, 0x8D27, 0x8F2B, 0x913B, 0x9325, 
	0x94B8, 0x9347, 0x94B8, 0x9E34, 0xAB49, 0xB1E2, 0xB867, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xF8C1, 0xF830, 0xF771, 0xF698, 0xF5BB, 0xF4EE, 0xF445, 
	0xF54C, 0xF445, 0xF315, 0xEFB2, 0xE6AF, 0xD49C, 0xC9F4, 0xE7CD, 0xE7CD, 
	0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE721, 0xE7CD, 0xEB57, 0xF0F8, 
	0xF709, 0xFBE3, 0xFDE0, 0x071C, 0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 
	0xF983, 0xF983, 0xF983, 0xF983, 0xFAFC, 0xFE80, 0x02B3, 0x0636, 0x07B0, 
	0x0306, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE94D, 
	0xE96A, 0xED77, 0xF6A2, 0x0177, 0x0A7F, 0x0E47, 0x0A90, 0xFFFE, 0x0001, 
	0xC9FE, 0xC982, 0xC840, 0xC684, 0xC49B, 0xC2D0, 0xC170, 0xC12B, 0xC170, 
	0xF2FD, 0xF378, 0xF41A, 0xF4D2, 0xF58E, 0xF63C, 0xF6CB, 0xF683, 0xF6CB, 
	0xF481, 0xE47E, 0x3907, 0x36DA, 0x0D07, 0x0D64, 0x0DDE, 0x0E69, 0x0EF7, 
	0x0F7A, 0x0FE6, 0x0F36, 0x0FE6, 0x1959, 0x28BC, 0x4F31, 0x54F5, 0x8F02, 
	0x9062, 0x9231, 0x943F, 0x9658, 0x984B, 0x99E4, 0x98D0, 0x99E4, 0x99C2, 
	0x98CF, 0x163E, 0x175C, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xF032, 0xEEB5, 0xECBD, 
	0xEA83, 0xE83B, 0xE61E, 0xE462, 0xE4CE, 0xE462, 0xE3CB, 0xE1B3, 0xDC16, 
	0xD0F2, 0xCB60, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 
	0x0B1C, 0x0ACF, 0x0A87, 0x0A37, 0x0988, 0x0827, 0x05BC, 0xFA42, 0x020D, 
	0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x021C, 0x020D, 0x0235, 
	0x0293, 0x0304, 0x0363, 0x038B, 0x0197, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 
	0xEDD1, 0xEDD1, 0xEDD1, 0xED9C, 0xEDD1, 0xF017, 0xF49D, 0xF9CD, 0xFE13, 
	0xFFDA, 0x0624, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xD826, 0xD9D0, 0xDBE8, 0xDE39, 0xE091, 
	0xE2BD, 0xE48A, 0xE553, 0xE48A, 0xE6A6, 0xEBEA, 0xF2C3, 0xF99C, 0xFEE1, 
	0x00FD, 0xFE9B, 0xE771, 0xE60A, 0xE4AF, 0xE365, 0xE231, 0xE117, 0xE01B, 
	0xDF8A, 0xE01B, 0xE1F4, 0xE4B2, 0xE7CA, 0xEAAE, 0xECD2, 0xEDA7, 0xEFF9, 
	0xBA93, 0xB706, 0xB28D, 0xAD96, 0xA890, 0xA3E7, 0xA00B, 0x9E9E, 0xA00B, 
	0x9FE7, 0x9EE5, 0x9C29, 0x96D7, 0x8E11, 0x80FA, 0x839E, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x378C, 0x3AA9, 0x3D22, 0x3F20, 0x40CA, 0x424A, 
	0x43C5, 0x4500, 0x43C5, 0x41F6, 0x4063, 0x3F46, 0x3ED9, 0x4415, 0x49AF, 
	0x49EE, 0xFED3, 0xFF74, 0x0051, 0x0150, 0x0256, 0x0349, 0x040F, 0x0456, 
	0x040F, 0x0192, 0xFCEB, 0xF7D1, 0xF3FB, 0xF272, 0xF239, 0xF7AE, 0xFFA1, 
	0xFFAF, 0xFFCA, 0xFFEC, 0x0012, 0x0035, 0x0051, 0x0058, 0x0051, 0x00FD, 
	0x0277, 0x03F1, 0x049D, 0x01AC, 0xFEBA, 0x03C6, 0xB309, 0xB28C, 0xB2F2, 
	0xB3EA, 0xB525, 0xB650, 0xB71D, 0xB704, 0xB71D, 0xB50D, 0xB083, 0xABF9, 
	0xA9E8, 0xABE1, 0xADDA, 0xAB92, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x17C1, 0x164C, 
	0x149B, 0x12CF, 0x1107, 0x0F61, 0x0DFE, 0x0D53, 0x0DFE, 0x0D3F, 0x0B56, 
	0x08C5, 0x060D, 0x03AD, 0x0226, 0x01C0, 0x15CC, 0x15F9, 0x15B9, 0x1533, 
	0x148E, 0x13F2, 0x1384, 0x1382, 0x1384, 0x135E, 0x1300, 0x1285, 0x120B, 
	0x11AC, 0x1187, 0x1192, 0xAE8D, 0xAAF2, 0xA6B8, 0xA231, 0x9DAF, 0x9985, 
	0x9603, 0x94A1, 0x9603, 0x95EC, 0x954B, 0x9395, 0x9040, 0x8AC2, 0x8290, 
	0x842B, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x3311, 0x35D0, 0x383D, 0x3A64, 0x3C52, 0x3E12, 0x3FB2, 0x4105, 
	0x3FB2, 0x401F, 0x4144, 0x42EC, 0x44E3, 0x46F6, 0x48F0, 0x4A21, 0x008C, 
	0xFFF2, 0xFF24, 0xFE38, 0xFD46, 0xFC66, 0xFBAE, 0xFB69, 0xFBAE, 0xFE45, 
	0x02EC, 0x075E, 0x095A, 0x091E, 0x0779, 0x09D3, 0x016D, 0x0124, 0x00BE, 
	0x0047, 0xFFCC, 0xFF59, 0xFEFC, 0xFEE7, 0xFEFC, 0xFF1C, 0xFF38, 0xFF4D, 
	0xFF55, 0xFEBE, 0xFAA0, 0xFE32, 0xBB93, 0xBB5D, 0xBBAB, 0xBC4D, 0xBD14, 
	0xBDD1, 0xBE55, 0xBE19, 0xBE55, 0xBB7E, 0xB540, 0xAF01, 0xAC2A, 0xACD6, 
	0xAD81, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0010, 0x0001, 0x000F, 0x0011, 0x0001, 0x0020, 0x0001, 
	0x0021, 0x0001, 0x0022, 0x0005, 0x0023, 0x000F, 0x0028, 0x000F, 0x0037, 
	0x0010, 0x0046, 0x000E, 0x0056, 0x0010, 0x0064, 0x0010, 0x0074, 0x0010, 
	0x0084, 0x0010, 0x0094, 0x0001, 0x00A4, 0x0001, 0x00A5, 0x0009, 0x00A6, 
	0x000D, 0x00AF, 0x000D, 0x00BC, 0x000D, 0x00C9, 0x000F, 0x00D6, 0x0010, 
	0x00E5, 0x000E, 0x00F5, 0x000F, 0x0103, 0x000F, 0x0112, 0x000F, 0x0121, 
	0x0001, 0x0130, 0x0001, 0x0131, 0x0009, 0x0132, 0x000D, 0x013B, 0x000D, 
	0x0148, 0x000D, 0x0155, 0x000E, 0x0162, 0x0010, 0x0170, 0x000E, 0x0180, 
	0x000F, 0x018E, 0x000F, 0x019D, 0x000F, 0x01AC, 0x000F, 0x01BB, 0x000D, 
	0x01CA, 0x0001, 0x01D7, 0x0010, 0x01D8, 0x0010, 0x01E8, 0x0010, 0x01F8, 
	0x0010, 0x0208, 0x0010, 0x0218, 0x0010, 0x0228, 0x0010, 0x0238, 0x0010, 
	0x0248, 0x0010, 0x0258, 0x000B, 0x0268, 0x0009, 0x0273, 0x0001, 0x027C, 
	0x0010, 0x027D, 0x0010, 0x028D, 0x0010, 0x029D, 0x000D, 0x02AD, 0x0005, 
	0x02BA, 0x0010, 0x02BF, 0x0010, 0x02CF, 0x0010, 0x02DF, 0x0010, 0x02EF, 
	

});

smlua_anim_util_register_animation('donkey_74_soft_back_kb',1, 0, 0, 0, 23, { 
	0x0000, 0x00AA, 0x00AA, 0x00AA, 0x00AB, 0x00AB, 0x00AC, 0x00AC, 0x00AC, 
	0x00AC, 0x00AA, 0x00A7, 0x00A3, 0x00A3, 0x00A1, 0x009F, 0x009B, 0x0097, 
	0x0091, 0x0091, 0x0090, 0x0090, 0x008E, 0x008D, 0x008B, 0x0000, 0x0000, 
	0x3FFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
	0x387B, 0x388F, 0x38C7, 0x391E, 0x398F, 0x3A14, 0x3AA8, 0x3B46, 0x3BE8, 
	0x3C88, 0x3D23, 0x3DB2, 0x3E30, 0x3E98, 0x3FD8, 0x41FE, 0x44CD, 0x4807, 
	0x4B6C, 0x4EBF, 0x51C1, 0x5434, 0x55DA, 0x5675, 0x025A, 0x027E, 0x020F, 
	0xFFB7, 0xFDC4, 0xFE0D, 0xFF22, 0x004C, 0x0181, 0x02CC, 0x038B, 0x035B, 
	0x02A0, 0x01EE, 0x015F, 0x00ED, 0x0094, 0x0051, 0x0021, 0x0000, 0xFFEC, 
	0xFFE3, 0xFFE1, 0x0000, 0xF845, 0xFA4C, 0xFE0A, 0x029A, 0x05F9, 0x0639, 
	0x052D, 0x0349, 0xFFEF, 0xFBBC, 0xF8F8, 0xF8EB, 0xFA4D, 0xFB87, 0xFC6E, 
	0xFD3A, 0xFDEC, 0xFE82, 0xFEFD, 0xFF5E, 0xFFA2, 0xFFCC, 0xFFD9, 0x0000, 
	0x14E9, 0x0EEF, 0x06AC, 0x0382, 0x029C, 0x0310, 0x0467, 0x0676, 0x09B2, 
	0x0DA7, 0x10D7, 0x1287, 0x1371, 0x1443, 0x13CC, 0x128B, 0x10B0, 0x0E70, 
	0x0BFC, 0x0987, 0x0743, 0x0564, 0x041B, 0x039F, 0x0000, 0x0006, 0x000D, 
	0x0005, 0xFFFA, 0x0000, 0x00D3, 0x0074, 0xFC51, 0xF70C, 0xF469, 0xF6FB, 
	0xFC2E, 0x0005, 0x0007, 0x000C, 0x0013, 0x001B, 0x0024, 0x002C, 0x0033, 
	0x0038, 0x003A, 0x0000, 0x0000, 0x006F, 0x0151, 0x026D, 0x03A5, 0x047B, 
	0x0493, 0x03C1, 0x0202, 0xFFD4, 0xFDCA, 0xFBCE, 0xF9F6, 0xF912, 0xF94C, 
	0xF9E6, 0xFAC6, 0xFBCF, 0xFCE6, 0xFDF0, 0xFECF, 0xFF6A, 0xFFA4, 0x0000, 
	0x10C0, 0x1193, 0x1064, 0x0A47, 0x0276, 0xFCB2, 0xFD2D, 0xFEF5, 0xFCDC, 
	0xF9DE, 0xF84C, 0xF9F7, 0xFD0F, 0xFE6A, 0xFE64, 0xFE3D, 0xFDD1, 0xFCFF, 
	0xFBA6, 0xF9A2, 0xF6D2, 0xF315, 0xEE47, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 
	0xB881, 0xC76D, 0xE76A, 0x054F, 0x0DE9, 0xFDE4, 0xE227, 0xBFCC, 0x1BF3, 
	0xFBB9, 0xE43E, 0xDF80, 0xE942, 0xF14A, 0xF2FD, 0xF490, 0xF5FF, 0xF747, 
	0xF866, 0xF957, 0xFA19, 0xFAA7, 0xFAFE, 0x1DCC, 0xA508, 0xA714, 0xABC4, 
	0xB0EE, 0xB467, 0xB65F, 0xB83F, 0xB9B1, 0xC5A0, 0xC60D, 0xC7EA, 0xD02B, 
	0xDCD5, 0xE3D9, 0xE40E, 0xE329, 0xE16A, 0xDF14, 0xDC67, 0xD9A5, 0xD70E, 
	0xD4E4, 0xD368, 0xD901, 0x0E88, 0x01D9, 0xE6B8, 0xCD93, 0xC6CC, 0xD547, 
	0xEDFB, 0x0C6F, 0xAC1C, 0xC88D, 0xDD42, 0xE106, 0xD7D1, 0xD0EA, 0xD07D, 
	0xD077, 0xD0C4, 0xD14C, 0xD1FC, 0xD2BC, 0xD377, 0xD418, 0xD488, 0xB867, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xF516, 0xF260, 0xEC67, 0xE664, 0xE391, 0xE470, 0xE6EB, 
	0xEA57, 0xEE08, 0xF153, 0xF38D, 0xF434, 0xF343, 0xF0D0, 0xED2B, 0xE8C0, 
	0xE3D5, 0xDEB1, 0xD998, 0xD4D1, 0xD0A0, 0xCD4C, 0xCB19, 0xC9F4, 0xE6BD, 
	0xE706, 0xE7D2, 0xE90A, 0xEA99, 0xEC7D, 0xEEAA, 0xF102, 0xF362, 0xF5AB, 
	0xF7BB, 0xF97C, 0xFADE, 0xFBC6, 0xFC69, 0xFD07, 0xFD9F, 0xFE2D, 0xFEAF, 
	0xFF1F, 0xFF7D, 0xFFC3, 0xFFF0, 0x071C, 0xF97B, 0xF91C, 0xF83F, 0xF745, 
	0xF68F, 0xF61E, 0xF5BB, 0xF566, 0xF525, 0xF4F9, 0xF4E5, 0xF52F, 0xF5CE, 
	0xF658, 0xF6B8, 0xF71F, 0xF78A, 0xF7F5, 0xF85A, 0xF8B7, 0xF906, 0xF944, 
	0xF96C, 0x0306, 0xED8B, 0xED09, 0xEBC7, 0xEA27, 0xE88C, 0xE6E6, 0xE502, 
	0xE312, 0xE147, 0xDFD1, 0xDEE3, 0xDF78, 0xE165, 0xE322, 0xE456, 0xE5A8, 
	0xE709, 0xE86B, 0xE9BF, 0xEAF5, 0xEC01, 0xECD2, 0xED5A, 0x0A90, 0x0001, 
	0xFFFE, 0xC170, 0x266D, 0x22F9, 0x19C4, 0x0C89, 0xFD01, 0xE617, 0x4A12, 
	0x35B9, 0x2C86, 0x2B01, 0x3387, 0x4A70, 0xEAD2, 0x0932, 0x1A12, 0x1E54, 
	0x1F0F, 0x1D12, 0x192C, 0x142C, 0x0EE0, 0x0A17, 0x06A1, 0x36DA, 0x2576, 
	0x25A8, 0x264E, 0x277D, 0x294C, 0x2CE7, 0x4E6F, 0x4B79, 0x4C1B, 0x4E72, 
	0x4F9C, 0x4E43, 0x342B, 0x366A, 0x3736, 0x368B, 0x355A, 0x33CC, 0x3209, 
	0x303C, 0x2E8D, 0x2D27, 0x2C31, 0x54F5, 0xF541, 0xF65E, 0xF73F, 0xF42E, 
	0xE978, 0xCDCD, 0x26BF, 0x06E8, 0xF1D1, 0xE3F8, 0xE559, 0xFC6A, 0xA0CE, 
	0xC442, 0xD88E, 0xDE74, 0xE0BB, 0xE02C, 0xDD8E, 0xD9AA, 0xD547, 0xD12D, 
	0xCE24, 0x175C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xD13B, 0xD6FC, 0xE3CF, 0xF10F, 0xF817, 0xF7F0, 
	0xF4D8, 0xEFF9, 0xEA7B, 0xE588, 0xE249, 0xE1CE, 0xE328, 0xE480, 0xE400, 
	0xE16E, 0xDDFE, 0xD9FF, 0xD5C2, 0xD197, 0xCDCD, 0xCAB6, 0xC8A0, 0xCB60, 
	0x1619, 0x15EE, 0x156F, 0x14A4, 0x1393, 0x1243, 0x10C1, 0x0F1F, 0x0D6F, 
	0x0BC3, 0x0A2C, 0x088B, 0x06DF, 0x0563, 0x0451, 0x038D, 0x02D3, 0x0227, 
	0x018D, 0x0107, 0x0099, 0x0046, 0x0012, 0xFA42, 0x1127, 0x1105, 0x10A3, 
	0x1005, 0x0F31, 0x0E2C, 0x0D01, 0x0BBD, 0x0A6D, 0x0921, 0x07E5, 0x06A2, 
	0x0555, 0x042E, 0x035A, 0x02C1, 0x0231, 0x01AC, 0x0134, 0x00CC, 0x0076, 
	0x0036, 0x000E, 0x0197, 0xE8AD, 0xE8C6, 0xE90E, 0xE982, 0xEA1E, 0xEADE, 
	0xEBBA, 0xECA8, 0xED9E, 0xEE93, 0xEF7B, 0xF068, 0xF15D, 0xF236, 0xF2D2, 
	0xF341, 0xF3AB, 0xF40D, 0xF466, 0xF4B2, 0xF4F1, 0xF520, 0xF53E, 0x0624, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0xEC16, 0xED77, 0xF0D8, 0xF513, 0xF904, 0xFE89, 0x0092, 0xF5A3, 0xEAC7, 
	0xE896, 0xE837, 0xE8BB, 0xE92F, 0xE8A2, 0xE969, 0xEB7D, 0xEE7F, 0xF211, 
	0xF5D2, 0xF963, 0xFC66, 0xFE7A, 0xFF41, 0xFE9B, 0xF7DA, 0xF7C0, 0xF78C, 
	0xF76B, 0xF785, 0xF8C5, 0xF981, 0xF75F, 0xF47F, 0xF208, 0xEF5E, 0xECDE, 
	0xEAE2, 0xE9C6, 0xE9EB, 0xEA4E, 0xEADD, 0xEB86, 0xEC39, 0xECE2, 0xED71, 
	0xEDD4, 0xEDF9, 0xEFF9, 0xB0EB, 0xAFA5, 0xACA0, 0xA90B, 0xA617, 0xA300, 
	0xA37A, 0xAF4F, 0xB9B7, 0xBA40, 0xB88B, 0xB5C8, 0xB326, 0xB1D3, 0xB112, 
	0xB043, 0xAEF5, 0xACB5, 0xA913, 0xA39E, 0x9BE2, 0x9170, 0x83D6, 0x839E, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x2537, 0x2427, 
	0x2225, 0x20F5, 0x225E, 0x2E45, 0x38FC, 0x303A, 0x2607, 0x254F, 0x2672, 
	0x2875, 0x2A5C, 0x2B2D, 0x2CD1, 0x2F9B, 0x333B, 0x3762, 0x3BC1, 0x4007, 
	0x43E4, 0x470A, 0x4928, 0x49EE, 0x048E, 0x0452, 0x03B2, 0x02CF, 0x01C7, 
	0x0005, 0xFE2A, 0xFD56, 0xFCBE, 0xFBCA, 0xFAA8, 0xF998, 0xF8DC, 0xF8B4, 
	0xF743, 0xF482, 0xF160, 0xEECE, 0xEDBE, 0xEECA, 0xF11A, 0xF36A, 0xF477, 
	0xF7AE, 0x009A, 0x009A, 0x0097, 0x008E, 0x007A, 0x0041, 0x0000, 0xFFC9, 
	0xFFD6, 0x005A, 0x010D, 0x01C4, 0x0253, 0x028F, 0x0222, 0x0120, 0xFFEA, 
	0xFEE7, 0xFE7B, 0xFE7F, 0xFE9E, 0xFEF3, 0xFF99, 0x03C6, 0xC1BD, 0xC3AC, 
	0xC7E9, 0xCC17, 0xCDDD, 0xC863, 0xC06F, 0xBB9E, 0xB924, 0xB928, 0xB9EF, 
	0xBB16, 0xBC3A, 0xBCF6, 0xBA8F, 0xB4D4, 0xADFD, 0xA842, 0xA5DA, 0xA703, 
	0xA990, 0xAC1D, 0xAD46, 0xAB92, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x0D67, 0x0CE4, 
	0x0C97, 0x0DFF, 0x0F1F, 0x0E90, 0x0D7C, 0x0C67, 0x0BD6, 0x0BD6, 0x0C27, 
	0x0CDD, 0x0E09, 0x100E, 0x100A, 0x0FF0, 0x0FAA, 0x0F20, 0x0E3D, 0x0CEB, 
	0x0B13, 0x089F, 0x0579, 0x01C0, 0x0E7F, 0x0ED1, 0x0E8C, 0x0C34, 0x09CF, 
	0x08BD, 0x07FB, 0x076C, 0x06F5, 0x0651, 0x05A5, 0x056D, 0x0628, 0x0895, 
	0x0ACB, 0x0C5A, 0x0D66, 0x0E14, 0x0E86, 0x0EDF, 0x0F45, 0x0FD9, 0x10C1, 
	0x1192, 0x9B5D, 0x9CB4, 0xA118, 0xABB1, 0xB3CB, 0xB304, 0xAF9B, 0xAB4B, 
	0xA7D2, 0xA536, 0xA2AE, 0xA0C3, 0x9FF9, 0xA0E8, 0xA0DF, 0xA09C, 0x9FE5, 
	0x9E82, 0x9C38, 0x98CF, 0x940C, 0x8DB5, 0x8592, 0x842B, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x1E4A, 0x2BCC, 0x3C1B, 0x3B3B, 0x34B2, 0x2D68, 0x24BC, 0x1D51, 
	0x19CE, 0x1C59, 0x230C, 0x2A7D, 0x2F41, 0x3054, 0x3193, 0x33D7, 0x36DA, 
	0x3A58, 0x3E0A, 0x41AB, 0x44F7, 0x47A7, 0x4977, 0x4A21, 0x0000, 0x0014, 
	0x0037, 0x0086, 0x0078, 0xFF04, 0xFDCB, 0xFEC9, 0xFFED, 0xFFE5, 0xFF97, 
	0xFF29, 0xFEC4, 0xFE57, 0xFEA6, 0xFF78, 0x00A1, 0x01F6, 0x034C, 0x047B, 
	0x056E, 0x060E, 0x0647, 0x09D3, 0xFF2F, 0xFF34, 0xFF3F, 0xFF4C, 0xFF55, 
	0xFF52, 0xFF49, 0xFF41, 0xFF30, 0xFF09, 0xFEDA, 0xFEB0, 0xFE98, 0xFE9B, 
	0xFEBB, 0xFEFC, 0xFF45, 0xFF82, 0xFF9B, 0xFF95, 0xFF6A, 0xFEF6, 0xFE14, 
	0xFE32, 0xC9D7, 0xC5B4, 0xBE68, 0xB5AA, 0xB093, 0xB7DF, 0xC257, 0xCA46, 
	0xCDEA, 0xCA86, 0xC488, 0xBE76, 0xBAD7, 0xBABE, 0xB8D0, 0xB4A1, 0xAFBC, 
	0xABAB, 0xA9F9, 0xAA19, 0xAA60, 0xAAA8, 0xAAC8, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0018, 0x0001, 0x0001, 0x0019, 0x0001, 0x001A, 0x0001, 
	0x001B, 0x0001, 0x001C, 0x0002, 0x001D, 0x0017, 0x001F, 0x0018, 0x0036, 
	0x0018, 0x004E, 0x0018, 0x0066, 0x0018, 0x007E, 0x0018, 0x0096, 0x0018, 
	0x00AE, 0x0018, 0x00C6, 0x0001, 0x00DE, 0x0001, 0x00DF, 0x0001, 0x00E0, 
	0x0018, 0x00E1, 0x0018, 0x00F9, 0x0018, 0x0111, 0x0018, 0x0129, 0x0017, 
	0x0141, 0x0018, 0x0158, 0x0018, 0x0170, 0x0018, 0x0188, 0x0018, 0x01A0, 
	0x0001, 0x01B8, 0x0001, 0x01B9, 0x0001, 0x01BA, 0x0018, 0x01BB, 0x0018, 
	0x01D3, 0x0018, 0x01EB, 0x0018, 0x0203, 0x0016, 0x021B, 0x0018, 0x0231, 
	0x0018, 0x0249, 0x0018, 0x0261, 0x0018, 0x0279, 0x0017, 0x0291, 0x0015, 
	0x02A8, 0x0001, 0x02BD, 0x0018, 0x02BE, 0x0018, 0x02D6, 0x0018, 0x02EE, 
	0x0001, 0x0306, 0x0018, 0x0307, 0x0018, 0x031F, 0x0018, 0x0337, 0x0018, 
	0x034F, 0x0018, 0x0367, 0x0017, 0x037F, 0x0018, 0x0396, 0x0001, 0x03AE, 
	0x0018, 0x03AF, 0x0018, 0x03C7, 0x0018, 0x03DF, 0x0007, 0x03F7, 0x0017, 
	0x03FE, 0x0018, 0x0415, 0x0018, 0x042D, 0x0018, 0x0445, 0x0018, 0x045D, 
	

});

smlua_anim_util_register_animation('donkey_75_soft_front_kb',1, 0, 0, 0, 23, { 
	0x0000, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AF, 0x00AF, 0x00B0, 0x00B0, 
	0x00B1, 0x00B1, 0x00B1, 0x00B1, 0x00B1, 0x00AF, 0x00AB, 0x00A7, 0x00A1, 
	0x00A0, 0x009B, 0x0093, 0x0093, 0x0091, 0x008F, 0x008B, 0x0000, 0x0000, 
	0x3FFF, 0x0000, 0x0000, 0xFFF9, 0xFFEC, 0xFFDE, 0xFFD8, 0xFFD9, 0xFFDE, 
	0xFFE4, 0xFFEC, 0xFFF3, 0xFFFA, 0x0000, 0x0002, 0x0003, 0x0003, 0x0003, 
	0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0xFFFF, 0xFFFF, 
	0x0023, 0x007B, 0x00F1, 0x0169, 0x01F4, 0x02A2, 0x035B, 0x0408, 0x0493, 
	0x04E4, 0x04E3, 0x037F, 0x0109, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFF80, 
	0xFF80, 0xFF80, 0xFF80, 0xFF80, 0xFFFE, 0x40A1, 0x404C, 0x3FB6, 0x3F7D, 
	0x403D, 0x4212, 0x4481, 0x4747, 0x4A20, 0x4CCA, 0x4F02, 0x5085, 0x4FD6, 
	0x4D34, 0x4AED, 0x4AED, 0x4AED, 0x4AED, 0x4AED, 0x4AED, 0x4AED, 0x4AED, 
	0x4AED, 0x5675, 0x09E0, 0x05B7, 0xFCD4, 0xF496, 0xF15D, 0xF3C4, 0xF70A, 
	0xFA6A, 0xFD1C, 0xFF1C, 0x00DF, 0x0259, 0x0380, 0x0448, 0x041F, 0x03A7, 
	0x02F2, 0x0218, 0x0132, 0x0055, 0xFF9A, 0xFF19, 0xFEE8, 0x0000, 0xFB90, 
	0xFC9E, 0xFEE1, 0x0101, 0x01FE, 0x0242, 0x0283, 0x0280, 0x01FC, 0x00B7, 
	0xFEE4, 0xFCF0, 0xFB48, 0xFA58, 0xFAC1, 0xFB89, 0xFC78, 0xFD7C, 0xFE7E, 
	0xFF6B, 0x002E, 0x00B2, 0x00E2, 0x0000, 0x05C3, 0x008A, 0xF5DA, 0xED30, 
	0xF11D, 0xF8CD, 0x017B, 0x0929, 0x0DDA, 0x0F22, 0x0E6A, 0x0C77, 0x0A0D, 
	0x07EF, 0x054D, 0x0572, 0x05D3, 0x065C, 0x06F9, 0x0796, 0x081F, 0x0880, 
	0x08A5, 0x039F, 0xF71B, 0xF940, 0xFE42, 0x0400, 0x085B, 0x0984, 0x08CF, 
	0x07CD, 0x067A, 0x0508, 0x03AA, 0x025A, 0x0110, 0x0000, 0xFF34, 0xFF3A, 
	0xFF3E, 0xFF42, 0xFF44, 0xFF45, 0xFF46, 0xFF46, 0xFF46, 0x0000, 0x0734, 
	0x05F6, 0x0313, 0xFFCE, 0xFD6B, 0xFD3D, 0xFE0A, 0xFE89, 0xFF18, 0xFF9D, 
	0xFFFF, 0x001F, 0x000F, 0x0000, 0xFFF6, 0xFFF6, 0xFFF5, 0xFFF2, 0xFFED, 
	0xFFE4, 0xFFD6, 0xFFC4, 0xFFAB, 0x0000, 0x1612, 0x1220, 0x08FE, 0xFEB4, 
	0xF74E, 0xF6DA, 0xFA68, 0xFE76, 0x0341, 0x07F5, 0x0BC0, 0x0E3B, 0x0F92, 
	0x0FCE, 0x0E9F, 0x0D62, 0x0C9A, 0x0BF3, 0x0B19, 0x09B6, 0x0777, 0x0406, 
	0xFF0F, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xF59B, 0xF55A, 0xF4C3, 0xF41A, 
	0xF3A1, 0xF39A, 0xF44A, 0xF595, 0xF72F, 0xF8CA, 0xFA1B, 0xFAD3, 0xFAA7, 
	0xF949, 0xF0F9, 0xF3D5, 0xFB5E, 0x0607, 0x123E, 0x1E74, 0x291C, 0x30A5, 
	0x3381, 0x1DCC, 0xE52E, 0xE554, 0xE599, 0xE5BC, 0xE57A, 0xE490, 0xE2EF, 
	0xE0D0, 0xDE62, 0xDBD4, 0xD953, 0xD70E, 0xD533, 0xD3F1, 0xD54C, 0xD669, 
	0xD73F, 0xD7D9, 0xD83F, 0xD87E, 0xD89E, 0xD8AA, 0xD8AB, 0xD901, 0xD705, 
	0xDB78, 0xE611, 0xF2B3, 0xFD3F, 0x0197, 0xFFCF, 0xFB48, 0xF4DA, 0xED59, 
	0xE59B, 0xDE76, 0xD8C1, 0xD551, 0xDA21, 0xDA07, 0xD953, 0xD768, 0xD3AD, 
	0xCD86, 0xC459, 0xB78B, 0xA681, 0xB867, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xE11F, 0xE35B, 0xE814, 0xEC54, 
	0xED25, 0xE94F, 0xE2BF, 0xDB32, 0xD468, 0xD01E, 0xCFD0, 0xD256, 0xD57C, 
	0xD70F, 0xD5A9, 0xD537, 0xD4FD, 0xD4E7, 0xD4E4, 0xD4E1, 0xD4CC, 0xD491, 
	0xD420, 0xC9F4, 0xFFFF, 0xFBAD, 0xF219, 0xE855, 0xE377, 0xE34E, 0xE429, 
	0xE5D8, 0xE828, 0xEAE9, 0xEDE9, 0xF0F9, 0xF3E7, 0xF682, 0xF9D0, 0xF9CF, 
	0xF9CA, 0xF9BC, 0xF99F, 0xF971, 0xF92C, 0xF8CB, 0xF84B, 0x071C, 0xF97B, 
	0xF644, 0xEF28, 0xE7F9, 0xE485, 0xE4AC, 0xE5A8, 0xE74B, 0xE96C, 0xEBDC, 
	0xEE72, 0xF100, 0xF35C, 0xF559, 0xF71B, 0xF977, 0xFC6C, 0xFFB0, 0x02FE, 
	0x060C, 0x0893, 0x0A4C, 0x0AEF, 0x0306, 0xED8B, 0xEC87, 0xEA47, 0xE7FD, 
	0xE6DD, 0xE6DB, 0xE718, 0xE788, 0xE81E, 0xE8CF, 0xE98D, 0xEA4D, 0xEB02, 
	0xEBA0, 0xEC54, 0xEE7A, 0xF204, 0xF66E, 0xFB32, 0xFFCE, 0x03BD, 0x067A, 
	0x0781, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0x107B, 0x1294, 0x178B, 0x1D5D, 
	0x2209, 0x251C, 0x27AD, 0x2A09, 0x2C7D, 0x2F57, 0x33BA, 0x3973, 0x3ECD, 
	0x4210, 0x4187, 0x40F0, 0x4060, 0x3F83, 0x3E04, 0x3B90, 0x37D2, 0x3276, 
	0x2B27, 0x36DA, 0x13E2, 0x1529, 0x1858, 0x1C72, 0x207A, 0x242D, 0x27FC, 
	0x2BFE, 0x3045, 0x34E8, 0x3B05, 0x428D, 0x49D4, 0x4F2A, 0x50E3, 0x522D, 
	0x53D9, 0x55BB, 0x57A7, 0x5972, 0x5AF0, 0x5BF5, 0x5C56, 0x54F5, 0xD9CD, 
	0xDEC3, 0xEA33, 0xF6F3, 0xFFD8, 0x0429, 0x06DF, 0x0855, 0x08EA, 0x08FA, 
	0x0895, 0x077E, 0x059B, 0x02D5, 0xFF12, 0x0507, 0x097F, 0x0CB4, 0x0EDA, 
	0x1027, 0x10D2, 0x1112, 0x111B, 0x175C, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xE0B7, 0xE29D, 0xE6E8, 
	0xEB79, 0xEE34, 0xEEB7, 0xEE46, 0xED38, 0xEBE7, 0xEAAB, 0xE99D, 0xE882, 
	0xE735, 0xE591, 0xE370, 0xE1EB, 0xE10F, 0xE08A, 0xE00B, 0xDF40, 0xDDD8, 
	0xDB82, 0xD7EC, 0xCB60, 0x0000, 0xFF97, 0xFEE9, 0xFEC7, 0xFFFF, 0x0333, 
	0x07C8, 0x0CB7, 0x10FB, 0x138E, 0x1412, 0x1337, 0x1188, 0x0F90, 0x0DDA, 
	0x0DB0, 0x0D9A, 0x0D92, 0x0D91, 0x0D90, 0x0D88, 0x0D72, 0x0D48, 0xFA42, 
	0x0000, 0xFFF8, 0xFFE5, 0xFFC7, 0xFF9F, 0xFF6E, 0xFF36, 0xFEF7, 0xFEB4, 
	0xFE6D, 0xFE23, 0xFDD8, 0xFD8D, 0xFD44, 0xFCFC, 0xFCB9, 0xFC7A, 0xFC42, 
	0xFC11, 0xFBE9, 0xFBCB, 0xFBB8, 0xFBB1, 0x0197, 0xF548, 0xF387, 0xEF8C, 
	0xEB48, 0xE8A7, 0xE807, 0xE843, 0xE906, 0xE9FC, 0xEAD1, 0xEB94, 0xEC7D, 
	0xED76, 0xEE68, 0xEF3E, 0xF0CF, 0xF31B, 0xF5D7, 0xF8BB, 0xFB7B, 0xFDCE, 
	0xFF69, 0x0004, 0x0624, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xEEC8, 0xF133, 
	0xF675, 0xFB91, 0xFD88, 0xFA6F, 0xF43E, 0xEDCE, 0xE9F6, 0xEA1C, 0xEC86, 
	0xEF5B, 0xF0C4, 0xF092, 0xEFD8, 0xF062, 0xF1CD, 0xF3CF, 0xF61D, 0xF86A, 
	0xFA6C, 0xFBD7, 0xFC61, 0xFE9B, 0xFA11, 0xFA70, 0xFB2F, 0xFBC0, 0xFB94, 
	0xFA14, 0xF7B2, 0xF56C, 0xF440, 0xF51A, 0xF73B, 0xF91E, 0xF940, 0xF6F1, 
	0xF32E, 0xF30B, 0xF2F9, 0xF2F2, 0xF2F1, 0xF2F1, 0xF2EA, 0xF2D8, 0xF2B5, 
	0xEFF9, 0xB276, 0xB440, 0xB85D, 0xBCE9, 0xC003, 0xC190, 0xC271, 0xC237, 
	0xC074, 0xBC31, 0xB5F3, 0xAF80, 0xAAA4, 0xA745, 0xA453, 0xA252, 0xA0FD, 
	0x9FBC, 0x9DF5, 0x9B11, 0x9676, 0x8F8B, 0x85B8, 0x839E, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x1A9F, 0x1ADA, 0x1B93, 
	0x1CD8, 0x1EB7, 0x21A0, 0x2573, 0x2960, 0x2C96, 0x2E47, 0x2BD4, 0x26A7, 
	0x23F6, 0x2573, 0x2893, 0x2C95, 0x312B, 0x360E, 0x3AF6, 0x3F9A, 0x43B3, 
	0x46F9, 0x4925, 0x49EE, 0xFFFF, 0xFDED, 0xFB04, 0xF9B9, 0xF94C, 0xF96A, 
	0xF99F, 0xF9E6, 0xFA3A, 0xFA96, 0xFAF6, 0xFB55, 0xFBAD, 0xFC05, 0xFC63, 
	0xFC56, 0xFC38, 0xFC14, 0xFBF6, 0xFBE9, 0xFC13, 0xFC61, 0xFC8B, 0xF7AE, 
	0xFFFF, 0x0001, 0xFFEF, 0xFFA5, 0xFF60, 0xFF40, 0xFF1C, 0xFEF9, 0xFED9, 
	0xFEC1, 0xFEB5, 0xFEB8, 0xFECE, 0xFF0F, 0xFF7F, 0xFFEE, 0x004D, 0x0096, 
	0x00C5, 0x00D5, 0x00C2, 0x003E, 0xFED5, 0x03C6, 0xC219, 0xBDAB, 0xB6D1, 
	0xB17D, 0xAEBB, 0xAF4C, 0xB055, 0xB1B7, 0xB355, 0xB510, 0xB6CB, 0xB868, 
	0xB9C8, 0xBAE7, 0xBBE1, 0xB9F0, 0xB54D, 0xAFC5, 0xAB23, 0xA931, 0xAC0E, 
	0xB160, 0xB43D, 0xAB92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x19CA, 0x16B1, 
	0x0FE8, 0x0936, 0x042F, 0x0E89, 0x18C3, 0x1961, 0x17E2, 0x18F8, 0x1A8F, 
	0x1C41, 0x1E58, 0x2073, 0x2135, 0x2129, 0x20D2, 0x1FE8, 0x1E20, 0x1B30, 
	0x16CE, 0x10B0, 0x088C, 0x01C0, 0x02D9, 0x030E, 0x0386, 0x0408, 0x04AD, 
	0x07EA, 0x0B87, 0x0F0A, 0x11AA, 0x129F, 0x12E0, 0x12EE, 0x122C, 0x1111, 
	0x10B3, 0x1073, 0x1020, 0x0FC2, 0x0F62, 0x0F08, 0x0EBE, 0x0E8B, 0x0E78, 
	0x1192, 0xC8E6, 0xC39E, 0xB828, 0xAD1B, 0xA648, 0xA7AA, 0xA993, 0xA797, 
	0xA5D3, 0xA6F8, 0xA918, 0xAB36, 0xACF8, 0xAE68, 0xAE28, 0xADD8, 0xAD52, 
	0xAC34, 0xAA1E, 0xA6AF, 0xA186, 0x9A42, 0x9082, 0x842B, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x23FE, 0x29CD, 0x35C5, 0x3FB8, 0x3CD8, 
	0x2739, 0x157C, 0x1AEA, 0x2395, 0x21B7, 0x1D57, 0x18CE, 0x1674, 0x1A18, 
	0x20B7, 0x27A0, 0x2E58, 0x34B7, 0x3A90, 0x3FB8, 0x4406, 0x474E, 0x4965, 
	0x4A21, 0x004C, 0xFF29, 0xFD0D, 0xFBEE, 0x0063, 0xFE1F, 0xFC10, 0xFE92, 
	0x0235, 0x04EA, 0x06E8, 0x078C, 0x0755, 0x0698, 0x052A, 0x04C9, 0x048E, 
	0x0470, 0x0465, 0x0463, 0x046C, 0x04AC, 0x0559, 0x09D3, 0xFF3E, 0xFF32, 
	0xFF1E, 0xFF15, 0xFF48, 0xFEF3, 0xFEB1, 0xFF05, 0xFF5E, 0xFF2F, 0xFEF5, 
	0xFF24, 0xFF41, 0xFEB9, 0xFE47, 0xFEC0, 0xFFE0, 0x0138, 0x0258, 0x02D1, 
	0x02C0, 0x0248, 0x0102, 0xFE32, 0xBA5B, 0xB878, 0xB4BC, 0xB209, 0xB577, 
	0xC2E0, 0xCD24, 0xC845, 0xC079, 0xBF8B, 0xC0B7, 0xC325, 0xC4D9, 0xC291, 
	0xBF4B, 0xB98E, 0xB203, 0xAA6F, 0xA498, 0xA240, 0xA473, 0xA888, 0xAABA, 
	0xABC3, 

},{ 
	0x0001, 0x0000, 0x0018, 0x0001, 0x0001, 0x0019, 0x0001, 0x001A, 0x0001, 
	0x001B, 0x0001, 0x001C, 0x0018, 0x001D, 0x0018, 0x0035, 0x0018, 0x004D, 
	0x0018, 0x0065, 0x0018, 0x007D, 0x0018, 0x0095, 0x0018, 0x00AD, 0x0018, 
	0x00C5, 0x0018, 0x00DD, 0x0001, 0x00F5, 0x0001, 0x00F6, 0x0001, 0x00F7, 
	0x0018, 0x00F8, 0x0018, 0x0110, 0x0018, 0x0128, 0x0018, 0x0140, 0x0015, 
	0x0158, 0x0018, 0x016D, 0x0018, 0x0185, 0x0018, 0x019D, 0x0018, 0x01B5, 
	0x0001, 0x01CD, 0x0001, 0x01CE, 0x0001, 0x01CF, 0x0018, 0x01D0, 0x0018, 
	0x01E8, 0x0018, 0x0200, 0x0017, 0x0218, 0x0017, 0x022F, 0x0018, 0x0246, 
	0x0018, 0x025E, 0x0018, 0x0276, 0x0018, 0x028E, 0x000F, 0x02A6, 0x0018, 
	0x02B5, 0x0001, 0x02CD, 0x0018, 0x02CE, 0x0018, 0x02E6, 0x0018, 0x02FE, 
	0x0004, 0x0316, 0x0016, 0x031A, 0x0018, 0x0330, 0x0018, 0x0348, 0x0018, 
	0x0360, 0x0018, 0x0378, 0x000F, 0x0390, 0x0018, 0x039F, 0x0001, 0x03B7, 
	0x0018, 0x03B8, 0x0018, 0x03D0, 0x0018, 0x03E8, 0x0009, 0x0400, 0x0018, 
	0x0409, 0x0018, 0x0421, 0x0018, 0x0439, 0x0018, 0x0451, 0x0018, 0x0469, 
	

});

smlua_anim_util_register_animation('donkey_7B_backward_kb',1, 0, 0, 0, 29, { 
	0x0000, 0x006A, 0x0056, 0x0041, 0x0046, 0x004F, 0x0059, 0x005D, 0x005A, 
	0x0054, 0x0051, 0x0052, 0x0055, 0x0056, 0x0054, 0x0051, 0x004E, 0x0053, 
	0x005F, 0x006F, 0x007E, 0x008A, 0x008F, 0x008F, 0x008E, 0x008E, 0x008D, 
	0x008C, 0x008C, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFF84, 0xFF68, 
	0xFF4B, 0xFF48, 0xFF46, 0xFF43, 0xFF40, 0xFF3D, 0xFF3A, 0xFF37, 0xFF36, 
	0xFF35, 0xFF35, 0xFF36, 0xFF38, 0xFF3D, 0xFF43, 0xFF4B, 0xFF68, 0xFF9D, 
	0xFFD4, 0xFFF5, 0x0001, 0x0001, 0x0000, 0x0000, 0xFFFF, 0x02CF, 0x02CA, 
	0x02C3, 0x02C4, 0x02C8, 0x02CF, 0x02D7, 0x02E0, 0x02E9, 0x02F1, 0x02F8, 
	0x02FC, 0x02FE, 0x02FC, 0x02F6, 0x02EB, 0x02DA, 0x02C3, 0x026F, 0x01D4, 
	0x0130, 0x00C4, 0x008E, 0x0068, 0x0047, 0x002D, 0x0019, 0x000B, 0x0002, 
	0xFFFE, 0x28FB, 0x2762, 0x25B7, 0x2588, 0x2538, 0x24D0, 0x2458, 0x23DB, 
	0x2362, 0x22F5, 0x229E, 0x2267, 0x2259, 0x227C, 0x22DB, 0x237E, 0x246F, 
	0x25B7, 0x2A77, 0x333B, 0x3C31, 0x4186, 0x4334, 0x454C, 0x4872, 0x4C27, 
	0x4FE8, 0x5336, 0x5590, 0x5675, 0xF868, 0xFC58, 0x04A0, 0x051B, 0x0575, 
	0x05B2, 0x05D4, 0x05E0, 0x05D9, 0x05C2, 0x05A0, 0x0575, 0x0546, 0x0516, 
	0x04E8, 0x04C0, 0x04A2, 0x0483, 0x0451, 0x0400, 0x0385, 0x02D5, 0x015B, 
	0x012B, 0x0119, 0x0116, 0x0114, 0x0102, 0x00D1, 0x0000, 0x0083, 0x0045, 
	0xFFB3, 0xFFA2, 0xFF78, 0xFF3D, 0xFEF8, 0xFEB0, 0xFE6C, 0xFE32, 0xFE0A, 
	0xFDFB, 0xFE0D, 0xFE45, 0xFEAB, 0xFF46, 0x001D, 0x0292, 0x070B, 0x0C16, 
	0x103F, 0x1215, 0x0E68, 0x0A12, 0x070A, 0x04F7, 0x0380, 0x024E, 0x0107, 
	0x0000, 0x0435, 0x0465, 0x044A, 0x03EF, 0x0369, 0x02C1, 0x0206, 0x0142, 
	0x0081, 0xFFD1, 0xFF3C, 0xFECE, 0xFE95, 0xFE9B, 0xFEED, 0xFF97, 0x00A5, 
	0x0402, 0x0A52, 0x11B8, 0x1857, 0x1C51, 0x1ACF, 0x16D0, 0x1149, 0x0B3B, 
	0x05AA, 0x0195, 0xFFFF, 0x039F, 0x0321, 0xFF00, 0xF6AC, 0xF55C, 0xF564, 
	0xF5DF, 0xF727, 0xF8B2, 0xF926, 0xF98C, 0xFA75, 0xFB82, 0xFC91, 0xFD81, 
	0xFE6A, 0xFF2F, 0xFF61, 0xFEE5, 0xFE11, 0xFD1A, 0xFC35, 0xFB98, 0xFB6F, 
	0xFBC7, 0xFCA3, 0xFDC1, 0xFEE0, 0xFFBC, 0x0015, 0x0000, 0xFA27, 0xF99B, 
	0xF8C5, 0xFA4B, 0xFC39, 0xFD94, 0xFD17, 0xFC79, 0xFDED, 0xFF8A, 0x003F, 
	0x00C3, 0x0121, 0x0167, 0x0192, 0x018B, 0x013E, 0x009D, 0xFFC6, 0xFEE4, 
	0xFE25, 0xFDB6, 0xFE02, 0xFE36, 0xFE58, 0xFE6E, 0xFE78, 0xFE7C, 0xFE7D, 
	0x0000, 0x0F2A, 0x17C3, 0x28F4, 0x3016, 0x3522, 0x3700, 0x2FEF, 0x287E, 
	0x2DB6, 0x33A2, 0x336D, 0x31DD, 0x2F40, 0x2BE0, 0x26AB, 0x1FEE, 0x1A09, 
	0x152E, 0x104F, 0x0BE6, 0x0870, 0x0667, 0x08D9, 0x08C3, 0x0828, 0x0683, 
	0x0351, 0xFE0A, 0xF62C, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xD16D, 0xD16D, 
	0xCE73, 0xCF0A, 0xCF99, 0xD025, 0xD0B3, 0xD148, 0xD1E8, 0xD296, 0xD359, 
	0xD434, 0xD52C, 0xD646, 0xD785, 0xD8EE, 0xDA87, 0xDD4C, 0xE19D, 0xE68D, 
	0xEB31, 0xEE9D, 0xF112, 0xF7C9, 0x0259, 0x0E7D, 0x19F5, 0x227F, 0x25D8, 
	0x1DCC, 0xDE5E, 0xDE5E, 0xE000, 0xE1D5, 0xE3E6, 0xE625, 0xE87F, 0xEAE5, 
	0xED45, 0xEF8F, 0xF1B2, 0xF39E, 0xF542, 0xF68D, 0xF76F, 0xF7D7, 0xF7B4, 
	0xF492, 0xED8C, 0xE4E7, 0xDCEB, 0xD7DC, 0xD579, 0xD5B5, 0xD64C, 0xD710, 
	0xD7D4, 0xD86B, 0xD8A7, 0xD901, 0x098D, 0x098D, 0x0DB0, 0x0BE9, 0x0A07, 
	0x080D, 0x05FF, 0x03E0, 0x01B2, 0xFF79, 0xFD38, 0xFAF3, 0xF8AB, 0xF666, 
	0xF425, 0xF1EC, 0xEFBD, 0xED8D, 0xEB51, 0xE914, 0xE6E0, 0xE4BE, 0xE276, 
	0xE0E6, 0xDF0D, 0xDB57, 0xD42E, 0xC7FD, 0xB530, 0xB867, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xD516, 0xD516, 0xCCC0, 0xC910, 0xC65A, 0xC568, 
	0xC979, 0xCDBF, 0xCAD1, 0xC7E2, 0xCF95, 0xD129, 0xD28C, 0xD398, 0xD429, 
	0xD41A, 0xD345, 0xCE13, 0xC65E, 0xC431, 0xD490, 0xE39A, 0xE2FB, 0xE257, 
	0xE196, 0xE013, 0xDD28, 0xD830, 0xD086, 0xC9F4, 0x0000, 0xFFFD, 0xFFF6, 
	0xFFEC, 0xFFDE, 0xFFCD, 0xFFB9, 0xFFA2, 0xFF89, 0xFF6E, 0xFF51, 0xFF33, 
	0xFF14, 0xFEF5, 0xFED5, 0xFEB5, 0xFE95, 0xFE76, 0xFE59, 0xFE3C, 0xFE21, 
	0xFE08, 0xFDF1, 0xFDDD, 0xFDCC, 0xFDBE, 0xFDB3, 0xFDAD, 0xFDAB, 0x071C, 
	0xF97B, 0xF97B, 0xF97D, 0xF97F, 0xF981, 0xF984, 0xF988, 0xF98C, 0xF991, 
	0xF996, 0xF99B, 0xF9A0, 0xF9A6, 0xF9AC, 0xF9B2, 0xF9B8, 0xF9BD, 0xF9C3, 
	0xF9C9, 0xF9CE, 0xF9D3, 0xF9D7, 0xF9DB, 0xF9DF, 0xF9E2, 0xF9E5, 0xF9E7, 
	0xF9E8, 0xF9E8, 0x0306, 0xED8B, 0xED99, 0xEDC3, 0xEE05, 0xEE5F, 0xEECE, 
	0xEF4F, 0xEFE1, 0xF082, 0xF12F, 0xF1E7, 0xF2A7, 0xF36E, 0xF438, 0xF505, 
	0xF5D2, 0xF69C, 0xF763, 0xF823, 0xF8DB, 0xF988, 0xFA29, 0xFABB, 0xFB3D, 
	0xFBAB, 0xFC05, 0xFC47, 0xFC71, 0xFC7F, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0x17D3, 0x17D3, 0x271F, 0x2756, 0x275D, 0x2736, 0x26E4, 0x2668, 0x25C7, 
	0x2502, 0x241B, 0x2316, 0x21F6, 0x20BB, 0x1F6B, 0x1E06, 0x1C8F, 0x1A70, 
	0x1603, 0x0DBA, 0xF198, 0xFAE7, 0xEA1A, 0xDB5B, 0xD5ED, 0xD526, 0xD45F, 
	0xCEF1, 0x4032, 0x36DA, 0x500D, 0x500D, 0x4EFF, 0x4BD6, 0x4897, 0x4548, 
	0x41ED, 0x3E89, 0x3B21, 0x37B9, 0x3456, 0x30FC, 0x2DAF, 0x2A73, 0x274C, 
	0x2440, 0x2151, 0x1E67, 0x1CB7, 0x1E3D, 0x307A, 0x27E7, 0x2764, 0x27AB, 
	0x285D, 0x2945, 0x2A2C, 0x2ADE, 0x54DA, 0x54F5, 0xD724, 0xD724, 0xE339, 
	0xE5E6, 0xE891, 0xEB34, 0xEDC9, 0xF04A, 0xF2B0, 0xF4F5, 0xF713, 0xF903, 
	0xFABF, 0xFC41, 0xFD82, 0xFE7C, 0xFF29, 0xFC30, 0xF49D, 0xEBFF, 0xDF58, 
	0xD6DC, 0xC269, 0xB5D6, 0xB134, 0xB08A, 0xAFE1, 0xAB3F, 0x1EAC, 0x175C, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xDDE6, 0xDDE6, 0xDD0C, 0xD88E, 0xD376, 
	0xCFBD, 0xD37F, 0xCF20, 0xC96D, 0xC6D2, 0xD52A, 0xD6EF, 0xD797, 0xD796, 
	0xD761, 0xD76B, 0xD828, 0xDA44, 0xDD6A, 0xE094, 0xE2BB, 0xE2D7, 0xE0B9, 
	0xDECA, 0xDDF4, 0xDD81, 0xDCB8, 0xDAE2, 0xD74A, 0xCB60, 0x0000, 0x0000, 
	0x0000, 0xFFF5, 0xFFD8, 0xFFAE, 0xFF7B, 0xFF45, 0xFF11, 0xFEE4, 0xFEC2, 
	0xFEB0, 0xFEB4, 0xFED3, 0xFF11, 0xFF74, 0x0000, 0x0223, 0x0605, 0x09BE, 
	0x0B68, 0xFFFF, 0xFF07, 0xFF07, 0xFF03, 0xFEFA, 0xFEE9, 0xFECC, 0xFEA2, 
	0xFA42, 0x0000, 0xFFFF, 0xFFFF, 0xFFEC, 0xFFB7, 0xFF6A, 0xFF0E, 0xFEAC, 
	0xFE4D, 0xFDFA, 0xFDBD, 0xFD9D, 0xFDA4, 0xFDDC, 0xFE4D, 0xFF01, 0xFFFF, 
	0x03E5, 0x0AF7, 0x11BF, 0x14C7, 0xFFFF, 0xFE3B, 0xFE5A, 0xFE6E, 0xFE7B, 
	0xFE81, 0xFE83, 0xFE84, 0x0197, 0xEB58, 0xEB58, 0xE7D6, 0xE79B, 0xE760, 
	0xE729, 0xE6F7, 0xE6CD, 0xE6AB, 0xE695, 0xE68C, 0xE692, 0xE6A9, 0xE6D3, 
	0xE712, 0xE768, 0xE7D6, 0xE91A, 0xEB73, 0xEE2B, 0xF08B, 0xF1A9, 0xF238, 
	0xF383, 0xF57F, 0xF7C3, 0xF9E3, 0xFB78, 0xFC16, 0x0624, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xBF32, 0xBF5E, 0xC07B, 0xC1B8, 
	0xC30C, 0xC470, 0xC5DB, 0xC746, 0xC8A8, 0xC9FB, 0xCB35, 0xCC4F, 0xCD41, 
	0xCE04, 0xCE8E, 0xCED9, 0xCD8B, 0xCA29, 0xC5F6, 0xC237, 0xBF5E, 0xBF20, 
	0xBF03, 0xBEFF, 0xBF0D, 0xBF25, 0xBF40, 0xBF55, 0xBF5E, 0xEFE9, 0xEFE9, 
	0xE009, 0xDFA8, 0xDF81, 0xDF8F, 0xDFCE, 0xE038, 0xE0C9, 0xE17B, 0xE24A, 
	0xE330, 0xE429, 0xE52F, 0xE63D, 0xE74F, 0xE85F, 0xEA7D, 0xEDDB, 0xF121, 
	0xF2FA, 0xEBD4, 0xE876, 0xE9D8, 0xED4C, 0xF1CA, 0xF647, 0xF9BB, 0xFB1D, 
	0xFE9B, 0xEACA, 0xEACA, 0xE5CA, 0xE456, 0xE2DA, 0xE159, 0xDFDA, 0xDE60, 
	0xDCF1, 0xDB93, 0xDA49, 0xD91A, 0xD809, 0xD71D, 0xD65A, 0xD5C5, 0xD563, 
	0xD6D1, 0xDA6D, 0xDE60, 0xE0D4, 0xDAD0, 0xDC89, 0xDF25, 0xE1A8, 0xE3E7, 
	0xE5B6, 0xE6EC, 0xE75D, 0xEFF9, 0x99D8, 0x99D8, 0x81E3, 0x7FCB, 0x7E1F, 
	0x7CD0, 0x7BCF, 0x7B10, 0x7A85, 0x7A21, 0x79D6, 0x7996, 0x7956, 0x7906, 
	0x7899, 0x7803, 0x7736, 0x74F2, 0x719A, 0x6F8D, 0x712D, 0x8C84, 0x941A, 
	0x9407, 0x937D, 0x9206, 0x8F2D, 0x8A7B, 0x8379, 0x839E, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x392D, 0x38B3, 
	0x2670, 0x2C21, 0x3623, 0x3D4F, 0x3B06, 0x374D, 0x3B72, 0x3F45, 0x36D3, 
	0x3684, 0x36B6, 0x3757, 0x3858, 0x39A8, 0x3B37, 0x3DA1, 0x4102, 0x448A, 
	0x4766, 0x467A, 0x4223, 0x4291, 0x43AE, 0x4534, 0x46DD, 0x4862, 0x497F, 
	0x49EE, 0xFFFF, 0xFFFF, 0x0000, 0xFFD2, 0xFF9C, 0xFF68, 0xFF38, 0xFF0E, 
	0xFEEE, 0xFED3, 0xFEBE, 0xFEB8, 0xFE7B, 0xFE41, 0xFE46, 0xFEC7, 0xFFFF, 
	0x02F8, 0x078A, 0x0C2A, 0x0F4F, 0x096F, 0x06CD, 0x0509, 0x0273, 0xFF76, 
	0xFC7C, 0xF9F0, 0xF83C, 0xF7AE, 0x0000, 0x0000, 0x0000, 0xFFFE, 0xFFFC, 
	0xFFF2, 0xFFC9, 0xFFAA, 0xFFD2, 0xFFF1, 0xFF7A, 0xFF7F, 0xFF8A, 0xFF9C, 
	0xFFB5, 0xFFD6, 0xFFFF, 0x004C, 0x00B9, 0x0119, 0x013F, 0xFFE4, 0xFFC6, 
	0x003A, 0x015B, 0x02D2, 0x044A, 0x056A, 0x05DE, 0x03C6, 0xCBE1, 0xD061, 
	0xDA8B, 0xDE5B, 0xE0D2, 0xE0CD, 0xD96D, 0xD252, 0xD75B, 0xDC5D, 0xCED7, 
	0xCF95, 0xD1D2, 0xD4CC, 0xD7BF, 0xD9EB, 0xDA8B, 0xD8D8, 0xD51B, 0xD02A, 
	0xCAE1, 0xC0A5, 0xBEA9, 0xBE94, 0xBE02, 0xBC75, 0xB971, 0xB477, 0xAD0B, 
	0xAB92, 0x0038, 0x0038, 0xFFFF, 0xFFFC, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFF8, 
	0xFFF8, 0xFFF9, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFFE, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF3A, 0xBF3A, 0xBF5E, 0xBF6A, 0xBF86, 0xBFAF, 0xBFDE, 0xC010, 
	0xC040, 0xC06A, 0xC089, 0xC098, 0xC093, 0xC076, 0xC03C, 0xBFE0, 0xBF5E, 
	0xBD62, 0xB9C7, 0xB652, 0xB4C6, 0xBF5E, 0xC045, 0xC045, 0xC045, 0xC045, 
	0xC045, 0xC045, 0xC045, 0xBF5E, 0x0FB6, 0x0FB6, 0x0F7F, 0x0FD3, 0x1045, 
	0x10CE, 0x1165, 0x1203, 0x12A0, 0x1333, 0x13B5, 0x141D, 0x1463, 0x1480, 
	0x146B, 0x141C, 0x138C, 0x0FCF, 0x08FC, 0x038A, 0x067A, 0x0A09, 0x0C83, 
	0x0C6D, 0x0C0F, 0x0B3E, 0x09CE, 0x0795, 0x0468, 0x01C0, 0x15FE, 0x15FE, 
	0x1AEC, 0x1A70, 0x19CC, 0x1906, 0x1826, 0x1734, 0x1636, 0x1533, 0x1434, 
	0x1340, 0x125C, 0x1192, 0x10E9, 0x1066, 0x1013, 0x115F, 0x1460, 0x1718, 
	0x17B2, 0x18CB, 0x17EC, 0x1720, 0x16CA, 0x16A0, 0x1657, 0x15A5, 0x1442, 
	0x1192, 0x8F56, 0x8F56, 0x86F9, 0x86AF, 0x869C, 0x86B8, 0x86F8, 0x8754, 
	0x87C1, 0x8836, 0x88A9, 0x8912, 0x8966, 0x899C, 0x89AA, 0x8987, 0x892A, 
	0x861D, 0x810C, 0x7E9B, 0x8AE6, 0x8EEF, 0x9308, 0x92F9, 0x9290, 0x9171, 
	0x8F42, 0x8BA9, 0x864A, 0x842B, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x286A, 0x286A, 0x1CA8, 0x1F50, 0x248E, 0x27F5, 0x2511, 0x21B5, 
	0x24AA, 0x283F, 0x25AF, 0x2758, 0x28D2, 0x2A8B, 0x2CF2, 0x3075, 0x3583, 
	0x3EA0, 0x4B80, 0x5859, 0x615F, 0x52C2, 0x4ACC, 0x4A8C, 0x4A5F, 0x4A41, 
	0x4A2E, 0x4A25, 0x4A21, 0xFFAB, 0xFFAB, 0xFFB5, 0xFFC8, 0xFFDC, 0xFFFA, 
	0x0038, 0x0073, 0x0077, 0x0079, 0x00C7, 0x00D3, 0x0104, 0x012F, 0x012A, 
	0x00C9, 0xFFE0, 0xFD7D, 0xF9CB, 0xF649, 0xF477, 0xFD78, 0xFEFF, 0xFEFF, 
	0xFEFF, 0xFEFF, 0xFEFF, 0xFEFF, 0xFEFF, 0x09D3, 0xFF3C, 0xFF3C, 0xFF3D, 
	0xFF3C, 0xFF3B, 0xFF3D, 0xFF4A, 0xFF52, 0xFF43, 0xFF34, 0xFF53, 0xFF52, 
	0xFF51, 0xFF4E, 0xFF49, 0xFF3F, 0xFF31, 0xFF4B, 0xFF7B, 0xFF65, 0xFEAD, 
	0xF96E, 0xF92E, 0xF92E, 0xF92E, 0xF92E, 0xF92E, 0xF92E, 0xF92E, 0xFE32, 
	0xDABA, 0xDABA, 0xD883, 0xD857, 0xD87C, 0xD78B, 0xD2AB, 0xCEBE, 0xD2DD, 
	0xD756, 0xD0B9, 0xD06C, 0xD126, 0xD22F, 0xD2CF, 0xD24E, 0xCFF4, 0xC9D5, 
	0xC048, 0xB5F9, 0xAD91, 0xAF25, 0xB0A7, 0xB0A7, 0xB0A7, 0xB0A7, 0xB0A7, 
	0xB0A7, 0xB0A7, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001D, 0x0001, 0x0001, 0x001E, 0x0001, 0x001F, 0x0001, 
	0x0020, 0x0001, 0x0021, 0x001B, 0x0022, 0x001E, 0x003D, 0x001E, 0x005B, 
	0x001E, 0x0079, 0x001E, 0x0097, 0x001E, 0x00B5, 0x001E, 0x00D3, 0x001E, 
	0x00F1, 0x001E, 0x010F, 0x0001, 0x012D, 0x0001, 0x012E, 0x0001, 0x012F, 
	0x001E, 0x0130, 0x001E, 0x014E, 0x001E, 0x016C, 0x001D, 0x018A, 0x001E, 
	0x01A7, 0x001E, 0x01C5, 0x001E, 0x01E3, 0x001E, 0x0201, 0x001E, 0x021F, 
	0x0001, 0x023D, 0x0001, 0x023E, 0x0001, 0x023F, 0x001E, 0x0240, 0x001E, 
	0x025E, 0x001E, 0x027C, 0x001D, 0x029A, 0x001D, 0x02B7, 0x001E, 0x02D4, 
	0x001E, 0x02F2, 0x001E, 0x0310, 0x001E, 0x032E, 0x001E, 0x034C, 0x001E, 
	0x036A, 0x001E, 0x0388, 0x001E, 0x03A6, 0x001E, 0x03C4, 0x001E, 0x03E2, 
	0x0006, 0x0400, 0x001E, 0x0406, 0x001E, 0x0424, 0x001E, 0x0442, 0x001E, 
	0x0460, 0x001E, 0x047E, 0x001E, 0x049C, 0x0018, 0x04BA, 0x001E, 0x04D2, 
	0x001E, 0x04F0, 0x001E, 0x050E, 0x001E, 0x052C, 0x000C, 0x054A, 0x001E, 
	0x0556, 0x001D, 0x0574, 0x001E, 0x0591, 0x001E, 0x05AF, 0x001E, 0x05CD, 
	

});

smlua_anim_util_register_animation('donkey_7C _forward_kb',1, 0, 0, 0, 29, { 
	0x0000, 0x007E, 0x007C, 0x0075, 0x006C, 0x0061, 0x0056, 0x004D, 0x0047, 
	0x0043, 0x0040, 0x003D, 0x003C, 0x003B, 0x003A, 0x003A, 0x003A, 0x003A, 
	0x0043, 0x0059, 0x0073, 0x008B, 0x0098, 0x009E, 0x009F, 0x009D, 0x009A, 
	0x0095, 0x0090, 0x008D, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0003, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0B68, 0x0000, 0xFEB0, 
	0xFED6, 0xFF90, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
	0x36DA, 0x492F, 0x5699, 0x6373, 0x6F17, 0x78DB, 0x7B44, 0x7961, 0x7A07, 
	0x7B73, 0x7CD7, 0x7D67, 0x7C57, 0x78DB, 0x6596, 0x50ED, 0x48EF, 0x4AB3, 
	0x4F41, 0x557C, 0x5C46, 0x6280, 0x670E, 0x68D3, 0x6776, 0x6410, 0x5FA4, 
	0x5B38, 0x57D1, 0x5675, 0xFFFF, 0xFFD2, 0xFFA4, 0xFFB8, 0xFFDF, 0xFFFF, 
	0x0006, 0x0003, 0x0003, 0x0002, 0x0002, 0x0001, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFE9, 0xFFB1, 0xFF6D, 0xFF2F, 0xFF0B, 0xFF15, 0xFF60, 0xFFFF, 
	0x0000, 0xF638, 0xF719, 0xF8F8, 0xFB1F, 0xFD80, 0xFFFF, 0x0346, 0x054B, 
	0x04FE, 0x0436, 0x0322, 0x01F3, 0x00D7, 0xFFFF, 0xFFD6, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x012E, 
	0x015E, 0x0102, 0xFF16, 0xFCBF, 0xFBD5, 0xFF8A, 0x030A, 0x027A, 0x0113, 
	0xFF46, 0xFD82, 0xFC37, 0xFBD5, 0xFFBB, 0x04CC, 0x074C, 0x09B1, 0x0BF7, 
	0x0E19, 0x1015, 0x11E5, 0x1386, 0x14F4, 0x13AB, 0x1076, 0x0C49, 0x081D, 
	0x04E8, 0x039F, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0023, 0x0069, 0x009D, 0x008C, 0xFFFF, 0xFE90, 0xFC5F, 0xFA0B, 0xFAAC, 
	0xFC2D, 0xFDF7, 0xFF78, 0x001A, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 
	0x0003, 0x0003, 0x0004, 0x0004, 0x0005, 0x0005, 0x0005, 0x0006, 0x0006, 
	0x0006, 0x0006, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0000, 0xF7E5, 
	0x01E7, 0x0B1B, 0x03E9, 0xF7C5, 0xF008, 0xEDE8, 0xEC5E, 0xEB6D, 0xEB18, 
	0xEB61, 0xEC4A, 0xEDD7, 0xF008, 0x0755, 0xF3C1, 0xEB29, 0xE298, 0xDB62, 
	0xD6DC, 0xD65A, 0xDC00, 0xE6EC, 0xF3E6, 0xF3D0, 0xF338, 0xF19B, 0xEE75, 
	0xE946, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xDA73, 0xD080, 0xB7B0, 0x178D, 
	0xF79C, 0xDF70, 0xCFDD, 0xC726, 0xC359, 0xC283, 0xC2A4, 0xC38A, 0xC5FA, 
	0xCABA, 0xE272, 0x0029, 0x0811, 0x12C0, 0x1F0A, 0x2BC3, 0xB7BE, 0xC1D3, 
	0xD21F, 0xDCE6, 0xDC6B, 0xD911, 0xCFF8, 0x3E40, 0x210A, 0x1DCC, 0xE188, 
	0xDCC1, 0xD0B5, 0xBF2C, 0xCF76, 0xDCBB, 0xDAE2, 0xD6D2, 0xD2C2, 0xD0EA, 
	0xD3E0, 0xDB47, 0xE4E6, 0xEE86, 0xF5ED, 0xF8E3, 0xF889, 0xF7AB, 0xF61A, 
	0xF3AB, 0x8FD0, 0x9485, 0xAB63, 0xAC30, 0xAC18, 0xAB71, 0xA9AD, 0xD9C2, 
	0xDF6D, 0xD901, 0xFBD4, 0x002E, 0x0AE5, 0x9877, 0xA566, 0xAE2E, 0xB760, 
	0xC0BB, 0xC800, 0xCAEC, 0xC925, 0xC477, 0xBDE0, 0xB65C, 0xAEE7, 0xA87E, 
	0xA334, 0x9C71, 0x94CE, 0x8CE7, 0x0557, 0xFEB7, 0xEF2E, 0xE793, 0xEF51, 
	0x01C9, 0x17D3, 0xAA4A, 0xB208, 0xB867, 0xFFFF, 0x0008, 0x001F, 0x0043, 
	0x0070, 0x00A5, 0x00DF, 0x011B, 0x0157, 0x0191, 0x01C6, 0x01F3, 0x0217, 
	0x022E, 0x0236, 0x0147, 0x0028, 0x0019, 0x000E, 0x0007, 0x0003, 0x0001, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0003, 0x0006, 
	0x000A, 0x0010, 0x0017, 0x0021, 0x002E, 0x003D, 0x004F, 0x0064, 0x007D, 
	0x01C7, 0x01E5, 0x01CA, 0x0185, 0x0126, 0x00BF, 0x0060, 0x001B, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xCF32, 0xD113, 0xD589, 
	0xDACC, 0xDF15, 0xE09D, 0xDF54, 0xDCA6, 0xD90C, 0xD4FC, 0xD0EC, 0xCD53, 
	0xCAA9, 0xC964, 0xC039, 0xD396, 0xE225, 0xF0E7, 0xEEE8, 0xEC38, 0xE939, 
	0xE64B, 0xE2F8, 0xDECD, 0xDC7C, 0xDBDE, 0xDBD0, 0xDB2D, 0xD8D5, 0xC9F4, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFCF, 0xFF58, 0xFEC5, 
	0xFE40, 0xFDF3, 0xFE08, 0xFEA9, 0x0000, 0x102A, 0x2483, 0x20C1, 0x1A91, 
	0x1321, 0x0B9F, 0x0537, 0x0116, 0xFF0E, 0xFE00, 0xFECC, 0x00B2, 0x02F5, 
	0x04DB, 0x05A6, 0x071C, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97C, 0xF97E, 0xF981, 0xF984, 0xF986, 0xF985, 0xF982, 0xF97B, 0xF923, 
	0xFFE3, 0xFA93, 0xF379, 0xEBC6, 0xE4AB, 0xDF59, 0xDD01, 0xDDE1, 0xE0F1, 
	0xE82C, 0xF21D, 0xFC4A, 0x0438, 0x0769, 0x0306, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED98, 0xEDB7, 0xEDDE, 0xEE01, 0xEE16, 0xEE10, 
	0xEDE5, 0xED8B, 0xE941, 0xF228, 0xF160, 0xEF9F, 0xED5E, 0xEB14, 0xE93B, 
	0xE84A, 0xE844, 0xE8BE, 0xECF3, 0xF4E8, 0xFDEE, 0x0552, 0x0862, 0x0A90, 
	0x0001, 0xFFFE, 0xC170, 0x24EE, 0x2526, 0x25A7, 0x2633, 0x2690, 0x267F, 
	0x29E8, 0x316A, 0x38EC, 0x3C56, 0x39B5, 0x34D2, 0x3231, 0x35A7, 0x1774, 
	0xFEF3, 0x00D5, 0xFE8E, 0xF9DA, 0xF478, 0xF025, 0xEE9E, 0xEA67, 0xECEA, 
	0xEC98, 0xEA5D, 0xE451, 0xD889, 0x451D, 0x36DA, 0x1C98, 0x1D57, 0x1F18, 
	0x2118, 0x2299, 0x22DB, 0x23D3, 0x2577, 0x2703, 0x27B2, 0x272E, 0x2392, 
	0x19C6, 0x059D, 0xF868, 0x095F, 0x08C8, 0x090A, 0x0A02, 0x0B90, 0x0D92, 
	0x0FE7, 0x219B, 0x25B9, 0x25BA, 0x25C0, 0x25CF, 0x25EE, 0x59DF, 0x54F5, 
	0xF3E0, 0xEEB4, 0xE1AD, 0xD083, 0xBEEF, 0xB0AB, 0xB53B, 0xBF45, 0xC94E, 
	0xCDDE, 0xCDAF, 0xCC63, 0xC8DF, 0xAE34, 0x960A, 0xA26A, 0xA123, 0x9D0D, 
	0x97C4, 0x92DF, 0x8FF8, 0x90A9, 0x8C89, 0x9527, 0x9A4B, 0x9D69, 0x9F03, 
	0x9F9A, 0x1FB0, 0x175C, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xC774, 0xC92D, 0xCD3E, 0xD1FF, 0xD5CB, 0xD6FA, 0xD565, 0xD255, 0xCE53, 
	0xC9E5, 0xC592, 0xC1E3, 0xBF5D, 0xBE88, 0xCD3B, 0xDDEA, 0xE8EB, 0xF097, 
	0xED59, 0xE98B, 0xE554, 0xE0DF, 0xDC55, 0xD7DF, 0xD7DF, 0xD7DF, 0xD7DF, 
	0xD7DF, 0xD7DF, 0xCB60, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0001, 0x0002, 0x0002, 0x0003, 0x0003, 0x0003, 0x0000, 
	0xD897, 0xD564, 0xD4CA, 0xD61E, 0xD8B3, 0xDBDD, 0xDEEF, 0xE27F, 0xE740, 
	0xEC33, 0xF0BB, 0xF474, 0xF6F9, 0xF7E6, 0xFA42, 0x0000, 0xFFCD, 0xFF69, 
	0xFF1E, 0xFF37, 0xFFFF, 0x0177, 0x0354, 0x057A, 0x07C9, 0x0A24, 0x0C6D, 
	0x0E84, 0x104C, 0x0EAA, 0xFA8F, 0xFBB2, 0xFEEF, 0x0346, 0x07B9, 0x0B47, 
	0x0CF1, 0x0CAE, 0x0B5A, 0x0850, 0x0438, 0x0010, 0xFCD6, 0xFB8A, 0x0197, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF536, 0xF509, 0xF4D2, 
	0xF49F, 0xF482, 0xF48A, 0xF4C7, 0xF549, 0xFB65, 0xECA0, 0xE8C3, 0xE552, 
	0xE27A, 0xE068, 0xDF49, 0xDF48, 0xE0B2, 0xE369, 0xE7DA, 0xED59, 0xF2BA, 
	0xF6D0, 0xF870, 0x0624, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 
	0xEAE3, 0xEC16, 0xEF1D, 0xF31B, 0xF733, 0xFA88, 0xFCB4, 0xFD8A, 0xFD29, 
	0xFC41, 0xFB2E, 0xFA4C, 0xF9F6, 0xFA88, 0x00B4, 0x06D2, 0x058A, 0x01F4, 
	0xFF89, 0xFFBA, 0x00F0, 0x0217, 0x021E, 0xFB13, 0xFB13, 0xFB14, 0xFB14, 
	0xFB14, 0xFB14, 0xFE9B, 0xEF5C, 0xEFEA, 0xF14B, 0xF315, 0xF4DC, 0xF637, 
	0xF68D, 0xF662, 0xF68F, 0xF6F2, 0xF752, 0xF778, 0xF72C, 0xF637, 0xF122, 
	0xEB4F, 0xE932, 0xE858, 0xE86E, 0xE96D, 0xEB22, 0xED00, 0xEE78, 0xEDDE, 
	0xEDDE, 0xEDDE, 0xEDDE, 0xEDDE, 0xEDDE, 0xEFF9, 0xCFCC, 0xCD2E, 0xC682, 
	0xBD8A, 0xB408, 0xABBF, 0xA32F, 0x9E2A, 0x9F14, 0xA163, 0xA473, 0xA79F, 
	0xAA45, 0xABBF, 0xA81E, 0xA3AE, 0xA4EE, 0xA794, 0xA724, 0xA1B3, 0x99CC, 
	0x919A, 0x8B49, 0x8FE1, 0x8FA5, 0x8DFD, 0x897F, 0x80BE, 0x7251, 0x839E, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x38C5, 0x38B2, 
	0x388C, 0x386F, 0x3879, 0x38C6, 0x3A89, 0x3C11, 0x3B4B, 0x3986, 0x3793, 
	0x3641, 0x3662, 0x38C6, 0x4B23, 0x5AFF, 0x520C, 0x40FE, 0x32DF, 0x2AEC, 
	0x24C1, 0x1FF9, 0x1C2D, 0x21B3, 0x2A9C, 0x33B8, 0x3C38, 0x434B, 0x4822, 
	0x49EE, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x005F, 0x0000, 0xFE05, 
	0xFB6E, 0xF8C7, 0xF618, 0xF345, 0xF09E, 0xEE77, 0xEFC7, 0xF311, 0xF759, 
	0xFBA1, 0xFEEC, 0x003F, 0xF7AE, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x007F, 0x0000, 0xFC80, 0xF82E, 0xF64E, 0xF812, 0xFBA2, 0xFFB9, 0x030F, 
	0x02FD, 0x0304, 0x0319, 0x033B, 0x0367, 0x039D, 0x03C6, 0xCB78, 0xCB67, 
	0xCB37, 0xCAEF, 0xCA96, 0xCA33, 0xC955, 0xC8AB, 0xC857, 0xC7A6, 0xC70B, 
	0xC6F8, 0xC7DF, 0xCA33, 0xD66E, 0xE2A5, 0xE316, 0xDF64, 0xD981, 0xD1C9, 
	0xC852, 0xBEA6, 0xB64D, 0xB5A0, 0xB664, 0xB838, 0xBA66, 0xBC39, 0xBCFD, 
	0xAB92, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x04C5, 0x0513, 0x05C5, 
	0x068D, 0x0718, 0x0716, 0x047B, 0x0211, 0x027B, 0x0381, 0x04CE, 0x060E, 
	0x06ED, 0x0716, 0x03E4, 0xFF97, 0xFD1F, 0xFAEB, 0xF940, 0xF867, 0xF97D, 
	0xFBDD, 0xFD26, 0xF830, 0xF830, 0xF830, 0xF831, 0xF831, 0xF831, 0x01C0, 
	0x1482, 0x1475, 0x1457, 0x1437, 0x1424, 0x142C, 0x14BB, 0x153D, 0x1523, 
	0x14E5, 0x1497, 0x1450, 0x1425, 0x142C, 0x15E0, 0x167E, 0x134A, 0x0ECB, 
	0x0A9F, 0x0868, 0x0A52, 0x0EBF, 0x119F, 0x0B68, 0x0B68, 0x0B68, 0x0B68, 
	0x0B68, 0x0B68, 0x1192, 0xADF8, 0xAE33, 0xAEA7, 0xAEF9, 0xAECE, 0xADCA, 
	0xA80B, 0xA314, 0xA3F1, 0xA615, 0xA8D2, 0xAB78, 0xAD5A, 0xADCA, 0xA870, 
	0x9EE2, 0x94A1, 0x8959, 0x7F84, 0x79A1, 0x7B35, 0x8253, 0x894B, 0x8DAC, 
	0x8D70, 0x8BC8, 0x874A, 0x7E89, 0x701C, 0x842B, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x4A4A, 0x4E1A, 0x4F1F, 0x4606, 0x397E, 0x2EE6, 
	0x29DC, 0x28BD, 0x2839, 0x2739, 0x2690, 0x2713, 0x2994, 0x2EE6, 0x48CE, 
	0x61D3, 0x6363, 0x5F11, 0x5708, 0x4D74, 0x3F08, 0x2C94, 0x1E6D, 0x2887, 
	0x34DE, 0x3DD9, 0x43F8, 0x47B9, 0x499C, 0x4A21, 0xFFC1, 0xFFC2, 0xFFC3, 
	0xFFC4, 0xFFC6, 0xFFC8, 0xFFCA, 0xFFCC, 0xFFCD, 0xFFCF, 0xFFD0, 0xFFD0, 
	0xFFCE, 0xFFC8, 0xFFA3, 0xFF87, 0xFEF8, 0xFE0C, 0xFDFA, 0xFFFC, 0x097C, 
	0x1441, 0x11F7, 0x0C3C, 0x0B4E, 0x0AD6, 0x0AA2, 0x0A7B, 0x0A2E, 0x09D3, 
	0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF38, 0xFF37, 0xFF36, 0xFF36, 0xFF35, 
	0xFF34, 0xFF33, 0xFF33, 0xFF34, 0xFF37, 0xFEA3, 0xFF57, 0x0315, 0x07FF, 
	0x0C4F, 0x0E43, 0x0892, 0x0070, 0x0026, 0x001B, 0xFFBF, 0xFF17, 0xFE59, 
	0xFDBE, 0xFD7E, 0xFE32, 0xD611, 0xD5FC, 0xD5C5, 0xD578, 0xD521, 0xD4CB, 
	0xD43F, 0xD3DC, 0xD3AB, 0xD346, 0xD2EE, 0xD2E5, 0xD36E, 0xD4CB, 0xDCCB, 
	0xE30E, 0xDF6C, 0xD901, 0xD1B3, 0xCB6A, 0xC820, 0xC437, 0xB847, 0xAF72, 
	0xB0DB, 0xB437, 0xB83A, 0xBB97, 0xBCFF, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001E, 0x0001, 0x0001, 0x001F, 0x0001, 0x0020, 0x0001, 
	0x0021, 0x0001, 0x0022, 0x0019, 0x0023, 0x001E, 0x003C, 0x001E, 0x005A, 
	0x0019, 0x0078, 0x0019, 0x0091, 0x001E, 0x00AA, 0x001E, 0x00C8, 0x001E, 
	0x00E6, 0x001E, 0x0104, 0x0001, 0x0122, 0x0001, 0x0123, 0x0001, 0x0124, 
	0x001E, 0x0125, 0x001E, 0x0143, 0x001E, 0x0161, 0x0019, 0x017F, 0x001E, 
	0x0198, 0x001E, 0x01B6, 0x001E, 0x01D4, 0x001E, 0x01F2, 0x001E, 0x0210, 
	0x0001, 0x022E, 0x0001, 0x022F, 0x0001, 0x0230, 0x001E, 0x0231, 0x001E, 
	0x024F, 0x001E, 0x026D, 0x001E, 0x028B, 0x001E, 0x02A9, 0x001E, 0x02C7, 
	0x001E, 0x02E5, 0x001E, 0x0303, 0x001E, 0x0321, 0x001E, 0x033F, 0x001D, 
	0x035D, 0x0001, 0x037A, 0x001E, 0x037B, 0x001E, 0x0399, 0x001E, 0x03B7, 
	0x0004, 0x03D5, 0x001E, 0x03D9, 0x001E, 0x03F7, 0x001E, 0x0415, 0x001E, 
	0x0433, 0x001E, 0x0451, 0x001D, 0x046F, 0x001D, 0x048C, 0x0001, 0x04A9, 
	0x001E, 0x04AA, 0x001E, 0x04C8, 0x001E, 0x04E6, 0x0009, 0x0504, 0x0018, 
	0x050D, 0x001E, 0x0525, 0x001E, 0x0543, 0x001E, 0x0561, 0x001E, 0x057F, 
	

});

smlua_anim_util_register_animation('donkey_8A _ground_bonk',1, 0, 0, 0, 39, { 
	0x0000, 0x0068, 0x006A, 0x006A, 0x0063, 0x005B, 0x0051, 0x0047, 0x003E, 
	0x0034, 0x002E, 0x0029, 0x0027, 0x002A, 0x0032, 0x003A, 0x003D, 0x0033, 
	0x0029, 0x002E, 0x0034, 0x0039, 0x003D, 0x0041, 0x0044, 0x0046, 0x0048, 
	0x0049, 0x004D, 0x0057, 0x0069, 0x007B, 0x0085, 0x0087, 0x0089, 0x008A, 
	0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0280, 0x0258, 0x01FC, 0x0199, 
	0x013A, 0x00CF, 0x005E, 0xFFEF, 0xFF87, 0xFF2E, 0xFEEA, 0xFEC2, 0xFEAD, 
	0xFE9F, 0xFE97, 0xFE95, 0xFE97, 0xFE9F, 0xFEAA, 0xFEB8, 0xFEC8, 0xFEDA, 
	0xFEEE, 0xFF02, 0xFF16, 0xFF29, 0xFF3B, 0xFF4B, 0xFF63, 0xFF8A, 0xFFB6, 
	0xFFDC, 0x0000, 0x0022, 0x0040, 0x005A, 0x006D, 0x007A, 0x007F, 0xFFFF, 
	0x015E, 0x0180, 0x01C4, 0x01F9, 0x0214, 0x022D, 0x0244, 0x0258, 0x026A, 
	0x027A, 0x0287, 0x0291, 0x029A, 0x02A5, 0x02B0, 0x02BC, 0x02C8, 0x02D3, 
	0x02DE, 0x02E7, 0x02EE, 0x02F2, 0x02F4, 0x02F3, 0x02EE, 0x02E4, 0x02D6, 
	0x02C3, 0x0289, 0x021B, 0x0197, 0x011B, 0x00B8, 0x006F, 0x003B, 0x0019, 
	0x0005, 0xFFFB, 0xFFF9, 0xFFFE, 0x5B90, 0x584E, 0x5130, 0x4A2D, 0x441C, 
	0x3D6E, 0x3685, 0x2FBF, 0x297D, 0x241E, 0x2004, 0x1D8D, 0x1C35, 0x1B33, 
	0x1A83, 0x1A20, 0x1A04, 0x1A2A, 0x1A8E, 0x1B2B, 0x1BFC, 0x1CFB, 0x1E24, 
	0x1F72, 0x20E0, 0x2269, 0x2407, 0x25B7, 0x2959, 0x2FAD, 0x36F7, 0x3D7E, 
	0x42FF, 0x4799, 0x4B6A, 0x4E92, 0x512F, 0x5362, 0x554A, 0x5675, 0xF900, 
	0xFA69, 0xFC58, 0xFD6E, 0xFE8E, 0xFFAE, 0x00C6, 0x01CE, 0x02BD, 0x038B, 
	0x042F, 0x04A0, 0x04ED, 0x052C, 0x055D, 0x0581, 0x059A, 0x05A8, 0x05AC, 
	0x05A7, 0x0599, 0x0584, 0x0569, 0x0549, 0x0524, 0x04FB, 0x04CF, 0x04A2, 
	0x042F, 0x035A, 0x025D, 0x0174, 0x011A, 0x00F2, 0x00E7, 0x00E6, 0x00DB, 
	0x00B3, 0x005B, 0x0000, 0x0301, 0x01B6, 0x0045, 0x0003, 0xFFD6, 0xFFB9, 
	0xFFAA, 0xFFA6, 0xFFA7, 0xFFAD, 0xFFB1, 0xFFB3, 0xFFB3, 0xFFB7, 0xFFBD, 
	0xFFC6, 0xFFD0, 0xFFDB, 0xFFE8, 0xFFF4, 0x0000, 0x000B, 0x0015, 0x001D, 
	0x0022, 0x0024, 0x0023, 0x001D, 0xFFFD, 0xFFBB, 0xFF6F, 0xFF2F, 0xFF48, 
	0xFF88, 0xFFE0, 0x0041, 0x0099, 0x00DA, 0x00F3, 0x0000, 0x11DA, 0x0B6E, 
	0x0465, 0x036E, 0x02F1, 0x02D2, 0x02FA, 0x034C, 0x03B1, 0x040E, 0x044A, 
	0x044A, 0x0403, 0x0383, 0x02D7, 0x020C, 0x012D, 0x0048, 0xFF68, 0xFE9B, 
	0xFDED, 0xFD6A, 0xFD1F, 0xFD19, 0xFD63, 0xFE0B, 0xFF1D, 0x00A5, 0x05F2, 
	0x100D, 0x1B9C, 0x2543, 0x242B, 0x2132, 0x1CD2, 0x1784, 0x11BF, 0x0BFD, 
	0x06B7, 0x039F, 0x02D5, 0x04A2, 0x069F, 0x06AD, 0x060E, 0x04AE, 0x02A4, 
	0x0035, 0xFD95, 0xFAFB, 0xF89B, 0xF6AC, 0xF5A8, 0xF590, 0xF5DF, 0xF697, 
	0xF7B6, 0xF8B2, 0xF922, 0xF98C, 0xFA48, 0xFB15, 0xFBEA, 0xFCBC, 0xFD81, 
	0xFE5F, 0xFF2B, 0xFF61, 0xFED8, 0xFDEE, 0xFCE3, 0xFBFB, 0xFC1E, 0xFC79, 
	0xFCF4, 0xFD7B, 0xFDF7, 0xFE51, 0xFE74, 0x0000, 0xFA01, 0xFC31, 0xFE83, 
	0xFDF1, 0xFC7C, 0xFB51, 0xFAA6, 0xF9FA, 0xF960, 0xF8ED, 0xF8B2, 0xF8C5, 
	0xF9FE, 0xFC1D, 0xFD94, 0xFD7B, 0xFCB9, 0xFC79, 0xFDEE, 0xFF8A, 0x0026, 
	0x009A, 0x00EE, 0x012F, 0x0167, 0x018D, 0x0185, 0x013E, 0x00B5, 0x0005, 
	0xFF47, 0xFE91, 0xFE95, 0xFE9F, 0xFEAD, 0xFEBC, 0xFEC9, 0xFED3, 0xFED7, 
	0x0000, 0x1138, 0xFE8E, 0xE913, 0xE817, 0xED85, 0xF507, 0xFCC8, 0x058A, 
	0x0ED0, 0x1821, 0x2100, 0x28F4, 0x2FDE, 0x3505, 0x3700, 0x335B, 0x2C89, 
	0x287E, 0x2DC6, 0x33A2, 0x33A6, 0x32C9, 0x3124, 0x2ECF, 0x2BE0, 0x26CD, 
	0x1FE5, 0x1A09, 0x1636, 0x1320, 0x103C, 0x0CFD, 0x0828, 0x0207, 0xFB57, 
	0xF4DA, 0xEF4B, 0xEB6A, 0xE9F5, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xD16D, 
	0xD16D, 0xD16D, 0xD14A, 0xD0ED, 0xD06A, 0xCFD3, 0xCF3E, 0xCEBD, 0xCE63, 
	0xCE44, 0xCE73, 0xCEDD, 0xCF5F, 0xCFF6, 0xD0A0, 0xD15A, 0xD222, 0xD2F4, 
	0xD3CE, 0xD4AD, 0xD590, 0xD672, 0xD753, 0xD82E, 0xD901, 0xD9CB, 0xDA87, 
	0xDAD6, 0xDAB8, 0xDABA, 0xDB66, 0xE0CA, 0xEB73, 0xF928, 0x07B1, 0x14D3, 
	0x1E55, 0x21FF, 0x1DCC, 0xDE5E, 0xDE5E, 0xDE5E, 0xDE53, 0xDE39, 0xDE1E, 
	0xDE0C, 0xDE12, 0xDE3A, 0xDE92, 0xDF25, 0xE000, 0xE11D, 0xE268, 0xE3DA, 
	0xE56B, 0xE715, 0xE8D0, 0xEA95, 0xEC5E, 0xEE22, 0xEFDB, 0xF182, 0xF30F, 
	0xF47B, 0xF5C0, 0xF6D5, 0xF7B4, 0xF7DB, 0xF6F1, 0xF52C, 0xF2BE, 0xF10B, 
	0xEFE4, 0xEE93, 0xEC5F, 0xE892, 0xE274, 0xD94E, 0xD901, 0x098D, 0x098D, 
	0x098D, 0x09CC, 0x0A6E, 0x0B50, 0x0C4C, 0x0D3D, 0x0DFE, 0x0E6A, 0x0E5C, 
	0x0DB0, 0x0C81, 0x0B0B, 0x0958, 0x0772, 0x0564, 0x0338, 0x00F8, 0xFEAE, 
	0xFC64, 0xFA24, 0xF7FA, 0xF5EE, 0xF40B, 0xF25B, 0xF0E8, 0xEFBD, 0xF058, 
	0xF31D, 0xF672, 0xF8BC, 0xF887, 0xF715, 0xF328, 0xEB83, 0xDEEA, 0xCC1D, 
	0xB1E1, 0xB867, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xD516, 
	0xD516, 0xD516, 0xD4EE, 0xD47C, 0xD3CC, 0xD2E6, 0xD1D7, 0xD0A7, 0xCF62, 
	0xCE11, 0xCCC0, 0xCA3B, 0xC6F3, 0xC568, 0xC789, 0xCB67, 0xCDBF, 0xCAD3, 
	0xC7E2, 0xCB7E, 0xCF95, 0xD093, 0xD0F2, 0xD10B, 0xD13B, 0xD1DA, 0xD345, 
	0xD673, 0xDB31, 0xE01A, 0xE3C7, 0xE3B5, 0xE334, 0xE1D8, 0xDF31, 0xDAD2, 
	0xD44C, 0xCB32, 0xC9F4, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0002, 0x0008, 0x0013, 0x0026, 0x0041, 0x0068, 0x071C, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF97B, 0xF97B, 0xF97B, 0xFA07, 0xFB71, 0xFD60, 0xFF7B, 0x016B, 0x02D5, 
	0x0361, 0x0306, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xEF45, 0xF3B8, 
	0xF9CE, 0x0070, 0x0686, 0x0AF9, 0x0CB3, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0x17D3, 0x17D3, 0x17D3, 0x1855, 0x19B1, 0x1BAA, 0x1E04, 0x2082, 0x22E7, 
	0x24F6, 0x2672, 0x271F, 0x2781, 0x2838, 0x2927, 0x2A38, 0x2B4F, 0x2C54, 
	0x2D2C, 0x2DBF, 0x2DF2, 0x2DAD, 0x2CD5, 0x2B52, 0x2909, 0x25E1, 0x21C1, 
	0x1C8F, 0x0F5F, 0xF77A, 0x5B27, 0x409B, 0x3D45, 0x3BC5, 0x3B5F, 0x3B58, 
	0x3AF2, 0x3972, 0x361C, 0x36DA, 0x500D, 0x500D, 0x500D, 0x5033, 0x5091, 
	0x5106, 0x5175, 0x51BF, 0x51C3, 0x5164, 0x5083, 0x4EFF, 0x4CBE, 0x49CB, 
	0x464A, 0x425C, 0x3E21, 0x39BB, 0x354D, 0x30F6, 0x2CD9, 0x2917, 0x25D2, 
	0x232A, 0x2141, 0x2039, 0x2033, 0x2151, 0x2A47, 0x3D69, 0x2BBF, 0x17A2, 
	0x1AFE, 0x23A7, 0x2F7E, 0x3C65, 0x483C, 0x50E5, 0x5441, 0x54F5, 0xD724, 
	0xD724, 0xD724, 0xD765, 0xD81C, 0xD934, 0xDA99, 0xDC35, 0xDDF5, 0xDFC3, 
	0xE18B, 0xE339, 0xE54B, 0xE82F, 0xEBB4, 0xEFAC, 0xF3E7, 0xF837, 0xFC6C, 
	0x005C, 0x03CD, 0x0697, 0x0889, 0x0974, 0x0929, 0x0779, 0x0435, 0xFF29, 
	0xEDBA, 0xCBE4, 0x2370, 0xFE23, 0x0836, 0x0F6C, 0x1442, 0x1731, 0x18B3, 
	0x1941, 0x1955, 0x175C, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0025, 0x0086, 0x0109, 0x0199, 0x021D, 0x027D, 
	0x02A2, 0xFFFF, 0xDDE6, 0xDDE6, 0xDDE6, 0xDDFD, 0xDE33, 0xDE77, 0xDEB6, 
	0xDEDC, 0xDED8, 0xDE95, 0xDE02, 0xDD0C, 0xD97F, 0xD3C6, 0xCFBD, 0xD196, 
	0xD37F, 0xCF58, 0xC990, 0xC6D2, 0xCD88, 0xD52A, 0xD6D0, 0xD79C, 0xD7DB, 
	0xD7D5, 0xD7D6, 0xD828, 0xD917, 0xDA65, 0xDB92, 0xDC1C, 0xDC11, 0xDBBF, 
	0xDAE2, 0xD934, 0xD66E, 0xD24C, 0xCC87, 0xCB60, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFA42, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0197, 0xEB58, 0xEB58, 0xEB58, 0xEB3D, 
	0xEAF3, 0xEA87, 0xEA05, 0xE979, 0xE8EF, 0xE873, 0xE812, 0xE7D6, 0xE7B0, 
	0xE785, 0xE759, 0xE72C, 0xE701, 0xE6DA, 0xE6B9, 0xE69F, 0xE68F, 0xE68B, 
	0xE695, 0xE6AE, 0xE6D9, 0xE717, 0xE76B, 0xE7D6, 0xE8FB, 0xEB1A, 0xEDA1, 
	0xF001, 0xF362, 0xF7B2, 0xFC67, 0x00FD, 0x04EA, 0x07A8, 0x08B0, 0x0624, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xBF4C, 
	0xBF32, 0xBF22, 0xBF10, 0xBEFF, 0xBEF2, 0xBEEA, 0xBEEA, 0xBEDB, 0xBEE2, 
	0xBF5E, 0xC045, 0xC149, 0xC264, 0xC391, 0xC4C9, 0xC608, 0xC747, 0xC880, 
	0xC9AE, 0xCACC, 0xCBD3, 0xCCBD, 0xCD86, 0xCE26, 0xCE99, 0xCED9, 0xCD89, 
	0xCA27, 0xC5F5, 0xC237, 0xBF5E, 0xBF1C, 0xBF01, 0xBF03, 0xBF18, 0xBF35, 
	0xBF50, 0xBF5E, 0x039B, 0x039B, 0x039B, 0x0588, 0x08CE, 0x09AD, 0x0679, 
	0x00DE, 0xFA18, 0xF076, 0xE5AA, 0xE009, 0xDF41, 0xDEC2, 0xDE86, 0xDE88, 
	0xDEBF, 0x5F29, 0x5FBB, 0x6072, 0x6148, 0x6235, 0xE332, 0xE43D, 0xE54C, 
	0xE65B, 0xE763, 0xE85F, 0xEA6E, 0xEDCD, 0xF11C, 0xF2FA, 0xF4DC, 0xF70D, 
	0xF954, 0xFB7B, 0xFD4A, 0xFE88, 0xFEFF, 0xFE9B, 0xE60C, 0xE60C, 0xE60C, 
	0xE69A, 0xE770, 0xE74E, 0xE4F8, 0xE1AA, 0xDFD9, 0xE166, 0xE470, 0xE5CA, 
	0xE522, 0xE44B, 0xE34C, 0xE22C, 0xE0F3, 0xA056, 0xA1AB, 0xA302, 0xA455, 
	0xA59C, 0xD930, 0xD818, 0xD724, 0xD65A, 0xD5C2, 0xD563, 0xD6D5, 0xDA71, 
	0xDE62, 0xE0D4, 0xE397, 0xE6F5, 0xEA8E, 0xEE02, 0xF0F0, 0xF2F9, 0xF3BC, 
	0xEFF9, 0x7762, 0x7762, 0x7762, 0x73E1, 0x6D43, 0x6961, 0x6AF8, 0x6F4A, 
	0x73FA, 0x795C, 0x7F1B, 0x81E3, 0x81F7, 0x81DF, 0x819F, 0x813A, 0x80B6, 
	0x0016, 0xFF5A, 0xFE8D, 0xFDB0, 0xFCC7, 0x7BD7, 0x7AE2, 0x79ED, 0x78FC, 
	0x7813, 0x7736, 0x7500, 0x71A5, 0x6F91, 0x712D, 0x73A1, 0x760B, 0x784B, 
	0x7A41, 0x7BCF, 0x7CD5, 0x7D33, 0x839E, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x4AB2, 0x4FDF, 0x5396, 0x4FDE, 0x4ADD, 0x450A, 0x3EDE, 
	0x38D0, 0x3358, 0x2D66, 0x27EE, 0x2670, 0x2C7B, 0x367F, 0x3D4F, 0x3CE9, 
	0x394F, 0x374D, 0x3B6A, 0x3F45, 0x3B25, 0x36D3, 0x3691, 0x36C6, 0x3765, 
	0x3861, 0x39AB, 0x3B37, 0x3DA1, 0x4102, 0x448A, 0x4766, 0x483C, 0x48DC, 
	0x4950, 0x499D, 0x49CC, 0x49E4, 0x49ED, 0x49EE, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFF4, 0xFFD5, 0xFFA6, 0xFF6D, 0xFF2D, 0xFEEC, 0xFEAE, 0xFE78, 0xFE4D, 
	0xFE34, 0xFE30, 0xFE47, 0xFE7B, 0xFED3, 0xFF53, 0x0000, 0x0278, 0x0717, 
	0x0BFF, 0x0F4F, 0x0F42, 0x0EE9, 0x0DF5, 0x0C1C, 0x0910, 0x0483, 0xFE29, 
	0xF7AE, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFC, 0xFFF8, 0xFFF4, 0xFFEE, 
	0xFFE9, 0xFFE4, 0xFFE0, 0xFFDC, 0xFFDA, 0xFFDA, 0xFFDC, 0xFFE0, 0xFFE7, 
	0xFFF1, 0xFFFF, 0x003B, 0x00AA, 0x0113, 0x013F, 0x0205, 0x036C, 0x052D, 
	0x0704, 0x08AA, 0x09DA, 0x0A4F, 0x03C6, 0xCBE1, 0xCC87, 0xCB7D, 0xC557, 
	0xBDC6, 0xBAFD, 0xC16F, 0xCCA8, 0xD57F, 0xD915, 0xDA49, 0xDA8B, 0xDAD3, 
	0xDB1F, 0xDB6E, 0xDBBB, 0xDC04, 0xDC45, 0xDC7C, 0xDCA5, 0xDCBD, 0xDCC1, 
	0xDCAE, 0xDC82, 0xDC38, 0xDBCD, 0xDB40, 0xDA8B, 0xD8A1, 0xD4E9, 0xD018, 
	0xCAE1, 0xC77B, 0xC5A9, 0xC46A, 0xC2BB, 0xBF9D, 0xBA0C, 0xB108, 0xAB92, 
	0x0038, 0x0038, 0x0038, 0x0037, 0x0034, 0x002F, 0x002A, 0x0024, 0x001D, 
	0x0013, 0x0007, 0x0000, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 
	0xFFFC, 0xFFFC, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFE, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF3A, 0xBF3A, 0xBF3A, 0xBF3B, 
	0xBF3D, 0xBF3F, 0xBF43, 0xBF47, 0xBF4B, 0xBF51, 0xBF5A, 0xBF5E, 0xBF67, 
	0xBF7D, 0xBF9E, 0xBFC6, 0xBFF2, 0xC01F, 0xC04A, 0xC06F, 0xC08C, 0xC09D, 
	0xC09F, 0xC090, 0xC06B, 0xC02E, 0xBFD5, 0xBF5E, 0xBD6A, 0xB9CE, 0xB654, 
	0xB4C6, 0xB53B, 0xB66E, 0xB820, 0xBA12, 0xBC04, 0xBDB7, 0xBEEA, 0xBF5E, 
	0x13BD, 0x13BD, 0x13BD, 0x0D04, 0x001E, 0xF7F1, 0xF9B5, 0x0032, 0x06A5, 
	0x0C60, 0x1210, 0x14F9, 0x158A, 0x1608, 0x1672, 0x16C6, 0x1703, 0x1727, 
	0x1731, 0x1720, 0x16F3, 0x16A7, 0x163B, 0x15AF, 0x1501, 0x142E, 0x1337, 
	0x1219, 0x0E74, 0x07D1, 0x0114, 0xFD1E, 0xFF34, 0x00B4, 0x01B4, 0x0250, 
	0x02A0, 0x02BD, 0x02C2, 0x01C0, 0x128B, 0x128B, 0x128B, 0x140E, 0x1729, 
	0x19B5, 0x1B0C, 0x1BD5, 0x1BDC, 0x1A95, 0x188D, 0x1733, 0x16AA, 0x1622, 
	0x159C, 0x1519, 0x149A, 0x1422, 0x13B0, 0x1346, 0x12E6, 0x1290, 0x1247, 
	0x120A, 0x11DC, 0x11BE, 0x11B1, 0x11B5, 0x1282, 0x1455, 0x167F, 0x1851, 
	0x184D, 0x1834, 0x17EF, 0x176A, 0x168D, 0x1545, 0x137A, 0x1192, 0x97BF, 
	0x97BF, 0x97BF, 0x8BFC, 0x7543, 0x6676, 0x688F, 0x7290, 0x7C5C, 0x8491, 
	0x8C90, 0x906C, 0x90CA, 0x90F1, 0x90E3, 0x90A6, 0x903E, 0x8FB0, 0x8EFF, 
	0x8E30, 0x8D48, 0x8C4B, 0x8B3D, 0x8A22, 0x8900, 0x87DA, 0x86B4, 0x8594, 
	0x82D4, 0x7E66, 0x7AB9, 0x7A36, 0x7AE4, 0x7CA5, 0x7F0C, 0x81A9, 0x8410, 
	0x85D1, 0x8680, 0x842B, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x4EB6, 0x51B4, 0x52C9, 0x4E65, 0x4912, 0x4318, 
	0x3CC0, 0x3655, 0x301E, 0x28B4, 0x20F8, 0x1CA8, 0x1ECC, 0x245A, 0x27F5, 
	0x26B3, 0x237D, 0x21B5, 0x24BE, 0x283F, 0x26CD, 0x25AF, 0x2763, 0x2947, 
	0x2B7F, 0x2E2E, 0x3178, 0x3583, 0x3B6C, 0x4336, 0x4B58, 0x524C, 0x51F2, 
	0x5105, 0x4FB6, 0x4E36, 0x4CB6, 0x4B68, 0x4A7B, 0x4A21, 0x009A, 0x008C, 
	0x007D, 0x0069, 0x003E, 0x0013, 0xFFED, 0xFFC8, 0xFFAF, 0xFFA9, 0xFFAF, 
	0xFFB5, 0xFFBC, 0xFFCA, 0xFFDD, 0xFFF4, 0x000D, 0x0026, 0x003F, 0x0055, 
	0x0066, 0x0072, 0x0076, 0x0070, 0x0061, 0x0044, 0x001A, 0xFFE0, 0xFEFB, 
	0xFD4F, 0xFB94, 0xFA85, 0xFB46, 0xFD37, 0xFFE0, 0x02C6, 0x056E, 0x075F, 
	0x0820, 0x09D3, 0xFF6C, 0xFF60, 0xFF53, 0xFF4B, 0xFF3C, 0xFF31, 0xFF32, 
	0xFF38, 0xFF3C, 0xFF3D, 0xFF3D, 0xFF3D, 0xFF3B, 0xFF38, 0xFF33, 0xFF2D, 
	0xFF27, 0xFF20, 0xFF1A, 0xFF15, 0xFF10, 0xFF0D, 0xFF0C, 0xFF0E, 0xFF12, 
	0xFF19, 0xFF23, 0xFF31, 0xFFA7, 0x0077, 0x00FA, 0x0086, 0xFFC5, 0xFEF8, 
	0xFE2F, 0xFD78, 0xFCE2, 0xFC7D, 0xFC58, 0xFE32, 0xA903, 0xACAE, 0xB059, 
	0xB46A, 0xBD49, 0xC5F8, 0xCD84, 0xD4DE, 0xD9DD, 0xDB00, 0xD9C7, 0xD883, 
	0xD80D, 0xD7B4, 0xD771, 0xD73C, 0xD710, 0xD6E6, 0xD6B6, 0xD67C, 0xD62F, 
	0xD5CA, 0xD545, 0xD49B, 0xD3C4, 0xD2BB, 0xD177, 0xCFF4, 0xCC72, 0xC637, 
	0xBEC1, 0xB78F, 0xB37F, 0xB1AC, 0xB130, 0xB126, 0xB0AA, 0xAED7, 0xAAC7, 
	0xABC3, 

},{ 
	0x0001, 0x0000, 0x0024, 0x0001, 0x0001, 0x0025, 0x0001, 0x0026, 0x0001, 
	0x0027, 0x0001, 0x0028, 0x0028, 0x0029, 0x0028, 0x0051, 0x0028, 0x0079, 
	0x0028, 0x00A1, 0x0028, 0x00C9, 0x0028, 0x00F1, 0x0028, 0x0119, 0x0028, 
	0x0141, 0x0028, 0x0169, 0x0001, 0x0191, 0x0001, 0x0192, 0x0001, 0x0193, 
	0x0028, 0x0194, 0x0028, 0x01BC, 0x0028, 0x01E4, 0x0026, 0x020C, 0x0028, 
	0x0232, 0x0028, 0x025A, 0x0028, 0x0282, 0x0028, 0x02AA, 0x0028, 0x02D2, 
	0x0001, 0x02FA, 0x0001, 0x02FB, 0x0001, 0x02FC, 0x0028, 0x02FD, 0x0028, 
	0x0325, 0x0028, 0x034D, 0x0028, 0x0375, 0x0028, 0x039D, 0x0028, 0x03C5, 
	0x0028, 0x03ED, 0x0028, 0x0415, 0x0028, 0x043D, 0x0027, 0x0465, 0x0028, 
	0x048C, 0x0028, 0x04B4, 0x0028, 0x04DC, 0x0028, 0x0504, 0x0028, 0x052C, 
	0x000B, 0x0554, 0x0028, 0x055F, 0x0028, 0x0587, 0x0028, 0x05AF, 0x0028, 
	0x05D7, 0x0028, 0x05FF, 0x0025, 0x0627, 0x0028, 0x064C, 0x0028, 0x0674, 
	0x0028, 0x069C, 0x0028, 0x06C4, 0x0028, 0x06EC, 0x000E, 0x0714, 0x0028, 
	0x0722, 0x0028, 0x074A, 0x0028, 0x0772, 0x0028, 0x079A, 0x0028, 0x07C2, 
	

});

smlua_anim_util_register_animation('donkey_93_twirl_land',1, 0, 0, 0, 9, { 
	0x0000, 0x00B0, 0x00AF, 0x00AC, 0x00A7, 0x00A1, 0x009B, 0x0095, 0x0090, 
	0x008D, 0x008B, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFE, 0x3FFF, 
	0x40F5, 0x437F, 0x4715, 0x4B33, 0x4F51, 0x52EA, 0x5577, 0x5673, 0x5675, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFF25, 0xFF61, 0xFFFF, 0x00DF, 0x01DE, 0x02DE, 0x03BD, 0x045B, 0x0497, 
	0x039F, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xF50B, 0xF506, 0xF4E5, 0xF48C, 0xF3DE, 0xF2C0, 0xF114, 0xEEC0, 0xEBA6, 
	0xEE2F, 0xFFFE, 0x0001, 0xC170, 0xBE28, 0xB8AB, 0xA9F5, 0x14A7, 0xFB63, 
	0xE0CB, 0xC780, 0x3225, 0x235A, 0x1DCC, 0xC91B, 0xC924, 0xC95E, 0xB600, 
	0xB4C9, 0xB2C9, 0xAFCC, 0xD45F, 0xD9EB, 0xD901, 0x1220, 0x18D6, 0x2A89, 
	0xC38D, 0xE03C, 0xFCEA, 0x15F1, 0xA7A3, 0xAE59, 0xB867, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xF9E3, 0xF9D0, 0xF948, 0xF7D9, 0xF50D, 0xF071, 0xE991, 
	0xDFF8, 0xD333, 0xC9F4, 0xFF89, 0x0014, 0x0181, 0x0384, 0x05D3, 0x0821, 
	0x0A25, 0x0B91, 0x0C1B, 0x071C, 0xF97F, 0xF9FE, 0xFB4E, 0xFD28, 0xFF48, 
	0x0168, 0x0343, 0x0492, 0x0512, 0x0306, 0xF06E, 0xF11A, 0xF2DF, 0xF55F, 
	0xF83C, 0xFB1A, 0xFD9A, 0xFF5F, 0x000C, 0x0A90, 0xFFFE, 0x0001, 0xC170, 
	0x4ED2, 0x537E, 0xDFCE, 0xF138, 0x052E, 0x1924, 0x2A8E, 0x36DF, 0x3B8B, 
	0x36DA, 0x35F4, 0x3569, 0x4C05, 0x4E0A, 0x505B, 0x52AC, 0x54B2, 0x5620, 
	0x56AB, 0x54F5, 0x1B41, 0x20BF, 0xAF39, 0xC3B2, 0xDB2A, 0xF2A1, 0x071B, 
	0x1596, 0x1B14, 0x175C, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFB1C, 0xFB08, 0xFA7A, 0xF8F8, 
	0xF60A, 0xF135, 0xEA00, 0xDFF0, 0xD28D, 0xCB60, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFA42, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0197, 0xED8B, 
	0xEE2E, 0xEFDC, 0xF23B, 0xF4F3, 0xF7AC, 0xFA0B, 0xFBB9, 0xFC5C, 0x0624, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xBF5E, 0x0040, 0x0040, 0x003E, 0x0038, 0x002E, 0x001D, 
	0x0004, 0xFFDF, 0xFFB0, 0xFE9B, 0x0056, 0xFFD7, 0xFE83, 0xFC8E, 0xFA30, 
	0xF7A0, 0xF515, 0xF2C6, 0xF0E9, 0xEFF9, 0xBCD2, 0xBCB6, 0xBBEE, 0xB9D1, 
	0xB5B3, 0xAEEA, 0xA4CA, 0x96A9, 0x83DB, 0x839E, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x054B, 0x055A, 0x05C0, 0x06D7, 0x08F6, 0x133A, 0x26D5, 0x3B40, 0x47F0, 
	0x49EE, 0xFF9D, 0xFF74, 0xFF0D, 0xFE83, 0xFDF2, 0xFD77, 0xFD2E, 0xFC8A, 
	0xF856, 0xF7AE, 0xFEEF, 0xFEDD, 0xFEAF, 0xFE74, 0xFE39, 0xFE0B, 0xFDF9, 
	0xFF43, 0x008F, 0x03C6, 0xF087, 0xECC9, 0xE348, 0xD698, 0xC951, 0xBE06, 
	0xB74C, 0xB52C, 0xAD71, 0xAB92, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFEE8, 0xFEFB, 
	0xFF2D, 0xFF75, 0xFFC6, 0x0019, 0x0060, 0x0093, 0x00A6, 0x01C0, 0xFF3E, 
	0xFFA6, 0x00BA, 0x023E, 0x03FB, 0x05B8, 0x073D, 0x084F, 0x08B8, 0x1192, 
	0xBC51, 0xBC34, 0xBB63, 0xB92E, 0xB4E2, 0xADCC, 0xA33A, 0x9479, 0x80D8, 
	0x842B, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0640, 0x064D, 
	0x06AB, 0x07AA, 0x099A, 0x13AC, 0x2727, 0x3B7E, 0x4825, 0x4A21, 0x01E6, 
	0x01DE, 0x01CB, 0x01B2, 0x0199, 0x0185, 0x017E, 0x025D, 0x05CA, 0x09D3, 
	0x0166, 0x0191, 0x01FE, 0x028B, 0x0319, 0x0386, 0x03B1, 0x0378, 0x01E6, 
	0xFE32, 0xEF6F, 0xEBC5, 0xE278, 0xD60E, 0xC90E, 0xBE01, 0xB76C, 0xB58D, 
	0xAF75, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x000A, 0x0001, 0x0001, 0x000B, 0x0001, 0x000C, 0x0001, 
	0x000D, 0x0001, 0x000E, 0x000A, 0x000F, 0x000A, 0x0019, 0x000A, 0x0023, 
	0x0008, 0x002D, 0x000A, 0x0035, 0x000A, 0x003F, 0x000A, 0x0049, 0x0007, 
	0x0053, 0x000A, 0x005A, 0x0001, 0x0064, 0x0001, 0x0065, 0x0001, 0x0066, 
	0x000A, 0x0067, 0x000A, 0x0071, 0x000A, 0x007B, 0x000A, 0x0085, 0x0003, 
	0x008F, 0x000A, 0x0092, 0x000A, 0x009C, 0x000A, 0x00A6, 0x000A, 0x00B0, 
	0x0001, 0x00BA, 0x0001, 0x00BB, 0x0001, 0x00BC, 0x000A, 0x00BD, 0x000A, 
	0x00C7, 0x000A, 0x00D1, 0x0001, 0x00DB, 0x000A, 0x00DC, 0x000A, 0x00E6, 
	0x000A, 0x00F0, 0x000A, 0x00FA, 0x000A, 0x0104, 0x000A, 0x010E, 0x000A, 
	0x0118, 0x0001, 0x0122, 0x000A, 0x0123, 0x000A, 0x012D, 0x000A, 0x0137, 
	0x0005, 0x0141, 0x0007, 0x0146, 0x000A, 0x014D, 0x000A, 0x0157, 0x000A, 
	0x0161, 0x000A, 0x016B, 0x000A, 0x0175, 0x000A, 0x017F, 0x0001, 0x0189, 
	0x000A, 0x018A, 0x000A, 0x0194, 0x000A, 0x019E, 0x0005, 0x01A8, 0x000A, 
	0x01AD, 0x000A, 0x01B7, 0x000A, 0x01C1, 0x000A, 0x01CB, 0x000A, 0x01D5, 
	

});

smlua_anim_util_register_animation('donkey_9C_summon_star',1, 0, 0, 0, 63, { 
	0x0000, 0x008B, 0x008C, 0x008E, 0x0091, 0x0095, 0x009B, 0x00A1, 0x00A5, 
	0x00A8, 0x00AA, 0x00AB, 0x00AB, 0x00AB, 0x00AB, 0x00AB, 0x00AB, 0x00AB, 
	0x00AB, 0x00AB, 0x00AA, 0x00A9, 0x00A8, 0x00A7, 0x00A5, 0x00A4, 0x00A1, 
	0x009F, 0x009F, 0x009F, 0x009F, 0x009F, 0x009F, 0x00A0, 0x00A0, 0x00A0, 
	0x00A0, 0x00A1, 0x00A1, 0x00A2, 0x00A2, 0x00A2, 0x00A3, 0x00A3, 0x00A4, 
	0x00A5, 0x00A5, 0x00A6, 0x00A7, 0x00A7, 0x00A8, 0x00A9, 0x00A9, 0x00AA, 
	0x00AA, 0x00AB, 0x00AC, 0x00AE, 0x0000, 0xFFFF, 0xFFFB, 0xFFF5, 0xFFED, 
	0xFFE2, 0xFFD7, 0xFFCF, 0xFFC9, 0xFFC5, 0xFFC4, 0xFFAF, 0xFF9A, 0xFF87, 
	0xFF7A, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF74, 0xFF73, 
	0xFF73, 0xFF72, 0xFF72, 0xFF72, 0xFF71, 0xFF71, 0xFF71, 0xFF71, 0xFF71, 
	0xFF71, 0xFF72, 0xFF72, 0xFF72, 0xFF72, 0xFF72, 0xFF72, 0xFF72, 0xFF72, 
	0xFF72, 0xFF73, 0xFF73, 0xFF73, 0xFF73, 0xFF73, 0xFF73, 0xFF73, 0xFF73, 
	0xFF74, 0xFF74, 0xFF74, 0xFF74, 0xFF75, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 
	0x006A, 0x01A8, 0x03B9, 0x069F, 0x0A58, 0x0E12, 0x10F7, 0x1309, 0x1447, 
	0x14B1, 0x152F, 0x11E0, 0x0A97, 0x034F, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFE, 
	0x5675, 0x5605, 0x54B6, 0x5287, 0x4F79, 0x4B8B, 0x479D, 0x448F, 0x4260, 
	0x4111, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 0x40A1, 
	0x40C2, 0x411C, 0x41A2, 0x4247, 0x42FE, 0x43BB, 0x446F, 0x450F, 0x458C, 
	0x45DA, 0x45ED, 0x45D9, 0x45BD, 0x459A, 0x4570, 0x453F, 0x4509, 0x44CD, 
	0x448C, 0x4447, 0x43FE, 0x43B2, 0x4363, 0x4312, 0x42BF, 0x426A, 0x4215, 
	0x41BF, 0x416A, 0x4115, 0x40C2, 0x4070, 0x4020, 0x3FD3, 0x3F8A, 0x3F44, 
	0x3F02, 0x3EC6, 0x3E8E, 0x3E5C, 0x3E31, 0x3E0C, 0x3DEF, 0x3DD9, 0x3DCB, 
	0x3DC7, 0x0000, 0x0004, 0x000F, 0x0022, 0x003C, 0x005D, 0x007E, 0x0099, 
	0x00AB, 0x00B6, 0x00BA, 0x02C0, 0x02F5, 0x01F0, 0x00A4, 0x0000, 0x0000, 
	0x0000, 0xFFC4, 0xFF4D, 0xFEF4, 0xFF12, 0xFFFF, 0x022B, 0x055B, 0x08F1, 
	0x0C4D, 0x0ECF, 0x0FD7, 0x0FE4, 0x0FE0, 0x0FCD, 0x0FAA, 0x0F7A, 0x0F3C, 
	0x0EF3, 0x0E9E, 0x0E40, 0x0DD8, 0x0D69, 0x0CF2, 0x0C75, 0x0BF3, 0x0B6D, 
	0x0AE4, 0x0A59, 0x09CD, 0x0940, 0x08B5, 0x082B, 0x07A4, 0x0721, 0x06A3, 
	0x062A, 0x05B8, 0x054E, 0x04ED, 0x0496, 0x0449, 0x0408, 0x03D4, 0x03AD, 
	0x0395, 0x038D, 0x0000, 0x0021, 0x0081, 0x0123, 0x0205, 0x0328, 0x044A, 
	0x052C, 0x05CE, 0x062F, 0x064F, 0x065C, 0x052E, 0x0304, 0x00EE, 0x0000, 
	0x0000, 0x0000, 0x000E, 0x002C, 0x0042, 0x003B, 0x0000, 0xFF7A, 0xFEBA, 
	0xFDE1, 0xFD10, 0xFC6B, 0xFC11, 0xFBEA, 0xFBC4, 0xFBA0, 0xFB7D, 0xFB5B, 
	0xFB3B, 0xFB1C, 0xFAFF, 0xFAE3, 0xFAC8, 0xFAAF, 0xFA96, 0xFA7F, 0xFA69, 
	0xFA55, 0xFA41, 0xFA2F, 0xFA1E, 0xFA0E, 0xF9FF, 0xF9F2, 0xF9E5, 0xF9D9, 
	0xF9CF, 0xF9C5, 0xF9BD, 0xF9B5, 0xF9AE, 0xF9A9, 0xF9A4, 0xF9A0, 0xF99D, 
	0xF99B, 0xF99A, 0x039F, 0x0420, 0x05A1, 0x0825, 0x0BA9, 0x102E, 0x14B4, 
	0x1838, 0x1ABB, 0x1C3D, 0x1CBE, 0x1D32, 0x1977, 0x1269, 0x0B94, 0x0884, 
	0x0884, 0x0884, 0x08EE, 0x0A09, 0x0B9F, 0x0D7E, 0x0F6F, 0x11DF, 0x1501, 
	0x1845, 0x1B1E, 0x1CFD, 0x1D55, 0x1CAB, 0x1BE4, 0x1B02, 0x1A07, 0x18F5, 
	0x17CE, 0x1695, 0x154B, 0x13F3, 0x128D, 0x111D, 0x0FA4, 0x0E25, 0x0CA1, 
	0x0B1A, 0x0993, 0x080D, 0x068A, 0x050D, 0x0398, 0x022C, 0x00CB, 0xFF78, 
	0xFE34, 0xFD02, 0xFBE4, 0xFADB, 0xF9EA, 0xF912, 0xF856, 0xF7B8, 0xF739, 
	0xF6DC, 0xF6A3, 0xF68F, 0x0000, 0xFF22, 0xFECC, 0xFDE4, 0xFC8D, 0xFAEE, 
	0xF92B, 0xF76B, 0xF5D1, 0xF484, 0xF3A9, 0xF35E, 0xF529, 0xF934, 0xFD7C, 
	0x0000, 0x005C, 0xFFC4, 0xFE98, 0xFD35, 0xFBFA, 0xFACD, 0xF96C, 0xF7EF, 
	0xF672, 0xF50F, 0xF3E1, 0xF303, 0xF28E, 0xF25A, 0xF22C, 0xF204, 0xF1E2, 
	0xF1C5, 0xF1AD, 0xF19A, 0xF18C, 0xF182, 0xF17C, 0xF179, 0xF17A, 0xF17E, 
	0xF185, 0xF18E, 0xF19A, 0xF1A8, 0xF1B7, 0xF1C8, 0xF1DA, 0xF1ED, 0xF200, 
	0xF214, 0xF228, 0xF23C, 0xF24F, 0xF261, 0xF272, 0xF282, 0xF290, 0xF29C, 
	0xF2A6, 0xF2AE, 0xF2B2, 0xF2B4, 0x0000, 0x00A3, 0x00AC, 0x00B2, 0x00B5, 
	0x00B7, 0x00B9, 0x00BA, 0x00BB, 0x00BE, 0x00C2, 0x00C6, 0x00B2, 0x007F, 
	0x003E, 0x0000, 0xFFBB, 0xFF6A, 0xFF1C, 0xFEE1, 0xFECA, 0xFEDA, 0xFF06, 
	0xFF42, 0xFF84, 0xFFC2, 0xFFF2, 0x000A, 0xFFFF, 0xFFDE, 0xFFB9, 0xFF8F, 
	0xFF62, 0xFF32, 0xFEFF, 0xFEC9, 0xFE90, 0xFE56, 0xFE1A, 0xFDDC, 0xFD9E, 
	0xFD5E, 0xFD1E, 0xFCDE, 0xFC9E, 0xFC5F, 0xFC20, 0xFBE2, 0xFBA5, 0xFB6B, 
	0xFB32, 0xFAFB, 0xFAC7, 0xFA96, 0xFA68, 0xFA3E, 0xFA18, 0xF9F5, 0xF9D7, 
	0xF9BE, 0xF9AA, 0xF99B, 0xF992, 0xF98F, 0xEE2F, 0xED6C, 0xF186, 0xF4B7, 
	0xF71D, 0xF8D5, 0xF9FC, 0xFAAE, 0xFB0A, 0xFB2C, 0xFB31, 0xFC21, 0xFF94, 
	0x05A1, 0x0B45, 0x0D7D, 0x0B3B, 0x0670, 0x0097, 0xFB2A, 0xF7A6, 0xF5DD, 
	0xF494, 0xF3B6, 0xF32C, 0xF2E1, 0xF2BF, 0xF2AE, 0xF29A, 0xF27D, 0xF265, 
	0xF24F, 0xF23C, 0xF22D, 0xF220, 0xF215, 0xF20D, 0xF207, 0xF204, 0xF202, 
	0xF202, 0xF204, 0xF207, 0xF20C, 0xF212, 0xF219, 0xF221, 0xF22A, 0xF233, 
	0xF23D, 0xF247, 0xF251, 0xF25C, 0xF266, 0xF270, 0xF279, 0xF282, 0xF28B, 
	0xF292, 0xF299, 0xF29E, 0xF2A2, 0xF2A4, 0xF2A5, 0x0001, 0xFFFE, 0xC170, 
	0x1DCC, 0x2289, 0x2100, 0x1CE3, 0x16EF, 0x0FE0, 0x0873, 0x0164, 0xFB6F, 
	0xF752, 0xF5C9, 0xF74D, 0xF8BE, 0xF9F5, 0xFACC, 0xFB1C, 0xFB1C, 0xFB1C, 
	0xFBE1, 0xFDFD, 0x0121, 0x04FD, 0x0944, 0x0DA5, 0x11D2, 0x157D, 0x1856, 
	0x1A0E, 0x1A57, 0x19B4, 0x18DD, 0x17D7, 0x16A5, 0x1549, 0x13C8, 0x1225, 
	0x1062, 0x0E84, 0x0C8D, 0x0A82, 0x0865, 0x0639, 0x0402, 0x01C4, 0xFF81, 
	0xFD3D, 0xFAFB, 0xF8BF, 0xF68C, 0xF465, 0xF24E, 0xF049, 0xEE5B, 0xEC86, 
	0xEACE, 0xE936, 0xE7C2, 0xE675, 0xE551, 0xE45C, 0xE397, 0xE306, 0xE2AD, 
	0xE28E, 0xD901, 0xDB1F, 0xDA97, 0xD92B, 0xD71B, 0xD4AA, 0xD219, 0xCFA7, 
	0xCD98, 0xCC2C, 0xCBA4, 0xCDB2, 0xCFA6, 0xD14B, 0xD26E, 0xD2DB, 0xD2DB, 
	0xD2DB, 0xD32E, 0xD412, 0xD56A, 0xD719, 0xD900, 0xDB03, 0xDD04, 0xDEE5, 
	0xE088, 0xE1D1, 0xE2A1, 0xE328, 0xE3AB, 0xE42A, 0xE4A4, 0xE51A, 0xE58C, 
	0xE5F9, 0xE662, 0xE6C6, 0xE727, 0xE783, 0xE7DB, 0xE82F, 0xE87F, 0xE8CA, 
	0xE912, 0xE956, 0xE996, 0xE9D2, 0xEA0A, 0xEA3E, 0xEA6E, 0xEA9B, 0xEAC3, 
	0xEAE8, 0xEB0A, 0xEB27, 0xEB41, 0xEB58, 0xEB6B, 0xEB7A, 0xEB86, 0xEB8F, 
	0xEB94, 0xEB95, 0xB867, 0xB41A, 0xBF73, 0xC849, 0xCEED, 0xD3B0, 0xD6E0, 
	0xD8D0, 0xD9CE, 0xDA2C, 0xDA39, 0xD8A6, 0xD727, 0xD5E5, 0xD506, 0xD4B3, 
	0xD4B3, 0xD4B3, 0xD37A, 0xD023, 0xCB27, 0xC502, 0xBE2E, 0xB726, 0xB065, 
	0xAA65, 0xA5A2, 0xA296, 0xA1BB, 0xA248, 0xA31B, 0xA430, 0xA584, 0xA711, 
	0xA8D3, 0xAAC5, 0xACE3, 0xAF29, 0xB192, 0xB41A, 0xB6BC, 0xB973, 0xBC3C, 
	0xBF11, 0xC1EE, 0xC4D0, 0xC7B0, 0xCA8C, 0xCD5D, 0xD021, 0xD2D2, 0xD56C, 
	0xD7EA, 0xDA48, 0xDC82, 0xDE93, 0xE076, 0xE228, 0xE3A3, 0xE4E3, 0xE5E4, 
	0xE6A0, 0xE715, 0xE73D, 0x0000, 0xFF7E, 0x0000, 0x02F0, 0xC9F4, 0xD0CE, 
	0xD122, 0xD163, 0xD194, 0xD1B8, 0xD1CF, 0xD1DE, 0xD1E5, 0xD1E8, 0xD1E8, 
	0xCFBE, 0xCDB0, 0xCBF3, 0xCAC1, 0xCA4E, 0xCA4E, 0xCA4E, 0xC9C7, 0xC854, 
	0xC62E, 0xC38B, 0xC0A3, 0xBDAC, 0xBADE, 0xB86F, 0xB697, 0xB58D, 0xB587, 
	0xB62B, 0xB6F5, 0xB7E5, 0xB8F6, 0xBA27, 0xBB75, 0xBCDD, 0xBE5C, 0xBFF0, 
	0xC196, 0xC34C, 0xC50F, 0xC6DD, 0xC8B2, 0xCA8C, 0xCC68, 0xCE45, 0xD01F, 
	0xD1F3, 0xD3BF, 0xD581, 0xD735, 0xD8D9, 0xDA6B, 0xDBE8, 0xDD4D, 0xDE97, 
	0xDFC5, 0xE0D3, 0xE1BE, 0xE285, 0xE324, 0xE399, 0xE3E1, 0xE3F9, 0x071C, 
	0x0AA2, 0x0A45, 0x094B, 0x07E0, 0x0633, 0x046F, 0x02C2, 0x0158, 0x005D, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFA5, 
	0xFEAD, 0xFD37, 0xFB66, 0xF95A, 0xF735, 0xF519, 0xF327, 0xF17F, 0xF044, 
	0xEF97, 0xEF41, 0xEEF5, 0xEEB3, 0xEE7A, 0xEE49, 0xEE21, 0xEE00, 0xEDE7, 
	0xEDD5, 0xEDC9, 0xEDC3, 0xEDC3, 0xEDC8, 0xEDD1, 0xEDDF, 0xEDF0, 0xEE04, 
	0xEE1C, 0xEE36, 0xEE51, 0xEE6F, 0xEE8D, 0xEEAC, 0xEECB, 0xEEE9, 0xEF07, 
	0xEF24, 0xEF3F, 0xEF57, 0xEF6E, 0xEF81, 0xEF90, 0xEF9C, 0xEFA4, 0xEFA6, 
	0x0306, 0xFA51, 0xFA49, 0xFA36, 0xFA19, 0xF9F8, 0xF9D4, 0xF9B2, 0xF996, 
	0xF982, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 0xF97B, 
	0xF9CD, 0xFAB0, 0xFC03, 0xFDA6, 0xFF79, 0x015C, 0x032E, 0x04D1, 0x0624, 
	0x0707, 0x0759, 0x0750, 0x0737, 0x070F, 0x06D8, 0x0693, 0x0643, 0x05E6, 
	0x0580, 0x0510, 0x0497, 0x0417, 0x0390, 0x0304, 0x0274, 0x01E0, 0x014A, 
	0x00B2, 0x0019, 0xFF81, 0xFEEB, 0xFE57, 0xFDC7, 0xFD3B, 0xFCB4, 0xFC34, 
	0xFBBC, 0xFB4C, 0xFAE5, 0xFA89, 0xFA38, 0xF9F4, 0xF9BD, 0xF995, 0xF97C, 
	0xF973, 0x0A90, 0x028C, 0x01D4, 0xFFE5, 0xFD19, 0xF9C9, 0xF64D, 0xF2FD, 
	0xF032, 0xEE43, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 0xED8B, 
	0xED8B, 0xED79, 0xED49, 0xED01, 0xECA9, 0xEC47, 0xEBE4, 0xEB86, 0xEB34, 
	0xEAF6, 0xEAD2, 0xEAD0, 0xEAE5, 0xEAFE, 0xEB1C, 0xEB3E, 0xEB64, 0xEB8E, 
	0xEBBB, 0xEBEB, 0xEC1E, 0xEC54, 0xEC8B, 0xECC4, 0xECFE, 0xED3A, 0xED76, 
	0xEDB2, 0xEDEE, 0xEE2A, 0xEE66, 0xEEA0, 0xEED9, 0xEF10, 0xEF46, 0xEF79, 
	0xEFA9, 0xEFD6, 0xF000, 0xF026, 0xF049, 0xF067, 0xF080, 0xF094, 0xF0A3, 
	0xF0AC, 0xF0AF, 0x0001, 0xFFFE, 0xC170, 0x36DA, 0x375B, 0x3B8D, 0xC43A, 
	0xD00E, 0xDDB5, 0xEBDB, 0xF92C, 0x0455, 0x0C00, 0x0EDA, 0x0C21, 0x098B, 
	0x075D, 0x05DB, 0x054B, 0x054B, 0x054B, 0x04F9, 0x0407, 0x027C, 0x005D, 
	0xFDB3, 0xFA82, 0xF6D1, 0xF2A8, 0xEE0D, 0xE905, 0xE398, 0xDD7F, 0xD68B, 
	0x4EE7, 0x46B8, 0x3E27, 0x355E, 0x2C86, 0x23C6, 0x1B47, 0x1332, 0x0BB0, 
	0x04E8, 0xFF00, 0xFA4B, 0xF6E8, 0xF4CA, 0x73E0, 0x741A, 0x7567, 0x77B9, 
	0x7B0C, 0xFF4A, 0x044E, 0x89E1, 0x8FDE, 0x9618, 0x9C64, 0xA296, 0xA882, 
	0xADFD, 0xB2DB, 0xB6F0, 0xBA10, 0xBC10, 0xBCC5, 0x54F5, 0x5665, 0x5665, 
	0x299C, 0x299D, 0x29A0, 0x29A6, 0x29AE, 0x29B9, 0x29C8, 0x29DB, 0x2A6C, 
	0x2AF5, 0x2B69, 0x2BB8, 0x2BD6, 0x2BD6, 0x2BD6, 0x2B8E, 0x2ACA, 0x29A6, 
	0x283E, 0x26B0, 0x2517, 0x2390, 0x2239, 0x212C, 0x2088, 0x2068, 0x20C9, 
	0x2187, 0x5D6C, 0x5C22, 0x5AAA, 0x5915, 0x5772, 0x55D2, 0x5444, 0x52DA, 
	0x51A3, 0x50AE, 0x500D, 0x4FF4, 0x5073, 0x5164, 0x2D5D, 0x2BF8, 0x2A90, 
	0x294D, 0x2811, 0x5952, 0x5AD3, 0x2396, 0x21F4, 0x204E, 0x1EAE, 0x1D1D, 
	0x1BA4, 0x1A4D, 0x191F, 0x1825, 0x1767, 0x16EE, 0x16C4, 0x175C, 0x1713, 
	0x2A68, 0xB976, 0xC4C6, 0xCCE1, 0xD251, 0xD59C, 0xD74E, 0xD7ED, 0xD804, 
	0xD4DE, 0xD1E0, 0xCF5A, 0xCD9B, 0xCCF5, 0xCCF5, 0xCCF5, 0xCC72, 0xCAF8, 
	0xC89C, 0xC573, 0xC191, 0xBD0C, 0xB7F9, 0xB26C, 0xAC7B, 0xA63B, 0x9FC0, 
	0x98C1, 0x90FD, 0x0898, 0xFFB0, 0xF670, 0xECF7, 0xE368, 0xD9E7, 0xD096, 
	0xC798, 0xBF11, 0xB723, 0xAFF1, 0xA981, 0xA3D8, 0x9F1A, 0x1B6C, 0x18F1, 
	0x17CC, 0x1822, 0x19BC, 0x9C2E, 0x9F57, 0x2312, 0x2739, 0x2BA7, 0x303A, 
	0x34CB, 0x3937, 0x3D59, 0x410D, 0x442E, 0x4697, 0x4824, 0x48B0, 0xFFFF, 
	0x01D4, 0xFFFF, 0x0078, 0xCB60, 0xD155, 0xD102, 0xD023, 0xCEE1, 0xCD62, 
	0xCBD0, 0xCA51, 0xC90E, 0xC82F, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 0xC7DC, 
	0xC7DC, 0xC7DC, 0xC7DC, 0xC781, 0xC683, 0xC507, 0xC32D, 0xC118, 0xBEEA, 
	0xBCC4, 0xBAC8, 0xB919, 0xB7D9, 0xB728, 0xB6D9, 0xB6A5, 0xB692, 0xB6A1, 
	0xB6D6, 0xB733, 0xB7BC, 0xB874, 0xB95D, 0xBA7B, 0xBBD1, 0xBD61, 0xBF2F, 
	0xC14D, 0xC3C3, 0xC686, 0xC98A, 0xCCC6, 0xD02D, 0xD3B5, 0xD753, 0xDAFB, 
	0xDEA3, 0xE240, 0xE5C6, 0xE92B, 0xEC63, 0xEF64, 0xF222, 0xF492, 0xF6AA, 
	0xF85D, 0xF9A2, 0xFA6D, 0xFAB4, 0xFA42, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFF9, 0xFFE7, 0xFFCE, 0xFFB3, 0xFF98, 
	0xFF84, 0xFF79, 0xFF7C, 0xFF90, 0xFFBB, 0x0000, 0x005E, 0x00D2, 0x0157, 
	0x01EB, 0x028B, 0x0334, 0x03E2, 0x0493, 0x0543, 0x05F0, 0x0696, 0x0733, 
	0x07C3, 0x0850, 0x08E5, 0x0981, 0x0A23, 0x0AC8, 0x0B70, 0x0C1A, 0x0CC2, 
	0x0D69, 0x0E0D, 0x0EAB, 0x0F44, 0x0FD5, 0x105D, 0x10DA, 0x114B, 0x11AF, 
	0x1204, 0x1249, 0x127C, 0x129B, 0x12A6, 0x0197, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFF0, 0xFFC6, 0xFF8D, 0xFF4E, 
	0xFF12, 0xFEE2, 0xFEC9, 0xFECF, 0xFEFF, 0xFF61, 0xFFFF, 0x00DA, 0x01E5, 
	0x0319, 0x046F, 0x05E1, 0x0766, 0x08F9, 0x0A91, 0x0C28, 0x0DB7, 0x0F37, 
	0x10A1, 0x11ED, 0x1333, 0x148B, 0x15F4, 0x1769, 0x18E8, 0x1A6C, 0x1BF2, 
	0x1D78, 0x1EF9, 0x2073, 0x21E2, 0x2342, 0x2491, 0x25CB, 0x26EC, 0x27F2, 
	0x28D8, 0x299C, 0x2A3B, 0x2AB0, 0x2AF9, 0x2B12, 0x0624, 0x0253, 0x01E0, 
	0x00AD, 0xFEF0, 0xFCE2, 0xFAB8, 0xF8A9, 0xF6ED, 0xF5BA, 0xF548, 0xF548, 
	0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF548, 0xF513, 0xF480, 0xF3A3, 
	0xF290, 0xF15A, 0xF015, 0xEED4, 0xEDAA, 0xECAC, 0xEBEE, 0xEB81, 0xEB59, 
	0xEB56, 0xEB74, 0xEBAD, 0xEBFF, 0xEC63, 0xECD4, 0xED4F, 0xEDCF, 0xEE4F, 
	0xEEC9, 0xEF3B, 0xEF9E, 0xEFFC, 0xF064, 0xF0D2, 0xF147, 0xF1C0, 0xF23D, 
	0xF2BB, 0xF33B, 0xF3BA, 0xF438, 0xF4B3, 0xF52A, 0xF59B, 0xF606, 0xF669, 
	0xF6C3, 0xF712, 0xF756, 0xF78D, 0xF7B6, 0xF7CF, 0xF7D8, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0xFE9B, 0xFF47, 0xFF43, 0xFF29, 0xFEE3, 0xFE5B, 0xFD7B, 0xFC2C, 
	0xFA59, 0xF7EC, 0xF4CE, 0xED5E, 0xE544, 0xDDD5, 0xD865, 0xD649, 0xD649, 
	0xD649, 0xD69C, 0xD781, 0xD8D7, 0xDA80, 0xDC5C, 0xDE4C, 0xE030, 0xE1E8, 
	0xE356, 0xE45B, 0xE4D5, 0xE4FB, 0xE513, 0xE51F, 0xE520, 0xE516, 0xE503, 
	0xE4E6, 0xE4C1, 0xE493, 0xE45F, 0xE424, 0xE3E4, 0xE39E, 0xE354, 0xE306, 
	0xE2B5, 0xE262, 0xE20E, 0xE1B8, 0xE162, 0xE10D, 0xE0B9, 0xE067, 0xE017, 
	0xDFCB, 0xDF83, 0xDF3F, 0xDF01, 0xDEC8, 0xDE97, 0xDE6D, 0xDE4B, 0xDE32, 
	0xDE22, 0xDE1D, 0xEFF9, 0xF564, 0xF52E, 0xF49E, 0xF3C8, 0xF2C3, 0xF1A4, 
	0xF083, 0xEF75, 0xEE91, 0xEDEC, 0xED84, 0xED12, 0xECAA, 0xEC5D, 0xEC40, 
	0xEC40, 0xEC40, 0xEC22, 0xEBD0, 0xEB57, 0xEAC2, 0xEA1E, 0xE976, 0xE8D6, 
	0xE84B, 0xE7E0, 0xE7A2, 0xE79D, 0xE7BC, 0xE7E3, 0xE813, 0xE849, 0xE886, 
	0xE8C9, 0xE911, 0xE95E, 0xE9B0, 0xEA06, 0xEA5F, 0xEABA, 0xEB18, 0xEB78, 
	0xEBD9, 0xEC3A, 0xEC9C, 0xECFD, 0xED5D, 0xEDBB, 0xEE17, 0xEE71, 0xEEC7, 
	0xEF1A, 0xEF68, 0xEFB1, 0xEFF5, 0xF033, 0xF06B, 0xF09B, 0xF0C4, 0xF0E5, 
	0xF0FD, 0xF10C, 0xF111, 0x839E, 0x8168, 0x92C2, 0xA046, 0xAA6E, 0xB1B4, 
	0xB695, 0xB98B, 0xBB10, 0xBB9F, 0xBBB3, 0xBA38, 0xB89A, 0xB71E, 0xB609, 
	0xB59D, 0xB59D, 0xB59D, 0xB51E, 0xB3C1, 0xB1B8, 0xAF35, 0xAC69, 0xA985, 
	0xA6BB, 0xA43C, 0xA23A, 0xA0E7, 0xA073, 0xA08E, 0xA0C2, 0xA110, 0xA175, 
	0xA1EF, 0xA27D, 0xA31D, 0xA3CE, 0xA48D, 0xA55B, 0xA634, 0xA717, 0xA802, 
	0xA8F5, 0xA9ED, 0xAAE9, 0xABE6, 0xACE4, 0xADE1, 0xAEDB, 0xAFD1, 0xB0C1, 
	0xB1A9, 0xB287, 0xB35B, 0xB423, 0xB4DC, 0xB585, 0xB61E, 0xB6A3, 0xB713, 
	0xB76E, 0xB7B0, 0xB7DA, 0xB7E8, 0x0000, 0xFFFF, 0x49EE, 0x4932, 0x46FE, 
	0x4352, 0x3E2E, 0x3792, 0x30F7, 0x2BD3, 0x2827, 0x25F3, 0x2537, 0x2537, 
	0x2537, 0x2537, 0x2537, 0x2537, 0x2537, 0x2537, 0x25C5, 0x2749, 0x298C, 
	0x2C57, 0x2F72, 0x32A4, 0x35B7, 0x3873, 0x3AA0, 0x3C07, 0x3C70, 0x3C36, 
	0x3BDD, 0x3B67, 0x3AD4, 0x3A28, 0x3965, 0x388B, 0x379E, 0x369F, 0x3590, 
	0x3474, 0x334C, 0x321A, 0x30E0, 0x2FA1, 0x2E5D, 0x2D18, 0x2BD3, 0x2A91, 
	0x2952, 0x2819, 0x26E9, 0x25C3, 0x24A9, 0x239D, 0x22A1, 0x21B7, 0x20E1, 
	0x2021, 0x1F7A, 0x1EEC, 0x1E7A, 0x1E27, 0x1DF3, 0x1DE1, 0xF7AE, 0xFA3D, 
	0xFA28, 0xF9EF, 0xF99D, 0xF93C, 0xF8D6, 0xF875, 0xF823, 0xF7EA, 0xF7D5, 
	0xF9D2, 0xFBFD, 0xFDFB, 0xFF6F, 0xFFFF, 0xFFFF, 0xFFFF, 0x0009, 0x0021, 
	0x0045, 0x0072, 0x00A1, 0x00D1, 0x00FD, 0x0122, 0x013A, 0x0143, 0x0138, 
	0x0121, 0x0106, 0x00E7, 0x00C5, 0x00A1, 0x0079, 0x0050, 0x0024, 0xFFF7, 
	0xFFC7, 0xFF97, 0xFF65, 0xFF33, 0xFF00, 0xFECD, 0xFE9A, 0xFE67, 0xFE34, 
	0xFE02, 0xFDD2, 0xFDA2, 0xFD74, 0xFD48, 0xFD1E, 0xFCF6, 0xFCD1, 0xFCAE, 
	0xFC8F, 0xFC73, 0xFC5A, 0xFC46, 0xFC35, 0xFC29, 0xFC22, 0xFC1F, 0x03C6, 
	0xFEC1, 0xFECC, 0xFEEA, 0xFF14, 0xFF46, 0xFF7B, 0xFFAD, 0xFFD7, 0xFFF4, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0001, 
	0x0005, 0x000B, 0x0011, 0x0016, 0x001B, 0x001D, 0x001C, 0x0017, 0x000D, 
	0xFFFC, 0xFFE8, 0xFFD1, 0xFFB9, 0xFF9E, 0xFF83, 0xFF66, 0xFF47, 0xFF28, 
	0xFF08, 0xFEE7, 0xFEC5, 0xFEA3, 0xFE81, 0xFE5E, 0xFE3C, 0xFE19, 0xFDF7, 
	0xFDD6, 0xFDB5, 0xFD95, 0xFD76, 0xFD58, 0xFD3B, 0xFD20, 0xFD06, 0xFCEE, 
	0xFCD7, 0xFCC3, 0xFCB1, 0xFCA2, 0xFC95, 0xFC8A, 0xFC82, 0xFC7E, 0xFC7C, 
	0xAB92, 0xADF8, 0xAFB1, 0xB0AA, 0xB119, 0xB137, 0xB139, 0xB157, 0xB1C7, 
	0xB2C0, 0xB478, 0xB718, 0xB9F5, 0xBC95, 0xBE81, 0xBF3F, 0xBF3F, 0xBF3F, 
	0xBEFE, 0xBE4C, 0xBD42, 0xBBFA, 0xBA8D, 0xB917, 0xB7AF, 0xB670, 0xB573, 
	0xB4D2, 0xB4A7, 0xB4C8, 0xB4F7, 0xB534, 0xB57F, 0xB5D6, 0xB637, 0xB6A4, 
	0xB719, 0xB797, 0xB81C, 0xB8A8, 0xB939, 0xB9CF, 0xBA68, 0xBB04, 0xBBA2, 
	0xBC40, 0xBCDE, 0xBD7B, 0xBE16, 0xBEAE, 0xBF42, 0xBFD0, 0xC059, 0xC0DB, 
	0xC155, 0xC1C6, 0xC22E, 0xC28B, 0xC2DC, 0xC320, 0xC357, 0xC380, 0xC399, 
	0xC3A1, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x01C0, 
	0x013A, 0x01EB, 0x03C4, 0x0672, 0x099E, 0x0CF5, 0x1022, 0x12D0, 0x14A9, 
	0x155A, 0x13DB, 0x1507, 0x177E, 0x19EE, 0x1B09, 0x1B09, 0x1B09, 0x1AD8, 
	0x1A53, 0x198B, 0x1895, 0x1782, 0x1665, 0x1552, 0x145A, 0x1391, 0x130A, 
	0x12D6, 0x12D9, 0x12E4, 0x12F8, 0x1315, 0x1339, 0x1365, 0x1397, 0x13CF, 
	0x140C, 0x144E, 0x1495, 0x14E0, 0x152D, 0x157D, 0x15D0, 0x1623, 0x1678, 
	0x16CD, 0x1722, 0x1776, 0x17C9, 0x181A, 0x1868, 0x18B4, 0x18FB, 0x193F, 
	0x197E, 0x19B8, 0x19EB, 0x1A19, 0x1A3F, 0x1A5E, 0x1A75, 0x1A83, 0x1A87, 
	0x1192, 0x1732, 0x174A, 0x1757, 0x175D, 0x175F, 0x175F, 0x1761, 0x1767, 
	0x1774, 0x178C, 0x1957, 0x180C, 0x1546, 0x1284, 0x1144, 0x1144, 0x1144, 
	0x1165, 0x11BC, 0x123F, 0x12DF, 0x138F, 0x1443, 0x14EE, 0x1581, 0x15F1, 
	0x1631, 0x1632, 0x160C, 0x15DC, 0x15A3, 0x1563, 0x151B, 0x14CC, 0x1477, 
	0x141C, 0x13BD, 0x1359, 0x12F2, 0x1287, 0x121A, 0x11AB, 0x113B, 0x10CA, 
	0x105A, 0x0FEA, 0x0F7B, 0x0F0E, 0x0EA4, 0x0E3D, 0x0DD9, 0x0D7A, 0x0D20, 
	0x0CCC, 0x0C7E, 0x0C36, 0x0BF7, 0x0BBF, 0x0B90, 0x0B6A, 0x0B4F, 0x0B3E, 
	0x0B38, 0x842B, 0x82C4, 0x8BCE, 0x92D9, 0x9824, 0x9BEE, 0x9E79, 0xA003, 
	0xA0CE, 0xA119, 0xA123, 0x9E10, 0xA05C, 0xA53C, 0xAA12, 0xAC43, 0xAC43, 
	0xAC43, 0xABD2, 0xAA9B, 0xA8CD, 0xA694, 0xA41C, 0xA192, 0x9F24, 0x9CFE, 
	0x9B4D, 0x9A3D, 0x99FC, 0x9A3F, 0x9A9D, 0x9B15, 0x9BA4, 0x9C49, 0x9D02, 
	0x9DCE, 0x9EAA, 0x9F95, 0xA08D, 0xA191, 0xA29F, 0xA3B4, 0xA4D0, 0xA5F0, 
	0xA713, 0xA838, 0xA95B, 0xAA7C, 0xAB9A, 0xACB1, 0xADC0, 0xAEC7, 0xAFC2, 
	0xB0B1, 0xB191, 0xB261, 0xB31E, 0xB3C9, 0xB45D, 0xB4DB, 0xB540, 0xB58A, 
	0xB5B7, 0xB5C7, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x4A21, 0x497C, 0x478E, 0x4457, 0x3FD7, 
	0x3A0D, 0x3443, 0x2FC3, 0x2C8B, 0x2A9D, 0x29F9, 0x3107, 0x2EBE, 0x283A, 
	0x216E, 0x1E4A, 0x1EA0, 0x1F8D, 0x20EE, 0x22A0, 0x2481, 0x2670, 0x28CB, 
	0x2BC9, 0x2F0A, 0x322E, 0x34D4, 0x369B, 0x3724, 0x36E1, 0x3685, 0x3612, 
	0x358B, 0x34EF, 0x3442, 0x3384, 0x32B7, 0x31DD, 0x30F6, 0x3006, 0x2F0D, 
	0x2E0D, 0x2D08, 0x2BFE, 0x2AF2, 0x29E6, 0x28DA, 0x27D0, 0x26CA, 0x25CA, 
	0x24D1, 0x23E1, 0x22FB, 0x2220, 0x2153, 0x2095, 0x1FE7, 0x1F4C, 0x1EC4, 
	0x1E51, 0x1DF5, 0x1DB1, 0x1D87, 0x1D79, 0x09D3, 0x0A88, 0x0A84, 0x0A6A, 
	0x0A24, 0x099A, 0x08B7, 0x0765, 0x058D, 0x0319, 0xFFF2, 0x0000, 0x0003, 
	0x0002, 0x0001, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 
	0xFFFA, 0xFFF8, 0xFFF7, 0xFFF5, 0xFFF4, 0xFFF2, 0xFFF2, 0xFFF1, 0xFFF0, 
	0xFFF0, 0xFFEF, 0xFFEF, 0xFFEE, 0xFFEE, 0xFFED, 0xFFEC, 0xFFEC, 0xFFEB, 
	0xFFEB, 0xFFEA, 0xFFEA, 0xFFEA, 0xFFE9, 0xFFE9, 0xFFE8, 0xFFE8, 0xFFE8, 
	0xFFE7, 0xFFE7, 0xFFE7, 0xFFE6, 0xFFE6, 0xFFE6, 0xFFE5, 0xFE32, 0xFBF2, 
	0xFCE9, 0xFDA9, 0xFE3A, 0xFEA2, 0xFEE7, 0xFF11, 0xFF27, 0xFF2F, 0xFF30, 
	0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF31, 0xFF38, 
	0xFF42, 0xFF4F, 0xFF5D, 0xFF6B, 0xFF7A, 0xFF87, 0xFF93, 0xFF9B, 0xFFA0, 
	0xFFA2, 0xFFA4, 0xFFA6, 0xFFA8, 0xFFA9, 0xFFAA, 0xFFAB, 0xFFAC, 0xFFAD, 
	0xFFAD, 0xFFAE, 0xFFAE, 0xFFAE, 0xFFAE, 0xFFAD, 0xFFAD, 0xFFAD, 0xFFAC, 
	0xFFAB, 0xFFAB, 0xFFAA, 0xFFA9, 0xFFA9, 0xFFA8, 0xFFA7, 0xFFA7, 0xFFA6, 
	0xFFA5, 0xFFA5, 0xFFA4, 0xFFA4, 0xFFA3, 0xABC3, 0xAE29, 0xB72D, 0xBE32, 
	0xC379, 0xC741, 0xC9CA, 0xCB53, 0xCC1D, 0xCC68, 0xCC72, 0xC9D7, 0xC938, 
	0xC949, 0xC9A2, 0xC9D7, 0xC9D7, 0xC9D7, 0xC992, 0xC8D2, 0xC7B4, 0xC650, 
	0xC4C1, 0xC321, 0xC18B, 0xC018, 0xBEE3, 0xBE06, 0xBD9B, 0xBD77, 0xBD5E, 
	0xBD4E, 0xBD48, 0xBD4A, 0xBD54, 0xBD66, 0xBD7E, 0xBD9D, 0xBDC2, 0xBDEC, 
	0xBE1B, 0xBE4E, 0xBE85, 0xBEBF, 0xBEFC, 0xBF3A, 0xBF7A, 0xBFBB, 0xBFFC, 
	0xC03D, 0xC07D, 0xC0BB, 0xC0F8, 0xC133, 0xC16B, 0xC19F, 0xC1CF, 0xC1FA, 
	0xC220, 0xC241, 0xC25B, 0xC26F, 0xC27B, 0xC27F, 

},{ 
	0x0001, 0x0000, 0x0039, 0x0001, 0x0037, 0x003A, 0x0001, 0x0071, 0x0001, 
	0x0072, 0x0001, 0x0073, 0x003F, 0x0074, 0x0001, 0x00B3, 0x0040, 0x00B4, 
	0x0040, 0x00F4, 0x003F, 0x0134, 0x0040, 0x0173, 0x0040, 0x01B3, 0x0040, 
	0x01F3, 0x0040, 0x0233, 0x0001, 0x0273, 0x0001, 0x0274, 0x0001, 0x0275, 
	0x0040, 0x0276, 0x0040, 0x02B6, 0x0040, 0x02F6, 0x0002, 0x0336, 0x0002, 
	0x0338, 0x0040, 0x033A, 0x0040, 0x037A, 0x0040, 0x03BA, 0x0040, 0x03FA, 
	0x0001, 0x043A, 0x0001, 0x043B, 0x0001, 0x043C, 0x0040, 0x043D, 0x0040, 
	0x047D, 0x0040, 0x04BD, 0x0002, 0x04FD, 0x0002, 0x04FF, 0x0040, 0x0501, 
	0x0040, 0x0541, 0x0040, 0x0581, 0x0040, 0x05C1, 0x0040, 0x0601, 0x0040, 
	0x0641, 0x0001, 0x0681, 0x0040, 0x0682, 0x0040, 0x06C2, 0x0040, 0x0702, 
	0x0001, 0x0742, 0x0001, 0x0743, 0x0040, 0x0744, 0x0040, 0x0784, 0x0040, 
	0x07C4, 0x0040, 0x0804, 0x0035, 0x0844, 0x0010, 0x0879, 0x0001, 0x0889, 
	0x0040, 0x088A, 0x0040, 0x08CA, 0x0040, 0x090A, 0x0001, 0x094A, 0x002E, 
	0x094B, 0x0040, 0x0979, 0x0038, 0x09B9, 0x003D, 0x09F1, 0x0040, 0x0A2E, 
	

});

smlua_anim_util_register_animation('donkey_B9_heavy_throw',1, 0, 0, 0, 24, { 
	0xFFF4, 0xFFF4, 0xFFF4, 0xFFF4, 0xFFF3, 0xFFF2, 0xFFF1, 0xFFEF, 0xFFED, 
	0xFFED, 0xFFF0, 0xFFF5, 0xFFFB, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
	0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0x0000, 0x009C, 0x009D, 0x009D, 0x009E, 
	0x009F, 0x00A0, 0x00A2, 0x00A3, 0x00A5, 0x00A6, 0x00A8, 0x00AA, 0x00AB, 
	0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00AF, 0x00AC, 0x00A6, 0x009D, 0x0096, 
	0x0090, 0x008C, 0x008B, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 
	0x0023, 0x0022, 0x0022, 0x0024, 0x0027, 0x002D, 0x0032, 0x0033, 0x0030, 
	0x002A, 0x0024, 0x001D, 0x0012, 0x0008, 0x0003, 0x0006, 0x0005, 0x0002, 
	0x0000, 0x0000, 0x3FFF, 0x0000, 0xF3D8, 0xF361, 0xF21E, 0xF047, 0xEE0F, 
	0xEBAC, 0xE953, 0xE73A, 0xE596, 0xE49D, 0xE529, 0xE74C, 0xEA0B, 0xEC69, 
	0xEE67, 0xF09B, 0xF2EF, 0xF54E, 0xF7D2, 0xFA59, 0xFCAD, 0xFE99, 0xFFE7, 
	0x0064, 0xFFFF, 0x04C2, 0x051E, 0x0619, 0x078A, 0x094A, 0x0B33, 0x0D1E, 
	0x0EE2, 0x1059, 0x115B, 0x1181, 0x10C3, 0x0F8B, 0x0E42, 0x0CF4, 0x0B71, 
	0x09CA, 0x0811, 0x066D, 0x04EC, 0x038F, 0x025B, 0x0152, 0x0078, 0xFFFE, 
	0x4630, 0x45A3, 0x442F, 0x421F, 0x3FBC, 0x3D51, 0x3B29, 0x398F, 0x38CC, 
	0x392C, 0x3DCE, 0x46B2, 0x4F73, 0x53AF, 0x53A8, 0x52B3, 0x5101, 0x4EC6, 
	0x4F0B, 0x4FC9, 0x50E6, 0x5246, 0x53D0, 0x5568, 0x5675, 0xF9E4, 0xF9CB, 
	0xF98D, 0xF939, 0xF8E2, 0xF898, 0xF86C, 0xF871, 0xF8B6, 0xF94D, 0xFA47, 
	0xFE74, 0x0531, 0x0966, 0x083B, 0x0498, 0x0204, 0x0143, 0x00E3, 0x0088, 
	0x0037, 0xFFF6, 0xFFCC, 0xFFBD, 0x0000, 0xFF98, 0xFFCD, 0x0057, 0x011C, 
	0x0201, 0x02E8, 0x03B9, 0x0455, 0x04A3, 0x0486, 0x03E4, 0xFFC2, 0xF899, 
	0xF37A, 0xF27F, 0xF36C, 0xF4D3, 0xF632, 0xF7F5, 0xFA02, 0xFC15, 0xFDE6, 
	0xFF31, 0xFFAE, 0x0000, 0xDBAD, 0xDB57, 0xDA79, 0xD94A, 0xD801, 0xD6D5, 
	0xD5FE, 0xD5B2, 0xD629, 0xD799, 0xDA3A, 0xE4B0, 0xF6CB, 0x0681, 0x120A, 
	0x1BCD, 0x2004, 0x1F27, 0x1CEB, 0x199F, 0x1585, 0x10DD, 0x0BE7, 0x06E4, 
	0x039F, 0x3A73, 0x3ACA, 0x3BAE, 0x3CE8, 0x3E46, 0x3F93, 0x4099, 0x4125, 
	0x4102, 0x3FFC, 0x3DDD, 0x3A73, 0x2188, 0x04B7, 0xFD30, 0xFBA2, 0xFBC5, 
	0xFB9E, 0xFBE8, 0xFCA0, 0xFD8F, 0xFE7E, 0xFF36, 0xFF80, 0x0000, 0x020F, 
	0x020C, 0x0203, 0x01F8, 0x01EA, 0x01DE, 0x01D4, 0x01CE, 0x01D0, 0x01DA, 
	0x01EE, 0x020F, 0x032D, 0x0418, 0x0338, 0x01C6, 0x00CE, 0x007B, 0x003C, 
	0xFFF2, 0xFFA8, 0xFF68, 0xFF3A, 0xFF28, 0x0000, 0xFD2D, 0xFD46, 0xFD87, 
	0xFDE1, 0xFE46, 0xFEA5, 0xFEF0, 0xFF18, 0xFF0E, 0xFEC3, 0xFE27, 0xFD2D, 
	0xF692, 0xEDC8, 0xE774, 0xE1C4, 0xE00B, 0xE24C, 0xE50E, 0xE710, 0xE870, 
	0xE948, 0xE9B5, 0xE9D4, 0xEE2F, 0x0001, 0xFFFE, 0xCACF, 0xCACF, 0xCACF, 
	0xCACF, 0xCACF, 0xCACF, 0xCACF, 0xCACF, 0xCACF, 0xCACF, 0xCACF, 0xCACF, 
	0xCA3D, 0xC90C, 0xC7FE, 0xC736, 0xC65E, 0xC57F, 0xC4A0, 0xC3CB, 0xC30A, 
	0xC264, 0xC1E2, 0xC18E, 0xC170, 0x97E8, 0x97E8, 0x97E8, 0x97E8, 0x97E8, 
	0x97E8, 0x97E8, 0x97E8, 0x97E8, 0x97E8, 0x97E8, 0x97E8, 0x1FF9, 0x2DC7, 
	0x31C3, 0x200B, 0x0481, 0xF338, 0x0653, 0x1321, 0x1AE5, 0x1EE2, 0x205B, 
	0x2090, 0x1DCC, 0xB54D, 0xB54D, 0xB54D, 0xB54D, 0xB54D, 0xB54D, 0xB54D, 
	0xB54D, 0xB54D, 0xB54D, 0xB54D, 0xB54D, 0xD1FF, 0xE055, 0xEA58, 0xEAC9, 
	0xE6E6, 0xE310, 0xE11C, 0xE040, 0xDFBF, 0xDEDC, 0xDCDB, 0xD8FE, 0xD901, 
	0xF622, 0xF622, 0xF622, 0xF622, 0xF622, 0xF622, 0xF622, 0xF622, 0xF622, 
	0xF622, 0xF622, 0xF622, 0x700B, 0x6741, 0x6A00, 0x854D, 0xAC21, 0xC5B2, 
	0xC59C, 0xC4FE, 0xC353, 0xC012, 0xBAB5, 0xB2B6, 0xB867, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xEC1F, 0xEC1F, 0xEC1F, 
	0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 0xEC1F, 
	0xF15D, 0xFA99, 0xFE12, 0xFA79, 0xF54B, 0xEEFE, 0xEAFD, 0xE8DC, 0xE6C8, 
	0xE2EF, 0xDB7D, 0xCEA0, 0xC9F4, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 
	0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE7CD, 0xE944, 0xEC58, 
	0xEF13, 0xF116, 0xF343, 0xF585, 0xF92E, 0xFDFA, 0x031E, 0x07C9, 0x0B2D, 
	0x0C7C, 0x071C, 0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 
	0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 0xF983, 0xF982, 0xF981, 0xF980, 
	0xF97F, 0xF97E, 0xFA19, 0xFB9B, 0xFD91, 0xFF87, 0x010A, 0x01A4, 0x0306, 
	0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 0xE96A, 
	0xE96A, 0xE96A, 0xE96A, 0xE9AA, 0xEA30, 0xEAA8, 0xEAFF, 0xEB5F, 0xEBC1, 
	0xEE96, 0xF3E4, 0xFA57, 0x009A, 0x0555, 0x0735, 0x0A90, 0x0001, 0xFFFE, 
	0xC170, 0xEE03, 0xEE03, 0xEE03, 0xEE03, 0xEE03, 0xEE03, 0xEE03, 0xEE03, 
	0xEE03, 0xEE03, 0xEE03, 0xEE03, 0xEC7C, 0xE99B, 0xE7ED, 0xE99A, 0xECDD, 
	0xF02A, 0xEFE8, 0xEE1A, 0xE932, 0xDFA6, 0xCFE8, 0x386D, 0x36DA, 0x132B, 
	0x132B, 0x132B, 0x132B, 0x132B, 0x132B, 0x132B, 0x132B, 0x132B, 0x132B, 
	0x132B, 0x132B, 0x114C, 0x0EC2, 0x102D, 0x1E8D, 0x2BD8, 0x2DF6, 0x2DF5, 
	0x2DF1, 0x2DE5, 0x2DCF, 0x2DAA, 0x528D, 0x54F5, 0x7137, 0x7137, 0x7137, 
	0x7137, 0x7137, 0x7137, 0x7137, 0x7137, 0x7137, 0x7137, 0x7137, 0x7137, 
	0x6F66, 0x6E16, 0x7380, 0x8DFA, 0xA77D, 0xAFF2, 0xAFD2, 0xAEF2, 0xAC92, 
	0xA7F1, 0xA050, 0x14F0, 0x175C, 0x0000, 0x020D, 0x07E8, 0x1119, 0x1D2D, 
	0x2BAE, 0x3C27, 0x4E22, 0x612A, 0x74CA, 0x888C, 0x9BFC, 0xAEA4, 0xC00E, 
	0xCFC6, 0xDD56, 0xE849, 0xF02A, 0xF561, 0xF8E0, 0xFAFF, 0xFC15, 0xFC7C, 
	0xFC8B, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFE2, 0xFF98, 0xFF38, 0xFED8, 0xFE8F, 0xFE71, 0xFFFF, 
	0xF09B, 0xF09B, 0xF09B, 0xF09B, 0xF09B, 0xF09B, 0xF09B, 0xF09B, 0xF09B, 
	0xF09B, 0xF09B, 0xF09B, 0xF387, 0xF859, 0xF923, 0xF52C, 0xEFEC, 0xE9CC, 
	0xE5E6, 0xE3B4, 0xE155, 0xDCE7, 0xD489, 0xC65A, 0xCB60, 0x0ACF, 0x0ACF, 
	0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 0x0ACF, 
	0x0ACF, 0x0A28, 0x08C8, 0x0790, 0x06A9, 0x05B0, 0x04AE, 0x0410, 0x03AF, 
	0x0339, 0x025A, 0x00C0, 0xFE17, 0xFA42, 0x020D, 0x020D, 0x020D, 0x020D, 
	0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x020D, 0x01ED, 
	0x01AA, 0x016F, 0x0143, 0x0114, 0x00E3, 0x0082, 0xFFF7, 0xFF5F, 0xFED2, 
	0xFE6A, 0xFE42, 0x0197, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 
	0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 0xEDD1, 0xEE44, 0xEF38, 0xF00F, 
	0xF0AE, 0xF15A, 0xF20C, 0xF4C6, 0xF948, 0xFE8D, 0x0393, 0x0754, 0x08CE, 
	0x0624, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0xE384, 0xE3A7, 
	0xE406, 0xE491, 0xE53A, 0xE5F2, 0xE6A9, 0xE750, 0xE7D8, 0xE832, 0xE75A, 
	0xE62E, 0xE666, 0xE685, 0xE5A6, 0xE46D, 0xE31D, 0xE1CD, 0xE38D, 0xE7EC, 
	0xED9B, 0xF34A, 0xF7A9, 0xF969, 0xFE9B, 0xEDF4, 0xEDBD, 0xED2B, 0xEC58, 
	0xEB5E, 0xEA57, 0xE95F, 0xE88F, 0xE803, 0xE7D3, 0xEA9B, 0xEE50, 0xEF10, 
	0xEF58, 0xF081, 0xF1DA, 0xF304, 0xF424, 0xF41B, 0xF3DF, 0xF33B, 0xF1FD, 
	0xEFEF, 0xECDF, 0xEFF9, 0xA3FC, 0xA3B3, 0xA2EF, 0xA1CF, 0xA074, 0x9EFE, 
	0x9D8D, 0x9C41, 0x9B3A, 0x9A98, 0x9CC6, 0x9FAE, 0x9F29, 0x9ED4, 0xA0F0, 
	0xA3DE, 0xA6D4, 0xA9C0, 0xA991, 0xA844, 0xA4BB, 0x9DDA, 0x9283, 0x8197, 
	0x839E, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x2395, 0x25E4, 0x2B5D, 0x31D3, 0x3719, 0x3901, 
	0x35DB, 0x2EF1, 0x2696, 0x1F1A, 0x1796, 0x135B, 0x19F9, 0x2053, 0x1C96, 
	0x15DE, 0x1239, 0x152C, 0x1BFA, 0x2506, 0x2F1D, 0x390C, 0x41A0, 0x47A7, 
	0x49EE, 0x0019, 0x0029, 0x0050, 0x0082, 0x00B5, 0x00DB, 0x00EB, 0x00D8, 
	0x0096, 0x0019, 0xFD1C, 0xF957, 0xF994, 0xF98F, 0xF93E, 0xF966, 0xF9F0, 
	0xFB26, 0xFA5B, 0xF89D, 0xF6DF, 0xF614, 0xF8FF, 0xFBEB, 0xF7AE, 0x0141, 
	0x013B, 0x012D, 0x011A, 0x0107, 0x00F8, 0x00F2, 0x00FA, 0x0112, 0x0141, 
	0x0248, 0x03CB, 0x04DD, 0x0411, 0x0446, 0x0527, 0x057B, 0x0437, 0x0275, 
	0x0102, 0x0007, 0xFFA9, 0xFFDD, 0x0147, 0x03C6, 0xC821, 0xC826, 0xC831, 
	0xC841, 0xC850, 0xC85C, 0xC861, 0xC85B, 0xC847, 0xC821, 0xC705, 0xC610, 
	0xC87A, 0xC161, 0xC22E, 0xC83F, 0xCC52, 0xC977, 0xC14D, 0xB6DB, 0xADDB, 
	0xAA07, 0xAEF3, 0xB3DF, 0xAB92, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xBF5E, 0x07D3, 0x0761, 0x0633, 0x0487, 0x0299, 0x00A5, 0xFEE8, 0xFDA0, 
	0xFD08, 0xFD5E, 0x00E7, 0x07BD, 0x0EDB, 0x133D, 0x1515, 0x169D, 0x17DB, 
	0x18D7, 0x17EE, 0x1579, 0x11E4, 0x0D98, 0x08FF, 0x0484, 0x01C0, 0x09FE, 
	0x0A73, 0x0BB0, 0x0D85, 0x0FBF, 0x122D, 0x149F, 0x16E3, 0x18C8, 0x1A1B, 
	0x1A3E, 0x1935, 0x17C8, 0x16BB, 0x161C, 0x1574, 0x14C8, 0x141E, 0x13E0, 
	0x13C9, 0x13C6, 0x13C3, 0x13AC, 0x136E, 0x1192, 0xB8CB, 0xB858, 0xB71D, 
	0xB54A, 0xB30D, 0xB096, 0xAE15, 0xABB7, 0xA9AC, 0xA823, 0xA787, 0xA7CC, 
	0xA871, 0xA8F4, 0xA943, 0xA99E, 0xAA00, 0xAA67, 0xAA38, 0xA8F0, 0xA575, 
	0x9EAE, 0x9380, 0x82D4, 0x842B, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x2670, 
	0x270E, 0x28B1, 0x2B04, 0x2DB5, 0x306E, 0x32DC, 0x34AA, 0x3586, 0x351A, 
	0x3012, 0x265E, 0x1C91, 0x1740, 0x1623, 0x15CB, 0x1615, 0x16DC, 0x1B63, 
	0x235D, 0x2D49, 0x37A3, 0x40E7, 0x4792, 0x4A21, 0x0791, 0x0791, 0x0790, 
	0x078F, 0x078F, 0x078F, 0x0753, 0x06EF, 0x06DB, 0x0791, 0x09F1, 0x0D7C, 
	0x1095, 0x11A0, 0x100B, 0x0CEA, 0x091E, 0x0589, 0x06A7, 0x091B, 0x0B8F, 
	0x0CAD, 0x098D, 0x066E, 0x09D3, 0xFFE6, 0xFFDE, 0xFFCB, 0xFFB4, 0xFFA1, 
	0xFF99, 0xFFCF, 0x002E, 0x0056, 0xFFE6, 0xFE60, 0xFC19, 0xF9EC, 0xF8B3, 
	0xF8A3, 0xF932, 0xFA1A, 0xFB15, 0xFB98, 0xFBC3, 0xFBEF, 0xFC72, 0xFD69, 
	0xFDF9, 0xFE32, 0xAA56, 0xAA81, 0xAAE6, 0xAB60, 0xABC5, 0xABF0, 0xAB3F, 
	0xA9F6, 0xA943, 0xAA56, 0xAE43, 0xB427, 0xBA3F, 0xBEC7, 0xC163, 0xC319, 
	0xC43B, 0xC517, 0xC106, 0xB812, 0xAF1F, 0xAB0D, 0xAE75, 0xB1DE, 0xABC3, 
	

},{ 
	0x0017, 0x0000, 0x0019, 0x0017, 0x0019, 0x0030, 0x0001, 0x0049, 0x0001, 
	0x004A, 0x0001, 0x004B, 0x0019, 0x004C, 0x0019, 0x0065, 0x0019, 0x007E, 
	0x0019, 0x0097, 0x0019, 0x00B0, 0x0019, 0x00C9, 0x0019, 0x00E2, 0x0019, 
	0x00FB, 0x0019, 0x0114, 0x0001, 0x012D, 0x0001, 0x012E, 0x0019, 0x012F, 
	0x0019, 0x0148, 0x0019, 0x0161, 0x0019, 0x017A, 0x0015, 0x0193, 0x0017, 
	0x01A8, 0x0019, 0x01BF, 0x0019, 0x01D8, 0x0019, 0x01F1, 0x0019, 0x020A, 
	0x0001, 0x0223, 0x0001, 0x0224, 0x0001, 0x0225, 0x0019, 0x0226, 0x0019, 
	0x023F, 0x0019, 0x0258, 0x0019, 0x0271, 0x0019, 0x028A, 0x0019, 0x02A3, 
	0x0019, 0x02BC, 0x0019, 0x02D5, 0x0019, 0x02EE, 0x0019, 0x0307, 0x0019, 
	0x0320, 0x0001, 0x0339, 0x0019, 0x033A, 0x0019, 0x0353, 0x0019, 0x036C, 
	0x0004, 0x0385, 0x0019, 0x0389, 0x0019, 0x03A2, 0x0019, 0x03BB, 0x0019, 
	0x03D4, 0x0019, 0x03ED, 0x0019, 0x0406, 0x0019, 0x041F, 0x0001, 0x0438, 
	0x0019, 0x0439, 0x0019, 0x0452, 0x0019, 0x046B, 0x0008, 0x0484, 0x0017, 
	0x048C, 0x0019, 0x04A3, 0x0019, 0x04BC, 0x0019, 0x04D5, 0x0019, 0x04EE, 
	

});

smlua_anim_util_register_animation('donkey_B7_release_bowser',1, 0, 0, 0, 39, { 
	0x0000, 0x0046, 0x0047, 0x0048, 0x004A, 0x0049, 0x0048, 0x0044, 0x003E, 
	0x0034, 0x0025, 0x002C, 0x0033, 0x0039, 0x003B, 0x0038, 0x0033, 0x0034, 
	0x0035, 0x0036, 0x0037, 0x0038, 0x0036, 0x0034, 0x0032, 0x0033, 0x0039, 
	0x0051, 0x006F, 0x007E, 0x0084, 0x0085, 0x0085, 0x0086, 0x0087, 0x0088, 
	0x0089, 0x008A, 0x008B, 0xFFB8, 0xFFB9, 0xFFBC, 0xFFBF, 0xFFC1, 0xFFC2, 
	0xFFC2, 0xFFC3, 0xFFC3, 0xFFC3, 0xFFC3, 0xFFC4, 0xFFC4, 0xFFC4, 0xFFC4, 
	0xFFC5, 0xFFC5, 0xFFC6, 0xFFC6, 0xFFC6, 0xFFC6, 0xFFC6, 0xFFC7, 0xFFC7, 
	0xFFC8, 0xFFC9, 0xFFCB, 0xFFCD, 0xFFD1, 0xFFD6, 0xFFDB, 0xFFE0, 0xFFE6, 
	0xFFEC, 0xFFF1, 0xFFF6, 0xFFFA, 0xFFFD, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x3799, 0x3711, 0x359E, 0x337B, 0x30E2, 
	0x2E0D, 0x2B35, 0x2895, 0x2666, 0x24E3, 0x240C, 0x23A6, 0x2399, 0x23CA, 
	0x241D, 0x195F, 0x196F, 0x19A7, 0x1A0E, 0x1AAD, 0x1B8D, 0x1CB7, 0x1E32, 
	0x2007, 0x223F, 0x24E3, 0x286A, 0x2E27, 0x34A2, 0x3A65, 0x3DF6, 0x414B, 
	0x44DE, 0x4884, 0x4C11, 0x4F5B, 0x5235, 0x5475, 0x55EE, 0x5675, 0x0B8D, 
	0x0B0F, 0x0A39, 0x0966, 0x0890, 0x081C, 0x0832, 0x0891, 0x0902, 0x094B, 
	0x095B, 0x0951, 0x093D, 0x092E, 0x0922, 0x0913, 0x090B, 0x0917, 0x0994, 
	0x0A5E, 0x0ABC, 0x09F2, 0x0792, 0x0414, 0x0018, 0xFC40, 0xF7B3, 0xF306, 
	0xF106, 0xF198, 0xF2B0, 0xF44A, 0xF64D, 0xF887, 0xFAC8, 0xFCDF, 0xFE99, 
	0xFFC7, 0x0037, 0x0000, 0x03B5, 0x0428, 0x04CA, 0x0545, 0x05AC, 0x058C, 
	0x04B0, 0x036B, 0x0215, 0x0104, 0x0052, 0xFFD0, 0xFF68, 0xFF06, 0xFE96, 
	0xFE28, 0xFDDB, 0xFDCB, 0xFE0A, 0xFE84, 0xFF22, 0xFFCC, 0x0081, 0x014C, 
	0x0226, 0x0307, 0x0439, 0x057C, 0x05F3, 0x05A2, 0x0524, 0x047A, 0x03A8, 
	0x02C3, 0x01DC, 0x0107, 0x0057, 0xFFDF, 0xFFB3, 0x0000, 0xFA88, 0xF958, 
	0xF751, 0xF4D5, 0xF252, 0xF227, 0xF552, 0xFA48, 0xFF9E, 0x03E8, 0x06C5, 
	0x08F7, 0x0AC6, 0x0C79, 0x0E59, 0x102D, 0x117D, 0x11CD, 0x1043, 0x0D5D, 
	0x0AAA, 0x09B9, 0x0BA2, 0x0F57, 0x1329, 0x156B, 0x14A5, 0x1216, 0x1018, 
	0x0F28, 0x0E33, 0x0CDA, 0x0B34, 0x0968, 0x079A, 0x05F1, 0x0493, 0x03A5, 
	0x034D, 0x039F, 0xF34E, 0xF364, 0xF3A0, 0xF3F8, 0xF463, 0xF4D8, 0xF54D, 
	0xF5BA, 0xF614, 0xF652, 0xF675, 0xF685, 0xF687, 0xF67F, 0xF672, 0xF663, 
	0xF657, 0xF652, 0xF628, 0xF5C3, 0xF546, 0xF4D5, 0xF494, 0xF4A6, 0xF52F, 
	0xF652, 0xF8B7, 0xFC7C, 0x00F7, 0x057B, 0x0960, 0x090E, 0x0831, 0x06F2, 
	0x0577, 0x03E9, 0x026E, 0x012F, 0x0052, 0x0000, 0xFEC6, 0xFED3, 0xFEF9, 
	0xFF31, 0xFF76, 0xFFC0, 0x000A, 0x004F, 0x0088, 0x00B0, 0x00C6, 0x00D0, 
	0x00D2, 0x00CD, 0x00C4, 0x00BB, 0x00B3, 0x00B0, 0x00B1, 0x00B2, 0x00B4, 
	0x00B6, 0x00B7, 0x00B7, 0x00B5, 0x00B0, 0x00A8, 0x009C, 0x008E, 0x007F, 
	0x006F, 0x005E, 0x004D, 0x003C, 0x002C, 0x001E, 0x0012, 0x0008, 0x0002, 
	0x0000, 0xFDD8, 0xFE15, 0xFEBB, 0xFFB0, 0x00D9, 0x021D, 0x0363, 0x048F, 
	0x0589, 0x0636, 0x0696, 0x06C4, 0x06CA, 0x06B4, 0x068F, 0x0665, 0x0644, 
	0x0636, 0x0640, 0x0658, 0x0675, 0x0690, 0x06A0, 0x069B, 0x067B, 0x0636, 
	0x05C0, 0x051B, 0x0455, 0x037A, 0x0297, 0x00F6, 0xFE96, 0xFBBA, 0xF8A0, 
	0xF588, 0xF2B0, 0xF05A, 0xEEC4, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x24F8, 
	0x2416, 0x21E5, 0x1F11, 0x1C4A, 0x19BE, 0x172B, 0x148F, 0x11EA, 0x0F3B, 
	0x0C81, 0x09BC, 0x06EB, 0x040D, 0x00B5, 0xFCAD, 0xF849, 0xF3D9, 0xEFAF, 
	0xEC1D, 0xE976, 0xE80B, 0xE82D, 0xEA39, 0xEE09, 0xF32C, 0xF932, 0xFFAC, 
	0x0627, 0x0C35, 0x1164, 0x14E3, 0x17B5, 0x19EA, 0x1B93, 0x1CC1, 0x1D84, 
	0x1DEC, 0x1E0C, 0x1DCC, 0x026F, 0x01AE, 0xFFAE, 0xFCD9, 0xF995, 0xF5EC, 
	0xF1C4, 0xED4F, 0xE8BD, 0xE440, 0xE008, 0xDC47, 0xD92D, 0xD6EC, 0xD599, 
	0xD50E, 0xD523, 0xD5AF, 0xD688, 0xD786, 0xD880, 0xD94E, 0xD9C7, 0xDA12, 
	0xDA6E, 0xDAD1, 0xDB34, 0xDB8F, 0xDBD9, 0xDC0A, 0xDC19, 0xDC19, 0xDC19, 
	0xDC19, 0xDC19, 0xDC19, 0xDC19, 0xDC19, 0xDC19, 0xD901, 0x801A, 0x7D05, 
	0x767A, 0x7070, 0x6EE5, 0x7173, 0x74F3, 0x793C, 0x7E25, 0x8387, 0x8935, 
	0x8F09, 0x94DA, 0x9A7E, 0xA09C, 0xA7B0, 0xAF51, 0xB718, 0xBE9C, 0xC576, 
	0xCB3D, 0xCF88, 0xD1F1, 0xD228, 0xD073, 0xCD45, 0xC912, 0xC44E, 0xBF6B, 
	0xBADE, 0xB71B, 0xB71B, 0xB71B, 0xB71B, 0xB71B, 0xB71B, 0xB71B, 0xB71B, 
	0xB71B, 0xB867, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFF6, 
	0xFFDF, 0xFFBF, 0xFF99, 0xFF74, 0xFF53, 0xFF3C, 0xFF33, 0x0000, 0xF59A, 
	0xF31E, 0xED8B, 0xE7AF, 0xE45C, 0xEA71, 0xEEE0, 0xE6C4, 0xDA95, 0xCF4A, 
	0xC9D9, 0xCC33, 0xD31B, 0xDBC4, 0xE361, 0xE726, 0xE471, 0xDD44, 0xD5C2, 
	0xD210, 0xD4C4, 0xDB29, 0xE177, 0xE3E5, 0xDD81, 0xD277, 0xCCAA, 0xCE90, 
	0xD320, 0xD900, 0xDED3, 0xDEC9, 0xDE86, 0xDDCD, 0xDC67, 0xDA17, 0xD6A5, 
	0xD1D5, 0xCB6E, 0xC9F4, 0xF0CF, 0xF0EA, 0xF12F, 0xF18F, 0xF1FD, 0xF26E, 
	0xF2DF, 0xF353, 0xF3C7, 0xF43D, 0xF4B3, 0xF52B, 0xF5A3, 0xF61C, 0xF695, 
	0xF70F, 0xF788, 0xF802, 0xF87B, 0xF8F4, 0xF96D, 0xF9E5, 0xFA5C, 0xFAD3, 
	0xFB48, 0xFBBC, 0xFC2F, 0xFCA0, 0xFD10, 0xFD7E, 0xFDEA, 0xFE9E, 0xFF98, 
	0x00BB, 0x01E9, 0x0306, 0x03F5, 0x049A, 0x04D7, 0x071C, 0xF7BD, 0xF7C0, 
	0xF7C8, 0xF7D3, 0xF7E0, 0xF7ED, 0xF7FA, 0xF807, 0xF814, 0xF822, 0xF82F, 
	0xF83D, 0xF84B, 0xF859, 0xF866, 0xF874, 0xF882, 0xF890, 0xF89E, 0xF8AC, 
	0xF8BA, 0xF8C8, 0xF8D5, 0xF8E3, 0xF8F0, 0xF8FE, 0xF90B, 0xF918, 0xF925, 
	0xF931, 0xF93D, 0xF9D8, 0xFB33, 0xFD0E, 0xFF27, 0x013C, 0x0309, 0x044E, 
	0x04C9, 0x0306, 0xF953, 0xF93F, 0xF909, 0xF8BE, 0xF869, 0xF812, 0xF7B9, 
	0xF760, 0xF706, 0xF6AA, 0xF64E, 0xF5F1, 0xF594, 0xF536, 0xF4D8, 0xF47A, 
	0xF41C, 0xF3BE, 0xF35F, 0xF301, 0xF2A4, 0xF247, 0xF1EA, 0xF18E, 0xF133, 
	0xF0D9, 0xF080, 0xF028, 0xEFD2, 0xEF7D, 0xEF29, 0xF076, 0xF3E4, 0xF8BE, 
	0xFE4D, 0x03DD, 0x08B6, 0x0C25, 0x0D72, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0xE207, 0xE315, 0xE5B1, 0xE908, 0xEC47, 0xEF07, 0xF190, 0xF417, 0xF6D0, 
	0xF9EE, 0xFDA6, 0x022C, 0x084B, 0x1010, 0x188E, 0x20DA, 0x2807, 0x2D29, 
	0x2FBA, 0x303F, 0x2F5F, 0x2DBF, 0x2C05, 0x295B, 0x2536, 0x20AA, 0x1BD7, 
	0x1614, 0x0ED7, 0x068C, 0xFE8D, 0xFE68, 0xFD69, 0xFAB2, 0xF569, 0xECB3, 
	0xDFB4, 0xCD91, 0x356F, 0x36DA, 0x11B5, 0x12EB, 0x15CA, 0x1928, 0x1BDD, 
	0x1DFA, 0x2038, 0x226C, 0x246E, 0x2614, 0x2734, 0x27A4, 0x2736, 0x25F7, 
	0x2414, 0x21BC, 0x1F1D, 0x1C66, 0x1942, 0x157B, 0x116D, 0x0D72, 0x09E5, 
	0x06E9, 0x0477, 0x02AE, 0x0171, 0x02D0, 0x0775, 0x0D3D, 0x1359, 0x18F2, 
	0x1DD1, 0x21F3, 0x2559, 0x2800, 0x29E6, 0x2B0C, 0x5492, 0x54F5, 0x7CD7, 
	0x7A30, 0x74A3, 0x6FD2, 0x6F5D, 0x72EC, 0x77AA, 0x7D78, 0x843D, 0x8BD6, 
	0x9428, 0x9D15, 0xA7F1, 0xB535, 0xC383, 0xD17A, 0xDDBB, 0xE6E5, 0xEC1B, 
	0xEE22, 0xEE0D, 0xECF3, 0xEBE8, 0xE9EA, 0xE615, 0xE1AD, 0xDCDB, 0xD688, 
	0xCDDB, 0xC3A8, 0xB9CE, 0xB344, 0xAFCC, 0xAE3E, 0xAD73, 0xAC41, 0xA97F, 
	0xA406, 0x1AAC, 0x175C, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0009, 0x0021, 
	0x0044, 0x006B, 0x0092, 0x00B4, 0x00CD, 0x00D6, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0067, 0x0178, 0x02F9, 0x04B2, 0x066B, 0x07EC, 0x08FC, 
	0x0964, 0xFFFF, 0xEEBF, 0xEEB5, 0xEE82, 0xEE08, 0xED28, 0xEBC4, 0xE9BD, 
	0xE6F5, 0xDF74, 0xD4B3, 0xCEC2, 0xD371, 0xDCF0, 0xE1DD, 0xDF6C, 0xDA31, 
	0xD3E3, 0xCE39, 0xCAE8, 0xCB09, 0xCD90, 0xD0F5, 0xD3B3, 0xD454, 0xD4B1, 
	0xD83B, 0xE65D, 0xF30D, 0xF57A, 0xF623, 0xF546, 0xF44E, 0xF348, 0xF192, 
	0xEE8C, 0xE992, 0xE205, 0xD742, 0xC8A8, 0xCB60, 0x0042, 0x004D, 0x006E, 
	0x00A3, 0x00EA, 0x0141, 0x01A6, 0x0218, 0x0295, 0x031C, 0x03A9, 0x043C, 
	0x04D3, 0x056C, 0x0605, 0x069C, 0x0730, 0x07BF, 0x0847, 0x08C7, 0x093C, 
	0x09A4, 0x09FF, 0x09D9, 0x091F, 0x085E, 0x07C8, 0x072F, 0x0695, 0x05FA, 
	0x055F, 0x04F3, 0x04A6, 0x0453, 0x03D4, 0x0305, 0x01C1, 0xFFE2, 0xFD44, 
	0xFA42, 0x0024, 0x0029, 0x0039, 0x0053, 0x0075, 0x00A0, 0x00D3, 0x010C, 
	0x014B, 0x018F, 0x01D8, 0x0225, 0x0274, 0x02C6, 0x0319, 0x036D, 0x03C1, 
	0x0415, 0x0466, 0x04B6, 0x0503, 0x054B, 0x0590, 0x0603, 0x0684, 0x0693, 
	0x0629, 0x0598, 0x04ED, 0x0437, 0x0382, 0x02B2, 0x01CC, 0x00E0, 0xFFFA, 
	0xFF2E, 0xFE89, 0xFE1A, 0xFDF2, 0x0197, 0xF4CF, 0xF4BD, 0xF489, 0xF435, 
	0xF3C4, 0xF338, 0xF293, 0xF1D8, 0xF108, 0xF027, 0xEF36, 0xEE38, 0xED2F, 
	0xEC1D, 0xEB05, 0xE9E9, 0xE8CB, 0xE7AE, 0xE695, 0xE580, 0xE473, 0xE36F, 
	0xE278, 0xE07C, 0xDDFD, 0xDD5C, 0xDED9, 0xE0F8, 0xE382, 0xE63E, 0xE8F4, 
	0xECFF, 0xF24D, 0xF850, 0xFE7A, 0x043F, 0x090C, 0x0C56, 0x0D8F, 0x0624, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xBF5E, 0xFAF2, 0xF9E6, 0xF7BC, 0xF5ED, 0xF4CB, 0xF3B5, 
	0xF2B6, 0xF1D7, 0xF123, 0xF0A5, 0xF05B, 0xF038, 0xF034, 0xF044, 0xF061, 
	0xF081, 0xF09A, 0xF0A5, 0xF09D, 0xF08A, 0xF072, 0xF05C, 0xF04F, 0xF053, 
	0xF06D, 0xF0A5, 0xF1B1, 0xF370, 0xF4A5, 0xF411, 0xF1B5, 0xF221, 0xF33C, 
	0xF4CD, 0xF698, 0xF863, 0xF9F4, 0xFB0F, 0xFB7B, 0xFE9B, 0xF823, 0xF7C5, 
	0xF704, 0xF664, 0xF603, 0xF5A8, 0xF556, 0xF50F, 0xF4D5, 0xF4AC, 0xF494, 
	0xF489, 0xF488, 0xF48D, 0xF496, 0xF4A1, 0xF4A9, 0xF4AC, 0xF4D0, 0xF527, 
	0xF592, 0xF5F4, 0xF62C, 0xF61D, 0xF5A7, 0xF4AC, 0xF1AC, 0xECAB, 0xE7D5, 
	0xE557, 0xE50C, 0xE58A, 0xE6D7, 0xE8AD, 0xEAC8, 0xECE3, 0xEEB9, 0xF006, 
	0xF084, 0xEFF9, 0x83C5, 0x870A, 0x8CDB, 0x8F3F, 0x8CA1, 0x881A, 0x82B8, 
	0x7D85, 0x7993, 0x77ED, 0x7893, 0x7A91, 0x7D85, 0x810D, 0x84C2, 0x8843, 
	0x8B2E, 0x8D1E, 0x8E36, 0x8EE1, 0x8F2D, 0x8F29, 0x8EE4, 0x8E6D, 0x8DD0, 
	0x8D1E, 0x8AD3, 0x8700, 0x8415, 0x847F, 0x8837, 0x8835, 0x8826, 0x87FC, 
	0x87AA, 0x8724, 0x865B, 0x8543, 0x83CE, 0x839E, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x2E88, 0x293A, 0x1E95, 0x1685, 0x13B7, 
	0x12C6, 0x1277, 0x1191, 0x0D7E, 0x0CEB, 0x150E, 0x204D, 0x2B1F, 0x31F6, 
	0x318F, 0x2C30, 0x26A0, 0x21B2, 0x22C0, 0x2486, 0x269A, 0x2892, 0x2A04, 
	0x2A85, 0x23CE, 0x20E1, 0x2D8F, 0x3FC0, 0x5026, 0x5771, 0x5649, 0x5477, 
	0x5296, 0x50BA, 0x4EF3, 0x4D56, 0x4BF4, 0x4AE1, 0x4A2E, 0x49EE, 0x047C, 
	0x049B, 0x04D1, 0x04E4, 0x04C7, 0x0498, 0x0460, 0x0428, 0x03F9, 0x03DA, 
	0x03CC, 0x03C5, 0x03C4, 0x03C7, 0x03CD, 0x03D3, 0x03D8, 0x03DA, 0x03BE, 
	0x037A, 0x0327, 0x02DB, 0x02AF, 0x02BB, 0x0317, 0x03DA, 0x0600, 0x0994, 
	0x0D48, 0x0FCD, 0x0F0F, 0x0E19, 0x0D2B, 0x0C0D, 0x0A87, 0x0861, 0x0562, 
	0x0152, 0xFBF8, 0xF7AE, 0x01A6, 0x0148, 0x0096, 0x002F, 0x0035, 0x005A, 
	0x0092, 0x00D0, 0x0105, 0x0125, 0x0133, 0x0139, 0x013A, 0x0137, 0x0132, 
	0x012C, 0x0127, 0x0125, 0x011A, 0x00FF, 0x00DE, 0x00C0, 0x00AF, 0x00B3, 
	0x00D8, 0x0125, 0x01F7, 0x0353, 0x04C9, 0x05E6, 0x0626, 0x0661, 0x06CB, 
	0x0753, 0x07E8, 0x087A, 0x08F7, 0x094E, 0x096F, 0x03C6, 0xC828, 0xCA8D, 
	0xCEE7, 0xD0FC, 0xCFD1, 0xCD96, 0xCACA, 0xC7EA, 0xC574, 0xC3E6, 0xC32F, 
	0xC2D9, 0xC2CE, 0xC2F7, 0xC33E, 0xC38D, 0xC3CC, 0xC3E6, 0xC3FA, 0xC429, 
	0xC464, 0xC499, 0xC4B7, 0xC4AF, 0xC46F, 0xC3E6, 0xC2B1, 0xC0AF, 0xBE30, 
	0xBB8A, 0xB764, 0xB454, 0xB2BB, 0xB215, 0xB1DE, 0xB191, 0xB0AA, 0xAEA3, 
	0xAAF9, 0xAB92, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x181F, 0x1956, 
	0x1B98, 0x1CCC, 0x1CB0, 0x1C5E, 0x1BC9, 0x1AE3, 0x19A0, 0x17F1, 0x14A6, 
	0x0FE1, 0x0B96, 0x09B9, 0x0C1B, 0x1144, 0x1635, 0x17F1, 0x1427, 0x0CEF, 
	0x05F0, 0x02CB, 0x05DA, 0x0CB7, 0x13E7, 0x17F1, 0x16F8, 0x1326, 0x0F0F, 
	0x0D45, 0x0DD5, 0x0D4D, 0x0BE6, 0x09EB, 0x07A5, 0x0560, 0x0365, 0x01FE, 
	0x0176, 0x01C0, 0x0E89, 0x0D53, 0x0B1F, 0x0A12, 0x0AA3, 0x0BB5, 0x0D10, 
	0x0E7E, 0x0FC7, 0x10B3, 0x1117, 0x1113, 0x10E4, 0x10C7, 0x10C3, 0x10BB, 
	0x10B4, 0x10B3, 0x10BF, 0x10D3, 0x10E6, 0x10EF, 0x10F8, 0x1102, 0x10F4, 
	0x10B3, 0x1008, 0x0F11, 0x0E34, 0x0DDA, 0x0DFB, 0x0E18, 0x0E27, 0x0E2C, 
	0x0E2D, 0x0E2E, 0x0E33, 0x0E42, 0x0E5F, 0x1192, 0x8564, 0x899C, 0x9151, 
	0x9516, 0x9324, 0x8F45, 0x8A6B, 0x8584, 0x8182, 0x7F52, 0x806C, 0x8437, 
	0x889F, 0x8B8A, 0x8C4D, 0x8C10, 0x8B76, 0x8B24, 0x8B44, 0x8B7F, 0x8BB7, 
	0x8BD1, 0x8BED, 0x8C0D, 0x8BE4, 0x8B24, 0x88BB, 0x8527, 0x8273, 0x82AB, 
	0x85C0, 0x85BD, 0x85A6, 0x8568, 0x84EF, 0x8427, 0x82FC, 0x815C, 0x7F32, 
	0x842B, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x25AF, 0x2041, 0x15C3, 0x0EE9, 0x0D7F, 
	0x0D4F, 0x0E08, 0x0F57, 0x10EC, 0x1274, 0x1461, 0x170F, 0x1A0D, 0x1CE9, 
	0x1FB2, 0x2295, 0x2550, 0x27A4, 0x29A9, 0x2B73, 0x2CBA, 0x2D38, 0x2B6B, 
	0x27F3, 0x25B9, 0x27A4, 0x31A1, 0x4116, 0x4F22, 0x54E6, 0x52D4, 0x503D, 
	0x4E39, 0x4CB5, 0x4B9F, 0x4AE4, 0x4A73, 0x4A39, 0x4A24, 0x4A21, 0xF884, 
	0xF88E, 0xF8AA, 0xF8D2, 0xF902, 0xF937, 0xF96C, 0xF99E, 0xF9C6, 0xF9E3, 
	0xF9EE, 0xF9EB, 0xF9E0, 0xF9D1, 0xF9C4, 0xF9BF, 0xF9C8, 0xF9E3, 0xFA40, 
	0xFADD, 0xFB6F, 0xFBB0, 0xFBC3, 0xFBBD, 0xFB3D, 0xF9E3, 0xF704, 0xF305, 
	0xEF17, 0xEC6D, 0xED63, 0xEF8F, 0xF276, 0xF5C7, 0xF932, 0xFC66, 0xFF14, 
	0x00EB, 0x0199, 0x09D3, 0xFE67, 0xFE69, 0xFE71, 0xFE7B, 0xFE88, 0xFE96, 
	0xFEA3, 0xFEB0, 0xFEBB, 0xFEC2, 0xFECA, 0xFED3, 0xFEDC, 0xFEE4, 0xFEE7, 
	0xFEE4, 0xFED8, 0xFEC2, 0xFE7E, 0xFE0C, 0xFDA1, 0xFD71, 0xFDD8, 0xFEA0, 
	0xFF24, 0xFEC2, 0xFCE4, 0xFA04, 0xF718, 0xF514, 0xF59A, 0xF59A, 0xF599, 
	0xF597, 0xF593, 0xF58C, 0xF581, 0xF573, 0xF55F, 0xFE32, 0xD559, 0xD54F, 
	0xD531, 0xD506, 0xD4D2, 0xD498, 0xD45F, 0xD42A, 0xD3FE, 0xD3DF, 0xD3F5, 
	0xD44D, 0xD4C2, 0xD531, 0xD575, 0xD56C, 0xD4F0, 0xD3DF, 0xD071, 0xCABA, 
	0xC55D, 0xC2FE, 0xC59C, 0xCB62, 0xD12E, 0xD3DF, 0xD231, 0xCDF6, 0xC8A5, 
	0xC3BB, 0xBE48, 0xBA7C, 0xB883, 0xB7BC, 0xB783, 0xB736, 0xB633, 0xB3D7, 
	0xAF80, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0026, 0x0001, 0x0028, 0x0027, 0x0001, 0x004F, 0x0001, 
	0x0050, 0x0001, 0x0051, 0x0002, 0x0052, 0x0025, 0x0054, 0x0028, 0x0079, 
	0x0028, 0x00A1, 0x0028, 0x00C9, 0x0028, 0x00F1, 0x0028, 0x0119, 0x0028, 
	0x0141, 0x0028, 0x0169, 0x0001, 0x0191, 0x0001, 0x0192, 0x0001, 0x0193, 
	0x0028, 0x0194, 0x0028, 0x01BC, 0x0028, 0x01E4, 0x0026, 0x020C, 0x0028, 
	0x0232, 0x0028, 0x025A, 0x0028, 0x0282, 0x0028, 0x02AA, 0x0028, 0x02D2, 
	0x0001, 0x02FA, 0x0001, 0x02FB, 0x0001, 0x02FC, 0x0028, 0x02FD, 0x0028, 
	0x0325, 0x0028, 0x034D, 0x0028, 0x0375, 0x0028, 0x039D, 0x0028, 0x03C5, 
	0x0028, 0x03ED, 0x0028, 0x0415, 0x0028, 0x043D, 0x0024, 0x0465, 0x0026, 
	0x0489, 0x0001, 0x04AF, 0x0028, 0x04B0, 0x0028, 0x04D8, 0x0028, 0x0500, 
	0x000C, 0x0528, 0x0028, 0x0534, 0x0028, 0x055C, 0x0028, 0x0584, 0x0028, 
	0x05AC, 0x0028, 0x05D4, 0x0024, 0x05FC, 0x001F, 0x0620, 0x0001, 0x063F, 
	0x0028, 0x0640, 0x0028, 0x0668, 0x0028, 0x0690, 0x000E, 0x06B8, 0x0022, 
	0x06C6, 0x0028, 0x06E8, 0x0028, 0x0710, 0x0028, 0x0738, 0x0028, 0x0760, 
	

});

smlua_anim_util_register_animation('donkey_9D_return_star_approach_door',1, 0, 0, 0, 25, { 
	0x0000, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 
	0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AE, 0x00AD, 0x00AC, 
	0x00A9, 0x00A5, 0x00A0, 0x009C, 0x0097, 0x0092, 0x008F, 0x008C, 0x008B, 
	0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF75, 
	0xFF75, 0xFF75, 0xFF75, 0xFF75, 0xFF89, 0xFFB1, 0xFFCF, 0xFFDC, 0xFFE7, 
	0xFFEF, 0xFFF5, 0xFFFA, 0xFFFD, 0xFFFF, 0x0000, 0x0000, 0x3FFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x3DC7, 
	0x3DA4, 0x3D89, 0x3D78, 0x3D72, 0x3D79, 0x3D8E, 0x3DB2, 0x3DE8, 0x3E30, 
	0x3E8D, 0x3EFF, 0x3FB9, 0x40D5, 0x422B, 0x4398, 0x44F4, 0x461A, 0x472D, 
	0x4909, 0x4B9D, 0x4E8B, 0x5175, 0x53FE, 0x55C8, 0x5675, 0x038D, 0x032C, 
	0x02B3, 0x022C, 0x01A4, 0x0123, 0x00B6, 0x0066, 0x003F, 0x004B, 0x0095, 
	0x0127, 0x0317, 0x06A6, 0x0AA6, 0x0DE5, 0x0F35, 0x0DEE, 0x0ADB, 0x07DD, 
	0x0562, 0x0365, 0x01E2, 0x00D3, 0x0034, 0x0000, 0xF99A, 0xF9A8, 0xF9C8, 
	0xF9F8, 0xFA37, 0xFA82, 0xFAD8, 0xFB38, 0xFBA0, 0xFC0D, 0xFC7F, 0xFCF4, 
	0xFD9A, 0xFE83, 0xFF7E, 0x005E, 0x00F2, 0x012C, 0x012B, 0x0118, 0x00ED, 
	0x00B2, 0x0074, 0x003A, 0x0010, 0x0000, 0xF68F, 0xF622, 0xF622, 0xF680, 
	0xF72B, 0xF811, 0xF923, 0xFA4F, 0xFB85, 0xFCB3, 0xFDCA, 0xFEB9, 0xFF98, 
	0x008C, 0x0193, 0x02AC, 0x03D6, 0x053A, 0x06D9, 0x06AB, 0x0635, 0x0594, 
	0x04E4, 0x0443, 0x03CD, 0x039F, 0xF2B4, 0xF302, 0xF390, 0xF44E, 0xF52E, 
	0xF620, 0xF714, 0xF7FB, 0xF8C6, 0xF964, 0xF9C8, 0xF9E1, 0xF8E6, 0xF6B1, 
	0xF426, 0xF227, 0xF19A, 0xF2FC, 0xF5B7, 0xF871, 0xFADC, 0xFCE3, 0xFE70, 
	0xFF6E, 0xFFC7, 0x0000, 0xF98F, 0xF98D, 0xF9A9, 0xF9DD, 0xFA26, 0xFA7D, 
	0xFADF, 0xFB48, 0xFBB1, 0xFC17, 0xFC76, 0xFCC7, 0xFD10, 0xFD58, 0xFD9E, 
	0xFDE4, 0xFE2A, 0xFE71, 0xFEBB, 0xFEFF, 0xFF3A, 0xFF6B, 0xFF8F, 0xFFA6, 
	0xFFAE, 0x0000, 0xF2A5, 0xF2D3, 0xF31F, 0xF384, 0xF3FD, 0xF486, 0xF518, 
	0xF5B1, 0xF649, 0xF6DD, 0xF768, 0xF7E5, 0xF856, 0xF8C2, 0xF928, 0xF989, 
	0xF9E4, 0xFA37, 0xFA84, 0xFA75, 0xFA0D, 0xF8F3, 0xF6CE, 0xF344, 0xEDFD, 
	0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xE28E, 0xE1FB, 0xE21D, 0xE2D2, 0xE3FA, 
	0xE573, 0xE71B, 0xE8D1, 0xEA74, 0xEBE3, 0xECFB, 0xED9C, 0xED1D, 0xEB7C, 
	0xE98F, 0xE82C, 0xE82B, 0xE994, 0xEBBA, 0xF206, 0xFBEB, 0x074D, 0x120C, 
	0x1A0C, 0x1D2F, 0x1DCC, 0xEB95, 0xEB48, 0xEA98, 0xE997, 0xE857, 0xE6EB, 
	0xE563, 0xE3D3, 0xE24B, 0xE0DD, 0xDF9C, 0xDE9A, 0xDE18, 0xDE15, 0xDE3C, 
	0xDE3C, 0xDDBF, 0xDCB6, 0xDB5B, 0xDA88, 0xDA3A, 0xDA2F, 0xDA24, 0xD9D6, 
	0xD902, 0xD901, 0xE73D, 0xE82D, 0xE85F, 0xE7F9, 0xE71C, 0xE5EE, 0xE492, 
	0xE32C, 0xE1DF, 0xE0CF, 0xE021, 0xDFF7, 0xE12F, 0xE3D5, 0xE6D3, 0xE917, 
	0xE98D, 0xE833, 0xE5F2, 0xE465, 0xE2A1, 0xDF23, 0xD867, 0xCCEB, 0xBB2A, 
	0xB867, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xE3F9, 0xE445, 0xE3C8, 0xE2AC, 
	0xE11E, 0xDF48, 0xDD57, 0xDB75, 0xD9CF, 0xD890, 0xD7E3, 0xD7F4, 0xDA80, 
	0xDFCC, 0xE5D0, 0xEA85, 0xEBE4, 0xE9F8, 0xE679, 0xE431, 0xE29A, 0xE057, 
	0xDC0D, 0xD45D, 0xC7EC, 0xC9F4, 0xEFA6, 0xEFF4, 0xF073, 0xF11D, 0xF1E8, 
	0xF2CE, 0xF3C4, 0xF4C4, 0xF5C4, 0xF6BD, 0xF7A6, 0xF878, 0xF937, 0xF9F0, 
	0xFA9E, 0xFB3F, 0xFBD1, 0xFC63, 0xFCFF, 0xFE47, 0x001F, 0x022B, 0x0411, 
	0x0578, 0x0603, 0x071C, 0xF973, 0xF92E, 0xF8FE, 0xF8DF, 0xF8CE, 0xF8C9, 
	0xF8CC, 0xF8D4, 0xF8DF, 0xF8E8, 0xF8ED, 0xF8EC, 0xF8EA, 0xF8F0, 0xF8FA, 
	0xF906, 0xF911, 0xF91D, 0xF92B, 0xF98C, 0xFA3E, 0xFB14, 0xFBE4, 0xFC80, 
	0xFCBE, 0x0306, 0xF0AF, 0xF0BD, 0xF0BA, 0xF0A6, 0xF086, 0xF05D, 0xF02C, 
	0xEFF8, 0xEFC2, 0xEF8F, 0xEF60, 0xEF38, 0xEF14, 0xEEEF, 0xEEC9, 0xEEA5, 
	0xEE84, 0xEE63, 0xEE3F, 0xF061, 0xF5B7, 0xFCA7, 0x0397, 0x08ED, 0x0B10, 
	0x0A90, 0x0001, 0xFFFE, 0xC170, 0xBCC5, 0xC139, 0xC5C1, 0xCA50, 0xCEDB, 
	0xD355, 0xD7B2, 0xDBE6, 0xDFE4, 0xE3A2, 0xE713, 0xEA2A, 0xED10, 0xEFEE, 
	0xF2BE, 0xF577, 0xF812, 0xFA87, 0xFCCE, 0xFC89, 0xFAA9, 0xF590, 0xEBA4, 
	0xDB48, 0x42E2, 0x36DA, 0x16C4, 0x16B2, 0x170B, 0x17BD, 0x18B6, 0x19E5, 
	0x1B37, 0x1C9B, 0x1DFF, 0x1F50, 0x207E, 0x2177, 0x2258, 0x2347, 0x2440, 
	0x253E, 0x263B, 0x2733, 0x2820, 0x28D7, 0x295A, 0x29BB, 0x2A0A, 0x2A5A, 
	0x5545, 0x54F5, 0x48B0, 0x4E14, 0x5466, 0x5B74, 0x630B, 0x6AF7, 0x7308, 
	0x7B08, 0x82C9, 0x8A13, 0x90B5, 0x967E, 0x9BD9, 0xA148, 0xA6B8, 0xAC16, 
	0xB14D, 0xB64B, 0xBAFB, 0xBADF, 0xBA18, 0xB7FB, 0xB3DE, 0xAD15, 0x22F7, 
	0x175C, 0x0000, 0x0241, 0x08AB, 0x12BA, 0x1FE7, 0x2FAE, 0x418A, 0x54F5, 
	0x696A, 0x7E65, 0x9360, 0xA7D6, 0xBB41, 0xCD1D, 0xDCE5, 0xEA12, 0xF421, 
	0xFA8C, 0xFCCE, 0xFCCF, 0xFCCF, 0xFCCF, 0xFCD0, 0xFCD0, 0xFCD0, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFB, 0xFFF2, 0xFFE5, 0xFFD9, 0xFFCF, 0xFFCB, 0xFFFF, 0xFAB4, 
	0xFB27, 0xFA88, 0xF904, 0xF6C7, 0xF3FF, 0xF0D8, 0xED81, 0xEA25, 0xE6F3, 
	0xE416, 0xE1BD, 0xDF9B, 0xDD51, 0xDAEB, 0xD875, 0xD5FE, 0xD392, 0xD13E, 
	0xD056, 0xD001, 0xCFF5, 0xCFE9, 0xCF93, 0xCEAB, 0xCB60, 0x12A6, 0x1283, 
	0x1212, 0x115F, 0x1078, 0x0F6C, 0x0E46, 0x0D15, 0x0BE5, 0x0AC6, 0x09C3, 
	0x08EA, 0x0824, 0x0753, 0x067B, 0x05A0, 0x04C6, 0x03F2, 0x0327, 0x02AB, 
	0x025D, 0x01F7, 0x0137, 0xFFD9, 0xFD9A, 0xFA42, 0x2B12, 0x2AC1, 0x29BB, 
	0x281E, 0x260A, 0x239D, 0x20F7, 0x1E36, 0x1B7A, 0x18E1, 0x168B, 0x1497, 
	0x12CE, 0x10EB, 0x0EF8, 0x0CFE, 0x0B07, 0x091C, 0x0747, 0x06A8, 0x066D, 
	0x0664, 0x065C, 0x0621, 0x0582, 0x0197, 0xF7D8, 0xF803, 0xF815, 0xF813, 
	0xF800, 0xF7E0, 0xF7B6, 0xF787, 0xF756, 0xF726, 0xF6FD, 0xF6DD, 0xF6C0, 
	0xF6A0, 0xF67C, 0xF657, 0xF630, 0xF60A, 0xF5E5, 0xF718, 0xFA17, 0xFDFC, 
	0x01E2, 0x04E2, 0x0614, 0x0624, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xBF5E, 0xDE1D, 0xDDAC, 0xDCE9, 0xDBF1, 0xDADE, 0xD9CC, 0xD8D8, 
	0xD81E, 0xD7B9, 0xD7C5, 0xD85E, 0xD9A1, 0xE435, 0xF341, 0xF951, 0xF6A3, 
	0xF2E1, 0xF194, 0xF031, 0xF134, 0xF3BB, 0xF703, 0xFA4C, 0xFCD3, 0xFDD6, 
	0xFE9B, 0xF111, 0xF11F, 0xF101, 0xF0C1, 0xF069, 0xF004, 0xEF9C, 0xEF3B, 
	0xEEED, 0xEEBB, 0xEEB0, 0xEED7, 0xF0B9, 0xF474, 0xFAAE, 0xFA87, 0xF919, 
	0xF830, 0xF6A8, 0xF599, 0xF523, 0xF4E1, 0xF46E, 0xF365, 0xF161, 0xEFF9, 
	0xB7E8, 0xB879, 0xB91E, 0xB9C8, 0xBA64, 0xBAE2, 0xBB31, 0xBB3E, 0xBAFA, 
	0xBA53, 0xB937, 0xB797, 0xADCC, 0x9F15, 0x9451, 0x9966, 0x9FAF, 0xA000, 
	0x9EB7, 0x9D74, 0x9C52, 0x9A59, 0x9690, 0x8FFF, 0x85AD, 0x839E, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x1DE1, 0x1D4F, 0x1CD3, 0x1C74, 
	0x1C38, 0x1C26, 0x1C45, 0x1C9B, 0x1D2F, 0x1E08, 0x1F2C, 0x20A3, 0x2AE9, 
	0x3319, 0x2B16, 0x1DD7, 0x13F4, 0x12D4, 0x185F, 0x2170, 0x2AF9, 0x344E, 
	0x3CBE, 0x439D, 0x483D, 0x49EE, 0xFC1F, 0xFC18, 0xFC22, 0xFC3D, 0xFC64, 
	0xFC96, 0xFCCF, 0xFD0D, 0xFD4E, 0xFD8E, 0xFDCC, 0xFE03, 0xFE62, 0xFEBF, 
	0xFF01, 0xFF2E, 0xFEED, 0xFCDD, 0xFBCC, 0xFAB5, 0xF95C, 0xF836, 0xF7B9, 
	0xF9E5, 0xFC10, 0xF7AE, 0xFC7C, 0xFC7C, 0xFC8C, 0xFCAA, 0xFCD4, 0xFD06, 
	0xFD3D, 0xFD76, 0xFDB0, 0xFDE6, 0xFE16, 0xFE3E, 0xFE39, 0xFE37, 0xFE3A, 
	0xFE52, 0xFF0E, 0x0209, 0x0475, 0x03CB, 0x0256, 0x00E1, 0x0037, 0x0059, 
	0x0144, 0x03C6, 0xC3A1, 0xC3D8, 0xC3EC, 0xC3E2, 0xC3C1, 0xC38C, 0xC349, 
	0xC2FD, 0xC2AD, 0xC25F, 0xC217, 0xC1DB, 0xC167, 0xC0F1, 0xC09C, 0xC060, 
	0xC0B5, 0xC366, 0xC4C6, 0xC099, 0xB768, 0xAE37, 0xAA0A, 0xAB11, 0xAC17, 
	0xAB92, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x1A87, 
	0x1AB6, 0x1AE6, 0x1B13, 0x1B3C, 0x1B5E, 0x1B77, 0x1B85, 0x1B85, 0x1B75, 
	0x1B52, 0x1B1A, 0x1981, 0x1724, 0x1576, 0x13DE, 0x1227, 0x0FB0, 0x0CC5, 
	0x09CA, 0x06F4, 0x0471, 0x026E, 0x0118, 0x009C, 0x01C0, 0x0B38, 0x0B2B, 
	0x0B54, 0x0BA8, 0x0C19, 0x0C9A, 0x0D1D, 0x0D96, 0x0DF8, 0x0E35, 0x0E40, 
	0x0E0D, 0x0ABD, 0x06CA, 0x05A3, 0x0561, 0x05EF, 0x075F, 0x0973, 0x0AC1, 
	0x0B42, 0x0B65, 0x0B97, 0x0C49, 0x0DE8, 0x1192, 0xB5C7, 0xB605, 0xB5CA, 
	0xB534, 0xB461, 0xB36F, 0xB27C, 0xB1A5, 0xB109, 0xB0C4, 0xB0F6, 0xB1BC, 
	0xB95B, 0xC418, 0xCD1F, 0xD556, 0xD679, 0xCD0E, 0xBDB2, 0xB441, 0xAFC0, 
	0xAC51, 0xA618, 0x9938, 0x81D5, 0x842B, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x1D79, 0x1D0E, 0x1CE7, 0x1CF4, 0x1D23, 0x1D65, 0x1DA9, 
	0x1DE0, 0x1DF8, 0x1DE2, 0x1D8C, 0x1CE8, 0x1A3D, 0x1564, 0x109F, 0x0E31, 
	0x105D, 0x1C55, 0x3004, 0x39AF, 0x409D, 0x4541, 0x4813, 0x4985, 0x4A0D, 
	0x4A21, 0xFFE5, 0xFFD5, 0xFFAB, 0xFF72, 0xFF33, 0xFEF7, 0xFEC8, 0xFEB0, 
	0xFEB8, 0xFEEA, 0xFF50, 0xFFF3, 0x051A, 0x09E2, 0x07A6, 0x0338, 0x0012, 
	0xFF5F, 0xFF97, 0x007D, 0x0226, 0x0405, 0x058C, 0x062E, 0x0616, 0x09D3, 
	0xFFA3, 0xFF9F, 0xFF99, 0xFF90, 0xFF86, 0xFF7B, 0xFF71, 0xFF68, 0xFF61, 
	0xFF5E, 0xFF5E, 0xFF64, 0xFFC0, 0x0014, 0xFFE4, 0xFF8A, 0xFF4C, 0xFF41, 
	0xFF4A, 0xFE73, 0xFC71, 0xFA0D, 0xF80C, 0xF734, 0xFCC5, 0xFE32, 0xC27F, 
	0xC2CB, 0xC343, 0xC3D9, 0xC480, 0xC52B, 0xC5CD, 0xC659, 0xC6C2, 0xC6FB, 
	0xC6F5, 0xC6A6, 0xC18F, 0xBC55, 0xBE1C, 0xC1DA, 0xC2E6, 0xBEA9, 0xB7D3, 
	0xB11E, 0xAB1C, 0xA641, 0xA302, 0xA1D3, 0xADED, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x001A, 0x0001, 0x0018, 0x001B, 0x0001, 0x0033, 0x0001, 
	0x0034, 0x0001, 0x0035, 0x0001, 0x0036, 0x0019, 0x0037, 0x001A, 0x0050, 
	0x001A, 0x006A, 0x001A, 0x0084, 0x001A, 0x009E, 0x001A, 0x00B8, 0x001A, 
	0x00D2, 0x001A, 0x00EC, 0x0001, 0x0106, 0x0001, 0x0107, 0x0001, 0x0108, 
	0x001A, 0x0109, 0x001A, 0x0123, 0x001A, 0x013D, 0x0017, 0x0157, 0x001A, 
	0x016E, 0x001A, 0x0188, 0x001A, 0x01A2, 0x001A, 0x01BC, 0x001A, 0x01D6, 
	0x0001, 0x01F0, 0x0001, 0x01F1, 0x0001, 0x01F2, 0x001A, 0x01F3, 0x001A, 
	0x020D, 0x001A, 0x0227, 0x001A, 0x0241, 0x001A, 0x025B, 0x001A, 0x0275, 
	0x001A, 0x028F, 0x001A, 0x02A9, 0x001A, 0x02C3, 0x001A, 0x02DD, 0x0019, 
	0x02F7, 0x0001, 0x0310, 0x001A, 0x0311, 0x001A, 0x032B, 0x001A, 0x0345, 
	0x0007, 0x035F, 0x001A, 0x0366, 0x001A, 0x0380, 0x001A, 0x039A, 0x001A, 
	0x03B4, 0x001A, 0x03CE, 0x001A, 0x03E8, 0x0019, 0x0402, 0x0001, 0x041B, 
	0x001A, 0x041C, 0x001A, 0x0436, 0x001A, 0x0450, 0x0007, 0x046A, 0x001A, 
	0x0471, 0x001A, 0x048B, 0x001A, 0x04A5, 0x001A, 0x04BF, 0x001A, 0x04D9, 
	

});

smlua_anim_util_register_animation('donkey_BE_sideflip_land',1, 0, 0, 0, 17, { 
	0x0000, 0x00B4, 0x0094, 0x0080, 0x007A, 0x0076, 0x0074, 0x0073, 0x0074, 
	0x0077, 0x007B, 0x007F, 0x0084, 0x0088, 0x008A, 0x008B, 0x0000, 0x0003, 
	0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0004, 0x0003, 
	0x0002, 0x0001, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x8000, 0x7FFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0001, 0x3F5F, 0x3025, 0x2702, 0x23F7, 0x23F7, 0x23F7, 0x23F7, 
	0x242D, 0x24C8, 0x25AF, 0x26C1, 0x27D2, 0x28B9, 0x2954, 0x298A, 0x0112, 
	0x007A, 0x001F, 0x0000, 0xFFFF, 0x0000, 0x0B88, 0x0C09, 0x0C56, 0x0C70, 
	0x0D56, 0x0DE0, 0x0E0E, 0x0DA9, 0x0C87, 0x0AD6, 0x08D7, 0x06D8, 0x0526, 
	0x0405, 0x039F, 0xFEC1, 0xFF54, 0xFFAC, 0xFFDD, 0xFFF4, 0xFFFD, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFEBF, 0xFF52, 0xFFAC, 0xFFDD, 0xFFF4, 0xFFFD, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xF4FC, 0xF3D2, 
	0xF31E, 0xF2BB, 0xF28B, 0xF27A, 0xF276, 0xF276, 0xF24C, 0xF1D5, 0xF124, 
	0xF052, 0xEF81, 0xEECF, 0xEE59, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xC04D, 
	0xCB0E, 0xE5F0, 0xF0B1, 0xEE00, 0xEC63, 0xEBD9, 0xECEB, 0xF021, 0xF57B, 
	0xFCF8, 0x069B, 0x137D, 0x1B39, 0x1DCC, 0xCF99, 0xD3B4, 0xDDF6, 0xE210, 
	0xE26D, 0xE2A4, 0xE2B7, 0xE265, 0xE16E, 0xDFD4, 0xDD96, 0xDAB4, 0xD9C3, 
	0xD932, 0xD901, 0xF5D2, 0xEFA8, 0xE040, 0xDA16, 0xDD75, 0xDF7A, 0xE026, 
	0xDF41, 0xDC90, 0xD815, 0xD1CE, 0xC9BC, 0xC01B, 0xBA54, 0xB867, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xD2B7, 0xCB3D, 0xB88B, 0xB110, 0xAE4C, 0xACA4, 0xAC16, 0xAD05, 0xAFD2, 
	0xB47C, 0xBB05, 0xC18D, 0xC638, 0xC905, 0xC9F4, 0x0000, 0x03FC, 0x0DF1, 
	0x11ED, 0x1436, 0x1595, 0x160A, 0x1593, 0x142C, 0x11D7, 0x0E93, 0x0B4F, 
	0x08F9, 0x0793, 0x071C, 0xFFFF, 0x00D2, 0x02E0, 0x03B3, 0x0436, 0x0484, 
	0x049E, 0x0492, 0x046B, 0x042B, 0x03D2, 0x0379, 0x0339, 0x0312, 0x0306, 
	0xF1C6, 0xF6B6, 0x030E, 0x07FD, 0x072D, 0x06B1, 0x0687, 0x06A7, 0x0708, 
	0x07A9, 0x088B, 0x096D, 0x0A0F, 0x0A6F, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0x3213, 0x3323, 0x35CA, 0x36DA, 0x2F46, 0x31A5, 0x3791, 0x39F0, 0x36C7, 
	0x34E1, 0x3440, 0x3545, 0x3856, 0x3D73, 0x449B, 0x4BC2, 0x50DF, 0x53F0, 
	0x54F5, 0xFCD7, 0xFF6A, 0x05DA, 0x086D, 0x086D, 0x086D, 0x086D, 0x08E5, 
	0x0A4B, 0x0CA0, 0x0FE5, 0x1329, 0x157E, 0x16E5, 0x175C, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xD757, 0xCE0B, 0xB6CE, 0xAD82, 0xAABE, 0xA915, 
	0xA888, 0xA99F, 0xACE3, 0xB255, 0xB9F4, 0xC193, 0xC705, 0xCA49, 0xCB60, 
	0xF76B, 0xF819, 0xF9CC, 0xFA7A, 0xFA5F, 0xFA4E, 0xFA49, 0xFA48, 0xFA48, 
	0xFA47, 0xFA45, 0xFA44, 0xFA42, 0x0F23, 0x0C46, 0x051C, 0x023E, 0x01EF, 
	0x01C0, 0x01B0, 0x01AF, 0x01AD, 0x01A9, 0x01A4, 0x019E, 0x019A, 0x0198, 
	0x0197, 0xF1E2, 0xF76E, 0x054B, 0x0AD6, 0x089D, 0x0747, 0x06D5, 0x06D0, 
	0x06BF, 0x06A4, 0x067D, 0x0656, 0x063A, 0x062A, 0x0624, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xBF5E, 0xFEAA, 0x0323, 0x05D1, 0x06B5, 0x0849, 0x093B, 0x098C, 
	0x0921, 0x07F2, 0x062C, 0x0414, 0x01FC, 0x0036, 0xFF06, 0xFE9B, 0xEEA3, 
	0xF020, 0xF104, 0xF151, 0xF237, 0xF2C1, 0xF2EF, 0xF2D2, 0xF280, 0xF205, 
	0xF174, 0xF0E3, 0xF068, 0xF016, 0xEFF9, 0x79CC, 0x7346, 0x6F5C, 0x6E0E, 
	0x695A, 0x6687, 0x6596, 0x66BB, 0x69FC, 0x6EDB, 0x749A, 0x7A59, 0x7F38, 
	0x827A, 0x839E, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x4884, 0x53AD, 0x5A5F, 
	0x5C9B, 0x6150, 0x6423, 0x6514, 0x640B, 0x611A, 0x5CB2, 0x5781, 0x524F, 
	0x4DE8, 0x4AF6, 0x49EE, 0xFFFF, 0xFB22, 0xF837, 0xF73E, 0xF749, 0xF74F, 
	0xF751, 0xF755, 0xF75F, 0xF76E, 0xF780, 0xF791, 0xF7A0, 0xF7AA, 0xF7AE, 
	0x0000, 0x0170, 0x024D, 0x0296, 0x02B9, 0x02CF, 0x02D6, 0x02DF, 0x02F9, 
	0x0320, 0x034E, 0x037C, 0x03A3, 0x03BD, 0x03C6, 0xD467, 0xBA9E, 0xAB26, 
	0xA5FE, 0xA69F, 0xA700, 0xA721, 0xA74C, 0xA7C7, 0xA880, 0xA95A, 0xAA33, 
	0xAAEC, 0xAB67, 0xAB92, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xBF5E, 0xFFFF, 0xFBF8, 0xF98D, 0xF8BF, 0xF6E7, 0xF5CD, 0xF56E, 0xF5E6, 
	0xF73C, 0xF93B, 0xFB96, 0xFDF2, 0xFFF1, 0x0148, 0x01C0, 0x0000, 0x08FD, 
	0x0E62, 0x102E, 0x0F24, 0x0E84, 0x0E4E, 0x0E6E, 0x0EC9, 0x0F50, 0x0FF0, 
	0x1090, 0x1118, 0x1172, 0x1192, 0xB90D, 0x8F80, 0x7692, 0x6E43, 0x693E, 
	0x663C, 0x653B, 0x6668, 0x69C3, 0x6EC8, 0x74B3, 0x7A9F, 0x7FA3, 0x82FE, 
	0x842B, 0x0000, 0xFFFF, 0x0000, 0x0F93, 0x3A7B, 0x5439, 0x5CCE, 0x61D1, 
	0x64D3, 0x65D4, 0x64C6, 0x61C5, 0x5D47, 0x57FA, 0x52AD, 0x4E2F, 0x4B2F, 
	0x4A21, 0xFFFF, 0x058B, 0x08DE, 0x09F9, 0x09F6, 0x09F4, 0x09F3, 0x09F2, 
	0x09EE, 0x09E9, 0x09E3, 0x09DD, 0x09D7, 0x09D4, 0x09D3, 0xFFFF, 0xFFC2, 
	0xFF9D, 0xFF91, 0xFF57, 0xFF35, 0xFF29, 0xFF20, 0xFF05, 0xFEDD, 0xFEAE, 
	0xFE7F, 0xFE57, 0xFE3C, 0xFE32, 0xD659, 0xBB9F, 0xAB95, 0xA63D, 0xA724, 
	0xA7AF, 0xA7DD, 0xA803, 0xA870, 0xA911, 0xA9D0, 0xAA8F, 0xAB31, 0xAB9D, 
	0xABC3, 

},{ 
	0x0001, 0x0000, 0x000F, 0x0001, 0x000E, 0x0010, 0x0001, 0x001E, 0x0001, 
	0x001F, 0x0001, 0x0020, 0x0002, 0x0021, 0x000C, 0x0023, 0x000F, 0x002F, 
	0x0004, 0x003E, 0x0002, 0x0042, 0x000F, 0x0044, 0x0010, 0x0053, 0x0010, 
	0x0063, 0x0010, 0x0073, 0x0001, 0x0083, 0x0001, 0x0084, 0x0001, 0x0085, 
	0x000F, 0x0086, 0x000F, 0x0095, 0x000F, 0x00A4, 0x000F, 0x00B3, 0x000D, 
	0x00C2, 0x000F, 0x00CF, 0x000F, 0x00DE, 0x000F, 0x00ED, 0x000F, 0x00FC, 
	0x0001, 0x010B, 0x0001, 0x010C, 0x0001, 0x010D, 0x0004, 0x010E, 0x000F, 
	0x0112, 0x000F, 0x0121, 0x0001, 0x0130, 0x000D, 0x0131, 0x000F, 0x013E, 
	0x000D, 0x014D, 0x000F, 0x015A, 0x000F, 0x0169, 0x000F, 0x0178, 0x000F, 
	0x0187, 0x0001, 0x0196, 0x000F, 0x0197, 0x000F, 0x01A6, 0x000F, 0x01B5, 
	0x0002, 0x01C4, 0x0002, 0x01C6, 0x000F, 0x01C8, 0x000F, 0x01D7, 0x000F, 
	0x01E6, 0x000F, 0x01F5, 0x000F, 0x0204, 0x0009, 0x0213, 0x0001, 0x021C, 
	0x000F, 0x021D, 0x000F, 0x022C, 0x000F, 0x023B, 0x0002, 0x024A, 0x0001, 
	0x024C, 0x000F, 0x024D, 0x000F, 0x025C, 0x000F, 0x026B, 0x000F, 0x027A, 
	

});

smlua_anim_util_register_animation('donkey_C0_triple_jump_land',1, 0, 0, 0, 33, { 
	0x0000, 0x0087, 0x0078, 0x0078, 0x007A, 0x007E, 0x0086, 0x0093, 0x00A6, 
	0x00A4, 0x00A2, 0x00A1, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x00A0, 0x009F, 
	0x009E, 0x009D, 0x009B, 0x0098, 0x0094, 0x0090, 0x008B, 0xFFF2, 0xFFF4, 
	0xFFF4, 0xFFF4, 0xFFF4, 0xFFF5, 0xFFF5, 0xFFF6, 0xFFF6, 0xFFF6, 0xFFF5, 
	0xFFF5, 0xFFF5, 0xFFF5, 0xFFF5, 0xFFF5, 0xFFF5, 0xFFF6, 0xFFF7, 0xFFF8, 
	0xFFF9, 0xFFFB, 0xFFFD, 0x0000, 0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFE, 0x543A, 0x543A, 0x542D, 0x53D5, 0x52E4, 0x510F, 
	0x4E0A, 0x4988, 0x4988, 0x4988, 0x4988, 0x4988, 0x4988, 0x4988, 0x4988, 
	0x4988, 0x49BC, 0x4A57, 0x4B5A, 0x4CC3, 0x4E95, 0x50CD, 0x536E, 0x5675, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x08B7, 0x0D34, 0x0EB3, 0x0E7A, 0x0CE5, 0x089B, 0x0041, 0xF27A, 0xDDEF, 
	0xDCA1, 0xDBC7, 0xDB43, 0xDAFA, 0xDAD8, 0xDACB, 0xDAC8, 0xDAC8, 0xDBF5, 
	0xDF7E, 0xE561, 0xEDA0, 0xF83A, 0x052F, 0x147F, 0x1554, 0x159B, 0x150B, 
	0x135C, 0x108C, 0x0C9D, 0x08AE, 0x05DF, 0x042F, 0x039F, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xF9D8, 0xFBAF, 0xFCC9, 0xFD27, 0xFD45, 0xFE15, 
	0x004A, 0x0495, 0x0BA8, 0x1637, 0x1759, 0x1817, 0x188A, 0x18C9, 0x18E7, 
	0x18F2, 0x18F5, 0x18F5, 0x175C, 0x1292, 0x0A96, 0xFF67, 0xF107, 0xDF76, 
	0xDF9E, 0xDFAC, 0xE020, 0xE17C, 0xE3C1, 0xE6ED, 0xEA1A, 0xEC5E, 0xEDBB, 
	0xEE2F, 0x0001, 0xFFFE, 0xC170, 0xB00E, 0xB5FF, 0xB98F, 0xBABF, 0xBA0A, 
	0xB514, 0xA79F, 0x0D69, 0xE232, 0xA1BB, 0xA30B, 0xA3E6, 0xA46B, 0xA4B4, 
	0xA4D6, 0xA4E3, 0xA4E6, 0xA4E6, 0xA856, 0xB2A7, 0xC3D8, 0xDBE9, 0xFADB, 
	0x20AE, 0x1FC1, 0x1F72, 0x1F64, 0x1F3D, 0x1EFB, 0x1E9F, 0x1E43, 0x1E01, 
	0x1DD9, 0x1DCC, 0xADFA, 0xAB7E, 0xAA00, 0xA981, 0xA97F, 0xA977, 0xA95F, 
	0xD6CE, 0xD719, 0xD78A, 0xD8FD, 0xD9EF, 0xDA82, 0xDAD3, 0xDAF9, 0xDB07, 
	0xDB0A, 0xDB0B, 0xDA64, 0xD872, 0xD533, 0xD0A8, 0xCAD0, 0xC3AC, 0xC29B, 
	0xC240, 0xC2F6, 0xC518, 0xC8A6, 0xCDA1, 0xD29B, 0xD629, 0xD84B, 0xD901, 
	0x0000, 0xFE12, 0xFCEB, 0xFC88, 0xFD1A, 0x011A, 0x0BF1, 0xA10D, 0xC3DB, 
	0xF7C6, 0xF728, 0xF6C2, 0xF683, 0xF661, 0xF650, 0xF64A, 0xF649, 0xF649, 
	0xF49B, 0xEF91, 0xE72B, 0xDB6A, 0xCC4C, 0xB9D3, 0xBAA7, 0xBAEE, 0xBADA, 
	0xBA9D, 0xBA38, 0xB9AA, 0xB91D, 0xB8B8, 0xB87B, 0xB867, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xC06F, 0xBD08, 0xBAFD, 0xBA4F, 0xBA7D, 0xBBC2, 0xBF32, 0xC5E6, 
	0xD0F1, 0xE16B, 0xE16B, 0xE16B, 0xE16B, 0xE16B, 0xE16B, 0xE16B, 0xE16B, 
	0xE16B, 0xE032, 0xDC85, 0xD666, 0xCDD3, 0xC2CD, 0xB555, 0xB444, 0xB3E9, 
	0xB499, 0xB6AA, 0xBA1C, 0xBEEE, 0xC3C1, 0xC732, 0xC943, 0xC9F4, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFEF, 0xFF7E, 0xFE4D, 0xFBFA, 0xF826, 0xF26F, 
	0xF26F, 0xF26F, 0xF26F, 0xF26F, 0xF26F, 0xF26F, 0xF26F, 0xF26F, 0xF268, 
	0xF254, 0xF233, 0xF204, 0xF1C7, 0xF17E, 0xF174, 0xF171, 0xF21E, 0xF426, 
	0xF789, 0xFC46, 0x0104, 0x0466, 0x066E, 0x071C, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x000A, 0x004D, 0x0104, 0x0269, 0x04B5, 0x0822, 0x0822, 0x0822, 
	0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x0822, 0x077C, 0x0589, 0x024A, 
	0xFDBD, 0xF7E5, 0xF0C0, 0xEFC6, 0xEF72, 0xF00F, 0xF1E5, 0xF4F3, 0xF93B, 
	0xFD83, 0x0093, 0x0269, 0x0306, 0xEC16, 0xEC16, 0xEC16, 0xEC16, 0xEC19, 
	0xEC31, 0xEC73, 0xECF2, 0xEDC3, 0xEEFC, 0xEEFC, 0xEEFC, 0xEEFC, 0xEEFC, 
	0xEEFC, 0xEEFC, 0xEEFC, 0xEEFC, 0xEFE1, 0xF28E, 0xF704, 0xFD44, 0x054D, 
	0x0F1F, 0x0F18, 0x0F16, 0x0EF2, 0x0E85, 0x0DD0, 0x0CD3, 0x0BD5, 0x0B20, 
	0x0AB4, 0x0A90, 0x0001, 0xFFFE, 0xC170, 0xF488, 0xE5CF, 0x5CFA, 0x5A09, 
	0x5A0A, 0x5A13, 0x5A2D, 0x5A5F, 0x5AB1, 0x5B2B, 0x5BDE, 0x5C53, 0x5C9A, 
	0x5CC1, 0x5CD3, 0x5CDA, 0x5CDC, 0x5CDC, 0x585D, 0x4AE1, 0x3467, 0x14F0, 
	0xEC7B, 0x3B09, 0x3C15, 0x3C6F, 0x3C42, 0x3BBC, 0x3ADD, 0x39A5, 0x386C, 
	0x378D, 0x3707, 0x36DA, 0x35FC, 0x3461, 0x4C95, 0x4CE7, 0x4CBA, 0x4B7D, 
	0x4821, 0x4196, 0x36CD, 0x26B6, 0x248A, 0x231F, 0x2243, 0x21CA, 0x2191, 
	0x217B, 0x2176, 0x2176, 0x2243, 0x24A9, 0x28A8, 0x2E40, 0x3572, 0x41C2, 
	0x4029, 0x3FA0, 0x404B, 0x424B, 0x45A0, 0x4A4B, 0x4EF6, 0x524B, 0x544B, 
	0x54F5, 0xA297, 0x983A, 0x1203, 0x0FF1, 0x0FCA, 0x0EBD, 0x0BE1, 0x0650, 
	0xFD21, 0xEF6F, 0xF08A, 0xF143, 0xF1B3, 0xF1F0, 0xF20E, 0xF218, 0xF21B, 
	0xF21B, 0xEF5E, 0xE727, 0xD977, 0xC64C, 0xADA8, 0x0F8A, 0x1062, 0x10AA, 
	0x10DF, 0x1180, 0x128C, 0x1403, 0x157A, 0x1686, 0x1727, 0x175C, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xC888, 
	0xC300, 0xBFAE, 0xBE93, 0xBEB1, 0xBF7F, 0xC1B0, 0xC5F3, 0xCCFA, 0xD777, 
	0xD777, 0xD777, 0xD777, 0xD777, 0xD777, 0xD777, 0xD777, 0xD777, 0xD67C, 
	0xD38E, 0xCEAB, 0xC7D3, 0xBF08, 0xB448, 0xB337, 0xB2DC, 0xB3A0, 0xB5EC, 
	0xB9C1, 0xBF1E, 0xC47B, 0xC84F, 0xCA9C, 0xCB60, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0011, 0x0085, 0x01BF, 0x0425, 0x0818, 0x0DFC, 0x0DFC, 0x0DFC, 
	0x0DFC, 0x0DFC, 0x0DFC, 0x0DFC, 0x0DFC, 0x0DFC, 0x0D44, 0x0B1F, 0x078A, 
	0x0287, 0xFC15, 0xF435, 0xF41B, 0xF413, 0xF444, 0xF4D8, 0xF5D0, 0xF72A, 
	0xF884, 0xF97C, 0xFA10, 0xFA42, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFF3, 
	0xFF9C, 0xFEB0, 0xFCE5, 0xF9F1, 0xF588, 0xF588, 0xF588, 0xF588, 0xF588, 
	0xF588, 0xF588, 0xF588, 0xF588, 0xF5FE, 0xF761, 0xF9B0, 0xFCEC, 0x0115, 
	0x0629, 0x0723, 0x0776, 0x0747, 0x06BA, 0x05CF, 0x0487, 0x033E, 0x0253, 
	0x01C6, 0x0197, 0xE75A, 0xE75A, 0xE75A, 0xE75A, 0xE770, 0xE80B, 0xE9AE, 
	0xECDF, 0xF222, 0xF9FB, 0xF9FB, 0xF9FB, 0xF9FB, 0xF9FB, 0xF9FB, 0xF9FB, 
	0xF9FB, 0xF9FB, 0xFA63, 0xFB9C, 0xFDA6, 0x0082, 0x042D, 0x08AA, 0x08A5, 
	0x08A4, 0x0890, 0x0854, 0x07F0, 0x0764, 0x06D8, 0x0674, 0x0638, 0x0624, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xBF5E, 0x017C, 0x0475, 0x0470, 0x044B, 0x03E7, 0x0323, 
	0x01E1, 0x0000, 0x0075, 0x00C1, 0x00EF, 0x0109, 0x0115, 0x0119, 0x011B, 
	0x011B, 0x0111, 0x00F3, 0x00C1, 0x007B, 0x0021, 0xFFB2, 0xFF31, 0xFE9B, 
	0xF819, 0xF94C, 0xF94E, 0xF95A, 0xF97D, 0xF9BF, 0xFA2C, 0xFACF, 0xFADB, 
	0xFAE4, 0xFAE9, 0xFAEB, 0xFAED, 0xFAED, 0xFAED, 0xFAED, 0xFAC1, 0xFA3E, 
	0xF963, 0xF830, 0xF6A6, 0xF4C4, 0xF28A, 0xEFF9, 0x791A, 0x68A3, 0x68E4, 
	0x6AAB, 0x6F7E, 0x78E2, 0x885D, 0x9F75, 0x9BD5, 0x9978, 0x9809, 0x973F, 
	0x96DF, 0x96BC, 0x96B3, 0x96B3, 0x9666, 0x9582, 0x9404, 0x91EE, 0x8F3F, 
	0x8BF7, 0x8817, 0x839E, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x5105, 0x638B, 0x6346, 0x6161, 0x5C3E, 0x523C, 0x41BD, 0x2921, 
	0x2E04, 0x3133, 0x3323, 0x3433, 0x34B4, 0x34E4, 0x34EF, 0x34F0, 0x3544, 
	0x3640, 0x37E4, 0x3A2F, 0x3D23, 0x40BF, 0x4502, 0x49EE, 0xF98C, 0xF972, 
	0xF971, 0xF966, 0xF94A, 0xF913, 0xF8B7, 0xF82F, 0xF828, 0xF824, 0xF821, 
	0xF81F, 0xF81F, 0xF81E, 0xF81E, 0xF81E, 0xF81D, 0xF817, 0xF80F, 0xF802, 
	0xF7F2, 0xF7DF, 0xF7C8, 0xF7AE, 0xF901, 0xF912, 0xF912, 0xF913, 0xF914, 
	0xF916, 0xF91A, 0xF920, 0xF901, 0xF8EE, 0xF8E2, 0xF8DB, 0xF8D8, 0xF8D7, 
	0xF8D7, 0xF8D7, 0xF902, 0xF985, 0xFA60, 0xFB92, 0xFD1C, 0xFEFD, 0x0136, 
	0x03C6, 0xAEF1, 0xAD91, 0xADA3, 0xAE1E, 0xAF6B, 0xB1F5, 0xB625, 0xBC64, 
	0xBB52, 0xBAA0, 0xBA34, 0xB9F8, 0xB9DC, 0xB9D2, 0xB9CF, 0xB9CF, 0xB996, 
	0xB8EB, 0xB7CE, 0xB640, 0xB43F, 0xB1CD, 0xAEE8, 0xAB92, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xBF5E, 0xFD3A, 0xFAF8, 0xFAFE, 0xFB28, 0xFB99, 0xFC75, 
	0xFDE1, 0xFFFF, 0xFF88, 0xFF3A, 0xFF0A, 0xFEF0, 0xFEE4, 0xFEDF, 0xFEDE, 
	0xFEDE, 0xFEEA, 0xFF0C, 0xFF46, 0xFF96, 0xFFFE, 0x007E, 0x0113, 0x01C0, 
	0x065F, 0x04CC, 0x04CD, 0x04D1, 0x04DC, 0x04F2, 0x0516, 0x054C, 0x053F, 
	0x0537, 0x0532, 0x052F, 0x052E, 0x052D, 0x052D, 0x052D, 0x055F, 0x05F4, 
	0x06EC, 0x0847, 0x0A05, 0x0C26, 0x0EAB, 0x1192, 0x7903, 0x68B2, 0x68F3, 
	0x6AB9, 0x6F8A, 0x78EC, 0x8863, 0x9F75, 0x9BD5, 0x9978, 0x9808, 0x973E, 
	0x96DE, 0x96BB, 0x96B3, 0x96B2, 0x9668, 0x958A, 0x9417, 0x9210, 0x8F75, 
	0x8C46, 0x8883, 0x842B, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x5105, 
	0x638B, 0x6346, 0x6161, 0x5C3E, 0x523C, 0x41BD, 0x2921, 0x2E04, 0x3133, 
	0x3323, 0x3433, 0x34B4, 0x34E4, 0x34EF, 0x34F0, 0x3545, 0x3643, 0x37EB, 
	0x3A3C, 0x3D37, 0x40DB, 0x4529, 0x4A21, 0x0786, 0x079F, 0x079E, 0x079C, 
	0x0797, 0x078B, 0x0779, 0x075D, 0x076C, 0x0775, 0x077B, 0x077E, 0x0780, 
	0x0780, 0x0781, 0x0781, 0x078A, 0x07A6, 0x07D4, 0x0815, 0x0869, 0x08CF, 
	0x0947, 0x09D3, 0x052E, 0x054A, 0x054A, 0x0548, 0x0544, 0x053C, 0x052F, 
	0x051B, 0x0558, 0x0580, 0x0598, 0x05A5, 0x05AB, 0x05AD, 0x05AE, 0x05AE, 
	0x0590, 0x0536, 0x04A1, 0x03CF, 0x02C2, 0x0179, 0xFFF3, 0xFE32, 0xAEC7, 
	0xAD6C, 0xAD7E, 0xADF8, 0xAF42, 0xB1C6, 0xB5EC, 0xBC1C, 0xBB0F, 0xBA5F, 
	0xB9F5, 0xB9BA, 0xB99E, 0xB994, 0xB992, 0xB992, 0xB95A, 0xB8B5, 0xB7A0, 
	0xB61E, 0xB42D, 0xB1CD, 0xAEFF, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0018, 0x0001, 0x0018, 0x0019, 0x0001, 0x0031, 0x0001, 
	0x0032, 0x0001, 0x0033, 0x0011, 0x0034, 0x0018, 0x0045, 0x0018, 0x005D, 
	0x0012, 0x0075, 0x0009, 0x0087, 0x0022, 0x0090, 0x001D, 0x00B2, 0x0015, 
	0x00CF, 0x0022, 0x00E4, 0x0001, 0x0106, 0x0001, 0x0107, 0x0001, 0x0108, 
	0x0022, 0x0109, 0x0022, 0x012B, 0x0022, 0x014D, 0x0021, 0x016F, 0x0021, 
	0x0190, 0x0022, 0x01B1, 0x0022, 0x01D3, 0x0022, 0x01F5, 0x0022, 0x0217, 
	0x0001, 0x0239, 0x0001, 0x023A, 0x0001, 0x023B, 0x0022, 0x023C, 0x0022, 
	0x025E, 0x0022, 0x0280, 0x0015, 0x02A2, 0x0018, 0x02B7, 0x0022, 0x02CF, 
	0x0022, 0x02F1, 0x0022, 0x0313, 0x0022, 0x0335, 0x0018, 0x0357, 0x0017, 
	0x036F, 0x0001, 0x0386, 0x0018, 0x0387, 0x0018, 0x039F, 0x0018, 0x03B7, 
	0x0011, 0x03CF, 0x0008, 0x03E0, 0x0018, 0x03E8, 0x0018, 0x0400, 0x0018, 
	0x0418, 0x0018, 0x0430, 0x0017, 0x0448, 0x0008, 0x045F, 0x0001, 0x0467, 
	0x0018, 0x0468, 0x0018, 0x0480, 0x0018, 0x0498, 0x0012, 0x04B0, 0x0017, 
	0x04C2, 0x0018, 0x04D9, 0x0018, 0x04F1, 0x0018, 0x0509, 0x0018, 0x0521, 
	

});

smlua_anim_util_register_animation('donkey_98_crouching',0, 0, 0, 0, 89, { 
	0x0000, 0x008E, 0xFFEA, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0x50ED, 
	0x50E7, 0x50D6, 0x50BC, 0x509A, 0x5073, 0x5049, 0x501C, 0x4FF0, 0x4FC5, 
	0x4F9F, 0x4F7D, 0x4F63, 0x4F52, 0x4F4C, 0x4F51, 0x4F60, 0x4F77, 0x4F95, 
	0x4FB8, 0x4FDF, 0x5008, 0x5031, 0x505A, 0x5081, 0x50A4, 0x50C2, 0x50D9, 
	0x50E8, 0x50ED, 0x50E8, 0x50D9, 0x50C2, 0x50A4, 0x5081, 0x505A, 0x5031, 
	0x5008, 0x4FDF, 0x4FB8, 0x4F95, 0x4F77, 0x4F60, 0x4F51, 0x4F4C, 0x4F51, 
	0x4F60, 0x4F77, 0x4F95, 0x4FB8, 0x4FDF, 0x5008, 0x5031, 0x505A, 0x5081, 
	0x50A4, 0x50C2, 0x50D9, 0x50E8, 0x50ED, 0x50E8, 0x50D9, 0x50C2, 0x50A4, 
	0x5081, 0x505A, 0x5031, 0x5008, 0x4FDF, 0x4FB8, 0x4F95, 0x4F77, 0x4F60, 
	0x4F51, 0x4F4C, 0x4F51, 0x4F60, 0x4F77, 0x4F95, 0x4FB8, 0x4FDF, 0x5008, 
	0x5031, 0x505A, 0x5081, 0x50A4, 0x50C2, 0x50D9, 0x50E8, 0x50ED, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0011, 0x003E, 0x0080, 0x00CE, 0x0120, 0x016E, 0x01B0, 0x01DE, 
	0x01EF, 0x01DE, 0x01B0, 0x016F, 0x0120, 0x00CC, 0x007B, 0x0034, 0xFFFF, 
	0xFFDC, 0xFFC2, 0xFFB2, 0xFFA7, 0xFFA2, 0xFFA0, 0xFFA0, 0xFFA3, 0xFFAA, 
	0xFFB4, 0xFFC1, 0xFFCF, 0xFFDD, 0xFFEA, 0xFFF5, 0xFFFC, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0026, 0x008B, 0x011D, 0x01CA, 0x0280, 0x032E, 0x03C0, 0x0425, 
	0x044B, 0x0439, 0x0403, 0x03AA, 0x0330, 0x0294, 0x01D7, 0x00FB, 0xFFFF, 
	0xFEE9, 0xFDC8, 0xFCB0, 0xFBB4, 0xFAE8, 0xFA5F, 0xFA2D, 0xFA57, 0xFAC8, 
	0xFB6F, 0xFC3A, 0xFD16, 0xFDF3, 0xFEBD, 0xFF64, 0xFFD5, 0xFFFF, 0x2E60, 
	0x2E81, 0x2ED7, 0x2F4D, 0x2FCD, 0x3043, 0x3098, 0x30BA, 0x30B5, 0x30A6, 
	0x308F, 0x3071, 0x304E, 0x3028, 0x2FFF, 0x2FD6, 0x2FAD, 0x2F87, 0x2F64, 
	0x2F47, 0x2F30, 0x2F21, 0x2F1B, 0x2F21, 0x2F30, 0x2F49, 0x2F68, 0x2F8E, 
	0x2FB9, 0x2FE8, 0x301A, 0x304C, 0x307F, 0x30B0, 0x30DF, 0x310A, 0x3130, 
	0x3150, 0x3168, 0x3177, 0x317D, 0x3173, 0x3156, 0x312A, 0x30F1, 0x30AE, 
	0x3064, 0x3016, 0x2FC7, 0x2F78, 0x2F2F, 0x2EEC, 0x2EB3, 0x2E87, 0x2E6A, 
	0x2E60, 0x2E69, 0x2E82, 0x2EAA, 0x2EE2, 0x2F27, 0x2F78, 0x2FD5, 0x303D, 
	0x30AE, 0x3127, 0x31A3, 0x321B, 0x328B, 0x32EC, 0x3339, 0x336B, 0x337D, 
	0x3373, 0x3356, 0x3327, 0x32E8, 0x329A, 0x3240, 0x31D9, 0x3169, 0x30F3, 
	0x307B, 0x3005, 0x2F96, 0x2F31, 0x2EDC, 0x2E9A, 0x2E6F, 0x2E60, 0x0000, 
	0x0001, 0x0005, 0x000A, 0x0012, 0x001B, 0x0027, 0x0034, 0x0043, 0x0053, 
	0x0066, 0x0079, 0x008E, 0x00A4, 0x00BC, 0x00D4, 0x00EE, 0x0109, 0x0124, 
	0x0140, 0x015D, 0x017B, 0x0199, 0x01B8, 0x01D7, 0x01F6, 0x0216, 0x0235, 
	0x0255, 0x0275, 0x0294, 0x02B3, 0x02D2, 0x02F1, 0x030F, 0x032D, 0x034A, 
	0x0366, 0x0382, 0x039C, 0x03B6, 0x03CE, 0x03E6, 0x03FC, 0x0411, 0x0425, 
	0x0437, 0x0447, 0x0456, 0x0464, 0x046F, 0x0478, 0x0480, 0x0485, 0x0489, 
	0x048A, 0x03EF, 0x024B, 0xFFDF, 0xFCEF, 0xF9BD, 0xF68A, 0xF39A, 0xF12F, 
	0xEF8B, 0xEEF0, 0xEFC3, 0xF1FC, 0xF53B, 0xF920, 0xFD4A, 0x0159, 0x04ED, 
	0x07BA, 0x09C8, 0x0B36, 0x0C1F, 0x0CA2, 0x0CDB, 0x0CE7, 0x0C8B, 0x0B90, 
	0x0A1E, 0x085D, 0x0674, 0x048B, 0x02CA, 0x0158, 0x005D, 0x0000, 0x0001, 
	0x0001, 0x0002, 0x0003, 0x0004, 0x0006, 0x0009, 0x000C, 0x000F, 0x0012, 
	0x0016, 0x001A, 0x001F, 0x0023, 0x0028, 0x002E, 0x0033, 0x0039, 0x003F, 
	0x0045, 0x004B, 0x0051, 0x0058, 0x005E, 0x0065, 0x006B, 0x0072, 0x0079, 
	0x0080, 0x0086, 0x008D, 0x0094, 0x009A, 0x00A1, 0x00A7, 0x00AE, 0x00B4, 
	0x00BA, 0x00C0, 0x00C5, 0x00CB, 0x00D0, 0x00D5, 0x00DA, 0x00DE, 0x00E2, 
	0x00E6, 0x00EA, 0x00ED, 0x00F0, 0x00F2, 0x00F4, 0x00F6, 0x00F7, 0x00F8, 
	0x00F8, 0x008A, 0xFF5D, 0xFDA4, 0xFB8D, 0xF946, 0xF6FF, 0xF4E7, 0xF32E, 
	0xF203, 0xF195, 0xF1E9, 0xF2DA, 0xF44F, 0xF635, 0xF874, 0xFAF8, 0xFDAB, 
	0x0075, 0x0334, 0x05C3, 0x07FF, 0x09C4, 0x0AEF, 0x0B5A, 0x0B09, 0x0A2C, 
	0x08E6, 0x075B, 0x05AD, 0x03FF, 0x0274, 0x012F, 0x0052, 0x0001, 0xCBD9, 
	0xCBD9, 0xCBD9, 0xCBD9, 0xCBD9, 0xCBDA, 0xCBDA, 0xCBDA, 0xCBDA, 0xCBDB, 
	0xCBDB, 0xCBDC, 0xCBDC, 0xCBDD, 0xCBDD, 0xCBDE, 0xCBDF, 0xCBDF, 0xCBE0, 
	0xCBE1, 0xCBE1, 0xCBE2, 0xCBE3, 0xCBE3, 0xCBE4, 0xCBE5, 0xCBE6, 0xCBE6, 
	0xCBE7, 0xCBE8, 0xCBE9, 0xCBE9, 0xCBEA, 0xCBEB, 0xCBEC, 0xCBEC, 0xCBED, 
	0xCBEE, 0xCBEE, 0xCBEF, 0xCBF0, 0xCBF0, 0xCBF1, 0xCBF1, 0xCBF2, 0xCBF2, 
	0xCBF3, 0xCBF3, 0xCBF3, 0xCBF4, 0xCBF4, 0xCBF4, 0xCBF4, 0xCBF4, 0xCBF5, 
	0xCBF5, 0xCB45, 0xC969, 0xC6AB, 0xC357, 0xBFB8, 0xBC18, 0xB8C4, 0xB606, 
	0xB42A, 0xB37B, 0xB3F6, 0xB535, 0xB6EA, 0xB8C5, 0xBA79, 0xBBB8, 0xBC34, 
	0xBB7C, 0xB9A3, 0xB71C, 0xB45B, 0xB1D4, 0xAFFB, 0xAF44, 0xB011, 0xB23D, 
	0xB570, 0xB953, 0xBD8E, 0xC1C9, 0xC5AC, 0xC8E0, 0xCB0C, 0xCBD9, 0x0001, 
	0xFFFE, 0xC170, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 0x4796, 
	0x4796, 0x4796, 0x4796, 0x4796, 0x47DA, 0x48A0, 0x49DB, 0x4B82, 0x4D87, 
	0x4FE2, 0x5285, 0x5566, 0x5879, 0x5BB4, 0x5F0B, 0x6273, 0x65E0, 0x6948, 
	0x6C9F, 0x6FDA, 0x72ED, 0x75CE, 0x7871, 0x7ACB, 0x7CD1, 0x7E78, 0x7FB3, 
	0x8079, 0x80BD, 0x7EC7, 0x7987, 0x71EC, 0x68E8, 0x5F6B, 0x5667, 0x4ECC, 
	0x498C, 0x4796, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 
	0xDBEB, 0xDBEB, 0xDBEB, 0xDBEB, 0xDBE8, 0xDBDF, 0xDBD1, 0xDBBE, 0xDBA8, 
	0xDB8D, 0xDB70, 0xDB4F, 0xDB2D, 0xDB08, 0xDAE3, 0xDABC, 0xDA96, 0xDA6F, 
	0xDA4A, 0xDA26, 0xDA03, 0xD9E3, 0xD9C5, 0xD9AA, 0xD994, 0xD981, 0xD973, 
	0xD96B, 0xD968, 0xD97E, 0xD9B9, 0xDA0E, 0xDA74, 0xDADE, 0xDB44, 0xDB99, 
	0xDBD5, 0xDBEB, 0x3819, 0x3814, 0x3806, 0x37F2, 0x37DA, 0x37C2, 0x37AA, 
	0x3796, 0x3789, 0x3784, 0x378B, 0x379E, 0x37BD, 0x37E4, 0x3812, 0x3844, 
	0x387A, 0x38B1, 0x38E6, 0x3919, 0x3947, 0x396E, 0x398C, 0x39A0, 0x39A7, 
	0x39A3, 0x3996, 0x3982, 0x3968, 0x3949, 0x3926, 0x38FF, 0x38D6, 0x38AB, 
	0x3880, 0x3855, 0x382C, 0x3805, 0x37E1, 0x37C2, 0x37A8, 0x3795, 0x3788, 
	0x3784, 0x3787, 0x378F, 0x379B, 0x37AA, 0x37BC, 0x37CE, 0x37E1, 0x37F2, 
	0x3801, 0x380E, 0x3816, 0x3819, 0x37C8, 0x36E1, 0x356E, 0x337F, 0x311F, 
	0x2E5D, 0x2B44, 0x27E4, 0x2448, 0x207D, 0x1C92, 0x1893, 0x148E, 0x108F, 
	0x0CA4, 0x08D9, 0x053D, 0x01DC, 0xFEC3, 0xFC01, 0xF9A1, 0xF7B2, 0xF63F, 
	0xF557, 0xF507, 0xF754, 0xFD7E, 0x066B, 0x1100, 0x1C21, 0x26B6, 0x2FA2, 
	0x35CC, 0x3819, 0x060E, 0x05FB, 0x05C7, 0x057A, 0x051D, 0x04B8, 0x0453, 
	0x03F6, 0x03AA, 0x0376, 0x0363, 0x036F, 0x0392, 0x03C7, 0x040C, 0x045D, 
	0x04B7, 0x0516, 0x0576, 0x05D5, 0x062E, 0x067F, 0x06C4, 0x06FA, 0x071D, 
	0x0729, 0x0720, 0x0708, 0x06E1, 0x06AF, 0x0673, 0x062E, 0x05E4, 0x0596, 
	0x0546, 0x04F6, 0x04A8, 0x045D, 0x0419, 0x03DD, 0x03AA, 0x0384, 0x036B, 
	0x0363, 0x0370, 0x0395, 0x03CE, 0x0414, 0x0464, 0x04B8, 0x050D, 0x055D, 
	0x05A3, 0x05DB, 0x0600, 0x060E, 0x0605, 0x05ED, 0x05C6, 0x0593, 0x0553, 
	0x0509, 0x04B7, 0x045C, 0x03FC, 0x0396, 0x032E, 0x02C3, 0x0257, 0x01EC, 
	0x0184, 0x011E, 0x00BE, 0x0063, 0x0011, 0xFFC6, 0xFF86, 0xFF53, 0xFF2C, 
	0xFF14, 0xFF0B, 0xFF49, 0xFFEE, 0x00DD, 0x01F8, 0x0322, 0x043D, 0x052B, 
	0x05D0, 0x060E, 0xE5DB, 0xE5E6, 0xE602, 0xE62C, 0xE65E, 0xE695, 0xE6CC, 
	0xE6FF, 0xE729, 0xE745, 0xE750, 0xE74A, 0xE73A, 0xE721, 0xE702, 0xE6DC, 
	0xE6B3, 0xE688, 0xE65B, 0xE630, 0xE607, 0xE5E1, 0xE5C2, 0xE5A9, 0xE599, 
	0xE593, 0xE597, 0xE5A3, 0xE5B4, 0xE5CB, 0xE5E7, 0xE607, 0xE629, 0xE64D, 
	0xE671, 0xE696, 0xE6BA, 0xE6DC, 0xE6FC, 0xE717, 0xE72F, 0xE740, 0xE74C, 
	0xE750, 0xE74E, 0xE74B, 0xE743, 0xE737, 0xE727, 0xE710, 0xE6F2, 0xE6CD, 
	0xE69F, 0xE668, 0xE627, 0xE5DB, 0xE584, 0xE522, 0xE4B7, 0xE444, 0xE3CA, 
	0xE34B, 0xE2C7, 0xE23F, 0xE1B6, 0xE12B, 0xE0A1, 0xE018, 0xDF92, 0xDF10, 
	0xDE93, 0xDE1C, 0xDDAD, 0xDD46, 0xDCE9, 0xDC97, 0xDC51, 0xDC19, 0xDBEF, 
	0xDBD5, 0xDBCD, 0xDC25, 0xDD11, 0xDE68, 0xDFFE, 0xE1A9, 0xE340, 0xE496, 
	0xE583, 0xE5DB, 0xA890, 0xA899, 0xA8B2, 0xA8D7, 0xA904, 0xA935, 0xA966, 
	0xA993, 0xA9B8, 0xA9D1, 0xA9DA, 0xA9D4, 0xA9C3, 0xA9A9, 0xA987, 0xA960, 
	0xA934, 0xA906, 0xA8D6, 0xA8A8, 0xA87C, 0xA855, 0xA833, 0xA819, 0xA808, 
	0xA802, 0xA806, 0xA812, 0xA825, 0xA83E, 0xA85B, 0xA87C, 0xA8A1, 0xA8C7, 
	0xA8EE, 0xA915, 0xA93C, 0xA960, 0xA981, 0xA99F, 0xA9B7, 0xA9CA, 0xA9D6, 
	0xA9DA, 0xA9D4, 0xA9C2, 0xA9A7, 0xA985, 0xA95E, 0xA935, 0xA90C, 0xA8E6, 
	0xA8C4, 0xA8A9, 0xA897, 0xA890, 0xA8A7, 0xA8EA, 0xA954, 0xA9E3, 0xAA92, 
	0xAB5D, 0xAC41, 0xAD3A, 0xAE44, 0xAF5B, 0xB07C, 0xB1A2, 0xB2CA, 0xB3F1, 
	0xB511, 0xB628, 0xB732, 0xB82B, 0xB90F, 0xB9DA, 0xBA89, 0xBB18, 0xBB82, 
	0xBBC5, 0xBBDC, 0xBB33, 0xB96D, 0xB6DB, 0xB3D0, 0xB09C, 0xAD91, 0xAB00, 
	0xA93A, 0xA890, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 
	0xEBDE, 0xEBDE, 0xEBDE, 0xEBDE, 0xEBD3, 0xEBB5, 0xEB83, 0xEB41, 0xEAEF, 
	0xEA90, 0xEA25, 0xE9AF, 0xE930, 0xE8AA, 0xE81F, 0xE78F, 0xE6FD, 0xE66A, 
	0xE5D8, 0xE549, 0xE4BD, 0xE437, 0xE3B9, 0xE343, 0xE2D7, 0xE278, 0xE227, 
	0xE1E4, 0xE1B3, 0xE194, 0xE18A, 0xE21C, 0xE396, 0xE59A, 0xE7CD, 0xE9D2, 
	0xEB4B, 0xEBDE, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 
	0xEFEB, 0xEFEB, 0xEFEB, 0xEFEB, 0xEFDF, 0xEFBC, 0xEF84, 0xEF39, 0xEEDD, 
	0xEE71, 0xEDF8, 0xED73, 0xECE4, 0xEC4C, 0xEBAE, 0xEB0C, 0xEA67, 0xE9C1, 
	0xE91C, 0xE879, 0xE7DB, 0xE744, 0xE6B5, 0xE630, 0xE5B6, 0xE54B, 0xE4EE, 
	0xE4A3, 0xE46C, 0xE449, 0xE43D, 0xE4E3, 0xE68E, 0xE8D6, 0xEB52, 0xED9A, 
	0xEF45, 0xEFEB, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B18, 
	0x0B18, 0x0B18, 0x0B18, 0x0B18, 0x0B15, 0x0B0E, 0x0B02, 0x0AF2, 0x0ADF, 
	0x0AC8, 0x0AAF, 0x0A92, 0x0A74, 0x0A54, 0x0A33, 0x0A10, 0x09EE, 0x09CA, 
	0x09A8, 0x0985, 0x0964, 0x0944, 0x0926, 0x0909, 0x08F0, 0x08D9, 0x08C6, 
	0x08B6, 0x08AA, 0x08A3, 0x08A0, 0x08C3, 0x091D, 0x0999, 0x0A1F, 0x0A9B, 
	0x0AF5, 0x0B18, 0x0001, 0xFFFE, 0xC170, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 
	0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBF7D, 0xBE2E, 0xBAAE, 
	0xB59D, 0xAF9B, 0xA949, 0xA347, 0x9E36, 0x9AB6, 0x9968, 0x9995, 0x9A19, 
	0x9AEB, 0x9C04, 0x9D5D, 0x9EEF, 0xA0B1, 0xA29C, 0xA4A8, 0xA6CF, 0xA909, 
	0xAB4E, 0xAD96, 0xAFDB, 0xB215, 0xB43C, 0xB649, 0xB834, 0xB9F6, 0xBB87, 
	0xBCE0, 0xBDF9, 0xBECB, 0xBF4F, 0xBF7D, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 
	0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FC3, 0x1FD8, 0x2013, 
	0x2068, 0x20CC, 0x2136, 0x219B, 0x21F0, 0x222A, 0x2240, 0x223D, 0x2235, 
	0x2227, 0x2214, 0x21FE, 0x21E4, 0x21C6, 0x21A6, 0x2184, 0x2160, 0x213A, 
	0x2114, 0x20EE, 0x20C8, 0x20A3, 0x207F, 0x205D, 0x203D, 0x201F, 0x2005, 
	0x1FEE, 0x1FDC, 0x1FCE, 0x1FC6, 0x1FC3, 0x3F9E, 0x3F99, 0x3F8C, 0x3F78, 
	0x3F60, 0x3F47, 0x3F30, 0x3F1C, 0x3F0E, 0x3F09, 0x3F10, 0x3F24, 0x3F42, 
	0x3F69, 0x3F97, 0x3FCA, 0x4000, 0x4036, 0x406C, 0x409F, 0x40CD, 0x40F4, 
	0x4112, 0x4126, 0x412D, 0x4128, 0x411C, 0x4108, 0x40EE, 0x40CF, 0x40AB, 
	0x4085, 0x405B, 0x4031, 0x4005, 0x3FDB, 0x3FB1, 0x3F8B, 0x3F67, 0x3F48, 
	0x3F2E, 0x3F1A, 0x3F0E, 0x3F09, 0x3F0C, 0x3F14, 0x3F21, 0x3F30, 0x3F41, 
	0x3F54, 0x3F66, 0x3F78, 0x3F87, 0x3F93, 0x3F9B, 0x3F9E, 0x3E70, 0x3B44, 
	0x36AE, 0x313D, 0x2B84, 0x2613, 0x217D, 0x1E51, 0x1D23, 0x1D4C, 0x1DC3, 
	0x1E82, 0x1F80, 0x20B9, 0x2224, 0x23BB, 0x2578, 0x2753, 0x2946, 0x2B4A, 
	0x2D58, 0x2F69, 0x3177, 0x337B, 0x356E, 0x3749, 0x3906, 0x3A9D, 0x3C08, 
	0x3D41, 0x3E40, 0x3EFE, 0x3F75, 0x3F9E, 0xFA09, 0xFA20, 0xFA5F, 0xFABC, 
	0xFB2C, 0xFBA7, 0xFC21, 0xFC92, 0xFCEF, 0xFD2E, 0xFD45, 0xFD37, 0xFD11, 
	0xFCD6, 0xFC8A, 0xFC31, 0xFBCF, 0xFB66, 0xFAFC, 0xFA94, 0xFA31, 0xF9D8, 
	0xF98C, 0xF951, 0xF92B, 0xF91E, 0xF927, 0xF942, 0xF96D, 0xF9A4, 0xF9E6, 
	0xFA31, 0xFA83, 0xFAD9, 0xFB31, 0xFB8A, 0xFBE0, 0xFC31, 0xFC7C, 0xFCBF, 
	0xFCF6, 0xFD20, 0xFD3B, 0xFD45, 0xFD39, 0xFD17, 0xFCE4, 0xFCA2, 0xFC56, 
	0xFC03, 0xFBAC, 0xFB55, 0xFB02, 0xFAB7, 0xFA77, 0xFA45, 0xFA22, 0xFA01, 
	0xF9D0, 0xF980, 0xF8FF, 0xF83C, 0xF727, 0xF5AF, 0xF3C4, 0xF11D, 0xEE77, 
	0xED43, 0xEDEB, 0xEF9B, 0xF1ED, 0xF478, 0xF6D3, 0xF897, 0xF95C, 0xF97D, 
	0xF999, 0xF9B1, 0xF9C5, 0xF9D6, 0xF9E4, 0xF9EF, 0xF9F8, 0xF9FE, 0xFA03, 
	0xFA06, 0xFA08, 0xFA09, 0x197B, 0x1967, 0x192F, 0x18DD, 0x1879, 0x180D, 
	0x17A0, 0x173D, 0x16EA, 0x16B3, 0x169E, 0x16A2, 0x16AE, 0x16BF, 0x16D6, 
	0x16F0, 0x170D, 0x172C, 0x174C, 0x176B, 0x1788, 0x17A3, 0x17B9, 0x17CB, 
	0x17D6, 0x17DA, 0x17D7, 0x17CF, 0x17C3, 0x17B2, 0x179F, 0x1788, 0x1770, 
	0x1756, 0x173C, 0x1722, 0x1708, 0x16F0, 0x16DA, 0x16C6, 0x16B6, 0x16A9, 
	0x16A1, 0x169E, 0x169E, 0x169F, 0x16A0, 0x16A3, 0x16A7, 0x16AE, 0x16B7, 
	0x16C2, 0x16D2, 0x16E5, 0x16FC, 0x1718, 0x17B8, 0x193B, 0x1B75, 0x1E37, 
	0x2154, 0x249F, 0x27E9, 0x2B05, 0x2DC6, 0x2FFD, 0x3178, 0x3201, 0x31BE, 
	0x3102, 0x2FE5, 0x2E7B, 0x2CDC, 0x2B1D, 0x2955, 0x2796, 0x25E7, 0x2448, 
	0x22BE, 0x2149, 0x1FED, 0x1EAC, 0x1D87, 0x1C82, 0x1B9F, 0x1AE0, 0x1A47, 
	0x19D7, 0x1993, 0x197B, 0xA84E, 0xA85A, 0xA87B, 0xA8AB, 0xA8E5, 0xA925, 
	0xA964, 0xA99F, 0xA9CF, 0xA9EF, 0xA9FB, 0xA9F4, 0xA9E1, 0xA9C2, 0xA99B, 
	0xA96D, 0xA93A, 0xA905, 0xA8CE, 0xA898, 0xA865, 0xA837, 0xA810, 0xA7F2, 
	0xA7DE, 0xA7D7, 0xA7DC, 0xA7EA, 0xA800, 0xA81C, 0xA83E, 0xA865, 0xA88F, 
	0xA8BC, 0xA8E9, 0xA917, 0xA943, 0xA96D, 0xA994, 0xA9B6, 0xA9D3, 0xA9E9, 
	0xA9F6, 0xA9FB, 0xA9F5, 0xA9E3, 0xA9C9, 0xA9A8, 0xA982, 0xA95A, 0xA932, 
	0xA90C, 0xA8EB, 0xA8D1, 0xA8BF, 0xA8B9, 0xA972, 0xAB63, 0xAE32, 0xB186, 
	0xB508, 0xB85C, 0xBB2B, 0xBD1C, 0xBDD5, 0xBC30, 0xB921, 0xB77C, 0xB7B0, 
	0xB837, 0xB8EF, 0xB9B8, 0xBA70, 0xBAF7, 0xBB2B, 0xBAEE, 0xBA41, 0xB935, 
	0xB7DC, 0xB647, 0xB487, 0xB2AE, 0xB0CC, 0xAEF2, 0xAD32, 0xAB9D, 0xAA44, 
	0xA939, 0xA88C, 0xA84E, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 
	0x122A, 0x122A, 0x122A, 0x122A, 0x122A, 0x1253, 0x12C3, 0x136E, 0x1443, 
	0x1536, 0x1637, 0x1738, 0x182A, 0x1900, 0x19AA, 0x1A1B, 0x1A44, 0x1A37, 
	0x1A13, 0x19DA, 0x198F, 0x1933, 0x18C9, 0x1853, 0x17D4, 0x174E, 0x16C4, 
	0x1637, 0x15AA, 0x151F, 0x1499, 0x141A, 0x13A4, 0x133A, 0x12DE, 0x1293, 
	0x125A, 0x1236, 0x122A, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 
	0x119B, 0x119B, 0x119B, 0x119B, 0x119B, 0x11CF, 0x125E, 0x1336, 0x1445, 
	0x1579, 0x16BE, 0x1804, 0x1938, 0x1A47, 0x1B1F, 0x1BAE, 0x1BE2, 0x1BD2, 
	0x1BA5, 0x1B5C, 0x1AFD, 0x1A88, 0x1A02, 0x196C, 0x18CB, 0x1821, 0x1771, 
	0x16BE, 0x160B, 0x155C, 0x14B2, 0x1410, 0x137B, 0x12F5, 0x1280, 0x1220, 
	0x11D8, 0x11AB, 0x119B, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 
	0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0F26, 0x0EBA, 0x0D90, 0x0BCC, 0x0997, 
	0x0715, 0x046D, 0x01C5, 0xFF42, 0xFD0D, 0xFB4A, 0xFA1F, 0xF9B3, 0xF9D4, 
	0xFA33, 0xFAC9, 0xFB91, 0xFC85, 0xFD9D, 0xFED5, 0x0026, 0x0189, 0x02F8, 
	0x046D, 0x05E2, 0x0752, 0x08B4, 0x0A05, 0x0B3C, 0x0C54, 0x0D48, 0x0E10, 
	0x0EA7, 0x0F05, 0x0F26, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xBF5E, 0x0259, 0x0256, 0x024D, 0x0240, 0x0230, 0x021C, 
	0x0207, 0x01F1, 0x01DA, 0x01C5, 0x01B2, 0x01A1, 0x0194, 0x018B, 0x0188, 
	0x018B, 0x0192, 0x019E, 0x01AD, 0x01BE, 0x01D2, 0x01E6, 0x01FB, 0x020F, 
	0x0223, 0x0234, 0x0243, 0x024F, 0x0256, 0x0259, 0x0256, 0x024F, 0x0243, 
	0x0234, 0x0223, 0x020F, 0x01FB, 0x01E6, 0x01D2, 0x01BE, 0x01AD, 0x019E, 
	0x0192, 0x018B, 0x0188, 0x018B, 0x0192, 0x019E, 0x01AD, 0x01BE, 0x01D2, 
	0x01E6, 0x01FB, 0x020F, 0x0223, 0x0234, 0x0243, 0x024F, 0x0256, 0x0259, 
	0x0256, 0x024F, 0x0243, 0x0234, 0x0223, 0x020F, 0x01FB, 0x01E6, 0x01D2, 
	0x01BE, 0x01AD, 0x019E, 0x0192, 0x018B, 0x0188, 0x018B, 0x0192, 0x019E, 
	0x01AD, 0x01BE, 0x01D2, 0x01E6, 0x01FB, 0x020F, 0x0223, 0x0234, 0x0243, 
	0x024F, 0x0256, 0x0259, 0xED24, 0xED24, 0xED23, 0xED22, 0xED20, 0xED1E, 
	0xED1C, 0xED1A, 0xED18, 0xED16, 0xED14, 0xED13, 0xED11, 0xED11, 0xED10, 
	0xED11, 0xED11, 0xED12, 0xED14, 0xED16, 0xED17, 0xED19, 0xED1B, 0xED1D, 
	0xED1F, 0xED21, 0xED22, 0xED23, 0xED24, 0xED24, 0xED24, 0xED23, 0xED22, 
	0xED21, 0xED1F, 0xED1D, 0xED1B, 0xED19, 0xED17, 0xED16, 0xED14, 0xED12, 
	0xED11, 0xED11, 0xED10, 0xED11, 0xED11, 0xED12, 0xED14, 0xED16, 0xED17, 
	0xED19, 0xED1B, 0xED1D, 0xED1F, 0xED21, 0xED22, 0xED23, 0xED24, 0xED24, 
	0xED24, 0xED23, 0xED22, 0xED21, 0xED1F, 0xED1D, 0xED1B, 0xED19, 0xED17, 
	0xED16, 0xED14, 0xED12, 0xED11, 0xED11, 0xED10, 0xED11, 0xED11, 0xED12, 
	0xED14, 0xED16, 0xED17, 0xED19, 0xED1B, 0xED1D, 0xED1F, 0xED21, 0xED22, 
	0xED23, 0xED24, 0x7774, 0x777B, 0x778E, 0x77AB, 0x77D1, 0x77FC, 0x782C, 
	0x785D, 0x788F, 0x78BE, 0x78EA, 0x790F, 0x792C, 0x793F, 0x7946, 0x7940, 
	0x7930, 0x7916, 0x78F4, 0x78CD, 0x78A2, 0x7874, 0x7846, 0x7818, 0x77ED, 
	0x77C6, 0x77A5, 0x778B, 0x777A, 0x7774, 0x777A, 0x778B, 0x77A5, 0x77C6, 
	0x77ED, 0x7818, 0x7846, 0x7874, 0x78A2, 0x78CD, 0x78F4, 0x7916, 0x7930, 
	0x7940, 0x7946, 0x7940, 0x7930, 0x7916, 0x78F4, 0x78CD, 0x78A2, 0x7874, 
	0x7846, 0x7818, 0x77ED, 0x77C6, 0x77A5, 0x778B, 0x777A, 0x7774, 0x777A, 
	0x778B, 0x77A5, 0x77C6, 0x77ED, 0x7818, 0x7846, 0x7874, 0x78A2, 0x78CD, 
	0x78F4, 0x7916, 0x7930, 0x7940, 0x7946, 0x7940, 0x7930, 0x7916, 0x78F4, 
	0x78CD, 0x78A2, 0x7874, 0x7846, 0x7818, 0x77ED, 0x77C6, 0x77A5, 0x778B, 
	0x777A, 0x7774, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x4C54, 0xFA4B, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xBB2C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x0283, 0x0288, 0x0294, 0x02A7, 
	0x02BE, 0x02DA, 0x02F9, 0x0318, 0x0338, 0x0357, 0x0372, 0x038A, 0x039D, 
	0x03A9, 0x03AD, 0x03AA, 0x039F, 0x038E, 0x0379, 0x0360, 0x0345, 0x0327, 
	0x0309, 0x02EC, 0x02D1, 0x02B8, 0x02A2, 0x0292, 0x0287, 0x0283, 0x0287, 
	0x0292, 0x02A2, 0x02B8, 0x02D1, 0x02EC, 0x0309, 0x0327, 0x0345, 0x0360, 
	0x0379, 0x038E, 0x039F, 0x03AA, 0x03AD, 0x03AA, 0x039F, 0x038E, 0x0379, 
	0x0360, 0x0345, 0x0327, 0x0309, 0x02EC, 0x02D1, 0x02B8, 0x02A2, 0x0292, 
	0x0287, 0x0283, 0x0287, 0x0292, 0x02A2, 0x02B8, 0x02D1, 0x02EC, 0x0309, 
	0x0327, 0x0345, 0x0360, 0x0379, 0x038E, 0x039F, 0x03AA, 0x03AD, 0x03AA, 
	0x039F, 0x038E, 0x0379, 0x0360, 0x0345, 0x0327, 0x0309, 0x02EC, 0x02D1, 
	0x02B8, 0x02A2, 0x0292, 0x0287, 0x0283, 0x1549, 0x1548, 0x1547, 0x1544, 
	0x1541, 0x153D, 0x1539, 0x1535, 0x1531, 0x152D, 0x1529, 0x1526, 0x1523, 
	0x1522, 0x1521, 0x1522, 0x1523, 0x1525, 0x1528, 0x152B, 0x152F, 0x1533, 
	0x1537, 0x153B, 0x153E, 0x1542, 0x1545, 0x1547, 0x1548, 0x1549, 0x1548, 
	0x1547, 0x1545, 0x1542, 0x153E, 0x153B, 0x1537, 0x1533, 0x152F, 0x152B, 
	0x1528, 0x1525, 0x1523, 0x1522, 0x1521, 0x1522, 0x1523, 0x1525, 0x1528, 
	0x152B, 0x152F, 0x1533, 0x1537, 0x153B, 0x153E, 0x1542, 0x1545, 0x1547, 
	0x1548, 0x1549, 0x1548, 0x1547, 0x1545, 0x1542, 0x153E, 0x153B, 0x1537, 
	0x1533, 0x152F, 0x152B, 0x1528, 0x1525, 0x1523, 0x1522, 0x1521, 0x1522, 
	0x1523, 0x1525, 0x1528, 0x152B, 0x152F, 0x1533, 0x1537, 0x153B, 0x153E, 
	0x1542, 0x1545, 0x1547, 0x1548, 0x1549, 0x735F, 0x7368, 0x7380, 0x73A6, 
	0x73D6, 0x740E, 0x744B, 0x748B, 0x74CB, 0x7508, 0x7540, 0x7570, 0x7595, 
	0x75AE, 0x75B7, 0x75AF, 0x7599, 0x7578, 0x754D, 0x751B, 0x74E4, 0x74A9, 
	0x746D, 0x7432, 0x73FB, 0x73C8, 0x739D, 0x737C, 0x7367, 0x735F, 0x7367, 
	0x737C, 0x739D, 0x73C8, 0x73FB, 0x7432, 0x746D, 0x74A9, 0x74E4, 0x751B, 
	0x754D, 0x7578, 0x7599, 0x75AF, 0x75B7, 0x75AF, 0x7599, 0x7578, 0x754D, 
	0x751B, 0x74E4, 0x74A9, 0x746D, 0x7432, 0x73FB, 0x73C8, 0x739D, 0x737C, 
	0x7367, 0x735F, 0x7367, 0x737C, 0x739D, 0x73C8, 0x73FB, 0x7432, 0x746D, 
	0x74A9, 0x74E4, 0x751B, 0x754D, 0x7578, 0x7599, 0x75AF, 0x75B7, 0x75AF, 
	0x7599, 0x7578, 0x754D, 0x751B, 0x74E4, 0x74A9, 0x746D, 0x7432, 0x73FB, 
	0x73C8, 0x739D, 0x737C, 0x7367, 0x735F, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x44FE, 0x0012, 0x000C, 0xFFFB, 0xFFE1, 
	0xFFBF, 0xFF99, 0xFF6E, 0xFF42, 0xFF15, 0xFEEB, 0xFEC4, 0xFEA2, 0xFE88, 
	0xFE77, 0xFE71, 0xFE76, 0xFE85, 0xFE9C, 0xFEBA, 0xFEDD, 0xFF04, 0xFF2D, 
	0xFF56, 0xFF7F, 0xFFA6, 0xFFC9, 0xFFE7, 0xFFFE, 0x000D, 0x0012, 0x000D, 
	0xFFFE, 0xFFE7, 0xFFC9, 0xFFA6, 0xFF7F, 0xFF56, 0xFF2D, 0xFF04, 0xFEDD, 
	0xFEBA, 0xFE9C, 0xFE85, 0xFE76, 0xFE71, 0xFE76, 0xFE85, 0xFE9C, 0xFEBA, 
	0xFEDD, 0xFF04, 0xFF2D, 0xFF56, 0xFF7F, 0xFFA6, 0xFFC9, 0xFFE7, 0xFFFE, 
	0x000D, 0x0012, 0x000D, 0xFFFE, 0xFFE7, 0xFFC9, 0xFFA6, 0xFF7F, 0xFF56, 
	0xFF2D, 0xFF04, 0xFEDD, 0xFEBA, 0xFE9C, 0xFE85, 0xFE76, 0xFE71, 0xFE76, 
	0xFE85, 0xFE9C, 0xFEBA, 0xFEDD, 0xFF04, 0xFF2D, 0xFF56, 0xFF7F, 0xFFA6, 
	0xFFC9, 0xFFE7, 0xFFFE, 0x000D, 0x0012, 0xFF30, 0xC62C, 

},{ 
	0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0003, 0x0001, 
	0x0004, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 0x0007, 0x005A, 0x0008, 
	0x005A, 0x0062, 0x005A, 0x00BC, 0x005A, 0x0116, 0x005A, 0x0170, 0x005A, 
	0x01CA, 0x005A, 0x0224, 0x0001, 0x027E, 0x0001, 0x027F, 0x0001, 0x0280, 
	0x005A, 0x0281, 0x005A, 0x02DB, 0x005A, 0x0335, 0x005A, 0x038F, 0x005A, 
	0x03E9, 0x005A, 0x0443, 0x005A, 0x049D, 0x005A, 0x04F7, 0x005A, 0x0551, 
	0x0001, 0x05AB, 0x0001, 0x05AC, 0x0001, 0x05AD, 0x005A, 0x05AE, 0x005A, 
	0x0608, 0x005A, 0x0662, 0x0058, 0x06BC, 0x005A, 0x0714, 0x005A, 0x076E, 
	0x005A, 0x07C8, 0x005A, 0x0822, 0x005A, 0x087C, 0x005A, 0x08D6, 0x0059, 
	0x0930, 0x0001, 0x0989, 0x005A, 0x098A, 0x0059, 0x09E4, 0x005A, 0x0A3D, 
	0x0059, 0x0A97, 0x005A, 0x0AF0, 0x0001, 0x0B4A, 0x0001, 0x0B4B, 0x005A, 
	0x0B4C, 0x0001, 0x0BA6, 0x005A, 0x0BA7, 0x005A, 0x0C01, 0x0001, 0x0C5B, 
	0x005A, 0x0C5C, 0x005A, 0x0CB6, 0x005A, 0x0D10, 0x0059, 0x0D6A, 0x005A, 
	0x0DC3, 0x0001, 0x0E1D, 0x005A, 0x0E1E, 0x0001, 0x0E78, 0x0001, 0x0E79, 
	

});

smlua_anim_util_register_animation('donkey_9B_start_crawling',1, 0, 0, 0, 7, { 
	0x0000, 0x008E, 0x008E, 0x008E, 0x008C, 0x007E, 0x0062, 0x0046, 0x0039, 
	0xFFEA, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0xFFD8, 0xFF75, 0xFEF5, 
	0xFE74, 0xFE11, 0xFDEA, 0x0000, 0x0000, 0x0085, 0x01D3, 0x0384, 0x0535, 
	0x0683, 0x0708, 0x50ED, 0x4D94, 0x5070, 0x5797, 0x60E2, 0x6A2E, 0x7154, 
	0x7431, 0xFFFF, 0x0000, 0x00D6, 0x02ED, 0x05A4, 0x085B, 0x0A71, 0x0B47, 
	0xFFFF, 0x0000, 0xFF1D, 0xFCE8, 0xFA0A, 0xF72C, 0xF4F7, 0xF415, 0x2E60, 
	0x313C, 0x2C19, 0x1F43, 0x0E94, 0xFDE3, 0xF10D, 0xEBEB, 0x0000, 0x0000, 
	0xFF33, 0xFD35, 0xFA9F, 0xF808, 0xF60A, 0xF53E, 0x0001, 0x0000, 0x002C, 
	0x009A, 0x0129, 0x01B9, 0x0227, 0x0253, 0xCBD9, 0xCBD9, 0xCCE2, 0xCF7A, 
	0xD2D9, 0xD637, 0xD8CF, 0xD9D8, 0x0001, 0xFFFE, 0xC170, 0x4796, 0x4B50, 
	0x54F0, 0xE21B, 0xF07C, 0xFDB9, 0x077B, 0x0B54, 0xDBEB, 0xD813, 0xCE35, 
	0xBF31, 0xCDA4, 0xDAA8, 0xE3BE, 0xE6DF, 0x3819, 0x35E1, 0x3056, 0xA920, 
	0xA1EB, 0x9C5F, 0x9A28, 0x9B41, 0x060E, 0x05B8, 0x04DA, 0x03AC, 0x0262, 
	0x0133, 0x0056, 0xFFFF, 0xE5DB, 0xE74E, 0xEB0A, 0xF025, 0xF5B5, 0xFAD0, 
	0xFE8C, 0x0000, 0xA890, 0xAA9D, 0xAFE6, 0xB721, 0xBF01, 0xC63B, 0xCB84, 
	0xCD91, 0xEBDE, 0x18A4, 0xEFEB, 0xEFA4, 0xF069, 0xF255, 0xF4D4, 0xF753, 
	0xF93F, 0xFA04, 0x0B18, 0x0B18, 0x082B, 0x00DB, 0xF759, 0xEDD7, 0xE687, 
	0xE39A, 0x0001, 0xFFFE, 0xC170, 0xBF7D, 0xC22B, 0xC915, 0xD289, 0xDCD6, 
	0xE64A, 0xED34, 0xEFE2, 0x1FC3, 0x1EFD, 0x1CFE, 0x1A44, 0x174B, 0x1491, 
	0x1293, 0x11CD, 0x3F9E, 0x4306, 0x4BCD, 0x57CF, 0x64E3, 0x70E4, 0x79AC, 
	0x7D14, 0xFA09, 0xFA5E, 0xFB38, 0xFC62, 0xFDA6, 0xFED0, 0xFFAA, 0x0000, 
	0x197B, 0x1812, 0x146E, 0x0F74, 0x0A07, 0x050D, 0x0169, 0x0000, 0xA84E, 
	0xAB80, 0xB3BB, 0xBEFD, 0xCB41, 0xD683, 0xDEBF, 0xE1F0, 0x122A, 0x188A, 
	0x1557, 0x0D57, 0x02F1, 0xF889, 0xF089, 0xED56, 0x119B, 0x0344, 0x02E6, 
	0x01FC, 0x00CB, 0xFF9A, 0xFEB0, 0xFE52, 0x0F26, 0x0EEF, 0x0BED, 0x0568, 
	0xFD2F, 0xF512, 0xEEE1, 0xEC69, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xBF5E, 0x0259, 0x0222, 0x01C0, 0x00C9, 0xFF88, 0xFE47, 0xFD51, 0xFCEE, 
	0xED24, 0xECCC, 0xEBE2, 0xEA9E, 0xE93B, 0xE7F4, 0xE705, 0xE6A8, 0x7774, 
	0x76C1, 0x7885, 0x7CF0, 0x82AE, 0x886C, 0x8CD6, 0x8E9A, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x4C54, 0x4C88, 0x4D0E, 0x4DC5, 0x4E8D, 0x4F44, 
	0x4FCA, 0x4FFE, 0xFA4B, 0xF999, 0xF53D, 0xEC0C, 0xDF82, 0xD8D9, 0xE821, 
	0xF768, 0xFFFF, 0x0000, 0xFFBA, 0xFDD3, 0xF853, 0xF474, 0xF617, 0xF7BA, 
	0xBB2C, 0xBB05, 0xB65A, 0xAC7D, 0xA26D, 0x9DCA, 0xB98E, 0xD552, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x0283, 0x0222, 0x01E9, 0x015A, 
	0x00A0, 0xFFE4, 0xFF55, 0xFF1C, 0x1549, 0x149F, 0x145A, 0x142C, 0x140F, 
	0x1401, 0x13FC, 0x13FB, 0x735F, 0x7333, 0x75BC, 0x7C14, 0x8454, 0x8C93, 
	0x92EB, 0x9574, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x44FE, 0x4566, 0x4672, 0x47E1, 0x4971, 0x4ADF, 0x4BEC, 0x4C54, 0x0012, 
	0x0000, 0x09DB, 0x0B77, 0x0C95, 0x0D59, 0x0683, 0xFFAC, 0xFF30, 0x016C, 
	0xFE52, 0xFDE0, 0xFDE7, 0xFE12, 0x00F9, 0x03BB, 0xC62C, 0xC5B0, 0xC192, 
	0xB52A, 0xA05F, 0x949A, 0xB78F, 0xDA83, 

},{ 
	0x0001, 0x0000, 0x0008, 0x0001, 0x0001, 0x0009, 0x0001, 0x000A, 0x0001, 
	0x000B, 0x0001, 0x000C, 0x0008, 0x000D, 0x0008, 0x0015, 0x0008, 0x001D, 
	0x0008, 0x0025, 0x0008, 0x002D, 0x0008, 0x0035, 0x0008, 0x003D, 0x0008, 
	0x0045, 0x0008, 0x004D, 0x0001, 0x0055, 0x0001, 0x0056, 0x0001, 0x0057, 
	0x0008, 0x0058, 0x0008, 0x0060, 0x0008, 0x0068, 0x0008, 0x0070, 0x0008, 
	0x0078, 0x0008, 0x0080, 0x0002, 0x0088, 0x0008, 0x008A, 0x0008, 0x0092, 
	0x0001, 0x009A, 0x0001, 0x009B, 0x0001, 0x009C, 0x0008, 0x009D, 0x0008, 
	0x00A5, 0x0008, 0x00AD, 0x0008, 0x00B5, 0x0008, 0x00BD, 0x0008, 0x00C5, 
	0x0008, 0x00CD, 0x0008, 0x00D5, 0x0008, 0x00DD, 0x0007, 0x00E5, 0x0007, 
	0x00EC, 0x0001, 0x00F3, 0x0008, 0x00F4, 0x0008, 0x00FC, 0x0008, 0x0104, 
	0x0008, 0x010C, 0x0006, 0x0114, 0x0008, 0x011A, 0x0008, 0x0122, 0x0008, 
	0x012A, 0x0008, 0x0132, 0x0007, 0x013A, 0x0007, 0x0141, 0x0001, 0x0148, 
	0x0008, 0x0149, 0x0008, 0x0151, 0x0008, 0x0159, 0x0008, 0x0161, 0x0008, 
	0x0169, 0x0008, 0x0171, 0x0008, 0x0179, 0x0008, 0x0181, 0x0008, 0x0189, 
	

});

smlua_anim_util_register_animation('donkey_96_stop_crouching',1, 0, 0, 0, 9, { 
	0x0000, 0x008E, 0x008E, 0x008E, 0x008E, 0x008D, 0x008D, 0x008C, 0x008C, 
	0x008B, 0xFFEA, 0xFFEB, 0xFFED, 0xFFF0, 0xFFF3, 0xFFF7, 0xFFFA, 0xFFFD, 
	0xFFFF, 0x0000, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0x50ED, 0x511D, 
	0x519F, 0x525C, 0x533B, 0x5426, 0x5506, 0x55C2, 0x5644, 0x5675, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x2E60, 0x2CE9, 0x28FB, 0x234A, 0x1C8C, 0x1573, 0x0EB5, 0x0904, 
	0x0516, 0x039F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 
	0x0001, 0x0000, 0xCBD9, 0xC9E3, 0xC63E, 0xC448, 0xC855, 0xD1FF, 0xDD88, 
	0xE732, 0xEB40, 0xEE2F, 0x0001, 0xFFFE, 0xC170, 0x4796, 0x4B08, 0x541D, 
	0xE0F4, 0xEFAC, 0xFE64, 0x0B3D, 0x1452, 0x17C4, 0x1DCC, 0xDBEB, 0xD9AD, 
	0xD3C4, 0xB496, 0xBE2A, 0xC7BE, 0xD01A, 0xD603, 0xD840, 0xD901, 0x3819, 
	0x381F, 0x382F, 0xB845, 0xB85F, 0xB879, 0xB890, 0xB8A0, 0xB8A6, 0xB867, 
	0x060E, 0x0601, 0x05D7, 0x0588, 0x0510, 0x0468, 0x0389, 0x026D, 0x010E, 
	0x0000, 0xE5DB, 0xE715, 0xEA50, 0xEEE2, 0xF41F, 0xF95C, 0xFDED, 0x012A, 
	0x0264, 0x0000, 0xA890, 0xAA01, 0xADCD, 0xB32B, 0xB953, 0xBF7A, 0xC4D8, 
	0xC8A5, 0xCA15, 0xC9F4, 0xEBDE, 0xECE4, 0xEF96, 0xF367, 0xF7C6, 0xFC25, 
	0xFFF5, 0x02A8, 0x03AE, 0x071C, 0xEFEB, 0xF0BB, 0xF2DF, 0xF5E7, 0xF960, 
	0xFCD9, 0xFFE0, 0x0206, 0x02D6, 0x0306, 0x0B18, 0x0B17, 0x0B14, 0x0B0A, 
	0x0AF7, 0x0AD8, 0x0AA9, 0x0A67, 0x0A10, 0x0A90, 0x0001, 0xFFFE, 0xC170, 
	0xBF7D, 0xBF85, 0xBF9D, 0x3FBE, 0x3FE4, 0x400A, 0x402B, 0x4042, 0x404B, 
	0x36DA, 0x1FC3, 0x200B, 0x20D3, 0x5E00, 0x5C8A, 0x5AE5, 0x592B, 0x5778, 
	0x55E6, 0x54F5, 0x3F9E, 0x43B8, 0x4E87, 0xDDCF, 0xEF53, 0x00D9, 0x1021, 
	0x1AF1, 0x1F0A, 0x175C, 0xFA09, 0xF9FE, 0xF9E0, 0xF9B6, 0xF986, 0xF956, 
	0xF92C, 0xF90E, 0xF903, 0xFFFF, 0x197B, 0x1843, 0x150C, 0x1081, 0x0B4C, 
	0x0617, 0x018C, 0xFE54, 0xFD1C, 0xFFFF, 0xA84E, 0xA9CF, 0xADC5, 0xB35F, 
	0xB9CB, 0xC037, 0xC5D1, 0xC9C7, 0xCB48, 0xCB60, 0x122A, 0x1159, 0x0F2A, 
	0x0BFF, 0x083E, 0x0449, 0x0084, 0xFD52, 0xFB1A, 0xFA42, 0x119B, 0x117A, 
	0x110D, 0x1041, 0x0F06, 0x0D4B, 0x0AFD, 0x080C, 0x0466, 0x0197, 0x0F26, 
	0x0F24, 0x0F10, 0x0EDC, 0x0E75, 0x0DCD, 0x0CD1, 0x0B72, 0x099E, 0x0624, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 
	0x0259, 0x0243, 0x0207, 0x01AB, 0x0137, 0x00B1, 0x0020, 0xFF8A, 0xFEF8, 
	0xFE9B, 0xED24, 0xED4B, 0xEDB1, 0xEE41, 0xEEE6, 0xEF8B, 0xF01B, 0xF080, 
	0xF0A7, 0xEFF9, 0x7774, 0x77F1, 0x793B, 0x7B0F, 0x7D26, 0x7F3E, 0x8111, 
	0x825C, 0x82D9, 0x839E, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x4C54, 0x4C3F, 0x4C06, 0x4BB5, 
	0x4B54, 0x4AEE, 0x4A8D, 0x4A3B, 0x4A03, 0x49EE, 0xFA4B, 0xF9DC, 0xF8D2, 
	0xF794, 0xF68B, 0xF61B, 0xF688, 0xF751, 0xF7BD, 0xF7AE, 0xFFFF, 0x0001, 
	0x000B, 0x0024, 0x0056, 0x00A9, 0x0158, 0x025A, 0x034F, 0x03C6, 0xBB2C, 
	0xBA6C, 0xB892, 0xB639, 0xB3FB, 0xB272, 0xB1C3, 0xB046, 0xABDA, 0xAB92, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xBF5E, 0x0283, 
	0x027B, 0x0264, 0x0245, 0x0221, 0x01FD, 0x01DE, 0x01C8, 0x01C0, 0x1549, 
	0x1520, 0x14B4, 0x141C, 0x136E, 0x12BF, 0x1227, 0x11BB, 0x1192, 0x735F, 
	0x7409, 0x75C9, 0x7844, 0x7B1B, 0x7DF2, 0x806D, 0x822D, 0x82D8, 0x842B, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x44FE, 0x452B, 0x45A4, 0x4653, 0x4722, 0x47FC, 
	0x48CC, 0x497B, 0x49F4, 0x4A21, 0x0012, 0x007E, 0x0198, 0x0324, 0x04E6, 
	0x06A0, 0x081B, 0x0930, 0x09BE, 0x09D3, 0xFF30, 0xFEF8, 0xFE71, 0xFDD0, 
	0xFD4A, 0xFD11, 0xFD63, 0xFDFA, 0xFE4B, 0xFE32, 0xC62C, 0xC4C3, 0xC14A, 
	0xBCE1, 0xB8AB, 0xB5C8, 0xB4AA, 0xB2FB, 0xADB4, 0xABC3, 

},{ 
	0x0001, 0x0000, 0x0009, 0x0001, 0x000A, 0x000A, 0x0001, 0x0014, 0x0001, 
	0x0015, 0x0001, 0x0016, 0x0001, 0x0017, 0x000A, 0x0018, 0x000A, 0x0022, 
	0x0008, 0x002C, 0x0003, 0x0034, 0x000A, 0x0037, 0x000A, 0x0041, 0x0008, 
	0x004B, 0x000A, 0x0053, 0x0001, 0x005D, 0x0001, 0x005E, 0x0001, 0x005F, 
	0x000A, 0x0060, 0x000A, 0x006A, 0x000A, 0x0074, 0x000A, 0x007E, 0x000A, 
	0x0088, 0x000A, 0x0092, 0x000A, 0x009C, 0x000A, 0x00A6, 0x000A, 0x00B0, 
	0x0001, 0x00BA, 0x0001, 0x00BB, 0x0001, 0x00BC, 0x000A, 0x00BD, 0x000A, 
	0x00C7, 0x000A, 0x00D1, 0x000A, 0x00DB, 0x000A, 0x00E5, 0x000A, 0x00EF, 
	0x000A, 0x00F9, 0x000A, 0x0103, 0x000A, 0x010D, 0x0007, 0x0117, 0x000A, 
	0x011E, 0x0001, 0x0128, 0x000A, 0x0129, 0x000A, 0x0133, 0x000A, 0x013D, 
	0x0001, 0x0147, 0x000A, 0x0148, 0x000A, 0x0152, 0x000A, 0x015C, 0x000A, 
	0x0166, 0x000A, 0x0170, 0x0007, 0x017A, 0x0009, 0x0181, 0x0001, 0x018A, 
	0x0009, 0x018B, 0x0009, 0x0194, 0x000A, 0x019D, 0x0003, 0x01A7, 0x0009, 
	0x01AA, 0x000A, 0x01B3, 0x000A, 0x01BD, 0x000A, 0x01C7, 0x000A, 0x01D1, 
	

});

smlua_anim_util_register_animation('donkey_9A_stop_crawling',1, 0, 0, 0, 7, { 
	0x0000, 0x0039, 0x0046, 0x0062, 0x007E, 0x008C, 0x008E, 0xFFEA, 0x0000, 
	0x3FFF, 0x0000, 0xFDEA, 0xFE11, 0xFE74, 0xFEF5, 0xFF75, 0xFFD8, 0x0000, 
	0xFFFF, 0x0708, 0x0683, 0x0535, 0x0384, 0x01D3, 0x0085, 0x0000, 0x7431, 
	0x7154, 0x6A2E, 0x60E2, 0x5797, 0x5070, 0x4D94, 0x50ED, 0x0B47, 0x0A71, 
	0x085B, 0x05A4, 0x02ED, 0x00D6, 0x0000, 0xFFFF, 0xF415, 0xF4F7, 0xF72C, 
	0xFA0A, 0xFCE8, 0xFF1D, 0x0000, 0xFFFF, 0xEBEB, 0xF10D, 0xFDE3, 0x0E94, 
	0x1F43, 0x2C19, 0x313C, 0x2E60, 0xF53E, 0xF60A, 0xF808, 0xFA9F, 0xFD35, 
	0xFF33, 0x0000, 0x0253, 0x0227, 0x01B9, 0x0129, 0x009A, 0x002C, 0x0000, 
	0x0001, 0xD9D8, 0xD8CF, 0xD637, 0xD2D9, 0xCF7A, 0xCCE2, 0xCBD9, 0x0001, 
	0xFFFE, 0xC170, 0x0B54, 0x077B, 0xFDB9, 0xF07C, 0xE21B, 0x54F0, 0x4B50, 
	0x4796, 0xE6DF, 0xE3BE, 0xDAA8, 0xCDA4, 0xBF31, 0xCE35, 0xD813, 0xDBEB, 
	0x9B41, 0x9A28, 0x9C5F, 0xA1EB, 0xA920, 0x3056, 0x35E1, 0x3819, 0xFFFF, 
	0x0056, 0x0133, 0x0262, 0x03AC, 0x04DA, 0x05B8, 0x060E, 0x0000, 0xFE8C, 
	0xFAD0, 0xF5B5, 0xF025, 0xEB0A, 0xE74E, 0xE5DB, 0xCD91, 0xCB84, 0xC63B, 
	0xBF01, 0xB721, 0xAFE6, 0xAA9D, 0xA890, 0x18A4, 0x18A4, 0x18A4, 0x18A4, 
	0x18A4, 0x18A4, 0x18A4, 0xEBDE, 0xFA04, 0xF93F, 0xF753, 0xF4D4, 0xF255, 
	0xF069, 0xEFA4, 0xEFEB, 0xE39A, 0xE687, 0xEDD7, 0xF759, 0x00DB, 0x082B, 
	0x0B18, 0x0001, 0xFFFE, 0xC170, 0xEFE2, 0xED34, 0xE64A, 0xDCD6, 0xD289, 
	0xC915, 0xC22B, 0xBF7D, 0x11CD, 0x1293, 0x1491, 0x174B, 0x1A44, 0x1CFE, 
	0x1EFD, 0x1FC3, 0x7D14, 0x79AC, 0x70E4, 0x64E3, 0x57CF, 0x4BCD, 0x4306, 
	0x3F9E, 0x0000, 0xFFAA, 0xFED0, 0xFDA6, 0xFC62, 0xFB38, 0xFA5E, 0xFA09, 
	0x0000, 0x0169, 0x050D, 0x0A07, 0x0F74, 0x146E, 0x1812, 0x197B, 0xE1F0, 
	0xDEBF, 0xD683, 0xCB41, 0xBEFD, 0xB3BB, 0xAB80, 0xA84E, 0xED56, 0xF089, 
	0xF889, 0x02F1, 0x0D57, 0x1557, 0x188A, 0x122A, 0xFE52, 0xFEB0, 0xFF9A, 
	0x00CB, 0x01FC, 0x02E6, 0x0344, 0x119B, 0xEC69, 0xEEE1, 0xF512, 0xFD2F, 
	0x0568, 0x0BED, 0x0EEF, 0x0F26, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xBF5E, 0xFCEE, 0xFD51, 0xFE47, 0xFF88, 0x00C9, 0x01C0, 0x0222, 
	0x0259, 0xE6A8, 0xE705, 0xE7F4, 0xE93B, 0xEA9E, 0xEBE2, 0xECCC, 0xED24, 
	0x8E9A, 0x8CD6, 0x886C, 0x82AE, 0x7CF0, 0x7885, 0x76C1, 0x7774, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x4FFE, 0x4FCA, 0x4F44, 0x4E8D, 
	0x4DC5, 0x4D0E, 0x4C88, 0x4C54, 0xF768, 0xE821, 0xD8D9, 0xDF82, 0xEC0C, 
	0xF53D, 0xF999, 0xFA4B, 0xF7BA, 0xF617, 0xF474, 0xF853, 0xFDD3, 0xFFBA, 
	0x0000, 0xFFFF, 0xD552, 0xB98E, 0x9DCA, 0xA26D, 0xAC7D, 0xB65A, 0xBB05, 
	0xBB2C, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0xFF1C, 0xFF55, 0xFFE4, 
	0x00A0, 0x015A, 0x01E9, 0x0222, 0x0283, 0x13FB, 0x13FC, 0x1401, 0x140F, 
	0x142C, 0x145A, 0x149F, 0x1549, 0x9574, 0x92EB, 0x8C93, 0x8454, 0x7C14, 
	0x75BC, 0x7333, 0x735F, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x4C54, 0x4BEC, 0x4ADF, 0x4971, 0x47E1, 0x4672, 0x4566, 0x44FE, 0xFFAC, 
	0x0683, 0x0D59, 0x0C95, 0x0B77, 0x09DB, 0x0000, 0x0012, 0x03BB, 0x00F9, 
	0xFE12, 0xFDE7, 0xFDE0, 0xFE52, 0x016C, 0xFF30, 0xDA83, 0xB78F, 0x949A, 
	0xA05F, 0xB52A, 0xC192, 0xC5B0, 0xC62C, 

},{ 
	0x0001, 0x0000, 0x0006, 0x0001, 0x0001, 0x0007, 0x0001, 0x0008, 0x0001, 
	0x0009, 0x0001, 0x000A, 0x0008, 0x000B, 0x0007, 0x0013, 0x0008, 0x001A, 
	0x0008, 0x0022, 0x0008, 0x002A, 0x0008, 0x0032, 0x0007, 0x003A, 0x0008, 
	0x0041, 0x0007, 0x0049, 0x0001, 0x0050, 0x0001, 0x0051, 0x0001, 0x0052, 
	0x0008, 0x0053, 0x0008, 0x005B, 0x0008, 0x0063, 0x0008, 0x006B, 0x0008, 
	0x0073, 0x0008, 0x007B, 0x0008, 0x0083, 0x0008, 0x008B, 0x0007, 0x0093, 
	0x0001, 0x009A, 0x0001, 0x009B, 0x0001, 0x009C, 0x0008, 0x009D, 0x0008, 
	0x00A5, 0x0008, 0x00AD, 0x0008, 0x00B5, 0x0008, 0x00BD, 0x0008, 0x00C5, 
	0x0008, 0x00CD, 0x0008, 0x00D5, 0x0008, 0x00DD, 0x0008, 0x00E5, 0x0007, 
	0x00ED, 0x0001, 0x00F4, 0x0008, 0x00F5, 0x0008, 0x00FD, 0x0008, 0x0105, 
	0x0007, 0x010D, 0x0008, 0x0114, 0x0008, 0x011C, 0x0008, 0x0124, 0x0008, 
	0x012C, 0x0008, 0x0134, 0x0007, 0x013C, 0x0006, 0x0143, 0x0001, 0x0149, 
	0x0008, 0x014A, 0x0008, 0x0152, 0x0008, 0x015A, 0x0008, 0x0162, 0x0007, 
	0x016A, 0x0008, 0x0171, 0x0008, 0x0179, 0x0008, 0x0181, 0x0008, 0x0189, 
	

});

smlua_anim_util_register_animation('donkey_97_start_crouching',1, 0, 0, 0, 5, { 
	0x0000, 0x008B, 0x008C, 0x008C, 0x008D, 0x008E, 0x0000, 0xFFFE, 0xFFF9, 
	0xFFF1, 0xFFEC, 0xFFEA, 0x0000, 0x3FFF, 0x0000, 0xFFFF, 0xFFFE, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x5675, 0x5604, 0x54B0, 0x52B2, 0x515E, 
	0x50ED, 0x0000, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x039F, 0x08E1, 0x18A7, 0x286E, 0x2DB0, 0x2E60, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0xEE2F, 
	0xE9F7, 0xDD50, 0xD0A9, 0xCC71, 0xCBD9, 0x0001, 0xFFFE, 0xC170, 0x1DCC, 
	0xA859, 0x32E7, 0x382D, 0x47FE, 0x4796, 0xD901, 0xA67D, 0xDA03, 0xDA42, 
	0xDAFE, 0xDBEB, 0xB867, 0xF4F3, 0x3181, 0x3321, 0x3803, 0x3819, 0x0000, 
	0x00C7, 0x031E, 0x0574, 0x063B, 0x060E, 0x0000, 0xFCDA, 0xF369, 0xE9F9, 
	0xE6D4, 0xE5DB, 0xC9F4, 0xC5A0, 0xB8A5, 0xABA9, 0xA756, 0xA890, 0x071C, 
	0x038D, 0xF8DE, 0xEE31, 0xEAA2, 0xEBDE, 0x0306, 0x008C, 0xF91C, 0xF1AE, 
	0xEF34, 0xEFEB, 0x0A90, 0x0A62, 0x09D9, 0x0950, 0x0922, 0x0B18, 0x0001, 
	0xFFFE, 0xC170, 0x36DA, 0x3830, 0xB985, 0xBA30, 0xBC30, 0xBF7D, 0x54F5, 
	0x5936, 0x2289, 0x2067, 0x1A02, 0x1FC3, 0x175C, 0xDE86, 0x25B1, 0x2C9F, 
	0x416B, 0x3F9E, 0xFFFF, 0xFD41, 0xF506, 0xECCC, 0xEA0E, 0xFA09, 0xFFFF, 
	0x0402, 0x1009, 0x1C0F, 0x2011, 0x197B, 0xCB60, 0xC63C, 0xB6D0, 0xA765, 
	0xA241, 0xA84E, 0xFA42, 0xFE15, 0x0992, 0x150E, 0x18E2, 0x122A, 0x0197, 
	0x0222, 0x03C2, 0x0561, 0x05EC, 0x119B, 0x0624, 0x07A4, 0x0C25, 0x10A6, 
	0x1226, 0x0F26, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xBF5E, 0xFE9B, 0xFEFF, 0x002A, 0x0155, 0x01B8, 0x0259, 
	0xEFF9, 0xEFFA, 0xEFFD, 0xF000, 0xF001, 0xED24, 0x839E, 0x829B, 0x7F92, 
	0x7C88, 0x7B85, 0x7774, 0x0000, 0xFFFF, 0x49EE, 0x4A1F, 0x4AB2, 0x4B8F, 
	0x4C23, 0x4C54, 0xF7AE, 0xF7CB, 0xF824, 0xF87C, 0xF89A, 0xFA4B, 0x03C6, 
	0x02D7, 0x000B, 0xFD3F, 0xFC50, 0xFFFF, 0xAB92, 0xACDD, 0xB0BB, 0xB49A, 
	0xB5E5, 0xBB2C, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xBF5E, 0x01C0, 0x01A4, 0x0150, 
	0x00FD, 0x00E1, 0x0283, 0x1192, 0x1234, 0x141B, 0x1601, 0x16A3, 0x1549, 
	0x842B, 0x823C, 0x7C6F, 0x76A2, 0x74B3, 0x735F, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x4A21, 0x49B8, 0x487C, 0x46A3, 0x4567, 0x44FE, 0x09D3, 0x08E1, 0x060C, 
	0x0336, 0x0244, 0x0012, 0xFE32, 0xFD9A, 0xFBD2, 0xFA0A, 0xF971, 0xFF30, 
	0xABC3, 0xAE8F, 0xB6F3, 0xBF57, 0xC224, 0xC62C, 

},{ 
	0x0001, 0x0000, 0x0005, 0x0001, 0x0006, 0x0006, 0x0001, 0x000C, 0x0001, 
	0x000D, 0x0001, 0x000E, 0x0001, 0x000F, 0x0006, 0x0010, 0x0006, 0x0016, 
	0x0006, 0x001C, 0x0003, 0x0022, 0x0006, 0x0025, 0x0006, 0x002B, 0x0004, 
	0x0031, 0x0006, 0x0035, 0x0001, 0x003B, 0x0001, 0x003C, 0x0001, 0x003D, 
	0x0006, 0x003E, 0x0006, 0x0044, 0x0006, 0x004A, 0x0006, 0x0050, 0x0006, 
	0x0056, 0x0006, 0x005C, 0x0006, 0x0062, 0x0006, 0x0068, 0x0006, 0x006E, 
	0x0001, 0x0074, 0x0001, 0x0075, 0x0001, 0x0076, 0x0006, 0x0077, 0x0006, 
	0x007D, 0x0006, 0x0083, 0x0006, 0x0089, 0x0006, 0x008F, 0x0006, 0x0095, 
	0x0006, 0x009B, 0x0006, 0x00A1, 0x0006, 0x00A7, 0x0004, 0x00AD, 0x0005, 
	0x00B1, 0x0001, 0x00B6, 0x0006, 0x00B7, 0x0006, 0x00BD, 0x0006, 0x00C3, 
	0x0001, 0x00C9, 0x0001, 0x00CA, 0x0006, 0x00CB, 0x0006, 0x00D1, 0x0006, 
	0x00D7, 0x0006, 0x00DD, 0x0006, 0x00E3, 0x0006, 0x00E9, 0x0001, 0x00EF, 
	0x0006, 0x00F0, 0x0006, 0x00F6, 0x0006, 0x00FC, 0x0006, 0x0102, 0x0006, 
	0x0108, 0x0006, 0x010E, 0x0006, 0x0114, 0x0006, 0x011A, 0x0006, 0x0120, 
	

});

smlua_anim_util_register_animation('donkey_33_idle_on_ledge',0, 0, 0, 0, 50, { 
	0x0000, 0xFEF5, 0xFEF5, 0xFEF5, 0xFEF6, 0xFEF6, 0xFEF7, 0xFEF8, 0xFEF9, 
	0xFEFB, 0xFEFC, 0xFEFD, 0xFEFF, 0xFF00, 0xFF02, 0xFF03, 0xFF05, 0xFF06, 
	0xFF07, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0C, 0xFF0D, 0xFF0D, 0xFF0D, 
	0xFF0D, 0xFF0D, 0xFF0C, 0xFF0C, 0xFF0B, 0xFF0A, 0xFF09, 0xFF07, 0xFF06, 
	0xFF05, 0xFF03, 0xFF02, 0xFF00, 0xFEFF, 0xFEFD, 0xFEFC, 0xFEFB, 0xFEF9, 
	0xFEF8, 0xFEF7, 0xFEF6, 0xFEF6, 0xFEF5, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFBD, 
	0xFFBD, 0xFFBD, 0xFFBE, 0xFFBF, 0xFFBF, 0xFFC0, 0xFFC1, 0xFFC2, 0xFFC2, 
	0xFFC3, 0xFFC4, 0xFFC5, 0xFFC6, 0xFFC6, 0xFFC7, 0xFFC8, 0xFFC8, 0xFFC9, 
	0xFFC9, 0xFFC9, 0xFFC9, 0xFFC9, 0xFFC9, 0xFFC9, 0xFFC9, 0xFFC9, 0xFFC8, 
	0xFFC8, 0xFFC7, 0xFFC6, 0xFFC6, 0xFFC5, 0xFFC4, 0xFFC3, 0xFFC2, 0xFFC2, 
	0xFFC1, 0xFFC0, 0xFFBF, 0xFFBF, 0xFFBE, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBC, 
	0x0000, 0x3FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x4912, 0x4913, 0x4916, 
	0x491A, 0x491F, 0x4925, 0x492D, 0x4935, 0x493E, 0x4948, 0x4953, 0x495D, 
	0x4968, 0x4973, 0x497E, 0x4988, 0x4993, 0x499D, 0x49A6, 0x49AE, 0x49B6, 
	0x49BC, 0x49C1, 0x49C5, 0x49C8, 0x49C9, 0x49C8, 0x49C5, 0x49C1, 0x49BC, 
	0x49B6, 0x49AE, 0x49A6, 0x499D, 0x4993, 0x4988, 0x497E, 0x4973, 0x4968, 
	0x495D, 0x4953, 0x4948, 0x493E, 0x4935, 0x492D, 0x4925, 0x491F, 0x491A, 
	0x4916, 0x4913, 0x4912, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xDCA3, 0xDCA2, 0xDCA0, 0xDC9C, 0xDC97, 0xDC90, 0xDC89, 0xDC80, 
	0xDC77, 0xDC6D, 0xDC63, 0xDC59, 0xDC4E, 0xDC43, 0xDC38, 0xDC2D, 0xDC23, 
	0xDC19, 0xDC10, 0xDC08, 0xDC00, 0xDBFA, 0xDBF4, 0xDBF0, 0xDBEE, 0xDBED, 
	0xDBEE, 0xDBF0, 0xDBF4, 0xDBFA, 0xDC00, 0xDC08, 0xDC10, 0xDC19, 0xDC23, 
	0xDC2D, 0xDC38, 0xDC43, 0xDC4E, 0xDC59, 0xDC63, 0xDC6D, 0xDC77, 0xDC80, 
	0xDC89, 0xDC90, 0xDC97, 0xDC9C, 0xDCA0, 0xDCA2, 0xDCA3, 0x0000, 0x0000, 
	0xF371, 0xFFFE, 0x0001, 0xC170, 0xC2FB, 0xC2FE, 0xC307, 0xC316, 0xC32A, 
	0xC342, 0xC35E, 0xC37E, 0xC3A0, 0xC3C5, 0xC3EC, 0xC414, 0xC43C, 0xC465, 
	0xC48E, 0xC4B6, 0xC4DD, 0xC501, 0xC524, 0xC543, 0xC560, 0xC578, 0xC58C, 
	0xC59A, 0xC5A4, 0xC5A7, 0xC5A4, 0xC59A, 0xC58C, 0xC578, 0xC560, 0xC543, 
	0xC524, 0xC501, 0xC4DD, 0xC4B6, 0xC48E, 0xC465, 0xC43C, 0xC414, 0xC3EC, 
	0xC3C5, 0xC3A0, 0xC37E, 0xC35E, 0xC342, 0xC32A, 0xC316, 0xC307, 0xC2FE, 
	0xC2FB, 0xA528, 0xA539, 0xA56A, 0xA5B8, 0xA620, 0xA6A0, 0xA736, 0xA7DD, 
	0xA893, 0xA956, 0xAA23, 0xAAF6, 0xABCE, 0xACA7, 0xAD7F, 0xAE53, 0xAF1F, 
	0xAFE2, 0xB099, 0xB140, 0xB1D5, 0xB255, 0xB2BE, 0xB30C, 0xB33D, 0xB34E, 
	0xB33D, 0xB30C, 0xB2BE, 0xB255, 0xB1D5, 0xB140, 0xB099, 0xAFE2, 0xAF1F, 
	0xAE53, 0xAD7F, 0xACA7, 0xABCE, 0xAAF6, 0xAA23, 0xA956, 0xA893, 0xA7DD, 
	0xA736, 0xA6A0, 0xA620, 0xA5B8, 0xA56A, 0xA539, 0xA528, 0xEB11, 0xEB0D, 
	0xEB01, 0xEAEF, 0xEAD6, 0xEAB8, 0xEA95, 0xEA6E, 0xEA43, 0xEA15, 0xE9E5, 
	0xE9B3, 0xE980, 0xE94D, 0xE91A, 0xE8E9, 0xE8B8, 0xE88A, 0xE860, 0xE838, 
	0xE815, 0xE7F7, 0xE7DE, 0xE7CC, 0xE7C0, 0xE7BD, 0xE7C0, 0xE7CC, 0xE7DE, 
	0xE7F7, 0xE815, 0xE838, 0xE860, 0xE88A, 0xE8B8, 0xE8E9, 0xE91A, 0xE94D, 
	0xE980, 0xE9B3, 0xE9E5, 0xEA15, 0xEA43, 0xEA6E, 0xEA95, 0xEAB8, 0xEAD6, 
	0xEAEF, 0xEB01, 0xEB0D, 0xEB11, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xD1C6, 0xD1AE, 0xD16A, 0xD0FC, 0xD069, 0xCFB4, 0xCEE2, 
	0xCDF7, 0xCCF6, 0xCBE4, 0xCAC4, 0xC99A, 0xC86B, 0xC739, 0xC609, 0xC4DF, 
	0xC3BF, 0xC2AD, 0xC1AC, 0xC0C1, 0xBFEF, 0xBF3B, 0xBEA8, 0xBE3A, 0xBDF5, 
	0xBDDD, 0xBDF5, 0xBE3A, 0xBEA8, 0xBF3B, 0xBFEF, 0xC0C1, 0xC1AC, 0xC2AD, 
	0xC3BF, 0xC4DF, 0xC609, 0xC739, 0xC86B, 0xC99A, 0xCAC4, 0xCBE4, 0xCCF6, 
	0xCDF7, 0xCEE2, 0xCFB4, 0xD069, 0xD0FC, 0xD16A, 0xD1AE, 0xD1C6, 0xFEF4, 
	0xFEF1, 0xFEE8, 0xFEDA, 0xFEC6, 0xFEAF, 0xFE93, 0xFE75, 0xFE53, 0xFE30, 
	0xFE0A, 0xFDE3, 0xFDBB, 0xFD94, 0xFD6C, 0xFD45, 0xFD1F, 0xFCFC, 0xFCDA, 
	0xFCBC, 0xFCA0, 0xFC89, 0xFC75, 0xFC67, 0xFC5E, 0xFC5B, 0xFC5E, 0xFC67, 
	0xFC75, 0xFC89, 0xFCA0, 0xFCBC, 0xFCDA, 0xFCFC, 0xFD1F, 0xFD45, 0xFD6C, 
	0xFD94, 0xFDBB, 0xFDE3, 0xFE0A, 0xFE30, 0xFE53, 0xFE75, 0xFE93, 0xFEAF, 
	0xFEC6, 0xFEDA, 0xFEE8, 0xFEF1, 0xFEF4, 0xECCF, 0xECD0, 0xECD1, 0xECD2, 
	0xECD4, 0xECD7, 0xECDA, 0xECDE, 0xECE1, 0xECE6, 0xECEA, 0xECEE, 0xECF3, 
	0xECF7, 0xECFC, 0xED00, 0xED05, 0xED09, 0xED0D, 0xED10, 0xED13, 0xED16, 
	0xED18, 0xED1A, 0xED1B, 0xED1B, 0xED1B, 0xED1A, 0xED18, 0xED16, 0xED13, 
	0xED10, 0xED0D, 0xED09, 0xED05, 0xED00, 0xECFC, 0xECF7, 0xECF3, 0xECEE, 
	0xECEA, 0xECE6, 0xECE1, 0xECDE, 0xECDA, 0xECD7, 0xECD4, 0xECD2, 0xECD1, 
	0xECD0, 0xECCF, 0x0BBF, 0x0BC6, 0x0BDA, 0x0BFA, 0x0C24, 0x0C59, 0x0C95, 
	0x0CD9, 0x0D24, 0x0D73, 0x0DC6, 0x0E1C, 0x0E74, 0x0ECD, 0x0F25, 0x0F7B, 
	0x0FCE, 0x101D, 0x1068, 0x10AC, 0x10E8, 0x111D, 0x1147, 0x1167, 0x117B, 
	0x1182, 0x117B, 0x1167, 0x1147, 0x111D, 0x10E8, 0x10AC, 0x1068, 0x101D, 
	0x0FCE, 0x0F7B, 0x0F25, 0x0ECD, 0x0E74, 0x0E1C, 0x0DC6, 0x0D73, 0x0D24, 
	0x0CD9, 0x0C95, 0x0C59, 0x0C24, 0x0BFA, 0x0BDA, 0x0BC6, 0x0BBF, 0xFFFE, 
	0x0001, 0xC170, 0x3BA9, 0x3BA6, 0x3B9B, 0x3B8A, 0x3B74, 0x3B58, 0x3B39, 
	0x3B15, 0x3AEE, 0x3AC4, 0x3A98, 0x3A6B, 0x3A3D, 0x3A0E, 0x39E0, 0x39B3, 
	0x3987, 0x395D, 0x3936, 0x3912, 0x38F2, 0x38D7, 0x38C0, 0x38B0, 0x38A5, 
	0x38A2, 0x38A5, 0x38B0, 0x38C0, 0x38D7, 0x38F2, 0x3912, 0x3936, 0x395D, 
	0x3987, 0x39B3, 0x39E0, 0x3A0E, 0x3A3D, 0x3A6B, 0x3A98, 0x3AC4, 0x3AEE, 
	0x3B15, 0x3B39, 0x3B58, 0x3B74, 0x3B8A, 0x3B9B, 0x3BA6, 0x3BA9, 0x598E, 
	0x597E, 0x5951, 0x5909, 0x58A9, 0x5833, 0x57AA, 0x5710, 0x5668, 0x55B4, 
	0x54F7, 0x5434, 0x536E, 0x52A6, 0x51DF, 0x511C, 0x505F, 0x4FAC, 0x4F03, 
	0x4E6A, 0x4DE0, 0x4D6A, 0x4D0A, 0x4CC2, 0x4C95, 0x4C85, 0x4C95, 0x4CC2, 
	0x4D0A, 0x4D6A, 0x4DE0, 0x4E6A, 0x4F03, 0x4FAC, 0x505F, 0x511C, 0x51DF, 
	0x52A6, 0x536E, 0x5434, 0x54F7, 0x55B4, 0x5668, 0x5710, 0x57AA, 0x5833, 
	0x58A9, 0x5909, 0x5951, 0x597E, 0x598E, 0xEA82, 0xEA7E, 0xEA72, 0xEA5F, 
	0xEA46, 0xEA28, 0xEA05, 0xE9DD, 0xE9B1, 0xE983, 0xE952, 0xE920, 0xE8ED, 
	0xE8B9, 0xE886, 0xE854, 0xE823, 0xE7F5, 0xE7C9, 0xE7A1, 0xE77E, 0xE760, 
	0xE747, 0xE734, 0xE728, 0xE724, 0xE728, 0xE734, 0xE747, 0xE760, 0xE77E, 
	0xE7A1, 0xE7C9, 0xE7F5, 0xE823, 0xE854, 0xE886, 0xE8B9, 0xE8ED, 0xE920, 
	0xE952, 0xE983, 0xE9B1, 0xE9DD, 0xEA05, 0xEA28, 0xEA46, 0xEA5F, 0xEA72, 
	0xEA7E, 0xEA82, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xCEEE, 0xCED7, 0xCE95, 0xCE2B, 0xCD9D, 0xCCEF, 0xCC25, 0xCB42, 
	0xCA4A, 0xC942, 0xC82C, 0xC70D, 0xC5E8, 0xC4C1, 0xC39C, 0xC27D, 0xC167, 
	0xC05F, 0xBF67, 0xBE84, 0xBDBA, 0xBD0C, 0xBC7E, 0xBC14, 0xBBD2, 0xBBBB, 
	0xBBD2, 0xBC14, 0xBC7E, 0xBD0C, 0xBDBA, 0xBE84, 0xBF67, 0xC05F, 0xC167, 
	0xC27D, 0xC39C, 0xC4C1, 0xC5E8, 0xC70D, 0xC82C, 0xC942, 0xCA4A, 0xCB42, 
	0xCC25, 0xCCEF, 0xCD9D, 0xCE2B, 0xCE95, 0xCED7, 0xCEEE, 0xFD8D, 0xFD91, 
	0xFD9F, 0xFDB5, 0xFDD2, 0xFDF6, 0xFE20, 0xFE4F, 0xFE82, 0xFEB9, 0xFEF3, 
	0xFF2E, 0xFF6B, 0xFFA8, 0xFFE4, 0x0021, 0x005A, 0x0091, 0x00C4, 0x00F3, 
	0x011D, 0x0141, 0x015F, 0x0175, 0x0182, 0x0187, 0x0182, 0x0175, 0x015F, 
	0x0141, 0x011D, 0x00F3, 0x00C4, 0x0091, 0x005A, 0x0021, 0xFFE4, 0xFFA8, 
	0xFF6B, 0xFF2E, 0xFEF3, 0xFEB9, 0xFE82, 0xFE4F, 0xFE20, 0xFDF6, 0xFDD2, 
	0xFDB5, 0xFD9F, 0xFD91, 0xFD8D, 0x1311, 0x1311, 0x1311, 0x1312, 0x1312, 
	0x1313, 0x1314, 0x1315, 0x1316, 0x1318, 0x1319, 0x131A, 0x131C, 0x131D, 
	0x131E, 0x1320, 0x1321, 0x1322, 0x1323, 0x1324, 0x1325, 0x1326, 0x1327, 
	0x1327, 0x1327, 0x1328, 0x1327, 0x1327, 0x1327, 0x1326, 0x1325, 0x1324, 
	0x1323, 0x1322, 0x1321, 0x1320, 0x131E, 0x131D, 0x131C, 0x131A, 0x1319, 
	0x1318, 0x1316, 0x1315, 0x1314, 0x1313, 0x1312, 0x1312, 0x1311, 0x05A0, 
	0x05AA, 0x05C9, 0x05F9, 0x063A, 0x0689, 0x06E5, 0x074D, 0x07BE, 0x0837, 
	0x08B6, 0x0939, 0x09BF, 0x0A45, 0x0ACB, 0x0B4E, 0x0BCD, 0x0C46, 0x0CB7, 
	0x0D1E, 0x0D7B, 0x0DCA, 0x0E0B, 0x0E3B, 0x0E5A, 0x0E64, 0x0E5A, 0x0E3B, 
	0x0E0B, 0x0DCA, 0x0D7B, 0x0D1E, 0x0CB7, 0x0C46, 0x0BCD, 0x0B4E, 0x0ACB, 
	0x0A45, 0x09BF, 0x0939, 0x08B6, 0x0837, 0x07BE, 0x074D, 0x06E5, 0x0689, 
	0x063A, 0x05F9, 0x05C9, 0x05AA, 0x05A0, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xF275, 
	0xF279, 0xF286, 0xF29B, 0xF2B7, 0xF2D8, 0xF300, 0xF32C, 0xF35C, 0xF390, 
	0xF3C6, 0xF3FE, 0xF437, 0xF470, 0xF4A9, 0xF4E1, 0xF517, 0xF54B, 0xF57B, 
	0xF5A7, 0xF5CF, 0xF5F0, 0xF60C, 0xF621, 0xF62E, 0xF632, 0xF62E, 0xF621, 
	0xF60C, 0xF5F0, 0xF5CF, 0xF5A7, 0xF57B, 0xF54B, 0xF517, 0xF4E1, 0xF4A9, 
	0xF470, 0xF437, 0xF3FE, 0xF3C6, 0xF390, 0xF35C, 0xF32C, 0xF300, 0xF2D8, 
	0xF2B7, 0xF29B, 0xF286, 0xF279, 0xF275, 0xF0B5, 0xF0B1, 0xF0A9, 0xF09A, 
	0xF088, 0xF070, 0xF055, 0xF037, 0xF016, 0xEFF3, 0xEFCE, 0xEFA8, 0xEF81, 
	0xEF59, 0xEF32, 0xEF0C, 0xEEE7, 0xEEC4, 0xEEA3, 0xEE85, 0xEE6A, 0xEE53, 
	0xEE40, 0xEE32, 0xEE29, 0xEE26, 0xEE29, 0xEE32, 0xEE40, 0xEE53, 0xEE6A, 
	0xEE85, 0xEEA3, 0xEEC4, 0xEEE7, 0xEF0C, 0xEF32, 0xEF59, 0xEF81, 0xEFA8, 
	0xEFCE, 0xEFF3, 0xF016, 0xF037, 0xF055, 0xF070, 0xF088, 0xF09A, 0xF0A9, 
	0xF0B1, 0xF0B5, 0xA61C, 0xA611, 0xA5F0, 0xA5BC, 0xA577, 0xA521, 0xA4BE, 
	0xA44F, 0xA3D5, 0xA354, 0xA2CC, 0xA23F, 0xA1AF, 0xA11F, 0xA08F, 0xA002, 
	0x9F7A, 0x9EF8, 0x9E7F, 0x9E10, 0x9DAD, 0x9D57, 0x9D12, 0x9CDE, 0x9CBD, 
	0x9CB2, 0x9CBD, 0x9CDE, 0x9D12, 0x9D57, 0x9DAD, 0x9E10, 0x9E7F, 0x9EF8, 
	0x9F7A, 0xA002, 0xA08F, 0xA11F, 0xA1AF, 0xA23F, 0xA2CC, 0xA354, 0xA3D5, 
	0xA44F, 0xA4BE, 0xA521, 0xA577, 0xA5BC, 0xA5F0, 0xA611, 0xA61C, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x1BBC, 0x1BC9, 0x1BF1, 0x1C2F, 0x1C83, 0x1CEB, 0x1D62, 0x1DE9, 0x1E7C, 
	0x1F18, 0x1FBD, 0x2067, 0x2115, 0x21C3, 0x2271, 0x231B, 0x23C0, 0x245C, 
	0x24EF, 0x2576, 0x25ED, 0x2654, 0x26A9, 0x26E7, 0x270F, 0x271C, 0x270F, 
	0x26E7, 0x26A9, 0x2654, 0x25ED, 0x2576, 0x24EF, 0x245C, 0x23C0, 0x231B, 
	0x2271, 0x21C3, 0x2115, 0x2067, 0x1FBD, 0x1F18, 0x1E7C, 0x1DE9, 0x1D62, 
	0x1CEB, 0x1C83, 0x1C2F, 0x1BF1, 0x1BC9, 0x1BBC, 0x0000, 0x0003, 0x000B, 
	0x0018, 0x0029, 0x003E, 0x0056, 0x0072, 0x0090, 0x00AF, 0x00D1, 0x00F4, 
	0x0117, 0x013B, 0x015E, 0x0181, 0x01A2, 0x01C2, 0x01E0, 0x01FC, 0x0214, 
	0x0229, 0x023A, 0x0247, 0x024F, 0x0252, 0x024F, 0x0247, 0x023A, 0x0229, 
	0x0214, 0x01FC, 0x01E0, 0x01C2, 0x01A2, 0x0181, 0x015E, 0x013B, 0x0117, 
	0x00F4, 0x00D1, 0x00AF, 0x0090, 0x0072, 0x0056, 0x003E, 0x0029, 0x0018, 
	0x000B, 0x0003, 0x0000, 0x0C88, 0x0C87, 0x0C87, 0x0C85, 0x0C84, 0x0C82, 
	0x0C80, 0x0C7D, 0x0C7B, 0x0C78, 0x0C75, 0x0C72, 0x0C6E, 0x0C6B, 0x0C68, 
	0x0C65, 0x0C62, 0x0C5F, 0x0C5C, 0x0C5A, 0x0C57, 0x0C56, 0x0C54, 0x0C53, 
	0x0C52, 0x0C52, 0x0C52, 0x0C53, 0x0C54, 0x0C56, 0x0C57, 0x0C5A, 0x0C5C, 
	0x0C5F, 0x0C62, 0x0C65, 0x0C68, 0x0C6B, 0x0C6E, 0x0C72, 0x0C75, 0x0C78, 
	0x0C7B, 0x0C7D, 0x0C80, 0x0C82, 0x0C84, 0x0C85, 0x0C87, 0x0C87, 0x0C88, 
	0xDE2A, 0xDE33, 0xDE4E, 0xDE79, 0xDEB1, 0xDEF7, 0xDF48, 0xDFA3, 0xE007, 
	0xE071, 0xE0E0, 0xE154, 0xE1C9, 0xE240, 0xE2B5, 0xE328, 0xE398, 0xE402, 
	0xE465, 0xE4C0, 0xE511, 0xE557, 0xE590, 0xE5BB, 0xE5D5, 0xE5DF, 0xE5D5, 
	0xE5BB, 0xE590, 0xE557, 0xE511, 0xE4C0, 0xE465, 0xE402, 0xE398, 0xE328, 
	0xE2B5, 0xE240, 0xE1C9, 0xE154, 0xE0E0, 0xE071, 0xE007, 0xDFA3, 0xDF48, 
	0xDEF7, 0xDEB1, 0xDE79, 0xDE4E, 0xDE33, 0xDE2A, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x1E07, 0x1E05, 0x1DFD, 
	0x1DF2, 0x1DE3, 0x1DD0, 0x1DBA, 0x1DA2, 0x1D87, 0x1D6B, 0x1D4D, 0x1D2E, 
	0x1D0F, 0x1CEF, 0x1CD0, 0x1CB1, 0x1C93, 0x1C77, 0x1C5C, 0x1C44, 0x1C2E, 
	0x1C1B, 0x1C0C, 0x1C01, 0x1BFA, 0x1BF7, 0x1BFA, 0x1C01, 0x1C0C, 0x1C1B, 
	0x1C2E, 0x1C44, 0x1C5C, 0x1C77, 0x1C93, 0x1CB1, 0x1CD0, 0x1CEF, 0x1D0F, 
	0x1D2E, 0x1D4D, 0x1D6B, 0x1D87, 0x1DA2, 0x1DBA, 0x1DD0, 0x1DE3, 0x1DF2, 
	0x1DFD, 0x1E05, 0x1E07, 0x0C91, 0x0C96, 0x0CA6, 0x0CC0, 0x0CE2, 0x0D0C, 
	0x0D3D, 0x0D74, 0x0DB0, 0x0DF0, 0x0E33, 0x0E79, 0x0EC0, 0x0F07, 0x0F4E, 
	0x0F93, 0x0FD7, 0x1017, 0x1052, 0x1089, 0x10BA, 0x10E4, 0x1107, 0x1120, 
	0x1130, 0x1136, 0x1130, 0x1120, 0x1107, 0x10E4, 0x10BA, 0x1089, 0x1052, 
	0x1017, 0x0FD7, 0x0F93, 0x0F4E, 0x0F07, 0x0EC0, 0x0E79, 0x0E33, 0x0DF0, 
	0x0DB0, 0x0D74, 0x0D3D, 0x0D0C, 0x0CE2, 0x0CC0, 0x0CA6, 0x0C96, 0x0C91, 
	0xB7B3, 0xB7AC, 0xB798, 0xB779, 0xB74E, 0xB71A, 0xB6DD, 0xB699, 0xB64F, 
	0xB600, 0xB5AD, 0xB556, 0xB4FF, 0xB4A6, 0xB44F, 0xB3F9, 0xB3A5, 0xB356, 
	0xB30C, 0xB2C8, 0xB28B, 0xB257, 0xB22D, 0xB20D, 0xB1F9, 0xB1F2, 0xB1F9, 
	0xB20D, 0xB22D, 0xB257, 0xB28B, 0xB2C8, 0xB30C, 0xB356, 0xB3A5, 0xB3F9, 
	0xB44F, 0xB4A6, 0xB4FF, 0xB556, 0xB5AD, 0xB600, 0xB64F, 0xB699, 0xB6DD, 
	0xB71A, 0xB74E, 0xB779, 0xB798, 0xB7AC, 0xB7B3, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x07D2, 0x07E3, 
	0x0811, 0x085C, 0x08C0, 0x093A, 0x09C9, 0x0A68, 0x0B16, 0x0BD0, 0x0C94, 
	0x0D5E, 0x0E2C, 0x0EFC, 0x0FCA, 0x1094, 0x1157, 0x1211, 0x12C0, 0x135F, 
	0x13EE, 0x1468, 0x14CC, 0x1516, 0x1545, 0x1555, 0x1545, 0x1516, 0x14CC, 
	0x1468, 0x13EE, 0x135F, 0x12C0, 0x1211, 0x1157, 0x1094, 0x0FCA, 0x0EFC, 
	0x0E2C, 0x0D5E, 0x0C94, 0x0BD0, 0x0B16, 0x0A68, 0x09C9, 0x093A, 0x08C0, 
	0x085C, 0x0811, 0x07E3, 0x07D2, 0xF94E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xF22C, 

},{ 
	0x0001, 0x0000, 0x0031, 0x0001, 0x0031, 0x0032, 0x0001, 0x0063, 0x0001, 
	0x0064, 0x0001, 0x0065, 0x0033, 0x0066, 0x0033, 0x0099, 0x0033, 0x00CC, 
	0x0033, 0x00FF, 0x0001, 0x0132, 0x0033, 0x0133, 0x0001, 0x0166, 0x0001, 
	0x0167, 0x0001, 0x0168, 0x0001, 0x0169, 0x0001, 0x016A, 0x0001, 0x016B, 
	0x0033, 0x016C, 0x0033, 0x019F, 0x0033, 0x01D2, 0x0033, 0x0205, 0x002E, 
	0x0238, 0x0033, 0x0266, 0x0033, 0x0299, 0x0033, 0x02CC, 0x0033, 0x02FF, 
	0x0001, 0x0332, 0x0001, 0x0333, 0x0001, 0x0334, 0x0033, 0x0335, 0x0033, 
	0x0368, 0x0033, 0x039B, 0x0033, 0x03CE, 0x002F, 0x0401, 0x0033, 0x0430, 
	0x0033, 0x0463, 0x0031, 0x0496, 0x0033, 0x04C7, 0x0033, 0x04FA, 0x0032, 
	0x052D, 0x0001, 0x055F, 0x0033, 0x0560, 0x0033, 0x0593, 0x0033, 0x05C6, 
	0x0031, 0x05F9, 0x0033, 0x062A, 0x0033, 0x065D, 0x0033, 0x0690, 0x0033, 
	0x06C3, 0x0033, 0x06F6, 0x0033, 0x0729, 0x002F, 0x075C, 0x0001, 0x078B, 
	0x0033, 0x078C, 0x0033, 0x07BF, 0x0033, 0x07F2, 0x0033, 0x0825, 0x0031, 
	0x0858, 0x0033, 0x0889, 0x0001, 0x08BC, 0x0032, 0x08BD, 0x0001, 0x08EF, 
	

});



smlua_anim_util_register_animation('donkey_12_crouch_from_slow_long_jump',1, 0, 0, 0, 17, { 
	0x0000, 0x0094, 0x0094, 0x0084, 0x008E, 0xFFEA, 0x0000, 0x3FFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x3EEC, 0x3EC5, 
	0x3EDD, 0x3974, 0x3CEB, 0x40C6, 0x43E7, 0x469E, 0x48F1, 0x4AE8, 0x4C8A, 
	0x4DDE, 0x4EEA, 0x4FB6, 0x5048, 0x50A8, 0x50DD, 0x50ED, 0xFFF2, 0xFF76, 
	0xFE93, 0xFEF1, 0xFFA1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0121, 0x0125, 
	0x00B6, 0x0087, 0x002F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x263A, 0x27B5, 
	0x2A39, 0x33EC, 0x3FF9, 0x45E0, 0x4553, 0x43D1, 0x418F, 0x3EC5, 0x3BA8, 
	0x3871, 0x3555, 0x328A, 0x3048, 0x2EC6, 0x2E39, 0x2E60, 0x0070, 0x00C4, 
	0x011C, 0xFD1A, 0x016C, 0xFD60, 0xFD6D, 0xFD91, 0xFDC9, 0xFE0E, 0xFE5C, 
	0xFEAF, 0xFF03, 0xFF51, 0xFF96, 0xFFCE, 0xFFF2, 0x0000, 0xFD54, 0xFDD9, 
	0xFE69, 0x0074, 0x00D6, 0x0138, 0x0132, 0x0121, 0x0107, 0x00E7, 0x00C3, 
	0x009C, 0x0076, 0x0051, 0x0031, 0x0018, 0x0007, 0x0001, 0xF1E1, 0xF1B7, 
	0xF171, 0xDB9D, 0xC8F3, 0xC404, 0xC42B, 0xC498, 0xC53D, 0xC60C, 0xC6F6, 
	0xC7EE, 0xC8E7, 0xC9D1, 0xCAA0, 0xCB44, 0xCBB1, 0xCBD9, 0x0001, 0xFFFE, 
	0xC170, 0x1DA7, 0x1237, 0x02D8, 0xEEC7, 0xC983, 0xB572, 0xB5DC, 0xB6FC, 
	0xB8AC, 0xBAC1, 0xBD14, 0xBF7A, 0xC1CD, 0xC3E2, 0x4592, 0x46B3, 0x471C, 
	0x4796, 0xDE2E, 0xDD61, 0xDCFB, 0xE248, 0xEC20, 0xF16D, 0xEFE7, 0xEBB2, 
	0xE557, 0xDD5F, 0xD454, 0xCAC0, 0xC12C, 0xB821, 0xCFD5, 0xD630, 0xDA65, 
	0xDBEB, 0x7FBD, 0x8A30, 0x97C4, 0xC2B9, 0xF72B, 0x10BC, 0x0EFE, 0x0A2C, 
	0x02E3, 0xF9C0, 0xEF64, 0xE46A, 0xD970, 0xCF13, 0x45F2, 0x3EA9, 0x39D7, 
	0x3819, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x001E, 0x0073, 
	0x00F2, 0x0192, 0x0247, 0x0307, 0x03C7, 0x047C, 0x051B, 0x059B, 0x05EF, 
	0x060E, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF7B, 0xFE0F, 
	0xFBE9, 0xF938, 0xF62A, 0xF2ED, 0xEFB0, 0xECA2, 0xE9F1, 0xE7CB, 0xE65F, 
	0xE5DB, 0xE2EB, 0xDF81, 0xDBD0, 0xC73A, 0xAC49, 0x9EE3, 0x9F14, 0x9F9A, 
	0xA066, 0xA165, 0xA287, 0xA3B9, 0xA4EC, 0xA60E, 0xA70D, 0xA7D9, 0xA85F, 
	0xA890, 0xEF4F, 0xE8F4, 0xE1F9, 0xD171, 0xCD84, 0xCA6C, 0xCB15, 0xCCE6, 
	0xCFA6, 0xD318, 0xD701, 0xDB25, 0xDF49, 0xE332, 0xE6A4, 0xE964, 0xEB35, 
	0xEBDE, 0xEECB, 0xEC65, 0xE9CF, 0xE16A, 0xE1CF, 0xE213, 0xE29B, 0xE387, 
	0xE4C2, 0xE636, 0xE7CE, 0xE975, 0xEB16, 0xEC9A, 0xEDED, 0xEEFA, 0xEFAB, 
	0xEFEB, 0xEAE0, 0xEE9A, 0xF297, 0x01DB, 0xFFA6, 0xFDF0, 0xFE32, 0xFEE9, 
	0xFFFE, 0x015A, 0x02E4, 0x0484, 0x0625, 0x07AF, 0x090A, 0x0A1F, 0x0AD6, 
	0x0B18, 0x0001, 0xFFFE, 0xC170, 0xCCED, 0xBE2D, 0x3057, 0x645A, 0x0087, 
	0x4ED1, 0x4EDB, 0x4F23, 0x4FE5, 0x74C8, 0x435C, 0x1035, 0x35BF, 0xBA7F, 
	0xBD62, 0xBEDD, 0xBF69, 0xBF7D, 0x25BB, 0x2E8A, 0x47D8, 0x4846, 0x59AB, 
	0x1E30, 0x1E68, 0x1FEC, 0x240A, 0x35F6, 0x3A78, 0x45E9, 0x464B, 0x3647, 
	0x2FC0, 0x2858, 0x2247, 0x1FC3, 0x621D, 0x4D55, 0xB9A4, 0xF8F7, 0xA52B, 
	0xF3F4, 0xEA15, 0xE673, 0xE5EE, 0x087E, 0xD3EF, 0x9E6A, 0xC000, 0x3FF7, 
	0x3FDE, 0x3FC1, 0x3FA9, 0x3F9E, 0x0000, 0x0255, 0x07E5, 0x0E88, 0x1418, 
	0x166D, 0x15DE, 0x1452, 0x11FD, 0x0F11, 0x0BBF, 0x083B, 0x04B7, 0x0166, 
	0xFE79, 0xFC23, 0xFA98, 0xFA09, 0x0000, 0xFDC7, 0xF87B, 0xF22A, 0xECDE, 
	0xEAA6, 0xEB92, 0xEE1E, 0xF1F7, 0xF6CA, 0xFC43, 0x0211, 0x07DE, 0x0D57, 
	0x122A, 0x1603, 0x188F, 0x197B, 0xDB53, 0xDBBD, 0xDC23, 0xCBF2, 0xADE0, 
	0x9DAE, 0x9DE4, 0x9E78, 0x9F57, 0xA070, 0xA1AE, 0xA2FE, 0xA44F, 0xA58D, 
	0xA6A5, 0xA785, 0xA819, 0xA84E, 0x2136, 0x23A6, 0x2660, 0x28DC, 0x2D59, 
	0x3072, 0x2FD9, 0x2E34, 0x2BB7, 0x2898, 0x250E, 0x214E, 0x1D8E, 0x1A04, 
	0x16E5, 0x1468, 0x12C2, 0x122A, 0x1038, 0x0F0F, 0x0DE2, 0x0606, 0x08FD, 
	0x0BCB, 0x0D21, 0x0E3E, 0x0F27, 0x0FE2, 0x1074, 0x10E1, 0x112F, 0x1164, 
	0x1184, 0x1194, 0x119A, 0x119B, 0xFAB9, 0xFB79, 0xFC45, 0xFFA9, 0xFF05, 
	0xFE69, 0xFEBD, 0xFFA6, 0x0107, 0x02C1, 0x04B6, 0x06C8, 0x08DB, 0x0AD0, 
	0x0C89, 0x0DE9, 0x0ED2, 0x0F26, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xBF5E, 0x03D7, 0x034F, 0x02AE, 0xFFA8, 0xFFCC, 
	0x0008, 0x0065, 0x0130, 0x01FC, 0x0259, 0xFABF, 0xFC11, 0xFD04, 0xFFF3, 
	0xFED7, 0xFD5E, 0xF973, 0xF407, 0xEF37, 0xED24, 0x82B7, 0x8029, 0x7F43, 
	0x8A2B, 0x88FD, 0x879E, 0x83C9, 0x7E5F, 0x798B, 0x7774, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x2583, 0x40B0, 0x5430, 0x5591, 0x54E8, 0x53AB, 
	0x519A, 0x4F2F, 0x4D2B, 0x4C54, 0xFC3D, 0xFCE0, 0xFD7C, 0xFF64, 0xFF13, 
	0xFEB0, 0xFDA3, 0xFC2B, 0xFADC, 0xFA4B, 0x0176, 0x00F9, 0x007A, 0xFF25, 
	0xFF3E, 0xFF49, 0xFF87, 0xFFD7, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xC53F, 0xC140, 0xBCCC, 0xB076, 
	0xB21B, 0xB2E2, 0xB4B2, 0xB77D, 0xBA0D, 0xBB2C, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xBF5E, 0xFE57, 
	0xFEAA, 0xFF0B, 0x01CD, 0x011F, 0x00B9, 0x0101, 0x019E, 0x023B, 0x0283, 
	0x01A0, 0x0209, 0x0295, 0x0200, 0x03CD, 0x0596, 0x0971, 0x0EAF, 0x134D, 
	0x1549, 0x8864, 0x83BA, 0x80A1, 0x83F2, 0x82A8, 0x817D, 0x7E35, 0x7979, 
	0x7537, 0x735F, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x27FE, 
	0x406D, 0x519B, 0x5408, 0x503A, 0x4C9D, 0x49BF, 0x4750, 0x45A0, 0x44FE, 
	0xFE32, 0xFFE9, 0x0117, 0xFD6D, 0xFD7D, 0xFDA2, 0xFE70, 0xFF7B, 0x0000, 
	0x0012, 0xFD4C, 0xFD39, 0xFD2F, 0xFD37, 0xFD64, 0xFD8C, 0xFDF1, 0xFE7D, 
	0xFEFA, 0xFF30, 0xC04C, 0xBF0A, 0xBDA4, 0xBE26, 0xBFDF, 0xC0BA, 0xC213, 
	0xC3E4, 0xC57D, 0xC62C, 

},{ 
	0x0001, 0x0000, 0x0004, 0x0001, 0x0001, 0x0005, 0x0001, 0x0006, 0x0001, 
	0x0007, 0x0001, 0x0008, 0x0008, 0x0009, 0x0008, 0x0011, 0x0012, 0x0019, 
	0x0012, 0x002B, 0x0012, 0x003D, 0x0012, 0x004F, 0x0012, 0x0061, 0x0012, 
	0x0073, 0x0012, 0x0085, 0x0001, 0x0097, 0x0001, 0x0098, 0x0001, 0x0099, 
	0x0012, 0x009A, 0x0012, 0x00AC, 0x0012, 0x00BE, 0x0012, 0x00D0, 0x0012, 
	0x00E2, 0x0012, 0x00F4, 0x0012, 0x0106, 0x0012, 0x0118, 0x0012, 0x012A, 
	0x0001, 0x013C, 0x0001, 0x013D, 0x0001, 0x013E, 0x0012, 0x013F, 0x0012, 
	0x0151, 0x0012, 0x0163, 0x0012, 0x0175, 0x0012, 0x0187, 0x0012, 0x0199, 
	0x0012, 0x01AB, 0x0012, 0x01BD, 0x0012, 0x01CF, 0x0012, 0x01E1, 0x0011, 
	0x01F3, 0x0001, 0x0204, 0x000A, 0x0205, 0x000A, 0x020F, 0x000A, 0x0219, 
	0x000E, 0x0223, 0x0012, 0x0231, 0x000A, 0x0243, 0x000A, 0x024D, 0x0012, 
	0x0257, 0x000A, 0x0269, 0x000A, 0x0273, 0x0012, 0x027D, 0x0001, 0x028F, 
	0x000A, 0x0290, 0x000A, 0x029A, 0x000A, 0x02A4, 0x0010, 0x02AE, 0x0011, 
	0x02BE, 0x000A, 0x02CF, 0x000A, 0x02D9, 0x000A, 0x02E3, 0x000A, 0x02ED, 
	

});

smlua_anim_util_register_animation('donkey_11_crouch_from_fast_long_jump',1, 0, 0, 0, 16, { 
	0x0000, 0x0099, 0x00A2, 0x008E, 0xFFEA, 0x0000, 0x3FFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x3AC3, 0x38B5, 0x374B, 
	0x3974, 0x3CEB, 0x40C6, 0x4443, 0x4736, 0x49AA, 0x4BAC, 0x4D45, 0x4E83, 
	0x4F70, 0x5018, 0x5086, 0x50C7, 0x50E5, 0x106C, 0x0F32, 0x0B2A, 0x0616, 
	0x01CD, 0x0000, 0xFA19, 0xFA7F, 0xFC22, 0xFDFE, 0xFF6D, 0x0000, 0x2E21, 
	0x3215, 0x359F, 0x3BC0, 0x429F, 0x45E0, 0x4553, 0x43D1, 0x418F, 0x3EC5, 
	0x3BA8, 0x3871, 0x3555, 0x328A, 0x3048, 0x2EC6, 0x2E39, 0xF381, 0xF118, 
	0xF0F2, 0xFD1A, 0x016C, 0xFD60, 0xFD6D, 0xFD91, 0xFDC9, 0xFE0E, 0xFE5C, 
	0xFEAF, 0xFF03, 0xFF51, 0xFF96, 0xFFCE, 0xFFF2, 0xFB39, 0xFDBF, 0x002F, 
	0x0074, 0x00F3, 0x0138, 0x0132, 0x0121, 0x0107, 0x00E7, 0x00C3, 0x009C, 
	0x0076, 0x0051, 0x0031, 0x0018, 0x0007, 0xF6D3, 0xEFE7, 0xE957, 0xDB9D, 
	0xCBAB, 0xC404, 0xC42B, 0xC498, 0xC53D, 0xC60C, 0xC6F6, 0xC7EE, 0xC8E7, 
	0xC9D1, 0xCAA0, 0xCB44, 0xCBB1, 0x0001, 0xFFFE, 0xC170, 0xD6E9, 0xC837, 
	0xBD5D, 0xB7CB, 0xB5BD, 0xB572, 0xB5DC, 0xB6FC, 0xB8AC, 0xBAC1, 0xBD14, 
	0xBF7A, 0xC1CD, 0xC3E2, 0x4592, 0x46B3, 0x471C, 0xE6A1, 0xDBA8, 0xDF0F, 
	0xE68A, 0xEE06, 0xF16D, 0xEFE7, 0xEBB2, 0xE557, 0xDD5F, 0xD454, 0xCAC0, 
	0xC12C, 0xB821, 0xCFD5, 0xD630, 0xDA65, 0xE092, 0xE276, 0xECE2, 0xFC6F, 
	0x0A92, 0x10BC, 0x0EFE, 0x0A2C, 0x02E3, 0xF9C0, 0xEF64, 0xE46A, 0xD970, 
	0xCF13, 0x45F2, 0x3EA9, 0x39D7, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x001E, 0x0073, 0x00F2, 0x0192, 0x0247, 0x0307, 0x03C7, 0x047C, 
	0x051B, 0x059B, 0x05EF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFF7B, 0xFE0F, 0xFBE9, 0xF938, 0xF62A, 0xF2ED, 0xEFB0, 0xECA2, 0xE9F1, 
	0xE7CB, 0xE65F, 0xF3C1, 0xEC41, 0xD7D7, 0xBE2B, 0xA833, 0x9EE3, 0x9F14, 
	0x9F9A, 0xA066, 0xA165, 0xA287, 0xA3B9, 0xA4EC, 0xA60E, 0xA70D, 0xA7D9, 
	0xA85F, 0xDE66, 0xDA45, 0xD5D2, 0xD171, 0xCD84, 0xCA6C, 0xCB15, 0xCCE6, 
	0xCFA6, 0xD318, 0xD701, 0xDB25, 0xDF49, 0xE332, 0xE6A4, 0xE964, 0xEB35, 
	0xE0EC, 0xE0D2, 0xE109, 0xE16A, 0xE1CF, 0xE213, 0xE2A7, 0xE39B, 0xE4D9, 
	0xE64F, 0xE7E6, 0xE98A, 0xEB27, 0xECA6, 0xEDF5, 0xEEFE, 0xEFAC, 0x08B5, 
	0x06A8, 0x0448, 0x01DB, 0xFFA6, 0xFDF0, 0xFE32, 0xFEE9, 0xFFFE, 0x015A, 
	0x02E4, 0x0484, 0x0625, 0x07AF, 0x090A, 0x0A1F, 0x0AD6, 0x0001, 0xFFFE, 
	0xC170, 0x3E1B, 0x486C, 0xF37D, 0x59AF, 0x502D, 0x4ED1, 0x4EDB, 0x4F23, 
	0x4FE5, 0x74C8, 0x435C, 0x1035, 0x35BF, 0xBA7F, 0xBD62, 0xBEDD, 0xBF69, 
	0x180C, 0x2565, 0x4605, 0x32C6, 0x2565, 0x1E30, 0x1E68, 0x1FEC, 0x240A, 
	0x35F6, 0x3A78, 0x45E9, 0x464B, 0x3647, 0x2FC0, 0x2858, 0x2247, 0xE790, 
	0xE57B, 0xAAEF, 0x0506, 0xF78C, 0xF3F4, 0xEEC2, 0xE8C9, 0xE5EE, 0x087E, 
	0xD3EF, 0x9E6A, 0xC000, 0x3FF7, 0x3FDE, 0x3FC1, 0x3FA9, 0xFFFF, 0x0255, 
	0x07E5, 0x0E88, 0x1418, 0x166D, 0x15DE, 0x1452, 0x11FD, 0x0F11, 0x0BBF, 
	0x083B, 0x04B7, 0x0166, 0xFE79, 0xFC23, 0xFA98, 0xFFFF, 0xFDC7, 0xF87B, 
	0xF22A, 0xECDE, 0xEAA6, 0xEB92, 0xEE1E, 0xF1F7, 0xF6CA, 0xFC43, 0x0211, 
	0x07DE, 0x0D57, 0x122A, 0x1603, 0x188F, 0xF445, 0xF2AE, 0xE2B7, 0xC5CC, 
	0xAA11, 0x9DAE, 0x9DE4, 0x9E78, 0x9F57, 0xA070, 0xA1AE, 0xA2FE, 0xA44F, 
	0xA58D, 0xA6A5, 0xA785, 0xA819, 0x156D, 0x1B9C, 0x23CD, 0x28DC, 0x2D59, 
	0x3072, 0x2FD9, 0x2E34, 0x2BB7, 0x2898, 0x250E, 0x214E, 0x1D8E, 0x1A04, 
	0x16E5, 0x1468, 0x12C2, 0x1B99, 0x1136, 0x0643, 0x0606, 0x08FD, 0x0BCB, 
	0x0D21, 0x0E3E, 0x0F27, 0x0FE2, 0x1074, 0x10E1, 0x112F, 0x1164, 0x1184, 
	0x1194, 0x119A, 0xFAFD, 0xFD21, 0xFF9C, 0xFFA9, 0xFF05, 0xFE69, 0xFEBD, 
	0xFFA6, 0x0107, 0x02C1, 0x04B6, 0x06C8, 0x08DB, 0x0AD0, 0x0C89, 0x0DE9, 
	0x0ED2, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 0x02DE, 0x0182, 0xFFE6, 
	0xFFA8, 0xFFCC, 0x0008, 0x0065, 0x0130, 0x01FC, 0x0259, 0xF952, 0xFC9B, 
	0xFFF9, 0xFFF3, 0xFED7, 0xFD5E, 0xF972, 0xF406, 0xEF37, 0xED24, 0x8CC7, 
	0x8BD1, 0x8B32, 0x8A2B, 0x88FD, 0x879E, 0x83B5, 0x7E4E, 0x7984, 0x7774, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x330E, 0x425A, 0x526D, 
	0x5591, 0x54E8, 0x53AB, 0x519A, 0x4F2F, 0x4D2B, 0x4C54, 0xFB89, 0xFD47, 
	0xFF34, 0xFF64, 0xFF13, 0xFEB0, 0xFDA3, 0xFC2B, 0xFADC, 0xFA4B, 0xFF13, 
	0xFF07, 0xFF13, 0xFF25, 0xFF3E, 0xFF49, 0xFF86, 0xFFD7, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xAF2D, 0xAEAA, 0xAF2D, 
	0xB076, 0xB21B, 0xB2E2, 0xB4CD, 0xB795, 0xBA16, 0xBB2C, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xBF5E, 
	0xFD6D, 0xFF90, 0x01D3, 0x01CD, 0x011F, 0x00B9, 0x0101, 0x019E, 0x023B, 
	0x0283, 0x0046, 0x003E, 0x00A3, 0x0200, 0x03CD, 0x0596, 0x098D, 0x0EC8, 
	0x1356, 0x1549, 0x9563, 0x8EE4, 0x8696, 0x83F2, 0x82A8, 0x817D, 0x7E1F, 
	0x7966, 0x7530, 0x735F, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x14E1, 0x3084, 0x5018, 
	0x5408, 0x503A, 0x4C9D, 0x49BF, 0x4750, 0x45A0, 0x44FE, 0xFCE1, 0xFD14, 
	0xFD56, 0xFD6D, 0xFD7D, 0xFDA2, 0xFE70, 0xFF7B, 0x0000, 0x0012, 0xFD81, 
	0xFD50, 0xFD22, 0xFD37, 0xFD64, 0xFD8C, 0xFDF2, 0xFE7E, 0xFEFA, 0xFF30, 
	0xC2FA, 0xC043, 0xBD71, 0xBE26, 0xBFDF, 0xC0BA, 0xC216, 0xC3E6, 0xC57E, 
	0xC62C, 

},{ 
	0x0001, 0x0000, 0x0003, 0x0001, 0x0001, 0x0004, 0x0001, 0x0005, 0x0001, 
	0x0006, 0x0001, 0x0007, 0x0008, 0x0008, 0x0008, 0x0010, 0x0011, 0x0018, 
	0x0006, 0x0029, 0x0006, 0x002F, 0x0011, 0x0035, 0x0011, 0x0046, 0x0011, 
	0x0057, 0x0011, 0x0068, 0x0001, 0x0079, 0x0001, 0x007A, 0x0001, 0x007B, 
	0x0011, 0x007C, 0x0011, 0x008D, 0x0011, 0x009E, 0x0011, 0x00AF, 0x0011, 
	0x00C0, 0x0011, 0x00D1, 0x0011, 0x00E2, 0x0011, 0x00F3, 0x0011, 0x0104, 
	0x0001, 0x0115, 0x0001, 0x0116, 0x0001, 0x0117, 0x0011, 0x0118, 0x0011, 
	0x0129, 0x0011, 0x013A, 0x0011, 0x014B, 0x0011, 0x015C, 0x0011, 0x016D, 
	0x0011, 0x017E, 0x0011, 0x018F, 0x0011, 0x01A0, 0x000E, 0x01B1, 0x0011, 
	0x01BF, 0x0001, 0x01D0, 0x000A, 0x01D1, 0x000A, 0x01DB, 0x000A, 0x01E5, 
	0x0011, 0x01EF, 0x0010, 0x0200, 0x000A, 0x0210, 0x000A, 0x021A, 0x0010, 
	0x0224, 0x000A, 0x0234, 0x000B, 0x023E, 0x0011, 0x0249, 0x0001, 0x025A, 
	0x000A, 0x025B, 0x000A, 0x0265, 0x000A, 0x026F, 0x000F, 0x0279, 0x000F, 
	0x0288, 0x000A, 0x0297, 0x000A, 0x02A1, 0x000A, 0x02AB, 0x000A, 0x02B5, 
	

});

smlua_anim_util_register_animation('donkey_8D_crouch_from_slide_kick',1, 0, 0, 0, 13, { 
	0x0000, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0086, 0x008E, 0xFFEA, 
	0x0000, 0x3FFF, 0x0000, 0xF1AB, 0xF1E9, 0xF295, 0xF39B, 0xF4E8, 0xF666, 
	0xF802, 0xF9A9, 0xFB69, 0xFD1E, 0xFE95, 0xFF9C, 0x0000, 0xFFFF, 0xFF33, 
	0xFF36, 0xFF40, 0xFF4E, 0xFF61, 0xFF76, 0xFF8D, 0xFFA5, 0xFFBE, 0xFFD6, 
	0xFFEB, 0xFFFA, 0x0000, 0x0D43, 0x0E67, 0x1193, 0x1669, 0x1C8A, 0x2397, 
	0x2B33, 0x32FE, 0x3AD5, 0x4241, 0x48B1, 0x4D95, 0x505B, 0x50ED, 0xF33A, 
	0xF371, 0xF40A, 0xF4F4, 0xF61C, 0xF771, 0xF8E1, 0xFA59, 0xFBE7, 0xFD6D, 
	0xFEBC, 0xFFA7, 0x0000, 0xFFFF, 0xFCB3, 0xFCC1, 0xFCE9, 0xFD25, 0xFD71, 
	0xFDC9, 0xFE28, 0xFE8A, 0xFEF1, 0xFF56, 0xFFAC, 0xFFE8, 0x0000, 0xFFFF, 
	0x1203, 0x1299, 0x143C, 0x16BB, 0x19E5, 0x1D89, 0x2176, 0x257B, 0x28D2, 
	0x2B54, 0x2D0E, 0x2E0E, 0x2E60, 0x11CF, 0x11E8, 0x114D, 0x1023, 0x0E8D, 
	0x0CB0, 0x0AAE, 0x08AC, 0x066B, 0x0419, 0x020A, 0x0090, 0xFFFF, 0x0000, 
	0xF4A1, 0xF4BE, 0xF557, 0xF650, 0xF790, 0xF8FC, 0xFA78, 0xFBEA, 0xFD3B, 
	0xFE5B, 0xFF3A, 0xFFCB, 0x0000, 0x0001, 0x1A18, 0x191A, 0x1563, 0x0F8E, 
	0x0835, 0xFFF3, 0xF760, 0xEF18, 0xE68A, 0xDD2F, 0xD496, 0xCE4A, 0xCBD9, 
	0x0001, 0xFFFE, 0xC170, 0xE896, 0xEC3D, 0xFC1E, 0x04CD, 0x1B03, 0x3619, 
	0x4E8B, 0xDCD4, 0xD1C6, 0x3623, 0x1235, 0xEE47, 0x52A4, 0x4796, 0xE6F9, 
	0xE83B, 0xFEA3, 0xF8B6, 0xF21D, 0xEABF, 0xE39D, 0xA245, 0xAB6B, 0xC889, 
	0xBBA2, 0xAFE7, 0xD89F, 0xDBEB, 0x1770, 0x0EEF, 0x033F, 0xF0D4, 0xE25A, 
	0xD3C4, 0xC34D, 0x2F33, 0x2FDC, 0xB181, 0xB3A5, 0xB5CA, 0x3770, 0x3819, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0073, 
	0x0192, 0x0307, 0x047C, 0x059B, 0x060E, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFE0F, 0xF938, 0xF2ED, 0xECA2, 0xE7CB, 
	0xE5DB, 0xD5BA, 0xDA64, 0xDFDE, 0xE4FB, 0xEA7A, 0xF07B, 0xF4DB, 0xF579, 
	0xEFC7, 0xE189, 0xCF05, 0xBC81, 0xAE43, 0xA890, 0xD3BB, 0xE7C9, 0xFC93, 
	0x04DD, 0xFABC, 0xE6BD, 0xD162, 0xC32D, 0xC631, 0xCDBA, 0xD786, 0xE151, 
	0xE8DA, 0xEBDE, 0xF441, 0xF96D, 0xFD7F, 0xFE70, 0xFB2C, 0xF56C, 0xEF5B, 
	0xEB23, 0xEB7E, 0xEC60, 0xED87, 0xEEAD, 0xEF90, 0xEFEB, 0xF0C2, 0xE8C1, 
	0xDF16, 0xDA81, 0xDDDB, 0xE534, 0xED22, 0xF236, 0xF744, 0xFCC6, 0x0220, 
	0x06B3, 0x09E5, 0x0B18, 0x0001, 0xFFFE, 0xC170, 0x49A0, 0x39BB, 0x3739, 
	0x1D2A, 0x07C8, 0xFC13, 0x007E, 0xD539, 0xD39D, 0x4F97, 0x4A5B, 0xC51F, 
	0xC119, 0xBF7D, 0x167A, 0x18C2, 0x1F8C, 0x25E2, 0x1BF1, 0x153D, 0x11E0, 
	0x198D, 0x1C2B, 0x6214, 0x6104, 0x1F88, 0x1FBB, 0x1FC3, 0x2327, 0x1F4C, 
	0x1583, 0xE847, 0xC6BE, 0xC4D4, 0xBE7E, 0xB24B, 0x9ED9, 0x068C, 0xED20, 
	0x5657, 0x45EC, 0x3F9E, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFF8E, 0xFE73, 0xFD04, 0xFB95, 0xFA7A, 0xFA09, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x01E3, 0x069B, 
	0x0CBE, 0x12E0, 0x1798, 0x197B, 0xCEA5, 0xD465, 0xDC18, 0xE4BC, 0xED4E, 
	0xF4CB, 0xFA30, 0xFC7A, 0xF63E, 0xE6A8, 0xD264, 0xBE21, 0xAE8A, 0xA84E, 
	0xE0EA, 0xE88E, 0xFCC1, 0x042C, 0x0A4C, 0x0FB5, 0x14FB, 0x1AB3, 0x1A11, 
	0x187C, 0x166E, 0x1460, 0x12CC, 0x122A, 0x03F5, 0x028E, 0x0500, 0x075D, 
	0x0A2B, 0x0D1E, 0x0FEC, 0x124B, 0x123E, 0x121D, 0x11F3, 0x11C9, 0x11A8, 
	0x119B, 0xE245, 0xE0CE, 0xE35D, 0xE5D6, 0xE8C4, 0xEBD9, 0xEEC8, 0xF142, 
	0xF5B0, 0xFBD7, 0x0299, 0x08D1, 0x0D61, 0x0F26, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xBF5E, 0xFC1C, 0xFC10, 0xFC63, 0xFCF9, 
	0xFDB9, 0xFE87, 0xFF49, 0xFFE4, 0x0081, 0x011B, 0x01A1, 0x01FF, 0x0222, 
	0x0259, 0xEB35, 0xEB31, 0xEB4B, 0xEB7A, 0xEBB5, 0xEBF5, 0xEC31, 0xEC61, 
	0xEC8F, 0xECBC, 0xECE5, 0xED06, 0xED1C, 0xED24, 0x8D12, 0x8D3C, 0x8C1E, 
	0x8A14, 0x877C, 0x84B1, 0x8211, 0x7FF5, 0x7DEF, 0x7BF8, 0x7A33, 0x78C4, 
	0x77CD, 0x7774, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x61F7, 
	0x62F4, 0x62E6, 0x6206, 0x6090, 0x5EBF, 0x5CCD, 0x5AF4, 0x5866, 0x5548, 
	0x520E, 0x4F2E, 0x4D1E, 0x4C54, 0xFB09, 0xFB07, 0xFAFA, 0xFAE4, 0xFAC9, 
	0xFAAD, 0xFA94, 0xFA81, 0xFA71, 0xFA64, 0xFA59, 0xFA51, 0xFA4D, 0xFA4B, 
	0xFD4C, 0xFD5B, 0xFD9A, 0xFDF8, 0xFE68, 0xFEDA, 0xFF3F, 0xFF89, 0xFFBD, 
	0xFFDF, 0xFFF3, 0xFFFD, 0x0000, 0xFFFF, 0xA73D, 0xA7B0, 0xA97E, 0xAC38, 
	0xAF71, 0xB2BA, 0xB5A5, 0xB7C5, 0xB934, 0xBA2A, 0xBABF, 0xBB0C, 0xBB28, 
	0xBB2C, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xBF5E, 0x0675, 0x0642, 0x057E, 0x0497, 0x03FC, 
	0x03AF, 0x036B, 0x032F, 0x02FC, 0x02D1, 0x02B0, 0x0297, 0x0288, 0x0283, 
	0xFCFC, 0xFC6F, 0xFEBA, 0x0224, 0x04F3, 0x0708, 0x0958, 0x0BC1, 0x0E1C, 
	0x1056, 0x124D, 0x13DF, 0x14E9, 0x1549, 0xA81D, 0xA6B8, 0x9E31, 0x93A5, 
	0x8C34, 0x880C, 0x8402, 0x8031, 0x7CB6, 0x79A2, 0x770D, 0x7513, 0x73D0, 
	0x735F, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x1605, 0x1AFD, 0x277C, 0x35F2, 0x40CF, 0x45E6, 0x47E4, 0x4882, 0x483F, 
	0x4798, 0x46C0, 0x45E7, 0x4540, 0x44FE, 0xFFF7, 0xFFF6, 0xFFF8, 0xFFFB, 
	0xFFFE, 0x0000, 0x0003, 0x0006, 0x0009, 0x000B, 0x000E, 0x0010, 0x0011, 
	0x0012, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF2F, 0xFF30, 
	0xCBF9, 0xCC33, 0xCBC9, 0xCB16, 0xCA78, 0xC9F5, 0xC95E, 0xC8BE, 0xC81E, 
	0xC784, 0xC6FC, 0xC68F, 0xC647, 0xC62C, 

},{ 
	0x0001, 0x0000, 0x0007, 0x0001, 0x0001, 0x0008, 0x0001, 0x0009, 0x0001, 
	0x000A, 0x0001, 0x000B, 0x000E, 0x000C, 0x000D, 0x001A, 0x000E, 0x0027, 
	0x000E, 0x0035, 0x000E, 0x0043, 0x000D, 0x0051, 0x000E, 0x005E, 0x000E, 
	0x006C, 0x000D, 0x007A, 0x0001, 0x0087, 0x0001, 0x0088, 0x0001, 0x0089, 
	0x000E, 0x008A, 0x000E, 0x0098, 0x000E, 0x00A6, 0x000E, 0x00B4, 0x000E, 
	0x00C2, 0x000E, 0x00D0, 0x000E, 0x00DE, 0x000E, 0x00EC, 0x000E, 0x00FA, 
	0x0001, 0x0108, 0x0001, 0x0109, 0x0001, 0x010A, 0x000E, 0x010B, 0x000E, 
	0x0119, 0x000E, 0x0127, 0x000E, 0x0135, 0x000E, 0x0143, 0x000E, 0x0151, 
	0x000E, 0x015F, 0x000E, 0x016D, 0x000E, 0x017B, 0x000C, 0x0189, 0x000D, 
	0x0195, 0x0001, 0x01A2, 0x000E, 0x01A3, 0x000E, 0x01B1, 0x000E, 0x01BF, 
	0x000A, 0x01CD, 0x000E, 0x01D7, 0x000E, 0x01E5, 0x000E, 0x01F3, 0x000E, 
	0x0201, 0x000E, 0x020F, 0x0008, 0x021D, 0x000C, 0x0225, 0x0001, 0x0231, 
	0x000E, 0x0232, 0x000E, 0x0240, 0x000E, 0x024E, 0x000C, 0x025C, 0x000E, 
	0x0268, 0x000E, 0x0276, 0x000E, 0x0284, 0x0008, 0x0292, 0x000E, 0x029A, 
	

});

smlua_anim_util_register_animation('donkey_99_crawling',0, 0, 0, 0, 91, { 
	0x0000, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 
	0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 
	0x0039, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 
	0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 
	0x0037, 0x0037, 0x0037, 0x0037, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 
	0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 
	0x0036, 0x0036, 0x0036, 0x0037, 0x0037, 0x0037, 0x0037, 0x0038, 0x0038, 
	0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 
	0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0039, 0xFFEA, 0x0000, 
	0x3FFF, 0x0000, 0xFDEA, 0xFDEA, 0xFDEA, 0xFDEA, 0xFDEC, 0xFDF1, 0xFDF9, 
	0xFE05, 0xFE13, 0xFE25, 0xFE38, 0xFE4F, 0xFE67, 0xFE82, 0xFE9F, 0xFEBD, 
	0xFEDD, 0xFEFF, 0xFF22, 0xFF46, 0xFF6B, 0xFF91, 0xFFB7, 0xFFDE, 0x0006, 
	0x002D, 0x0055, 0x007C, 0x00A3, 0x00C9, 0x00EF, 0x0114, 0x0138, 0x015B, 
	0x017D, 0x019D, 0x01BB, 0x01D8, 0x01F3, 0x020C, 0x0222, 0x0236, 0x0247, 
	0x0256, 0x0261, 0x026A, 0x026F, 0x0271, 0x026F, 0x026A, 0x0261, 0x0256, 
	0x0247, 0x0236, 0x0222, 0x020C, 0x01F3, 0x01D8, 0x01BB, 0x019D, 0x017D, 
	0x015B, 0x0138, 0x0114, 0x00EF, 0x00C9, 0x00A3, 0x007C, 0x0055, 0x002D, 
	0x0006, 0xFFDE, 0xFFB7, 0xFF91, 0xFF6B, 0xFF46, 0xFF22, 0xFEFF, 0xFEDD, 
	0xFEBD, 0xFE9F, 0xFE82, 0xFE67, 0xFE4F, 0xFE38, 0xFE25, 0xFE13, 0xFE05, 
	0xFDF9, 0xFDF1, 0xFDEC, 0xFDEA, 0x0708, 0x0708, 0x0708, 0x0708, 0x0702, 
	0x06F1, 0x06D4, 0x06AD, 0x067D, 0x0642, 0x05FF, 0x05B4, 0x0561, 0x0507, 
	0x04A7, 0x0440, 0x03D4, 0x0363, 0x02ED, 0x0274, 0x01F7, 0x0178, 0x00F6, 
	0x0073, 0xFFEF, 0xFF6A, 0xFEE5, 0xFE60, 0xFDDD, 0xFD5B, 0xFCDC, 0xFC5F, 
	0xFBE6, 0xFB71, 0xFAFF, 0xFA93, 0xFA2D, 0xF9CC, 0xF972, 0xF91F, 0xF8D4, 
	0xF891, 0xF857, 0xF826, 0xF7FF, 0xF7E2, 0xF7D1, 0xF7CB, 0xF7D1, 0xF7E2, 
	0xF7FF, 0xF826, 0xF857, 0xF891, 0xF8D4, 0xF91F, 0xF972, 0xF9CC, 0xFA2D, 
	0xFA93, 0xFAFF, 0xFB71, 0xFBE6, 0xFC5F, 0xFCDC, 0xFD5B, 0xFDDD, 0xFE60, 
	0xFEE5, 0xFF6A, 0xFFEF, 0x0073, 0x00F6, 0x0178, 0x01F7, 0x0274, 0x02ED, 
	0x0363, 0x03D4, 0x0440, 0x04A7, 0x0507, 0x0561, 0x05B4, 0x05FF, 0x0642, 
	0x067D, 0x06AD, 0x06D4, 0x06F1, 0x0702, 0x0708, 0x7431, 0x7431, 0x7431, 
	0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7430, 0x7430, 0x7430, 0x7430, 
	0x742F, 0x742F, 0x742E, 0x742E, 0x742D, 0x742D, 0x742C, 0x742C, 0x742B, 
	0x742B, 0x742A, 0x742A, 0x7429, 0x7429, 0x7428, 0x7427, 0x7427, 0x7426, 
	0x7426, 0x7425, 0x7425, 0x7424, 0x7424, 0x7423, 0x7423, 0x7422, 0x7422, 
	0x7422, 0x7421, 0x7421, 0x7421, 0x7420, 0x7420, 0x7420, 0x7420, 0x7420, 
	0x7420, 0x7420, 0x7420, 0x7420, 0x7421, 0x7421, 0x7421, 0x7422, 0x7422, 
	0x7422, 0x7423, 0x7423, 0x7424, 0x7424, 0x7425, 0x7425, 0x7426, 0x7426, 
	0x7427, 0x7427, 0x7428, 0x7429, 0x7429, 0x742A, 0x742A, 0x742B, 0x742B, 
	0x742C, 0x742C, 0x742D, 0x742D, 0x742E, 0x742E, 0x742F, 0x742F, 0x7430, 
	0x7430, 0x7430, 0x7430, 0x7431, 0x0B47, 0x0B41, 0x0B30, 0x0B14, 0x0AED, 
	0x0ABD, 0x0A84, 0x0A41, 0x09F7, 0x09A4, 0x094A, 0x08E9, 0x0883, 0x0816, 
	0x07A4, 0x072D, 0x06B2, 0x0633, 0x05B1, 0x052C, 0x04A4, 0x041B, 0x0391, 
	0x0306, 0x027B, 0x01F0, 0x0165, 0x00DC, 0x0055, 0xFFCF, 0xFF4D, 0xFECE, 
	0xFE53, 0xFDDC, 0xFD6A, 0xFCFD, 0xFC96, 0xFC35, 0xFBDC, 0xFB89, 0xFB3E, 
	0xFAFC, 0xFAC2, 0xFA92, 0xFA6C, 0xFA50, 0xFA3F, 0xFA39, 0xF993, 0xF9B7, 
	0xF9EB, 0xFA2C, 0xFA7B, 0xFAD5, 0xFB39, 0xFBA4, 0xFC17, 0xFC8E, 0xFD09, 
	0xFD86, 0xFE03, 0xFE7F, 0xFEF9, 0xFF6E, 0xFFDD, 0x0045, 0x00A4, 0x00F9, 
	0x0149, 0x019C, 0x01F1, 0x0247, 0x029E, 0x02F6, 0x035C, 0x03D3, 0x0457, 
	0x04E5, 0x057C, 0x0617, 0x06B6, 0x0755, 0x07F1, 0x0888, 0x0917, 0x099C, 
	0x0A13, 0x0A7B, 0x0AD0, 0x0B10, 0x0B39, 0x0B47, 0xF415, 0xF41D, 0xF437, 
	0xF461, 0xF49B, 0xF4E3, 0xF53A, 0xF59D, 0xF60D, 0xF689, 0xF710, 0xF7A1, 
	0xF83C, 0xF8DF, 0xF98A, 0xFA3C, 0xFAF5, 0xFBB4, 0xFC77, 0xFD3E, 0xFE09, 
	0xFED7, 0xFFA7, 0x0078, 0x0149, 0x021A, 0x02E9, 0x03B7, 0x0482, 0x0549, 
	0x060D, 0x06CB, 0x0784, 0x0836, 0x08E2, 0x0985, 0x0A1F, 0x0AB0, 0x0B37, 
	0x0BB3, 0x0C23, 0x0C87, 0x0CDD, 0x0D25, 0x0D5F, 0x0D89, 0x0DA3, 0x0DAC, 
	0x0D87, 0x0D3F, 0x0CD5, 0x0C4E, 0x0BAC, 0x0AF2, 0x0A25, 0x0946, 0x0859, 
	0x0762, 0x0663, 0x0560, 0x045C, 0x035A, 0x025D, 0x0169, 0x0081, 0xFFA8, 
	0xFEE2, 0xFE31, 0xFD88, 0xFCD9, 0xFC26, 0xFB6F, 0xFAB6, 0xF9FC, 0xF94C, 
	0xF8A8, 0xF810, 0xF784, 0xF703, 0xF68D, 0xF623, 0xF5C3, 0xF56E, 0xF522, 
	0xF4E1, 0xF4A9, 0xF47B, 0xF455, 0xF439, 0xF424, 0xF419, 0xF415, 0xEBEB, 
	0xEBEB, 0xEBEC, 0xEBEE, 0xEBF0, 0xEBF3, 0xEBF7, 0xEBFB, 0xEBFF, 0xEC04, 
	0xEC0A, 0xEC10, 0xEC16, 0xEC1D, 0xEC24, 0xEC2B, 0xEC32, 0xEC3A, 0xEC42, 
	0xEC4A, 0xEC53, 0xEC5B, 0xEC63, 0xEC6C, 0xEC74, 0xEC7D, 0xEC85, 0xEC8E, 
	0xEC96, 0xEC9E, 0xECA6, 0xECAE, 0xECB5, 0xECBD, 0xECC4, 0xECCA, 0xECD1, 
	0xECD6, 0xECDC, 0xECE1, 0xECE6, 0xECEA, 0xECED, 0xECF0, 0xECF2, 0xECF4, 
	0xECF5, 0xECF6, 0xECF5, 0xECF4, 0xECF2, 0xECEF, 0xECEC, 0xECE8, 0xECE3, 
	0xECDE, 0xECD9, 0xECD2, 0xECCC, 0xECC5, 0xECBD, 0xECB6, 0xECAE, 0xECA5, 
	0xEC9D, 0xEC94, 0xEC8B, 0xEC82, 0xEC79, 0xEC70, 0xEC67, 0xEC5E, 0xEC55, 
	0xEC4C, 0xEC43, 0xEC3B, 0xEC33, 0xEC2B, 0xEC23, 0xEC1B, 0xEC14, 0xEC0E, 
	0xEC08, 0xEC02, 0xEBFD, 0xEBF8, 0xEBF4, 0xEBF1, 0xEBEE, 0xEBEC, 0xEBEB, 
	0xF53E, 0xF53E, 0xF53F, 0xF541, 0xF546, 0xF55D, 0xF582, 0xF5B4, 0xF5F2, 
	0xF63B, 0xF68F, 0xF6EB, 0xF750, 0xF7BC, 0xF82E, 0xF8A5, 0xF920, 0xF99E, 
	0xFA1F, 0xFAA1, 0xFB23, 0xFBA4, 0xFC23, 0xFC9F, 0xFD18, 0xFD8C, 0xFDFA, 
	0xFE61, 0xFECA, 0xFF3D, 0xFFB8, 0x003A, 0x00C0, 0x0149, 0x01D4, 0x025E, 
	0x02E7, 0x036B, 0x03EB, 0x0463, 0x04D2, 0x0537, 0x0590, 0x05DB, 0x0616, 
	0x0640, 0x0657, 0x0659, 0x0645, 0x061B, 0x05DC, 0x058B, 0x052A, 0x04BB, 
	0x043F, 0x03B9, 0x032B, 0x0295, 0x01FC, 0x0160, 0x00C3, 0x0027, 0xFF8F, 
	0xFEFC, 0xFE70, 0xFDED, 0xFD75, 0xFD0B, 0xFCA5, 0xFC3C, 0xFBD0, 0xFB62, 
	0xFAF3, 0xFA83, 0xFA13, 0xF9A3, 0xF935, 0xF8C9, 0xF85F, 0xF7FA, 0xF798, 
	0xF73B, 0xF6E4, 0xF692, 0xF648, 0xF606, 0xF5CC, 0xF59A, 0xF572, 0xF555, 
	0xF544, 0xF53E, 0x0253, 0x0253, 0x0253, 0x0253, 0x0252, 0x024D, 0x0245, 
	0x023A, 0x022D, 0x021E, 0x020C, 0x01F8, 0x01E3, 0x01CC, 0x01B4, 0x019A, 
	0x0180, 0x0165, 0x014A, 0x012E, 0x0112, 0x00F7, 0x00DB, 0x00C1, 0x00A7, 
	0x008E, 0x0076, 0x0060, 0x0049, 0x0030, 0x0015, 0xFFF8, 0xFFDB, 0xFFBC, 
	0xFF9E, 0xFF7F, 0xFF61, 0xFF43, 0xFF27, 0xFF0C, 0xFEF3, 0xFEDD, 0xFEC9, 
	0xFEB8, 0xFEAB, 0xFEA2, 0xFE9D, 0xFE9C, 0xFEA1, 0xFEAA, 0xFEB8, 0xFECA, 
	0xFEDF, 0xFEF8, 0xFF14, 0xFF31, 0xFF51, 0xFF72, 0xFF94, 0xFFB7, 0xFFDA, 
	0xFFFC, 0x001E, 0x003E, 0x005D, 0x007A, 0x0094, 0x00AB, 0x00C1, 0x00D8, 
	0x00EF, 0x0106, 0x011E, 0x0136, 0x014E, 0x0166, 0x017D, 0x0194, 0x01AA, 
	0x01C0, 0x01D5, 0x01E8, 0x01FB, 0x020C, 0x021B, 0x0229, 0x0236, 0x0240, 
	0x0248, 0x024E, 0x0252, 0x0253, 0xD9D8, 0x0001, 0xFFFE, 0xC170, 0x10D1, 
	0x1087, 0x0FC7, 0x0EC1, 0x0DA3, 0x0C9D, 0x0BDD, 0x0B93, 0x0BB4, 0x0BDC, 
	0x0C09, 0x0C3C, 0x0C73, 0x0CAF, 0x0CEE, 0x0D30, 0x0D76, 0x0DBD, 0x0E07, 
	0x0E51, 0x0E9D, 0x0EE9, 0x0F35, 0x0F81, 0x0FCB, 0x1014, 0x105B, 0x10A0, 
	0x10E9, 0x113D, 0x119A, 0x11FF, 0x126A, 0x12D8, 0x134A, 0x13BB, 0x142C, 
	0x149B, 0x1504, 0x1568, 0x15C4, 0x1616, 0x165D, 0x1697, 0x16C3, 0x16DE, 
	0x16E7, 0x16DC, 0x16C3, 0x16A4, 0x167E, 0x1651, 0x161F, 0x15E8, 0x15AB, 
	0x1569, 0x1523, 0x14D9, 0x148C, 0x143B, 0x13E6, 0x1390, 0x1337, 0x12DB, 
	0x127F, 0x1221, 0x11C2, 0x1163, 0x1103, 0x10A3, 0x1044, 0x0FE6, 0x0F89, 
	0x0F2D, 0x0ED4, 0x0E7C, 0x0E28, 0x0DD6, 0x0D87, 0x0D3C, 0x0D4E, 0x0D80, 
	0x0DCB, 0x0E2A, 0x0E95, 0x0F07, 0x0F78, 0x0FE3, 0x1042, 0x108D, 0x10BF, 
	0x10D1, 0xD820, 0xD710, 0xD452, 0xD092, 0xCC7C, 0xC8BC, 0xC5FD, 0xC4ED, 
	0xC50B, 0xC564, 0xC5F2, 0xC6B2, 0xC79F, 0xC8B5, 0xC9F1, 0xCB4E, 0xCCC8, 
	0xCE5B, 0xD002, 0xD1BA, 0xD37F, 0xD54B, 0xD71C, 0xD8ED, 0xDAB9, 0xDC7E, 
	0xDE36, 0xDFDD, 0xE170, 0xE2EA, 0xE447, 0xE583, 0xE699, 0xE786, 0xE846, 
	0xE8D4, 0xE92C, 0xE94B, 0xE946, 0xE939, 0xE924, 0xE906, 0xE8E1, 0xE8B4, 
	0xE880, 0xE846, 0xE805, 0xE7BE, 0xE772, 0xE720, 0xE6C9, 0xE66E, 0xE60E, 
	0xE5AA, 0xE542, 0xE4D7, 0xE469, 0xE3F9, 0xE386, 0xE311, 0xE29A, 0xE222, 
	0xE1A9, 0xE130, 0xE0B6, 0xE03B, 0xDFC2, 0xDF49, 0xDED1, 0xDE5A, 0xDDE5, 
	0xDD72, 0xDD02, 0xDC94, 0xDC29, 0xDBC1, 0xDB5D, 0xDAFD, 0xDAA2, 0xDA4B, 
	0xD9F9, 0xD9AD, 0xD966, 0xD925, 0xD8EB, 0xD8B7, 0xD88A, 0xD865, 0xD847, 
	0xD832, 0xD825, 0xD820, 0x93B9, 0x9412, 0x94F9, 0x9635, 0x978E, 0x98CA, 
	0x99B1, 0x9A0A, 0x9968, 0x98AA, 0x97D4, 0x96E8, 0x95E9, 0x94DB, 0x93C1, 
	0x929D, 0x9173, 0x9045, 0x8F17, 0x8DEC, 0x8CC7, 0x8BAB, 0x8A9B, 0x8999, 
	0x88AA, 0x87D0, 0x870E, 0x8667, 0x85D0, 0x853B, 0x84AA, 0x841D, 0x8397, 
	0x8317, 0x829F, 0x822F, 0x81CA, 0x816F, 0x8120, 0x80DD, 0x80A9, 0x8083, 
	0x806E, 0x8069, 0x8075, 0x8095, 0x80C9, 0x8112, 0x816C, 0x81D2, 0x8244, 
	0x82C1, 0x8349, 0x83DB, 0x8475, 0x8519, 0x85C3, 0x8675, 0x872D, 0x87EB, 
	0x88AE, 0x8975, 0x8A3F, 0x8B0D, 0x8BDC, 0x8CAE, 0x8D80, 0x8E52, 0x8F24, 
	0x8FF4, 0x90C3, 0x918F, 0x9257, 0x931C, 0x93DC, 0x9497, 0x954C, 0x95FA, 
	0x96A1, 0x9740, 0x972F, 0x96FD, 0x96B3, 0x9656, 0x95EC, 0x957D, 0x950D, 
	0x94A3, 0x9446, 0x93FC, 0x93CB, 0x93B9, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xCD91, 0xCD91, 
	0xCD90, 0xCD8D, 0xCD88, 0xCD6F, 0xCD49, 0xCD1B, 0xCCE9, 0xCCB4, 0xCC82, 
	0xCC55, 0xCC32, 0xCC1B, 0xCC15, 0xCC23, 0xCC3D, 0xCC59, 0xCC7A, 0xCCA2, 
	0xCCD4, 0xCD11, 0xCD5B, 0xCDB6, 0xCE23, 0xCEA5, 0xCF3E, 0xCFF0, 0xD0C3, 
	0xD1B8, 0xD2CB, 0xD3F8, 0xD538, 0xD687, 0xD7E1, 0xD93F, 0xDA9D, 0xDBF6, 
	0xDD45, 0xDE85, 0xDFB1, 0xE0C4, 0xE1B9, 0xE28B, 0xE335, 0xE3B1, 0xE3FC, 
	0xE410, 0xE3FE, 0xE3DC, 0xE3AA, 0xE36A, 0xE31C, 0xE2C1, 0xE25A, 0xE1E7, 
	0xE16A, 0xE0E2, 0xE051, 0xDFB8, 0xDF18, 0xDE70, 0xDDC2, 0xDD10, 0xDC58, 
	0xDB9D, 0xDADF, 0xDA1F, 0xD95E, 0xD89C, 0xD7DA, 0xD71A, 0xD65B, 0xD59E, 
	0xD4E5, 0xD430, 0xD380, 0xD2D6, 0xD232, 0xD196, 0xD101, 0xD075, 0xCFF3, 
	0xCF7B, 0xCF0F, 0xCEAE, 0xCE5A, 0xCE14, 0xCDDC, 0xCDB2, 0xCD99, 0xCD91, 
	0x18A4, 0x18A4, 0x18A3, 0x189F, 0x1899, 0x187C, 0x184F, 0x1816, 0x17D4, 
	0x178B, 0x1740, 0x16F5, 0x16AE, 0x166E, 0x1637, 0x160D, 0x15EC, 0x15CC, 
	0x15AE, 0x1592, 0x157B, 0x1567, 0x1559, 0x1550, 0x154E, 0x1552, 0x155F, 
	0x1574, 0x1592, 0x15B7, 0x15E3, 0x1615, 0x164C, 0x1687, 0x16C5, 0x1705, 
	0x1746, 0x1787, 0x17C7, 0x1805, 0x1841, 0x1878, 0x18AB, 0x18D8, 0x18EC, 
	0x18E1, 0x18CB, 0x18BF, 0x18BE, 0x18BC, 0x18BB, 0x18BA, 0x18B9, 0x18B8, 
	0x18B7, 0x18B6, 0x18B5, 0x18B4, 0x18B4, 0x18B3, 0x18B2, 0x18B1, 0x18B0, 
	0x18AF, 0x18AF, 0x18AE, 0x18AD, 0x18AC, 0x18AC, 0x18AB, 0x18AA, 0x18AA, 
	0x18A9, 0x18A9, 0x18A8, 0x18A8, 0x18A7, 0x18A7, 0x18A6, 0x18A6, 0x18A6, 
	0x18A5, 0x18A5, 0x18A5, 0x18A4, 0xFA04, 0xFA04, 0xFA08, 0xFA10, 0xFA20, 
	0xFA6B, 0xFADE, 0xFB6D, 0xFC10, 0xFCBD, 0xFD6A, 0xFE0D, 0xFE9D, 0xFF10, 
	0xFF5C, 0xFF78, 0xFF65, 0xFF2D, 0xFED6, 0xFE67, 0xFDE4, 0xFD54, 0xFCBC, 
	0xFC21, 0xFB8B, 0xFAFD, 0xFA7E, 0xFA14, 0xF9B3, 0xF94E, 0xF8E7, 0xF87D, 
	0xF814, 0xF7AC, 0xF748, 0xF6E7, 0xF68D, 0xF63A, 0xF5EF, 0xF5AF, 0xF57A, 
	0xF553, 0xF53A, 0xF532, 0xF5EF, 0xF794, 0xF93F, 0xFA10, 0xFA29, 0xFA3F, 
	0xFA53, 0xFA65, 0xFA75, 0xFA83, 0xFA8F, 0xFA99, 0xFAA1, 0xFAA8, 0xFAAD, 
	0xFAB1, 0xFAB4, 0xFAB5, 0xFAB4, 0xFAB3, 0xFAB1, 0xFAAD, 0xFAA9, 0xFAA4, 
	0xFA9E, 0xFA98, 0xFA90, 0xFA89, 0xFA81, 0xFA78, 0xFA70, 0xFA67, 0xFA5E, 
	0xFA55, 0xFA4C, 0xFA44, 0xFA3B, 0xFA33, 0xFA2B, 0xFA24, 0xFA1D, 0xFA17, 
	0xFA11, 0xFA0D, 0xFA09, 0xFA06, 0xFA05, 0xFA04, 0xE39A, 0xE39B, 0xE3A1, 
	0xE3B2, 0xE3D3, 0xE46F, 0xE55A, 0xE681, 0xE7D0, 0xE931, 0xEA91, 0xEBDD, 
	0xECFE, 0xEDE3, 0xEE76, 0xEEA3, 0xEE66, 0xEDD3, 0xECF7, 0xEBE4, 0xEAA7, 
	0xE950, 0xE7EE, 0xE690, 0xE545, 0xE41E, 0xE328, 0xE273, 0xE1EB, 0xE171, 
	0xE104, 0xE0A3, 0xE04E, 0xE004, 0xDFC5, 0xDF90, 0xDF64, 0xDF40, 0xDF24, 
	0xDF10, 0xDF02, 0xDEFA, 0xDEF7, 0xDEF8, 0xDF8D, 0xE0D0, 0xE219, 0xE2BD, 
	0xE2D5, 0xE2EB, 0xE300, 0xE314, 0xE326, 0xE337, 0xE346, 0xE354, 0xE362, 
	0xE36E, 0xE378, 0xE382, 0xE38B, 0xE393, 0xE399, 0xE39F, 0xE3A5, 0xE3A9, 
	0xE3AD, 0xE3AF, 0xE3B2, 0xE3B3, 0xE3B4, 0xE3B5, 0xE3B5, 0xE3B5, 0xE3B4, 
	0xE3B3, 0xE3B2, 0xE3B0, 0xE3AE, 0xE3AD, 0xE3AB, 0xE3A8, 0xE3A6, 0xE3A4, 
	0xE3A2, 0xE3A0, 0xE39F, 0xE39D, 0xE39C, 0xE39B, 0xE39A, 0x0001, 0xFFFE, 
	0xC170, 0xEFE2, 0xEFE2, 0xEFE3, 0xEFE5, 0xEFE8, 0xEFF9, 0xF015, 0xF03B, 
	0xF06C, 0xF0A5, 0xF0E7, 0xF131, 0xF183, 0xF1DC, 0xF23B, 0xF2A0, 0xF30B, 
	0xF37A, 0xF3EE, 0xF465, 0xF4E0, 0xF55D, 0xF5DC, 0xF65D, 0xF6DF, 0xF761, 
	0xF7E4, 0xF865, 0xF8E6, 0xF965, 0xF9E1, 0xFA5B, 0xFAD1, 0xFB43, 0xFBB1, 
	0xFC1A, 0xFC7E, 0xFCDB, 0xFD32, 0xFD81, 0xFDC9, 0xFE09, 0xFE3F, 0xFE6D, 
	0xFE90, 0xFEA9, 0xFEB7, 0xFEB9, 0xFE9D, 0xFE52, 0xFDDD, 0xFD44, 0xFC8A, 
	0xFBB5, 0xFAC8, 0xF9CA, 0xF8BD, 0xF7A8, 0xF68F, 0xF577, 0xF464, 0xF35A, 
	0xF260, 0xF178, 0xF0A9, 0xEFF6, 0xEF65, 0xEEFA, 0xEEAC, 0xEE6E, 0xEE3E, 
	0xEE1C, 0xEE06, 0xEDFB, 0xEDFB, 0xEE03, 0xEE14, 0xEE2C, 0xEE49, 0xEE6B, 
	0xEE91, 0xEEB9, 0xEEE2, 0xEF0C, 0xEF35, 0xEF5C, 0xEF81, 0xEFA1, 0xEFBB, 
	0xEFD0, 0xEFDD, 0xEFE2, 0x11CD, 0x11DF, 0x1213, 0x1268, 0x12DD, 0x136F, 
	0x141E, 0x14E7, 0x15C8, 0x16C1, 0x17D0, 0x18F3, 0x1A28, 0x1B6F, 0x1CC4, 
	0x1E27, 0x1F96, 0x2110, 0x2292, 0x241C, 0x25AB, 0x273E, 0x28D4, 0x2A6B, 
	0x2C00, 0x2D94, 0x2F23, 0x30AC, 0x322F, 0x33A8, 0x3518, 0x367B, 0x37D0, 
	0x3916, 0x3A4C, 0x3B6E, 0x3C7D, 0x3D76, 0x3E58, 0x3F21, 0x3FCF, 0x4062, 
	0x40D6, 0x412C, 0x4160, 0x4172, 0x4161, 0x412F, 0x40DD, 0x406D, 0x3FE1, 
	0x3F39, 0x3E78, 0x3D9F, 0x3CB0, 0x3BAB, 0x3A93, 0x3969, 0x382E, 0x36E4, 
	0x358D, 0x3429, 0x32BC, 0x3145, 0x2FC6, 0x2E42, 0x2CB9, 0x2B2D, 0x299F, 
	0x2812, 0x2686, 0x24FD, 0x2378, 0x21FA, 0x2083, 0x1F15, 0x1DB2, 0x1C5B, 
	0x1B11, 0x19D6, 0x18AC, 0x1794, 0x168F, 0x159F, 0x14C6, 0x1405, 0x135E, 
	0x12D2, 0x1262, 0x1210, 0x11DE, 0x11CD, 0x7D14, 0x7D14, 0x7D16, 0x7D1A, 
	0x7D24, 0x7D51, 0x7D9A, 0x7DFE, 0x7E7B, 0x7F11, 0x7FBD, 0x8080, 0x8155, 
	0x823D, 0x8335, 0x843E, 0x8554, 0x8677, 0x87A6, 0x88DF, 0x8A20, 0x8B69, 
	0x8CB8, 0x8E0A, 0x8F60, 0x90B8, 0x9210, 0x9367, 0x94BB, 0x960B, 0x9756, 
	0x989A, 0x99D6, 0x9B08, 0x9C30, 0x9D4B, 0x9E58, 0x9F56, 0xA044, 0xA120, 
	0xA1E8, 0xA29B, 0xA339, 0xA3BF, 0xA42C, 0xA47E, 0xA4B5, 0xA4CF, 0xA49E, 
	0xA400, 0xA2FD, 0xA1A3, 0x9FFA, 0x9E0F, 0x9BEC, 0x999D, 0x972B, 0x94A2, 
	0x920D, 0x8F77, 0x8CEB, 0x8A74, 0x881C, 0x85EF, 0x83F7, 0x823F, 0x80D3, 
	0x7FBB, 0x7EE4, 0x7E29, 0x7D8B, 0x7D07, 0x7C9B, 0x7C45, 0x7C04, 0x7BD6, 
	0x7BB8, 0x7BAA, 0x7BA8, 0x7BB3, 0x7BC6, 0x7BE2, 0x7C04, 0x7C2A, 0x7C52, 
	0x7C7A, 0x7CA2, 0x7CC6, 0x7CE6, 0x7CFE, 0x7D0F, 0x7D14, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xE1F0, 0xE1F0, 0xE1EF, 0xE1EC, 0xE1E6, 0xE1C9, 0xE199, 
	0xE158, 0xE106, 0xE0A4, 0xE034, 0xDFB5, 0xDF29, 0xDE90, 0xDDEB, 0xDD3C, 
	0xDC83, 0xDBC0, 0xDAF6, 0xDA24, 0xD94B, 0xD86C, 0xD789, 0xD6A2, 0xD5B7, 
	0xD4CA, 0xD3DB, 0xD2EC, 0xD1FD, 0xD10E, 0xD022, 0xCF38, 0xCE52, 0xCD70, 
	0xCC93, 0xCBBC, 0xCAED, 0xCA24, 0xC965, 0xC8AF, 0xC803, 0xC762, 0xC6CD, 
	0xC645, 0xC5CB, 0xC55F, 0xC502, 0xC4B5, 0xC486, 0xC47F, 0xC49E, 0xC4DE, 
	0xC53D, 0xC5B7, 0xC64A, 0xC6F3, 0xC7AE, 0xC877, 0xC94D, 0xCA2B, 0xCB0F, 
	0xCBF6, 0xCCDC, 0xCDBE, 0xCE99, 0xCF6A, 0xD02D, 0xD0E1, 0xD193, 0xD254, 
	0xD323, 0xD3FD, 0xD4DF, 0xD5C9, 0xD6B8, 0xD7AA, 0xD89C, 0xD98E, 0xDA7D, 
	0xDB66, 0xDC49, 0xDD22, 0xDDF1, 0xDEB2, 0xDF64, 0xE005, 0xE092, 0xE10B, 
	0xE16C, 0xE1B4, 0xE1E0, 0xE1F0, 0xED56, 0xED56, 0xED56, 0xED56, 0xED56, 
	0xED56, 0xED55, 0xED55, 0xED54, 0xED53, 0xED52, 0xED51, 0xED4F, 0xED4E, 
	0xED4C, 0xED49, 0xED47, 0xED44, 0xED41, 0xED3D, 0xED39, 0xED35, 0xED31, 
	0xED2C, 0xED27, 0xED21, 0xED1B, 0xED15, 0xED0E, 0xED06, 0xECFF, 0xECF6, 
	0xECEE, 0xECE4, 0xECDB, 0xECD0, 0xECC6, 0xECBA, 0xECAF, 0xECA2, 0xEC95, 
	0xEC87, 0xEC79, 0xEC6A, 0xEC5B, 0xEC4B, 0xEC3A, 0xEC29, 0xEC0F, 0xEBE9, 
	0xEBB6, 0xEB7B, 0xEB39, 0xEAF3, 0xEAAA, 0xEA62, 0xEA1D, 0xE9DD, 0xE9A4, 
	0xE975, 0xE94C, 0xE926, 0xE905, 0xE8EA, 0xE8D8, 0xE8D1, 0xE8D5, 0xE8E7, 
	0xE905, 0xE92D, 0xE95C, 0xE992, 0xE9CD, 0xEA0B, 0xEA4B, 0xEA8B, 0xEACA, 
	0xEB06, 0xEB3E, 0xEB71, 0xEBA2, 0xEBD6, 0xEC0C, 0xEC43, 0xEC78, 0xECAA, 
	0xECD9, 0xED02, 0xED25, 0xED3F, 0xED50, 0xED56, 0xFE52, 0xFE52, 0xFE52, 
	0xFE52, 0xFE52, 0xFE4F, 0xFE4B, 0xFE45, 0xFE3E, 0xFE35, 0xFE2B, 0xFE1F, 
	0xFE12, 0xFE04, 0xFDF4, 0xFDE2, 0xFDCF, 0xFDBB, 0xFDA6, 0xFD8F, 0xFD77, 
	0xFD5E, 0xFD43, 0xFD28, 0xFD0B, 0xFCED, 0xFCCE, 0xFCAD, 0xFC8C, 0xFC6A, 
	0xFC47, 0xFC22, 0xFBFD, 0xFBD7, 0xFBB0, 0xFB87, 0xFB5E, 0xFB35, 0xFB0A, 
	0xFADF, 0xFAB2, 0xFA85, 0xFA58, 0xFA29, 0xF9FA, 0xF9CB, 0xF99A, 0xF969, 
	0xF922, 0xF8B4, 0xF828, 0xF788, 0xF6DA, 0xF628, 0xF57B, 0xF4DC, 0xF451, 
	0xF3E6, 0xF3A1, 0xF38C, 0xF3C1, 0xF447, 0xF50C, 0xF5FB, 0xF701, 0xF80A, 
	0xF902, 0xF9D6, 0xFA99, 0xFB6A, 0xFC43, 0xFD1F, 0xFDFA, 0xFECE, 0xFF97, 
	0x004F, 0x00F1, 0x0179, 0x01E2, 0x0225, 0x023A, 0x021F, 0x01DD, 0x017D, 
	0x0107, 0x0084, 0xFFFD, 0xFF7B, 0xFF06, 0xFEA8, 0xFE69, 0xFE52, 0xEC69, 
	0xEC69, 0xEC69, 0xEC68, 0xEC66, 0xEC5A, 0xEC48, 0xEC2E, 0xEC0F, 0xEBE9, 
	0xEBBE, 0xEB8D, 0xEB58, 0xEB1E, 0xEAE0, 0xEA9E, 0xEA59, 0xEA11, 0xE9C6, 
	0xE978, 0xE929, 0xE8D8, 0xE887, 0xE834, 0xE7E1, 0xE78D, 0xE73B, 0xE6E8, 
	0xE697, 0xE647, 0xE5F9, 0xE5AD, 0xE564, 0xE51E, 0xE4DB, 0xE49B, 0xE460, 
	0xE429, 0xE3F6, 0xE3C9, 0xE3A2, 0xE380, 0xE364, 0xE34F, 0xE341, 0xE33B, 
	0xE33C, 0xE345, 0xE37C, 0xE3FE, 0xE4C0, 0xE5B6, 0xE6D5, 0xE810, 0xE95E, 
	0xEAB2, 0xEC01, 0xED3E, 0xEE60, 0xEF5A, 0xF04D, 0xF156, 0xF261, 0xF359, 
	0xF42A, 0xF4C1, 0xF50A, 0xF4EF, 0xF475, 0xF3B3, 0xF2B7, 0xF191, 0xF04E, 
	0xEEFB, 0xEDA8, 0xEC63, 0xEB39, 0xEA38, 0xE970, 0xE8ED, 0xE8B2, 0xE8B1, 
	0xE8DF, 0xE933, 0xE9A2, 0xEA23, 0xEAAB, 0xEB31, 0xEBAB, 0xEC0E, 0xEC51, 
	0xEC69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0xFFFF, 0xBF5E, 0xFCEE, 0xFCEE, 0xFCEE, 0xFCEE, 0xFCEC, 0xFCE7, 
	0xFCE0, 0xFCD6, 0xFCC9, 0xFCBA, 0xFCA8, 0xFC94, 0xFC7F, 0xFC67, 0xFC4E, 
	0xFC33, 0xFC17, 0xFBF9, 0xFBDA, 0xFBBA, 0xFB9A, 0xFB78, 0xFB56, 0xFB34, 
	0xFB11, 0xFAEF, 0xFACC, 0xFAA9, 0xFA87, 0xFA65, 0xFA43, 0xFA23, 0xFA03, 
	0xF9E4, 0xF9C7, 0xF9AA, 0xF98F, 0xF976, 0xF95E, 0xF949, 0xF935, 0xF924, 
	0xF914, 0xF907, 0xF8FD, 0xF8F6, 0xF8F1, 0xF8F0, 0xF8F1, 0xF8F6, 0xF8FD, 
	0xF907, 0xF914, 0xF924, 0xF935, 0xF949, 0xF95E, 0xF976, 0xF98F, 0xF9AA, 
	0xF9C7, 0xF9E4, 0xFA03, 0xFA23, 0xFA43, 0xFA65, 0xFA87, 0xFAA9, 0xFACC, 
	0xFAEF, 0xFB11, 0xFB34, 0xFB56, 0xFB78, 0xFB9A, 0xFBBA, 0xFBDA, 0xFBF9, 
	0xFC17, 0xFC33, 0xFC4E, 0xFC67, 0xFC7F, 0xFC94, 0xFCA8, 0xFCBA, 0xFCC9, 
	0xFCD6, 0xFCE0, 0xFCE7, 0xFCEC, 0xFCEE, 0xE6A8, 0xE6A8, 0xE6A8, 0xE6A8, 
	0xE6A8, 0xE6A9, 0xE6AB, 0xE6AC, 0xE6AF, 0xE6B1, 0xE6B4, 0xE6B8, 0xE6BC, 
	0xE6C0, 0xE6C5, 0xE6C9, 0xE6CE, 0xE6D4, 0xE6D9, 0xE6DF, 0xE6E5, 0xE6EA, 
	0xE6F0, 0xE6F7, 0xE6FD, 0xE703, 0xE709, 0xE70F, 0xE715, 0xE71B, 0xE721, 
	0xE727, 0xE72D, 0xE732, 0xE738, 0xE73D, 0xE741, 0xE746, 0xE74A, 0xE74E, 
	0xE751, 0xE755, 0xE757, 0xE75A, 0xE75B, 0xE75D, 0xE75D, 0xE75E, 0xE75D, 
	0xE75D, 0xE75B, 0xE75A, 0xE757, 0xE755, 0xE751, 0xE74E, 0xE74A, 0xE746, 
	0xE741, 0xE73D, 0xE738, 0xE732, 0xE72D, 0xE727, 0xE721, 0xE71B, 0xE715, 
	0xE70F, 0xE709, 0xE703, 0xE6FD, 0xE6F7, 0xE6F0, 0xE6EA, 0xE6E5, 0xE6DF, 
	0xE6D9, 0xE6D4, 0xE6CE, 0xE6C9, 0xE6C5, 0xE6C0, 0xE6BC, 0xE6B8, 0xE6B4, 
	0xE6B1, 0xE6AF, 0xE6AC, 0xE6AB, 0xE6A9, 0xE6A8, 0x8E9A, 0x8E9A, 0x8E9A, 
	0x8E9A, 0x8E9D, 0x8EA5, 0x8EB2, 0x8EC4, 0x8EDA, 0x8EF4, 0x8F13, 0x8F35, 
	0x8F5A, 0x8F83, 0x8FAF, 0x8FDE, 0x900F, 0x9042, 0x9078, 0x90AF, 0x90E8, 
	0x9121, 0x915C, 0x9198, 0x91D4, 0x9211, 0x924D, 0x9289, 0x92C5, 0x9300, 
	0x9339, 0x9372, 0x93A9, 0x93DF, 0x9412, 0x9443, 0x9472, 0x949E, 0x94C7, 
	0x94EC, 0x950E, 0x952D, 0x9547, 0x955D, 0x956F, 0x957C, 0x9584, 0x9587, 
	0x9584, 0x957C, 0x956F, 0x955D, 0x9547, 0x952D, 0x950E, 0x94EC, 0x94C7, 
	0x949E, 0x9472, 0x9443, 0x9412, 0x93DF, 0x93A9, 0x9372, 0x9339, 0x9300, 
	0x92C5, 0x9289, 0x924D, 0x9211, 0x91D4, 0x9198, 0x915C, 0x9121, 0x90E8, 
	0x90AF, 0x9078, 0x9042, 0x900F, 0x8FDE, 0x8FAF, 0x8F83, 0x8F5A, 0x8F35, 
	0x8F13, 0x8EF4, 0x8EDA, 0x8EC4, 0x8EB2, 0x8EA5, 0x8E9D, 0x8E9A, 0x0000, 
	0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 0xFFFF, 
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 
	0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
	0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
	0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0xFFFF, 0x0000, 0x0000, 
	0xFFFF, 0x0000, 0x4FFE, 0x4FFE, 0x4FFE, 0x4FFE, 0x4FFC, 0x4FF6, 0x4FEC, 
	0x4FDF, 0x4FCE, 0x4FB9, 0x4FA2, 0x4F88, 0x4F6B, 0x4F4C, 0x4F2A, 0x4F07, 
	0x4EE1, 0x4EBA, 0x4E91, 0x4E67, 0x4E3B, 0x4E0F, 0x4DE2, 0x4DB4, 0x4D86, 
	0x4D58, 0x4D2A, 0x4CFC, 0x4CCE, 0x4CA1, 0x4C75, 0x4C4A, 0x4C20, 0x4BF7, 
	0x4BCF, 0x4BAA, 0x4B86, 0x4B65, 0x4B45, 0x4B28, 0x4B0E, 0x4AF7, 0x4AE3, 
	0x4AD2, 0x4AC4, 0x4ABA, 0x4AB4, 0x4AB2, 0x4AB4, 0x4ABA, 0x4AC4, 0x4AD2, 
	0x4AE3, 0x4AF7, 0x4B0E, 0x4B28, 0x4B45, 0x4B65, 0x4B86, 0x4BAA, 0x4BCF, 
	0x4BF7, 0x4C20, 0x4C4A, 0x4C75, 0x4CA1, 0x4CCE, 0x4CFC, 0x4D2A, 0x4D58, 
	0x4D86, 0x4DB4, 0x4DE2, 0x4E0F, 0x4E3B, 0x4E67, 0x4E91, 0x4EBA, 0x4EE1, 
	0x4F07, 0x4F2A, 0x4F4C, 0x4F6B, 0x4F88, 0x4FA2, 0x4FB9, 0x4FCE, 0x4FDF, 
	0x4FEC, 0x4FF6, 0x4FFC, 0x4FFE, 0xF768, 0xF768, 0xF768, 0xF768, 0xF770, 
	0xF784, 0xF7A4, 0xF7CF, 0xF803, 0xF83E, 0xF87F, 0xF8C4, 0xF90C, 0xF956, 
	0xF9A0, 0xF9E8, 0xFA2E, 0xFA6F, 0xFAAA, 0xFADD, 0xFB08, 0xFB28, 0xFB3D, 
	0xFB44, 0xFB40, 0xFB33, 0xFB1E, 0xFB03, 0xFAE1, 0xFABA, 0xFA8E, 0xFA5E, 
	0xFA2A, 0xF9F4, 0xF9BC, 0xF982, 0xF948, 0xF90D, 0xF8D4, 0xF89C, 0xF867, 
	0xF834, 0xF805, 0xF7DA, 0xF7B4, 0xF794, 0xF77B, 0xF768, 0xF75B, 0xF74E, 
	0xF743, 0xF738, 0xF72F, 0xF727, 0xF721, 0xF71B, 0xF716, 0xF712, 0xF70F, 
	0xF70C, 0xF70B, 0xF70A, 0xF70A, 0xF70A, 0xF70B, 0xF70D, 0xF70F, 0xF712, 
	0xF715, 0xF719, 0xF71C, 0xF720, 0xF725, 0xF729, 0xF72E, 0xF733, 0xF738, 
	0xF73C, 0xF741, 0xF746, 0xF74A, 0xF74F, 0xF753, 0xF757, 0xF75B, 0xF75E, 
	0xF761, 0xF764, 0xF766, 0xF767, 0xF768, 0xF7BA, 0xF7BA, 0xF7BA, 0xF7BA, 
	0xF7B4, 0xF7A2, 0xF786, 0xF761, 0xF734, 0xF701, 0xF6C9, 0xF68C, 0xF64E, 
	0xF60D, 0xF5CD, 0xF58E, 0xF552, 0xF51A, 0xF4E6, 0xF4BA, 0xF495, 0xF478, 
	0xF467, 0xF460, 0xF464, 0xF46F, 0xF481, 0xF499, 0xF4B6, 0xF4D8, 0xF4FF, 
	0xF528, 0xF555, 0xF584, 0xF5B5, 0xF5E8, 0xF61A, 0xF64D, 0xF67F, 0xF6AF, 
	0xF6DE, 0xF70A, 0xF733, 0xF758, 0xF779, 0xF794, 0xF7AB, 0xF7BA, 0xF7C6, 
	0xF7D1, 0xF7DB, 0xF7E4, 0xF7EC, 0xF7F3, 0xF7F9, 0xF7FE, 0xF802, 0xF806, 
	0xF809, 0xF80B, 0xF80C, 0xF80D, 0xF80D, 0xF80C, 0xF80B, 0xF80A, 0xF808, 
	0xF806, 0xF803, 0xF800, 0xF7FD, 0xF7F9, 0xF7F5, 0xF7F1, 0xF7ED, 0xF7E9, 
	0xF7E5, 0xF7E1, 0xF7DD, 0xF7D8, 0xF7D4, 0xF7D1, 0xF7CD, 0xF7C9, 0xF7C6, 
	0xF7C3, 0xF7C1, 0xF7BF, 0xF7BD, 0xF7BC, 0xF7BB, 0xF7BA, 0xD552, 0xD552, 
	0xD552, 0xD552, 0x