-- name: [CS] Cool Dragon
-- description: An adventurous dragon set on seeing all a world has to offer!\n\n\\#ff7777\\This Pack requires Character Select\nto use as a Library!

--[[
    API Documentation for Character Select can be found below:
    https://github.com/Squishy6094/character-select-coop/wiki/API-Documentation

    Use this if you're curious on how anything here works >v<
]]

-- Replace Mod Name with your Character/Pack name.
local TEXT_MOD_NAME = "Cool Dragon"
local TEXT_MOD_VERSION = "2.0"

-- Stops mod from loading if Character Select isn't on, Does not need to be touched
if not _G.charSelectExists then
    djui_popup_create(
        "\\#ffffdc\\\n" ..
        TEXT_MOD_NAME ..
        "\nRequires the Character Select Mod\nto use as a Library!\n\nPlease turn on the Character Select Mod\nand Restart the Room!",
        6)
    return 0
end

--[[
    Everything from here down is character data, and is loaded at the end of the file

    Note that most things here are noted out via use of '--', if there is any
    functionality you'd want to use then remove the '--' in front of the functions.

    If needbe, Replace CHAR in the tables with your character's name
    Ex: E_MODEL_CHAR -> E_MODEL_SQUISHY

    Ensure all file naming is unique from other mods.
    Prefixing your files with your character's name should work fine
    Ex: life-icon.png -> squis
]]


local E_MODEL_CDRAGON = smlua_model_util_get_id("cdragon_geo") -- Located in "actors"
local E_MODEL_HPITCH = smlua_model_util_get_id("hpitch_geo")
local E_MODEL_CPIE = smlua_model_util_get_id("cpie_geo")

local TEX_CDRAGON_LIFE_ICON = get_texture_info("cdragon-icon") -- Located in "textures"

-- CS Menu Graffiti
local TEX_CDRAGON_CS_MENU_GRAFFITI = get_texture_info("cdragon_menu_graffiti2") -- Located in "textures"

-- All sound files are located in "sound" folder
-- Remember to include the file extention in the name
-- Any sound files that are missing will cause script errors starting in CS 1.16
-- Any entries that fail to load will default to Mario (or default base character sound)
-- Comment out or delete entries that you want to be silent
-- The following VOICE_TABLE_SILENT has no entries which means no mario sounds or anything.
-- It may be used as a placeholder or if you don't have any planned sounds.
-- local VOICE_TABLE_SILENT = {}
--[[local VOICETABLE_CHAR = {
    [CHAR_SOUND_OKEY_DOKEY] = 'CharStartGame.ogg',                                     -- Starting game
    [CHAR_SOUND_LETS_A_GO] = 'CharStartLevel.ogg',                                     -- Starting level
    [CHAR_SOUND_GAME_OVER] = 'CharGameOver.ogg',                                       -- Game Overed
    [CHAR_SOUND_PUNCH_YAH] = 'CharPunch1.ogg',                                         -- Punch 1
    [CHAR_SOUND_PUNCH_WAH] = 'CharPunch2.ogg',                                         -- Punch 2
    [CHAR_SOUND_PUNCH_HOO] = 'CharPunch3.ogg',                                         -- Punch 3
    [CHAR_SOUND_YAH_WAH_HOO] = { 'CharJump1.ogg', 'CharJump2.ogg', 'CharJump3.ogg' },  -- First Jump Sounds
    [CHAR_SOUND_HOOHOO] = 'CharDoubleJump.ogg',                                        -- Second jump sound
    [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'CharTripleJump1.ogg', 'CharTripleJump2.ogg' }, -- Triple jump sounds
    [CHAR_SOUND_UH] = 'CharBonk.ogg',                                                  -- Soft wall bonk
    [CHAR_SOUND_UH2] = 'CharLedgeGetUp.ogg',                                           -- Quick ledge get up
    [CHAR_SOUND_UH2_2] = 'CharLongJumpLand.ogg',                                       -- Landing after long jump
    [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                 -- Hard wall bonk
    [CHAR_SOUND_OOOF] = 'CharBonk.ogg',                                                -- Attacked in air
    [CHAR_SOUND_OOOF2] = 'CharBonk.ogg',                                               -- Land from hard bonk
    [CHAR_SOUND_HAHA] = 'CharTripleJumpLand.ogg',                                      -- Landing triple jump
    [CHAR_SOUND_HAHA_2] = 'CharWaterLanding.ogg',                                      -- Landing in water from big fall
    [CHAR_SOUND_YAHOO] = 'CharLongJump.ogg',                                           -- Long jump
    [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                 -- Long jump wall bonk
    [CHAR_SOUND_WHOA] = 'CharGrabLedge.ogg',                                           -- Grabbing ledge
    [CHAR_SOUND_EEUH] = 'CharClimbLedge.ogg',                                          -- Climbing over ledge
    [CHAR_SOUND_WAAAOOOW] = 'CharFalling.ogg',                                         -- Falling a long distance
    [CHAR_SOUND_TWIRL_BOUNCE] = 'CharFlowerBounce.ogg',                                -- Bouncing off of a flower spring
    [CHAR_SOUND_GROUND_POUND_WAH] = 'CharGroundPound.ogg',                             -- Ground Pound after startup
    [CHAR_SOUND_WAH2] = 'CharThrow.ogg',                                               -- Throwing something
    [CHAR_SOUND_HRMM] = 'CharLift.ogg',                                                -- Lifting something
    [CHAR_SOUND_HERE_WE_GO] = 'CharGetStar.ogg',                                       -- Star get
    [CHAR_SOUND_SO_LONGA_BOWSER] = 'CharThrowBowser.ogg',                              -- Throwing Bowser
    --DAMAGE
    [CHAR_SOUND_ATTACKED] = 'CharDamaged.ogg',                                         -- Damaged
    [CHAR_SOUND_PANTING] = 'CharPanting.ogg',                                          -- Low health
    [CHAR_SOUND_PANTING_COLD] = 'CharPanting.ogg',                                     -- Getting cold
    [CHAR_SOUND_ON_FIRE] = 'CharBurned.ogg',                                           -- Burned
    --SLEEP SOUNDS
    [CHAR_SOUND_IMA_TIRED] = 'CharTired.ogg',                                          -- Mario feeling tired
    [CHAR_SOUND_YAWNING] = 'CharYawn.ogg',                                             -- Mario yawning before he sits down to sleep
    [CHAR_SOUND_SNORING1] = 'CharSnore.ogg',                                           -- Snore Inhale
    [CHAR_SOUND_SNORING2] = 'CharExhale.ogg',                                          -- Exhale
    [CHAR_SOUND_SNORING3] = 'CharSleepTalk.ogg',                                       -- Sleep talking / mumbling
    --COUGHING (USED IN THE GAS MAZE)
    [CHAR_SOUND_COUGHING1] = 'CharCough1.ogg',                                         -- Cough take 1
    [CHAR_SOUND_COUGHING2] = 'CharCough2.ogg',                                         -- Cough take 2
    [CHAR_SOUND_COUGHING3] = 'CharCough3.ogg',                                         -- Cough take 3
    --DEATH
    [CHAR_SOUND_DYING] = 'CharDying.ogg',                                              -- Dying from damage
    [CHAR_SOUND_DROWNING] = 'CharDrowning.ogg',                                        -- Running out of air underwater
    [CHAR_SOUND_MAMA_MIA] = 'CharLeaveLevel.ogg'                                       -- Booted out of level
}]]

-- All Located in "actors" folder
-- (Models do not exist in template)
--[[
local CAPTABLE_CHAR = {
    normal = smlua_model_util_get_id("FILENAME_geo"),
    wing = smlua_model_util_get_id("FILENAME_geo"),
    metal = smlua_model_util_get_id("FILENAME_geo"),
}
]]

--[[local PALETTE_CHAR = {
    [PANTS]  = "ffffff",
    [SHIRT]  = "ffffff",
    [GLOVES] = "ffffff",
    [SHOES]  = "ffffff",
    [HAIR]   = "ffffff",
    [SKIN]   = "ffffff",
    [CAP]    = "ffffff",
    [EMBLEM] = "ffffff"
}]]

-- All Located in "textures" folder
-- (Textures do not exist in template)
--[[
local HEALTH_METER_CHAR = {
    label = {
        left = get_texture_info("healthleft"),
        right = get_texture_info("healthright"),
    },
    pie = {
        [1] = get_texture_info("Pie1"),
        [2] = get_texture_info("Pie2"),
        [3] = get_texture_info("Pie3"),
        [4] = get_texture_info("Pie4"),
        [5] = get_texture_info("Pie5"),
        [6] = get_texture_info("Pie6"),
        [7] = get_texture_info("Pie7"),
        [8] = get_texture_info("Pie8"),
    }
}
]]

--[[
    Everything from here down where the data is applied

    Note that nothing here other than the 'character_add' function
    is required for a custom character, if you don't have the assets
    then feel free to remove the function from the functions below
]]

local CT_CDRAGON

local function on_character_select_load()
    -- Adds the custom character to the Character Select Menu
    CT_CDRAGON = _G.charSelect.character_add(
        "Cool Dragon",                                                                                              -- Character Name
        { "An adventurous dragon set on seeing all a world has to offer! A Commission for Cool_Treat" }, -- Description
        "Gamebun",                                                                                                  -- Credits
        "83dbb3",                                                                                                   -- Menu Color
        E_MODEL_CDRAGON,                                                                                            -- Character Model
        CT_MARIO,                                                                                                   -- Override Character
        TEX_CDRAGON_LIFE_ICON,                                                                                      -- Life Icon
        1                                                                                                           -- Camera Scale
    )

    -- Adds cap models to your character
    -- (Models do not exist in template)
    -- _G.charSelect.character_add_caps(E_MODEL_CHAR, CAPTABLE_CHAR)

    -- Adds a voice to your character
    -- (Sounds do not exist in template)
    -- (ModelID, Voice Table)
    --_G.charSelect.character_add_voice(E_MODEL_CHAR, VOICE_TABLE_SILENT)

    -- Adds a nickname to replace Mario's name in dialog
    _G.charSelect.character_set_nickname(CT_CDRAGON, "Cool Dragon")

    -- Adds a celebration star to your character
    -- (Models do not exist in template)
    --_G.charSelect.character_add_celebration_star(E_MODEL_CHAR, E_MODEL_CHAR_STAR, TEX_CHAR_STAR_ICON)

    -- Adds a palette to your character
    -- _G.charSelect.character_add_palette_preset(E_MODEL_CHAR, PALETTE_CHAR)

    -- Adds a health meter to your character
    -- (Textures do not exist in template)
    -- _G.charSelect.character_add_health_meter(CT_CHAR, HEALTH_METER_CHAR)

    -- Add Alt Costumes for the character
    -- The parts that are set to nil are things like desc, credits, etc that can be individual for each costume
    -- if set to nil, it defaults to the base character's fields.
    -- See https://github.com/Squishy6094/character-select-coop/wiki/API-Documentation#character_add_costume for docs
    _G.charSelect.character_add_costume(CT_CDRAGON, "High Pitch", nil, nil, nil, E_MODEL_HPITCH, CT_MARIO, nil, 1)
    _G.charSelect.character_add_costume(CT_CDRAGON, "Cutie Pie", nil, nil, nil, E_MODEL_CPIE, CT_MARIO, nil, 1)

    -- Adds CS Menu Graffiti to selected character
    _G.charSelect.character_add_graffiti(CT_CDRAGON, TEX_CDRAGON_CS_MENU_GRAFFITI)

    -- Add voices to the alt costumes
    -- (Alt ModelID, Voice Table)
    -- _G.charSelect.character_add_voice(E_MODEL_HPITCH, VOICE_TABLE_SILENT)
    -- _G.charSelect.character_add_voice(E_MODEL_CPIE, VOICE_TABLE_SILENT)

    -- Adds credits to the credits menu
    _G.charSelect.credit_add(TEXT_MOD_NAME .. " (" .. TEXT_MOD_VERSION .. ")", "Gamebun", "Creator")
end

-- Character Voice hooks
-- You will likely not need to care about these
-- Will soon be overhauled

_G.charSelect.config_character_sounds()

hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)