-- name: Teleport
-- description: Teleport to any player, even between courses.\nCreated by Sunk.

local function strip_colors(name)
    local string = ''
    local inSlash = false
    for i = 1, #name do
        local character = name:sub(i,i)
        if character == '\\' then
            inSlash = not inSlash
        elseif not inSlash then
            string = string .. character
        end
    end
    return string
end

---@param player string
---@return MarioState | nil
local function get_mario_state_from_name(player)
    for i = 0, MAX_PLAYERS - 1, 1 do
        if gNetworkPlayers[i].connected then
            if string.lower(strip_colors(gNetworkPlayers[i].name)) == string.lower(strip_colors(player)) then
                return gMarioStates[i]
            end
        end
    end
    return nil
end

local teleportDue = false
---@type MarioState
local targetMarioState
local timer = 1

function mario_update(m)
    if m.playerIndex ~= 0 then return end

    if teleportDue then
        if is_player_in_local_area(targetMarioState) == 0 then
            return
        end
        vec3f_copy(m.pos, targetMarioState.pos)
        timer = timer - 1
        if timer < 0 then
            teleportDue = false
            timer = 10
        end
    end
end

function teleport(msg)
    --If the target player is self, mention it and don't allow the teleport
    msg = strip_colors(msg)

    --Branches if a name or index is entered
    if tonumber(msg) == nil then
        --If a name is entered
        targetMarioState = get_mario_state_from_name(msg)
    else
        --If an index is entered
        targetMarioState = gMarioStates[tonumber(msg)]
    end

    ---@type NetworkPlayer
    local targetNP = gNetworkPlayers[targetMarioState.playerIndex]
    if (targetMarioState == nil) or (not targetNP.connected) then
        djui_chat_message_create("Enter a valid player")
        return true
    end

    if is_player_in_local_area(targetMarioState) ~= 0 then
        vec3f_copy(gMarioStates[0].pos, targetMarioState.pos)
    else
        warp_to_level(targetNP.currLevelNum, targetNP.currAreaIndex, targetNP.currActNum)
        teleportDue = true
    end

    return true
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_chat_command('tp', "Teleport to a specified player. Enter name or player index.", teleport)