-- Remove Fake Ledge Grab
function act_custom_ledge_grab(m)
    local intendedDYaw = m.intendedYaw - m.faceAngle.y
    local hasSpaceForMario = (m.ceilHeight - m.floorHeight >= 160)

    if (m.actionTimer < 10) then
        m.actionTimer = m.actionTimer + 1
    end

    if (m.input & (INPUT_Z_PRESSED | INPUT_OFF_FLOOR) ~= 0) then
        return let_go_of_ledge(m)
    end

    if ((m.input & INPUT_A_PRESSED) ~= 0 and hasSpaceForMario) then
        return set_mario_action(m, ACT_LEDGE_CLIMB_FAST, 0)
    end

    if (m.input & INPUT_UNKNOWN_10) ~= 0 then
        return let_go_of_ledge(m)
    end

    if (m.actionTimer == 10 and (m.input & INPUT_NONZERO_ANALOG) ~= 0) then
        if (intendedDYaw >= -0x4000 and intendedDYaw <= 0x4000) then
            if (hasSpaceForMario) then
                return set_mario_action(m, ACT_LEDGE_CLIMB_SLOW_1, 0)
            end
        else
            return let_go_of_ledge(m)
        end
    end

    local heightAboveFloor = m.pos.y - find_floor_height_relative_polar(m, -0x8000, 30)
    if (hasSpaceForMario and heightAboveFloor < 100) then
        return set_mario_action(m, ACT_LEDGE_CLIMB_FAST, 0)
    end

    if (m.actionArg == 0) then
        play_character_sound_if_no_flag(m, CHAR_SOUND_WHOA, MARIO_MARIO_SOUND_PLAYED)
    end

    stop_and_set_height_to_floor(m)
    set_character_animation(m, CHAR_ANIM_IDLE_ON_LEDGE)

    return 0
end

hook_mario_action(ACT_LEDGE_GRAB, act_custom_ledge_grab)

local prevFaceAngle = 0

-- Remove Steep Jumps
local function on_set_mario_action(m)
    if m.playerIndex ~= 0 then return end

    if m.action == ACT_STEEP_JUMP then
        m.faceAngle.y = prevFaceAngle
        if m.prevAction == ACT_JUMP_LAND or m.prevAction == ACT_FREEFALL_LAND or m.prevAction == ACT_SIDE_FLIP_LAND then
            set_mario_action(m, ACT_DOUBLE_JUMP, 0)
        elseif m.prevAction == ACT_LONG_JUMP_LAND then
            set_mario_action(m, ACT_LONG_JUMP, 0)
        elseif m.prevAction == ACT_START_CROUCHING or m.prevAction == ACT_CROUCHING then
            set_mario_action(m, ACT_BACKFLIP, 0)
        elseif m.prevAction == ACT_TURNING_AROUND or m.prevAction == ACT_FINISH_TURNING_AROUND then
            set_mario_action(m, ACT_SIDE_FLIP, 0)
        elseif m.prevAction == ACT_HOLD_JUMP_LAND or m.prevAction == ACT_HOLD_WALKING or m.prevAction == ACT_HOLD_FREEFALL_LAND then
            mario_grab_used_object(m)
            set_mario_action(m, ACT_HOLD_JUMP, 0)
        else
            set_mario_action(m, ACT_JUMP, 0)
        end
    end
end

local function mario_update(m)
    if m.playerIndex ~= 0 then return end

    if m.action ~= ACT_STEEP_JUMP then
        prevFaceAngle = m.faceAngle.y
    end
end

hook_event(HOOK_ON_SET_MARIO_ACTION, on_set_mario_action)
hook_event(HOOK_MARIO_UPDATE, mario_update)

-----------------------------
-- Faster hangable ceiling --
-----------------------------

-- Original Code by Sunk

---@param num number
---@return number
local function convert_s16(num)
    num = num & 0xFFFF
    return ((num >= 0x7FFF) and (num - 0x10000) or num)
end

---@param m MarioState
local function update_custom_hang_moving(m)
    local stepResult = 0
    local nextPos = {}
    local maxSpeed = 16

    m.forwardVel = m.forwardVel + 16
    if m.forwardVel > maxSpeed then
        m.forwardVel = maxSpeed
    end

    m.faceAngle.y = m.intendedYaw - approach_s32(convert_s16(m.intendedYaw - m.faceAngle.y), 0, 0x800, 0x800)

    m.slideYaw = m.faceAngle.y
    m.slideVelX = m.forwardVel * sins(m.faceAngle.y)
    m.slideVelZ = m.forwardVel * coss(m.faceAngle.y)

    m.vel.x = m.slideVelX
    m.vel.y = 0.0
    m.vel.z = m.slideVelZ

    nextPos.x = m.pos.x - m.ceil.normal.y * m.vel.x
    nextPos.z = m.pos.z - m.ceil.normal.y * m.vel.z
    nextPos.y = m.pos.y

    stepResult = perform_hanging_step(m, nextPos)

    vec3f_copy(m.marioObj.header.gfx.pos, m.pos)
    vec3s_set(m.marioObj.header.gfx.angle, 0, m.faceAngle.y, 0)
    return stepResult
end

---@param m MarioState
function act_custom_hang_moving(m)
    if m.input & INPUT_A_DOWN == 0 then
        return set_mario_action(m, ACT_FREEFALL, 0)
    end

    if m.input & INPUT_Z_PRESSED ~= 0 then
        return set_mario_action(m, ACT_GROUND_POUND, 0)
    end

    if m.ceil == nil or m.ceil.type ~= SURFACE_HANGABLE then
        return set_mario_action(m, ACT_FREEFALL, 0)
    end

    if m.actionArg & 1 ~= 0 then
        set_mario_animation(m, MARIO_ANIM_MOVE_ON_WIRE_NET_RIGHT)
    else
        set_mario_animation(m, MARIO_ANIM_MOVE_ON_WIRE_NET_LEFT)
    end

    if m.marioObj.header.gfx.animInfo.animFrame == 12 then
        play_sound(SOUND_ACTION_HANGING_STEP, m.marioObj.header.gfx.cameraToObject)
        queue_rumble_data_mario(m, 5, 30)
    end

    if is_anim_past_end(m) ~= 0 then
        m.actionArg = m.actionArg ~ 1
        if m.input & INPUT_ZERO_MOVEMENT ~= 0 then
            return set_mario_action(m, ACT_HANGING, m.actionArg)
        end
    end

    if update_custom_hang_moving(m) == 2 --[[HANG_LEFT_CEIL]] then
        set_mario_action(m, ACT_FREEFALL, 0)
    end

    return 0
end

hook_mario_action(ACT_HANG_MOVING, act_custom_hang_moving)
