--Simplified the amount of samples by calling only what was needed
local beta_mario_attacked = 'beta_mario_attacked.aiff'
local beta_mario_blank = 'beta_mario_blank.aiff'
local beta_mario_carry = 'beta_mario_carry.aiff'
local beta_mario_climb = 'beta_mario_climb.aiff'
local beta_mario_double_jump = 'beta_mario_double_jump.aiff'
local beta_mario_jump_hoo = 'beta_mario_jump_hoo.aiff'
local beta_mario_jump_wah = 'beta_mario_jump_wah.aiff'
local beta_mario_jump_yah = 'beta_mario_jump_yah.aiff'
local beta_mario_ledge = 'beta_mario_ledge.aiff'
local beta_mario_punch_hoo = 'beta_mario_punch_hoo.aiff'
local beta_mario_punch_wah = 'beta_mario_punch_wah.aiff'
local beta_mario_punch_yah = 'beta_mario_punch_yah.aiff'
local beta_mario_scream = 'beta_mario_scream.aiff'
local beta_mario_triple_jump = 'beta_mario_triple_jump.aiff'
local beta_mario_victory = 'beta_mario_victory.aiff'

--Define what triggers the custom voice
local function use_custom_voice(m)
    return m.character.type == CT_MARIO or m.character.type == CT_LUIGI or m.character.type == CT_WARIO or m.character.type == CT_WALUIGI or m.character.type == CT_TOAD
end

--How many snores the sleep-talk has, or rather, how long the sleep-talk lasts
--If you omit the sleep-talk you can ignore this
local SLEEP_TALK_SNORES = 8

--Define what actions play what voice clips
--If an action has more than one voice clip, put those clips inside a table
--CHAR_SOUND_SNORING3 requires two or three voice clips to work properly...
--but you can omit it if your character does not sleep-talk
local CUSTOM_VOICETABLE = {
    [CHAR_SOUND_ATTACKED] = beta_mario_attacked,
    [CHAR_SOUND_COUGHING1] = beta_mario_blank,
    [CHAR_SOUND_COUGHING2] = beta_mario_blank,
    [CHAR_SOUND_COUGHING3] = beta_mario_blank,
    [CHAR_SOUND_DOH] = beta_mario_double_jump,
    [CHAR_SOUND_DROWNING] = beta_mario_blank,
    [CHAR_SOUND_DYING] = beta_mario_blank,
    [CHAR_SOUND_EEUH] = beta_mario_climb,
    [CHAR_SOUND_GAME_OVER] = beta_mario_blank,
    [CHAR_SOUND_GROUND_POUND_WAH] = beta_mario_double_jump,
    [CHAR_SOUND_HAHA] = beta_mario_victory,
    [CHAR_SOUND_HAHA_2] = beta_mario_victory,
    [CHAR_SOUND_HELLO] = beta_mario_blank,
    [CHAR_SOUND_HERE_WE_GO] = beta_mario_victory,
    [CHAR_SOUND_HOOHOO] = beta_mario_double_jump,
    [CHAR_SOUND_HRMM] = beta_mario_carry,
    [CHAR_SOUND_IMA_TIRED] = beta_mario_blank,
    [CHAR_SOUND_LETS_A_GO] = beta_mario_blank,
    [CHAR_SOUND_MAMA_MIA] = beta_mario_blank,
    [CHAR_SOUND_OKEY_DOKEY] = beta_mario_blank,
    [CHAR_SOUND_ON_FIRE] = beta_mario_scream,
    [CHAR_SOUND_OOOF] = beta_mario_blank,
    [CHAR_SOUND_OOOF2] = beta_mario_blank,
    [CHAR_SOUND_PANTING] = {beta_mario_blank, beta_mario_blank, beta_mario_blank},
    [CHAR_SOUND_PANTING_COLD] = beta_mario_blank,
    [CHAR_SOUND_PRESS_START_TO_PLAY] = beta_mario_blank,
    [CHAR_SOUND_PUNCH_HOO] = beta_mario_punch_hoo,
    [CHAR_SOUND_PUNCH_WAH] = beta_mario_punch_wah,
    [CHAR_SOUND_PUNCH_YAH] = beta_mario_punch_yah,
    [CHAR_SOUND_SNORING1] = beta_mario_blank,
    [CHAR_SOUND_SNORING2] = beta_mario_blank,
    [CHAR_SOUND_SNORING3] = {beta_mario_blank, beta_mario_blank, beta_mario_blank},
    [CHAR_SOUND_SO_LONGA_BOWSER] = beta_mario_victory,
    [CHAR_SOUND_TWIRL_BOUNCE] = beta_mario_blank,
    [CHAR_SOUND_UH] = beta_mario_double_jump,
    [CHAR_SOUND_UH2] = beta_mario_climb,
    [CHAR_SOUND_UH2_2] = beta_mario_climb,
    [CHAR_SOUND_WAAAOOOW] = beta_mario_scream,
    [CHAR_SOUND_WAH2] = beta_mario_blank,
    [CHAR_SOUND_WHOA] = beta_mario_ledge,
    [CHAR_SOUND_YAHOO] = beta_mario_victory,
    [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = {beta_mario_triple_jump, beta_mario_triple_jump, beta_mario_triple_jump, beta_mario_triple_jump},
    [CHAR_SOUND_YAH_WAH_HOO] = {beta_mario_jump_yah, beta_mario_jump_wah, beta_mario_jump_hoo},
    [CHAR_SOUND_YAWNING] = beta_mario_blank,
}

--Define the table of samples that will be used for each player
--Global so if multiple mods use this they won't create unneeded samples
--DON'T MODIFY THIS SINCE IT'S GLOBAL FOR USE BY OTHER MODS!
gCustomVoiceSamples = {}
gCustomVoiceStream = nil

--Get the player's sample, stop whatever sound
--it's playing if it doesn't match the provided sound
--DON'T MODIFY THIS SINCE IT'S GLOBAL FOR USE BY OTHER MODS!
--- @param m MarioState
function stop_custom_character_sound(m, sound)
    local voice_sample = gCustomVoiceSamples[m.playerIndex]
    if voice_sample == nil or not voice_sample.loaded then
        return
    end

    audio_sample_stop(voice_sample)
    if voice_sample.file.relativePath:match('^.+/(.+)$') == sound then
        return voice_sample
    end
    audio_sample_destroy(voice_sample)
end

--Play a custom character's sound
--DON'T MODIFY THIS SINCE IT'S GLOBAL FOR USE BY OTHER MODS!
--- @param m MarioState
function play_custom_character_sound(m, voice)
    --Get sound, if it's a table, get a random entry from it
    local sound
    if type(voice) == "table" then
        sound = voice[math.random(#voice)]
    else
        sound = voice
    end
    if sound == nil then return 0 end

    --Get current sample and stop it
    local voice_sample = stop_custom_character_sound(m, sound)

    --If the new sound isn't a string, let's assume it's
    --a number to return to the character sound hook
    if type(sound) ~= "string" then
        return sound
    end

    --Load a new sample and play it! Don't make a new one if we don't need to
    if (m.area == nil or m.area.camera == nil) and m.playerIndex == 0 then
        if gCustomVoiceStream ~= nil then
            audio_stream_stop(gCustomVoiceStream)
            audio_stream_destroy(gCustomVoiceStream)
        end
        gCustomVoiceStream = audio_stream_load(sound)
        audio_stream_play(gCustomVoiceStream, true, 1)
    else
        if voice_sample == nil then
            voice_sample = audio_sample_load(sound)
        end
        if voice_sample == nil then
						return 0
				end
				
        if not voice_sample.loaded then
						return 0
				end
        audio_sample_play(voice_sample, m.pos, 1)

        gCustomVoiceSamples[m.playerIndex] = voice_sample
    end
    return 0
end

--Main character sound hook
--This hook is freely modifiable in case you want to make any specific exceptions
--- @param m MarioState
local function custom_character_sound(m, characterSound)
    if not use_custom_voice(m) then return end
    if characterSound == CHAR_SOUND_SNORING3 then return 0 end
    if characterSound == CHAR_SOUND_HAHA and m.hurtCounter > 0 then return 0 end

    local voice = CUSTOM_VOICETABLE[characterSound]
    if voice ~= nil then
        return play_custom_character_sound(m, voice)
    end
    return 0
end
hook_event(HOOK_CHARACTER_SOUND, custom_character_sound)

--Snoring logic for CHAR_SOUND_SNORING3 since we have to loop it manually
--This code won't activate on the Japanese version, due to MARIO_MARIO_SOUND_PLAYED not being set
local SNORE3_TABLE = CUSTOM_VOICETABLE[CHAR_SOUND_SNORING3]
local STARTING_SNORE = 46
local SLEEP_TALK_START = STARTING_SNORE + 49
local SLEEP_TALK_END = SLEEP_TALK_START + SLEEP_TALK_SNORES

--Main hook for snoring
--- @param m MarioState
local function custom_character_snore(m)
    if not use_custom_voice(m) then return end

    --Stop the snoring!
    if m.action ~= ACT_SLEEPING then
        if m.isSnoring > 0 then
            stop_custom_character_sound(m)
        end
        return

    --You're not in deep snoring
    elseif not (m.actionState == 2 and (m.flags & MARIO_MARIO_SOUND_PLAYED) ~= 0) then
        return
    end

    local animFrame = m.marioObj.header.gfx.animInfo.animFrame

    --Behavior for CHAR_SOUND_SNORING3
    if SNORE3_TABLE ~= nil and #SNORE3_TABLE >= 2 then
        --Exhale sound
        if animFrame == 2 and m.actionTimer < SLEEP_TALK_START then
            play_custom_character_sound(m, SNORE3_TABLE[2])

        --Inhale sound
        elseif animFrame == 25 then
            
            --Count up snores
            if #SNORE3_TABLE >= 3 then
                m.actionTimer = m.actionTimer + 1

                --End sleep-talk
                if m.actionTimer >= SLEEP_TALK_END then
                    m.actionTimer = STARTING_SNORE
                end
    
                --Enough snores? Start sleep-talk
                if m.actionTimer == SLEEP_TALK_START then
                    play_custom_character_sound(m, SNORE3_TABLE[3])
                
                --Regular snoring
                elseif m.actionTimer < SLEEP_TALK_START then
                    play_custom_character_sound(m, SNORE3_TABLE[1])
                end
            
            --Definitely regular snoring
            else
                play_custom_character_sound(m, SNORE3_TABLE[1])
            end
        end

    --No CHAR_SOUND_SNORING3, just use regular snoring
    elseif animFrame == 2 then
        play_character_sound(m, CHAR_SOUND_SNORING2)

    elseif animFrame == 25 then
        play_character_sound(m, CHAR_SOUND_SNORING1)
    end
end
hook_event(HOOK_MARIO_UPDATE, custom_character_snore)