---@param o Object
function wind_init(o)
    o.oFlags = (OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_COMPUTE_DIST_TO_MARIO | OBJ_FLAG_ACTIVE_FROM_AFAR)
end
---@param o Object
function wind_loop(o)
    ---@type MarioState
    local m = gMarioStates[0]
    obj_copy_pos(pos, o)
    play_sound(SOUND_AIR_HOWLING_WIND, m.marioObj.header.gfx.cameraToObject)
    -- o.oPosX = gMarioStates[0].pos.x
    -- o.oPosY = gMarioStates[0].pos.y
    -- o.oPosZ = gMarioStates[0].pos.z
    o.oPosX = m.pos.x
    o.oPosY = m.pos.y
    o.oPosZ = m.pos.z
    -- obj_set_pos(o, gMarioStates[0].pos.x, gMarioStates[0].pos.y, gMarioStates[0].pos.z)
end
---@param o Object
function ukiki_init(o)
    o.oInteractionSubtype = INT_SUBTYPE_NPC
    o.oInteractType = INTERACT_TEXT
    o.oFlags = (OBJ_FLAG_UPDATE_GFX_POS_AND_ANGLE | OBJ_FLAG_COMPUTE_ANGLE_TO_MARIO | OBJ_FLAG_COMPUTE_DIST_TO_MARIO | OBJ_FLAG_SET_FACE_YAW_TO_MOVE_YAW)
    bhv_bobomb_buddy_init()
    smlua_anim_util_set_animation(o, "koopa")
    o.oIntangibleTimer = 0
    o.hitboxHeight = 113
    o.hitboxRadius = 65
    o.hitboxDownOffset = 0
    o.oGravity = 2.5
    o.oFriction = 0.8
    o.oBuoyancy = 1.3
    o.oGraphYOffset = o.oGraphYOffset + 35
    timer = 0
end
---@param o Object
function ukiki_loop(o)
    bhv_bobomb_buddy_loop()
    local timer = timer + 1
    ---@type MarioState
    local m = gMarioStates[0]
    if timer == 0 then
        smlua_anim_util_set_animation(o, "koopa")
    end
    if timer == 0x3C then
        smlua_anim_util_set_animation(o, "koopa2")
    end
    if timer == 0x3C + 0x1A then
        smlua_anim_util_set_animation(o, "koopa3")
    end
    if timer == 0x3C + 0x1A + 0x22 then
        timer = 0
    end
    
    object_step()
end
id_bhvSandSoundLoop = hook_behavior(id_bhvSandSoundLoop, OBJ_LIST_LEVEL, true, wind_init, wind_loop, "Sand Ambient Sounds")
id_bhvUkiki = hook_behavior(id_bhvUkiki, OBJ_LIST_LEVEL, true, ukiki_init, ukiki_loop, "ukiki")
