-- name: B3313 Area Display
-- description: \\#ff00ff\\B\\#ff0000\\3\\#5555ff\\3\\#ffff00\\1\\#00ff00\\3\\#ff7700\\ Area Display\n\n\\#ffffff\\This mod displays the proper names of each area every player is in. It's easier to keep track of stars and their locations that way. Names are accurate to their latest version (either 0.7 or 0.9).\n\nMod by \\#2b0013\\Floralys\\#ffffff\\.

if mod_storage_load("ShowDisplay") == nil then
    mod_storage_save("ShowDisplay", "1")
end

local areas = {
    [LEVEL_BOB] = {
        [1] = {name = "Crimson Hallway", course = "C1", color = "blue"},
        [2] = {name = "3rd Floor (Beta)", course = "C1", color = "blue"},
        [3] = {name = "athletic", course = "C1", color = "yellow"},
        [4] = {name = "Bowser's Castle", course = "C1", color = "blue"},
        [5] = {name = "Fake Lobby", course = "C1", color = "blue"},
        [6] = {name = "Crescent Castle", course = "C1", color = "blue"},
        [7] = {name = "Goomba Hills", course = "C1", color = "yellow"}
    },
    [LEVEL_WF] = {
        [1] = {name = "Cryptic Hideout", course = "C2", color = "blue"},
        [2] = {name = "Dark Lobby", course = "C2", color = "blue"},
        [3] = {name = "Plexal Basement", course = "C2", color = "blue"},
        [4] = {name = "Plexal Basement", course = "C2", color = "purple"},
        [5] = {name = "Empty Flooded Hallway", course = "C2", color = "purple"},
        [6] = {name = "Lavish Lava Mountain", course = "C2", color = "yellow"},
        [7] = {name = "Lavish Lava Mountain", course = "C2", color = "yellow"}
    },
    [LEVEL_JRB] = {
        [1] = {name = "Bob-Omb River", course = "C3", color = "yellow"},
        [2] = {name = "Big Bob-Omb's Fortress", course = "C3", color = "purple"},
        [3] = {name = "Piranha Plant Garden", course = "C3", color = "yellow"},
        [4] = {name = "Minion Base", course = "C3", color = "yellow"},
        [5] = {name = "Piranha's Igloo", course = "C3", color = "yellow"}
    },
    [LEVEL_CCM] = {
        [1] = {name = "Jolly Roger Lagoon", course = "C4", color = "yellow"},
        [2] = {name = "Orange Hall", course = "C4", color = "blue"},
        [3] = {name = "Test Level", course = "C4", color = "yellow"},
        [4] = {name = "Checkerboard 1", course = "C4", color = "purple"},
        [5] = {name = "Holy Yellow Switch Palace", course = "C4", color = "purple"},
        [6] = {name = "Holy Yellow Switch Palace", course = "C4", color = "purple"}
    },
    [LEVEL_BBH] = {
        [1] = {name = "Whomp's Kingdom", course = "C5", color = "yellow"},
        [2] = {name = "Whomp's Prison", course = "C5", color = "yellow"},
        [4] = {name = "King Whomp's Battle Arena", course = "C5", color = "purple"},
        [5] = {name = "Flower Fields", course = "C5", color = "yellow"},
        [6] = {name = "Vanish Cap under the Moat (Beta)", course = "C5", color = "yellow"}
    },
    [LEVEL_HMC] = {
        [1] = {name = "Hazy Maze Cave (Empty)", course = "C6", color = "purple"},
        [2] = {name = "Tick Tock Blocks", course = "C6", color = "yellow"},
        [3] = {name = "Midnight Meadow", course = "C6", color = "yellow"},
        [4] = {name = "Lethal Cavern", course = "C6", color = "yellow"},
        [5] = {name = "???", course = "C6", color = "red"},
        [6] = {name = "Cave City", course = "C6", color = "yellow"},
        [7] = {name = "Click Clock Climb", course = "C6", color = "yellow"}
    },
    [LEVEL_LLL] = {
        [1] = {name = "Blazing Bully Base", course = "C7", color = "yellow"},
        [2] = {name = "Peaceful Sewer Maze", course = "C7", color = "purple"},
        [3] = {name = "Blazing Bully Base", course = "C7", color = "yellow"},
        [4] = {name = "Infernal Tower", course = "C7", color = "yellow"},
        [5] = {name = "Fire Bubble (B-Roll)", course = "C7", color = "yellow"}
    },
    [LEVEL_SSL] = {
        [1] = {name = "Desert Maze", course = "C8", color = "yellow"},
        [2] = {name = "Shifted Sand Land", course = "C8", color = "yellow"},
        [3] = {name = "Scary Sewer Maze", course = "C8", color = "purple"},
        [4] = {name = "Eyerok's Tomb", course = "C8", color = "purple"},
        [5] = {name = "Sandy Skyloft", course = "C8", color = "yellow"},
        [6] = {name = "Scary Sewer Maze", course = "C8", color = "purple"},
        [7] = {name = "Scary Sewer Maze", course = "C8", color = "purple"}
    },
    [LEVEL_DDD] = {
        [1] = {name = "Dark Hallway", course = "C9", color = "green"},
        [2] = {name = "Checkerboard 2", course = "C9", color = "purple"},
        [3] = {name = "Deadly Descent", course = "C9", color = "green"},
        [4] = {name = "Delicious Cake", course = "C9", color = "purple"},
        [5] = {name = "Snow Slide (B-Roll)", course = "C9", color = "yellow"},
        [6] = {name = "Snowman's Land (Beta)", course = "C9", color = "yellow"},
        [7] = {name = "Frosty Highlands", course = "C9", color = "yellow"}
    },
    [LEVEL_SL] = {
        [1] = {name = "Floating Hotel", course = "C10", color = "yellow"},
        [2] = {name = "Haunted Castle Grounds", course = "C10", color = "green"},
        [3] = {name = "Wing Cap by the Rainbow Highway", course = "C10", color = "yellow"},
        [4] = {name = "Tower of the Wing Cap (Beta)", course = "C10", color = "purple"},
        [5] = {name = "Rainbow Ride (Beta)", course = "C10", color = "yellow"},
        [6] = {name = "Vanish Cap within the Plexus", course = "C10", color = "yellow"}
    },
    [LEVEL_WDW] = {
        [1] = {name = "Snow Slide 2", course = "C11", color = "yellow"},
        [2] = {name = "Snowman's Darkness", course = "C11", color = "green"},
        [3] = {name = "Frosty Highlands", course = "C11", color = "yellow"},
        [4] = {name = "Cool, Cool Mountain (Beta)", course = "C11", color = "yellow"},
        [5] = {name = "Chief Chilly's Ring", course = "C11", color = "purple"},
        [6] = {name = "Cold, Cold Crevasse", course = "C11", color = "yellow"},
        [7] = {name = "Chroma Tundra", course = "C11", color = "yellow"}
    },
    [LEVEL_TTM] = {
        [1] = {name = "Tall, Tall Mountain", course = "C12", color = "yellow"},
        [2] = {name = "Monkey Slide", course = "C12", color = "green"},
        [3] = {name = "Monkey Slide", course = "C12", color = "green"},
        [4] = {name = "Monkey Slide", course = "C12", color = "green"}
    },
    [LEVEL_THI] = {
        [1] = {name = "Castle Grounds", course = "C13", color = "blue"},
        [2] = {name = "Bob-Omb Tower", course = "C13", color = "yellow"},
        [3] = {name = "Creepy Cove", course = "C13", color = "yellow"},
        [4] = {name = "Grassy Highlands", course = "C13", color = "yellow"},
        [5] = {name = "Minion Base", course = "C13", color = "yellow"},
        [6] = {name = "Peach's Cell", course = "C13", color = "green"},
        [7] = {name = "Peach's Cell", course = "C13", color = "green"}
    },
    [LEVEL_TTC] = {
        [1] = {name = "Big Boo's Haunted Forest", course = "C14", color = "yellow"},
        [2] = {name = "Dark Lobby", course = "C14", color = "blue"},
        [3] = {name = "Plexal Lobby", course = "C14", color = "blue"},
        [4] = {name = "Clock Hall", course = "C14", color = "blue"},
        [5] = {name = "Big Boo's Fortress", course = "C14", color = "yellow"},
        [6] = {name = "Plexal Hallway", course = "C14", color = "blue"},
        [7] = {name = "Bowser's Floor / Peach's Floor", course = "C14", color = "blue"}
    },
    [LEVEL_RR] = {
        [1] = {name = "Jolly Roger Bay (Beta)", course = "C15", color = "yellow"},
        [2] = {name = "Wiggler's Forest Fortress", course = "C15", color = "purple"},
        [3] = {name = "Checkerboard 3", course = "C15", color = "purple"},
        [4] = {name = "Bowser's Maze", course = "C15", color = "blue"},
        [5] = {name = "Balcony", course = "C15", color = "green"}
    },
    [LEVEL_BITDW] = {
        [1] = {name = "Tiny-Huge Island (Beta)", course = "B1", color = "yellow"},
        [2] = {name = "Uncanny Courtyard", course = "B1", color = "blue"},
        [3] = {name = "Creepy Cove", course = "B1", color = "yellow"},
        [4] = {name = "Sunken Castle", course = "B1", color = "yellow"},
        [5] = {name = "Mario's Maze", course = "B1", color = "purple"},
        [6] = {name = "Mario's Maze", course = "B1", color = "purple"}
    },
    [LEVEL_BITFS] = {
        [1] = {name = "Aquatic Tunnel", course = "B2", color = "yellow"},
        [2] = {name = "Cryptic Hideout", course = "B2", color = "blue"},
        [3] = {name = "Cryptic Hideout", course = "B2", color = "purple"},
        [4] = {name = "Cryptic Hideout", course = "B2", color = "purple"},
        [5] = {name = "Funhouse", course = "B2", color = "blue"}
    },
    [LEVEL_BITS] = {
        [1] = {name = "Wet-Dry World (Beta)", course = "B3", color = "yellow"},
        [3] = {name = "Ice-Cold Warzone", course = "B3", color = "yellow"},
        [4] = {name = "Bob-Omb Battlefield (Beta)", course = "B3", color = "yellow"}
    },
    [LEVEL_BOWSER_1] = {
        [1] = {name = "Bowser in the Dark World (Shoshinkai)", course = "B1", color = "purple"}
    },
    [LEVEL_BOWSER_2] = {
        [1] = {name = "Bowser's Checkered Madness", course = "B2", color = "purple"},
        [2] = {name = "Bowser in the Bully Battlefield", course = "B2", color = "purple"}
    },
    [LEVEL_BOWSER_3] = {
        [1] = {name = "Eternal Fort (Beta)", course = "B3", color = "purple"},
        [2] = {name = "The Void", course = "B3", color = "green"}
    },
    [LEVEL_SA] = {
        [1] = {name = "Dry Town", course = "S2", color = "yellow"},
        [2] = {name = "Wiggler's Forest Fortress", course = "S2", color = "purple"},
        [3] = {name = "Pleasant, Pleasant Falls", course = "S2", color = "yellow"},
        [4] = {name = "Sky-High Pathway", course = "S2", color = "yellow"},
        [6] = {name = "Ruins in the Blood Lake", course = "S2", color = "green"}
    },
    [LEVEL_WMOTR] = {
        [1] = {name = "Water Land", course = "S1", color = "yellow"},
        [2] = {name = "castle1", course = "S1", color = "yellow"},
        [3] = {name = "Parkour Playground", course = "S1", color = "yellow"},
        [4] = {name = "???", course = "S1", color = "red"},
        [5] = {name = "Castle Garden", course = "S1", color = "purple"},
        [6] = {name = "Castle Garden", course = "S1", color = "purple"}
    },
    [LEVEL_ENDING] = {
        [1] = {name = "Flooded Town", course = "S3", color = "yellow"},
        [2] = {name = "Underground Passageway", course = "S3", color = "blue"},
        [6] = {name = "Wet-Dry World (Beta)", course = "S3", color = "yellow"}
    },
    [LEVEL_PSS] = {
        [1] = {name = "Dark Downtown", course = "Slide", color = "yellow"},
        [2] = {name = "castle2", course = "Slide", color = "yellow"},
        [3] = {name = "Cubic Greens", course = "Slide", color = "yellow"},
        [4] = {name = "???", course = "Slide", color = "red"},
        [5] = {name = "Bob-Omb Village", course = "Slide", color = "yellow"},
        [6] = {name = "Dead Village", course = "Slide", color = "purple"},
        [7] = {name = "Plexal Upstairs", course = "Slide", color = "blue"}
    },
    [LEVEL_TOTWC] = {
        [1] = {name = "Eel Graveyard", course = "WC", color = "purple"},
        [2] = {name = "???", course = "WC", color = "red"},
        [3] = {name = "Checkerboard 4", course = "WC", color = "purple"},
        [4] = {name = "Plexal Upstairs", course = "WC", color = "blue"},
        [5] = {name = "Silent Hall", course = "WC", color = "blue"},
        [6] = {name = "The Void", course = "WC", color = "green"},
        [7] = {name = "The Void", course = "WC", color = "green"}
    },
    [LEVEL_COTMC] = {
        [1] = {name = "Mountain (B-Roll)", course = "MC", color = "yellow"},
        [2] = {name = "Goomboss Battle", course = "MC", color = "yellow"},
        [3] = {name = "Sinister Clockwork", course = "MC", color = "purple"},
        [4] = {name = "Whomp's Fortress (Beta)", course = "MC", color = "yellow"},
        [5] = {name = "Whomp's Fortress (Beta)", course = "MC", color = "yellow"},
        [6] = {name = "Rocky Trek", course = "MC", color = "yellow"}
    },
    [LEVEL_VCUTM] = {
        [1] = {name = "Battle Fort", course = "VC", color = "yellow"},
        [2] = {name = "Floor 2B", course = "VC", color = "blue"},
        [3] = {name = "Randomized Realm", course = "VC", color = "yellow"},
        [4] = {name = "???", course = "VC", color = "red"},
        [5] = {name = "Bob-Omb Test Site", course = "VC", color = "yellow"},
        [6] = {name = "Big Bob-Omb's Fortress", course = "VC", color = "purple"}
    },
    [LEVEL_CASTLE_GROUNDS] = {
        [1] = {name = "Castle Grounds", course = "OW (Grounds)", color = "blue"},
        [2] = {name = "Beta Lobbies C and D", course = "OW (Grounds)", color = "blue"},
        [3] = {name = "Beta Lobby B", course = "OW (Grounds)", color = "blue"},
        [4] = {name = "Beta Lobby A", course = "OW (Grounds)", color = "blue"},
        [5] = {name = "Genesis Basement", course = "OW (Grounds)", color = "blue"},
        [6] = {name = "Bowser Hallway / Bowser's Prison (Grounds)", course = "OW", color = "blue"},
        [7] = {name = "Plexal Upstairs", course = "OW (Grounds)", color = "blue"}
    },
    [LEVEL_CASTLE] = {
        [1] = {name = "Vanilla Lobby", course = "OW (Castle)", color = "blue"},
        [2] = {name = "Vanilla Upstairs", course = "OW (Castle)", color = "blue"},
        [3] = {name = "Vanilla Basement", course = "OW (Castle)", color = "blue"}
    },
    [LEVEL_CASTLE_COURTYARD] = {
        [1] = {name = "Uncanny Courtyard (Sunny)", course = "OW (Courtyard)", color = "blue"},
        [2] = {name = "Forest Maze", course = "OW (Courtyard)", color = "green"},
        [3] = {name = "The Star", course = "OW (Courtyard)", color = "green"},
        [4] = {name = "Purple Upstairs", course = "OW (Courtyard)", color = "blue"},
        [5] = {name = "The Void", course = "OW (Courtyard)", color = "green"},
        [6] = {name = "Uncanny Courtyard (Crimson)", course = "OW (Courtyard)", color = "blue"},
        [7] = {name = "Uncanny Courtyard (Windy)", course = "OW (Courtyard)", color = "blue"}
    }
}

local timer = 0
local function mario_update(m)
    if m.playerIndex ~= 0 then return end
    timer = timer + 1
    if timer >= 30 then
        if areas[gNetworkPlayers[m.playerIndex].currLevelNum][gNetworkPlayers[m.playerIndex].currAreaIndex] ~= nil then
            gPlayerSyncTable[m.playerIndex].location = areas[gNetworkPlayers[m.playerIndex].currLevelNum][gNetworkPlayers[m.playerIndex].currAreaIndex].name
            gPlayerSyncTable[m.playerIndex].course = areas[gNetworkPlayers[m.playerIndex].currLevelNum][gNetworkPlayers[m.playerIndex].currAreaIndex].course
            gPlayerSyncTable[m.playerIndex].color = areas[gNetworkPlayers[m.playerIndex].currLevelNum][gNetworkPlayers[m.playerIndex].currAreaIndex].color
            gPlayerSyncTable[m.playerIndex].area = gNetworkPlayers[m.playerIndex].currAreaIndex
        else
            gPlayerSyncTable[m.playerIndex].location = "???"
            gPlayerSyncTable[m.playerIndex].course = "???"
            gPlayerSyncTable[m.playerIndex].color = "red"
            gPlayerSyncTable[m.playerIndex].area = "???"
        end
        timer = 0
    end
end

for i = 0, MAX_PLAYERS - 1 do
    gPlayerSyncTable[i].location = "Loading..."
    gPlayerSyncTable[i].course = "???"
    gPlayerSyncTable[i].color = "red"
    gPlayerSyncTable[i].area = "???"
end

local j = 0
local scrolling = 0
local height = 0
local function on_hud_render()
    j = 0
    if network_player_connected_count() > 5 then
        if gMarioStates[0].controller.buttonPressed & D_JPAD ~= 0 then
            if scrolling < network_player_connected_count() - 5 then
                scrolling = scrolling + 1
            end
        end
        if gMarioStates[0].controller.buttonPressed & U_JPAD ~= 0 then
            if scrolling > 0 then
                scrolling = scrolling - 1
            end
        end
    else
        scrolling = 0
    end

    if network_player_connected_count() >= 5 then
        height = 125
    else
        height = (25 * network_player_connected_count())
    end

    if mod_storage_load("ShowDisplay") == "1" then
        djui_hud_set_resolution(RESOLUTION_N64)
        djui_hud_set_color(0, 0, 0, 128)
        djui_hud_render_rect(2, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 42), 115, height + 2)
        djui_hud_render_rect(3, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 43), 113, height)
        if network_player_connected_count() > 5 then
            djui_hud_print_text("Use the D-Pad to check other players' locations!", 13.25, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 35.25), 0.2)
            djui_hud_set_color(255, 255, 255, 255)
            djui_hud_print_text("Use the D-Pad to check other players' locations!", 13, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 35), 0.2)
        end

        for i = 0, MAX_PLAYERS - 1 do
            if i + scrolling > 15 then return end
            if gNetworkPlayers[i + scrolling].connected then
                if i < 5 then
                    djui_hud_set_color(0, 0, 0, 128)
                    djui_hud_print_text(gNetworkPlayers[i + scrolling].name.." is in:", 5.5, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 44.5 - (j * 25)), 0.3)
                    djui_hud_print_text(gPlayerSyncTable[i + scrolling].location, 5.5, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 52.5 - (j * 25)), 0.3)
                    djui_hud_print_text("("..gPlayerSyncTable[i + scrolling].course.." - Area "..gPlayerSyncTable[i + scrolling].area..")", 5.25, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 60.25 - (j * 25)), 0.2)
                    djui_hud_set_color(0, 128, 255, 255)
                    djui_hud_print_text(gNetworkPlayers[i + scrolling].name.." is in:", 5, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 44 - (j * 25)), 0.3)
                    if gPlayerSyncTable[i + scrolling].color == "yellow" then
                        djui_hud_set_color(255, 255, 0, 255)
                    elseif gPlayerSyncTable[i + scrolling].color == "green" then
                        djui_hud_set_color(0, 255, 0, 255)
                    elseif gPlayerSyncTable[i + scrolling].color == "blue" then
                        djui_hud_set_color(0, 255, 255, 255)
                    elseif gPlayerSyncTable[i + scrolling].color == "purple" then
                        djui_hud_set_color(255, 0, 255, 255)
                    elseif gPlayerSyncTable[i + scrolling].color == "red" then
                        djui_hud_set_color(255, 0, 0, 255)
                    end
                    djui_hud_print_text(gPlayerSyncTable[i + scrolling].location, 5, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 52 - (j * 25)), 0.3)
                    djui_hud_set_color(128, 128, 128, 255)
                    djui_hud_print_text("("..gPlayerSyncTable[i + scrolling].course.." - Area "..gPlayerSyncTable[i + scrolling].area..")", 5, djui_hud_get_screen_height() - (djui_hud_get_screen_height() - 60 - (j * 25)), 0.2)
                end
            end
            j = j + 1
            if not gNetworkPlayers[i + scrolling].connected then
                j = j - 1
            end
        end
    end
end

local function chat_command(msg)
    msg = string.lower(msg)
    if msg == "on" then
        mod_storage_save("ShowDisplay", "1")
    elseif msg == "off" then
        mod_storage_save("ShowDisplay", "0")
    else
        return false
    end
    return true
end

hook_event(HOOK_MARIO_UPDATE, mario_update)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_chat_command("show-display", "- [\\#ff00ff\\B\\#ff0000\\3\\#5555ff\\3\\#ffff00\\1\\#00ff00\\3\\#ff7700\\ Area Display\\#ffffff\\] [on/off] Toggles whether or not the area display is shown to you.", chat_command)