/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.dynamic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;

public class DynamicEnchantment {
    protected final Type type;
    @Nullable
    protected final Enchantment enchantment;
    protected int levelAddition;

    public DynamicEnchantment(Type type, @Nonnull Enchantment enchantment, int levelAddition) {
        if (!type.hasEnchantmentTag()) {
            throw new IllegalArgumentException("Tried to create amulet enchantment that doesn't requires a std. enchantment together with an enchantment!");
        }
        this.type = type;
        this.enchantment = enchantment;
        this.levelAddition = levelAddition;
    }

    public DynamicEnchantment(Type type, int levelAddition) {
        if (type.hasEnchantmentTag()) {
            throw new IllegalArgumentException("Tried to create amulet enchantment that requires a std. enchantment without an enchantment!");
        }
        this.type = type;
        this.enchantment = null;
        this.levelAddition = levelAddition;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getLevelAddition() {
        return this.levelAddition;
    }

    public void setLevelAddition(int levelAddition) {
        this.levelAddition = levelAddition;
    }

    @Nonnull
    public DynamicEnchantment copy() {
        return this.copy(this.getLevelAddition());
    }

    @Nonnull
    public DynamicEnchantment copy(int level) {
        if (this.getType().hasEnchantmentTag()) {
            return new DynamicEnchantment(this.getType(), this.getEnchantment(), level);
        }
        return new DynamicEnchantment(this.type, level);
    }

    public static enum Type {
        ADD_TO_SPECIFIC,
        ADD_TO_EXISTING_SPECIFIC,
        ADD_TO_EXISTING_ALL(false);

        private final boolean hasEnchantmentTag;

        private Type() {
            this(true);
        }

        private Type(boolean hasEnchantmentTag) {
            this.hasEnchantmentTag = hasEnchantmentTag;
        }

        public boolean hasEnchantmentTag() {
            return this.hasEnchantmentTag;
        }
    }
}

