/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.lib.Constellations;

public class ConstellationEffectProperties {
    private double size;
    private double potency = 1.0;
    private double effectAmplifier = 1.0;
    private boolean corrupted = false;
    private double fracturationLower = 1.0;
    private double fracturationRate = 1.0;

    public ConstellationEffectProperties(double size) {
        this.size = size;
    }

    public double getSize() {
        return this.size;
    }

    public double getPotency() {
        return this.potency;
    }

    public double getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public double getFracturationLowerBoundaryMultiplier() {
        return this.fracturationLower;
    }

    public double getFracturationRate() {
        return this.fracturationRate;
    }

    public ConstellationEffectProperties modify(IMinorConstellation trait) {
        if (trait != null) {
            if (trait.equals(Constellations.gelu)) {
                this.potency *= (double)0.15f;
                this.size *= 3.5;
            }
            if (trait.equals(Constellations.ulteria)) {
                this.effectAmplifier *= 4.0;
                this.size *= (double)0.2f;
            }
            if (trait.equals(Constellations.alcara)) {
                this.fracturationLower *= (double)0.015f;
                this.fracturationRate *= 50000.0;
                this.size *= 2.0;
                this.effectAmplifier *= 2.0;
                this.corrupted = true;
            }
            if (trait.equals(Constellations.vorux)) {
                this.fracturationLower *= 0.25;
                this.fracturationRate *= 3000.0;
                this.effectAmplifier *= 2.0;
                this.size *= 1.75;
            }
        }
        return this;
    }
}

