/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AlternativelyParser
extends ClassVisitor {
    public Map<String, String> fieldReplacements = new HashMap<String, String>();
    public Map<String, String> methodReplacements = new HashMap<String, String>();
    private final ClassNode node;

    public AlternativelyParser(int api, ClassNode node) {
        super(api);
        this.node = node;
    }

    public AlternativelyParser(int api, ClassNode node, ClassVisitor next) {
        super(api, next);
        this.node = node;
    }

    private boolean containsMethod(String name, String desc) {
        for (MethodNode methodNode : this.node.methods) {
            if (!name.equals(methodNode.name) || !desc.equals(methodNode.desc)) continue;
            return true;
        }
        return false;
    }

    private boolean containsField(String name, String desc) {
        for (FieldNode fieldNode : this.node.fields) {
            if (!name.equals(fieldNode.name) || !desc.equals(fieldNode.desc)) continue;
            return true;
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.containsMethod(name, desc)) {
            return new Method(this.api, name, desc, super.visitMethod(access, name, desc, signature, exceptions));
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public class Field
    extends FieldVisitor {
        private final String name;
        private final String desc;

        public Field(int api, String name, String desc, FieldVisitor mv) {
            super(api, mv);
            this.name = name;
            this.desc = desc;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            System.out.println(desc);
            return new Annotation(this.api, AlternativelyParser.this.fieldReplacements, (x$0, x$1) -> AlternativelyParser.this.containsField(x$0, x$1), this.name, this.desc, super.visitAnnotation(desc, visible));
        }
    }

    public class Method
    extends MethodVisitor {
        private final String name;
        private final String desc;

        public Method(int api, String name, String desc, MethodVisitor mv) {
            super(api, mv);
            this.name = name;
            this.desc = desc;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            System.out.println(desc);
            return new Annotation(this.api, AlternativelyParser.this.methodReplacements, (x$0, x$1) -> AlternativelyParser.this.containsMethod(x$0, x$1), this.name, this.desc, super.visitAnnotation(desc, visible));
        }
    }

    public static class Annotation
    extends AnnotationVisitor {
        private final Map<String, String> targetMap;
        private final BiFunction<String, String, Boolean> verifier;
        private final String targetKey;
        private final String targetDesc;

        public Annotation(int api, Map<String, String> map, BiFunction<String, String, Boolean> verifier, String key, String desc, AnnotationVisitor next) {
            super(api, next);
            this.verifier = verifier;
            this.targetMap = map;
            this.targetKey = key;
            this.targetDesc = desc;
        }

        public void visit(String name, Object value) {
            if (value instanceof String[] && "value".equals(name)) {
                for (String s : (String[])value) {
                    if (!this.verifier.apply(s, this.targetDesc).booleanValue()) continue;
                    this.targetMap.put(this.targetKey, s);
                    return;
                }
            }
        }
    }
}

