/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import electroblob.wizardry.util.WizardryUtilities;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.Template;

public class WoodTypeTemplateProcessor
implements ITemplateProcessor {
    private final BlockPlanks.EnumType woodType;
    private final EnumMap<BlockPlanks.EnumType, Block> DOORS;
    private final EnumMap<BlockPlanks.EnumType, Block> STAIRS;
    private final EnumMap<BlockPlanks.EnumType, Block> FENCES;
    private final EnumMap<BlockPlanks.EnumType, Block> FENCE_GATES;

    public WoodTypeTemplateProcessor(BlockPlanks.EnumType woodType) {
        this.woodType = woodType;
        this.DOORS = new EnumMap(BlockPlanks.EnumType.class);
        this.DOORS.put(BlockPlanks.EnumType.OAK, (Block)Blocks.field_180413_ao);
        this.DOORS.put(BlockPlanks.EnumType.SPRUCE, (Block)Blocks.field_180414_ap);
        this.DOORS.put(BlockPlanks.EnumType.BIRCH, (Block)Blocks.field_180412_aq);
        this.DOORS.put(BlockPlanks.EnumType.JUNGLE, (Block)Blocks.field_180411_ar);
        this.DOORS.put(BlockPlanks.EnumType.ACACIA, (Block)Blocks.field_180410_as);
        this.DOORS.put(BlockPlanks.EnumType.DARK_OAK, (Block)Blocks.field_180409_at);
        this.STAIRS = new EnumMap(BlockPlanks.EnumType.class);
        this.STAIRS.put(BlockPlanks.EnumType.OAK, Blocks.field_150476_ad);
        this.STAIRS.put(BlockPlanks.EnumType.SPRUCE, Blocks.field_150485_bF);
        this.STAIRS.put(BlockPlanks.EnumType.BIRCH, Blocks.field_150487_bG);
        this.STAIRS.put(BlockPlanks.EnumType.JUNGLE, Blocks.field_150481_bH);
        this.STAIRS.put(BlockPlanks.EnumType.ACACIA, Blocks.field_150400_ck);
        this.STAIRS.put(BlockPlanks.EnumType.DARK_OAK, Blocks.field_150401_cl);
        this.FENCES = new EnumMap(BlockPlanks.EnumType.class);
        this.FENCES.put(BlockPlanks.EnumType.OAK, Blocks.field_180407_aO);
        this.FENCES.put(BlockPlanks.EnumType.SPRUCE, Blocks.field_180408_aP);
        this.FENCES.put(BlockPlanks.EnumType.BIRCH, Blocks.field_180404_aQ);
        this.FENCES.put(BlockPlanks.EnumType.JUNGLE, Blocks.field_180403_aR);
        this.FENCES.put(BlockPlanks.EnumType.ACACIA, Blocks.field_180405_aT);
        this.FENCES.put(BlockPlanks.EnumType.DARK_OAK, Blocks.field_180406_aS);
        this.FENCE_GATES = new EnumMap(BlockPlanks.EnumType.class);
        this.FENCE_GATES.put(BlockPlanks.EnumType.OAK, Blocks.field_180390_bo);
        this.FENCE_GATES.put(BlockPlanks.EnumType.SPRUCE, Blocks.field_180391_bp);
        this.FENCE_GATES.put(BlockPlanks.EnumType.BIRCH, Blocks.field_180392_bq);
        this.FENCE_GATES.put(BlockPlanks.EnumType.JUNGLE, Blocks.field_180386_br);
        this.FENCE_GATES.put(BlockPlanks.EnumType.ACACIA, Blocks.field_180387_bt);
        this.FENCE_GATES.put(BlockPlanks.EnumType.DARK_OAK, Blocks.field_180385_bs);
    }

    @Nullable
    public Template.BlockInfo func_189943_a(World world, BlockPos pos, Template.BlockInfo info) {
        if (info.field_186243_b.func_177230_c() instanceof BlockPlanks) {
            return new Template.BlockInfo(info.field_186242_a, info.field_186243_b.func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)this.woodType), info.field_186244_c);
        }
        if (info.field_186243_b.func_177230_c() instanceof BlockWoodSlab) {
            return new Template.BlockInfo(info.field_186242_a, info.field_186243_b.func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)this.woodType), info.field_186244_c);
        }
        if (this.DOORS.containsValue(info.field_186243_b.func_177230_c())) {
            return new Template.BlockInfo(info.field_186242_a, WizardryUtilities.copyState(this.DOORS.get(this.woodType), info.field_186243_b), info.field_186244_c);
        }
        if (this.STAIRS.containsValue(info.field_186243_b.func_177230_c())) {
            return new Template.BlockInfo(info.field_186242_a, WizardryUtilities.copyState(this.STAIRS.get(this.woodType), info.field_186243_b), info.field_186244_c);
        }
        if (this.FENCES.containsValue(info.field_186243_b.func_177230_c())) {
            return new Template.BlockInfo(info.field_186242_a, WizardryUtilities.copyState(this.FENCES.get(this.woodType), info.field_186243_b), info.field_186244_c);
        }
        if (this.FENCE_GATES.containsValue(info.field_186243_b.func_177230_c())) {
            return new Template.BlockInfo(info.field_186242_a, WizardryUtilities.copyState(this.FENCE_GATES.get(this.woodType), info.field_186243_b), info.field_186244_c);
        }
        return info;
    }
}

