/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.tileentity;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.packet.PacketConquerShrine;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.potion.PotionContainment;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityShrineCore
extends TileEntity
implements ITickable {
    private static final double ACTIVATION_RADIUS = 5.0;
    private boolean activated = false;
    private AxisAlignedBB containmentField;
    private final UUID[] linkedWizards = new UUID[3];
    private TileEntity linkedContainer;
    private BlockPos linkedContainerPos;

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.initContainmentField(pos);
    }

    private void initContainmentField(BlockPos pos) {
        float r = PotionContainment.getContainmentDistance(0);
        this.containmentField = new AxisAlignedBB((double)(-r), (double)(-r), (double)(-r), (double)r, (double)r, (double)r).func_191194_a(WizardryUtilities.getCentre(pos));
    }

    public void linkContainer(TileEntity container) {
        this.linkedContainer = container;
    }

    public void func_73660_a() {
        if (this.linkedContainer == null && this.linkedContainerPos != null) {
            this.linkContainer(this.field_145850_b.func_175625_s(this.linkedContainerPos));
        }
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (!this.activated && this.field_145850_b.func_184137_a(x, y, z, 5.0, false) != null) {
            this.activated = true;
            if (this.field_145850_b.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(x, y + 1.0, z).clr(15754389).scale(5.0f).time(12).spawn(this.field_145850_b);
            }
            this.field_145850_b.func_184134_a(x, y, z, WizardrySounds.BLOCK_PEDESTAL_ACTIVATE, SoundCategory.BLOCKS, 1.5f, 1.0f, false);
            if (!this.field_145850_b.field_72995_K) {
                EntityEvilWizard[] wizards = new EntityEvilWizard[this.linkedWizards.length];
                for (int i = 0; i < this.linkedWizards.length; ++i) {
                    EntityEvilWizard wizard = new EntityEvilWizard(this.field_145850_b);
                    float angle = this.field_145850_b.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
                    double x1 = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(5.0f * MathHelper.func_76126_a((float)angle));
                    double z1 = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(5.0f * MathHelper.func_76134_b((float)angle));
                    Integer y1 = WizardryUtilities.getNearestFloor(this.field_145850_b, new BlockPos(x1, (double)this.field_174879_c.func_177956_o(), z1), 8);
                    if (y1 == null) {
                        x1 = this.field_174879_c.func_177958_n() + 1;
                        y1 = this.field_174879_c.func_177956_o();
                        z1 = this.field_174879_c.func_177952_p();
                    }
                    wizard.func_70012_b(x1, (double)y1.intValue() + 0.5, z1, 0.0f, 0.0f);
                    wizard.setElement((Element)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPedestal.ELEMENT)));
                    wizard.func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
                    wizard.hasStructure = true;
                    this.field_145850_b.func_72838_d((Entity)wizard);
                    wizards[i] = wizard;
                    this.linkedWizards[i] = wizard.func_110124_au();
                }
                for (EntityEvilWizard wizard : wizards) {
                    wizard.groupUUIDs.addAll(Arrays.asList(this.linkedWizards));
                }
            }
            this.containNearbyTargets();
        }
        if (this.activated && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.containNearbyTargets();
        }
        if (this.activated && this.areWizardsDead() && !this.field_145850_b.field_72995_K) {
            this.conquer();
        }
    }

    private boolean areWizardsDead() {
        for (UUID uuid : this.linkedWizards) {
            Entity entity = WizardryUtilities.getEntityByUUID(this.field_145850_b, uuid);
            if (!(entity instanceof EntityEvilWizard) || !entity.func_70089_S()) continue;
            return false;
        }
        return true;
    }

    public void conquer() {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        if (!this.field_145850_b.field_72995_K) {
            WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketConquerShrine.Message(this.field_174879_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), x, y, z, 64.0));
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == WizardryBlocks.runestone_pedestal) {
                this.field_145850_b.func_175656_a(this.field_174879_c, WizardryBlocks.runestone_pedestal.func_176223_P().func_177226_a(BlockPedestal.ELEMENT, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockPedestal.ELEMENT)));
            } else {
                Wizardry.logger.warn("What's going on?! A shrine core is being conquered but the block at its position is not a runestone pedestal!");
            }
        }
        this.field_145850_b.func_147457_a((TileEntity)this);
        if (!this.field_145850_b.field_72995_K) {
            if (this.linkedContainer != null) {
                NBTExtras.removeUniqueId(this.linkedContainer.getTileData(), "arcaneLockOwner");
            }
        } else {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (tileEntity != null) {
                NBTExtras.removeUniqueId(tileEntity.getTileData(), "arcaneLockOwner");
            }
        }
        this.field_145850_b.func_184134_a(x, y, z, WizardrySounds.BLOCK_PEDESTAL_CONQUER, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        if (this.field_145850_b.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).scale(5.0f).pos(x, y + 1.0, z).clr(15754389).time(12).spawn(this.field_145850_b);
            for (int i = 0; i < 5; ++i) {
                float brightness = 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE, this.field_145850_b.field_73012_v, x, y + 1.0, z, 1.0, true).clr(1.0f, brightness, brightness).spawn(this.field_145850_b);
            }
        }
    }

    private void containNearbyTargets() {
        List entities = this.field_145850_b.func_175647_a(EntityLivingBase.class, this.containmentField, e -> e instanceof EntityPlayer || e instanceof EntityWizard || e instanceof EntityEvilWizard);
        for (EntityLivingBase entity : entities) {
            entity.func_70690_d(new PotionEffect(WizardryPotions.containment, 219));
            NBTExtras.storeTagSafely(entity.getEntityData(), "containmentPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.field_174879_c));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("activated", this.activated);
        if (this.linkedContainer != null) {
            NBTExtras.storeTagSafely(compound, "linkedContainerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.linkedContainer.func_174877_v()));
        }
        NBTTagList tagList = new NBTTagList();
        for (UUID uuid : this.linkedWizards) {
            if (uuid == null) continue;
            tagList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid));
        }
        NBTExtras.storeTagSafely(compound, "wizards", (NBTBase)tagList);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.activated = compound.func_74767_n("activated");
        this.linkedContainerPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("linkedContainerPos"));
        NBTTagList tagList = compound.func_150295_c("wizards", 10);
        int i = 0;
        for (NBTBase tag : tagList) {
            if (tag instanceof NBTTagCompound) {
                this.linkedWizards[i++] = NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)tag));
                continue;
            }
            Wizardry.logger.warn("Unexpected tag type in NBT tag list of compound tags!");
        }
        super.func_145839_a(compound);
        this.initContainmentField(this.field_174879_c);
    }
}

