/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonIronGolem
extends Spell {
    public SummonIronGolem() {
        super("summon_iron_golem", EnumAction.BOW, false);
        this.addProperties("summon_radius");
        this.soundValues(1.0f, 1.1f, 0.2f);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, this.getProperty("summon_radius").intValue(), this.getProperty("summon_radius").intValue());
        if (pos == null) {
            return false;
        }
        if (!world.field_72995_K) {
            EntityIronGolem golem = new EntityIronGolem(world);
            golem.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            golem.func_70849_f(true);
            world.func_72838_d((Entity)golem);
        } else {
            for (int i = 0; i < 10; ++i) {
                double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = (double)pos.func_177956_o() + 0.5 + world.field_73012_v.nextDouble();
                double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).clr(0.6f, 0.6f, 1.0f).spawn(world);
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

