/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LifeDrain
extends SpellRay {
    public static final String HEAL_FACTOR = "heal_factor";

    public LifeDrain() {
        super("life_drain", true, EnumAction.NONE);
        this.particleVelocity(-0.5);
        this.particleSpacing(0.4);
        this.addProperties("damage", HEAL_FACTOR);
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target) && ticksInUse % 12 == 0) {
            float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
            WizardryUtilities.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), damage);
            if (caster != null) {
                caster.func_70691_i(damage * this.getProperty(HEAL_FACTOR).floatValue());
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        if (world.field_73012_v.nextInt(5) == 0) {
            ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        }
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(6)).clr(0.5f, 0.0f, 0.0f).spawn(world);
    }
}

