/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class InvigoratingPresence
extends Spell {
    public InvigoratingPresence() {
        super("invigorating_presence", EnumAction.BOW, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties("effect_radius", "effect_duration", "effect_strength");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityPlayer> targets = WizardryUtilities.getEntitiesWithinRadius(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityPlayer.class);
        for (EntityPlayer target : targets) {
            if (!AllyDesignationSystem.isPlayerAlly(caster, target) && target != caster) continue;
            int bonusAmplifier = SpellBuff.getStandardBonusAmplifier(modifiers.get("potency"));
            target.func_70690_d(new PotionEffect(MobEffects.field_76420_g, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + bonusAmplifier));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 50.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double radius = (1.0 + world.field_73012_v.nextDouble() * 4.0) * (double)modifiers.get(WizardryItems.blast_upgrade);
                float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                double x = caster.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle);
                double y = caster.func_174813_aQ().field_72338_b;
                double z = caster.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle);
                ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.03, 0.0).time(50).clr(1.0f, 0.2f, 0.2f).spawn(world);
                ++i;
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    protected String getTranslationKey() {
        return Wizardry.tisTheSeason ? super.getTranslationKey() + "_festive" : super.getTranslationKey();
    }
}

