/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemDye;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GrowthAura
extends Spell {
    public GrowthAura() {
        super("growth_aura", EnumAction.NONE, false);
        this.addProperties("effect_radius");
        this.soundValues(0.7f, 1.2f, 0.2f);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean flag = false;
        List<BlockPos> sphere = WizardryUtilities.getBlockSphere(caster.func_180425_c(), this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade));
        for (BlockPos pos : sphere) {
            IGrowable plant;
            IBlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof IGrowable) || !(plant = (IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, world.field_72995_K)) continue;
            if (!world.field_72995_K) {
                if (plant.func_180670_a(world, world.field_73012_v, pos, state)) {
                    if (world.field_73012_v.nextFloat() < 0.35f && ItemArtefact.isArtefactActive(caster, WizardryItems.charm_growth)) {
                        while (plant.func_176473_a(world, pos, state, false)) {
                            plant.func_176474_b(world, world.field_73012_v, pos, state);
                            state = world.func_180495_p(pos);
                            plant = (IGrowable)state.func_177230_c();
                        }
                    } else {
                        plant.func_176474_b(world, world.field_73012_v, pos, state);
                    }
                }
            } else {
                ItemDye.func_180617_a((World)world, (BlockPos)pos, (int)0);
            }
            flag = true;
        }
        if (flag) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return flag;
    }
}

