/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityEarthquake;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class Earthquake
extends SpellConstruct<EntityEarthquake> {
    public static final String SPREAD_SPEED = "spread_speed";

    public Earthquake() {
        super("earthquake", EnumAction.NONE, EntityEarthquake::new, true);
        this.soundValues(2.0f, 1.0f, 0.0f);
        this.overlap(true);
        this.floor(true);
        this.addProperties("effect_radius", SPREAD_SPEED);
    }

    @Override
    public boolean requiresPacket() {
        return true;
    }

    @Override
    protected void addConstructExtras(EntityEarthquake construct, EnumFacing side, EntityLivingBase caster, SpellModifiers modifiers) {
        construct.lifetime = (int)(this.getProperty("effect_radius").floatValue() / this.getProperty(SPREAD_SPEED).floatValue() * modifiers.get(WizardryItems.blast_upgrade));
    }

    @Override
    protected boolean spawnConstruct(World world, double x, double y, double z, EnumFacing side, EntityLivingBase caster, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, x, y + 0.1, z, 0.0, 0.0, 0.0, new int[0]);
            for (int i = 0; i < 40; ++i) {
                double particleX = x - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = z - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, y, particleZ, particleX - x, 0.0, particleZ - z, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            WizardryUtilities.getEntitiesWithinRadius(15.0, x, y, z, world, EntityPlayer.class).forEach(p -> Wizardry.proxy.shakeScreen((EntityPlayer)p, 12.0f));
        }
        return super.spawnConstruct(world, x, y, z, side, caster, modifiers);
    }
}

