/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstructRanged;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Decay
extends SpellConstructRanged<EntityDecay> {
    public static final String DECAY_PATCHES_SPAWNED = "decay_patches_spawned";

    public Decay() {
        super("decay", EntityDecay::new, false);
        this.soundValues(1.0f, 1.1f, 0.1f);
        this.floor(true);
        this.overlap(true);
        this.addProperties(DECAY_PATCHES_SPAWNED, "effect_duration");
    }

    @Override
    protected boolean spawnConstruct(World world, double x, double y, double z, EnumFacing side, EntityLivingBase caster, SpellModifiers modifiers) {
        BlockPos pos;
        BlockPos origin = new BlockPos(x, y, z);
        if (world.func_180495_p(origin).func_185915_l()) {
            return false;
        }
        super.spawnConstruct(world, x, y, z, side, caster, modifiers);
        float decayCount = this.getProperty(DECAY_PATCHES_SPAWNED).floatValue();
        int quantity = (int)(decayCount * modifiers.get(WizardryItems.blast_upgrade));
        int horizontalRange = (int)(0.4 * (double)decayCount * (double)modifiers.get(WizardryItems.blast_upgrade));
        int verticalRange = (int)(6.0f * modifiers.get(WizardryItems.blast_upgrade));
        for (int i = 0; i < quantity && (pos = WizardryUtilities.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange)) != null; ++i) {
            super.spawnConstruct(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, side, caster, modifiers);
        }
        return true;
    }
}

