/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ArcaneJammer
extends SpellRay {
    private static final Field spellTicks = ObfuscationReflectionHelper.findField(EntitySpellcasterIllager.class, (String)"field_193087_b");

    public ArcaneJammer() {
        super("arcane_jammer", false, EnumAction.NONE);
        this.soundValues(0.7f, 1.0f, 0.4f);
        this.addProperties("effect_duration");
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving(target) && !world.field_72995_K) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.arcane_jammer, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), 0));
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(0.9f, 0.3f, 0.7f).spawn(world);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() != null && event.getCaster().func_70644_a(WizardryPotions.arcane_jammer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntitySpellcasterIllager && event.getEntityLiving().func_70644_a(WizardryPotions.arcane_jammer)) {
            ((EntitySpellcasterIllager)event.getEntity()).func_193081_a(EntitySpellcasterIllager.SpellType.NONE);
            try {
                spellTicks.set(event.getEntity(), 10);
            }
            catch (IllegalAccessException e) {
                Wizardry.logger.error("Error setting evoker spell timer:", (Throwable)e);
            }
        }
    }
}

