/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer;

import electroblob.wizardry.entity.construct.EntityForcefield;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderForcefield
extends Render<EntityForcefield> {
    private static final float EXPANSION_TIME = 3.0f;

    public RenderForcefield(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityForcefield entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float latStep = 0.15707964f;
        float longStep = 0.15707964f;
        float pulse = MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + partialTicks) / 10.0f));
        float r = 0.35f;
        float g = 0.55f + 0.05f * pulse;
        float b = 1.0f;
        float radius = entity.getRadius();
        float a = 0.5f;
        if ((float)entity.field_70173_aa > (float)entity.lifetime - 3.0f) {
            radius *= 1.0f + 0.2f * ((float)entity.field_70173_aa + partialTicks - ((float)entity.lifetime - 3.0f)) / 3.0f;
            a *= Math.max(0.0f, 1.0f - ((float)entity.field_70173_aa + partialTicks - ((float)entity.lifetime - 3.0f)) / 3.0f);
        } else if ((float)entity.field_70173_aa < 3.0f) {
            radius *= 1.0f - (3.0f - (float)entity.field_70173_aa - partialTicks) / 3.0f;
            a *= 1.0f - (3.0f - (float)entity.field_70173_aa - partialTicks) / 3.0f;
        }
        RenderForcefield.drawSphere(radius - 0.1f - 0.025f * pulse, latStep, longStep, true, r, g, b, a);
        RenderForcefield.drawSphere(radius - 0.1f - 0.025f * pulse, latStep, longStep, false, 1.0f, 1.0f, 1.0f, a);
        RenderForcefield.drawSphere(radius, latStep, longStep, false, r, g, b, 0.7f * a);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityForcefield entity) {
        return null;
    }

    private static void drawSphere(float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        boolean goingUp = inside;
        buffer.func_181662_b(0.0, goingUp ? (double)(-radius) : (double)radius, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * MathHelper.func_76134_b((float)latitude);
                float vy = radius * MathHelper.func_76126_a((float)latitude);
                float vx = hRadius * MathHelper.func_76126_a((float)longitude);
                float vz = hRadius * MathHelper.func_76134_b((float)longitude);
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
                vx = hRadius * MathHelper.func_76126_a((float)(longitude + longStep));
                vz = hRadius * MathHelper.func_76134_b((float)(longitude + longStep));
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
            }
            buffer.func_181662_b(0.0, goingUp ? (double)radius : (double)(-radius), 0.0).func_181666_a(r, g, b, a).func_181675_d();
            goingUp = !goingUp;
        }
        tessellator.func_78381_a();
    }
}

