/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import electroblob.wizardry.client.particle.ParticleTargeted;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ParticleLightning
extends ParticleTargeted {
    private static final float THICKNESS = 0.04f;
    private static final double MAX_SEGMENT_LENGTH = 0.6;
    private static final double MIN_SEGMENT_LENGTH = 0.2;
    private static final double VERTEX_JITTER = 0.15;
    private static final int MAX_FORK_SEGMENTS = 3;
    private static final float FORK_CHANCE = 0.3f;
    private static final int UPDATE_PERIOD = 1;

    public ParticleLightning(World world, double x, double y, double z) {
        super(world, x, y, z, new ResourceLocation[0]);
        this.seed = this.field_187136_p.nextLong();
        this.func_70538_b(0.2f, 0.6f, 1.0f);
        this.func_187114_a(3);
        this.field_70544_f = 1.0f;
    }

    public boolean func_187111_c() {
        return true;
    }

    @Override
    public int func_70537_b() {
        return 3;
    }

    @Override
    protected void draw(Tessellator tessellator, double length, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        boolean freeEnd = this.target == null;
        int numberOfSegments = (int)Math.round(length / 0.6);
        for (int layer = 0; layer < 3; ++layer) {
            double px = 0.0;
            double py = 0.0;
            double pz = 0.0;
            this.random.setSeed(this.seed + (long)(this.field_70546_d / 1));
            for (int i = 0; i < numberOfSegments - 1; ++i) {
                double px2 = (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                double py2 = (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                double pz2 = pz + length / (double)numberOfSegments;
                this.drawSegment(tessellator, layer, px, py, pz, px2, py2, pz2, 0.04f * this.field_70544_f);
                if (this.random.nextFloat() < 0.3f) {
                    double px3 = px;
                    double py3 = py;
                    double pz3 = pz;
                    for (int j = 0; j < this.random.nextInt(2) + 1; ++j) {
                        double px4 = px3 + (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                        double py4 = py3 + (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                        double pz4 = pz3 + 0.2 + this.random.nextDouble() * 0.39999999999999997;
                        this.drawSegment(tessellator, layer, px3, py3, pz3, px4, py4, pz4, 0.032f * this.field_70544_f);
                        if (this.random.nextFloat() < 0.3f) {
                            double px5 = px3 + (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                            double py5 = py3 + (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f;
                            double pz5 = pz3 + 0.2 + this.random.nextDouble() * 0.39999999999999997;
                            this.drawSegment(tessellator, layer, px3, py3, pz3, px5, py5, pz5, 0.024f * this.field_70544_f);
                        }
                        px3 = px4;
                        py3 = py4;
                        pz3 = pz4;
                    }
                }
                px = px2;
                py = py2;
                pz = pz2;
            }
            double px2 = freeEnd ? (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f : 0.0;
            double py2 = freeEnd ? (this.random.nextDouble() * 2.0 - 1.0) * 0.15 * (double)this.field_70544_f : 0.0;
            this.drawSegment(tessellator, layer, px, py, pz, px2, py2, length, 0.04f * this.field_70544_f);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
    }

    private void drawSegment(Tessellator tessellator, int layer, double x1, double y1, double z1, double x2, double y2, double z2, float thickness) {
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        switch (layer) {
            case 0: {
                this.drawShearedBox(buffer, x1, y1, z1, x2, y2, z2, 0.25f * thickness, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.drawShearedBox(buffer, x1, y1, z1, x2, y2, z2, 0.6f * thickness, (this.field_70552_h + 1.0f) / 2.0f, (this.field_70553_i + 1.0f) / 2.0f, (this.field_70551_j + 1.0f) / 2.0f, 0.65f);
                break;
            }
            case 2: {
                this.drawShearedBox(buffer, x1, y1, z1, x2, y2, z2, thickness, this.field_70552_h, this.field_70553_i, this.field_70551_j, 0.3f);
            }
        }
        tessellator.func_78381_a();
    }

    private void drawShearedBox(BufferBuilder buffer, double x1, double y1, double z1, double x2, double y2, double z2, float width, float r, float g, float b, float a) {
        buffer.func_181662_b(x1 - (double)width, y1 - (double)width, z1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 - (double)width, z2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 - (double)width, y1 + (double)width, z1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 + (double)width, z2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 + (double)width, y1 + (double)width, z1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 + (double)width, y2 + (double)width, z2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 + (double)width, y1 - (double)width, z1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 + (double)width, y2 - (double)width, z2).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1 - (double)width, y1 - (double)width, z1).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x2 - (double)width, y2 - (double)width, z2).func_181666_a(r, g, b, a).func_181675_d();
    }
}

