/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketControlInput;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.ContainerArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import electroblob.wizardry.util.WandHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiArcaneWorkbench
extends GuiContainer {
    private GuiButton applyBtn;
    public static final ResourceLocation texture = new ResourceLocation("ebwizardry", "textures/gui/arcane_workbench.png");
    private IInventory playerInventory;
    private IInventory arcaneWorkbenchInventory;
    private static final int TOOLTIP_WIDTH = 164;
    private static final int TOOLTIP_TEXT_INSET = 6;
    private static final int MAIN_GUI_WIDTH = 176;
    private static final int RUNE_LEFT = 38;
    private static final int RUNE_TOP = 22;
    private static final int RUNE_WIDTH = 100;
    private static final int RUNE_HEIGHT = 100;
    private static final int PROGRESSION_BAR_WIDTH = 152;
    private static final int PROGRESSION_BAR_HEIGHT = 3;
    private static final int HALO_DIAMETER = 156;
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 256;
    private int animationTimer = 0;
    private static final int ANIMATION_DURATION = 20;

    public GuiArcaneWorkbench(InventoryPlayer invPlayer, TileEntityArcaneWorkbench entity) {
        super((Container)new ContainerArcaneWorkbench((IInventory)invPlayer, entity));
        this.playerInventory = invPlayer;
        this.arcaneWorkbenchInventory = entity;
        this.field_146999_f = 176;
        this.field_147000_g = 220;
    }

    public void func_73876_c() {
        if (this.animationTimer > 0) {
            --this.animationTimer;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Slot slot = this.field_147002_h.func_75139_a(9);
        if (slot.func_75216_d() && slot.func_75211_c().func_77973_b() instanceof IWorkbenchItem && ((IWorkbenchItem)slot.func_75211_c().func_77973_b()).showTooltip(slot.func_75211_c())) {
            this.field_146999_f = 340;
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.applyBtn.field_146128_h = (this.field_146294_l - 164) / 2 + 64;
        } else {
            this.field_146999_f = 176;
            this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
            this.applyBtn.field_146128_h = this.field_146294_l / 2 + 64;
        }
        this.applyBtn.field_146124_l = slot.func_75216_d();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        DrawingUtils.drawTexturedRect(this.field_147003_i + 38, this.field_147009_r + 22, 340, 0, 100, 100, 512, 256);
        if (this.animationTimer > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int x = this.field_147003_i + 38 + 50;
            int y = this.field_147009_r + 22 + 50;
            float scale = ((float)this.animationTimer + partialTicks) / 20.0f;
            scale = (float)(1.0 - Math.pow(1.0f - scale, 1.4f));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)x / scale), (float)((float)y / scale), (float)0.0f);
            DrawingUtils.drawTexturedRect(-78, -78, 340, 100, 156, 156, 512, 256);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        DrawingUtils.drawTexturedRect(this.field_147003_i, this.field_147009_r, 0, 0, 176, this.field_147000_g, 512, 256);
        float opacity = ((float)this.animationTimer + partialTicks) / 20.0f;
        for (int i = 0; i < 8; ++i) {
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (slot.field_75223_e < 0 || slot.field_75221_f < 0) continue;
            DrawingUtils.drawTexturedRect(this.field_147003_i + slot.field_75223_e - 10, this.field_147009_r + slot.field_75221_f - 10, 0, 220, 36, 36, 512, 256);
            if (this.animationTimer <= 0 || !slot.func_75216_d()) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            DrawingUtils.drawTexturedRect(this.field_147003_i + slot.field_75223_e - 10, this.field_147009_r + slot.field_75221_f - 10, 36, 220, 36, 36, 512, 256);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (this.animationTimer > 0) {
            Slot crystals = this.field_147002_h.func_75139_a(8);
            Slot upgrades = this.field_147002_h.func_75139_a(10);
            if (crystals.func_75216_d()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_147003_i + crystals.field_75223_e - 8, this.field_147009_r + crystals.field_75221_f - 8, 440, 0, 32, 32, 512, 256);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            if (upgrades.func_75216_d()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                DrawingUtils.drawTexturedRect(this.field_147003_i + upgrades.field_75223_e - 8, this.field_147009_r + upgrades.field_75221_f - 8, 440, 0, 32, 32, 512, 256);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
        if (this.field_147002_h.func_75139_a(9).func_75216_d()) {
            ItemStack stack = this.field_147002_h.func_75139_a(9).func_75211_c();
            if (!(stack.func_77973_b() instanceof IWorkbenchItem)) {
                Wizardry.logger.warn("Invalid item in central slot of arcane workbench, how did that get there?!");
                return;
            }
            if (((IWorkbenchItem)stack.func_77973_b()).showTooltip(stack)) {
                DrawingUtils.drawTexturedRect(this.field_147003_i + 176, this.field_147009_r, 176, 0, 164, this.field_147000_g, 512, 256);
                int y = this.field_147009_r + 20;
                if (stack.func_77973_b() instanceof IManaStoringItem && ((IManaStoringItem)stack.func_77973_b()).showManaInWorkbench((EntityPlayer)this.field_146297_k.field_71439_g, stack)) {
                    y += 14;
                }
                if (stack.func_77973_b() instanceof ItemWand && !Wizardry.settings.legacyWandLevelling) {
                    y += 10;
                    Tier tier = ((ItemWand)stack.func_77973_b()).tier;
                    float progressFraction = 1.0f;
                    if (tier != Tier.MASTER) {
                        progressFraction = (float)WandHelper.getProgression(stack) / (float)Tier.values()[tier.level + 1].progression;
                    }
                    DrawingUtils.drawTexturedRect(this.field_147003_i + 176 + 6, y, 176, this.field_147000_g + 3, 152, 3, 512, 256);
                    int width = (int)(152.0f * progressFraction);
                    DrawingUtils.drawTexturedRect(this.field_147003_i + 176 + 6, y, 176, this.field_147000_g, width, 3, 512, 256);
                    y += 8;
                }
                if (stack.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).showSpellsInWorkbench((EntityPlayer)this.field_146297_k.field_71439_g, stack)) {
                    Spell[] spells = ((ISpellCastingItem)stack.func_77973_b()).getSpells(stack);
                    GlStateManager.func_179147_l();
                    for (Spell spell : spells) {
                        boolean discovered = true;
                        if (!this.field_146297_k.field_71439_g.func_184812_l_() && WizardData.get((EntityPlayer)this.field_146297_k.field_71439_g) != null) {
                            discovered = WizardData.get((EntityPlayer)this.field_146297_k.field_71439_g).hasSpellBeenDiscovered(spell);
                        }
                        Minecraft.func_71410_x().field_71446_o.func_110577_a(discovered ? spell.getElement().getIcon() : Element.MAGIC.getIcon());
                        DrawingUtils.drawTexturedRect(this.field_147003_i + 176 + 6 - 1, y, 8, 8);
                        y += 10;
                    }
                }
                GlStateManager.func_179084_k();
                int x = 0;
                y += 16;
                for (Item item : WandHelper.getSpecialUpgrades()) {
                    int level = WandHelper.getUpgradeLevel(stack, item);
                    if (level <= 0) continue;
                    ItemStack stack1 = new ItemStack(item, level);
                    GlStateManager.func_179126_j();
                    this.field_146296_j.func_180450_b(stack1, this.field_147003_i + 176 + 6 + x, y);
                    this.field_146296_j.func_180453_a(this.field_146289_q, stack1, this.field_147003_i + 176 + 6 + x, y, null);
                    x += 18;
                    GlStateManager.func_179097_i();
                }
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(this.arcaneWorkbenchInventory.func_145818_k_() ? this.arcaneWorkbenchInventory.func_70005_c_() : I18n.func_135052_a((String)this.arcaneWorkbenchInventory.func_70005_c_(), (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145818_k_() ? this.playerInventory.func_70005_c_() : I18n.func_135052_a((String)this.playerInventory.func_70005_c_(), (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (this.field_147002_h.func_75139_a(9).func_75216_d()) {
            ItemStack stack = this.field_147002_h.func_75139_a(9).func_75211_c();
            if (!(stack.func_77973_b() instanceof IWorkbenchItem)) {
                Wizardry.logger.warn("Invalid item in central slot of arcane workbench, how did that get there?!");
                return;
            }
            if (((IWorkbenchItem)stack.func_77973_b()).showTooltip(stack)) {
                int y = 6;
                this.field_146289_q.func_175063_a("\u00a7f" + stack.func_82833_r(), 182.0f, (float)y, 0);
                if (stack.func_77973_b() instanceof IManaStoringItem && ((IManaStoringItem)stack.func_77973_b()).showManaInWorkbench((EntityPlayer)this.field_146297_k.field_71439_g, stack)) {
                    this.field_146289_q.func_175063_a("\u00a77" + I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.mana", (Object[])new Object[0]) + " " + ((IManaStoringItem)stack.func_77973_b()).getMana(stack) + "/" + ((IManaStoringItem)stack.func_77973_b()).getManaCapacity(stack), 182.0f, (float)(y += 14), 0);
                }
                if (stack.func_77973_b() instanceof ItemWand && !Wizardry.settings.legacyWandLevelling) {
                    Tier tier = ((ItemWand)stack.func_77973_b()).tier;
                    this.field_146289_q.func_175063_a(tier.getDisplayNameWithFormatting(), 182.0f, (float)(y += 14), 0);
                    if (tier != Tier.MASTER) {
                        Tier nextTier = Tier.values()[tier.level + 1];
                        String s = TextFormatting.DARK_GRAY.toString() + nextTier.getDisplayName();
                        if (WandHelper.getProgression(stack) >= nextTier.progression) {
                            s = nextTier.getDisplayNameWithFormatting();
                        }
                        this.field_146289_q.func_175063_a(s, (float)(334 - this.field_146289_q.func_78256_a(s)), (float)y, 0);
                    }
                    y += 4;
                }
                y += 14;
                if (stack.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)stack.func_77973_b()).showSpellsInWorkbench((EntityPlayer)this.field_146297_k.field_71439_g, stack)) {
                    Spell[] spells = ((ISpellCastingItem)stack.func_77973_b()).getSpells(stack);
                    for (Spell spell : spells) {
                        boolean discovered = true;
                        if (!this.field_146297_k.field_71439_g.func_184812_l_() && WizardData.get((EntityPlayer)this.field_146297_k.field_71439_g) != null) {
                            discovered = WizardData.get((EntityPlayer)this.field_146297_k.field_71439_g).hasSpellBeenDiscovered(spell);
                        }
                        if (discovered) {
                            this.field_146289_q.func_175063_a(spell.getDisplayNameWithFormatting(), 192.0f, (float)y, 0);
                        } else {
                            this.field_146297_k.field_71464_q.func_175063_a("\u00a79" + SpellGlyphData.getGlyphName(spell, (World)this.field_146297_k.field_71441_e), 192.0f, (float)y, 0);
                        }
                        y += 10;
                    }
                }
                if (WandHelper.getTotalUpgrades(stack) > 0) {
                    this.field_146289_q.func_175063_a("\u00a7f" + I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.upgrades", (Object[])new Object[0]), 182.0f, (float)(y += 6), 0);
                    int x = 0;
                    y += 10;
                    for (Item item : WandHelper.getSpecialUpgrades()) {
                        int level = WandHelper.getUpgradeLevel(stack, item);
                        if (level <= 0) continue;
                        if (this.func_146978_c(182 + x, y, 16, 16, mouseX, mouseY)) {
                            ItemStack stack1 = new ItemStack(item, level);
                            this.func_146285_a(stack1, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                        }
                        x += 18;
                    }
                }
            }
        }
    }

    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.applyBtn = new GuiButtonApply(0, this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 3);
        this.field_146292_n.add(this.applyBtn);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146127_k == 0) {
            PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.APPLY_BUTTON);
            WizardryPacketHandler.net.sendToServer((IMessage)msg);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, (float)1.0f));
            this.animationTimer = 20;
        }
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_CRYSTAL);
        event.getMap().func_174942_a(ContainerArcaneWorkbench.EMPTY_SLOT_UPGRADE);
    }

    private class GuiButtonApply
    extends GuiButton {
        public GuiButtonApply(int id, int x, int y) {
            super(id, x, y, 16, 16, I18n.func_135052_a((String)"container.ebwizardry:arcane_workbench.apply", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = 72;
            int l = 220;
            if (this.field_146124_l) {
                if (this.field_146123_n) {
                    k += this.field_146120_f * 2;
                }
            } else {
                k += this.field_146120_f;
            }
            DrawingUtils.drawTexturedRect(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g, 512, 256);
        }
    }
}

