/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import xt9.deepmoblearning.common.items.ItemCreativeModelLearner;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.items.ItemDeepLearner;
import xt9.deepmoblearning.common.util.DataModel;

public class LevelUpModelMessage
implements IMessage {
    private int index;

    public LevelUpModelMessage() {
    }

    public LevelUpModelMessage(int index) {
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.index);
    }

    public static class Handler
    implements IMessageHandler<LevelUpModelMessage, IMessage> {
        public IMessage onMessage(LevelUpModelMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Item mainHand = player.func_184614_ca().func_77973_b();
            Item offHand = player.func_184592_cb().func_77973_b();
            if (mainHand instanceof ItemCreativeModelLearner || offHand instanceof ItemCreativeModelLearner) {
                player.func_71121_q().func_152344_a(() -> {
                    this.findAndLevelUpModels((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, player, message.index);
                    this.findAndLevelUpModels((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, player, message.index);
                });
            }
            return null;
        }

        public void findAndLevelUpModels(NonNullList<ItemStack> inventory, EntityPlayerMP player, int action) {
            for (ItemStack inventoryStack : inventory) {
                if (!(inventoryStack.func_77973_b() instanceof ItemDeepLearner)) continue;
                NonNullList<ItemStack> deepLearnerInternalInv = ItemDeepLearner.getContainedItems(inventoryStack);
                for (ItemStack stack : deepLearnerInternalInv) {
                    int tier;
                    if (stack.func_77973_b() instanceof ItemDataModel && (tier = DataModel.getTier(stack)) != 4) {
                        if (action == 0) {
                            DataModel.setTier(stack, tier + 1);
                        } else {
                            DataModel.increaseMobKillCount(stack, player);
                        }
                    }
                    ItemDeepLearner.setContainedItems(inventoryStack, deepLearnerInternalInv);
                }
            }
        }
    }
}

