/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lnet/ndrei/teslacorelib/utils/FluidUtils;", "", "()V", "canDrainInto", "", "tank", "Lnet/minecraftforge/fluids/IFluidTank;", "bucket", "Lnet/minecraft/item/ItemStack;", "canFillFrom", "target", "source", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "drainInto", "fillFluidFrom", "tesla-core-lib"})
public final class FluidUtils {
    public static final FluidUtils INSTANCE;

    public final boolean canFillFrom(@NotNull IFluidTank target, @NotNull IFluidTankProperties source) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        FluidStack fluidStack = source.getContents();
        if (fluidStack == null) {
            return false;
        }
        FluidStack fluid = fluidStack;
        return fluid.amount > 0 && source.canDrainFluidType(fluid) && 0 < target.fill(fluid, false);
    }

    public final boolean canFillFrom(@NotNull IFluidTank tank2, @NotNull ItemStack bucket) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        if (!bucket.func_190926_b() && bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            boolean bl;
            IFluidHandlerItem handler;
            block5: {
                IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (iFluidHandlerItem == null) {
                    return false;
                }
                IFluidHandlerItem iFluidHandlerItem2 = handler = iFluidHandlerItem;
                Intrinsics.checkExpressionValueIsNotNull((Object)iFluidHandlerItem2, (String)"handler");
                IFluidTankProperties[] iFluidTankPropertiesArray = iFluidHandlerItem2.getTankProperties();
                Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankPropertiesArray, (String)"handler.tankProperties");
                IFluidTankProperties[] $receiver$iv = iFluidTankPropertiesArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    IFluidTankProperties element$iv;
                    IFluidTankProperties it;
                    IFluidTankProperties iFluidTankProperties = it = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankProperties, (String)"it");
                    if (!INSTANCE.canFillFrom(tank2, iFluidTankProperties)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            FluidStack fluidStack = handler.drain(1000, false);
            if (fluidStack == null) {
                return false;
            }
            FluidStack drained = fluidStack;
            return drained.amount > 0 && tank2.fill(drained, false) > 0;
        }
        return false;
    }

    @NotNull
    public final ItemStack fillFluidFrom(@NotNull IFluidTank tank2, @NotNull ItemStack bucket) {
        ItemStack clone;
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        ItemStack itemStack = clone = bucket.func_77946_l();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"clone");
        if (!itemStack.func_190926_b() && clone.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidTankProperties result;
            IFluidHandlerItem handler;
            block20: {
                IFluidTankProperties iFluidTankProperties;
                IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)clone.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (iFluidHandlerItem == null) {
                    return bucket;
                }
                IFluidHandlerItem iFluidHandlerItem2 = handler = iFluidHandlerItem;
                Intrinsics.checkExpressionValueIsNotNull((Object)iFluidHandlerItem2, (String)"handler");
                IFluidTankProperties[] iFluidTankPropertiesArray = iFluidHandlerItem2.getTankProperties();
                Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankPropertiesArray, (String)"handler.tankProperties");
                IFluidTankProperties[] $receiver$iv = iFluidTankPropertiesArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    IFluidTankProperties element$iv;
                    IFluidTankProperties it;
                    IFluidTankProperties iFluidTankProperties2 = it = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankProperties2, (String)"it");
                    if (!INSTANCE.canFillFrom(tank2, iFluidTankProperties2)) continue;
                    iFluidTankProperties = element$iv;
                    break block20;
                }
                iFluidTankProperties = result = null;
            }
            if (result != null && result.getContents() != null) {
                int filled;
                FluidStack fluidStack = result.getContents();
                if (fluidStack == null) {
                    Intrinsics.throwNpe();
                }
                int amount = Math.min(1000, fluidStack.amount);
                FluidStack fluidStack2 = result.getContents();
                if (fluidStack2 == null) {
                    Intrinsics.throwNpe();
                }
                FluidStack fluidStack3 = handler.drain(new FluidStack(fluidStack2, amount), false);
                if (fluidStack3 == null) {
                    return bucket;
                }
                FluidStack drained = fluidStack3;
                if (drained.amount > 0 && (filled = tank2.fill(drained, false)) > 0) {
                    if (filled != drained.amount) {
                        FluidStack fluidStack4 = result.getContents();
                        if (fluidStack4 == null) {
                            Intrinsics.throwNpe();
                        }
                        FluidStack fluidStack5 = handler.drain(new FluidStack(fluidStack4, filled), false);
                        if (fluidStack5 == null) {
                            return bucket;
                        }
                        drained = fluidStack5;
                    }
                    if (drained.amount == filled) {
                        FluidStack fluidStack6 = result.getContents();
                        if (fluidStack6 == null) {
                            Intrinsics.throwNpe();
                        }
                        tank2.fill(handler.drain(new FluidStack(fluidStack6, filled), true), true);
                        ItemStack itemStack2 = handler.getContainer();
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"handler.container");
                        return itemStack2;
                    }
                }
            } else {
                int filled;
                FluidStack fluidStack = handler.drain(1000, false);
                if (fluidStack == null) {
                    return bucket;
                }
                FluidStack drained = fluidStack;
                if (drained.amount > 0 && (filled = tank2.fill(drained, false)) > 0) {
                    int toMove;
                    int n;
                    if (filled != drained.amount) {
                        FluidStack fluidStack7 = handler.drain(filled, false);
                        if (fluidStack7 == null) {
                            return bucket;
                        }
                        n = fluidStack7.amount;
                    } else {
                        n = toMove = filled;
                    }
                    if (toMove > 0) {
                        tank2.fill(handler.drain(toMove, true), true);
                        ItemStack itemStack3 = handler.getContainer();
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"handler.container");
                        return itemStack3;
                    }
                }
            }
        }
        return bucket;
    }

    public final boolean canDrainInto(@NotNull IFluidTank tank2, @NotNull ItemStack bucket) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        if (!bucket.func_190926_b() && bucket.func_190916_E() == 1 && bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (iFluidHandlerItem == null) {
                return false;
            }
            IFluidHandlerItem handler = iFluidHandlerItem;
            FluidStack fluidStack = tank2.getFluid();
            if (fluidStack == null) {
                return false;
            }
            int filled = handler.fill(fluidStack, false);
            if (filled > 0) {
                FluidStack drained = tank2.drain(filled, false);
                return drained != null && drained.amount == filled;
            }
        }
        return false;
    }

    @NotNull
    public final ItemStack drainInto(@NotNull IFluidTank tank2, @NotNull ItemStack bucket) {
        Intrinsics.checkParameterIsNotNull((Object)tank2, (String)"tank");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        if (bucket.func_190926_b() || bucket.func_190916_E() > 1) {
            return bucket;
        }
        if (bucket.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            FluidStack fluidStack;
            FluidStack it;
            IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)bucket.func_77946_l().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (iFluidHandlerItem == null) {
                return bucket;
            }
            IFluidHandlerItem handler = iFluidHandlerItem;
            FluidStack fluidStack2 = tank2.getFluid();
            if (fluidStack2 == null) {
                return bucket;
            }
            FluidStack fluidStack3 = it = (fluidStack = fluidStack2);
            Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack3, (String)"it");
            FluidStack fluid = new FluidStack(fluidStack3.getFluid(), Math.min(it.amount, 1000));
            int filled = handler.fill(fluid, false);
            if (filled > 0) {
                FluidStack drained;
                FluidStack fluidStack4 = drained = tank2.drain(filled, false);
                if (filled == (fluidStack4 != null ? fluidStack4.amount : 0)) {
                    handler.fill(fluid, true);
                    tank2.drain(filled, true);
                    IFluidHandlerItem iFluidHandlerItem2 = handler;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iFluidHandlerItem2, (String)"handler");
                    ItemStack itemStack = iFluidHandlerItem2.getContainer();
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"handler.container");
                    return itemStack;
                }
            }
        }
        return bucket;
    }

    private FluidUtils() {
    }

    static {
        FluidUtils fluidUtils;
        INSTANCE = fluidUtils = new FluidUtils();
    }
}

