/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismFluids;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHohlraum
extends ItemMekanism
implements IGasItem {
    public static final int MAX_GAS = 10;
    public static final int TRANSFER_RATE = 1;

    public ItemHohlraum() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize((String)"tooltip.noGas") + ".");
            list.add(EnumColor.DARK_RED + LangUtils.localize((String)"tooltip.insufficientFuel"));
        } else {
            list.add(LangUtils.localize((String)"tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
            if (gasStack.amount == this.getMaxGas(itemstack)) {
                list.add(EnumColor.DARK_GREEN + LangUtils.localize((String)"tooltip.readyForReaction") + "!");
            } else {
                list.add(EnumColor.DARK_RED + LangUtils.localize((String)"tooltip.insufficientFuel"));
            }
        }
    }

    public int getMaxGas(ItemStack itemstack) {
        return 10;
    }

    public int getRate(ItemStack itemstack) {
        return 1;
    }

    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != MekanismFluids.FusionFuel) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == MekanismFluids.FusionFuel;
    }

    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT((NBTTagCompound)ItemDataUtils.getCompound((ItemStack)itemstack, (String)"stored"));
    }

    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData((ItemStack)itemstack, (String)"stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound((ItemStack)itemstack, (String)"stored", (NBTTagCompound)gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack stack = new ItemStack((Item)this);
        this.setGas(stack, null);
        return stack;
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        list.add((Object)empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(MekanismFluids.FusionFuel, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add((Object)filled);
    }
}

