/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.features;

import com.google.common.collect.Maps;
import doggytalents.api.feature.IStatsFeature;
import doggytalents.entity.EntityDog;
import doggytalents.entity.features.DogFeature;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DogStats
extends DogFeature
implements IStatsFeature {
    private Map<EntityEntry, Integer> ENTITY_KILLS = Maps.newHashMap();
    private double damageDealt = 0.0;

    public DogStats(EntityDog dogIn) {
        super(dogIn);
    }

    @Override
    public void writeAdditional(NBTTagCompound compound) {
        NBTTagList killList = new NBTTagList();
        for (Map.Entry<EntityEntry, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            NBTTagCompound stats = new NBTTagCompound();
            stats.func_74778_a("type", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entry.getKey()).toString());
            stats.func_74768_a("count", entry.getValue().intValue());
            killList.func_74742_a((NBTBase)stats);
        }
        compound.func_74782_a("entityKills", (NBTBase)killList);
        compound.func_74780_a("damageDealt", this.damageDealt);
    }

    @Override
    public void readAdditional(NBTTagCompound compound) {
        NBTTagList killList = compound.func_150295_c("entityKills", 10);
        for (int i = 0; i < killList.func_74745_c(); ++i) {
            NBTTagCompound stats = killList.func_150305_b(i);
            ResourceLocation typeLoc = new ResourceLocation(stats.func_74779_i("type"));
            if (!ForgeRegistries.ENTITIES.containsKey(typeLoc)) continue;
            this.ENTITY_KILLS.put((EntityEntry)ForgeRegistries.ENTITIES.getValue(typeLoc), stats.func_74762_e("count"));
        }
        this.damageDealt = compound.func_74769_h("damageDealt");
    }

    @Override
    public void tick() {
    }

    @Override
    public int getKillCountFor(EntityEntry type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    @Override
    public int getTotalKillCount() {
        int total = 0;
        for (Map.Entry<EntityEntry, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public void incrementKillCount(Entity entity) {
        EntityEntry entityEntry = (EntityEntry)GameData.getEntityClassMap().get(entity.getClass());
        if (entityEntry != null) {
            this.incrementKillCount(entityEntry);
        }
    }

    private void incrementKillCount(EntityEntry type) {
        this.ENTITY_KILLS.put(type, this.getKillCountFor(type) + 1);
    }

    public void increaseDamageDealt(double damage) {
        this.damageDealt += damage;
    }
}

