/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.api.inferface.IBedMaterial;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BedMaterial
implements IBedMaterial {
    @Nullable
    private String translationKey;
    public ResourceLocation key;
    public int meta;
    public String texture;
    public Ingredient ingredients;
    public String regName;

    public BedMaterial(ResourceLocation key, int meta, ResourceLocation texture, Ingredient ingredients) {
        this.key = key;
        this.meta = meta;
        this.texture = texture.toString();
        this.ingredients = ingredients;
    }

    public BedMaterial(Block block, int meta, ResourceLocation texture, Ingredient ingredients) {
        this(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block), meta, texture, ingredients);
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredients;
    }

    @Override
    public ITextComponent getTooltip() {
        if (this.translationKey == null) {
            this.translationKey = BedMaterial.makeTranslationKey("dogbed." + this.regName, this.key) + "." + this.meta;
        }
        return new TextComponentTranslation(this.translationKey, new Object[0]);
    }

    public static String makeTranslationKey(String type, @Nullable ResourceLocation id) {
        return id == null ? type + ".unregistered_sadface" : type + '.' + id.func_110624_b() + '.' + id.func_110623_a().replace('/', '.');
    }

    @Override
    public String getSaveId() {
        return this.key.toString() + "." + this.meta;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BedMaterial)) {
            return false;
        }
        BedMaterial other = (BedMaterial)o;
        return other.getSaveId().equals(this.getSaveId());
    }

    public int hashCode() {
        return this.getSaveId().hashCode();
    }

    @Override
    public BedMaterial setRegName(String regName) {
        this.regName = regName;
        return this;
    }
}

