/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.utilities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;

public abstract class BlockStateMatcher {
    protected String propertyName;

    public static BlockStateMatcher create(String name, String ... strings) {
        return new BlockStateMatcherList(name, strings);
    }

    public static BlockStateMatcher create(String name, LootHelper.RangeFloat range) {
        return new BlockStateMatcherRange(name, range);
    }

    public static BlockStateMatcher[] deserialize(JsonObject jsonParent, String name) {
        JsonObject json = JsonUtils.func_152754_s((JsonObject)jsonParent, (String)name);
        ArrayList<BlockStateMatcher> states = new ArrayList<BlockStateMatcher>();
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                LootHelper.RangeFloat range = LootHelper.deserializeRangeFloat(json, (String)entry.getKey());
                states.add(new BlockStateMatcherRange((String)entry.getKey(), range));
                continue;
            }
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                String string = BlockStateMatcher.getStringFromPrimitive(primitive);
                if (string == null) continue;
                states.add(new BlockStateMatcherList((String)entry.getKey(), string));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
            JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
            ArrayList strings = new ArrayList();
            array.forEach(jsonElement -> {
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
                    String string = BlockStateMatcher.getStringFromPrimitive(primitive);
                    if (string != null) {
                        strings.add(string);
                    }
                } else {
                    throw new JsonSyntaxException("Expected '" + (String)entry.getKey() + "' array to only contain json primitives.");
                }
            });
            if (strings.isEmpty()) continue;
            states.add(new BlockStateMatcherList((String)entry.getKey(), strings.toArray(new String[0])));
        }
        return states.toArray(new BlockStateMatcher[0]);
    }

    @Nullable
    public static String getStringFromPrimitive(JsonPrimitive primitive) {
        String primitiveString = null;
        if (primitive.isBoolean()) {
            primitiveString = String.valueOf(primitive.getAsBoolean());
        }
        if (primitive.isString()) {
            primitiveString = primitive.getAsString();
        }
        if (primitive.isNumber()) {
            primitiveString = String.valueOf(primitive.getAsNumber());
        }
        return primitiveString;
    }

    public static void serialize(BlockStateMatcher[] states, JsonObject jsonParent, String name) {
        JsonObject json = new JsonObject();
        for (BlockStateMatcher state : states) {
            if (state instanceof BlockStateMatcherRange) {
                BlockStateMatcherRange stateRange = (BlockStateMatcherRange)state;
                stateRange.possibleValueRange.serialize(json, state.propertyName);
            }
            if (!(state instanceof BlockStateMatcherList)) continue;
            BlockStateMatcherList stateList = (BlockStateMatcherList)state;
            if (stateList.possibleValueList.length == 1) {
                json.addProperty(state.propertyName, String.valueOf(stateList.possibleValueList[0]));
                continue;
            }
            JsonArray jsonArray = new JsonArray();
            for (String string : stateList.possibleValueList) {
                jsonArray.add(string);
            }
            json.add(state.propertyName, (JsonElement)jsonArray);
        }
        jsonParent.add(name, (JsonElement)json);
    }

    public abstract boolean matches(IBlockState var1);

    public static class BlockStateMatcherRange
    extends BlockStateMatcher {
        public LootHelper.RangeFloat possibleValueRange;

        public BlockStateMatcherRange(String name, LootHelper.RangeFloat range) {
            this.propertyName = name;
            this.possibleValueRange = range;
        }

        @Override
        public boolean matches(IBlockState state) {
            for (IProperty property : state.func_177227_a()) {
                Comparable value = (Comparable)state.func_177228_b().get((Object)property);
                if (!this.propertyName.equals(property.func_177701_a())) continue;
                if (value instanceof Integer && this.possibleValueRange.isInRange(Float.valueOf(((Integer)value).intValue()))) {
                    return true;
                }
                if (!(value instanceof Float) || !this.possibleValueRange.isInRange((Float)value)) continue;
                return true;
            }
            return false;
        }
    }

    public static class BlockStateMatcherList
    extends BlockStateMatcher {
        public String[] possibleValueList;

        public BlockStateMatcherList(String name, String ... comparables) {
            this.propertyName = name;
            this.possibleValueList = comparables;
        }

        @Override
        public boolean matches(IBlockState state) {
            for (IProperty property : state.func_177227_a()) {
                Comparable value = (Comparable)state.func_177228_b().get((Object)property);
                if (!this.propertyName.equals(property.func_177701_a())) continue;
                for (String possibleValue : this.possibleValueList) {
                    if (!possibleValue.equals(property.func_177702_a(value))) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

