/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.items.ItemLoot;
import com.tmtravlr.lootoverhaul.loot.LootContextExtended;
import com.tmtravlr.lootoverhaul.loot.LootHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FunctionPosition
extends LootFunction {
    private LootContextExtended.ExtendedEntityTarget target;
    private String selector;
    private Double posX;
    private Double posY;
    private Double posZ;

    public FunctionPosition(LootCondition[] conditions, LootContextExtended.ExtendedEntityTarget target, String selector, Double posX, Double posY, Double posZ) {
        super(conditions);
        this.target = target;
        this.selector = selector;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (!(stack.func_77973_b() instanceof ItemLoot)) {
            stack = ItemLoot.createStackFromItem(stack);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound positionTag = new NBTTagCompound();
        if (this.target != null) {
            Entity targetEntity = LootHelper.getEntityFromContext(context, this.target);
            if (targetEntity != null) {
                positionTag.func_74778_a("Entity", targetEntity.func_110124_au().toString());
            }
        } else if (this.selector != null) {
            positionTag.func_74778_a("Entity", this.selector);
        }
        if (this.posX != null) {
            positionTag.func_74780_a("X", this.posX.doubleValue());
        }
        if (this.posY != null) {
            positionTag.func_74780_a("Y", this.posY.doubleValue());
        }
        if (this.posZ != null) {
            positionTag.func_74780_a("Z", this.posZ.doubleValue());
        }
        stack.func_77978_p().func_74782_a("Position", (NBTBase)positionTag);
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionPosition> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "position"), FunctionPosition.class);
        }

        public void serialize(JsonObject json, FunctionPosition value, JsonSerializationContext serializationContext) {
            if (value.target != null) {
                LootHelper.serializeExtendedEntityTarget(json, "entity", value.target);
            }
            if (value.selector != null) {
                json.addProperty("selector", value.selector);
            }
            if (value.posX != null) {
                json.addProperty("x", (Number)value.posX);
            }
            if (value.posY != null) {
                json.addProperty("y", (Number)value.posY);
            }
            if (value.posZ != null) {
                json.addProperty("z", (Number)value.posZ);
            }
        }

        public FunctionPosition deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            LootContextExtended.ExtendedEntityTarget target = null;
            String selector = null;
            Double posX = null;
            Double posY = null;
            Double posZ = null;
            if (json.has("target") && (target = LootHelper.deserializeExtendedEntityTargetOrNull(json, "target")) == null) {
                selector = JsonUtils.func_151200_h((JsonObject)json, (String)"target");
            }
            if (json.has("x")) {
                posX = JsonUtils.func_151217_k((JsonObject)json, (String)"x");
            }
            if (json.has("y")) {
                posY = JsonUtils.func_151217_k((JsonObject)json, (String)"y");
            }
            if (json.has("z")) {
                posZ = JsonUtils.func_151217_k((JsonObject)json, (String)"z");
            }
            return new FunctionPosition(conditionsIn, target, selector, posX, posY, posZ);
        }
    }
}

