/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tmtravlr.lootoverhaul.items.ItemLoot;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FunctionOffset
extends LootFunction {
    private RandomValueRange offsetX;
    private RandomValueRange offsetY;
    private RandomValueRange offsetZ;
    private RandomValueRange offsetRadius;
    private int surfaceSearchMax;

    public FunctionOffset(LootCondition[] conditions, RandomValueRange offsetX, RandomValueRange offsetY, RandomValueRange offsetZ, RandomValueRange offsetRadius, int surfaceSearchMax) {
        super(conditions);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.offsetRadius = offsetRadius;
        this.surfaceSearchMax = surfaceSearchMax;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (!(stack.func_77973_b() instanceof ItemLoot)) {
            stack = ItemLoot.createStackFromItem(stack);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound offsetTag = new NBTTagCompound().func_74775_l("Offset");
        if (this.offsetX != null) {
            offsetTag.func_74780_a("X", offsetTag.func_74769_h("X") + (double)this.offsetX.func_186507_b(rand));
        }
        if (this.offsetY != null) {
            offsetTag.func_74780_a("Y", offsetTag.func_74769_h("Y") + (double)this.offsetY.func_186507_b(rand));
        }
        if (this.offsetZ != null) {
            offsetTag.func_74780_a("Z", offsetTag.func_74769_h("Z") + (double)this.offsetZ.func_186507_b(rand));
        }
        if (this.offsetRadius != null) {
            offsetTag.func_74780_a("Radius", offsetTag.func_74769_h("Radius") + (double)this.offsetRadius.func_186507_b(rand));
        }
        if (this.surfaceSearchMax >= 0) {
            offsetTag.func_74768_a("SurfaceSearch", this.surfaceSearchMax);
        }
        stack.func_77978_p().func_74782_a("Offset", (NBTBase)offsetTag);
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionOffset> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "offset"), FunctionOffset.class);
        }

        public void serialize(JsonObject json, FunctionOffset value, JsonSerializationContext serializationContext) {
            if (value.offsetX != null) {
                json.add("x", serializationContext.serialize((Object)value.offsetX));
            }
            if (value.offsetY != null) {
                json.add("y", serializationContext.serialize((Object)value.offsetY));
            }
            if (value.offsetZ != null) {
                json.add("z", serializationContext.serialize((Object)value.offsetZ));
            }
            if (value.offsetRadius != null) {
                json.add("radius", serializationContext.serialize((Object)value.offsetRadius));
            }
            if (value.surfaceSearchMax >= 0) {
                json.addProperty("surface_search_max", (Number)value.surfaceSearchMax);
            }
        }

        public FunctionOffset deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            RandomValueRange posX = null;
            RandomValueRange posY = null;
            RandomValueRange posZ = null;
            RandomValueRange radius = null;
            int surfaceSearchMax = JsonUtils.func_151208_a((JsonObject)json, (String)"surface_search_max", (int)-1);
            if (json.has("x")) {
                posX = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"x", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            if (json.has("y")) {
                posY = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"y", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            if (json.has("z")) {
                posZ = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"z", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            if (json.has("radius")) {
                radius = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"radius", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            return new FunctionOffset(conditionsIn, posX, posY, posZ, radius, surfaceSearchMax);
        }
    }
}

