/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

public class FunctionGroup
extends LootFunction {
    private List<LootFunction> functions;
    private RandomValueRange numberToApply;

    public FunctionGroup(LootCondition[] conditionsIn, List<LootFunction> functions, RandomValueRange numberToApply) {
        super(conditionsIn);
        this.functions = functions;
        this.numberToApply = numberToApply;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int numToApply = this.functions.size();
        if (this.numberToApply != null) {
            numToApply = this.numberToApply.func_186511_a(rand);
        }
        numToApply = MathHelper.func_76125_a((int)numToApply, (int)0, (int)this.functions.size());
        int numToRemove = this.functions.size() - numToApply;
        LinkedList<LootFunction> functionsToApply = new LinkedList<LootFunction>(this.functions);
        for (int i = 0; i < numToRemove; ++i) {
            int toRemove = rand.nextInt(functionsToApply.size());
            functionsToApply.remove(toRemove);
        }
        for (LootFunction function : functionsToApply) {
            stack = function.func_186553_a(stack, rand, context);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionGroup> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "function_group"), FunctionGroup.class);
        }

        public void serialize(JsonObject json, FunctionGroup value, JsonSerializationContext serializationContext) {
            JsonArray functionArray = new JsonArray();
            for (LootFunction function : value.functions) {
                JsonObject functionObject = new JsonObject();
                LootFunctionManager.func_186581_a((LootFunction)function).func_186532_a(functionObject, function, serializationContext);
                functionArray.add((JsonElement)functionObject);
            }
            if (value.numberToApply != null) {
                json.add("number_to_apply", serializationContext.serialize((Object)value.numberToApply));
            }
            json.add("functions", (JsonElement)functionArray);
        }

        public FunctionGroup deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            JsonArray functionArray = JsonUtils.func_151214_t((JsonObject)json, (String)"functions");
            ArrayList<LootFunction> functions = new ArrayList<LootFunction>();
            RandomValueRange numberToApply = null;
            functionArray.forEach(functionObject -> functions.add(LootFunctionManager.func_186583_a((ResourceLocation)new ResourceLocation(JsonUtils.func_151200_h((JsonObject)functionObject.getAsJsonObject(), (String)"function"))).func_186530_b(functionObject.getAsJsonObject(), deserializationContext, conditionsIn)));
            if (json.has("number_to_apply")) {
                numberToApply = (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"number_to_apply", (JsonDeserializationContext)deserializationContext, RandomValueRange.class);
            }
            return new FunctionGroup(conditionsIn, functions, numberToApply);
        }
    }
}

