/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FunctionEnchantments
extends LootFunction {
    private List<EnchantmentDetails> details;
    private String replace;
    private RandomValueRange numberToGenerate;

    public FunctionEnchantments(LootCondition[] conditionsIn, List<EnchantmentDetails> enchantmentDetails, String replace, RandomValueRange numberToGenerate) {
        super(conditionsIn);
        this.details = enchantmentDetails;
        this.replace = replace;
        this.numberToGenerate = numberToGenerate;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int numToRemove = this.details.size() - MathHelper.func_76125_a((int)this.numberToGenerate.func_186511_a(rand), (int)1, (int)this.details.size());
        ArrayList<EnchantmentDetails> enchantmentsToGenerate = new ArrayList<EnchantmentDetails>(this.details);
        for (int i = 0; i < numToRemove; ++i) {
            enchantmentsToGenerate.remove(rand.nextInt(enchantmentsToGenerate.size()));
        }
        Map<Enchantment, Integer> enchantmentMap = enchantmentsToGenerate.stream().filter(details -> Enchantment.func_180305_b((String)((EnchantmentDetails)details).name) != null).collect(Collectors.toMap(details -> Enchantment.func_180305_b((String)((EnchantmentDetails)details).name), details -> ((EnchantmentDetails)details).level.func_186511_a(rand)));
        if (this.replace.isEmpty()) {
            Map stackEnchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            stackEnchantments.putAll(enchantmentMap);
            EnchantmentHelper.func_82782_a((Map)stackEnchantments, (ItemStack)stack);
        } else if (stack.func_77942_o()) {
            String enchantmnetsString = "[";
            StringJoiner enchantmentJoiner = new StringJoiner(",");
            enchantmentMap.forEach((ench, level) -> enchantmentJoiner.add("{id:" + Enchantment.func_185258_b((Enchantment)ench) + ", lvl:" + level + "}"));
            enchantmnetsString = enchantmnetsString + enchantmentJoiner.toString() + "]";
            String tagString = stack.func_77978_p().toString();
            if (!this.replace.equals(enchantmnetsString)) {
                tagString = tagString.replace(this.replace, enchantmnetsString);
            }
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tagString));
            }
            catch (NBTException e) {
                LootOverhaul.logger.warn("Unable to generate loot enchantments.", (Throwable)e);
            }
        }
        return stack;
    }

    private static class EnchantmentDetails {
        private String name;
        private RandomValueRange level;

        private EnchantmentDetails(String enchantmentName, RandomValueRange enchantmentLevel) {
            this.name = enchantmentName;
            this.level = enchantmentLevel;
        }

        private JsonObject serialize(JsonSerializationContext serializationContext) {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.name);
            json.add("level", serializationContext.serialize((Object)this.level));
            return json;
        }

        private static EnchantmentDetails deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
            RandomValueRange level = json.has("level") ? (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"level", (JsonDeserializationContext)deserializationContext, RandomValueRange.class) : new RandomValueRange(1.0f);
            return new EnchantmentDetails(name, level);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionEnchantments> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "enchantments"), FunctionEnchantments.class);
        }

        public void serialize(JsonObject json, FunctionEnchantments value, JsonSerializationContext serializationContext) {
            if (value.details.size() == 1) {
                json.add("enchantment", (JsonElement)((EnchantmentDetails)value.details.get(0)).serialize(serializationContext));
            } else {
                JsonArray jsonArray = new JsonArray();
                value.details.forEach(detail -> jsonArray.add((JsonElement)((EnchantmentDetails)detail).serialize(serializationContext)));
                json.add("enchantment", (JsonElement)jsonArray);
            }
            json.add("number_to_generate", serializationContext.serialize((Object)value.numberToGenerate));
            if (!value.replace.isEmpty()) {
                json.addProperty("replace", value.replace);
            }
        }

        public FunctionEnchantments deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            ArrayList<EnchantmentDetails> enchantments = new ArrayList<EnchantmentDetails>();
            String replace = JsonUtils.func_151219_a((JsonObject)json, (String)"replace", (String)"");
            if (JsonUtils.func_151202_d((JsonObject)json, (String)"enchantment")) {
                JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)"enchantment");
                jsonArray.forEach(element -> enchantments.add(EnchantmentDetails.deserialize(JsonUtils.func_151210_l((JsonElement)element, (String)"member of enchantment"), deserializationContext, conditionsIn)));
                if (enchantments.size() == 0) {
                    throw new JsonSyntaxException("At least one enchantment is required");
                }
            } else {
                enchantments.add(EnchantmentDetails.deserialize(JsonUtils.func_152754_s((JsonObject)json, (String)"enchantment"), deserializationContext, conditionsIn));
            }
            RandomValueRange numberToGenerate = json.has("number_to_generate") ? (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"number_to_generate", (JsonDeserializationContext)deserializationContext, RandomValueRange.class) : new RandomValueRange(1.0f);
            return new FunctionEnchantments(conditionsIn, enchantments, replace, numberToGenerate);
        }
    }
}

