/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootoverhaul.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.lootoverhaul.LootOverhaul;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class FunctionCustomPotionEffects
extends LootFunction {
    private List<PotionEffectDetails> details;
    private String replace;
    private RandomValueRange numberToGenerate;

    public FunctionCustomPotionEffects(LootCondition[] conditionsIn, List<PotionEffectDetails> details, String replace, RandomValueRange numberToGenerate) {
        super(conditionsIn);
        this.details = details;
        this.replace = replace;
        this.numberToGenerate = numberToGenerate;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int numToRemove = this.details.size() - MathHelper.func_76125_a((int)this.numberToGenerate.func_186511_a(rand), (int)1, (int)this.details.size());
        ArrayList<PotionEffectDetails> effectsToGenerate = new ArrayList<PotionEffectDetails>(this.details);
        for (int i = 0; i < numToRemove; ++i) {
            effectsToGenerate.remove(rand.nextInt(effectsToGenerate.size()));
        }
        List<PotionEffect> effects = effectsToGenerate.stream().filter(details -> Potion.func_180142_b((String)((PotionEffectDetails)details).name) != null).map(details -> new PotionEffect(Potion.func_180142_b((String)((PotionEffectDetails)details).name), ((PotionEffectDetails)details).duration.func_186511_a(rand), ((PotionEffectDetails)details).amplifier.func_186511_a(rand), ((PotionEffectDetails)details).isAmbient, !((PotionEffectDetails)details).hideParticles)).collect(Collectors.toList());
        if (this.replace.isEmpty()) {
            PotionUtils.func_185184_a((ItemStack)stack, effects);
        } else if (stack.func_77942_o()) {
            String customPotionEffectsString = "[";
            StringJoiner effectJoiner = new StringJoiner(",");
            effects.forEach(effect -> {
                NBTTagCompound effectTag = effect.func_82719_a(new NBTTagCompound());
                if (effectTag.func_74764_b("CurativeItems")) {
                    effectTag.func_82580_o("CurativeItems");
                }
                effectJoiner.add(effectTag.toString());
            });
            customPotionEffectsString = customPotionEffectsString + effectJoiner.toString() + "]";
            String tagString = stack.func_77978_p().toString();
            if (!this.replace.equals(customPotionEffectsString)) {
                tagString = tagString.replace(this.replace, customPotionEffectsString);
            }
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tagString));
            }
            catch (NBTException e) {
                LootOverhaul.logger.warn("Unable to generate loot potion effects.", (Throwable)e);
            }
        }
        return stack;
    }

    private static class PotionEffectDetails {
        private String name;
        private RandomValueRange duration;
        private RandomValueRange amplifier;
        private boolean isAmbient;
        private boolean hideParticles;

        private PotionEffectDetails(String potionName, RandomValueRange potionDuration, RandomValueRange potionAmplifier, boolean isAmbient, boolean hideParticles) {
            this.name = potionName;
            this.duration = potionDuration;
            this.amplifier = potionAmplifier;
            this.isAmbient = isAmbient;
            this.hideParticles = hideParticles;
        }

        private JsonObject serialize(JsonSerializationContext serializationContext) {
            JsonObject json = new JsonObject();
            json.addProperty("name", this.name);
            json.addProperty("is_ambient", Boolean.valueOf(this.isAmbient));
            json.addProperty("hide_particles", Boolean.valueOf(this.hideParticles));
            json.add("duration", serializationContext.serialize((Object)this.duration));
            json.add("amplifier", serializationContext.serialize((Object)this.amplifier));
            return json;
        }

        private static PotionEffectDetails deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"name");
            boolean isAmbient = JsonUtils.func_151209_a((JsonObject)json, (String)"is_ambient", (boolean)false);
            boolean hideParticles = JsonUtils.func_151209_a((JsonObject)json, (String)"hide_particles", (boolean)false);
            RandomValueRange duration = json.has("duration") ? (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"duration", (JsonDeserializationContext)deserializationContext, RandomValueRange.class) : new RandomValueRange(1.0f);
            RandomValueRange amplifier = json.has("amplifier") ? (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"amplifier", (JsonDeserializationContext)deserializationContext, RandomValueRange.class) : new RandomValueRange(0.0f);
            return new PotionEffectDetails(name, duration, amplifier, isAmbient, hideParticles);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<FunctionCustomPotionEffects> {
        public Serializer() {
            super(new ResourceLocation("lootoverhaul", "custom_potion_effects"), FunctionCustomPotionEffects.class);
        }

        public void serialize(JsonObject json, FunctionCustomPotionEffects value, JsonSerializationContext serializationContext) {
            if (value.details.size() == 1) {
                json.add("potion", (JsonElement)((PotionEffectDetails)value.details.get(0)).serialize(serializationContext));
            } else {
                JsonArray jsonArray = new JsonArray();
                value.details.forEach(detail -> jsonArray.add((JsonElement)((PotionEffectDetails)detail).serialize(serializationContext)));
                json.add("potion", (JsonElement)jsonArray);
            }
            json.add("number_to_generate", serializationContext.serialize((Object)value.numberToGenerate));
            if (!value.replace.isEmpty()) {
                json.addProperty("replace", value.replace);
            }
        }

        public FunctionCustomPotionEffects deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            ArrayList<PotionEffectDetails> potions = new ArrayList<PotionEffectDetails>();
            String replace = JsonUtils.func_151219_a((JsonObject)json, (String)"replace", (String)"");
            if (JsonUtils.func_151202_d((JsonObject)json, (String)"potion")) {
                JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)"potion");
                jsonArray.forEach(element -> potions.add(PotionEffectDetails.deserialize(JsonUtils.func_151210_l((JsonElement)element, (String)"member of potion"), deserializationContext, conditionsIn)));
                if (potions.size() == 0) {
                    throw new JsonSyntaxException("At least one potion effect is required");
                }
            } else {
                potions.add(PotionEffectDetails.deserialize(JsonUtils.func_152754_s((JsonObject)json, (String)"potion"), deserializationContext, conditionsIn));
            }
            RandomValueRange numberToGenerate = json.has("number_to_generate") ? (RandomValueRange)JsonUtils.func_188174_a((JsonObject)json, (String)"number_to_generate", (JsonDeserializationContext)deserializationContext, RandomValueRange.class) : new RandomValueRange(1.0f);
            return new FunctionCustomPotionEffects(conditionsIn, potions, replace, numberToGenerate);
        }
    }
}

